/*
 * Copyright 1995, 2018 Perforce Software.  All rights reserved.
 *
 * This file is part of Perforce - the FAST SCM System.
 */

/*
 * Perforce client legal compliance statements
 *
 */

# include <stdhdrs.h>

# include <strbuf.h>
# include <strdict.h>
# include <strtable.h>
# include <error.h>
# include <rpc.h>

# include <filesys.h>
# include <handler.h>

# include "client.h"
# include "clientuser.h"

# include <openssl/opensslv.h>

static ErrorId LegalHelp = { ErrorOf( 0, 0, E_INFO, 0, 0 ),
"\n"
"    The following are the license statements for code used in\n"
"    this program.\n"
"\n"
"    See 'p4 help legal' for additional information.\n"
"\n"
"    P4/P4API License\n"
"    -----------------------\n"
"    Copyright (c) 1995-" ID_Y ", Perforce Software, Inc.\n"
"    All rights reserved.\n"
"\n"
"    Redistribution and use in source and binary forms, with or without\n"
"    modification, are permitted provided that the following conditions are met:\n"
"\n"
"        Redistributions of source code must retain the above copyright notice,\n"
"        this list of conditions and the following disclaimer.\n"
"\n"
"        Redistributions in binary form must reproduce the above copyright\n"
"        notice, this list of conditions and the following disclaimer in the\n"
"        documentation and/or other materials provided with the distribution.\n"
"\n"
"    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\"\n"
"    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
"    IMPLIED  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE\n"
"    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE\n"
"    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
"    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
"    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS\n"
"    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN\n"
"    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
"    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE\n"
"    POSSIBILITY OF SUCH DAMAGE.\n"
"\n"
"\n"
"    OpenSSL:\n"
"    -----------------------\n"
# if OPENSSL_VERSION_NUMBER < 0x30000000L
"	This product includes cryptographic software written by Eric Young\n"
"	(eay@cryptsoft.com).\n"
"	This product includes software written by Tim Hudson\n"
"	(tjh@cryptsoft.com).\n"
"\n"
"    OpenSSL License\n"
"    -----------------------\n"
"\n"
"     * ====================================================================\n"
"     * Copyright (c) 1998-2011 The OpenSSL Project.  All rights reserved.\n"
"     *\n"
"     * Redistribution and use in source and binary forms, with or without\n"
"     * modification, are permitted provided that the following conditions\n"
"     * are met:\n"
"     *\n"
"     * 1. Redistributions of source code must retain the above copyright\n"
"     *    notice, this list of conditions and the following disclaimer.\n"
"     *\n"
"     * 2. Redistributions in binary form must reproduce the above copyright\n"
"     *    notice, this list of conditions and the following disclaimer in\n"
"     *    the documentation and/or other materials provided with the\n"
"     *    distribution.\n"
"     *\n"
"     * 3. All advertising materials mentioning features or use of this\n"
"     *    software must display the following acknowledgment:\n"
"     *    \"This product includes software developed by the OpenSSL Project\n"
"     *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)\n"
"     *\n"
"     * 4. The names \"OpenSSL Toolkit\" and \"OpenSSL Project\" must not be\n"
"     *    used to endorse or promote products derived from this software\n"
"     *    without prior written permission. For written permission, please\n"
"     *    contact openssl-core@openssl.org.\n"
"     *\n"
"     * 5. Products derived from this software may not be called \"OpenSSL\n"
"     *    nor may \"OpenSSL\" appear in their names without prior written\n"
"     *    permission of the OpenSSL Project.\n"
"     *\n"
"     * 6. Redistributions of any form whatsoever must retain the following\n"
"     *    acknowledgment:\n"
"     *    \"This product includes software developed by the OpenSSL Project\n"
"     *    for use in the OpenSSL Toolkit (http://www.openssl.org/)\n"
"     *\n"
"     * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY\n"
"     * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
"     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
"     * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR\n"
"     * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n"
"     * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\n"
"     * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;\n"
"     * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)\n"
"     * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,\n"
"     * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)\n"
"     * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED\n"
"     * OF THE POSSIBILITY OF SUCH DAMAGE.\n"
"     * ====================================================================\n"
"     *\n"
"     * This product includes cryptographic software written by Eric Young\n"
"     * (eay@cryptsoft.com).  This product includes software written by Tim\n"
"     * Hudson (tjh@cryptsoft.com).\n"
"     *\n"
"     *\n"
"\n"
"    Original SSLeay License\n"
"    -----------------------\n"
"\n"
"     * Copyright (C) 1995-1998 Eric Young (eay@cryptsoft.com)\n"
"     * All rights reserved.\n"
"     *\n"
"     * This package is an SSL implementation written\n"
"     * by Eric Young (eay@cryptsoft.com).\n"
"     * The implementation was written so as to conform with Netscapes SSL.\n"
"     *\n"
"     * This library is free for commercial and non-commercial use as long as\n"
"     * the following conditions are adhered to.  The following conditions\n"
"     * apply to all code found in this distribution, be it the RC4, RSA,\n"
"     * lhash, DES, etc., code; not just the SSL code.  The SSL documentation\n"
"     * included with this distribution is covered by the same copyright terms\n"
"     * except that the holder is Tim Hudson (tjh@cryptsoft.com).\n"
"     *\n"
"     * Copyright remains Eric Young's, and as such any Copyright notices in\n"
"     * the code are not to be removed.\n"
"     * If this package is used in a product, Eric Young should be given\n"
"     * attribution as the author of the parts of the library used.\n"
"     * This can be in the form of a textual message at program startup or\n"
"     * in documentation (online or textual) provided with the package.\n"
"     *\n"
"     * Redistribution and use in source and binary forms, with or without\n"
"     * modification, are permitted provided that the following conditions\n"
"     * are met:\n"
"     * 1. Redistributions of source code must retain the copyright\n"
"     *    notice, this list of conditions and the following disclaimer.\n"
"     * 2. Redistributions in binary form must reproduce the above copyright\n"
"     *    notice, this list of conditions and the following disclaimer in the\n"
"     *    documentation and/or other materials provided with the distribution.\n"
"     * 3. All advertising materials mentioning features or use of this\n"
"     *    software must display the following acknowledgement:\n"
"     *    \"This product includes cryptographic software written by\n"
"     *     Eric Young (eay@cryptsoft.com)\"\n"
"     *    The word 'cryptographic' can be left out if the routines from the\n"
"     *    library being used are not cryptographic related  :-) .\n"
"     * 4. If you include any Windows specific code (or a derivative thereof)\n"
"     *    from the apps directory (application code) you must include an\n"
"     *    acknowledgement: \"This product includes software written by Tim\n"
"     *    Hudson (tjh@cryptsoft.com)\"\n"
"     *\n"
"     * THIS SOFTWARE IS PROVIDED BY ERIC YOUNG ``AS IS'' AND\n"
"     * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n"
"     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n"
"     * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS\n"
"     * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\n"
"     * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF\n"
"     * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR\n"
"     * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,\n"
"     * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE\n"
"     * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN\n"
"     * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n"
"     *\n"
"     * The licence and distribution terms for any publicly available version\n"
"     * or derivative of this code cannot be changed.  i.e. this code cannot\n"
"     * simply be copied and put under another distribution licence\n"
"     * [including the GNU Public Licence.]\n"
"     *\n"
#else
"    Copyright (c) 1998-2022 The OpenSSL Project\n"
"    Copyright (c) 1995-1998 Eric A. Young, Tim J. Hudson\n"
"    All rights reserved.\n"
"\n"
"    OpenSSL License\n"
"    -----------------------\n"
"\n"
"                                 Apache License\n"
"                           Version 2.0, January 2004\n"
"                        https://www.apache.org/licenses/\n"
"\n"
"    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n"
"\n"
"    1. Definitions.\n"
"\n"
"       \"License\" shall mean the terms and conditions for use, reproduction,\n"
"       and distribution as defined by Sections 1 through 9 of this document.\n"
"\n"
"       \"Licensor\" shall mean the copyright owner or entity authorized by\n"
"       the copyright owner that is granting the License.\n"
"\n"
"       \"Legal Entity\" shall mean the union of the acting entity and all\n"
"       other entities that control, are controlled by, or are under common\n"
"       control with that entity. For the purposes of this definition,\n"
"       \"control\" means (i) the power, direct or indirect, to cause the\n"
"       direction or management of such entity, whether by contract or\n"
"       otherwise, or (ii) ownership of fifty percent (50%) or more of the\n"
"       outstanding shares, or (iii) beneficial ownership of such entity.\n"
"\n"
"       \"You\" (or \"Your\") shall mean an individual or Legal Entity\n"
"       exercising permissions granted by this License.\n"
"\n"
"       \"Source\" form shall mean the preferred form for making modifications,\n"
"       including but not limited to software source code, documentation\n"
"       source, and configuration files.\n"
"\n"
"       \"Object\" form shall mean any form resulting from mechanical\n"
"       transformation or translation of a Source form, including but\n"
"       not limited to compiled object code, generated documentation,\n"
"       and conversions to other media types.\n"
"\n"
"       \"Work\" shall mean the work of authorship, whether in Source or\n"
"       Object form, made available under the License, as indicated by a\n"
"       copyright notice that is included in or attached to the work\n"
"       (an example is provided in the Appendix below).\n"
"\n"
"       \"Derivative Works\" shall mean any work, whether in Source or Object\n"
"       form, that is based on (or derived from) the Work and for which the\n"
"       editorial revisions, annotations, elaborations, or other modifications\n"
"       represent, as a whole, an original work of authorship. For the purposes\n"
"       of this License, Derivative Works shall not include works that remain\n"
"       separable from, or merely link (or bind by name) to the interfaces of,\n"
"       the Work and Derivative Works thereof.\n"
"\n"
"       \"Contribution\" shall mean any work of authorship, including\n"
"       the original version of the Work and any modifications or additions\n"
"       to that Work or Derivative Works thereof, that is intentionally\n"
"       submitted to Licensor for inclusion in the Work by the copyright owner\n"
"       or by an individual or Legal Entity authorized to submit on behalf of\n"
"       the copyright owner. For the purposes of this definition, \"submitted\"\n"
"       means any form of electronic, verbal, or written communication sent\n"
"       to the Licensor or its representatives, including but not limited to\n"
"       communication on electronic mailing lists, source code control systems,\n"
"       and issue tracking systems that are managed by, or on behalf of, the\n"
"       Licensor for the purpose of discussing and improving the Work, but\n"
"       excluding communication that is conspicuously marked or otherwise\n"
"       designated in writing by the copyright owner as \"Not a Contribution.\"\n"
"\n"
"       \"Contributor\" shall mean Licensor and any individual or Legal Entity\n"
"       on behalf of whom a Contribution has been received by Licensor and\n"
"       subsequently incorporated within the Work.\n"
"\n"
"    2. Grant of Copyright License. Subject to the terms and conditions of\n"
"       this License, each Contributor hereby grants to You a perpetual,\n"
"       worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n"
"       copyright license to reproduce, prepare Derivative Works of,\n"
"       publicly display, publicly perform, sublicense, and distribute the\n"
"       Work and such Derivative Works in Source or Object form.\n"
"\n"
"    3. Grant of Patent License. Subject to the terms and conditions of\n"
"       this License, each Contributor hereby grants to You a perpetual,\n"
"       worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n"
"       (except as stated in this section) patent license to make, have made,\n"
"       use, offer to sell, sell, import, and otherwise transfer the Work,\n"
"       where such license applies only to those patent claims licensable\n"
"       by such Contributor that are necessarily infringed by their\n"
"       Contribution(s) alone or by combination of their Contribution(s)\n"
"       with the Work to which such Contribution(s) was submitted. If You\n"
"       institute patent litigation against any entity (including a\n"
"       cross-claim or counterclaim in a lawsuit) alleging that the Work\n"
"       or a Contribution incorporated within the Work constitutes direct\n"
"       or contributory patent infringement, then any patent licenses\n"
"       granted to You under this License for that Work shall terminate\n"
"       as of the date such litigation is filed.\n"
"\n"
"    4. Redistribution. You may reproduce and distribute copies of the\n"
"       Work or Derivative Works thereof in any medium, with or without\n"
"       modifications, and in Source or Object form, provided that You\n"
"       meet the following conditions:\n"
"\n"
"       (a) You must give any other recipients of the Work or\n"
"           Derivative Works a copy of this License; and\n"
"\n"
"       (b) You must cause any modified files to carry prominent notices\n"
"           stating that You changed the files; and\n"
"\n"
"       (c) You must retain, in the Source form of any Derivative Works\n"
"           that You distribute, all copyright, patent, trademark, and\n"
"           attribution notices from the Source form of the Work,\n"
"           excluding those notices that do not pertain to any part of\n"
"           the Derivative Works; and\n"
"\n"
"       (d) If the Work includes a \"NOTICE\" text file as part of its\n"
"           distribution, then any Derivative Works that You distribute must\n"
"           include a readable copy of the attribution notices contained\n"
"           within such NOTICE file, excluding those notices that do not\n"
"           pertain to any part of the Derivative Works, in at least one\n"
"           of the following places: within a NOTICE text file distributed\n"
"           as part of the Derivative Works; within the Source form or\n"
"           documentation, if provided along with the Derivative Works; or,\n"
"           within a display generated by the Derivative Works, if and\n"
"           wherever such third-party notices normally appear. The contents\n"
"           of the NOTICE file are for informational purposes only and\n"
"           do not modify the License. You may add Your own attribution\n"
"           notices within Derivative Works that You distribute, alongside\n"
"           or as an addendum to the NOTICE text from the Work, provided\n"
"           that such additional attribution notices cannot be construed\n"
"           as modifying the License.\n"
"\n"
"       You may add Your own copyright statement to Your modifications and\n"
"       may provide additional or different license terms and conditions\n"
"       for use, reproduction, or distribution of Your modifications, or\n"
"       for any such Derivative Works as a whole, provided Your use,\n"
"       reproduction, and distribution of the Work otherwise complies with\n"
"       the conditions stated in this License.\n"
"\n"
"    5. Submission of Contributions. Unless You explicitly state otherwise,\n"
"       any Contribution intentionally submitted for inclusion in the Work\n"
"       by You to the Licensor shall be under the terms and conditions of\n"
"       this License, without any additional terms or conditions.\n"
"       Notwithstanding the above, nothing herein shall supersede or modify\n"
"       the terms of any separate license agreement you may have executed\n"
"       with Licensor regarding such Contributions.\n"
"\n"
"    6. Trademarks. This License does not grant permission to use the trade\n"
"       names, trademarks, service marks, or product names of the Licensor,\n"
"       except as required for reasonable and customary use in describing the\n"
"       origin of the Work and reproducing the content of the NOTICE file.\n"
"\n"
"    7. Disclaimer of Warranty. Unless required by applicable law or\n"
"       agreed to in writing, Licensor provides the Work (and each\n"
"       Contributor provides its Contributions) on an \"AS IS\" BASIS,\n"
"       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n"
"       implied, including, without limitation, any warranties or conditions\n"
"       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n"
"       PARTICULAR PURPOSE. You are solely responsible for determining the\n"
"       appropriateness of using or redistributing the Work and assume any\n"
"       risks associated with Your exercise of permissions under this License.\n"
"\n"
"    8. Limitation of Liability. In no event and under no legal theory,\n"
"       whether in tort (including negligence), contract, or otherwise,\n"
"       unless required by applicable law (such as deliberate and grossly\n"
"       negligent acts) or agreed to in writing, shall any Contributor be\n"
"       liable to You for damages, including any direct, indirect, special,\n"
"       incidental, or consequential damages of any character arising as a\n"
"       result of this License or out of the use or inability to use the\n"
"       Work (including but not limited to damages for loss of goodwill,\n"
"       work stoppage, computer failure or malfunction, or any and all\n"
"       other commercial damages or losses), even if such Contributor\n"
"       has been advised of the possibility of such damages.\n"
"\n"
"    9. Accepting Warranty or Additional Liability. While redistributing\n"
"       the Work or Derivative Works thereof, You may choose to offer,\n"
"       and charge a fee for, acceptance of support, warranty, indemnity,\n"
"       or other liability obligations and/or rights consistent with this\n"
"       License. However, in accepting such obligations, You may act only\n"
"       on Your own behalf and on Your sole responsibility, not on behalf\n"
"       of any other Contributor, and only if You agree to indemnify,\n"
"       defend, and hold each Contributor harmless for any liability\n"
"       incurred by, or claims asserted against, such Contributor by reason\n"
"       of your accepting any such warranty or additional liability.\n"
"\n"
"    END OF TERMS AND CONDITIONS\n"
# endif
"\n"
"\n"
"    sol2 License\n"
"    -----------------------\n"
"\n"
"    Copyright (c) 2013-2018 Rapptz, ThePhD, and contributors\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining\n"
"    a copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to\n"
"    permit persons to whom the Software is furnished to do so, subject to\n"
"    the following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be\n"
"    included in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
"    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n"
"    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n"
"    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n"
"    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n"
"    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    Lua License\n"
"    -----------------------\n"
"\n"
"    Copyright (c) 1994-2018 Lua.org, PUC-Rio.\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining\n"
"    a copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to\n"
"    permit persons to whom the Software is furnished to do so, subject to\n"
"    the following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be\n"
"    included in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
"    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND\n"
"    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE\n"
"    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION\n"
"    OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION\n"
"    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    cURL License\n"
"    -----------------------\n"
"\n"
"    This code uses a permissive license. Please use the following\n"
"    attribution in the documentation of the open source code.\n"
"\n"
"    Copyright (c) 1996 - 2018, Daniel Stenberg, daniel@haxx.se, and many\n"
"    contributors, see the THANKS file.\n"
"\n"
"    All rights reserved.\n"
"\n"
"    Permission to use, copy, modify, and distribute this software for any\n"
"    purpose with or without fee is hereby granted, provided that the above\n"
"    copyright notice and this permission notice appear in all copies.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n"
"    OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF\n"
"    THIRD PARTY RIGHTS. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS\n"
"    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN\n"
"    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN\n"
"    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE\n"
"    SOFTWARE.\n"
"\n"
"    Except as contained in this notice, the name of a copyright holder shall\n"
"    not be used in advertising or otherwise to promote the sale, use or\n"
"    other dealings in this Software without prior written authorization of\n"
"    the copyright holder.\n"
"\n"
"\n"
"    Lua-cURLv3 License\n"
"    -----------------------\n"
"\n"
"    Copyright (c) 2014-2018 Alexey Melnichuk\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining a\n"
"    copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to permit\n"
"    persons to whom the Software is furnished to do so, subject to the\n"
"    following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be included\n"
"    in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n"
"    OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n"
"    NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n"
"    DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n"
"    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n"
"    USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    LuaSQLite3 License\n"
"    -----------------------\n"
"\n"
"    Copyright (C) 2002-2016 Tiago Dionizio, Doug Currie\n"
"    All rights reserved.\n"
"    Author : Tiago Dionizio <tiago.dionizio@ist.utl.pt>\n"
"    Author : Doug Currie <doug.currie@alum.mit.edu>\n"
"    Library : lsqlite3 - an SQLite 3 database binding for Lua 5\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining\n"
"    a copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to\n"
"    permit persons to whom the Software is furnished to do so, subject to\n"
"    the following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be\n"
"    included in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
"    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
"    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY\n"
"    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\n"
"    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE\n"
"    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    lua-cjson License\n"
"    -----------------------\n"
"\n"
"    Copyright (c) 2010-2012 Mark Pulford <mark@kyne.com.au>\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining\n"
"    a copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to\n"
"    permit persons to whom the Software is furnished to do so, subject to\n"
"    the following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be\n"
"    included in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
"    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
"    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY\n"
"    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\n"
"    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE\n"
"    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    libc++ and libc++abi License\n"
"    -----------------------\n"
"\n"
"    These libraries are dual-licensed:\n"
"\n"
"    The University of Illinois/NCSA Open Source License (NCSA)\n"
"    Developed under the LLVM Project\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining a\n"
"    copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal with the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to\n"
"    permit persons to whom the Software is furnished to do so, subject to the\n"
"    following conditions:\n"
"\n"
"    Redistributions of source code must retain the above copyright notice,\n"
"    this list of conditions and the following disclaimers.\n"
"    Redistributions in binary form must reproduce the above copyright\n"
"    notice, this list of conditions and the following disclaimers in the\n"
"    documentation and/or other materials provided with the distribution.\n"
"    Neither the names of <Name of Development Group, Name of Institution>,\n"
"    nor the names of its contributors may be used to endorse or promote\n"
"    products derived from this Software without specific prior written\n"
"    permission.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n"
"    OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
"    IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR\n"
"    ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,\n"
"    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE\n"
"     SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.\n"
"\n"
"    MIT\n"
"    Developed under the LLVM Project\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining a\n"
"    copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to permit\n"
"    persons to whom the Software is furnished to do so, subject to the\n"
"    following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be included\n"
"    in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n"
"    OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n"
"    NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n"
"    DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n"
"    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n"
"    USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    jemalloc\n"
"    -----------------------\n"
"\n"
"    Copyright (C) 2002-present Jason Evans <jasone@canonware.com>.\n"
"    All rights reserved.\n"
"    Copyright (C) 2007-2012 Mozilla Foundation.  All rights reserved.\n"
"    Copyright (C) 2009-present Facebook, Inc.  All rights reserved.\n"
"\n"
"    Redistribution and use in source and binary forms, with or without\n"
"    modification, are permitted provided that the following conditions are met:\n"
"    1. Redistributions of source code must retain the above copyright\n"
"       notice(s), this list of conditions and the following disclaimer.\n"
"    2. Redistributions in binary form must reproduce the above copyright\n"
"       notice(s), this list of conditions and the following disclaimer in the\n"
"       documentation and/or other materials provided with the distribution.\n"
"\n"
"    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY\n"
"    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED\n"
"    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE\n"
"    DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY\n"
"    DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES\n"
"    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\n"
"    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER\n"
"    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT\n"
"    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY\n"
"    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n"
"    SUCH DAMAGE.\n"
"\n"
"\n"
"    JSON for Modern C++\n"
"    -----------------------\n"
"\n"
"    Copyright (c) 2013-2018 Niels Lohmann\n"
"\n"
"    Permission is hereby granted, free of charge, to any person obtaining\n"
"    a copy of this software and associated documentation files (the\n"
"    \"Software\"), to deal in the Software without restriction, including\n"
"    without limitation the rights to use, copy, modify, merge, publish,\n"
"    distribute, sublicense, and/or sell copies of the Software, and to permit\n"
"    persons to whom the Software is furnished to do so, subject to the\n"
"    following conditions:\n"
"\n"
"    The above copyright notice and this permission notice shall be included\n"
"    in all copies or substantial portions of the Software.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND,\n"
"    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n"
"    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.\n"
"    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY\n"
"    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT\n"
"    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR\n"
"    THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    optional-lite and any-lite\n"
"    Martin Moene\n"
"    -----------------------\n"
"\n"
"    Boost Software License - Version 1.0 - August 17th, 2003\n"
"\n"
"    Permission is hereby granted, free of charge, to any person or organization\n"
"    obtaining a copy of the software and accompanying documentation covered by\n"
"    this license (the \"Software\") to use, reproduce, display, distribute,\n"
"    execute, and transmit the Software, and to prepare derivative works of the\n"
"    Software, and to permit third-parties to whom the Software is furnished to\n"
"    do so, all subject to the following:\n"
"\n"
"    The copyright notices in the Software and this entire statement, including\n"
"    the above license grant, this restriction and the following disclaimer,\n"
"    must be included in all copies of the Software, in whole or in part, and\n"
"    all derivative works of the Software, unless such copies or derivative\n"
"    works are solely in the form of machine-executable object code generated by\n"
"    a source language processor.\n"
"\n"
"    THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"
"    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"
"    FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT\n"
"    SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE\n"
"    FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,\n"
"    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\n"
"    DEALINGS IN THE SOFTWARE.\n"
"\n"
"\n"
"    TinyXML-2\n"
"    -----------------------\n"
"\n"
"    Copyright (c) 2019-present, Lee Thomason and contributors.\n"
"\n"
"    This software is provided 'as-is', without any express or implied\n"
"    warranty. In no event will the authors be held liable for any\n"
"    damages arising from the use of this software.\n"
"\n"
"    Permission is granted to anyone to use this software for any\n"
"    purpose, including commercial applications, and to alter it and\n"
"    redistribute it freely, subject to the following restrictions:\n"
"\n"
"    1. The origin of this software must not be misrepresented; you must\n"
"    not claim that you wrote the original software. If you use this\n"
"    software in a product, an acknowledgment in the product documentation\n"
"    would be appreciated but is not required.\n"
"\n"
"    2. Altered source versions must be plainly marked as such, and\n"
"    must not be misrepresented as being the original software.\n"
"\n"
"    3. This notice may not be removed or altered from any source\n"
"    distribution.\n"
"\n"
"\n"
"    BLAKE3\n"
"    --------------------\n"
"\n"
"    Copyright 2019 Jack O'Connor and Samuel Neves\n"
"\n"
"    Licensed under the Apache License, Version 2.0 (the \"License\");\n"
"    you may not use this file except in compliance with the License.\n"
"    You may obtain a copy of the License at\n"
"\n"
"       http://www.apache.org/licenses/LICENSE-2.0\n"
"\n"
"    Unless required by applicable law or agreed to in writing, software\n"
"    distributed under the License is distributed on an \"AS IS\" BASIS,\n"
"    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n"
"    See the License for the specific language governing permissions and\n"
"    limitations under the License.\n"
"\n"
"\n"
"                                 Apache License\n"
"                           Version 2.0, January 2004\n"
"                        https://www.apache.org/licenses/\n"
"\n"
"    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n"
"\n"
"    1. Definitions.\n"
"\n"
"       \"License\" shall mean the terms and conditions for use, reproduction,\n"
"       and distribution as defined by Sections 1 through 9 of this document.\n"
"\n"
"       \"Licensor\" shall mean the copyright owner or entity authorized by\n"
"       the copyright owner that is granting the License.\n"
"\n"
"       \"Legal Entity\" shall mean the union of the acting entity and all\n"
"       other entities that control, are controlled by, or are under common\n"
"       control with that entity. For the purposes of this definition,\n"
"       \"control\" means (i) the power, direct or indirect, to cause the\n"
"       direction or management of such entity, whether by contract or\n"
"       otherwise, or (ii) ownership of fifty percent (50%) or more of the\n"
"       outstanding shares, or (iii) beneficial ownership of such entity.\n"
"\n"
"       \"You\" (or \"Your\") shall mean an individual or Legal Entity\n"
"       exercising permissions granted by this License.\n"
"\n"
"       \"Source\" form shall mean the preferred form for making modifications,\n"
"       including but not limited to software source code, documentation\n"
"       source, and configuration files.\n"
"\n"
"       \"Object\" form shall mean any form resulting from mechanical\n"
"       transformation or translation of a Source form, including but\n"
"       not limited to compiled object code, generated documentation,\n"
"       and conversions to other media types.\n"
"\n"
"       \"Work\" shall mean the work of authorship, whether in Source or\n"
"       Object form, made available under the License, as indicated by a\n"
"       copyright notice that is included in or attached to the work\n"
"       (an example is provided in the Appendix below).\n"
"\n"
"       \"Derivative Works\" shall mean any work, whether in Source or Object\n"
"       form, that is based on (or derived from) the Work and for which the\n"
"       editorial revisions, annotations, elaborations, or other modifications\n"
"       represent, as a whole, an original work of authorship. For the purposes\n"
"       of this License, Derivative Works shall not include works that remain\n"
"       separable from, or merely link (or bind by name) to the interfaces of,\n"
"       the Work and Derivative Works thereof.\n"
"\n"
"       \"Contribution\" shall mean any work of authorship, including\n"
"       the original version of the Work and any modifications or additions\n"
"       to that Work or Derivative Works thereof, that is intentionally\n"
"       submitted to Licensor for inclusion in the Work by the copyright owner\n"
"       or by an individual or Legal Entity authorized to submit on behalf of\n"
"       the copyright owner. For the purposes of this definition, \"submitted\"\n"
"       means any form of electronic, verbal, or written communication sent\n"
"       to the Licensor or its representatives, including but not limited to\n"
"       communication on electronic mailing lists, source code control systems,\n"
"       and issue tracking systems that are managed by, or on behalf of, the\n"
"       Licensor for the purpose of discussing and improving the Work, but\n"
"       excluding communication that is conspicuously marked or otherwise\n"
"       designated in writing by the copyright owner as \"Not a Contribution.\"\n"
"\n"
"       \"Contributor\" shall mean Licensor and any individual or Legal Entity\n"
"       on behalf of whom a Contribution has been received by Licensor and\n"
"       subsequently incorporated within the Work.\n"
"\n"
"    2. Grant of Copyright License. Subject to the terms and conditions of\n"
"       this License, each Contributor hereby grants to You a perpetual,\n"
"       worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n"
"       copyright license to reproduce, prepare Derivative Works of,\n"
"       publicly display, publicly perform, sublicense, and distribute the\n"
"       Work and such Derivative Works in Source or Object form.\n"
"\n"
"    3. Grant of Patent License. Subject to the terms and conditions of\n"
"       this License, each Contributor hereby grants to You a perpetual,\n"
"       worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n"
"       (except as stated in this section) patent license to make, have made,\n"
"       use, offer to sell, sell, import, and otherwise transfer the Work,\n"
"       where such license applies only to those patent claims licensable\n"
"       by such Contributor that are necessarily infringed by their\n"
"       Contribution(s) alone or by combination of their Contribution(s)\n"
"       with the Work to which such Contribution(s) was submitted. If You\n"
"       institute patent litigation against any entity (including a\n"
"       cross-claim or counterclaim in a lawsuit) alleging that the Work\n"
"       or a Contribution incorporated within the Work constitutes direct\n"
"       or contributory patent infringement, then any patent licenses\n"
"       granted to You under this License for that Work shall terminate\n"
"       as of the date such litigation is filed.\n"
"\n"
"    4. Redistribution. You may reproduce and distribute copies of the\n"
"       Work or Derivative Works thereof in any medium, with or without\n"
"       modifications, and in Source or Object form, provided that You\n"
"       meet the following conditions:\n"
"\n"
"       (a) You must give any other recipients of the Work or\n"
"           Derivative Works a copy of this License; and\n"
"\n"
"       (b) You must cause any modified files to carry prominent notices\n"
"           stating that You changed the files; and\n"
"\n"
"       (c) You must retain, in the Source form of any Derivative Works\n"
"           that You distribute, all copyright, patent, trademark, and\n"
"           attribution notices from the Source form of the Work,\n"
"           excluding those notices that do not pertain to any part of\n"
"           the Derivative Works; and\n"
"\n"
"       (d) If the Work includes a \"NOTICE\" text file as part of its\n"
"           distribution, then any Derivative Works that You distribute must\n"
"           include a readable copy of the attribution notices contained\n"
"           within such NOTICE file, excluding those notices that do not\n"
"           pertain to any part of the Derivative Works, in at least one\n"
"           of the following places: within a NOTICE text file distributed\n"
"           as part of the Derivative Works; within the Source form or\n"
"           documentation, if provided along with the Derivative Works; or,\n"
"           within a display generated by the Derivative Works, if and\n"
"           wherever such third-party notices normally appear. The contents\n"
"           of the NOTICE file are for informational purposes only and\n"
"           do not modify the License. You may add Your own attribution\n"
"           notices within Derivative Works that You distribute, alongside\n"
"           or as an addendum to the NOTICE text from the Work, provided\n"
"           that such additional attribution notices cannot be construed\n"
"           as modifying the License.\n"
"\n"
"       You may add Your own copyright statement to Your modifications and\n"
"       may provide additional or different license terms and conditions\n"
"       for use, reproduction, or distribution of Your modifications, or\n"
"       for any such Derivative Works as a whole, provided Your use,\n"
"       reproduction, and distribution of the Work otherwise complies with\n"
"       the conditions stated in this License.\n"
"\n"
"    5. Submission of Contributions. Unless You explicitly state otherwise,\n"
"       any Contribution intentionally submitted for inclusion in the Work\n"
"       by You to the Licensor shall be under the terms and conditions of\n"
"       this License, without any additional terms or conditions.\n"
"       Notwithstanding the above, nothing herein shall supersede or modify\n"
"       the terms of any separate license agreement you may have executed\n"
"       with Licensor regarding such Contributions.\n"
"\n"
"    6. Trademarks. This License does not grant permission to use the trade\n"
"       names, trademarks, service marks, or product names of the Licensor,\n"
"       except as required for reasonable and customary use in describing the\n"
"       origin of the Work and reproducing the content of the NOTICE file.\n"
"\n"
"    7. Disclaimer of Warranty. Unless required by applicable law or\n"
"       agreed to in writing, Licensor provides the Work (and each\n"
"       Contributor provides its Contributions) on an \"AS IS\" BASIS,\n"
"       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n"
"       implied, including, without limitation, any warranties or conditions\n"
"       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n"
"       PARTICULAR PURPOSE. You are solely responsible for determining the\n"
"       appropriateness of using or redistributing the Work and assume any\n"
"       risks associated with Your exercise of permissions under this License.\n"
"\n"
"    8. Limitation of Liability. In no event and under no legal theory,\n"
"       whether in tort (including negligence), contract, or otherwise,\n"
"       unless required by applicable law (such as deliberate and grossly\n"
"       negligent acts) or agreed to in writing, shall any Contributor be\n"
"       liable to You for damages, including any direct, indirect, special,\n"
"       incidental, or consequential damages of any character arising as a\n"
"       result of this License or out of the use or inability to use the\n"
"       Work (including but not limited to damages for loss of goodwill,\n"
"       work stoppage, computer failure or malfunction, or any and all\n"
"       other commercial damages or losses), even if such Contributor\n"
"       has been advised of the possibility of such damages.\n"
"\n"
"    9. Accepting Warranty or Additional Liability. While redistributing\n"
"       the Work or Derivative Works thereof, You may choose to offer,\n"
"       and charge a fee for, acceptance of support, warranty, indemnity,\n"
"       or other liability obligations and/or rights consistent with this\n"
"       License. However, in accepting such obligations, You may act only\n"
"       on Your own behalf and on Your sole responsibility, not on behalf\n"
"       of any other Contributor, and only if You agree to indemnify,\n"
"       defend, and hold each Contributor harmless for any liability\n"
"       incurred by, or claims asserted against, such Contributor by reason\n"
"       of your accepting any such warranty or additional liability.\n"
"\n"
"\n"
"    CDC File Transfer\n"
"    -----------------------\n"
"\n"
"    Copyright 2022 Lutz Justen\n"
"\n"
"    Licensed under the Apache License, Version 2.0 (the \"License\");\n"
"    you may not use this file except in compliance with the License.\n"
"    You may obtain a copy of the License at\n"
"\n"
"    http://www.apache.org/licenses/LICENSE-2.0\n"
"\n"
"    Unless required by applicable law or agreed to in writing, software\n"
"    distributed under the License is distributed on an \"AS IS\" BASIS,\n"
"    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n"
"    See the License for the specific language governing permissions and\n"
"    limitations under the License.\n"
"\n"
};

int
clientLegalHelp( Error *e )
{
	ClientUser cuser;
	e->Set( LegalHelp );
	cuser.Message( e );
	e->Clear();
	return 0;
}
