/*
 * Copyright 2001 Perforce Software.  All rights reserved.
 *
 */

/*
 * jptables.cc - Tables for Unicode to Japaneese character set conversions
 *
 * This is seporate from basecvt.cc so that unless you are really
 * possibly going to do character set conversions you will not link
 * in these large tables.
 *
 * charcvt.cc holds the code to use these tables.
 *
 * These tables data came from The Unicode Consortium and have a couple
 * changes which are dictated from how customers really use these character
 * sets which are due to legacy issues from MicroSoft and IBM which confused
 * backslash and the yen sign.
 */

#include <stdhdrs.h>

#include "i18napi.h"
#include "charcvt.h"

CharSetCvt::MapEnt
CharSetCvtUTF8toShiftJis::UCS2toShiftJis[] = {
{0x0020, 0x20},
{0x0021, 0x21},
{0x0022, 0x22},
{0x0023, 0x23},
{0x0024, 0x24},
{0x0025, 0x25},
{0x0026, 0x26},
{0x0027, 0x27},
{0x0028, 0x28},
{0x0029, 0x29},
{0x002A, 0x2A},
{0x002B, 0x2B},
{0x002C, 0x2C},
{0x002D, 0x2D},
{0x002E, 0x2E},
{0x002F, 0x2F},
{0x0030, 0x30},
{0x0031, 0x31},
{0x0032, 0x32},
{0x0033, 0x33},
{0x0034, 0x34},
{0x0035, 0x35},
{0x0036, 0x36},
{0x0037, 0x37},
{0x0038, 0x38},
{0x0039, 0x39},
{0x003A, 0x3A},
{0x003B, 0x3B},
{0x003C, 0x3C},
{0x003D, 0x3D},
{0x003E, 0x3E},
{0x003F, 0x3F},
{0x0040, 0x40},
{0x0041, 0x41},
{0x0042, 0x42},
{0x0043, 0x43},
{0x0044, 0x44},
{0x0045, 0x45},
{0x0046, 0x46},
{0x0047, 0x47},
{0x0048, 0x48},
{0x0049, 0x49},
{0x004A, 0x4A},
{0x004B, 0x4B},
{0x004C, 0x4C},
{0x004D, 0x4D},
{0x004E, 0x4E},
{0x004F, 0x4F},
{0x0050, 0x50},
{0x0051, 0x51},
{0x0052, 0x52},
{0x0053, 0x53},
{0x0054, 0x54},
{0x0055, 0x55},
{0x0056, 0x56},
{0x0057, 0x57},
{0x0058, 0x58},
{0x0059, 0x59},
{0x005A, 0x5A},
{0x005B, 0x5B},
#ifdef UNICODEMAPPING
{0x005C, 0x815F},
#else
{0x005c, 0x5c},
#endif
{0x005D, 0x5D},
{0x005E, 0x5E},
{0x005F, 0x5F},
{0x0060, 0x60},
{0x0061, 0x61},
{0x0062, 0x62},
{0x0063, 0x63},
{0x0064, 0x64},
{0x0065, 0x65},
{0x0066, 0x66},
{0x0067, 0x67},
{0x0068, 0x68},
{0x0069, 0x69},
{0x006A, 0x6A},
{0x006B, 0x6B},
{0x006C, 0x6C},
{0x006D, 0x6D},
{0x006E, 0x6E},
{0x006F, 0x6F},
{0x0070, 0x70},
{0x0071, 0x71},
{0x0072, 0x72},
{0x0073, 0x73},
{0x0074, 0x74},
{0x0075, 0x75},
{0x0076, 0x76},
{0x0077, 0x77},
{0x0078, 0x78},
{0x0079, 0x79},
{0x007A, 0x7A},
{0x007B, 0x7B},
{0x007C, 0x7C},
{0x007D, 0x7D},
#ifndef UNICODEMAPPING
{0x007e, 0x7e},
{0x007f, 0x7f},
#endif
{0x00A2, 0x8191},
{0x00A3, 0x8192},
{0x00A5, 0x5C},	// this may be a problem
{0x00A7, 0x8198},
{0x00A8, 0x814E},
{0x00AC, 0x81CA},
{0x00B0, 0x818B},
{0x00B1, 0x817D},
{0x00B4, 0x814C},
{0x00B6, 0x81F7},
{0x00D7, 0x817E},
{0x00F7, 0x8180},
{0x0391, 0x839F},
{0x0392, 0x83A0},
{0x0393, 0x83A1},
{0x0394, 0x83A2},
{0x0395, 0x83A3},
{0x0396, 0x83A4},
{0x0397, 0x83A5},
{0x0398, 0x83A6},
{0x0399, 0x83A7},
{0x039A, 0x83A8},
{0x039B, 0x83A9},
{0x039C, 0x83AA},
{0x039D, 0x83AB},
{0x039E, 0x83AC},
{0x039F, 0x83AD},
{0x03A0, 0x83AE},
{0x03A1, 0x83AF},
{0x03A3, 0x83B0},
{0x03A4, 0x83B1},
{0x03A5, 0x83B2},
{0x03A6, 0x83B3},
{0x03A7, 0x83B4},
{0x03A8, 0x83B5},
{0x03A9, 0x83B6},
{0x03B1, 0x83BF},
{0x03B2, 0x83C0},
{0x03B3, 0x83C1},
{0x03B4, 0x83C2},
{0x03B5, 0x83C3},
{0x03B6, 0x83C4},
{0x03B7, 0x83C5},
{0x03B8, 0x83C6},
{0x03B9, 0x83C7},
{0x03BA, 0x83C8},
{0x03BB, 0x83C9},
{0x03BC, 0x83CA},
{0x03BD, 0x83CB},
{0x03BE, 0x83CC},
{0x03BF, 0x83CD},
{0x03C0, 0x83CE},
{0x03C1, 0x83CF},
{0x03C3, 0x83D0},
{0x03C4, 0x83D1},
{0x03C5, 0x83D2},
{0x03C6, 0x83D3},
{0x03C7, 0x83D4},
{0x03C8, 0x83D5},
{0x03C9, 0x83D6},
{0x0401, 0x8446},
{0x0410, 0x8440},
{0x0411, 0x8441},
{0x0412, 0x8442},
{0x0413, 0x8443},
{0x0414, 0x8444},
{0x0415, 0x8445},
{0x0416, 0x8447},
{0x0417, 0x8448},
{0x0418, 0x8449},
{0x0419, 0x844A},
{0x041A, 0x844B},
{0x041B, 0x844C},
{0x041C, 0x844D},
{0x041D, 0x844E},
{0x041E, 0x844F},
{0x041F, 0x8450},
{0x0420, 0x8451},
{0x0421, 0x8452},
{0x0422, 0x8453},
{0x0423, 0x8454},
{0x0424, 0x8455},
{0x0425, 0x8456},
{0x0426, 0x8457},
{0x0427, 0x8458},
{0x0428, 0x8459},
{0x0429, 0x845A},
{0x042A, 0x845B},
{0x042B, 0x845C},
{0x042C, 0x845D},
{0x042D, 0x845E},
{0x042E, 0x845F},
{0x042F, 0x8460},
{0x0430, 0x8470},
{0x0431, 0x8471},
{0x0432, 0x8472},
{0x0433, 0x8473},
{0x0434, 0x8474},
{0x0435, 0x8475},
{0x0436, 0x8477},
{0x0437, 0x8478},
{0x0438, 0x8479},
{0x0439, 0x847A},
{0x043A, 0x847B},
{0x043B, 0x847C},
{0x043C, 0x847D},
{0x043D, 0x847E},
{0x043E, 0x8480},
{0x043F, 0x8481},
{0x0440, 0x8482},
{0x0441, 0x8483},
{0x0442, 0x8484},
{0x0443, 0x8485},
{0x0444, 0x8486},
{0x0445, 0x8487},
{0x0446, 0x8488},
{0x0447, 0x8489},
{0x0448, 0x848A},
{0x0449, 0x848B},
{0x044A, 0x848C},
{0x044B, 0x848D},
{0x044C, 0x848E},
{0x044D, 0x848F},
{0x044E, 0x8490},
{0x044F, 0x8491},
{0x0451, 0x8476},
{0x2010, 0x815D},
{0x2015, 0x815C},
{0x2016, 0x8161},
{0x2018, 0x8165},
{0x2019, 0x8166},
{0x201C, 0x8167},
{0x201D, 0x8168},
{0x2020, 0x81F5},
{0x2021, 0x81F6},
{0x2025, 0x8164},
{0x2026, 0x8163},
{0x2030, 0x81F1},
{0x2032, 0x818C},
{0x2033, 0x818D},
{0x203B, 0x81A6},
{0x203E, 0x7E}, // This may be a problem
{0x2103, 0x818E},
{0x2116, 0x8782},
{0x2121, 0x8784},
{0x212B, 0x81F0},
{0x2160, 0x8754},
{0x2161, 0x8755},
{0x2162, 0x8756},
{0x2163, 0x8757},
{0x2164, 0x8758},
{0x2165, 0x8759},
{0x2166, 0x875A},
{0x2167, 0x875B},
{0x2168, 0x875C},
{0x2169, 0x875D},
{0x2170, 0xFA40},
{0x2171, 0xFA41},
{0x2172, 0xFA42},
{0x2173, 0xFA43},
{0x2174, 0xFA44},
{0x2175, 0xFA45},
{0x2176, 0xFA46},
{0x2177, 0xFA47},
{0x2178, 0xFA48},
{0x2179, 0xFA49},
{0x2190, 0x81A9},
{0x2191, 0x81AA},
{0x2192, 0x81A8},
{0x2193, 0x81AB},
{0x21D2, 0x81CB},
{0x21D4, 0x81CC},
{0x2200, 0x81CD},
{0x2202, 0x81DD},
{0x2203, 0x81CE},
{0x2207, 0x81DE},
{0x2208, 0x81B8},
{0x220B, 0x81B9},
{0x2211, 0x8794},
{0x2212, 0x817C},
{0x221A, 0x81E3},
{0x221D, 0x81E5},
{0x221E, 0x8187},
{0x221F, 0x8798},
{0x2220, 0x81DA},
{0x2225, 0x8161},
{0x2227, 0x81C8},
{0x2228, 0x81C9},
{0x2229, 0x81BF},
{0x222A, 0x81BE},
{0x222B, 0x81E7},
{0x222C, 0x81E8},
{0x222E, 0x8793},
{0x2234, 0x8188},
{0x2235, 0x81E6},
{0x223D, 0x81E4},
{0x2252, 0x81E0},
{0x2260, 0x8182},
{0x2261, 0x81DF},
{0x2266, 0x8185},
{0x2267, 0x8186},
{0x226A, 0x81E1},
{0x226B, 0x81E2},
{0x2282, 0x81BC},
{0x2283, 0x81BD},
{0x2286, 0x81BA},
{0x2287, 0x81BB},
{0x22A5, 0x81DB},
{0x22BF, 0x8799},
{0x2312, 0x81DC},
{0x2460, 0x8740},
{0x2461, 0x8741},
{0x2462, 0x8742},
{0x2463, 0x8743},
{0x2464, 0x8744},
{0x2465, 0x8745},
{0x2466, 0x8746},
{0x2467, 0x8747},
{0x2468, 0x8748},
{0x2469, 0x8749},
{0x246A, 0x874A},
{0x246B, 0x874B},
{0x246C, 0x874C},
{0x246D, 0x874D},
{0x246E, 0x874E},
{0x246F, 0x874F},
{0x2470, 0x8750},
{0x2471, 0x8751},
{0x2472, 0x8752},
{0x2473, 0x8753},
{0x2500, 0x849F},
{0x2501, 0x84AA},
{0x2502, 0x84A0},
{0x2503, 0x84AB},
{0x250C, 0x84A1},
{0x250F, 0x84AC},
{0x2510, 0x84A2},
{0x2513, 0x84AD},
{0x2514, 0x84A4},
{0x2517, 0x84AF},
{0x2518, 0x84A3},
{0x251B, 0x84AE},
{0x251C, 0x84A5},
{0x251D, 0x84BA},
{0x2520, 0x84B5},
{0x2523, 0x84B0},
{0x2524, 0x84A7},
{0x2525, 0x84BC},
{0x2528, 0x84B7},
{0x252B, 0x84B2},
{0x252C, 0x84A6},
{0x252F, 0x84B6},
{0x2530, 0x84BB},
{0x2533, 0x84B1},
{0x2534, 0x84A8},
{0x2537, 0x84B8},
{0x2538, 0x84BD},
{0x253B, 0x84B3},
{0x253C, 0x84A9},
{0x253F, 0x84B9},
{0x2542, 0x84BE},
{0x254B, 0x84B4},
{0x25A0, 0x81A1},
{0x25A1, 0x81A0},
{0x25B2, 0x81A3},
{0x25B3, 0x81A2},
{0x25BC, 0x81A5},
{0x25BD, 0x81A4},
{0x25C6, 0x819F},
{0x25C7, 0x819E},
{0x25CB, 0x819B},
{0x25CE, 0x819D},
{0x25CF, 0x819C},
{0x25EF, 0x81FC},
{0x2605, 0x819A},
{0x2606, 0x8199},
{0x2640, 0x818A},
{0x2642, 0x8189},
{0x266A, 0x81F4},
{0x266D, 0x81F3},
{0x266F, 0x81F2},
{0x3000, 0x8140},
{0x3001, 0x8141},
{0x3002, 0x8142},
{0x3003, 0x8156},
{0x3005, 0x8158},
{0x3006, 0x8159},
{0x3007, 0x815A},
{0x3008, 0x8171},
{0x3009, 0x8172},
{0x300A, 0x8173},
{0x300B, 0x8174},
{0x300C, 0x8175},
{0x300D, 0x8176},
{0x300E, 0x8177},
{0x300F, 0x8178},
{0x3010, 0x8179},
{0x3011, 0x817A},
{0x3012, 0x81A7},
{0x3013, 0x81AC},
{0x3014, 0x816B},
{0x3015, 0x816C},
{0x301C, 0x8160},
{0x301D, 0x8780},
{0x301F, 0x8781},
{0x3041, 0x829F},
{0x3042, 0x82A0},
{0x3043, 0x82A1},
{0x3044, 0x82A2},
{0x3045, 0x82A3},
{0x3046, 0x82A4},
{0x3047, 0x82A5},
{0x3048, 0x82A6},
{0x3049, 0x82A7},
{0x304A, 0x82A8},
{0x304B, 0x82A9},
{0x304C, 0x82AA},
{0x304D, 0x82AB},
{0x304E, 0x82AC},
{0x304F, 0x82AD},
{0x3050, 0x82AE},
{0x3051, 0x82AF},
{0x3052, 0x82B0},
{0x3053, 0x82B1},
{0x3054, 0x82B2},
{0x3055, 0x82B3},
{0x3056, 0x82B4},
{0x3057, 0x82B5},
{0x3058, 0x82B6},
{0x3059, 0x82B7},
{0x305A, 0x82B8},
{0x305B, 0x82B9},
{0x305C, 0x82BA},
{0x305D, 0x82BB},
{0x305E, 0x82BC},
{0x305F, 0x82BD},
{0x3060, 0x82BE},
{0x3061, 0x82BF},
{0x3062, 0x82C0},
{0x3063, 0x82C1},
{0x3064, 0x82C2},
{0x3065, 0x82C3},
{0x3066, 0x82C4},
{0x3067, 0x82C5},
{0x3068, 0x82C6},
{0x3069, 0x82C7},
{0x306A, 0x82C8},
{0x306B, 0x82C9},
{0x306C, 0x82CA},
{0x306D, 0x82CB},
{0x306E, 0x82CC},
{0x306F, 0x82CD},
{0x3070, 0x82CE},
{0x3071, 0x82CF},
{0x3072, 0x82D0},
{0x3073, 0x82D1},
{0x3074, 0x82D2},
{0x3075, 0x82D3},
{0x3076, 0x82D4},
{0x3077, 0x82D5},
{0x3078, 0x82D6},
{0x3079, 0x82D7},
{0x307A, 0x82D8},
{0x307B, 0x82D9},
{0x307C, 0x82DA},
{0x307D, 0x82DB},
{0x307E, 0x82DC},
{0x307F, 0x82DD},
{0x3080, 0x82DE},
{0x3081, 0x82DF},
{0x3082, 0x82E0},
{0x3083, 0x82E1},
{0x3084, 0x82E2},
{0x3085, 0x82E3},
{0x3086, 0x82E4},
{0x3087, 0x82E5},
{0x3088, 0x82E6},
{0x3089, 0x82E7},
{0x308A, 0x82E8},
{0x308B, 0x82E9},
{0x308C, 0x82EA},
{0x308D, 0x82EB},
{0x308E, 0x82EC},
{0x308F, 0x82ED},
{0x3090, 0x82EE},
{0x3091, 0x82EF},
{0x3092, 0x82F0},
{0x3093, 0x82F1},
{0x309B, 0x814A},
{0x309C, 0x814B},
{0x309D, 0x8154},
{0x309E, 0x8155},
{0x30A1, 0x8340},
{0x30A2, 0x8341},
{0x30A3, 0x8342},
{0x30A4, 0x8343},
{0x30A5, 0x8344},
{0x30A6, 0x8345},
{0x30A7, 0x8346},
{0x30A8, 0x8347},
{0x30A9, 0x8348},
{0x30AA, 0x8349},
{0x30AB, 0x834A},
{0x30AC, 0x834B},
{0x30AD, 0x834C},
{0x30AE, 0x834D},
{0x30AF, 0x834E},
{0x30B0, 0x834F},
{0x30B1, 0x8350},
{0x30B2, 0x8351},
{0x30B3, 0x8352},
{0x30B4, 0x8353},
{0x30B5, 0x8354},
{0x30B6, 0x8355},
{0x30B7, 0x8356},
{0x30B8, 0x8357},
{0x30B9, 0x8358},
{0x30BA, 0x8359},
{0x30BB, 0x835A},
{0x30BC, 0x835B},
{0x30BD, 0x835C},
{0x30BE, 0x835D},
{0x30BF, 0x835E},
{0x30C0, 0x835F},
{0x30C1, 0x8360},
{0x30C2, 0x8361},
{0x30C3, 0x8362},
{0x30C4, 0x8363},
{0x30C5, 0x8364},
{0x30C6, 0x8365},
{0x30C7, 0x8366},
{0x30C8, 0x8367},
{0x30C9, 0x8368},
{0x30CA, 0x8369},
{0x30CB, 0x836A},
{0x30CC, 0x836B},
{0x30CD, 0x836C},
{0x30CE, 0x836D},
{0x30CF, 0x836E},
{0x30D0, 0x836F},
{0x30D1, 0x8370},
{0x30D2, 0x8371},
{0x30D3, 0x8372},
{0x30D4, 0x8373},
{0x30D5, 0x8374},
{0x30D6, 0x8375},
{0x30D7, 0x8376},
{0x30D8, 0x8377},
{0x30D9, 0x8378},
{0x30DA, 0x8379},
{0x30DB, 0x837A},
{0x30DC, 0x837B},
{0x30DD, 0x837C},
{0x30DE, 0x837D},
{0x30DF, 0x837E},
{0x30E0, 0x8380},
{0x30E1, 0x8381},
{0x30E2, 0x8382},
{0x30E3, 0x8383},
{0x30E4, 0x8384},
{0x30E5, 0x8385},
{0x30E6, 0x8386},
{0x30E7, 0x8387},
{0x30E8, 0x8388},
{0x30E9, 0x8389},
{0x30EA, 0x838A},
{0x30EB, 0x838B},
{0x30EC, 0x838C},
{0x30ED, 0x838D},
{0x30EE, 0x838E},
{0x30EF, 0x838F},
{0x30F0, 0x8390},
{0x30F1, 0x8391},
{0x30F2, 0x8392},
{0x30F3, 0x8393},
{0x30F4, 0x8394},
{0x30F5, 0x8395},
{0x30F6, 0x8396},
{0x30FB, 0x8145},
{0x30FC, 0x815B},
{0x30FD, 0x8152},
{0x30FE, 0x8153},
{0x3231, 0x878A},
{0x3232, 0x878B},
{0x3239, 0x878C},
{0x32A4, 0x8785},
{0x32A5, 0x8786},
{0x32A6, 0x8787},
{0x32A7, 0x8788},
{0x32A8, 0x8789},
{0x3303, 0x8765},
{0x330D, 0x8769},
{0x3314, 0x8760},
{0x3318, 0x8763},
{0x3322, 0x8761},
{0x3323, 0x876B},
{0x3326, 0x876A},
{0x3327, 0x8764},
{0x332B, 0x876C},
{0x3336, 0x8766},
{0x333B, 0x876E},
{0x3349, 0x875F},
{0x334A, 0x876D},
{0x334D, 0x8762},
{0x3351, 0x8767},
{0x3357, 0x8768},
{0x337B, 0x877E},
{0x337C, 0x878F},
{0x337D, 0x878E},
{0x337E, 0x878D},
{0x338E, 0x8772},
{0x338F, 0x8773},
{0x339C, 0x876F},
{0x339D, 0x8770},
{0x339E, 0x8771},
{0x33A1, 0x8775},
{0x33C4, 0x8774},
{0x33CD, 0x8783},
{0x4E00, 0x88EA},
{0x4E01, 0x929A},
{0x4E03, 0x8EB5},
{0x4E07, 0x969C},
{0x4E08, 0x8FE4},
{0x4E09, 0x8E4F},
{0x4E0A, 0x8FE3},
{0x4E0B, 0x89BA},
{0x4E0D, 0x9573},
{0x4E0E, 0x975E},
{0x4E10, 0x98A0},
{0x4E11, 0x894E},
{0x4E14, 0x8A8E},
{0x4E15, 0x98A1},
{0x4E16, 0x90A2},
{0x4E17, 0x99C0},
{0x4E18, 0x8B75},
{0x4E19, 0x95B8},
{0x4E1E, 0x8FE5},
{0x4E21, 0x97BC},
{0x4E26, 0x95C0},
{0x4E28, 0xFA68},
{0x4E2A, 0x98A2},
{0x4E2D, 0x9286},
{0x4E31, 0x98A3},
{0x4E32, 0x8BF8},
{0x4E36, 0x98A4},
{0x4E38, 0x8ADB},
{0x4E39, 0x924F},
{0x4E3B, 0x8EE5},
{0x4E3C, 0x98A5},
{0x4E3F, 0x98A6},
{0x4E42, 0x98A7},
{0x4E43, 0x9454},
{0x4E45, 0x8B76},
{0x4E4B, 0x9456},
{0x4E4D, 0x93E1},
{0x4E4E, 0x8CC1},
{0x4E4F, 0x9652},
{0x4E55, 0xE568},
{0x4E56, 0x98A8},
{0x4E57, 0x8FE6},
{0x4E58, 0x98A9},
{0x4E59, 0x89B3},
{0x4E5D, 0x8BE3},
{0x4E5E, 0x8CEE},
{0x4E5F, 0x96E7},
{0x4E62, 0x9BA4},
{0x4E71, 0x9790},
{0x4E73, 0x93FB},
{0x4E7E, 0x8AA3},
{0x4E80, 0x8B54},
{0x4E82, 0x98AA},
{0x4E85, 0x98AB},
{0x4E86, 0x97B9},
{0x4E88, 0x975C},
{0x4E89, 0x9188},
{0x4E8A, 0x98AD},
{0x4E8B, 0x8E96},
{0x4E8C, 0x93F1},
{0x4E8E, 0x98B0},
{0x4E91, 0x895D},
{0x4E92, 0x8CDD},
{0x4E94, 0x8CDC},
{0x4E95, 0x88E4},
{0x4E98, 0x986A},
{0x4E99, 0x9869},
{0x4E9B, 0x8DB1},
{0x4E9C, 0x889F},
{0x4E9E, 0x98B1},
{0x4E9F, 0x98B2},
{0x4EA0, 0x98B3},
{0x4EA1, 0x9653},
{0x4EA2, 0x98B4},
{0x4EA4, 0x8CF0},
{0x4EA5, 0x88E5},
{0x4EA6, 0x9692},
{0x4EA8, 0x8B9C},
{0x4EAB, 0x8B9D},
{0x4EAC, 0x8B9E},
{0x4EAD, 0x92E0},
{0x4EAE, 0x97BA},
{0x4EB0, 0x98B5},
{0x4EB3, 0x98B6},
{0x4EB6, 0x98B7},
{0x4EBA, 0x906C},
{0x4EC0, 0x8F59},
{0x4EC1, 0x906D},
{0x4EC2, 0x98BC},
{0x4EC4, 0x98BA},
{0x4EC6, 0x98BB},
{0x4EC7, 0x8B77},
{0x4ECA, 0x8DA1},
{0x4ECB, 0x89EE},
{0x4ECD, 0x98B9},
{0x4ECE, 0x98B8},
{0x4ECF, 0x95A7},
{0x4ED4, 0x8E65},
{0x4ED5, 0x8E64},
{0x4ED6, 0x91BC},
{0x4ED7, 0x98BD},
{0x4ED8, 0x9574},
{0x4ED9, 0x90E5},
{0x4EDD, 0x8157},
{0x4EDE, 0x98BE},
{0x4EDF, 0x98C0},
{0x4EE1, 0xFA69},
{0x4EE3, 0x91E3},
{0x4EE4, 0x97DF},
{0x4EE5, 0x88C8},
{0x4EED, 0x98BF},
{0x4EEE, 0x89BC},
{0x4EF0, 0x8BC2},
{0x4EF2, 0x9287},
{0x4EF6, 0x8C8F},
{0x4EF7, 0x98C1},
{0x4EFB, 0x9443},
{0x4EFC, 0xFA6A},
{0x4F00, 0xFA6B},
{0x4F01, 0x8AE9},
{0x4F03, 0xFA6C},
{0x4F09, 0x98C2},
{0x4F0A, 0x88C9},
{0x4F0D, 0x8CDE},
{0x4F0E, 0x8AEA},
{0x4F0F, 0x959A},
{0x4F10, 0x94B0},
{0x4F11, 0x8B78},
{0x4F1A, 0x89EF},
{0x4F1C, 0x98E5},
{0x4F1D, 0x9360},
{0x4F2F, 0x948C},
{0x4F30, 0x98C4},
{0x4F34, 0x94BA},
{0x4F36, 0x97E0},
{0x4F38, 0x904C},
{0x4F39, 0xFA6D},
{0x4F3A, 0x8E66},
{0x4F3C, 0x8E97},
{0x4F3D, 0x89BE},
{0x4F43, 0x92CF},
{0x4F46, 0x9241},
{0x4F47, 0x98C8},
{0x4F4D, 0x88CA},
{0x4F4E, 0x92E1},
{0x4F4F, 0x8F5A},
{0x4F50, 0x8DB2},
{0x4F51, 0x9743},
{0x4F53, 0x91CC},
{0x4F55, 0x89BD},
{0x4F56, 0xFA6E},
{0x4F57, 0x98C7},
{0x4F59, 0x975D},
{0x4F5A, 0x98C3},
{0x4F5B, 0x98C5},
{0x4F5C, 0x8DEC},
{0x4F5D, 0x98C6},
{0x4F5E, 0x9B43},
{0x4F69, 0x98CE},
{0x4F6F, 0x98D1},
{0x4F70, 0x98CF},
{0x4F73, 0x89C0},
{0x4F75, 0x95B9},
{0x4F76, 0x98C9},
{0x4F7B, 0x98CD},
{0x4F7C, 0x8CF1},
{0x4F7F, 0x8E67},
{0x4F83, 0x8AA4},
{0x4F86, 0x98D2},
{0x4F88, 0x98CA},
{0x4F8A, 0xFA70},
{0x4F8B, 0x97E1},
{0x4F8D, 0x8E98},
{0x4F8F, 0x98CB},
{0x4F91, 0x98D0},
{0x4F92, 0xFA6F},
{0x4F94, 0xFA72},
{0x4F96, 0x98D3},
{0x4F98, 0x98CC},
{0x4F9A, 0xFA71},
{0x4F9B, 0x8B9F},
{0x4F9D, 0x88CB},
{0x4FA0, 0x8BA0},
{0x4FA1, 0x89BF},
{0x4FAB, 0x9B44},
{0x4FAD, 0x9699},
{0x4FAE, 0x958E},
{0x4FAF, 0x8CF2},
{0x4FB5, 0x904E},
{0x4FB6, 0x97B5},
{0x4FBF, 0x95D6},
{0x4FC2, 0x8C57},
{0x4FC3, 0x91A3},
{0x4FC4, 0x89E2},
{0x4FC9, 0xFA61},
{0x4FCA, 0x8F72},
{0x4FCD, 0xFA73},
{0x4FCE, 0x98D7},
{0x4FD0, 0x98DC},
{0x4FD1, 0x98DA},
{0x4FD4, 0x98D5},
{0x4FD7, 0x91AD},
{0x4FD8, 0x98D8},
{0x4FDA, 0x98DB},
{0x4FDB, 0x98D9},
{0x4FDD, 0x95DB},
{0x4FDF, 0x98D6},
{0x4FE1, 0x904D},
{0x4FE3, 0x9693},
{0x4FE4, 0x98DD},
{0x4FE5, 0x98DE},
{0x4FEE, 0x8F43},
{0x4FEF, 0x98EB},
{0x4FF3, 0x946F},
{0x4FF5, 0x9555},
{0x4FF6, 0x98E6},
{0x4FF8, 0x95EE},
{0x4FFA, 0x89B4},
{0x4FFE, 0x98EA},
{0x4FFF, 0xFA76},
{0x5005, 0x98E4},
{0x5006, 0x98ED},
{0x5009, 0x9171},
{0x500B, 0x8CC2},
{0x500D, 0x947B},
{0x500F, 0xE0C5},
{0x5011, 0x98EC},
{0x5012, 0x937C},
{0x5014, 0x98E1},
{0x5016, 0x8CF4},
{0x5019, 0x8CF3},
{0x501A, 0x98DF},
{0x501E, 0xFA77},
{0x501F, 0x8ED8},
{0x5021, 0x98E7},
{0x5022, 0xFA75},
{0x5023, 0x95ED},
{0x5024, 0x926C},
{0x5025, 0x98E3},
{0x5026, 0x8C91},
{0x5028, 0x98E0},
{0x5029, 0x98E8},
{0x502A, 0x98E2},
{0x502B, 0x97CF},
{0x502C, 0x98E9},
{0x502D, 0x9860},
{0x5036, 0x8BE4},
{0x5039, 0x8C90},
{0x5040, 0xFA74},
{0x5042, 0xFA7A},
{0x5043, 0x98EE},
{0x5046, 0xFA78},
{0x5047, 0x98EF},
{0x5048, 0x98F3},
{0x5049, 0x88CC},
{0x504F, 0x95CE},
{0x5050, 0x98F2},
{0x5055, 0x98F1},
{0x5056, 0x98F5},
{0x505A, 0x98F4},
{0x505C, 0x92E2},
{0x5065, 0x8C92},
{0x506C, 0x98F6},
{0x5070, 0xFA79},
{0x5072, 0x8EC3},
{0x5074, 0x91A4},
{0x5075, 0x92E3},
{0x5076, 0x8BF4},
{0x5078, 0x98F7},
{0x507D, 0x8B55},
{0x5080, 0x98F8},
{0x5085, 0x98FA},
{0x508D, 0x9654},
{0x5091, 0x8C86},
{0x5094, 0xFA7B},
{0x5098, 0x8E50},
{0x5099, 0x94F5},
{0x509A, 0x98F9},
{0x50AC, 0x8DC3},
{0x50AD, 0x9762},
{0x50B2, 0x98FC},
{0x50B3, 0x9942},
{0x50B4, 0x98FB},
{0x50B5, 0x8DC2},
{0x50B7, 0x8F9D},
{0x50BE, 0x8C58},
{0x50C2, 0x9943},
{0x50C5, 0x8BCD},
{0x50C9, 0x9940},
{0x50CA, 0x9941},
{0x50CD, 0x93AD},
{0x50CF, 0x919C},
{0x50D1, 0x8BA1},
{0x50D5, 0x966C},
{0x50D6, 0x9944},
{0x50D8, 0xFA7D},
{0x50DA, 0x97BB},
{0x50DE, 0x9945},
{0x50E3, 0x9948},
{0x50E5, 0x9946},
{0x50E7, 0x916D},
{0x50ED, 0x9947},
{0x50EE, 0x9949},
{0x50F4, 0xFA7C},
{0x50F5, 0x994B},
{0x50F9, 0x994A},
{0x50FB, 0x95C6},
{0x5100, 0x8B56},
{0x5101, 0x994D},
{0x5102, 0x994E},
{0x5104, 0x89AD},
{0x5109, 0x994C},
{0x5112, 0x8EF2},
{0x5114, 0x9951},
{0x5115, 0x9950},
{0x5116, 0x994F},
{0x5118, 0x98D4},
{0x511A, 0x9952},
{0x511F, 0x8F9E},
{0x5121, 0x9953},
{0x512A, 0x9744},
{0x5132, 0x96D7},
{0x5137, 0x9955},
{0x513A, 0x9954},
{0x513B, 0x9957},
{0x513C, 0x9956},
{0x513F, 0x9958},
{0x5140, 0x9959},
{0x5141, 0x88F2},
{0x5143, 0x8CB3},
{0x5144, 0x8C5A},
{0x5145, 0x8F5B},
{0x5146, 0x929B},
{0x5147, 0x8BA2},
{0x5148, 0x90E6},
{0x5149, 0x8CF5},
{0x514A, 0xFA7E},
{0x514B, 0x8D8E},
{0x514C, 0x995B},
{0x514D, 0x96C6},
{0x514E, 0x9365},
{0x5150, 0x8E99},
{0x5152, 0x995A},
{0x5154, 0x995C},
{0x515A, 0x937D},
{0x515C, 0x8A95},
{0x5162, 0x995D},
{0x5164, 0xFA80},
{0x5165, 0x93FC},
{0x5168, 0x9153},
{0x5169, 0x995F},
{0x516A, 0x9960},
{0x516B, 0x94AA},
{0x516C, 0x8CF6},
{0x516D, 0x985A},
{0x516E, 0x9961},
{0x5171, 0x8BA4},
{0x5175, 0x95BA},
{0x5176, 0x91B4},
{0x5177, 0x8BEF},
{0x5178, 0x9354},
{0x517C, 0x8C93},
{0x5180, 0x9962},
{0x5182, 0x9963},
{0x5185, 0x93E0},
{0x5186, 0x897E},
{0x5189, 0x9966},
{0x518A, 0x8DFB},
{0x518C, 0x9965},
{0x518D, 0x8DC4},
{0x518F, 0x9967},
{0x5190, 0xE3EC},
{0x5191, 0x9968},
{0x5192, 0x9660},
{0x5193, 0x9969},
{0x5195, 0x996A},
{0x5196, 0x996B},
{0x5197, 0x8FE7},
{0x5199, 0x8ECA},
{0x519D, 0xFA81},
{0x51A0, 0x8AA5},
{0x51A2, 0x996E},
{0x51A4, 0x996C},
{0x51A5, 0x96BB},
{0x51A6, 0x996D},
{0x51A8, 0x9579},
{0x51A9, 0x996F},
{0x51AA, 0x9970},
{0x51AB, 0x9971},
{0x51AC, 0x937E},
{0x51B0, 0x9975},
{0x51B1, 0x9973},
{0x51B2, 0x9974},
{0x51B3, 0x9972},
{0x51B4, 0x8DE1},
{0x51B5, 0x9976},
{0x51B6, 0x96E8},
{0x51B7, 0x97E2},
{0x51BD, 0x9977},
{0x51BE, 0xFA82},
{0x51C4, 0x90A6},
{0x51C5, 0x9978},
{0x51C6, 0x8F79},
{0x51C9, 0x9979},
{0x51CB, 0x929C},
{0x51CC, 0x97BD},
{0x51CD, 0x9380},
{0x51D6, 0x99C3},
{0x51DB, 0x997A},
{0x51DC, 0xEAA3},
{0x51DD, 0x8BC3},
{0x51E0, 0x997B},
{0x51E1, 0x967D},
{0x51E6, 0x8F88},
{0x51E7, 0x91FA},
{0x51E9, 0x997D},
{0x51EA, 0x93E2},
{0x51EC, 0xFA83},
{0x51ED, 0x997E},
{0x51F0, 0x9980},
{0x51F1, 0x8A4D},
{0x51F5, 0x9981},
{0x51F6, 0x8BA5},
{0x51F8, 0x93CA},
{0x51F9, 0x899A},
{0x51FA, 0x8F6F},
{0x51FD, 0x949F},
{0x51FE, 0x9982},
{0x5200, 0x9381},
{0x5203, 0x906E},
{0x5204, 0x9983},
{0x5206, 0x95AA},
{0x5207, 0x90D8},
{0x5208, 0x8AA0},
{0x520A, 0x8AA7},
{0x520B, 0x9984},
{0x520E, 0x9986},
{0x5211, 0x8C59},
{0x5214, 0x9985},
{0x5215, 0xFA84},
{0x5217, 0x97F1},
{0x521D, 0x8F89},
{0x5224, 0x94BB},
{0x5225, 0x95CA},
{0x5227, 0x9987},
{0x5229, 0x9798},
{0x522A, 0x9988},
{0x522E, 0x9989},
{0x5230, 0x939E},
{0x5233, 0x998A},
{0x5236, 0x90A7},
{0x5237, 0x8DFC},
{0x5238, 0x8C94},
{0x5239, 0x998B},
{0x523A, 0x8E68},
{0x523B, 0x8D8F},
{0x5243, 0x92E4},
{0x5244, 0x998D},
{0x5247, 0x91A5},
{0x524A, 0x8DED},
{0x524B, 0x998E},
{0x524C, 0x998F},
{0x524D, 0x914F},
{0x524F, 0x998C},
{0x5254, 0x9991},
{0x5256, 0x9655},
{0x525B, 0x8D84},
{0x525E, 0x9990},
{0x5263, 0x8C95},
{0x5264, 0x8DDC},
{0x5265, 0x948D},
{0x5269, 0x9994},
{0x526A, 0x9992},
{0x526F, 0x959B},
{0x5270, 0x8FE8},
{0x5271, 0x999B},
{0x5272, 0x8A84},
{0x5273, 0x9995},
{0x5274, 0x9993},
{0x5275, 0x916E},
{0x527D, 0x9997},
{0x527F, 0x9996},
{0x5283, 0x8A63},
{0x5287, 0x8C80},
{0x5288, 0x999C},
{0x5289, 0x97AB},
{0x528D, 0x9998},
{0x5291, 0x999D},
{0x5292, 0x999A},
{0x5294, 0x9999},
{0x529B, 0x97CD},
{0x529C, 0xFA85},
{0x529F, 0x8CF7},
{0x52A0, 0x89C1},
{0x52A3, 0x97F2},
{0x52A6, 0xFA86},
{0x52A9, 0x8F95},
{0x52AA, 0x9377},
{0x52AB, 0x8D85},
{0x52AC, 0x99A0},
{0x52AD, 0x99A1},
{0x52AF, 0xFB77},
{0x52B1, 0x97E3},
{0x52B4, 0x984A},
{0x52B5, 0x99A3},
{0x52B9, 0x8CF8},
{0x52BC, 0x99A2},
{0x52BE, 0x8A4E},
{0x52C0, 0xFA87},
{0x52C1, 0x99A4},
{0x52C3, 0x9675},
{0x52C5, 0x92BA},
{0x52C7, 0x9745},
{0x52C9, 0x95D7},
{0x52CD, 0x99A5},
{0x52D2, 0xE8D3},
{0x52D5, 0x93AE},
{0x52D7, 0x99A6},
{0x52D8, 0x8AA8},
{0x52D9, 0x96B1},
{0x52DB, 0xFA88},
{0x52DD, 0x8F9F},
{0x52DE, 0x99A7},
{0x52DF, 0x95E5},
{0x52E0, 0x99AB},
{0x52E2, 0x90A8},
{0x52E3, 0x99A8},
{0x52E4, 0x8BCE},
{0x52E6, 0x99A9},
{0x52E7, 0x8AA9},
{0x52F2, 0x8C4D},
{0x52F3, 0x99AC},
{0x52F5, 0x99AD},
{0x52F8, 0x99AE},
{0x52F9, 0x99AF},
{0x52FA, 0x8ED9},
{0x52FE, 0x8CF9},
{0x52FF, 0x96DC},
{0x5300, 0xFA89},
{0x5301, 0x96E6},
{0x5302, 0x93F5},
{0x5305, 0x95EF},
{0x5306, 0x99B0},
{0x5307, 0xFA8A},
{0x5308, 0x99B1},
{0x530D, 0x99B3},
{0x530F, 0x99B5},
{0x5310, 0x99B4},
{0x5315, 0x99B6},
{0x5316, 0x89BB},
{0x5317, 0x966B},
{0x5319, 0x8DFA},
{0x531A, 0x99B7},
{0x531D, 0x9178},
{0x5320, 0x8FA0},
{0x5321, 0x8BA7},
{0x5323, 0x99B8},
{0x5324, 0xFA8B},
{0x532A, 0x94D9},
{0x532F, 0x99B9},
{0x5331, 0x99BA},
{0x5333, 0x99BB},
{0x5338, 0x99BC},
{0x5339, 0x9543},
{0x533A, 0x8BE6},
{0x533B, 0x88E3},
{0x533F, 0x93BD},
{0x5340, 0x99BD},
{0x5341, 0x8F5C},
{0x5343, 0x90E7},
{0x5345, 0x99BF},
{0x5346, 0x99BE},
{0x5347, 0x8FA1},
{0x5348, 0x8CDF},
{0x5349, 0x99C1},
{0x534A, 0x94BC},
{0x534D, 0x99C2},
{0x5351, 0x94DA},
{0x5352, 0x91B2},
{0x5353, 0x91EC},
{0x5354, 0x8BA6},
{0x5357, 0x93EC},
{0x5358, 0x9250},
{0x535A, 0x948E},
{0x535C, 0x966D},
{0x535E, 0x99C4},
{0x5360, 0x90E8},
{0x5366, 0x8C54},
{0x5369, 0x99C5},
{0x536E, 0x99C6},
{0x536F, 0x894B},
{0x5370, 0x88F3},
{0x5371, 0x8AEB},
{0x5372, 0xFA8C},
{0x5373, 0x91A6},
{0x5374, 0x8B70},
{0x5375, 0x9791},
{0x5377, 0x99C9},
{0x5378, 0x89B5},
{0x537B, 0x99C8},
{0x537F, 0x8BA8},
{0x5382, 0x99CA},
{0x5384, 0x96EF},
{0x5393, 0xFA8D},
{0x5396, 0x99CB},
{0x5398, 0x97D0},
{0x539A, 0x8CFA},
{0x539F, 0x8CB4},
{0x53A0, 0x99CC},
{0x53A5, 0x99CE},
{0x53A6, 0x99CD},
{0x53A8, 0x907E},
{0x53A9, 0x8958},
{0x53AD, 0x897D},
{0x53AE, 0x99CF},
{0x53B0, 0x99D0},
{0x53B2, 0xFA8E},
{0x53B3, 0x8CB5},
{0x53B6, 0x99D1},
{0x53BB, 0x8B8E},
{0x53C2, 0x8E51},
{0x53C3, 0x99D2},
{0x53C8, 0x9694},
{0x53C9, 0x8DB3},
{0x53CA, 0x8B79},
{0x53CB, 0x9746},
{0x53CC, 0x916F},
{0x53CD, 0x94BD},
{0x53CE, 0x8EFB},
{0x53D4, 0x8F66},
{0x53D6, 0x8EE6},
{0x53D7, 0x8EF3},
{0x53D9, 0x8F96},
{0x53DB, 0x94BE},
{0x53DD, 0xFA8F},
{0x53DF, 0x99D5},
{0x53E1, 0x8962},
{0x53E2, 0x9170},
{0x53E3, 0x8CFB},
{0x53E4, 0x8CC3},
{0x53E5, 0x8BE5},
{0x53E8, 0x99D9},
{0x53E9, 0x9240},
{0x53EA, 0x91FC},
{0x53EB, 0x8BA9},
{0x53EC, 0x8FA2},
{0x53ED, 0x99DA},
{0x53EE, 0x99D8},
{0x53EF, 0x89C2},
{0x53F0, 0x91E4},
{0x53F1, 0x8EB6},
{0x53F2, 0x8E6A},
{0x53F3, 0x8945},
{0x53F6, 0x8A90},
{0x53F7, 0x8D86},
{0x53F8, 0x8E69},
{0x53FA, 0x99DB},
{0x5401, 0x99DC},
{0x5403, 0x8B68},
{0x5404, 0x8A65},
{0x5408, 0x8D87},
{0x5409, 0x8B67},
{0x540A, 0x92DD},
{0x540B, 0x8944},
{0x540C, 0x93AF},
{0x540D, 0x96BC},
{0x540E, 0x8D40},
{0x540F, 0x9799},
{0x5410, 0x9366},
{0x5411, 0x8CFC},
{0x541B, 0x8C4E},
{0x541D, 0x99E5},
{0x541F, 0x8BE1},
{0x5420, 0x9669},
{0x5426, 0x94DB},
{0x5429, 0x99E4},
{0x542B, 0x8ADC},
{0x542C, 0x99DF},
{0x542D, 0x99E0},
{0x542E, 0x99E2},
{0x5436, 0x99E3},
{0x5438, 0x8B7A},
{0x5439, 0x9081},
{0x543B, 0x95AB},
{0x543C, 0x99E1},
{0x543D, 0x99DD},
{0x543E, 0x8CE1},
{0x5440, 0x99DE},
{0x5442, 0x9843},
{0x5446, 0x95F0},
{0x5448, 0x92E6},
{0x5449, 0x8CE0},
{0x544A, 0x8D90},
{0x544E, 0x99E6},
{0x5451, 0x93DB},
{0x545F, 0x99EA},
{0x5468, 0x8EFC},
{0x546A, 0x8EF4},
{0x5470, 0x99ED},
{0x5471, 0x99EB},
{0x5473, 0x96A1},
{0x5475, 0x99E8},
{0x5476, 0x99F1},
{0x5477, 0x99EC},
{0x547B, 0x99EF},
{0x547C, 0x8CC4},
{0x547D, 0x96BD},
{0x5480, 0x99F0},
{0x5484, 0x99F2},
{0x5486, 0x99F4},
{0x548A, 0xFA92},
{0x548B, 0x8DEE},
{0x548C, 0x9861},
{0x548E, 0x99E9},
{0x548F, 0x99E7},
{0x5490, 0x99F3},
{0x5492, 0x99EE},
{0x549C, 0xFA91},
{0x54A2, 0x99F6},
{0x54A4, 0x9A42},
{0x54A5, 0x99F8},
{0x54A8, 0x99FC},
{0x54A9, 0xFA93},
{0x54AB, 0x9A40},
{0x54AC, 0x99F9},
{0x54AF, 0x9A5D},
{0x54B2, 0x8DE7},
{0x54B3, 0x8A50},
{0x54B8, 0x99F7},
{0x54BC, 0x9A44},
{0x54BD, 0x88F4},
{0x54BE, 0x9A43},
{0x54C0, 0x88A3},
{0x54C1, 0x9569},
{0x54C2, 0x9A41},
{0x54C4, 0x99FA},
{0x54C7, 0x99F5},
{0x54C8, 0x99FB},
{0x54C9, 0x8DC6},
{0x54D8, 0x9A45},
{0x54E1, 0x88F5},
{0x54E2, 0x9A4E},
{0x54E5, 0x9A46},
{0x54E6, 0x9A47},
{0x54E8, 0x8FA3},
{0x54E9, 0x9689},
{0x54ED, 0x9A4C},
{0x54EE, 0x9A4B},
{0x54F2, 0x934E},
{0x54FA, 0x9A4D},
{0x54FD, 0x9A4A},
{0x54FF, 0xFA94},
{0x5504, 0x8953},
{0x5506, 0x8DB4},
{0x5507, 0x904F},
{0x550F, 0x9A48},
{0x5510, 0x9382},
{0x5514, 0x9A49},
{0x5516, 0x88A0},
{0x552E, 0x9A53},
{0x552F, 0x9742},
{0x5531, 0x8FA5},
{0x5533, 0x9A59},
{0x5538, 0x9A58},
{0x5539, 0x9A4F},
{0x553E, 0x91C1},
{0x5540, 0x9A50},
{0x5544, 0x91ED},
{0x5545, 0x9A55},
{0x5546, 0x8FA4},
{0x554C, 0x9A52},
{0x554F, 0x96E2},
{0x5553, 0x8C5B},
{0x5556, 0x9A56},
{0x5557, 0x9A57},
{0x555C, 0x9A54},
{0x555D, 0x9A5A},
{0x5563, 0x9A51},
{0x557B, 0x9A60},
{0x557C, 0x9A65},
{0x557E, 0x9A61},
{0x5580, 0x9A5C},
{0x5583, 0x9A66},
{0x5584, 0x9150},
{0x5586, 0xFA95},
{0x5587, 0x9A68},
{0x5589, 0x8D41},
{0x558A, 0x9A5E},
{0x558B, 0x929D},
{0x5598, 0x9A62},
{0x5599, 0x9A5B},
{0x559A, 0x8AAB},
{0x559C, 0x8AEC},
{0x559D, 0x8A85},
{0x559E, 0x9A63},
{0x559F, 0x9A5F},
{0x55A7, 0x8C96},
{0x55A8, 0x9A69},
{0x55A9, 0x9A67},
{0x55AA, 0x9172},
{0x55AB, 0x8B69},
{0x55AC, 0x8BAA},
{0x55AE, 0x9A64},
{0x55B0, 0x8BF2},
{0x55B6, 0x8963},
{0x55C4, 0x9A6D},
{0x55C5, 0x9A6B},
{0x55C7, 0x9AA5},
{0x55D4, 0x9A70},
{0x55DA, 0x9A6A},
{0x55DC, 0x9A6E},
{0x55DF, 0x9A6C},
{0x55E3, 0x8E6B},
{0x55E4, 0x9A6F},
{0x55F7, 0x9A72},
{0x55F9, 0x9A77},
{0x55FD, 0x9A75},
{0x55FE, 0x9A74},
{0x5606, 0x9251},
{0x5609, 0x89C3},
{0x5614, 0x9A71},
{0x5616, 0x9A73},
{0x5617, 0x8FA6},
{0x5618, 0x8952},
{0x561B, 0x9A76},
{0x5629, 0x89DC},
{0x562F, 0x9A82},
{0x5631, 0x8FFA},
{0x5632, 0x9A7D},
{0x5634, 0x9A7B},
{0x5636, 0x9A7C},
{0x5638, 0x9A7E},
{0x5642, 0x895C},
{0x564C, 0x9158},
{0x564E, 0x9A78},
{0x5650, 0x9A79},
{0x565B, 0x8A9A},
{0x5664, 0x9A81},
{0x5668, 0x8AED},
{0x566A, 0x9A84},
{0x566B, 0x9A80},
{0x566C, 0x9A83},
{0x5674, 0x95AC},
{0x5678, 0x93D3},
{0x567A, 0x94B6},
{0x5680, 0x9A86},
{0x5686, 0x9A85},
{0x5687, 0x8A64},
{0x568A, 0x9A87},
{0x568F, 0x9A8A},
{0x5694, 0x9A89},
{0x56A0, 0x9A88},
{0x56A2, 0x9458},
{0x56A5, 0x9A8B},
{0x56AE, 0x9A8C},
{0x56B4, 0x9A8E},
{0x56B6, 0x9A8D},
{0x56BC, 0x9A90},
{0x56C0, 0x9A93},
{0x56C1, 0x9A91},
{0x56C2, 0x9A8F},
{0x56C3, 0x9A92},
{0x56C8, 0x9A94},
{0x56CE, 0x9A95},
{0x56D1, 0x9A96},
{0x56D3, 0x9A97},
{0x56D7, 0x9A98},
{0x56D8, 0x9964},
{0x56DA, 0x8EFA},
{0x56DB, 0x8E6C},
{0x56DE, 0x89F1},
{0x56E0, 0x88F6},
{0x56E3, 0x9263},
{0x56EE, 0x9A99},
{0x56F0, 0x8DA2},
{0x56F2, 0x88CD},
{0x56F3, 0x907D},
{0x56F9, 0x9A9A},
{0x56FA, 0x8CC5},
{0x56FD, 0x8D91},
{0x56FF, 0x9A9C},
{0x5700, 0x9A9B},
{0x5703, 0x95DE},
{0x5704, 0x9A9D},
{0x5708, 0x9A9F},
{0x5709, 0x9A9E},
{0x570B, 0x9AA0},
{0x570D, 0x9AA1},
{0x570F, 0x8C97},
{0x5712, 0x8980},
{0x5713, 0x9AA2},
{0x5716, 0x9AA4},
{0x5718, 0x9AA3},
{0x571C, 0x9AA6},
{0x571F, 0x9379},
{0x5726, 0x9AA7},
{0x5727, 0x88B3},
{0x5728, 0x8DDD},
{0x572D, 0x8C5C},
{0x5730, 0x926E},
{0x5737, 0x9AA8},
{0x5738, 0x9AA9},
{0x573B, 0x9AAB},
{0x5740, 0x9AAC},
{0x5742, 0x8DE2},
{0x5747, 0x8BCF},
{0x574A, 0x9656},
{0x574E, 0x9AAA},
{0x574F, 0x9AAD},
{0x5750, 0x8DBF},
{0x5751, 0x8D42},
{0x5759, 0xFA96},
{0x5761, 0x9AB1},
{0x5764, 0x8DA3},
{0x5765, 0xFA97},
{0x5766, 0x9252},
{0x5769, 0x9AAE},
{0x576A, 0x92D8},
{0x577F, 0x9AB2},
{0x5782, 0x9082},
{0x5788, 0x9AB0},
{0x5789, 0x9AB3},
{0x578B, 0x8C5E},
{0x5793, 0x9AB4},
{0x57A0, 0x9AB5},
{0x57A2, 0x8D43},
{0x57A3, 0x8A5F},
{0x57A4, 0x9AB7},
{0x57AA, 0x9AB8},
{0x57AC, 0xFA98},
{0x57B0, 0x9AB9},
{0x57B3, 0x9AB6},
{0x57C0, 0x9AAF},
{0x57C3, 0x9ABA},
{0x57C6, 0x9ABB},
{0x57C7, 0xFA9A},
{0x57C8, 0xFA99},
{0x57CB, 0x9684},
{0x57CE, 0x8FE9},
{0x57D2, 0x9ABD},
{0x57D3, 0x9ABE},
{0x57D4, 0x9ABC},
{0x57D6, 0x9AC0},
{0x57DC, 0x9457},
{0x57DF, 0x88E6},
{0x57E0, 0x9575},
{0x57E3, 0x9AC1},
{0x57F4, 0x8FFB},
{0x57F7, 0x8EB7},
{0x57F9, 0x947C},
{0x57FA, 0x8AEE},
{0x57FC, 0x8DE9},
{0x5800, 0x9678},
{0x5802, 0x93B0},
{0x5805, 0x8C98},
{0x5806, 0x91CD},
{0x580A, 0x9ABF},
{0x580B, 0x9AC2},
{0x5815, 0x91C2},
{0x5819, 0x9AC3},
{0x581D, 0x9AC4},
{0x5821, 0x9AC6},
{0x5824, 0x92E7},
{0x582A, 0x8AAC},
{0x582F, 0xEA9F},
{0x5830, 0x8981},
{0x5831, 0x95F1},
{0x5834, 0x8FEA},
{0x5835, 0x9367},
{0x583A, 0x8DE4},
{0x583D, 0x9ACC},
{0x5840, 0x95BB},
{0x5841, 0x97DB},
{0x584A, 0x89F2},
{0x584B, 0x9AC8},
{0x5851, 0x9159},
{0x5852, 0x9ACB},
{0x5854, 0x9383},
{0x5857, 0x9368},
{0x5858, 0x9384},
{0x5859, 0x94B7},
{0x585A, 0x92CB},
{0x585E, 0x8DC7},
{0x5862, 0x9AC7},
{0x5869, 0x8996},
{0x586B, 0x9355},
{0x5870, 0x9AC9},
{0x5872, 0x9AC5},
{0x5875, 0x906F},
{0x5879, 0x9ACD},
{0x587E, 0x8F6D},
{0x5883, 0x8BAB},
{0x5885, 0x9ACE},
{0x5893, 0x95E6},
{0x5897, 0x919D},
{0x589C, 0x92C4},
{0x589E, 0xFA9D},
{0x589F, 0x9AD0},
{0x58A8, 0x966E},
{0x58AB, 0x9AD1},
{0x58AE, 0x9AD6},
{0x58B2, 0xFA9E},
{0x58B3, 0x95AD},
{0x58B8, 0x9AD5},
{0x58B9, 0x9ACF},
{0x58BA, 0x9AD2},
{0x58BB, 0x9AD4},
{0x58BE, 0x8DA4},
{0x58C1, 0x95C7},
{0x58C5, 0x9AD7},
{0x58C7, 0x9264},
{0x58CA, 0x89F3},
{0x58CC, 0x8FEB},
{0x58D1, 0x9AD9},
{0x58D3, 0x9AD8},
{0x58D5, 0x8D88},
{0x58D7, 0x9ADA},
{0x58D8, 0x9ADC},
{0x58D9, 0x9ADB},
{0x58DC, 0x9ADE},
{0x58DE, 0x9AD3},
{0x58DF, 0x9AE0},
{0x58E4, 0x9ADF},
{0x58E5, 0x9ADD},
{0x58EB, 0x8E6D},
{0x58EC, 0x9070},
{0x58EE, 0x9173},
{0x58EF, 0x9AE1},
{0x58F0, 0x90BA},
{0x58F1, 0x88EB},
{0x58F2, 0x9484},
{0x58F7, 0x92D9},
{0x58F9, 0x9AE3},
{0x58FA, 0x9AE2},
{0x58FB, 0x9AE4},
{0x58FC, 0x9AE5},
{0x58FD, 0x9AE6},
{0x5902, 0x9AE7},
{0x5909, 0x95CF},
{0x590A, 0x9AE8},
{0x590B, 0xFA9F},
{0x590F, 0x89C4},
{0x5910, 0x9AE9},
{0x5915, 0x975B},
{0x5916, 0x8A4F},
{0x5918, 0x99C7},
{0x5919, 0x8F67},
{0x591A, 0x91BD},
{0x591B, 0x9AEA},
{0x591C, 0x96E9},
{0x5922, 0x96B2},
{0x5925, 0x9AEC},
{0x5927, 0x91E5},
{0x5929, 0x9356},
{0x592A, 0x91BE},
{0x592B, 0x9576},
{0x592C, 0x9AED},
{0x592D, 0x9AEE},
{0x592E, 0x899B},
{0x5931, 0x8EB8},
{0x5932, 0x9AEF},
{0x5937, 0x88CE},
{0x5938, 0x9AF0},
{0x593E, 0x9AF1},
{0x5944, 0x8982},
{0x5947, 0x8AEF},
{0x5948, 0x93DE},
{0x5949, 0x95F2},
{0x594E, 0x9AF5},
{0x594F, 0x9174},
{0x5950, 0x9AF4},
{0x5951, 0x8C5F},
{0x5953, 0xFAA0},
{0x5954, 0x967A},
{0x5955, 0x9AF3},
{0x5957, 0x9385},
{0x5958, 0x9AF7},
{0x595A, 0x9AF6},
{0x595B, 0xFAA1},
{0x595D, 0xFAA2},
{0x5960, 0x9AF9},
{0x5962, 0x9AF8},
{0x5963, 0xFAA3},
{0x5965, 0x899C},
{0x5967, 0x9AFA},
{0x5968, 0x8FA7},
{0x5969, 0x9AFC},
{0x596A, 0x9244},
{0x596C, 0x9AFB},
{0x596E, 0x95B1},
{0x5973, 0x8F97},
{0x5974, 0x937A},
{0x5978, 0x9B40},
{0x597D, 0x8D44},
{0x5981, 0x9B41},
{0x5982, 0x9440},
{0x5983, 0x94DC},
{0x5984, 0x96CF},
{0x598A, 0x9444},
{0x598D, 0x9B4A},
{0x5993, 0x8B57},
{0x5996, 0x9764},
{0x5999, 0x96AD},
{0x599B, 0x9BAA},
{0x599D, 0x9B42},
{0x59A3, 0x9B45},
{0x59A4, 0xFAA4},
{0x59A5, 0x91C3},
{0x59A8, 0x9657},
{0x59AC, 0x9369},
{0x59B2, 0x9B46},
{0x59B9, 0x9685},
{0x59BA, 0xFAA5},
{0x59BB, 0x8DC8},
{0x59BE, 0x8FA8},
{0x59C6, 0x9B47},
{0x59C9, 0x8E6F},
{0x59CB, 0x8E6E},
{0x59D0, 0x88B7},
{0x59D1, 0x8CC6},
{0x59D3, 0x90A9},
{0x59D4, 0x88CF},
{0x59D9, 0x9B4B},
{0x59DA, 0x9B4C},
{0x59DC, 0x9B49},
{0x59E5, 0x8957},
{0x59E6, 0x8AAD},
{0x59E8, 0x9B48},
{0x59EA, 0x96C3},
{0x59EB, 0x9550},
{0x59F6, 0x88A6},
{0x59FB, 0x88F7},
{0x59FF, 0x8E70},
{0x5A01, 0x88D0},
{0x5A03, 0x88A1},
{0x5A09, 0x9B51},
{0x5A11, 0x9B4F},
{0x5A18, 0x96BA},
{0x5A1A, 0x9B52},
{0x5A1C, 0x9B50},
{0x5A1F, 0x9B4E},
{0x5A20, 0x9050},
{0x5A25, 0x9B4D},
{0x5A29, 0x95D8},
{0x5A2F, 0x8CE2},
{0x5A35, 0x9B56},
{0x5A36, 0x9B57},
{0x5A3C, 0x8FA9},
{0x5A40, 0x9B53},
{0x5A41, 0x984B},
{0x5A46, 0x946B},
{0x5A49, 0x9B55},
{0x5A5A, 0x8DA5},
{0x5A62, 0x9B58},
{0x5A66, 0x9577},
{0x5A6A, 0x9B59},
{0x5A6C, 0x9B54},
{0x5A7F, 0x96B9},
{0x5A92, 0x947D},
{0x5A9A, 0x9B5A},
{0x5A9B, 0x9551},
{0x5ABC, 0x9B5B},
{0x5ABD, 0x9B5F},
{0x5ABE, 0x9B5C},
{0x5AC1, 0x89C5},
{0x5AC2, 0x9B5E},
{0x5AC9, 0x8EB9},
{0x5ACB, 0x9B5D},
{0x5ACC, 0x8C99},
{0x5AD0, 0x9B6B},
{0x5AD6, 0x9B64},
{0x5AD7, 0x9B61},
{0x5AE1, 0x9284},
{0x5AE3, 0x9B60},
{0x5AE6, 0x9B62},
{0x5AE9, 0x9B63},
{0x5AFA, 0x9B65},
{0x5AFB, 0x9B66},
{0x5B09, 0x8AF0},
{0x5B0B, 0x9B68},
{0x5B0C, 0x9B67},
{0x5B16, 0x9B69},
{0x5B22, 0x8FEC},
{0x5B2A, 0x9B6C},
{0x5B2C, 0x92DA},
{0x5B30, 0x8964},
{0x5B32, 0x9B6A},
{0x5B36, 0x9B6D},
{0x5B3E, 0x9B6E},
{0x5B40, 0x9B71},
{0x5B43, 0x9B6F},
{0x5B45, 0x9B70},
{0x5B50, 0x8E71},
{0x5B51, 0x9B72},
{0x5B54, 0x8D45},
{0x5B55, 0x9B73},
{0x5B56, 0xFAA6},
{0x5B57, 0x8E9A},
{0x5B58, 0x91B6},
{0x5B5A, 0x9B74},
{0x5B5B, 0x9B75},
{0x5B5C, 0x8E79},
{0x5B5D, 0x8D46},
{0x5B5F, 0x96D0},
{0x5B63, 0x8B47},
{0x5B64, 0x8CC7},
{0x5B65, 0x9B76},
{0x5B66, 0x8A77},
{0x5B69, 0x9B77},
{0x5B6B, 0x91B7},
{0x5B70, 0x9B78},
{0x5B71, 0x9BA1},
{0x5B73, 0x9B79},
{0x5B75, 0x9B7A},
{0x5B78, 0x9B7B},
{0x5B7A, 0x9B7D},
{0x5B80, 0x9B7E},
{0x5B83, 0x9B80},
{0x5B85, 0x91EE},
{0x5B87, 0x8946},
{0x5B88, 0x8EE7},
{0x5B89, 0x88C0},
{0x5B8B, 0x9176},
{0x5B8C, 0x8AAE},
{0x5B8D, 0x8EB3},
{0x5B8F, 0x8D47},
{0x5B95, 0x9386},
{0x5B97, 0x8F40},
{0x5B98, 0x8AAF},
{0x5B99, 0x9288},
{0x5B9A, 0x92E8},
{0x5B9B, 0x88B6},
{0x5B9C, 0x8B58},
{0x5B9D, 0x95F3},
{0x5B9F, 0x8EC0},
{0x5BA2, 0x8B71},
{0x5BA3, 0x90E9},
{0x5BA4, 0x8EBA},
{0x5BA5, 0x9747},
{0x5BA6, 0x9B81},
{0x5BAE, 0x8B7B},
{0x5BB0, 0x8DC9},
{0x5BB3, 0x8A51},
{0x5BB4, 0x8983},
{0x5BB5, 0x8FAA},
{0x5BB6, 0x89C6},
{0x5BB8, 0x9B82},
{0x5BB9, 0x9765},
{0x5BBF, 0x8F68},
{0x5BC0, 0xFAA7},
{0x5BC2, 0x8EE2},
{0x5BC3, 0x9B83},
{0x5BC4, 0x8AF1},
{0x5BC5, 0x93D0},
{0x5BC6, 0x96A7},
{0x5BC7, 0x9B84},
{0x5BC9, 0x9B85},
{0x5BCC, 0x9578},
{0x5BD0, 0x9B87},
{0x5BD2, 0x8AA6},
{0x5BD3, 0x8BF5},
{0x5BD4, 0x9B86},
{0x5BD8, 0xFAA9},
{0x5BDB, 0x8AB0},
{0x5BDD, 0x9051},
{0x5BDE, 0x9B8B},
{0x5BDF, 0x8E40},
{0x5BE1, 0x89C7},
{0x5BE2, 0x9B8A},
{0x5BE4, 0x9B88},
{0x5BE5, 0x9B8C},
{0x5BE6, 0x9B89},
{0x5BE7, 0x944A},
{0x5BE8, 0x9ECB},
{0x5BE9, 0x9052},
{0x5BEB, 0x9B8D},
{0x5BEC, 0xFAAA},
{0x5BEE, 0x97BE},
{0x5BF0, 0x9B8E},
{0x5BF3, 0x9B90},
{0x5BF5, 0x929E},
{0x5BF6, 0x9B8F},
{0x5BF8, 0x90A1},
{0x5BFA, 0x8E9B},
{0x5BFE, 0x91CE},
{0x5BFF, 0x8EF5},
{0x5C01, 0x9595},
{0x5C02, 0x90EA},
{0x5C04, 0x8ECB},
{0x5C05, 0x9B91},
{0x5C06, 0x8FAB},
{0x5C07, 0x9B92},
{0x5C08, 0x9B93},
{0x5C09, 0x88D1},
{0x5C0A, 0x91B8},
{0x5C0B, 0x9071},
{0x5C0D, 0x9B94},
{0x5C0E, 0x93B1},
{0x5C0F, 0x8FAC},
{0x5C11, 0x8FAD},
{0x5C13, 0x9B95},
{0x5C16, 0x90EB},
{0x5C1A, 0x8FAE},
{0x5C1E, 0xFAAB},
{0x5C20, 0x9B96},
{0x5C22, 0x9B97},
{0x5C24, 0x96DE},
{0x5C28, 0x9B98},
{0x5C2D, 0x8BC4},
{0x5C31, 0x8F41},
{0x5C38, 0x9B99},
{0x5C39, 0x9B9A},
{0x5C3A, 0x8EDA},
{0x5C3B, 0x904B},
{0x5C3C, 0x93F2},
{0x5C3D, 0x9073},
{0x5C3E, 0x94F6},
{0x5C3F, 0x9441},
{0x5C40, 0x8BC7},
{0x5C41, 0x9B9B},
{0x5C45, 0x8B8F},
{0x5C46, 0x9B9C},
{0x5C48, 0x8BFC},
{0x5C4A, 0x93CD},
{0x5C4B, 0x89AE},
{0x5C4D, 0x8E72},
{0x5C4E, 0x9B9D},
{0x5C4F, 0x9BA0},
{0x5C50, 0x9B9F},
{0x5C51, 0x8BFB},
{0x5C53, 0x9B9E},
{0x5C55, 0x9357},
{0x5C5E, 0x91AE},
{0x5C60, 0x936A},
{0x5C61, 0x8EC6},
{0x5C64, 0x9177},
{0x5C65, 0x979A},
{0x5C6C, 0x9BA2},
{0x5C6E, 0x9BA3},
{0x5C6F, 0x93D4},
{0x5C71, 0x8E52},
{0x5C76, 0x9BA5},
{0x5C79, 0x9BA6},
{0x5C8C, 0x9BA7},
{0x5C90, 0x8AF2},
{0x5C91, 0x9BA8},
{0x5C94, 0x9BA9},
{0x5CA1, 0x89AA},
{0x5CA6, 0xFAAC},
{0x5CA8, 0x915A},
{0x5CA9, 0x8AE2},
{0x5CAB, 0x9BAB},
{0x5CAC, 0x96A6},
{0x5CB1, 0x91D0},
{0x5CB3, 0x8A78},
{0x5CB6, 0x9BAD},
{0x5CB7, 0x9BAF},
{0x5CB8, 0x8ADD},
{0x5CBA, 0xFAAD},
{0x5CBB, 0x9BAC},
{0x5CBC, 0x9BAE},
{0x5CBE, 0x9BB1},
{0x5CC5, 0x9BB0},
{0x5CC7, 0x9BB2},
{0x5CD9, 0x9BB3},
{0x5CE0, 0x93BB},
{0x5CE1, 0x8BAC},
{0x5CE8, 0x89E3},
{0x5CE9, 0x9BB4},
{0x5CEA, 0x9BB9},
{0x5CED, 0x9BB7},
{0x5CEF, 0x95F5},
{0x5CF0, 0x95F4},
{0x5CF5, 0xFAAE},
{0x5CF6, 0x9387},
{0x5CFA, 0x9BB6},
{0x5CFB, 0x8F73},
{0x5CFD, 0x9BB5},
{0x5D07, 0x9092},
{0x5D0B, 0x9BBA},
{0x5D0E, 0x8DE8},
{0x5D11, 0x9BC0},
{0x5D14, 0x9BC1},
{0x5D15, 0x9BBB},
{0x5D16, 0x8A52},
{0x5D17, 0x9BBC},
{0x5D18, 0x9BC5},
{0x5D19, 0x9BC4},
{0x5D1A, 0x9BC3},
{0x5D1B, 0x9BBF},
{0x5D1F, 0x9BBE},
{0x5D22, 0x9BC2},
{0x5D27, 0xFAAF},
{0x5D29, 0x95F6},
{0x5D42, 0xFAB2},
{0x5D4B, 0x9BC9},
{0x5D4C, 0x9BC6},
{0x5D4E, 0x9BC8},
{0x5D50, 0x9792},
{0x5D52, 0x9BC7},
{0x5D53, 0xFAB0},
{0x5D5C, 0x9BBD},
{0x5D69, 0x9093},
{0x5D6C, 0x9BCA},
{0x5D6D, 0xFAB3},
{0x5D6F, 0x8DB5},
{0x5D73, 0x9BCB},
{0x5D76, 0x9BCC},
{0x5D82, 0x9BCF},
{0x5D84, 0x9BCE},
{0x5D87, 0x9BCD},
{0x5D8B, 0x9388},
{0x5D8C, 0x9BB8},
{0x5D90, 0x9BD5},
{0x5D9D, 0x9BD1},
{0x5DA2, 0x9BD0},
{0x5DAC, 0x9BD2},
{0x5DAE, 0x9BD3},
{0x5DB7, 0x9BD6},
{0x5DB8, 0xFAB4},
{0x5DB9, 0xFAB5},
{0x5DBA, 0x97E4},
{0x5DBC, 0x9BD7},
{0x5DBD, 0x9BD4},
{0x5DC9, 0x9BD8},
{0x5DCC, 0x8ADE},
{0x5DCD, 0x9BD9},
{0x5DD0, 0xFAB6},
{0x5DD2, 0x9BDB},
{0x5DD3, 0x9BDA},
{0x5DD6, 0x9BDC},
{0x5DDB, 0x9BDD},
{0x5DDD, 0x90EC},
{0x5DDE, 0x8F42},
{0x5DE1, 0x8F84},
{0x5DE3, 0x9183},
{0x5DE5, 0x8D48},
{0x5DE6, 0x8DB6},
{0x5DE7, 0x8D49},
{0x5DE8, 0x8B90},
{0x5DEB, 0x9BDE},
{0x5DEE, 0x8DB7},
{0x5DF1, 0x8CC8},
{0x5DF2, 0x9BDF},
{0x5DF3, 0x96A4},
{0x5DF4, 0x9462},
{0x5DF5, 0x9BE0},
{0x5DF7, 0x8D4A},
{0x5DFB, 0x8AAA},
{0x5DFD, 0x9246},
{0x5DFE, 0x8BD0},
{0x5E02, 0x8E73},
{0x5E03, 0x957A},
{0x5E06, 0x94BF},
{0x5E0B, 0x9BE1},
{0x5E0C, 0x8AF3},
{0x5E11, 0x9BE4},
{0x5E16, 0x929F},
{0x5E19, 0x9BE3},
{0x5E1A, 0x9BE2},
{0x5E1B, 0x9BE5},
{0x5E1D, 0x92E9},
{0x5E25, 0x9083},
{0x5E2B, 0x8E74},
{0x5E2D, 0x90C8},
{0x5E2F, 0x91D1},
{0x5E30, 0x8B41},
{0x5E33, 0x92A0},
{0x5E36, 0x9BE6},
{0x5E37, 0x9BE7},
{0x5E38, 0x8FED},
{0x5E3D, 0x9658},
{0x5E40, 0x9BEA},
{0x5E43, 0x9BE9},
{0x5E44, 0x9BE8},
{0x5E45, 0x959D},
{0x5E47, 0x9BF1},
{0x5E4C, 0x9679},
{0x5E4E, 0x9BEB},
{0x5E54, 0x9BED},
{0x5E55, 0x968B},
{0x5E57, 0x9BEC},
{0x5E5F, 0x9BEE},
{0x5E61, 0x94A6},
{0x5E62, 0x9BEF},
{0x5E63, 0x95BC},
{0x5E64, 0x9BF0},
{0x5E72, 0x8AB1},
{0x5E73, 0x95BD},
{0x5E74, 0x944E},
{0x5E75, 0x9BF2},
{0x5E76, 0x9BF3},
{0x5E78, 0x8D4B},
{0x5E79, 0x8AB2},
{0x5E7A, 0x9BF4},
{0x5E7B, 0x8CB6},
{0x5E7C, 0x9763},
{0x5E7D, 0x9748},
{0x5E7E, 0x8AF4},
{0x5E7F, 0x9BF6},
{0x5E81, 0x92A1},
{0x5E83, 0x8D4C},
{0x5E84, 0x8FAF},
{0x5E87, 0x94DD},
{0x5E8A, 0x8FB0},
{0x5E8F, 0x8F98},
{0x5E95, 0x92EA},
{0x5E96, 0x95F7},
{0x5E97, 0x9358},
{0x5E9A, 0x8D4D},
{0x5E9C, 0x957B},
{0x5EA0, 0x9BF7},
{0x5EA6, 0x9378},
{0x5EA7, 0x8DC0},
{0x5EAB, 0x8CC9},
{0x5EAD, 0x92EB},
{0x5EB5, 0x88C1},
{0x5EB6, 0x8F8E},
{0x5EB7, 0x8D4E},
{0x5EB8, 0x9766},
{0x5EC1, 0x9BF8},
{0x5EC2, 0x9BF9},
{0x5EC3, 0x9470},
{0x5EC8, 0x9BFA},
{0x5EC9, 0x97F5},
{0x5ECA, 0x984C},
{0x5ECF, 0x9BFC},
{0x5ED0, 0x9BFB},
{0x5ED3, 0x8A66},
{0x5ED6, 0x9C40},
{0x5EDA, 0x9C43},
{0x5EDB, 0x9C44},
{0x5EDD, 0x9C42},
{0x5EDF, 0x955F},
{0x5EE0, 0x8FB1},
{0x5EE1, 0x9C46},
{0x5EE2, 0x9C45},
{0x5EE3, 0x9C41},
{0x5EE8, 0x9C47},
{0x5EE9, 0x9C48},
{0x5EEC, 0x9C49},
{0x5EF0, 0x9C4C},
{0x5EF1, 0x9C4A},
{0x5EF3, 0x9C4B},
{0x5EF4, 0x9C4D},
{0x5EF6, 0x8984},
{0x5EF7, 0x92EC},
{0x5EF8, 0x9C4E},
{0x5EFA, 0x8C9A},
{0x5EFB, 0x89F4},
{0x5EFC, 0x9455},
{0x5EFE, 0x9C4F},
{0x5EFF, 0x93F9},
{0x5F01, 0x95D9},
{0x5F03, 0x9C50},
{0x5F04, 0x984D},
{0x5F09, 0x9C51},
{0x5F0A, 0x95BE},
{0x5F0B, 0x9C54},
{0x5F0C, 0x989F},
{0x5F0D, 0x98AF},
{0x5F0F, 0x8EAE},
{0x5F10, 0x93F3},
{0x5F11, 0x9C55},
{0x5F13, 0x8B7C},
{0x5F14, 0x92A2},
{0x5F15, 0x88F8},
{0x5F16, 0x9C56},
{0x5F17, 0x95A4},
{0x5F18, 0x8D4F},
{0x5F1B, 0x926F},
{0x5F1F, 0x92ED},
{0x5F21, 0xFAB7},
{0x5F25, 0x96ED},
{0x5F26, 0x8CB7},
{0x5F27, 0x8CCA},
{0x5F29, 0x9C57},
{0x5F2D, 0x9C58},
{0x5F2F, 0x9C5E},
{0x5F31, 0x8EE3},
{0x5F34, 0xFAB8},
{0x5F35, 0x92A3},
{0x5F37, 0x8BAD},
{0x5F38, 0x9C59},
{0x5F3C, 0x954A},
{0x5F3E, 0x9265},
{0x5F41, 0x9C5A},
{0x5F45, 0xFA67},
{0x5F48, 0x9C5B},
{0x5F4A, 0x8BAE},
{0x5F4C, 0x9C5C},
{0x5F4E, 0x9C5D},
{0x5F51, 0x9C5F},
{0x5F53, 0x9396},
{0x5F56, 0x9C60},
{0x5F57, 0x9C61},
{0x5F59, 0x9C62},
{0x5F5C, 0x9C53},
{0x5F5D, 0x9C52},
{0x5F61, 0x9C63},
{0x5F62, 0x8C60},
{0x5F66, 0x9546},
{0x5F67, 0xFAB9},
{0x5F69, 0x8DCA},
{0x5F6A, 0x9556},
{0x5F6B, 0x92A4},
{0x5F6C, 0x956A},
{0x5F6D, 0x9C64},
{0x5F70, 0x8FB2},
{0x5F71, 0x8965},
{0x5F73, 0x9C65},
{0x5F77, 0x9C66},
{0x5F79, 0x96F0},
{0x5F7C, 0x94DE},
{0x5F7F, 0x9C69},
{0x5F80, 0x899D},
{0x5F81, 0x90AA},
{0x5F82, 0x9C68},
{0x5F83, 0x9C67},
{0x5F84, 0x8C61},
{0x5F85, 0x91D2},
{0x5F87, 0x9C6D},
{0x5F88, 0x9C6B},
{0x5F8A, 0x9C6A},
{0x5F8B, 0x97A5},
{0x5F8C, 0x8CE3},
{0x5F90, 0x8F99},
{0x5F91, 0x9C6C},
{0x5F92, 0x936B},
{0x5F93, 0x8F5D},
{0x5F97, 0x93BE},
{0x5F98, 0x9C70},
{0x5F99, 0x9C6F},
{0x5F9E, 0x9C6E},
{0x5FA0, 0x9C71},
{0x5FA1, 0x8CE4},
{0x5FA8, 0x9C72},
{0x5FA9, 0x959C},
{0x5FAA, 0x8F7A},
{0x5FAD, 0x9C73},
{0x5FAE, 0x94F7},
{0x5FB3, 0x93BF},
{0x5FB4, 0x92A5},
{0x5FB7, 0xFABA},
{0x5FB9, 0x934F},
{0x5FBC, 0x9C74},
{0x5FBD, 0x8B4A},
{0x5FC3, 0x9053},
{0x5FC5, 0x954B},
{0x5FCC, 0x8AF5},
{0x5FCD, 0x9445},
{0x5FD6, 0x9C75},
{0x5FD7, 0x8E75},
{0x5FD8, 0x9659},
{0x5FD9, 0x965A},
{0x5FDC, 0x899E},
{0x5FDD, 0x9C7A},
{0x5FDE, 0xFABB},
{0x5FE0, 0x9289},
{0x5FE4, 0x9C77},
{0x5FEB, 0x89F5},
{0x5FF0, 0x9CAB},
{0x5FF1, 0x9C79},
{0x5FF5, 0x944F},
{0x5FF8, 0x9C78},
{0x5FFB, 0x9C76},
{0x5FFD, 0x8D9A},
{0x5FFF, 0x9C7C},
{0x600E, 0x9C83},
{0x600F, 0x9C89},
{0x6010, 0x9C81},
{0x6012, 0x937B},
{0x6015, 0x9C86},
{0x6016, 0x957C},
{0x6019, 0x9C80},
{0x601B, 0x9C85},
{0x601C, 0x97E5},
{0x601D, 0x8E76},
{0x6020, 0x91D3},
{0x6021, 0x9C7D},
{0x6025, 0x8B7D},
{0x6026, 0x9C88},
{0x6027, 0x90AB},
{0x6028, 0x8985},
{0x6029, 0x9C82},
{0x602A, 0x89F6},
{0x602B, 0x9C87},
{0x602F, 0x8BAF},
{0x6031, 0x9C84},
{0x603A, 0x9C8A},
{0x6041, 0x9C8C},
{0x6042, 0x9C96},
{0x6043, 0x9C94},
{0x6046, 0x9C91},
{0x604A, 0x9C90},
{0x604B, 0x97F6},
{0x604D, 0x9C92},
{0x6050, 0x8BB0},
{0x6052, 0x8D50},
{0x6055, 0x8F9A},
{0x6059, 0x9C99},
{0x605A, 0x9C8B},
{0x605D, 0xFABC},
{0x605F, 0x9C8F},
{0x6060, 0x9C7E},
{0x6062, 0x89F8},
{0x6063, 0x9C93},
{0x6064, 0x9C95},
{0x6065, 0x9270},
{0x6068, 0x8DA6},
{0x6069, 0x89B6},
{0x606A, 0x9C8D},
{0x606B, 0x9C98},
{0x606C, 0x9C97},
{0x606D, 0x8BB1},
{0x606F, 0x91A7},
{0x6070, 0x8A86},
{0x6075, 0x8C62},
{0x6077, 0x9C8E},
{0x6081, 0x9C9A},
{0x6083, 0x9C9D},
{0x6084, 0x9C9F},
{0x6085, 0xFABD},
{0x6089, 0x8EBB},
{0x608A, 0xFABE},
{0x608B, 0x9CA5},
{0x608C, 0x92EE},
{0x608D, 0x9C9B},
{0x6092, 0x9CA3},
{0x6094, 0x89F7},
{0x6096, 0x9CA1},
{0x6097, 0x9CA2},
{0x609A, 0x9C9E},
{0x609B, 0x9CA0},
{0x609F, 0x8CE5},
{0x60A0, 0x9749},
{0x60A3, 0x8AB3},
{0x60A6, 0x8978},
{0x60A7, 0x9CA4},
{0x60A9, 0x9459},
{0x60AA, 0x88AB},
{0x60B2, 0x94DF},
{0x60B3, 0x9C7B},
{0x60B4, 0x9CAA},
{0x60B5, 0x9CAE},
{0x60B6, 0x96E3},
{0x60B8, 0x9CA7},
{0x60BC, 0x9389},
{0x60BD, 0x9CAC},
{0x60C5, 0x8FEE},
{0x60C6, 0x9CAD},
{0x60C7, 0x93D5},
{0x60D1, 0x9866},
{0x60D3, 0x9CA9},
{0x60D5, 0xFAC0},
{0x60D8, 0x9CAF},
{0x60DA, 0x8D9B},
{0x60DC, 0x90C9},
{0x60DE, 0xFABF},
{0x60DF, 0x88D2},
{0x60E0, 0x9CA8},
{0x60E1, 0x9CA6},
{0x60E3, 0x9179},
{0x60E7, 0x9C9C},
{0x60E8, 0x8E53},
{0x60F0, 0x91C4},
{0x60F1, 0x9CBB},
{0x60F2, 0xFAC2},
{0x60F3, 0x917A},
{0x60F4, 0x9CB6},
{0x60F6, 0x9CB3},
{0x60F7, 0x9CB4},
{0x60F9, 0x8EE4},
{0x60FA, 0x9CB7},
{0x60FB, 0x9CBA},
{0x6100, 0x9CB5},
{0x6101, 0x8F44},
{0x6103, 0x9CB8},
{0x6106, 0x9CB2},
{0x6108, 0x96FA},
{0x6109, 0x96F9},
{0x610D, 0x9CBC},
{0x610E, 0x9CBD},
{0x610F, 0x88D3},
{0x6111, 0xFAC3},
{0x6115, 0x9CB1},
{0x611A, 0x8BF0},
{0x611B, 0x88A4},
{0x611F, 0x8AB4},
{0x6120, 0xFAC1},
{0x6121, 0x9CB9},
{0x6127, 0x9CC1},
{0x6128, 0x9CC0},
{0x612C, 0x9CC5},
{0x6130, 0xFAC5},
{0x6134, 0x9CC6},
{0x6137, 0xFAC4},
{0x613C, 0x9CC4},
{0x613D, 0x9CC7},
{0x613E, 0x9CBF},
{0x613F, 0x9CC3},
{0x6142, 0x9CC8},
{0x6144, 0x9CC9},
{0x6147, 0x9CBE},
{0x6148, 0x8E9C},
{0x614A, 0x9CC2},
{0x614B, 0x91D4},
{0x614C, 0x8D51},
{0x614D, 0x9CB0},
{0x614E, 0x9054},
{0x6153, 0x9CD6},
{0x6155, 0x95E7},
{0x6158, 0x9CCC},
{0x6159, 0x9CCD},
{0x615A, 0x9CCE},
{0x615D, 0x9CD5},
{0x615F, 0x9CD4},
{0x6162, 0x969D},
{0x6163, 0x8AB5},
{0x6165, 0x9CD2},
{0x6167, 0x8C64},
{0x6168, 0x8A53},
{0x616B, 0x9CCF},
{0x616E, 0x97B6},
{0x616F, 0x9CD1},
{0x6170, 0x88D4},
{0x6171, 0x9CD3},
{0x6173, 0x9CCA},
{0x6174, 0x9CD0},
{0x6175, 0x9CD7},
{0x6176, 0x8C63},
{0x6177, 0x9CCB},
{0x617E, 0x977C},
{0x6182, 0x974A},
{0x6187, 0x9CDA},
{0x618A, 0x9CDE},
{0x618E, 0x919E},
{0x6190, 0x97F7},
{0x6191, 0x9CDF},
{0x6194, 0x9CDC},
{0x6196, 0x9CD9},
{0x6198, 0xFAC6},
{0x6199, 0x9CD8},
{0x619A, 0x9CDD},
{0x61A4, 0x95AE},
{0x61A7, 0x93B2},
{0x61A9, 0x8C65},
{0x61AB, 0x9CE0},
{0x61AC, 0x9CDB},
{0x61AE, 0x9CE1},
{0x61B2, 0x8C9B},
{0x61B6, 0x89AF},
{0x61BA, 0x9CE9},
{0x61BE, 0x8AB6},
{0x61C3, 0x9CE7},
{0x61C6, 0x9CE8},
{0x61C7, 0x8DA7},
{0x61C8, 0x9CE6},
{0x61C9, 0x9CE4},
{0x61CA, 0x9CE3},
{0x61CB, 0x9CEA},
{0x61CC, 0x9CE2},
{0x61CD, 0x9CEC},
{0x61D0, 0x89F9},
{0x61E3, 0x9CEE},
{0x61E6, 0x9CED},
{0x61F2, 0x92A6},
{0x61F4, 0x9CF1},
{0x61F6, 0x9CEF},
{0x61F7, 0x9CE5},
{0x61F8, 0x8C9C},
{0x61FA, 0x9CF0},
{0x61FC, 0x9CF4},
{0x61FD, 0x9CF3},
{0x61FE, 0x9CF5},
{0x61FF, 0x9CF2},
{0x6200, 0x9CF6},
{0x6208, 0x9CF7},
{0x6209, 0x9CF8},
{0x620A, 0x95E8},
{0x620C, 0x9CFA},
{0x620D, 0x9CF9},
{0x620E, 0x8F5E},
{0x6210, 0x90AC},
{0x6211, 0x89E4},
{0x6212, 0x89FA},
{0x6213, 0xFAC7},
{0x6214, 0x9CFB},
{0x6216, 0x88BD},
{0x621A, 0x90CA},
{0x621B, 0x9CFC},
{0x621D, 0xE6C1},
{0x621E, 0x9D40},
{0x621F, 0x8C81},
{0x6221, 0x9D41},
{0x6226, 0x90ED},
{0x622A, 0x9D42},
{0x622E, 0x9D43},
{0x622F, 0x8B59},
{0x6230, 0x9D44},
{0x6232, 0x9D45},
{0x6233, 0x9D46},
{0x6234, 0x91D5},
{0x6238, 0x8CCB},
{0x623B, 0x96DF},
{0x623F, 0x965B},
{0x6240, 0x8F8A},
{0x6241, 0x9D47},
{0x6247, 0x90EE},
{0x6248, 0xE7BB},
{0x6249, 0x94E0},
{0x624B, 0x8EE8},
{0x624D, 0x8DCB},
{0x624E, 0x9D48},
{0x6253, 0x91C5},
{0x6255, 0x95A5},
{0x6258, 0x91EF},
{0x625B, 0x9D4B},
{0x625E, 0x9D49},
{0x6260, 0x9D4C},
{0x6263, 0x9D4A},
{0x6268, 0x9D4D},
{0x626E, 0x95AF},
{0x6271, 0x88B5},
{0x6276, 0x957D},
{0x6279, 0x94E1},
{0x627C, 0x9D4E},
{0x627E, 0x9D51},
{0x627F, 0x8FB3},
{0x6280, 0x8B5A},
{0x6282, 0x9D4F},
{0x6283, 0x9D56},
{0x6284, 0x8FB4},
{0x6289, 0x9D50},
{0x628A, 0x9463},
{0x6291, 0x977D},
{0x6292, 0x9D52},
{0x6293, 0x9D53},
{0x6294, 0x9D57},
{0x6295, 0x938A},
{0x6296, 0x9D54},
{0x6297, 0x8D52},
{0x6298, 0x90DC},
{0x629B, 0x9D65},
{0x629C, 0x94B2},
{0x629E, 0x91F0},
{0x62A6, 0xFAC8},
{0x62AB, 0x94E2},
{0x62AC, 0x9DAB},
{0x62B1, 0x95F8},
{0x62B5, 0x92EF},
{0x62B9, 0x9695},
{0x62BB, 0x9D5A},
{0x62BC, 0x899F},
{0x62BD, 0x928A},
{0x62C2, 0x9D63},
{0x62C5, 0x9253},
{0x62C6, 0x9D5D},
{0x62C7, 0x9D64},
{0x62C8, 0x9D5F},
{0x62C9, 0x9D66},
{0x62CA, 0x9D62},
{0x62CC, 0x9D61},
{0x62CD, 0x948F},
{0x62CF, 0x9D5B},
{0x62D0, 0x89FB},
{0x62D1, 0x9D59},
{0x62D2, 0x8B91},
{0x62D3, 0x91F1},
{0x62D4, 0x9D55},
{0x62D7, 0x9D58},
{0x62D8, 0x8D53},
{0x62D9, 0x90D9},
{0x62DB, 0x8FB5},
{0x62DC, 0x9D60},
{0x62DD, 0x9471},
{0x62E0, 0x8B92},
{0x62E1, 0x8A67},
{0x62EC, 0x8A87},
{0x62ED, 0x9040},
{0x62EE, 0x9D68},
{0x62EF, 0x9D6D},
{0x62F1, 0x9D69},
{0x62F3, 0x8C9D},
{0x62F5, 0x9D6E},
{0x62F6, 0x8E41},
{0x62F7, 0x8D89},
{0x62FE, 0x8F45},
{0x62FF, 0x9D5C},
{0x6301, 0x8E9D},
{0x6302, 0x9D6B},
{0x6307, 0x8E77},
{0x6308, 0x9D6C},
{0x6309, 0x88C2},
{0x630C, 0x9D67},
{0x6311, 0x92A7},
{0x6319, 0x8B93},
{0x631F, 0x8BB2},
{0x6327, 0x9D6A},
{0x6328, 0x88A5},
{0x632B, 0x8DC1},
{0x632F, 0x9055},
{0x633A, 0x92F0},
{0x633D, 0x94D2},
{0x633E, 0x9D70},
{0x633F, 0x917D},
{0x6349, 0x91A8},
{0x634C, 0x8E4A},
{0x634D, 0x9D71},
{0x634F, 0x9D73},
{0x6350, 0x9D6F},
{0x6355, 0x95DF},
{0x6357, 0x92BB},
{0x635C, 0x917B},
{0x6367, 0x95F9},
{0x6368, 0x8ECC},
{0x6369, 0x9D80},
{0x636B, 0x9D7E},
{0x636E, 0x9098},
{0x6372, 0x8C9E},
{0x6376, 0x9D78},
{0x6377, 0x8FB7},
{0x637A, 0x93E6},
{0x637B, 0x9450},
{0x6380, 0x9D76},
{0x6383, 0x917C},
{0x6388, 0x8EF6},
{0x6389, 0x9D7B},
{0x638C, 0x8FB6},
{0x638E, 0x9D75},
{0x638F, 0x9D7A},
{0x6392, 0x9472},
{0x6396, 0x9D74},
{0x6398, 0x8C40},
{0x639B, 0x8A7C},
{0x639F, 0x9D7C},
{0x63A0, 0x97A9},
{0x63A1, 0x8DCC},
{0x63A2, 0x9254},
{0x63A3, 0x9D79},
{0x63A5, 0x90DA},
{0x63A7, 0x8D54},
{0x63A8, 0x9084},
{0x63A9, 0x8986},
{0x63AA, 0x915B},
{0x63AB, 0x9D77},
{0x63AC, 0x8B64},
{0x63B2, 0x8C66},
{0x63B4, 0x92CD},
{0x63B5, 0x9D7D},
{0x63BB, 0x917E},
{0x63BE, 0x9D81},
{0x63C0, 0x9D83},
{0x63C3, 0x91B5},
{0x63C4, 0x9D89},
{0x63C6, 0x9D84},
{0x63C9, 0x9D86},
{0x63CF, 0x9560},
{0x63D0, 0x92F1},
{0x63D2, 0x9D87},
{0x63D6, 0x974B},
{0x63DA, 0x9767},
{0x63DB, 0x8AB7},
{0x63E1, 0x88AC},
{0x63E3, 0x9D85},
{0x63E9, 0x9D82},
{0x63EE, 0x8AF6},
{0x63F4, 0x8987},
{0x63F5, 0xFAC9},
{0x63F6, 0x9D88},
{0x63FA, 0x9768},
{0x6406, 0x9D8C},
{0x640D, 0x91B9},
{0x640F, 0x9D93},
{0x6413, 0x9D8D},
{0x6416, 0x9D8A},
{0x6417, 0x9D91},
{0x641C, 0x9D72},
{0x6426, 0x9D8E},
{0x6428, 0x9D92},
{0x642C, 0x94C0},
{0x642D, 0x938B},
{0x6434, 0x9D8B},
{0x6436, 0x9D8F},
{0x643A, 0x8C67},
{0x643E, 0x8DEF},
{0x6442, 0x90DB},
{0x644E, 0x9D97},
{0x6458, 0x9345},
{0x6460, 0xFACA},
{0x6467, 0x9D94},
{0x6469, 0x9680},
{0x646F, 0x9D95},
{0x6476, 0x9D96},
{0x6478, 0x96CC},
{0x647A, 0x90A0},
{0x6483, 0x8C82},
{0x6488, 0x9D9D},
{0x6492, 0x8E54},
{0x6493, 0x9D9A},
{0x6495, 0x9D99},
{0x649A, 0x9451},
{0x649D, 0xFACB},
{0x649E, 0x93B3},
{0x64A4, 0x9350},
{0x64A5, 0x9D9B},
{0x64A9, 0x9D9C},
{0x64AB, 0x958F},
{0x64AD, 0x9464},
{0x64AE, 0x8E42},
{0x64B0, 0x90EF},
{0x64B2, 0x966F},
{0x64B9, 0x8A68},
{0x64BB, 0x9DA3},
{0x64BC, 0x9D9E},
{0x64C1, 0x9769},
{0x64C2, 0x9DA5},
{0x64C5, 0x9DA1},
{0x64C7, 0x9DA2},
{0x64CD, 0x9180},
{0x64CE, 0xFACC},
{0x64D2, 0x9DA0},
{0x64D4, 0x9D5E},
{0x64D8, 0x9DA4},
{0x64DA, 0x9D9F},
{0x64E0, 0x9DA9},
{0x64E1, 0x9DAA},
{0x64E2, 0x9346},
{0x64E3, 0x9DAC},
{0x64E6, 0x8E43},
{0x64E7, 0x9DA7},
{0x64EC, 0x8B5B},
{0x64EF, 0x9DAD},
{0x64F1, 0x9DA6},
{0x64F2, 0x9DB1},
{0x64F4, 0x9DB0},
{0x64F6, 0x9DAF},
{0x64FA, 0x9DB2},
{0x64FD, 0x9DB4},
{0x64FE, 0x8FEF},
{0x6500, 0x9DB3},
{0x6505, 0x9DB7},
{0x6518, 0x9DB5},
{0x651C, 0x9DB6},
{0x651D, 0x9D90},
{0x6523, 0x9DB9},
{0x6524, 0x9DB8},
{0x652A, 0x9D98},
{0x652B, 0x9DBA},
{0x652C, 0x9DAE},
{0x652F, 0x8E78},
{0x6534, 0x9DBB},
{0x6535, 0x9DBC},
{0x6536, 0x9DBE},
{0x6537, 0x9DBD},
{0x6538, 0x9DBF},
{0x6539, 0x89FC},
{0x653B, 0x8D55},
{0x653E, 0x95FA},
{0x653F, 0x90AD},
{0x6545, 0x8CCC},
{0x6548, 0x9DC1},
{0x654D, 0x9DC4},
{0x654E, 0xFACD},
{0x654F, 0x9571},
{0x6551, 0x8B7E},
{0x6555, 0x9DC3},
{0x6556, 0x9DC2},
{0x6557, 0x9473},
{0x6558, 0x9DC5},
{0x6559, 0x8BB3},
{0x655D, 0x9DC7},
{0x655E, 0x9DC6},
{0x6562, 0x8AB8},
{0x6563, 0x8E55},
{0x6566, 0x93D6},
{0x656C, 0x8C68},
{0x6570, 0x9094},
{0x6572, 0x9DC8},
{0x6574, 0x90AE},
{0x6575, 0x9347},
{0x6577, 0x957E},
{0x6578, 0x9DC9},
{0x6582, 0x9DCA},
{0x6583, 0x9DCB},
{0x6587, 0x95B6},
{0x6588, 0x9B7C},
{0x6589, 0x90C4},
{0x658C, 0x956B},
{0x658E, 0x8DD6},
{0x6590, 0x94E3},
{0x6591, 0x94C1},
{0x6597, 0x936C},
{0x6599, 0x97BF},
{0x659B, 0x9DCD},
{0x659C, 0x8ECE},
{0x659F, 0x9DCE},
{0x65A1, 0x88B4},
{0x65A4, 0x8BD2},
{0x65A5, 0x90CB},
{0x65A7, 0x9580},
{0x65AB, 0x9DCF},
{0x65AC, 0x8E61},
{0x65AD, 0x9266},
{0x65AF, 0x8E7A},
{0x65B0, 0x9056},
{0x65B7, 0x9DD0},
{0x65B9, 0x95FB},
{0x65BC, 0x8997},
{0x65BD, 0x8E7B},
{0x65C1, 0x9DD3},
{0x65C3, 0x9DD1},
{0x65C4, 0x9DD4},
{0x65C5, 0x97B7},
{0x65C6, 0x9DD2},
{0x65CB, 0x90F9},
{0x65CC, 0x9DD5},
{0x65CF, 0x91B0},
{0x65D2, 0x9DD6},
{0x65D7, 0x8AF8},
{0x65D9, 0x9DD8},
{0x65DB, 0x9DD7},
{0x65E0, 0x9DD9},
{0x65E1, 0x9DDA},
{0x65E2, 0x8AF9},
{0x65E5, 0x93FA},
{0x65E6, 0x9255},
{0x65E7, 0x8B8C},
{0x65E8, 0x8E7C},
{0x65E9, 0x9181},
{0x65EC, 0x8F7B},
{0x65ED, 0x88AE},
{0x65F1, 0x9DDB},
{0x65FA, 0x89A0},
{0x65FB, 0x9DDF},
{0x6600, 0xFACE},
{0x6602, 0x8D56},
{0x6603, 0x9DDE},
{0x6606, 0x8DA9},
{0x6607, 0x8FB8},
{0x6609, 0xFAD1},
{0x660A, 0x9DDD},
{0x660C, 0x8FB9},
{0x660E, 0x96BE},
{0x660F, 0x8DA8},
{0x6613, 0x88D5},
{0x6614, 0x90CC},
{0x6615, 0xFACF},
{0x661C, 0x9DE4},
{0x661E, 0xFAD3},
{0x661F, 0x90AF},
{0x6620, 0x8966},
{0x6624, 0xFAD4},
{0x6625, 0x8F74},
{0x6627, 0x9686},
{0x6628, 0x8DF0},
{0x662D, 0x8FBA},
{0x662E, 0xFAD2},
{0x662F, 0x90A5},
{0x6631, 0xFA63},
{0x6634, 0x9DE3},
{0x6635, 0x9DE1},
{0x6636, 0x9DE2},
{0x663B, 0xFAD0},
{0x663C, 0x928B},
{0x663F, 0x9E45},
{0x6641, 0x9DE8},
{0x6642, 0x8E9E},
{0x6643, 0x8D57},
{0x6644, 0x9DE6},
{0x6649, 0x9DE7},
{0x664B, 0x9057},
{0x664F, 0x9DE5},
{0x6652, 0x8E4E},
{0x6657, 0xFAD6},
{0x6659, 0xFAD7},
{0x665D, 0x9DEA},
{0x665E, 0x9DE9},
{0x665F, 0x9DEE},
{0x6662, 0x9DEF},
{0x6664, 0x9DEB},
{0x6665, 0xFAD5},
{0x6666, 0x8A41},
{0x6667, 0x9DEC},
{0x6668, 0x9DED},
{0x6669, 0x94D3},
{0x666E, 0x9581},
{0x666F, 0x8C69},
{0x6670, 0x9DF0},
{0x6673, 0xFAD9},
{0x6674, 0x90B0},
{0x6676, 0x8FBB},
{0x667A, 0x9271},
{0x6681, 0x8BC5},
{0x6683, 0x9DF1},
{0x6684, 0x9DF5},
{0x6687, 0x89C9},
{0x6688, 0x9DF2},
{0x6689, 0x9DF4},
{0x668E, 0x9DF3},
{0x6691, 0x8F8B},
{0x6696, 0x9267},
{0x6697, 0x88C3},
{0x6698, 0x9DF6},
{0x6699, 0xFADA},
{0x669D, 0x9DF7},
{0x66A0, 0xFADB},
{0x66A2, 0x92A8},
{0x66A6, 0x97EF},
{0x66AB, 0x8E62},
{0x66AE, 0x95E9},
{0x66B2, 0xFADC},
{0x66B4, 0x965C},
{0x66B8, 0x9E41},
{0x66B9, 0x9DF9},
{0x66BC, 0x9DFC},
{0x66BE, 0x9DFB},
{0x66BF, 0xFADD},
{0x66C1, 0x9DF8},
{0x66C4, 0x9E40},
{0x66C7, 0x93DC},
{0x66C9, 0x9DFA},
{0x66D6, 0x9E42},
{0x66D9, 0x8F8C},
{0x66DA, 0x9E43},
{0x66DC, 0x976A},
{0x66DD, 0x9498},
{0x66E0, 0x9E44},
{0x66E6, 0x9E46},
{0x66E9, 0x9E47},
{0x66F0, 0x9E48},
{0x66F2, 0x8BC8},
{0x66F3, 0x8967},
{0x66F4, 0x8D58},
{0x66F5, 0x9E49},
{0x66F7, 0x9E4A},
{0x66F8, 0x8F91},
{0x66F9, 0x9182},
{0x66FA, 0xFADE},
{0x66FB, 0xFA66},
{0x66FC, 0x99D6},
{0x66FD, 0x915D},
{0x66FE, 0x915C},
{0x66FF, 0x91D6},
{0x6700, 0x8DC5},
{0x6703, 0x98F0},
{0x6708, 0x8C8E},
{0x6709, 0x974C},
{0x670B, 0x95FC},
{0x670D, 0x959E},
{0x670E, 0xFADF},
{0x670F, 0x9E4B},
{0x6714, 0x8DF1},
{0x6715, 0x92BD},
{0x6716, 0x9E4C},
{0x6717, 0x984E},
{0x671B, 0x965D},
{0x671D, 0x92A9},
{0x671E, 0x9E4D},
{0x671F, 0x8AFA},
{0x6726, 0x9E4E},
{0x6727, 0x9E4F},
{0x6728, 0x96D8},
{0x672A, 0x96A2},
{0x672B, 0x9696},
{0x672C, 0x967B},
{0x672D, 0x8E44},
{0x672E, 0x9E51},
{0x6731, 0x8EE9},
{0x6734, 0x9670},
{0x6736, 0x9E53},
{0x6737, 0x9E56},
{0x6738, 0x9E55},
{0x673A, 0x8AF7},
{0x673D, 0x8B80},
{0x673F, 0x9E52},
{0x6741, 0x9E54},
{0x6746, 0x9E57},
{0x6749, 0x9099},
{0x674E, 0x979B},
{0x674F, 0x88C7},
{0x6750, 0x8DDE},
{0x6751, 0x91BA},
{0x6753, 0x8EDB},
{0x6756, 0x8FF1},
{0x6759, 0x9E5A},
{0x675C, 0x936D},
{0x675E, 0x9E58},
{0x675F, 0x91A9},
{0x6760, 0x9E59},
{0x6761, 0x8FF0},
{0x6762, 0x96DB},
{0x6763, 0x9E5B},
{0x6764, 0x9E5C},
{0x6765, 0x9788},
{0x6766, 0xFAE1},
{0x676A, 0x9E61},
{0x676D, 0x8D59},
{0x676F, 0x9474},
{0x6770, 0x9E5E},
{0x6771, 0x938C},
{0x6772, 0x9DDC},
{0x6773, 0x9DE0},
{0x6775, 0x8B6E},
{0x6777, 0x9466},
{0x677C, 0x9E60},
{0x677E, 0x8FBC},
{0x677F, 0x94C2},
{0x6785, 0x9E66},
{0x6787, 0x94F8},
{0x6789, 0x9E5D},
{0x678B, 0x9E63},
{0x678C, 0x9E62},
{0x6790, 0x90CD},
{0x6795, 0x968D},
{0x6797, 0x97D1},
{0x679A, 0x9687},
{0x679C, 0x89CA},
{0x679D, 0x8E7D},
{0x67A0, 0x9867},
{0x67A1, 0x9E65},
{0x67A2, 0x9095},
{0x67A6, 0x9E64},
{0x67A9, 0x9E5F},
{0x67AF, 0x8CCD},
{0x67B3, 0x9E6B},
{0x67B4, 0x9E69},
{0x67B6, 0x89CB},
{0x67B7, 0x9E67},
{0x67B8, 0x9E6D},
{0x67B9, 0x9E73},
{0x67BB, 0xFAE2},
{0x67C0, 0xFAE4},
{0x67C1, 0x91C6},
{0x67C4, 0x95BF},
{0x67C6, 0x9E75},
{0x67CA, 0x9541},
{0x67CE, 0x9E74},
{0x67CF, 0x9490},
{0x67D0, 0x965E},
{0x67D1, 0x8AB9},
{0x67D3, 0x90F5},
{0x67D4, 0x8F5F},
{0x67D8, 0x92D1},
{0x67DA, 0x974D},
{0x67DD, 0x9E70},
{0x67DE, 0x9E6F},
{0x67E2, 0x9E71},
{0x67E4, 0x9E6E},
{0x67E7, 0x9E76},
{0x67E9, 0x9E6C},
{0x67EC, 0x9E6A},
{0x67EE, 0x9E72},
{0x67EF, 0x9E68},
{0x67F1, 0x928C},
{0x67F3, 0x96F6},
{0x67F4, 0x8EC4},
{0x67F5, 0x8DF2},
{0x67FB, 0x8DB8},
{0x67FE, 0x968F},
{0x67FF, 0x8A60},
{0x6801, 0xFAE5},
{0x6802, 0x92CC},
{0x6803, 0x93C8},
{0x6804, 0x8968},
{0x6813, 0x90F0},
{0x6816, 0x90B2},
{0x6817, 0x8C49},
{0x681E, 0x9E78},
{0x6821, 0x8D5A},
{0x6822, 0x8A9C},
{0x6829, 0x9E7A},
{0x682A, 0x8A94},
{0x682B, 0x9E81},
{0x6832, 0x9E7D},
{0x6834, 0x90F1},
{0x6838, 0x8A6A},
{0x6839, 0x8DAA},
{0x683C, 0x8A69},
{0x683D, 0x8DCD},
{0x6840, 0x9E7B},
{0x6841, 0x8C85},
{0x6842, 0x8C6A},
{0x6843, 0x938D},
{0x6844, 0xFAE6},
{0x6846, 0x9E79},
{0x6848, 0x88C4},
{0x684D, 0x9E7C},
{0x684E, 0x9E7E},
{0x6850, 0x8BCB},
{0x6851, 0x8C4B},
{0x6852, 0xFAE3},
{0x6853, 0x8ABA},
{0x6854, 0x8B6A},
{0x6859, 0x9E82},
{0x685C, 0x8DF7},
{0x685D, 0x9691},
{0x685F, 0x8E56},
{0x6863, 0x9E83},
{0x6867, 0x954F},
{0x6874, 0x9E8F},
{0x6876, 0x89B1},
{0x6877, 0x9E84},
{0x687E, 0x9E95},
{0x687F, 0x9E85},
{0x6881, 0x97C0},
{0x6883, 0x9E8C},
{0x6885, 0x947E},
{0x688D, 0x9E94},
{0x688F, 0x9E87},
{0x6893, 0x88B2},
{0x6894, 0x9E89},
{0x6897, 0x8D5B},
{0x689B, 0x9E8B},
{0x689D, 0x9E8A},
{0x689F, 0x9E86},
{0x68A0, 0x9E91},
{0x68A2, 0x8FBD},
{0x68A6, 0x9AEB},
{0x68A7, 0x8CE6},
{0x68A8, 0x979C},
{0x68AD, 0x9E88},
{0x68AF, 0x92F2},
{0x68B0, 0x8A42},
{0x68B1, 0x8DAB},
{0x68B3, 0x9E80},
{0x68B5, 0x9E90},
{0x68B6, 0x8A81},
{0x68B9, 0x9E8E},
{0x68BA, 0x9E92},
{0x68BC, 0x938E},
{0x68C4, 0x8AFC},
{0x68C6, 0x9EB0},
{0x68C8, 0xFA64},
{0x68C9, 0x96C7},
{0x68CA, 0x9E97},
{0x68CB, 0x8AFB},
{0x68CD, 0x9E9E},
{0x68CF, 0xFAE7},
{0x68D2, 0x965F},
{0x68D4, 0x9E9F},
{0x68D5, 0x9EA1},
{0x68D7, 0x9EA5},
{0x68D8, 0x9E99},
{0x68DA, 0x9249},
{0x68DF, 0x938F},
{0x68E0, 0x9EA9},
{0x68E1, 0x9E9C},
{0x68E3, 0x9EA6},
{0x68E7, 0x9EA0},
{0x68EE, 0x9058},
{0x68EF, 0x9EAA},
{0x68F2, 0x90B1},
{0x68F9, 0x9EA8},
{0x68FA, 0x8ABB},
{0x6900, 0x986F},
{0x6901, 0x9E96},
{0x6904, 0x9EA4},
{0x6905, 0x88D6},
{0x6908, 0x9E98},
{0x690B, 0x96B8},
{0x690C, 0x9E9D},
{0x690D, 0x9041},
{0x690E, 0x92C5},
{0x690F, 0x9E93},
{0x6912, 0x9EA3},
{0x6919, 0x909A},
{0x691A, 0x9EAD},
{0x691B, 0x8A91},
{0x691C, 0x8C9F},
{0x6921, 0x9EAF},
{0x6922, 0x9E9A},
{0x6923, 0x9EAE},
{0x6925, 0x9EA7},
{0x6926, 0x9E9B},
{0x6928, 0x9EAB},
{0x692A, 0x9EAC},
{0x6930, 0x9EBD},
{0x6934, 0x93CC},
{0x6936, 0x9EA2},
{0x6939, 0x9EB9},
{0x693D, 0x9EBB},
{0x693F, 0x92D6},
{0x694A, 0x976B},
{0x6953, 0x9596},
{0x6954, 0x9EB6},
{0x6955, 0x91C8},
{0x6959, 0x9EBC},
{0x695A, 0x915E},
{0x695C, 0x9EB3},
{0x695D, 0x9EC0},
{0x695E, 0x9EBF},
{0x6960, 0x93ED},
{0x6961, 0x9EBE},
{0x6962, 0x93E8},
{0x6968, 0xFAE9},
{0x696A, 0x9EC2},
{0x696B, 0x9EB5},
{0x696D, 0x8BC6},
{0x696E, 0x9EB8},
{0x696F, 0x8F7C},
{0x6973, 0x9480},
{0x6974, 0x9EBA},
{0x6975, 0x8BC9},
{0x6977, 0x9EB2},
{0x6978, 0x9EB4},
{0x6979, 0x9EB1},
{0x697C, 0x984F},
{0x697D, 0x8A79},
{0x697E, 0x9EB7},
{0x6981, 0x9EC1},
{0x6982, 0x8A54},
{0x698A, 0x8DE5},
{0x698E, 0x897C},
{0x6991, 0x9ED2},
{0x6994, 0x9850},
{0x6995, 0x9ED5},
{0x6998, 0xFAEB},
{0x699B, 0x9059},
{0x699C, 0x9ED4},
{0x69A0, 0x9ED3},
{0x69A7, 0x9ED0},
{0x69AE, 0x9EC4},
{0x69B1, 0x9EE1},
{0x69B2, 0x9EC3},
{0x69B4, 0x9ED6},
{0x69BB, 0x9ECE},
{0x69BE, 0x9EC9},
{0x69BF, 0x9EC6},
{0x69C1, 0x9EC7},
{0x69C3, 0x9ECF},
{0x69C7, 0xEAA0},
{0x69CA, 0x9ECC},
{0x69CB, 0x8D5C},
{0x69CC, 0x92C6},
{0x69CD, 0x9184},
{0x69CE, 0x9ECA},
{0x69D0, 0x9EC5},
{0x69D3, 0x9EC8},
{0x69D8, 0x976C},
{0x69D9, 0x968A},
{0x69DD, 0x9ECD},
{0x69DE, 0x9ED7},
{0x69E2, 0xFAEC},
{0x69E7, 0x9EDF},
{0x69E8, 0x9ED8},
{0x69EB, 0x9EE5},
{0x69ED, 0x9EE3},
{0x69F2, 0x9EDE},
{0x69F9, 0x9EDD},
{0x69FB, 0x92CE},
{0x69FD, 0x9185},
{0x69FF, 0x9EDB},
{0x6A02, 0x9ED9},
{0x6A05, 0x9EE0},
{0x6A0A, 0x9EE6},
{0x6A0B, 0x94F3},
{0x6A0C, 0x9EEC},
{0x6A12, 0x9EE7},
{0x6A13, 0x9EEA},
{0x6A14, 0x9EE4},
{0x6A17, 0x9294},
{0x6A19, 0x9557},
{0x6A1B, 0x9EDA},
{0x6A1E, 0x9EE2},
{0x6A1F, 0x8FBE},
{0x6A21, 0x96CD},
{0x6A22, 0x9EF6},
{0x6A23, 0x9EE9},
{0x6A29, 0x8CA0},
{0x6A2A, 0x89A1},
{0x6A2B, 0x8A7E},
{0x6A2E, 0x9ED1},
{0x6A30, 0xFAED},
{0x6A35, 0x8FBF},
{0x6A36, 0x9EEE},
{0x6A38, 0x9EF5},
{0x6A39, 0x8EF7},
{0x6A3A, 0x8A92},
{0x6A3D, 0x924D},
{0x6A44, 0x9EEB},
{0x6A46, 0xFAEF},
{0x6A47, 0x9EF0},
{0x6A48, 0x9EF4},
{0x6A4B, 0x8BB4},
{0x6A58, 0x8B6B},
{0x6A59, 0x9EF2},
{0x6A5F, 0x8B40},
{0x6A61, 0x93C9},
{0x6A62, 0x9EF1},
{0x6A66, 0x9EF3},
{0x6A6B, 0xFAEE},
{0x6A72, 0x9EED},
{0x6A73, 0xFAF0},
{0x6A78, 0x9EEF},
{0x6A7E, 0xFAF1},
{0x6A7F, 0x8A80},
{0x6A80, 0x9268},
{0x6A84, 0x9EFA},
{0x6A8D, 0x9EF8},
{0x6A8E, 0x8CE7},
{0x6A90, 0x9EF7},
{0x6A97, 0x9F40},
{0x6A9C, 0x9E77},
{0x6AA0, 0x9EF9},
{0x6AA2, 0x9EFB},
{0x6AA3, 0x9EFC},
{0x6AAA, 0x9F4B},
{0x6AAC, 0x9F47},
{0x6AAE, 0x9E8D},
{0x6AB3, 0x9F46},
{0x6AB8, 0x9F45},
{0x6ABB, 0x9F42},
{0x6AC1, 0x9EE8},
{0x6AC2, 0x9F44},
{0x6AC3, 0x9F43},
{0x6AD1, 0x9F49},
{0x6AD3, 0x9845},
{0x6ADA, 0x9F4C},
{0x6ADB, 0x8BF9},
{0x6ADE, 0x9F48},
{0x6ADF, 0x9F4A},
{0x6AE2, 0xFAF2},
{0x6AE4, 0xFAF3},
{0x6AE8, 0x94A5},
{0x6AEA, 0x9F4D},
{0x6AFA, 0x9F51},
{0x6AFB, 0x9F4E},
{0x6B04, 0x9793},
{0x6B05, 0x9F4F},
{0x6B0A, 0x9EDC},
{0x6B12, 0x9F52},
{0x6B16, 0x9F53},
{0x6B1D, 0x8954},
{0x6B1F, 0x9F55},
{0x6B20, 0x8C87},
{0x6B21, 0x8E9F},
{0x6B23, 0x8BD3},
{0x6B27, 0x89A2},
{0x6B32, 0x977E},
{0x6B37, 0x9F57},
{0x6B38, 0x9F56},
{0x6B39, 0x9F59},
{0x6B3A, 0x8B5C},
{0x6B3D, 0x8BD4},
{0x6B3E, 0x8ABC},
{0x6B43, 0x9F5C},
{0x6B47, 0x9F5B},
{0x6B49, 0x9F5D},
{0x6B4C, 0x89CC},
{0x6B4E, 0x9256},
{0x6B50, 0x9F5E},
{0x6B53, 0x8ABD},
{0x6B54, 0x9F60},
{0x6B59, 0x9F5F},
{0x6B5B, 0x9F61},
{0x6B5F, 0x9F62},
{0x6B61, 0x9F63},
{0x6B62, 0x8E7E},
{0x6B63, 0x90B3},
{0x6B64, 0x8D9F},
{0x6B66, 0x9590},
{0x6B69, 0x95E0},
{0x6B6A, 0x9863},
{0x6B6F, 0x8E95},
{0x6B73, 0x8DCE},
{0x6B74, 0x97F0},
{0x6B78, 0x9F64},
{0x6B79, 0x9F65},
{0x6B7B, 0x8E80},
{0x6B7F, 0x9F66},
{0x6B80, 0x9F67},
{0x6B83, 0x9F69},
{0x6B84, 0x9F68},
{0x6B86, 0x9677},
{0x6B89, 0x8F7D},
{0x6B8A, 0x8EEA},
{0x6B8B, 0x8E63},
{0x6B8D, 0x9F6A},
{0x6B95, 0x9F6C},
{0x6B96, 0x9042},
{0x6B98, 0x9F6B},
{0x6B9E, 0x9F6D},
{0x6BA4, 0x9F6E},
{0x6BAA, 0x9F6F},
{0x6BAB, 0x9F70},
{0x6BAF, 0x9F71},
{0x6BB1, 0x9F73},
{0x6BB2, 0x9F72},
{0x6BB3, 0x9F74},
{0x6BB4, 0x89A3},
{0x6BB5, 0x9269},
{0x6BB7, 0x9F75},
{0x6BBA, 0x8E45},
{0x6BBB, 0x8A6B},
{0x6BBC, 0x9F76},
{0x6BBF, 0x9361},
{0x6BC0, 0x9ACA},
{0x6BC5, 0x8B42},
{0x6BC6, 0x9F77},
{0x6BCB, 0x9F78},
{0x6BCD, 0x95EA},
{0x6BCE, 0x9688},
{0x6BD2, 0x93C5},
{0x6BD3, 0x9F79},
{0x6BD4, 0x94E4},
{0x6BD6, 0xFAF4},
{0x6BD8, 0x94F9},
{0x6BDB, 0x96D1},
{0x6BDF, 0x9F7A},
{0x6BEB, 0x9F7C},
{0x6BEC, 0x9F7B},
{0x6BEF, 0x9F7E},
{0x6BF3, 0x9F7D},
{0x6C08, 0x9F81},
{0x6C0F, 0x8E81},
{0x6C11, 0x96AF},
{0x6C13, 0x9F82},
{0x6C14, 0x9F83},
{0x6C17, 0x8B43},
{0x6C1B, 0x9F84},
{0x6C23, 0x9F86},
{0x6C24, 0x9F85},
{0x6C34, 0x9085},
{0x6C37, 0x9558},
{0x6C38, 0x8969},
{0x6C3E, 0x94C3},
{0x6C3F, 0xFAF5},
{0x6C40, 0x92F3},
{0x6C41, 0x8F60},
{0x6C42, 0x8B81},
{0x6C4E, 0x94C4},
{0x6C50, 0x8EAC},
{0x6C55, 0x9F88},
{0x6C57, 0x8ABE},
{0x6C5A, 0x8998},
{0x6C5C, 0xFAF6},
{0x6C5D, 0x93F0},
{0x6C5E, 0x9F87},
{0x6C5F, 0x8D5D},
{0x6C60, 0x9272},
{0x6C62, 0x9F89},
{0x6C68, 0x9F91},
{0x6C6A, 0x9F8A},
{0x6C6F, 0xFAF8},
{0x6C70, 0x91BF},
{0x6C72, 0x8B82},
{0x6C73, 0x9F92},
{0x6C7A, 0x8C88},
{0x6C7D, 0x8B44},
{0x6C7E, 0x9F90},
{0x6C81, 0x9F8E},
{0x6C82, 0x9F8B},
{0x6C83, 0x9780},
{0x6C86, 0xFAF7},
{0x6C88, 0x92BE},
{0x6C8C, 0x93D7},
{0x6C8D, 0x9F8C},
{0x6C90, 0x9F94},
{0x6C92, 0x9F93},
{0x6C93, 0x8C42},
{0x6C96, 0x89AB},
{0x6C99, 0x8DB9},
{0x6C9A, 0x9F8D},
{0x6C9B, 0x9F8F},
{0x6CA1, 0x9676},
{0x6CA2, 0x91F2},
{0x6CAB, 0x9697},
{0x6CAE, 0x9F9C},
{0x6CB1, 0x9F9D},
{0x6CB3, 0x89CD},
{0x6CB8, 0x95A6},
{0x6CB9, 0x96FB},
{0x6CBA, 0x9F9F},
{0x6CBB, 0x8EA1},
{0x6CBC, 0x8FC0},
{0x6CBD, 0x9F98},
{0x6CBE, 0x9F9E},
{0x6CBF, 0x8988},
{0x6CC1, 0x8BB5},
{0x6CC4, 0x9F95},
{0x6CC5, 0x9F9A},
{0x6CC9, 0x90F2},
{0x6CCA, 0x9491},
{0x6CCC, 0x94E5},
{0x6CD3, 0x9F97},
{0x6CD5, 0x9640},
{0x6CD7, 0x9F99},
{0x6CD9, 0x9FA2},
{0x6CDA, 0xFAF9},
{0x6CDB, 0x9FA0},
{0x6CDD, 0x9F9B},
{0x6CE1, 0x9641},
{0x6CE2, 0x9467},
{0x6CE3, 0x8B83},
{0x6CE5, 0x9344},
{0x6CE8, 0x928D},
{0x6CEA, 0x9FA3},
{0x6CEF, 0x9FA1},
{0x6CF0, 0x91D7},
{0x6CF1, 0x9F96},
{0x6CF3, 0x896A},
{0x6D04, 0xFAFA},
{0x6D0B, 0x976D},
{0x6D0C, 0x9FAE},
{0x6D12, 0x9FAD},
{0x6D17, 0x90F4},
{0x6D19, 0x9FAA},
{0x6D1B, 0x978C},
{0x6D1E, 0x93B4},
{0x6D1F, 0x9FA4},
{0x6D25, 0x92C3},
{0x6D29, 0x896B},
{0x6D2A, 0x8D5E},
{0x6D2B, 0x9FA7},
{0x6D32, 0x8F46},
{0x6D33, 0x9FAC},
{0x6D35, 0x9FAB},
{0x6D36, 0x9FA6},
{0x6D38, 0x9FA9},
{0x6D3B, 0x8A88},
{0x6D3D, 0x9FA8},
{0x6D3E, 0x9468},
{0x6D41, 0x97AC},
{0x6D44, 0x8FF2},
{0x6D45, 0x90F3},
{0x6D59, 0x9FB4},
{0x6D5A, 0x9FB2},
{0x6D5C, 0x956C},
{0x6D63, 0x9FAF},
{0x6D64, 0x9FB1},
{0x6D66, 0x8959},
{0x6D69, 0x8D5F},
{0x6D6A, 0x9851},
{0x6D6C, 0x8A5C},
{0x6D6E, 0x9582},
{0x6D6F, 0xFAFC},
{0x6D74, 0x9781},
{0x6D77, 0x8A43},
{0x6D78, 0x905A},
{0x6D79, 0x9FB3},
{0x6D85, 0x9FB8},
{0x6D87, 0xFAFB},
{0x6D88, 0x8FC1},
{0x6D8C, 0x974F},
{0x6D8E, 0x9FB5},
{0x6D93, 0x9FB0},
{0x6D95, 0x9FB6},
{0x6D96, 0xFB40},
{0x6D99, 0x97DC},
{0x6D9B, 0x9393},
{0x6D9C, 0x93C0},
{0x6DAC, 0xFB41},
{0x6DAF, 0x8A55},
{0x6DB2, 0x8974},
{0x6DB5, 0x9FBC},
{0x6DB8, 0x9FBF},
{0x6DBC, 0x97C1},
{0x6DC0, 0x9784},
{0x6DC5, 0x9FC6},
{0x6DC6, 0x9FC0},
{0x6DC7, 0x9FBD},
{0x6DCB, 0x97D2},
{0x6DCC, 0x9FC3},
{0x6DCF, 0xFB42},
{0x6DD1, 0x8F69},
{0x6DD2, 0x9FC5},
{0x6DD5, 0x9FCA},
{0x6DD8, 0x9391},
{0x6DD9, 0x9FC8},
{0x6DDE, 0x9FC2},
{0x6DE1, 0x9257},
{0x6DE4, 0x9FC9},
{0x6DE6, 0x9FBE},
{0x6DE8, 0x9FC4},
{0x6DEA, 0x9FCB},
{0x6DEB, 0x88FA},
{0x6DEC, 0x9FC1},
{0x6DEE, 0x9FCC},
{0x6DF1, 0x905B},
{0x6DF2, 0xFB44},
{0x6DF3, 0x8F7E},
{0x6DF5, 0x95A3},
{0x6DF7, 0x8DAC},
{0x6DF8, 0xFB43},
{0x6DF9, 0x9FB9},
{0x6DFA, 0x9FC7},
{0x6DFB, 0x9359},
{0x6DFC, 0xFB45},
{0x6E05, 0x90B4},
{0x6E07, 0x8A89},
{0x6E08, 0x8DCF},
{0x6E09, 0x8FC2},
{0x6E0A, 0x9FBB},
{0x6E0B, 0x8F61},
{0x6E13, 0x8C6B},
{0x6E15, 0x9FBA},
{0x6E19, 0x9FD0},
{0x6E1A, 0x8F8D},
{0x6E1B, 0x8CB8},
{0x6E1D, 0x9FDF},
{0x6E1F, 0x9FD9},
{0x6E20, 0x8B94},
{0x6E21, 0x936E},
{0x6E23, 0x9FD4},
{0x6E24, 0x9FDD},
{0x6E25, 0x88AD},
{0x6E26, 0x8951},
{0x6E27, 0xFB48},
{0x6E29, 0x89B7},
{0x6E2B, 0x9FD6},
{0x6E2C, 0x91AA},
{0x6E2D, 0x9FCD},
{0x6E2E, 0x9FCF},
{0x6E2F, 0x8D60},
{0x6E38, 0x9FE0},
{0x6E39, 0xFB46},
{0x6E3A, 0x9FDB},
{0x6E3C, 0xFB49},
{0x6E3E, 0x9FD3},
{0x6E43, 0x9FDA},
{0x6E4A, 0x96A9},
{0x6E4D, 0x9FD8},
{0x6E4E, 0x9FDC},
{0x6E56, 0x8CCE},
{0x6E58, 0x8FC3},
{0x6E5B, 0x9258},
{0x6E5C, 0xFB47},
{0x6E5F, 0x9FD2},
{0x6E67, 0x974E},
{0x6E6B, 0x9FD5},
{0x6E6E, 0x9FCE},
{0x6E6F, 0x9392},
{0x6E72, 0x9FD1},
{0x6E76, 0x9FD7},
{0x6E7E, 0x9870},
{0x6E7F, 0x8EBC},
{0x6E80, 0x969E},
{0x6E82, 0x9FE1},
{0x6E8C, 0x94AC},
{0x6E8F, 0x9FED},
{0x6E90, 0x8CB9},
{0x6E96, 0x8F80},
{0x6E98, 0x9FE3},
{0x6E9C, 0x97AD},
{0x6E9D, 0x8D61},
{0x6E9F, 0x9FF0},
{0x6EA2, 0x88EC},
{0x6EA5, 0x9FEE},
{0x6EAA, 0x9FE2},
{0x6EAF, 0x9FE8},
{0x6EB2, 0x9FEA},
{0x6EB6, 0x976E},
{0x6EB7, 0x9FE5},
{0x6EBA, 0x934D},
{0x6EBD, 0x9FE7},
{0x6EBF, 0xFB4A},
{0x6EC2, 0x9FEF},
{0x6EC4, 0x9FE9},
{0x6EC5, 0x96C5},
{0x6EC9, 0x9FE4},
{0x6ECB, 0x8EA0},
{0x6ECC, 0x9FFC},
{0x6ED1, 0x8A8A},
{0x6ED3, 0x9FE6},
{0x6ED4, 0x9FEB},
{0x6ED5, 0x9FEC},
{0x6EDD, 0x91EA},
{0x6EDE, 0x91D8},
{0x6EEC, 0x9FF4},
{0x6EEF, 0x9FFA},
{0x6EF2, 0x9FF8},
{0x6EF4, 0x9348},
{0x6EF7, 0xE042},
{0x6EF8, 0x9FF5},
{0x6EFE, 0x9FF6},
{0x6EFF, 0x9FDE},
{0x6F01, 0x8B99},
{0x6F02, 0x9559},
{0x6F06, 0x8EBD},
{0x6F09, 0x8D97},
{0x6F0F, 0x9852},
{0x6F11, 0x9FF2},
{0x6F13, 0xE041},
{0x6F14, 0x8989},
{0x6F15, 0x9186},
{0x6F20, 0x9499},
{0x6F22, 0x8ABF},
{0x6F23, 0x97F8},
{0x6F2B, 0x969F},
{0x6F2C, 0x92D0},
{0x6F31, 0x9FF9},
{0x6F32, 0x9FFB},
{0x6F38, 0x9151},
{0x6F3E, 0xE040},
{0x6F3F, 0x9FF7},
{0x6F41, 0x9FF1},
{0x6F45, 0x8AC1},
{0x6F54, 0x8C89},
{0x6F58, 0xE04E},
{0x6F5B, 0xE049},
{0x6F5C, 0x90F6},
{0x6F5F, 0x8A83},
{0x6F64, 0x8F81},
{0x6F66, 0xE052},
{0x6F6D, 0xE04B},
{0x6F6E, 0x92AA},
{0x6F6F, 0xE048},
{0x6F70, 0x92D7},
{0x6F74, 0xE06B},
{0x6F78, 0xE045},
{0x6F7A, 0xE044},
{0x6F7C, 0xE04D},
{0x6F80, 0xE047},
{0x6F81, 0xE046},
{0x6F82, 0xE04C},
{0x6F84, 0x909F},
{0x6F86, 0xE043},
{0x6F88, 0xFB4B},
{0x6F8E, 0xE04F},
{0x6F91, 0xE050},
{0x6F97, 0x8AC0},
{0x6FA1, 0xE055},
{0x6FA3, 0xE054},
{0x6FA4, 0xE056},
{0x6FAA, 0xE059},
{0x6FB1, 0x9362},
{0x6FB3, 0xE053},
{0x6FB5, 0xFB4C},
{0x6FB9, 0xE057},
{0x6FC0, 0x8C83},
{0x6FC1, 0x91F7},
{0x6FC2, 0xE051},
{0x6FC3, 0x945A},
{0x6FC6, 0xE058},
{0x6FD4, 0xE05D},
{0x6FD5, 0xE05B},
{0x6FD8, 0xE05E},
{0x6FDB, 0xE061},
{0x6FDF, 0xE05A},
{0x6FE0, 0x8D8A},
{0x6FE1, 0x9447},
{0x6FE4, 0x9FB7},
{0x6FEB, 0x9794},
{0x6FEC, 0xE05C},
{0x6FEE, 0xE060},
{0x6FEF, 0x91F3},
{0x6FF1, 0xE05F},
{0x6FF3, 0xE04A},
{0x6FF5, 0xFB4D},
{0x6FF6, 0xE889},
{0x6FFA, 0xE064},
{0x6FFE, 0xE068},
{0x7001, 0xE066},
{0x7005, 0xFB4E},
{0x7007, 0xFB4F},
{0x7009, 0xE062},
{0x700B, 0xE063},
{0x700F, 0xE067},
{0x7011, 0xE065},
{0x7015, 0x956D},
{0x7018, 0xE06D},
{0x701A, 0xE06A},
{0x701B, 0xE069},
{0x701D, 0xE06C},
{0x701E, 0x93D2},
{0x701F, 0xE06E},
{0x7026, 0x9295},
{0x7027, 0x91EB},
{0x7028, 0xFB50},
{0x702C, 0x90A3},
{0x7030, 0xE06F},
{0x7032, 0xE071},
{0x703E, 0xE070},
{0x704C, 0x9FF3},
{0x7051, 0xE072},
{0x7058, 0x93E5},
{0x7063, 0xE073},
{0x706B, 0x89CE},
{0x706F, 0x9394},
{0x7070, 0x8A44},
{0x7078, 0x8B84},
{0x707C, 0x8EDC},
{0x707D, 0x8DD0},
{0x7085, 0xFB51},
{0x7089, 0x9846},
{0x708A, 0x9086},
{0x708E, 0x898A},
{0x7092, 0xE075},
{0x7099, 0xE074},
{0x70AB, 0xFB52},
{0x70AC, 0xE078},
{0x70AD, 0x9259},
{0x70AE, 0xE07B},
{0x70AF, 0xE076},
{0x70B3, 0xE07A},
{0x70B8, 0xE079},
{0x70B9, 0x935F},
{0x70BA, 0x88D7},
{0x70BB, 0xFA62},
{0x70C8, 0x97F3},
{0x70CB, 0xE07D},
{0x70CF, 0x8947},
{0x70D9, 0xE080},
{0x70DD, 0xE07E},
{0x70DF, 0xE07C},
{0x70F1, 0xE077},
{0x70F9, 0x9642},
{0x70FD, 0xE082},
{0x7104, 0xFB54},
{0x7109, 0xE081},
{0x710F, 0xFB53},
{0x7114, 0x898B},
{0x7119, 0xE084},
{0x711A, 0x95B0},
{0x711C, 0xE083},
{0x7121, 0x96B3},
{0x7126, 0x8FC5},
{0x7136, 0x9152},
{0x713C, 0x8FC4},
{0x7146, 0xFB56},
{0x7147, 0xFB57},
{0x7149, 0x97F9},
{0x714C, 0xE08A},
{0x714E, 0x90F7},
{0x7155, 0xE086},
{0x7156, 0xE08B},
{0x7159, 0x898C},
{0x715C, 0xFB55},
{0x7162, 0xE089},
{0x7164, 0x9481},
{0x7165, 0xE085},
{0x7166, 0xE088},
{0x7167, 0x8FC6},
{0x7169, 0x94CF},
{0x716C, 0xE08C},
{0x716E, 0x8ECF},
{0x717D, 0x90F8},
{0x7184, 0xE08F},
{0x7188, 0xE087},
{0x718A, 0x8C46},
{0x718F, 0xE08D},
{0x7194, 0x976F},
{0x7195, 0xE090},
{0x7199, 0xEAA4},
{0x719F, 0x8F6E},
{0x71A8, 0xE091},
{0x71AC, 0xE092},
{0x71B1, 0x944D},
{0x71B9, 0xE094},
{0x71BE, 0xE095},
{0x71C1, 0xFB59},
{0x71C3, 0x9452},
{0x71C8, 0x9395},
{0x71C9, 0xE097},
{0x71CE, 0xE099},
{0x71D0, 0x97D3},
{0x71D2, 0xE096},
{0x71D4, 0xE098},
{0x71D5, 0x898D},
{0x71D7, 0xE093},
{0x71DF, 0x9A7A},
{0x71E0, 0xE09A},
{0x71E5, 0x9187},
{0x71E6, 0x8E57},
{0x71E7, 0xE09C},
{0x71EC, 0xE09B},
{0x71ED, 0x9043},
{0x71EE, 0x99D7},
{0x71F5, 0xE09D},
{0x71F9, 0xE09F},
{0x71FB, 0xE08E},
{0x71FC, 0xE09E},
{0x71FE, 0xFB5A},
{0x71FF, 0xE0A0},
{0x7206, 0x949A},
{0x720D, 0xE0A1},
{0x7210, 0xE0A2},
{0x721B, 0xE0A3},
{0x7228, 0xE0A4},
{0x722A, 0x92DC},
{0x722C, 0xE0A6},
{0x722D, 0xE0A5},
{0x7230, 0xE0A7},
{0x7232, 0xE0A8},
{0x7235, 0x8EDD},
{0x7236, 0x9583},
{0x723A, 0x96EA},
{0x723B, 0xE0A9},
{0x723C, 0xE0AA},
{0x723D, 0x9175},
{0x723E, 0x8EA2},
{0x723F, 0xE0AB},
{0x7240, 0xE0AC},
{0x7246, 0xE0AD},
{0x7247, 0x95D0},
{0x7248, 0x94C5},
{0x724B, 0xE0AE},
{0x724C, 0x9476},
{0x7252, 0x92AB},
{0x7258, 0xE0AF},
{0x7259, 0x89E5},
{0x725B, 0x8B8D},
{0x725D, 0x96C4},
{0x725F, 0x96B4},
{0x7261, 0x89B2},
{0x7262, 0x9853},
{0x7267, 0x9671},
{0x7269, 0x95A8},
{0x7272, 0x90B5},
{0x7274, 0xE0B0},
{0x7279, 0x93C1},
{0x727D, 0x8CA1},
{0x727E, 0xE0B1},
{0x7280, 0x8DD2},
{0x7281, 0xE0B3},
{0x7282, 0xE0B2},
{0x7287, 0xE0B4},
{0x7292, 0xE0B5},
{0x7296, 0xE0B6},
{0x72A0, 0x8B5D},
{0x72A2, 0xE0B7},
{0x72A7, 0xE0B8},
{0x72AC, 0x8CA2},
{0x72AF, 0x94C6},
{0x72B1, 0xFB5B},
{0x72B2, 0xE0BA},
{0x72B6, 0x8FF3},
{0x72B9, 0xE0B9},
{0x72BE, 0xFB5C},
{0x72C2, 0x8BB6},
{0x72C3, 0xE0BB},
{0x72C4, 0xE0BD},
{0x72C6, 0xE0BC},
{0x72CE, 0xE0BE},
{0x72D0, 0x8CCF},
{0x72D2, 0xE0BF},
{0x72D7, 0x8BE7},
{0x72D9, 0x915F},
{0x72DB, 0x8D9D},
{0x72E0, 0xE0C1},
{0x72E1, 0xE0C2},
{0x72E2, 0xE0C0},
{0x72E9, 0x8EEB},
{0x72EC, 0x93C6},
{0x72ED, 0x8BB7},
{0x72F7, 0xE0C4},
{0x72F8, 0x924B},
{0x72F9, 0xE0C3},
{0x72FC, 0x9854},
{0x72FD, 0x9482},
{0x730A, 0xE0C7},
{0x7316, 0xE0C9},
{0x7317, 0xE0C6},
{0x731B, 0x96D2},
{0x731C, 0xE0C8},
{0x731D, 0xE0CA},
{0x731F, 0x97C2},
{0x7324, 0xFB5D},
{0x7325, 0xE0CE},
{0x7329, 0xE0CD},
{0x732A, 0x9296},
{0x732B, 0x944C},
{0x732E, 0x8CA3},
{0x732F, 0xE0CC},
{0x7334, 0xE0CB},
{0x7336, 0x9750},
{0x7337, 0x9751},
{0x733E, 0xE0CF},
{0x733F, 0x898E},
{0x7344, 0x8D96},
{0x7345, 0x8E82},
{0x734E, 0xE0D0},
{0x734F, 0xE0D1},
{0x7357, 0xE0D3},
{0x7363, 0x8F62},
{0x7368, 0xE0D5},
{0x736A, 0xE0D4},
{0x7370, 0xE0D6},
{0x7372, 0x8A6C},
{0x7375, 0xE0D8},
{0x7377, 0xFB5F},
{0x7378, 0xE0D7},
{0x737A, 0xE0DA},
{0x737B, 0xE0D9},
{0x7384, 0x8CBA},
{0x7387, 0x97A6},
{0x7389, 0x8BCA},
{0x738B, 0x89A4},
{0x7396, 0x8BE8},
{0x73A9, 0x8ADF},
{0x73B2, 0x97E6},
{0x73B3, 0xE0DC},
{0x73BB, 0xE0DE},
{0x73BD, 0xFB60},
{0x73C0, 0xE0DF},
{0x73C2, 0x89CF},
{0x73C8, 0xE0DB},
{0x73C9, 0xFB61},
{0x73CA, 0x8E58},
{0x73CD, 0x92BF},
{0x73CE, 0xE0DD},
{0x73D2, 0xFB64},
{0x73D6, 0xFB62},
{0x73DE, 0xE0E2},
{0x73E0, 0x8EEC},
{0x73E3, 0xFB63},
{0x73E5, 0xE0E0},
{0x73EA, 0x8C5D},
{0x73ED, 0x94C7},
{0x73EE, 0xE0E1},
{0x73F1, 0xE0FC},
{0x73F5, 0xFB66},
{0x73F8, 0xE0E7},
{0x73FE, 0x8CBB},
{0x7403, 0x8B85},
{0x7405, 0xE0E4},
{0x7406, 0x979D},
{0x7407, 0xFB65},
{0x7409, 0x97AE},
{0x7422, 0x91F4},
{0x7425, 0xE0E6},
{0x7426, 0xFB67},
{0x7429, 0xFB69},
{0x742A, 0xFB68},
{0x742E, 0xFB6A},
{0x7432, 0xE0E8},
{0x7433, 0x97D4},
{0x7434, 0x8BD5},
{0x7435, 0x94FA},
{0x7436, 0x9469},
{0x743A, 0xE0E9},
{0x743F, 0xE0EB},
{0x7441, 0xE0EE},
{0x7455, 0xE0EA},
{0x7459, 0xE0ED},
{0x745A, 0x8CE8},
{0x745B, 0x896C},
{0x745C, 0xE0EF},
{0x745E, 0x9090},
{0x745F, 0xE0EC},
{0x7460, 0x97DA},
{0x7462, 0xFB6B},
{0x7463, 0xE0F2},
{0x7464, 0xEAA2},
{0x7469, 0xE0F0},
{0x746A, 0xE0F3},
{0x746F, 0xE0E5},
{0x7470, 0xE0F1},
{0x7473, 0x8DBA},
{0x7476, 0xE0F4},
{0x747E, 0xE0F5},
{0x7483, 0x979E},
{0x7489, 0xFB6C},
{0x748B, 0xE0F6},
{0x749E, 0xE0F7},
{0x749F, 0xFB6D},
{0x74A2, 0xE0E3},
{0x74A7, 0xE0F8},
{0x74B0, 0x8AC2},
{0x74BD, 0x8EA3},
{0x74CA, 0xE0F9},
{0x74CF, 0xE0FA},
{0x74D4, 0xE0FB},
{0x74DC, 0x895A},
{0x74E0, 0xE140},
{0x74E2, 0x955A},
{0x74E3, 0xE141},
{0x74E6, 0x8AA2},
{0x74E7, 0xE142},
{0x74E9, 0xE143},
{0x74EE, 0xE144},
{0x74F0, 0xE146},
{0x74F1, 0xE147},
{0x74F2, 0xE145},
{0x74F6, 0x9572},
{0x74F7, 0xE149},
{0x74F8, 0xE148},
{0x7501, 0xFB6E},
{0x7503, 0xE14B},
{0x7504, 0xE14A},
{0x7505, 0xE14C},
{0x750C, 0xE14D},
{0x750D, 0xE14F},
{0x750E, 0xE14E},
{0x7511, 0x8D99},
{0x7513, 0xE151},
{0x7515, 0xE150},
{0x7518, 0x8AC3},
{0x751A, 0x9072},
{0x751C, 0x935B},
{0x751E, 0xE152},
{0x751F, 0x90B6},
{0x7523, 0x8E59},
{0x7525, 0x8999},
{0x7526, 0xE153},
{0x7528, 0x9770},
{0x752B, 0x95E1},
{0x752C, 0xE154},
{0x752F, 0xFAA8},
{0x7530, 0x9363},
{0x7531, 0x9752},
{0x7532, 0x8D62},
{0x7533, 0x905C},
{0x7537, 0x926A},
{0x7538, 0x99B2},
{0x753A, 0x92AC},
{0x753B, 0x89E6},
{0x753C, 0xE155},
{0x7544, 0xE156},
{0x7546, 0xE15B},
{0x7549, 0xE159},
{0x754A, 0xE158},
{0x754B, 0x9DC0},
{0x754C, 0x8A45},
{0x754D, 0xE157},
{0x754F, 0x88D8},
{0x7551, 0x94A8},
{0x7554, 0x94C8},
{0x7559, 0x97AF},
{0x755A, 0xE15C},
{0x755B, 0xE15A},
{0x755C, 0x927B},
{0x755D, 0x90A4},
{0x7560, 0x94A9},
{0x7562, 0x954C},
{0x7564, 0xE15E},
{0x7565, 0x97AA},
{0x7566, 0x8C6C},
{0x7567, 0xE15F},
{0x7569, 0xE15D},
{0x756A, 0x94D4},
{0x756B, 0xE160},
{0x756D, 0xE161},
{0x756F, 0xFB6F},
{0x7570, 0x88D9},
{0x7573, 0x8FF4},
{0x7574, 0xE166},
{0x7576, 0xE163},
{0x7577, 0x93EB},
{0x7578, 0xE162},
{0x757F, 0x8B45},
{0x7582, 0xE169},
{0x7586, 0xE164},
{0x7587, 0xE165},
{0x7589, 0xE168},
{0x758A, 0xE167},
{0x758B, 0x9544},
{0x758E, 0x9161},
{0x758F, 0x9160},
{0x7591, 0x8B5E},
{0x7594, 0xE16A},
{0x759A, 0xE16B},
{0x759D, 0xE16C},
{0x75A3, 0xE16E},
{0x75A5, 0xE16D},
{0x75AB, 0x8975},
{0x75B1, 0xE176},
{0x75B2, 0x94E6},
{0x75B3, 0xE170},
{0x75B5, 0xE172},
{0x75B8, 0xE174},
{0x75B9, 0x905D},
{0x75BC, 0xE175},
{0x75BD, 0xE173},
{0x75BE, 0x8EBE},
{0x75C2, 0xE16F},
{0x75C3, 0xE171},
{0x75C5, 0x9561},
{0x75C7, 0x8FC7},
{0x75CA, 0xE178},
{0x75CD, 0xE177},
{0x75D2, 0xE179},
{0x75D4, 0x8EA4},
{0x75D5, 0x8DAD},
{0x75D8, 0x9397},
{0x75D9, 0xE17A},
{0x75DB, 0x92C9},
{0x75DE, 0xE17C},
{0x75E2, 0x979F},
{0x75E3, 0xE17B},
{0x75E9, 0x9189},
{0x75F0, 0xE182},
{0x75F2, 0xE184},
{0x75F3, 0xE185},
{0x75F4, 0x9273},
{0x75FA, 0xE183},
{0x75FC, 0xE180},
{0x75FE, 0xE17D},
{0x75FF, 0xE17E},
{0x7601, 0xE181},
{0x7609, 0xE188},
{0x760B, 0xE186},
{0x760D, 0xE187},
{0x761F, 0xE189},
{0x7620, 0xE18B},
{0x7621, 0xE18C},
{0x7622, 0xE18D},
{0x7624, 0xE18E},
{0x7627, 0xE18A},
{0x7630, 0xE190},
{0x7634, 0xE18F},
{0x763B, 0xE191},
{0x7642, 0x97C3},
{0x7646, 0xE194},
{0x7647, 0xE192},
{0x7648, 0xE193},
{0x764C, 0x8AE0},
{0x7652, 0x96FC},
{0x7656, 0x95C8},
{0x7658, 0xE196},
{0x765C, 0xE195},
{0x7661, 0xE197},
{0x7662, 0xE198},
{0x7667, 0xE19C},
{0x7668, 0xE199},
{0x7669, 0xE19A},
{0x766A, 0xE19B},
{0x766C, 0xE19D},
{0x7670, 0xE19E},
{0x7672, 0xE19F},
{0x7676, 0xE1A0},
{0x7678, 0xE1A1},
{0x767A, 0x94AD},
{0x767B, 0x936F},
{0x767C, 0xE1A2},
{0x767D, 0x9492},
{0x767E, 0x9553},
{0x7680, 0xE1A3},
{0x7682, 0xFB70},
{0x7683, 0xE1A4},
{0x7684, 0x9349},
{0x7686, 0x8A46},
{0x7687, 0x8D63},
{0x7688, 0xE1A5},
{0x768B, 0xE1A6},
{0x768E, 0xE1A7},
{0x7690, 0x8E48},
{0x7693, 0xE1A9},
{0x7696, 0xE1A8},
{0x7699, 0xE1AA},
{0x769A, 0xE1AB},
{0x769B, 0xFB73},
{0x769C, 0xFB71},
{0x769E, 0xFB72},
{0x76A6, 0xFB74},
{0x76AE, 0x94E7},
{0x76B0, 0xE1AC},
{0x76B4, 0xE1AD},
{0x76B7, 0xEA89},
{0x76B8, 0xE1AE},
{0x76B9, 0xE1AF},
{0x76BA, 0xE1B0},
{0x76BF, 0x8E4D},
{0x76C2, 0xE1B1},
{0x76C3, 0x9475},
{0x76C6, 0x967E},
{0x76C8, 0x896D},
{0x76CA, 0x8976},
{0x76CD, 0xE1B2},
{0x76D2, 0xE1B4},
{0x76D6, 0xE1B3},
{0x76D7, 0x9390},
{0x76DB, 0x90B7},
{0x76DC, 0x9F58},
{0x76DE, 0xE1B5},
{0x76DF, 0x96BF},
{0x76E1, 0xE1B6},
{0x76E3, 0x8AC4},
{0x76E4, 0x94D5},
{0x76E5, 0xE1B7},
{0x76E7, 0xE1B8},
{0x76EA, 0xE1B9},
{0x76EE, 0x96DA},
{0x76F2, 0x96D3},
{0x76F4, 0x92BC},
{0x76F8, 0x918A},
{0x76FB, 0xE1BB},
{0x76FE, 0x8F82},
{0x7701, 0x8FC8},
{0x7704, 0xE1BE},
{0x7707, 0xE1BD},
{0x7708, 0xE1BC},
{0x7709, 0x94FB},
{0x770B, 0x8AC5},
{0x770C, 0x8CA7},
{0x771B, 0xE1C4},
{0x771E, 0xE1C1},
{0x771F, 0x905E},
{0x7720, 0x96B0},
{0x7724, 0xE1C0},
{0x7725, 0xE1C2},
{0x7726, 0xE1C3},
{0x7729, 0xE1BF},
{0x7737, 0xE1C5},
{0x7738, 0xE1C6},
{0x773A, 0x92AD},
{0x773C, 0x8AE1},
{0x7740, 0x9285},
{0x7746, 0xFB76},
{0x7747, 0xE1C7},
{0x775A, 0xE1C8},
{0x775B, 0xE1CB},
{0x7761, 0x9087},
{0x7763, 0x93C2},
{0x7765, 0xE1CC},
{0x7766, 0x9672},
{0x7768, 0xE1C9},
{0x776B, 0xE1CA},
{0x7779, 0xE1CF},
{0x777E, 0xE1CE},
{0x777F, 0xE1CD},
{0x778B, 0xE1D1},
{0x778E, 0xE1D0},
{0x7791, 0xE1D2},
{0x779E, 0xE1D4},
{0x77A0, 0xE1D3},
{0x77A5, 0x95CB},
{0x77AC, 0x8F75},
{0x77AD, 0x97C4},
{0x77B0, 0xE1D5},
{0x77B3, 0x93B5},
{0x77B6, 0xE1D6},
{0x77B9, 0xE1D7},
{0x77BB, 0xE1DB},
{0x77BC, 0xE1D9},
{0x77BD, 0xE1DA},
{0x77BF, 0xE1D8},
{0x77C7, 0xE1DC},
{0x77CD, 0xE1DD},
{0x77D7, 0xE1DE},
{0x77DA, 0xE1DF},
{0x77DB, 0x96B5},
{0x77DC, 0xE1E0},
{0x77E2, 0x96EE},
{0x77E3, 0xE1E1},
{0x77E5, 0x926D},
{0x77E7, 0x948A},
{0x77E9, 0x8BE9},
{0x77ED, 0x925A},
{0x77EE, 0xE1E2},
{0x77EF, 0x8BB8},
{0x77F3, 0x90CE},
{0x77FC, 0xE1E3},
{0x7802, 0x8DBB},
{0x780C, 0xE1E4},
{0x7812, 0xE1E5},
{0x7814, 0x8CA4},
{0x7815, 0x8DD3},
{0x7820, 0xE1E7},
{0x7821, 0xFB78},
{0x7825, 0x9375},
{0x7826, 0x8DD4},
{0x7827, 0x8B6D},
{0x7832, 0x9643},
{0x7834, 0x946A},
{0x783A, 0x9376},
{0x783F, 0x8D7B},
{0x7845, 0xE1E9},
{0x784E, 0xFB79},
{0x785D, 0x8FC9},
{0x7864, 0xFB7A},
{0x786B, 0x97B0},
{0x786C, 0x8D64},
{0x786F, 0x8CA5},
{0x7872, 0x94A1},
{0x7874, 0xE1EB},
{0x787A, 0xFB7B},
{0x787C, 0xE1ED},
{0x7881, 0x8CE9},
{0x7886, 0xE1EC},
{0x7887, 0x92F4},
{0x788C, 0xE1EF},
{0x788D, 0x8A56},
{0x788E, 0xE1EA},
{0x7891, 0x94E8},
{0x7893, 0x894F},
{0x7895, 0x8DEA},
{0x7897, 0x9871},
{0x789A, 0xE1EE},
{0x78A3, 0xE1F0},
{0x78A7, 0x95C9},
{0x78A9, 0x90D7},
{0x78AA, 0xE1F2},
{0x78AF, 0xE1F3},
{0x78B5, 0xE1F1},
{0x78BA, 0x8A6D},
{0x78BC, 0xE1F9},
{0x78BE, 0xE1F8},
{0x78C1, 0x8EA5},
{0x78C5, 0xE1FA},
{0x78C6, 0xE1F5},
{0x78CA, 0xE1FB},
{0x78CB, 0xE1F6},
{0x78D0, 0x94D6},
{0x78D1, 0xE1F4},
{0x78D4, 0xE1F7},
{0x78DA, 0xE241},
{0x78E7, 0xE240},
{0x78E8, 0x9681},
{0x78EC, 0xE1FC},
{0x78EF, 0x88E9},
{0x78F4, 0xE243},
{0x78FD, 0xE242},
{0x7901, 0x8FCA},
{0x7907, 0xE244},
{0x790E, 0x9162},
{0x7911, 0xE246},
{0x7912, 0xE245},
{0x7919, 0xE247},
{0x7926, 0xE1E6},
{0x792A, 0xE1E8},
{0x792B, 0xE249},
{0x792C, 0xE248},
{0x7930, 0xFB7C},
{0x793A, 0x8EA6},
{0x793C, 0x97E7},
{0x793E, 0x8ED0},
{0x7940, 0xE24A},
{0x7941, 0x8C56},
{0x7947, 0x8B5F},
{0x7948, 0x8B46},
{0x7949, 0x8E83},
{0x7950, 0x9753},
{0x7953, 0xE250},
{0x7955, 0xE24F},
{0x7956, 0x9163},
{0x7957, 0xE24C},
{0x795A, 0xE24E},
{0x795D, 0x8F6A},
{0x795E, 0x905F},
{0x795F, 0xE24D},
{0x7960, 0xE24B},
{0x7962, 0x9449},
{0x7965, 0x8FCB},
{0x7968, 0x955B},
{0x796D, 0x8DD5},
{0x7977, 0x9398},
{0x797A, 0xE251},
{0x797F, 0xE252},
{0x7980, 0xE268},
{0x7981, 0x8BD6},
{0x7984, 0x985C},
{0x7985, 0x9154},
{0x798A, 0xE253},
{0x798D, 0x89D0},
{0x798E, 0x92F5},
{0x798F, 0x959F},
{0x7994, 0xFB81},
{0x799B, 0xFB83},
{0x799D, 0xE254},
{0x79A6, 0x8B9A},
{0x79A7, 0xE255},
{0x79AA, 0xE257},
{0x79AE, 0xE258},
{0x79B0, 0x9448},
{0x79B3, 0xE259},
{0x79B9, 0xE25A},
{0x79BA, 0xE25B},
{0x79BD, 0x8BD7},
{0x79BE, 0x89D1},
{0x79BF, 0x93C3},
{0x79C0, 0x8F47},
{0x79C1, 0x8E84},
{0x79C9, 0xE25C},
{0x79CB, 0x8F48},
{0x79D1, 0x89C8},
{0x79D2, 0x9562},
{0x79D5, 0xE25D},
{0x79D8, 0x94E9},
{0x79DF, 0x9164},
{0x79E1, 0xE260},
{0x79E3, 0xE261},
{0x79E4, 0x9489},
{0x79E6, 0x9060},
{0x79E7, 0xE25E},
{0x79E9, 0x9281},
{0x79EC, 0xE25F},
{0x79F0, 0x8FCC},
{0x79FB, 0x88DA},
{0x7A00, 0x8B48},
{0x7A08, 0xE262},
{0x7A0B, 0x92F6},
{0x7A0D, 0xE263},
{0x7A0E, 0x90C5},
{0x7A14, 0x96AB},
{0x7A17, 0x9542},
{0x7A18, 0xE264},
{0x7A19, 0xE265},
{0x7A1A, 0x9274},
{0x7A1C, 0x97C5},
{0x7A1F, 0xE267},
{0x7A20, 0xE266},
{0x7A2E, 0x8EED},
{0x7A31, 0xE269},
{0x7A32, 0x88EE},
{0x7A37, 0xE26C},
{0x7A3B, 0xE26A},
{0x7A3C, 0x89D2},
{0x7A3D, 0x8C6D},
{0x7A3E, 0xE26B},
{0x7A3F, 0x8D65},
{0x7A40, 0x8D92},
{0x7A42, 0x95E4},
{0x7A43, 0xE26D},
{0x7A46, 0x9673},
{0x7A49, 0xE26F},
{0x7A4D, 0x90CF},
{0x7A4E, 0x896E},
{0x7A4F, 0x89B8},
{0x7A50, 0x88AA},
{0x7A57, 0xE26E},
{0x7A61, 0xE270},
{0x7A62, 0xE271},
{0x7A63, 0x8FF5},
{0x7A69, 0xE272},
{0x7A6B, 0x8A6E},
{0x7A70, 0xE274},
{0x7A74, 0x8C8A},
{0x7A76, 0x8B86},
{0x7A79, 0xE275},
{0x7A7A, 0x8BF3},
{0x7A7D, 0xE276},
{0x7A7F, 0x90FA},
{0x7A81, 0x93CB},
{0x7A83, 0x90DE},
{0x7A84, 0x8DF3},
{0x7A88, 0xE277},
{0x7A92, 0x9282},
{0x7A93, 0x918B},
{0x7A95, 0xE279},
{0x7A96, 0xE27B},
{0x7A97, 0xE278},
{0x7A98, 0xE27A},
{0x7A9F, 0x8C41},
{0x7AA9, 0xE27C},
{0x7AAA, 0x8C45},
{0x7AAE, 0x8B87},
{0x7AAF, 0x9771},
{0x7AB0, 0xE27E},
{0x7AB6, 0xE280},
{0x7ABA, 0x894D},
{0x7ABF, 0xE283},
{0x7AC3, 0x8A96},
{0x7AC4, 0xE282},
{0x7AC5, 0xE281},
{0x7AC7, 0xE285},
{0x7AC8, 0xE27D},
{0x7ACA, 0xE286},
{0x7ACB, 0x97A7},
{0x7ACD, 0xE287},
{0x7ACF, 0xE288},
{0x7AD1, 0xFB84},
{0x7AD2, 0x9AF2},
{0x7AD3, 0xE28A},
{0x7AD5, 0xE289},
{0x7AD9, 0xE28B},
{0x7ADA, 0xE28C},
{0x7ADC, 0x97B3},
{0x7ADD, 0xE28D},
{0x7ADF, 0xE8ED},
{0x7AE0, 0x8FCD},
{0x7AE1, 0xE28E},
{0x7AE2, 0xE28F},
{0x7AE3, 0x8F76},
{0x7AE5, 0x93B6},
{0x7AE6, 0xE290},
{0x7AE7, 0xFB85},
{0x7AEA, 0x9247},
{0x7AEB, 0xFB87},
{0x7AED, 0xE291},
{0x7AEF, 0x925B},
{0x7AF0, 0xE292},
{0x7AF6, 0x8BA3},
{0x7AF8, 0x995E},
{0x7AF9, 0x927C},
{0x7AFA, 0x8EB1},
{0x7AFF, 0x8AC6},
{0x7B02, 0xE293},
{0x7B04, 0xE2A0},
{0x7B06, 0xE296},
{0x7B08, 0x8B88},
{0x7B0A, 0xE295},
{0x7B0B, 0xE2A2},
{0x7B0F, 0xE294},
{0x7B11, 0x8FCE},
{0x7B18, 0xE298},
{0x7B19, 0xE299},
{0x7B1B, 0x934A},
{0x7B1E, 0xE29A},
{0x7B20, 0x8A7D},
{0x7B25, 0x9079},
{0x7B26, 0x9584},
{0x7B28, 0xE29C},
{0x7B2C, 0x91E6},
{0x7B33, 0xE297},
{0x7B35, 0xE29B},
{0x7B36, 0xE29D},
{0x7B39, 0x8DF9},
{0x7B45, 0xE2A4},
{0x7B46, 0x954D},
{0x7B48, 0x94A4},
{0x7B49, 0x9399},
{0x7B4B, 0x8BD8},
{0x7B4C, 0xE2A3},
{0x7B4D, 0xE2A1},
{0x7B4F, 0x94B3},
{0x7B50, 0xE29E},
{0x7B51, 0x927D},
{0x7B52, 0x939B},
{0x7B54, 0x939A},
{0x7B56, 0x8DF4},
{0x7B5D, 0xE2B6},
{0x7B65, 0xE2A6},
{0x7B67, 0xE2A8},
{0x7B6C, 0xE2AB},
{0x7B6E, 0xE2AC},
{0x7B70, 0xE2A9},
{0x7B71, 0xE2AA},
{0x7B74, 0xE2A7},
{0x7B75, 0xE2A5},
{0x7B7A, 0xE29F},
{0x7B86, 0x95CD},
{0x7B87, 0x89D3},
{0x7B8B, 0xE2B3},
{0x7B8D, 0xE2B0},
{0x7B8F, 0xE2B5},
{0x7B92, 0xE2B4},
{0x7B94, 0x9493},
{0x7B95, 0x96A5},
{0x7B97, 0x8E5A},
{0x7B98, 0xE2AE},
{0x7B99, 0xE2B7},
{0x7B9A, 0xE2B2},
{0x7B9C, 0xE2B1},
{0x7B9D, 0xE2AD},
{0x7B9E, 0xFB88},
{0x7B9F, 0xE2AF},
{0x7BA1, 0x8AC7},
{0x7BAA, 0x925C},
{0x7BAD, 0x90FB},
{0x7BB1, 0x94A0},
{0x7BB4, 0xE2BC},
{0x7BB8, 0x94A2},
{0x7BC0, 0x90DF},
{0x7BC1, 0xE2B9},
{0x7BC4, 0x94CD},
{0x7BC6, 0xE2BD},
{0x7BC7, 0x95D1},
{0x7BC9, 0x927A},
{0x7BCB, 0xE2B8},
{0x7BCC, 0xE2BA},
{0x7BCF, 0xE2BB},
{0x7BDD, 0xE2BE},
{0x7BE0, 0x8EC2},
{0x7BE4, 0x93C4},
{0x7BE5, 0xE2C3},
{0x7BE6, 0xE2C2},
{0x7BE9, 0xE2BF},
{0x7BED, 0x9855},
{0x7BF3, 0xE2C8},
{0x7BF6, 0xE2CC},
{0x7BF7, 0xE2C9},
{0x7C00, 0xE2C5},
{0x7C07, 0xE2C6},
{0x7C0D, 0xE2CB},
{0x7C11, 0xE2C0},
{0x7C12, 0x99D3},
{0x7C13, 0xE2C7},
{0x7C14, 0xE2C1},
{0x7C17, 0xE2CA},
{0x7C1F, 0xE2D0},
{0x7C21, 0x8AC8},
{0x7C23, 0xE2CD},
{0x7C27, 0xE2CE},
{0x7C2A, 0xE2CF},
{0x7C2B, 0xE2D2},
{0x7C37, 0xE2D1},
{0x7C38, 0x94F4},
{0x7C3D, 0xE2D3},
{0x7C3E, 0x97FA},
{0x7C3F, 0x95EB},
{0x7C40, 0xE2D8},
{0x7C43, 0xE2D5},
{0x7C4C, 0xE2D4},
{0x7C4D, 0x90D0},
{0x7C4F, 0xE2D7},
{0x7C50, 0xE2D9},
{0x7C54, 0xE2D6},
{0x7C56, 0xE2DD},
{0x7C58, 0xE2DA},
{0x7C5F, 0xE2DB},
{0x7C60, 0xE2C4},
{0x7C64, 0xE2DC},
{0x7C65, 0xE2DE},
{0x7C6C, 0xE2DF},
{0x7C73, 0x95C4},
{0x7C75, 0xE2E0},
{0x7C7E, 0x96E0},
{0x7C81, 0x8BCC},
{0x7C82, 0x8C48},
{0x7C83, 0xE2E1},
{0x7C89, 0x95B2},
{0x7C8B, 0x9088},
{0x7C8D, 0x96AE},
{0x7C90, 0xE2E2},
{0x7C92, 0x97B1},
{0x7C95, 0x9494},
{0x7C97, 0x9165},
{0x7C98, 0x9453},
{0x7C9B, 0x8F6C},
{0x7C9F, 0x88BE},
{0x7CA1, 0xE2E7},
{0x7CA2, 0xE2E5},
{0x7CA4, 0xE2E3},
{0x7CA5, 0x8A9F},
{0x7CA7, 0x8FCF},
{0x7CA8, 0xE2E8},
{0x7CAB, 0xE2E6},
{0x7CAD, 0xE2E4},
{0x7CAE, 0xE2EC},
{0x7CB1, 0xE2EB},
{0x7CB2, 0xE2EA},
{0x7CB3, 0xE2E9},
{0x7CB9, 0xE2ED},
{0x7CBD, 0xE2EE},
{0x7CBE, 0x90B8},
{0x7CC0, 0xE2EF},
{0x7CC2, 0xE2F1},
{0x7CC5, 0xE2F0},
{0x7CCA, 0x8CD0},
{0x7CCE, 0x9157},
{0x7CD2, 0xE2F3},
{0x7CD6, 0x939C},
{0x7CD8, 0xE2F2},
{0x7CDC, 0xE2F4},
{0x7CDE, 0x95B3},
{0x7CDF, 0x918C},
{0x7CE0, 0x8D66},
{0x7CE2, 0xE2F5},
{0x7CE7, 0x97C6},
{0x7CEF, 0xE2F7},
{0x7CF2, 0xE2F8},
{0x7CF4, 0xE2F9},
{0x7CF6, 0xE2FA},
{0x7CF8, 0x8E85},
{0x7CFA, 0xE2FB},
{0x7CFB, 0x8C6E},
{0x7CFE, 0x8B8A},
{0x7D00, 0x8B49},
{0x7D02, 0xE340},
{0x7D04, 0x96F1},
{0x7D05, 0x8D67},
{0x7D06, 0xE2FC},
{0x7D0A, 0xE343},
{0x7D0B, 0x96E4},
{0x7D0D, 0x945B},
{0x7D10, 0x9552},
{0x7D14, 0x8F83},
{0x7D15, 0xE342},
{0x7D17, 0x8ED1},
{0x7D18, 0x8D68},
{0x7D19, 0x8E86},
{0x7D1A, 0x8B89},
{0x7D1B, 0x95B4},
{0x7D1C, 0xE341},
{0x7D20, 0x9166},
{0x7D21, 0x9661},
{0x7D22, 0x8DF5},
{0x7D2B, 0x8E87},
{0x7D2C, 0x92DB},
{0x7D2E, 0xE346},
{0x7D2F, 0x97DD},
{0x7D30, 0x8DD7},
{0x7D32, 0xE347},
{0x7D33, 0x9061},
{0x7D35, 0xE349},
{0x7D39, 0x8FD0},
{0x7D3A, 0x8DAE},
{0x7D3F, 0xE348},
{0x7D42, 0x8F49},
{0x7D43, 0x8CBC},
{0x7D44, 0x9167},
{0x7D45, 0xE344},
{0x7D46, 0xE34A},
{0x7D48, 0xFB8A},
{0x7D4B, 0xE345},
{0x7D4C, 0x8C6F},
{0x7D4E, 0xE34D},
{0x7D4F, 0xE351},
{0x7D50, 0x8C8B},
{0x7D56, 0xE34C},
{0x7D5B, 0xE355},
{0x7D5C, 0xFB8B},
{0x7D5E, 0x8D69},
{0x7D61, 0x978D},
{0x7D62, 0x88BA},
{0x7D63, 0xE352},
{0x7D66, 0x8B8B},
{0x7D68, 0xE34F},
{0x7D6E, 0xE350},
{0x7D71, 0x939D},
{0x7D72, 0xE34E},
{0x7D73, 0xE34B},
{0x7D75, 0x8A47},
{0x7D76, 0x90E2},
{0x7D79, 0x8CA6},
{0x7D7D, 0xE357},
{0x7D89, 0xE354},
{0x7D8F, 0xE356},
{0x7D93, 0xE353},
{0x7D99, 0x8C70},
{0x7D9A, 0x91B1},
{0x7D9B, 0xE358},
{0x7D9C, 0x918E},
{0x7D9F, 0xE365},
{0x7DA0, 0xFB8D},
{0x7DA2, 0xE361},
{0x7DA3, 0xE35B},
{0x7DAB, 0xE35F},
{0x7DAC, 0x8EF8},
{0x7DAD, 0x88DB},
{0x7DAE, 0xE35A},
{0x7DAF, 0xE362},
{0x7DB0, 0xE366},
{0x7DB1, 0x8D6A},
{0x7DB2, 0x96D4},
{0x7DB4, 0x92D4},
{0x7DB5, 0xE35C},
{0x7DB7, 0xFB8C},
{0x7DB8, 0xE364},
{0x7DBA, 0xE359},
{0x7DBB, 0x925D},
{0x7DBD, 0xE35E},
{0x7DBE, 0x88BB},
{0x7DBF, 0x96C8},
{0x7DC7, 0xE35D},
{0x7DCA, 0x8BD9},
{0x7DCB, 0x94EA},
{0x7DCF, 0x918D},
{0x7DD1, 0x97CE},
{0x7DD2, 0x8F8F},
{0x7DD5, 0xE38E},
{0x7DD6, 0xFB8E},
{0x7DD8, 0xE367},
{0x7DDA, 0x90FC},
{0x7DDC, 0xE363},
{0x7DDD, 0xE368},
{0x7DDE, 0xE36A},
{0x7DE0, 0x92F7},
{0x7DE1, 0xE36D},
{0x7DE4, 0xE369},
{0x7DE8, 0x95D2},
{0x7DE9, 0x8AC9},
{0x7DEC, 0x96C9},
{0x7DEF, 0x88DC},
{0x7DF2, 0xE36C},
{0x7DF4, 0x97FB},
{0x7DFB, 0xE36B},
{0x7E01, 0x898F},
{0x7E04, 0x93EA},
{0x7E05, 0xE36E},
{0x7E09, 0xE375},
{0x7E0A, 0xE36F},
{0x7E0B, 0xE376},
{0x7E12, 0xE372},
{0x7E1B, 0x949B},
{0x7E1E, 0x8EC8},
{0x7E1F, 0xE374},
{0x7E21, 0xE371},
{0x7E22, 0xE377},
{0x7E23, 0xE370},
{0x7E26, 0x8F63},
{0x7E2B, 0x9644},
{0x7E2E, 0x8F6B},
{0x7E31, 0xE373},
{0x7E32, 0xE380},
{0x7E35, 0xE37B},
{0x7E37, 0xE37E},
{0x7E39, 0xE37C},
{0x7E3A, 0xE381},
{0x7E3B, 0xE37A},
{0x7E3D, 0xE360},
{0x7E3E, 0x90D1},
{0x7E41, 0x94C9},
{0x7E43, 0xE37D},
{0x7E46, 0xE378},
{0x7E4A, 0x9140},
{0x7E4B, 0x8C71},
{0x7E4D, 0x8F4A},
{0x7E52, 0xFB8F},
{0x7E54, 0x9044},
{0x7E55, 0x9155},
{0x7E56, 0xE384},
{0x7E59, 0xE386},
{0x7E5A, 0xE387},
{0x7E5D, 0xE383},
{0x7E5E, 0xE385},
{0x7E66, 0xE379},
{0x7E67, 0xE382},
{0x7E69, 0xE38A},
{0x7E6A, 0xE389},
{0x7E6D, 0x969A},
{0x7E70, 0x8C4A},
{0x7E79, 0xE388},
{0x7E7B, 0xE38C},
{0x7E7C, 0xE38B},
{0x7E7D, 0xE38F},
{0x7E7F, 0xE391},
{0x7E82, 0x8E5B},
{0x7E83, 0xE38D},
{0x7E88, 0xE392},
{0x7E89, 0xE393},
{0x7E8A, 0xFA5C},
{0x7E8C, 0xE394},
{0x7E8E, 0xE39A},
{0x7E8F, 0x935A},
{0x7E90, 0xE396},
{0x7E92, 0xE395},
{0x7E93, 0xE397},
{0x7E94, 0xE398},
{0x7E96, 0xE399},
{0x7E9B, 0xE39B},
{0x7E9C, 0xE39C},
{0x7F36, 0x8ACA},
{0x7F38, 0xE39D},
{0x7F3A, 0xE39E},
{0x7F45, 0xE39F},
{0x7F47, 0xFB90},
{0x7F4C, 0xE3A0},
{0x7F4D, 0xE3A1},
{0x7F4E, 0xE3A2},
{0x7F50, 0xE3A3},
{0x7F51, 0xE3A4},
{0x7F54, 0xE3A6},
{0x7F55, 0xE3A5},
{0x7F58, 0xE3A7},
{0x7F5F, 0xE3A8},
{0x7F60, 0xE3A9},
{0x7F67, 0xE3AC},
{0x7F68, 0xE3AA},
{0x7F69, 0xE3AB},
{0x7F6A, 0x8DDF},
{0x7F6B, 0x8C72},
{0x7F6E, 0x9275},
{0x7F70, 0x94B1},
{0x7F72, 0x8F90},
{0x7F75, 0x946C},
{0x7F77, 0x94EB},
{0x7F78, 0xE3AD},
{0x7F79, 0x9CEB},
{0x7F82, 0xE3AE},
{0x7F83, 0xE3B0},
{0x7F85, 0x9785},
{0x7F86, 0xE3AF},
{0x7F87, 0xE3B2},
{0x7F88, 0xE3B1},
{0x7F8A, 0x9772},
{0x7F8C, 0xE3B3},
{0x7F8E, 0x94FC},
{0x7F94, 0xE3B4},
{0x7F9A, 0xE3B7},
{0x7F9D, 0xE3B6},
{0x7F9E, 0xE3B5},
{0x7FA1, 0xFB91},
{0x7FA3, 0xE3B8},
{0x7FA4, 0x8C51},
{0x7FA8, 0x9141},
{0x7FA9, 0x8B60},
{0x7FAE, 0xE3BC},
{0x7FAF, 0xE3B9},
{0x7FB2, 0xE3BA},
{0x7FB6, 0xE3BD},
{0x7FB8, 0xE3BE},
{0x7FB9, 0xE3BB},
{0x7FBD, 0x8948},
{0x7FC1, 0x89A5},
{0x7FC5, 0xE3C0},
{0x7FC6, 0xE3C1},
{0x7FCA, 0xE3C2},
{0x7FCC, 0x9782},
{0x7FD2, 0x8F4B},
{0x7FD4, 0xE3C4},
{0x7FD5, 0xE3C3},
{0x7FE0, 0x9089},
{0x7FE1, 0xE3C5},
{0x7FE6, 0xE3C6},
{0x7FE9, 0xE3C7},
{0x7FEB, 0x8AE3},
{0x7FF0, 0x8ACB},
{0x7FF3, 0xE3C8},
{0x7FF9, 0xE3C9},
{0x7FFB, 0x967C},
{0x7FFC, 0x9783},
{0x8000, 0x9773},
{0x8001, 0x9856},
{0x8003, 0x8D6C},
{0x8004, 0xE3CC},
{0x8005, 0x8ED2},
{0x8006, 0xE3CB},
{0x800B, 0xE3CD},
{0x800C, 0x8EA7},
{0x8010, 0x91CF},
{0x8012, 0xE3CE},
{0x8015, 0x8D6B},
{0x8017, 0x96D5},
{0x8018, 0xE3CF},
{0x8019, 0xE3D0},
{0x801C, 0xE3D1},
{0x8021, 0xE3D2},
{0x8028, 0xE3D3},
{0x8033, 0x8EA8},
{0x8036, 0x96EB},
{0x803B, 0xE3D5},
{0x803D, 0x925E},
{0x803F, 0xE3D4},
{0x8046, 0xE3D7},
{0x804A, 0xE3D6},
{0x8052, 0xE3D8},
{0x8056, 0x90B9},
{0x8058, 0xE3D9},
{0x805A, 0xE3DA},
{0x805E, 0x95B7},
{0x805F, 0xE3DB},
{0x8061, 0x918F},
{0x8062, 0xE3DC},
{0x8068, 0xE3DD},
{0x806F, 0x97FC},
{0x8070, 0xE3E0},
{0x8072, 0xE3DF},
{0x8073, 0xE3DE},
{0x8074, 0x92AE},
{0x8076, 0xE3E1},
{0x8077, 0x9045},
{0x8079, 0xE3E2},
{0x807D, 0xE3E3},
{0x807E, 0x9857},
{0x807F, 0xE3E4},
{0x8084, 0xE3E5},
{0x8085, 0xE3E7},
{0x8086, 0xE3E6},
{0x8087, 0x94A3},
{0x8089, 0x93F7},
{0x808B, 0x985D},
{0x808C, 0x94A7},
{0x8093, 0xE3E9},
{0x8096, 0x8FD1},
{0x8098, 0x9549},
{0x809A, 0xE3EA},
{0x809B, 0xE3E8},
{0x809D, 0x8ACC},
{0x80A1, 0x8CD2},
{0x80A2, 0x8E88},
{0x80A5, 0x94EC},
{0x80A9, 0x8CA8},
{0x80AA, 0x9662},
{0x80AC, 0xE3ED},
{0x80AD, 0xE3EB},
{0x80AF, 0x8D6D},
{0x80B1, 0x8D6E},
{0x80B2, 0x88E7},
{0x80B4, 0x8DE6},
{0x80BA, 0x9478},
{0x80C3, 0x88DD},
{0x80C4, 0xE3F2},
{0x80C6, 0x925F},
{0x80CC, 0x9477},
{0x80CE, 0x91D9},
{0x80D6, 0xE3F4},
{0x80D9, 0xE3F0},
{0x80DA, 0xE3F3},
{0x80DB, 0xE3EE},
{0x80DD, 0xE3F1},
{0x80DE, 0x9645},
{0x80E1, 0x8CD3},
{0x80E4, 0x88FB},
{0x80E5, 0xE3EF},
{0x80EF, 0xE3F6},
{0x80F1, 0xE3F7},
{0x80F4, 0x93B7},
{0x80F8, 0x8BB9},
{0x80FC, 0xE445},
{0x80FD, 0x945C},
{0x8102, 0x8E89},
{0x8105, 0x8BBA},
{0x8106, 0x90C6},
{0x8107, 0x9865},
{0x8108, 0x96AC},
{0x8109, 0xE3F5},
{0x810A, 0x90D2},
{0x811A, 0x8B72},
{0x811B, 0xE3F8},
{0x8123, 0xE3FA},
{0x8129, 0xE3F9},
{0x812F, 0xE3FB},
{0x8131, 0x9245},
{0x8133, 0x945D},
{0x8139, 0x92AF},
{0x813E, 0xE442},
{0x8146, 0xE441},
{0x814B, 0xE3FC},
{0x814E, 0x9074},
{0x8150, 0x9585},
{0x8151, 0xE444},
{0x8153, 0xE443},
{0x8154, 0x8D6F},
{0x8155, 0x9872},
{0x815F, 0xE454},
{0x8165, 0xE448},
{0x8166, 0xE449},
{0x816B, 0x8EEE},
{0x816E, 0xE447},
{0x8170, 0x8D98},
{0x8171, 0xE446},
{0x8174, 0xE44A},
{0x8178, 0x92B0},
{0x8179, 0x95A0},
{0x817A, 0x9142},
{0x817F, 0x91DA},
{0x8180, 0xE44E},
{0x8182, 0xE44F},
{0x8183, 0xE44B},
{0x8188, 0xE44C},
{0x818A, 0xE44D},
{0x818F, 0x8D70},
{0x8193, 0xE455},
{0x8195, 0xE451},
{0x819A, 0x9586},
{0x819C, 0x968C},
{0x819D, 0x9547},
{0x81A0, 0xE450},
{0x81A3, 0xE453},
{0x81A4, 0xE452},
{0x81A8, 0x9663},
{0x81A9, 0xE456},
{0x81B0, 0xE457},
{0x81B3, 0x9156},
{0x81B5, 0xE458},
{0x81B8, 0xE45A},
{0x81BA, 0xE45E},
{0x81BD, 0xE45B},
{0x81BE, 0xE459},
{0x81BF, 0x945E},
{0x81C0, 0xE45C},
{0x81C2, 0xE45D},
{0x81C6, 0x89B0},
{0x81C8, 0xE464},
{0x81C9, 0xE45F},
{0x81CD, 0xE460},
{0x81D1, 0xE461},
{0x81D3, 0x919F},
{0x81D8, 0xE463},
{0x81D9, 0xE462},
{0x81DA, 0xE465},
{0x81DF, 0xE466},
{0x81E0, 0xE467},
{0x81E3, 0x9062},
{0x81E5, 0x89E7},
{0x81E7, 0xE468},
{0x81E8, 0x97D5},
{0x81EA, 0x8EA9},
{0x81ED, 0x8F4C},
{0x81F3, 0x8E8A},
{0x81F4, 0x9276},
{0x81FA, 0xE469},
{0x81FB, 0xE46A},
{0x81FC, 0x8950},
{0x81FE, 0xE46B},
{0x8201, 0xE46C},
{0x8202, 0xE46D},
{0x8205, 0xE46E},
{0x8207, 0xE46F},
{0x8208, 0x8BBB},
{0x8209, 0x9DA8},
{0x820A, 0xE470},
{0x820C, 0x90E3},
{0x820D, 0xE471},
{0x820E, 0x8EC9},
{0x8210, 0xE472},
{0x8212, 0x98AE},
{0x8216, 0xE473},
{0x8217, 0x95DC},
{0x8218, 0x8ADA},
{0x821B, 0x9143},
{0x821C, 0x8F77},
{0x821E, 0x9591},
{0x821F, 0x8F4D},
{0x8229, 0xE474},
{0x822A, 0x8D71},
{0x822B, 0xE475},
{0x822C, 0x94CA},
{0x822E, 0xE484},
{0x8233, 0xE477},
{0x8235, 0x91C7},
{0x8236, 0x9495},
{0x8237, 0x8CBD},
{0x8238, 0xE476},
{0x8239, 0x9144},
{0x8240, 0xE478},
{0x8247, 0x92F8},
{0x8258, 0xE47A},
{0x8259, 0xE479},
{0x825A, 0xE47C},
{0x825D, 0xE47B},
{0x825F, 0xE47D},
{0x8262, 0xE480},
{0x8264, 0xE47E},
{0x8266, 0x8ACD},
{0x8268, 0xE481},
{0x826A, 0xE482},
{0x826B, 0xE483},
{0x826E, 0x8DAF},
{0x826F, 0x97C7},
{0x8271, 0xE485},
{0x8272, 0x9046},
{0x8276, 0x8990},
{0x8277, 0xE486},
{0x8278, 0xE487},
{0x827E, 0xE488},
{0x828B, 0x88F0},
{0x828D, 0xE489},
{0x8292, 0xE48A},
{0x8299, 0x9587},
{0x829D, 0x8EC5},
{0x829F, 0xE48C},
{0x82A5, 0x8A48},
{0x82A6, 0x88B0},
{0x82AB, 0xE48B},
{0x82AC, 0xE48E},
{0x82AD, 0x946D},
{0x82AF, 0x9063},
{0x82B1, 0x89D4},
{0x82B3, 0x9646},
{0x82B8, 0x8C7C},
{0x82B9, 0x8BDA},
{0x82BB, 0xE48D},
{0x82BD, 0x89E8},
{0x82C5, 0x8AA1},
{0x82D1, 0x8991},
{0x82D2, 0xE492},
{0x82D3, 0x97E8},
{0x82D4, 0x91DB},
{0x82D7, 0x9563},
{0x82D9, 0xE49E},
{0x82DB, 0x89D5},
{0x82DC, 0xE49C},
{0x82DE, 0xE49A},
{0x82DF, 0xE491},
{0x82E1, 0xE48F},
{0x82E3, 0xE490},
{0x82E5, 0x8EE1},
{0x82E6, 0x8BEA},
{0x82E7, 0x9297},
{0x82EB, 0x93CF},
{0x82F1, 0x8970},
{0x82F3, 0xE494},
{0x82F4, 0xE493},
{0x82F9, 0xE499},
{0x82FA, 0xE495},
{0x82FB, 0xE498},
{0x8301, 0xFB93},
{0x8302, 0x96CE},
{0x8303, 0xE497},
{0x8304, 0x89D6},
{0x8305, 0x8A9D},
{0x8306, 0xE49B},
{0x8309, 0xE49D},
{0x830E, 0x8C73},
{0x8316, 0xE4A1},
{0x8317, 0xE4AA},
{0x8318, 0xE4AB},
{0x831C, 0x88A9},
{0x8323, 0xE4B2},
{0x8328, 0x88EF},
{0x832B, 0xE4A9},
{0x832F, 0xE4A8},
{0x8331, 0xE4A3},
{0x8332, 0xE4A2},
{0x8334, 0xE4A0},
{0x8335, 0xE49F},
{0x8336, 0x9283},
{0x8338, 0x91F9},
{0x8339, 0xE4A5},
{0x8340, 0xE4A4},
{0x8345, 0xE4A7},
{0x8349, 0x9190},
{0x834A, 0x8C74},
{0x834F, 0x8960},
{0x8350, 0xE4A6},
{0x8352, 0x8D72},
{0x8358, 0x9191},
{0x8362, 0xFB94},
{0x8373, 0xE4B8},
{0x8375, 0xE4B9},
{0x8377, 0x89D7},
{0x837B, 0x89AC},
{0x837C, 0xE4B6},
{0x837F, 0xFB95},
{0x8385, 0xE4AC},
{0x8387, 0xE4B4},
{0x8389, 0xE4BB},
{0x838A, 0xE4B5},
{0x838E, 0xE4B3},
{0x8393, 0xE496},
{0x8396, 0xE4B1},
{0x839A, 0xE4AD},
{0x839E, 0x8ACE},
{0x839F, 0xE4AF},
{0x83A0, 0xE4BA},
{0x83A2, 0xE4B0},
{0x83A8, 0xE4BC},
{0x83AA, 0xE4AE},
{0x83AB, 0x949C},
{0x83B1, 0x9789},
{0x83B5, 0xE4B7},
{0x83BD, 0xE4CD},
{0x83C1, 0xE4C5},
{0x83C5, 0x909B},
{0x83C7, 0xFB96},
{0x83CA, 0x8B65},
{0x83CC, 0x8BDB},
{0x83CE, 0xE4C0},
{0x83D3, 0x89D9},
{0x83D6, 0x8FD2},
{0x83D8, 0xE4C3},
{0x83DC, 0x8DD8},
{0x83DF, 0x9370},
{0x83E0, 0xE4C8},
{0x83E9, 0x95EC},
{0x83EB, 0xE4BF},
{0x83EF, 0x89D8},
{0x83F0, 0x8CD4},
{0x83F1, 0x9548},
{0x83F2, 0xE4C9},
{0x83F4, 0xE4BD},
{0x83F6, 0xFB97},
{0x83F7, 0xE4C6},
{0x83FB, 0xE4D0},
{0x83FD, 0xE4C1},
{0x8403, 0xE4C2},
{0x8404, 0x93B8},
{0x8407, 0xE4C7},
{0x840B, 0xE4C4},
{0x840C, 0x9647},
{0x840D, 0xE4CA},
{0x840E, 0x88DE},
{0x8413, 0xE4BE},
{0x8420, 0xE4CC},
{0x8422, 0xE4CB},
{0x8429, 0x948B},
{0x842A, 0xE4D2},
{0x842C, 0xE4DD},
{0x8431, 0x8A9E},
{0x8435, 0xE4E0},
{0x8438, 0xE4CE},
{0x843C, 0xE4D3},
{0x843D, 0x978E},
{0x8446, 0xE4DC},
{0x8448, 0xFB98},
{0x8449, 0x9774},
{0x844E, 0x97A8},
{0x8457, 0x9298},
{0x845B, 0x8A8B},
{0x8461, 0x9592},
{0x8462, 0xE4E2},
{0x8463, 0x939F},
{0x8466, 0x88AF},
{0x8469, 0xE4DB},
{0x846B, 0xE4D7},
{0x846C, 0x9192},
{0x846D, 0xE4D1},
{0x846E, 0xE4D9},
{0x846F, 0xE4DE},
{0x8471, 0x944B},
{0x8475, 0x88A8},
{0x8477, 0xE4D6},
{0x8479, 0xE4DF},
{0x847A, 0x9598},
{0x8482, 0xE4DA},
{0x8484, 0xE4D5},
{0x848B, 0x8FD3},
{0x8490, 0x8F4E},
{0x8494, 0x8EAA},
{0x8499, 0x96D6},
{0x849C, 0x9566},
{0x849F, 0xE4E5},
{0x84A1, 0xE4EE},
{0x84AD, 0xE4D8},
{0x84B2, 0x8A97},
{0x84B4, 0xFB99},
{0x84B8, 0x8FF6},
{0x84B9, 0xE4E3},
{0x84BB, 0xE4E8},
{0x84BC, 0x9193},
{0x84BF, 0xE4E4},
{0x84C1, 0xE4EB},
{0x84C4, 0x927E},
{0x84C6, 0xE4EC},
{0x84C9, 0x9775},
{0x84CA, 0xE4E1},
{0x84CB, 0x8A57},
{0x84CD, 0xE4E7},
{0x84D0, 0xE4EA},
{0x84D1, 0x96AA},
{0x84D6, 0xE4ED},
{0x84D9, 0xE4E6},
{0x84DA, 0xE4E9},
{0x84DC, 0xFA60},
{0x84EC, 0x9648},
{0x84EE, 0x9840},
{0x84F4, 0xE4F1},
{0x84FC, 0xE4F8},
{0x84FF, 0xE4F0},
{0x8500, 0x8EC1},
{0x8506, 0xE4CF},
{0x8511, 0x95CC},
{0x8513, 0x96A0},
{0x8514, 0xE4F7},
{0x8515, 0xE4F6},
{0x8517, 0xE4F2},
{0x8518, 0xE4F3},
{0x851A, 0x8955},
{0x851F, 0xE4F5},
{0x8521, 0xE4EF},
{0x8526, 0x92D3},
{0x852C, 0xE4F4},
{0x852D, 0x88FC},
{0x8535, 0x91A0},
{0x853D, 0x95C1},
{0x8540, 0xE4F9},
{0x8541, 0xE540},
{0x8543, 0x94D7},
{0x8548, 0xE4FC},
{0x8549, 0x8FD4},
{0x854A, 0x8EC7},
{0x854B, 0xE542},
{0x854E, 0x8BBC},
{0x8553, 0xFB9A},
{0x8555, 0xE543},
{0x8557, 0x9599},
{0x8558, 0xE4FB},
{0x8559, 0xFB9B},
{0x855A, 0xE4D4},
{0x8563, 0xE4FA},
{0x8568, 0x986E},
{0x8569, 0x93A0},
{0x856A, 0x9593},
{0x856B, 0xFB9C},
{0x856D, 0xE54A},
{0x8577, 0xE550},
{0x857E, 0xE551},
{0x8580, 0xE544},
{0x8584, 0x9496},
{0x8587, 0xE54E},
{0x8588, 0xE546},
{0x858A, 0xE548},
{0x8590, 0xE552},
{0x8591, 0xE547},
{0x8594, 0xE54B},
{0x8597, 0x8992},
{0x8599, 0x93E3},
{0x859B, 0xE54C},
{0x859C, 0xE54F},
{0x85A4, 0xE545},
{0x85A6, 0x9145},
{0x85A8, 0xE549},
{0x85A9, 0x8E46},
{0x85AA, 0x9064},
{0x85AB, 0x8C4F},
{0x85AC, 0x96F2},
{0x85AE, 0x96F7},
{0x85AF, 0x8F92},
{0x85B0, 0xFB9E},
{0x85B9, 0xE556},
{0x85BA, 0xE554},
{0x85C1, 0x986D},
{0x85C9, 0xE553},
{0x85CD, 0x9795},
{0x85CF, 0xE555},
{0x85D0, 0xE557},
{0x85D5, 0xE558},
{0x85DC, 0xE55B},
{0x85DD, 0xE559},
{0x85E4, 0x93A1},
{0x85E5, 0xE55A},
{0x85E9, 0x94CB},
{0x85EA, 0xE54D},
{0x85F7, 0x8F93},
{0x85F9, 0xE55C},
{0x85FA, 0xE561},
{0x85FB, 0x9194},
{0x85FE, 0xE560},
{0x8602, 0xE541},
{0x8606, 0xE562},
{0x8607, 0x9168},
{0x860A, 0xE55D},
{0x860B, 0xE55F},
{0x8613, 0xE55E},
{0x8616, 0x9F50},
{0x8617, 0x9F41},
{0x861A, 0xE564},
{0x8622, 0xE563},
{0x862D, 0x9796},
{0x862F, 0xE1BA},
{0x8630, 0xE565},
{0x863F, 0xE566},
{0x864D, 0xE567},
{0x864E, 0x8CD5},
{0x8650, 0x8B73},
{0x8654, 0xE569},
{0x8655, 0x997C},
{0x865A, 0x8B95},
{0x865C, 0x97B8},
{0x865E, 0x8BF1},
{0x865F, 0xE56A},
{0x8667, 0xE56B},
{0x866B, 0x928E},
{0x8671, 0xE56C},
{0x8679, 0x93F8},
{0x867B, 0x88B8},
{0x868A, 0x89E1},
{0x868B, 0xE571},
{0x868C, 0xE572},
{0x8693, 0xE56D},
{0x8695, 0x8E5C},
{0x86A3, 0xE56E},
{0x86A4, 0x9461},
{0x86A9, 0xE56F},
{0x86AA, 0xE570},
{0x86AB, 0xE57A},
{0x86AF, 0xE574},
{0x86B0, 0xE577},
{0x86B6, 0xE573},
{0x86C4, 0xE575},
{0x86C6, 0xE576},
{0x86C7, 0x8ED6},
{0x86C9, 0xE578},
{0x86CB, 0x9260},
{0x86CD, 0x8C75},
{0x86CE, 0x8A61},
{0x86D4, 0xE57B},
{0x86D9, 0x8A5E},
{0x86DB, 0xE581},
{0x86DE, 0xE57C},
{0x86DF, 0xE580},
{0x86E4, 0x94B8},
{0x86E9, 0xE57D},
{0x86EC, 0xE57E},
{0x86ED, 0x9567},
{0x86EE, 0x94D8},
{0x86EF, 0xE582},
{0x86F8, 0x91FB},
{0x86F9, 0xE58C},
{0x86FB, 0xE588},
{0x86FE, 0x89E9},
{0x8700, 0xE586},
{0x8702, 0x9649},
{0x8703, 0xE587},
{0x8706, 0xE584},
{0x8708, 0xE585},
{0x8709, 0xE58A},
{0x870A, 0xE58D},
{0x870D, 0xE58B},
{0x8711, 0xE589},
{0x8712, 0xE583},
{0x8718, 0x9277},
{0x871A, 0xE594},
{0x871C, 0x96A8},
{0x8725, 0xE592},
{0x8729, 0xE593},
{0x8734, 0xE58E},
{0x8737, 0xE590},
{0x873B, 0xE591},
{0x873F, 0xE58F},
{0x8749, 0x90E4},
{0x874B, 0x9858},
{0x874C, 0xE598},
{0x874E, 0xE599},
{0x8753, 0xE59F},
{0x8755, 0x9049},
{0x8757, 0xE59B},
{0x8759, 0xE59E},
{0x875F, 0xE596},
{0x8760, 0xE595},
{0x8763, 0xE5A0},
{0x8766, 0x89DA},
{0x8768, 0xE59C},
{0x876A, 0xE5A1},
{0x876E, 0xE59D},
{0x8774, 0xE59A},
{0x8776, 0x92B1},
{0x8778, 0xE597},
{0x877F, 0x9488},
{0x8782, 0xE5A5},
{0x878D, 0x975A},
{0x879F, 0xE5A4},
{0x87A2, 0xE5A3},
{0x87AB, 0xE5AC},
{0x87AF, 0xE5A6},
{0x87B3, 0xE5AE},
{0x87BA, 0x9786},
{0x87BB, 0xE5B1},
{0x87BD, 0xE5A8},
{0x87C0, 0xE5A9},
{0x87C4, 0xE5AD},
{0x87C6, 0xE5B0},
{0x87C7, 0xE5AF},
{0x87CB, 0xE5A7},
{0x87D0, 0xE5AA},
{0x87D2, 0xE5BB},
{0x87E0, 0xE5B4},
{0x87EF, 0xE5B2},
{0x87F2, 0xE5B3},
{0x87F6, 0xE5B8},
{0x87F7, 0xE5B9},
{0x87F9, 0x8A49},
{0x87FB, 0x8B61},
{0x87FE, 0xE5B7},
{0x8805, 0xE5A2},
{0x8807, 0xFBA1},
{0x880D, 0xE5B6},
{0x880E, 0xE5BA},
{0x880F, 0xE5B5},
{0x8811, 0xE5BC},
{0x8815, 0xE5BE},
{0x8816, 0xE5BD},
{0x8821, 0xE5C0},
{0x8822, 0xE5BF},
{0x8823, 0xE579},
{0x8827, 0xE5C4},
{0x8831, 0xE5C1},
{0x8836, 0xE5C2},
{0x8839, 0xE5C3},
{0x883B, 0xE5C5},
{0x8840, 0x8C8C},
{0x8842, 0xE5C7},
{0x8844, 0xE5C6},
{0x8846, 0x8F4F},
{0x884C, 0x8D73},
{0x884D, 0x9FA5},
{0x8852, 0xE5C8},
{0x8853, 0x8F70},
{0x8857, 0x8A58},
{0x8859, 0xE5C9},
{0x885B, 0x8971},
{0x885D, 0x8FD5},
{0x885E, 0xE5CA},
{0x8861, 0x8D74},
{0x8862, 0xE5CB},
{0x8863, 0x88DF},
{0x8868, 0x955C},
{0x886B, 0xE5CC},
{0x8870, 0x908A},
{0x8872, 0xE5D3},
{0x8875, 0xE5D0},
{0x8877, 0x928F},
{0x887D, 0xE5D1},
{0x887E, 0xE5CE},
{0x887F, 0x8BDC},
{0x8881, 0xE5CD},
{0x8882, 0xE5D4},
{0x8888, 0x8C55},
{0x888B, 0x91DC},
{0x888D, 0xE5DA},
{0x8892, 0xE5D6},
{0x8896, 0x91B3},
{0x8897, 0xE5D5},
{0x8899, 0xE5D8},
{0x889E, 0xE5CF},
{0x88A2, 0xE5D9},
{0x88A4, 0xE5DB},
{0x88AB, 0x94ED},
{0x88AE, 0xE5D7},
{0x88B0, 0xE5DC},
{0x88B1, 0xE5DE},
{0x88B4, 0x8CD1},
{0x88B5, 0xE5D2},
{0x88B7, 0x88BF},
{0x88BF, 0xE5DD},
{0x88C1, 0x8DD9},
{0x88C2, 0x97F4},
{0x88C3, 0xE5DF},
{0x88C4, 0xE5E0},
{0x88C5, 0x9195},
{0x88CF, 0x97A0},
{0x88D4, 0xE5E1},
{0x88D5, 0x9754},
{0x88D8, 0xE5E2},
{0x88D9, 0xE5E3},
{0x88DC, 0x95E2},
{0x88DD, 0xE5E4},
{0x88DF, 0x8DBE},
{0x88E1, 0x97A1},
{0x88E8, 0xE5E9},
{0x88F2, 0xE5EA},
{0x88F3, 0x8FD6},
{0x88F4, 0xE5E8},
{0x88F5, 0xFBA2},
{0x88F8, 0x9787},
{0x88F9, 0xE5E5},
{0x88FC, 0xE5E7},
{0x88FD, 0x90BB},
{0x88FE, 0x909E},
{0x8902, 0xE5E6},
{0x8904, 0xE5EB},
{0x8907, 0x95A1},
{0x890A, 0xE5ED},
{0x890C, 0xE5EC},
{0x8910, 0x8A8C},
{0x8912, 0x964A},
{0x8913, 0xE5EE},
{0x891C, 0xFA5D},
{0x891D, 0xE5FA},
{0x891E, 0xE5F0},
{0x8925, 0xE5F1},
{0x892A, 0xE5F2},
{0x892B, 0xE5F3},
{0x8936, 0xE5F7},
{0x8938, 0xE5F8},
{0x893B, 0xE5F6},
{0x8941, 0xE5F4},
{0x8943, 0xE5EF},
{0x8944, 0xE5F5},
{0x894C, 0xE5F9},
{0x894D, 0xE8B5},
{0x8956, 0x89A6},
{0x895E, 0xE5FC},
{0x895F, 0x8BDD},
{0x8960, 0xE5FB},
{0x8964, 0xE641},
{0x8966, 0xE640},
{0x896A, 0xE643},
{0x896D, 0xE642},
{0x896F, 0xE644},
{0x8972, 0x8F50},
{0x8974, 0xE645},
{0x8977, 0xE646},
{0x897E, 0xE647},
{0x897F, 0x90BC},
{0x8981, 0x9776},
{0x8983, 0xE648},
{0x8986, 0x95A2},
{0x8987, 0x9465},
{0x8988, 0xE649},
{0x898A, 0xE64A},
{0x898B, 0x8CA9},
{0x898F, 0x8B4B},
{0x8993, 0xE64B},
{0x8996, 0x8E8B},
{0x8997, 0x9460},
{0x8998, 0xE64C},
{0x899A, 0x8A6F},
{0x89A1, 0xE64D},
{0x89A6, 0xE64F},
{0x89A7, 0x9797},
{0x89A9, 0xE64E},
{0x89AA, 0x9065},
{0x89AC, 0xE650},
{0x89AF, 0xE651},
{0x89B2, 0xE652},
{0x89B3, 0x8ACF},
{0x89BA, 0xE653},
{0x89BD, 0xE654},
{0x89BF, 0xE655},
{0x89C0, 0xE656},
{0x89D2, 0x8A70},
{0x89DA, 0xE657},
{0x89DC, 0xE658},
{0x89DD, 0xE659},
{0x89E3, 0x89F0},
{0x89E6, 0x9047},
{0x89E7, 0xE65A},
{0x89F4, 0xE65B},
{0x89F8, 0xE65C},
{0x8A00, 0x8CBE},
{0x8A02, 0x92F9},
{0x8A03, 0xE65D},
{0x8A08, 0x8C76},
{0x8A0A, 0x9075},
{0x8A0C, 0xE660},
{0x8A0E, 0x93A2},
{0x8A10, 0xE65F},
{0x8A12, 0xFBA3},
{0x8A13, 0x8C50},
{0x8A16, 0xE65E},
{0x8A17, 0x91F5},
{0x8A18, 0x8B4C},
{0x8A1B, 0xE661},
{0x8A1D, 0xE662},
{0x8A1F, 0x8FD7},
{0x8A23, 0x8C8D},
{0x8A25, 0xE663},
{0x8A2A, 0x964B},
{0x8A2D, 0x90DD},
{0x8A31, 0x8B96},
{0x8A33, 0x96F3},
{0x8A34, 0x9169},
{0x8A36, 0xE664},
{0x8A37, 0xFBA4},
{0x8A3A, 0x9066},
{0x8A3B, 0x9290},
{0x8A3C, 0x8FD8},
{0x8A41, 0xE665},
{0x8A46, 0xE668},
{0x8A48, 0xE669},
{0x8A50, 0x8DBC},
{0x8A51, 0x91C0},
{0x8A52, 0xE667},
{0x8A54, 0x8FD9},
{0x8A55, 0x955D},
{0x8A5B, 0xE666},
{0x8A5E, 0x8E8C},
{0x8A60, 0x8972},
{0x8A62, 0xE66D},
{0x8A63, 0x8C77},
{0x8A66, 0x8E8E},
{0x8A69, 0x8E8D},
{0x8A6B, 0x986C},
{0x8A6C, 0xE66C},
{0x8A6D, 0xE66B},
{0x8A6E, 0x9146},
{0x8A70, 0x8B6C},
{0x8A71, 0x9862},
{0x8A72, 0x8A59},
{0x8A73, 0x8FDA},
{0x8A79, 0xFBA5},
{0x8A7C, 0xE66A},
{0x8A82, 0xE66F},
{0x8A84, 0xE670},
{0x8A85, 0xE66E},
{0x8A87, 0x8CD6},
{0x8A89, 0x975F},
{0x8A8C, 0x8E8F},
{0x8A8D, 0x9446},
{0x8A91, 0xE673},
{0x8A93, 0x90BE},
{0x8A95, 0x9261},
{0x8A98, 0x9755},
{0x8A9A, 0xE676},
{0x8A9E, 0x8CEA},
{0x8AA0, 0x90BD},
{0x8AA1, 0xE672},
{0x8AA3, 0xE677},
{0x8AA4, 0x8CEB},
{0x8AA5, 0xE674},
{0x8AA6, 0xE675},
{0x8AA7, 0xFBA6},
{0x8AA8, 0xE671},
{0x8AAC, 0x90E0},
{0x8AAD, 0x93C7},
{0x8AB0, 0x924E},
{0x8AB2, 0x89DB},
{0x8AB9, 0x94EE},
{0x8ABC, 0x8B62},
{0x8ABE, 0xFBA7},
{0x8ABF, 0x92B2},
{0x8AC2, 0xE67A},
{0x8AC4, 0xE678},
{0x8AC7, 0x926B},
{0x8ACB, 0x90BF},
{0x8ACC, 0x8AD0},
{0x8ACD, 0xE679},
{0x8ACF, 0x907A},
{0x8AD2, 0x97C8},
{0x8AD6, 0x985F},
{0x8ADA, 0xE67B},
{0x8ADB, 0xE687},
{0x8ADC, 0x92B3},
{0x8ADE, 0xE686},
{0x8ADF, 0xFBA8},
{0x8AE0, 0xE683},
{0x8AE1, 0xE68B},
{0x8AE2, 0xE684},
{0x8AE4, 0xE680},
{0x8AE6, 0x92FA},
{0x8AE7, 0xE67E},
{0x8AEB, 0xE67C},
{0x8AED, 0x9740},
{0x8AEE, 0x8E90},
{0x8AF1, 0xE681},
{0x8AF3, 0xE67D},
{0x8AF6, 0xFBAA},
{0x8AF7, 0xE685},
{0x8AF8, 0x8F94},
{0x8AFA, 0x8CBF},
{0x8AFE, 0x91F8},
{0x8B00, 0x9664},
{0x8B01, 0x8979},
{0x8B02, 0x88E0},
{0x8B04, 0x93A3},
{0x8B07, 0xE689},
{0x8B0C, 0xE688},
{0x8B0E, 0x93E4},
{0x8B10, 0xE68D},
{0x8B14, 0xE682},
{0x8B16, 0xE68C},
{0x8B17, 0xE68E},
{0x8B19, 0x8CAA},
{0x8B1A, 0xE68A},
{0x8B1B, 0x8D75},
{0x8B1D, 0x8ED3},
{0x8B20, 0xE68F},
{0x8B21, 0x9777},
{0x8B26, 0xE692},
{0x8B28, 0xE695},
{0x8B2B, 0xE693},
{0x8B2C, 0x9554},
{0x8B33, 0xE690},
{0x8B39, 0x8BDE},
{0x8B3E, 0xE694},
{0x8B41, 0xE696},
{0x8B49, 0xE69A},
{0x8B4C, 0xE697},
{0x8B4E, 0xE699},
{0x8B4F, 0xE698},
{0x8B53, 0xFBAB},
{0x8B56, 0xE69B},
{0x8B58, 0x8EAF},
{0x8B5A, 0xE69D},
{0x8B5B, 0xE69C},
{0x8B5C, 0x9588},
{0x8B5F, 0xE69F},
{0x8B66, 0x8C78},
{0x8B6B, 0xE69E},
{0x8B6C, 0xE6A0},
{0x8B6F, 0xE6A1},
{0x8B70, 0x8B63},
{0x8B71, 0xE3BF},
{0x8B72, 0x8FF7},
{0x8B74, 0xE6A2},
{0x8B77, 0x8CEC},
{0x8B7D, 0xE6A3},
{0x8B7F, 0xFBAC},
{0x8B80, 0xE6A4},
{0x8B83, 0x8E5D},
{0x8B8A, 0x9DCC},
{0x8B8C, 0xE6A5},
{0x8B8E, 0xE6A6},
{0x8B90, 0x8F51},
{0x8B92, 0xE6A7},
{0x8B93, 0xE6A8},
{0x8B96, 0xE6A9},
{0x8B99, 0xE6AA},
{0x8B9A, 0xE6AB},
{0x8C37, 0x924A},
{0x8C3A, 0xE6AC},
{0x8C3F, 0xE6AE},
{0x8C41, 0xE6AD},
{0x8C46, 0x93A4},
{0x8C48, 0xE6AF},
{0x8C4A, 0x964C},
{0x8C4C, 0xE6B0},
{0x8C4E, 0xE6B1},
{0x8C50, 0xE6B2},
{0x8C55, 0xE6B3},
{0x8C5A, 0x93D8},
{0x8C61, 0x8FDB},
{0x8C62, 0xE6B4},
{0x8C6A, 0x8D8B},
{0x8C6B, 0x98AC},
{0x8C6C, 0xE6B5},
{0x8C78, 0xE6B6},
{0x8C79, 0x955E},
{0x8C7A, 0xE6B7},
{0x8C7C, 0xE6BF},
{0x8C82, 0xE6B8},
{0x8C85, 0xE6BA},
{0x8C89, 0xE6B9},
{0x8C8A, 0xE6BB},
{0x8C8C, 0x9665},
{0x8C8D, 0xE6BC},
{0x8C8E, 0xE6BD},
{0x8C94, 0xE6BE},
{0x8C98, 0xE6C0},
{0x8C9D, 0x8A4C},
{0x8C9E, 0x92E5},
{0x8CA0, 0x9589},
{0x8CA1, 0x8DE0},
{0x8CA2, 0x8D76},
{0x8CA7, 0x956E},
{0x8CA8, 0x89DD},
{0x8CA9, 0x94CC},
{0x8CAA, 0xE6C3},
{0x8CAB, 0x8AD1},
{0x8CAC, 0x90D3},
{0x8CAD, 0xE6C2},
{0x8CAE, 0xE6C7},
{0x8CAF, 0x9299},
{0x8CB0, 0x96E1},
{0x8CB2, 0xE6C5},
{0x8CB3, 0xE6C6},
{0x8CB4, 0x8B4D},
{0x8CB6, 0xE6C8},
{0x8CB7, 0x9483},
{0x8CB8, 0x91DD},
{0x8CBB, 0x94EF},
{0x8CBC, 0x935C},
{0x8CBD, 0xE6C4},
{0x8CBF, 0x9666},
{0x8CC0, 0x89EA},
{0x8CC1, 0xE6CA},
{0x8CC2, 0x9847},
{0x8CC3, 0x92C0},
{0x8CC4, 0x9864},
{0x8CC7, 0x8E91},
{0x8CC8, 0xE6C9},
{0x8CCA, 0x91AF},
{0x8CCD, 0xE6DA},
{0x8CCE, 0x9147},
{0x8CD1, 0x93F6},
{0x8CD3, 0x956F},
{0x8CDA, 0xE6CD},
{0x8CDB, 0x8E5E},
{0x8CDC, 0x8E92},
{0x8CDE, 0x8FDC},
{0x8CE0, 0x9485},
{0x8CE2, 0x8CAB},
{0x8CE3, 0xE6CC},
{0x8CE4, 0xE6CB},
{0x8CE6, 0x958A},
{0x8CEA, 0x8EBF},
{0x8CED, 0x9371},
{0x8CF0, 0xFBAD},
{0x8CF4, 0xFBAE},
{0x8CFA, 0xE6CF},
{0x8CFB, 0xE6D0},
{0x8CFC, 0x8D77},
{0x8CFD, 0xE6CE},
{0x8D04, 0xE6D1},
{0x8D05, 0xE6D2},
{0x8D07, 0xE6D4},
{0x8D08, 0x91A1},
{0x8D0A, 0xE6D3},
{0x8D0B, 0x8AE4},
{0x8D0D, 0xE6D6},
{0x8D0F, 0xE6D5},
{0x8D10, 0xE6D7},
{0x8D12, 0xFBAF},
{0x8D13, 0xE6D9},
{0x8D14, 0xE6DB},
{0x8D16, 0xE6DC},
{0x8D64, 0x90D4},
{0x8D66, 0x8ECD},
{0x8D67, 0xE6DD},
{0x8D6B, 0x8A71},
{0x8D6D, 0xE6DE},
{0x8D70, 0x9196},
{0x8D71, 0xE6DF},
{0x8D73, 0xE6E0},
{0x8D74, 0x958B},
{0x8D76, 0xFBB0},
{0x8D77, 0x8B4E},
{0x8D81, 0xE6E1},
{0x8D85, 0x92B4},
{0x8D8A, 0x897A},
{0x8D99, 0xE6E2},
{0x8DA3, 0x8EEF},
{0x8DA8, 0x9096},
{0x8DB3, 0x91AB},
{0x8DBA, 0xE6E5},
{0x8DBE, 0xE6E4},
{0x8DC2, 0xE6E3},
{0x8DCB, 0xE6EB},
{0x8DCC, 0xE6E9},
{0x8DCF, 0xE6E6},
{0x8DD6, 0xE6E8},
{0x8DDA, 0xE6E7},
{0x8DDB, 0xE6EA},
{0x8DDD, 0x8B97},
{0x8DDF, 0xE6EE},
{0x8DE1, 0x90D5},
{0x8DE3, 0xE6EF},
{0x8DE8, 0x8CD7},
{0x8DEA, 0xE6EC},
{0x8DEB, 0xE6ED},
{0x8DEF, 0x9848},
{0x8DF3, 0x92B5},
{0x8DF5, 0x9148},
{0x8DFC, 0xE6F0},
{0x8DFF, 0xE6F3},
{0x8E08, 0xE6F1},
{0x8E09, 0xE6F2},
{0x8E0A, 0x9778},
{0x8E0F, 0x93A5},
{0x8E10, 0xE6F6},
{0x8E1D, 0xE6F4},
{0x8E1E, 0xE6F5},
{0x8E1F, 0xE6F7},
{0x8E2A, 0xE748},
{0x8E30, 0xE6FA},
{0x8E34, 0xE6FB},
{0x8E35, 0xE6F9},
{0x8E42, 0xE6F8},
{0x8E44, 0x92FB},
{0x8E47, 0xE740},
{0x8E48, 0xE744},
{0x8E49, 0xE741},
{0x8E4A, 0xE6FC},
{0x8E4C, 0xE742},
{0x8E50, 0xE743},
{0x8E55, 0xE74A},
{0x8E59, 0xE745},
{0x8E5F, 0x90D6},
{0x8E60, 0xE747},
{0x8E63, 0xE749},
{0x8E64, 0xE746},
{0x8E72, 0xE74C},
{0x8E74, 0x8F52},
{0x8E76, 0xE74B},
{0x8E7C, 0xE74D},
{0x8E81, 0xE74E},
{0x8E84, 0xE751},
{0x8E85, 0xE750},
{0x8E87, 0xE74F},
{0x8E8A, 0xE753},
{0x8E8B, 0xE752},
{0x8E8D, 0x96F4},
{0x8E91, 0xE755},
{0x8E93, 0xE754},
{0x8E94, 0xE756},
{0x8E99, 0xE757},
{0x8EA1, 0xE759},
{0x8EAA, 0xE758},
{0x8EAB, 0x9067},
{0x8EAC, 0xE75A},
{0x8EAF, 0x8BEB},
{0x8EB0, 0xE75B},
{0x8EB1, 0xE75D},
{0x8EBE, 0xE75E},
{0x8EC5, 0xE75F},
{0x8EC6, 0xE75C},
{0x8EC8, 0xE760},
{0x8ECA, 0x8ED4},
{0x8ECB, 0xE761},
{0x8ECC, 0x8B4F},
{0x8ECD, 0x8C52},
{0x8ECF, 0xFBB2},
{0x8ED2, 0x8CAC},
{0x8EDB, 0xE762},
{0x8EDF, 0x93EE},
{0x8EE2, 0x935D},
{0x8EE3, 0xE763},
{0x8EEB, 0xE766},
{0x8EF8, 0x8EB2},
{0x8EFB, 0xE765},
{0x8EFC, 0xE764},
{0x8EFD, 0x8C79},
{0x8EFE, 0xE767},
{0x8F03, 0x8A72},
{0x8F05, 0xE769},
{0x8F09, 0x8DDA},
{0x8F0A, 0xE768},
{0x8F0C, 0xE771},
{0x8F12, 0xE76B},
{0x8F13, 0xE76D},
{0x8F14, 0x95E3},
{0x8F15, 0xE76A},
{0x8F19, 0xE76C},
{0x8F1B, 0xE770},
{0x8F1C, 0xE76E},
{0x8F1D, 0x8B50},
{0x8F1F, 0xE76F},
{0x8F26, 0xE772},
{0x8F29, 0x9479},
{0x8F2A, 0x97D6},
{0x8F2F, 0x8F53},
{0x8F33, 0xE773},
{0x8F38, 0x9741},
{0x8F39, 0xE775},
{0x8F3B, 0xE774},
{0x8F3E, 0xE778},
{0x8F3F, 0x9760},
{0x8F42, 0xE777},
{0x8F44, 0x8A8D},
{0x8F45, 0xE776},
{0x8F46, 0xE77B},
{0x8F49, 0xE77A},
{0x8F4C, 0xE779},
{0x8F4D, 0x9351},
{0x8F4E, 0xE77C},
{0x8F57, 0xE77D},
{0x8F5C, 0xE77E},
{0x8F5F, 0x8D8C},
{0x8F61, 0x8C44},
{0x8F62, 0xE780},
{0x8F63, 0xE781},
{0x8F64, 0xE782},
{0x8F9B, 0x9068},
{0x8F9C, 0xE783},
{0x8F9E, 0x8EAB},
{0x8F9F, 0xE784},
{0x8FA3, 0xE785},
{0x8FA7, 0x999F},
{0x8FA8, 0x999E},
{0x8FAD, 0xE786},
{0x8FAE, 0xE390},
{0x8FAF, 0xE787},
{0x8FB0, 0x9243},
{0x8FB1, 0x904A},
{0x8FB2, 0x945F},
{0x8FB7, 0xE788},
{0x8FBA, 0x95D3},
{0x8FBB, 0x92D2},
{0x8FBC, 0x8D9E},
{0x8FBF, 0x9248},
{0x8FC2, 0x8949},
{0x8FC4, 0x9698},
{0x8FC5, 0x9076},
{0x8FCE, 0x8C7D},
{0x8FD1, 0x8BDF},
{0x8FD4, 0x95D4},
{0x8FDA, 0xE789},
{0x8FE2, 0xE78B},
{0x8FE5, 0xE78A},
{0x8FE6, 0x89DE},
{0x8FE9, 0x93F4},
{0x8FEA, 0xE78C},
{0x8FEB, 0x9497},
{0x8FED, 0x9352},
{0x8FEF, 0xE78D},
{0x8FF0, 0x8F71},
{0x8FF4, 0xE78F},
{0x8FF7, 0x96C0},
{0x8FF8, 0xE79E},
{0x8FF9, 0xE791},
{0x8FFA, 0xE792},
{0x8FFD, 0x92C7},
{0x9000, 0x91DE},
{0x9001, 0x9197},
{0x9003, 0x93A6},
{0x9005, 0xE790},
{0x9006, 0x8B74},
{0x900B, 0xE799},
{0x900D, 0xE796},
{0x900E, 0xE7A3},
{0x900F, 0x93A7},
{0x9010, 0x9280},
{0x9011, 0xE793},
{0x9013, 0x92FC},
{0x9014, 0x9372},
{0x9015, 0xE794},
{0x9016, 0xE798},
{0x9017, 0x9080},
{0x9019, 0x9487},
{0x901A, 0x92CA},
{0x901D, 0x90C0},
{0x901E, 0xE797},
{0x901F, 0x91AC},
{0x9020, 0x91A2},
{0x9021, 0xE795},
{0x9022, 0x88A7},
{0x9023, 0x9841},
{0x9027, 0xE79A},
{0x902E, 0x91DF},
{0x9031, 0x8F54},
{0x9032, 0x9069},
{0x9035, 0xE79C},
{0x9036, 0xE79B},
{0x9038, 0x88ED},
{0x9039, 0xE79D},
{0x903C, 0x954E},
{0x903E, 0xE7A5},
{0x9041, 0x93D9},
{0x9042, 0x908B},
{0x9045, 0x9278},
{0x9047, 0x8BF6},
{0x9049, 0xE7A4},
{0x904A, 0x9756},
{0x904B, 0x895E},
{0x904D, 0x95D5},
{0x904E, 0x89DF},
{0x904F, 0xE79F},
{0x9050, 0xE7A0},
{0x9051, 0xE7A1},
{0x9052, 0xE7A2},
{0x9053, 0x93B9},
{0x9054, 0x9242},
{0x9055, 0x88E1},
{0x9056, 0xE7A6},
{0x9058, 0xE7A7},
{0x9059, 0xEAA1},
{0x905C, 0x91BB},
{0x905E, 0xE7A8},
{0x9060, 0x8993},
{0x9061, 0x916B},
{0x9063, 0x8CAD},
{0x9065, 0x9779},
{0x9067, 0xFBB5},
{0x9068, 0xE7A9},
{0x9069, 0x934B},
{0x906D, 0x9198},
{0x906E, 0x8ED5},
{0x906F, 0xE7AA},
{0x9072, 0xE7AD},
{0x9075, 0x8F85},
{0x9076, 0xE7AB},
{0x9077, 0x914A},
{0x9078, 0x9149},
{0x907A, 0x88E2},
{0x907C, 0x97C9},
{0x907D, 0xE7AF},
{0x907F, 0x94F0},
{0x9080, 0xE7B1},
{0x9081, 0xE7B0},
{0x9082, 0xE7AE},
{0x9083, 0xE284},
{0x9084, 0x8AD2},
{0x9087, 0xE78E},
{0x9089, 0xE7B3},
{0x908A, 0xE7B2},
{0x908F, 0xE7B4},
{0x9091, 0x9757},
{0x90A3, 0x93DF},
{0x90A6, 0x964D},
{0x90A8, 0xE7B5},
{0x90AA, 0x8ED7},
{0x90AF, 0xE7B6},
{0x90B1, 0xE7B7},
{0x90B5, 0xE7B8},
{0x90B8, 0x9340},
{0x90C1, 0x88E8},
{0x90CA, 0x8D78},
{0x90CE, 0x9859},
{0x90DB, 0xE7BC},
{0x90DE, 0xFBB6},
{0x90E1, 0x8C53},
{0x90E2, 0xE7B9},
{0x90E4, 0xE7BA},
{0x90E8, 0x9594},
{0x90ED, 0x8A73},
{0x90F5, 0x9758},
{0x90F7, 0x8BBD},
{0x90FD, 0x9373},
{0x9102, 0xE7BD},
{0x9112, 0xE7BE},
{0x9115, 0xFBB8},
{0x9119, 0xE7BF},
{0x9127, 0xFBB9},
{0x912D, 0x9341},
{0x9130, 0xE7C1},
{0x9132, 0xE7C0},
{0x9149, 0x93D1},
{0x914A, 0xE7C2},
{0x914B, 0x8F55},
{0x914C, 0x8EDE},
{0x914D, 0x947A},
{0x914E, 0x9291},
{0x9152, 0x8EF0},
{0x9154, 0x908C},
{0x9156, 0xE7C3},
{0x9158, 0xE7C4},
{0x9162, 0x907C},
{0x9163, 0xE7C5},
{0x9165, 0xE7C6},
{0x9169, 0xE7C7},
{0x916A, 0x978F},
{0x916C, 0x8F56},
{0x9172, 0xE7C9},
{0x9173, 0xE7C8},
{0x9175, 0x8D79},
{0x9177, 0x8D93},
{0x9178, 0x8E5F},
{0x9182, 0xE7CC},
{0x9187, 0x8F86},
{0x9189, 0xE7CB},
{0x918B, 0xE7CA},
{0x918D, 0x91E7},
{0x9190, 0x8CED},
{0x9192, 0x90C1},
{0x9197, 0x94AE},
{0x919C, 0x8F58},
{0x91A2, 0xE7CD},
{0x91A4, 0x8FDD},
{0x91AA, 0xE7D0},
{0x91AB, 0xE7CE},
{0x91AF, 0xE7CF},
{0x91B4, 0xE7D2},
{0x91B5, 0xE7D1},
{0x91B8, 0x8FF8},
{0x91BA, 0xE7D3},
{0x91C0, 0xE7D4},
{0x91C1, 0xE7D5},
{0x91C6, 0x94CE},
{0x91C7, 0x8DD1},
{0x91C8, 0x8EDF},
{0x91C9, 0xE7D6},
{0x91CB, 0xE7D7},
{0x91CC, 0x97A2},
{0x91CD, 0x8F64},
{0x91CE, 0x96EC},
{0x91CF, 0x97CA},
{0x91D0, 0xE7D8},
{0x91D1, 0x8BE0},
{0x91D6, 0xE7D9},
{0x91D7, 0xFBBB},
{0x91D8, 0x9342},
{0x91DA, 0xFBBA},
{0x91DB, 0xE7DC},
{0x91DC, 0x8A98},
{0x91DD, 0x906A},
{0x91DE, 0xFBBC},
{0x91DF, 0xE7DA},
{0x91E1, 0xE7DB},
{0x91E3, 0x92DE},
{0x91E4, 0xFBBF},
{0x91E5, 0xFBC0},
{0x91E6, 0x9674},
{0x91E7, 0x8BFA},
{0x91ED, 0xFBBD},
{0x91EE, 0xFBBE},
{0x91F5, 0xE7DE},
{0x91F6, 0xE7DF},
{0x91FC, 0xE7DD},
{0x91FF, 0xE7E1},
{0x9206, 0xFBC1},
{0x920A, 0xFBC3},
{0x920D, 0x93DD},
{0x920E, 0x8A62},
{0x9210, 0xFBC2},
{0x9211, 0xE7E5},
{0x9214, 0xE7E2},
{0x9215, 0xE7E4},
{0x921E, 0xE7E0},
{0x9229, 0xE86E},
{0x922C, 0xE7E3},
{0x9234, 0x97E9},
{0x9237, 0x8CD8},
{0x9239, 0xFBCA},
{0x923A, 0xFBC4},
{0x923C, 0xFBC6},
{0x923F, 0xE7ED},
{0x9240, 0xFBC5},
{0x9244, 0x9353},
{0x9245, 0xE7E8},
{0x9248, 0xE7EB},
{0x9249, 0xE7E9},
{0x924B, 0xE7EE},
{0x924E, 0xFBC7},
{0x9250, 0xE7EF},
{0x9251, 0xFBC9},
{0x9257, 0xE7E7},
{0x9259, 0xFBC8},
{0x925A, 0xE7F4},
{0x925B, 0x8994},
{0x925E, 0xE7E6},
{0x9262, 0x94AB},
{0x9264, 0xE7EA},
{0x9266, 0x8FDE},
{0x9267, 0xFBCB},
{0x9271, 0x8D7A},
{0x9277, 0xFBCD},
{0x9278, 0xFBCE},
{0x927E, 0x9667},
{0x9280, 0x8BE2},
{0x9283, 0x8F65},
{0x9285, 0x93BA},
{0x9288, 0xFA5F},
{0x9291, 0x914C},
{0x9293, 0xE7F2},
{0x9295, 0xE7EC},
{0x9296, 0xE7F1},
{0x9298, 0x96C1},
{0x929A, 0x92B6},
{0x929B, 0xE7F3},
{0x929C, 0xE7F0},
{0x92A7, 0xFBCC},
{0x92AD, 0x914B},
{0x92B7, 0xE7F7},
{0x92B9, 0xE7F6},
{0x92CF, 0xE7F5},
{0x92D0, 0xFBD2},
{0x92D2, 0x964E},
{0x92D3, 0xFBD6},
{0x92D5, 0xFBD4},
{0x92D7, 0xFBD0},
{0x92D9, 0xFBD1},
{0x92E0, 0xFBD5},
{0x92E4, 0x8F9B},
{0x92E7, 0xFBCF},
{0x92E9, 0xE7F8},
{0x92EA, 0x95DD},
{0x92ED, 0x8973},
{0x92F2, 0x9565},
{0x92F3, 0x9292},
{0x92F8, 0x8B98},
{0x92F9, 0xFA65},
{0x92FA, 0xE7FA},
{0x92FB, 0xFBD9},
{0x92FC, 0x8D7C},
{0x92FF, 0xFBDC},
{0x9302, 0xFBDE},
{0x9306, 0x8E4B},
{0x930F, 0xE7F9},
{0x9310, 0x908D},
{0x9318, 0x908E},
{0x9319, 0xE840},
{0x931A, 0xE842},
{0x931D, 0xFBDD},
{0x931E, 0xFBDB},
{0x9320, 0x8FF9},
{0x9321, 0xFBD8},
{0x9322, 0xE841},
{0x9323, 0xE843},
{0x9325, 0xFBD7},
{0x9326, 0x8BD1},
{0x9328, 0x9564},
{0x932B, 0x8EE0},
{0x932C, 0x9842},
{0x932E, 0xE7FC},
{0x932F, 0x8DF6},
{0x9332, 0x985E},
{0x9335, 0xE845},
{0x933A, 0xE844},
{0x933B, 0xE846},
{0x9344, 0xE7FB},
{0x9348, 0xFA5E},
{0x934B, 0x93E7},
{0x934D, 0x9374},
{0x9354, 0x92D5},
{0x9356, 0xE84B},
{0x9357, 0xFBE0},
{0x935B, 0x9262},
{0x935C, 0xE847},
{0x9360, 0xE848},
{0x936C, 0x8C4C},
{0x936E, 0xE84A},
{0x9370, 0xFBDF},
{0x9375, 0x8CAE},
{0x937C, 0xE849},
{0x937E, 0x8FDF},
{0x938C, 0x8A99},
{0x9394, 0xE84F},
{0x9396, 0x8DBD},
{0x9397, 0x9199},
{0x939A, 0x92C8},
{0x93A4, 0xFBE1},
{0x93A7, 0x8A5A},
{0x93AC, 0xE84D},
{0x93AD, 0xE84E},
{0x93AE, 0x92C1},
{0x93B0, 0xE84C},
{0x93B9, 0xE850},
{0x93C3, 0xE856},
{0x93C6, 0xFBE2},
{0x93C8, 0xE859},
{0x93D0, 0xE858},
{0x93D1, 0x934C},
{0x93D6, 0xE851},
{0x93D7, 0xE852},
{0x93D8, 0xE855},
{0x93DD, 0xE857},
{0x93DE, 0xFBE3},
{0x93E1, 0x8BBE},
{0x93E4, 0xE85A},
{0x93E5, 0xE854},
{0x93E8, 0xE853},
{0x93F8, 0xFBE4},
{0x9403, 0xE85E},
{0x9407, 0xE85F},
{0x9410, 0xE860},
{0x9413, 0xE85D},
{0x9414, 0xE85C},
{0x9418, 0x8FE0},
{0x9419, 0x93A8},
{0x941A, 0xE85B},
{0x9421, 0xE864},
{0x942B, 0xE862},
{0x9431, 0xFBE5},
{0x9435, 0xE863},
{0x9436, 0xE861},
{0x9438, 0x91F6},
{0x943A, 0xE865},
{0x9441, 0xE866},
{0x9444, 0xE868},
{0x9445, 0xFBE6},
{0x9448, 0xFBE7},
{0x9451, 0x8AD3},
{0x9452, 0xE867},
{0x9453, 0x96F8},
{0x945A, 0xE873},
{0x945B, 0xE869},
{0x945E, 0xE86C},
{0x9460, 0xE86A},
{0x9462, 0xE86B},
{0x946A, 0xE86D},
{0x9470, 0xE86F},
{0x9475, 0xE870},
{0x9477, 0xE871},
{0x947C, 0xE874},
{0x947D, 0xE872},
{0x947E, 0xE875},
{0x947F, 0xE877},
{0x9481, 0xE876},
{0x9577, 0x92B7},
{0x9580, 0x96E5},
{0x9582, 0xE878},
{0x9583, 0x914D},
{0x9587, 0xE879},
{0x9589, 0x95C2},
{0x958A, 0xE87A},
{0x958B, 0x8A4A},
{0x958F, 0x895B},
{0x9591, 0x8AD5},
{0x9592, 0xFBE8},
{0x9593, 0x8AD4},
{0x9594, 0xE87B},
{0x9596, 0xE87C},
{0x9598, 0xE87D},
{0x9599, 0xE87E},
{0x95A0, 0xE880},
{0x95A2, 0x8AD6},
{0x95A3, 0x8A74},
{0x95A4, 0x8D7D},
{0x95A5, 0x94B4},
{0x95A7, 0xE882},
{0x95A8, 0xE881},
{0x95AD, 0xE883},
{0x95B2, 0x897B},
{0x95B9, 0xE886},
{0x95BB, 0xE885},
{0x95BC, 0xE884},
{0x95BE, 0xE887},
{0x95C3, 0xE88A},
{0x95C7, 0x88C5},
{0x95CA, 0xE888},
{0x95CC, 0xE88C},
{0x95CD, 0xE88B},
{0x95D4, 0xE88E},
{0x95D5, 0xE88D},
{0x95D6, 0xE88F},
{0x95D8, 0x93AC},
{0x95DC, 0xE890},
{0x95E1, 0xE891},
{0x95E2, 0xE893},
{0x95E5, 0xE892},
{0x961C, 0x958C},
{0x9621, 0xE894},
{0x9628, 0xE895},
{0x962A, 0x8DE3},
{0x962E, 0xE896},
{0x962F, 0xE897},
{0x9632, 0x9668},
{0x963B, 0x916A},
{0x963F, 0x88A2},
{0x9640, 0x91C9},
{0x9642, 0xE898},
{0x9644, 0x958D},
{0x964B, 0xE89B},
{0x964C, 0xE899},
{0x964D, 0x8D7E},
{0x964F, 0xE89A},
{0x9650, 0x8CC0},
{0x965B, 0x95C3},
{0x965C, 0xE89D},
{0x965D, 0xE89F},
{0x965E, 0xE89E},
{0x965F, 0xE8A0},
{0x9662, 0x8940},
{0x9663, 0x9077},
{0x9664, 0x8F9C},
{0x9665, 0x8AD7},
{0x9666, 0xE8A1},
{0x966A, 0x9486},
{0x966C, 0xE8A3},
{0x9670, 0x8941},
{0x9672, 0xE8A2},
{0x9673, 0x92C2},
{0x9675, 0x97CB},
{0x9676, 0x93A9},
{0x9677, 0xE89C},
{0x9678, 0x97A4},
{0x967A, 0x8CAF},
{0x967D, 0x977A},
{0x9685, 0x8BF7},
{0x9686, 0x97B2},
{0x9688, 0x8C47},
{0x968A, 0x91E0},
{0x968B, 0xE440},
{0x968D, 0xE8A4},
{0x968E, 0x8A4B},
{0x968F, 0x908F},
{0x9694, 0x8A75},
{0x9695, 0xE8A6},
{0x9697, 0xE8A7},
{0x9698, 0xE8A5},
{0x9699, 0x8C84},
{0x969B, 0x8DDB},
{0x969C, 0x8FE1},
{0x969D, 0xFBEB},
{0x96A0, 0x8942},
{0x96A3, 0x97D7},
{0x96A7, 0xE8A9},
{0x96A8, 0xE7AC},
{0x96AA, 0xE8A8},
{0x96AF, 0xFBEC},
{0x96B0, 0xE8AC},
{0x96B1, 0xE8AA},
{0x96B2, 0xE8AB},
{0x96B4, 0xE8AD},
{0x96B6, 0xE8AE},
{0x96B7, 0x97EA},
{0x96B8, 0xE8AF},
{0x96B9, 0xE8B0},
{0x96BB, 0x90C7},
{0x96BC, 0x94B9},
{0x96C0, 0x909D},
{0x96C1, 0x8AE5},
{0x96C4, 0x9759},
{0x96C5, 0x89EB},
{0x96C6, 0x8F57},
{0x96C7, 0x8CD9},
{0x96C9, 0xE8B3},
{0x96CB, 0xE8B2},
{0x96CC, 0x8E93},
{0x96CD, 0xE8B4},
{0x96CE, 0xE8B1},
{0x96D1, 0x8E47},
{0x96D5, 0xE8B8},
{0x96D6, 0xE5AB},
{0x96D9, 0x99D4},
{0x96DB, 0x9097},
{0x96DC, 0xE8B6},
{0x96E2, 0x97A3},
{0x96E3, 0x93EF},
{0x96E8, 0x894A},
{0x96EA, 0x90E1},
{0x96EB, 0x8EB4},
{0x96F0, 0x95B5},
{0x96F2, 0x895F},
{0x96F6, 0x97EB},
{0x96F7, 0x978B},
{0x96F9, 0xE8B9},
{0x96FB, 0x9364},
{0x9700, 0x8EF9},
{0x9704, 0xE8BA},
{0x9706, 0xE8BB},
{0x9707, 0x906B},
{0x9708, 0xE8BC},
{0x970A, 0x97EC},
{0x970D, 0xE8B7},
{0x970E, 0xE8BE},
{0x970F, 0xE8C0},
{0x9711, 0xE8BF},
{0x9713, 0xE8BD},
{0x9716, 0xE8C1},
{0x9719, 0xE8C2},
{0x971C, 0x919A},
{0x971E, 0x89E0},
{0x9724, 0xE8C3},
{0x9727, 0x96B6},
{0x972A, 0xE8C4},
{0x9730, 0xE8C5},
{0x9732, 0x9849},
{0x9733, 0xFBED},
{0x9738, 0x9E50},
{0x9739, 0xE8C6},
{0x973B, 0xFBEE},
{0x973D, 0xE8C7},
{0x973E, 0xE8C8},
{0x9742, 0xE8CC},
{0x9743, 0xFBEF},
{0x9744, 0xE8C9},
{0x9746, 0xE8CA},
{0x9748, 0xE8CB},
{0x9749, 0xE8CD},
{0x974D, 0xFBF0},
{0x974F, 0xFBF1},
{0x9751, 0xFBF2},
{0x9752, 0x90C2},
{0x9755, 0xFBF3},
{0x9756, 0x96F5},
{0x9759, 0x90C3},
{0x975C, 0xE8CE},
{0x975E, 0x94F1},
{0x9760, 0xE8CF},
{0x9761, 0xEA72},
{0x9762, 0x96CA},
{0x9764, 0xE8D0},
{0x9766, 0xE8D1},
{0x9768, 0xE8D2},
{0x9769, 0x8A76},
{0x976B, 0xE8D4},
{0x976D, 0x9078},
{0x9771, 0xE8D5},
{0x9774, 0x8C43},
{0x9779, 0xE8D6},
{0x977A, 0xE8DA},
{0x977C, 0xE8D8},
{0x9781, 0xE8D9},
{0x9784, 0x8A93},
{0x9785, 0xE8D7},
{0x9786, 0xE8DB},
{0x978B, 0xE8DC},
{0x978D, 0x88C6},
{0x978F, 0xE8DD},
{0x9790, 0xE8DE},
{0x9798, 0x8FE2},
{0x979C, 0xE8DF},
{0x97A0, 0x8B66},
{0x97A3, 0xE8E2},
{0x97A6, 0xE8E1},
{0x97A8, 0xE8E0},
{0x97AB, 0xE691},
{0x97AD, 0x95DA},
{0x97B3, 0xE8E3},
{0x97B4, 0xE8E4},
{0x97C3, 0xE8E5},
{0x97C6, 0xE8E6},
{0x97C8, 0xE8E7},
{0x97CB, 0xE8E8},
{0x97D3, 0x8AD8},
{0x97DC, 0xE8E9},
{0x97ED, 0xE8EA},
{0x97EE, 0x9442},
{0x97F2, 0xE8EC},
{0x97F3, 0x89B9},
{0x97F5, 0xE8EF},
{0x97F6, 0xE8EE},
{0x97FB, 0x8943},
{0x97FF, 0x8BBF},
{0x9801, 0x95C5},
{0x9802, 0x92B8},
{0x9803, 0x8DA0},
{0x9805, 0x8D80},
{0x9806, 0x8F87},
{0x9808, 0x907B},
{0x980C, 0xE8F1},
{0x980F, 0xE8F0},
{0x9810, 0x9761},
{0x9811, 0x8AE6},
{0x9812, 0x94D0},
{0x9813, 0x93DA},
{0x9817, 0x909C},
{0x9818, 0x97CC},
{0x981A, 0x8C7A},
{0x9821, 0xE8F4},
{0x9824, 0xE8F3},
{0x982C, 0x966A},
{0x982D, 0x93AA},
{0x9834, 0x896F},
{0x9837, 0xE8F5},
{0x9838, 0xE8F2},
{0x983B, 0x9570},
{0x983C, 0x978A},
{0x983D, 0xE8F6},
{0x9846, 0xE8F7},
{0x984B, 0xE8F9},
{0x984C, 0x91E8},
{0x984D, 0x8A7A},
{0x984E, 0x8A7B},
{0x984F, 0xE8F8},
{0x9854, 0x8AE7},
{0x9855, 0x8CB0},
{0x9857, 0xFBF4},
{0x9858, 0x8AE8},
{0x985B, 0x935E},
{0x985E, 0x97DE},
{0x9865, 0xFBF5},
{0x9867, 0x8CDA},
{0x986B, 0xE8FA},
{0x986F, 0xE8FB},
{0x9870, 0xE8FC},
{0x9871, 0xE940},
{0x9873, 0xE942},
{0x9874, 0xE941},
{0x98A8, 0x9597},
{0x98AA, 0xE943},
{0x98AF, 0xE944},
{0x98B1, 0xE945},
{0x98B6, 0xE946},
{0x98C3, 0xE948},
{0x98C4, 0xE947},
{0x98C6, 0xE949},
{0x98DB, 0x94F2},
{0x98DC, 0xE3CA},
{0x98DF, 0x9048},
{0x98E2, 0x8B51},
{0x98E9, 0xE94A},
{0x98EB, 0xE94B},
{0x98ED, 0x99AA},
{0x98EE, 0x9F5A},
{0x98EF, 0x94D1},
{0x98F2, 0x88F9},
{0x98F4, 0x88B9},
{0x98FC, 0x8E94},
{0x98FD, 0x964F},
{0x98FE, 0x8FFC},
{0x9903, 0xE94C},
{0x9905, 0x96DD},
{0x9909, 0xE94D},
{0x990A, 0x977B},
{0x990C, 0x8961},
{0x9910, 0x8E60},
{0x9912, 0xE94E},
{0x9913, 0x89EC},
{0x9914, 0xE94F},
{0x9918, 0xE950},
{0x991D, 0xE952},
{0x991E, 0xE953},
{0x9920, 0xE955},
{0x9921, 0xE951},
{0x9924, 0xE954},
{0x9927, 0xFBF8},
{0x9928, 0x8AD9},
{0x992C, 0xE956},
{0x992E, 0xE957},
{0x993D, 0xE958},
{0x993E, 0xE959},
{0x9942, 0xE95A},
{0x9945, 0xE95C},
{0x9949, 0xE95B},
{0x994B, 0xE95E},
{0x994C, 0xE961},
{0x9950, 0xE95D},
{0x9951, 0xE95F},
{0x9952, 0xE960},
{0x9955, 0xE962},
{0x9957, 0x8BC0},
{0x9996, 0x8EF1},
{0x9997, 0xE963},
{0x9998, 0xE964},
{0x9999, 0x8D81},
{0x999E, 0xFBFA},
{0x99A5, 0xE965},
{0x99A8, 0x8A5D},
{0x99AC, 0x946E},
{0x99AD, 0xE966},
{0x99AE, 0xE967},
{0x99B3, 0x9279},
{0x99B4, 0x93E9},
{0x99BC, 0xE968},
{0x99C1, 0x949D},
{0x99C4, 0x91CA},
{0x99C5, 0x8977},
{0x99C6, 0x8BEC},
{0x99C8, 0x8BED},
{0x99D0, 0x9293},
{0x99D1, 0xE96D},
{0x99D2, 0x8BEE},
{0x99D5, 0x89ED},
{0x99D8, 0xE96C},
{0x99DB, 0xE96A},
{0x99DD, 0xE96B},
{0x99DF, 0xE969},
{0x99E2, 0xE977},
{0x99ED, 0xE96E},
{0x99EE, 0xE96F},
{0x99F1, 0xE970},
{0x99F2, 0xE971},
{0x99F8, 0xE973},
{0x99FB, 0xE972},
{0x99FF, 0x8F78},
{0x9A01, 0xE974},
{0x9A05, 0xE976},
{0x9A0E, 0x8B52},
{0x9A0F, 0xE975},
{0x9A12, 0x919B},
{0x9A13, 0x8CB1},
{0x9A19, 0xE978},
{0x9A28, 0x91CB},
{0x9A2B, 0xE979},
{0x9A30, 0x93AB},
{0x9A37, 0xE97A},
{0x9A3E, 0xE980},
{0x9A40, 0xE97D},
{0x9A42, 0xE97C},
{0x9A43, 0xE97E},
{0x9A45, 0xE97B},
{0x9A4D, 0xE982},
{0x9A4E, 0xFBFB},
{0x9A55, 0xE981},
{0x9A57, 0xE984},
{0x9A5A, 0x8BC1},
{0x9A5B, 0xE983},
{0x9A5F, 0xE985},
{0x9A62, 0xE986},
{0x9A64, 0xE988},
{0x9A65, 0xE987},
{0x9A69, 0xE989},
{0x9A6A, 0xE98B},
{0x9A6B, 0xE98A},
{0x9AA8, 0x8D9C},
{0x9AAD, 0xE98C},
{0x9AB0, 0xE98D},
{0x9AB8, 0x8A5B},
{0x9ABC, 0xE98E},
{0x9AC0, 0xE98F},
{0x9AC4, 0x9091},
{0x9ACF, 0xE990},
{0x9AD1, 0xE991},
{0x9AD3, 0xE992},
{0x9AD4, 0xE993},
{0x9AD8, 0x8D82},
{0x9AD9, 0xFBFC},
{0x9ADC, 0xFC40},
{0x9ADE, 0xE994},
{0x9ADF, 0xE995},
{0x9AE2, 0xE996},
{0x9AE3, 0xE997},
{0x9AE6, 0xE998},
{0x9AEA, 0x94AF},
{0x9AEB, 0xE99A},
{0x9AED, 0x9545},
{0x9AEE, 0xE99B},
{0x9AEF, 0xE999},
{0x9AF1, 0xE99D},
{0x9AF4, 0xE99C},
{0x9AF7, 0xE99E},
{0x9AFB, 0xE99F},
{0x9B06, 0xE9A0},
{0x9B18, 0xE9A1},
{0x9B1A, 0xE9A2},
{0x9B1F, 0xE9A3},
{0x9B22, 0xE9A4},
{0x9B23, 0xE9A5},
{0x9B25, 0xE9A6},
{0x9B27, 0xE9A7},
{0x9B28, 0xE9A8},
{0x9B29, 0xE9A9},
{0x9B2A, 0xE9AA},
{0x9B2E, 0xE9AB},
{0x9B2F, 0xE9AC},
{0x9B31, 0x9F54},
{0x9B32, 0xE9AD},
{0x9B3B, 0xE2F6},
{0x9B3C, 0x8B53},
{0x9B41, 0x8A40},
{0x9B42, 0x8DB0},
{0x9B43, 0xE9AF},
{0x9B44, 0xE9AE},
{0x9B45, 0x96A3},
{0x9B4D, 0xE9B1},
{0x9B4E, 0xE9B2},
{0x9B4F, 0xE9B0},
{0x9B51, 0xE9B3},
{0x9B54, 0x9682},
{0x9B58, 0xE9B4},
{0x9B5A, 0x8B9B},
{0x9B6F, 0x9844},
{0x9B72, 0xFC42},
{0x9B74, 0xE9B5},
{0x9B75, 0xFC41},
{0x9B83, 0xE9B7},
{0x9B8E, 0x88BC},
{0x9B8F, 0xFC43},
{0x9B91, 0xE9B8},
{0x9B92, 0x95A9},
{0x9B93, 0xE9B6},
{0x9B96, 0xE9B9},
{0x9B97, 0xE9BA},
{0x9B9F, 0xE9BB},
{0x9BA0, 0xE9BC},
{0x9BA8, 0xE9BD},
{0x9BAA, 0x968E},
{0x9BAB, 0x8E4C},
{0x9BAD, 0x8DF8},
{0x9BAE, 0x914E},
{0x9BB1, 0xFC44},
{0x9BB4, 0xE9BE},
{0x9BB9, 0xE9C1},
{0x9BBB, 0xFC45},
{0x9BC0, 0xE9BF},
{0x9BC6, 0xE9C2},
{0x9BC9, 0x8CEF},
{0x9BCA, 0xE9C0},
{0x9BCF, 0xE9C3},
{0x9BD1, 0xE9C4},
{0x9BD2, 0xE9C5},
{0x9BD4, 0xE9C9},
{0x9BD6, 0x8E49},
{0x9BDB, 0x91E2},
{0x9BE1, 0xE9CA},
{0x9BE2, 0xE9C7},
{0x9BE3, 0xE9C6},
{0x9BE4, 0xE9C8},
{0x9BE8, 0x8C7E},
{0x9BF0, 0xE9CE},
{0x9BF1, 0xE9CD},
{0x9BF2, 0xE9CC},
{0x9BF5, 0x88B1},
{0x9C00, 0xFC46},
{0x9C04, 0xE9D8},
{0x9C06, 0xE9D4},
{0x9C08, 0xE9D5},
{0x9C09, 0xE9D1},
{0x9C0A, 0xE9D7},
{0x9C0C, 0xE9D3},
{0x9C0D, 0x8A82},
{0x9C10, 0x986B},
{0x9C12, 0xE9D6},
{0x9C13, 0xE9D2},
{0x9C14, 0xE9D0},
{0x9C15, 0xE9CF},
{0x9C1B, 0xE9DA},
{0x9C21, 0xE9DD},
{0x9C24, 0xE9DC},
{0x9C25, 0xE9DB},
{0x9C2D, 0x9568},
{0x9C2E, 0xE9D9},
{0x9C2F, 0x88F1},
{0x9C30, 0xE9DE},
{0x9C32, 0xE9E0},
{0x9C39, 0x8A8F},
{0x9C3A, 0xE9CB},
{0x9C3B, 0x8956},
{0x9C3E, 0xE9E2},
{0x9C46, 0xE9E1},
{0x9C47, 0xE9DF},
{0x9C48, 0x924C},
{0x9C52, 0x9690},
{0x9C57, 0x97D8},
{0x9C5A, 0xE9E3},
{0x9C60, 0xE9E4},
{0x9C67, 0xE9E5},
{0x9C76, 0xE9E6},
{0x9C78, 0xE9E7},
{0x9CE5, 0x92B9},
{0x9CE7, 0xE9E8},
{0x9CE9, 0x94B5},
{0x9CEB, 0xE9ED},
{0x9CEC, 0xE9E9},
{0x9CF0, 0xE9EA},
{0x9CF3, 0x9650},
{0x9CF4, 0x96C2},
{0x9CF6, 0x93CE},
{0x9D03, 0xE9EE},
{0x9D06, 0xE9EF},
{0x9D07, 0x93BC},
{0x9D08, 0xE9EC},
{0x9D09, 0xE9EB},
{0x9D0E, 0x89A8},
{0x9D12, 0xE9F7},
{0x9D15, 0xE9F6},
{0x9D1B, 0x8995},
{0x9D1F, 0xE9F4},
{0x9D23, 0xE9F3},
{0x9D26, 0xE9F1},
{0x9D28, 0x8A9B},
{0x9D2A, 0xE9F0},
{0x9D2B, 0x8EB0},
{0x9D2C, 0x89A7},
{0x9D3B, 0x8D83},
{0x9D3E, 0xE9FA},
{0x9D3F, 0xE9F9},
{0x9D41, 0xE9F8},
{0x9D44, 0xE9F5},
{0x9D46, 0xE9FB},
{0x9D48, 0xE9FC},
{0x9D50, 0xEA44},
{0x9D51, 0xEA43},
{0x9D59, 0xEA45},
{0x9D5C, 0x894C},
{0x9D5D, 0xEA40},
{0x9D5E, 0xEA41},
{0x9D60, 0x8D94},
{0x9D61, 0x96B7},
{0x9D64, 0xEA42},
{0x9D6B, 0xFC48},
{0x9D6C, 0x9651},
{0x9D6F, 0xEA4A},
{0x9D70, 0xFC47},
{0x9D72, 0xEA46},
{0x9D7A, 0xEA4B},
{0x9D87, 0xEA48},
{0x9D89, 0xEA47},
{0x9D8F, 0x8C7B},
{0x9D9A, 0xEA4C},
{0x9DA4, 0xEA4D},
{0x9DA9, 0xEA4E},
{0x9DAB, 0xEA49},
{0x9DAF, 0xE9F2},
{0x9DB2, 0xEA4F},
{0x9DB4, 0x92DF},
{0x9DB8, 0xEA53},
{0x9DBA, 0xEA54},
{0x9DBB, 0xEA52},
{0x9DC1, 0xEA51},
{0x9DC2, 0xEA57},
{0x9DC4, 0xEA50},
{0x9DC6, 0xEA55},
{0x9DCF, 0xEA56},
{0x9DD3, 0xEA59},
{0x9DD9, 0xEA58},
{0x9DE6, 0xEA5B},
{0x9DED, 0xEA5C},
{0x9DEF, 0xEA5D},
{0x9DF2, 0x9868},
{0x9DF8, 0xEA5A},
{0x9DF9, 0x91E9},
{0x9DFA, 0x8DEB},
{0x9DFD, 0xEA5E},
{0x9E19, 0xFC4A},
{0x9E1A, 0xEA5F},
{0x9E1B, 0xEA60},
{0x9E1E, 0xEA61},
{0x9E75, 0xEA62},
{0x9E78, 0x8CB2},
{0x9E79, 0xEA63},
{0x9E7D, 0xEA64},
{0x9E7F, 0x8EAD},
{0x9E81, 0xEA65},
{0x9E88, 0xEA66},
{0x9E8B, 0xEA67},
{0x9E8C, 0xEA68},
{0x9E91, 0xEA6B},
{0x9E92, 0xEA69},
{0x9E93, 0x985B},
{0x9E95, 0xEA6A},
{0x9E97, 0x97ED},
{0x9E9D, 0xEA6C},
{0x9E9F, 0x97D9},
{0x9EA5, 0xEA6D},
{0x9EA6, 0x949E},
{0x9EA9, 0xEA6E},
{0x9EAA, 0xEA70},
{0x9EAD, 0xEA71},
{0x9EB8, 0xEA6F},
{0x9EB9, 0x8D8D},
{0x9EBA, 0x96CB},
{0x9EBB, 0x9683},
{0x9EBC, 0x9BF5},
{0x9EBE, 0x9F80},
{0x9EBF, 0x969B},
{0x9EC4, 0x89A9},
{0x9ECC, 0xEA73},
{0x9ECD, 0x8B6F},
{0x9ECE, 0xEA74},
{0x9ECF, 0xEA75},
{0x9ED0, 0xEA76},
{0x9ED1, 0xFC4B},
{0x9ED2, 0x8D95},
{0x9ED4, 0xEA77},
{0x9ED8, 0xE0D2},
{0x9ED9, 0x96D9},
{0x9EDB, 0x91E1},
{0x9EDC, 0xEA78},
{0x9EDD, 0xEA7A},
{0x9EDE, 0xEA79},
{0x9EE0, 0xEA7B},
{0x9EE5, 0xEA7C},
{0x9EE8, 0xEA7D},
{0x9EEF, 0xEA7E},
{0x9EF4, 0xEA80},
{0x9EF6, 0xEA81},
{0x9EF7, 0xEA82},
{0x9EF9, 0xEA83},
{0x9EFB, 0xEA84},
{0x9EFC, 0xEA85},
{0x9EFD, 0xEA86},
{0x9F07, 0xEA87},
{0x9F08, 0xEA88},
{0x9F0E, 0x9343},
{0x9F13, 0x8CDB},
{0x9F15, 0xEA8A},
{0x9F20, 0x916C},
{0x9F21, 0xEA8B},
{0x9F2C, 0xEA8C},
{0x9F3B, 0x9540},
{0x9F3E, 0xEA8D},
{0x9F4A, 0xEA8E},
{0x9F4B, 0xE256},
{0x9F4E, 0xE6D8},
{0x9F4F, 0xE8EB},
{0x9F52, 0xEA8F},
{0x9F54, 0xEA90},
{0x9F5F, 0xEA92},
{0x9F60, 0xEA93},
{0x9F61, 0xEA94},
{0x9F62, 0x97EE},
{0x9F63, 0xEA91},
{0x9F66, 0xEA95},
{0x9F67, 0xEA96},
{0x9F6A, 0xEA98},
{0x9F6C, 0xEA97},
{0x9F72, 0xEA9A},
{0x9F76, 0xEA9B},
{0x9F77, 0xEA99},
{0x9F8D, 0x97B4},
{0x9F95, 0xEA9C},
{0x9F9C, 0xEA9D},
{0x9F9D, 0xE273},
{0x9FA0, 0xEA9E},
{0xF8F0, 0x00A0},
{0xF8F1, 0x00FD},
{0xF8F2, 0x00FE},
{0xF8F3, 0x00FF},
{0xF929, 0xFAE0},
{0xF9DC, 0xFBE9},
{0xFA0E, 0xFA90},
{0xFA0F, 0xFA9B},
{0xFA10, 0xFA9C},
{0xFA11, 0xFAB1},
{0xFA12, 0xFAD8},
{0xFA13, 0xFAE8},
{0xFA14, 0xFAEA},
{0xFA15, 0xFB58},
{0xFA16, 0xFB5E},
{0xFA17, 0xFB75},
{0xFA18, 0xFB7D},
{0xFA19, 0xFB7E},
{0xFA1A, 0xFB80},
{0xFA1B, 0xFB82},
{0xFA1C, 0xFB86},
{0xFA1D, 0xFB89},
{0xFA1E, 0xFB92},
{0xFA1F, 0xFB9D},
{0xFA20, 0xFB9F},
{0xFA21, 0xFBA0},
{0xFA22, 0xFBA9},
{0xFA23, 0xFBB1},
{0xFA24, 0xFBB3},
{0xFA25, 0xFBB4},
{0xFA26, 0xFBB7},
{0xFA27, 0xFBD3},
{0xFA28, 0xFBDA},
{0xFA29, 0xFBEA},
{0xFA2A, 0xFBF6},
{0xFA2B, 0xFBF7},
{0xFA2C, 0xFBF9},
{0xFA2D, 0xFC49},
{0xFF01, 0x8149},
{0xFF02, 0xFA57},
{0xFF03, 0x8194},
{0xFF04, 0x8190},
{0xFF05, 0x8193},
{0xFF06, 0x8195},
{0xFF07, 0xFA56},
{0xFF08, 0x8169},
{0xFF09, 0x816A},
{0xFF0A, 0x8196},
{0xFF0B, 0x817B},
{0xFF0C, 0x8143},
{0xFF0D, 0x817C},
{0xFF0E, 0x8144},
{0xFF0F, 0x815E},
{0xFF10, 0x824F},
{0xFF11, 0x8250},
{0xFF12, 0x8251},
{0xFF13, 0x8252},
{0xFF14, 0x8253},
{0xFF15, 0x8254},
{0xFF16, 0x8255},
{0xFF17, 0x8256},
{0xFF18, 0x8257},
{0xFF19, 0x8258},
{0xFF1A, 0x8146},
{0xFF1B, 0x8147},
{0xFF1C, 0x8183},
{0xFF1D, 0x8181},
{0xFF1E, 0x8184},
{0xFF1F, 0x8148},
{0xFF20, 0x8197},
{0xFF21, 0x8260},
{0xFF22, 0x8261},
{0xFF23, 0x8262},
{0xFF24, 0x8263},
{0xFF25, 0x8264},
{0xFF26, 0x8265},
{0xFF27, 0x8266},
{0xFF28, 0x8267},
{0xFF29, 0x8268},
{0xFF2A, 0x8269},
{0xFF2B, 0x826A},
{0xFF2C, 0x826B},
{0xFF2D, 0x826C},
{0xFF2E, 0x826D},
{0xFF2F, 0x826E},
{0xFF30, 0x826F},
{0xFF31, 0x8270},
{0xFF32, 0x8271},
{0xFF33, 0x8272},
{0xFF34, 0x8273},
{0xFF35, 0x8274},
{0xFF36, 0x8275},
{0xFF37, 0x8276},
{0xFF38, 0x8277},
{0xFF39, 0x8278},
{0xFF3A, 0x8279},
{0xFF3B, 0x816D},
#ifndef UNICODEMAPPING
{0xff3c, 0x815f},
#endif
{0xFF3D, 0x816E},
{0xFF3E, 0x814F},
{0xFF3F, 0x8151},
{0xFF40, 0x814D},
{0xFF41, 0x8281},
{0xFF42, 0x8282},
{0xFF43, 0x8283},
{0xFF44, 0x8284},
{0xFF45, 0x8285},
{0xFF46, 0x8286},
{0xFF47, 0x8287},
{0xFF48, 0x8288},
{0xFF49, 0x8289},
{0xFF4A, 0x828A},
{0xFF4B, 0x828B},
{0xFF4C, 0x828C},
{0xFF4D, 0x828D},
{0xFF4E, 0x828E},
{0xFF4F, 0x828F},
{0xFF50, 0x8290},
{0xFF51, 0x8291},
{0xFF52, 0x8292},
{0xFF53, 0x8293},
{0xFF54, 0x8294},
{0xFF55, 0x8295},
{0xFF56, 0x8296},
{0xFF57, 0x8297},
{0xFF58, 0x8298},
{0xFF59, 0x8299},
{0xFF5A, 0x829A},
{0xFF5B, 0x816F},
{0xFF5C, 0x8162},
{0xFF5D, 0x8170},
{0xFF5E, 0x8160},
{0xFF61, 0xA1},
{0xFF62, 0xA2},
{0xFF63, 0xA3},
{0xFF64, 0xA4},
{0xFF65, 0xA5},
{0xFF66, 0xA6},
{0xFF67, 0xA7},
{0xFF68, 0xA8},
{0xFF69, 0xA9},
{0xFF6A, 0xAA},
{0xFF6B, 0xAB},
{0xFF6C, 0xAC},
{0xFF6D, 0xAD},
{0xFF6E, 0xAE},
{0xFF6F, 0xAF},
{0xFF70, 0xB0},
{0xFF71, 0xB1},
{0xFF72, 0xB2},
{0xFF73, 0xB3},
{0xFF74, 0xB4},
{0xFF75, 0xB5},
{0xFF76, 0xB6},
{0xFF77, 0xB7},
{0xFF78, 0xB8},
{0xFF79, 0xB9},
{0xFF7A, 0xBA},
{0xFF7B, 0xBB},
{0xFF7C, 0xBC},
{0xFF7D, 0xBD},
{0xFF7E, 0xBE},
{0xFF7F, 0xBF},
{0xFF80, 0xC0},
{0xFF81, 0xC1},
{0xFF82, 0xC2},
{0xFF83, 0xC3},
{0xFF84, 0xC4},
{0xFF85, 0xC5},
{0xFF86, 0xC6},
{0xFF87, 0xC7},
{0xFF88, 0xC8},
{0xFF89, 0xC9},
{0xFF8A, 0xCA},
{0xFF8B, 0xCB},
{0xFF8C, 0xCC},
{0xFF8D, 0xCD},
{0xFF8E, 0xCE},
{0xFF8F, 0xCF},
{0xFF90, 0xD0},
{0xFF91, 0xD1},
{0xFF92, 0xD2},
{0xFF93, 0xD3},
{0xFF94, 0xD4},
{0xFF95, 0xD5},
{0xFF96, 0xD6},
{0xFF97, 0xD7},
{0xFF98, 0xD8},
{0xFF99, 0xD9},
{0xFF9A, 0xDA},
{0xFF9B, 0xDB},
{0xFF9C, 0xDC},
{0xFF9D, 0xDD},
{0xFF9E, 0xDE},
{0xFF9F, 0xDF},
{0xFFE0, 0x8191},
{0xFFE1, 0x8192},
{0xFFE2, 0x81CA},
{0xFFE3, 0x8150},
{0xFFE4, 0xFA55},
{0xFFE5, 0x818F}
};

int
CharSetCvtUTF8toShiftJis::MapCount()
{
	return sizeof(UCS2toShiftJis) / sizeof(*UCS2toShiftJis);
}

CharSetCvt::MapEnt
CharSetCvtShiftJistoUTF8::ShiftJistoUCS2[] = {
{0x20,0x0020},
{0x21,0x0021},
{0x22,0x0022},
{0x23,0x0023},
{0x24,0x0024},
{0x25,0x0025},
{0x26,0x0026},
{0x27,0x0027},
{0x28,0x0028},
{0x29,0x0029},
{0x2A,0x002A},
{0x2B,0x002B},
{0x2C,0x002C},
{0x2D,0x002D},
{0x2E,0x002E},
{0x2F,0x002F},
{0x30,0x0030},
{0x31,0x0031},
{0x32,0x0032},
{0x33,0x0033},
{0x34,0x0034},
{0x35,0x0035},
{0x36,0x0036},
{0x37,0x0037},
{0x38,0x0038},
{0x39,0x0039},
{0x3A,0x003A},
{0x3B,0x003B},
{0x3C,0x003C},
{0x3D,0x003D},
{0x3E,0x003E},
{0x3F,0x003F},
{0x40,0x0040},
{0x41,0x0041},
{0x42,0x0042},
{0x43,0x0043},
{0x44,0x0044},
{0x45,0x0045},
{0x46,0x0046},
{0x47,0x0047},
{0x48,0x0048},
{0x49,0x0049},
{0x4A,0x004A},
{0x4B,0x004B},
{0x4C,0x004C},
{0x4D,0x004D},
{0x4E,0x004E},
{0x4F,0x004F},
{0x50,0x0050},
{0x51,0x0051},
{0x52,0x0052},
{0x53,0x0053},
{0x54,0x0054},
{0x55,0x0055},
{0x56,0x0056},
{0x57,0x0057},
{0x58,0x0058},
{0x59,0x0059},
{0x5A,0x005A},
{0x5B,0x005B},
#ifdef UNICODEMAPPING
{0x5C,0x00A5},
#else
{0x5c, 0x005c},
#endif
{0x5D,0x005D},
{0x5E,0x005E},
{0x5F,0x005F},
{0x60,0x0060},
{0x61,0x0061},
{0x62,0x0062},
{0x63,0x0063},
{0x64,0x0064},
{0x65,0x0065},
{0x66,0x0066},
{0x67,0x0067},
{0x68,0x0068},
{0x69,0x0069},
{0x6A,0x006A},
{0x6B,0x006B},
{0x6C,0x006C},
{0x6D,0x006D},
{0x6E,0x006E},
{0x6F,0x006F},
{0x70,0x0070},
{0x71,0x0071},
{0x72,0x0072},
{0x73,0x0073},
{0x74,0x0074},
{0x75,0x0075},
{0x76,0x0076},
{0x77,0x0077},
{0x78,0x0078},
{0x79,0x0079},
{0x7A,0x007A},
{0x7B,0x007B},
{0x7C,0x007C},
{0x7D,0x007D},
#ifdef UNICODEMAPPING
{0x7E,0x203E},
#else
{0x7e, 0x007e},
#endif
{0x7f, 0x007f},
{0xA0,0xF8F0},
{0xA1,0xFF61},
{0xA2,0xFF62},
{0xA3,0xFF63},
{0xA4,0xFF64},
{0xA5,0xFF65},
{0xA6,0xFF66},
{0xA7,0xFF67},
{0xA8,0xFF68},
{0xA9,0xFF69},
{0xAA,0xFF6A},
{0xAB,0xFF6B},
{0xAC,0xFF6C},
{0xAD,0xFF6D},
{0xAE,0xFF6E},
{0xAF,0xFF6F},
{0xB0,0xFF70},
{0xB1,0xFF71},
{0xB2,0xFF72},
{0xB3,0xFF73},
{0xB4,0xFF74},
{0xB5,0xFF75},
{0xB6,0xFF76},
{0xB7,0xFF77},
{0xB8,0xFF78},
{0xB9,0xFF79},
{0xBA,0xFF7A},
{0xBB,0xFF7B},
{0xBC,0xFF7C},
{0xBD,0xFF7D},
{0xBE,0xFF7E},
{0xBF,0xFF7F},
{0xC0,0xFF80},
{0xC1,0xFF81},
{0xC2,0xFF82},
{0xC3,0xFF83},
{0xC4,0xFF84},
{0xC5,0xFF85},
{0xC6,0xFF86},
{0xC7,0xFF87},
{0xC8,0xFF88},
{0xC9,0xFF89},
{0xCA,0xFF8A},
{0xCB,0xFF8B},
{0xCC,0xFF8C},
{0xCD,0xFF8D},
{0xCE,0xFF8E},
{0xCF,0xFF8F},
{0xD0,0xFF90},
{0xD1,0xFF91},
{0xD2,0xFF92},
{0xD3,0xFF93},
{0xD4,0xFF94},
{0xD5,0xFF95},
{0xD6,0xFF96},
{0xD7,0xFF97},
{0xD8,0xFF98},
{0xD9,0xFF99},
{0xDA,0xFF9A},
{0xDB,0xFF9B},
{0xDC,0xFF9C},
{0xDD,0xFF9D},
{0xDE,0xFF9E},
{0xDF,0xFF9F},
{0xFD,0xF8F1},
{0xFE,0xF8F2},
{0xFF,0xF8F3},
{0x8140,0x3000},
{0x8141,0x3001},
{0x8142,0x3002},
{0x8143,0xFF0C},
{0x8144,0xFF0E},
{0x8145,0x30FB},
{0x8146,0xFF1A},
{0x8147,0xFF1B},
{0x8148,0xFF1F},
{0x8149,0xFF01},
{0x814A,0x309B},
{0x814B,0x309C},
{0x814C,0x00B4},
{0x814D,0xFF40},
{0x814E,0x00A8},
{0x814F,0xFF3E},
{0x8150,0xFFE3},
{0x8151,0xFF3F},
{0x8152,0x30FD},
{0x8153,0x30FE},
{0x8154,0x309D},
{0x8155,0x309E},
{0x8156,0x3003},
{0x8157,0x4EDD},
{0x8158,0x3005},
{0x8159,0x3006},
{0x815A,0x3007},
{0x815B,0x30FC},
{0x815C,0x2015},
{0x815D,0x2010},
{0x815E,0xFF0F},
#ifdef UNICODEMAPPING
{0x815F,0x005C},
#else
{0x815f,0xff3c},
#endif
{0x8160,0xFF5E},
{0x8161,0x2225},
{0x8162,0xFF5C},
{0x8163,0x2026},
{0x8164,0x2025},
{0x8165,0x2018},
{0x8166,0x2019},
{0x8167,0x201C},
{0x8168,0x201D},
{0x8169,0xFF08},
{0x816A,0xFF09},
{0x816B,0x3014},
{0x816C,0x3015},
{0x816D,0xFF3B},
{0x816E,0xFF3D},
{0x816F,0xFF5B},
{0x8170,0xFF5D},
{0x8171,0x3008},
{0x8172,0x3009},
{0x8173,0x300A},
{0x8174,0x300B},
{0x8175,0x300C},
{0x8176,0x300D},
{0x8177,0x300E},
{0x8178,0x300F},
{0x8179,0x3010},
{0x817A,0x3011},
{0x817B,0xFF0B},
{0x817C,0xFF0D},
{0x817D,0x00B1},
{0x817E,0x00D7},
{0x8180,0x00F7},
{0x8181,0xFF1D},
{0x8182,0x2260},
{0x8183,0xFF1C},
{0x8184,0xFF1E},
{0x8185,0x2266},
{0x8186,0x2267},
{0x8187,0x221E},
{0x8188,0x2234},
{0x8189,0x2642},
{0x818A,0x2640},
{0x818B,0x00B0},
{0x818C,0x2032},
{0x818D,0x2033},
{0x818E,0x2103},
{0x818F,0xFFE5},
{0x8190,0xFF04},
{0x8191,0xFFE0},
{0x8192,0xFFE1},
{0x8193,0xFF05},
{0x8194,0xFF03},
{0x8195,0xFF06},
{0x8196,0xFF0A},
{0x8197,0xFF20},
{0x8198,0x00A7},
{0x8199,0x2606},
{0x819A,0x2605},
{0x819B,0x25CB},
{0x819C,0x25CF},
{0x819D,0x25CE},
{0x819E,0x25C7},
{0x819F,0x25C6},
{0x81A0,0x25A1},
{0x81A1,0x25A0},
{0x81A2,0x25B3},
{0x81A3,0x25B2},
{0x81A4,0x25BD},
{0x81A5,0x25BC},
{0x81A6,0x203B},
{0x81A7,0x3012},
{0x81A8,0x2192},
{0x81A9,0x2190},
{0x81AA,0x2191},
{0x81AB,0x2193},
{0x81AC,0x3013},
{0x81B8,0x2208},
{0x81B9,0x220B},
{0x81BA,0x2286},
{0x81BB,0x2287},
{0x81BC,0x2282},
{0x81BD,0x2283},
{0x81BE,0x222A},
{0x81BF,0x2229},
{0x81C8,0x2227},
{0x81C9,0x2228},
{0x81CA,0xFFE2},
{0x81CB,0x21D2},
{0x81CC,0x21D4},
{0x81CD,0x2200},
{0x81CE,0x2203},
{0x81DA,0x2220},
{0x81DB,0x22A5},
{0x81DC,0x2312},
{0x81DD,0x2202},
{0x81DE,0x2207},
{0x81DF,0x2261},
{0x81E0,0x2252},
{0x81E1,0x226A},
{0x81E2,0x226B},
{0x81E3,0x221A},
{0x81E4,0x223D},
{0x81E5,0x221D},
{0x81E6,0x2235},
{0x81E7,0x222B},
{0x81E8,0x222C},
{0x81F0,0x212B},
{0x81F1,0x2030},
{0x81F2,0x266F},
{0x81F3,0x266D},
{0x81F4,0x266A},
{0x81F5,0x2020},
{0x81F6,0x2021},
{0x81F7,0x00B6},
{0x81FC,0x25EF},
{0x824F,0xFF10},
{0x8250,0xFF11},
{0x8251,0xFF12},
{0x8252,0xFF13},
{0x8253,0xFF14},
{0x8254,0xFF15},
{0x8255,0xFF16},
{0x8256,0xFF17},
{0x8257,0xFF18},
{0x8258,0xFF19},
{0x8260,0xFF21},
{0x8261,0xFF22},
{0x8262,0xFF23},
{0x8263,0xFF24},
{0x8264,0xFF25},
{0x8265,0xFF26},
{0x8266,0xFF27},
{0x8267,0xFF28},
{0x8268,0xFF29},
{0x8269,0xFF2A},
{0x826A,0xFF2B},
{0x826B,0xFF2C},
{0x826C,0xFF2D},
{0x826D,0xFF2E},
{0x826E,0xFF2F},
{0x826F,0xFF30},
{0x8270,0xFF31},
{0x8271,0xFF32},
{0x8272,0xFF33},
{0x8273,0xFF34},
{0x8274,0xFF35},
{0x8275,0xFF36},
{0x8276,0xFF37},
{0x8277,0xFF38},
{0x8278,0xFF39},
{0x8279,0xFF3A},
{0x8281,0xFF41},
{0x8282,0xFF42},
{0x8283,0xFF43},
{0x8284,0xFF44},
{0x8285,0xFF45},
{0x8286,0xFF46},
{0x8287,0xFF47},
{0x8288,0xFF48},
{0x8289,0xFF49},
{0x828A,0xFF4A},
{0x828B,0xFF4B},
{0x828C,0xFF4C},
{0x828D,0xFF4D},
{0x828E,0xFF4E},
{0x828F,0xFF4F},
{0x8290,0xFF50},
{0x8291,0xFF51},
{0x8292,0xFF52},
{0x8293,0xFF53},
{0x8294,0xFF54},
{0x8295,0xFF55},
{0x8296,0xFF56},
{0x8297,0xFF57},
{0x8298,0xFF58},
{0x8299,0xFF59},
{0x829A,0xFF5A},
{0x829F,0x3041},
{0x82A0,0x3042},
{0x82A1,0x3043},
{0x82A2,0x3044},
{0x82A3,0x3045},
{0x82A4,0x3046},
{0x82A5,0x3047},
{0x82A6,0x3048},
{0x82A7,0x3049},
{0x82A8,0x304A},
{0x82A9,0x304B},
{0x82AA,0x304C},
{0x82AB,0x304D},
{0x82AC,0x304E},
{0x82AD,0x304F},
{0x82AE,0x3050},
{0x82AF,0x3051},
{0x82B0,0x3052},
{0x82B1,0x3053},
{0x82B2,0x3054},
{0x82B3,0x3055},
{0x82B4,0x3056},
{0x82B5,0x3057},
{0x82B6,0x3058},
{0x82B7,0x3059},
{0x82B8,0x305A},
{0x82B9,0x305B},
{0x82BA,0x305C},
{0x82BB,0x305D},
{0x82BC,0x305E},
{0x82BD,0x305F},
{0x82BE,0x3060},
{0x82BF,0x3061},
{0x82C0,0x3062},
{0x82C1,0x3063},
{0x82C2,0x3064},
{0x82C3,0x3065},
{0x82C4,0x3066},
{0x82C5,0x3067},
{0x82C6,0x3068},
{0x82C7,0x3069},
{0x82C8,0x306A},
{0x82C9,0x306B},
{0x82CA,0x306C},
{0x82CB,0x306D},
{0x82CC,0x306E},
{0x82CD,0x306F},
{0x82CE,0x3070},
{0x82CF,0x3071},
{0x82D0,0x3072},
{0x82D1,0x3073},
{0x82D2,0x3074},
{0x82D3,0x3075},
{0x82D4,0x3076},
{0x82D5,0x3077},
{0x82D6,0x3078},
{0x82D7,0x3079},
{0x82D8,0x307A},
{0x82D9,0x307B},
{0x82DA,0x307C},
{0x82DB,0x307D},
{0x82DC,0x307E},
{0x82DD,0x307F},
{0x82DE,0x3080},
{0x82DF,0x3081},
{0x82E0,0x3082},
{0x82E1,0x3083},
{0x82E2,0x3084},
{0x82E3,0x3085},
{0x82E4,0x3086},
{0x82E5,0x3087},
{0x82E6,0x3088},
{0x82E7,0x3089},
{0x82E8,0x308A},
{0x82E9,0x308B},
{0x82EA,0x308C},
{0x82EB,0x308D},
{0x82EC,0x308E},
{0x82ED,0x308F},
{0x82EE,0x3090},
{0x82EF,0x3091},
{0x82F0,0x3092},
{0x82F1,0x3093},
{0x8340,0x30A1},
{0x8341,0x30A2},
{0x8342,0x30A3},
{0x8343,0x30A4},
{0x8344,0x30A5},
{0x8345,0x30A6},
{0x8346,0x30A7},
{0x8347,0x30A8},
{0x8348,0x30A9},
{0x8349,0x30AA},
{0x834A,0x30AB},
{0x834B,0x30AC},
{0x834C,0x30AD},
{0x834D,0x30AE},
{0x834E,0x30AF},
{0x834F,0x30B0},
{0x8350,0x30B1},
{0x8351,0x30B2},
{0x8352,0x30B3},
{0x8353,0x30B4},
{0x8354,0x30B5},
{0x8355,0x30B6},
{0x8356,0x30B7},
{0x8357,0x30B8},
{0x8358,0x30B9},
{0x8359,0x30BA},
{0x835A,0x30BB},
{0x835B,0x30BC},
{0x835C,0x30BD},
{0x835D,0x30BE},
{0x835E,0x30BF},
{0x835F,0x30C0},
{0x8360,0x30C1},
{0x8361,0x30C2},
{0x8362,0x30C3},
{0x8363,0x30C4},
{0x8364,0x30C5},
{0x8365,0x30C6},
{0x8366,0x30C7},
{0x8367,0x30C8},
{0x8368,0x30C9},
{0x8369,0x30CA},
{0x836A,0x30CB},
{0x836B,0x30CC},
{0x836C,0x30CD},
{0x836D,0x30CE},
{0x836E,0x30CF},
{0x836F,0x30D0},
{0x8370,0x30D1},
{0x8371,0x30D2},
{0x8372,0x30D3},
{0x8373,0x30D4},
{0x8374,0x30D5},
{0x8375,0x30D6},
{0x8376,0x30D7},
{0x8377,0x30D8},
{0x8378,0x30D9},
{0x8379,0x30DA},
{0x837A,0x30DB},
{0x837B,0x30DC},
{0x837C,0x30DD},
{0x837D,0x30DE},
{0x837E,0x30DF},
{0x8380,0x30E0},
{0x8381,0x30E1},
{0x8382,0x30E2},
{0x8383,0x30E3},
{0x8384,0x30E4},
{0x8385,0x30E5},
{0x8386,0x30E6},
{0x8387,0x30E7},
{0x8388,0x30E8},
{0x8389,0x30E9},
{0x838A,0x30EA},
{0x838B,0x30EB},
{0x838C,0x30EC},
{0x838D,0x30ED},
{0x838E,0x30EE},
{0x838F,0x30EF},
{0x8390,0x30F0},
{0x8391,0x30F1},
{0x8392,0x30F2},
{0x8393,0x30F3},
{0x8394,0x30F4},
{0x8395,0x30F5},
{0x8396,0x30F6},
{0x839F,0x0391},
{0x83A0,0x0392},
{0x83A1,0x0393},
{0x83A2,0x0394},
{0x83A3,0x0395},
{0x83A4,0x0396},
{0x83A5,0x0397},
{0x83A6,0x0398},
{0x83A7,0x0399},
{0x83A8,0x039A},
{0x83A9,0x039B},
{0x83AA,0x039C},
{0x83AB,0x039D},
{0x83AC,0x039E},
{0x83AD,0x039F},
{0x83AE,0x03A0},
{0x83AF,0x03A1},
{0x83B0,0x03A3},
{0x83B1,0x03A4},
{0x83B2,0x03A5},
{0x83B3,0x03A6},
{0x83B4,0x03A7},
{0x83B5,0x03A8},
{0x83B6,0x03A9},
{0x83BF,0x03B1},
{0x83C0,0x03B2},
{0x83C1,0x03B3},
{0x83C2,0x03B4},
{0x83C3,0x03B5},
{0x83C4,0x03B6},
{0x83C5,0x03B7},
{0x83C6,0x03B8},
{0x83C7,0x03B9},
{0x83C8,0x03BA},
{0x83C9,0x03BB},
{0x83CA,0x03BC},
{0x83CB,0x03BD},
{0x83CC,0x03BE},
{0x83CD,0x03BF},
{0x83CE,0x03C0},
{0x83CF,0x03C1},
{0x83D0,0x03C3},
{0x83D1,0x03C4},
{0x83D2,0x03C5},
{0x83D3,0x03C6},
{0x83D4,0x03C7},
{0x83D5,0x03C8},
{0x83D6,0x03C9},
{0x8440,0x0410},
{0x8441,0x0411},
{0x8442,0x0412},
{0x8443,0x0413},
{0x8444,0x0414},
{0x8445,0x0415},
{0x8446,0x0401},
{0x8447,0x0416},
{0x8448,0x0417},
{0x8449,0x0418},
{0x844A,0x0419},
{0x844B,0x041A},
{0x844C,0x041B},
{0x844D,0x041C},
{0x844E,0x041D},
{0x844F,0x041E},
{0x8450,0x041F},
{0x8451,0x0420},
{0x8452,0x0421},
{0x8453,0x0422},
{0x8454,0x0423},
{0x8455,0x0424},
{0x8456,0x0425},
{0x8457,0x0426},
{0x8458,0x0427},
{0x8459,0x0428},
{0x845A,0x0429},
{0x845B,0x042A},
{0x845C,0x042B},
{0x845D,0x042C},
{0x845E,0x042D},
{0x845F,0x042E},
{0x8460,0x042F},
{0x8470,0x0430},
{0x8471,0x0431},
{0x8472,0x0432},
{0x8473,0x0433},
{0x8474,0x0434},
{0x8475,0x0435},
{0x8476,0x0451},
{0x8477,0x0436},
{0x8478,0x0437},
{0x8479,0x0438},
{0x847A,0x0439},
{0x847B,0x043A},
{0x847C,0x043B},
{0x847D,0x043C},
{0x847E,0x043D},
{0x8480,0x043E},
{0x8481,0x043F},
{0x8482,0x0440},
{0x8483,0x0441},
{0x8484,0x0442},
{0x8485,0x0443},
{0x8486,0x0444},
{0x8487,0x0445},
{0x8488,0x0446},
{0x8489,0x0447},
{0x848A,0x0448},
{0x848B,0x0449},
{0x848C,0x044A},
{0x848D,0x044B},
{0x848E,0x044C},
{0x848F,0x044D},
{0x8490,0x044E},
{0x8491,0x044F},
{0x849F,0x2500},
{0x84A0,0x2502},
{0x84A1,0x250C},
{0x84A2,0x2510},
{0x84A3,0x2518},
{0x84A4,0x2514},
{0x84A5,0x251C},
{0x84A6,0x252C},
{0x84A7,0x2524},
{0x84A8,0x2534},
{0x84A9,0x253C},
{0x84AA,0x2501},
{0x84AB,0x2503},
{0x84AC,0x250F},
{0x84AD,0x2513},
{0x84AE,0x251B},
{0x84AF,0x2517},
{0x84B0,0x2523},
{0x84B1,0x2533},
{0x84B2,0x252B},
{0x84B3,0x253B},
{0x84B4,0x254B},
{0x84B5,0x2520},
{0x84B6,0x252F},
{0x84B7,0x2528},
{0x84B8,0x2537},
{0x84B9,0x253F},
{0x84BA,0x251D},
{0x84BB,0x2530},
{0x84BC,0x2525},
{0x84BD,0x2538},
{0x84BE,0x2542},
{0x8740,0x2460},
{0x8741,0x2461},
{0x8742,0x2462},
{0x8743,0x2463},
{0x8744,0x2464},
{0x8745,0x2465},
{0x8746,0x2466},
{0x8747,0x2467},
{0x8748,0x2468},
{0x8749,0x2469},
{0x874A,0x246A},
{0x874B,0x246B},
{0x874C,0x246C},
{0x874D,0x246D},
{0x874E,0x246E},
{0x874F,0x246F},
{0x8750,0x2470},
{0x8751,0x2471},
{0x8752,0x2472},
{0x8753,0x2473},
{0x8754,0x2160},
{0x8755,0x2161},
{0x8756,0x2162},
{0x8757,0x2163},
{0x8758,0x2164},
{0x8759,0x2165},
{0x875A,0x2166},
{0x875B,0x2167},
{0x875C,0x2168},
{0x875D,0x2169},
{0x875F,0x3349},
{0x8760,0x3314},
{0x8761,0x3322},
{0x8762,0x334D},
{0x8763,0x3318},
{0x8764,0x3327},
{0x8765,0x3303},
{0x8766,0x3336},
{0x8767,0x3351},
{0x8768,0x3357},
{0x8769,0x330D},
{0x876A,0x3326},
{0x876B,0x3323},
{0x876C,0x332B},
{0x876D,0x334A},
{0x876E,0x333B},
{0x876F,0x339C},
{0x8770,0x339D},
{0x8771,0x339E},
{0x8772,0x338E},
{0x8773,0x338F},
{0x8774,0x33C4},
{0x8775,0x33A1},
{0x877E,0x337B},
{0x8780,0x301D},
{0x8781,0x301F},
{0x8782,0x2116},
{0x8783,0x33CD},
{0x8784,0x2121},
{0x8785,0x32A4},
{0x8786,0x32A5},
{0x8787,0x32A6},
{0x8788,0x32A7},
{0x8789,0x32A8},
{0x878A,0x3231},
{0x878B,0x3232},
{0x878C,0x3239},
{0x878D,0x337E},
{0x878E,0x337D},
{0x878F,0x337C},
{0x8790,0x2252},
{0x8791,0x2261},
{0x8792,0x222B},
{0x8793,0x222E},
{0x8794,0x2211},
{0x8795,0x221A},
{0x8796,0x22A5},
{0x8797,0x2220},
{0x8798,0x221F},
{0x8799,0x22BF},
{0x879A,0x2235},
{0x879B,0x2229},
{0x879C,0x222A},
{0x889F,0x4E9C},
{0x88A0,0x5516},
{0x88A1,0x5A03},
{0x88A2,0x963F},
{0x88A3,0x54C0},
{0x88A4,0x611B},
{0x88A5,0x6328},
{0x88A6,0x59F6},
{0x88A7,0x9022},
{0x88A8,0x8475},
{0x88A9,0x831C},
{0x88AA,0x7A50},
{0x88AB,0x60AA},
{0x88AC,0x63E1},
{0x88AD,0x6E25},
{0x88AE,0x65ED},
{0x88AF,0x8466},
{0x88B0,0x82A6},
{0x88B1,0x9BF5},
{0x88B2,0x6893},
{0x88B3,0x5727},
{0x88B4,0x65A1},
{0x88B5,0x6271},
{0x88B6,0x5B9B},
{0x88B7,0x59D0},
{0x88B8,0x867B},
{0x88B9,0x98F4},
{0x88BA,0x7D62},
{0x88BB,0x7DBE},
{0x88BC,0x9B8E},
{0x88BD,0x6216},
{0x88BE,0x7C9F},
{0x88BF,0x88B7},
{0x88C0,0x5B89},
{0x88C1,0x5EB5},
{0x88C2,0x6309},
{0x88C3,0x6697},
{0x88C4,0x6848},
{0x88C5,0x95C7},
{0x88C6,0x978D},
{0x88C7,0x674F},
{0x88C8,0x4EE5},
{0x88C9,0x4F0A},
{0x88CA,0x4F4D},
{0x88CB,0x4F9D},
{0x88CC,0x5049},
{0x88CD,0x56F2},
{0x88CE,0x5937},
{0x88CF,0x59D4},
{0x88D0,0x5A01},
{0x88D1,0x5C09},
{0x88D2,0x60DF},
{0x88D3,0x610F},
{0x88D4,0x6170},
{0x88D5,0x6613},
{0x88D6,0x6905},
{0x88D7,0x70BA},
{0x88D8,0x754F},
{0x88D9,0x7570},
{0x88DA,0x79FB},
{0x88DB,0x7DAD},
{0x88DC,0x7DEF},
{0x88DD,0x80C3},
{0x88DE,0x840E},
{0x88DF,0x8863},
{0x88E0,0x8B02},
{0x88E1,0x9055},
{0x88E2,0x907A},
{0x88E3,0x533B},
{0x88E4,0x4E95},
{0x88E5,0x4EA5},
{0x88E6,0x57DF},
{0x88E7,0x80B2},
{0x88E8,0x90C1},
{0x88E9,0x78EF},
{0x88EA,0x4E00},
{0x88EB,0x58F1},
{0x88EC,0x6EA2},
{0x88ED,0x9038},
{0x88EE,0x7A32},
{0x88EF,0x8328},
{0x88F0,0x828B},
{0x88F1,0x9C2F},
{0x88F2,0x5141},
{0x88F3,0x5370},
{0x88F4,0x54BD},
{0x88F5,0x54E1},
{0x88F6,0x56E0},
{0x88F7,0x59FB},
{0x88F8,0x5F15},
{0x88F9,0x98F2},
{0x88FA,0x6DEB},
{0x88FB,0x80E4},
{0x88FC,0x852D},
{0x8940,0x9662},
{0x8941,0x9670},
{0x8942,0x96A0},
{0x8943,0x97FB},
{0x8944,0x540B},
{0x8945,0x53F3},
{0x8946,0x5B87},
{0x8947,0x70CF},
{0x8948,0x7FBD},
{0x8949,0x8FC2},
{0x894A,0x96E8},
{0x894B,0x536F},
{0x894C,0x9D5C},
{0x894D,0x7ABA},
{0x894E,0x4E11},
{0x894F,0x7893},
{0x8950,0x81FC},
{0x8951,0x6E26},
{0x8952,0x5618},
{0x8953,0x5504},
{0x8954,0x6B1D},
{0x8955,0x851A},
{0x8956,0x9C3B},
{0x8957,0x59E5},
{0x8958,0x53A9},
{0x8959,0x6D66},
{0x895A,0x74DC},
{0x895B,0x958F},
{0x895C,0x5642},
{0x895D,0x4E91},
{0x895E,0x904B},
{0x895F,0x96F2},
{0x8960,0x834F},
{0x8961,0x990C},
{0x8962,0x53E1},
{0x8963,0x55B6},
{0x8964,0x5B30},
{0x8965,0x5F71},
{0x8966,0x6620},
{0x8967,0x66F3},
{0x8968,0x6804},
{0x8969,0x6C38},
{0x896A,0x6CF3},
{0x896B,0x6D29},
{0x896C,0x745B},
{0x896D,0x76C8},
{0x896E,0x7A4E},
{0x896F,0x9834},
{0x8970,0x82F1},
{0x8971,0x885B},
{0x8972,0x8A60},
{0x8973,0x92ED},
{0x8974,0x6DB2},
{0x8975,0x75AB},
{0x8976,0x76CA},
{0x8977,0x99C5},
{0x8978,0x60A6},
{0x8979,0x8B01},
{0x897A,0x8D8A},
{0x897B,0x95B2},
{0x897C,0x698E},
{0x897D,0x53AD},
{0x897E,0x5186},
{0x8980,0x5712},
{0x8981,0x5830},
{0x8982,0x5944},
{0x8983,0x5BB4},
{0x8984,0x5EF6},
{0x8985,0x6028},
{0x8986,0x63A9},
{0x8987,0x63F4},
{0x8988,0x6CBF},
{0x8989,0x6F14},
{0x898A,0x708E},
{0x898B,0x7114},
{0x898C,0x7159},
{0x898D,0x71D5},
{0x898E,0x733F},
{0x898F,0x7E01},
{0x8990,0x8276},
{0x8991,0x82D1},
{0x8992,0x8597},
{0x8993,0x9060},
{0x8994,0x925B},
{0x8995,0x9D1B},
{0x8996,0x5869},
{0x8997,0x65BC},
{0x8998,0x6C5A},
{0x8999,0x7525},
{0x899A,0x51F9},
{0x899B,0x592E},
{0x899C,0x5965},
{0x899D,0x5F80},
{0x899E,0x5FDC},
{0x899F,0x62BC},
{0x89A0,0x65FA},
{0x89A1,0x6A2A},
{0x89A2,0x6B27},
{0x89A3,0x6BB4},
{0x89A4,0x738B},
{0x89A5,0x7FC1},
{0x89A6,0x8956},
{0x89A7,0x9D2C},
{0x89A8,0x9D0E},
{0x89A9,0x9EC4},
{0x89AA,0x5CA1},
{0x89AB,0x6C96},
{0x89AC,0x837B},
{0x89AD,0x5104},
{0x89AE,0x5C4B},
{0x89AF,0x61B6},
{0x89B0,0x81C6},
{0x89B1,0x6876},
{0x89B2,0x7261},
{0x89B3,0x4E59},
{0x89B4,0x4FFA},
{0x89B5,0x5378},
{0x89B6,0x6069},
{0x89B7,0x6E29},
{0x89B8,0x7A4F},
{0x89B9,0x97F3},
{0x89BA,0x4E0B},
{0x89BB,0x5316},
{0x89BC,0x4EEE},
{0x89BD,0x4F55},
{0x89BE,0x4F3D},
{0x89BF,0x4FA1},
{0x89C0,0x4F73},
{0x89C1,0x52A0},
{0x89C2,0x53EF},
{0x89C3,0x5609},
{0x89C4,0x590F},
{0x89C5,0x5AC1},
{0x89C6,0x5BB6},
{0x89C7,0x5BE1},
{0x89C8,0x79D1},
{0x89C9,0x6687},
{0x89CA,0x679C},
{0x89CB,0x67B6},
{0x89CC,0x6B4C},
{0x89CD,0x6CB3},
{0x89CE,0x706B},
{0x89CF,0x73C2},
{0x89D0,0x798D},
{0x89D1,0x79BE},
{0x89D2,0x7A3C},
{0x89D3,0x7B87},
{0x89D4,0x82B1},
{0x89D5,0x82DB},
{0x89D6,0x8304},
{0x89D7,0x8377},
{0x89D8,0x83EF},
{0x89D9,0x83D3},
{0x89DA,0x8766},
{0x89DB,0x8AB2},
{0x89DC,0x5629},
{0x89DD,0x8CA8},
{0x89DE,0x8FE6},
{0x89DF,0x904E},
{0x89E0,0x971E},
{0x89E1,0x868A},
{0x89E2,0x4FC4},
{0x89E3,0x5CE8},
{0x89E4,0x6211},
{0x89E5,0x7259},
{0x89E6,0x753B},
{0x89E7,0x81E5},
{0x89E8,0x82BD},
{0x89E9,0x86FE},
{0x89EA,0x8CC0},
{0x89EB,0x96C5},
{0x89EC,0x9913},
{0x89ED,0x99D5},
{0x89EE,0x4ECB},
{0x89EF,0x4F1A},
{0x89F0,0x89E3},
{0x89F1,0x56DE},
{0x89F2,0x584A},
{0x89F3,0x58CA},
{0x89F4,0x5EFB},
{0x89F5,0x5FEB},
{0x89F6,0x602A},
{0x89F7,0x6094},
{0x89F8,0x6062},
{0x89F9,0x61D0},
{0x89FA,0x6212},
{0x89FB,0x62D0},
{0x89FC,0x6539},
{0x8A40,0x9B41},
{0x8A41,0x6666},
{0x8A42,0x68B0},
{0x8A43,0x6D77},
{0x8A44,0x7070},
{0x8A45,0x754C},
{0x8A46,0x7686},
{0x8A47,0x7D75},
{0x8A48,0x82A5},
{0x8A49,0x87F9},
{0x8A4A,0x958B},
{0x8A4B,0x968E},
{0x8A4C,0x8C9D},
{0x8A4D,0x51F1},
{0x8A4E,0x52BE},
{0x8A4F,0x5916},
{0x8A50,0x54B3},
{0x8A51,0x5BB3},
{0x8A52,0x5D16},
{0x8A53,0x6168},
{0x8A54,0x6982},
{0x8A55,0x6DAF},
{0x8A56,0x788D},
{0x8A57,0x84CB},
{0x8A58,0x8857},
{0x8A59,0x8A72},
{0x8A5A,0x93A7},
{0x8A5B,0x9AB8},
{0x8A5C,0x6D6C},
{0x8A5D,0x99A8},
{0x8A5E,0x86D9},
{0x8A5F,0x57A3},
{0x8A60,0x67FF},
{0x8A61,0x86CE},
{0x8A62,0x920E},
{0x8A63,0x5283},
{0x8A64,0x5687},
{0x8A65,0x5404},
{0x8A66,0x5ED3},
{0x8A67,0x62E1},
{0x8A68,0x64B9},
{0x8A69,0x683C},
{0x8A6A,0x6838},
{0x8A6B,0x6BBB},
{0x8A6C,0x7372},
{0x8A6D,0x78BA},
{0x8A6E,0x7A6B},
{0x8A6F,0x899A},
{0x8A70,0x89D2},
{0x8A71,0x8D6B},
{0x8A72,0x8F03},
{0x8A73,0x90ED},
{0x8A74,0x95A3},
{0x8A75,0x9694},
{0x8A76,0x9769},
{0x8A77,0x5B66},
{0x8A78,0x5CB3},
{0x8A79,0x697D},
{0x8A7A,0x984D},
{0x8A7B,0x984E},
{0x8A7C,0x639B},
{0x8A7D,0x7B20},
{0x8A7E,0x6A2B},
{0x8A80,0x6A7F},
{0x8A81,0x68B6},
{0x8A82,0x9C0D},
{0x8A83,0x6F5F},
{0x8A84,0x5272},
{0x8A85,0x559D},
{0x8A86,0x6070},
{0x8A87,0x62EC},
{0x8A88,0x6D3B},
{0x8A89,0x6E07},
{0x8A8A,0x6ED1},
{0x8A8B,0x845B},
{0x8A8C,0x8910},
{0x8A8D,0x8F44},
{0x8A8E,0x4E14},
{0x8A8F,0x9C39},
{0x8A90,0x53F6},
{0x8A91,0x691B},
{0x8A92,0x6A3A},
{0x8A93,0x9784},
{0x8A94,0x682A},
{0x8A95,0x515C},
{0x8A96,0x7AC3},
{0x8A97,0x84B2},
{0x8A98,0x91DC},
{0x8A99,0x938C},
{0x8A9A,0x565B},
{0x8A9B,0x9D28},
{0x8A9C,0x6822},
{0x8A9D,0x8305},
{0x8A9E,0x8431},
{0x8A9F,0x7CA5},
{0x8AA0,0x5208},
{0x8AA1,0x82C5},
{0x8AA2,0x74E6},
{0x8AA3,0x4E7E},
{0x8AA4,0x4F83},
{0x8AA5,0x51A0},
{0x8AA6,0x5BD2},
{0x8AA7,0x520A},
{0x8AA8,0x52D8},
{0x8AA9,0x52E7},
{0x8AAA,0x5DFB},
{0x8AAB,0x559A},
{0x8AAC,0x582A},
{0x8AAD,0x59E6},
{0x8AAE,0x5B8C},
{0x8AAF,0x5B98},
{0x8AB0,0x5BDB},
{0x8AB1,0x5E72},
{0x8AB2,0x5E79},
{0x8AB3,0x60A3},
{0x8AB4,0x611F},
{0x8AB5,0x6163},
{0x8AB6,0x61BE},
{0x8AB7,0x63DB},
{0x8AB8,0x6562},
{0x8AB9,0x67D1},
{0x8ABA,0x6853},
{0x8ABB,0x68FA},
{0x8ABC,0x6B3E},
{0x8ABD,0x6B53},
{0x8ABE,0x6C57},
{0x8ABF,0x6F22},
{0x8AC0,0x6F97},
{0x8AC1,0x6F45},
{0x8AC2,0x74B0},
{0x8AC3,0x7518},
{0x8AC4,0x76E3},
{0x8AC5,0x770B},
{0x8AC6,0x7AFF},
{0x8AC7,0x7BA1},
{0x8AC8,0x7C21},
{0x8AC9,0x7DE9},
{0x8ACA,0x7F36},
{0x8ACB,0x7FF0},
{0x8ACC,0x809D},
{0x8ACD,0x8266},
{0x8ACE,0x839E},
{0x8ACF,0x89B3},
{0x8AD0,0x8ACC},
{0x8AD1,0x8CAB},
{0x8AD2,0x9084},
{0x8AD3,0x9451},
{0x8AD4,0x9593},
{0x8AD5,0x9591},
{0x8AD6,0x95A2},
{0x8AD7,0x9665},
{0x8AD8,0x97D3},
{0x8AD9,0x9928},
{0x8ADA,0x8218},
{0x8ADB,0x4E38},
{0x8ADC,0x542B},
{0x8ADD,0x5CB8},
{0x8ADE,0x5DCC},
{0x8ADF,0x73A9},
{0x8AE0,0x764C},
{0x8AE1,0x773C},
{0x8AE2,0x5CA9},
{0x8AE3,0x7FEB},
{0x8AE4,0x8D0B},
{0x8AE5,0x96C1},
{0x8AE6,0x9811},
{0x8AE7,0x9854},
{0x8AE8,0x9858},
{0x8AE9,0x4F01},
{0x8AEA,0x4F0E},
{0x8AEB,0x5371},
{0x8AEC,0x559C},
{0x8AED,0x5668},
{0x8AEE,0x57FA},
{0x8AEF,0x5947},
{0x8AF0,0x5B09},
{0x8AF1,0x5BC4},
{0x8AF2,0x5C90},
{0x8AF3,0x5E0C},
{0x8AF4,0x5E7E},
{0x8AF5,0x5FCC},
{0x8AF6,0x63EE},
{0x8AF7,0x673A},
{0x8AF8,0x65D7},
{0x8AF9,0x65E2},
{0x8AFA,0x671F},
{0x8AFB,0x68CB},
{0x8AFC,0x68C4},
{0x8B40,0x6A5F},
{0x8B41,0x5E30},
{0x8B42,0x6BC5},
{0x8B43,0x6C17},
{0x8B44,0x6C7D},
{0x8B45,0x757F},
{0x8B46,0x7948},
{0x8B47,0x5B63},
{0x8B48,0x7A00},
{0x8B49,0x7D00},
{0x8B4A,0x5FBD},
{0x8B4B,0x898F},
{0x8B4C,0x8A18},
{0x8B4D,0x8CB4},
{0x8B4E,0x8D77},
{0x8B4F,0x8ECC},
{0x8B50,0x8F1D},
{0x8B51,0x98E2},
{0x8B52,0x9A0E},
{0x8B53,0x9B3C},
{0x8B54,0x4E80},
{0x8B55,0x507D},
{0x8B56,0x5100},
{0x8B57,0x5993},
{0x8B58,0x5B9C},
{0x8B59,0x622F},
{0x8B5A,0x6280},
{0x8B5B,0x64EC},
{0x8B5C,0x6B3A},
{0x8B5D,0x72A0},
{0x8B5E,0x7591},
{0x8B5F,0x7947},
{0x8B60,0x7FA9},
{0x8B61,0x87FB},
{0x8B62,0x8ABC},
{0x8B63,0x8B70},
{0x8B64,0x63AC},
{0x8B65,0x83CA},
{0x8B66,0x97A0},
{0x8B67,0x5409},
{0x8B68,0x5403},
{0x8B69,0x55AB},
{0x8B6A,0x6854},
{0x8B6B,0x6A58},
{0x8B6C,0x8A70},
{0x8B6D,0x7827},
{0x8B6E,0x6775},
{0x8B6F,0x9ECD},
{0x8B70,0x5374},
{0x8B71,0x5BA2},
{0x8B72,0x811A},
{0x8B73,0x8650},
{0x8B74,0x9006},
{0x8B75,0x4E18},
{0x8B76,0x4E45},
{0x8B77,0x4EC7},
{0x8B78,0x4F11},
{0x8B79,0x53CA},
{0x8B7A,0x5438},
{0x8B7B,0x5BAE},
{0x8B7C,0x5F13},
{0x8B7D,0x6025},
{0x8B7E,0x6551},
{0x8B80,0x673D},
{0x8B81,0x6C42},
{0x8B82,0x6C72},
{0x8B83,0x6CE3},
{0x8B84,0x7078},
{0x8B85,0x7403},
{0x8B86,0x7A76},
{0x8B87,0x7AAE},
{0x8B88,0x7B08},
{0x8B89,0x7D1A},
{0x8B8A,0x7CFE},
{0x8B8B,0x7D66},
{0x8B8C,0x65E7},
{0x8B8D,0x725B},
{0x8B8E,0x53BB},
{0x8B8F,0x5C45},
{0x8B90,0x5DE8},
{0x8B91,0x62D2},
{0x8B92,0x62E0},
{0x8B93,0x6319},
{0x8B94,0x6E20},
{0x8B95,0x865A},
{0x8B96,0x8A31},
{0x8B97,0x8DDD},
{0x8B98,0x92F8},
{0x8B99,0x6F01},
{0x8B9A,0x79A6},
{0x8B9B,0x9B5A},
{0x8B9C,0x4EA8},
{0x8B9D,0x4EAB},
{0x8B9E,0x4EAC},
{0x8B9F,0x4F9B},
{0x8BA0,0x4FA0},
{0x8BA1,0x50D1},
{0x8BA2,0x5147},
{0x8BA3,0x7AF6},
{0x8BA4,0x5171},
{0x8BA5,0x51F6},
{0x8BA6,0x5354},
{0x8BA7,0x5321},
{0x8BA8,0x537F},
{0x8BA9,0x53EB},
{0x8BAA,0x55AC},
{0x8BAB,0x5883},
{0x8BAC,0x5CE1},
{0x8BAD,0x5F37},
{0x8BAE,0x5F4A},
{0x8BAF,0x602F},
{0x8BB0,0x6050},
{0x8BB1,0x606D},
{0x8BB2,0x631F},
{0x8BB3,0x6559},
{0x8BB4,0x6A4B},
{0x8BB5,0x6CC1},
{0x8BB6,0x72C2},
{0x8BB7,0x72ED},
{0x8BB8,0x77EF},
{0x8BB9,0x80F8},
{0x8BBA,0x8105},
{0x8BBB,0x8208},
{0x8BBC,0x854E},
{0x8BBD,0x90F7},
{0x8BBE,0x93E1},
{0x8BBF,0x97FF},
{0x8BC0,0x9957},
{0x8BC1,0x9A5A},
{0x8BC2,0x4EF0},
{0x8BC3,0x51DD},
{0x8BC4,0x5C2D},
{0x8BC5,0x6681},
{0x8BC6,0x696D},
{0x8BC7,0x5C40},
{0x8BC8,0x66F2},
{0x8BC9,0x6975},
{0x8BCA,0x7389},
{0x8BCB,0x6850},
{0x8BCC,0x7C81},
{0x8BCD,0x50C5},
{0x8BCE,0x52E4},
{0x8BCF,0x5747},
{0x8BD0,0x5DFE},
{0x8BD1,0x9326},
{0x8BD2,0x65A4},
{0x8BD3,0x6B23},
{0x8BD4,0x6B3D},
{0x8BD5,0x7434},
{0x8BD6,0x7981},
{0x8BD7,0x79BD},
{0x8BD8,0x7B4B},
{0x8BD9,0x7DCA},
{0x8BDA,0x82B9},
{0x8BDB,0x83CC},
{0x8BDC,0x887F},
{0x8BDD,0x895F},
{0x8BDE,0x8B39},
{0x8BDF,0x8FD1},
{0x8BE0,0x91D1},
{0x8BE1,0x541F},
{0x8BE2,0x9280},
{0x8BE3,0x4E5D},
{0x8BE4,0x5036},
{0x8BE5,0x53E5},
{0x8BE6,0x533A},
{0x8BE7,0x72D7},
{0x8BE8,0x7396},
{0x8BE9,0x77E9},
{0x8BEA,0x82E6},
{0x8BEB,0x8EAF},
{0x8BEC,0x99C6},
{0x8BED,0x99C8},
{0x8BEE,0x99D2},
{0x8BEF,0x5177},
{0x8BF0,0x611A},
{0x8BF1,0x865E},
{0x8BF2,0x55B0},
{0x8BF3,0x7A7A},
{0x8BF4,0x5076},
{0x8BF5,0x5BD3},
{0x8BF6,0x9047},
{0x8BF7,0x9685},
{0x8BF8,0x4E32},
{0x8BF9,0x6ADB},
{0x8BFA,0x91E7},
{0x8BFB,0x5C51},
{0x8BFC,0x5C48},
{0x8C40,0x6398},
{0x8C41,0x7A9F},
{0x8C42,0x6C93},
{0x8C43,0x9774},
{0x8C44,0x8F61},
{0x8C45,0x7AAA},
{0x8C46,0x718A},
{0x8C47,0x9688},
{0x8C48,0x7C82},
{0x8C49,0x6817},
{0x8C4A,0x7E70},
{0x8C4B,0x6851},
{0x8C4C,0x936C},
{0x8C4D,0x52F2},
{0x8C4E,0x541B},
{0x8C4F,0x85AB},
{0x8C50,0x8A13},
{0x8C51,0x7FA4},
{0x8C52,0x8ECD},
{0x8C53,0x90E1},
{0x8C54,0x5366},
{0x8C55,0x8888},
{0x8C56,0x7941},
{0x8C57,0x4FC2},
{0x8C58,0x50BE},
{0x8C59,0x5211},
{0x8C5A,0x5144},
{0x8C5B,0x5553},
{0x8C5C,0x572D},
{0x8C5D,0x73EA},
{0x8C5E,0x578B},
{0x8C5F,0x5951},
{0x8C60,0x5F62},
{0x8C61,0x5F84},
{0x8C62,0x6075},
{0x8C63,0x6176},
{0x8C64,0x6167},
{0x8C65,0x61A9},
{0x8C66,0x63B2},
{0x8C67,0x643A},
{0x8C68,0x656C},
{0x8C69,0x666F},
{0x8C6A,0x6842},
{0x8C6B,0x6E13},
{0x8C6C,0x7566},
{0x8C6D,0x7A3D},
{0x8C6E,0x7CFB},
{0x8C6F,0x7D4C},
{0x8C70,0x7D99},
{0x8C71,0x7E4B},
{0x8C72,0x7F6B},
{0x8C73,0x830E},
{0x8C74,0x834A},
{0x8C75,0x86CD},
{0x8C76,0x8A08},
{0x8C77,0x8A63},
{0x8C78,0x8B66},
{0x8C79,0x8EFD},
{0x8C7A,0x981A},
{0x8C7B,0x9D8F},
{0x8C7C,0x82B8},
{0x8C7D,0x8FCE},
{0x8C7E,0x9BE8},
{0x8C80,0x5287},
{0x8C81,0x621F},
{0x8C82,0x6483},
{0x8C83,0x6FC0},
{0x8C84,0x9699},
{0x8C85,0x6841},
{0x8C86,0x5091},
{0x8C87,0x6B20},
{0x8C88,0x6C7A},
{0x8C89,0x6F54},
{0x8C8A,0x7A74},
{0x8C8B,0x7D50},
{0x8C8C,0x8840},
{0x8C8D,0x8A23},
{0x8C8E,0x6708},
{0x8C8F,0x4EF6},
{0x8C90,0x5039},
{0x8C91,0x5026},
{0x8C92,0x5065},
{0x8C93,0x517C},
{0x8C94,0x5238},
{0x8C95,0x5263},
{0x8C96,0x55A7},
{0x8C97,0x570F},
{0x8C98,0x5805},
{0x8C99,0x5ACC},
{0x8C9A,0x5EFA},
{0x8C9B,0x61B2},
{0x8C9C,0x61F8},
{0x8C9D,0x62F3},
{0x8C9E,0x6372},
{0x8C9F,0x691C},
{0x8CA0,0x6A29},
{0x8CA1,0x727D},
{0x8CA2,0x72AC},
{0x8CA3,0x732E},
{0x8CA4,0x7814},
{0x8CA5,0x786F},
{0x8CA6,0x7D79},
{0x8CA7,0x770C},
{0x8CA8,0x80A9},
{0x8CA9,0x898B},
{0x8CAA,0x8B19},
{0x8CAB,0x8CE2},
{0x8CAC,0x8ED2},
{0x8CAD,0x9063},
{0x8CAE,0x9375},
{0x8CAF,0x967A},
{0x8CB0,0x9855},
{0x8CB1,0x9A13},
{0x8CB2,0x9E78},
{0x8CB3,0x5143},
{0x8CB4,0x539F},
{0x8CB5,0x53B3},
{0x8CB6,0x5E7B},
{0x8CB7,0x5F26},
{0x8CB8,0x6E1B},
{0x8CB9,0x6E90},
{0x8CBA,0x7384},
{0x8CBB,0x73FE},
{0x8CBC,0x7D43},
{0x8CBD,0x8237},
{0x8CBE,0x8A00},
{0x8CBF,0x8AFA},
{0x8CC0,0x9650},
{0x8CC1,0x4E4E},
{0x8CC2,0x500B},
{0x8CC3,0x53E4},
{0x8CC4,0x547C},
{0x8CC5,0x56FA},
{0x8CC6,0x59D1},
{0x8CC7,0x5B64},
{0x8CC8,0x5DF1},
{0x8CC9,0x5EAB},
{0x8CCA,0x5F27},
{0x8CCB,0x6238},
{0x8CCC,0x6545},
{0x8CCD,0x67AF},
{0x8CCE,0x6E56},
{0x8CCF,0x72D0},
{0x8CD0,0x7CCA},
{0x8CD1,0x88B4},
{0x8CD2,0x80A1},
{0x8CD3,0x80E1},
{0x8CD4,0x83F0},
{0x8CD5,0x864E},
{0x8CD6,0x8A87},
{0x8CD7,0x8DE8},
{0x8CD8,0x9237},
{0x8CD9,0x96C7},
{0x8CDA,0x9867},
{0x8CDB,0x9F13},
{0x8CDC,0x4E94},
{0x8CDD,0x4E92},
{0x8CDE,0x4F0D},
{0x8CDF,0x5348},
{0x8CE0,0x5449},
{0x8CE1,0x543E},
{0x8CE2,0x5A2F},
{0x8CE3,0x5F8C},
{0x8CE4,0x5FA1},
{0x8CE5,0x609F},
{0x8CE6,0x68A7},
{0x8CE7,0x6A8E},
{0x8CE8,0x745A},
{0x8CE9,0x7881},
{0x8CEA,0x8A9E},
{0x8CEB,0x8AA4},
{0x8CEC,0x8B77},
{0x8CED,0x9190},
{0x8CEE,0x4E5E},
{0x8CEF,0x9BC9},
{0x8CF0,0x4EA4},
{0x8CF1,0x4F7C},
{0x8CF2,0x4FAF},
{0x8CF3,0x5019},
{0x8CF4,0x5016},
{0x8CF5,0x5149},
{0x8CF6,0x516C},
{0x8CF7,0x529F},
{0x8CF8,0x52B9},
{0x8CF9,0x52FE},
{0x8CFA,0x539A},
{0x8CFB,0x53E3},
{0x8CFC,0x5411},
{0x8D40,0x540E},
{0x8D41,0x5589},
{0x8D42,0x5751},
{0x8D43,0x57A2},
{0x8D44,0x597D},
{0x8D45,0x5B54},
{0x8D46,0x5B5D},
{0x8D47,0x5B8F},
{0x8D48,0x5DE5},
{0x8D49,0x5DE7},
{0x8D4A,0x5DF7},
{0x8D4B,0x5E78},
{0x8D4C,0x5E83},
{0x8D4D,0x5E9A},
{0x8D4E,0x5EB7},
{0x8D4F,0x5F18},
{0x8D50,0x6052},
{0x8D51,0x614C},
{0x8D52,0x6297},
{0x8D53,0x62D8},
{0x8D54,0x63A7},
{0x8D55,0x653B},
{0x8D56,0x6602},
{0x8D57,0x6643},
{0x8D58,0x66F4},
{0x8D59,0x676D},
{0x8D5A,0x6821},
{0x8D5B,0x6897},
{0x8D5C,0x69CB},
{0x8D5D,0x6C5F},
{0x8D5E,0x6D2A},
{0x8D5F,0x6D69},
{0x8D60,0x6E2F},
{0x8D61,0x6E9D},
{0x8D62,0x7532},
{0x8D63,0x7687},
{0x8D64,0x786C},
{0x8D65,0x7A3F},
{0x8D66,0x7CE0},
{0x8D67,0x7D05},
{0x8D68,0x7D18},
{0x8D69,0x7D5E},
{0x8D6A,0x7DB1},
{0x8D6B,0x8015},
{0x8D6C,0x8003},
{0x8D6D,0x80AF},
{0x8D6E,0x80B1},
{0x8D6F,0x8154},
{0x8D70,0x818F},
{0x8D71,0x822A},
{0x8D72,0x8352},
{0x8D73,0x884C},
{0x8D74,0x8861},
{0x8D75,0x8B1B},
{0x8D76,0x8CA2},
{0x8D77,0x8CFC},
{0x8D78,0x90CA},
{0x8D79,0x9175},
{0x8D7A,0x9271},
{0x8D7B,0x783F},
{0x8D7C,0x92FC},
{0x8D7D,0x95A4},
{0x8D7E,0x964D},
{0x8D80,0x9805},
{0x8D81,0x9999},
{0x8D82,0x9AD8},
{0x8D83,0x9D3B},
{0x8D84,0x525B},
{0x8D85,0x52AB},
{0x8D86,0x53F7},
{0x8D87,0x5408},
{0x8D88,0x58D5},
{0x8D89,0x62F7},
{0x8D8A,0x6FE0},
{0x8D8B,0x8C6A},
{0x8D8C,0x8F5F},
{0x8D8D,0x9EB9},
{0x8D8E,0x514B},
{0x8D8F,0x523B},
{0x8D90,0x544A},
{0x8D91,0x56FD},
{0x8D92,0x7A40},
{0x8D93,0x9177},
{0x8D94,0x9D60},
{0x8D95,0x9ED2},
{0x8D96,0x7344},
{0x8D97,0x6F09},
{0x8D98,0x8170},
{0x8D99,0x7511},
{0x8D9A,0x5FFD},
{0x8D9B,0x60DA},
{0x8D9C,0x9AA8},
{0x8D9D,0x72DB},
{0x8D9E,0x8FBC},
{0x8D9F,0x6B64},
{0x8DA0,0x9803},
{0x8DA1,0x4ECA},
{0x8DA2,0x56F0},
{0x8DA3,0x5764},
{0x8DA4,0x58BE},
{0x8DA5,0x5A5A},
{0x8DA6,0x6068},
{0x8DA7,0x61C7},
{0x8DA8,0x660F},
{0x8DA9,0x6606},
{0x8DAA,0x6839},
{0x8DAB,0x68B1},
{0x8DAC,0x6DF7},
{0x8DAD,0x75D5},
{0x8DAE,0x7D3A},
{0x8DAF,0x826E},
{0x8DB0,0x9B42},
{0x8DB1,0x4E9B},
{0x8DB2,0x4F50},
{0x8DB3,0x53C9},
{0x8DB4,0x5506},
{0x8DB5,0x5D6F},
{0x8DB6,0x5DE6},
{0x8DB7,0x5DEE},
{0x8DB8,0x67FB},
{0x8DB9,0x6C99},
{0x8DBA,0x7473},
{0x8DBB,0x7802},
{0x8DBC,0x8A50},
{0x8DBD,0x9396},
{0x8DBE,0x88DF},
{0x8DBF,0x5750},
{0x8DC0,0x5EA7},
{0x8DC1,0x632B},
{0x8DC2,0x50B5},
{0x8DC3,0x50AC},
{0x8DC4,0x518D},
{0x8DC5,0x6700},
{0x8DC6,0x54C9},
{0x8DC7,0x585E},
{0x8DC8,0x59BB},
{0x8DC9,0x5BB0},
{0x8DCA,0x5F69},
{0x8DCB,0x624D},
{0x8DCC,0x63A1},
{0x8DCD,0x683D},
{0x8DCE,0x6B73},
{0x8DCF,0x6E08},
{0x8DD0,0x707D},
{0x8DD1,0x91C7},
{0x8DD2,0x7280},
{0x8DD3,0x7815},
{0x8DD4,0x7826},
{0x8DD5,0x796D},
{0x8DD6,0x658E},
{0x8DD7,0x7D30},
{0x8DD8,0x83DC},
{0x8DD9,0x88C1},
{0x8DDA,0x8F09},
{0x8DDB,0x969B},
{0x8DDC,0x5264},
{0x8DDD,0x5728},
{0x8DDE,0x6750},
{0x8DDF,0x7F6A},
{0x8DE0,0x8CA1},
{0x8DE1,0x51B4},
{0x8DE2,0x5742},
{0x8DE3,0x962A},
{0x8DE4,0x583A},
{0x8DE5,0x698A},
{0x8DE6,0x80B4},
{0x8DE7,0x54B2},
{0x8DE8,0x5D0E},
{0x8DE9,0x57FC},
{0x8DEA,0x7895},
{0x8DEB,0x9DFA},
{0x8DEC,0x4F5C},
{0x8DED,0x524A},
{0x8DEE,0x548B},
{0x8DEF,0x643E},
{0x8DF0,0x6628},
{0x8DF1,0x6714},
{0x8DF2,0x67F5},
{0x8DF3,0x7A84},
{0x8DF4,0x7B56},
{0x8DF5,0x7D22},
{0x8DF6,0x932F},
{0x8DF7,0x685C},
{0x8DF8,0x9BAD},
{0x8DF9,0x7B39},
{0x8DFA,0x5319},
{0x8DFB,0x518A},
{0x8DFC,0x5237},
{0x8E40,0x5BDF},
{0x8E41,0x62F6},
{0x8E42,0x64AE},
{0x8E43,0x64E6},
{0x8E44,0x672D},
{0x8E45,0x6BBA},
{0x8E46,0x85A9},
{0x8E47,0x96D1},
{0x8E48,0x7690},
{0x8E49,0x9BD6},
{0x8E4A,0x634C},
{0x8E4B,0x9306},
{0x8E4C,0x9BAB},
{0x8E4D,0x76BF},
{0x8E4E,0x6652},
{0x8E4F,0x4E09},
{0x8E50,0x5098},
{0x8E51,0x53C2},
{0x8E52,0x5C71},
{0x8E53,0x60E8},
{0x8E54,0x6492},
{0x8E55,0x6563},
{0x8E56,0x685F},
{0x8E57,0x71E6},
{0x8E58,0x73CA},
{0x8E59,0x7523},
{0x8E5A,0x7B97},
{0x8E5B,0x7E82},
{0x8E5C,0x8695},
{0x8E5D,0x8B83},
{0x8E5E,0x8CDB},
{0x8E5F,0x9178},
{0x8E60,0x9910},
{0x8E61,0x65AC},
{0x8E62,0x66AB},
{0x8E63,0x6B8B},
{0x8E64,0x4ED5},
{0x8E65,0x4ED4},
{0x8E66,0x4F3A},
{0x8E67,0x4F7F},
{0x8E68,0x523A},
{0x8E69,0x53F8},
{0x8E6A,0x53F2},
{0x8E6B,0x55E3},
{0x8E6C,0x56DB},
{0x8E6D,0x58EB},
{0x8E6E,0x59CB},
{0x8E6F,0x59C9},
{0x8E70,0x59FF},
{0x8E71,0x5B50},
{0x8E72,0x5C4D},
{0x8E73,0x5E02},
{0x8E74,0x5E2B},
{0x8E75,0x5FD7},
{0x8E76,0x601D},
{0x8E77,0x6307},
{0x8E78,0x652F},
{0x8E79,0x5B5C},
{0x8E7A,0x65AF},
{0x8E7B,0x65BD},
{0x8E7C,0x65E8},
{0x8E7D,0x679D},
{0x8E7E,0x6B62},
{0x8E80,0x6B7B},
{0x8E81,0x6C0F},
{0x8E82,0x7345},
{0x8E83,0x7949},
{0x8E84,0x79C1},
{0x8E85,0x7CF8},
{0x8E86,0x7D19},
{0x8E87,0x7D2B},
{0x8E88,0x80A2},
{0x8E89,0x8102},
{0x8E8A,0x81F3},
{0x8E8B,0x8996},
{0x8E8C,0x8A5E},
{0x8E8D,0x8A69},
{0x8E8E,0x8A66},
{0x8E8F,0x8A8C},
{0x8E90,0x8AEE},
{0x8E91,0x8CC7},
{0x8E92,0x8CDC},
{0x8E93,0x96CC},
{0x8E94,0x98FC},
{0x8E95,0x6B6F},
{0x8E96,0x4E8B},
{0x8E97,0x4F3C},
{0x8E98,0x4F8D},
{0x8E99,0x5150},
{0x8E9A,0x5B57},
{0x8E9B,0x5BFA},
{0x8E9C,0x6148},
{0x8E9D,0x6301},
{0x8E9E,0x6642},
{0x8E9F,0x6B21},
{0x8EA0,0x6ECB},
{0x8EA1,0x6CBB},
{0x8EA2,0x723E},
{0x8EA3,0x74BD},
{0x8EA4,0x75D4},
{0x8EA5,0x78C1},
{0x8EA6,0x793A},
{0x8EA7,0x800C},
{0x8EA8,0x8033},
{0x8EA9,0x81EA},
{0x8EAA,0x8494},
{0x8EAB,0x8F9E},
{0x8EAC,0x6C50},
{0x8EAD,0x9E7F},
{0x8EAE,0x5F0F},
{0x8EAF,0x8B58},
{0x8EB0,0x9D2B},
{0x8EB1,0x7AFA},
{0x8EB2,0x8EF8},
{0x8EB3,0x5B8D},
{0x8EB4,0x96EB},
{0x8EB5,0x4E03},
{0x8EB6,0x53F1},
{0x8EB7,0x57F7},
{0x8EB8,0x5931},
{0x8EB9,0x5AC9},
{0x8EBA,0x5BA4},
{0x8EBB,0x6089},
{0x8EBC,0x6E7F},
{0x8EBD,0x6F06},
{0x8EBE,0x75BE},
{0x8EBF,0x8CEA},
{0x8EC0,0x5B9F},
{0x8EC1,0x8500},
{0x8EC2,0x7BE0},
{0x8EC3,0x5072},
{0x8EC4,0x67F4},
{0x8EC5,0x829D},
{0x8EC6,0x5C61},
{0x8EC7,0x854A},
{0x8EC8,0x7E1E},
{0x8EC9,0x820E},
{0x8ECA,0x5199},
{0x8ECB,0x5C04},
{0x8ECC,0x6368},
{0x8ECD,0x8D66},
{0x8ECE,0x659C},
{0x8ECF,0x716E},
{0x8ED0,0x793E},
{0x8ED1,0x7D17},
{0x8ED2,0x8005},
{0x8ED3,0x8B1D},
{0x8ED4,0x8ECA},
{0x8ED5,0x906E},
{0x8ED6,0x86C7},
{0x8ED7,0x90AA},
{0x8ED8,0x501F},
{0x8ED9,0x52FA},
{0x8EDA,0x5C3A},
{0x8EDB,0x6753},
{0x8EDC,0x707C},
{0x8EDD,0x7235},
{0x8EDE,0x914C},
{0x8EDF,0x91C8},
{0x8EE0,0x932B},
{0x8EE1,0x82E5},
{0x8EE2,0x5BC2},
{0x8EE3,0x5F31},
{0x8EE4,0x60F9},
{0x8EE5,0x4E3B},
{0x8EE6,0x53D6},
{0x8EE7,0x5B88},
{0x8EE8,0x624B},
{0x8EE9,0x6731},
{0x8EEA,0x6B8A},
{0x8EEB,0x72E9},
{0x8EEC,0x73E0},
{0x8EED,0x7A2E},
{0x8EEE,0x816B},
{0x8EEF,0x8DA3},
{0x8EF0,0x9152},
{0x8EF1,0x9996},
{0x8EF2,0x5112},
{0x8EF3,0x53D7},
{0x8EF4,0x546A},
{0x8EF5,0x5BFF},
{0x8EF6,0x6388},
{0x8EF7,0x6A39},
{0x8EF8,0x7DAC},
{0x8EF9,0x9700},
{0x8EFA,0x56DA},
{0x8EFB,0x53CE},
{0x8EFC,0x5468},
{0x8F40,0x5B97},
{0x8F41,0x5C31},
{0x8F42,0x5DDE},
{0x8F43,0x4FEE},
{0x8F44,0x6101},
{0x8F45,0x62FE},
{0x8F46,0x6D32},
{0x8F47,0x79C0},
{0x8F48,0x79CB},
{0x8F49,0x7D42},
{0x8F4A,0x7E4D},
{0x8F4B,0x7FD2},
{0x8F4C,0x81ED},
{0x8F4D,0x821F},
{0x8F4E,0x8490},
{0x8F4F,0x8846},
{0x8F50,0x8972},
{0x8F51,0x8B90},
{0x8F52,0x8E74},
{0x8F53,0x8F2F},
{0x8F54,0x9031},
{0x8F55,0x914B},
{0x8F56,0x916C},
{0x8F57,0x96C6},
{0x8F58,0x919C},
{0x8F59,0x4EC0},
{0x8F5A,0x4F4F},
{0x8F5B,0x5145},
{0x8F5C,0x5341},
{0x8F5D,0x5F93},
{0x8F5E,0x620E},
{0x8F5F,0x67D4},
{0x8F60,0x6C41},
{0x8F61,0x6E0B},
{0x8F62,0x7363},
{0x8F63,0x7E26},
{0x8F64,0x91CD},
{0x8F65,0x9283},
{0x8F66,0x53D4},
{0x8F67,0x5919},
{0x8F68,0x5BBF},
{0x8F69,0x6DD1},
{0x8F6A,0x795D},
{0x8F6B,0x7E2E},
{0x8F6C,0x7C9B},
{0x8F6D,0x587E},
{0x8F6E,0x719F},
{0x8F6F,0x51FA},
{0x8F70,0x8853},
{0x8F71,0x8FF0},
{0x8F72,0x4FCA},
{0x8F73,0x5CFB},
{0x8F74,0x6625},
{0x8F75,0x77AC},
{0x8F76,0x7AE3},
{0x8F77,0x821C},
{0x8F78,0x99FF},
{0x8F79,0x51C6},
{0x8F7A,0x5FAA},
{0x8F7B,0x65EC},
{0x8F7C,0x696F},
{0x8F7D,0x6B89},
{0x8F7E,0x6DF3},
{0x8F80,0x6E96},
{0x8F81,0x6F64},
{0x8F82,0x76FE},
{0x8F83,0x7D14},
{0x8F84,0x5DE1},
{0x8F85,0x9075},
{0x8F86,0x9187},
{0x8F87,0x9806},
{0x8F88,0x51E6},
{0x8F89,0x521D},
{0x8F8A,0x6240},
{0x8F8B,0x6691},
{0x8F8C,0x66D9},
{0x8F8D,0x6E1A},
{0x8F8E,0x5EB6},
{0x8F8F,0x7DD2},
{0x8F90,0x7F72},
{0x8F91,0x66F8},
{0x8F92,0x85AF},
{0x8F93,0x85F7},
{0x8F94,0x8AF8},
{0x8F95,0x52A9},
{0x8F96,0x53D9},
{0x8F97,0x5973},
{0x8F98,0x5E8F},
{0x8F99,0x5F90},
{0x8F9A,0x6055},
{0x8F9B,0x92E4},
{0x8F9C,0x9664},
{0x8F9D,0x50B7},
{0x8F9E,0x511F},
{0x8F9F,0x52DD},
{0x8FA0,0x5320},
{0x8FA1,0x5347},
{0x8FA2,0x53EC},
{0x8FA3,0x54E8},
{0x8FA4,0x5546},
{0x8FA5,0x5531},
{0x8FA6,0x5617},
{0x8FA7,0x5968},
{0x8FA8,0x59BE},
{0x8FA9,0x5A3C},
{0x8FAA,0x5BB5},
{0x8FAB,0x5C06},
{0x8FAC,0x5C0F},
{0x8FAD,0x5C11},
{0x8FAE,0x5C1A},
{0x8FAF,0x5E84},
{0x8FB0,0x5E8A},
{0x8FB1,0x5EE0},
{0x8FB2,0x5F70},
{0x8FB3,0x627F},
{0x8FB4,0x6284},
{0x8FB5,0x62DB},
{0x8FB6,0x638C},
{0x8FB7,0x6377},
{0x8FB8,0x6607},
{0x8FB9,0x660C},
{0x8FBA,0x662D},
{0x8FBB,0x6676},
{0x8FBC,0x677E},
{0x8FBD,0x68A2},
{0x8FBE,0x6A1F},
{0x8FBF,0x6A35},
{0x8FC0,0x6CBC},
{0x8FC1,0x6D88},
{0x8FC2,0x6E09},
{0x8FC3,0x6E58},
{0x8FC4,0x713C},
{0x8FC5,0x7126},
{0x8FC6,0x7167},
{0x8FC7,0x75C7},
{0x8FC8,0x7701},
{0x8FC9,0x785D},
{0x8FCA,0x7901},
{0x8FCB,0x7965},
{0x8FCC,0x79F0},
{0x8FCD,0x7AE0},
{0x8FCE,0x7B11},
{0x8FCF,0x7CA7},
{0x8FD0,0x7D39},
{0x8FD1,0x8096},
{0x8FD2,0x83D6},
{0x8FD3,0x848B},
{0x8FD4,0x8549},
{0x8FD5,0x885D},
{0x8FD6,0x88F3},
{0x8FD7,0x8A1F},
{0x8FD8,0x8A3C},
{0x8FD9,0x8A54},
{0x8FDA,0x8A73},
{0x8FDB,0x8C61},
{0x8FDC,0x8CDE},
{0x8FDD,0x91A4},
{0x8FDE,0x9266},
{0x8FDF,0x937E},
{0x8FE0,0x9418},
{0x8FE1,0x969C},
{0x8FE2,0x9798},
{0x8FE3,0x4E0A},
{0x8FE4,0x4E08},
{0x8FE5,0x4E1E},
{0x8FE6,0x4E57},
{0x8FE7,0x5197},
{0x8FE8,0x5270},
{0x8FE9,0x57CE},
{0x8FEA,0x5834},
{0x8FEB,0x58CC},
{0x8FEC,0x5B22},
{0x8FED,0x5E38},
{0x8FEE,0x60C5},
{0x8FEF,0x64FE},
{0x8FF0,0x6761},
{0x8FF1,0x6756},
{0x8FF2,0x6D44},
{0x8FF3,0x72B6},
{0x8FF4,0x7573},
{0x8FF5,0x7A63},
{0x8FF6,0x84B8},
{0x8FF7,0x8B72},
{0x8FF8,0x91B8},
{0x8FF9,0x9320},
{0x8FFA,0x5631},
{0x8FFB,0x57F4},
{0x8FFC,0x98FE},
{0x9040,0x62ED},
{0x9041,0x690D},
{0x9042,0x6B96},
{0x9043,0x71ED},
{0x9044,0x7E54},
{0x9045,0x8077},
{0x9046,0x8272},
{0x9047,0x89E6},
{0x9048,0x98DF},
{0x9049,0x8755},
{0x904A,0x8FB1},
{0x904B,0x5C3B},
{0x904C,0x4F38},
{0x904D,0x4FE1},
{0x904E,0x4FB5},
{0x904F,0x5507},
{0x9050,0x5A20},
{0x9051,0x5BDD},
{0x9052,0x5BE9},
{0x9053,0x5FC3},
{0x9054,0x614E},
{0x9055,0x632F},
{0x9056,0x65B0},
{0x9057,0x664B},
{0x9058,0x68EE},
{0x9059,0x699B},
{0x905A,0x6D78},
{0x905B,0x6DF1},
{0x905C,0x7533},
{0x905D,0x75B9},
{0x905E,0x771F},
{0x905F,0x795E},
{0x9060,0x79E6},
{0x9061,0x7D33},
{0x9062,0x81E3},
{0x9063,0x82AF},
{0x9064,0x85AA},
{0x9065,0x89AA},
{0x9066,0x8A3A},
{0x9067,0x8EAB},
{0x9068,0x8F9B},
{0x9069,0x9032},
{0x906A,0x91DD},
{0x906B,0x9707},
{0x906C,0x4EBA},
{0x906D,0x4EC1},
{0x906E,0x5203},
{0x906F,0x5875},
{0x9070,0x58EC},
{0x9071,0x5C0B},
{0x9072,0x751A},
{0x9073,0x5C3D},
{0x9074,0x814E},
{0x9075,0x8A0A},
{0x9076,0x8FC5},
{0x9077,0x9663},
{0x9078,0x976D},
{0x9079,0x7B25},
{0x907A,0x8ACF},
{0x907B,0x9808},
{0x907C,0x9162},
{0x907D,0x56F3},
{0x907E,0x53A8},
{0x9080,0x9017},
{0x9081,0x5439},
{0x9082,0x5782},
{0x9083,0x5E25},
{0x9084,0x63A8},
{0x9085,0x6C34},
{0x9086,0x708A},
{0x9087,0x7761},
{0x9088,0x7C8B},
{0x9089,0x7FE0},
{0x908A,0x8870},
{0x908B,0x9042},
{0x908C,0x9154},
{0x908D,0x9310},
{0x908E,0x9318},
{0x908F,0x968F},
{0x9090,0x745E},
{0x9091,0x9AC4},
{0x9092,0x5D07},
{0x9093,0x5D69},
{0x9094,0x6570},
{0x9095,0x67A2},
{0x9096,0x8DA8},
{0x9097,0x96DB},
{0x9098,0x636E},
{0x9099,0x6749},
{0x909A,0x6919},
{0x909B,0x83C5},
{0x909C,0x9817},
{0x909D,0x96C0},
{0x909E,0x88FE},
{0x909F,0x6F84},
{0x90A0,0x647A},
{0x90A1,0x5BF8},
{0x90A2,0x4E16},
{0x90A3,0x702C},
{0x90A4,0x755D},
{0x90A5,0x662F},
{0x90A6,0x51C4},
{0x90A7,0x5236},
{0x90A8,0x52E2},
{0x90A9,0x59D3},
{0x90AA,0x5F81},
{0x90AB,0x6027},
{0x90AC,0x6210},
{0x90AD,0x653F},
{0x90AE,0x6574},
{0x90AF,0x661F},
{0x90B0,0x6674},
{0x90B1,0x68F2},
{0x90B2,0x6816},
{0x90B3,0x6B63},
{0x90B4,0x6E05},
{0x90B5,0x7272},
{0x90B6,0x751F},
{0x90B7,0x76DB},
{0x90B8,0x7CBE},
{0x90B9,0x8056},
{0x90BA,0x58F0},
{0x90BB,0x88FD},
{0x90BC,0x897F},
{0x90BD,0x8AA0},
{0x90BE,0x8A93},
{0x90BF,0x8ACB},
{0x90C0,0x901D},
{0x90C1,0x9192},
{0x90C2,0x9752},
{0x90C3,0x9759},
{0x90C4,0x6589},
{0x90C5,0x7A0E},
{0x90C6,0x8106},
{0x90C7,0x96BB},
{0x90C8,0x5E2D},
{0x90C9,0x60DC},
{0x90CA,0x621A},
{0x90CB,0x65A5},
{0x90CC,0x6614},
{0x90CD,0x6790},
{0x90CE,0x77F3},
{0x90CF,0x7A4D},
{0x90D0,0x7C4D},
{0x90D1,0x7E3E},
{0x90D2,0x810A},
{0x90D3,0x8CAC},
{0x90D4,0x8D64},
{0x90D5,0x8DE1},
{0x90D6,0x8E5F},
{0x90D7,0x78A9},
{0x90D8,0x5207},
{0x90D9,0x62D9},
{0x90DA,0x63A5},
{0x90DB,0x6442},
{0x90DC,0x6298},
{0x90DD,0x8A2D},
{0x90DE,0x7A83},
{0x90DF,0x7BC0},
{0x90E0,0x8AAC},
{0x90E1,0x96EA},
{0x90E2,0x7D76},
{0x90E3,0x820C},
{0x90E4,0x8749},
{0x90E5,0x4ED9},
{0x90E6,0x5148},
{0x90E7,0x5343},
{0x90E8,0x5360},
{0x90E9,0x5BA3},
{0x90EA,0x5C02},
{0x90EB,0x5C16},
{0x90EC,0x5DDD},
{0x90ED,0x6226},
{0x90EE,0x6247},
{0x90EF,0x64B0},
{0x90F0,0x6813},
{0x90F1,0x6834},
{0x90F2,0x6CC9},
{0x90F3,0x6D45},
{0x90F4,0x6D17},
{0x90F5,0x67D3},
{0x90F6,0x6F5C},
{0x90F7,0x714E},
{0x90F8,0x717D},
{0x90F9,0x65CB},
{0x90FA,0x7A7F},
{0x90FB,0x7BAD},
{0x90FC,0x7DDA},
{0x9140,0x7E4A},
{0x9141,0x7FA8},
{0x9142,0x817A},
{0x9143,0x821B},
{0x9144,0x8239},
{0x9145,0x85A6},
{0x9146,0x8A6E},
{0x9147,0x8CCE},
{0x9148,0x8DF5},
{0x9149,0x9078},
{0x914A,0x9077},
{0x914B,0x92AD},
{0x914C,0x9291},
{0x914D,0x9583},
{0x914E,0x9BAE},
{0x914F,0x524D},
{0x9150,0x5584},
{0x9151,0x6F38},
{0x9152,0x7136},
{0x9153,0x5168},
{0x9154,0x7985},
{0x9155,0x7E55},
{0x9156,0x81B3},
{0x9157,0x7CCE},
{0x9158,0x564C},
{0x9159,0x5851},
{0x915A,0x5CA8},
{0x915B,0x63AA},
{0x915C,0x66FE},
{0x915D,0x66FD},
{0x915E,0x695A},
{0x915F,0x72D9},
{0x9160,0x758F},
{0x9161,0x758E},
{0x9162,0x790E},
{0x9163,0x7956},
{0x9164,0x79DF},
{0x9165,0x7C97},
{0x9166,0x7D20},
{0x9167,0x7D44},
{0x9168,0x8607},
{0x9169,0x8A34},
{0x916A,0x963B},
{0x916B,0x9061},
{0x916C,0x9F20},
{0x916D,0x50E7},
{0x916E,0x5275},
{0x916F,0x53CC},
{0x9170,0x53E2},
{0x9171,0x5009},
{0x9172,0x55AA},
{0x9173,0x58EE},
{0x9174,0x594F},
{0x9175,0x723D},
{0x9176,0x5B8B},
{0x9177,0x5C64},
{0x9178,0x531D},
{0x9179,0x60E3},
{0x917A,0x60F3},
{0x917B,0x635C},
{0x917C,0x6383},
{0x917D,0x633F},
{0x917E,0x63BB},
{0x9180,0x64CD},
{0x9181,0x65E9},
{0x9182,0x66F9},
{0x9183,0x5DE3},
{0x9184,0x69CD},
{0x9185,0x69FD},
{0x9186,0x6F15},
{0x9187,0x71E5},
{0x9188,0x4E89},
{0x9189,0x75E9},
{0x918A,0x76F8},
{0x918B,0x7A93},
{0x918C,0x7CDF},
{0x918D,0x7DCF},
{0x918E,0x7D9C},
{0x918F,0x8061},
{0x9190,0x8349},
{0x9191,0x8358},
{0x9192,0x846C},
{0x9193,0x84BC},
{0x9194,0x85FB},
{0x9195,0x88C5},
{0x9196,0x8D70},
{0x9197,0x9001},
{0x9198,0x906D},
{0x9199,0x9397},
{0x919A,0x971C},
{0x919B,0x9A12},
{0x919C,0x50CF},
{0x919D,0x5897},
{0x919E,0x618E},
{0x919F,0x81D3},
{0x91A0,0x8535},
{0x91A1,0x8D08},
{0x91A2,0x9020},
{0x91A3,0x4FC3},
{0x91A4,0x5074},
{0x91A5,0x5247},
{0x91A6,0x5373},
{0x91A7,0x606F},
{0x91A8,0x6349},
{0x91A9,0x675F},
{0x91AA,0x6E2C},
{0x91AB,0x8DB3},
{0x91AC,0x901F},
{0x91AD,0x4FD7},
{0x91AE,0x5C5E},
{0x91AF,0x8CCA},
{0x91B0,0x65CF},
{0x91B1,0x7D9A},
{0x91B2,0x5352},
{0x91B3,0x8896},
{0x91B4,0x5176},
{0x91B5,0x63C3},
{0x91B6,0x5B58},
{0x91B7,0x5B6B},
{0x91B8,0x5C0A},
{0x91B9,0x640D},
{0x91BA,0x6751},
{0x91BB,0x905C},
{0x91BC,0x4ED6},
{0x91BD,0x591A},
{0x91BE,0x592A},
{0x91BF,0x6C70},
{0x91C0,0x8A51},
{0x91C1,0x553E},
{0x91C2,0x5815},
{0x91C3,0x59A5},
{0x91C4,0x60F0},
{0x91C5,0x6253},
{0x91C6,0x67C1},
{0x91C7,0x8235},
{0x91C8,0x6955},
{0x91C9,0x9640},
{0x91CA,0x99C4},
{0x91CB,0x9A28},
{0x91CC,0x4F53},
{0x91CD,0x5806},
{0x91CE,0x5BFE},
{0x91CF,0x8010},
{0x91D0,0x5CB1},
{0x91D1,0x5E2F},
{0x91D2,0x5F85},
{0x91D3,0x6020},
{0x91D4,0x614B},
{0x91D5,0x6234},
{0x91D6,0x66FF},
{0x91D7,0x6CF0},
{0x91D8,0x6EDE},
{0x91D9,0x80CE},
{0x91DA,0x817F},
{0x91DB,0x82D4},
{0x91DC,0x888B},
{0x91DD,0x8CB8},
{0x91DE,0x9000},
{0x91DF,0x902E},
{0x91E0,0x968A},
{0x91E1,0x9EDB},
{0x91E2,0x9BDB},
{0x91E3,0x4EE3},
{0x91E4,0x53F0},
{0x91E5,0x5927},
{0x91E6,0x7B2C},
{0x91E7,0x918D},
{0x91E8,0x984C},
{0x91E9,0x9DF9},
{0x91EA,0x6EDD},
{0x91EB,0x7027},
{0x91EC,0x5353},
{0x91ED,0x5544},
{0x91EE,0x5B85},
{0x91EF,0x6258},
{0x91F0,0x629E},
{0x91F1,0x62D3},
{0x91F2,0x6CA2},
{0x91F3,0x6FEF},
{0x91F4,0x7422},
{0x91F5,0x8A17},
{0x91F6,0x9438},
{0x91F7,0x6FC1},
{0x91F8,0x8AFE},
{0x91F9,0x8338},
{0x91FA,0x51E7},
{0x91FB,0x86F8},
{0x91FC,0x53EA},
{0x9240,0x53E9},
{0x9241,0x4F46},
{0x9242,0x9054},
{0x9243,0x8FB0},
{0x9244,0x596A},
{0x9245,0x8131},
{0x9246,0x5DFD},
{0x9247,0x7AEA},
{0x9248,0x8FBF},
{0x9249,0x68DA},
{0x924A,0x8C37},
{0x924B,0x72F8},
{0x924C,0x9C48},
{0x924D,0x6A3D},
{0x924E,0x8AB0},
{0x924F,0x4E39},
{0x9250,0x5358},
{0x9251,0x5606},
{0x9252,0x5766},
{0x9253,0x62C5},
{0x9254,0x63A2},
{0x9255,0x65E6},
{0x9256,0x6B4E},
{0x9257,0x6DE1},
{0x9258,0x6E5B},
{0x9259,0x70AD},
{0x925A,0x77ED},
{0x925B,0x7AEF},
{0x925C,0x7BAA},
{0x925D,0x7DBB},
{0x925E,0x803D},
{0x925F,0x80C6},
{0x9260,0x86CB},
{0x9261,0x8A95},
{0x9262,0x935B},
{0x9263,0x56E3},
{0x9264,0x58C7},
{0x9265,0x5F3E},
{0x9266,0x65AD},
{0x9267,0x6696},
{0x9268,0x6A80},
{0x9269,0x6BB5},
{0x926A,0x7537},
{0x926B,0x8AC7},
{0x926C,0x5024},
{0x926D,0x77E5},
{0x926E,0x5730},
{0x926F,0x5F1B},
{0x9270,0x6065},
{0x9271,0x667A},
{0x9272,0x6C60},
{0x9273,0x75F4},
{0x9274,0x7A1A},
{0x9275,0x7F6E},
{0x9276,0x81F4},
{0x9277,0x8718},
{0x9278,0x9045},
{0x9279,0x99B3},
{0x927A,0x7BC9},
{0x927B,0x755C},
{0x927C,0x7AF9},
{0x927D,0x7B51},
{0x927E,0x84C4},
{0x9280,0x9010},
{0x9281,0x79E9},
{0x9282,0x7A92},
{0x9283,0x8336},
{0x9284,0x5AE1},
{0x9285,0x7740},
{0x9286,0x4E2D},
{0x9287,0x4EF2},
{0x9288,0x5B99},
{0x9289,0x5FE0},
{0x928A,0x62BD},
{0x928B,0x663C},
{0x928C,0x67F1},
{0x928D,0x6CE8},
{0x928E,0x866B},
{0x928F,0x8877},
{0x9290,0x8A3B},
{0x9291,0x914E},
{0x9292,0x92F3},
{0x9293,0x99D0},
{0x9294,0x6A17},
{0x9295,0x7026},
{0x9296,0x732A},
{0x9297,0x82E7},
{0x9298,0x8457},
{0x9299,0x8CAF},
{0x929A,0x4E01},
{0x929B,0x5146},
{0x929C,0x51CB},
{0x929D,0x558B},
{0x929E,0x5BF5},
{0x929F,0x5E16},
{0x92A0,0x5E33},
{0x92A1,0x5E81},
{0x92A2,0x5F14},
{0x92A3,0x5F35},
{0x92A4,0x5F6B},
{0x92A5,0x5FB4},
{0x92A6,0x61F2},
{0x92A7,0x6311},
{0x92A8,0x66A2},
{0x92A9,0x671D},
{0x92AA,0x6F6E},
{0x92AB,0x7252},
{0x92AC,0x753A},
{0x92AD,0x773A},
{0x92AE,0x8074},
{0x92AF,0x8139},
{0x92B0,0x8178},
{0x92B1,0x8776},
{0x92B2,0x8ABF},
{0x92B3,0x8ADC},
{0x92B4,0x8D85},
{0x92B5,0x8DF3},
{0x92B6,0x929A},
{0x92B7,0x9577},
{0x92B8,0x9802},
{0x92B9,0x9CE5},
{0x92BA,0x52C5},
{0x92BB,0x6357},
{0x92BC,0x76F4},
{0x92BD,0x6715},
{0x92BE,0x6C88},
{0x92BF,0x73CD},
{0x92C0,0x8CC3},
{0x92C1,0x93AE},
{0x92C2,0x9673},
{0x92C3,0x6D25},
{0x92C4,0x589C},
{0x92C5,0x690E},
{0x92C6,0x69CC},
{0x92C7,0x8FFD},
{0x92C8,0x939A},
{0x92C9,0x75DB},
{0x92CA,0x901A},
{0x92CB,0x585A},
{0x92CC,0x6802},
{0x92CD,0x63B4},
{0x92CE,0x69FB},
{0x92CF,0x4F43},
{0x92D0,0x6F2C},
{0x92D1,0x67D8},
{0x92D2,0x8FBB},
{0x92D3,0x8526},
{0x92D4,0x7DB4},
{0x92D5,0x9354},
{0x92D6,0x693F},
{0x92D7,0x6F70},
{0x92D8,0x576A},
{0x92D9,0x58F7},
{0x92DA,0x5B2C},
{0x92DB,0x7D2C},
{0x92DC,0x722A},
{0x92DD,0x540A},
{0x92DE,0x91E3},
{0x92DF,0x9DB4},
{0x92E0,0x4EAD},
{0x92E1,0x4F4E},
{0x92E2,0x505C},
{0x92E3,0x5075},
{0x92E4,0x5243},
{0x92E5,0x8C9E},
{0x92E6,0x5448},
{0x92E7,0x5824},
{0x92E8,0x5B9A},
{0x92E9,0x5E1D},
{0x92EA,0x5E95},
{0x92EB,0x5EAD},
{0x92EC,0x5EF7},
{0x92ED,0x5F1F},
{0x92EE,0x608C},
{0x92EF,0x62B5},
{0x92F0,0x633A},
{0x92F1,0x63D0},
{0x92F2,0x68AF},
{0x92F3,0x6C40},
{0x92F4,0x7887},
{0x92F5,0x798E},
{0x92F6,0x7A0B},
{0x92F7,0x7DE0},
{0x92F8,0x8247},
{0x92F9,0x8A02},
{0x92FA,0x8AE6},
{0x92FB,0x8E44},
{0x92FC,0x9013},
{0x9340,0x90B8},
{0x9341,0x912D},
{0x9342,0x91D8},
{0x9343,0x9F0E},
{0x9344,0x6CE5},
{0x9345,0x6458},
{0x9346,0x64E2},
{0x9347,0x6575},
{0x9348,0x6EF4},
{0x9349,0x7684},
{0x934A,0x7B1B},
{0x934B,0x9069},
{0x934C,0x93D1},
{0x934D,0x6EBA},
{0x934E,0x54F2},
{0x934F,0x5FB9},
{0x9350,0x64A4},
{0x9351,0x8F4D},
{0x9352,0x8FED},
{0x9353,0x9244},
{0x9354,0x5178},
{0x9355,0x586B},
{0x9356,0x5929},
{0x9357,0x5C55},
{0x9358,0x5E97},
{0x9359,0x6DFB},
{0x935A,0x7E8F},
{0x935B,0x751C},
{0x935C,0x8CBC},
{0x935D,0x8EE2},
{0x935E,0x985B},
{0x935F,0x70B9},
{0x9360,0x4F1D},
{0x9361,0x6BBF},
{0x9362,0x6FB1},
{0x9363,0x7530},
{0x9364,0x96FB},
{0x9365,0x514E},
{0x9366,0x5410},
{0x9367,0x5835},
{0x9368,0x5857},
{0x9369,0x59AC},
{0x936A,0x5C60},
{0x936B,0x5F92},
{0x936C,0x6597},
{0x936D,0x675C},
{0x936E,0x6E21},
{0x936F,0x767B},
{0x9370,0x83DF},
{0x9371,0x8CED},
{0x9372,0x9014},
{0x9373,0x90FD},
{0x9374,0x934D},
{0x9375,0x7825},
{0x9376,0x783A},
{0x9377,0x52AA},
{0x9378,0x5EA6},
{0x9379,0x571F},
{0x937A,0x5974},
{0x937B,0x6012},
{0x937C,0x5012},
{0x937D,0x515A},
{0x937E,0x51AC},
{0x9380,0x51CD},
{0x9381,0x5200},
{0x9382,0x5510},
{0x9383,0x5854},
{0x9384,0x5858},
{0x9385,0x5957},
{0x9386,0x5B95},
{0x9387,0x5CF6},
{0x9388,0x5D8B},
{0x9389,0x60BC},
{0x938A,0x6295},
{0x938B,0x642D},
{0x938C,0x6771},
{0x938D,0x6843},
{0x938E,0x68BC},
{0x938F,0x68DF},
{0x9390,0x76D7},
{0x9391,0x6DD8},
{0x9392,0x6E6F},
{0x9393,0x6D9B},
{0x9394,0x706F},
{0x9395,0x71C8},
{0x9396,0x5F53},
{0x9397,0x75D8},
{0x9398,0x7977},
{0x9399,0x7B49},
{0x939A,0x7B54},
{0x939B,0x7B52},
{0x939C,0x7CD6},
{0x939D,0x7D71},
{0x939E,0x5230},
{0x939F,0x8463},
{0x93A0,0x8569},
{0x93A1,0x85E4},
{0x93A2,0x8A0E},
{0x93A3,0x8B04},
{0x93A4,0x8C46},
{0x93A5,0x8E0F},
{0x93A6,0x9003},
{0x93A7,0x900F},
{0x93A8,0x9419},
{0x93A9,0x9676},
{0x93AA,0x982D},
{0x93AB,0x9A30},
{0x93AC,0x95D8},
{0x93AD,0x50CD},
{0x93AE,0x52D5},
{0x93AF,0x540C},
{0x93B0,0x5802},
{0x93B1,0x5C0E},
{0x93B2,0x61A7},
{0x93B3,0x649E},
{0x93B4,0x6D1E},
{0x93B5,0x77B3},
{0x93B6,0x7AE5},
{0x93B7,0x80F4},
{0x93B8,0x8404},
{0x93B9,0x9053},
{0x93BA,0x9285},
{0x93BB,0x5CE0},
{0x93BC,0x9D07},
{0x93BD,0x533F},
{0x93BE,0x5F97},
{0x93BF,0x5FB3},
{0x93C0,0x6D9C},
{0x93C1,0x7279},
{0x93C2,0x7763},
{0x93C3,0x79BF},
{0x93C4,0x7BE4},
{0x93C5,0x6BD2},
{0x93C6,0x72EC},
{0x93C7,0x8AAD},
{0x93C8,0x6803},
{0x93C9,0x6A61},
{0x93CA,0x51F8},
{0x93CB,0x7A81},
{0x93CC,0x6934},
{0x93CD,0x5C4A},
{0x93CE,0x9CF6},
{0x93CF,0x82EB},
{0x93D0,0x5BC5},
{0x93D1,0x9149},
{0x93D2,0x701E},
{0x93D3,0x5678},
{0x93D4,0x5C6F},
{0x93D5,0x60C7},
{0x93D6,0x6566},
{0x93D7,0x6C8C},
{0x93D8,0x8C5A},
{0x93D9,0x9041},
{0x93DA,0x9813},
{0x93DB,0x5451},
{0x93DC,0x66C7},
{0x93DD,0x920D},
{0x93DE,0x5948},
{0x93DF,0x90A3},
{0x93E0,0x5185},
{0x93E1,0x4E4D},
{0x93E2,0x51EA},
{0x93E3,0x8599},
{0x93E4,0x8B0E},
{0x93E5,0x7058},
{0x93E6,0x637A},
{0x93E7,0x934B},
{0x93E8,0x6962},
{0x93E9,0x99B4},
{0x93EA,0x7E04},
{0x93EB,0x7577},
{0x93EC,0x5357},
{0x93ED,0x6960},
{0x93EE,0x8EDF},
{0x93EF,0x96E3},
{0x93F0,0x6C5D},
{0x93F1,0x4E8C},
{0x93F2,0x5C3C},
{0x93F3,0x5F10},
{0x93F4,0x8FE9},
{0x93F5,0x5302},
{0x93F6,0x8CD1},
{0x93F7,0x8089},
{0x93F8,0x8679},
{0x93F9,0x5EFF},
{0x93FA,0x65E5},
{0x93FB,0x4E73},
{0x93FC,0x5165},
{0x9440,0x5982},
{0x9441,0x5C3F},
{0x9442,0x97EE},
{0x9443,0x4EFB},
{0x9444,0x598A},
{0x9445,0x5FCD},
{0x9446,0x8A8D},
{0x9447,0x6FE1},
{0x9448,0x79B0},
{0x9449,0x7962},
{0x944A,0x5BE7},
{0x944B,0x8471},
{0x944C,0x732B},
{0x944D,0x71B1},
{0x944E,0x5E74},
{0x944F,0x5FF5},
{0x9450,0x637B},
{0x9451,0x649A},
{0x9452,0x71C3},
{0x9453,0x7C98},
{0x9454,0x4E43},
{0x9455,0x5EFC},
{0x9456,0x4E4B},
{0x9457,0x57DC},
{0x9458,0x56A2},
{0x9459,0x60A9},
{0x945A,0x6FC3},
{0x945B,0x7D0D},
{0x945C,0x80FD},
{0x945D,0x8133},
{0x945E,0x81BF},
{0x945F,0x8FB2},
{0x9460,0x8997},
{0x9461,0x86A4},
{0x9462,0x5DF4},
{0x9463,0x628A},
{0x9464,0x64AD},
{0x9465,0x8987},
{0x9466,0x6777},
{0x9467,0x6CE2},
{0x9468,0x6D3E},
{0x9469,0x7436},
{0x946A,0x7834},
{0x946B,0x5A46},
{0x946C,0x7F75},
{0x946D,0x82AD},
{0x946E,0x99AC},
{0x946F,0x4FF3},
{0x9470,0x5EC3},
{0x9471,0x62DD},
{0x9472,0x6392},
{0x9473,0x6557},
{0x9474,0x676F},
{0x9475,0x76C3},
{0x9476,0x724C},
{0x9477,0x80CC},
{0x9478,0x80BA},
{0x9479,0x8F29},
{0x947A,0x914D},
{0x947B,0x500D},
{0x947C,0x57F9},
{0x947D,0x5A92},
{0x947E,0x6885},
{0x9480,0x6973},
{0x9481,0x7164},
{0x9482,0x72FD},
{0x9483,0x8CB7},
{0x9484,0x58F2},
{0x9485,0x8CE0},
{0x9486,0x966A},
{0x9487,0x9019},
{0x9488,0x877F},
{0x9489,0x79E4},
{0x948A,0x77E7},
{0x948B,0x8429},
{0x948C,0x4F2F},
{0x948D,0x5265},
{0x948E,0x535A},
{0x948F,0x62CD},
{0x9490,0x67CF},
{0x9491,0x6CCA},
{0x9492,0x767D},
{0x9493,0x7B94},
{0x9494,0x7C95},
{0x9495,0x8236},
{0x9496,0x8584},
{0x9497,0x8FEB},
{0x9498,0x66DD},
{0x9499,0x6F20},
{0x949A,0x7206},
{0x949B,0x7E1B},
{0x949C,0x83AB},
{0x949D,0x99C1},
{0x949E,0x9EA6},
{0x949F,0x51FD},
{0x94A0,0x7BB1},
{0x94A1,0x7872},
{0x94A2,0x7BB8},
{0x94A3,0x8087},
{0x94A4,0x7B48},
{0x94A5,0x6AE8},
{0x94A6,0x5E61},
{0x94A7,0x808C},
{0x94A8,0x7551},
{0x94A9,0x7560},
{0x94AA,0x516B},
{0x94AB,0x9262},
{0x94AC,0x6E8C},
{0x94AD,0x767A},
{0x94AE,0x9197},
{0x94AF,0x9AEA},
{0x94B0,0x4F10},
{0x94B1,0x7F70},
{0x94B2,0x629C},
{0x94B3,0x7B4F},
{0x94B4,0x95A5},
{0x94B5,0x9CE9},
{0x94B6,0x567A},
{0x94B7,0x5859},
{0x94B8,0x86E4},
{0x94B9,0x96BC},
{0x94BA,0x4F34},
{0x94BB,0x5224},
{0x94BC,0x534A},
{0x94BD,0x53CD},
{0x94BE,0x53DB},
{0x94BF,0x5E06},
{0x94C0,0x642C},
{0x94C1,0x6591},
{0x94C2,0x677F},
{0x94C3,0x6C3E},
{0x94C4,0x6C4E},
{0x94C5,0x7248},
{0x94C6,0x72AF},
{0x94C7,0x73ED},
{0x94C8,0x7554},
{0x94C9,0x7E41},
{0x94CA,0x822C},
{0x94CB,0x85E9},
{0x94CC,0x8CA9},
{0x94CD,0x7BC4},
{0x94CE,0x91C6},
{0x94CF,0x7169},
{0x94D0,0x9812},
{0x94D1,0x98EF},
{0x94D2,0x633D},
{0x94D3,0x6669},
{0x94D4,0x756A},
{0x94D5,0x76E4},
{0x94D6,0x78D0},
{0x94D7,0x8543},
{0x94D8,0x86EE},
{0x94D9,0x532A},
{0x94DA,0x5351},
{0x94DB,0x5426},
{0x94DC,0x5983},
{0x94DD,0x5E87},
{0x94DE,0x5F7C},
{0x94DF,0x60B2},
{0x94E0,0x6249},
{0x94E1,0x6279},
{0x94E2,0x62AB},
{0x94E3,0x6590},
{0x94E4,0x6BD4},
{0x94E5,0x6CCC},
{0x94E6,0x75B2},
{0x94E7,0x76AE},
{0x94E8,0x7891},
{0x94E9,0x79D8},
{0x94EA,0x7DCB},
{0x94EB,0x7F77},
{0x94EC,0x80A5},
{0x94ED,0x88AB},
{0x94EE,0x8AB9},
{0x94EF,0x8CBB},
{0x94F0,0x907F},
{0x94F1,0x975E},
{0x94F2,0x98DB},
{0x94F3,0x6A0B},
{0x94F4,0x7C38},
{0x94F5,0x5099},
{0x94F6,0x5C3E},
{0x94F7,0x5FAE},
{0x94F8,0x6787},
{0x94F9,0x6BD8},
{0x94FA,0x7435},
{0x94FB,0x7709},
{0x94FC,0x7F8E},
{0x9540,0x9F3B},
{0x9541,0x67CA},
{0x9542,0x7A17},
{0x9543,0x5339},
{0x9544,0x758B},
{0x9545,0x9AED},
{0x9546,0x5F66},
{0x9547,0x819D},
{0x9548,0x83F1},
{0x9549,0x8098},
{0x954A,0x5F3C},
{0x954B,0x5FC5},
{0x954C,0x7562},
{0x954D,0x7B46},
{0x954E,0x903C},
{0x954F,0x6867},
{0x9550,0x59EB},
{0x9551,0x5A9B},
{0x9552,0x7D10},
{0x9553,0x767E},
{0x9554,0x8B2C},
{0x9555,0x4FF5},
{0x9556,0x5F6A},
{0x9557,0x6A19},
{0x9558,0x6C37},
{0x9559,0x6F02},
{0x955A,0x74E2},
{0x955B,0x7968},
{0x955C,0x8868},
{0x955D,0x8A55},
{0x955E,0x8C79},
{0x955F,0x5EDF},
{0x9560,0x63CF},
{0x9561,0x75C5},
{0x9562,0x79D2},
{0x9563,0x82D7},
{0x9564,0x9328},
{0x9565,0x92F2},
{0x9566,0x849C},
{0x9567,0x86ED},
{0x9568,0x9C2D},
{0x9569,0x54C1},
{0x956A,0x5F6C},
{0x956B,0x658C},
{0x956C,0x6D5C},
{0x956D,0x7015},
{0x956E,0x8CA7},
{0x956F,0x8CD3},
{0x9570,0x983B},
{0x9571,0x654F},
{0x9572,0x74F6},
{0x9573,0x4E0D},
{0x9574,0x4ED8},
{0x9575,0x57E0},
{0x9576,0x592B},
{0x9577,0x5A66},
{0x9578,0x5BCC},
{0x9579,0x51A8},
{0x957A,0x5E03},
{0x957B,0x5E9C},
{0x957C,0x6016},
{0x957D,0x6276},
{0x957E,0x6577},
{0x9580,0x65A7},
{0x9581,0x666E},
{0x9582,0x6D6E},
{0x9583,0x7236},
{0x9584,0x7B26},
{0x9585,0x8150},
{0x9586,0x819A},
{0x9587,0x8299},
{0x9588,0x8B5C},
{0x9589,0x8CA0},
{0x958A,0x8CE6},
{0x958B,0x8D74},
{0x958C,0x961C},
{0x958D,0x9644},
{0x958E,0x4FAE},
{0x958F,0x64AB},
{0x9590,0x6B66},
{0x9591,0x821E},
{0x9592,0x8461},
{0x9593,0x856A},
{0x9594,0x90E8},
{0x9595,0x5C01},
{0x9596,0x6953},
{0x9597,0x98A8},
{0x9598,0x847A},
{0x9599,0x8557},
{0x959A,0x4F0F},
{0x959B,0x526F},
{0x959C,0x5FA9},
{0x959D,0x5E45},
{0x959E,0x670D},
{0x959F,0x798F},
{0x95A0,0x8179},
{0x95A1,0x8907},
{0x95A2,0x8986},
{0x95A3,0x6DF5},
{0x95A4,0x5F17},
{0x95A5,0x6255},
{0x95A6,0x6CB8},
{0x95A7,0x4ECF},
{0x95A8,0x7269},
{0x95A9,0x9B92},
{0x95AA,0x5206},
{0x95AB,0x543B},
{0x95AC,0x5674},
{0x95AD,0x58B3},
{0x95AE,0x61A4},
{0x95AF,0x626E},
{0x95B0,0x711A},
{0x95B1,0x596E},
{0x95B2,0x7C89},
{0x95B3,0x7CDE},
{0x95B4,0x7D1B},
{0x95B5,0x96F0},
{0x95B6,0x6587},
{0x95B7,0x805E},
{0x95B8,0x4E19},
{0x95B9,0x4F75},
{0x95BA,0x5175},
{0x95BB,0x5840},
{0x95BC,0x5E63},
{0x95BD,0x5E73},
{0x95BE,0x5F0A},
{0x95BF,0x67C4},
{0x95C0,0x4E26},
{0x95C1,0x853D},
{0x95C2,0x9589},
{0x95C3,0x965B},
{0x95C4,0x7C73},
{0x95C5,0x9801},
{0x95C6,0x50FB},
{0x95C7,0x58C1},
{0x95C8,0x7656},
{0x95C9,0x78A7},
{0x95CA,0x5225},
{0x95CB,0x77A5},
{0x95CC,0x8511},
{0x95CD,0x7B86},
{0x95CE,0x504F},
{0x95CF,0x5909},
{0x95D0,0x7247},
{0x95D1,0x7BC7},
{0x95D2,0x7DE8},
{0x95D3,0x8FBA},
{0x95D4,0x8FD4},
{0x95D5,0x904D},
{0x95D6,0x4FBF},
{0x95D7,0x52C9},
{0x95D8,0x5A29},
{0x95D9,0x5F01},
{0x95DA,0x97AD},
{0x95DB,0x4FDD},
{0x95DC,0x8217},
{0x95DD,0x92EA},
{0x95DE,0x5703},
{0x95DF,0x6355},
{0x95E0,0x6B69},
{0x95E1,0x752B},
{0x95E2,0x88DC},
{0x95E3,0x8F14},
{0x95E4,0x7A42},
{0x95E5,0x52DF},
{0x95E6,0x5893},
{0x95E7,0x6155},
{0x95E8,0x620A},
{0x95E9,0x66AE},
{0x95EA,0x6BCD},
{0x95EB,0x7C3F},
{0x95EC,0x83E9},
{0x95ED,0x5023},
{0x95EE,0x4FF8},
{0x95EF,0x5305},
{0x95F0,0x5446},
{0x95F1,0x5831},
{0x95F2,0x5949},
{0x95F3,0x5B9D},
{0x95F4,0x5CF0},
{0x95F5,0x5CEF},
{0x95F6,0x5D29},
{0x95F7,0x5E96},
{0x95F8,0x62B1},
{0x95F9,0x6367},
{0x95FA,0x653E},
{0x95FB,0x65B9},
{0x95FC,0x670B},
{0x9640,0x6CD5},
{0x9641,0x6CE1},
{0x9642,0x70F9},
{0x9643,0x7832},
{0x9644,0x7E2B},
{0x9645,0x80DE},
{0x9646,0x82B3},
{0x9647,0x840C},
{0x9648,0x84EC},
{0x9649,0x8702},
{0x964A,0x8912},
{0x964B,0x8A2A},
{0x964C,0x8C4A},
{0x964D,0x90A6},
{0x964E,0x92D2},
{0x964F,0x98FD},
{0x9650,0x9CF3},
{0x9651,0x9D6C},
{0x9652,0x4E4F},
{0x9653,0x4EA1},
{0x9654,0x508D},
{0x9655,0x5256},
{0x9656,0x574A},
{0x9657,0x59A8},
{0x9658,0x5E3D},
{0x9659,0x5FD8},
{0x965A,0x5FD9},
{0x965B,0x623F},
{0x965C,0x66B4},
{0x965D,0x671B},
{0x965E,0x67D0},
{0x965F,0x68D2},
{0x9660,0x5192},
{0x9661,0x7D21},
{0x9662,0x80AA},
{0x9663,0x81A8},
{0x9664,0x8B00},
{0x9665,0x8C8C},
{0x9666,0x8CBF},
{0x9667,0x927E},
{0x9668,0x9632},
{0x9669,0x5420},
{0x966A,0x982C},
{0x966B,0x5317},
{0x966C,0x50D5},
{0x966D,0x535C},
{0x966E,0x58A8},
{0x966F,0x64B2},
{0x9670,0x6734},
{0x9671,0x7267},
{0x9672,0x7766},
{0x9673,0x7A46},
{0x9674,0x91E6},
{0x9675,0x52C3},
{0x9676,0x6CA1},
{0x9677,0x6B86},
{0x9678,0x5800},
{0x9679,0x5E4C},
{0x967A,0x5954},
{0x967B,0x672C},
{0x967C,0x7FFB},
{0x967D,0x51E1},
{0x967E,0x76C6},
{0x9680,0x6469},
{0x9681,0x78E8},
{0x9682,0x9B54},
{0x9683,0x9EBB},
{0x9684,0x57CB},
{0x9685,0x59B9},
{0x9686,0x6627},
{0x9687,0x679A},
{0x9688,0x6BCE},
{0x9689,0x54E9},
{0x968A,0x69D9},
{0x968B,0x5E55},
{0x968C,0x819C},
{0x968D,0x6795},
{0x968E,0x9BAA},
{0x968F,0x67FE},
{0x9690,0x9C52},
{0x9691,0x685D},
{0x9692,0x4EA6},
{0x9693,0x4FE3},
{0x9694,0x53C8},
{0x9695,0x62B9},
{0x9696,0x672B},
{0x9697,0x6CAB},
{0x9698,0x8FC4},
{0x9699,0x4FAD},
{0x969A,0x7E6D},
{0x969B,0x9EBF},
{0x969C,0x4E07},
{0x969D,0x6162},
{0x969E,0x6E80},
{0x969F,0x6F2B},
{0x96A0,0x8513},
{0x96A1,0x5473},
{0x96A2,0x672A},
{0x96A3,0x9B45},
{0x96A4,0x5DF3},
{0x96A5,0x7B95},
{0x96A6,0x5CAC},
{0x96A7,0x5BC6},
{0x96A8,0x871C},
{0x96A9,0x6E4A},
{0x96AA,0x84D1},
{0x96AB,0x7A14},
{0x96AC,0x8108},
{0x96AD,0x5999},
{0x96AE,0x7C8D},
{0x96AF,0x6C11},
{0x96B0,0x7720},
{0x96B1,0x52D9},
{0x96B2,0x5922},
{0x96B3,0x7121},
{0x96B4,0x725F},
{0x96B5,0x77DB},
{0x96B6,0x9727},
{0x96B7,0x9D61},
{0x96B8,0x690B},
{0x96B9,0x5A7F},
{0x96BA,0x5A18},
{0x96BB,0x51A5},
{0x96BC,0x540D},
{0x96BD,0x547D},
{0x96BE,0x660E},
{0x96BF,0x76DF},
{0x96C0,0x8FF7},
{0x96C1,0x9298},
{0x96C2,0x9CF4},
{0x96C3,0x59EA},
{0x96C4,0x725D},
{0x96C5,0x6EC5},
{0x96C6,0x514D},
{0x96C7,0x68C9},
{0x96C8,0x7DBF},
{0x96C9,0x7DEC},
{0x96CA,0x9762},
{0x96CB,0x9EBA},
{0x96CC,0x6478},
{0x96CD,0x6A21},
{0x96CE,0x8302},
{0x96CF,0x5984},
{0x96D0,0x5B5F},
{0x96D1,0x6BDB},
{0x96D2,0x731B},
{0x96D3,0x76F2},
{0x96D4,0x7DB2},
{0x96D5,0x8017},
{0x96D6,0x8499},
{0x96D7,0x5132},
{0x96D8,0x6728},
{0x96D9,0x9ED9},
{0x96DA,0x76EE},
{0x96DB,0x6762},
{0x96DC,0x52FF},
{0x96DD,0x9905},
{0x96DE,0x5C24},
{0x96DF,0x623B},
{0x96E0,0x7C7E},
{0x96E1,0x8CB0},
{0x96E2,0x554F},
{0x96E3,0x60B6},
{0x96E4,0x7D0B},
{0x96E5,0x9580},
{0x96E6,0x5301},
{0x96E7,0x4E5F},
{0x96E8,0x51B6},
{0x96E9,0x591C},
{0x96EA,0x723A},
{0x96EB,0x8036},
{0x96EC,0x91CE},
{0x96ED,0x5F25},
{0x96EE,0x77E2},
{0x96EF,0x5384},
{0x96F0,0x5F79},
{0x96F1,0x7D04},
{0x96F2,0x85AC},
{0x96F3,0x8A33},
{0x96F4,0x8E8D},
{0x96F5,0x9756},
{0x96F6,0x67F3},
{0x96F7,0x85AE},
{0x96F8,0x9453},
{0x96F9,0x6109},
{0x96FA,0x6108},
{0x96FB,0x6CB9},
{0x96FC,0x7652},
{0x9740,0x8AED},
{0x9741,0x8F38},
{0x9742,0x552F},
{0x9743,0x4F51},
{0x9744,0x512A},
{0x9745,0x52C7},
{0x9746,0x53CB},
{0x9747,0x5BA5},
{0x9748,0x5E7D},
{0x9749,0x60A0},
{0x974A,0x6182},
{0x974B,0x63D6},
{0x974C,0x6709},
{0x974D,0x67DA},
{0x974E,0x6E67},
{0x974F,0x6D8C},
{0x9750,0x7336},
{0x9751,0x7337},
{0x9752,0x7531},
{0x9753,0x7950},
{0x9754,0x88D5},
{0x9755,0x8A98},
{0x9756,0x904A},
{0x9757,0x9091},
{0x9758,0x90F5},
{0x9759,0x96C4},
{0x975A,0x878D},
{0x975B,0x5915},
{0x975C,0x4E88},
{0x975D,0x4F59},
{0x975E,0x4E0E},
{0x975F,0x8A89},
{0x9760,0x8F3F},
{0x9761,0x9810},
{0x9762,0x50AD},
{0x9763,0x5E7C},
{0x9764,0x5996},
{0x9765,0x5BB9},
{0x9766,0x5EB8},
{0x9767,0x63DA},
{0x9768,0x63FA},
{0x9769,0x64C1},
{0x976A,0x66DC},
{0x976B,0x694A},
{0x976C,0x69D8},
{0x976D,0x6D0B},
{0x976E,0x6EB6},
{0x976F,0x7194},
{0x9770,0x7528},
{0x9771,0x7AAF},
{0x9772,0x7F8A},
{0x9773,0x8000},
{0x9774,0x8449},
{0x9775,0x84C9},
{0x9776,0x8981},
{0x9777,0x8B21},
{0x9778,0x8E0A},
{0x9779,0x9065},
{0x977A,0x967D},
{0x977B,0x990A},
{0x977C,0x617E},
{0x977D,0x6291},
{0x977E,0x6B32},
{0x9780,0x6C83},
{0x9781,0x6D74},
{0x9782,0x7FCC},
{0x9783,0x7FFC},
{0x9784,0x6DC0},
{0x9785,0x7F85},
{0x9786,0x87BA},
{0x9787,0x88F8},
{0x9788,0x6765},
{0x9789,0x83B1},
{0x978A,0x983C},
{0x978B,0x96F7},
{0x978C,0x6D1B},
{0x978D,0x7D61},
{0x978E,0x843D},
{0x978F,0x916A},
{0x9790,0x4E71},
{0x9791,0x5375},
{0x9792,0x5D50},
{0x9793,0x6B04},
{0x9794,0x6FEB},
{0x9795,0x85CD},
{0x9796,0x862D},
{0x9797,0x89A7},
{0x9798,0x5229},
{0x9799,0x540F},
{0x979A,0x5C65},
{0x979B,0x674E},
{0x979C,0x68A8},
{0x979D,0x7406},
{0x979E,0x7483},
{0x979F,0x75E2},
{0x97A0,0x88CF},
{0x97A1,0x88E1},
{0x97A2,0x91CC},
{0x97A3,0x96E2},
{0x97A4,0x9678},
{0x97A5,0x5F8B},
{0x97A6,0x7387},
{0x97A7,0x7ACB},
{0x97A8,0x844E},
{0x97A9,0x63A0},
{0x97AA,0x7565},
{0x97AB,0x5289},
{0x97AC,0x6D41},
{0x97AD,0x6E9C},
{0x97AE,0x7409},
{0x97AF,0x7559},
{0x97B0,0x786B},
{0x97B1,0x7C92},
{0x97B2,0x9686},
{0x97B3,0x7ADC},
{0x97B4,0x9F8D},
{0x97B5,0x4FB6},
{0x97B6,0x616E},
{0x97B7,0x65C5},
{0x97B8,0x865C},
{0x97B9,0x4E86},
{0x97BA,0x4EAE},
{0x97BB,0x50DA},
{0x97BC,0x4E21},
{0x97BD,0x51CC},
{0x97BE,0x5BEE},
{0x97BF,0x6599},
{0x97C0,0x6881},
{0x97C1,0x6DBC},
{0x97C2,0x731F},
{0x97C3,0x7642},
{0x97C4,0x77AD},
{0x97C5,0x7A1C},
{0x97C6,0x7CE7},
{0x97C7,0x826F},
{0x97C8,0x8AD2},
{0x97C9,0x907C},
{0x97CA,0x91CF},
{0x97CB,0x9675},
{0x97CC,0x9818},
{0x97CD,0x529B},
{0x97CE,0x7DD1},
{0x97CF,0x502B},
{0x97D0,0x5398},
{0x97D1,0x6797},
{0x97D2,0x6DCB},
{0x97D3,0x71D0},
{0x97D4,0x7433},
{0x97D5,0x81E8},
{0x97D6,0x8F2A},
{0x97D7,0x96A3},
{0x97D8,0x9C57},
{0x97D9,0x9E9F},
{0x97DA,0x7460},
{0x97DB,0x5841},
{0x97DC,0x6D99},
{0x97DD,0x7D2F},
{0x97DE,0x985E},
{0x97DF,0x4EE4},
{0x97E0,0x4F36},
{0x97E1,0x4F8B},
{0x97E2,0x51B7},
{0x97E3,0x52B1},
{0x97E4,0x5DBA},
{0x97E5,0x601C},
{0x97E6,0x73B2},
{0x97E7,0x793C},
{0x97E8,0x82D3},
{0x97E9,0x9234},
{0x97EA,0x96B7},
{0x97EB,0x96F6},
{0x97EC,0x970A},
{0x97ED,0x9E97},
{0x97EE,0x9F62},
{0x97EF,0x66A6},
{0x97F0,0x6B74},
{0x97F1,0x5217},
{0x97F2,0x52A3},
{0x97F3,0x70C8},
{0x97F4,0x88C2},
{0x97F5,0x5EC9},
{0x97F6,0x604B},
{0x97F7,0x6190},
{0x97F8,0x6F23},
{0x97F9,0x7149},
{0x97FA,0x7C3E},
{0x97FB,0x7DF4},
{0x97FC,0x806F},
{0x9840,0x84EE},
{0x9841,0x9023},
{0x9842,0x932C},
{0x9843,0x5442},
{0x9844,0x9B6F},
{0x9845,0x6AD3},
{0x9846,0x7089},
{0x9847,0x8CC2},
{0x9848,0x8DEF},
{0x9849,0x9732},
{0x984A,0x52B4},
{0x984B,0x5A41},
{0x984C,0x5ECA},
{0x984D,0x5F04},
{0x984E,0x6717},
{0x984F,0x697C},
{0x9850,0x6994},
{0x9851,0x6D6A},
{0x9852,0x6F0F},
{0x9853,0x7262},
{0x9854,0x72FC},
{0x9855,0x7BED},
{0x9856,0x8001},
{0x9857,0x807E},
{0x9858,0x874B},
{0x9859,0x90CE},
{0x985A,0x516D},
{0x985B,0x9E93},
{0x985C,0x7984},
{0x985D,0x808B},
{0x985E,0x9332},
{0x985F,0x8AD6},
{0x9860,0x502D},
{0x9861,0x548C},
{0x9862,0x8A71},
{0x9863,0x6B6A},
{0x9864,0x8CC4},
{0x9865,0x8107},
{0x9866,0x60D1},
{0x9867,0x67A0},
{0x9868,0x9DF2},
{0x9869,0x4E99},
{0x986A,0x4E98},
{0x986B,0x9C10},
{0x986C,0x8A6B},
{0x986D,0x85C1},
{0x986E,0x8568},
{0x986F,0x6900},
{0x9870,0x6E7E},
{0x9871,0x7897},
{0x9872,0x8155},
{0x989F,0x5F0C},
{0x98A0,0x4E10},
{0x98A1,0x4E15},
{0x98A2,0x4E2A},
{0x98A3,0x4E31},
{0x98A4,0x4E36},
{0x98A5,0x4E3C},
{0x98A6,0x4E3F},
{0x98A7,0x4E42},
{0x98A8,0x4E56},
{0x98A9,0x4E58},
{0x98AA,0x4E82},
{0x98AB,0x4E85},
{0x98AC,0x8C6B},
{0x98AD,0x4E8A},
{0x98AE,0x8212},
{0x98AF,0x5F0D},
{0x98B0,0x4E8E},
{0x98B1,0x4E9E},
{0x98B2,0x4E9F},
{0x98B3,0x4EA0},
{0x98B4,0x4EA2},
{0x98B5,0x4EB0},
{0x98B6,0x4EB3},
{0x98B7,0x4EB6},
{0x98B8,0x4ECE},
{0x98B9,0x4ECD},
{0x98BA,0x4EC4},
{0x98BB,0x4EC6},
{0x98BC,0x4EC2},
{0x98BD,0x4ED7},
{0x98BE,0x4EDE},
{0x98BF,0x4EED},
{0x98C0,0x4EDF},
{0x98C1,0x4EF7},
{0x98C2,0x4F09},
{0x98C3,0x4F5A},
{0x98C4,0x4F30},
{0x98C5,0x4F5B},
{0x98C6,0x4F5D},
{0x98C7,0x4F57},
{0x98C8,0x4F47},
{0x98C9,0x4F76},
{0x98CA,0x4F88},
{0x98CB,0x4F8F},
{0x98CC,0x4F98},
{0x98CD,0x4F7B},
{0x98CE,0x4F69},
{0x98CF,0x4F70},
{0x98D0,0x4F91},
{0x98D1,0x4F6F},
{0x98D2,0x4F86},
{0x98D3,0x4F96},
{0x98D4,0x5118},
{0x98D5,0x4FD4},
{0x98D6,0x4FDF},
{0x98D7,0x4FCE},
{0x98D8,0x4FD8},
{0x98D9,0x4FDB},
{0x98DA,0x4FD1},
{0x98DB,0x4FDA},
{0x98DC,0x4FD0},
{0x98DD,0x4FE4},
{0x98DE,0x4FE5},
{0x98DF,0x501A},
{0x98E0,0x5028},
{0x98E1,0x5014},
{0x98E2,0x502A},
{0x98E3,0x5025},
{0x98E4,0x5005},
{0x98E5,0x4F1C},
{0x98E6,0x4FF6},
{0x98E7,0x5021},
{0x98E8,0x5029},
{0x98E9,0x502C},
{0x98EA,0x4FFE},
{0x98EB,0x4FEF},
{0x98EC,0x5011},
{0x98ED,0x5006},
{0x98EE,0x5043},
{0x98EF,0x5047},
{0x98F0,0x6703},
{0x98F1,0x5055},
{0x98F2,0x5050},
{0x98F3,0x5048},
{0x98F4,0x505A},
{0x98F5,0x5056},
{0x98F6,0x506C},
{0x98F7,0x5078},
{0x98F8,0x5080},
{0x98F9,0x509A},
{0x98FA,0x5085},
{0x98FB,0x50B4},
{0x98FC,0x50B2},
{0x9940,0x50C9},
{0x9941,0x50CA},
{0x9942,0x50B3},
{0x9943,0x50C2},
{0x9944,0x50D6},
{0x9945,0x50DE},
{0x9946,0x50E5},
{0x9947,0x50ED},
{0x9948,0x50E3},
{0x9949,0x50EE},
{0x994A,0x50F9},
{0x994B,0x50F5},
{0x994C,0x5109},
{0x994D,0x5101},
{0x994E,0x5102},
{0x994F,0x5116},
{0x9950,0x5115},
{0x9951,0x5114},
{0x9952,0x511A},
{0x9953,0x5121},
{0x9954,0x513A},
{0x9955,0x5137},
{0x9956,0x513C},
{0x9957,0x513B},
{0x9958,0x513F},
{0x9959,0x5140},
{0x995A,0x5152},
{0x995B,0x514C},
{0x995C,0x5154},
{0x995D,0x5162},
{0x995E,0x7AF8},
{0x995F,0x5169},
{0x9960,0x516A},
{0x9961,0x516E},
{0x9962,0x5180},
{0x9963,0x5182},
{0x9964,0x56D8},
{0x9965,0x518C},
{0x9966,0x5189},
{0x9967,0x518F},
{0x9968,0x5191},
{0x9969,0x5193},
{0x996A,0x5195},
{0x996B,0x5196},
{0x996C,0x51A4},
{0x996D,0x51A6},
{0x996E,0x51A2},
{0x996F,0x51A9},
{0x9970,0x51AA},
{0x9971,0x51AB},
{0x9972,0x51B3},
{0x9973,0x51B1},
{0x9974,0x51B2},
{0x9975,0x51B0},
{0x9976,0x51B5},
{0x9977,0x51BD},
{0x9978,0x51C5},
{0x9979,0x51C9},
{0x997A,0x51DB},
{0x997B,0x51E0},
{0x997C,0x8655},
{0x997D,0x51E9},
{0x997E,0x51ED},
{0x9980,0x51F0},
{0x9981,0x51F5},
{0x9982,0x51FE},
{0x9983,0x5204},
{0x9984,0x520B},
{0x9985,0x5214},
{0x9986,0x520E},
{0x9987,0x5227},
{0x9988,0x522A},
{0x9989,0x522E},
{0x998A,0x5233},
{0x998B,0x5239},
{0x998C,0x524F},
{0x998D,0x5244},
{0x998E,0x524B},
{0x998F,0x524C},
{0x9990,0x525E},
{0x9991,0x5254},
{0x9992,0x526A},
{0x9993,0x5274},
{0x9994,0x5269},
{0x9995,0x5273},
{0x9996,0x527F},
{0x9997,0x527D},
{0x9998,0x528D},
{0x9999,0x5294},
{0x999A,0x5292},
{0x999B,0x5271},
{0x999C,0x5288},
{0x999D,0x5291},
{0x999E,0x8FA8},
{0x999F,0x8FA7},
{0x99A0,0x52AC},
{0x99A1,0x52AD},
{0x99A2,0x52BC},
{0x99A3,0x52B5},
{0x99A4,0x52C1},
{0x99A5,0x52CD},
{0x99A6,0x52D7},
{0x99A7,0x52DE},
{0x99A8,0x52E3},
{0x99A9,0x52E6},
{0x99AA,0x98ED},
{0x99AB,0x52E0},
{0x99AC,0x52F3},
{0x99AD,0x52F5},
{0x99AE,0x52F8},
{0x99AF,0x52F9},
{0x99B0,0x5306},
{0x99B1,0x5308},
{0x99B2,0x7538},
{0x99B3,0x530D},
{0x99B4,0x5310},
{0x99B5,0x530F},
{0x99B6,0x5315},
{0x99B7,0x531A},
{0x99B8,0x5323},
{0x99B9,0x532F},
{0x99BA,0x5331},
{0x99BB,0x5333},
{0x99BC,0x5338},
{0x99BD,0x5340},
{0x99BE,0x5346},
{0x99BF,0x5345},
{0x99C0,0x4E17},
{0x99C1,0x5349},
{0x99C2,0x534D},
{0x99C3,0x51D6},
{0x99C4,0x535E},
{0x99C5,0x5369},
{0x99C6,0x536E},
{0x99C7,0x5918},
{0x99C8,0x537B},
{0x99C9,0x5377},
{0x99CA,0x5382},
{0x99CB,0x5396},
{0x99CC,0x53A0},
{0x99CD,0x53A6},
{0x99CE,0x53A5},
{0x99CF,0x53AE},
{0x99D0,0x53B0},
{0x99D1,0x53B6},
{0x99D2,0x53C3},
{0x99D3,0x7C12},
{0x99D4,0x96D9},
{0x99D5,0x53DF},
{0x99D6,0x66FC},
{0x99D7,0x71EE},
{0x99D8,0x53EE},
{0x99D9,0x53E8},
{0x99DA,0x53ED},
{0x99DB,0x53FA},
{0x99DC,0x5401},
{0x99DD,0x543D},
{0x99DE,0x5440},
{0x99DF,0x542C},
{0x99E0,0x542D},
{0x99E1,0x543C},
{0x99E2,0x542E},
{0x99E3,0x5436},
{0x99E4,0x5429},
{0x99E5,0x541D},
{0x99E6,0x544E},
{0x99E7,0x548F},
{0x99E8,0x5475},
{0x99E9,0x548E},
{0x99EA,0x545F},
{0x99EB,0x5471},
{0x99EC,0x5477},
{0x99ED,0x5470},
{0x99EE,0x5492},
{0x99EF,0x547B},
{0x99F0,0x5480},
{0x99F1,0x5476},
{0x99F2,0x5484},
{0x99F3,0x5490},
{0x99F4,0x5486},
{0x99F5,0x54C7},
{0x99F6,0x54A2},
{0x99F7,0x54B8},
{0x99F8,0x54A5},
{0x99F9,0x54AC},
{0x99FA,0x54C4},
{0x99FB,0x54C8},
{0x99FC,0x54A8},
{0x9A40,0x54AB},
{0x9A41,0x54C2},
{0x9A42,0x54A4},
{0x9A43,0x54BE},
{0x9A44,0x54BC},
{0x9A45,0x54D8},
{0x9A46,0x54E5},
{0x9A47,0x54E6},
{0x9A48,0x550F},
{0x9A49,0x5514},
{0x9A4A,0x54FD},
{0x9A4B,0x54EE},
{0x9A4C,0x54ED},
{0x9A4D,0x54FA},
{0x9A4E,0x54E2},
{0x9A4F,0x5539},
{0x9A50,0x5540},
{0x9A51,0x5563},
{0x9A52,0x554C},
{0x9A53,0x552E},
{0x9A54,0x555C},
{0x9A55,0x5545},
{0x9A56,0x5556},
{0x9A57,0x5557},
{0x9A58,0x5538},
{0x9A59,0x5533},
{0x9A5A,0x555D},
{0x9A5B,0x5599},
{0x9A5C,0x5580},
{0x9A5D,0x54AF},
{0x9A5E,0x558A},
{0x9A5F,0x559F},
{0x9A60,0x557B},
{0x9A61,0x557E},
{0x9A62,0x5598},
{0x9A63,0x559E},
{0x9A64,0x55AE},
{0x9A65,0x557C},
{0x9A66,0x5583},
{0x9A67,0x55A9},
{0x9A68,0x5587},
{0x9A69,0x55A8},
{0x9A6A,0x55DA},
{0x9A6B,0x55C5},
{0x9A6C,0x55DF},
{0x9A6D,0x55C4},
{0x9A6E,0x55DC},
{0x9A6F,0x55E4},
{0x9A70,0x55D4},
{0x9A71,0x5614},
{0x9A72,0x55F7},
{0x9A73,0x5616},
{0x9A74,0x55FE},
{0x9A75,0x55FD},
{0x9A76,0x561B},
{0x9A77,0x55F9},
{0x9A78,0x564E},
{0x9A79,0x5650},
{0x9A7A,0x71DF},
{0x9A7B,0x5634},
{0x9A7C,0x5636},
{0x9A7D,0x5632},
{0x9A7E,0x5638},
{0x9A80,0x566B},
{0x9A81,0x5664},
{0x9A82,0x562F},
{0x9A83,0x566C},
{0x9A84,0x566A},
{0x9A85,0x5686},
{0x9A86,0x5680},
{0x9A87,0x568A},
{0x9A88,0x56A0},
{0x9A89,0x5694},
{0x9A8A,0x568F},
{0x9A8B,0x56A5},
{0x9A8C,0x56AE},
{0x9A8D,0x56B6},
{0x9A8E,0x56B4},
{0x9A8F,0x56C2},
{0x9A90,0x56BC},
{0x9A91,0x56C1},
{0x9A92,0x56C3},
{0x9A93,0x56C0},
{0x9A94,0x56C8},
{0x9A95,0x56CE},
{0x9A96,0x56D1},
{0x9A97,0x56D3},
{0x9A98,0x56D7},
{0x9A99,0x56EE},
{0x9A9A,0x56F9},
{0x9A9B,0x5700},
{0x9A9C,0x56FF},
{0x9A9D,0x5704},
{0x9A9E,0x5709},
{0x9A9F,0x5708},
{0x9AA0,0x570B},
{0x9AA1,0x570D},
{0x9AA2,0x5713},
{0x9AA3,0x5718},
{0x9AA4,0x5716},
{0x9AA5,0x55C7},
{0x9AA6,0x571C},
{0x9AA7,0x5726},
{0x9AA8,0x5737},
{0x9AA9,0x5738},
{0x9AAA,0x574E},
{0x9AAB,0x573B},
{0x9AAC,0x5740},
{0x9AAD,0x574F},
{0x9AAE,0x5769},
{0x9AAF,0x57C0},
{0x9AB0,0x5788},
{0x9AB1,0x5761},
{0x9AB2,0x577F},
{0x9AB3,0x5789},
{0x9AB4,0x5793},
{0x9AB5,0x57A0},
{0x9AB6,0x57B3},
{0x9AB7,0x57A4},
{0x9AB8,0x57AA},
{0x9AB9,0x57B0},
{0x9ABA,0x57C3},
{0x9ABB,0x57C6},
{0x9ABC,0x57D4},
{0x9ABD,0x57D2},
{0x9ABE,0x57D3},
{0x9ABF,0x580A},
{0x9AC0,0x57D6},
{0x9AC1,0x57E3},
{0x9AC2,0x580B},
{0x9AC3,0x5819},
{0x9AC4,0x581D},
{0x9AC5,0x5872},
{0x9AC6,0x5821},
{0x9AC7,0x5862},
{0x9AC8,0x584B},
{0x9AC9,0x5870},
{0x9ACA,0x6BC0},
{0x9ACB,0x5852},
{0x9ACC,0x583D},
{0x9ACD,0x5879},
{0x9ACE,0x5885},
{0x9ACF,0x58B9},
{0x9AD0,0x589F},
{0x9AD1,0x58AB},
{0x9AD2,0x58BA},
{0x9AD3,0x58DE},
{0x9AD4,0x58BB},
{0x9AD5,0x58B8},
{0x9AD6,0x58AE},
{0x9AD7,0x58C5},
{0x9AD8,0x58D3},
{0x9AD9,0x58D1},
{0x9ADA,0x58D7},
{0x9ADB,0x58D9},
{0x9ADC,0x58D8},
{0x9ADD,0x58E5},
{0x9ADE,0x58DC},
{0x9ADF,0x58E4},
{0x9AE0,0x58DF},
{0x9AE1,0x58EF},
{0x9AE2,0x58FA},
{0x9AE3,0x58F9},
{0x9AE4,0x58FB},
{0x9AE5,0x58FC},
{0x9AE6,0x58FD},
{0x9AE7,0x5902},
{0x9AE8,0x590A},
{0x9AE9,0x5910},
{0x9AEA,0x591B},
{0x9AEB,0x68A6},
{0x9AEC,0x5925},
{0x9AED,0x592C},
{0x9AEE,0x592D},
{0x9AEF,0x5932},
{0x9AF0,0x5938},
{0x9AF1,0x593E},
{0x9AF2,0x7AD2},
{0x9AF3,0x5955},
{0x9AF4,0x5950},
{0x9AF5,0x594E},
{0x9AF6,0x595A},
{0x9AF7,0x5958},
{0x9AF8,0x5962},
{0x9AF9,0x5960},
{0x9AFA,0x5967},
{0x9AFB,0x596C},
{0x9AFC,0x5969},
{0x9B40,0x5978},
{0x9B41,0x5981},
{0x9B42,0x599D},
{0x9B43,0x4F5E},
{0x9B44,0x4FAB},
{0x9B45,0x59A3},
{0x9B46,0x59B2},
{0x9B47,0x59C6},
{0x9B48,0x59E8},
{0x9B49,0x59DC},
{0x9B4A,0x598D},
{0x9B4B,0x59D9},
{0x9B4C,0x59DA},
{0x9B4D,0x5A25},
{0x9B4E,0x5A1F},
{0x9B4F,0x5A11},
{0x9B50,0x5A1C},
{0x9B51,0x5A09},
{0x9B52,0x5A1A},
{0x9B53,0x5A40},
{0x9B54,0x5A6C},
{0x9B55,0x5A49},
{0x9B56,0x5A35},
{0x9B57,0x5A36},
{0x9B58,0x5A62},
{0x9B59,0x5A6A},
{0x9B5A,0x5A9A},
{0x9B5B,0x5ABC},
{0x9B5C,0x5ABE},
{0x9B5D,0x5ACB},
{0x9B5E,0x5AC2},
{0x9B5F,0x5ABD},
{0x9B60,0x5AE3},
{0x9B61,0x5AD7},
{0x9B62,0x5AE6},
{0x9B63,0x5AE9},
{0x9B64,0x5AD6},
{0x9B65,0x5AFA},
{0x9B66,0x5AFB},
{0x9B67,0x5B0C},
{0x9B68,0x5B0B},
{0x9B69,0x5B16},
{0x9B6A,0x5B32},
{0x9B6B,0x5AD0},
{0x9B6C,0x5B2A},
{0x9B6D,0x5B36},
{0x9B6E,0x5B3E},
{0x9B6F,0x5B43},
{0x9B70,0x5B45},
{0x9B71,0x5B40},
{0x9B72,0x5B51},
{0x9B73,0x5B55},
{0x9B74,0x5B5A},
{0x9B75,0x5B5B},
{0x9B76,0x5B65},
{0x9B77,0x5B69},
{0x9B78,0x5B70},
{0x9B79,0x5B73},
{0x9B7A,0x5B75},
{0x9B7B,0x5B78},
{0x9B7C,0x6588},
{0x9B7D,0x5B7A},
{0x9B7E,0x5B80},
{0x9B80,0x5B83},
{0x9B81,0x5BA6},
{0x9B82,0x5BB8},
{0x9B83,0x5BC3},
{0x9B84,0x5BC7},
{0x9B85,0x5BC9},
{0x9B86,0x5BD4},
{0x9B87,0x5BD0},
{0x9B88,0x5BE4},
{0x9B89,0x5BE6},
{0x9B8A,0x5BE2},
{0x9B8B,0x5BDE},
{0x9B8C,0x5BE5},
{0x9B8D,0x5BEB},
{0x9B8E,0x5BF0},
{0x9B8F,0x5BF6},
{0x9B90,0x5BF3},
{0x9B91,0x5C05},
{0x9B92,0x5C07},
{0x9B93,0x5C08},
{0x9B94,0x5C0D},
{0x9B95,0x5C13},
{0x9B96,0x5C20},
{0x9B97,0x5C22},
{0x9B98,0x5C28},
{0x9B99,0x5C38},
{0x9B9A,0x5C39},
{0x9B9B,0x5C41},
{0x9B9C,0x5C46},
{0x9B9D,0x5C4E},
{0x9B9E,0x5C53},
{0x9B9F,0x5C50},
{0x9BA0,0x5C4F},
{0x9BA1,0x5B71},
{0x9BA2,0x5C6C},
{0x9BA3,0x5C6E},
{0x9BA4,0x4E62},
{0x9BA5,0x5C76},
{0x9BA6,0x5C79},
{0x9BA7,0x5C8C},
{0x9BA8,0x5C91},
{0x9BA9,0x5C94},
{0x9BAA,0x599B},
{0x9BAB,0x5CAB},
{0x9BAC,0x5CBB},
{0x9BAD,0x5CB6},
{0x9BAE,0x5CBC},
{0x9BAF,0x5CB7},
{0x9BB0,0x5CC5},
{0x9BB1,0x5CBE},
{0x9BB2,0x5CC7},
{0x9BB3,0x5CD9},
{0x9BB4,0x5CE9},
{0x9BB5,0x5CFD},
{0x9BB6,0x5CFA},
{0x9BB7,0x5CED},
{0x9BB8,0x5D8C},
{0x9BB9,0x5CEA},
{0x9BBA,0x5D0B},
{0x9BBB,0x5D15},
{0x9BBC,0x5D17},
{0x9BBD,0x5D5C},
{0x9BBE,0x5D1F},
{0x9BBF,0x5D1B},
{0x9BC0,0x5D11},
{0x9BC1,0x5D14},
{0x9BC2,0x5D22},
{0x9BC3,0x5D1A},
{0x9BC4,0x5D19},
{0x9BC5,0x5D18},
{0x9BC6,0x5D4C},
{0x9BC7,0x5D52},
{0x9BC8,0x5D4E},
{0x9BC9,0x5D4B},
{0x9BCA,0x5D6C},
{0x9BCB,0x5D73},
{0x9BCC,0x5D76},
{0x9BCD,0x5D87},
{0x9BCE,0x5D84},
{0x9BCF,0x5D82},
{0x9BD0,0x5DA2},
{0x9BD1,0x5D9D},
{0x9BD2,0x5DAC},
{0x9BD3,0x5DAE},
{0x9BD4,0x5DBD},
{0x9BD5,0x5D90},
{0x9BD6,0x5DB7},
{0x9BD7,0x5DBC},
{0x9BD8,0x5DC9},
{0x9BD9,0x5DCD},
{0x9BDA,0x5DD3},
{0x9BDB,0x5DD2},
{0x9BDC,0x5DD6},
{0x9BDD,0x5DDB},
{0x9BDE,0x5DEB},
{0x9BDF,0x5DF2},
{0x9BE0,0x5DF5},
{0x9BE1,0x5E0B},
{0x9BE2,0x5E1A},
{0x9BE3,0x5E19},
{0x9BE4,0x5E11},
{0x9BE5,0x5E1B},
{0x9BE6,0x5E36},
{0x9BE7,0x5E37},
{0x9BE8,0x5E44},
{0x9BE9,0x5E43},
{0x9BEA,0x5E40},
{0x9BEB,0x5E4E},
{0x9BEC,0x5E57},
{0x9BED,0x5E54},
{0x9BEE,0x5E5F},
{0x9BEF,0x5E62},
{0x9BF0,0x5E64},
{0x9BF1,0x5E47},
{0x9BF2,0x5E75},
{0x9BF3,0x5E76},
{0x9BF4,0x5E7A},
{0x9BF5,0x9EBC},
{0x9BF6,0x5E7F},
{0x9BF7,0x5EA0},
{0x9BF8,0x5EC1},
{0x9BF9,0x5EC2},
{0x9BFA,0x5EC8},
{0x9BFB,0x5ED0},
{0x9BFC,0x5ECF},
{0x9C40,0x5ED6},
{0x9C41,0x5EE3},
{0x9C42,0x5EDD},
{0x9C43,0x5EDA},
{0x9C44,0x5EDB},
{0x9C45,0x5EE2},
{0x9C46,0x5EE1},
{0x9C47,0x5EE8},
{0x9C48,0x5EE9},
{0x9C49,0x5EEC},
{0x9C4A,0x5EF1},
{0x9C4B,0x5EF3},
{0x9C4C,0x5EF0},
{0x9C4D,0x5EF4},
{0x9C4E,0x5EF8},
{0x9C4F,0x5EFE},
{0x9C50,0x5F03},
{0x9C51,0x5F09},
{0x9C52,0x5F5D},
{0x9C53,0x5F5C},
{0x9C54,0x5F0B},
{0x9C55,0x5F11},
{0x9C56,0x5F16},
{0x9C57,0x5F29},
{0x9C58,0x5F2D},
{0x9C59,0x5F38},
{0x9C5A,0x5F41},
{0x9C5B,0x5F48},
{0x9C5C,0x5F4C},
{0x9C5D,0x5F4E},
{0x9C5E,0x5F2F},
{0x9C5F,0x5F51},
{0x9C60,0x5F56},
{0x9C61,0x5F57},
{0x9C62,0x5F59},
{0x9C63,0x5F61},
{0x9C64,0x5F6D},
{0x9C65,0x5F73},
{0x9C66,0x5F77},
{0x9C67,0x5F83},
{0x9C68,0x5F82},
{0x9C69,0x5F7F},
{0x9C6A,0x5F8A},
{0x9C6B,0x5F88},
{0x9C6C,0x5F91},
{0x9C6D,0x5F87},
{0x9C6E,0x5F9E},
{0x9C6F,0x5F99},
{0x9C70,0x5F98},
{0x9C71,0x5FA0},
{0x9C72,0x5FA8},
{0x9C73,0x5FAD},
{0x9C74,0x5FBC},
{0x9C75,0x5FD6},
{0x9C76,0x5FFB},
{0x9C77,0x5FE4},
{0x9C78,0x5FF8},
{0x9C79,0x5FF1},
{0x9C7A,0x5FDD},
{0x9C7B,0x60B3},
{0x9C7C,0x5FFF},
{0x9C7D,0x6021},
{0x9C7E,0x6060},
{0x9C80,0x6019},
{0x9C81,0x6010},
{0x9C82,0x6029},
{0x9C83,0x600E},
{0x9C84,0x6031},
{0x9C85,0x601B},
{0x9C86,0x6015},
{0x9C87,0x602B},
{0x9C88,0x6026},
{0x9C89,0x600F},
{0x9C8A,0x603A},
{0x9C8B,0x605A},
{0x9C8C,0x6041},
{0x9C8D,0x606A},
{0x9C8E,0x6077},
{0x9C8F,0x605F},
{0x9C90,0x604A},
{0x9C91,0x6046},
{0x9C92,0x604D},
{0x9C93,0x6063},
{0x9C94,0x6043},
{0x9C95,0x6064},
{0x9C96,0x6042},
{0x9C97,0x606C},
{0x9C98,0x606B},
{0x9C99,0x6059},
{0x9C9A,0x6081},
{0x9C9B,0x608D},
{0x9C9C,0x60E7},
{0x9C9D,0x6083},
{0x9C9E,0x609A},
{0x9C9F,0x6084},
{0x9CA0,0x609B},
{0x9CA1,0x6096},
{0x9CA2,0x6097},
{0x9CA3,0x6092},
{0x9CA4,0x60A7},
{0x9CA5,0x608B},
{0x9CA6,0x60E1},
{0x9CA7,0x60B8},
{0x9CA8,0x60E0},
{0x9CA9,0x60D3},
{0x9CAA,0x60B4},
{0x9CAB,0x5FF0},
{0x9CAC,0x60BD},
{0x9CAD,0x60C6},
{0x9CAE,0x60B5},
{0x9CAF,0x60D8},
{0x9CB0,0x614D},
{0x9CB1,0x6115},
{0x9CB2,0x6106},
{0x9CB3,0x60F6},
{0x9CB4,0x60F7},
{0x9CB5,0x6100},
{0x9CB6,0x60F4},
{0x9CB7,0x60FA},
{0x9CB8,0x6103},
{0x9CB9,0x6121},
{0x9CBA,0x60FB},
{0x9CBB,0x60F1},
{0x9CBC,0x610D},
{0x9CBD,0x610E},
{0x9CBE,0x6147},
{0x9CBF,0x613E},
{0x9CC0,0x6128},
{0x9CC1,0x6127},
{0x9CC2,0x614A},
{0x9CC3,0x613F},
{0x9CC4,0x613C},
{0x9CC5,0x612C},
{0x9CC6,0x6134},
{0x9CC7,0x613D},
{0x9CC8,0x6142},
{0x9CC9,0x6144},
{0x9CCA,0x6173},
{0x9CCB,0x6177},
{0x9CCC,0x6158},
{0x9CCD,0x6159},
{0x9CCE,0x615A},
{0x9CCF,0x616B},
{0x9CD0,0x6174},
{0x9CD1,0x616F},
{0x9CD2,0x6165},
{0x9CD3,0x6171},
{0x9CD4,0x615F},
{0x9CD5,0x615D},
{0x9CD6,0x6153},
{0x9CD7,0x6175},
{0x9CD8,0x6199},
{0x9CD9,0x6196},
{0x9CDA,0x6187},
{0x9CDB,0x61AC},
{0x9CDC,0x6194},
{0x9CDD,0x619A},
{0x9CDE,0x618A},
{0x9CDF,0x6191},
{0x9CE0,0x61AB},
{0x9CE1,0x61AE},
{0x9CE2,0x61CC},
{0x9CE3,0x61CA},
{0x9CE4,0x61C9},
{0x9CE5,0x61F7},
{0x9CE6,0x61C8},
{0x9CE7,0x61C3},
{0x9CE8,0x61C6},
{0x9CE9,0x61BA},
{0x9CEA,0x61CB},
{0x9CEB,0x7F79},
{0x9CEC,0x61CD},
{0x9CED,0x61E6},
{0x9CEE,0x61E3},
{0x9CEF,0x61F6},
{0x9CF0,0x61FA},
{0x9CF1,0x61F4},
{0x9CF2,0x61FF},
{0x9CF3,0x61FD},
{0x9CF4,0x61FC},
{0x9CF5,0x61FE},
{0x9CF6,0x6200},
{0x9CF7,0x6208},
{0x9CF8,0x6209},
{0x9CF9,0x620D},
{0x9CFA,0x620C},
{0x9CFB,0x6214},
{0x9CFC,0x621B},
{0x9D40,0x621E},
{0x9D41,0x6221},
{0x9D42,0x622A},
{0x9D43,0x622E},
{0x9D44,0x6230},
{0x9D45,0x6232},
{0x9D46,0x6233},
{0x9D47,0x6241},
{0x9D48,0x624E},
{0x9D49,0x625E},
{0x9D4A,0x6263},
{0x9D4B,0x625B},
{0x9D4C,0x6260},
{0x9D4D,0x6268},
{0x9D4E,0x627C},
{0x9D4F,0x6282},
{0x9D50,0x6289},
{0x9D51,0x627E},
{0x9D52,0x6292},
{0x9D53,0x6293},
{0x9D54,0x6296},
{0x9D55,0x62D4},
{0x9D56,0x6283},
{0x9D57,0x6294},
{0x9D58,0x62D7},
{0x9D59,0x62D1},
{0x9D5A,0x62BB},
{0x9D5B,0x62CF},
{0x9D5C,0x62FF},
{0x9D5D,0x62C6},
{0x9D5E,0x64D4},
{0x9D5F,0x62C8},
{0x9D60,0x62DC},
{0x9D61,0x62CC},
{0x9D62,0x62CA},
{0x9D63,0x62C2},
{0x9D64,0x62C7},
{0x9D65,0x629B},
{0x9D66,0x62C9},
{0x9D67,0x630C},
{0x9D68,0x62EE},
{0x9D69,0x62F1},
{0x9D6A,0x6327},
{0x9D6B,0x6302},
{0x9D6C,0x6308},
{0x9D6D,0x62EF},
{0x9D6E,0x62F5},
{0x9D6F,0x6350},
{0x9D70,0x633E},
{0x9D71,0x634D},
{0x9D72,0x641C},
{0x9D73,0x634F},
{0x9D74,0x6396},
{0x9D75,0x638E},
{0x9D76,0x6380},
{0x9D77,0x63AB},
{0x9D78,0x6376},
{0x9D79,0x63A3},
{0x9D7A,0x638F},
{0x9D7B,0x6389},
{0x9D7C,0x639F},
{0x9D7D,0x63B5},
{0x9D7E,0x636B},
{0x9D80,0x6369},
{0x9D81,0x63BE},
{0x9D82,0x63E9},
{0x9D83,0x63C0},
{0x9D84,0x63C6},
{0x9D85,0x63E3},
{0x9D86,0x63C9},
{0x9D87,0x63D2},
{0x9D88,0x63F6},
{0x9D89,0x63C4},
{0x9D8A,0x6416},
{0x9D8B,0x6434},
{0x9D8C,0x6406},
{0x9D8D,0x6413},
{0x9D8E,0x6426},
{0x9D8F,0x6436},
{0x9D90,0x651D},
{0x9D91,0x6417},
{0x9D92,0x6428},
{0x9D93,0x640F},
{0x9D94,0x6467},
{0x9D95,0x646F},
{0x9D96,0x6476},
{0x9D97,0x644E},
{0x9D98,0x652A},
{0x9D99,0x6495},
{0x9D9A,0x6493},
{0x9D9B,0x64A5},
{0x9D9C,0x64A9},
{0x9D9D,0x6488},
{0x9D9E,0x64BC},
{0x9D9F,0x64DA},
{0x9DA0,0x64D2},
{0x9DA1,0x64C5},
{0x9DA2,0x64C7},
{0x9DA3,0x64BB},
{0x9DA4,0x64D8},
{0x9DA5,0x64C2},
{0x9DA6,0x64F1},
{0x9DA7,0x64E7},
{0x9DA8,0x8209},
{0x9DA9,0x64E0},
{0x9DAA,0x64E1},
{0x9DAB,0x62AC},
{0x9DAC,0x64E3},
{0x9DAD,0x64EF},
{0x9DAE,0x652C},
{0x9DAF,0x64F6},
{0x9DB0,0x64F4},
{0x9DB1,0x64F2},
{0x9DB2,0x64FA},
{0x9DB3,0x6500},
{0x9DB4,0x64FD},
{0x9DB5,0x6518},
{0x9DB6,0x651C},
{0x9DB7,0x6505},
{0x9DB8,0x6524},
{0x9DB9,0x6523},
{0x9DBA,0x652B},
{0x9DBB,0x6534},
{0x9DBC,0x6535},
{0x9DBD,0x6537},
{0x9DBE,0x6536},
{0x9DBF,0x6538},
{0x9DC0,0x754B},
{0x9DC1,0x6548},
{0x9DC2,0x6556},
{0x9DC3,0x6555},
{0x9DC4,0x654D},
{0x9DC5,0x6558},
{0x9DC6,0x655E},
{0x9DC7,0x655D},
{0x9DC8,0x6572},
{0x9DC9,0x6578},
{0x9DCA,0x6582},
{0x9DCB,0x6583},
{0x9DCC,0x8B8A},
{0x9DCD,0x659B},
{0x9DCE,0x659F},
{0x9DCF,0x65AB},
{0x9DD0,0x65B7},
{0x9DD1,0x65C3},
{0x9DD2,0x65C6},
{0x9DD3,0x65C1},
{0x9DD4,0x65C4},
{0x9DD5,0x65CC},
{0x9DD6,0x65D2},
{0x9DD7,0x65DB},
{0x9DD8,0x65D9},
{0x9DD9,0x65E0},
{0x9DDA,0x65E1},
{0x9DDB,0x65F1},
{0x9DDC,0x6772},
{0x9DDD,0x660A},
{0x9DDE,0x6603},
{0x9DDF,0x65FB},
{0x9DE0,0x6773},
{0x9DE1,0x6635},
{0x9DE2,0x6636},
{0x9DE3,0x6634},
{0x9DE4,0x661C},
{0x9DE5,0x664F},
{0x9DE6,0x6644},
{0x9DE7,0x6649},
{0x9DE8,0x6641},
{0x9DE9,0x665E},
{0x9DEA,0x665D},
{0x9DEB,0x6664},
{0x9DEC,0x6667},
{0x9DED,0x6668},
{0x9DEE,0x665F},
{0x9DEF,0x6662},
{0x9DF0,0x6670},
{0x9DF1,0x6683},
{0x9DF2,0x6688},
{0x9DF3,0x668E},
{0x9DF4,0x6689},
{0x9DF5,0x6684},
{0x9DF6,0x6698},
{0x9DF7,0x669D},
{0x9DF8,0x66C1},
{0x9DF9,0x66B9},
{0x9DFA,0x66C9},
{0x9DFB,0x66BE},
{0x9DFC,0x66BC},
{0x9E40,0x66C4},
{0x9E41,0x66B8},
{0x9E42,0x66D6},
{0x9E43,0x66DA},
{0x9E44,0x66E0},
{0x9E45,0x663F},
{0x9E46,0x66E6},
{0x9E47,0x66E9},
{0x9E48,0x66F0},
{0x9E49,0x66F5},
{0x9E4A,0x66F7},
{0x9E4B,0x670F},
{0x9E4C,0x6716},
{0x9E4D,0x671E},
{0x9E4E,0x6726},
{0x9E4F,0x6727},
{0x9E50,0x9738},
{0x9E51,0x672E},
{0x9E52,0x673F},
{0x9E53,0x6736},
{0x9E54,0x6741},
{0x9E55,0x6738},
{0x9E56,0x6737},
{0x9E57,0x6746},
{0x9E58,0x675E},
{0x9E59,0x6760},
{0x9E5A,0x6759},
{0x9E5B,0x6763},
{0x9E5C,0x6764},
{0x9E5D,0x6789},
{0x9E5E,0x6770},
{0x9E5F,0x67A9},
{0x9E60,0x677C},
{0x9E61,0x676A},
{0x9E62,0x678C},
{0x9E63,0x678B},
{0x9E64,0x67A6},
{0x9E65,0x67A1},
{0x9E66,0x6785},
{0x9E67,0x67B7},
{0x9E68,0x67EF},
{0x9E69,0x67B4},
{0x9E6A,0x67EC},
{0x9E6B,0x67B3},
{0x9E6C,0x67E9},
{0x9E6D,0x67B8},
{0x9E6E,0x67E4},
{0x9E6F,0x67DE},
{0x9E70,0x67DD},
{0x9E71,0x67E2},
{0x9E72,0x67EE},
{0x9E73,0x67B9},
{0x9E74,0x67CE},
{0x9E75,0x67C6},
{0x9E76,0x67E7},
{0x9E77,0x6A9C},
{0x9E78,0x681E},
{0x9E79,0x6846},
{0x9E7A,0x6829},
{0x9E7B,0x6840},
{0x9E7C,0x684D},
{0x9E7D,0x6832},
{0x9E7E,0x684E},
{0x9E80,0x68B3},
{0x9E81,0x682B},
{0x9E82,0x6859},
{0x9E83,0x6863},
{0x9E84,0x6877},
{0x9E85,0x687F},
{0x9E86,0x689F},
{0x9E87,0x688F},
{0x9E88,0x68AD},
{0x9E89,0x6894},
{0x9E8A,0x689D},
{0x9E8B,0x689B},
{0x9E8C,0x6883},
{0x9E8D,0x6AAE},
{0x9E8E,0x68B9},
{0x9E8F,0x6874},
{0x9E90,0x68B5},
{0x9E91,0x68A0},
{0x9E92,0x68BA},
{0x9E93,0x690F},
{0x9E94,0x688D},
{0x9E95,0x687E},
{0x9E96,0x6901},
{0x9E97,0x68CA},
{0x9E98,0x6908},
{0x9E99,0x68D8},
{0x9E9A,0x6922},
{0x9E9B,0x6926},
{0x9E9C,0x68E1},
{0x9E9D,0x690C},
{0x9E9E,0x68CD},
{0x9E9F,0x68D4},
{0x9EA0,0x68E7},
{0x9EA1,0x68D5},
{0x9EA2,0x6936},
{0x9EA3,0x6912},
{0x9EA4,0x6904},
{0x9EA5,0x68D7},
{0x9EA6,0x68E3},
{0x9EA7,0x6925},
{0x9EA8,0x68F9},
{0x9EA9,0x68E0},
{0x9EAA,0x68EF},
{0x9EAB,0x6928},
{0x9EAC,0x692A},
{0x9EAD,0x691A},
{0x9EAE,0x6923},
{0x9EAF,0x6921},
{0x9EB0,0x68C6},
{0x9EB1,0x6979},
{0x9EB2,0x6977},
{0x9EB3,0x695C},
{0x9EB4,0x6978},
{0x9EB5,0x696B},
{0x9EB6,0x6954},
{0x9EB7,0x697E},
{0x9EB8,0x696E},
{0x9EB9,0x6939},
{0x9EBA,0x6974},
{0x9EBB,0x693D},
{0x9EBC,0x6959},
{0x9EBD,0x6930},
{0x9EBE,0x6961},
{0x9EBF,0x695E},
{0x9EC0,0x695D},
{0x9EC1,0x6981},
{0x9EC2,0x696A},
{0x9EC3,0x69B2},
{0x9EC4,0x69AE},
{0x9EC5,0x69D0},
{0x9EC6,0x69BF},
{0x9EC7,0x69C1},
{0x9EC8,0x69D3},
{0x9EC9,0x69BE},
{0x9ECA,0x69CE},
{0x9ECB,0x5BE8},
{0x9ECC,0x69CA},
{0x9ECD,0x69DD},
{0x9ECE,0x69BB},
{0x9ECF,0x69C3},
{0x9ED0,0x69A7},
{0x9ED1,0x6A2E},
{0x9ED2,0x6991},
{0x9ED3,0x69A0},
{0x9ED4,0x699C},
{0x9ED5,0x6995},
{0x9ED6,0x69B4},
{0x9ED7,0x69DE},
{0x9ED8,0x69E8},
{0x9ED9,0x6A02},
{0x9EDA,0x6A1B},
{0x9EDB,0x69FF},
{0x9EDC,0x6B0A},
{0x9EDD,0x69F9},
{0x9EDE,0x69F2},
{0x9EDF,0x69E7},
{0x9EE0,0x6A05},
{0x9EE1,0x69B1},
{0x9EE2,0x6A1E},
{0x9EE3,0x69ED},
{0x9EE4,0x6A14},
{0x9EE5,0x69EB},
{0x9EE6,0x6A0A},
{0x9EE7,0x6A12},
{0x9EE8,0x6AC1},
{0x9EE9,0x6A23},
{0x9EEA,0x6A13},
{0x9EEB,0x6A44},
{0x9EEC,0x6A0C},
{0x9EED,0x6A72},
{0x9EEE,0x6A36},
{0x9EEF,0x6A78},
{0x9EF0,0x6A47},
{0x9EF1,0x6A62},
{0x9EF2,0x6A59},
{0x9EF3,0x6A66},
{0x9EF4,0x6A48},
{0x9EF5,0x6A38},
{0x9EF6,0x6A22},
{0x9EF7,0x6A90},
{0x9EF8,0x6A8D},
{0x9EF9,0x6AA0},
{0x9EFA,0x6A84},
{0x9EFB,0x6AA2},
{0x9EFC,0x6AA3},
{0x9F40,0x6A97},
{0x9F41,0x8617},
{0x9F42,0x6ABB},
{0x9F43,0x6AC3},
{0x9F44,0x6AC2},
{0x9F45,0x6AB8},
{0x9F46,0x6AB3},
{0x9F47,0x6AAC},
{0x9F48,0x6ADE},
{0x9F49,0x6AD1},
{0x9F4A,0x6ADF},
{0x9F4B,0x6AAA},
{0x9F4C,0x6ADA},
{0x9F4D,0x6AEA},
{0x9F4E,0x6AFB},
{0x9F4F,0x6B05},
{0x9F50,0x8616},
{0x9F51,0x6AFA},
{0x9F52,0x6B12},
{0x9F53,0x6B16},
{0x9F54,0x9B31},
{0x9F55,0x6B1F},
{0x9F56,0x6B38},
{0x9F57,0x6B37},
{0x9F58,0x76DC},
{0x9F59,0x6B39},
{0x9F5A,0x98EE},
{0x9F5B,0x6B47},
{0x9F5C,0x6B43},
{0x9F5D,0x6B49},
{0x9F5E,0x6B50},
{0x9F5F,0x6B59},
{0x9F60,0x6B54},
{0x9F61,0x6B5B},
{0x9F62,0x6B5F},
{0x9F63,0x6B61},
{0x9F64,0x6B78},
{0x9F65,0x6B79},
{0x9F66,0x6B7F},
{0x9F67,0x6B80},
{0x9F68,0x6B84},
{0x9F69,0x6B83},
{0x9F6A,0x6B8D},
{0x9F6B,0x6B98},
{0x9F6C,0x6B95},
{0x9F6D,0x6B9E},
{0x9F6E,0x6BA4},
{0x9F6F,0x6BAA},
{0x9F70,0x6BAB},
{0x9F71,0x6BAF},
{0x9F72,0x6BB2},
{0x9F73,0x6BB1},
{0x9F74,0x6BB3},
{0x9F75,0x6BB7},
{0x9F76,0x6BBC},
{0x9F77,0x6BC6},
{0x9F78,0x6BCB},
{0x9F79,0x6BD3},
{0x9F7A,0x6BDF},
{0x9F7B,0x6BEC},
{0x9F7C,0x6BEB},
{0x9F7D,0x6BF3},
{0x9F7E,0x6BEF},
{0x9F80,0x9EBE},
{0x9F81,0x6C08},
{0x9F82,0x6C13},
{0x9F83,0x6C14},
{0x9F84,0x6C1B},
{0x9F85,0x6C24},
{0x9F86,0x6C23},
{0x9F87,0x6C5E},
{0x9F88,0x6C55},
{0x9F89,0x6C62},
{0x9F8A,0x6C6A},
{0x9F8B,0x6C82},
{0x9F8C,0x6C8D},
{0x9F8D,0x6C9A},
{0x9F8E,0x6C81},
{0x9F8F,0x6C9B},
{0x9F90,0x6C7E},
{0x9F91,0x6C68},
{0x9F92,0x6C73},
{0x9F93,0x6C92},
{0x9F94,0x6C90},
{0x9F95,0x6CC4},
{0x9F96,0x6CF1},
{0x9F97,0x6CD3},
{0x9F98,0x6CBD},
{0x9F99,0x6CD7},
{0x9F9A,0x6CC5},
{0x9F9B,0x6CDD},
{0x9F9C,0x6CAE},
{0x9F9D,0x6CB1},
{0x9F9E,0x6CBE},
{0x9F9F,0x6CBA},
{0x9FA0,0x6CDB},
{0x9FA1,0x6CEF},
{0x9FA2,0x6CD9},
{0x9FA3,0x6CEA},
{0x9FA4,0x6D1F},
{0x9FA5,0x884D},
{0x9FA6,0x6D36},
{0x9FA7,0x6D2B},
{0x9FA8,0x6D3D},
{0x9FA9,0x6D38},
{0x9FAA,0x6D19},
{0x9FAB,0x6D35},
{0x9FAC,0x6D33},
{0x9FAD,0x6D12},
{0x9FAE,0x6D0C},
{0x9FAF,0x6D63},
{0x9FB0,0x6D93},
{0x9FB1,0x6D64},
{0x9FB2,0x6D5A},
{0x9FB3,0x6D79},
{0x9FB4,0x6D59},
{0x9FB5,0x6D8E},
{0x9FB6,0x6D95},
{0x9FB7,0x6FE4},
{0x9FB8,0x6D85},
{0x9FB9,0x6DF9},
{0x9FBA,0x6E15},
{0x9FBB,0x6E0A},
{0x9FBC,0x6DB5},
{0x9FBD,0x6DC7},
{0x9FBE,0x6DE6},
{0x9FBF,0x6DB8},
{0x9FC0,0x6DC6},
{0x9FC1,0x6DEC},
{0x9FC2,0x6DDE},
{0x9FC3,0x6DCC},
{0x9FC4,0x6DE8},
{0x9FC5,0x6DD2},
{0x9FC6,0x6DC5},
{0x9FC7,0x6DFA},
{0x9FC8,0x6DD9},
{0x9FC9,0x6DE4},
{0x9FCA,0x6DD5},
{0x9FCB,0x6DEA},
{0x9FCC,0x6DEE},
{0x9FCD,0x6E2D},
{0x9FCE,0x6E6E},
{0x9FCF,0x6E2E},
{0x9FD0,0x6E19},
{0x9FD1,0x6E72},
{0x9FD2,0x6E5F},
{0x9FD3,0x6E3E},
{0x9FD4,0x6E23},
{0x9FD5,0x6E6B},
{0x9FD6,0x6E2B},
{0x9FD7,0x6E76},
{0x9FD8,0x6E4D},
{0x9FD9,0x6E1F},
{0x9FDA,0x6E43},
{0x9FDB,0x6E3A},
{0x9FDC,0x6E4E},
{0x9FDD,0x6E24},
{0x9FDE,0x6EFF},
{0x9FDF,0x6E1D},
{0x9FE0,0x6E38},
{0x9FE1,0x6E82},
{0x9FE2,0x6EAA},
{0x9FE3,0x6E98},
{0x9FE4,0x6EC9},
{0x9FE5,0x6EB7},
{0x9FE6,0x6ED3},
{0x9FE7,0x6EBD},
{0x9FE8,0x6EAF},
{0x9FE9,0x6EC4},
{0x9FEA,0x6EB2},
{0x9FEB,0x6ED4},
{0x9FEC,0x6ED5},
{0x9FED,0x6E8F},
{0x9FEE,0x6EA5},
{0x9FEF,0x6EC2},
{0x9FF0,0x6E9F},
{0x9FF1,0x6F41},
{0x9FF2,0x6F11},
{0x9FF3,0x704C},
{0x9FF4,0x6EEC},
{0x9FF5,0x6EF8},
{0x9FF6,0x6EFE},
{0x9FF7,0x6F3F},
{0x9FF8,0x6EF2},
{0x9FF9,0x6F31},
{0x9FFA,0x6EEF},
{0x9FFB,0x6F32},
{0x9FFC,0x6ECC},
{0xE040,0x6F3E},
{0xE041,0x6F13},
{0xE042,0x6EF7},
{0xE043,0x6F86},
{0xE044,0x6F7A},
{0xE045,0x6F78},
{0xE046,0x6F81},
{0xE047,0x6F80},
{0xE048,0x6F6F},
{0xE049,0x6F5B},
{0xE04A,0x6FF3},
{0xE04B,0x6F6D},
{0xE04C,0x6F82},
{0xE04D,0x6F7C},
{0xE04E,0x6F58},
{0xE04F,0x6F8E},
{0xE050,0x6F91},
{0xE051,0x6FC2},
{0xE052,0x6F66},
{0xE053,0x6FB3},
{0xE054,0x6FA3},
{0xE055,0x6FA1},
{0xE056,0x6FA4},
{0xE057,0x6FB9},
{0xE058,0x6FC6},
{0xE059,0x6FAA},
{0xE05A,0x6FDF},
{0xE05B,0x6FD5},
{0xE05C,0x6FEC},
{0xE05D,0x6FD4},
{0xE05E,0x6FD8},
{0xE05F,0x6FF1},
{0xE060,0x6FEE},
{0xE061,0x6FDB},
{0xE062,0x7009},
{0xE063,0x700B},
{0xE064,0x6FFA},
{0xE065,0x7011},
{0xE066,0x7001},
{0xE067,0x700F},
{0xE068,0x6FFE},
{0xE069,0x701B},
{0xE06A,0x701A},
{0xE06B,0x6F74},
{0xE06C,0x701D},
{0xE06D,0x7018},
{0xE06E,0x701F},
{0xE06F,0x7030},
{0xE070,0x703E},
{0xE071,0x7032},
{0xE072,0x7051},
{0xE073,0x7063},
{0xE074,0x7099},
{0xE075,0x7092},
{0xE076,0x70AF},
{0xE077,0x70F1},
{0xE078,0x70AC},
{0xE079,0x70B8},
{0xE07A,0x70B3},
{0xE07B,0x70AE},
{0xE07C,0x70DF},
{0xE07D,0x70CB},
{0xE07E,0x70DD},
{0xE080,0x70D9},
{0xE081,0x7109},
{0xE082,0x70FD},
{0xE083,0x711C},
{0xE084,0x7119},
{0xE085,0x7165},
{0xE086,0x7155},
{0xE087,0x7188},
{0xE088,0x7166},
{0xE089,0x7162},
{0xE08A,0x714C},
{0xE08B,0x7156},
{0xE08C,0x716C},
{0xE08D,0x718F},
{0xE08E,0x71FB},
{0xE08F,0x7184},
{0xE090,0x7195},
{0xE091,0x71A8},
{0xE092,0x71AC},
{0xE093,0x71D7},
{0xE094,0x71B9},
{0xE095,0x71BE},
{0xE096,0x71D2},
{0xE097,0x71C9},
{0xE098,0x71D4},
{0xE099,0x71CE},
{0xE09A,0x71E0},
{0xE09B,0x71EC},
{0xE09C,0x71E7},
{0xE09D,0x71F5},
{0xE09E,0x71FC},
{0xE09F,0x71F9},
{0xE0A0,0x71FF},
{0xE0A1,0x720D},
{0xE0A2,0x7210},
{0xE0A3,0x721B},
{0xE0A4,0x7228},
{0xE0A5,0x722D},
{0xE0A6,0x722C},
{0xE0A7,0x7230},
{0xE0A8,0x7232},
{0xE0A9,0x723B},
{0xE0AA,0x723C},
{0xE0AB,0x723F},
{0xE0AC,0x7240},
{0xE0AD,0x7246},
{0xE0AE,0x724B},
{0xE0AF,0x7258},
{0xE0B0,0x7274},
{0xE0B1,0x727E},
{0xE0B2,0x7282},
{0xE0B3,0x7281},
{0xE0B4,0x7287},
{0xE0B5,0x7292},
{0xE0B6,0x7296},
{0xE0B7,0x72A2},
{0xE0B8,0x72A7},
{0xE0B9,0x72B9},
{0xE0BA,0x72B2},
{0xE0BB,0x72C3},
{0xE0BC,0x72C6},
{0xE0BD,0x72C4},
{0xE0BE,0x72CE},
{0xE0BF,0x72D2},
{0xE0C0,0x72E2},
{0xE0C1,0x72E0},
{0xE0C2,0x72E1},
{0xE0C3,0x72F9},
{0xE0C4,0x72F7},
{0xE0C5,0x500F},
{0xE0C6,0x7317},
{0xE0C7,0x730A},
{0xE0C8,0x731C},
{0xE0C9,0x7316},
{0xE0CA,0x731D},
{0xE0CB,0x7334},
{0xE0CC,0x732F},
{0xE0CD,0x7329},
{0xE0CE,0x7325},
{0xE0CF,0x733E},
{0xE0D0,0x734E},
{0xE0D1,0x734F},
{0xE0D2,0x9ED8},
{0xE0D3,0x7357},
{0xE0D4,0x736A},
{0xE0D5,0x7368},
{0xE0D6,0x7370},
{0xE0D7,0x7378},
{0xE0D8,0x7375},
{0xE0D9,0x737B},
{0xE0DA,0x737A},
{0xE0DB,0x73C8},
{0xE0DC,0x73B3},
{0xE0DD,0x73CE},
{0xE0DE,0x73BB},
{0xE0DF,0x73C0},
{0xE0E0,0x73E5},
{0xE0E1,0x73EE},
{0xE0E2,0x73DE},
{0xE0E3,0x74A2},
{0xE0E4,0x7405},
{0xE0E5,0x746F},
{0xE0E6,0x7425},
{0xE0E7,0x73F8},
{0xE0E8,0x7432},
{0xE0E9,0x743A},
{0xE0EA,0x7455},
{0xE0EB,0x743F},
{0xE0EC,0x745F},
{0xE0ED,0x7459},
{0xE0EE,0x7441},
{0xE0EF,0x745C},
{0xE0F0,0x7469},
{0xE0F1,0x7470},
{0xE0F2,0x7463},
{0xE0F3,0x746A},
{0xE0F4,0x7476},
{0xE0F5,0x747E},
{0xE0F6,0x748B},
{0xE0F7,0x749E},
{0xE0F8,0x74A7},
{0xE0F9,0x74CA},
{0xE0FA,0x74CF},
{0xE0FB,0x74D4},
{0xE0FC,0x73F1},
{0xE140,0x74E0},
{0xE141,0x74E3},
{0xE142,0x74E7},
{0xE143,0x74E9},
{0xE144,0x74EE},
{0xE145,0x74F2},
{0xE146,0x74F0},
{0xE147,0x74F1},
{0xE148,0x74F8},
{0xE149,0x74F7},
{0xE14A,0x7504},
{0xE14B,0x7503},
{0xE14C,0x7505},
{0xE14D,0x750C},
{0xE14E,0x750E},
{0xE14F,0x750D},
{0xE150,0x7515},
{0xE151,0x7513},
{0xE152,0x751E},
{0xE153,0x7526},
{0xE154,0x752C},
{0xE155,0x753C},
{0xE156,0x7544},
{0xE157,0x754D},
{0xE158,0x754A},
{0xE159,0x7549},
{0xE15A,0x755B},
{0xE15B,0x7546},
{0xE15C,0x755A},
{0xE15D,0x7569},
{0xE15E,0x7564},
{0xE15F,0x7567},
{0xE160,0x756B},
{0xE161,0x756D},
{0xE162,0x7578},
{0xE163,0x7576},
{0xE164,0x7586},
{0xE165,0x7587},
{0xE166,0x7574},
{0xE167,0x758A},
{0xE168,0x7589},
{0xE169,0x7582},
{0xE16A,0x7594},
{0xE16B,0x759A},
{0xE16C,0x759D},
{0xE16D,0x75A5},
{0xE16E,0x75A3},
{0xE16F,0x75C2},
{0xE170,0x75B3},
{0xE171,0x75C3},
{0xE172,0x75B5},
{0xE173,0x75BD},
{0xE174,0x75B8},
{0xE175,0x75BC},
{0xE176,0x75B1},
{0xE177,0x75CD},
{0xE178,0x75CA},
{0xE179,0x75D2},
{0xE17A,0x75D9},
{0xE17B,0x75E3},
{0xE17C,0x75DE},
{0xE17D,0x75FE},
{0xE17E,0x75FF},
{0xE180,0x75FC},
{0xE181,0x7601},
{0xE182,0x75F0},
{0xE183,0x75FA},
{0xE184,0x75F2},
{0xE185,0x75F3},
{0xE186,0x760B},
{0xE187,0x760D},
{0xE188,0x7609},
{0xE189,0x761F},
{0xE18A,0x7627},
{0xE18B,0x7620},
{0xE18C,0x7621},
{0xE18D,0x7622},
{0xE18E,0x7624},
{0xE18F,0x7634},
{0xE190,0x7630},
{0xE191,0x763B},
{0xE192,0x7647},
{0xE193,0x7648},
{0xE194,0x7646},
{0xE195,0x765C},
{0xE196,0x7658},
{0xE197,0x7661},
{0xE198,0x7662},
{0xE199,0x7668},
{0xE19A,0x7669},
{0xE19B,0x766A},
{0xE19C,0x7667},
{0xE19D,0x766C},
{0xE19E,0x7670},
{0xE19F,0x7672},
{0xE1A0,0x7676},
{0xE1A1,0x7678},
{0xE1A2,0x767C},
{0xE1A3,0x7680},
{0xE1A4,0x7683},
{0xE1A5,0x7688},
{0xE1A6,0x768B},
{0xE1A7,0x768E},
{0xE1A8,0x7696},
{0xE1A9,0x7693},
{0xE1AA,0x7699},
{0xE1AB,0x769A},
{0xE1AC,0x76B0},
{0xE1AD,0x76B4},
{0xE1AE,0x76B8},
{0xE1AF,0x76B9},
{0xE1B0,0x76BA},
{0xE1B1,0x76C2},
{0xE1B2,0x76CD},
{0xE1B3,0x76D6},
{0xE1B4,0x76D2},
{0xE1B5,0x76DE},
{0xE1B6,0x76E1},
{0xE1B7,0x76E5},
{0xE1B8,0x76E7},
{0xE1B9,0x76EA},
{0xE1BA,0x862F},
{0xE1BB,0x76FB},
{0xE1BC,0x7708},
{0xE1BD,0x7707},
{0xE1BE,0x7704},
{0xE1BF,0x7729},
{0xE1C0,0x7724},
{0xE1C1,0x771E},
{0xE1C2,0x7725},
{0xE1C3,0x7726},
{0xE1C4,0x771B},
{0xE1C5,0x7737},
{0xE1C6,0x7738},
{0xE1C7,0x7747},
{0xE1C8,0x775A},
{0xE1C9,0x7768},
{0xE1CA,0x776B},
{0xE1CB,0x775B},
{0xE1CC,0x7765},
{0xE1CD,0x777F},
{0xE1CE,0x777E},
{0xE1CF,0x7779},
{0xE1D0,0x778E},
{0xE1D1,0x778B},
{0xE1D2,0x7791},
{0xE1D3,0x77A0},
{0xE1D4,0x779E},
{0xE1D5,0x77B0},
{0xE1D6,0x77B6},
{0xE1D7,0x77B9},
{0xE1D8,0x77BF},
{0xE1D9,0x77BC},
{0xE1DA,0x77BD},
{0xE1DB,0x77BB},
{0xE1DC,0x77C7},
{0xE1DD,0x77CD},
{0xE1DE,0x77D7},
{0xE1DF,0x77DA},
{0xE1E0,0x77DC},
{0xE1E1,0x77E3},
{0xE1E2,0x77EE},
{0xE1E3,0x77FC},
{0xE1E4,0x780C},
{0xE1E5,0x7812},
{0xE1E6,0x7926},
{0xE1E7,0x7820},
{0xE1E8,0x792A},
{0xE1E9,0x7845},
{0xE1EA,0x788E},
{0xE1EB,0x7874},
{0xE1EC,0x7886},
{0xE1ED,0x787C},
{0xE1EE,0x789A},
{0xE1EF,0x788C},
{0xE1F0,0x78A3},
{0xE1F1,0x78B5},
{0xE1F2,0x78AA},
{0xE1F3,0x78AF},
{0xE1F4,0x78D1},
{0xE1F5,0x78C6},
{0xE1F6,0x78CB},
{0xE1F7,0x78D4},
{0xE1F8,0x78BE},
{0xE1F9,0x78BC},
{0xE1FA,0x78C5},
{0xE1FB,0x78CA},
{0xE1FC,0x78EC},
{0xE240,0x78E7},
{0xE241,0x78DA},
{0xE242,0x78FD},
{0xE243,0x78F4},
{0xE244,0x7907},
{0xE245,0x7912},
{0xE246,0x7911},
{0xE247,0x7919},
{0xE248,0x792C},
{0xE249,0x792B},
{0xE24A,0x7940},
{0xE24B,0x7960},
{0xE24C,0x7957},
{0xE24D,0x795F},
{0xE24E,0x795A},
{0xE24F,0x7955},
{0xE250,0x7953},
{0xE251,0x797A},
{0xE252,0x797F},
{0xE253,0x798A},
{0xE254,0x799D},
{0xE255,0x79A7},
{0xE256,0x9F4B},
{0xE257,0x79AA},
{0xE258,0x79AE},
{0xE259,0x79B3},
{0xE25A,0x79B9},
{0xE25B,0x79BA},
{0xE25C,0x79C9},
{0xE25D,0x79D5},
{0xE25E,0x79E7},
{0xE25F,0x79EC},
{0xE260,0x79E1},
{0xE261,0x79E3},
{0xE262,0x7A08},
{0xE263,0x7A0D},
{0xE264,0x7A18},
{0xE265,0x7A19},
{0xE266,0x7A20},
{0xE267,0x7A1F},
{0xE268,0x7980},
{0xE269,0x7A31},
{0xE26A,0x7A3B},
{0xE26B,0x7A3E},
{0xE26C,0x7A37},
{0xE26D,0x7A43},
{0xE26E,0x7A57},
{0xE26F,0x7A49},
{0xE270,0x7A61},
{0xE271,0x7A62},
{0xE272,0x7A69},
{0xE273,0x9F9D},
{0xE274,0x7A70},
{0xE275,0x7A79},
{0xE276,0x7A7D},
{0xE277,0x7A88},
{0xE278,0x7A97},
{0xE279,0x7A95},
{0xE27A,0x7A98},
{0xE27B,0x7A96},
{0xE27C,0x7AA9},
{0xE27D,0x7AC8},
{0xE27E,0x7AB0},
{0xE280,0x7AB6},
{0xE281,0x7AC5},
{0xE282,0x7AC4},
{0xE283,0x7ABF},
{0xE284,0x9083},
{0xE285,0x7AC7},
{0xE286,0x7ACA},
{0xE287,0x7ACD},
{0xE288,0x7ACF},
{0xE289,0x7AD5},
{0xE28A,0x7AD3},
{0xE28B,0x7AD9},
{0xE28C,0x7ADA},
{0xE28D,0x7ADD},
{0xE28E,0x7AE1},
{0xE28F,0x7AE2},
{0xE290,0x7AE6},
{0xE291,0x7AED},
{0xE292,0x7AF0},
{0xE293,0x7B02},
{0xE294,0x7B0F},
{0xE295,0x7B0A},
{0xE296,0x7B06},
{0xE297,0x7B33},
{0xE298,0x7B18},
{0xE299,0x7B19},
{0xE29A,0x7B1E},
{0xE29B,0x7B35},
{0xE29C,0x7B28},
{0xE29D,0x7B36},
{0xE29E,0x7B50},
{0xE29F,0x7B7A},
{0xE2A0,0x7B04},
{0xE2A1,0x7B4D},
{0xE2A2,0x7B0B},
{0xE2A3,0x7B4C},
{0xE2A4,0x7B45},
{0xE2A5,0x7B75},
{0xE2A6,0x7B65},
{0xE2A7,0x7B74},
{0xE2A8,0x7B67},
{0xE2A9,0x7B70},
{0xE2AA,0x7B71},
{0xE2AB,0x7B6C},
{0xE2AC,0x7B6E},
{0xE2AD,0x7B9D},
{0xE2AE,0x7B98},
{0xE2AF,0x7B9F},
{0xE2B0,0x7B8D},
{0xE2B1,0x7B9C},
{0xE2B2,0x7B9A},
{0xE2B3,0x7B8B},
{0xE2B4,0x7B92},
{0xE2B5,0x7B8F},
{0xE2B6,0x7B5D},
{0xE2B7,0x7B99},
{0xE2B8,0x7BCB},
{0xE2B9,0x7BC1},
{0xE2BA,0x7BCC},
{0xE2BB,0x7BCF},
{0xE2BC,0x7BB4},
{0xE2BD,0x7BC6},
{0xE2BE,0x7BDD},
{0xE2BF,0x7BE9},
{0xE2C0,0x7C11},
{0xE2C1,0x7C14},
{0xE2C2,0x7BE6},
{0xE2C3,0x7BE5},
{0xE2C4,0x7C60},
{0xE2C5,0x7C00},
{0xE2C6,0x7C07},
{0xE2C7,0x7C13},
{0xE2C8,0x7BF3},
{0xE2C9,0x7BF7},
{0xE2CA,0x7C17},
{0xE2CB,0x7C0D},
{0xE2CC,0x7BF6},
{0xE2CD,0x7C23},
{0xE2CE,0x7C27},
{0xE2CF,0x7C2A},
{0xE2D0,0x7C1F},
{0xE2D1,0x7C37},
{0xE2D2,0x7C2B},
{0xE2D3,0x7C3D},
{0xE2D4,0x7C4C},
{0xE2D5,0x7C43},
{0xE2D6,0x7C54},
{0xE2D7,0x7C4F},
{0xE2D8,0x7C40},
{0xE2D9,0x7C50},
{0xE2DA,0x7C58},
{0xE2DB,0x7C5F},
{0xE2DC,0x7C64},
{0xE2DD,0x7C56},
{0xE2DE,0x7C65},
{0xE2DF,0x7C6C},
{0xE2E0,0x7C75},
{0xE2E1,0x7C83},
{0xE2E2,0x7C90},
{0xE2E3,0x7CA4},
{0xE2E4,0x7CAD},
{0xE2E5,0x7CA2},
{0xE2E6,0x7CAB},
{0xE2E7,0x7CA1},
{0xE2E8,0x7CA8},
{0xE2E9,0x7CB3},
{0xE2EA,0x7CB2},
{0xE2EB,0x7CB1},
{0xE2EC,0x7CAE},
{0xE2ED,0x7CB9},
{0xE2EE,0x7CBD},
{0xE2EF,0x7CC0},
{0xE2F0,0x7CC5},
{0xE2F1,0x7CC2},
{0xE2F2,0x7CD8},
{0xE2F3,0x7CD2},
{0xE2F4,0x7CDC},
{0xE2F5,0x7CE2},
{0xE2F6,0x9B3B},
{0xE2F7,0x7CEF},
{0xE2F8,0x7CF2},
{0xE2F9,0x7CF4},
{0xE2FA,0x7CF6},
{0xE2FB,0x7CFA},
{0xE2FC,0x7D06},
{0xE340,0x7D02},
{0xE341,0x7D1C},
{0xE342,0x7D15},
{0xE343,0x7D0A},
{0xE344,0x7D45},
{0xE345,0x7D4B},
{0xE346,0x7D2E},
{0xE347,0x7D32},
{0xE348,0x7D3F},
{0xE349,0x7D35},
{0xE34A,0x7D46},
{0xE34B,0x7D73},
{0xE34C,0x7D56},
{0xE34D,0x7D4E},
{0xE34E,0x7D72},
{0xE34F,0x7D68},
{0xE350,0x7D6E},
{0xE351,0x7D4F},
{0xE352,0x7D63},
{0xE353,0x7D93},
{0xE354,0x7D89},
{0xE355,0x7D5B},
{0xE356,0x7D8F},
{0xE357,0x7D7D},
{0xE358,0x7D9B},
{0xE359,0x7DBA},
{0xE35A,0x7DAE},
{0xE35B,0x7DA3},
{0xE35C,0x7DB5},
{0xE35D,0x7DC7},
{0xE35E,0x7DBD},
{0xE35F,0x7DAB},
{0xE360,0x7E3D},
{0xE361,0x7DA2},
{0xE362,0x7DAF},
{0xE363,0x7DDC},
{0xE364,0x7DB8},
{0xE365,0x7D9F},
{0xE366,0x7DB0},
{0xE367,0x7DD8},
{0xE368,0x7DDD},
{0xE369,0x7DE4},
{0xE36A,0x7DDE},
{0xE36B,0x7DFB},
{0xE36C,0x7DF2},
{0xE36D,0x7DE1},
{0xE36E,0x7E05},
{0xE36F,0x7E0A},
{0xE370,0x7E23},
{0xE371,0x7E21},
{0xE372,0x7E12},
{0xE373,0x7E31},
{0xE374,0x7E1F},
{0xE375,0x7E09},
{0xE376,0x7E0B},
{0xE377,0x7E22},
{0xE378,0x7E46},
{0xE379,0x7E66},
{0xE37A,0x7E3B},
{0xE37B,0x7E35},
{0xE37C,0x7E39},
{0xE37D,0x7E43},
{0xE37E,0x7E37},
{0xE380,0x7E32},
{0xE381,0x7E3A},
{0xE382,0x7E67},
{0xE383,0x7E5D},
{0xE384,0x7E56},
{0xE385,0x7E5E},
{0xE386,0x7E59},
{0xE387,0x7E5A},
{0xE388,0x7E79},
{0xE389,0x7E6A},
{0xE38A,0x7E69},
{0xE38B,0x7E7C},
{0xE38C,0x7E7B},
{0xE38D,0x7E83},
{0xE38E,0x7DD5},
{0xE38F,0x7E7D},
{0xE390,0x8FAE},
{0xE391,0x7E7F},
{0xE392,0x7E88},
{0xE393,0x7E89},
{0xE394,0x7E8C},
{0xE395,0x7E92},
{0xE396,0x7E90},
{0xE397,0x7E93},
{0xE398,0x7E94},
{0xE399,0x7E96},
{0xE39A,0x7E8E},
{0xE39B,0x7E9B},
{0xE39C,0x7E9C},
{0xE39D,0x7F38},
{0xE39E,0x7F3A},
{0xE39F,0x7F45},
{0xE3A0,0x7F4C},
{0xE3A1,0x7F4D},
{0xE3A2,0x7F4E},
{0xE3A3,0x7F50},
{0xE3A4,0x7F51},
{0xE3A5,0x7F55},
{0xE3A6,0x7F54},
{0xE3A7,0x7F58},
{0xE3A8,0x7F5F},
{0xE3A9,0x7F60},
{0xE3AA,0x7F68},
{0xE3AB,0x7F69},
{0xE3AC,0x7F67},
{0xE3AD,0x7F78},
{0xE3AE,0x7F82},
{0xE3AF,0x7F86},
{0xE3B0,0x7F83},
{0xE3B1,0x7F88},
{0xE3B2,0x7F87},
{0xE3B3,0x7F8C},
{0xE3B4,0x7F94},
{0xE3B5,0x7F9E},
{0xE3B6,0x7F9D},
{0xE3B7,0x7F9A},
{0xE3B8,0x7FA3},
{0xE3B9,0x7FAF},
{0xE3BA,0x7FB2},
{0xE3BB,0x7FB9},
{0xE3BC,0x7FAE},
{0xE3BD,0x7FB6},
{0xE3BE,0x7FB8},
{0xE3BF,0x8B71},
{0xE3C0,0x7FC5},
{0xE3C1,0x7FC6},
{0xE3C2,0x7FCA},
{0xE3C3,0x7FD5},
{0xE3C4,0x7FD4},
{0xE3C5,0x7FE1},
{0xE3C6,0x7FE6},
{0xE3C7,0x7FE9},
{0xE3C8,0x7FF3},
{0xE3C9,0x7FF9},
{0xE3CA,0x98DC},
{0xE3CB,0x8006},
{0xE3CC,0x8004},
{0xE3CD,0x800B},
{0xE3CE,0x8012},
{0xE3CF,0x8018},
{0xE3D0,0x8019},
{0xE3D1,0x801C},
{0xE3D2,0x8021},
{0xE3D3,0x8028},
{0xE3D4,0x803F},
{0xE3D5,0x803B},
{0xE3D6,0x804A},
{0xE3D7,0x8046},
{0xE3D8,0x8052},
{0xE3D9,0x8058},
{0xE3DA,0x805A},
{0xE3DB,0x805F},
{0xE3DC,0x8062},
{0xE3DD,0x8068},
{0xE3DE,0x8073},
{0xE3DF,0x8072},
{0xE3E0,0x8070},
{0xE3E1,0x8076},
{0xE3E2,0x8079},
{0xE3E3,0x807D},
{0xE3E4,0x807F},
{0xE3E5,0x8084},
{0xE3E6,0x8086},
{0xE3E7,0x8085},
{0xE3E8,0x809B},
{0xE3E9,0x8093},
{0xE3EA,0x809A},
{0xE3EB,0x80AD},
{0xE3EC,0x5190},
{0xE3ED,0x80AC},
{0xE3EE,0x80DB},
{0xE3EF,0x80E5},
{0xE3F0,0x80D9},
{0xE3F1,0x80DD},
{0xE3F2,0x80C4},
{0xE3F3,0x80DA},
{0xE3F4,0x80D6},
{0xE3F5,0x8109},
{0xE3F6,0x80EF},
{0xE3F7,0x80F1},
{0xE3F8,0x811B},
{0xE3F9,0x8129},
{0xE3FA,0x8123},
{0xE3FB,0x812F},
{0xE3FC,0x814B},
{0xE440,0x968B},
{0xE441,0x8146},
{0xE442,0x813E},
{0xE443,0x8153},
{0xE444,0x8151},
{0xE445,0x80FC},
{0xE446,0x8171},
{0xE447,0x816E},
{0xE448,0x8165},
{0xE449,0x8166},
{0xE44A,0x8174},
{0xE44B,0x8183},
{0xE44C,0x8188},
{0xE44D,0x818A},
{0xE44E,0x8180},
{0xE44F,0x8182},
{0xE450,0x81A0},
{0xE451,0x8195},
{0xE452,0x81A4},
{0xE453,0x81A3},
{0xE454,0x815F},
{0xE455,0x8193},
{0xE456,0x81A9},
{0xE457,0x81B0},
{0xE458,0x81B5},
{0xE459,0x81BE},
{0xE45A,0x81B8},
{0xE45B,0x81BD},
{0xE45C,0x81C0},
{0xE45D,0x81C2},
{0xE45E,0x81BA},
{0xE45F,0x81C9},
{0xE460,0x81CD},
{0xE461,0x81D1},
{0xE462,0x81D9},
{0xE463,0x81D8},
{0xE464,0x81C8},
{0xE465,0x81DA},
{0xE466,0x81DF},
{0xE467,0x81E0},
{0xE468,0x81E7},
{0xE469,0x81FA},
{0xE46A,0x81FB},
{0xE46B,0x81FE},
{0xE46C,0x8201},
{0xE46D,0x8202},
{0xE46E,0x8205},
{0xE46F,0x8207},
{0xE470,0x820A},
{0xE471,0x820D},
{0xE472,0x8210},
{0xE473,0x8216},
{0xE474,0x8229},
{0xE475,0x822B},
{0xE476,0x8238},
{0xE477,0x8233},
{0xE478,0x8240},
{0xE479,0x8259},
{0xE47A,0x8258},
{0xE47B,0x825D},
{0xE47C,0x825A},
{0xE47D,0x825F},
{0xE47E,0x8264},
{0xE480,0x8262},
{0xE481,0x8268},
{0xE482,0x826A},
{0xE483,0x826B},
{0xE484,0x822E},
{0xE485,0x8271},
{0xE486,0x8277},
{0xE487,0x8278},
{0xE488,0x827E},
{0xE489,0x828D},
{0xE48A,0x8292},
{0xE48B,0x82AB},
{0xE48C,0x829F},
{0xE48D,0x82BB},
{0xE48E,0x82AC},
{0xE48F,0x82E1},
{0xE490,0x82E3},
{0xE491,0x82DF},
{0xE492,0x82D2},
{0xE493,0x82F4},
{0xE494,0x82F3},
{0xE495,0x82FA},
{0xE496,0x8393},
{0xE497,0x8303},
{0xE498,0x82FB},
{0xE499,0x82F9},
{0xE49A,0x82DE},
{0xE49B,0x8306},
{0xE49C,0x82DC},
{0xE49D,0x8309},
{0xE49E,0x82D9},
{0xE49F,0x8335},
{0xE4A0,0x8334},
{0xE4A1,0x8316},
{0xE4A2,0x8332},
{0xE4A3,0x8331},
{0xE4A4,0x8340},
{0xE4A5,0x8339},
{0xE4A6,0x8350},
{0xE4A7,0x8345},
{0xE4A8,0x832F},
{0xE4A9,0x832B},
{0xE4AA,0x8317},
{0xE4AB,0x8318},
{0xE4AC,0x8385},
{0xE4AD,0x839A},
{0xE4AE,0x83AA},
{0xE4AF,0x839F},
{0xE4B0,0x83A2},
{0xE4B1,0x8396},
{0xE4B2,0x8323},
{0xE4B3,0x838E},
{0xE4B4,0x8387},
{0xE4B5,0x838A},
{0xE4B6,0x837C},
{0xE4B7,0x83B5},
{0xE4B8,0x8373},
{0xE4B9,0x8375},
{0xE4BA,0x83A0},
{0xE4BB,0x8389},
{0xE4BC,0x83A8},
{0xE4BD,0x83F4},
{0xE4BE,0x8413},
{0xE4BF,0x83EB},
{0xE4C0,0x83CE},
{0xE4C1,0x83FD},
{0xE4C2,0x8403},
{0xE4C3,0x83D8},
{0xE4C4,0x840B},
{0xE4C5,0x83C1},
{0xE4C6,0x83F7},
{0xE4C7,0x8407},
{0xE4C8,0x83E0},
{0xE4C9,0x83F2},
{0xE4CA,0x840D},
{0xE4CB,0x8422},
{0xE4CC,0x8420},
{0xE4CD,0x83BD},
{0xE4CE,0x8438},
{0xE4CF,0x8506},
{0xE4D0,0x83FB},
{0xE4D1,0x846D},
{0xE4D2,0x842A},
{0xE4D3,0x843C},
{0xE4D4,0x855A},
{0xE4D5,0x8484},
{0xE4D6,0x8477},
{0xE4D7,0x846B},
{0xE4D8,0x84AD},
{0xE4D9,0x846E},
{0xE4DA,0x8482},
{0xE4DB,0x8469},
{0xE4DC,0x8446},
{0xE4DD,0x842C},
{0xE4DE,0x846F},
{0xE4DF,0x8479},
{0xE4E0,0x8435},
{0xE4E1,0x84CA},
{0xE4E2,0x8462},
{0xE4E3,0x84B9},
{0xE4E4,0x84BF},
{0xE4E5,0x849F},
{0xE4E6,0x84D9},
{0xE4E7,0x84CD},
{0xE4E8,0x84BB},
{0xE4E9,0x84DA},
{0xE4EA,0x84D0},
{0xE4EB,0x84C1},
{0xE4EC,0x84C6},
{0xE4ED,0x84D6},
{0xE4EE,0x84A1},
{0xE4EF,0x8521},
{0xE4F0,0x84FF},
{0xE4F1,0x84F4},
{0xE4F2,0x8517},
{0xE4F3,0x8518},
{0xE4F4,0x852C},
{0xE4F5,0x851F},
{0xE4F6,0x8515},
{0xE4F7,0x8514},
{0xE4F8,0x84FC},
{0xE4F9,0x8540},
{0xE4FA,0x8563},
{0xE4FB,0x8558},
{0xE4FC,0x8548},
{0xE540,0x8541},
{0xE541,0x8602},
{0xE542,0x854B},
{0xE543,0x8555},
{0xE544,0x8580},
{0xE545,0x85A4},
{0xE546,0x8588},
{0xE547,0x8591},
{0xE548,0x858A},
{0xE549,0x85A8},
{0xE54A,0x856D},
{0xE54B,0x8594},
{0xE54C,0x859B},
{0xE54D,0x85EA},
{0xE54E,0x8587},
{0xE54F,0x859C},
{0xE550,0x8577},
{0xE551,0x857E},
{0xE552,0x8590},
{0xE553,0x85C9},
{0xE554,0x85BA},
{0xE555,0x85CF},
{0xE556,0x85B9},
{0xE557,0x85D0},
{0xE558,0x85D5},
{0xE559,0x85DD},
{0xE55A,0x85E5},
{0xE55B,0x85DC},
{0xE55C,0x85F9},
{0xE55D,0x860A},
{0xE55E,0x8613},
{0xE55F,0x860B},
{0xE560,0x85FE},
{0xE561,0x85FA},
{0xE562,0x8606},
{0xE563,0x8622},
{0xE564,0x861A},
{0xE565,0x8630},
{0xE566,0x863F},
{0xE567,0x864D},
{0xE568,0x4E55},
{0xE569,0x8654},
{0xE56A,0x865F},
{0xE56B,0x8667},
{0xE56C,0x8671},
{0xE56D,0x8693},
{0xE56E,0x86A3},
{0xE56F,0x86A9},
{0xE570,0x86AA},
{0xE571,0x868B},
{0xE572,0x868C},
{0xE573,0x86B6},
{0xE574,0x86AF},
{0xE575,0x86C4},
{0xE576,0x86C6},
{0xE577,0x86B0},
{0xE578,0x86C9},
{0xE579,0x8823},
{0xE57A,0x86AB},
{0xE57B,0x86D4},
{0xE57C,0x86DE},
{0xE57D,0x86E9},
{0xE57E,0x86EC},
{0xE580,0x86DF},
{0xE581,0x86DB},
{0xE582,0x86EF},
{0xE583,0x8712},
{0xE584,0x8706},
{0xE585,0x8708},
{0xE586,0x8700},
{0xE587,0x8703},
{0xE588,0x86FB},
{0xE589,0x8711},
{0xE58A,0x8709},
{0xE58B,0x870D},
{0xE58C,0x86F9},
{0xE58D,0x870A},
{0xE58E,0x8734},
{0xE58F,0x873F},
{0xE590,0x8737},
{0xE591,0x873B},
{0xE592,0x8725},
{0xE593,0x8729},
{0xE594,0x871A},
{0xE595,0x8760},
{0xE596,0x875F},
{0xE597,0x8778},
{0xE598,0x874C},
{0xE599,0x874E},
{0xE59A,0x8774},
{0xE59B,0x8757},
{0xE59C,0x8768},
{0xE59D,0x876E},
{0xE59E,0x8759},
{0xE59F,0x8753},
{0xE5A0,0x8763},
{0xE5A1,0x876A},
{0xE5A2,0x8805},
{0xE5A3,0x87A2},
{0xE5A4,0x879F},
{0xE5A5,0x8782},
{0xE5A6,0x87AF},
{0xE5A7,0x87CB},
{0xE5A8,0x87BD},
{0xE5A9,0x87C0},
{0xE5AA,0x87D0},
{0xE5AB,0x96D6},
{0xE5AC,0x87AB},
{0xE5AD,0x87C4},
{0xE5AE,0x87B3},
{0xE5AF,0x87C7},
{0xE5B0,0x87C6},
{0xE5B1,0x87BB},
{0xE5B2,0x87EF},
{0xE5B3,0x87F2},
{0xE5B4,0x87E0},
{0xE5B5,0x880F},
{0xE5B6,0x880D},
{0xE5B7,0x87FE},
{0xE5B8,0x87F6},
{0xE5B9,0x87F7},
{0xE5BA,0x880E},
{0xE5BB,0x87D2},
{0xE5BC,0x8811},
{0xE5BD,0x8816},
{0xE5BE,0x8815},
{0xE5BF,0x8822},
{0xE5C0,0x8821},
{0xE5C1,0x8831},
{0xE5C2,0x8836},
{0xE5C3,0x8839},
{0xE5C4,0x8827},
{0xE5C5,0x883B},
{0xE5C6,0x8844},
{0xE5C7,0x8842},
{0xE5C8,0x8852},
{0xE5C9,0x8859},
{0xE5CA,0x885E},
{0xE5CB,0x8862},
{0xE5CC,0x886B},
{0xE5CD,0x8881},
{0xE5CE,0x887E},
{0xE5CF,0x889E},
{0xE5D0,0x8875},
{0xE5D1,0x887D},
{0xE5D2,0x88B5},
{0xE5D3,0x8872},
{0xE5D4,0x8882},
{0xE5D5,0x8897},
{0xE5D6,0x8892},
{0xE5D7,0x88AE},
{0xE5D8,0x8899},
{0xE5D9,0x88A2},
{0xE5DA,0x888D},
{0xE5DB,0x88A4},
{0xE5DC,0x88B0},
{0xE5DD,0x88BF},
{0xE5DE,0x88B1},
{0xE5DF,0x88C3},
{0xE5E0,0x88C4},
{0xE5E1,0x88D4},
{0xE5E2,0x88D8},
{0xE5E3,0x88D9},
{0xE5E4,0x88DD},
{0xE5E5,0x88F9},
{0xE5E6,0x8902},
{0xE5E7,0x88FC},
{0xE5E8,0x88F4},
{0xE5E9,0x88E8},
{0xE5EA,0x88F2},
{0xE5EB,0x8904},
{0xE5EC,0x890C},
{0xE5ED,0x890A},
{0xE5EE,0x8913},
{0xE5EF,0x8943},
{0xE5F0,0x891E},
{0xE5F1,0x8925},
{0xE5F2,0x892A},
{0xE5F3,0x892B},
{0xE5F4,0x8941},
{0xE5F5,0x8944},
{0xE5F6,0x893B},
{0xE5F7,0x8936},
{0xE5F8,0x8938},
{0xE5F9,0x894C},
{0xE5FA,0x891D},
{0xE5FB,0x8960},
{0xE5FC,0x895E},
{0xE640,0x8966},
{0xE641,0x8964},
{0xE642,0x896D},
{0xE643,0x896A},
{0xE644,0x896F},
{0xE645,0x8974},
{0xE646,0x8977},
{0xE647,0x897E},
{0xE648,0x8983},
{0xE649,0x8988},
{0xE64A,0x898A},
{0xE64B,0x8993},
{0xE64C,0x8998},
{0xE64D,0x89A1},
{0xE64E,0x89A9},
{0xE64F,0x89A6},
{0xE650,0x89AC},
{0xE651,0x89AF},
{0xE652,0x89B2},
{0xE653,0x89BA},
{0xE654,0x89BD},
{0xE655,0x89BF},
{0xE656,0x89C0},
{0xE657,0x89DA},
{0xE658,0x89DC},
{0xE659,0x89DD},
{0xE65A,0x89E7},
{0xE65B,0x89F4},
{0xE65C,0x89F8},
{0xE65D,0x8A03},
{0xE65E,0x8A16},
{0xE65F,0x8A10},
{0xE660,0x8A0C},
{0xE661,0x8A1B},
{0xE662,0x8A1D},
{0xE663,0x8A25},
{0xE664,0x8A36},
{0xE665,0x8A41},
{0xE666,0x8A5B},
{0xE667,0x8A52},
{0xE668,0x8A46},
{0xE669,0x8A48},
{0xE66A,0x8A7C},
{0xE66B,0x8A6D},
{0xE66C,0x8A6C},
{0xE66D,0x8A62},
{0xE66E,0x8A85},
{0xE66F,0x8A82},
{0xE670,0x8A84},
{0xE671,0x8AA8},
{0xE672,0x8AA1},
{0xE673,0x8A91},
{0xE674,0x8AA5},
{0xE675,0x8AA6},
{0xE676,0x8A9A},
{0xE677,0x8AA3},
{0xE678,0x8AC4},
{0xE679,0x8ACD},
{0xE67A,0x8AC2},
{0xE67B,0x8ADA},
{0xE67C,0x8AEB},
{0xE67D,0x8AF3},
{0xE67E,0x8AE7},
{0xE680,0x8AE4},
{0xE681,0x8AF1},
{0xE682,0x8B14},
{0xE683,0x8AE0},
{0xE684,0x8AE2},
{0xE685,0x8AF7},
{0xE686,0x8ADE},
{0xE687,0x8ADB},
{0xE688,0x8B0C},
{0xE689,0x8B07},
{0xE68A,0x8B1A},
{0xE68B,0x8AE1},
{0xE68C,0x8B16},
{0xE68D,0x8B10},
{0xE68E,0x8B17},
{0xE68F,0x8B20},
{0xE690,0x8B33},
{0xE691,0x97AB},
{0xE692,0x8B26},
{0xE693,0x8B2B},
{0xE694,0x8B3E},
{0xE695,0x8B28},
{0xE696,0x8B41},
{0xE697,0x8B4C},
{0xE698,0x8B4F},
{0xE699,0x8B4E},
{0xE69A,0x8B49},
{0xE69B,0x8B56},
{0xE69C,0x8B5B},
{0xE69D,0x8B5A},
{0xE69E,0x8B6B},
{0xE69F,0x8B5F},
{0xE6A0,0x8B6C},
{0xE6A1,0x8B6F},
{0xE6A2,0x8B74},
{0xE6A3,0x8B7D},
{0xE6A4,0x8B80},
{0xE6A5,0x8B8C},
{0xE6A6,0x8B8E},
{0xE6A7,0x8B92},
{0xE6A8,0x8B93},
{0xE6A9,0x8B96},
{0xE6AA,0x8B99},
{0xE6AB,0x8B9A},
{0xE6AC,0x8C3A},
{0xE6AD,0x8C41},
{0xE6AE,0x8C3F},
{0xE6AF,0x8C48},
{0xE6B0,0x8C4C},
{0xE6B1,0x8C4E},
{0xE6B2,0x8C50},
{0xE6B3,0x8C55},
{0xE6B4,0x8C62},
{0xE6B5,0x8C6C},
{0xE6B6,0x8C78},
{0xE6B7,0x8C7A},
{0xE6B8,0x8C82},
{0xE6B9,0x8C89},
{0xE6BA,0x8C85},
{0xE6BB,0x8C8A},
{0xE6BC,0x8C8D},
{0xE6BD,0x8C8E},
{0xE6BE,0x8C94},
{0xE6BF,0x8C7C},
{0xE6C0,0x8C98},
{0xE6C1,0x621D},
{0xE6C2,0x8CAD},
{0xE6C3,0x8CAA},
{0xE6C4,0x8CBD},
{0xE6C5,0x8CB2},
{0xE6C6,0x8CB3},
{0xE6C7,0x8CAE},
{0xE6C8,0x8CB6},
{0xE6C9,0x8CC8},
{0xE6CA,0x8CC1},
{0xE6CB,0x8CE4},
{0xE6CC,0x8CE3},
{0xE6CD,0x8CDA},
{0xE6CE,0x8CFD},
{0xE6CF,0x8CFA},
{0xE6D0,0x8CFB},
{0xE6D1,0x8D04},
{0xE6D2,0x8D05},
{0xE6D3,0x8D0A},
{0xE6D4,0x8D07},
{0xE6D5,0x8D0F},
{0xE6D6,0x8D0D},
{0xE6D7,0x8D10},
{0xE6D8,0x9F4E},
{0xE6D9,0x8D13},
{0xE6DA,0x8CCD},
{0xE6DB,0x8D14},
{0xE6DC,0x8D16},
{0xE6DD,0x8D67},
{0xE6DE,0x8D6D},
{0xE6DF,0x8D71},
{0xE6E0,0x8D73},
{0xE6E1,0x8D81},
{0xE6E2,0x8D99},
{0xE6E3,0x8DC2},
{0xE6E4,0x8DBE},
{0xE6E5,0x8DBA},
{0xE6E6,0x8DCF},
{0xE6E7,0x8DDA},
{0xE6E8,0x8DD6},
{0xE6E9,0x8DCC},
{0xE6EA,0x8DDB},
{0xE6EB,0x8DCB},
{0xE6EC,0x8DEA},
{0xE6ED,0x8DEB},
{0xE6EE,0x8DDF},
{0xE6EF,0x8DE3},
{0xE6F0,0x8DFC},
{0xE6F1,0x8E08},
{0xE6F2,0x8E09},
{0xE6F3,0x8DFF},
{0xE6F4,0x8E1D},
{0xE6F5,0x8E1E},
{0xE6F6,0x8E10},
{0xE6F7,0x8E1F},
{0xE6F8,0x8E42},
{0xE6F9,0x8E35},
{0xE6FA,0x8E30},
{0xE6FB,0x8E34},
{0xE6FC,0x8E4A},
{0xE740,0x8E47},
{0xE741,0x8E49},
{0xE742,0x8E4C},
{0xE743,0x8E50},
{0xE744,0x8E48},
{0xE745,0x8E59},
{0xE746,0x8E64},
{0xE747,0x8E60},
{0xE748,0x8E2A},
{0xE749,0x8E63},
{0xE74A,0x8E55},
{0xE74B,0x8E76},
{0xE74C,0x8E72},
{0xE74D,0x8E7C},
{0xE74E,0x8E81},
{0xE74F,0x8E87},
{0xE750,0x8E85},
{0xE751,0x8E84},
{0xE752,0x8E8B},
{0xE753,0x8E8A},
{0xE754,0x8E93},
{0xE755,0x8E91},
{0xE756,0x8E94},
{0xE757,0x8E99},
{0xE758,0x8EAA},
{0xE759,0x8EA1},
{0xE75A,0x8EAC},
{0xE75B,0x8EB0},
{0xE75C,0x8EC6},
{0xE75D,0x8EB1},
{0xE75E,0x8EBE},
{0xE75F,0x8EC5},
{0xE760,0x8EC8},
{0xE761,0x8ECB},
{0xE762,0x8EDB},
{0xE763,0x8EE3},
{0xE764,0x8EFC},
{0xE765,0x8EFB},
{0xE766,0x8EEB},
{0xE767,0x8EFE},
{0xE768,0x8F0A},
{0xE769,0x8F05},
{0xE76A,0x8F15},
{0xE76B,0x8F12},
{0xE76C,0x8F19},
{0xE76D,0x8F13},
{0xE76E,0x8F1C},
{0xE76F,0x8F1F},
{0xE770,0x8F1B},
{0xE771,0x8F0C},
{0xE772,0x8F26},
{0xE773,0x8F33},
{0xE774,0x8F3B},
{0xE775,0x8F39},
{0xE776,0x8F45},
{0xE777,0x8F42},
{0xE778,0x8F3E},
{0xE779,0x8F4C},
{0xE77A,0x8F49},
{0xE77B,0x8F46},
{0xE77C,0x8F4E},
{0xE77D,0x8F57},
{0xE77E,0x8F5C},
{0xE780,0x8F62},
{0xE781,0x8F63},
{0xE782,0x8F64},
{0xE783,0x8F9C},
{0xE784,0x8F9F},
{0xE785,0x8FA3},
{0xE786,0x8FAD},
{0xE787,0x8FAF},
{0xE788,0x8FB7},
{0xE789,0x8FDA},
{0xE78A,0x8FE5},
{0xE78B,0x8FE2},
{0xE78C,0x8FEA},
{0xE78D,0x8FEF},
{0xE78E,0x9087},
{0xE78F,0x8FF4},
{0xE790,0x9005},
{0xE791,0x8FF9},
{0xE792,0x8FFA},
{0xE793,0x9011},
{0xE794,0x9015},
{0xE795,0x9021},
{0xE796,0x900D},
{0xE797,0x901E},
{0xE798,0x9016},
{0xE799,0x900B},
{0xE79A,0x9027},
{0xE79B,0x9036},
{0xE79C,0x9035},
{0xE79D,0x9039},
{0xE79E,0x8FF8},
{0xE79F,0x904F},
{0xE7A0,0x9050},
{0xE7A1,0x9051},
{0xE7A2,0x9052},
{0xE7A3,0x900E},
{0xE7A4,0x9049},
{0xE7A5,0x903E},
{0xE7A6,0x9056},
{0xE7A7,0x9058},
{0xE7A8,0x905E},
{0xE7A9,0x9068},
{0xE7AA,0x906F},
{0xE7AB,0x9076},
{0xE7AC,0x96A8},
{0xE7AD,0x9072},
{0xE7AE,0x9082},
{0xE7AF,0x907D},
{0xE7B0,0x9081},
{0xE7B1,0x9080},
{0xE7B2,0x908A},
{0xE7B3,0x9089},
{0xE7B4,0x908F},
{0xE7B5,0x90A8},
{0xE7B6,0x90AF},
{0xE7B7,0x90B1},
{0xE7B8,0x90B5},
{0xE7B9,0x90E2},
{0xE7BA,0x90E4},
{0xE7BB,0x6248},
{0xE7BC,0x90DB},
{0xE7BD,0x9102},
{0xE7BE,0x9112},
{0xE7BF,0x9119},
{0xE7C0,0x9132},
{0xE7C1,0x9130},
{0xE7C2,0x914A},
{0xE7C3,0x9156},
{0xE7C4,0x9158},
{0xE7C5,0x9163},
{0xE7C6,0x9165},
{0xE7C7,0x9169},
{0xE7C8,0x9173},
{0xE7C9,0x9172},
{0xE7CA,0x918B},
{0xE7CB,0x9189},
{0xE7CC,0x9182},
{0xE7CD,0x91A2},
{0xE7CE,0x91AB},
{0xE7CF,0x91AF},
{0xE7D0,0x91AA},
{0xE7D1,0x91B5},
{0xE7D2,0x91B4},
{0xE7D3,0x91BA},
{0xE7D4,0x91C0},
{0xE7D5,0x91C1},
{0xE7D6,0x91C9},
{0xE7D7,0x91CB},
{0xE7D8,0x91D0},
{0xE7D9,0x91D6},
{0xE7DA,0x91DF},
{0xE7DB,0x91E1},
{0xE7DC,0x91DB},
{0xE7DD,0x91FC},
{0xE7DE,0x91F5},
{0xE7DF,0x91F6},
{0xE7E0,0x921E},
{0xE7E1,0x91FF},
{0xE7E2,0x9214},
{0xE7E3,0x922C},
{0xE7E4,0x9215},
{0xE7E5,0x9211},
{0xE7E6,0x925E},
{0xE7E7,0x9257},
{0xE7E8,0x9245},
{0xE7E9,0x9249},
{0xE7EA,0x9264},
{0xE7EB,0x9248},
{0xE7EC,0x9295},
{0xE7ED,0x923F},
{0xE7EE,0x924B},
{0xE7EF,0x9250},
{0xE7F0,0x929C},
{0xE7F1,0x9296},
{0xE7F2,0x9293},
{0xE7F3,0x929B},
{0xE7F4,0x925A},
{0xE7F5,0x92CF},
{0xE7F6,0x92B9},
{0xE7F7,0x92B7},
{0xE7F8,0x92E9},
{0xE7F9,0x930F},
{0xE7FA,0x92FA},
{0xE7FB,0x9344},
{0xE7FC,0x932E},
{0xE840,0x9319},
{0xE841,0x9322},
{0xE842,0x931A},
{0xE843,0x9323},
{0xE844,0x933A},
{0xE845,0x9335},
{0xE846,0x933B},
{0xE847,0x935C},
{0xE848,0x9360},
{0xE849,0x937C},
{0xE84A,0x936E},
{0xE84B,0x9356},
{0xE84C,0x93B0},
{0xE84D,0x93AC},
{0xE84E,0x93AD},
{0xE84F,0x9394},
{0xE850,0x93B9},
{0xE851,0x93D6},
{0xE852,0x93D7},
{0xE853,0x93E8},
{0xE854,0x93E5},
{0xE855,0x93D8},
{0xE856,0x93C3},
{0xE857,0x93DD},
{0xE858,0x93D0},
{0xE859,0x93C8},
{0xE85A,0x93E4},
{0xE85B,0x941A},
{0xE85C,0x9414},
{0xE85D,0x9413},
{0xE85E,0x9403},
{0xE85F,0x9407},
{0xE860,0x9410},
{0xE861,0x9436},
{0xE862,0x942B},
{0xE863,0x9435},
{0xE864,0x9421},
{0xE865,0x943A},
{0xE866,0x9441},
{0xE867,0x9452},
{0xE868,0x9444},
{0xE869,0x945B},
{0xE86A,0x9460},
{0xE86B,0x9462},
{0xE86C,0x945E},
{0xE86D,0x946A},
{0xE86E,0x9229},
{0xE86F,0x9470},
{0xE870,0x9475},
{0xE871,0x9477},
{0xE872,0x947D},
{0xE873,0x945A},
{0xE874,0x947C},
{0xE875,0x947E},
{0xE876,0x9481},
{0xE877,0x947F},
{0xE878,0x9582},
{0xE879,0x9587},
{0xE87A,0x958A},
{0xE87B,0x9594},
{0xE87C,0x9596},
{0xE87D,0x9598},
{0xE87E,0x9599},
{0xE880,0x95A0},
{0xE881,0x95A8},
{0xE882,0x95A7},
{0xE883,0x95AD},
{0xE884,0x95BC},
{0xE885,0x95BB},
{0xE886,0x95B9},
{0xE887,0x95BE},
{0xE888,0x95CA},
{0xE889,0x6FF6},
{0xE88A,0x95C3},
{0xE88B,0x95CD},
{0xE88C,0x95CC},
{0xE88D,0x95D5},
{0xE88E,0x95D4},
{0xE88F,0x95D6},
{0xE890,0x95DC},
{0xE891,0x95E1},
{0xE892,0x95E5},
{0xE893,0x95E2},
{0xE894,0x9621},
{0xE895,0x9628},
{0xE896,0x962E},
{0xE897,0x962F},
{0xE898,0x9642},
{0xE899,0x964C},
{0xE89A,0x964F},
{0xE89B,0x964B},
{0xE89C,0x9677},
{0xE89D,0x965C},
{0xE89E,0x965E},
{0xE89F,0x965D},
{0xE8A0,0x965F},
{0xE8A1,0x9666},
{0xE8A2,0x9672},
{0xE8A3,0x966C},
{0xE8A4,0x968D},
{0xE8A5,0x9698},
{0xE8A6,0x9695},
{0xE8A7,0x9697},
{0xE8A8,0x96AA},
{0xE8A9,0x96A7},
{0xE8AA,0x96B1},
{0xE8AB,0x96B2},
{0xE8AC,0x96B0},
{0xE8AD,0x96B4},
{0xE8AE,0x96B6},
{0xE8AF,0x96B8},
{0xE8B0,0x96B9},
{0xE8B1,0x96CE},
{0xE8B2,0x96CB},
{0xE8B3,0x96C9},
{0xE8B4,0x96CD},
{0xE8B5,0x894D},
{0xE8B6,0x96DC},
{0xE8B7,0x970D},
{0xE8B8,0x96D5},
{0xE8B9,0x96F9},
{0xE8BA,0x9704},
{0xE8BB,0x9706},
{0xE8BC,0x9708},
{0xE8BD,0x9713},
{0xE8BE,0x970E},
{0xE8BF,0x9711},
{0xE8C0,0x970F},
{0xE8C1,0x9716},
{0xE8C2,0x9719},
{0xE8C3,0x9724},
{0xE8C4,0x972A},
{0xE8C5,0x9730},
{0xE8C6,0x9739},
{0xE8C7,0x973D},
{0xE8C8,0x973E},
{0xE8C9,0x9744},
{0xE8CA,0x9746},
{0xE8CB,0x9748},
{0xE8CC,0x9742},
{0xE8CD,0x9749},
{0xE8CE,0x975C},
{0xE8CF,0x9760},
{0xE8D0,0x9764},
{0xE8D1,0x9766},
{0xE8D2,0x9768},
{0xE8D3,0x52D2},
{0xE8D4,0x976B},
{0xE8D5,0x9771},
{0xE8D6,0x9779},
{0xE8D7,0x9785},
{0xE8D8,0x977C},
{0xE8D9,0x9781},
{0xE8DA,0x977A},
{0xE8DB,0x9786},
{0xE8DC,0x978B},
{0xE8DD,0x978F},
{0xE8DE,0x9790},
{0xE8DF,0x979C},
{0xE8E0,0x97A8},
{0xE8E1,0x97A6},
{0xE8E2,0x97A3},
{0xE8E3,0x97B3},
{0xE8E4,0x97B4},
{0xE8E5,0x97C3},
{0xE8E6,0x97C6},
{0xE8E7,0x97C8},
{0xE8E8,0x97CB},
{0xE8E9,0x97DC},
{0xE8EA,0x97ED},
{0xE8EB,0x9F4F},
{0xE8EC,0x97F2},
{0xE8ED,0x7ADF},
{0xE8EE,0x97F6},
{0xE8EF,0x97F5},
{0xE8F0,0x980F},
{0xE8F1,0x980C},
{0xE8F2,0x9838},
{0xE8F3,0x9824},
{0xE8F4,0x9821},
{0xE8F5,0x9837},
{0xE8F6,0x983D},
{0xE8F7,0x9846},
{0xE8F8,0x984F},
{0xE8F9,0x984B},
{0xE8FA,0x986B},
{0xE8FB,0x986F},
{0xE8FC,0x9870},
{0xE940,0x9871},
{0xE941,0x9874},
{0xE942,0x9873},
{0xE943,0x98AA},
{0xE944,0x98AF},
{0xE945,0x98B1},
{0xE946,0x98B6},
{0xE947,0x98C4},
{0xE948,0x98C3},
{0xE949,0x98C6},
{0xE94A,0x98E9},
{0xE94B,0x98EB},
{0xE94C,0x9903},
{0xE94D,0x9909},
{0xE94E,0x9912},
{0xE94F,0x9914},
{0xE950,0x9918},
{0xE951,0x9921},
{0xE952,0x991D},
{0xE953,0x991E},
{0xE954,0x9924},
{0xE955,0x9920},
{0xE956,0x992C},
{0xE957,0x992E},
{0xE958,0x993D},
{0xE959,0x993E},
{0xE95A,0x9942},
{0xE95B,0x9949},
{0xE95C,0x9945},
{0xE95D,0x9950},
{0xE95E,0x994B},
{0xE95F,0x9951},
{0xE960,0x9952},
{0xE961,0x994C},
{0xE962,0x9955},
{0xE963,0x9997},
{0xE964,0x9998},
{0xE965,0x99A5},
{0xE966,0x99AD},
{0xE967,0x99AE},
{0xE968,0x99BC},
{0xE969,0x99DF},
{0xE96A,0x99DB},
{0xE96B,0x99DD},
{0xE96C,0x99D8},
{0xE96D,0x99D1},
{0xE96E,0x99ED},
{0xE96F,0x99EE},
{0xE970,0x99F1},
{0xE971,0x99F2},
{0xE972,0x99FB},
{0xE973,0x99F8},
{0xE974,0x9A01},
{0xE975,0x9A0F},
{0xE976,0x9A05},
{0xE977,0x99E2},
{0xE978,0x9A19},
{0xE979,0x9A2B},
{0xE97A,0x9A37},
{0xE97B,0x9A45},
{0xE97C,0x9A42},
{0xE97D,0x9A40},
{0xE97E,0x9A43},
{0xE980,0x9A3E},
{0xE981,0x9A55},
{0xE982,0x9A4D},
{0xE983,0x9A5B},
{0xE984,0x9A57},
{0xE985,0x9A5F},
{0xE986,0x9A62},
{0xE987,0x9A65},
{0xE988,0x9A64},
{0xE989,0x9A69},
{0xE98A,0x9A6B},
{0xE98B,0x9A6A},
{0xE98C,0x9AAD},
{0xE98D,0x9AB0},
{0xE98E,0x9ABC},
{0xE98F,0x9AC0},
{0xE990,0x9ACF},
{0xE991,0x9AD1},
{0xE992,0x9AD3},
{0xE993,0x9AD4},
{0xE994,0x9ADE},
{0xE995,0x9ADF},
{0xE996,0x9AE2},
{0xE997,0x9AE3},
{0xE998,0x9AE6},
{0xE999,0x9AEF},
{0xE99A,0x9AEB},
{0xE99B,0x9AEE},
{0xE99C,0x9AF4},
{0xE99D,0x9AF1},
{0xE99E,0x9AF7},
{0xE99F,0x9AFB},
{0xE9A0,0x9B06},
{0xE9A1,0x9B18},
{0xE9A2,0x9B1A},
{0xE9A3,0x9B1F},
{0xE9A4,0x9B22},
{0xE9A5,0x9B23},
{0xE9A6,0x9B25},
{0xE9A7,0x9B27},
{0xE9A8,0x9B28},
{0xE9A9,0x9B29},
{0xE9AA,0x9B2A},
{0xE9AB,0x9B2E},
{0xE9AC,0x9B2F},
{0xE9AD,0x9B32},
{0xE9AE,0x9B44},
{0xE9AF,0x9B43},
{0xE9B0,0x9B4F},
{0xE9B1,0x9B4D},
{0xE9B2,0x9B4E},
{0xE9B3,0x9B51},
{0xE9B4,0x9B58},
{0xE9B5,0x9B74},
{0xE9B6,0x9B93},
{0xE9B7,0x9B83},
{0xE9B8,0x9B91},
{0xE9B9,0x9B96},
{0xE9BA,0x9B97},
{0xE9BB,0x9B9F},
{0xE9BC,0x9BA0},
{0xE9BD,0x9BA8},
{0xE9BE,0x9BB4},
{0xE9BF,0x9BC0},
{0xE9C0,0x9BCA},
{0xE9C1,0x9BB9},
{0xE9C2,0x9BC6},
{0xE9C3,0x9BCF},
{0xE9C4,0x9BD1},
{0xE9C5,0x9BD2},
{0xE9C6,0x9BE3},
{0xE9C7,0x9BE2},
{0xE9C8,0x9BE4},
{0xE9C9,0x9BD4},
{0xE9CA,0x9BE1},
{0xE9CB,0x9C3A},
{0xE9CC,0x9BF2},
{0xE9CD,0x9BF1},
{0xE9CE,0x9BF0},
{0xE9CF,0x9C15},
{0xE9D0,0x9C14},
{0xE9D1,0x9C09},
{0xE9D2,0x9C13},
{0xE9D3,0x9C0C},
{0xE9D4,0x9C06},
{0xE9D5,0x9C08},
{0xE9D6,0x9C12},
{0xE9D7,0x9C0A},
{0xE9D8,0x9C04},
{0xE9D9,0x9C2E},
{0xE9DA,0x9C1B},
{0xE9DB,0x9C25},
{0xE9DC,0x9C24},
{0xE9DD,0x9C21},
{0xE9DE,0x9C30},
{0xE9DF,0x9C47},
{0xE9E0,0x9C32},
{0xE9E1,0x9C46},
{0xE9E2,0x9C3E},
{0xE9E3,0x9C5A},
{0xE9E4,0x9C60},
{0xE9E5,0x9C67},
{0xE9E6,0x9C76},
{0xE9E7,0x9C78},
{0xE9E8,0x9CE7},
{0xE9E9,0x9CEC},
{0xE9EA,0x9CF0},
{0xE9EB,0x9D09},
{0xE9EC,0x9D08},
{0xE9ED,0x9CEB},
{0xE9EE,0x9D03},
{0xE9EF,0x9D06},
{0xE9F0,0x9D2A},
{0xE9F1,0x9D26},
{0xE9F2,0x9DAF},
{0xE9F3,0x9D23},
{0xE9F4,0x9D1F},
{0xE9F5,0x9D44},
{0xE9F6,0x9D15},
{0xE9F7,0x9D12},
{0xE9F8,0x9D41},
{0xE9F9,0x9D3F},
{0xE9FA,0x9D3E},
{0xE9FB,0x9D46},
{0xE9FC,0x9D48},
{0xEA40,0x9D5D},
{0xEA41,0x9D5E},
{0xEA42,0x9D64},
{0xEA43,0x9D51},
{0xEA44,0x9D50},
{0xEA45,0x9D59},
{0xEA46,0x9D72},
{0xEA47,0x9D89},
{0xEA48,0x9D87},
{0xEA49,0x9DAB},
{0xEA4A,0x9D6F},
{0xEA4B,0x9D7A},
{0xEA4C,0x9D9A},
{0xEA4D,0x9DA4},
{0xEA4E,0x9DA9},
{0xEA4F,0x9DB2},
{0xEA50,0x9DC4},
{0xEA51,0x9DC1},
{0xEA52,0x9DBB},
{0xEA53,0x9DB8},
{0xEA54,0x9DBA},
{0xEA55,0x9DC6},
{0xEA56,0x9DCF},
{0xEA57,0x9DC2},
{0xEA58,0x9DD9},
{0xEA59,0x9DD3},
{0xEA5A,0x9DF8},
{0xEA5B,0x9DE6},
{0xEA5C,0x9DED},
{0xEA5D,0x9DEF},
{0xEA5E,0x9DFD},
{0xEA5F,0x9E1A},
{0xEA60,0x9E1B},
{0xEA61,0x9E1E},
{0xEA62,0x9E75},
{0xEA63,0x9E79},
{0xEA64,0x9E7D},
{0xEA65,0x9E81},
{0xEA66,0x9E88},
{0xEA67,0x9E8B},
{0xEA68,0x9E8C},
{0xEA69,0x9E92},
{0xEA6A,0x9E95},
{0xEA6B,0x9E91},
{0xEA6C,0x9E9D},
{0xEA6D,0x9EA5},
{0xEA6E,0x9EA9},
{0xEA6F,0x9EB8},
{0xEA70,0x9EAA},
{0xEA71,0x9EAD},
{0xEA72,0x9761},
{0xEA73,0x9ECC},
{0xEA74,0x9ECE},
{0xEA75,0x9ECF},
{0xEA76,0x9ED0},
{0xEA77,0x9ED4},
{0xEA78,0x9EDC},
{0xEA79,0x9EDE},
{0xEA7A,0x9EDD},
{0xEA7B,0x9EE0},
{0xEA7C,0x9EE5},
{0xEA7D,0x9EE8},
{0xEA7E,0x9EEF},
{0xEA80,0x9EF4},
{0xEA81,0x9EF6},
{0xEA82,0x9EF7},
{0xEA83,0x9EF9},
{0xEA84,0x9EFB},
{0xEA85,0x9EFC},
{0xEA86,0x9EFD},
{0xEA87,0x9F07},
{0xEA88,0x9F08},
{0xEA89,0x76B7},
{0xEA8A,0x9F15},
{0xEA8B,0x9F21},
{0xEA8C,0x9F2C},
{0xEA8D,0x9F3E},
{0xEA8E,0x9F4A},
{0xEA8F,0x9F52},
{0xEA90,0x9F54},
{0xEA91,0x9F63},
{0xEA92,0x9F5F},
{0xEA93,0x9F60},
{0xEA94,0x9F61},
{0xEA95,0x9F66},
{0xEA96,0x9F67},
{0xEA97,0x9F6C},
{0xEA98,0x9F6A},
{0xEA99,0x9F77},
{0xEA9A,0x9F72},
{0xEA9B,0x9F76},
{0xEA9C,0x9F95},
{0xEA9D,0x9F9C},
{0xEA9E,0x9FA0},
{0xEA9F,0x582F},
{0xEAA0,0x69C7},
{0xEAA1,0x9059},
{0xEAA2,0x7464},
{0xEAA3,0x51DC},
{0xEAA4,0x7199},
{0xED40,0x7E8A},
{0xED41,0x891C},
{0xED42,0x9348},
{0xED43,0x9288},
{0xED44,0x84DC},
{0xED45,0x4FC9},
{0xED46,0x70BB},
{0xED47,0x6631},
{0xED48,0x68C8},
{0xED49,0x92F9},
{0xED4A,0x66FB},
{0xED4B,0x5F45},
{0xED4C,0x4E28},
{0xED4D,0x4EE1},
{0xED4E,0x4EFC},
{0xED4F,0x4F00},
{0xED50,0x4F03},
{0xED51,0x4F39},
{0xED52,0x4F56},
{0xED53,0x4F92},
{0xED54,0x4F8A},
{0xED55,0x4F9A},
{0xED56,0x4F94},
{0xED57,0x4FCD},
{0xED58,0x5040},
{0xED59,0x5022},
{0xED5A,0x4FFF},
{0xED5B,0x501E},
{0xED5C,0x5046},
{0xED5D,0x5070},
{0xED5E,0x5042},
{0xED5F,0x5094},
{0xED60,0x50F4},
{0xED61,0x50D8},
{0xED62,0x514A},
{0xED63,0x5164},
{0xED64,0x519D},
{0xED65,0x51BE},
{0xED66,0x51EC},
{0xED67,0x5215},
{0xED68,0x529C},
{0xED69,0x52A6},
{0xED6A,0x52C0},
{0xED6B,0x52DB},
{0xED6C,0x5300},
{0xED6D,0x5307},
{0xED6E,0x5324},
{0xED6F,0x5372},
{0xED70,0x5393},
{0xED71,0x53B2},
{0xED72,0x53DD},
{0xED73,0xFA0E},
{0xED74,0x549C},
{0xED75,0x548A},
{0xED76,0x54A9},
{0xED77,0x54FF},
{0xED78,0x5586},
{0xED79,0x5759},
{0xED7A,0x5765},
{0xED7B,0x57AC},
{0xED7C,0x57C8},
{0xED7D,0x57C7},
{0xED7E,0xFA0F},
{0xED80,0xFA10},
{0xED81,0x589E},
{0xED82,0x58B2},
{0xED83,0x590B},
{0xED84,0x5953},
{0xED85,0x595B},
{0xED86,0x595D},
{0xED87,0x5963},
{0xED88,0x59A4},
{0xED89,0x59BA},
{0xED8A,0x5B56},
{0xED8B,0x5BC0},
{0xED8C,0x752F},
{0xED8D,0x5BD8},
{0xED8E,0x5BEC},
{0xED8F,0x5C1E},
{0xED90,0x5CA6},
{0xED91,0x5CBA},
{0xED92,0x5CF5},
{0xED93,0x5D27},
{0xED94,0x5D53},
{0xED95,0xFA11},
{0xED96,0x5D42},
{0xED97,0x5D6D},
{0xED98,0x5DB8},
{0xED99,0x5DB9},
{0xED9A,0x5DD0},
{0xED9B,0x5F21},
{0xED9C,0x5F34},
{0xED9D,0x5F67},
{0xED9E,0x5FB7},
{0xED9F,0x5FDE},
{0xEDA0,0x605D},
{0xEDA1,0x6085},
{0xEDA2,0x608A},
{0xEDA3,0x60DE},
{0xEDA4,0x60D5},
{0xEDA5,0x6120},
{0xEDA6,0x60F2},
{0xEDA7,0x6111},
{0xEDA8,0x6137},
{0xEDA9,0x6130},
{0xEDAA,0x6198},
{0xEDAB,0x6213},
{0xEDAC,0x62A6},
{0xEDAD,0x63F5},
{0xEDAE,0x6460},
{0xEDAF,0x649D},
{0xEDB0,0x64CE},
{0xEDB1,0x654E},
{0xEDB2,0x6600},
{0xEDB3,0x6615},
{0xEDB4,0x663B},
{0xEDB5,0x6609},
{0xEDB6,0x662E},
{0xEDB7,0x661E},
{0xEDB8,0x6624},
{0xEDB9,0x6665},
{0xEDBA,0x6657},
{0xEDBB,0x6659},
{0xEDBC,0xFA12},
{0xEDBD,0x6673},
{0xEDBE,0x6699},
{0xEDBF,0x66A0},
{0xEDC0,0x66B2},
{0xEDC1,0x66BF},
{0xEDC2,0x66FA},
{0xEDC3,0x670E},
{0xEDC4,0xF929},
{0xEDC5,0x6766},
{0xEDC6,0x67BB},
{0xEDC7,0x6852},
{0xEDC8,0x67C0},
{0xEDC9,0x6801},
{0xEDCA,0x6844},
{0xEDCB,0x68CF},
{0xEDCC,0xFA13},
{0xEDCD,0x6968},
{0xEDCE,0xFA14},
{0xEDCF,0x6998},
{0xEDD0,0x69E2},
{0xEDD1,0x6A30},
{0xEDD2,0x6A6B},
{0xEDD3,0x6A46},
{0xEDD4,0x6A73},
{0xEDD5,0x6A7E},
{0xEDD6,0x6AE2},
{0xEDD7,0x6AE4},
{0xEDD8,0x6BD6},
{0xEDD9,0x6C3F},
{0xEDDA,0x6C5C},
{0xEDDB,0x6C86},
{0xEDDC,0x6C6F},
{0xEDDD,0x6CDA},
{0xEDDE,0x6D04},
{0xEDDF,0x6D87},
{0xEDE0,0x6D6F},
{0xEDE1,0x6D96},
{0xEDE2,0x6DAC},
{0xEDE3,0x6DCF},
{0xEDE4,0x6DF8},
{0xEDE5,0x6DF2},
{0xEDE6,0x6DFC},
{0xEDE7,0x6E39},
{0xEDE8,0x6E5C},
{0xEDE9,0x6E27},
{0xEDEA,0x6E3C},
{0xEDEB,0x6EBF},
{0xEDEC,0x6F88},
{0xEDED,0x6FB5},
{0xEDEE,0x6FF5},
{0xEDEF,0x7005},
{0xEDF0,0x7007},
{0xEDF1,0x7028},
{0xEDF2,0x7085},
{0xEDF3,0x70AB},
{0xEDF4,0x710F},
{0xEDF5,0x7104},
{0xEDF6,0x715C},
{0xEDF7,0x7146},
{0xEDF8,0x7147},
{0xEDF9,0xFA15},
{0xEDFA,0x71C1},
{0xEDFB,0x71FE},
{0xEDFC,0x72B1},
{0xEE40,0x72BE},
{0xEE41,0x7324},
{0xEE42,0xFA16},
{0xEE43,0x7377},
{0xEE44,0x73BD},
{0xEE45,0x73C9},
{0xEE46,0x73D6},
{0xEE47,0x73E3},
{0xEE48,0x73D2},
{0xEE49,0x7407},
{0xEE4A,0x73F5},
{0xEE4B,0x7426},
{0xEE4C,0x742A},
{0xEE4D,0x7429},
{0xEE4E,0x742E},
{0xEE4F,0x7462},
{0xEE50,0x7489},
{0xEE51,0x749F},
{0xEE52,0x7501},
{0xEE53,0x756F},
{0xEE54,0x7682},
{0xEE55,0x769C},
{0xEE56,0x769E},
{0xEE57,0x769B},
{0xEE58,0x76A6},
{0xEE59,0xFA17},
{0xEE5A,0x7746},
{0xEE5B,0x52AF},
{0xEE5C,0x7821},
{0xEE5D,0x784E},
{0xEE5E,0x7864},
{0xEE5F,0x787A},
{0xEE60,0x7930},
{0xEE61,0xFA18},
{0xEE62,0xFA19},
{0xEE63,0xFA1A},
{0xEE64,0x7994},
{0xEE65,0xFA1B},
{0xEE66,0x799B},
{0xEE67,0x7AD1},
{0xEE68,0x7AE7},
{0xEE69,0xFA1C},
{0xEE6A,0x7AEB},
{0xEE6B,0x7B9E},
{0xEE6C,0xFA1D},
{0xEE6D,0x7D48},
{0xEE6E,0x7D5C},
{0xEE6F,0x7DB7},
{0xEE70,0x7DA0},
{0xEE71,0x7DD6},
{0xEE72,0x7E52},
{0xEE73,0x7F47},
{0xEE74,0x7FA1},
{0xEE75,0xFA1E},
{0xEE76,0x8301},
{0xEE77,0x8362},
{0xEE78,0x837F},
{0xEE79,0x83C7},
{0xEE7A,0x83F6},
{0xEE7B,0x8448},
{0xEE7C,0x84B4},
{0xEE7D,0x8553},
{0xEE7E,0x8559},
{0xEE80,0x856B},
{0xEE81,0xFA1F},
{0xEE82,0x85B0},
{0xEE83,0xFA20},
{0xEE84,0xFA21},
{0xEE85,0x8807},
{0xEE86,0x88F5},
{0xEE87,0x8A12},
{0xEE88,0x8A37},
{0xEE89,0x8A79},
{0xEE8A,0x8AA7},
{0xEE8B,0x8ABE},
{0xEE8C,0x8ADF},
{0xEE8D,0xFA22},
{0xEE8E,0x8AF6},
{0xEE8F,0x8B53},
{0xEE90,0x8B7F},
{0xEE91,0x8CF0},
{0xEE92,0x8CF4},
{0xEE93,0x8D12},
{0xEE94,0x8D76},
{0xEE95,0xFA23},
{0xEE96,0x8ECF},
{0xEE97,0xFA24},
{0xEE98,0xFA25},
{0xEE99,0x9067},
{0xEE9A,0x90DE},
{0xEE9B,0xFA26},
{0xEE9C,0x9115},
{0xEE9D,0x9127},
{0xEE9E,0x91DA},
{0xEE9F,0x91D7},
{0xEEA0,0x91DE},
{0xEEA1,0x91ED},
{0xEEA2,0x91EE},
{0xEEA3,0x91E4},
{0xEEA4,0x91E5},
{0xEEA5,0x9206},
{0xEEA6,0x9210},
{0xEEA7,0x920A},
{0xEEA8,0x923A},
{0xEEA9,0x9240},
{0xEEAA,0x923C},
{0xEEAB,0x924E},
{0xEEAC,0x9259},
{0xEEAD,0x9251},
{0xEEAE,0x9239},
{0xEEAF,0x9267},
{0xEEB0,0x92A7},
{0xEEB1,0x9277},
{0xEEB2,0x9278},
{0xEEB3,0x92E7},
{0xEEB4,0x92D7},
{0xEEB5,0x92D9},
{0xEEB6,0x92D0},
{0xEEB7,0xFA27},
{0xEEB8,0x92D5},
{0xEEB9,0x92E0},
{0xEEBA,0x92D3},
{0xEEBB,0x9325},
{0xEEBC,0x9321},
{0xEEBD,0x92FB},
{0xEEBE,0xFA28},
{0xEEBF,0x931E},
{0xEEC0,0x92FF},
{0xEEC1,0x931D},
{0xEEC2,0x9302},
{0xEEC3,0x9370},
{0xEEC4,0x9357},
{0xEEC5,0x93A4},
{0xEEC6,0x93C6},
{0xEEC7,0x93DE},
{0xEEC8,0x93F8},
{0xEEC9,0x9431},
{0xEECA,0x9445},
{0xEECB,0x9448},
{0xEECC,0x9592},
{0xEECD,0xF9DC},
{0xEECE,0xFA29},
{0xEECF,0x969D},
{0xEED0,0x96AF},
{0xEED1,0x9733},
{0xEED2,0x973B},
{0xEED3,0x9743},
{0xEED4,0x974D},
{0xEED5,0x974F},
{0xEED6,0x9751},
{0xEED7,0x9755},
{0xEED8,0x9857},
{0xEED9,0x9865},
{0xEEDA,0xFA2A},
{0xEEDB,0xFA2B},
{0xEEDC,0x9927},
{0xEEDD,0xFA2C},
{0xEEDE,0x999E},
{0xEEDF,0x9A4E},
{0xEEE0,0x9AD9},
{0xEEE1,0x9ADC},
{0xEEE2,0x9B75},
{0xEEE3,0x9B72},
{0xEEE4,0x9B8F},
{0xEEE5,0x9BB1},
{0xEEE6,0x9BBB},
{0xEEE7,0x9C00},
{0xEEE8,0x9D70},
{0xEEE9,0x9D6B},
{0xEEEA,0xFA2D},
{0xEEEB,0x9E19},
{0xEEEC,0x9ED1},
{0xEEEF,0x2170},
{0xEEF0,0x2171},
{0xEEF1,0x2172},
{0xEEF2,0x2173},
{0xEEF3,0x2174},
{0xEEF4,0x2175},
{0xEEF5,0x2176},
{0xEEF6,0x2177},
{0xEEF7,0x2178},
{0xEEF8,0x2179},
{0xEEF9,0xFFE2},
{0xEEFA,0xFFE4},
{0xEEFB,0xFF07},
{0xEEFC,0xFF02},
{0xFA40,0x2170},
{0xFA41,0x2171},
{0xFA42,0x2172},
{0xFA43,0x2173},
{0xFA44,0x2174},
{0xFA45,0x2175},
{0xFA46,0x2176},
{0xFA47,0x2177},
{0xFA48,0x2178},
{0xFA49,0x2179},
{0xFA4A,0x2160},
{0xFA4B,0x2161},
{0xFA4C,0x2162},
{0xFA4D,0x2163},
{0xFA4E,0x2164},
{0xFA4F,0x2165},
{0xFA50,0x2166},
{0xFA51,0x2167},
{0xFA52,0x2168},
{0xFA53,0x2169},
{0xFA54,0xFFE2},
{0xFA55,0xFFE4},
{0xFA56,0xFF07},
{0xFA57,0xFF02},
{0xFA58,0x3231},
{0xFA59,0x2116},
{0xFA5A,0x2121},
{0xFA5B,0x2235},
{0xFA5C,0x7E8A},
{0xFA5D,0x891C},
{0xFA5E,0x9348},
{0xFA5F,0x9288},
{0xFA60,0x84DC},
{0xFA61,0x4FC9},
{0xFA62,0x70BB},
{0xFA63,0x6631},
{0xFA64,0x68C8},
{0xFA65,0x92F9},
{0xFA66,0x66FB},
{0xFA67,0x5F45},
{0xFA68,0x4E28},
{0xFA69,0x4EE1},
{0xFA6A,0x4EFC},
{0xFA6B,0x4F00},
{0xFA6C,0x4F03},
{0xFA6D,0x4F39},
{0xFA6E,0x4F56},
{0xFA6F,0x4F92},
{0xFA70,0x4F8A},
{0xFA71,0x4F9A},
{0xFA72,0x4F94},
{0xFA73,0x4FCD},
{0xFA74,0x5040},
{0xFA75,0x5022},
{0xFA76,0x4FFF},
{0xFA77,0x501E},
{0xFA78,0x5046},
{0xFA79,0x5070},
{0xFA7A,0x5042},
{0xFA7B,0x5094},
{0xFA7C,0x50F4},
{0xFA7D,0x50D8},
{0xFA7E,0x514A},
{0xFA80,0x5164},
{0xFA81,0x519D},
{0xFA82,0x51BE},
{0xFA83,0x51EC},
{0xFA84,0x5215},
{0xFA85,0x529C},
{0xFA86,0x52A6},
{0xFA87,0x52C0},
{0xFA88,0x52DB},
{0xFA89,0x5300},
{0xFA8A,0x5307},
{0xFA8B,0x5324},
{0xFA8C,0x5372},
{0xFA8D,0x5393},
{0xFA8E,0x53B2},
{0xFA8F,0x53DD},
{0xFA90,0xFA0E},
{0xFA91,0x549C},
{0xFA92,0x548A},
{0xFA93,0x54A9},
{0xFA94,0x54FF},
{0xFA95,0x5586},
{0xFA96,0x5759},
{0xFA97,0x5765},
{0xFA98,0x57AC},
{0xFA99,0x57C8},
{0xFA9A,0x57C7},
{0xFA9B,0xFA0F},
{0xFA9C,0xFA10},
{0xFA9D,0x589E},
{0xFA9E,0x58B2},
{0xFA9F,0x590B},
{0xFAA0,0x5953},
{0xFAA1,0x595B},
{0xFAA2,0x595D},
{0xFAA3,0x5963},
{0xFAA4,0x59A4},
{0xFAA5,0x59BA},
{0xFAA6,0x5B56},
{0xFAA7,0x5BC0},
{0xFAA8,0x752F},
{0xFAA9,0x5BD8},
{0xFAAA,0x5BEC},
{0xFAAB,0x5C1E},
{0xFAAC,0x5CA6},
{0xFAAD,0x5CBA},
{0xFAAE,0x5CF5},
{0xFAAF,0x5D27},
{0xFAB0,0x5D53},
{0xFAB1,0xFA11},
{0xFAB2,0x5D42},
{0xFAB3,0x5D6D},
{0xFAB4,0x5DB8},
{0xFAB5,0x5DB9},
{0xFAB6,0x5DD0},
{0xFAB7,0x5F21},
{0xFAB8,0x5F34},
{0xFAB9,0x5F67},
{0xFABA,0x5FB7},
{0xFABB,0x5FDE},
{0xFABC,0x605D},
{0xFABD,0x6085},
{0xFABE,0x608A},
{0xFABF,0x60DE},
{0xFAC0,0x60D5},
{0xFAC1,0x6120},
{0xFAC2,0x60F2},
{0xFAC3,0x6111},
{0xFAC4,0x6137},
{0xFAC5,0x6130},
{0xFAC6,0x6198},
{0xFAC7,0x6213},
{0xFAC8,0x62A6},
{0xFAC9,0x63F5},
{0xFACA,0x6460},
{0xFACB,0x649D},
{0xFACC,0x64CE},
{0xFACD,0x654E},
{0xFACE,0x6600},
{0xFACF,0x6615},
{0xFAD0,0x663B},
{0xFAD1,0x6609},
{0xFAD2,0x662E},
{0xFAD3,0x661E},
{0xFAD4,0x6624},
{0xFAD5,0x6665},
{0xFAD6,0x6657},
{0xFAD7,0x6659},
{0xFAD8,0xFA12},
{0xFAD9,0x6673},
{0xFADA,0x6699},
{0xFADB,0x66A0},
{0xFADC,0x66B2},
{0xFADD,0x66BF},
{0xFADE,0x66FA},
{0xFADF,0x670E},
{0xFAE0,0xF929},
{0xFAE1,0x6766},
{0xFAE2,0x67BB},
{0xFAE3,0x6852},
{0xFAE4,0x67C0},
{0xFAE5,0x6801},
{0xFAE6,0x6844},
{0xFAE7,0x68CF},
{0xFAE8,0xFA13},
{0xFAE9,0x6968},
{0xFAEA,0xFA14},
{0xFAEB,0x6998},
{0xFAEC,0x69E2},
{0xFAED,0x6A30},
{0xFAEE,0x6A6B},
{0xFAEF,0x6A46},
{0xFAF0,0x6A73},
{0xFAF1,0x6A7E},
{0xFAF2,0x6AE2},
{0xFAF3,0x6AE4},
{0xFAF4,0x6BD6},
{0xFAF5,0x6C3F},
{0xFAF6,0x6C5C},
{0xFAF7,0x6C86},
{0xFAF8,0x6C6F},
{0xFAF9,0x6CDA},
{0xFAFA,0x6D04},
{0xFAFB,0x6D87},
{0xFAFC,0x6D6F},
{0xFB40,0x6D96},
{0xFB41,0x6DAC},
{0xFB42,0x6DCF},
{0xFB43,0x6DF8},
{0xFB44,0x6DF2},
{0xFB45,0x6DFC},
{0xFB46,0x6E39},
{0xFB47,0x6E5C},
{0xFB48,0x6E27},
{0xFB49,0x6E3C},
{0xFB4A,0x6EBF},
{0xFB4B,0x6F88},
{0xFB4C,0x6FB5},
{0xFB4D,0x6FF5},
{0xFB4E,0x7005},
{0xFB4F,0x7007},
{0xFB50,0x7028},
{0xFB51,0x7085},
{0xFB52,0x70AB},
{0xFB53,0x710F},
{0xFB54,0x7104},
{0xFB55,0x715C},
{0xFB56,0x7146},
{0xFB57,0x7147},
{0xFB58,0xFA15},
{0xFB59,0x71C1},
{0xFB5A,0x71FE},
{0xFB5B,0x72B1},
{0xFB5C,0x72BE},
{0xFB5D,0x7324},
{0xFB5E,0xFA16},
{0xFB5F,0x7377},
{0xFB60,0x73BD},
{0xFB61,0x73C9},
{0xFB62,0x73D6},
{0xFB63,0x73E3},
{0xFB64,0x73D2},
{0xFB65,0x7407},
{0xFB66,0x73F5},
{0xFB67,0x7426},
{0xFB68,0x742A},
{0xFB69,0x7429},
{0xFB6A,0x742E},
{0xFB6B,0x7462},
{0xFB6C,0x7489},
{0xFB6D,0x749F},
{0xFB6E,0x7501},
{0xFB6F,0x756F},
{0xFB70,0x7682},
{0xFB71,0x769C},
{0xFB72,0x769E},
{0xFB73,0x769B},
{0xFB74,0x76A6},
{0xFB75,0xFA17},
{0xFB76,0x7746},
{0xFB77,0x52AF},
{0xFB78,0x7821},
{0xFB79,0x784E},
{0xFB7A,0x7864},
{0xFB7B,0x787A},
{0xFB7C,0x7930},
{0xFB7D,0xFA18},
{0xFB7E,0xFA19},
{0xFB80,0xFA1A},
{0xFB81,0x7994},
{0xFB82,0xFA1B},
{0xFB83,0x799B},
{0xFB84,0x7AD1},
{0xFB85,0x7AE7},
{0xFB86,0xFA1C},
{0xFB87,0x7AEB},
{0xFB88,0x7B9E},
{0xFB89,0xFA1D},
{0xFB8A,0x7D48},
{0xFB8B,0x7D5C},
{0xFB8C,0x7DB7},
{0xFB8D,0x7DA0},
{0xFB8E,0x7DD6},
{0xFB8F,0x7E52},
{0xFB90,0x7F47},
{0xFB91,0x7FA1},
{0xFB92,0xFA1E},
{0xFB93,0x8301},
{0xFB94,0x8362},
{0xFB95,0x837F},
{0xFB96,0x83C7},
{0xFB97,0x83F6},
{0xFB98,0x8448},
{0xFB99,0x84B4},
{0xFB9A,0x8553},
{0xFB9B,0x8559},
{0xFB9C,0x856B},
{0xFB9D,0xFA1F},
{0xFB9E,0x85B0},
{0xFB9F,0xFA20},
{0xFBA0,0xFA21},
{0xFBA1,0x8807},
{0xFBA2,0x88F5},
{0xFBA3,0x8A12},
{0xFBA4,0x8A37},
{0xFBA5,0x8A79},
{0xFBA6,0x8AA7},
{0xFBA7,0x8ABE},
{0xFBA8,0x8ADF},
{0xFBA9,0xFA22},
{0xFBAA,0x8AF6},
{0xFBAB,0x8B53},
{0xFBAC,0x8B7F},
{0xFBAD,0x8CF0},
{0xFBAE,0x8CF4},
{0xFBAF,0x8D12},
{0xFBB0,0x8D76},
{0xFBB1,0xFA23},
{0xFBB2,0x8ECF},
{0xFBB3,0xFA24},
{0xFBB4,0xFA25},
{0xFBB5,0x9067},
{0xFBB6,0x90DE},
{0xFBB7,0xFA26},
{0xFBB8,0x9115},
{0xFBB9,0x9127},
{0xFBBA,0x91DA},
{0xFBBB,0x91D7},
{0xFBBC,0x91DE},
{0xFBBD,0x91ED},
{0xFBBE,0x91EE},
{0xFBBF,0x91E4},
{0xFBC0,0x91E5},
{0xFBC1,0x9206},
{0xFBC2,0x9210},
{0xFBC3,0x920A},
{0xFBC4,0x923A},
{0xFBC5,0x9240},
{0xFBC6,0x923C},
{0xFBC7,0x924E},
{0xFBC8,0x9259},
{0xFBC9,0x9251},
{0xFBCA,0x9239},
{0xFBCB,0x9267},
{0xFBCC,0x92A7},
{0xFBCD,0x9277},
{0xFBCE,0x9278},
{0xFBCF,0x92E7},
{0xFBD0,0x92D7},
{0xFBD1,0x92D9},
{0xFBD2,0x92D0},
{0xFBD3,0xFA27},
{0xFBD4,0x92D5},
{0xFBD5,0x92E0},
{0xFBD6,0x92D3},
{0xFBD7,0x9325},
{0xFBD8,0x9321},
{0xFBD9,0x92FB},
{0xFBDA,0xFA28},
{0xFBDB,0x931E},
{0xFBDC,0x92FF},
{0xFBDD,0x931D},
{0xFBDE,0x9302},
{0xFBDF,0x9370},
{0xFBE0,0x9357},
{0xFBE1,0x93A4},
{0xFBE2,0x93C6},
{0xFBE3,0x93DE},
{0xFBE4,0x93F8},
{0xFBE5,0x9431},
{0xFBE6,0x9445},
{0xFBE7,0x9448},
{0xFBE8,0x9592},
{0xFBE9,0xF9DC},
{0xFBEA,0xFA29},
{0xFBEB,0x969D},
{0xFBEC,0x96AF},
{0xFBED,0x9733},
{0xFBEE,0x973B},
{0xFBEF,0x9743},
{0xFBF0,0x974D},
{0xFBF1,0x974F},
{0xFBF2,0x9751},
{0xFBF3,0x9755},
{0xFBF4,0x9857},
{0xFBF5,0x9865},
{0xFBF6,0xFA2A},
{0xFBF7,0xFA2B},
{0xFBF8,0x9927},
{0xFBF9,0xFA2C},
{0xFBFA,0x999E},
{0xFBFB,0x9A4E},
{0xFBFC,0x9AD9},
{0xFC40,0x9ADC},
{0xFC41,0x9B75},
{0xFC42,0x9B72},
{0xFC43,0x9B8F},
{0xFC44,0x9BB1},
{0xFC45,0x9BBB},
{0xFC46,0x9C00},
{0xFC47,0x9D70},
{0xFC48,0x9D6B},
{0xFC49,0xFA2D},
{0xFC4A,0x9E19},
{0xFC4B,0x9ED1}
};

int
CharSetCvtShiftJistoUTF8::MapCount()
{
	return sizeof(ShiftJistoUCS2) / sizeof(*ShiftJistoUCS2);
}

CharSetCvt::MapEnt
CharSetCvtUTF8toEUCJP::UCS2toEUCJP[] = {
# ifndef OS_LYNX
{0x0020,0x20}, {0x0021,0x21}, {0x0022,0x22}, {0x0023,0x23}, {0x0024,0x24},
{0x0025,0x25}, {0x0026,0x26}, {0x0027,0x27}, {0x0028,0x28}, {0x0029,0x29},
{0x002A,0x2A}, {0x002B,0x2B}, {0x002C,0x2C}, {0x002D,0x2D}, {0x002E,0x2E},
{0x002F,0x2F}, {0x0030,0x30}, {0x0031,0x31}, {0x0032,0x32}, {0x0033,0x33},
{0x0034,0x34}, {0x0035,0x35}, {0x0036,0x36}, {0x0037,0x37}, {0x0038,0x38},
{0x0039,0x39}, {0x003A,0x3A}, {0x003B,0x3B}, {0x003C,0x3C}, {0x003D,0x3D},
{0x003E,0x3E}, {0x003F,0x3F}, {0x0040,0x40}, {0x0041,0x41}, {0x0042,0x42},
{0x0043,0x43}, {0x0044,0x44}, {0x0045,0x45}, {0x0046,0x46}, {0x0047,0x47},
{0x0048,0x48}, {0x0049,0x49}, {0x004A,0x4A}, {0x004B,0x4B}, {0x004C,0x4C},
{0x004D,0x4D}, {0x004E,0x4E}, {0x004F,0x4F}, {0x0050,0x50}, {0x0051,0x51},
{0x0052,0x52}, {0x0053,0x53}, {0x0054,0x54}, {0x0055,0x55}, {0x0056,0x56},
{0x0057,0x57}, {0x0058,0x58}, {0x0059,0x59}, {0x005A,0x5A}, {0x005B,0x5B},

# ifdef UNICODE_MAPPING
{0x005C,0xA1C0},
# else
{0x005C,0x005C},
# endif
             {0x005D,0x5D}, {0x005E,0x5E}, {0x005F,0x5F}, {0x0060,0x60},
{0x0061,0x61}, {0x0062,0x62}, {0x0063,0x63}, {0x0064,0x64}, {0x0065,0x65},
{0x0066,0x66}, {0x0067,0x67}, {0x0068,0x68}, {0x0069,0x69}, {0x006A,0x6A},
{0x006B,0x6B}, {0x006C,0x6C}, {0x006D,0x6D}, {0x006E,0x6E}, {0x006F,0x6F},
{0x0070,0x70}, {0x0071,0x71}, {0x0072,0x72}, {0x0073,0x73}, {0x0074,0x74},
{0x0075,0x75}, {0x0076,0x76}, {0x0077,0x77}, {0x0078,0x78}, {0x0079,0x79},
{0x007A,0x7A}, {0x007B,0x7B}, {0x007C,0x7C}, {0x007D,0x7D},
# ifdef UNICODE_MAPPING
{0x007E,0x2237},
# else
{0x007E,0x7E},
#endif
{0x00A1,0x2242}, {0x00A2,0xA1F1}, {0x00A3,0xA1F2}, {0x00A4,0x2270}, {0x00A5,0x5C},
{0x00A6,0x2243}, {0x00A7,0xA1F8}, {0x00A8,0xA1AF}, {0x00A9,0x226D}, {0x00AA,0x226C},
{0x00AC,0xA2CC}, {0x00AE,0x226E}, {0x00AF,0x2234}, {0x00B0,0xA1EB}, {0x00B1,0xA1DE},
{0x00B4,0xA1AD}, {0x00B6,0xA2F9}, {0x00B8,0x2231}, {0x00BA,0x226B}, {0x00BF,0x2244},
{0x00C0,0x2A22}, {0x00C1,0x2A21}, {0x00C2,0x2A24}, {0x00C3,0x2A2A}, {0x00C4,0x2A23},
{0x00C5,0x2A29}, {0x00C6,0x2921}, {0x00C7,0x2A2E}, {0x00C8,0x2A32}, {0x00C9,0x2A31},
{0x00CA,0x2A34}, {0x00CB,0x2A33}, {0x00CC,0x2A40}, {0x00CD,0x2A3F}, {0x00CE,0x2A42},
{0x00CF,0x2A41}, {0x00D1,0x2A50}, {0x00D2,0x2A52}, {0x00D3,0x2A51}, {0x00D4,0x2A54},
{0x00D5,0x2A58}, {0x00D6,0x2A53}, {0x00D7,0xA1DF}, {0x00D8,0x292C}, {0x00D9,0x2A63},
{0x00DA,0x2A62}, {0x00DB,0x2A65}, {0x00DC,0x2A64}, {0x00DD,0x2A72}, {0x00DE,0x2930},
{0x00DF,0x294E}, {0x00E0,0x2B22}, {0x00E1,0x2B21}, {0x00E2,0x2B24}, {0x00E3,0x2B2A},
{0x00E4,0x2B23}, {0x00E5,0x2B29}, {0x00E6,0x2941}, {0x00E7,0x2B2E}, {0x00E8,0x2B32},
{0x00E9,0x2B31}, {0x00EA,0x2B34}, {0x00EB,0x2B33}, {0x00EC,0x2B40}, {0x00ED,0x2B3F},
{0x00EE,0x2B42}, {0x00EF,0x2B41}, {0x00F0,0x2943}, {0x00F1,0x2B50}, {0x00F2,0x2B52},
{0x00F3,0x2B51}, {0x00F4,0x2B54}, {0x00F5,0x2B58}, {0x00F6,0x2B53}, {0x00F7,0xA1E0},
{0x00F8,0x294C}, {0x00F9,0x2B63}, {0x00FA,0x2B62}, {0x00FB,0x2B65}, {0x00FC,0x2B64},
{0x00FD,0x2B72}, {0x00FE,0x2950}, {0x00FF,0x2B73}, {0x0100,0x2A27}, {0x0101,0x2B27},
{0x0102,0x2A25}, {0x0103,0x2B25}, {0x0104,0x2A28}, {0x0105,0x2B28}, {0x0106,0x2A2B},
{0x0107,0x2B2B}, {0x0108,0x2A2C}, {0x0109,0x2B2C}, {0x010A,0x2A2F}, {0x010B,0x2B2F},
{0x010C,0x2A2D}, {0x010D,0x2B2D}, {0x010E,0x2A30}, {0x010F,0x2B30}, {0x0110,0x2922},
{0x0111,0x2942}, {0x0112,0x2A37}, {0x0113,0x2B37}, {0x0116,0x2A36}, {0x0117,0x2B36},
{0x0118,0x2A38}, {0x0119,0x2B38}, {0x011A,0x2A35}, {0x011B,0x2B35}, {0x011C,0x2A3A},
{0x011D,0x2B3A}, {0x011E,0x2A3B}, {0x011F,0x2B3B}, {0x0120,0x2A3D}, {0x0121,0x2B3D},
{0x0122,0x2A3C}, {0x0124,0x2A3E}, {0x0125,0x2B3E}, {0x0126,0x2924}, {0x0127,0x2944},
{0x0128,0x2A47}, {0x0129,0x2B47}, {0x012A,0x2A45}, {0x012B,0x2B45}, {0x012E,0x2A46},
{0x012F,0x2B46}, {0x0130,0x2A44}, {0x0131,0x2945}, {0x0132,0x2926}, {0x0133,0x2946},
{0x0134,0x2A48}, {0x0135,0x2B48}, {0x0136,0x2A49}, {0x0137,0x2B49}, {0x0138,0x2947},
{0x0139,0x2A4A}, {0x013A,0x2B4A}, {0x013B,0x2A4C}, {0x013C,0x2B4C}, {0x013D,0x2A4B},
{0x013E,0x2B4B}, {0x013F,0x2929}, {0x0140,0x2949}, {0x0141,0x2928}, {0x0142,0x2948},
{0x0143,0x2A4D}, {0x0144,0x2B4D}, {0x0145,0x2A4F}, {0x0146,0x2B4F}, {0x0147,0x2A4E},
{0x0148,0x2B4E}, {0x0149,0x294A}, {0x014A,0x292B}, {0x014B,0x294B}, {0x014C,0x2A57},
{0x014D,0x2B57}, {0x0150,0x2A56}, {0x0151,0x2B56}, {0x0152,0x292D}, {0x0153,0x294D},
{0x0154,0x2A59}, {0x0155,0x2B59}, {0x0156,0x2A5B}, {0x0157,0x2B5B}, {0x0158,0x2A5A},
{0x0159,0x2B5A}, {0x015A,0x2A5C}, {0x015B,0x2B5C}, {0x015C,0x2A5D}, {0x015D,0x2B5D},
{0x015E,0x2A5F}, {0x015F,0x2B5F}, {0x0160,0x2A5E}, {0x0161,0x2B5E}, {0x0162,0x2A61},
{0x0163,0x2B61}, {0x0164,0x2A60}, {0x0165,0x2B60}, {0x0166,0x292F}, {0x0167,0x294F},
{0x0168,0x2A6C}, {0x0169,0x2B6C}, {0x016A,0x2A69}, {0x016B,0x2B69}, {0x016C,0x2A66},
{0x016D,0x2B66}, {0x016E,0x2A6B}, {0x016F,0x2B6B}, {0x0170,0x2A68}, {0x0171,0x2B68},
{0x0172,0x2A6A}, {0x0173,0x2B6A}, {0x0174,0x2A71}, {0x0175,0x2B71}, {0x0176,0x2A74},
{0x0177,0x2B74}, {0x0178,0x2A73}, {0x0179,0x2A75}, {0x017A,0x2B75}, {0x017B,0x2A77},
{0x017C,0x2B77}, {0x017D,0x2A76}, {0x017E,0x2B76}, {0x01CD,0x2A26}, {0x01CE,0x2B26},
{0x01CF,0x2A43}, {0x01D0,0x2B43}, {0x01D1,0x2A55}, {0x01D2,0x2B55}, {0x01D3,0x2A67},
{0x01D4,0x2B67}, {0x01D5,0x2A70}, {0x01D6,0x2B70}, {0x01D7,0x2A6D}, {0x01D8,0x2B6D},
{0x01D9,0x2A6F}, {0x01DA,0x2B6F}, {0x01DB,0x2A6E}, {0x01DC,0x2B6E}, {0x01F5,0x2B39},
{0x02C7,0x2230}, {0x02D8,0x222F}, {0x02D9,0x2232}, {0x02DA,0x2236}, {0x02DB,0x2235},
{0x02DD,0x2233}, {0x0384,0x2238}, {0x0385,0x2239}, {0x0386,0x2661}, {0x0388,0x2662},
{0x0389,0x2663}, {0x038A,0x2664}, {0x038C,0x2667}, {0x038E,0x2669}, {0x038F,0x266C},
{0x0390,0x2676}, {0x0391,0xA6A1}, {0x0392,0xA6A2}, {0x0393,0xA6A3}, {0x0394,0xA6A4},
{0x0395,0xA6A5}, {0x0396,0xA6A6}, {0x0397,0xA6A7}, {0x0398,0xA6A8}, {0x0399,0xA6A9},
{0x039A,0xA6AA}, {0x039B,0xA6AB}, {0x039C,0xA6AC}, {0x039D,0xA6AD}, {0x039E,0xA6AE},
{0x039F,0xA6AF}, {0x03A0,0xA6B0}, {0x03A1,0xA6B1}, {0x03A3,0xA6B2}, {0x03A4,0xA6B3},
{0x03A5,0xA6B4}, {0x03A6,0xA6B5}, {0x03A7,0xA6B6}, {0x03A8,0xA6B7}, {0x03A9,0xA6B8},
{0x03AA,0x2665}, {0x03AB,0x266A}, {0x03AC,0x2671}, {0x03AD,0x2672}, {0x03AE,0x2673},
{0x03AF,0x2674}, {0x03B0,0x267B}, {0x03B1,0xA6C1}, {0x03B2,0xA6C2}, {0x03B3,0xA6C3},
{0x03B4,0xA6C4}, {0x03B5,0xA6C5}, {0x03B6,0xA6C6}, {0x03B7,0xA6C7}, {0x03B8,0xA6C8},
{0x03B9,0xA6C9}, {0x03BA,0xA6CA}, {0x03BB,0xA6CB}, {0x03BC,0xA6CC}, {0x03BD,0xA6CD},
{0x03BE,0xA6CE}, {0x03BF,0xA6CF}, {0x03C0,0xA6D0}, {0x03C1,0xA6D1}, {0x03C2,0x2678},
{0x03C3,0xA6D2}, {0x03C4,0xA6D3}, {0x03C5,0xA6D4}, {0x03C6,0xA6D5}, {0x03C7,0xA6D6},
{0x03C8,0xA6D7}, {0x03C9,0xA6D8}, {0x03CA,0x2675}, {0x03CB,0x267A}, {0x03CC,0x2677},
{0x03CD,0x2679}, {0x03CE,0x267C}, {0x0401,0xA7A7}, {0x0402,0x2742}, {0x0403,0x2743},
{0x0404,0x2744}, {0x0405,0x2745}, {0x0406,0x2746}, {0x0407,0x2747}, {0x0408,0x2748},
{0x0409,0x2749}, {0x040A,0x274A}, {0x040B,0x274B}, {0x040C,0x274C}, {0x040E,0x274D},
{0x040F,0x274E}, {0x0410,0xA7A1}, {0x0411,0xA7A2}, {0x0412,0xA7A3}, {0x0413,0xA7A4},
{0x0414,0xA7A5}, {0x0415,0xA7A6}, {0x0416,0xA7A8}, {0x0417,0xA7A9}, {0x0418,0xA7AA},
{0x0419,0xA7AB}, {0x041A,0xA7AC}, {0x041B,0xA7AD}, {0x041C,0xA7AE}, {0x041D,0xA7AF},
{0x041E,0xA7B0}, {0x041F,0xA7B1}, {0x0420,0xA7B2}, {0x0421,0xA7B3}, {0x0422,0xA7B4},
{0x0423,0xA7B5}, {0x0424,0xA7B6}, {0x0425,0xA7B7}, {0x0426,0xA7B8}, {0x0427,0xA7B9},
{0x0428,0xA7BA}, {0x0429,0xA7BB}, {0x042A,0xA7BC}, {0x042B,0xA7BD}, {0x042C,0xA7BE},
{0x042D,0xA7BF}, {0x042E,0xA7C0}, {0x042F,0xA7C1}, {0x0430,0xA7D1}, {0x0431,0xA7D2},
{0x0432,0xA7D3}, {0x0433,0xA7D4}, {0x0434,0xA7D5}, {0x0435,0xA7D6}, {0x0436,0xA7D8},
{0x0437,0xA7D9}, {0x0438,0xA7DA}, {0x0439,0xA7DB}, {0x043A,0xA7DC}, {0x043B,0xA7DD},
{0x043C,0xA7DE}, {0x043D,0xA7DF}, {0x043E,0xA7E0}, {0x043F,0xA7E1}, {0x0440,0xA7E2},
{0x0441,0xA7E3}, {0x0442,0xA7E4}, {0x0443,0xA7E5}, {0x0444,0xA7E6}, {0x0445,0xA7E7},
{0x0446,0xA7E8}, {0x0447,0xA7E9}, {0x0448,0xA7EA}, {0x0449,0xA7EB}, {0x044A,0xA7EC},
{0x044B,0xA7ED}, {0x044C,0xA7EE}, {0x044D,0xA7EF}, {0x044E,0xA7F0}, {0x044F,0xA7F1},
{0x0451,0xA7D7}, {0x0452,0x2772}, {0x0453,0x2773}, {0x0454,0x2774}, {0x0455,0x2775},
{0x0456,0x2776}, {0x0457,0x2777}, {0x0458,0x2778}, {0x0459,0x2779}, {0x045A,0x277A},
{0x045B,0x277B}, {0x045C,0x277C}, {0x045E,0x277D}, {0x045F,0x277E}, {0x2010,0xA1BE},
{0x2015,0xA1BD}, {0x2016,0xA1C2}, {0x2018,0xA1C6}, {0x2019,0xA1C7}, {0x201C,0xA1C8},
{0x201D,0xA1C9}, {0x2020,0xA2F7}, {0x2021,0xA2F8}, {0x2025,0xA1C5}, {0x2026,0xA1C4},
{0x2030,0xA2F3}, {0x2032,0xA1EC}, {0x2033,0xA1ED}, {0x203B,0xA2A8}, {0x203E,0x7E},
{0x2103,0xA1EE},
{0x2116,0xADE2},
{0x2121,0xADE4},
{0x2122,0x226F}, {0x212B,0xA2F2},
{0x2160,0xADB5},
{0x2161,0xADB6},
{0x2162,0xADB7},
{0x2163,0xADB8},
{0x2164,0xADB9},
{0x2165,0xADBA},
{0x2166,0xADBB},
{0x2167,0xADBC},
{0x2168,0xADBD},
{0x2169,0xADBE},
{0x2170,0x7373},
{0x2171,0x7374},
{0x2172,0x7375},
{0x2173,0x7376},
{0x2174,0x7377},
{0x2175,0x7378},
{0x2176,0x7379},
{0x2177,0x737A},
{0x2178,0x737B},
{0x2179,0x737C},
{0x2190,0xA2AB},
{0x2191,0xA2AC}, {0x2192,0xA2AA}, {0x2193,0xA2AD}, {0x21D2,0xA2CD}, {0x21D4,0xA2CE},
{0x2200,0xA2CF}, {0x2202,0xA2DF}, {0x2203,0xA2D0}, {0x2207,0xA2E0}, {0x2208,0xA2BA},
{0x220B,0xA2BB},
{0x2211,0xADF4},
{0x2212,0xA1DD}, {0x221A,0xA2E5}, {0x221D,0xA2E7}, {0x221E,0xA1E7},
{0x221F,0xADF8},
{0x2220,0xA2DC},
// {0x2220,0xADF7}, alternative
{0x2225,0xA1C2},
{0x2227,0xA2CA}, {0x2228,0xA2CB}, {0x2229,0xA2C1}, {0x222A,0xA2C0},
// {0x2229,0xADFB}, {0x222A,0xADFC}, {0x222B,0xADF2}, alternatives
{0x222B,0xA2E9}, {0x222C,0xA2EA},
{0x222E,0xADF3},
{0x2234,0xA1E8}, {0x2235,0xA2E8},
// {0x2235,0xADFA}, alternative
{0x223D,0xA2E6},
// {0x2252,0xADF0}, alternative
{0x2252,0xA2E2}, {0x2260,0xA1E2}, {0x2261,0xA2E1}, {0x2266,0xA1E5}, {0x2267,0xA1E6},
{0x226A,0xA2E3}, {0x226B,0xA2E4}, {0x2282,0xA2BE}, {0x2283,0xA2BF}, {0x2286,0xA2BC},
{0x2287,0xA2BD}, {0x22A5,0xA2DD},
// {0x22A5,0xADF6}, alternative
{0x22BF,0xADF9},
{0x2312,0xA2DE},
{0x2460,0xADA1},
{0x2461,0xADA2},
{0x2462,0xADA3},
{0x2463,0xADA4},
{0x2464,0xADA5},
{0x2465,0xADA6},
{0x2466,0xADA7},
{0x2467,0xADA8},
{0x2468,0xADA9},
{0x2469,0xADAA},
{0x246A,0xADAB},
{0x246B,0xADAC},
{0x246C,0xADAD},
{0x246D,0xADAE},
{0x246E,0xADAF},
{0x246F,0xADB0},
{0x2470,0xADB1},
{0x2471,0xADB2},
{0x2472,0xADB3},
{0x2473,0xADB4},
{0x2500,0xA8A1}, {0x2501,0xA8AC},
{0x2502,0xA8A2}, {0x2503,0xA8AD}, {0x250C,0xA8A3}, {0x250F,0xA8AE}, {0x2510,0xA8A4},
{0x2513,0xA8AF}, {0x2514,0xA8A6}, {0x2517,0xA8B1}, {0x2518,0xA8A5}, {0x251B,0xA8B0},
{0x251C,0xA8A7}, {0x251D,0xA8BC}, {0x2520,0xA8B7}, {0x2523,0xA8B2}, {0x2524,0xA8A9},
{0x2525,0xA8BE}, {0x2528,0xA8B9}, {0x252B,0xA8B4}, {0x252C,0xA8A8}, {0x252F,0xA8B8},
{0x2530,0xA8BD}, {0x2533,0xA8B3}, {0x2534,0xA8AA}, {0x2537,0xA8BA}, {0x2538,0xA8BF},
{0x253B,0xA8B5}, {0x253C,0xA8AB}, {0x253F,0xA8BB}, {0x2542,0xA8C0}, {0x254B,0xA8B6},
{0x25A0,0xA2A3}, {0x25A1,0xA2A2}, {0x25B2,0xA2A5}, {0x25B3,0xA2A4}, {0x25BC,0xA2A7},
{0x25BD,0xA2A6}, {0x25C6,0xA2A1}, {0x25C7,0xA1FE}, {0x25CB,0xA1FB}, {0x25CE,0xA1FD},
{0x25CF,0xA1FC}, {0x25EF,0xA2FE}, {0x2605,0xA1FA}, {0x2606,0xA1F9}, {0x2640,0xA1EA},
{0x2642,0xA1E9}, {0x266A,0xA2F6}, {0x266D,0xA2F5}, {0x266F,0xA2F4}, {0x3000,0xA1A1}, 
{0x3001,0xA1A2}, {0x3002,0xA1A3}, {0x3003,0xA1B7}, {0x3005,0xA1B9}, {0x3006,0xA1BA},
{0x3007,0xA1BB}, {0x3008,0xA1D2}, {0x3009,0xA1D3}, {0x300A,0xA1D4}, {0x300B,0xA1D5},
{0x300C,0xA1D6}, {0x300D,0xA1D7}, {0x300E,0xA1D8}, {0x300F,0xA1D9}, {0x3010,0xA1DA},
{0x3011,0xA1DB}, {0x3012,0xA2A9}, {0x3013,0xA2AE}, {0x3014,0xA1CC}, {0x3015,0xA1CD},
{0x301C,0xA1C1},
{0x301D,0xADE0},
{0x301F,0xADE1},
{0x3041,0xA4A1}, {0x3042,0xA4A2}, {0x3043,0xA4A3}, {0x3044,0xA4A4},
{0x3045,0xA4A5}, {0x3046,0xA4A6}, {0x3047,0xA4A7}, {0x3048,0xA4A8}, {0x3049,0xA4A9},
{0x304A,0xA4AA}, {0x304B,0xA4AB}, {0x304C,0xA4AC}, {0x304D,0xA4AD}, {0x304E,0xA4AE},
{0x304F,0xA4AF}, {0x3050,0xA4B0}, {0x3051,0xA4B1}, {0x3052,0xA4B2}, {0x3053,0xA4B3},
{0x3054,0xA4B4}, {0x3055,0xA4B5}, {0x3056,0xA4B6}, {0x3057,0xA4B7}, {0x3058,0xA4B8},
{0x3059,0xA4B9}, {0x305A,0xA4BA}, {0x305B,0xA4BB}, {0x305C,0xA4BC}, {0x305D,0xA4BD},
{0x305E,0xA4BE}, {0x305F,0xA4BF}, {0x3060,0xA4C0}, {0x3061,0xA4C1}, {0x3062,0xA4C2},
{0x3063,0xA4C3}, {0x3064,0xA4C4}, {0x3065,0xA4C5}, {0x3066,0xA4C6}, {0x3067,0xA4C7},
{0x3068,0xA4C8}, {0x3069,0xA4C9}, {0x306A,0xA4CA}, {0x306B,0xA4CB}, {0x306C,0xA4CC},
{0x306D,0xA4CD}, {0x306E,0xA4CE}, {0x306F,0xA4CF}, {0x3070,0xA4D0}, {0x3071,0xA4D1},
{0x3072,0xA4D2}, {0x3073,0xA4D3}, {0x3074,0xA4D4}, {0x3075,0xA4D5}, {0x3076,0xA4D6},
{0x3077,0xA4D7}, {0x3078,0xA4D8}, {0x3079,0xA4D9}, {0x307A,0xA4DA}, {0x307B,0xA4DB},
{0x307C,0xA4DC}, {0x307D,0xA4DD}, {0x307E,0xA4DE}, {0x307F,0xA4DF}, {0x3080,0xA4E0},
{0x3081,0xA4E1}, {0x3082,0xA4E2}, {0x3083,0xA4E3}, {0x3084,0xA4E4}, {0x3085,0xA4E5},
{0x3086,0xA4E6}, {0x3087,0xA4E7}, {0x3088,0xA4E8}, {0x3089,0xA4E9}, {0x308A,0xA4EA},
{0x308B,0xA4EB}, {0x308C,0xA4EC}, {0x308D,0xA4ED}, {0x308E,0xA4EE}, {0x308F,0xA4EF},
{0x3090,0xA4F0}, {0x3091,0xA4F1}, {0x3092,0xA4F2}, {0x3093,0xA4F3}, {0x309B,0xA1AB},
{0x309C,0xA1AC}, {0x309D,0xA1B5}, {0x309E,0xA1B6}, {0x30A1,0xA5A1}, {0x30A2,0xA5A2},
{0x30A3,0xA5A3}, {0x30A4,0xA5A4}, {0x30A5,0xA5A5}, {0x30A6,0xA5A6}, {0x30A7,0xA5A7},
{0x30A8,0xA5A8}, {0x30A9,0xA5A9}, {0x30AA,0xA5AA}, {0x30AB,0xA5AB}, {0x30AC,0xA5AC},
{0x30AD,0xA5AD}, {0x30AE,0xA5AE}, {0x30AF,0xA5AF}, {0x30B0,0xA5B0}, {0x30B1,0xA5B1},
{0x30B2,0xA5B2}, {0x30B3,0xA5B3}, {0x30B4,0xA5B4}, {0x30B5,0xA5B5}, {0x30B6,0xA5B6},
{0x30B7,0xA5B7}, {0x30B8,0xA5B8}, {0x30B9,0xA5B9}, {0x30BA,0xA5BA}, {0x30BB,0xA5BB},
{0x30BC,0xA5BC}, {0x30BD,0xA5BD}, {0x30BE,0xA5BE}, {0x30BF,0xA5BF}, {0x30C0,0xA5C0},
{0x30C1,0xA5C1}, {0x30C2,0xA5C2}, {0x30C3,0xA5C3}, {0x30C4,0xA5C4}, {0x30C5,0xA5C5},
{0x30C6,0xA5C6}, {0x30C7,0xA5C7}, {0x30C8,0xA5C8}, {0x30C9,0xA5C9}, {0x30CA,0xA5CA},
{0x30CB,0xA5CB}, {0x30CC,0xA5CC}, {0x30CD,0xA5CD}, {0x30CE,0xA5CE}, {0x30CF,0xA5CF},
{0x30D0,0xA5D0}, {0x30D1,0xA5D1}, {0x30D2,0xA5D2}, {0x30D3,0xA5D3}, {0x30D4,0xA5D4},
{0x30D5,0xA5D5}, {0x30D6,0xA5D6}, {0x30D7,0xA5D7}, {0x30D8,0xA5D8}, {0x30D9,0xA5D9},
{0x30DA,0xA5DA}, {0x30DB,0xA5DB}, {0x30DC,0xA5DC}, {0x30DD,0xA5DD}, {0x30DE,0xA5DE},
{0x30DF,0xA5DF}, {0x30E0,0xA5E0}, {0x30E1,0xA5E1}, {0x30E2,0xA5E2}, {0x30E3,0xA5E3},
{0x30E4,0xA5E4}, {0x30E5,0xA5E5}, {0x30E6,0xA5E6}, {0x30E7,0xA5E7}, {0x30E8,0xA5E8},
{0x30E9,0xA5E9}, {0x30EA,0xA5EA}, {0x30EB,0xA5EB}, {0x30EC,0xA5EC}, {0x30ED,0xA5ED},
{0x30EE,0xA5EE}, {0x30EF,0xA5EF}, {0x30F0,0xA5F0}, {0x30F1,0xA5F1}, {0x30F2,0xA5F2},
{0x30F3,0xA5F3}, {0x30F4,0xA5F4}, {0x30F5,0xA5F5}, {0x30F6,0xA5F6}, {0x30FB,0xA1A6},
{0x30FC,0xA1BC}, {0x30FD,0xA1B3}, {0x30FE,0xA1B4},
{0x3231,0xADEA},
{0x3232,0xADEB},
{0x3239,0xADEC},
{0x32A4,0xADE5},
{0x32A5,0xADE6},
{0x32A6,0xADE7},
{0x32A7,0xADE8},
{0x32A8,0xADE9},
{0x3303,0xADC6},
{0x330D,0xADCA},
{0x3314,0xADC1},
{0x3318,0xADC4},
{0x3322,0xADC2},
{0x3323,0xADCC},
{0x3326,0xADCB},
{0x3327,0xADC5},
{0x332B,0xADCD},
{0x3336,0xADC7},
{0x333B,0xADCF},
{0x3349,0xADC0},
{0x334A,0xADCE},
{0x334D,0xADC3},
{0x3351,0xADC8},
{0x3357,0xADC9},
{0x337B,0xADDF},
{0x337C,0xADEF},
{0x337D,0xADEE},
{0x337E,0xADED},
{0x338E,0xADD3},
{0x338F,0xADD4},
{0x339C,0xADD0},
{0x339D,0xADD1},
{0x339E,0xADD2},
{0x33A1,0xADD6},
{0x33C4,0xADD5},
{0x33CD,0xADE3},
{0x4E00,0xB0EC}, {0x4E01,0xC3FA},
{0x4E02,0x3021}, {0x4E03,0xBCB7}, {0x4E04,0x3022}, {0x4E05,0x3023}, {0x4E07,0xCBFC},
{0x4E08,0xBEE6}, {0x4E09,0xBBB0}, {0x4E0A,0xBEE5}, {0x4E0B,0xB2BC}, {0x4E0C,0x3024},
{0x4E0D,0xC9D4}, {0x4E0E,0xCDBF}, {0x4E10,0xD0A2}, {0x4E11,0xB1AF}, {0x4E12,0x3025},
{0x4E14,0xB3EE}, {0x4E15,0xD0A3}, {0x4E16,0xC0A4}, {0x4E17,0xD2C2}, {0x4E18,0xB5D6},
{0x4E19,0xCABA}, {0x4E1E,0xBEE7}, {0x4E1F,0x3026}, {0x4E21,0xCEBE}, {0x4E23,0x3027},
// {0x4E28, 0xF9AD}, alternative
{0x4E24,0x3028}, {0x4E26,0xCAC2}, {0x4E28,0x3029}, {0x4E2A,0xD0A4}, {0x4E2B,0x302A},
{0x4E2D,0xC3E6}, {0x4E2E,0x302B}, {0x4E2F,0x302C}, {0x4E30,0x302D}, {0x4E31,0xD0A5},
{0x4E32,0xB6FA}, {0x4E35,0x302E}, {0x4E36,0xD0A6}, {0x4E38,0xB4DD}, {0x4E39,0xC3B0},
{0x4E3B,0xBCE7}, {0x4E3C,0xD0A7}, {0x4E3F,0xD0A8}, {0x4E40,0x302F}, {0x4E41,0x3030},
{0x4E42,0xD0A9}, {0x4E43,0xC7B5}, {0x4E44,0x3031}, {0x4E45,0xB5D7}, {0x4E47,0x3032},
{0x4E4B,0xC7B7}, {0x4E4D,0xC6E3}, {0x4E4E,0xB8C3}, {0x4E4F,0xCBB3}, {0x4E51,0x3033},
{0x4E55,0xE9C9}, {0x4E56,0xD0AA}, {0x4E57,0xBEE8}, {0x4E58,0xD0AB}, {0x4E59,0xB2B5},
{0x4E5A,0x3034}, {0x4E5C,0x3035}, {0x4E5D,0xB6E5}, {0x4E5E,0xB8F0}, {0x4E5F,0xCCE9},
{0x4E62,0xD6A6}, {0x4E63,0x3036}, {0x4E68,0x3037}, {0x4E69,0x3038}, {0x4E71,0xCDF0},
{0x4E73,0xC6FD}, {0x4E74,0x3039}, {0x4E75,0x303A}, {0x4E79,0x303B}, {0x4E7E,0xB4A5},
{0x4E7F,0x303C}, {0x4E80,0xB5B5}, {0x4E82,0xD0AC}, {0x4E85,0xD0AD}, {0x4E86,0xCEBB},
{0x4E88,0xCDBD}, {0x4E89,0xC1E8}, {0x4E8A,0xD0AF}, {0x4E8B,0xBBF6}, {0x4E8C,0xC6F3},
{0x4E8D,0x303D}, {0x4E8E,0xD0B2}, {0x4E91,0xB1BE}, {0x4E92,0xB8DF}, {0x4E94,0xB8DE},
{0x4E95,0xB0E6}, {0x4E96,0x303E}, {0x4E97,0x303F}, {0x4E98,0xCFCB}, {0x4E99,0xCFCA},
{0x4E9B,0xBAB3}, {0x4E9C,0xB0A1}, {0x4E9D,0x3040}, {0x4E9E,0xD0B3}, {0x4E9F,0xD0B4},
{0x4EA0,0xD0B5}, {0x4EA1,0xCBB4}, {0x4EA2,0xD0B6}, {0x4EA4,0xB8F2}, {0x4EA5,0xB0E7},
{0x4EA6,0xCBF2}, {0x4EA8,0xB5FC}, {0x4EAB,0xB5FD}, {0x4EAC,0xB5FE}, {0x4EAD,0xC4E2},
{0x4EAE,0xCEBC}, {0x4EAF,0x3041}, {0x4EB0,0xD0B7}, {0x4EB3,0xD0B8}, {0x4EB6,0xD0B9},
{0x4EB9,0x3042}, {0x4EBA,0xBFCD}, {0x4EC0,0xBDBA}, {0x4EC1,0xBFCE}, {0x4EC2,0xD0BE},
{0x4EC3,0x3043}, {0x4EC4,0xD0BC}, {0x4EC6,0xD0BD}, {0x4EC7,0xB5D8}, {0x4ECA,0xBAA3},
{0x4ECB,0xB2F0}, {0x4ECD,0xD0BB}, {0x4ECE,0xD0BA}, {0x4ECF,0xCAA9}, {0x4ED0,0x3044},
{0x4ED4,0xBBC6}, {0x4ED5,0xBBC5}, {0x4ED6,0xC2BE}, {0x4ED7,0xD0BF}, {0x4ED8,0xC9D5},
{0x4ED9,0xC0E7}, {0x4EDA,0x3045}, {0x4EDB,0x3046}, {0x4EDD,0xA1B8}, {0x4EDE,0xD0C0},
// {0x4EE1, 0xF9AE}, alternative
{0x4EDF,0xD0C2}, {0x4EE0,0x3047}, {0x4EE1,0x3048}, {0x4EE2,0x3049}, {0x4EE3,0xC2E5},
{0x4EE4,0xCEE1}, {0x4EE5,0xB0CA}, {0x4EE8,0x304A}, {0x4EED,0xD0C1}, {0x4EEE,0xB2BE},
{0x4EEF,0x304B}, {0x4EF0,0xB6C4}, {0x4EF1,0x304C}, {0x4EF2,0xC3E7}, {0x4EF3,0x304D},
{0x4EF5,0x304E}, {0x4EF6,0xB7EF}, {0x4EF7,0xD0C3}, {0x4EFB,0xC7A4},
{0x4EFC,0x742f},
{0x4EFD,0x304F},
{0x4EFE,0x3050}, {0x4EFF,0x3051}, {0x4F00,0x3052}, {0x4F01,0xB4EB}, {0x4F02,0x3053},
// {0x4F00,0xF9B0}, {0x4F03,0xF9B1}, alternatives
{0x4F03,0x3054}, {0x4F08,0x3055}, {0x4F09,0xD0C4}, {0x4F0A,0xB0CB}, {0x4F0B,0x3056},
{0x4F0C,0x3057}, {0x4F0D,0xB8E0}, {0x4F0E,0xB4EC}, {0x4F0F,0xC9FA}, {0x4F10,0xC8B2},
{0x4F11,0xB5D9}, {0x4F12,0x3058}, {0x4F15,0x3059}, {0x4F16,0x305A}, {0x4F17,0x305B},
{0x4F19,0x305C}, {0x4F1A,0xB2F1}, {0x4F1C,0xD0E7}, {0x4F1D,0xC5C1}, {0x4F2E,0x305D},
{0x4F2F,0xC7EC}, {0x4F30,0xD0C6}, {0x4F31,0x305E}, {0x4F33,0x3060}, {0x4F34,0xC8BC},
{0x4F35,0x3061}, {0x4F36,0xCEE2}, {0x4F37,0x3062}, {0x4F38,0xBFAD}, {0x4F39,0x3063},
// {0x4F39,0xF9B2}, alternative
{0x4F3A,0xBBC7}, {0x4F3B,0x3064}, {0x4F3C,0xBBF7}, {0x4F3D,0xB2C0}, {0x4F3E,0x3065},
{0x4F40,0x3066}, {0x4F42,0x3067}, {0x4F43,0xC4D1}, {0x4F46,0xC3A2}, {0x4F47,0xD0CA},
{0x4F48,0x3068}, {0x4F49,0x3069}, {0x4F4B,0x306A}, {0x4F4C,0x306B}, {0x4F4D,0xB0CC},
{0x4F4E,0xC4E3}, {0x4F4F,0xBDBB}, {0x4F50,0xBAB4}, {0x4F51,0xCDA4}, {0x4F52,0x306C},
{0x4F53,0xC2CE}, {0x4F54,0x306D}, {0x4F55,0xB2BF}, {0x4F56,0x306E}, {0x4F57,0xD0C9},
// {0x4F56, 0xF9B3}, alternative
{0x4F58,0x306F}, {0x4F59,0xCDBE}, {0x4F5A,0xD0C5}, {0x4F5B,0xD0C7}, {0x4F5C,0xBAEE},
{0x4F5D,0xD0C8}, {0x4F5E,0xD5A4}, {0x4F5F,0x3070}, {0x4F60,0x305F}, {0x4F63,0x3071},
{0x4F69,0xD0D0}, {0x4F6A,0x3072}, {0x4F6C,0x3073}, {0x4F6E,0x3074}, {0x4F6F,0xD0D3},
{0x4F70,0xD0D1}, {0x4F71,0x3075}, {0x4F73,0xB2C2}, {0x4F75,0xCABB}, {0x4F76,0xD0CB},
{0x4F77,0x3076}, {0x4F78,0x3077}, {0x4F79,0x3078}, {0x4F7A,0x3079}, {0x4F7B,0xD0CF},
{0x4F7C,0xB8F3}, {0x4F7D,0x307A}, {0x4F7E,0x307B}, {0x4F7F,0xBBC8}, {0x4F81,0x307C},
{0x4F82,0x307D}, {0x4F83,0xB4A6}, {0x4F84,0x307E}, {0x4F85,0x3121}, {0x4F86,0xD0D4},
{0x4F88,0xD0CC}, {0x4F89,0x3122}, {0x4F8A,0x3123}, {0x4F8B,0xCEE3}, {0x4F8C,0x3124},
// {0x4F8A, 0xF9B5}, alternative
{0x4F8D,0xBBF8}, {0x4F8E,0x3125}, {0x4F8F,0xD0CD}, {0x4F90,0x3126}, {0x4F91,0xD0D2},
{0x4F92,0x3127}, {0x4F93,0x3128}, {0x4F94,0x3129}, {0x4F96,0xD0D5}, {0x4F97,0x312A},
// {0x4F92,0xF9B4}, {0x4F94,0xF9B7}, {0x4F9A,0xF9B6}, alternatives
{0x4F98,0xD0CE}, {0x4F99,0x312B}, {0x4F9A,0x312C}, {0x4F9B,0xB6A1}, {0x4F9D,0xB0CD},
{0x4F9E,0x312D}, {0x4F9F,0x312E}, {0x4FA0,0xB6A2}, {0x4FA1,0xB2C1}, {0x4FAB,0xD5A5},
{0x4FAD,0xCBF9}, {0x4FAE,0xC9EE}, {0x4FAF,0xB8F4}, {0x4FB2,0x312F}, {0x4FB5,0xBFAF},
{0x4FB6,0xCEB7}, {0x4FB7,0x3130}, {0x4FB9,0x3131}, {0x4FBB,0x3132}, {0x4FBC,0x3133},
{0x4FBD,0x3134}, {0x4FBE,0x3135}, {0x4FBF,0xCAD8}, {0x4FC0,0x3136}, {0x4FC1,0x3137},
{0x4FC2,0xB7B8}, {0x4FC3,0xC2A5}, {0x4FC4,0xB2E4}, {0x4FC5,0x3138}, {0x4FC6,0x3139},
{0x4FC8,0x313A}, {0x4FC9,0x313B}, {0x4FCA,0xBDD3}, {0x4FCB,0x313C}, {0x4FCC,0x313D},
// {0x4FC9,0xF9A6}, {0x4FCD,0xF9B8}, alternatives
{0x4FCD,0x313E}, {0x4FCE,0xD0D9}, {0x4FCF,0x313F}, {0x4FD0,0xD0DE}, {0x4FD1,0xD0DC},
{0x4FD2,0x3140}, {0x4FD4,0xD0D7}, {0x4FD7,0xC2AF}, {0x4FD8,0xD0DA}, {0x4FDA,0xD0DD},
{0x4FDB,0xD0DB}, {0x4FDC,0x3141}, {0x4FDD,0xCADD}, {0x4FDF,0xD0D8}, {0x4FE0,0x3142},
{0x4FE1,0xBFAE}, {0x4FE2,0x3143}, {0x4FE3,0xCBF3}, {0x4FE4,0xD0DF}, {0x4FE5,0xD0E0},
{0x4FEE,0xBDA4}, {0x4FEF,0xD0ED}, {0x4FF0,0x3144}, {0x4FF2,0x3145}, {0x4FF3,0xC7D0},
{0x4FF5,0xC9B6}, {0x4FF6,0xD0E8}, {0x4FF8,0xCAF0}, {0x4FFA,0xB2B6}, {0x4FFC,0x3146},
{0x4FFD,0x3147}, {0x4FFE,0xD0EC}, {0x4FFF,0x3148}, {0x5000,0x3149}, {0x5001,0x314A},
// {0x4FFF,0xF9BB}, alternative
{0x5004,0x314B}, {0x5005,0xD0E6}, {0x5006,0xD0EF}, {0x5007,0x314C}, {0x5009,0xC1D2},
{0x500A,0x314D}, {0x500B,0xB8C4}, {0x500C,0x314E}, {0x500D,0xC7DC}, {0x500E,0x314F},
{0x500F,0xE0C7}, {0x5010,0x3150}, {0x5011,0xD0EE}, {0x5012,0xC5DD}, {0x5013,0x3151},
{0x5014,0xD0E3}, {0x5016,0xB8F6}, {0x5017,0x3152}, {0x5018,0x3153}, {0x5019,0xB8F5},
{0x501A,0xD0E1}, {0x501B,0x3154}, {0x501C,0x3155}, {0x501D,0x3156}, {0x501E,0x3157},
// {0x501E,0xF9BC}, {0x5022,0xF9BA}, alternatives
{0x501F,0xBCDA}, {0x5021,0xD0E9}, {0x5022,0x3158}, {0x5023,0xCAEF}, {0x5024,0xC3CD},
{0x5025,0xD0E5}, {0x5026,0xB7F1}, {0x5027,0x3159}, {0x5028,0xD0E2}, {0x5029,0xD0EA},
{0x502A,0xD0E4}, {0x502B,0xCED1}, {0x502C,0xD0EB}, {0x502D,0xCFC1}, {0x502E,0x315A},
{0x5030,0x315B}, {0x5032,0x315C}, {0x5033,0x315D}, {0x5035,0x315E}, {0x5036,0xB6E6},
{0x5039,0xB7F0}, {0x503B,0x3176}, {0x5040,0x315F}, {0x5041,0x3160}, {0x5042,0x3161},
// {0x5040,0xF9B9}, {0x5042,0xF9BF}, {0x5046,0xF9BD}, alternatives
{0x5043,0xD0F0}, {0x5045,0x3162}, {0x5046,0x3163}, {0x5047,0xD0F1}, {0x5048,0xD0F5},
{0x5049,0xB0CE}, {0x504A,0x3164}, {0x504C,0x3165}, {0x504E,0x3166}, {0x504F,0xCAD0},
{0x5050,0xD0F4}, {0x5051,0x3167}, {0x5052,0x3168}, {0x5053,0x3169}, {0x5055,0xD0F3},
{0x5056,0xD0F7}, {0x5057,0x316A}, {0x5059,0x316B}, {0x505A,0xD0F6}, {0x505C,0xC4E4},
{0x505F,0x316C}, {0x5060,0x316D}, {0x5062,0x316E}, {0x5063,0x316F}, {0x5065,0xB7F2},
{0x5066,0x3170}, {0x5067,0x3171}, {0x506A,0x3172}, {0x506C,0xD0F8}, {0x506D,0x3173},
// {0x5070,0xF9BE}, alternative
{0x5070,0x3174}, {0x5071,0x3175}, {0x5072,0xBCC5}, {0x5074,0xC2A6}, {0x5075,0xC4E5},
{0x5076,0xB6F6}, {0x5078,0xD0F9}, {0x507D,0xB5B6}, {0x5080,0xD0FA}, {0x5081,0x3177},
{0x5083,0x3178}, {0x5084,0x3179}, {0x5085,0xD0FC}, {0x5086,0x317A}, {0x508A,0x317B},
{0x508D,0xCBB5}, {0x508E,0x317C}, {0x508F,0x317D}, {0x5090,0x317E}, {0x5091,0xB7E6},
// {0x5094,0xF9C0}, alternative
{0x5092,0x3221}, {0x5093,0x3222}, {0x5094,0x3223}, {0x5096,0x3224}, {0x5098,0xBBB1},
{0x5099,0xC8F7}, {0x509A,0xD0FB}, {0x509B,0x3225}, {0x509C,0x3226}, {0x509E,0x3227},
{0x509F,0x3228}, {0x50A0,0x3229}, {0x50A1,0x322A}, {0x50A2,0x322B}, {0x50AA,0x322C},
{0x50AC,0xBAC5}, {0x50AD,0xCDC3}, {0x50AF,0x322D}, {0x50B0,0x322E}, {0x50B2,0xD0FE},
{0x50B3,0xD1A3}, {0x50B4,0xD0FD}, {0x50B5,0xBAC4}, {0x50B7,0xBDFD}, {0x50B9,0x322F},
{0x50BA,0x3230}, {0x50BD,0x3231}, {0x50BE,0xB7B9}, {0x50C0,0x3232}, {0x50C2,0xD1A4},
{0x50C3,0x3233}, {0x50C4,0x3234}, {0x50C5,0xB6CF}, {0x50C7,0x3235}, {0x50C9,0xD1A1},
{0x50CA,0xD1A2}, {0x50CC,0x3236}, {0x50CD,0xC6AF}, {0x50CE,0x3237}, {0x50CF,0xC1FC},
{0x50D0,0x3238}, {0x50D1,0xB6A3}, {0x50D3,0x3239}, {0x50D4,0x323A}, {0x50D5,0xCBCD},
// {0x50D8,0xF9C2}, alternative
{0x50D6,0xD1A5}, {0x50D8,0x323B}, {0x50DA,0xCEBD}, {0x50DC,0x323C}, {0x50DD,0x323D},
{0x50DE,0xD1A6}, {0x50DF,0x323E}, {0x50E2,0x323F}, {0x50E3,0xD1A9}, {0x50E4,0x3240},
{0x50E5,0xD1A7}, {0x50E6,0x3241}, {0x50E7,0xC1CE}, {0x50E8,0x3242}, {0x50E9,0x3243},
{0x50ED,0xD1A8}, {0x50EE,0xD1AA}, {0x50EF,0x3244}, {0x50F1,0x3245}, {0x50F2,0x3251},
{0x50F4,0x7430},
{0x50F5,0xD1AC}, {0x50F6,0x3246}, {0x50F9,0xD1AB}, {0x50FA,0x3247}, {0x50FB,0xCAC8},
{0x50FE,0x3248}, {0x5100,0xB5B7}, {0x5101,0xD1AE}, {0x5102,0xD1AF}, {0x5103,0x3249},
{0x5104,0xB2AF}, {0x5106,0x324A}, {0x5107,0x324B}, {0x5108,0x324C}, {0x5109,0xD1AD},
{0x510B,0x324D}, {0x510C,0x324E}, {0x510D,0x324F}, {0x510E,0x3250}, {0x5110,0x3252},
{0x5112,0xBCF4}, {0x5114,0xD1B2}, {0x5115,0xD1B1}, {0x5116,0xD1B0}, {0x5117,0x3253},
{0x5118,0xD0D6}, {0x5119,0x3254}, {0x511A,0xD1B3}, {0x511B,0x3255}, {0x511C,0x3256},
{0x511D,0x3257}, {0x511E,0x3258}, {0x511F,0xBDFE}, {0x5121,0xD1B4}, {0x5123,0x3259},
{0x5127,0x325A}, {0x5128,0x325B}, {0x512A,0xCDA5}, {0x512C,0x325C}, {0x512D,0x325D},
{0x512F,0x325E}, {0x5131,0x325F}, {0x5132,0xCCD9}, {0x5133,0x3260}, {0x5134,0x3261},
{0x5135,0x3262}, {0x5137,0xD1B6}, {0x5138,0x3263}, {0x5139,0x3264}, {0x513A,0xD1B5},
{0x513B,0xD1B8}, {0x513C,0xD1B7}, {0x513F,0xD1B9}, {0x5140,0xD1BA}, {0x5141,0xB0F4},
{0x5142,0x3265}, {0x5143,0xB8B5}, {0x5144,0xB7BB}, {0x5145,0xBDBC}, {0x5146,0xC3FB},
// {0x514A,0xF9C3}, alternative
{0x5147,0xB6A4}, {0x5148,0xC0E8}, {0x5149,0xB8F7}, {0x514A,0x3266}, {0x514B,0xB9EE},
{0x514C,0xD1BC}, {0x514D,0xCCC8}, {0x514E,0xC5C6}, {0x514F,0x3267}, {0x5150,0xBBF9},
{0x5152,0xD1BB}, {0x5153,0x3268}, {0x5154,0xD1BD}, {0x5155,0x3269}, {0x5157,0x326A},
{0x5158,0x326B}, {0x515A,0xC5DE}, {0x515C,0xB3F5}, {0x515F,0x326C}, {0x5162,0xD1BE},
// {0x5164,0xF9C4}, alternative
{0x5164,0x326D}, {0x5165,0xC6FE}, {0x5166,0x326E}, {0x5168,0xC1B4}, {0x5169,0xD1C0},
{0x516A,0xD1C1}, {0x516B,0xC8AC}, {0x516C,0xB8F8}, {0x516D,0xCFBB}, {0x516E,0xD1C2},
{0x5171,0xB6A6}, {0x5175,0xCABC}, {0x5176,0xC2B6}, {0x5177,0xB6F1}, {0x5178,0xC5B5},
{0x517C,0xB7F3}, {0x517E,0x326F}, {0x5180,0xD1C3}, {0x5182,0xD1C4}, {0x5183,0x3270},
{0x5184,0x3271}, {0x5185,0xC6E2}, {0x5186,0xB1DF}, {0x5189,0xD1C7}, {0x518A,0xBAFD},
{0x518B,0x3272}, {0x518C,0xD1C6}, {0x518D,0xBAC6}, {0x518E,0x3273}, {0x518F,0xD1C8},
{0x5190,0xE6EE}, {0x5191,0xD1C9}, {0x5192,0xCBC1}, {0x5193,0xD1CA}, {0x5195,0xD1CB},
// {0x519D,0xF9C5}, alternative
{0x5196,0xD1CC}, {0x5197,0xBEE9}, {0x5198,0x3274}, {0x5199,0xBCCC}, {0x519D,0x3275},
{0x51A0,0xB4A7}, {0x51A1,0x3276}, {0x51A2,0xD1CF}, {0x51A3,0x3277}, {0x51A4,0xD1CD},
{0x51A5,0xCCBD}, {0x51A6,0xD1CE}, {0x51A8,0xC9DA}, {0x51A9,0xD1D0}, {0x51AA,0xD1D1},
{0x51AB,0xD1D2}, {0x51AC,0xC5DF}, {0x51AD,0x3278}, {0x51B0,0xD1D6}, {0x51B1,0xD1D4},
{0x51B2,0xD1D5}, {0x51B3,0xD1D3}, {0x51B4,0xBAE3}, {0x51B5,0xD1D7}, {0x51B6,0xCCEA},
{0x51B7,0xCEE4}, {0x51B8,0x3279}, {0x51BA,0x327A}, {0x51BC,0x327B}, {0x51BD,0xD1D8},
// {0x51BE,0xF9C6}, alternative
{0x51BE,0x327C}, {0x51BF,0x327D}, {0x51C2,0x327E}, {0x51C4,0xC0A8}, {0x51C5,0xD1D9},
{0x51C6,0xBDDA}, {0x51C8,0x3321}, {0x51C9,0xD1DA}, {0x51CB,0xC3FC}, {0x51CC,0xCEBF},
{0x51CD,0xC5E0}, {0x51CF,0x3322}, {0x51D1,0x3323}, {0x51D2,0x3324}, {0x51D3,0x3325},
{0x51D5,0x3326}, {0x51D6,0xD2C5}, {0x51D8,0x3327}, {0x51DB,0xD1DB}, {0x51DC,0xF4A5},
{0x51DD,0xB6C5}, {0x51DE,0x3328}, {0x51E0,0xD1DC}, {0x51E1,0xCBDE}, {0x51E2,0x3329},
{0x51E5,0x332A}, {0x51E6,0xBDE8}, {0x51E7,0xC2FC}, {0x51E9,0xD1DE}, {0x51EA,0xC6E4},
{0x51EC,0x7431},
{0x51ED,0xD1DF}, {0x51EE,0x332B}, {0x51F0,0xD1E0}, {0x51F1,0xB3AE}, {0x51F2,0x332C},
{0x51F3,0x332D}, {0x51F4,0x332E}, {0x51F5,0xD1E1}, {0x51F6,0xB6A7}, {0x51F7,0x332F},
{0x51F8,0xC6CC}, {0x51F9,0xB1FA}, {0x51FA,0xBDD0}, {0x51FD,0xC8A1}, {0x51FE,0xD1E2},
{0x5200,0xC5E1}, {0x5201,0x3330}, {0x5202,0x3331}, {0x5203,0xBFCF}, {0x5204,0xD1E3},
{0x5205,0x3332}, {0x5206,0xCAAC}, {0x5207,0xC0DA}, {0x5208,0xB4A2}, {0x520A,0xB4A9},
{0x520B,0xD1E4}, {0x520E,0xD1E6}, {0x5211,0xB7BA}, {0x5212,0x3333}, {0x5213,0x3334},
// {0x5215,0xF9C8}, alternative
{0x5214,0xD1E5}, {0x5215,0x3335}, {0x5216,0x3336}, {0x5217,0xCEF3}, {0x5218,0x3337},
{0x521D,0xBDE9}, {0x5222,0x3338}, {0x5224,0xC8BD}, {0x5225,0xCACC}, {0x5227,0xD1E7},
{0x5228,0x3339}, {0x5229,0xCDF8}, {0x522A,0xD1E8}, {0x522E,0xD1E9}, {0x5230,0xC5FE},
{0x5231,0x333A}, {0x5232,0x333B}, {0x5233,0xD1EA}, {0x5235,0x333C}, {0x5236,0xC0A9},
{0x5237,0xBAFE}, {0x5238,0xB7F4}, {0x5239,0xD1EB}, {0x523A,0xBBC9}, {0x523B,0xB9EF},
{0x523C,0x333D}, {0x5243,0xC4E6}, {0x5244,0xD1ED}, {0x5245,0x333E}, {0x5247,0xC2A7},
{0x5249,0x333F}, {0x524A,0xBAEF}, {0x524B,0xD1EE}, {0x524C,0xD1EF}, {0x524D,0xC1B0},
{0x524F,0xD1EC}, {0x5254,0xD1F1}, {0x5255,0x3340}, {0x5256,0xCBB6}, {0x5257,0x3341},
{0x5258,0x3342}, {0x525A,0x3343}, {0x525B,0xB9E4}, {0x525C,0x3344}, {0x525E,0xD1F0},
{0x525F,0x3345}, {0x5260,0x3346}, {0x5261,0x3347}, {0x5263,0xB7F5}, {0x5264,0xBADE},
{0x5265,0xC7ED}, {0x5266,0x3348}, {0x5269,0xD1F4}, {0x526A,0xD1F2}, {0x526E,0x3349},
{0x526F,0xC9FB}, {0x5270,0xBEEA}, {0x5271,0xD1FB}, {0x5272,0xB3E4}, {0x5273,0xD1F5},
{0x5274,0xD1F3}, {0x5275,0xC1CF}, {0x5277,0x334A}, {0x5278,0x334B}, {0x5279,0x334C},
{0x527D,0xD1F7}, {0x527F,0xD1F6}, {0x5280,0x334D}, {0x5282,0x334E}, {0x5283,0xB3C4},
{0x5285,0x334F}, {0x5287,0xB7E0}, {0x5288,0xD1FC}, {0x5289,0xCEAD}, {0x528A,0x3350},
{0x528C,0x3351}, {0x528D,0xD1F8}, {0x5291,0xD1FD}, {0x5292,0xD1FA}, {0x5293,0x3352},
// {0x529C,0xF9C9}, alternative
{0x5294,0xD1F9}, {0x5295,0x3353}, {0x5296,0x3354}, {0x5297,0x3355}, {0x5298,0x3356},
{0x529A,0x3357}, {0x529B,0xCECF}, {0x529C,0x3358}, {0x529F,0xB8F9}, {0x52A0,0xB2C3},
// {0x52A6,0xF9CA}, alternative
{0x52A3,0xCEF4}, {0x52A4,0x3359}, {0x52A5,0x335A}, {0x52A6,0x335B}, {0x52A7,0x335C},
{0x52A9,0xBDF5}, {0x52AA,0xC5D8}, {0x52AB,0xB9E5}, {0x52AC,0xD2A2}, {0x52AD,0xD2A3},
// {0x52AF,0xFBBC}, alternative
{0x52AF,0x335D}, {0x52B0,0x335E}, {0x52B1,0xCEE5}, {0x52B4,0xCFAB}, {0x52B5,0xD2A5},
{0x52B6,0x335F}, {0x52B7,0x3360}, {0x52B8,0x3361}, {0x52B9,0xB8FA}, {0x52BA,0x3362},
// {0x52C0,0xF9CB}, alternative
{0x52BB,0x3363}, {0x52BC,0xD2A4}, {0x52BD,0x3364}, {0x52BE,0xB3AF}, {0x52C0,0x3365},
{0x52C1,0xD2A6}, {0x52C3,0xCBD6}, {0x52C4,0x3366}, {0x52C5,0xC4BC}, {0x52C6,0x3367},
{0x52C7,0xCDA6}, {0x52C8,0x3368}, {0x52C9,0xCAD9}, {0x52CC,0x3369}, {0x52CD,0xD2A7},
{0x52CF,0x336A}, {0x52D1,0x336B}, {0x52D2,0xF0D5}, {0x52D4,0x336C}, {0x52D5,0xC6B0},
// {0x52DB,0xF9CC}, alternative
{0x52D6,0x336D}, {0x52D7,0xD2A8}, {0x52D8,0xB4AA}, {0x52D9,0xCCB3}, {0x52DB,0x336E},
{0x52DC,0x336F}, {0x52DD,0xBEA1}, {0x52DE,0xD2A9}, {0x52DF,0xCAE7}, {0x52E0,0xD2AD},
{0x52E1,0x3370}, {0x52E2,0xC0AA}, {0x52E3,0xD2AA}, {0x52E4,0xB6D0}, {0x52E5,0x3371},
{0x52E6,0xD2AB}, {0x52E7,0xB4AB}, {0x52E8,0x3372}, {0x52E9,0x3373}, {0x52EA,0x3374},
{0x52EC,0x3375}, {0x52F0,0x3376}, {0x52F1,0x3377}, {0x52F2,0xB7AE}, {0x52F3,0xD2AE},
{0x52F4,0x3378}, {0x52F5,0xD2AF}, {0x52F6,0x3379}, {0x52F7,0x337A}, {0x52F8,0xD2B0},
// {0x5300,0xF9CD}, alternative
{0x52F9,0xD2B1}, {0x52FA,0xBCDB}, {0x52FE,0xB8FB}, {0x52FF,0xCCDE}, {0x5300,0x337B},
{0x5301,0xCCE8}, {0x5302,0xC6F7}, {0x5303,0x337C}, {0x5305,0xCAF1}, {0x5306,0xD2B2},
{0x5307,0x7432},
{0x5308,0xD2B3}, {0x530A,0x337D}, {0x530B,0x337E}, {0x530C,0x3421}, {0x530D,0xD2B5},
{0x530F,0xD2B7}, {0x5310,0xD2B6}, {0x5311,0x3422}, {0x5313,0x3423}, {0x5315,0xD2B8},
{0x5316,0xB2BD}, {0x5317,0xCBCC}, {0x5318,0x3424}, {0x5319,0xBAFC}, {0x531A,0xD2B9},
{0x531B,0x3425}, {0x531C,0x3426}, {0x531D,0xC1D9}, {0x531E,0x3427}, {0x531F,0x3428},
{0x5320,0xBEA2}, {0x5321,0xB6A9}, {0x5323,0xD2BA},
{0x5324,0x7433},
{0x5325,0x3429}, {0x5327,0x342A},
{0x5328,0x342B}, {0x5329,0x342C}, {0x532A,0xC8DB}, {0x532B,0x342D}, {0x532C,0x342E},
{0x532D,0x342F}, {0x532F,0xD2BB}, {0x5330,0x3430}, {0x5331,0xD2BC}, {0x5332,0x3431},
{0x5333,0xD2BD}, {0x5335,0x3432}, {0x5338,0xD2BE}, {0x5339,0xC9A4}, {0x533A,0xB6E8},
{0x533B,0xB0E5}, {0x533C,0x3433}, {0x533D,0x3434}, {0x533E,0x3435}, {0x533F,0xC6BF},
{0x5340,0xD2BF}, {0x5341,0xBDBD}, {0x5342,0x3436}, {0x5343,0xC0E9}, {0x5345,0xD2C1},
{0x5346,0xD2C0}, {0x5347,0xBEA3}, {0x5348,0xB8E1}, {0x5349,0xD2C3}, {0x534A,0xC8BE},
{0x534B,0x3438}, {0x534C,0x3437}, {0x534D,0xD2C4}, {0x5351,0xC8DC}, {0x5352,0xC2B4},
{0x5353,0xC2EE}, {0x5354,0xB6A8}, {0x5357,0xC6EE}, {0x5358,0xC3B1}, {0x5359,0x3439},
{0x535A,0xC7EE}, {0x535B,0x343A}, {0x535C,0xCBCE}, {0x535E,0xD2C6}, {0x5360,0xC0EA},
{0x5361,0x343B}, {0x5363,0x343C}, {0x5365,0x343D}, {0x5366,0xB7B5}, {0x5369,0xD2C7},
{0x536C,0x343E}, {0x536D,0x343F}, {0x536E,0xD2C8}, {0x536F,0xB1AC}, {0x5370,0xB0F5},
// {0x5372,0xF9D0}, alternative
{0x5371,0xB4ED}, {0x5372,0x3440}, {0x5373,0xC2A8}, {0x5374,0xB5D1}, {0x5375,0xCDF1},
{0x5377,0xD2CB}, {0x5378,0xB2B7}, {0x5379,0x3441}, {0x537B,0xD2CA}, {0x537E,0x3442},
{0x537F,0xB6AA}, {0x5382,0xD2CC}, {0x5383,0x3443}, {0x5384,0xCCF1}, {0x5387,0x3444},
// {0x5393,0xF9D1}, alternative
{0x5388,0x3445}, {0x538E,0x3446}, {0x5393,0x3447}, {0x5394,0x3448}, {0x5396,0xD2CD},
{0x5398,0xCED2}, {0x5399,0x3449}, {0x539A,0xB8FC}, {0x539D,0x344A}, {0x539F,0xB8B6},
{0x53A0,0xD2CE}, {0x53A1,0x344B}, {0x53A4,0x344C}, {0x53A5,0xD2D0}, {0x53A6,0xD2CF},
{0x53A8,0xBFDF}, {0x53A9,0xB1B9}, {0x53AA,0x344D}, {0x53AB,0x344E}, {0x53AD,0xB1DE},
// {0x53B2,0xF9D2}, alternative
{0x53AE,0xD2D1}, {0x53AF,0x344F}, {0x53B0,0xD2D2}, {0x53B2,0x3450}, {0x53B3,0xB8B7},
{0x53B4,0x3451}, {0x53B5,0x3452}, {0x53B6,0xD2D3}, {0x53B7,0x3453}, {0x53B8,0x3454},
{0x53BA,0x3455}, {0x53BB,0xB5EE}, {0x53BD,0x3456}, {0x53C0,0x3457}, {0x53C2,0xBBB2},
{0x53C3,0xD2D4}, {0x53C5,0x3458}, {0x53C8,0xCBF4}, {0x53C9,0xBAB5}, {0x53CA,0xB5DA},
{0x53CB,0xCDA7}, {0x53CC,0xC1D0}, {0x53CD,0xC8BF}, {0x53CE,0xBCFD}, {0x53CF,0x3459},
{0x53D2,0x345A}, {0x53D3,0x345B}, {0x53D4,0xBDC7}, {0x53D5,0x345C}, {0x53D6,0xBCE8},
// {0x53DD,0xF9D3}, alternative
{0x53D7,0xBCF5}, {0x53D9,0xBDF6}, {0x53DA,0x345D}, {0x53DB,0xC8C0}, {0x53DD,0x345E},
{0x53DE,0x345F}, {0x53DF,0xD2D7}, {0x53E0,0x3460}, {0x53E1,0xB1C3}, {0x53E2,0xC1D1},
{0x53E3,0xB8FD}, {0x53E4,0xB8C5}, {0x53E5,0xB6E7}, {0x53E6,0x3461}, {0x53E7,0x3462},
{0x53E8,0xD2DB}, {0x53E9,0xC3A1}, {0x53EA,0xC2FE}, {0x53EB,0xB6AB}, {0x53EC,0xBEA4},
{0x53ED,0xD2DC}, {0x53EE,0xD2DA}, {0x53EF,0xB2C4}, {0x53F0,0xC2E6}, {0x53F1,0xBCB8},
{0x53F2,0xBBCB}, {0x53F3,0xB1A6}, {0x53F5,0x3463}, {0x53F6,0xB3F0}, {0x53F7,0xB9E6},
{0x53F8,0xBBCA}, {0x53FA,0xD2DD}, {0x5401,0xD2DE}, {0x5402,0x3464}, {0x5403,0xB5C9},
{0x5404,0xB3C6}, {0x5408,0xB9E7}, {0x5409,0xB5C8}, {0x540A,0xC4DF}, {0x540B,0xB1A5},
{0x540C,0xC6B1}, {0x540D,0xCCBE}, {0x540E,0xB9A1}, {0x540F,0xCDF9}, {0x5410,0xC5C7},
{0x5411,0xB8FE}, {0x5413,0x3465}, {0x541A,0x3466}, {0x541B,0xB7AF}, {0x541D,0xD2E7},
{0x541F,0xB6E3}, {0x5420,0xCBCA}, {0x5421,0x3467}, {0x5426,0xC8DD}, {0x5427,0x3468},
{0x5428,0x3469}, {0x5429,0xD2E6}, {0x542A,0x346A}, {0x542B,0xB4DE}, {0x542C,0xD2E1},
{0x542D,0xD2E2}, {0x542E,0xD2E4}, {0x542F,0x346B}, {0x5431,0x346C}, {0x5434,0x346D},
{0x5435,0x346E}, {0x5436,0xD2E5}, {0x5438,0xB5DB}, {0x5439,0xBFE1}, {0x543B,0xCAAD},
{0x543C,0xD2E3}, {0x543D,0xD2DF}, {0x543E,0xB8E3}, {0x5440,0xD2E0}, {0x5442,0xCFA4},
{0x5443,0x346F}, {0x5444,0x3470}, {0x5446,0xCAF2}, {0x5447,0x3471}, {0x5448,0xC4E8},
{0x5449,0xB8E2}, {0x544A,0xB9F0}, {0x544D,0x3472}, {0x544E,0xD2E8}, {0x544F,0x3473},
{0x5451,0xC6DD}, {0x545E,0x3474}, {0x545F,0xD2EC}, {0x5462,0x3475}, {0x5464,0x3476},
{0x5466,0x3477}, {0x5467,0x3478}, {0x5468,0xBCFE}, {0x5469,0x3479}, {0x546A,0xBCF6},
{0x546B,0x347A}, {0x546D,0x347B}, {0x546E,0x347C}, {0x5470,0xD2EF}, {0x5471,0xD2ED},
{0x5473,0xCCA3}, {0x5474,0x347D}, {0x5475,0xD2EA}, {0x5476,0xD2F3}, {0x5477,0xD2EE},
{0x547B,0xD2F1}, {0x547C,0xB8C6}, {0x547D,0xCCBF}, {0x547F,0x347E}, {0x5480,0xD2F2},
{0x5481,0x3521}, {0x5483,0x3522}, {0x5484,0xD2F4}, {0x5485,0x3523}, {0x5486,0xD2F6},
{0x5488,0x3524}, {0x5489,0x3525},
{0x548A,0x7435},
{0x548B,0xBAF0}, {0x548C,0xCFC2}, {0x548D,0x3526},
{0x548E,0xD2EB}, {0x548F,0xD2E9}, {0x5490,0xD2F5}, {0x5491,0x3527}, {0x5492,0xD2F0},
// {0x549C,0xF9D5}, alternative
{0x5495,0x3528}, {0x5496,0x3529}, {0x549C,0x352A}, {0x549F,0x352B}, {0x54A1,0x352C},
{0x54A2,0xD2F8}, {0x54A4,0xD3A3}, {0x54A5,0xD2FA}, {0x54A6,0x352D}, {0x54A7,0x352E},
// {0x54A9,0xF9D7}, alternative
{0x54A8,0xD2FE}, {0x54A9,0x352F}, {0x54AA,0x3530}, {0x54AB,0xD3A1}, {0x54AC,0xD2FB},
{0x54AD,0x3531}, {0x54AE,0x3532}, {0x54AF,0xD3BE}, {0x54B1,0x3533}, {0x54B2,0xBAE9},
{0x54B3,0xB3B1}, {0x54B7,0x3534}, {0x54B8,0xD2F9}, {0x54B9,0x3535}, {0x54BA,0x3536},
{0x54BB,0x3537}, {0x54BC,0xD3A5}, {0x54BD,0xB0F6}, {0x54BE,0xD3A4}, {0x54BF,0x3538},
{0x54C0,0xB0A5}, {0x54C1,0xC9CA}, {0x54C2,0xD3A2}, {0x54C4,0xD2FC}, {0x54C6,0x3539},
{0x54C7,0xD2F7}, {0x54C8,0xD2FD}, {0x54C9,0xBAC8}, {0x54CA,0x353A}, {0x54CD,0x353B},
{0x54CE,0x353C}, {0x54D8,0xD3A6}, {0x54E0,0x353D}, {0x54E1,0xB0F7}, {0x54E2,0xD3AF},
{0x54E5,0xD3A7}, {0x54E6,0xD3A8}, {0x54E8,0xBEA5}, {0x54E9,0xCBE9}, {0x54EA,0x353E},
{0x54EC,0x353F}, {0x54ED,0xD3AD}, {0x54EE,0xD3AC}, {0x54EF,0x3540}, {0x54F2,0xC5AF},
{0x54F6,0x3541}, {0x54FA,0xD3AE}, {0x54FC,0x3542}, {0x54FD,0xD3AB}, {0x54FE,0x3543},
// {0x54FF,0xF9D8}, alternative
{0x54FF,0x3544}, {0x5500,0x3545}, {0x5501,0x3546}, {0x5504,0xB1B4}, {0x5505,0x3547},
{0x5506,0xBAB6}, {0x5507,0xBFB0}, {0x5508,0x3548}, {0x5509,0x3549}, {0x550C,0x354A},
{0x550D,0x354B}, {0x550E,0x354C}, {0x550F,0xD3A9}, {0x5510,0xC5E2}, {0x5514,0xD3AA},
{0x5515,0x354D}, {0x5516,0xB0A2}, {0x552A,0x354E}, {0x552B,0x354F}, {0x552E,0xD3B4},
{0x552F,0xCDA3}, {0x5531,0xBEA7}, {0x5532,0x3550}, {0x5533,0xD3BA}, {0x5535,0x3551},
{0x5536,0x3552}, {0x5538,0xD3B9}, {0x5539,0xD3B0}, {0x553B,0x3553}, {0x553C,0x3554},
{0x553D,0x3555}, {0x553E,0xC2C3}, {0x5540,0xD3B1}, {0x5541,0x3556}, {0x5544,0xC2EF},
{0x5545,0xD3B6}, {0x5546,0xBEA6}, {0x5547,0x3557}, {0x5549,0x3558}, {0x554A,0x3559},
{0x554C,0xD3B3}, {0x554D,0x355A}, {0x554F,0xCCE4}, {0x5550,0x355B}, {0x5551,0x355C},
{0x5553,0xB7BC}, {0x5556,0xD3B7}, {0x5557,0xD3B8}, {0x5558,0x355D}, {0x555A,0x355E},
{0x555B,0x355F}, {0x555C,0xD3B5}, {0x555D,0xD3BB}, {0x555E,0x3560}, {0x5560,0x3561},
{0x5561,0x3562}, {0x5563,0xD3B2}, {0x5564,0x3563}, {0x5566,0x3564}, {0x557B,0xD3C1},
{0x557C,0xD3C6}, {0x557E,0xD3C2}, {0x557F,0x3565}, {0x5580,0xD3BD}, {0x5581,0x3566},
// {0x5586,0xF9D9}, alternative
{0x5582,0x3567}, {0x5583,0xD3C7}, {0x5584,0xC1B1}, {0x5586,0x3568}, {0x5587,0xD3C9},
{0x5588,0x3569}, {0x5589,0xB9A2}, {0x558A,0xD3BF}, {0x558B,0xC3FD}, {0x558E,0x356A},
{0x558F,0x356B}, {0x5591,0x356C}, {0x5592,0x356D}, {0x5593,0x356E}, {0x5594,0x356F},
{0x5597,0x3570}, {0x5598,0xD3C3}, {0x5599,0xD3BC}, {0x559A,0xB4AD}, {0x559C,0xB4EE},
{0x559D,0xB3E5}, {0x559E,0xD3C4}, {0x559F,0xD3C0}, {0x55A3,0x3571}, {0x55A4,0x3572},
{0x55A7,0xB7F6}, {0x55A8,0xD3CA}, {0x55A9,0xD3C8}, {0x55AA,0xC1D3}, {0x55AB,0xB5CA},
{0x55AC,0xB6AC}, {0x55AD,0x3573}, {0x55AE,0xD3C5}, {0x55B0,0xB6F4}, {0x55B2,0x3574},
{0x55B6,0xB1C4}, {0x55BF,0x3575}, {0x55C1,0x3576}, {0x55C3,0x3577}, {0x55C4,0xD3CE},
{0x55C5,0xD3CC}, {0x55C6,0x3578}, {0x55C7,0xD4A7}, {0x55C9,0x3579}, {0x55CB,0x357A},
{0x55CC,0x357B}, {0x55CE,0x357C}, {0x55D1,0x357D}, {0x55D2,0x357E}, {0x55D3,0x3621},
{0x55D4,0xD3D1}, {0x55D7,0x3622}, {0x55D8,0x3623}, {0x55DA,0xD3CB}, {0x55DB,0x3624},
{0x55DC,0xD3CF}, {0x55DE,0x3625}, {0x55DF,0xD3CD}, {0x55E2,0x3626}, {0x55E3,0xBBCC},
{0x55E4,0xD3D0}, {0x55E9,0x3627}, {0x55F6,0x3628}, {0x55F7,0xD3D3}, {0x55F9,0xD3D8},
{0x55FD,0xD3D6}, {0x55FE,0xD3D5}, {0x55FF,0x3629}, {0x5605,0x362A}, {0x5606,0xC3B2},
{0x5608,0x362B}, {0x5609,0xB2C5}, {0x560A,0x362C}, {0x560D,0x362D}, {0x560E,0x362E},
{0x560F,0x362F}, {0x5610,0x3630}, {0x5611,0x3631}, {0x5612,0x3632}, {0x5614,0xD3D2},
{0x5616,0xD3D4}, {0x5617,0xBEA8}, {0x5618,0xB1B3}, {0x5619,0x3633}, {0x561B,0xD3D7},
{0x5629,0xB2DE}, {0x562C,0x3634}, {0x562F,0xD3E2}, {0x5630,0x3635}, {0x5631,0xBEFC},
{0x5632,0xD3DE}, {0x5633,0x3636}, {0x5634,0xD3DC}, {0x5635,0x3637}, {0x5636,0xD3DD},
{0x5637,0x3638}, {0x5638,0xD3DF}, {0x5639,0x3639}, {0x563B,0x363A}, {0x563C,0x363B},
{0x563D,0x363C}, {0x563F,0x363D}, {0x5640,0x363E}, {0x5641,0x363F}, {0x5642,0xB1BD},
{0x5643,0x3640}, {0x5644,0x3641}, {0x5646,0x3642}, {0x5649,0x3643}, {0x564B,0x3644},
{0x564C,0xC1B9}, {0x564D,0x3645}, {0x564E,0xD3D9}, {0x564F,0x3646}, {0x5650,0xD3DA},
{0x5654,0x3647}, {0x565B,0xB3FA}, {0x565E,0x3648}, {0x5660,0x3649}, {0x5661,0x364A},
{0x5662,0x364B}, {0x5663,0x364C}, {0x5664,0xD3E1}, {0x5666,0x364D}, {0x5668,0xB4EF},
{0x5669,0x364E}, {0x566A,0xD3E4}, {0x566B,0xD3E0}, {0x566C,0xD3E3}, {0x566D,0x364F},
{0x566F,0x3650}, {0x5671,0x3651}, {0x5672,0x3652}, {0x5674,0xCAAE}, {0x5675,0x3653},
{0x5678,0xC6D5}, {0x567A,0xC8B8}, {0x5680,0xD3E6}, {0x5684,0x3654}, {0x5685,0x3655},
{0x5686,0xD3E5}, {0x5687,0xB3C5}, {0x5688,0x3656}, {0x568A,0xD3E7}, {0x568B,0x3657},
{0x568C,0x3658}, {0x568F,0xD3EA}, {0x5694,0xD3E9}, {0x5695,0x3659}, {0x5699,0x365A},
{0x569A,0x365B}, {0x569D,0x365C}, {0x569E,0x365D}, {0x569F,0x365E}, {0x56A0,0xD3E8},
{0x56A2,0xC7B9}, {0x56A5,0xD3EB}, {0x56A6,0x365F}, {0x56A7,0x3660}, {0x56A8,0x3661},
{0x56A9,0x3662}, {0x56AB,0x3663}, {0x56AC,0x3664}, {0x56AD,0x3665}, {0x56AE,0xD3EC},
{0x56B1,0x3666}, {0x56B3,0x3667}, {0x56B4,0xD3EE}, {0x56B6,0xD3ED}, {0x56B7,0x3668},
{0x56BC,0xD3F0}, {0x56BE,0x3669}, {0x56C0,0xD3F3}, {0x56C1,0xD3F1}, {0x56C2,0xD3EF},
{0x56C3,0xD3F2}, {0x56C5,0x366A}, {0x56C8,0xD3F4}, {0x56C9,0x366B}, {0x56CA,0x366C},
{0x56CB,0x366D}, {0x56CC,0x3670}, {0x56CD,0x3671}, {0x56CE,0xD3F5}, {0x56CF,0x366E},
{0x56D0,0x366F}, {0x56D1,0xD3F6}, {0x56D3,0xD3F7}, {0x56D7,0xD3F8}, {0x56D8,0xD1C5},
{0x56D9,0x3672}, {0x56DA,0xBCFC}, {0x56DB,0xBBCD}, {0x56DC,0x3673}, {0x56DD,0x3674},
{0x56DE,0xB2F3}, {0x56DF,0x3675}, {0x56E0,0xB0F8}, {0x56E1,0x3676}, {0x56E3,0xC3C4},
{0x56E4,0x3677}, {0x56E5,0x3678}, {0x56E6,0x3679}, {0x56E7,0x367A}, {0x56E8,0x367B},
{0x56EB,0x367D}, {0x56ED,0x367E}, {0x56EE,0xD3F9}, {0x56F0,0xBAA4}, {0x56F1,0x367C},
{0x56F2,0xB0CF}, {0x56F3,0xBFDE}, {0x56F6,0x3721}, {0x56F7,0x3722}, {0x56F9,0xD3FA},
{0x56FA,0xB8C7}, {0x56FD,0xB9F1}, {0x56FF,0xD3FC}, {0x5700,0xD3FB}, {0x5701,0x3723},
{0x5702,0x3724}, {0x5703,0xCAE0}, {0x5704,0xD3FD}, {0x5707,0x3725}, {0x5708,0xD4A1},
{0x5709,0xD3FE}, {0x570A,0x3726}, {0x570B,0xD4A2}, {0x570C,0x3727}, {0x570D,0xD4A3},
{0x570F,0xB7F7}, {0x5711,0x3728}, {0x5712,0xB1E0}, {0x5713,0xD4A4}, {0x5715,0x3729},
{0x5716,0xD4A6}, {0x5718,0xD4A5}, {0x571A,0x372A}, {0x571B,0x372B}, {0x571C,0xD4A8},
{0x571D,0x372C}, {0x571F,0xC5DA}, {0x5720,0x372D}, {0x5722,0x372E}, {0x5723,0x372F},
{0x5724,0x3730}, {0x5725,0x3731}, {0x5726,0xD4A9}, {0x5727,0xB0B5}, {0x5728,0xBADF},
{0x5729,0x3732}, {0x572A,0x3733}, {0x572C,0x3734}, {0x572D,0xB7BD}, {0x572E,0x3735},
{0x572F,0x3736}, {0x5730,0xC3CF}, {0x5733,0x3737}, {0x5734,0x3738}, {0x5737,0xD4AA},
{0x5738,0xD4AB}, {0x573B,0xD4AD}, {0x573D,0x3739}, {0x573E,0x373A}, {0x573F,0x373B},
{0x5740,0xD4AE}, {0x5742,0xBAE4}, {0x5745,0x373C}, {0x5746,0x373D}, {0x5747,0xB6D1},
{0x574A,0xCBB7}, {0x574C,0x373E}, {0x574D,0x373F}, {0x574E,0xD4AC}, {0x574F,0xD4AF},
{0x5750,0xBAC1}, {0x5751,0xB9A3}, {0x5752,0x3740},
{0x5759,0x7436},
{0x5761,0xD4B3}, {0x5762,0x3741},
// {0x5765,0xF9DB}, alternative
{0x5764,0xBAA5}, {0x5765,0x3742}, {0x5766,0xC3B3}, {0x5767,0x3743}, {0x5768,0x3744},
{0x5769,0xD4B0}, {0x576A,0xC4DA}, {0x576B,0x3745}, {0x576D,0x3746}, {0x576E,0x3747},
{0x576F,0x3748}, {0x5770,0x3749}, {0x5771,0x374A}, {0x5773,0x374B}, {0x5774,0x374C},
{0x5775,0x374D}, {0x5777,0x374E}, {0x5779,0x374F}, {0x577A,0x3750}, {0x577B,0x3751},
{0x577C,0x3752}, {0x577E,0x3753}, {0x577F,0xD4B4}, {0x5781,0x3754}, {0x5782,0xBFE2},
{0x5783,0x3755}, {0x5788,0xD4B2}, {0x5789,0xD4B5}, {0x578B,0xB7BF}, {0x578C,0x3756},
{0x5793,0xD4B6}, {0x5794,0x3757}, {0x5795,0x3760}, {0x5797,0x3758}, {0x5799,0x3759},
{0x579A,0x375A}, {0x579C,0x375B}, {0x579D,0x375C}, {0x579E,0x375D}, {0x579F,0x375E},
{0x57A0,0xD4B7}, {0x57A1,0x375F}, {0x57A2,0xB9A4}, {0x57A3,0xB3C0}, {0x57A4,0xD4B9},
// {0x57AC,0xF9DC}, alternative
{0x57A7,0x3761}, {0x57A8,0x3762}, {0x57A9,0x3763}, {0x57AA,0xD4BA}, {0x57AC,0x3764},
{0x57B0,0xD4BB}, {0x57B3,0xD4B8}, {0x57B8,0x3765}, {0x57BD,0x3766}, {0x57C0,0xD4B1},
// {0x57C7,0xF9DE}, alternative
// {0x57C8,0xF9DD}, alternative
{0x57C3,0xD4BC}, {0x57C6,0xD4BD}, {0x57C7,0x3767}, {0x57C8,0x3768}, {0x57CB,0xCBE4},
{0x57CC,0x3769}, {0x57CE,0xBEEB}, {0x57CF,0x376A}, {0x57D2,0xD4BF}, {0x57D3,0xD4C0},
{0x57D4,0xD4BE}, {0x57D5,0x376B}, {0x57D6,0xD4C2}, {0x57DC,0xC7B8}, {0x57DD,0x376C},
{0x57DE,0x376D}, {0x57DF,0xB0E8}, {0x57E0,0xC9D6}, {0x57E1,0x377E}, {0x57E3,0xD4C3},
{0x57E4,0x376E}, {0x57E6,0x376F}, {0x57E7,0x3770}, {0x57E9,0x3771}, {0x57ED,0x3772},
{0x57F0,0x3773}, {0x57F4,0xBEFD}, {0x57F5,0x3774}, {0x57F6,0x3775}, {0x57F7,0xBCB9},
{0x57F8,0x3776}, {0x57F9,0xC7DD}, {0x57FA,0xB4F0}, {0x57FC,0xBAEB}, {0x57FD,0x3777},
{0x57FE,0x3778}, {0x57FF,0x3779}, {0x5800,0xCBD9}, {0x5802,0xC6B2}, {0x5803,0x377A},
{0x5804,0x377B}, {0x5805,0xB7F8}, {0x5806,0xC2CF}, {0x5808,0x377C}, {0x5809,0x377D},
{0x580A,0xD4C1}, {0x580B,0xD4C4}, {0x580C,0x3821}, {0x580D,0x3822}, {0x5815,0xC2C4},
{0x5819,0xD4C5}, {0x581B,0x3823}, {0x581D,0xD4C6}, {0x581E,0x3824}, {0x581F,0x3825},
{0x5820,0x3826}, {0x5821,0xD4C8}, {0x5824,0xC4E9}, {0x5826,0x3827}, {0x5827,0x3828},
{0x582A,0xB4AE}, {0x582D,0x3829}, {0x582F,0xF4A1}, {0x5830,0xB1E1}, {0x5831,0xCAF3},
{0x5832,0x382A}, {0x5834,0xBEEC}, {0x5835,0xC5C8}, {0x5839,0x382B}, {0x583A,0xBAE6},
{0x583D,0xD4CE}, {0x583F,0x382C}, {0x5840,0xCABD}, {0x5841,0xCEDD}, {0x5849,0x382D},
{0x584A,0xB2F4}, {0x584B,0xD4CA}, {0x584C,0x382E}, {0x584D,0x382F}, {0x584F,0x3830},
{0x5850,0x3831}, {0x5851,0xC1BA}, {0x5852,0xD4CD}, {0x5854,0xC5E3}, {0x5855,0x3832},
{0x5857,0xC5C9}, {0x5858,0xC5E4}, {0x5859,0xC8B9}, {0x585A,0xC4CD}, {0x585E,0xBAC9},
{0x585F,0x3833}, {0x5861,0x3834}, {0x5862,0xD4C9}, {0x5864,0x3835}, {0x5867,0x3836},
{0x5868,0x3837}, {0x5869,0xB1F6}, {0x586B,0xC5B6}, {0x5870,0xD4CB}, {0x5872,0xD4C7},
{0x5875,0xBFD0}, {0x5878,0x3838}, {0x5879,0xD4CF}, {0x587C,0x3839}, {0x587E,0xBDCE},
{0x587F,0x383A}, {0x5880,0x383B}, {0x5881,0x383C}, {0x5883,0xB6AD}, {0x5885,0xD4D0},
{0x5887,0x383D}, {0x5888,0x383E}, {0x5889,0x383F}, {0x588A,0x3840}, {0x588C,0x3841},
{0x588D,0x3842}, {0x588F,0x3843}, {0x5890,0x3844}, {0x5893,0xCAE8}, {0x5894,0x3845},
{0x5896,0x3846}, {0x5897,0xC1FD}, {0x589C,0xC4C6}, {0x589D,0x3847},
{0x589E,0x7439},
{0x589F,0xD4D2},
{0x58A0,0x3848}, {0x58A1,0x3849}, {0x58A2,0x384A}, {0x58A6,0x384B}, {0x58A8,0xCBCF},
// {0x58B2,0xF9E2}, alternative
{0x58A9,0x384C}, {0x58AB,0xD4D3}, {0x58AE,0xD4D8}, {0x58B1,0x384D}, {0x58B2,0x384E},
{0x58B3,0xCAAF}, {0x58B8,0xD4D7}, {0x58B9,0xD4D1}, {0x58BA,0xD4D4}, {0x58BB,0xD4D6},
{0x58BC,0x3850}, {0x58BE,0xBAA6}, {0x58C1,0xCAC9}, {0x58C2,0x3851}, {0x58C4,0x384F},
{0x58C5,0xD4D9}, {0x58C7,0xC3C5}, {0x58C8,0x3852}, {0x58CA,0xB2F5}, {0x58CC,0xBEED},
{0x58CD,0x3853}, {0x58CE,0x3854}, {0x58D0,0x3855}, {0x58D1,0xD4DB}, {0x58D2,0x3856},
{0x58D3,0xD4DA}, {0x58D4,0x3857}, {0x58D5,0xB9E8}, {0x58D6,0x3858}, {0x58D7,0xD4DC},
{0x58D8,0xD4DE}, {0x58D9,0xD4DD}, {0x58DA,0x3859}, {0x58DC,0xD4E0}, {0x58DD,0x385A},
{0x58DE,0xD4D5}, {0x58DF,0xD4E2}, {0x58E1,0x385B}, {0x58E2,0x385C}, {0x58E4,0xD4E1},
{0x58E5,0xD4DF}, {0x58E9,0x385D}, {0x58EB,0xBBCE}, {0x58EC,0xBFD1}, {0x58EE,0xC1D4},
{0x58EF,0xD4E3}, {0x58F0,0xC0BC}, {0x58F1,0xB0ED}, {0x58F2,0xC7E4}, {0x58F3,0x385E},
{0x58F7,0xC4DB}, {0x58F9,0xD4E5}, {0x58FA,0xD4E4}, {0x58FB,0xD4E6}, {0x58FC,0xD4E7},
{0x58FD,0xD4E8}, {0x5902,0xD4E9}, {0x5905,0x385F}, {0x5906,0x3860}, {0x5909,0xCAD1},
// {0x590B,0xF9E3}, alternative
{0x590A,0xD4EA}, {0x590B,0x3861}, {0x590C,0x3862}, {0x590F,0xB2C6}, {0x5910,0xD4EB},
{0x5912,0x3863}, {0x5913,0x3864}, {0x5914,0x3865}, {0x5915,0xCDBC}, {0x5916,0xB3B0},
{0x5918,0xD2C9}, {0x5919,0xBDC8}, {0x591A,0xC2BF}, {0x591B,0xD4EC}, {0x591C,0xCCEB},
{0x591D,0x3867}, {0x5921,0x3868}, {0x5922,0xCCB4}, {0x5923,0x3869}, {0x5924,0x386A},
{0x5925,0xD4EE}, {0x5927,0xC2E7}, {0x5928,0x386B}, {0x5929,0xC5B7}, {0x592A,0xC2C0},
{0x592B,0xC9D7}, {0x592C,0xD4EF}, {0x592D,0xD4F0}, {0x592E,0xB1FB}, {0x592F,0x386C},
{0x5930,0x386D}, {0x5931,0xBCBA}, {0x5932,0xD4F1}, {0x5933,0x386E}, {0x5935,0x386F},
{0x5936,0x3870}, {0x5937,0xB0D0}, {0x5938,0xD4F2}, {0x593E,0xD4F3}, {0x593F,0x3871},
{0x5943,0x3872}, {0x5944,0xB1E2}, {0x5946,0x3873}, {0x5947,0xB4F1}, {0x5948,0xC6E0},
{0x5949,0xCAF4}, {0x594E,0xD4F7}, {0x594F,0xC1D5}, {0x5950,0xD4F6}, {0x5951,0xB7C0},
// {0x5953,0xF9E4}, alternative
{0x5952,0x3874}, {0x5953,0x3875}, {0x5954,0xCBDB}, {0x5955,0xD4F5}, {0x5957,0xC5E5},
// {0x595B,0xF9E5}, alternative
// {0x595D,0xF9E6}, alternative
{0x5958,0xD4F9}, {0x5959,0x3876}, {0x595A,0xD4F8}, {0x595B,0x3877}, {0x595D,0x3878},
{0x595E,0x3879}, {0x595F,0x387A}, {0x5960,0xD4FB}, {0x5961,0x387B}, {0x5962,0xD4FA},
// {0x5963,0xF9E7}, alternative
{0x5963,0x387C}, {0x5965,0xB1FC}, {0x5967,0xD4FC}, {0x5968,0xBEA9}, {0x5969,0xD4FE},
{0x596A,0xC3A5}, {0x596B,0x387D}, {0x596C,0xD4FD}, {0x596D,0x387E}, {0x596E,0xCAB3},
{0x596F,0x3921}, {0x5972,0x3922}, {0x5973,0xBDF7}, {0x5974,0xC5DB}, {0x5975,0x3923},
{0x5976,0x3924}, {0x5978,0xD5A1}, {0x5979,0x3925}, {0x597B,0x3926}, {0x597C,0x3927},
{0x597D,0xB9A5}, {0x5981,0xD5A2}, {0x5982,0xC7A1}, {0x5983,0xC8DE}, {0x5984,0xCCD1},
{0x598A,0xC7A5}, {0x598B,0x3928}, {0x598C,0x3929}, {0x598D,0xD5AB}, {0x598E,0x392A},
{0x5992,0x392B}, {0x5993,0xB5B8}, {0x5995,0x392C}, {0x5996,0xCDC5}, {0x5997,0x392D},
{0x5999,0xCCAF}, {0x599B,0xD6AC}, {0x599D,0xD5A3}, {0x599F,0x392E}, {0x59A3,0xD5A6},
// {0x59A4,0xF9E8}, alternative
{0x59A4,0x392F}, {0x59A5,0xC2C5}, {0x59A7,0x3930}, {0x59A8,0xCBB8}, {0x59AC,0xC5CA},
{0x59AD,0x3931}, {0x59AE,0x3932}, {0x59AF,0x3933}, {0x59B0,0x3934}, {0x59B2,0xD5A7},
// {0x59BA,0xF9E9}, alternative
{0x59B3,0x3935}, {0x59B7,0x3936}, {0x59B9,0xCBE5}, {0x59BA,0x3937}, {0x59BB,0xBACA},
{0x59BC,0x3938}, {0x59BE,0xBEAA}, {0x59C1,0x3939}, {0x59C3,0x393A}, {0x59C4,0x393B},
{0x59C6,0xD5A8}, {0x59C8,0x393C}, {0x59C9,0xBBD0}, {0x59CA,0x393D}, {0x59CB,0xBBCF},
{0x59CD,0x393E}, {0x59D0,0xB0B9}, {0x59D1,0xB8C8}, {0x59D2,0x393F}, {0x59D3,0xC0AB},
{0x59D4,0xB0D1}, {0x59D9,0xD5AC}, {0x59DA,0xD5AD}, {0x59DC,0xD5AA}, {0x59DD,0x3940},
{0x59DE,0x3941}, {0x59DF,0x3942}, {0x59E3,0x3943}, {0x59E4,0x3944}, {0x59E5,0xB1B8},
{0x59E6,0xB4AF}, {0x59E7,0x3945}, {0x59E8,0xD5A9}, {0x59EA,0xCCC5}, {0x59EB,0xC9B1},
{0x59EE,0x3946}, {0x59EF,0x3947}, {0x59F1,0x3948}, {0x59F2,0x3949}, {0x59F4,0x394A},
{0x59F6,0xB0A8}, {0x59F7,0x394B}, {0x59FB,0xB0F9}, {0x59FF,0xBBD1}, {0x5A00,0x394C},
{0x5A01,0xB0D2}, {0x5A03,0xB0A3}, {0x5A04,0x394D}, {0x5A09,0xD5B2}, {0x5A0C,0x394E},
{0x5A0D,0x394F}, {0x5A0E,0x3950}, {0x5A11,0xD5B0}, {0x5A12,0x3951}, {0x5A13,0x3952},
{0x5A18,0xCCBC}, {0x5A1A,0xD5B3}, {0x5A1C,0xD5B1}, {0x5A1E,0x3953}, {0x5A1F,0xD5AF},
{0x5A20,0xBFB1}, {0x5A23,0x3954}, {0x5A24,0x3955}, {0x5A25,0xD5AE}, {0x5A27,0x3956},
{0x5A28,0x3957}, {0x5A29,0xCADA}, {0x5A2A,0x3958}, {0x5A2D,0x3959}, {0x5A2F,0xB8E4},
{0x5A30,0x395A}, {0x5A35,0xD5B7}, {0x5A36,0xD5B8}, {0x5A3C,0xBEAB}, {0x5A40,0xD5B4},
{0x5A41,0xCFAC}, {0x5A44,0x395B}, {0x5A45,0x395C}, {0x5A46,0xC7CC}, {0x5A47,0x395D},
{0x5A48,0x395E}, {0x5A49,0xD5B6}, {0x5A4C,0x395F}, {0x5A50,0x3960}, {0x5A55,0x3961},
{0x5A5A,0xBAA7}, {0x5A5E,0x3962}, {0x5A62,0xD5B9}, {0x5A63,0x3963}, {0x5A65,0x3964},
{0x5A66,0xC9D8}, {0x5A67,0x3965}, {0x5A6A,0xD5BA}, {0x5A6C,0xD5B5}, {0x5A6D,0x3966},
{0x5A77,0x3967}, {0x5A7A,0x3968}, {0x5A7B,0x3969}, {0x5A7E,0x396A}, {0x5A7F,0xCCBB},
{0x5A8B,0x396B}, {0x5A90,0x396C}, {0x5A92,0xC7DE}, {0x5A93,0x396D}, {0x5A96,0x396E},
{0x5A99,0x396F}, {0x5A9A,0xD5BB}, {0x5A9B,0xC9B2}, {0x5A9C,0x3970}, {0x5A9E,0x3971},
{0x5A9F,0x3972}, {0x5AA0,0x3973}, {0x5AA2,0x3974}, {0x5AA7,0x3975}, {0x5AAC,0x3976},
{0x5AB1,0x3977}, {0x5AB2,0x3978}, {0x5AB3,0x3979}, {0x5AB5,0x397A}, {0x5AB8,0x397B},
{0x5ABA,0x397C}, {0x5ABB,0x397D}, {0x5ABC,0xD5BC}, {0x5ABD,0xD5C0}, {0x5ABE,0xD5BD},
{0x5ABF,0x397E}, {0x5AC1,0xB2C7}, {0x5AC2,0xD5BF}, {0x5AC4,0x3A21}, {0x5AC6,0x3A22},
{0x5AC8,0x3A23}, {0x5AC9,0xBCBB}, {0x5ACB,0xD5BE}, {0x5ACC,0xB7F9}, {0x5ACF,0x3A24},
{0x5AD0,0xD5CC}, {0x5AD6,0xD5C5}, {0x5AD7,0xD5C2}, {0x5ADA,0x3A25}, {0x5ADC,0x3A26},
{0x5AE0,0x3A27}, {0x5AE1,0xC3E4}, {0x5AE3,0xD5C1}, {0x5AE5,0x3A28}, {0x5AE6,0xD5C3},
{0x5AE9,0xD5C4}, {0x5AEA,0x3A29}, {0x5AEE,0x3A2A}, {0x5AF5,0x3A2B}, {0x5AF6,0x3A2C},
{0x5AFA,0xD5C6}, {0x5AFB,0xD5C7}, {0x5AFD,0x3A2D}, {0x5B00,0x3A2E}, {0x5B01,0x3A2F},
{0x5B08,0x3A30}, {0x5B09,0xB4F2}, {0x5B0B,0xD5C9}, {0x5B0C,0xD5C8}, {0x5B16,0xD5CA},
{0x5B17,0x3A31}, {0x5B19,0x3A33}, {0x5B1B,0x3A34}, {0x5B1D,0x3A35}, {0x5B21,0x3A36},
{0x5B22,0xBEEE}, {0x5B25,0x3A37}, {0x5B2A,0xD5CD}, {0x5B2C,0xC4DC}, {0x5B2D,0x3A38},
{0x5B30,0xB1C5}, {0x5B32,0xD5CB}, {0x5B34,0x3A32}, {0x5B36,0xD5CE}, {0x5B38,0x3A39},
{0x5B3E,0xD5CF}, {0x5B40,0xD5D2}, {0x5B41,0x3A3A}, {0x5B43,0xD5D0}, {0x5B45,0xD5D1},
{0x5B4B,0x3A3B}, {0x5B4C,0x3A3C}, {0x5B50,0xBBD2}, {0x5B51,0xD5D3}, {0x5B52,0x3A3D},
// {0x5B56,0xF9EA}, alternative
{0x5B54,0xB9A6}, {0x5B55,0xD5D4}, {0x5B56,0x3A3E}, {0x5B57,0xBBFA}, {0x5B58,0xC2B8},
{0x5B5A,0xD5D5}, {0x5B5B,0xD5D6}, {0x5B5C,0xBBDA}, {0x5B5D,0xB9A7}, {0x5B5E,0x3A3F},
{0x5B5F,0xCCD2}, {0x5B63,0xB5A8}, {0x5B64,0xB8C9}, {0x5B65,0xD5D7}, {0x5B66,0xB3D8},
{0x5B68,0x3A40}, {0x5B69,0xD5D8}, {0x5B6B,0xC2B9}, {0x5B6E,0x3A41}, {0x5B6F,0x3A42},
{0x5B70,0xD5D9}, {0x5B71,0xD6A3}, {0x5B73,0xD5DA}, {0x5B75,0xD5DB}, {0x5B78,0xD5DC},
{0x5B7A,0xD5DE}, {0x5B7C,0x3A43}, {0x5B7D,0x3A44}, {0x5B7E,0x3A45}, {0x5B7F,0x3A46},
{0x5B80,0xD5DF}, {0x5B81,0x3A47}, {0x5B83,0xD5E0}, {0x5B84,0x3A48}, {0x5B85,0xC2F0},
{0x5B86,0x3A49}, {0x5B87,0xB1A7}, {0x5B88,0xBCE9}, {0x5B89,0xB0C2}, {0x5B8A,0x3A4A},
{0x5B8B,0xC1D7}, {0x5B8C,0xB4B0}, {0x5B8D,0xBCB5}, {0x5B8E,0x3A4B}, {0x5B8F,0xB9A8},
{0x5B90,0x3A4C}, {0x5B91,0x3A4D}, {0x5B93,0x3A4E}, {0x5B94,0x3A4F}, {0x5B95,0xC5E6},
{0x5B96,0x3A50}, {0x5B97,0xBDA1}, {0x5B98,0xB4B1}, {0x5B99,0xC3E8}, {0x5B9A,0xC4EA},
{0x5B9B,0xB0B8}, {0x5B9C,0xB5B9}, {0x5B9D,0xCAF5}, {0x5B9F,0xBCC2}, {0x5BA2,0xB5D2},
{0x5BA3,0xC0EB}, {0x5BA4,0xBCBC}, {0x5BA5,0xCDA8}, {0x5BA6,0xD5E1}, {0x5BA8,0x3A51},
{0x5BA9,0x3A52}, {0x5BAC,0x3A53}, {0x5BAD,0x3A54}, {0x5BAE,0xB5DC}, {0x5BAF,0x3A55},
{0x5BB0,0xBACB}, {0x5BB1,0x3A56}, {0x5BB2,0x3A57}, {0x5BB3,0xB3B2}, {0x5BB4,0xB1E3},
{0x5BB5,0xBEAC}, {0x5BB6,0xB2C8}, {0x5BB7,0x3A58}, {0x5BB8,0xD5E2}, {0x5BB9,0xCDC6},
// {0x5BC0,0xF9EB}, alternative
{0x5BBA,0x3A59}, {0x5BBC,0x3A5A}, {0x5BBF,0xBDC9}, {0x5BC0,0x3A5B}, {0x5BC1,0x3A5C},
{0x5BC2,0xBCE4}, {0x5BC3,0xD5E3}, {0x5BC4,0xB4F3}, {0x5BC5,0xC6D2}, {0x5BC6,0xCCA9},
{0x5BC7,0xD5E4}, {0x5BC9,0xD5E5}, {0x5BCC,0xC9D9}, {0x5BCD,0x3A5D}, {0x5BCF,0x3A5E},
{0x5BD0,0xD5E7}, {0x5BD2,0xB4A8}, {0x5BD3,0xB6F7}, {0x5BD4,0xD5E6}, {0x5BD6,0x3A5F},
// {0x5BD8,0xF9ED}, alternative
{0x5BD7,0x3A60}, {0x5BD8,0x3A61}, {0x5BD9,0x3A62}, {0x5BDA,0x3A63}, {0x5BDB,0xB4B2},
{0x5BDD,0xBFB2}, {0x5BDE,0xD5EB}, {0x5BDF,0xBBA1}, {0x5BE0,0x3A64}, {0x5BE1,0xB2C9},
{0x5BE2,0xD5EA}, {0x5BE4,0xD5E8}, {0x5BE5,0xD5EC}, {0x5BE6,0xD5E9}, {0x5BE7,0xC7AB},
{0x5BE8,0xDCCD}, {0x5BE9,0xBFB3}, {0x5BEB,0xD5ED},
{0x5BEC,0x743a},
{0x5BEE,0xCEC0}, {0x5BEF,0x3A65},
{0x5BF0,0xD5EE}, {0x5BF1,0x3A66}, {0x5BF3,0xD5F0}, {0x5BF4,0x3A67}, {0x5BF5,0xC3FE},
{0x5BF6,0xD5EF}, {0x5BF8,0xC0A3}, {0x5BFA,0xBBFB}, {0x5BFD,0x3A68}, {0x5BFE,0xC2D0},
{0x5BFF,0xBCF7}, {0x5C01,0xC9F5}, {0x5C02,0xC0EC}, {0x5C04,0xBCCD}, {0x5C05,0xD5F1},
{0x5C06,0xBEAD}, {0x5C07,0xD5F2}, {0x5C08,0xD5F3}, {0x5C09,0xB0D3}, {0x5C0A,0xC2BA},
{0x5C0B,0xBFD2}, {0x5C0C,0x3A69}, {0x5C0D,0xD5F4}, {0x5C0E,0xC6B3}, {0x5C0F,0xBEAE},
{0x5C11,0xBEAF}, {0x5C13,0xD5F5}, {0x5C16,0xC0ED}, {0x5C17,0x3A6A}, {0x5C1A,0xBEB0},
// {0x5C1E,0xF9EF}, alternative
{0x5C1E,0x3A6B}, {0x5C1F,0x3A6C}, {0x5C20,0xD5F6}, {0x5C22,0xD5F7}, {0x5C23,0x3A6D},
{0x5C24,0xCCE0}, {0x5C26,0x3A6E}, {0x5C28,0xD5F8}, {0x5C29,0x3A6F}, {0x5C2B,0x3A70},
{0x5C2C,0x3A71}, {0x5C2D,0xB6C6}, {0x5C2E,0x3A72}, {0x5C30,0x3A73}, {0x5C31,0xBDA2},
{0x5C32,0x3A74}, {0x5C35,0x3A75}, {0x5C36,0x3A76}, {0x5C38,0xD5F9}, {0x5C39,0xD5FA},
{0x5C3A,0xBCDC}, {0x5C3B,0xBFAC}, {0x5C3C,0xC6F4}, {0x5C3D,0xBFD4}, {0x5C3E,0xC8F8},
{0x5C3F,0xC7A2}, {0x5C40,0xB6C9}, {0x5C41,0xD5FB}, {0x5C45,0xB5EF}, {0x5C46,0xD5FC},
{0x5C48,0xB6FE}, {0x5C4A,0xC6CF}, {0x5C4B,0xB2B0}, {0x5C4D,0xBBD3}, {0x5C4E,0xD5FD},
{0x5C4F,0xD6A2}, {0x5C50,0xD6A1}, {0x5C51,0xB6FD}, {0x5C53,0xD5FE}, {0x5C55,0xC5B8},
{0x5C59,0x3A77}, {0x5C5A,0x3A78}, {0x5C5C,0x3A79}, {0x5C5E,0xC2B0}, {0x5C60,0xC5CB},
{0x5C61,0xBCC8}, {0x5C62,0x3A7A}, {0x5C63,0x3A7B}, {0x5C64,0xC1D8}, {0x5C65,0xCDFA},
{0x5C67,0x3A7C}, {0x5C68,0x3A7D}, {0x5C69,0x3A7E}, {0x5C6C,0xD6A4}, {0x5C6D,0x3B21},
{0x5C6E,0xD6A5}, {0x5C6F,0xC6D6}, {0x5C70,0x3B22}, {0x5C71,0xBBB3}, {0x5C74,0x3B23},
{0x5C75,0x3B24}, {0x5C76,0xD6A7}, {0x5C79,0xD6A8}, {0x5C7A,0x3B25}, {0x5C7B,0x3B26},
{0x5C7C,0x3B27}, {0x5C7D,0x3B28}, {0x5C87,0x3B29}, {0x5C88,0x3B2A}, {0x5C8A,0x3B2B},
{0x5C8C,0xD6A9}, {0x5C8F,0x3B2C}, {0x5C90,0xB4F4}, {0x5C91,0xD6AA}, {0x5C92,0x3B2D},
{0x5C94,0xD6AB}, {0x5C9D,0x3B2E}, {0x5C9F,0x3B2F}, {0x5CA0,0x3B30}, {0x5CA1,0xB2AC},
// {0x5CA6,0xF9F0}, alternative
{0x5CA2,0x3B31}, {0x5CA3,0x3B32}, {0x5CA6,0x3B33}, {0x5CA8,0xC1BB}, {0x5CA9,0xB4E4},
{0x5CAA,0x3B34}, {0x5CAB,0xD6AD}, {0x5CAC,0xCCA8}, {0x5CB1,0xC2D2}, {0x5CB2,0x3B35},
{0x5CB3,0xB3D9}, {0x5CB4,0x3B36}, {0x5CB5,0x3B37}, {0x5CB6,0xD6AF}, {0x5CB7,0xD6B1},
// {0x5CBA,0xF9F1}, alternative
{0x5CB8,0xB4DF}, {0x5CBA,0x3B38}, {0x5CBB,0xD6AE}, {0x5CBC,0xD6B0}, {0x5CBE,0xD6B3},
{0x5CC5,0xD6B2}, {0x5CC7,0xD6B4}, {0x5CC9,0x3B39}, {0x5CCB,0x3B3A}, {0x5CD2,0x3B3B},
{0x5CD7,0x3B3D}, {0x5CD9,0xD6B5}, {0x5CDD,0x3B3C}, {0x5CE0,0xC6BD}, {0x5CE1,0xB6AE},
{0x5CE8,0xB2E5}, {0x5CE9,0xD6B6}, {0x5CEA,0xD6BB}, {0x5CED,0xD6B9}, {0x5CEE,0x3B3E},
{0x5CEF,0xCAF7}, {0x5CF0,0xCAF6}, {0x5CF1,0x3B3F}, {0x5CF2,0x3B40}, {0x5CF4,0x3B41},
{0x5CF5,0x743b},
{0x5CF6,0xC5E7}, {0x5CFA,0xD6B8}, {0x5CFB,0xBDD4}, {0x5CFD,0xD6B7}, {0x5D01,0x3B42},
{0x5D06,0x3B43}, {0x5D07,0xBFF2}, {0x5D0B,0xD6BC}, {0x5D0D,0x3B44}, {0x5D0E,0xBAEA},
{0x5D11,0xD6C2}, {0x5D12,0x3B45}, {0x5D14,0xD6C3}, {0x5D15,0xD6BD}, {0x5D16,0xB3B3},
{0x5D17,0xD6BE}, {0x5D18,0xD6C7}, {0x5D19,0xD6C6}, {0x5D1A,0xD6C5}, {0x5D1B,0xD6C1},
{0x5D1F,0xD6C0}, {0x5D22,0xD6C4}, {0x5D23,0x3B47}, {0x5D24,0x3B48}, {0x5D26,0x3B49},
// {0x5D27,0xF9F3}, alternative
{0x5D27,0x3B4A}, {0x5D29,0xCAF8}, {0x5D2B,0x3B46}, {0x5D31,0x3B4B}, {0x5D34,0x3B4C},
// {0x5D42,0xF9F6}, alternative
{0x5D39,0x3B4D}, {0x5D3D,0x3B4E}, {0x5D3F,0x3B4F}, {0x5D42,0x3B50}, {0x5D43,0x3B51},
{0x5D46,0x3B52}, {0x5D48,0x3B53}, {0x5D4A,0x3B57}, {0x5D4B,0xD6CB}, {0x5D4C,0xD6C8},
{0x5D4E,0xD6CA}, {0x5D50,0xCDF2}, {0x5D51,0x3B55}, {0x5D52,0xD6C9},
{0x5D53,0x743c},
{0x5D55,0x3B54},
{0x5D59,0x3B56}, {0x5D5C,0xD6BF}, {0x5D5F,0x3B58}, {0x5D60,0x3B59}, {0x5D61,0x3B5A},
{0x5D62,0x3B5B}, {0x5D64,0x3B5C}, {0x5D69,0xBFF3}, {0x5D6A,0x3B5D}, {0x5D6C,0xD6CC},
// {0x5D6D,0xF9F7}, alternative
{0x5D6D,0x3B5E}, {0x5D6F,0xBAB7}, {0x5D70,0x3B5F}, {0x5D73,0xD6CD}, {0x5D76,0xD6CE},
{0x5D79,0x3B60}, {0x5D7A,0x3B61}, {0x5D7E,0x3B62}, {0x5D7F,0x3B63}, {0x5D81,0x3B64},
{0x5D82,0xD6D1}, {0x5D83,0x3B65}, {0x5D84,0xD6D0}, {0x5D87,0xD6CF}, {0x5D88,0x3B66},
{0x5D8A,0x3B67}, {0x5D8B,0xC5E8}, {0x5D8C,0xD6BA}, {0x5D90,0xD6D7}, {0x5D92,0x3B68},
{0x5D93,0x3B69}, {0x5D94,0x3B6A}, {0x5D95,0x3B6B}, {0x5D99,0x3B6C}, {0x5D9B,0x3B6D},
{0x5D9D,0xD6D3}, {0x5D9F,0x3B6E}, {0x5DA0,0x3B6F}, {0x5DA2,0xD6D2}, {0x5DA7,0x3B70},
{0x5DAB,0x3B71}, {0x5DAC,0xD6D4}, {0x5DAE,0xD6D5}, {0x5DB0,0x3B72}, {0x5DB2,0x6674},
// {0x5DB8,0xF9F8}, alternative
// {0x5DB9,0xF9F9}, alternative
{0x5DB4,0x3B73}, {0x5DB7,0xD6D8}, {0x5DB8,0x3B74}, {0x5DB9,0x3B75}, {0x5DBA,0xCEE6},
{0x5DBC,0xD6D9}, {0x5DBD,0xD6D6}, {0x5DC3,0x3B76}, {0x5DC7,0x3B77}, {0x5DC9,0xD6DA},
// {0x5DD0,0xF9FA}, alternative
{0x5DCB,0x3B78}, {0x5DCC,0xB4E0}, {0x5DCD,0xD6DB}, {0x5DCE,0x3B7A}, {0x5DD0,0x3B79},
{0x5DD2,0xD6DD}, {0x5DD3,0xD6DC}, {0x5DD6,0xD6DE}, {0x5DD8,0x3B7B}, {0x5DD9,0x3B7C},
{0x5DDB,0xD6DF}, {0x5DDD,0xC0EE}, {0x5DDE,0xBDA3}, {0x5DE0,0x3B7D}, {0x5DE1,0xBDE4},
{0x5DE3,0xC1E3}, {0x5DE4,0x3B7E}, {0x5DE5,0xB9A9}, {0x5DE6,0xBAB8}, {0x5DE7,0xB9AA},
{0x5DE8,0xB5F0}, {0x5DE9,0x3C21}, {0x5DEB,0xD6E0}, {0x5DEE,0xBAB9}, {0x5DF1,0xB8CA},
{0x5DF2,0xD6E1}, {0x5DF3,0xCCA6}, {0x5DF4,0xC7C3}, {0x5DF5,0xD6E2}, {0x5DF7,0xB9AB},
{0x5DF8,0x3C22}, {0x5DF9,0x3C23}, {0x5DFB,0xB4AC}, {0x5DFD,0xC3A7}, {0x5DFE,0xB6D2},
{0x5E00,0x3C24}, {0x5E02,0xBBD4}, {0x5E03,0xC9DB}, {0x5E06,0xC8C1}, {0x5E07,0x3C25},
{0x5E0B,0xD6E3}, {0x5E0C,0xB4F5}, {0x5E0D,0x3C26}, {0x5E11,0xD6E6}, {0x5E12,0x3C27},
{0x5E14,0x3C28}, {0x5E15,0x3C29}, {0x5E16,0xC4A1}, {0x5E18,0x3C2A}, {0x5E19,0xD6E5},
{0x5E1A,0xD6E4}, {0x5E1B,0xD6E7}, {0x5E1D,0xC4EB}, {0x5E1F,0x3C2B}, {0x5E20,0x3C2C},
{0x5E25,0xBFE3}, {0x5E28,0x3C2E}, {0x5E2B,0xBBD5}, {0x5E2D,0xC0CA}, {0x5E2E,0x3C2D},
{0x5E2F,0xC2D3}, {0x5E30,0xB5A2}, {0x5E32,0x3C2F}, {0x5E33,0xC4A2}, {0x5E35,0x3C30},
{0x5E36,0xD6E8}, {0x5E37,0xD6E9}, {0x5E38,0xBEEF}, {0x5E3D,0xCBB9}, {0x5E3E,0x3C31},
{0x5E40,0xD6EC}, {0x5E43,0xD6EB}, {0x5E44,0xD6EA}, {0x5E45,0xC9FD}, {0x5E47,0xD6F3},
{0x5E49,0x3C34}, {0x5E4B,0x3C32}, {0x5E4C,0xCBDA}, {0x5E4E,0xD6ED}, {0x5E50,0x3C33},
{0x5E51,0x3C35}, {0x5E54,0xD6EF}, {0x5E55,0xCBEB}, {0x5E56,0x3C36}, {0x5E57,0xD6EE},
{0x5E58,0x3C37}, {0x5E5B,0x3C38}, {0x5E5C,0x3C39}, {0x5E5E,0x3C3A}, {0x5E5F,0xD6F0},
{0x5E61,0xC8A8}, {0x5E62,0xD6F1}, {0x5E63,0xCABE}, {0x5E64,0xD6F2}, {0x5E68,0x3C3B},
{0x5E6A,0x3C3C}, {0x5E6B,0x3C3D}, {0x5E6C,0x3C3E}, {0x5E6D,0x3C3F}, {0x5E6E,0x3C40},
{0x5E70,0x3C41}, {0x5E72,0xB4B3}, {0x5E73,0xCABF}, {0x5E74,0xC7AF}, {0x5E75,0xD6F4},
{0x5E76,0xD6F5}, {0x5E78,0xB9AC}, {0x5E79,0xB4B4}, {0x5E7A,0xD6F6}, {0x5E7B,0xB8B8},
{0x5E7C,0xCDC4}, {0x5E7D,0xCDA9}, {0x5E7E,0xB4F6}, {0x5E7F,0xD6F8}, {0x5E80,0x3C42},
{0x5E81,0xC4A3}, {0x5E83,0xB9AD}, {0x5E84,0xBEB1}, {0x5E87,0xC8DF}, {0x5E8A,0xBEB2},
{0x5E8B,0x3C43}, {0x5E8E,0x3C44}, {0x5E8F,0xBDF8}, {0x5E95,0xC4EC}, {0x5E96,0xCAF9},
{0x5E97,0xC5B9}, {0x5E9A,0xB9AE}, {0x5E9C,0xC9DC}, {0x5EA0,0xD6F9}, {0x5EA2,0x3C45},
{0x5EA4,0x3C46}, {0x5EA5,0x3C47}, {0x5EA6,0xC5D9}, {0x5EA7,0xBAC2}, {0x5EA8,0x3C48},
{0x5EAA,0x3C49}, {0x5EAB,0xB8CB}, {0x5EAC,0x3C4A}, {0x5EAD,0xC4ED}, {0x5EB1,0x3C4B},
{0x5EB3,0x3C4C}, {0x5EB5,0xB0C3}, {0x5EB6,0xBDEE}, {0x5EB7,0xB9AF}, {0x5EB8,0xCDC7},
{0x5EBD,0x3C4D}, {0x5EBE,0x3C4E}, {0x5EBF,0x3C4F}, {0x5EC1,0xD6FA}, {0x5EC2,0xD6FB},
{0x5EC3,0xC7D1}, {0x5EC6,0x3C50}, {0x5EC8,0xD6FC}, {0x5EC9,0xCEF7}, {0x5ECA,0xCFAD},
{0x5ECB,0x3C52}, {0x5ECC,0x3C51}, {0x5ECE,0x3C53}, {0x5ECF,0xD6FE}, {0x5ED0,0xD6FD},
{0x5ED1,0x3C54}, {0x5ED2,0x3C55}, {0x5ED3,0xB3C7}, {0x5ED4,0x3C56}, {0x5ED5,0x3C57},
{0x5ED6,0xD7A1}, {0x5EDA,0xD7A4}, {0x5EDB,0xD7A5}, {0x5EDC,0x3C58}, {0x5EDD,0xD7A3},
{0x5EDE,0x3C59}, {0x5EDF,0xC9C0}, {0x5EE0,0xBEB3}, {0x5EE1,0xD7A7}, {0x5EE2,0xD7A6},
{0x5EE3,0xD7A2}, {0x5EE5,0x3C5A}, {0x5EE8,0xD7A8}, {0x5EE9,0xD7A9}, {0x5EEB,0x3C5B},
{0x5EEC,0xD7AA}, {0x5EF0,0xD7AD}, {0x5EF1,0xD7AB}, {0x5EF3,0xD7AC}, {0x5EF4,0xD7AE},
{0x5EF6,0xB1E4}, {0x5EF7,0xC4EE}, {0x5EF8,0xD7AF}, {0x5EFA,0xB7FA}, {0x5EFB,0xB2F6},
{0x5EFC,0xC7B6}, {0x5EFE,0xD7B0}, {0x5EFF,0xC6FB}, {0x5F01,0xCADB}, {0x5F02,0x3C5C},
{0x5F03,0xD7B1}, {0x5F04,0xCFAE}, {0x5F06,0x3C5D}, {0x5F07,0x3C5E}, {0x5F08,0x3C5F},
{0x5F09,0xD7B2}, {0x5F0A,0xCAC0}, {0x5F0B,0xD7B5}, {0x5F0C,0xD0A1}, {0x5F0D,0xD0B1},
{0x5F0E,0x3C60}, {0x5F0F,0xBCB0}, {0x5F10,0xC6F5}, {0x5F11,0xD7B6}, {0x5F13,0xB5DD},
{0x5F14,0xC4A4}, {0x5F15,0xB0FA}, {0x5F16,0xD7B7}, {0x5F17,0xCAA6}, {0x5F18,0xB9B0},
{0x5F19,0x3C61}, {0x5F1B,0xC3D0}, {0x5F1C,0x3C62}, {0x5F1D,0x3C63}, {0x5F1F,0xC4EF},
// {0x5F21,0xF9FB}, alternative
{0x5F21,0x3C64}, {0x5F22,0x3C65}, {0x5F23,0x3C66}, {0x5F24,0x3C67}, {0x5F25,0xCCEF},
{0x5F26,0xB8B9}, {0x5F27,0xB8CC}, {0x5F28,0x3C68}, {0x5F29,0xD7B8}, {0x5F2B,0x3C69},
{0x5F2C,0x3C6A}, {0x5F2D,0xD7B9}, {0x5F2E,0x3C6B}, {0x5F2F,0xD7BF}, {0x5F30,0x3C6C},
// {0x5F34,0xF9FC}, alternative
{0x5F31,0xBCE5}, {0x5F34,0x3C6D}, {0x5F35,0xC4A5}, {0x5F36,0x3C6E}, {0x5F37,0xB6AF},
{0x5F38,0xD7BA}, {0x5F3B,0x3C6F}, {0x5F3C,0xC9AB}, {0x5F3D,0x3C70}, {0x5F3E,0xC3C6},
// {0x5F45,0xF9AC}, alternative
{0x5F3F,0x3C71}, {0x5F40,0x3C72}, {0x5F41,0xD7BB}, {0x5F44,0x3C73}, {0x5F45,0x3C74},
{0x5F47,0x3C75}, {0x5F48,0xD7BC}, {0x5F4A,0xB6B0}, {0x5F4C,0xD7BD}, {0x5F4D,0x3C76},
{0x5F4E,0xD7BE}, {0x5F50,0x3C77}, {0x5F51,0xD7C0}, {0x5F53,0xC5F6}, {0x5F54,0x3C78},
{0x5F56,0xD7C1}, {0x5F57,0xD7C2}, {0x5F58,0x3C79}, {0x5F59,0xD7C3}, {0x5F5B,0x3C7A},
{0x5F5C,0xD7B4}, {0x5F5D,0xD7B3}, {0x5F60,0x3C7B}, {0x5F61,0xD7C4}, {0x5F62,0xB7C1},
// {0x5F67,0xF9FD}, alternative
{0x5F63,0x3C7C}, {0x5F64,0x3C7D}, {0x5F66,0xC9A7}, {0x5F67,0x3C7E}, {0x5F69,0xBACC},
{0x5F6A,0xC9B7}, {0x5F6B,0xC4A6}, {0x5F6C,0xC9CB}, {0x5F6D,0xD7C5}, {0x5F6F,0x3D21},
{0x5F70,0xBEB4}, {0x5F71,0xB1C6}, {0x5F72,0x3D22}, {0x5F73,0xD7C6}, {0x5F74,0x3D23},
{0x5F75,0x3D24}, {0x5F77,0xD7C7}, {0x5F78,0x3D25}, {0x5F79,0xCCF2}, {0x5F7A,0x3D26},
{0x5F7C,0xC8E0}, {0x5F7D,0x3D27}, {0x5F7E,0x3D28}, {0x5F7F,0xD7CA}, {0x5F80,0xB1FD},
{0x5F81,0xC0AC}, {0x5F82,0xD7C9}, {0x5F83,0xD7C8}, {0x5F84,0xB7C2}, {0x5F85,0xC2D4},
{0x5F87,0xD7CE}, {0x5F88,0xD7CC}, {0x5F89,0x3D29}, {0x5F8A,0xD7CB}, {0x5F8B,0xCEA7},
{0x5F8C,0xB8E5}, {0x5F8D,0x3D2A}, {0x5F8F,0x3D2B}, {0x5F90,0xBDF9}, {0x5F91,0xD7CD},
{0x5F92,0xC5CC}, {0x5F93,0xBDBE}, {0x5F96,0x3D2C}, {0x5F97,0xC6C0}, {0x5F98,0xD7D1},
{0x5F99,0xD7D0}, {0x5F9C,0x3D2D}, {0x5F9D,0x3D2E}, {0x5F9E,0xD7CF}, {0x5FA0,0xD7D2},
{0x5FA1,0xB8E6}, {0x5FA2,0x3D2F}, {0x5FA4,0x3D32}, {0x5FA7,0x3D30}, {0x5FA8,0xD7D3},
{0x5FA9,0xC9FC}, {0x5FAA,0xBDDB}, {0x5FAB,0x3D31}, {0x5FAC,0x3D33}, {0x5FAD,0xD7D4},
{0x5FAE,0xC8F9}, {0x5FAF,0x3D34}, {0x5FB0,0x3D35}, {0x5FB1,0x3D36}, {0x5FB3,0xC6C1},
{0x5FB4,0xC4A7},
{0x5FB7,0x743e},
{0x5FB8,0x3D37}, {0x5FB9,0xC5B0}, {0x5FBC,0xD7D5}, {0x5FBD,0xB5AB},
{0x5FC3,0xBFB4}, {0x5FC4,0x3D38}, {0x5FC5,0xC9AC}, {0x5FC7,0x3D39}, {0x5FC8,0x3D3A},
{0x5FC9,0x3D3B}, {0x5FCB,0x3D3C}, {0x5FCC,0xB4F7}, {0x5FCD,0xC7A6}, {0x5FD0,0x3D3D},
{0x5FD1,0x3D3E}, {0x5FD2,0x3D3F}, {0x5FD3,0x3D40}, {0x5FD4,0x3D41}, {0x5FD6,0xD7D6},
{0x5FD7,0xBBD6}, {0x5FD8,0xCBBA}, {0x5FD9,0xCBBB}, {0x5FDC,0xB1FE}, {0x5FDD,0xD7DB},
// {0x5FDE,0xFAA1}, alternative
{0x5FDE,0x3D42}, {0x5FE0,0xC3E9}, {0x5FE1,0x3D43}, {0x5FE2,0x3D44}, {0x5FE4,0xD7D8},
{0x5FE8,0x3D45}, {0x5FE9,0x3D46}, {0x5FEA,0x3D47}, {0x5FEB,0xB2F7}, {0x5FEC,0x3D48},
{0x5FED,0x3D49}, {0x5FEE,0x3D4A}, {0x5FEF,0x3D4B}, {0x5FF0,0xD8AD}, {0x5FF1,0xD7DA},
{0x5FF2,0x3D4C}, {0x5FF3,0x3D4D}, {0x5FF5,0xC7B0}, {0x5FF6,0x3D4E}, {0x5FF8,0xD7D9},
{0x5FFA,0x3D4F}, {0x5FFB,0xD7D7}, {0x5FFC,0x3D50}, {0x5FFD,0xB9FA}, {0x5FFF,0xD7DD},
{0x6007,0x3D51}, {0x600A,0x3D52}, {0x600D,0x3D53}, {0x600E,0xD7E3}, {0x600F,0xD7E9},
{0x6010,0xD7E1}, {0x6012,0xC5DC}, {0x6013,0x3D54}, {0x6014,0x3D55}, {0x6015,0xD7E6},
{0x6016,0xC9DD}, {0x6017,0x3D56}, {0x6018,0x3D57}, {0x6019,0xD7E0}, {0x601A,0x3D58},
{0x601B,0xD7E5}, {0x601C,0xCEE7}, {0x601D,0xBBD7}, {0x601F,0x3D59}, {0x6020,0xC2D5},
{0x6021,0xD7DE}, {0x6024,0x3D5A}, {0x6025,0xB5DE}, {0x6026,0xD7E8}, {0x6027,0xC0AD},
{0x6028,0xB1E5}, {0x6029,0xD7E2}, {0x602A,0xB2F8}, {0x602B,0xD7E7}, {0x602D,0x3D5B},
{0x602F,0xB6B1}, {0x6031,0xD7E4}, {0x6033,0x3D5C}, {0x6035,0x3D5D}, {0x603A,0xD7EA},
{0x6040,0x3D5E}, {0x6041,0xD7EC}, {0x6042,0xD7F6}, {0x6043,0xD7F4}, {0x6046,0xD7F1},
{0x6047,0x3D5F}, {0x6048,0x3D60}, {0x6049,0x3D61}, {0x604A,0xD7F0}, {0x604B,0xCEF8},
{0x604C,0x3D62}, {0x604D,0xD7F2}, {0x6050,0xB6B2}, {0x6051,0x3D63}, {0x6052,0xB9B1},
{0x6054,0x3D64}, {0x6055,0xBDFA}, {0x6056,0x3D65}, {0x6057,0x3D66}, {0x6059,0xD7F9},
// {0x605D,0xFAA2}, alternative
{0x605A,0xD7EB}, {0x605D,0x3D67}, {0x605F,0xD7EF}, {0x6060,0xD7DF}, {0x6061,0x3D68},
{0x6062,0xB2FA}, {0x6063,0xD7F3}, {0x6064,0xD7F5}, {0x6065,0xC3D1}, {0x6067,0x3D69},
{0x6068,0xBAA8}, {0x6069,0xB2B8}, {0x606A,0xD7ED}, {0x606B,0xD7F8}, {0x606C,0xD7F7},
{0x606D,0xB6B3}, {0x606F,0xC2A9}, {0x6070,0xB3E6}, {0x6071,0x3D6A}, {0x6075,0xB7C3},
{0x6077,0xD7EE}, {0x607E,0x3D6B}, {0x607F,0x3D6C}, {0x6081,0xD7FA}, {0x6082,0x3D6D},
{0x6083,0xD7FD}, {0x6084,0xD8A1},
{0x6085,0x743f},
{0x6086,0x3D6E}, {0x6088,0x3D6F}, {0x6089,0xBCBD},
// {0x608A,0xFAA4}, alternative
{0x608A,0x3D70}, {0x608B,0xD8A7}, {0x608C,0xC4F0}, {0x608D,0xD7FB}, {0x608E,0x3D71},
{0x6091,0x3D72}, {0x6092,0xD8A5}, {0x6093,0x3D73}, {0x6094,0xB2F9}, {0x6095,0x3D74},
{0x6096,0xD8A3}, {0x6097,0xD8A4}, {0x6098,0x3D75}, {0x609A,0xD7FE}, {0x609B,0xD8A2},
{0x609D,0x3D76}, {0x609E,0x3D77}, {0x609F,0xB8E7}, {0x60A0,0xCDAA}, {0x60A2,0x3D78},
{0x60A3,0xB4B5}, {0x60A4,0x3D79}, {0x60A5,0x3D7A}, {0x60A6,0xB1D9}, {0x60A7,0xD8A6},
{0x60A8,0x3D7B}, {0x60A9,0xC7BA}, {0x60AA,0xB0AD}, {0x60B0,0x3D7C}, {0x60B1,0x3D7D},
{0x60B2,0xC8E1}, {0x60B3,0xD7DC}, {0x60B4,0xD8AC}, {0x60B5,0xD8B0}, {0x60B6,0xCCE5},
{0x60B7,0x3D7E}, {0x60B8,0xD8A9}, {0x60BB,0x3E21}, {0x60BC,0xC5E9}, {0x60BD,0xD8AE},
{0x60BE,0x3E22}, {0x60C2,0x3E23}, {0x60C4,0x3E24}, {0x60C5,0xBEF0}, {0x60C6,0xD8AF},
{0x60C7,0xC6D7}, {0x60C8,0x3E25}, {0x60C9,0x3E26}, {0x60CA,0x3E27}, {0x60CB,0x3E28},
{0x60CE,0x3E29}, {0x60CF,0x3E2A}, {0x60D1,0xCFC7}, {0x60D3,0xD8AB}, {0x60D4,0x3E2B},
// {0x60D5,0xFAA6}, alternative
{0x60D5,0x3E2C}, {0x60D8,0xD8B1}, {0x60D9,0x3E2D}, {0x60DA,0xB9FB}, {0x60DB,0x3E2E},
// {0x60DE,0xFAA5}, alternative
{0x60DC,0xC0CB}, {0x60DD,0x3E2F}, {0x60DE,0x3E30}, {0x60DF,0xB0D4}, {0x60E0,0xD8AA},
{0x60E1,0xD8A8}, {0x60E2,0x3E31}, {0x60E3,0xC1DA}, {0x60E5,0x3E32}, {0x60E7,0xD7FC},
// {0x60F2,0xFAA8}, alternative
{0x60E8,0xBBB4}, {0x60F0,0xC2C6}, {0x60F1,0xD8BD}, {0x60F2,0x3E33}, {0x60F3,0xC1DB},
{0x60F4,0xD8B8}, {0x60F5,0x3E34}, {0x60F6,0xD8B5}, {0x60F7,0xD8B6}, {0x60F8,0x3E35},
{0x60F9,0xBCE6}, {0x60FA,0xD8B9}, {0x60FB,0xD8BC}, {0x60FC,0x3E36}, {0x60FD,0x3E37},
{0x6100,0xD8B7}, {0x6101,0xBDA5}, {0x6102,0x3E38}, {0x6103,0xD8BA}, {0x6106,0xD8B4},
{0x6107,0x3E39}, {0x6108,0xCCFC}, {0x6109,0xCCFB}, {0x610A,0x3E3A}, {0x610C,0x3E3B},
// {0x6111,0xFAA9}, alternative
{0x610D,0xD8BE}, {0x610E,0xD8BF}, {0x610F,0xB0D5}, {0x6110,0x3E3C}, {0x6111,0x3E3D},
{0x6112,0x3E3E}, {0x6113,0x3E3F}, {0x6114,0x3E40}, {0x6115,0xD8B3}, {0x6116,0x3E41},
{0x6117,0x3E42}, {0x6119,0x3E43}, {0x611A,0xB6F2}, {0x611B,0xB0A6}, {0x611C,0x3E44},
{0x611E,0x3E45}, {0x611F,0xB4B6},
{0x6120,0x7440},
{0x6121,0xD8BB}, {0x6122,0x3E46}, {0x6127,0xD8C3},
{0x6128,0xD8C2}, {0x612A,0x3E47}, {0x612B,0x3E48}, {0x612C,0xD8C7},
{0x6130,0x3E49},
// {0x6137,0xFAAA}, alternative
{0x6131,0x3E4A}, {0x6134,0xD8C8}, {0x6135,0x3E4B}, {0x6136,0x3E4C}, {0x6137,0x3E4D},
{0x6139,0x3E4E}, {0x613C,0xD8C6}, {0x613D,0xD8C9}, {0x613E,0xD8C1}, {0x613F,0xD8C5},
{0x6141,0x3E4F}, {0x6142,0xD8CA}, {0x6144,0xD8CB}, {0x6145,0x3E50}, {0x6146,0x3E51},
{0x6147,0xD8C0}, {0x6148,0xBBFC}, {0x6149,0x3E52}, {0x614A,0xD8C4}, {0x614B,0xC2D6},
{0x614C,0xB9B2}, {0x614D,0xD8B2}, {0x614E,0xBFB5}, {0x6153,0xD8D8}, {0x6155,0xCAE9},
{0x6158,0xD8CE}, {0x6159,0xD8CF}, {0x615A,0xD8D0}, {0x615D,0xD8D7}, {0x615E,0x3E53},
{0x615F,0xD8D6}, {0x6160,0x3E54}, {0x6162,0xCBFD}, {0x6163,0xB4B7}, {0x6165,0xD8D4},
{0x6167,0xB7C5}, {0x6168,0xB3B4}, {0x616B,0xD8D1}, {0x616C,0x3E55}, {0x616E,0xCEB8},
{0x616F,0xD8D3}, {0x6170,0xB0D6}, {0x6171,0xD8D5}, {0x6172,0x3E56}, {0x6173,0xD8CC},
{0x6174,0xD8D2}, {0x6175,0xD8D9}, {0x6176,0xB7C4}, {0x6177,0xD8CD}, {0x6178,0x3E57},
{0x617B,0x3E58}, {0x617C,0x3E59}, {0x617E,0xCDDD}, {0x617F,0x3E5A}, {0x6180,0x3E5B},
{0x6181,0x3E5C}, {0x6182,0xCDAB}, {0x6183,0x3E5D}, {0x6184,0x3E5E}, {0x6187,0xD8DC},
{0x618A,0xD8E0}, {0x618B,0x3E5F}, {0x618D,0x3E60}, {0x618E,0xC1FE}, {0x6190,0xCEF9},
{0x6191,0xD8E1}, {0x6192,0x3E61}, {0x6193,0x3E62}, {0x6194,0xD8DE}, {0x6196,0xD8DB},
// {0x6198,0xFAAC}, alternative
{0x6197,0x3E63}, {0x6198,0x3E64}, {0x6199,0xD8DA}, {0x619A,0xD8DF}, {0x619C,0x3E65},
{0x619D,0x3E66}, {0x619F,0x3E67}, {0x61A0,0x3E68}, {0x61A4,0xCAB0}, {0x61A5,0x3E69},
{0x61A7,0xC6B4}, {0x61A8,0x3E6A}, {0x61A9,0xB7C6}, {0x61AA,0x3E6B}, {0x61AB,0xD8E2},
{0x61AC,0xD8DD}, {0x61AD,0x3E6C}, {0x61AE,0xD8E3}, {0x61B2,0xB7FB}, {0x61B6,0xB2B1},
{0x61B8,0x3E6D}, {0x61B9,0x3E6E}, {0x61BA,0xD8EB}, {0x61BC,0x3E6F}, {0x61BE,0xB4B8},
{0x61C0,0x3E70}, {0x61C1,0x3E71}, {0x61C2,0x3E72}, {0x61C3,0xD8E9}, {0x61C6,0xD8EA},
{0x61C7,0xBAA9}, {0x61C8,0xD8E8}, {0x61C9,0xD8E6}, {0x61CA,0xD8E5}, {0x61CB,0xD8EC},
{0x61CC,0xD8E4}, {0x61CD,0xD8EE}, {0x61CE,0x3E73}, {0x61CF,0x3E74}, {0x61D0,0xB2FB},
{0x61D5,0x3E75}, {0x61DC,0x3E76}, {0x61DD,0x3E77}, {0x61DE,0x3E78}, {0x61DF,0x3E79},
{0x61E1,0x3E7A}, {0x61E2,0x3E7B}, {0x61E3,0xD8F0}, {0x61E5,0x3E7E}, {0x61E6,0xD8EF},
{0x61E7,0x3E7C}, {0x61E9,0x3E7D}, {0x61EC,0x3F21}, {0x61ED,0x3F22}, {0x61EF,0x3F23},
{0x61F2,0xC4A8}, {0x61F4,0xD8F3}, {0x61F6,0xD8F1}, {0x61F7,0xD8E7}, {0x61F8,0xB7FC},
{0x61FA,0xD8F2}, {0x61FC,0xD8F6}, {0x61FD,0xD8F5}, {0x61FE,0xD8F7}, {0x61FF,0xD8F4},
{0x6200,0xD8F8}, {0x6201,0x3F24}, {0x6203,0x3F25}, {0x6204,0x3F26}, {0x6207,0x3F27},
{0x6208,0xD8F9}, {0x6209,0xD8FA}, {0x620A,0xCAEA}, {0x620C,0xD8FC}, {0x620D,0xD8FB},
// {0x6213,0xFAAD}, alternative
{0x620E,0xBDBF}, {0x6210,0xC0AE}, {0x6211,0xB2E6}, {0x6212,0xB2FC}, {0x6213,0x3F28},
{0x6214,0xD8FD}, {0x6215,0x3F29}, {0x6216,0xB0BF}, {0x621A,0xC0CC}, {0x621B,0xD8FE},
{0x621C,0x3F2A}, {0x621D,0xECC3}, {0x621E,0xD9A1}, {0x621F,0xB7E1}, {0x6220,0x3F2B},
{0x6221,0xD9A2}, {0x6222,0x3F2C}, {0x6223,0x3F2D}, {0x6226,0xC0EF}, {0x6227,0x3F2E},
{0x6229,0x3F2F}, {0x622A,0xD9A3}, {0x622B,0x3F30}, {0x622E,0xD9A4}, {0x622F,0xB5BA},
{0x6230,0xD9A5}, {0x6232,0xD9A6}, {0x6233,0xD9A7}, {0x6234,0xC2D7}, {0x6238,0xB8CD},
{0x6239,0x3F31}, {0x623B,0xCCE1}, {0x623D,0x3F32}, {0x623F,0xCBBC}, {0x6240,0xBDEA},
{0x6241,0xD9A8}, {0x6242,0x3F33}, {0x6243,0x3F34}, {0x6244,0x3F35}, {0x6246,0x3F36},
{0x6247,0xC0F0}, {0x6248,0xEEBD}, {0x6249,0xC8E2}, {0x624B,0xBCEA}, {0x624C,0x3F37},
{0x624D,0xBACD}, {0x624E,0xD9A9}, {0x6250,0x3F38}, {0x6251,0x3F39}, {0x6252,0x3F3A},
{0x6253,0xC2C7}, {0x6254,0x3F3B}, {0x6255,0xCAA7}, {0x6256,0x3F3C}, {0x6258,0xC2F1},
{0x625A,0x3F3D}, {0x625B,0xD9AC}, {0x625C,0x3F3E}, {0x625E,0xD9AA}, {0x6260,0xD9AD},
{0x6263,0xD9AB}, {0x6264,0x3F3F}, {0x6268,0xD9AE}, {0x626D,0x3F40}, {0x626E,0xCAB1},
{0x626F,0x3F41}, {0x6271,0xB0B7}, {0x6273,0x3F42}, {0x6276,0xC9DE}, {0x6279,0xC8E3},
{0x627A,0x3F43}, {0x627C,0xD9AF}, {0x627D,0x3F44}, {0x627E,0xD9B2}, {0x627F,0xBEB5},
{0x6280,0xB5BB}, {0x6282,0xD9B0}, {0x6283,0xD9B7}, {0x6284,0xBEB6}, {0x6289,0xD9B1},
{0x628A,0xC7C4}, {0x628D,0x3F45}, {0x628E,0x3F46}, {0x628F,0x3F47}, {0x6290,0x3F48},
{0x6291,0xCDDE}, {0x6292,0xD9B3}, {0x6293,0xD9B4}, {0x6294,0xD9B8}, {0x6295,0xC5EA},
{0x6296,0xD9B5}, {0x6297,0xB9B3}, {0x6298,0xC0DE}, {0x629B,0xD9C6}, {0x629C,0xC8B4},
// {0x62A6,0xFAAE}, alternative
{0x629E,0xC2F2}, {0x62A6,0x3F49}, {0x62A8,0x3F4A}, {0x62AB,0xC8E4}, {0x62AC,0xDAAD},
{0x62B1,0xCAFA}, {0x62B3,0x3F4B}, {0x62B5,0xC4F1}, {0x62B6,0x3F4C}, {0x62B7,0x3F4D},
{0x62B9,0xCBF5}, {0x62BA,0x3F4E}, {0x62BB,0xD9BB}, {0x62BC,0xB2A1}, {0x62BD,0xC3EA},
{0x62BE,0x3F4F}, {0x62BF,0x3F50}, {0x62C2,0xD9C4}, {0x62C4,0x3F51}, {0x62C5,0xC3B4},
{0x62C6,0xD9BE}, {0x62C7,0xD9C5}, {0x62C8,0xD9C0}, {0x62C9,0xD9C7}, {0x62CA,0xD9C3},
{0x62CC,0xD9C2}, {0x62CD,0xC7EF}, {0x62CE,0x3F52}, {0x62CF,0xD9BC}, {0x62D0,0xB2FD},
{0x62D1,0xD9BA}, {0x62D2,0xB5F1}, {0x62D3,0xC2F3}, {0x62D4,0xD9B6}, {0x62D5,0x3F53},
{0x62D6,0x3F54}, {0x62D7,0xD9B9}, {0x62D8,0xB9B4}, {0x62D9,0xC0DB}, {0x62DA,0x3F55},
{0x62DB,0xBEB7}, {0x62DC,0xD9C1}, {0x62DD,0xC7D2}, {0x62E0,0xB5F2}, {0x62E1,0xB3C8},
{0x62EA,0x3F56}, {0x62EC,0xB3E7}, {0x62ED,0xBFA1}, {0x62EE,0xD9C9}, {0x62EF,0xD9CE},
{0x62F1,0xD9CA}, {0x62F2,0x3F57}, {0x62F3,0xB7FD}, {0x62F4,0x3F58}, {0x62F5,0xD9CF},
{0x62F6,0xBBA2}, {0x62F7,0xB9E9}, {0x62FC,0x3F59}, {0x62FD,0x3F5A}, {0x62FE,0xBDA6},
{0x62FF,0xD9BD}, {0x6301,0xBBFD}, {0x6302,0xD9CC}, {0x6303,0x3F5B}, {0x6304,0x3F5C},
{0x6307,0xBBD8}, {0x6308,0xD9CD}, {0x6309,0xB0C4}, {0x630A,0x3F5D}, {0x630B,0x3F5E},
{0x630C,0xD9C8}, {0x630D,0x3F5F}, {0x6310,0x3F60}, {0x6311,0xC4A9}, {0x6313,0x3F61},
{0x6316,0x3F62}, {0x6318,0x3F63}, {0x6319,0xB5F3}, {0x631F,0xB6B4}, {0x6327,0xD9CB},
{0x6328,0xB0A7}, {0x6329,0x3F64}, {0x632A,0x3F65}, {0x632B,0xBAC3}, {0x632D,0x3F66},
{0x632F,0xBFB6}, {0x6335,0x3F67}, {0x6336,0x3F68}, {0x6339,0x3F69}, {0x633A,0xC4F2},
{0x633C,0x3F6A}, {0x633D,0xC8D4}, {0x633E,0xD9D1}, {0x633F,0xC1DE}, {0x6341,0x3F6B},
{0x6342,0x3F6C}, {0x6343,0x3F6D}, {0x6344,0x3F6E}, {0x6346,0x3F6F}, {0x6349,0xC2AA},
{0x634A,0x3F70}, {0x634B,0x3F71}, {0x634C,0xBBAB}, {0x634D,0xD9D2}, {0x634E,0x3F72},
{0x634F,0xD9D4}, {0x6350,0xD9D0}, {0x6352,0x3F73}, {0x6353,0x3F74}, {0x6354,0x3F75},
{0x6355,0xCAE1}, {0x6357,0xC4BD}, {0x6358,0x3F76}, {0x635B,0x3F77}, {0x635C,0xC1DC},
{0x6365,0x3F78}, {0x6366,0x3F79}, {0x6367,0xCAFB}, {0x6368,0xBCCE}, {0x6369,0xD9E0},
{0x636B,0xD9DF}, {0x636C,0x3F7A}, {0x636D,0x3F7B}, {0x636E,0xBFF8}, {0x6371,0x3F7C},
{0x6372,0xB7FE}, {0x6374,0x3F7D}, {0x6375,0x3F7E}, {0x6376,0xD9D9}, {0x6377,0xBEB9},
{0x6378,0x4021}, {0x637A,0xC6E8}, {0x637B,0xC7B1}, {0x637C,0x4022}, {0x637D,0x4023},
{0x637F,0x4024}, {0x6380,0xD9D7}, {0x6382,0x4025}, {0x6383,0xC1DD}, {0x6384,0x4026},
{0x6387,0x4027}, {0x6388,0xBCF8}, {0x6389,0xD9DC}, {0x638A,0x4028}, {0x638C,0xBEB8},
{0x638E,0xD9D6}, {0x638F,0xD9DB}, {0x6390,0x4029}, {0x6392,0xC7D3}, {0x6394,0x402A},
{0x6395,0x402B}, {0x6396,0xD9D5}, {0x6398,0xB7A1}, {0x6399,0x402C}, {0x639A,0x402D},
{0x639B,0xB3DD}, {0x639E,0x402E}, {0x639F,0xD9DD}, {0x63A0,0xCEAB}, {0x63A1,0xBACE},
{0x63A2,0xC3B5}, {0x63A3,0xD9DA}, {0x63A4,0x402F}, {0x63A5,0xC0DC}, {0x63A6,0x4030},
{0x63A7,0xB9B5}, {0x63A8,0xBFE4}, {0x63A9,0xB1E6}, {0x63AA,0xC1BC}, {0x63AB,0xD9D8},
{0x63AC,0xB5C5}, {0x63AD,0x4031}, {0x63AE,0x4032}, {0x63AF,0x4033}, {0x63B2,0xB7C7},
{0x63B4,0xC4CF}, {0x63B5,0xD9DE}, {0x63BB,0xC1DF}, {0x63BD,0x4034}, {0x63BE,0xD9E1},
{0x63C0,0xD9E3}, {0x63C1,0x4035}, {0x63C3,0xC2B7}, {0x63C4,0xD9E9}, {0x63C5,0x4036},
{0x63C6,0xD9E4}, {0x63C8,0x4037}, {0x63C9,0xD9E6}, {0x63CE,0x4038}, {0x63CF,0xC9C1},
{0x63D0,0xC4F3}, {0x63D1,0x4039}, {0x63D2,0xD9E7}, {0x63D3,0x403A}, {0x63D4,0x403B},
{0x63D5,0x403C}, {0x63D6,0xCDAC}, {0x63DA,0xCDC8}, {0x63DB,0xB4B9}, {0x63DC,0x403D},
{0x63E0,0x403E}, {0x63E1,0xB0AE}, {0x63E3,0xD9E5}, {0x63E5,0x403F}, {0x63E9,0xD9E2},
{0x63EA,0x4040}, {0x63EC,0x4041}, {0x63EE,0xB4F8}, {0x63F2,0x4042}, {0x63F3,0x4043},
// {0x63F5,0xFAAF}, alternative
{0x63F4,0xB1E7}, {0x63F5,0x4044}, {0x63F6,0xD9E8}, {0x63F8,0x4045}, {0x63F9,0x4046},
{0x63FA,0xCDC9}, {0x6406,0xD9EC}, {0x6409,0x4047}, {0x640A,0x4048}, {0x640D,0xC2BB},
{0x640F,0xD9F3}, {0x6410,0x4049}, {0x6412,0x404A}, {0x6413,0xD9ED}, {0x6414,0x404B},
{0x6416,0xD9EA}, {0x6417,0xD9F1}, {0x6418,0x404C}, {0x641C,0xD9D3}, {0x641E,0x404D},
{0x6420,0x404E}, {0x6422,0x404F}, {0x6424,0x4050}, {0x6425,0x4051}, {0x6426,0xD9EE},
{0x6428,0xD9F2}, {0x6429,0x4052}, {0x642A,0x4053}, {0x642C,0xC8C2}, {0x642D,0xC5EB},
{0x642F,0x4054}, {0x6430,0x4055}, {0x6434,0xD9EB}, {0x6435,0x4056}, {0x6436,0xD9EF},
{0x643A,0xB7C8}, {0x643D,0x4057}, {0x643E,0xBAF1}, {0x643F,0x4058}, {0x6442,0xC0DD},
{0x644B,0x4059}, {0x644E,0xD9F7}, {0x644F,0x405A}, {0x6451,0x405B}, {0x6452,0x405C},
{0x6453,0x405D}, {0x6454,0x405E}, {0x6458,0xC5A6}, {0x645A,0x405F}, {0x645B,0x4060},
// {0x6460,0xFAB0}, alternative
{0x645C,0x4061}, {0x645D,0x4062}, {0x645F,0x4063}, {0x6460,0x4064}, {0x6461,0x4065},
{0x6463,0x4066}, {0x6467,0xD9F4}, {0x6469,0xCBE0}, {0x646D,0x4067}, {0x646F,0xD9F5},
{0x6473,0x4068}, {0x6474,0x4069}, {0x6476,0xD9F6}, {0x6478,0xCCCE}, {0x647A,0xC0A2},
{0x647B,0x406A}, {0x647D,0x406B}, {0x6483,0xB7E2}, {0x6485,0x406C}, {0x6487,0x406D},
{0x6488,0xD9FD}, {0x648F,0x406E}, {0x6490,0x406F}, {0x6491,0x4070}, {0x6492,0xBBB5},
{0x6493,0xD9FA}, {0x6495,0xD9F9}, {0x6498,0x4071}, {0x6499,0x4072}, {0x649A,0xC7B2},
// {0x649D,0xFAB1}, alternative
{0x649B,0x4073}, {0x649D,0x4074}, {0x649E,0xC6B5}, {0x649F,0x4075}, {0x64A1,0x4076},
{0x64A3,0x4077}, {0x64A4,0xC5B1}, {0x64A5,0xD9FB}, {0x64A6,0x4078}, {0x64A8,0x4079},
{0x64A9,0xD9FC}, {0x64AB,0xC9EF}, {0x64AC,0x407A}, {0x64AD,0xC7C5}, {0x64AE,0xBBA3},
{0x64B0,0xC0F1}, {0x64B2,0xCBD0}, {0x64B3,0x407B}, {0x64B9,0xB3C9}, {0x64BB,0xDAA5},
{0x64BC,0xD9FE}, {0x64BD,0x407C}, {0x64BE,0x407D}, {0x64BF,0x407E}, {0x64C1,0xCDCA},
{0x64C2,0xDAA7}, {0x64C4,0x4121}, {0x64C5,0xDAA3}, {0x64C7,0xDAA4}, {0x64C9,0x4122},
// {0x64CE,0xFAB2}, alternative
{0x64CA,0x4123}, {0x64CB,0x4124}, {0x64CC,0x4125}, {0x64CD,0xC1E0}, {0x64CE,0x4126},
{0x64D0,0x4127}, {0x64D1,0x4128}, {0x64D2,0xDAA2}, {0x64D4,0xD9BF}, {0x64D5,0x4129},
{0x64D7,0x412A}, {0x64D8,0xDAA6}, {0x64DA,0xDAA1}, {0x64E0,0xDAAB}, {0x64E1,0xDAAC},
{0x64E2,0xC5A7}, {0x64E3,0xDAAE}, {0x64E4,0x412B}, {0x64E5,0x412C}, {0x64E6,0xBBA4},
{0x64E7,0xDAA9}, {0x64E9,0x412D}, {0x64EA,0x412E}, {0x64EC,0xB5BC}, {0x64ED,0x412F},
{0x64EF,0xDAAF}, {0x64F0,0x4130}, {0x64F1,0xDAA8}, {0x64F2,0xDAB3}, {0x64F4,0xDAB2},
{0x64F5,0x4131}, {0x64F6,0xDAB1}, {0x64F7,0x4132}, {0x64FA,0xDAB4}, {0x64FB,0x4133},
{0x64FD,0xDAB6}, {0x64FE,0xBEF1}, {0x64FF,0x4134}, {0x6500,0xDAB5}, {0x6501,0x4135},
{0x6504,0x4136}, {0x6505,0xDAB9}, {0x6508,0x4137}, {0x6509,0x4138}, {0x650A,0x4139},
{0x650F,0x413A}, {0x6513,0x413B}, {0x6514,0x413C}, {0x6516,0x413D}, {0x6518,0xDAB7},
{0x6519,0x413E}, {0x651B,0x413F}, {0x651C,0xDAB8}, {0x651D,0xD9F0}, {0x651E,0x4140},
{0x651F,0x4141}, {0x6522,0x4142}, {0x6523,0xDABB}, {0x6524,0xDABA}, {0x6526,0x4143},
{0x6529,0x4144}, {0x652A,0xD9F8}, {0x652B,0xDABC}, {0x652C,0xDAB0}, {0x652E,0x4145},
{0x652F,0xBBD9}, {0x6531,0x4146}, {0x6534,0xDABD}, {0x6535,0xDABE}, {0x6536,0xDAC0},
{0x6537,0xDABF}, {0x6538,0xDAC1}, {0x6539,0xB2FE}, {0x653A,0x4147}, {0x653B,0xB9B6},
{0x653C,0x4148}, {0x653D,0x4149}, {0x653E,0xCAFC}, {0x653F,0xC0AF}, {0x6543,0x414A},
{0x6545,0xB8CE}, {0x6547,0x414B}, {0x6548,0xDAC3}, {0x6549,0x414C}, {0x654D,0xDAC6},
{0x654E,0x7441},
{0x654F,0xC9D2}, {0x6550,0x414D}, {0x6551,0xB5DF}, {0x6552,0x414E}, {0x6554,0x414F},
{0x6555,0xDAC5}, {0x6556,0xDAC4}, {0x6557,0xC7D4}, {0x6558,0xDAC7}, {0x6559,0xB6B5},
{0x655D,0xDAC9}, {0x655E,0xDAC8}, {0x655F,0x4150}, {0x6560,0x4151}, {0x6562,0xB4BA},
{0x6563,0xBBB6}, {0x6566,0xC6D8}, {0x6567,0x4152}, {0x656B,0x4153}, {0x656C,0xB7C9},
{0x6570,0xBFF4}, {0x6572,0xDACA}, {0x6574,0xC0B0}, {0x6575,0xC5A8}, {0x6577,0xC9DF},
{0x6578,0xDACB}, {0x657A,0x4154}, {0x657D,0x4155}, {0x6581,0x4156}, {0x6582,0xDACC},
{0x6583,0xDACD}, {0x6585,0x4157}, {0x6587,0xCAB8}, {0x6588,0xD5DD}, {0x6589,0xC0C6},
{0x658A,0x4158}, {0x658C,0xC9CC}, {0x658E,0xBAD8}, {0x6590,0xC8E5}, {0x6591,0xC8C3},
{0x6592,0x4159}, {0x6595,0x415A}, {0x6597,0xC5CD}, {0x6598,0x415B}, {0x6599,0xCEC1},
{0x659B,0xDACF}, {0x659C,0xBCD0}, {0x659D,0x415C}, {0x659F,0xDAD0}, {0x65A0,0x415D},
{0x65A1,0xB0B6}, {0x65A3,0x415E}, {0x65A4,0xB6D4}, {0x65A5,0xC0CD}, {0x65A6,0x415F},
{0x65A7,0xC9E0}, {0x65AB,0xDAD1}, {0x65AC,0xBBC2}, {0x65AD,0xC3C7}, {0x65AE,0x4160},
{0x65AF,0xBBDB}, {0x65B0,0xBFB7}, {0x65B2,0x4161}, {0x65B3,0x4162}, {0x65B4,0x4163},
{0x65B7,0xDAD2}, {0x65B9,0xCAFD}, {0x65BC,0xB1F7}, {0x65BD,0xBBDC}, {0x65BF,0x4164},
{0x65C1,0xDAD5}, {0x65C2,0x4165}, {0x65C3,0xDAD3}, {0x65C4,0xDAD6}, {0x65C5,0xCEB9},
{0x65C6,0xDAD4}, {0x65C8,0x4166}, {0x65C9,0x4167}, {0x65CB,0xC0FB}, {0x65CC,0xDAD7},
{0x65CE,0x4168}, {0x65CF,0xC2B2}, {0x65D0,0x4169}, {0x65D2,0xDAD8}, {0x65D4,0x416A},
{0x65D6,0x416B}, {0x65D7,0xB4FA}, {0x65D8,0x416C}, {0x65D9,0xDADA}, {0x65DB,0xDAD9},
{0x65DF,0x416D}, {0x65E0,0xDADB}, {0x65E1,0xDADC}, {0x65E2,0xB4FB}, {0x65E5,0xC6FC},
{0x65E6,0xC3B6}, {0x65E7,0xB5EC}, {0x65E8,0xBBDD}, {0x65E9,0xC1E1}, {0x65EC,0xBDDC},
{0x65ED,0xB0B0}, {0x65F0,0x416E}, {0x65F1,0xDADD}, {0x65F2,0x416F}, {0x65F4,0x4170},
{0x65F5,0x4171}, {0x65F9,0x4172}, {0x65FA,0xB2A2}, {0x65FB,0xDAE1}, {0x65FE,0x4173},
// {0x6600,0xFAB4}, alternative
{0x65FF,0x4174}, {0x6600,0x4175}, {0x6602,0xB9B7}, {0x6603,0xDAE0}, {0x6604,0x4176},
// {0x6609,0xFAB7}, alternative
{0x6606,0xBAAB}, {0x6607,0xBEBA}, {0x6608,0x4177}, {0x6609,0x4178}, {0x660A,0xDADF},
{0x660C,0xBEBB}, {0x660D,0x4179}, {0x660E,0xCCC0}, {0x660F,0xBAAA}, {0x6611,0x417A},
// {0x6615,0xFAB5}, alternative
{0x6612,0x417B}, {0x6613,0xB0D7}, {0x6614,0xC0CE}, {0x6615,0x417C}, {0x6616,0x417D},
// {0x661E,0xFAB9}, alternative
{0x661C,0xDAE6}, {0x661D,0x417E}, {0x661E,0x4221}, {0x661F,0xC0B1}, {0x6620,0xB1C7},
// {0x6624,0xFABA}, alternative
{0x6621,0x4222}, {0x6622,0x4223}, {0x6623,0x4224}, {0x6624,0x4225}, {0x6625,0xBDD5},
{0x6626,0x4226}, {0x6627,0xCBE6}, {0x6628,0xBAF2}, {0x6629,0x4227}, {0x662A,0x4228},
// {0x662E,0xFAB8}, alternative
{0x662B,0x4229}, {0x662C,0x422A}, {0x662D,0xBEBC}, {0x662E,0x422B}, {0x662F,0xC0A7},
// {0x6631,0xF9A8}, alternative
{0x6630,0x422C}, {0x6631,0x422D}, {0x6633,0x422E}, {0x6634,0xDAE5}, {0x6635,0xDAE3},
{0x6636,0xDAE4}, {0x6637,0x4230}, {0x6639,0x422F},
{0x663B,0x7442},
{0x663C,0xC3EB}, {0x663F,0xDBA6},
{0x6640,0x4231}, {0x6641,0xDAEA}, {0x6642,0xBBFE}, {0x6643,0xB9B8}, {0x6644,0xDAE8},
{0x6645,0x4232}, {0x6646,0x4233}, {0x6649,0xDAE9}, {0x664A,0x4234}, {0x664B,0xBFB8},
{0x664C,0x4235}, {0x664E,0x4237}, {0x664F,0xDAE7}, {0x6651,0x4236}, {0x6652,0xBBAF},
// {0x6657,0xFABC}, alternative
// {0x6659,0xFABD}, alternative
{0x6657,0x4238}, {0x6658,0x4239}, {0x6659,0x423A}, {0x665B,0x423B}, {0x665C,0x423C},
{0x665D,0xDAEC}, {0x665E,0xDAEB}, {0x665F,0xDAF0}, {0x6660,0x423D}, {0x6661,0x423E},
{0x6662,0xDAF1}, {0x6664,0xDAED},
{0x6665,0x7443},
{0x6666,0xB3A2}, {0x6667,0xDAEE}, {0x6668,0xDAEF},
{0x6669,0xC8D5}, {0x666A,0x4240}, {0x666B,0x4241}, {0x666C,0x4242}, {0x666E,0xC9E1},
// {0x6673,0xFABF}, alternative
{0x666F,0xB7CA}, {0x6670,0xDAF2}, {0x6673,0x4244}, {0x6674,0xC0B2}, {0x6675,0x4245},
{0x6676,0xBEBD}, {0x6677,0x4247}, {0x6678,0x4248}, {0x6679,0x4249}, {0x667A,0xC3D2},
{0x667B,0x424A}, {0x667C,0x424C}, {0x667E,0x4243}, {0x667F,0x4246}, {0x6680,0x424B},
{0x6681,0xB6C7}, {0x6683,0xDAF3}, {0x6684,0xDAF7}, {0x6687,0xB2CB}, {0x6688,0xDAF4},
{0x6689,0xDAF6}, {0x668B,0x424D}, {0x668C,0x424E}, {0x668D,0x424F}, {0x668E,0xDAF5},
{0x6690,0x4250}, {0x6691,0xBDEB}, {0x6692,0x4251}, {0x6696,0xC3C8}, {0x6697,0xB0C5},
// {0x6699,0xFAC0}, alternative
{0x6698,0xDAF8}, {0x6699,0x4252}, {0x669A,0x4253}, {0x669B,0x4254}, {0x669C,0x4255},
// {0x66A0,0xFAC1}, alternative
{0x669D,0xDAF9}, {0x669F,0x4256}, {0x66A0,0x4257}, {0x66A2,0xC4AA}, {0x66A4,0x4258},
{0x66A6,0xCEF1}, {0x66AB,0xBBC3}, {0x66AD,0x4259}, {0x66AE,0xCAEB}, {0x66B1,0x425A},
// {0x66B2,0xFAC2}, alternative
{0x66B2,0x425B}, {0x66B4,0xCBBD}, {0x66B5,0x425C}, {0x66B8,0xDBA2}, {0x66B9,0xDAFB},
// {0x66BF,0xFAC3}, alternative
{0x66BB,0x425D}, {0x66BC,0xDAFE}, {0x66BE,0xDAFD}, {0x66BF,0x425E}, {0x66C0,0x425F},
{0x66C1,0xDAFA}, {0x66C2,0x4260}, {0x66C3,0x4261}, {0x66C4,0xDBA1}, {0x66C7,0xC6DE},
{0x66C8,0x4262}, {0x66C9,0xDAFC}, {0x66CC,0x4263}, {0x66CE,0x4264}, {0x66CF,0x4265},
{0x66D4,0x4266}, {0x66D6,0xDBA3}, {0x66D9,0xBDEC}, {0x66DA,0xDBA4}, {0x66DB,0x4267},
{0x66DC,0xCDCB}, {0x66DD,0xC7F8}, {0x66DF,0x4268}, {0x66E0,0xDBA5}, {0x66E6,0xDBA7},
{0x66E8,0x4269}, {0x66E9,0xDBA8}, {0x66EB,0x426A}, {0x66EC,0x426B}, {0x66EE,0x426C},
{0x66F0,0xDBA9}, {0x66F2,0xB6CA}, {0x66F3,0xB1C8}, {0x66F4,0xB9B9}, {0x66F5,0xDBAA},
// {0x66FA,0xFAC4}, alternative
// {0x66FB,0xF9AB}, alternative
{0x66F7,0xDBAB}, {0x66F8,0xBDF1}, {0x66F9,0xC1E2}, {0x66FA,0x426D}, {0x66FB,0x423F},
{0x66FC,0xD2D8}, {0x66FD,0xC1BE}, {0x66FE,0xC1BD}, {0x66FF,0xC2D8}, {0x6700,0xBAC7},
{0x6703,0xD0F2}, {0x6705,0x426E}, {0x6707,0x426F}, {0x6708,0xB7EE}, {0x6709,0xCDAD},
// {0x670E,0xFAC5}, alternative
{0x670B,0xCAFE}, {0x670D,0xC9FE}, {0x670E,0x4270}, {0x670F,0xDBAC}, {0x6713,0x4271},
{0x6714,0xBAF3}, {0x6715,0xC4BF}, {0x6716,0xDBAD}, {0x6717,0xCFAF}, {0x6719,0x4272},
{0x671B,0xCBBE}, {0x671C,0x4273}, {0x671D,0xC4AB}, {0x671E,0xDBAE}, {0x671F,0xB4FC},
{0x6720,0x4274}, {0x6722,0x4275}, {0x6726,0xDBAF}, {0x6727,0xDBB0}, {0x6728,0xCCDA},
{0x672A,0xCCA4}, {0x672B,0xCBF6}, {0x672C,0xCBDC}, {0x672D,0xBBA5}, {0x672E,0xDBB2},
{0x6731,0xBCEB}, {0x6733,0x4276}, {0x6734,0xCBD1}, {0x6736,0xDBB4}, {0x6737,0xDBB7},
{0x6738,0xDBB6}, {0x673A,0xB4F9}, {0x673D,0xB5E0}, {0x673E,0x4277}, {0x673F,0xDBB3},
{0x6741,0xDBB5}, {0x6745,0x4278}, {0x6746,0xDBB8}, {0x6747,0x4279}, {0x6748,0x427A},
{0x6749,0xBFF9}, {0x674C,0x427B}, {0x674E,0xCDFB}, {0x674F,0xB0C9}, {0x6750,0xBAE0},
{0x6751,0xC2BC}, {0x6753,0xBCDD}, {0x6754,0x427C}, {0x6755,0x427D}, {0x6756,0xBEF3},
{0x6759,0xDBBB}, {0x675C,0xC5CE}, {0x675D,0x427E}, {0x675E,0xDBB9}, {0x675F,0xC2AB},
{0x6760,0xDBBA}, {0x6761,0xBEF2}, {0x6762,0xCCDD}, {0x6763,0xDBBC}, {0x6764,0xDBBD},
// {0x6766,0xFAC7}, alternative
{0x6765,0xCDE8}, {0x6766,0x4321}, {0x676A,0xDBC2}, {0x676C,0x4322}, {0x676D,0xB9BA},
{0x676E,0x4323}, {0x676F,0xC7D5}, {0x6770,0xDBBF}, {0x6771,0xC5EC}, {0x6772,0xDADE},
{0x6773,0xDAE2}, {0x6774,0x4324}, {0x6775,0xB5CF}, {0x6776,0x4325}, {0x6777,0xC7C7},
{0x677B,0x4326}, {0x677C,0xDBC1}, {0x677E,0xBEBE}, {0x677F,0xC8C4}, {0x6781,0x4327},
{0x6784,0x4328}, {0x6785,0xDBC7}, {0x6787,0xC8FA}, {0x6789,0xDBBE}, {0x678B,0xDBC4},
{0x678C,0xDBC3}, {0x678E,0x4329}, {0x678F,0x432A}, {0x6790,0xC0CF}, {0x6791,0x432B},
{0x6793,0x432C}, {0x6795,0xCBED}, {0x6796,0x432D}, {0x6797,0xCED3}, {0x6798,0x432E},
{0x6799,0x432F}, {0x679A,0xCBE7}, {0x679B,0x4330}, {0x679C,0xB2CC}, {0x679D,0xBBDE},
{0x67A0,0xCFC8}, {0x67A1,0xDBC6}, {0x67A2,0xBFF5}, {0x67A6,0xDBC5}, {0x67A9,0xDBC0},
{0x67AF,0xB8CF}, {0x67B0,0x4331}, {0x67B1,0x4332}, {0x67B2,0x4333}, {0x67B3,0xDBCC},
{0x67B4,0xDBCA}, {0x67B5,0x4334}, {0x67B6,0xB2CD}, {0x67B7,0xDBC8}, {0x67B8,0xDBCE},
// {0x67BB,0xFAC8}, alternative
// {0x67C0,0xFACA}, alternative
{0x67B9,0xDBD4}, {0x67BB,0x4335}, {0x67BC,0x4336}, {0x67BD,0x4337}, {0x67C0,0x4339},
{0x67C1,0xC2C8}, {0x67C2,0x433A}, {0x67C3,0x433B}, {0x67C4,0xCAC1}, {0x67C5,0x433C},
{0x67C6,0xDBD6}, {0x67C8,0x433D}, {0x67C9,0x433E}, {0x67CA,0xC9A2}, {0x67CE,0xDBD5},
{0x67CF,0xC7F0}, {0x67D0,0xCBBF}, {0x67D1,0xB4BB}, {0x67D2,0x433F}, {0x67D3,0xC0F7},
{0x67D4,0xBDC0}, {0x67D7,0x4340}, {0x67D8,0xC4D3}, {0x67D9,0x4341}, {0x67DA,0xCDAE},
{0x67DC,0x4342}, {0x67DD,0xDBD1}, {0x67DE,0xDBD0}, {0x67E1,0x4343}, {0x67E2,0xDBD2},
{0x67E4,0xDBCF}, {0x67E6,0x4344}, {0x67E7,0xDBD7}, {0x67E9,0xDBCD}, {0x67EC,0xDBCB},
{0x67EE,0xDBD3}, {0x67EF,0xDBC9}, {0x67F0,0x4345}, {0x67F1,0xC3EC}, {0x67F2,0x4346},
{0x67F3,0xCCF8}, {0x67F4,0xBCC6}, {0x67F5,0xBAF4}, {0x67F6,0x4347}, {0x67F7,0x4348},
{0x67F9,0x4338}, {0x67FB,0xBABA}, {0x67FE,0xCBEF}, {0x67FF,0xB3C1},
{0x6801,0x7446},
{0x6802,0xC4CE},
{0x6803,0xC6CA}, {0x6804,0xB1C9}, {0x6813,0xC0F2}, {0x6814,0x434A}, {0x6816,0xC0B4},
{0x6817,0xB7AA}, {0x6819,0x434B}, {0x681D,0x434C}, {0x681E,0xDBD9}, {0x681F,0x434D},
{0x6821,0xB9BB}, {0x6822,0xB3FC}, {0x6827,0x434F}, {0x6828,0x434E}, {0x6829,0xDBDB},
{0x682A,0xB3F4}, {0x682B,0xDBE1}, {0x682C,0x4350}, {0x682D,0x4351}, {0x682F,0x4352},
{0x6830,0x4353}, {0x6831,0x4354}, {0x6832,0xDBDE}, {0x6833,0x4355}, {0x6834,0xC0F3},
{0x6838,0xB3CB}, {0x6839,0xBAAC}, {0x683B,0x4356}, {0x683C,0xB3CA}, {0x683D,0xBACF},
{0x683F,0x4357}, {0x6840,0xDBDC}, {0x6841,0xB7E5}, {0x6842,0xB7CB}, {0x6843,0xC5ED},
// {0x6844,0xFACC}, alternative
{0x6844,0x4358}, {0x6845,0x4359}, {0x6846,0xDBDA}, {0x6848,0xB0C6}, {0x684A,0x435A},
{0x684C,0x435B}, {0x684D,0xDBDD}, {0x684E,0xDBDF}, {0x6850,0xB6CD}, {0x6851,0xB7AC},
// {0x6852,0xFAC9}, alternative
{0x6852,0x4349}, {0x6853,0xB4BC}, {0x6854,0xB5CB}, {0x6855,0x435C}, {0x6857,0x435D},
{0x6858,0x435E}, {0x6859,0xDBE2}, {0x685B,0x435F}, {0x685C,0xBAF9}, {0x685D,0xCBF1},
{0x685F,0xBBB7}, {0x6863,0xDBE3}, {0x6867,0xC9B0}, {0x686B,0x4360}, {0x686E,0x4361},
{0x686F,0x4362}, {0x6870,0x4363}, {0x6871,0x4364}, {0x6872,0x4365}, {0x6874,0xDBEF},
{0x6875,0x4366}, {0x6876,0xB2B3}, {0x6877,0xDBE4}, {0x6879,0x4367}, {0x687A,0x4368},
{0x687B,0x4369}, {0x687C,0x436A}, {0x687E,0xDBF5}, {0x687F,0xDBE5}, {0x6881,0xCEC2},
{0x6882,0x436B}, {0x6883,0xDBEC}, {0x6884,0x436C}, {0x6885,0xC7DF}, {0x6886,0x436D},
{0x6888,0x436E}, {0x688D,0xDBF4}, {0x688F,0xDBE7}, {0x6893,0xB0B4}, {0x6894,0xDBE9},
{0x6896,0x436F}, {0x6897,0xB9BC}, {0x6898,0x4370}, {0x689A,0x4371}, {0x689B,0xDBEB},
{0x689C,0x4372}, {0x689D,0xDBEA}, {0x689F,0xDBE6}, {0x68A0,0xDBF1}, {0x68A1,0x4373},
{0x68A2,0xBEBF}, {0x68A3,0x4374}, {0x68A5,0x4375}, {0x68A6,0xD4ED}, {0x68A7,0xB8E8},
{0x68A8,0xCDFC}, {0x68A9,0x4376}, {0x68AA,0x4377}, {0x68AD,0xDBE8}, {0x68AE,0x4378},
{0x68AF,0xC4F4}, {0x68B0,0xB3A3}, {0x68B1,0xBAAD}, {0x68B2,0x4379}, {0x68B3,0xDBE0},
{0x68B5,0xDBF0}, {0x68B6,0xB3E1}, {0x68B9,0xDBEE}, {0x68BA,0xDBF2}, {0x68BB,0x437A},
// {0x68C8,0xF9A9}, alternative
{0x68BC,0xC5EE}, {0x68C4,0xB4FE}, {0x68C5,0x437B}, {0x68C6,0xDCB2}, {0x68C8,0x437C},
{0x68C9,0xCCC9}, {0x68CA,0xDBF7}, {0x68CB,0xB4FD}, {0x68CC,0x437D}, {0x68CD,0xDBFE},
// {0x68CF,0xFACD}, alternative
{0x68CF,0x437E}, {0x68D0,0x4421}, {0x68D1,0x4422}, {0x68D2,0xCBC0}, {0x68D3,0x4423},
{0x68D4,0xDCA1}, {0x68D5,0xDCA3}, {0x68D6,0x4424}, {0x68D7,0xDCA7}, {0x68D8,0xDBF9},
{0x68D9,0x4425}, {0x68DA,0xC3AA}, {0x68DC,0x4426}, {0x68DD,0x4427}, {0x68DF,0xC5EF},
{0x68E0,0xDCAB}, {0x68E1,0xDBFC}, {0x68E3,0xDCA8}, {0x68E5,0x4428}, {0x68E7,0xDCA2},
{0x68E8,0x4429}, {0x68EA,0x442A}, {0x68EB,0x442B}, {0x68EC,0x442C}, {0x68ED,0x442D},
{0x68EE,0xBFB9}, {0x68EF,0xDCAC}, {0x68F0,0x442E}, {0x68F1,0x442F}, {0x68F2,0xC0B3},
{0x68F5,0x4430}, {0x68F6,0x4431}, {0x68F9,0xDCAA}, {0x68FA,0xB4BD}, {0x68FB,0x4432},
{0x68FC,0x4433}, {0x68FD,0x4434}, {0x6900,0xCFD0}, {0x6901,0xDBF6}, {0x6904,0xDCA6},
{0x6905,0xB0D8}, {0x6906,0x4435}, {0x6908,0xDBF8}, {0x6909,0x4436}, {0x690A,0x4437},
{0x690B,0xCCBA}, {0x690C,0xDBFD}, {0x690D,0xBFA2}, {0x690E,0xC4C7}, {0x690F,0xDBF3},
{0x6910,0x4438}, {0x6911,0x4439}, {0x6912,0xDCA5}, {0x6913,0x443A}, {0x6916,0x443B},
{0x6917,0x443C}, {0x6919,0xBFFA}, {0x691A,0xDCAF}, {0x691B,0xB3F1}, {0x691C,0xB8A1},
{0x6921,0xDCB1}, {0x6922,0xDBFA}, {0x6923,0xDCB0}, {0x6925,0xDCA9}, {0x6926,0xDBFB},
{0x6928,0xDCAD}, {0x692A,0xDCAE}, {0x6930,0xDCBF}, {0x6931,0x443D}, {0x6933,0x443E},
{0x6934,0xC6CE}, {0x6935,0x443F}, {0x6936,0xDCA4}, {0x6938,0x4440}, {0x6939,0xDCBB},
{0x693B,0x4441}, {0x693D,0xDCBD}, {0x693F,0xC4D8}, {0x6942,0x4442}, {0x6945,0x4443},
{0x6949,0x4444}, {0x694A,0xCDCC}, {0x694E,0x4445}, {0x6953,0xC9F6}, {0x6954,0xDCB8},
{0x6955,0xC2CA}, {0x6957,0x4446}, {0x6959,0xDCBE}, {0x695A,0xC1BF}, {0x695B,0x4447},
{0x695C,0xDCB5}, {0x695D,0xDCC2}, {0x695E,0xDCC1}, {0x6960,0xC6EF}, {0x6961,0xDCC0},
{0x6962,0xC6EA}, {0x6963,0x4448}, {0x6964,0x4449}, {0x6965,0x444A}, {0x6966,0x444B},
// {0x6968,0xFACF}, alternative
{0x6968,0x444C}, {0x6969,0x444D}, {0x696A,0xDCC4}, {0x696B,0xDCB7}, {0x696C,0x444E},
{0x696D,0xB6C8}, {0x696E,0xDCBA}, {0x696F,0xBDDD}, {0x6970,0x444F}, {0x6971,0x4450},
{0x6972,0x4451}, {0x6973,0xC7E0}, {0x6974,0xDCBC}, {0x6975,0xB6CB}, {0x6977,0xDCB4},
{0x6978,0xDCB6}, {0x6979,0xDCB3}, {0x697A,0x4452}, {0x697B,0x4453}, {0x697C,0xCFB0},
{0x697D,0xB3DA}, {0x697E,0xDCB9}, {0x697F,0x4454}, {0x6980,0x4455}, {0x6981,0xDCC3},
{0x6982,0xB3B5}, {0x698A,0xBAE7}, {0x698D,0x4456}, {0x698E,0xB1DD}, {0x6991,0xDCD4},
// {0x6998,0xFAD1}, alternative
{0x6992,0x4457}, {0x6994,0xCFB1}, {0x6995,0xDCD7}, {0x6996,0x4458}, {0x6998,0x4459},
{0x699B,0xBFBA}, {0x699C,0xDCD6}, {0x69A0,0xDCD5}, {0x69A1,0x445A}, {0x69A5,0x445B},
{0x69A6,0x445C}, {0x69A7,0xDCD2}, {0x69A8,0x445D}, {0x69AB,0x445E}, {0x69AD,0x445F},
{0x69AE,0xDCC6}, {0x69AF,0x4460}, {0x69B1,0xDCE3}, {0x69B2,0xDCC5}, {0x69B4,0xDCD8},
{0x69B7,0x4461}, {0x69B8,0x4462}, {0x69BA,0x4463}, {0x69BB,0xDCD0}, {0x69BC,0x4464},
{0x69BE,0xDCCB}, {0x69BF,0xDCC8}, {0x69C1,0xDCC9}, {0x69C3,0xDCD1}, {0x69C5,0x4465},
{0x69C7,0xF4A2}, {0x69C8,0x4466}, {0x69CA,0xDCCE}, {0x69CB,0xB9BD}, {0x69CC,0xC4C8},
{0x69CD,0xC1E4}, {0x69CE,0xDCCC}, {0x69D0,0xDCC7}, {0x69D1,0x4467}, {0x69D3,0xDCCA},
{0x69D6,0x4468}, {0x69D7,0x4469}, {0x69D8,0xCDCD}, {0x69D9,0xCBEA}, {0x69DD,0xDCCF},
// {0x69E2,0xFAD2}, alternative
{0x69DE,0xDCD9}, {0x69E2,0x446A}, {0x69E5,0x446B}, {0x69E7,0xDCE1}, {0x69E8,0xDCDA},
{0x69EB,0xDCE7}, {0x69ED,0xDCE5}, {0x69EE,0x446C}, {0x69EF,0x446D}, {0x69F1,0x446E},
{0x69F2,0xDCE0}, {0x69F3,0x446F}, {0x69F5,0x4470}, {0x69F9,0xDCDF}, {0x69FB,0xC4D0},
{0x69FD,0xC1E5}, {0x69FE,0x4471}, {0x69FF,0xDCDD}, {0x6A00,0x4472}, {0x6A01,0x4473},
{0x6A02,0xDCDB}, {0x6A03,0x4474}, {0x6A05,0xDCE2}, {0x6A0A,0xDCE8}, {0x6A0B,0xC8F5},
{0x6A0C,0xDCEE}, {0x6A0F,0x4475}, {0x6A11,0x4476}, {0x6A12,0xDCE9}, {0x6A13,0xDCEC},
{0x6A14,0xDCE6}, {0x6A15,0x4477}, {0x6A17,0xC3F4}, {0x6A19,0xC9B8}, {0x6A1A,0x4478},
{0x6A1B,0xDCDC}, {0x6A1D,0x4479}, {0x6A1E,0xDCE4}, {0x6A1F,0xBEC0}, {0x6A20,0x447A},
{0x6A21,0xCCCF}, {0x6A22,0xDCF8}, {0x6A23,0xDCEB}, {0x6A24,0x447B}, {0x6A28,0x447C},
// {0x6A30,0xFAD3}, alternative
{0x6A29,0xB8A2}, {0x6A2A,0xB2A3}, {0x6A2B,0xB3DF}, {0x6A2E,0xDCD3}, {0x6A30,0x447D},
{0x6A32,0x447E}, {0x6A34,0x4521}, {0x6A35,0xBEC1}, {0x6A36,0xDCF0}, {0x6A37,0x4522},
{0x6A38,0xDCF7}, {0x6A39,0xBCF9}, {0x6A3A,0xB3F2}, {0x6A3B,0x4523}, {0x6A3D,0xC3AE},
// {0x6A46,0xFAD5}, alternative
{0x6A3E,0x4524}, {0x6A3F,0x4525}, {0x6A44,0xDCED}, {0x6A45,0x4526}, {0x6A46,0x4527},
{0x6A47,0xDCF2}, {0x6A48,0xDCF6}, {0x6A49,0x4528}, {0x6A4A,0x4529}, {0x6A4B,0xB6B6},
{0x6A4E,0x452A}, {0x6A50,0x452B}, {0x6A51,0x452C}, {0x6A52,0x452D}, {0x6A55,0x452E},
{0x6A56,0x452F}, {0x6A58,0xB5CC}, {0x6A59,0xDCF4}, {0x6A5B,0x4530}, {0x6A5F,0xB5A1},
{0x6A61,0xC6CB}, {0x6A62,0xDCF3}, {0x6A64,0x4531}, {0x6A66,0xDCF5}, {0x6A67,0x4532},
{0x6A6A,0x4533},
{0x6A6B,0x7449},
// {0x6A73,0xFAD6}, alternative
{0x6A71,0x4534}, {0x6A72,0xDCEF}, {0x6A73,0x4535}, {0x6A78,0xDCF1},
// {0x6A7E,0xFAD7}, alternative
{0x6A7E,0x4536}, {0x6A7F,0xB3E0}, {0x6A80,0xC3C9}, {0x6A81,0x4537}, {0x6A83,0x4538},
{0x6A84,0xDCFC}, {0x6A86,0x4539}, {0x6A87,0x453A}, {0x6A89,0x453B}, {0x6A8B,0x453C},
{0x6A8D,0xDCFA}, {0x6A8E,0xB8E9}, {0x6A90,0xDCF9}, {0x6A91,0x453D}, {0x6A97,0xDDA1},
{0x6A9B,0x453E}, {0x6A9C,0xDBD8}, {0x6A9D,0x453F}, {0x6A9E,0x4540}, {0x6A9F,0x4541},
{0x6AA0,0xDCFB}, {0x6AA2,0xDCFD}, {0x6AA3,0xDCFE}, {0x6AA5,0x4542}, {0x6AAA,0xDDAC},
{0x6AAB,0x4543}, {0x6AAC,0xDDA8}, {0x6AAE,0xDBED}, {0x6AAF,0x4544}, {0x6AB0,0x4545},
{0x6AB1,0x4546}, {0x6AB3,0xDDA7}, {0x6AB4,0x4547}, {0x6AB8,0xDDA6}, {0x6ABB,0xDDA3},
{0x6ABD,0x4548}, {0x6ABE,0x4549}, {0x6ABF,0x454A}, {0x6AC1,0xDCEA}, {0x6AC2,0xDDA5},
{0x6AC3,0xDDA4}, {0x6AC6,0x454B}, {0x6AC8,0x454D}, {0x6AC9,0x454C}, {0x6ACC,0x454E},
{0x6AD0,0x454F}, {0x6AD1,0xDDAA}, {0x6AD3,0xCFA6}, {0x6AD4,0x4550}, {0x6AD5,0x4551},
{0x6AD6,0x4552}, {0x6ADA,0xDDAD}, {0x6ADB,0xB6FB}, {0x6ADC,0x4553}, {0x6ADD,0x4554},
{0x6ADE,0xDDA9}, {0x6ADF,0xDDAB},
{0x6AE2,0x744a},
// {0x6AE4,0xFAD9}, alternative
{0x6AE4,0x4555}, {0x6AE7,0x4556}, {0x6AE8,0xC8A7},
{0x6AEA,0xDDAE}, {0x6AEC,0x4557}, {0x6AF0,0x4558}, {0x6AF1,0x4559}, {0x6AF2,0x455A},
{0x6AFA,0xDDB2}, {0x6AFB,0xDDAF}, {0x6AFC,0x455B}, {0x6AFD,0x455C}, {0x6B02,0x455D},
{0x6B03,0x455E}, {0x6B04,0xCDF3}, {0x6B05,0xDDB0}, {0x6B06,0x455F}, {0x6B07,0x4560},
{0x6B09,0x4561}, {0x6B0A,0xDCDE}, {0x6B0F,0x4562}, {0x6B10,0x4563}, {0x6B11,0x4564},
{0x6B12,0xDDB3}, {0x6B16,0xDDB4}, {0x6B17,0x4565}, {0x6B1B,0x4566}, {0x6B1D,0xB1B5},
{0x6B1E,0x4567}, {0x6B1F,0xDDB6}, {0x6B20,0xB7E7}, {0x6B21,0xBCA1}, {0x6B23,0xB6D5},
{0x6B24,0x4568}, {0x6B27,0xB2A4}, {0x6B28,0x4569}, {0x6B2B,0x456A}, {0x6B2C,0x456B},
{0x6B2F,0x456C}, {0x6B32,0xCDDF}, {0x6B35,0x456D}, {0x6B36,0x456E}, {0x6B37,0xDDB8},
{0x6B38,0xDDB7}, {0x6B39,0xDDBA}, {0x6B3A,0xB5BD}, {0x6B3B,0x456F}, {0x6B3D,0xB6D6},
{0x6B3E,0xB4BE}, {0x6B3F,0x4570}, {0x6B43,0xDDBD}, {0x6B46,0x4571}, {0x6B47,0xDDBC},
{0x6B49,0xDDBE}, {0x6B4A,0x4572}, {0x6B4C,0xB2CE}, {0x6B4D,0x4573}, {0x6B4E,0xC3B7},
{0x6B50,0xDDBF}, {0x6B52,0x4574}, {0x6B53,0xB4BF}, {0x6B54,0xDDC1}, {0x6B56,0x4575},
{0x6B58,0x4576}, {0x6B59,0xDDC0}, {0x6B5B,0xDDC2}, {0x6B5D,0x4577}, {0x6B5F,0xDDC3},
{0x6B60,0x4578}, {0x6B61,0xDDC4}, {0x6B62,0xBBDF}, {0x6B63,0xC0B5}, {0x6B64,0xBAA1},
{0x6B66,0xC9F0}, {0x6B67,0x4579}, {0x6B69,0xCAE2}, {0x6B6A,0xCFC4}, {0x6B6B,0x457A},
{0x6B6E,0x457B}, {0x6B6F,0xBBF5}, {0x6B70,0x457C}, {0x6B73,0xBAD0}, {0x6B74,0xCEF2},
{0x6B75,0x457D}, {0x6B78,0xDDC5}, {0x6B79,0xDDC6}, {0x6B7B,0xBBE0}, {0x6B7D,0x457E},
{0x6B7E,0x4621}, {0x6B7F,0xDDC7}, {0x6B80,0xDDC8}, {0x6B82,0x4622}, {0x6B83,0xDDCA},
{0x6B84,0xDDC9}, {0x6B85,0x4623}, {0x6B86,0xCBD8}, {0x6B89,0xBDDE}, {0x6B8A,0xBCEC},
{0x6B8B,0xBBC4}, {0x6B8D,0xDDCB}, {0x6B95,0xDDCD}, {0x6B96,0xBFA3}, {0x6B97,0x4624},
{0x6B98,0xDDCC}, {0x6B9B,0x4625}, {0x6B9E,0xDDCE}, {0x6B9F,0x4626}, {0x6BA0,0x4627},
{0x6BA2,0x4628}, {0x6BA3,0x4629}, {0x6BA4,0xDDCF}, {0x6BA8,0x462A}, {0x6BA9,0x462B},
{0x6BAA,0xDDD0}, {0x6BAB,0xDDD1}, {0x6BAC,0x462C}, {0x6BAD,0x462D}, {0x6BAE,0x462E},
{0x6BAF,0xDDD2}, {0x6BB0,0x462F}, {0x6BB1,0xDDD4}, {0x6BB2,0xDDD3}, {0x6BB3,0xDDD5},
{0x6BB4,0xB2A5}, {0x6BB5,0xC3CA}, {0x6BB7,0xDDD6}, {0x6BB8,0x4630}, {0x6BB9,0x4631},
{0x6BBA,0xBBA6}, {0x6BBB,0xB3CC}, {0x6BBC,0xDDD7}, {0x6BBD,0x4632}, {0x6BBE,0x4633},
{0x6BBF,0xC5C2}, {0x6BC0,0xD4CC}, {0x6BC3,0x4634}, {0x6BC4,0x4635}, {0x6BC5,0xB5A3},
{0x6BC6,0xDDD8}, {0x6BC9,0x4636}, {0x6BCB,0xDDD9}, {0x6BCC,0x4637}, {0x6BCD,0xCAEC},
// {0x6BD6,0xFADA}, alternative
{0x6BCE,0xCBE8}, {0x6BD2,0xC6C7}, {0x6BD3,0xDDDA}, {0x6BD4,0xC8E6}, {0x6BD6,0x4638},
{0x6BD8,0xC8FB}, {0x6BDA,0x4639}, {0x6BDB,0xCCD3}, {0x6BDF,0xDDDB}, {0x6BE1,0x463A},
{0x6BE3,0x463B}, {0x6BE6,0x463C}, {0x6BE7,0x463D}, {0x6BEB,0xDDDD}, {0x6BEC,0xDDDC},
{0x6BEE,0x463E}, {0x6BEF,0xDDDF}, {0x6BF1,0x463F}, {0x6BF3,0xDDDE}, {0x6BF7,0x4640},
{0x6BF9,0x4641}, {0x6BFF,0x4642}, {0x6C02,0x4643}, {0x6C04,0x4644}, {0x6C05,0x4645},
{0x6C08,0xDDE1}, {0x6C09,0x4646}, {0x6C0D,0x4647}, {0x6C0E,0x4648}, {0x6C0F,0xBBE1},
{0x6C10,0x4649}, {0x6C11,0xCCB1}, {0x6C12,0x464A}, {0x6C13,0xDDE2}, {0x6C14,0xDDE3},
{0x6C17,0xB5A4}, {0x6C19,0x464B}, {0x6C1B,0xDDE4}, {0x6C1F,0x464C}, {0x6C23,0xDDE6},
{0x6C24,0xDDE5}, {0x6C26,0x464D}, {0x6C27,0x464E}, {0x6C28,0x464F}, {0x6C2C,0x4650},
{0x6C2E,0x4651}, {0x6C33,0x4652}, {0x6C34,0xBFE5}, {0x6C35,0x4653}, {0x6C36,0x4654},
{0x6C37,0xC9B9}, {0x6C38,0xB1CA}, {0x6C3A,0x4655}, {0x6C3B,0x4656}, {0x6C3E,0xC8C5},
// {0x6C3F,0xFADB}, alternative
{0x6C3F,0x4657}, {0x6C40,0xC4F5}, {0x6C41,0xBDC1}, {0x6C42,0xB5E1}, {0x6C4A,0x4658},
{0x6C4B,0x4659}, {0x6C4D,0x465A}, {0x6C4E,0xC8C6}, {0x6C4F,0x465B}, {0x6C50,0xBCAE},
{0x6C52,0x465C}, {0x6C54,0x465D}, {0x6C55,0xDDE8}, {0x6C57,0xB4C0}, {0x6C59,0x465E},
// {0x6C5C,0xFADC}, alternative
{0x6C5A,0xB1F8}, {0x6C5B,0x465F}, {0x6C5C,0x4660}, {0x6C5D,0xC6F2}, {0x6C5E,0xDDE7},
{0x6C5F,0xB9BE}, {0x6C60,0xC3D3}, {0x6C62,0xDDE9}, {0x6C67,0x4736}, {0x6C68,0xDDF1},
// {0x6C6F,0xFADE}, alternative
{0x6C6A,0xDDEA}, {0x6C6B,0x4661}, {0x6C6D,0x4662}, {0x6C6F,0x4663}, {0x6C70,0xC2C1},
{0x6C72,0xB5E2}, {0x6C73,0xDDF2}, {0x6C74,0x4664}, {0x6C76,0x4665}, {0x6C78,0x4666},
{0x6C79,0x4667}, {0x6C7A,0xB7E8}, {0x6C7B,0x4668}, {0x6C7D,0xB5A5}, {0x6C7E,0xDDF0},
// {0x6C86,0xFADD}, alternative
{0x6C81,0xDDEE}, {0x6C82,0xDDEB}, {0x6C83,0xCDE0}, {0x6C85,0x4669}, {0x6C86,0x466A},
{0x6C87,0x466B}, {0x6C88,0xC4C0}, {0x6C89,0x466C}, {0x6C8C,0xC6D9}, {0x6C8D,0xDDEC},
{0x6C90,0xDDF4}, {0x6C92,0xDDF3}, {0x6C93,0xB7A3}, {0x6C94,0x466D}, {0x6C95,0x466E},
{0x6C96,0xB2AD}, {0x6C97,0x466F}, {0x6C98,0x4670}, {0x6C99,0xBABB}, {0x6C9A,0xDDED},
{0x6C9B,0xDDEF}, {0x6C9C,0x4671}, {0x6C9F,0x4672}, {0x6CA1,0xCBD7}, {0x6CA2,0xC2F4},
{0x6CAB,0xCBF7}, {0x6CAE,0xDDFC}, {0x6CB0,0x4673}, {0x6CB1,0xDDFD}, {0x6CB2,0x4674},
{0x6CB3,0xB2CF}, {0x6CB4,0x4675}, {0x6CB8,0xCAA8}, {0x6CB9,0xCCFD}, {0x6CBA,0xDEA1},
{0x6CBB,0xBCA3}, {0x6CBC,0xBEC2}, {0x6CBD,0xDDF8}, {0x6CBE,0xDDFE}, {0x6CBF,0xB1E8},
{0x6CC1,0xB6B7}, {0x6CC2,0x4676}, {0x6CC4,0xDDF5}, {0x6CC5,0xDDFA}, {0x6CC6,0x4677},
{0x6CC9,0xC0F4}, {0x6CCA,0xC7F1}, {0x6CCC,0xC8E7}, {0x6CCD,0x4678}, {0x6CCF,0x4679},
{0x6CD0,0x467A}, {0x6CD1,0x467B}, {0x6CD2,0x467C}, {0x6CD3,0xDDF7}, {0x6CD4,0x467D},
// {0x6CDA,0xFADF}, alternative
{0x6CD5,0xCBA1}, {0x6CD6,0x467E}, {0x6CD7,0xDDF9}, {0x6CD9,0xDEA4}, {0x6CDA,0x4721},
{0x6CDB,0xDEA2}, {0x6CDC,0x4722}, {0x6CDD,0xDDFB}, {0x6CE0,0x4723}, {0x6CE1,0xCBA2},
{0x6CE2,0xC7C8}, {0x6CE3,0xB5E3}, {0x6CE5,0xC5A5}, {0x6CE7,0x4724}, {0x6CE8,0xC3ED},
{0x6CE9,0x4725}, {0x6CEA,0xDEA5}, {0x6CEB,0x4726}, {0x6CEC,0x4727}, {0x6CEE,0x4728},
{0x6CEF,0xDEA3}, {0x6CF0,0xC2D9}, {0x6CF1,0xDDF6}, {0x6CF2,0x4729}, {0x6CF3,0xB1CB},
// {0x6D04,0xFAE0}, alternative
{0x6CF4,0x472A}, {0x6D04,0x472B}, {0x6D07,0x472C}, {0x6D0A,0x472D}, {0x6D0B,0xCDCE},
{0x6D0C,0xDEB0}, {0x6D0E,0x472E}, {0x6D0F,0x472F}, {0x6D11,0x4730}, {0x6D12,0xDEAF},
{0x6D13,0x4731}, {0x6D17,0xC0F6}, {0x6D19,0xDEAC}, {0x6D1A,0x4732}, {0x6D1B,0xCDEC},
{0x6D1E,0xC6B6}, {0x6D1F,0xDEA6}, {0x6D25,0xC4C5}, {0x6D26,0x4733}, {0x6D27,0x4734},
{0x6D28,0x4735}, {0x6D29,0xB1CC}, {0x6D2A,0xB9BF}, {0x6D2B,0xDEA9}, {0x6D2E,0x4737},
{0x6D2F,0x4738}, {0x6D31,0x4739}, {0x6D32,0xBDA7}, {0x6D33,0xDEAE}, {0x6D35,0xDEAD},
{0x6D36,0xDEA8}, {0x6D38,0xDEAB}, {0x6D39,0x473A}, {0x6D3B,0xB3E8}, {0x6D3C,0x473B},
{0x6D3D,0xDEAA}, {0x6D3E,0xC7C9}, {0x6D3F,0x473C}, {0x6D41,0xCEAE}, {0x6D44,0xBEF4},
{0x6D45,0xC0F5}, {0x6D57,0x473D}, {0x6D59,0xDEB6}, {0x6D5A,0xDEB4}, {0x6D5C,0xC9CD},
{0x6D5E,0x473E}, {0x6D5F,0x473F}, {0x6D61,0x4740}, {0x6D63,0xDEB1}, {0x6D64,0xDEB3},
{0x6D65,0x4741}, {0x6D66,0xB1BA}, {0x6D67,0x4742}, {0x6D69,0xB9C0}, {0x6D6A,0xCFB2},
// {0x6D6F,0xFAE2}, alternative
{0x6D6C,0xB3BD}, {0x6D6E,0xC9E2}, {0x6D6F,0x4743}, {0x6D70,0x4744}, {0x6D74,0xCDE1},
{0x6D77,0xB3A4}, {0x6D78,0xBFBB}, {0x6D79,0xDEB5}, {0x6D7C,0x4745}, {0x6D82,0x4746},
// {0x6D87,0xFAE1}, alternative
{0x6D85,0xDEBA}, {0x6D87,0x4747}, {0x6D88,0xBEC3}, {0x6D8C,0xCDB0}, {0x6D8E,0xDEB7},
{0x6D91,0x4748}, {0x6D92,0x4749}, {0x6D93,0xDEB2}, {0x6D94,0x474A}, {0x6D95,0xDEB8},
// {0x6D96,0xFAE3}, alternative
{0x6D96,0x474B}, {0x6D97,0x474C}, {0x6D98,0x474D}, {0x6D99,0xCEDE}, {0x6D9B,0xC5F3},
// {0x6DAC,0xFAE4}, alternative
{0x6D9C,0xC6C2}, {0x6DAA,0x474E}, {0x6DAC,0x474F}, {0x6DAF,0xB3B6}, {0x6DB2,0xB1D5},
{0x6DB4,0x4750}, {0x6DB5,0xDEBE}, {0x6DB7,0x4751}, {0x6DB8,0xDEC1}, {0x6DB9,0x4752},
{0x6DBC,0xCEC3}, {0x6DBD,0x4753}, {0x6DBF,0x4754}, {0x6DC0,0xCDE4}, {0x6DC4,0x4755},
{0x6DC5,0xDEC8}, {0x6DC6,0xDEC2}, {0x6DC7,0xDEBF}, {0x6DC8,0x4756}, {0x6DCA,0x4757},
// {0x6DCF,0xFAE5}, alternative
{0x6DCB,0xCED4}, {0x6DCC,0xDEC5}, {0x6DCE,0x4758}, {0x6DCF,0x4759}, {0x6DD1,0xBDCA},
{0x6DD2,0xDEC7}, {0x6DD5,0xDECC}, {0x6DD6,0x475A}, {0x6DD8,0xC5F1}, {0x6DD9,0xDECA},
{0x6DDB,0x475B}, {0x6DDD,0x475C}, {0x6DDE,0xDEC4}, {0x6DDF,0x475D}, {0x6DE0,0x475E},
{0x6DE1,0xC3B8}, {0x6DE2,0x475F}, {0x6DE4,0xDECB}, {0x6DE5,0x4760}, {0x6DE6,0xDEC0},
{0x6DE8,0xDEC6}, {0x6DE9,0x4761}, {0x6DEA,0xDECD}, {0x6DEB,0xB0FC}, {0x6DEC,0xDEC3},
{0x6DEE,0xDECE}, {0x6DEF,0x4762}, {0x6DF0,0x4763}, {0x6DF1,0xBFBC},
{0x6DF2,0x744c},
{0x6DF3,0xBDDF},
{0x6DF4,0x4764}, {0x6DF5,0xCAA5}, {0x6DF6,0x4765}, {0x6DF7,0xBAAE},
{0x6DF8,0x744b},
{0x6DF9,0xDEBB},
// {0x6DFC,0xFAE8}, alternative
{0x6DFA,0xDEC9}, {0x6DFB,0xC5BA}, {0x6DFC,0x4766}, {0x6E00,0x4767}, {0x6E04,0x4768},
{0x6E05,0xC0B6}, {0x6E07,0xB3E9}, {0x6E08,0xBAD1}, {0x6E09,0xBEC4}, {0x6E0A,0xDEBD},
{0x6E0B,0xBDC2}, {0x6E13,0xB7CC}, {0x6E15,0xDEBC}, {0x6E19,0xDED2}, {0x6E1A,0xBDED},
{0x6E1B,0xB8BA}, {0x6E1D,0xDEE1}, {0x6E1E,0x4769}, {0x6E1F,0xDEDB}, {0x6E20,0xB5F4},
{0x6E21,0xC5CF}, {0x6E22,0x476A}, {0x6E23,0xDED6}, {0x6E24,0xDEDF}, {0x6E25,0xB0AF},
// {0x6E27,0xFAEB}, alternative
{0x6E26,0xB1B2}, {0x6E27,0x476B}, {0x6E29,0xB2B9}, {0x6E2B,0xDED8}, {0x6E2C,0xC2AC},
{0x6E2D,0xDECF}, {0x6E2E,0xDED1}, {0x6E2F,0xB9C1}, {0x6E32,0x476C}, {0x6E36,0x476D},
// {0x6E39,0xFAE9}, alternative
// {0x6E3C,0xFAEC}, alternative
{0x6E38,0xDEE2}, {0x6E39,0x476E}, {0x6E3A,0xDEDD}, {0x6E3B,0x476F}, {0x6E3C,0x4770},
{0x6E3E,0xDED5}, {0x6E43,0xDEDC}, {0x6E44,0x4771}, {0x6E45,0x4772}, {0x6E48,0x4773},
{0x6E49,0x4774}, {0x6E4A,0xCCAB}, {0x6E4B,0x4775}, {0x6E4D,0xDEDA}, {0x6E4E,0xDEDE},
{0x6E4F,0x4776}, {0x6E51,0x4777}, {0x6E52,0x4778}, {0x6E53,0x4779}, {0x6E54,0x477A},
// {0x6E5C,0xFAEA}, alternative
{0x6E56,0xB8D0}, {0x6E57,0x477B}, {0x6E58,0xBEC5}, {0x6E5B,0xC3B9}, {0x6E5C,0x477C},
{0x6E5D,0x477D}, {0x6E5E,0x477E}, {0x6E5F,0xDED4}, {0x6E62,0x4821}, {0x6E63,0x4822},
{0x6E67,0xCDAF}, {0x6E68,0x4823}, {0x6E6B,0xDED7}, {0x6E6E,0xDED0}, {0x6E6F,0xC5F2},
{0x6E72,0xDED3}, {0x6E73,0x4824}, {0x6E76,0xDED9}, {0x6E7B,0x4825}, {0x6E7D,0x4826},
{0x6E7E,0xCFD1}, {0x6E7F,0xBCBE}, {0x6E80,0xCBFE}, {0x6E82,0xDEE3}, {0x6E8C,0xC8AE},
{0x6E8D,0x4827}, {0x6E8F,0xDEEF}, {0x6E90,0xB8BB}, {0x6E93,0x4828}, {0x6E96,0xBDE0},
{0x6E98,0xDEE5}, {0x6E99,0x4829}, {0x6E9C,0xCEAF}, {0x6E9D,0xB9C2}, {0x6E9F,0xDEF2},
{0x6EA0,0x482A}, {0x6EA2,0xB0EE}, {0x6EA5,0xDEF0}, {0x6EA7,0x482B}, {0x6EAA,0xDEE4},
{0x6EAD,0x482C}, {0x6EAE,0x482D}, {0x6EAF,0xDEEA}, {0x6EB1,0x482E}, {0x6EB2,0xDEEC},
{0x6EB3,0x482F}, {0x6EB6,0xCDCF}, {0x6EB7,0xDEE7}, {0x6EBA,0xC5AE}, {0x6EBB,0x4830},
// {0x6EBF,0xFAED}, alternative
{0x6EBD,0xDEE9}, {0x6EBF,0x4831}, {0x6EC0,0x4832}, {0x6EC1,0x4833}, {0x6EC2,0xDEF1},
{0x6EC3,0x4834}, {0x6EC4,0xDEEB}, {0x6EC5,0xCCC7}, {0x6EC7,0x4835}, {0x6EC8,0x4836},
{0x6EC9,0xDEE6}, {0x6ECA,0x4837}, {0x6ECB,0xBCA2}, {0x6ECC,0xDEFE}, {0x6ECD,0x4838},
{0x6ECE,0x4839}, {0x6ECF,0x483A}, {0x6ED1,0xB3EA}, {0x6ED3,0xDEE8}, {0x6ED4,0xDEED},
{0x6ED5,0xDEEE}, {0x6EDD,0xC2EC}, {0x6EDE,0xC2DA}, {0x6EEB,0x483B}, {0x6EEC,0xDEF6},
{0x6EED,0x483C}, {0x6EEE,0x483D}, {0x6EEF,0xDEFC}, {0x6EF2,0xDEFA}, {0x6EF4,0xC5A9},
{0x6EF7,0xDFA3}, {0x6EF8,0xDEF7}, {0x6EF9,0x483E}, {0x6EFB,0x483F}, {0x6EFD,0x4840},
{0x6EFE,0xDEF8}, {0x6EFF,0xDEE0}, {0x6F01,0xB5F9}, {0x6F02,0xC9BA}, {0x6F04,0x4841},
{0x6F06,0xBCBF}, {0x6F08,0x4842}, {0x6F09,0xB9F7}, {0x6F0A,0x4843}, {0x6F0C,0x4844},
{0x6F0D,0x4845}, {0x6F0F,0xCFB3}, {0x6F11,0xDEF4}, {0x6F13,0xDFA2}, {0x6F14,0xB1E9},
{0x6F15,0xC1E6}, {0x6F16,0x4846}, {0x6F18,0x4847}, {0x6F1A,0x4848}, {0x6F1B,0x4849},
{0x6F20,0xC7F9}, {0x6F22,0xB4C1}, {0x6F23,0xCEFA}, {0x6F26,0x484A}, {0x6F29,0x484B},
{0x6F2A,0x484C}, {0x6F2B,0xCCA1}, {0x6F2C,0xC4D2}, {0x6F2D,0x4853}, {0x6F2F,0x484D},
{0x6F30,0x484E}, {0x6F31,0xDEFB}, {0x6F32,0xDEFD}, {0x6F33,0x484F}, {0x6F36,0x4850},
{0x6F38,0xC1B2}, {0x6F3B,0x4851}, {0x6F3C,0x4852}, {0x6F3E,0xDFA1}, {0x6F3F,0xDEF9},
{0x6F41,0xDEF3}, {0x6F45,0xB4C3}, {0x6F4F,0x4854}, {0x6F51,0x4855}, {0x6F52,0x4856},
{0x6F53,0x4857}, {0x6F54,0xB7E9}, {0x6F57,0x4858}, {0x6F58,0xDFAF}, {0x6F59,0x4859},
{0x6F5A,0x485A}, {0x6F5B,0xDFAA}, {0x6F5C,0xC0F8}, {0x6F5D,0x485B}, {0x6F5E,0x485C},
{0x6F5F,0xB3E3}, {0x6F61,0x485D}, {0x6F62,0x485E}, {0x6F64,0xBDE1}, {0x6F66,0xDFB3},
{0x6F68,0x485F}, {0x6F6C,0x4860}, {0x6F6D,0xDFAC}, {0x6F6E,0xC4AC}, {0x6F6F,0xDFA9},
{0x6F70,0xC4D9}, {0x6F74,0xDFCC}, {0x6F78,0xDFA6}, {0x6F7A,0xDFA5}, {0x6F7C,0xDFAE},
{0x6F7D,0x4861}, {0x6F7E,0x4862}, {0x6F80,0xDFA8}, {0x6F81,0xDFA7}, {0x6F82,0xDFAD},
// {0x6F88,0xFAEE}, alternative
{0x6F83,0x4863}, {0x6F84,0xC0A1}, {0x6F86,0xDFA4}, {0x6F87,0x4864}, {0x6F88,0x4865},
{0x6F8B,0x4866}, {0x6F8C,0x4867}, {0x6F8D,0x4868}, {0x6F8E,0xDFB0}, {0x6F90,0x4869},
{0x6F91,0xDFB1}, {0x6F92,0x486A}, {0x6F93,0x486B}, {0x6F94,0x486C}, {0x6F96,0x486D},
{0x6F97,0xB4C2}, {0x6F9A,0x486E}, {0x6F9F,0x486F}, {0x6FA0,0x4870}, {0x6FA1,0xDFB6},
{0x6FA3,0xDFB5}, {0x6FA4,0xDFB7}, {0x6FA5,0x4871}, {0x6FA6,0x4872}, {0x6FA7,0x4873},
{0x6FA8,0x4874}, {0x6FAA,0xDFBA}, {0x6FAE,0x4875}, {0x6FAF,0x4876}, {0x6FB0,0x4877},
// {0x6FB5,0xFAEF}, alternative
{0x6FB1,0xC5C3}, {0x6FB3,0xDFB4}, {0x6FB5,0x4878}, {0x6FB6,0x4879}, {0x6FB9,0xDFB8},
{0x6FBC,0x487A}, {0x6FC0,0xB7E3}, {0x6FC1,0xC2F9}, {0x6FC2,0xDFB2}, {0x6FC3,0xC7BB},
{0x6FC5,0x487B}, {0x6FC6,0xDFB9}, {0x6FC7,0x487C}, {0x6FC8,0x487D}, {0x6FCA,0x487E},
{0x6FD4,0xDFBE}, {0x6FD5,0xDFBC}, {0x6FD8,0xDFBF}, {0x6FDA,0x4921}, {0x6FDB,0xDFC2},
{0x6FDE,0x4922}, {0x6FDF,0xDFBB}, {0x6FE0,0xB9EA}, {0x6FE1,0xC7A8}, {0x6FE4,0xDEB9},
{0x6FE8,0x4923}, {0x6FE9,0x4924}, {0x6FEB,0xCDF4}, {0x6FEC,0xDFBD}, {0x6FEE,0xDFC1},
// {0x6FF5,0xFAF0}, alternative
{0x6FEF,0xC2F5}, {0x6FF0,0x4925}, {0x6FF1,0xDFC0}, {0x6FF3,0xDFAB}, {0x6FF5,0x4926},
{0x6FF6,0xEFE9}, {0x6FF9,0x4927}, {0x6FFA,0xDFC5}, {0x6FFC,0x4928}, {0x6FFD,0x4929},
// {0x7005,0xFAF1}, alternative
{0x6FFE,0xDFC9}, {0x7000,0x492A}, {0x7001,0xDFC7}, {0x7005,0x492B}, {0x7006,0x492C},
// {0x7007,0xFAF2}, alternative
{0x7007,0x492D}, {0x7009,0xDFC3}, {0x700B,0xDFC4}, {0x700D,0x492E}, {0x700F,0xDFC8},
{0x7011,0xDFC6}, {0x7015,0xC9CE}, {0x7017,0x492F}, {0x7018,0xDFCE}, {0x701A,0xDFCB},
{0x701B,0xDFCA}, {0x701D,0xDFCD}, {0x701E,0xC6D4}, {0x701F,0xDFCF}, {0x7020,0x4930},
{0x7023,0x4931}, {0x7026,0xC3F5}, {0x7027,0xC2ED},
{0x7028,0x744d},
{0x702C,0xC0A5}, {0x702F,0x4932},
{0x7030,0xDFD0}, {0x7032,0xDFD2}, {0x7034,0x4933}, {0x7037,0x4934}, {0x7039,0x4935},
{0x703C,0x4936}, {0x703E,0xDFD1}, {0x7043,0x4937}, {0x7044,0x4938}, {0x7048,0x4939},
{0x7049,0x493A}, {0x704A,0x493B}, {0x704B,0x493C}, {0x704C,0xDEF5}, {0x704E,0x4941},
{0x7051,0xDFD3}, {0x7054,0x493D}, {0x7055,0x493E}, {0x7058,0xC6E7}, {0x705D,0x493F},
{0x705E,0x4940}, {0x7063,0xDFD4}, {0x7064,0x4942}, {0x7065,0x4943}, {0x706B,0xB2D0},
{0x706C,0x4944}, {0x706E,0x4945}, {0x706F,0xC5F4}, {0x7070,0xB3A5}, {0x7075,0x4946},
{0x7076,0x4947}, {0x7078,0xB5E4}, {0x707C,0xBCDE}, {0x707D,0xBAD2}, {0x707E,0x4948},
// {0x7085,0xFAF4}, alternative
{0x7081,0x4949}, {0x7085,0x494A}, {0x7086,0x494B}, {0x7089,0xCFA7}, {0x708A,0xBFE6},
{0x708E,0xB1EA}, {0x7092,0xDFD6}, {0x7094,0x494C}, {0x7095,0x494D}, {0x7096,0x494E},
{0x7097,0x494F}, {0x7098,0x4950}, {0x7099,0xDFD5}, {0x709B,0x4951}, {0x70A4,0x4952},
// {0x70AB,0xFAF5}, alternative
{0x70AB,0x4953}, {0x70AC,0xDFD9}, {0x70AD,0xC3BA}, {0x70AE,0xDFDC}, {0x70AF,0xDFD7},
{0x70B0,0x4954}, {0x70B1,0x4955}, {0x70B3,0xDFDB}, {0x70B4,0x4956}, {0x70B7,0x4957},
{0x70B8,0xDFDA}, {0x70B9,0xC5C0}, {0x70BA,0xB0D9},
{0x70BB,0x742e},
{0x70C8,0xCEF5}, {0x70CA,0x4958},
{0x70CB,0xDFDE}, {0x70CF,0xB1A8}, {0x70D1,0x4959}, {0x70D3,0x495A}, {0x70D4,0x495B},
{0x70D5,0x495C}, {0x70D6,0x495D}, {0x70D8,0x495E}, {0x70D9,0xDFE0}, {0x70DC,0x495F},
{0x70DD,0xDFDF}, {0x70DF,0xDFDD}, {0x70E4,0x4960}, {0x70F1,0xDFD8}, {0x70F9,0xCBA3},
// {0x7104,0xFAF7}, alternative
{0x70FA,0x4961}, {0x70FD,0xDFE2}, {0x7103,0x4962}, {0x7104,0x4963}, {0x7105,0x4964},
{0x7106,0x4965}, {0x7107,0x4966}, {0x7109,0xDFE1}, {0x710B,0x4967}, {0x710C,0x4968},
// {0x710F,0xFAF6}, alternative
{0x710F,0x4969}, {0x7114,0xB1EB}, {0x7119,0xDFE4}, {0x711A,0xCAB2}, {0x711C,0xDFE3},
{0x711E,0x496A}, {0x7120,0x496B}, {0x7121,0xCCB5}, {0x7126,0xBEC7}, {0x712B,0x496C},
{0x712D,0x496D}, {0x712F,0x496E}, {0x7130,0x496F}, {0x7131,0x4970}, {0x7136,0xC1B3},
// {0x7146,0xFAF9}, alternative
{0x7138,0x4971}, {0x713C,0xBEC6}, {0x7141,0x4972}, {0x7145,0x4973}, {0x7146,0x4974},
// {0x7147,0xFAFA}, alternative
{0x7147,0x4975}, {0x7149,0xCEFB}, {0x714A,0x4976}, {0x714B,0x4977}, {0x714C,0xDFEA},
{0x714E,0xC0F9}, {0x7150,0x4978}, {0x7152,0x4979}, {0x7155,0xDFE6}, {0x7156,0xDFEB},
// {0x715C,0xFAF8}, alternative
{0x7157,0x497A}, {0x7159,0xB1EC}, {0x715A,0x497B}, {0x715C,0x497C}, {0x715E,0x497D},
{0x7160,0x497E}, {0x7162,0xDFE9}, {0x7164,0xC7E1}, {0x7165,0xDFE5}, {0x7166,0xDFE8},
{0x7167,0xBEC8}, {0x7168,0x4A21}, {0x7169,0xC8D1}, {0x716C,0xDFEC}, {0x716E,0xBCD1},
{0x7179,0x4A22}, {0x717D,0xC0FA}, {0x7180,0x4A23}, {0x7184,0xDFEF}, {0x7185,0x4A24},
{0x7187,0x4A25}, {0x7188,0xDFE7}, {0x718A,0xB7A7}, {0x718C,0x4A26}, {0x718F,0xDFED},
{0x7192,0x4A27}, {0x7194,0xCDD0}, {0x7195,0xDFF0}, {0x7199,0xF4A6}, {0x719A,0x4A28},
{0x719B,0x4A29}, {0x719F,0xBDCF}, {0x71A0,0x4A2A}, {0x71A2,0x4A2B}, {0x71A8,0xDFF1},
{0x71AC,0xDFF2}, {0x71AF,0x4A2C}, {0x71B0,0x4A2D}, {0x71B1,0xC7AE}, {0x71B2,0x4A2E},
{0x71B3,0x4A2F}, {0x71B9,0xDFF4}, {0x71BA,0x4A30}, {0x71BE,0xDFF5}, {0x71BF,0x4A31},
// {0x71C1,0xFAFC}, alternative
{0x71C0,0x4A32}, {0x71C1,0x4A33}, {0x71C3,0xC7B3}, {0x71C4,0x4A34}, {0x71C8,0xC5F5},
{0x71C9,0xDFF7}, {0x71CB,0x4A35}, {0x71CC,0x4A36}, {0x71CE,0xDFF9}, {0x71D0,0xCED5},
{0x71D2,0xDFF6}, {0x71D3,0x4A37}, {0x71D4,0xDFF8}, {0x71D5,0xB1ED}, {0x71D6,0x4A38},
{0x71D7,0xDFF3}, {0x71D9,0x4A39}, {0x71DA,0x4A3A}, {0x71DC,0x4A3B}, {0x71DF,0xD3DB},
{0x71E0,0xDFFA}, {0x71E5,0xC1E7}, {0x71E6,0xBBB8}, {0x71E7,0xDFFC}, {0x71EC,0xDFFB},
{0x71ED,0xBFA4}, {0x71EE,0xD2D9}, {0x71F5,0xDFFD}, {0x71F8,0x4A3C}, {0x71F9,0xE0A1},
// {0x71FE,0xFAFD}, alternative
{0x71FB,0xDFEE}, {0x71FC,0xDFFE}, {0x71FE,0x4A3D}, {0x71FF,0xE0A2}, {0x7200,0x4A3E},
{0x7206,0xC7FA}, {0x7207,0x4A3F}, {0x7208,0x4A40}, {0x7209,0x4A41}, {0x720D,0xE0A3},
{0x7210,0xE0A4}, {0x7213,0x4A42}, {0x7217,0x4A43}, {0x721A,0x4A44}, {0x721B,0xE0A5},
{0x721D,0x4A45}, {0x721F,0x4A46}, {0x7224,0x4A47}, {0x7228,0xE0A6}, {0x722A,0xC4DE},
{0x722B,0x4A48}, {0x722C,0xE0A8}, {0x722D,0xE0A7}, {0x722F,0x4A49}, {0x7230,0xE0A9},
{0x7232,0xE0AA}, {0x7234,0x4A4A}, {0x7235,0xBCDF}, {0x7236,0xC9E3}, {0x7238,0x4A4B},
{0x7239,0x4A4C}, {0x723A,0xCCEC}, {0x723B,0xE0AB}, {0x723C,0xE0AC}, {0x723D,0xC1D6},
{0x723E,0xBCA4}, {0x723F,0xE0AD}, {0x7240,0xE0AE}, {0x7241,0x4A4D}, {0x7242,0x4A4E},
{0x7243,0x4A4F}, {0x7245,0x4A50}, {0x7246,0xE0AF}, {0x7247,0xCAD2}, {0x7248,0xC8C7},
{0x724B,0xE0B0}, {0x724C,0xC7D7}, {0x724E,0x4A51}, {0x724F,0x4A52}, {0x7250,0x4A53},
{0x7252,0xC4AD}, {0x7253,0x4A54}, {0x7255,0x4A55}, {0x7256,0x4A56}, {0x7258,0xE0B1},
{0x7259,0xB2E7}, {0x725A,0x4A57}, {0x725B,0xB5ED}, {0x725C,0x4A58}, {0x725D,0xCCC6},
{0x725E,0x4A59}, {0x725F,0xCCB6}, {0x7260,0x4A5A}, {0x7261,0xB2B4}, {0x7262,0xCFB4},
{0x7263,0x4A5B}, {0x7267,0xCBD2}, {0x7268,0x4A5C}, {0x7269,0xCAAA}, {0x726B,0x4A5D},
{0x726E,0x4A5E}, {0x726F,0x4A5F}, {0x7271,0x4A60}, {0x7272,0xC0B7}, {0x7274,0xE0B2},
{0x7277,0x4A61}, {0x7278,0x4A62}, {0x7279,0xC6C3}, {0x727B,0x4A63}, {0x727C,0x4A64},
{0x727D,0xB8A3}, {0x727E,0xE0B3}, {0x727F,0x4A65}, {0x7280,0xBAD4}, {0x7281,0xE0B5},
{0x7282,0xE0B4}, {0x7284,0x4A66}, {0x7287,0xE0B6}, {0x7289,0x4A67}, {0x728D,0x4A68},
{0x728E,0x4A69}, {0x7292,0xE0B7}, {0x7293,0x4A6A}, {0x7296,0xE0B8}, {0x729B,0x4A6B},
{0x72A0,0xB5BE}, {0x72A2,0xE0B9}, {0x72A7,0xE0BA}, {0x72A8,0x4A6C}, {0x72AC,0xB8A4},
// {0x72B1,0xFAFE}, alternative
{0x72AD,0x4A6D}, {0x72AE,0x4A6E}, {0x72AF,0xC8C8}, {0x72B1,0x4A6F}, {0x72B2,0xE0BC},
// {0x72BE,0xFBA1}, alternative
{0x72B4,0x4A70}, {0x72B6,0xBEF5}, {0x72B9,0xE0BB}, {0x72BE,0x4A71}, {0x72C1,0x4A72},
{0x72C2,0xB6B8}, {0x72C3,0xE0BD}, {0x72C4,0xE0BF}, {0x72C6,0xE0BE}, {0x72C7,0x4A73},
{0x72C9,0x4A74}, {0x72CC,0x4A75}, {0x72CE,0xE0C0}, {0x72D0,0xB8D1}, {0x72D2,0xE0C1},
{0x72D5,0x4A76}, {0x72D6,0x4A77}, {0x72D7,0xB6E9}, {0x72D8,0x4A78}, {0x72D9,0xC1C0},
{0x72DB,0xB9FD}, {0x72DF,0x4A79}, {0x72E0,0xE0C3}, {0x72E1,0xE0C4}, {0x72E2,0xE0C2},
{0x72E5,0x4A7A}, {0x72E9,0xBCED}, {0x72EC,0xC6C8}, {0x72ED,0xB6B9}, {0x72F3,0x4A7B},
{0x72F4,0x4A7C}, {0x72F7,0xE0C6}, {0x72F8,0xC3AC}, {0x72F9,0xE0C5}, {0x72FA,0x4A7D},
{0x72FB,0x4A7E}, {0x72FC,0xCFB5}, {0x72FD,0xC7E2}, {0x72FE,0x4B21}, {0x7302,0x4B22},
{0x7304,0x4B23}, {0x7305,0x4B24}, {0x7307,0x4B25}, {0x730A,0xE0C9}, {0x730B,0x4B26},
{0x730D,0x4B27}, {0x7312,0x4B28}, {0x7313,0x4B29}, {0x7316,0xE0CB}, {0x7317,0xE0C8},
{0x7318,0x4B2A}, {0x7319,0x4B2B}, {0x731B,0xCCD4}, {0x731C,0xE0CA}, {0x731D,0xE0CC},
// {0x7324,0xFBA2}, alternative
{0x731E,0x4B2C}, {0x731F,0xCEC4}, {0x7322,0x4B2D}, {0x7324,0x4B2E}, {0x7325,0xE0D0},
{0x7327,0x4B2F}, {0x7328,0x4B30}, {0x7329,0xE0CF}, {0x732A,0xC3F6}, {0x732B,0xC7AD},
{0x732C,0x4B31}, {0x732E,0xB8A5}, {0x732F,0xE0CE}, {0x7331,0x4B32}, {0x7332,0x4B33},
{0x7334,0xE0CD}, {0x7335,0x4B34}, {0x7336,0xCDB1}, {0x7337,0xCDB2}, {0x733A,0x4B35},
{0x733B,0x4B36}, {0x733D,0x4B37}, {0x733E,0xE0D1}, {0x733F,0xB1EE}, {0x7343,0x4B38},
{0x7344,0xB9F6}, {0x7345,0xBBE2}, {0x734D,0x4B39}, {0x734E,0xE0D2}, {0x734F,0xE0D3},
{0x7350,0x4B3A}, {0x7352,0x4B3B}, {0x7356,0x4B3C}, {0x7357,0xE0D5}, {0x7358,0x4B3D},
{0x735D,0x4B3E}, {0x735E,0x4B3F}, {0x735F,0x4B40}, {0x7360,0x4B41}, {0x7363,0xBDC3},
{0x7366,0x4B42}, {0x7367,0x4B43}, {0x7368,0xE0D7}, {0x7369,0x4B44}, {0x736A,0xE0D6},
{0x736B,0x4B45}, {0x736C,0x4B46}, {0x736E,0x4B47}, {0x736F,0x4B48}, {0x7370,0xE0D8},
// {0x7377,0xFBA4}, alternative
{0x7371,0x4B49}, {0x7372,0xB3CD}, {0x7375,0xE0DA}, {0x7377,0x4B4A}, {0x7378,0xE0D9},
{0x7379,0x4B4B}, {0x737A,0xE0DC}, {0x737B,0xE0DB}, {0x737C,0x4B4C}, {0x7380,0x4B4D},
{0x7381,0x4B4E}, {0x7383,0x4B4F}, {0x7384,0xB8BC}, {0x7385,0x4B50}, {0x7386,0x4B51},
{0x7387,0xCEA8}, {0x7389,0xB6CC}, {0x738B,0xB2A6}, {0x738E,0x4B52}, {0x7390,0x4B53},
{0x7393,0x4B54}, {0x7395,0x4B55}, {0x7396,0xB6EA}, {0x7397,0x4B56}, {0x7398,0x4B57},
{0x739C,0x4B58}, {0x739E,0x4B59}, {0x739F,0x4B5A}, {0x73A0,0x4B5B}, {0x73A2,0x4B5C},
{0x73A5,0x4B5D}, {0x73A6,0x4B5E}, {0x73A9,0xB4E1}, {0x73AA,0x4B5F}, {0x73AB,0x4B60},
{0x73AD,0x4B61}, {0x73B2,0xCEE8}, {0x73B3,0xE0DE}, {0x73B5,0x4B62}, {0x73B7,0x4B63},
// {0x73BD,0xFBA5}, alternative
{0x73B9,0x4B64}, {0x73BB,0xE0E0}, {0x73BC,0x4B65}, {0x73BD,0x4B66}, {0x73BF,0x4B67},
{0x73C0,0xE0E1}, {0x73C2,0xB2D1}, {0x73C5,0x4B68}, {0x73C6,0x4B69}, {0x73C8,0xE0DD},
// {0x73C9,0xFBA6}, alternative
{0x73C9,0x4B6A}, {0x73CA,0xBBB9}, {0x73CB,0x4B6B}, {0x73CC,0x4B6C}, {0x73CD,0xC4C1},
// {0x73D2,0xFBA9}, alternative
// {0x73D6,0xFBA7}, alternative
{0x73CE,0xE0DF}, {0x73CF,0x4B6D}, {0x73D2,0x4B6E}, {0x73D3,0x4B6F}, {0x73D6,0x4B70},
{0x73D9,0x4B71}, {0x73DD,0x4B72}, {0x73DE,0xE0E4}, {0x73E0,0xBCEE}, {0x73E1,0x4B73},
// {0x73E3,0xFBA8}, alternative
{0x73E3,0x4B74}, {0x73E5,0xE0E2}, {0x73E6,0x4B75}, {0x73E7,0x4B76}, {0x73E9,0x4B77},
{0x73EA,0xB7BE}, {0x73ED,0xC8C9}, {0x73EE,0xE0E3}, {0x73F1,0xE0FE}, {0x73F4,0x4B78},
// {0x73F5,0xFBAB}, alternative
{0x73F5,0x4B79}, {0x73F7,0x4B7A}, {0x73F8,0xE0E9}, {0x73F9,0x4B7B}, {0x73FA,0x4B7C},
{0x73FB,0x4B7D}, {0x73FD,0x4B7E}, {0x73FE,0xB8BD}, {0x73FF,0x4C21}, {0x7400,0x4C22},
{0x7401,0x4C23}, {0x7403,0xB5E5}, {0x7404,0x4C24}, {0x7405,0xE0E6}, {0x7406,0xCDFD},
// {0x7407,0xFBAA}, alternative
{0x7407,0x4C25}, {0x7409,0xCEB0}, {0x740A,0x4C26}, {0x7411,0x4C27}, {0x741A,0x4C28},
// {0x7426,0xFBAC}, alternative
{0x741B,0x4C29}, {0x7422,0xC2F6}, {0x7424,0x4C2A}, {0x7425,0xE0E8}, {0x7426,0x4C2B},
// {0x7429,0xFBAE}, alternative
// {0x742A,0xFBAD}, alternative
{0x7428,0x4C2C}, {0x7429,0x4C2D}, {0x742A,0x4C2E}, {0x742B,0x4C2F}, {0x742C,0x4C30},
// {0x742E,0xFBAF}, alternative
{0x742D,0x4C31}, {0x742E,0x4C32}, {0x742F,0x4C33}, {0x7430,0x4C34}, {0x7431,0x4C35},
{0x7432,0xE0EA}, {0x7433,0xCED6}, {0x7434,0xB6D7}, {0x7435,0xC8FC}, {0x7436,0xC7CA},
{0x7439,0x4C36}, {0x743A,0xE0EB}, {0x743F,0xE0ED}, {0x7440,0x4C37}, {0x7441,0xE0F0},
{0x7443,0x4C38}, {0x7444,0x4C39}, {0x7446,0x4C3A}, {0x7447,0x4C3B}, {0x744B,0x4C3C},
{0x744D,0x4C3D}, {0x7451,0x4C3E}, {0x7452,0x4C3F}, {0x7455,0xE0EC}, {0x7457,0x4C40},
{0x7459,0xE0EF}, {0x745A,0xB8EA}, {0x745B,0xB1CD}, {0x745C,0xE0F1}, {0x745D,0x4C41},
// {0x7462,0xFBB0}, alternative
{0x745E,0xBFF0}, {0x745F,0xE0EE}, {0x7460,0xCEDC}, {0x7462,0x4C42}, {0x7463,0xE0F4},
{0x7464,0xF4A4}, {0x7466,0x4C43}, {0x7467,0x4C44}, {0x7468,0x4C45}, {0x7469,0xE0F2},
{0x746A,0xE0F5}, {0x746B,0x4C46}, {0x746D,0x4C47}, {0x746E,0x4C48}, {0x746F,0xE0E7},
{0x7470,0xE0F3}, {0x7471,0x4C49}, {0x7472,0x4C4A}, {0x7473,0xBABC}, {0x7476,0xE0F6},
{0x747E,0xE0F7}, {0x7480,0x4C4B}, {0x7481,0x4C4C}, {0x7483,0xCDFE}, {0x7485,0x4C4D},
// {0x7489,0xFBB1}, alternative
{0x7486,0x4C4E}, {0x7487,0x4C4F}, {0x7489,0x4C50}, {0x748B,0xE0F8}, {0x748F,0x4C51},
{0x7490,0x4C52}, {0x7491,0x4C53}, {0x7492,0x4C54}, {0x7498,0x4C55}, {0x7499,0x4C56},
// {0x749F,0xFBB2}, alternative
{0x749A,0x4C57}, {0x749C,0x4C58}, {0x749E,0xE0F9}, {0x749F,0x4C59}, {0x74A0,0x4C5A},
{0x74A1,0x4C5B}, {0x74A2,0xE0E5}, {0x74A3,0x4C5C}, {0x74A6,0x4C5D}, {0x74A7,0xE0FA},
{0x74A8,0x4C5E}, {0x74A9,0x4C5F}, {0x74AA,0x4C60}, {0x74AB,0x4C61}, {0x74AE,0x4C62},
{0x74AF,0x4C63}, {0x74B0,0xB4C4}, {0x74B1,0x4C64}, {0x74B2,0x4C65}, {0x74B5,0x4C66},
{0x74B9,0x4C67}, {0x74BB,0x4C68}, {0x74BD,0xBCA5}, {0x74BF,0x4C69}, {0x74C8,0x4C6A},
{0x74C9,0x4C6B}, {0x74CA,0xE0FB}, {0x74CC,0x4C6C}, {0x74CF,0xE0FC}, {0x74D0,0x4C6D},
{0x74D3,0x4C6E}, {0x74D4,0xE0FD}, {0x74D8,0x4C6F}, {0x74DA,0x4C70}, {0x74DB,0x4C71},
{0x74DC,0xB1BB}, {0x74DE,0x4C72}, {0x74DF,0x4C73}, {0x74E0,0xE1A1}, {0x74E2,0xC9BB},
{0x74E3,0xE1A2}, {0x74E4,0x4C74}, {0x74E6,0xB4A4}, {0x74E7,0xE1A3}, {0x74E8,0x4C75},
{0x74E9,0xE1A4}, {0x74EA,0x4C76}, {0x74EB,0x4C77}, {0x74EE,0xE1A5}, {0x74EF,0x4C78},
{0x74F0,0xE1A7}, {0x74F1,0xE1A8}, {0x74F2,0xE1A6}, {0x74F4,0x4C79}, {0x74F6,0xC9D3},
{0x74F7,0xE1AA}, {0x74F8,0xE1A9}, {0x74FA,0x4C7A}, {0x74FB,0x4C7B}, {0x74FC,0x4C7C},
{0x74FF,0x4C7D},
{0x7501,0x7450},
{0x7503,0xE1AC}, {0x7504,0xE1AB}, {0x7505,0xE1AD}, {0x7506,0x4C7E},
{0x750C,0xE1AE}, {0x750D,0xE1B0}, {0x750E,0xE1AF}, {0x7511,0xB9F9}, {0x7512,0x4D21},
{0x7513,0xE1B2}, {0x7515,0xE1B1}, {0x7516,0x4D22}, {0x7517,0x4D23}, {0x7518,0xB4C5},
{0x751A,0xBFD3}, {0x751C,0xC5BC}, {0x751E,0xE1B3}, {0x751F,0xC0B8}, {0x7520,0x4D24},
{0x7521,0x4D25}, {0x7523,0xBBBA}, {0x7524,0x4D26}, {0x7525,0xB1F9}, {0x7526,0xE1B4},
{0x7527,0x4D27}, {0x7528,0xCDD1}, {0x7529,0x4D28}, {0x752A,0x4D29}, {0x752B,0xCAE3},
// {0x752F,0xF9EC}, alternative
{0x752C,0xE1B5}, {0x752F,0x4D2A}, {0x7530,0xC5C4}, {0x7531,0xCDB3}, {0x7532,0xB9C3},
{0x7533,0xBFBD}, {0x7536,0x4D2B}, {0x7537,0xC3CB}, {0x7538,0xD2B4}, {0x7539,0x4D2C},
{0x753A,0xC4AE}, {0x753B,0xB2E8}, {0x753C,0xE1B6}, {0x753D,0x4D2D}, {0x753E,0x4D2E},
{0x753F,0x4D2F}, {0x7540,0x4D30}, {0x7543,0x4D31}, {0x7544,0xE1B7}, {0x7546,0xE1BC},
{0x7547,0x4D32}, {0x7548,0x4D33}, {0x7549,0xE1BA}, {0x754A,0xE1B9}, {0x754B,0xDAC2},
{0x754C,0xB3A6}, {0x754D,0xE1B8}, {0x754E,0x4D34}, {0x754F,0xB0DA}, {0x7550,0x4D35},
{0x7551,0xC8AA}, {0x7552,0x4D36}, {0x7554,0xC8CA}, {0x7557,0x4D37}, {0x7559,0xCEB1},
{0x755A,0xE1BD}, {0x755B,0xE1BB}, {0x755C,0xC3DC}, {0x755D,0xC0A6}, {0x755E,0x4D38},
{0x755F,0x4D39}, {0x7560,0xC8AB}, {0x7561,0x4D3A}, {0x7562,0xC9AD}, {0x7564,0xE1BF},
{0x7565,0xCEAC}, {0x7566,0xB7CD}, {0x7567,0xE1C0}, {0x7569,0xE1BE}, {0x756A,0xC8D6},
// {0x756F,0xFBB4}, alternative
{0x756B,0xE1C1}, {0x756D,0xE1C2}, {0x756F,0x4D3B}, {0x7570,0xB0DB}, {0x7571,0x4D3C},
{0x7573,0xBEF6}, {0x7574,0xE1C7}, {0x7576,0xE1C4}, {0x7577,0xC6ED}, {0x7578,0xE1C3},
{0x7579,0x4D3D}, {0x757A,0x4D3E}, {0x757B,0x4D3F}, {0x757C,0x4D40}, {0x757D,0x4D41},
{0x757E,0x4D42}, {0x757F,0xB5A6}, {0x7581,0x4D43}, {0x7582,0xE1CA}, {0x7585,0x4D44},
{0x7586,0xE1C5}, {0x7587,0xE1C6}, {0x7589,0xE1C9}, {0x758A,0xE1C8}, {0x758B,0xC9A5},
{0x758E,0xC1C2}, {0x758F,0xC1C1}, {0x7590,0x4D45}, {0x7591,0xB5BF}, {0x7592,0x4D46},
{0x7593,0x4D47}, {0x7594,0xE1CB}, {0x7595,0x4D48}, {0x7599,0x4D49}, {0x759A,0xE1CC},
{0x759C,0x4D4A}, {0x759D,0xE1CD}, {0x75A2,0x4D4B}, {0x75A3,0xE1CF}, {0x75A4,0x4D4C},
{0x75A5,0xE1CE}, {0x75AB,0xB1D6}, {0x75B1,0xE1D7}, {0x75B2,0xC8E8}, {0x75B3,0xE1D1},
{0x75B4,0x4D4D}, {0x75B5,0xE1D3}, {0x75B8,0xE1D5}, {0x75B9,0xBFBE}, {0x75BA,0x4D4E},
{0x75BC,0xE1D6}, {0x75BD,0xE1D4}, {0x75BE,0xBCC0}, {0x75BF,0x4D4F}, {0x75C0,0x4D50},
{0x75C1,0x4D51}, {0x75C2,0xE1D0}, {0x75C3,0xE1D2}, {0x75C4,0x4D52}, {0x75C5,0xC9C2},
{0x75C6,0x4D53}, {0x75C7,0xBEC9}, {0x75CA,0xE1D9}, {0x75CC,0x4D54}, {0x75CD,0xE1D8},
{0x75CE,0x4D55}, {0x75CF,0x4D56}, {0x75D2,0xE1DA}, {0x75D4,0xBCA6}, {0x75D5,0xBAAF},
{0x75D7,0x4D57}, {0x75D8,0xC5F7}, {0x75D9,0xE1DB}, {0x75DB,0xC4CB}, {0x75DC,0x4D58},
{0x75DE,0xE1DD}, {0x75DF,0x4D59}, {0x75E0,0x4D5A}, {0x75E1,0x4D5B}, {0x75E2,0xCEA1},
{0x75E3,0xE1DC}, {0x75E4,0x4D5C}, {0x75E7,0x4D5D}, {0x75E9,0xC1E9}, {0x75EC,0x4D5E},
{0x75EE,0x4D5F}, {0x75EF,0x4D60}, {0x75F0,0xE1E2}, {0x75F1,0x4D61}, {0x75F2,0xE1E4},
{0x75F3,0xE1E5}, {0x75F4,0xC3D4}, {0x75F9,0x4D62}, {0x75FA,0xE1E3}, {0x75FC,0xE1E0},
{0x75FE,0xE1DE}, {0x75FF,0xE1DF}, {0x7600,0x4D63}, {0x7601,0xE1E1}, {0x7602,0x4D64},
{0x7603,0x4D65}, {0x7604,0x4D66}, {0x7607,0x4D67}, {0x7608,0x4D68}, {0x7609,0xE1E8},
{0x760A,0x4D69}, {0x760B,0xE1E6}, {0x760C,0x4D6A}, {0x760D,0xE1E7}, {0x760F,0x4D6B},
{0x7612,0x4D6C}, {0x7613,0x4D6D}, {0x7615,0x4D6E}, {0x7616,0x4D6F}, {0x7619,0x4D70},
{0x761B,0x4D71}, {0x761C,0x4D72}, {0x761D,0x4D73}, {0x761E,0x4D74}, {0x761F,0xE1E9},
{0x7620,0xE1EB}, {0x7621,0xE1EC}, {0x7622,0xE1ED}, {0x7623,0x4D75}, {0x7624,0xE1EE},
{0x7625,0x4D76}, {0x7626,0x4D77}, {0x7627,0xE1EA}, {0x7629,0x4D78}, {0x762D,0x4D79},
{0x7630,0xE1F0}, {0x7632,0x4D7A}, {0x7633,0x4D7B}, {0x7634,0xE1EF}, {0x7635,0x4D7C},
{0x7638,0x4D7D}, {0x7639,0x4D7E}, {0x763A,0x4E21}, {0x763B,0xE1F1}, {0x763C,0x4E22},
{0x7640,0x4E24}, {0x7641,0x4E25}, {0x7642,0xCEC5}, {0x7643,0x4E26}, {0x7644,0x4E27},
{0x7645,0x4E28}, {0x7646,0xE1F4}, {0x7647,0xE1F2}, {0x7648,0xE1F3}, {0x7649,0x4E29},
{0x764A,0x4E23}, {0x764B,0x4E2A}, {0x764C,0xB4E2}, {0x7652,0xCCFE}, {0x7655,0x4E2B},
{0x7656,0xCACA}, {0x7658,0xE1F6}, {0x7659,0x4E2C}, {0x765C,0xE1F5}, {0x765F,0x4E2D},
{0x7661,0xE1F7}, {0x7662,0xE1F8}, {0x7664,0x4E2E}, {0x7665,0x4E2F}, {0x7667,0xE1FC},
{0x7668,0xE1F9}, {0x7669,0xE1FA}, {0x766A,0xE1FB}, {0x766C,0xE1FD}, {0x766D,0x4E30},
{0x766E,0x4E31}, {0x766F,0x4E32}, {0x7670,0xE1FE}, {0x7671,0x4E33}, {0x7672,0xE2A1},
{0x7674,0x4E34}, {0x7676,0xE2A2}, {0x7678,0xE2A3}, {0x767A,0xC8AF}, {0x767B,0xC5D0},
{0x767C,0xE2A4}, {0x767D,0xC7F2}, {0x767E,0xC9B4}, {0x7680,0xE2A5}, {0x7681,0x4E35},
{0x7682,0x7451},
{0x7683,0xE2A6}, {0x7684,0xC5AA}, {0x7685,0x4E36}, {0x7686,0xB3A7}, {0x7687,0xB9C4},
{0x7688,0xE2A7}, {0x768B,0xE2A8}, {0x768C,0x4E37}, {0x768D,0x4E38}, {0x768E,0xE2A9},
{0x7690,0xBBA9}, {0x7693,0xE2AB}, {0x7695,0x4E39}, {0x7696,0xE2AA}, {0x7699,0xE2AC},
// {0x769B,0xFBB8}, alternative
// {0x769C,0xFBB6}, alternative
{0x769A,0xE2AD}, {0x769B,0x4E3A}, {0x769C,0x4E3B}, {0x769D,0x4E3C},
{0x769E,0x7452},
{0x769F,0x4E3D},
{0x76A0,0x4E3E}, {0x76A2,0x4E3F}, {0x76A3,0x4E40}, {0x76A4,0x4E41}, {0x76A5,0x4E42},
// {0x76A6,0xFBB9}, alternative
{0x76A6,0x4E43}, {0x76A7,0x4E44}, {0x76A8,0x4E45}, {0x76AA,0x4E46}, {0x76AD,0x4E47},
{0x76AE,0xC8E9}, {0x76B0,0xE2AE}, {0x76B4,0xE2AF}, {0x76B7,0xF3E9}, {0x76B8,0xE2B0},
{0x76B9,0xE2B1}, {0x76BA,0xE2B2}, {0x76BD,0x4E48}, {0x76BF,0xBBAE}, {0x76C1,0x4E49},
{0x76C2,0xE2B3}, {0x76C3,0xC7D6}, {0x76C5,0x4E4A}, {0x76C6,0xCBDF}, {0x76C8,0xB1CE},
{0x76C9,0x4E4B}, {0x76CA,0xB1D7}, {0x76CB,0x4E4C}, {0x76CC,0x4E4D}, {0x76CD,0xE2B4},
{0x76CE,0x4E4E}, {0x76D2,0xE2B6}, {0x76D4,0x4E4F}, {0x76D6,0xE2B5}, {0x76D7,0xC5F0},
{0x76D9,0x4E50}, {0x76DB,0xC0B9}, {0x76DC,0xDDB9}, {0x76DE,0xE2B7}, {0x76DF,0xCCC1},
{0x76E0,0x4E51}, {0x76E1,0xE2B8}, {0x76E3,0xB4C6}, {0x76E4,0xC8D7}, {0x76E5,0xE2B9},
{0x76E6,0x4E52}, {0x76E7,0xE2BA}, {0x76E8,0x4E53}, {0x76EA,0xE2BB}, {0x76EC,0x4E54},
{0x76EE,0xCCDC}, {0x76F0,0x4E55}, {0x76F1,0x4E56}, {0x76F2,0xCCD5}, {0x76F4,0xC4BE},
{0x76F6,0x4E57}, {0x76F8,0xC1EA}, {0x76F9,0x4E58}, {0x76FB,0xE2BD}, {0x76FC,0x4E59},
{0x76FE,0xBDE2}, {0x7700,0x4E5A}, {0x7701,0xBECA}, {0x7704,0xE2C0}, {0x7706,0x4E5B},
{0x7707,0xE2BF}, {0x7708,0xE2BE}, {0x7709,0xC8FD}, {0x770A,0x4E5C}, {0x770B,0xB4C7},
{0x770C,0xB8A9}, {0x770E,0x4E5D}, {0x7712,0x4E5E}, {0x7714,0x4E5F}, {0x7715,0x4E60},
{0x7717,0x4E61}, {0x7719,0x4E62}, {0x771A,0x4E63}, {0x771B,0xE2C6}, {0x771C,0x4E64},
{0x771E,0xE2C3}, {0x771F,0xBFBF}, {0x7720,0xCCB2}, {0x7722,0x4E65}, {0x7724,0xE2C2},
{0x7725,0xE2C4}, {0x7726,0xE2C5}, {0x7728,0x4E66}, {0x7729,0xE2C1}, {0x772D,0x4E67},
{0x772E,0x4E68}, {0x772F,0x4E69}, {0x7734,0x4E6A}, {0x7735,0x4E6B}, {0x7736,0x4E6C},
{0x7737,0xE2C7}, {0x7738,0xE2C8}, {0x7739,0x4E6D}, {0x773A,0xC4AF}, {0x773C,0xB4E3},
{0x773D,0x4E6E}, {0x773E,0x4E6F}, {0x7740,0xC3E5}, {0x7742,0x4E70}, {0x7745,0x4E71},
// {0x7746,0xFBBB}, alternative
{0x7746,0x4E72}, {0x7747,0xE2C9}, {0x774A,0x4E73}, {0x774D,0x4E74}, {0x774E,0x4E75},
{0x774F,0x4E76}, {0x7752,0x4E77}, {0x7756,0x4E78}, {0x7757,0x4E79}, {0x775A,0xE2CA},
{0x775B,0xE2CD}, {0x775C,0x4E7A}, {0x775E,0x4E7B}, {0x775F,0x4E7C}, {0x7760,0x4E7D},
{0x7761,0xBFE7}, {0x7762,0x4E7E}, {0x7763,0xC6C4}, {0x7764,0x4F21}, {0x7765,0xE2CE},
{0x7766,0xCBD3}, {0x7767,0x4F22}, {0x7768,0xE2CB}, {0x776A,0x4F23}, {0x776B,0xE2CC},
{0x776C,0x4F24}, {0x7770,0x4F25}, {0x7772,0x4F26}, {0x7773,0x4F27}, {0x7774,0x4F28},
{0x7779,0xE2D1}, {0x777A,0x4F29}, {0x777D,0x4F2A}, {0x777E,0xE2D0}, {0x777F,0xE2CF},
{0x7780,0x4F2B}, {0x7784,0x4F2C}, {0x778B,0xE2D3}, {0x778C,0x4F2D}, {0x778D,0x4F2E},
{0x778E,0xE2D2}, {0x7791,0xE2D4}, {0x7794,0x4F2F}, {0x7795,0x4F30}, {0x7796,0x4F31},
{0x779A,0x4F32}, {0x779E,0xE2D6}, {0x779F,0x4F33}, {0x77A0,0xE2D5}, {0x77A2,0x4F34},
{0x77A5,0xCACD}, {0x77A7,0x4F35}, {0x77AA,0x4F36}, {0x77AC,0xBDD6}, {0x77AD,0xCEC6},
{0x77AE,0x4F37}, {0x77AF,0x4F38}, {0x77B0,0xE2D7}, {0x77B1,0x4F39}, {0x77B3,0xC6B7},
{0x77B5,0x4F3A}, {0x77B6,0xE2D8}, {0x77B9,0xE2D9}, {0x77BB,0xE2DD}, {0x77BC,0xE2DB},
{0x77BD,0xE2DC}, {0x77BE,0x4F3B}, {0x77BF,0xE2DA}, {0x77C3,0x4F3C}, {0x77C7,0xE2DE},
{0x77C9,0x4F3D}, {0x77CD,0xE2DF}, {0x77D1,0x4F3E}, {0x77D2,0x4F3F}, {0x77D5,0x4F40},
{0x77D7,0xE2E0}, {0x77D9,0x4F41}, {0x77DA,0xE2E1}, {0x77DB,0xCCB7}, {0x77DC,0xE2E2},
{0x77DE,0x4F42}, {0x77DF,0x4F43}, {0x77E0,0x4F44}, {0x77E2,0xCCF0}, {0x77E3,0xE2E3},
{0x77E4,0x4F45}, {0x77E5,0xC3CE}, {0x77E6,0x4F46}, {0x77E7,0xC7EA}, {0x77E9,0xB6EB},
{0x77EA,0x4F47}, {0x77EC,0x4F48}, {0x77ED,0xC3BB}, {0x77EE,0xE2E4}, {0x77EF,0xB6BA},
{0x77F0,0x4F49}, {0x77F1,0x4F4A}, {0x77F3,0xC0D0}, {0x77F4,0x4F4B}, {0x77F8,0x4F4C},
{0x77FB,0x4F4D}, {0x77FC,0xE2E5}, {0x7802,0xBABD}, {0x7805,0x4F4E}, {0x7806,0x4F4F},
{0x7809,0x4F50}, {0x780C,0xE2E6}, {0x780D,0x4F51}, {0x780E,0x4F52}, {0x7811,0x4F53},
{0x7812,0xE2E7}, {0x7814,0xB8A6}, {0x7815,0xBAD5}, {0x781D,0x4F54}, {0x7820,0xE2E9},
// {0x7821,0xFBBD}, alternative
{0x7821,0x4F55}, {0x7822,0x4F56}, {0x7823,0x4F57}, {0x7825,0xC5D6}, {0x7826,0xBAD6},
{0x7827,0xB5CE}, {0x782D,0x4F58}, {0x782E,0x4F59}, {0x7830,0x4F5A}, {0x7832,0xCBA4},
{0x7834,0xC7CB}, {0x7835,0x4F5B}, {0x7837,0x4F5C}, {0x783A,0xC5D7}, {0x783F,0xB9DC},
{0x7843,0x4F5D}, {0x7844,0x4F5E}, {0x7845,0xE2EB}, {0x7847,0x4F5F}, {0x7848,0x4F60},
// {0x784E,0xFBBE}, alternative
{0x784C,0x4F61}, {0x784E,0x4F62}, {0x7852,0x4F63}, {0x785C,0x4F64}, {0x785D,0xBECB},
// {0x7864,0xFBBF}, alternative
{0x785E,0x4F65}, {0x7860,0x4F66}, {0x7861,0x4F67}, {0x7863,0x4F68}, {0x7864,0x4F69},
{0x7868,0x4F6A}, {0x786A,0x4F6B}, {0x786B,0xCEB2}, {0x786C,0xB9C5}, {0x786E,0x4F6C},
// {0x787A,0xFBC0}, alternative
{0x786F,0xB8A7}, {0x7872,0xC8A3}, {0x7874,0xE2ED}, {0x787A,0x4F6D}, {0x787C,0xE2EF},
{0x787E,0x4F6E}, {0x7881,0xB8EB}, {0x7886,0xE2EE}, {0x7887,0xC4F6}, {0x788A,0x4F6F},
{0x788C,0xE2F1}, {0x788D,0xB3B7}, {0x788E,0xE2EC}, {0x788F,0x4F70}, {0x7891,0xC8EA},
{0x7893,0xB1B0}, {0x7894,0x4F71}, {0x7895,0xBAEC}, {0x7897,0xCFD2}, {0x7898,0x4F72},
{0x789A,0xE2F0}, {0x789D,0x4F74}, {0x789E,0x4F75}, {0x789F,0x4F76}, {0x78A1,0x4F73},
{0x78A3,0xE2F2}, {0x78A4,0x4F77}, {0x78A7,0xCACB}, {0x78A8,0x4F78}, {0x78A9,0xC0D9},
{0x78AA,0xE2F4}, {0x78AC,0x4F79}, {0x78AD,0x4F7A}, {0x78AF,0xE2F5}, {0x78B0,0x4F7B},
{0x78B1,0x4F7C}, {0x78B2,0x4F7D}, {0x78B3,0x4F7E}, {0x78B5,0xE2F3}, {0x78BA,0xB3CE},
{0x78BB,0x5021}, {0x78BC,0xE2FB}, {0x78BD,0x5022}, {0x78BE,0xE2FA}, {0x78BF,0x5023},
{0x78C1,0xBCA7}, {0x78C5,0xE2FC}, {0x78C6,0xE2F7}, {0x78C7,0x5024}, {0x78C8,0x5025},
{0x78C9,0x5026}, {0x78CA,0xE2FD}, {0x78CB,0xE2F8}, {0x78CC,0x5027}, {0x78CE,0x5028},
{0x78D0,0xC8D8}, {0x78D1,0xE2F6}, {0x78D2,0x5029}, {0x78D3,0x502A}, {0x78D4,0xE2F9},
{0x78D5,0x502B}, {0x78D6,0x502C}, {0x78DA,0xE3A2}, {0x78DB,0x502E}, {0x78DF,0x502F},
{0x78E0,0x5030}, {0x78E1,0x5031}, {0x78E4,0x502D}, {0x78E6,0x5032}, {0x78E7,0xE3A1},
{0x78E8,0xCBE1}, {0x78EA,0x5033}, {0x78EC,0xE2FE}, {0x78EF,0xB0EB}, {0x78F2,0x5034},
{0x78F3,0x5035}, {0x78F4,0xE3A4}, {0x78F6,0x5037}, {0x78F7,0x5038}, {0x78FA,0x5039},
{0x78FB,0x503A}, {0x78FD,0xE3A3}, {0x78FF,0x503B}, {0x7900,0x5036}, {0x7901,0xBECC},
{0x7906,0x503C}, {0x7907,0xE3A5}, {0x790C,0x503D}, {0x790E,0xC1C3}, {0x7910,0x503E},
{0x7911,0xE3A7}, {0x7912,0xE3A6}, {0x7919,0xE3A8}, {0x791A,0x503F}, {0x791C,0x5040},
{0x791E,0x5041}, {0x791F,0x5042}, {0x7920,0x5043}, {0x7925,0x5044}, {0x7926,0xE2E8},
{0x7927,0x5045}, {0x7929,0x5046}, {0x792A,0xE2EA}, {0x792B,0xE3AA}, {0x792C,0xE3A9},
{0x792D,0x5047},
{0x7930,0x7454},
{0x7931,0x5048}, {0x7934,0x5049}, {0x7935,0x504A}, {0x793A,0xBCA8},
{0x793B,0x504B}, {0x793C,0xCEE9}, {0x793D,0x504C}, {0x793E,0xBCD2}, {0x793F,0x504D},
{0x7940,0xE3AB}, {0x7941,0xB7B7}, {0x7944,0x504E}, {0x7945,0x504F}, {0x7946,0x5050},
{0x7947,0xB5C0}, {0x7948,0xB5A7}, {0x7949,0xBBE3}, {0x794A,0x5051}, {0x794B,0x5052},
{0x794F,0x5053}, {0x7950,0xCDB4}, {0x7951,0x5054}, {0x7953,0xE3B1}, {0x7954,0x5055},
{0x7955,0xE3B0}, {0x7956,0xC1C4}, {0x7957,0xE3AD}, {0x7958,0x5056}, {0x795A,0xE3AF},
{0x795B,0x5057}, {0x795C,0x5058}, {0x795D,0xBDCB}, {0x795E,0xBFC0}, {0x795F,0xE3AE},
{0x7960,0xE3AC}, {0x7962,0xC7AA}, {0x7965,0xBECD}, {0x7967,0x5059}, {0x7968,0xC9BC},
{0x7969,0x505A}, {0x796B,0x505B}, {0x796D,0xBAD7}, {0x7972,0x505C}, {0x7977,0xC5F8},
{0x7979,0x505D}, {0x797A,0xE3B2}, {0x797B,0x505E}, {0x797C,0x505F}, {0x797E,0x5060},
{0x797F,0xE3B3}, {0x7980,0xE3C9}, {0x7981,0xB6D8}, {0x7984,0xCFBD}, {0x7985,0xC1B5},
{0x798A,0xE3B4}, {0x798B,0x5061}, {0x798C,0x5062}, {0x798D,0xB2D2}, {0x798E,0xC4F7},
// {0x7994,0xFBC5}, alternative
{0x798F,0xCAA1}, {0x7991,0x5063}, {0x7993,0x5064}, {0x7994,0x5065}, {0x7995,0x5066},
// {0x799B,0xFBC7}, alternative
{0x7996,0x5067}, {0x7998,0x5068}, {0x799B,0x5069}, {0x799C,0x506A}, {0x799D,0xE3B5},
{0x79A1,0x506B}, {0x79A6,0xB5FA}, {0x79A7,0xE3B6}, {0x79A8,0x506C}, {0x79A9,0x506D},
{0x79AA,0xE3B8}, {0x79AB,0x506E}, {0x79AE,0xE3B9}, {0x79AF,0x506F}, {0x79B0,0xC7A9},
{0x79B1,0x5070}, {0x79B3,0xE3BA}, {0x79B4,0x5071}, {0x79B8,0x5072}, {0x79B9,0xE3BB},
{0x79BA,0xE3BC}, {0x79BB,0x5073}, {0x79BD,0xB6D9}, {0x79BE,0xB2D3}, {0x79BF,0xC6C5},
{0x79C0,0xBDA8}, {0x79C1,0xBBE4}, {0x79C2,0x5074}, {0x79C4,0x5075}, {0x79C7,0x5076},
{0x79C8,0x5077}, {0x79C9,0xE3BD}, {0x79CA,0x5078}, {0x79CB,0xBDA9}, {0x79CF,0x5079},
{0x79D1,0xB2CA}, {0x79D2,0xC9C3}, {0x79D4,0x507A}, {0x79D5,0xE3BE}, {0x79D6,0x507B},
{0x79D8,0xC8EB}, {0x79DA,0x507C}, {0x79DD,0x507D}, {0x79DE,0x507E}, {0x79DF,0xC1C5},
{0x79E0,0x5121}, {0x79E1,0xE3C1}, {0x79E2,0x5122}, {0x79E3,0xE3C2}, {0x79E4,0xC7E9},
{0x79E5,0x5123}, {0x79E6,0xBFC1}, {0x79E7,0xE3BF}, {0x79E9,0xC3E1}, {0x79EA,0x5124},
{0x79EB,0x5125}, {0x79EC,0xE3C0}, {0x79ED,0x5126}, {0x79F0,0xBECE}, {0x79F1,0x5127},
{0x79F8,0x5128}, {0x79FB,0xB0DC}, {0x79FC,0x5129}, {0x7A00,0xB5A9}, {0x7A02,0x512A},
{0x7A03,0x512B}, {0x7A07,0x512C}, {0x7A08,0xE3C3}, {0x7A09,0x512D}, {0x7A0A,0x512E},
{0x7A0B,0xC4F8}, {0x7A0C,0x512F}, {0x7A0D,0xE3C4}, {0x7A0E,0xC0C7}, {0x7A11,0x5130},
{0x7A14,0xCCAD}, {0x7A15,0x5131}, {0x7A17,0xC9A3}, {0x7A18,0xE3C5}, {0x7A19,0xE3C6},
{0x7A1A,0xC3D5}, {0x7A1B,0x5132}, {0x7A1C,0xCEC7}, {0x7A1E,0x5133}, {0x7A1F,0xE3C8},
{0x7A20,0xE3C7}, {0x7A21,0x5134}, {0x7A27,0x5135}, {0x7A2B,0x5136}, {0x7A2D,0x5137},
{0x7A2E,0xBCEF}, {0x7A2F,0x5138}, {0x7A30,0x5139}, {0x7A31,0xE3CA}, {0x7A32,0xB0F0},
{0x7A34,0x513A}, {0x7A35,0x513B}, {0x7A37,0xE3CD}, {0x7A38,0x513C}, {0x7A39,0x513D},
{0x7A3A,0x513E}, {0x7A3B,0xE3CB}, {0x7A3C,0xB2D4}, {0x7A3D,0xB7CE}, {0x7A3E,0xE3CC},
{0x7A3F,0xB9C6}, {0x7A40,0xB9F2}, {0x7A42,0xCAE6}, {0x7A43,0xE3CE}, {0x7A44,0x513F},
{0x7A45,0x5140}, {0x7A46,0xCBD4}, {0x7A47,0x5141}, {0x7A48,0x5142}, {0x7A49,0xE3D0},
{0x7A4C,0x5143}, {0x7A4D,0xC0D1}, {0x7A4E,0xB1CF}, {0x7A4F,0xB2BA}, {0x7A50,0xB0AC},
{0x7A55,0x5144}, {0x7A56,0x5145}, {0x7A57,0xE3CF}, {0x7A59,0x5146}, {0x7A5C,0x5147},
{0x7A5D,0x5148}, {0x7A5F,0x5149}, {0x7A60,0x514A}, {0x7A61,0xE3D1}, {0x7A62,0xE3D2},
{0x7A63,0xBEF7}, {0x7A65,0x514B}, {0x7A67,0x514C}, {0x7A69,0xE3D3}, {0x7A6A,0x514D},
{0x7A6B,0xB3CF}, {0x7A6D,0x514E}, {0x7A70,0xE3D5}, {0x7A74,0xB7EA}, {0x7A75,0x514F},
{0x7A76,0xB5E6}, {0x7A78,0x5150}, {0x7A79,0xE3D6}, {0x7A7A,0xB6F5}, {0x7A7D,0xE3D7},
{0x7A7E,0x5151}, {0x7A7F,0xC0FC}, {0x7A80,0x5152}, {0x7A81,0xC6CD}, {0x7A82,0x5153},
{0x7A83,0xC0E0}, {0x7A84,0xBAF5}, {0x7A85,0x5154}, {0x7A86,0x5155}, {0x7A88,0xE3D8},
{0x7A8A,0x5156}, {0x7A8B,0x5157}, {0x7A90,0x5158}, {0x7A91,0x5159}, {0x7A92,0xC3E2},
{0x7A93,0xC1EB}, {0x7A94,0x515A}, {0x7A95,0xE3DA}, {0x7A96,0xE3DC}, {0x7A97,0xE3D9},
{0x7A98,0xE3DB}, {0x7A9E,0x515B}, {0x7A9F,0xB7A2}, {0x7AA0,0x515C}, {0x7AA3,0x515D},
{0x7AA9,0xE3DD}, {0x7AAA,0xB7A6}, {0x7AAC,0x515E}, {0x7AAE,0xB5E7}, {0x7AAF,0xCDD2},
{0x7AB0,0xE3DF}, {0x7AB3,0x515F}, {0x7AB5,0x5160}, {0x7AB6,0xE3E0}, {0x7AB9,0x5161},
{0x7ABA,0xB1AE}, {0x7ABB,0x5162}, {0x7ABC,0x5163}, {0x7ABF,0xE3E3}, {0x7AC3,0xB3F6},
{0x7AC4,0xE3E2}, {0x7AC5,0xE3E1}, {0x7AC6,0x5164}, {0x7AC7,0xE3E5}, {0x7AC8,0xE3DE},
{0x7AC9,0x5165}, {0x7ACA,0xE3E6}, {0x7ACB,0xCEA9}, {0x7ACC,0x5166}, {0x7ACD,0xE3E7},
// {0x7AD1,0xFBC8}, alternative
{0x7ACE,0x5167}, {0x7ACF,0xE3E8}, {0x7AD1,0x5168}, {0x7AD2,0xD4F4}, {0x7AD3,0xE3EA},
{0x7AD5,0xE3E9}, {0x7AD9,0xE3EB}, {0x7ADA,0xE3EC}, {0x7ADB,0x5169}, {0x7ADC,0xCEB5},
{0x7ADD,0xE3ED}, {0x7ADF,0xF0EF}, {0x7AE0,0xBECF}, {0x7AE1,0xE3EE}, {0x7AE2,0xE3EF},
{0x7AE3,0xBDD7}, {0x7AE5,0xC6B8}, {0x7AE6,0xE3F0},
{0x7AE7,0x7459},
{0x7AE8,0x516A}, {0x7AE9,0x516B},
// {0x7AEB,0xFBCB}, alternative
{0x7AEA,0xC3A8}, {0x7AEB,0x516C}, {0x7AEC,0x516D}, {0x7AED,0xE3F1}, {0x7AEF,0xC3BC},
{0x7AF0,0xE3F2}, {0x7AF1,0x516E}, {0x7AF4,0x516F}, {0x7AF6,0xB6A5}, {0x7AF8,0xD1BF},
{0x7AF9,0xC3DD}, {0x7AFA,0xBCB3}, {0x7AFB,0x5170}, {0x7AFD,0x5171}, {0x7AFE,0x5172},
{0x7AFF,0xB4C8}, {0x7B02,0xE3F3}, {0x7B04,0xE4A2}, {0x7B06,0xE3F6}, {0x7B07,0x5173},
{0x7B08,0xB5E8}, {0x7B0A,0xE3F5}, {0x7B0B,0xE4A4}, {0x7B0F,0xE3F4}, {0x7B11,0xBED0},
{0x7B14,0x5174}, {0x7B18,0xE3F8}, {0x7B19,0xE3F9}, {0x7B1B,0xC5AB}, {0x7B1E,0xE3FA},
{0x7B1F,0x5175}, {0x7B20,0xB3DE}, {0x7B23,0x5176}, {0x7B25,0xBFDA}, {0x7B26,0xC9E4},
{0x7B27,0x5177}, {0x7B28,0xE3FC}, {0x7B29,0x5178}, {0x7B2A,0x5179}, {0x7B2B,0x517A},
{0x7B2C,0xC2E8}, {0x7B2D,0x517B}, {0x7B2E,0x517C}, {0x7B2F,0x517D}, {0x7B30,0x517E},
{0x7B31,0x5221}, {0x7B33,0xE3F7}, {0x7B34,0x5222}, {0x7B35,0xE3FB}, {0x7B36,0xE3FD},
{0x7B39,0xBAFB}, {0x7B3D,0x5223}, {0x7B3F,0x5224}, {0x7B40,0x5225}, {0x7B41,0x5226},
{0x7B45,0xE4A6}, {0x7B46,0xC9AE}, {0x7B47,0x5227}, {0x7B48,0xC8A6}, {0x7B49,0xC5F9},
{0x7B4B,0xB6DA}, {0x7B4C,0xE4A5}, {0x7B4D,0xE4A3}, {0x7B4E,0x5228}, {0x7B4F,0xC8B5},
{0x7B50,0xE3FE}, {0x7B51,0xC3DE}, {0x7B52,0xC5FB}, {0x7B54,0xC5FA}, {0x7B55,0x5229},
{0x7B56,0xBAF6}, {0x7B5D,0xE4B8}, {0x7B60,0x522A}, {0x7B64,0x522B}, {0x7B65,0xE4A8},
{0x7B66,0x522C}, {0x7B67,0xE4AA}, {0x7B69,0x522D}, {0x7B6A,0x522E}, {0x7B6C,0xE4AD},
{0x7B6D,0x522F}, {0x7B6E,0xE4AE}, {0x7B6F,0x5230}, {0x7B70,0xE4AB}, {0x7B71,0xE4AC},
{0x7B72,0x5231}, {0x7B73,0x5232}, {0x7B74,0xE4A9}, {0x7B75,0xE4A7}, {0x7B77,0x5233},
{0x7B7A,0xE4A1}, {0x7B84,0x5234}, {0x7B86,0xCACF}, {0x7B87,0xB2D5}, {0x7B89,0x5235},
{0x7B8B,0xE4B5}, {0x7B8D,0xE4B2}, {0x7B8E,0x5236}, {0x7B8F,0xE4B7}, {0x7B90,0x5237},
{0x7B91,0x5238}, {0x7B92,0xE4B6}, {0x7B94,0xC7F3}, {0x7B95,0xCCA7}, {0x7B96,0x5239},
{0x7B97,0xBBBB}, {0x7B98,0xE4B0}, {0x7B99,0xE4B9}, {0x7B9A,0xE4B4}, {0x7B9B,0x523A},
// {0x7B9E,0xFBCC}, alternative
{0x7B9C,0xE4B3}, {0x7B9D,0xE4AF}, {0x7B9E,0x523B}, {0x7B9F,0xE4B1}, {0x7BA0,0x523C},
{0x7BA1,0xB4C9}, {0x7BA5,0x523D}, {0x7BAA,0xC3BD}, {0x7BAC,0x523E}, {0x7BAD,0xC0FD},
{0x7BAF,0x523F}, {0x7BB0,0x5240}, {0x7BB1,0xC8A2}, {0x7BB2,0x5241}, {0x7BB4,0xE4BE},
{0x7BB5,0x5242}, {0x7BB6,0x5243}, {0x7BB8,0xC8A4}, {0x7BBA,0x5244}, {0x7BBB,0x5245},
{0x7BBC,0x5246}, {0x7BBD,0x5247}, {0x7BC0,0xC0E1}, {0x7BC1,0xE4BB}, {0x7BC2,0x5248},
{0x7BC4,0xC8CF}, {0x7BC5,0x5249}, {0x7BC6,0xE4BF}, {0x7BC7,0xCAD3}, {0x7BC8,0x524A},
{0x7BC9,0xC3DB}, {0x7BCA,0x524B}, {0x7BCB,0xE4BA}, {0x7BCC,0xE4BC}, {0x7BCF,0xE4BD},
{0x7BD4,0x524C}, {0x7BD6,0x524D}, {0x7BD7,0x524E}, {0x7BD9,0x524F}, {0x7BDA,0x5250},
{0x7BDB,0x5251}, {0x7BDD,0xE4C0}, {0x7BE0,0xBCC4}, {0x7BE4,0xC6C6}, {0x7BE5,0xE4C5},
{0x7BE6,0xE4C4}, {0x7BE8,0x5252}, {0x7BE9,0xE4C1}, {0x7BEA,0x5253}, {0x7BED,0xCFB6},
{0x7BF2,0x5254}, {0x7BF3,0xE4CA}, {0x7BF4,0x5255}, {0x7BF5,0x5256}, {0x7BF6,0xE4CE},
{0x7BF7,0xE4CB}, {0x7BF8,0x5257}, {0x7BF9,0x5258}, {0x7BFA,0x5259}, {0x7BFC,0x525A},
{0x7BFE,0x525B}, {0x7C00,0xE4C7}, {0x7C01,0x525C}, {0x7C02,0x525D}, {0x7C03,0x525E},
{0x7C04,0x525F}, {0x7C06,0x5260}, {0x7C07,0xE4C8}, {0x7C09,0x5261}, {0x7C0B,0x5262},
{0x7C0C,0x5263}, {0x7C0D,0xE4CD}, {0x7C0E,0x5264}, {0x7C0F,0x5265}, {0x7C11,0xE4C2},
{0x7C12,0xD2D5}, {0x7C13,0xE4C9}, {0x7C14,0xE4C3}, {0x7C17,0xE4CC}, {0x7C19,0x5266},
{0x7C1B,0x5267}, {0x7C1F,0xE4D2}, {0x7C20,0x5268}, {0x7C21,0xB4CA}, {0x7C23,0xE4CF},
{0x7C25,0x5269}, {0x7C26,0x526A}, {0x7C27,0xE4D0}, {0x7C28,0x526B}, {0x7C2A,0xE4D1},
{0x7C2B,0xE4D4}, {0x7C2C,0x526C}, {0x7C31,0x526D}, {0x7C33,0x526E}, {0x7C34,0x526F},
{0x7C36,0x5270}, {0x7C37,0xE4D3}, {0x7C38,0xC8F6}, {0x7C39,0x5271}, {0x7C3A,0x5272},
{0x7C3D,0xE4D5}, {0x7C3E,0xCEFC}, {0x7C3F,0xCAED}, {0x7C40,0xE4DA}, {0x7C43,0xE4D7},
{0x7C46,0x5273}, {0x7C4A,0x5274}, {0x7C4C,0xE4D6}, {0x7C4D,0xC0D2}, {0x7C4F,0xE4D9},
{0x7C50,0xE4DB}, {0x7C51,0x5276}, {0x7C52,0x5277}, {0x7C53,0x5278}, {0x7C54,0xE4D8},
{0x7C55,0x5275}, {0x7C56,0xE4DF}, {0x7C58,0xE4DC}, {0x7C59,0x5279}, {0x7C5A,0x527A},
{0x7C5B,0x527B}, {0x7C5C,0x527C}, {0x7C5D,0x527D}, {0x7C5E,0x527E}, {0x7C5F,0xE4DD},
{0x7C60,0xE4C6}, {0x7C61,0x5321}, {0x7C63,0x5322}, {0x7C64,0xE4DE}, {0x7C65,0xE4E0},
{0x7C67,0x5323}, {0x7C69,0x5324}, {0x7C6C,0xE4E1}, {0x7C6D,0x5325}, {0x7C6E,0x5326},
{0x7C70,0x5327}, {0x7C72,0x5328}, {0x7C73,0xCAC6}, {0x7C75,0xE4E2}, {0x7C79,0x5329},
{0x7C7C,0x532A}, {0x7C7D,0x532B}, {0x7C7E,0xCCE2}, {0x7C81,0xB6CE}, {0x7C82,0xB7A9},
{0x7C83,0xE4E3}, {0x7C86,0x532C}, {0x7C87,0x532D}, {0x7C89,0xCAB4}, {0x7C8B,0xBFE8},
{0x7C8D,0xCCB0}, {0x7C8F,0x532E}, {0x7C90,0xE4E4}, {0x7C92,0xCEB3}, {0x7C94,0x532F},
{0x7C95,0xC7F4}, {0x7C97,0xC1C6}, {0x7C98,0xC7B4}, {0x7C9B,0xBDCD}, {0x7C9E,0x5330},
{0x7C9F,0xB0C0}, {0x7CA0,0x5331}, {0x7CA1,0xE4E9}, {0x7CA2,0xE4E7}, {0x7CA4,0xE4E5},
{0x7CA5,0xB4A1}, {0x7CA6,0x5332}, {0x7CA7,0xBED1}, {0x7CA8,0xE4EA}, {0x7CAB,0xE4E8},
{0x7CAD,0xE4E6}, {0x7CAE,0xE4EE}, {0x7CB0,0x5333}, {0x7CB1,0xE4ED}, {0x7CB2,0xE4EC},
{0x7CB3,0xE4EB}, {0x7CB6,0x5334}, {0x7CB7,0x5335}, {0x7CB9,0xE4EF}, {0x7CBA,0x5336},
{0x7CBB,0x5337}, {0x7CBC,0x5338}, {0x7CBD,0xE4F0}, {0x7CBE,0xC0BA}, {0x7CBF,0x5339},
{0x7CC0,0xE4F1}, {0x7CC2,0xE4F3}, {0x7CC4,0x533A}, {0x7CC5,0xE4F2}, {0x7CC7,0x533B},
{0x7CC8,0x533C}, {0x7CC9,0x533D}, {0x7CCA,0xB8D2}, {0x7CCD,0x533E}, {0x7CCE,0xC1B8},
{0x7CCF,0x533F}, {0x7CD2,0xE4F5}, {0x7CD3,0x5340}, {0x7CD4,0x5341}, {0x7CD5,0x5342},
{0x7CD6,0xC5FC}, {0x7CD7,0x5343}, {0x7CD8,0xE4F4}, {0x7CD9,0x5344}, {0x7CDA,0x5345},
{0x7CDC,0xE4F6}, {0x7CDD,0x5346}, {0x7CDE,0xCAB5}, {0x7CDF,0xC1EC}, {0x7CE0,0xB9C7},
{0x7CE2,0xE4F7}, {0x7CE6,0x5347}, {0x7CE7,0xCEC8}, {0x7CE9,0x5348}, {0x7CEB,0x5349},
{0x7CEF,0xE4F9}, {0x7CF2,0xE4FA}, {0x7CF4,0xE4FB}, {0x7CF5,0x534A}, {0x7CF6,0xE4FC},
{0x7CF8,0xBBE5}, {0x7CFA,0xE4FD}, {0x7CFB,0xB7CF}, {0x7CFE,0xB5EA}, {0x7D00,0xB5AA},
{0x7D02,0xE5A1}, {0x7D03,0x534B}, {0x7D04,0xCCF3}, {0x7D05,0xB9C8}, {0x7D06,0xE4FE},
{0x7D07,0x534C}, {0x7D08,0x534D}, {0x7D09,0x534E}, {0x7D0A,0xE5A4}, {0x7D0B,0xCCE6},
{0x7D0D,0xC7BC}, {0x7D0F,0x534F}, {0x7D10,0xC9B3}, {0x7D11,0x5350}, {0x7D12,0x5351},
{0x7D13,0x5352}, {0x7D14,0xBDE3}, {0x7D15,0xE5A3}, {0x7D16,0x5353}, {0x7D17,0xBCD3},
{0x7D18,0xB9C9}, {0x7D19,0xBBE6}, {0x7D1A,0xB5E9}, {0x7D1B,0xCAB6}, {0x7D1C,0xE5A2},
{0x7D1D,0x5354}, {0x7D1E,0x5355}, {0x7D20,0xC1C7}, {0x7D21,0xCBC2}, {0x7D22,0xBAF7},
{0x7D23,0x5356}, {0x7D26,0x5357}, {0x7D2A,0x5358}, {0x7D2B,0xBBE7}, {0x7D2C,0xC4DD},
{0x7D2D,0x5359}, {0x7D2E,0xE5A7}, {0x7D2F,0xCEDF}, {0x7D30,0xBAD9}, {0x7D31,0x535A},
{0x7D32,0xE5A8}, {0x7D33,0xBFC2}, {0x7D35,0xE5AA}, {0x7D39,0xBED2}, {0x7D3A,0xBAB0},
{0x7D3C,0x535B}, {0x7D3D,0x535C}, {0x7D3E,0x535D}, {0x7D3F,0xE5A9}, {0x7D40,0x535E},
{0x7D41,0x535F}, {0x7D42,0xBDAA}, {0x7D43,0xB8BE}, {0x7D44,0xC1C8}, {0x7D45,0xE5A5},
// {0x7D48,0xFBCE}, alternative
{0x7D46,0xE5AB}, {0x7D47,0x5360}, {0x7D48,0x5361}, {0x7D4B,0xE5A6}, {0x7D4C,0xB7D0},
{0x7D4D,0x5362}, {0x7D4E,0xE5AE}, {0x7D4F,0xE5B2}, {0x7D50,0xB7EB}, {0x7D51,0x5363},
{0x7D53,0x5364}, {0x7D56,0xE5AD}, {0x7D57,0x5365}, {0x7D59,0x5366}, {0x7D5A,0x5367},
// {0x7D5C,0xFBCF}, alternative
{0x7D5B,0xE5B6}, {0x7D5C,0x5368}, {0x7D5D,0x5369}, {0x7D5E,0xB9CA}, {0x7D61,0xCDED},
{0x7D62,0xB0BC}, {0x7D63,0xE5B3}, {0x7D65,0x536A}, {0x7D66,0xB5EB}, {0x7D67,0x536B},
{0x7D68,0xE5B0}, {0x7D6A,0x536C}, {0x7D6E,0xE5B1}, {0x7D70,0x536D}, {0x7D71,0xC5FD},
{0x7D72,0xE5AF}, {0x7D73,0xE5AC}, {0x7D75,0xB3A8}, {0x7D76,0xC0E4}, {0x7D78,0x536E},
{0x7D79,0xB8A8}, {0x7D7A,0x536F}, {0x7D7B,0x5370}, {0x7D7D,0xE5B8}, {0x7D7F,0x5371},
{0x7D81,0x5372}, {0x7D82,0x5373}, {0x7D83,0x5374}, {0x7D85,0x5375}, {0x7D86,0x5376},
{0x7D88,0x5377}, {0x7D89,0xE5B5}, {0x7D8B,0x5378}, {0x7D8C,0x5379}, {0x7D8D,0x537A},
{0x7D8F,0xE5B7}, {0x7D91,0x537B}, {0x7D93,0xE5B4}, {0x7D96,0x537C}, {0x7D97,0x537D},
{0x7D99,0xB7D1}, {0x7D9A,0xC2B3}, {0x7D9B,0xE5B9}, {0x7D9C,0xC1EE}, {0x7D9D,0x537E},
{0x7D9E,0x5421}, {0x7D9F,0xE5C6},
{0x7DA0,0x745c},
{0x7DA2,0xE5C2}, {0x7DA3,0xE5BC}, {0x7DA6,0x5422},
{0x7DA7,0x5423}, {0x7DAA,0x5424}, {0x7DAB,0xE5C0}, {0x7DAC,0xBCFA}, {0x7DAD,0xB0DD},
{0x7DAE,0xE5BB}, {0x7DAF,0xE5C3}, {0x7DB0,0xE5C7}, {0x7DB1,0xB9CB}, {0x7DB2,0xCCD6},
// {0x7DB7,0xFBD0}, alternative
{0x7DB3,0x5425}, {0x7DB4,0xC4D6}, {0x7DB5,0xE5BD}, {0x7DB6,0x5426}, {0x7DB7,0x5427},
{0x7DB8,0xE5C5}, {0x7DB9,0x5428}, {0x7DBA,0xE5BA}, {0x7DBB,0xC3BE}, {0x7DBD,0xE5BF},
{0x7DBE,0xB0BD}, {0x7DBF,0xCCCA}, {0x7DC2,0x5429}, {0x7DC3,0x542A}, {0x7DC4,0x542B},
{0x7DC5,0x542C}, {0x7DC6,0x542D}, {0x7DC7,0xE5BE}, {0x7DCA,0xB6DB}, {0x7DCB,0xC8EC},
{0x7DCC,0x542E}, {0x7DCD,0x542F}, {0x7DCE,0x5430}, {0x7DCF,0xC1ED}, {0x7DD1,0xCED0},
{0x7DD2,0xBDEF}, {0x7DD5,0xE5EE},
{0x7DD6,0x745d},
{0x7DD7,0x5431}, {0x7DD8,0xE5C8}, {0x7DD9,0x5432},
{0x7DDA,0xC0FE}, {0x7DDC,0xE5C4}, {0x7DDD,0xE5C9}, {0x7DDE,0xE5CB}, {0x7DE0,0xC4F9},
{0x7DE1,0xE5CE}, {0x7DE2,0x5434}, {0x7DE4,0xE5CA}, {0x7DE5,0x5435}, {0x7DE6,0x5436},
{0x7DE8,0xCAD4}, {0x7DE9,0xB4CB}, {0x7DEA,0x5437}, {0x7DEB,0x5438}, {0x7DEC,0xCCCB},
{0x7DED,0x5439}, {0x7DEF,0xB0DE}, {0x7DF1,0x543A}, {0x7DF2,0xE5CD}, {0x7DF4,0xCEFD},
{0x7DF5,0x543B}, {0x7DF6,0x543C}, {0x7DF9,0x543D}, {0x7DFA,0x543E}, {0x7DFB,0xE5CC},
{0x7E00,0x5433}, {0x7E01,0xB1EF}, {0x7E04,0xC6EC}, {0x7E05,0xE5CF}, {0x7E08,0x543F},
{0x7E09,0xE5D6}, {0x7E0A,0xE5D0}, {0x7E0B,0xE5D7}, {0x7E10,0x5440}, {0x7E11,0x5441},
{0x7E12,0xE5D3}, {0x7E15,0x5442}, {0x7E17,0x5443}, {0x7E1B,0xC7FB}, {0x7E1C,0x5444},
{0x7E1D,0x5445}, {0x7E1E,0xBCCA}, {0x7E1F,0xE5D5}, {0x7E20,0x5446}, {0x7E21,0xE5D2},
{0x7E22,0xE5D8}, {0x7E23,0xE5D1}, {0x7E26,0xBDC4}, {0x7E27,0x5447}, {0x7E28,0x5448},
{0x7E2B,0xCBA5}, {0x7E2C,0x5449}, {0x7E2D,0x544A}, {0x7E2E,0xBDCC}, {0x7E2F,0x544B},
{0x7E31,0xE5D4}, {0x7E32,0xE5E0}, {0x7E33,0x544C}, {0x7E35,0xE5DC}, {0x7E36,0x544D},
{0x7E37,0xE5DF}, {0x7E39,0xE5DD}, {0x7E3A,0xE5E1}, {0x7E3B,0xE5DB}, {0x7E3D,0xE5C1},
{0x7E3E,0xC0D3}, {0x7E3F,0x544E}, {0x7E41,0xC8CB}, {0x7E43,0xE5DE}, {0x7E44,0x544F},
{0x7E45,0x5450}, {0x7E46,0xE5D9}, {0x7E47,0x5451}, {0x7E4A,0xC1A1}, {0x7E4B,0xB7D2},
// {0x7E52,0xFBD3}, alternative
{0x7E4D,0xBDAB}, {0x7E4E,0x5452}, {0x7E50,0x5453}, {0x7E52,0x5454}, {0x7E54,0xBFA5},
{0x7E55,0xC1B6}, {0x7E56,0xE5E4}, {0x7E58,0x5455}, {0x7E59,0xE5E6}, {0x7E5A,0xE5E7},
{0x7E5D,0xE5E3}, {0x7E5E,0xE5E5}, {0x7E5F,0x5456}, {0x7E61,0x5457}, {0x7E62,0x5458},
{0x7E65,0x5459}, {0x7E66,0xE5DA}, {0x7E67,0xE5E2}, {0x7E69,0xE5EA}, {0x7E6A,0xE5E9},
{0x7E6B,0x545A}, {0x7E6D,0xCBFA}, {0x7E6E,0x545B}, {0x7E6F,0x545C}, {0x7E70,0xB7AB},
{0x7E73,0x545D}, {0x7E78,0x545E}, {0x7E79,0xE5E8}, {0x7E7B,0xE5EC}, {0x7E7C,0xE5EB},
{0x7E7D,0xE5EF}, {0x7E7E,0x545F}, {0x7E7F,0xE5F1}, {0x7E81,0x5460}, {0x7E82,0xBBBC},
{0x7E83,0xE5ED}, {0x7E86,0x5461}, {0x7E87,0x5462}, {0x7E88,0xE5F2}, {0x7E89,0xE5F3},
// {0x7E8A,0xF9A1}, alternative
{0x7E8A,0x5463}, {0x7E8C,0xE5F4}, {0x7E8D,0x5464}, {0x7E8E,0xE5FA}, {0x7E8F,0xC5BB},
{0x7E90,0xE5F6}, {0x7E91,0x5465}, {0x7E92,0xE5F5}, {0x7E93,0xE5F7}, {0x7E94,0xE5F8},
{0x7E95,0x5466}, {0x7E96,0xE5F9}, {0x7E98,0x5467}, {0x7E9A,0x5468}, {0x7E9B,0xE5FB},
{0x7E9C,0xE5FC}, {0x7E9D,0x5469}, {0x7E9E,0x546A}, {0x7F36,0xB4CC}, {0x7F38,0xE5FD},
{0x7F3A,0xE5FE}, {0x7F3B,0x546C}, {0x7F3C,0x546B}, {0x7F3D,0x546D}, {0x7F3E,0x546E},
// {0x7F47,0xFBD4}, alternative
{0x7F3F,0x546F}, {0x7F43,0x5470}, {0x7F44,0x5471}, {0x7F45,0xE6A1}, {0x7F47,0x5472},
{0x7F4C,0xE6A2}, {0x7F4D,0xE6A3}, {0x7F4E,0xE6A4}, {0x7F4F,0x5473}, {0x7F50,0xE6A5},
{0x7F51,0xE6A6}, {0x7F52,0x5474}, {0x7F53,0x5475}, {0x7F54,0xE6A8}, {0x7F55,0xE6A7},
{0x7F58,0xE6A9}, {0x7F5B,0x5476}, {0x7F5C,0x5477}, {0x7F5D,0x5478}, {0x7F5F,0xE6AA},
{0x7F60,0xE6AB}, {0x7F61,0x5479}, {0x7F63,0x547A}, {0x7F64,0x547B}, {0x7F65,0x547C},
{0x7F66,0x547D}, {0x7F67,0xE6AE}, {0x7F68,0xE6AC}, {0x7F69,0xE6AD}, {0x7F6A,0xBAE1},
{0x7F6B,0xB7D3}, {0x7F6D,0x547E}, {0x7F6E,0xC3D6}, {0x7F70,0xC8B3}, {0x7F71,0x5521},
{0x7F72,0xBDF0}, {0x7F75,0xC7CD}, {0x7F77,0xC8ED}, {0x7F78,0xE6AF}, {0x7F79,0xD8ED},
{0x7F7D,0x5522}, {0x7F7E,0x5523}, {0x7F7F,0x5524}, {0x7F80,0x5525}, {0x7F82,0xE6B0},
{0x7F83,0xE6B2}, {0x7F85,0xCDE5}, {0x7F86,0xE6B1}, {0x7F87,0xE6B4}, {0x7F88,0xE6B3},
{0x7F8A,0xCDD3}, {0x7F8B,0x5526}, {0x7F8C,0xE6B5}, {0x7F8D,0x5527}, {0x7F8E,0xC8FE},
{0x7F8F,0x5528}, {0x7F90,0x5529}, {0x7F91,0x552A}, {0x7F94,0xE6B6}, {0x7F96,0x552B},
{0x7F97,0x552C}, {0x7F9A,0xE6B9}, {0x7F9C,0x552D}, {0x7F9D,0xE6B8}, {0x7F9E,0xE6B7},
// {0x7FA1,0xFBD5}, alternative
{0x7FA1,0x552E}, {0x7FA2,0x552F}, {0x7FA3,0xE6BA}, {0x7FA4,0xB7B2}, {0x7FA6,0x5530},
{0x7FA8,0xC1A2}, {0x7FA9,0xB5C1}, {0x7FAA,0x5531}, {0x7FAD,0x5532}, {0x7FAE,0xE6BE},
{0x7FAF,0xE6BB}, {0x7FB2,0xE6BC}, {0x7FB4,0x5533}, {0x7FB6,0xE6BF}, {0x7FB8,0xE6C0},
{0x7FB9,0xE6BD}, {0x7FBC,0x5534}, {0x7FBD,0xB1A9}, {0x7FBF,0x5535}, {0x7FC0,0x5536},
{0x7FC1,0xB2A7}, {0x7FC3,0x5537}, {0x7FC5,0xE6C2}, {0x7FC6,0xE6C3}, {0x7FC8,0x5538},
{0x7FCA,0xE6C4}, {0x7FCC,0xCDE2}, {0x7FCE,0x5539}, {0x7FCF,0x553A}, {0x7FD2,0xBDAC},
{0x7FD4,0xE6C6}, {0x7FD5,0xE6C5}, {0x7FDB,0x553B}, {0x7FDF,0x553C}, {0x7FE0,0xBFE9},
{0x7FE1,0xE6C7}, {0x7FE3,0x553D}, {0x7FE5,0x553E}, {0x7FE6,0xE6C8}, {0x7FE8,0x553F},
{0x7FE9,0xE6C9}, {0x7FEB,0xB4E5}, {0x7FEC,0x5540}, {0x7FEE,0x5541}, {0x7FEF,0x5542},
{0x7FF0,0xB4CD}, {0x7FF2,0x5543}, {0x7FF3,0xE6CA}, {0x7FF9,0xE6CB}, {0x7FFA,0x5544},
{0x7FFB,0xCBDD}, {0x7FFC,0xCDE3}, {0x7FFD,0x5545}, {0x7FFE,0x5546}, {0x7FFF,0x5547},
{0x8000,0xCDD4}, {0x8001,0xCFB7}, {0x8003,0xB9CD}, {0x8004,0xE6CE}, {0x8005,0xBCD4},
{0x8006,0xE6CD}, {0x8007,0x5548}, {0x8008,0x5549}, {0x800A,0x554A}, {0x800B,0xE6CF},
{0x800C,0xBCA9}, {0x800D,0x554B}, {0x800E,0x554C}, {0x800F,0x554D}, {0x8010,0xC2D1},
{0x8011,0x554E}, {0x8012,0xE6D0}, {0x8013,0x554F}, {0x8014,0x5550}, {0x8015,0xB9CC},
{0x8016,0x5551}, {0x8017,0xCCD7}, {0x8018,0xE6D1}, {0x8019,0xE6D2}, {0x801C,0xE6D3},
{0x801D,0x5552}, {0x801E,0x5553}, {0x801F,0x5554}, {0x8020,0x5555}, {0x8021,0xE6D4},
{0x8024,0x5556}, {0x8026,0x5557}, {0x8028,0xE6D5}, {0x802C,0x5558}, {0x802E,0x5559},
{0x8030,0x555A}, {0x8033,0xBCAA}, {0x8034,0x555B}, {0x8035,0x555C}, {0x8036,0xCCED},
{0x8037,0x555D}, {0x8039,0x555E}, {0x803A,0x555F}, {0x803B,0xE6D7}, {0x803C,0x5560},
{0x803D,0xC3BF}, {0x803E,0x5561}, {0x803F,0xE6D6}, {0x8040,0x5562}, {0x8044,0x5563},
{0x8046,0xE6D9}, {0x804A,0xE6D8}, {0x8052,0xE6DA}, {0x8056,0xC0BB}, {0x8058,0xE6DB},
{0x805A,0xE6DC}, {0x805E,0xCAB9}, {0x805F,0xE6DD}, {0x8060,0x5564}, {0x8061,0xC1EF},
{0x8062,0xE6DE}, {0x8064,0x5565}, {0x8066,0x5566}, {0x8068,0xE6DF}, {0x806D,0x5567},
{0x806F,0xCEFE}, {0x8070,0xE6E2}, {0x8071,0x5568}, {0x8072,0xE6E1}, {0x8073,0xE6E0},
{0x8074,0xC4B0}, {0x8075,0x5569}, {0x8076,0xE6E3}, {0x8077,0xBFA6}, {0x8079,0xE6E4},
{0x807D,0xE6E5}, {0x807E,0xCFB8}, {0x807F,0xE6E6}, {0x8081,0x556A}, {0x8084,0xE6E7},
{0x8085,0xE6E9}, {0x8086,0xE6E8}, {0x8087,0xC8A5}, {0x8088,0x556B}, {0x8089,0xC6F9},
{0x808B,0xCFBE}, {0x808C,0xC8A9}, {0x808E,0x556C}, {0x8093,0xE6EB}, {0x8096,0xBED3},
{0x8098,0xC9AA}, {0x809A,0xE6EC}, {0x809B,0xE6EA}, {0x809C,0x556D}, {0x809D,0xB4CE},
{0x809E,0x556E}, {0x80A1,0xB8D4}, {0x80A2,0xBBE8}, {0x80A5,0xC8EE}, {0x80A6,0x556F},
{0x80A7,0x5570}, {0x80A9,0xB8AA}, {0x80AA,0xCBC3}, {0x80AB,0x5571}, {0x80AC,0xE6EF},
{0x80AD,0xE6ED}, {0x80AF,0xB9CE}, {0x80B1,0xB9CF}, {0x80B2,0xB0E9}, {0x80B4,0xBAE8},
{0x80B8,0x5572}, {0x80B9,0x5573}, {0x80BA,0xC7D9}, {0x80C3,0xB0DF}, {0x80C4,0xE6F4},
{0x80C6,0xC3C0}, {0x80C8,0x5574}, {0x80CC,0xC7D8}, {0x80CD,0x5575}, {0x80CE,0xC2DB},
{0x80CF,0x5576}, {0x80D2,0x5577}, {0x80D4,0x5578}, {0x80D5,0x5579}, {0x80D6,0xE6F6},
{0x80D7,0x557A}, {0x80D8,0x557B}, {0x80D9,0xE6F2}, {0x80DA,0xE6F5}, {0x80DB,0xE6F0},
{0x80DD,0xE6F3}, {0x80DE,0xCBA6}, {0x80E0,0x557C}, {0x80E1,0xB8D5}, {0x80E4,0xB0FD},
{0x80E5,0xE6F1}, {0x80ED,0x557D}, {0x80EE,0x557E}, {0x80EF,0xE6F8}, {0x80F0,0x5621},
{0x80F1,0xE6F9}, {0x80F2,0x5622}, {0x80F3,0x5623}, {0x80F4,0xC6B9}, {0x80F6,0x5624},
{0x80F8,0xB6BB}, {0x80F9,0x5625}, {0x80FA,0x5626}, {0x80FC,0xE7A6}, {0x80FD,0xC7BD},
{0x80FE,0x5627}, {0x8102,0xBBE9}, {0x8103,0x5628}, {0x8105,0xB6BC}, {0x8106,0xC0C8},
{0x8107,0xCFC6}, {0x8108,0xCCAE}, {0x8109,0xE6F7}, {0x810A,0xC0D4}, {0x810B,0x5629},
{0x8116,0x562A}, {0x8117,0x562B}, {0x8118,0x562C}, {0x811A,0xB5D3}, {0x811B,0xE6FA},
{0x811C,0x562D}, {0x811E,0x562E}, {0x8120,0x562F}, {0x8123,0xE6FC}, {0x8124,0x5630},
{0x8127,0x5631}, {0x8129,0xE6FB}, {0x812C,0x5632}, {0x812F,0xE6FD}, {0x8130,0x5633},
{0x8131,0xC3A6}, {0x8133,0xC7BE}, {0x8135,0x5634}, {0x8139,0xC4B1}, {0x813A,0x5635},
{0x813C,0x5636}, {0x813E,0xE7A3}, {0x8145,0x5637}, {0x8146,0xE7A2}, {0x8147,0x5638},
{0x814A,0x5639}, {0x814B,0xE6FE}, {0x814C,0x563A}, {0x814E,0xBFD5}, {0x8150,0xC9E5},
{0x8151,0xE7A5}, {0x8152,0x563B}, {0x8153,0xE7A4}, {0x8154,0xB9D0}, {0x8155,0xCFD3},
{0x8157,0x563C}, {0x815F,0xE7B5}, {0x8160,0x563D}, {0x8161,0x563E}, {0x8165,0xE7A9},
{0x8166,0xE7AA}, {0x8167,0x563F}, {0x8168,0x5640}, {0x8169,0x5641}, {0x816B,0xBCF0},
{0x816D,0x5642}, {0x816E,0xE7A8}, {0x816F,0x5643}, {0x8170,0xB9F8}, {0x8171,0xE7A7},
{0x8174,0xE7AB}, {0x8177,0x5644}, {0x8178,0xC4B2}, {0x8179,0xCAA2}, {0x817A,0xC1A3},
{0x817F,0xC2DC}, {0x8180,0xE7AF}, {0x8181,0x5645}, {0x8182,0xE7B0}, {0x8183,0xE7AC},
{0x8184,0x5647}, {0x8185,0x5648}, {0x8186,0x5649}, {0x8188,0xE7AD}, {0x818A,0xE7AE},
{0x818B,0x564A}, {0x818E,0x564B}, {0x818F,0xB9D1}, {0x8190,0x5646}, {0x8193,0xE7B6},
{0x8195,0xE7B2}, {0x8196,0x564C}, {0x8198,0x564D}, {0x819A,0xC9E6}, {0x819B,0x564E},
{0x819C,0xCBEC}, {0x819D,0xC9A8}, {0x819E,0x564F}, {0x81A0,0xE7B1}, {0x81A2,0x5650},
{0x81A3,0xE7B4}, {0x81A4,0xE7B3}, {0x81A8,0xCBC4}, {0x81A9,0xE7B7}, {0x81AE,0x5651},
{0x81B0,0xE7B8}, {0x81B2,0x5652}, {0x81B3,0xC1B7}, {0x81B4,0x5653}, {0x81B5,0xE7B9},
{0x81B8,0xE7BB}, {0x81BA,0xE7BF}, {0x81BB,0x5654}, {0x81BD,0xE7BC}, {0x81BE,0xE7BA},
{0x81BF,0xC7BF}, {0x81C0,0xE7BD}, {0x81C2,0xE7BE}, {0x81C3,0x5656}, {0x81C5,0x5657},
{0x81C6,0xB2B2}, {0x81C8,0xE7C5}, {0x81C9,0xE7C0}, {0x81CA,0x5658}, {0x81CB,0x5655},
{0x81CD,0xE7C1}, {0x81CE,0x5659}, {0x81CF,0x565A}, {0x81D1,0xE7C2}, {0x81D3,0xC2A1},
{0x81D5,0x565B}, {0x81D7,0x565C}, {0x81D8,0xE7C4}, {0x81D9,0xE7C3}, {0x81DA,0xE7C6},
{0x81DB,0x565D}, {0x81DD,0x565E}, {0x81DE,0x565F}, {0x81DF,0xE7C7}, {0x81E0,0xE7C8},
{0x81E1,0x5660}, {0x81E3,0xBFC3}, {0x81E4,0x5661}, {0x81E5,0xB2E9}, {0x81E7,0xE7C9},
{0x81E8,0xCED7}, {0x81EA,0xBCAB}, {0x81EB,0x5662}, {0x81EC,0x5663}, {0x81ED,0xBDAD},
{0x81F0,0x5664}, {0x81F1,0x5665}, {0x81F2,0x5666}, {0x81F3,0xBBEA}, {0x81F4,0xC3D7},
{0x81F5,0x5667}, {0x81F6,0x5668}, {0x81F8,0x5669}, {0x81F9,0x566A}, {0x81FA,0xE7CA},
{0x81FB,0xE7CB}, {0x81FC,0xB1B1}, {0x81FD,0x566B}, {0x81FE,0xE7CC}, {0x81FF,0x566C},
{0x8200,0x566D}, {0x8201,0xE7CD}, {0x8202,0xE7CE}, {0x8203,0x566E}, {0x8205,0xE7CF},
{0x8207,0xE7D0}, {0x8208,0xB6BD}, {0x8209,0xDAAA}, {0x820A,0xE7D1}, {0x820C,0xC0E5},
{0x820D,0xE7D2}, {0x820E,0xBCCB}, {0x820F,0x566F}, {0x8210,0xE7D3}, {0x8212,0xD0B0},
{0x8213,0x5670}, {0x8214,0x5671}, {0x8216,0xE7D4}, {0x8217,0xCADE}, {0x8218,0xB4DC},
{0x8219,0x5672}, {0x821A,0x5673}, {0x821B,0xC1A4}, {0x821C,0xBDD8}, {0x821D,0x5674},
{0x821E,0xC9F1}, {0x821F,0xBDAE}, {0x8221,0x5675}, {0x8222,0x5676}, {0x8228,0x5677},
{0x8229,0xE7D5}, {0x822A,0xB9D2}, {0x822B,0xE7D6}, {0x822C,0xC8CC}, {0x822E,0xE7E4},
{0x8232,0x5678}, {0x8233,0xE7D8}, {0x8234,0x5679}, {0x8235,0xC2C9}, {0x8236,0xC7F5},
{0x8237,0xB8BF}, {0x8238,0xE7D7}, {0x8239,0xC1A5}, {0x823A,0x567A}, {0x8240,0xE7D9},
{0x8243,0x567B}, {0x8244,0x567C}, {0x8245,0x567D}, {0x8246,0x567E}, {0x8247,0xC4FA},
{0x824B,0x5721}, {0x824E,0x5722}, {0x824F,0x5723}, {0x8251,0x5724}, {0x8256,0x5725},
{0x8258,0xE7DB}, {0x8259,0xE7DA}, {0x825A,0xE7DD}, {0x825C,0x5726}, {0x825D,0xE7DC},
{0x825F,0xE7DE}, {0x8260,0x5727}, {0x8262,0xE7E0}, {0x8263,0x5728}, {0x8264,0xE7DF},
{0x8266,0xB4CF}, {0x8267,0x5729}, {0x8268,0xE7E1}, {0x826A,0xE7E2}, {0x826B,0xE7E3},
{0x826D,0x572A}, {0x826E,0xBAB1}, {0x826F,0xCEC9}, {0x8271,0xE7E5}, {0x8272,0xBFA7},
{0x8274,0x572B}, {0x8276,0xB1F0}, {0x8277,0xE7E6}, {0x8278,0xE7E7}, {0x827B,0x572C},
{0x827D,0x572D}, {0x827E,0xE7E8}, {0x827F,0x572E}, {0x8280,0x572F}, {0x8281,0x5730},
{0x8283,0x5731}, {0x8284,0x5732}, {0x8287,0x5733}, {0x8289,0x5734}, {0x828A,0x5735},
{0x828B,0xB0F2}, {0x828D,0xE7E9}, {0x828E,0x5736}, {0x8291,0x5737}, {0x8292,0xE7EA},
{0x8294,0x5738}, {0x8296,0x5739}, {0x8298,0x573A}, {0x8299,0xC9E7}, {0x829A,0x573B},
{0x829B,0x573C}, {0x829D,0xBCC7}, {0x829F,0xE7EC}, {0x82A0,0x573D}, {0x82A1,0x573E},
{0x82A3,0x573F}, {0x82A4,0x5740}, {0x82A5,0xB3A9}, {0x82A6,0xB0B2}, {0x82A7,0x5741},
{0x82A8,0x5742}, {0x82A9,0x5743}, {0x82AA,0x5744}, {0x82AB,0xE7EB}, {0x82AC,0xE7EE},
{0x82AD,0xC7CE}, {0x82AE,0x5745}, {0x82AF,0xBFC4}, {0x82B0,0x5746}, {0x82B1,0xB2D6},
{0x82B2,0x5747}, {0x82B3,0xCBA7}, {0x82B4,0x5748}, {0x82B7,0x5749}, {0x82B8,0xB7DD},
{0x82B9,0xB6DC}, {0x82BA,0x574A}, {0x82BB,0xE7ED}, {0x82BC,0x574B}, {0x82BD,0xB2EA},
{0x82BE,0x574C}, {0x82BF,0x574D}, {0x82C5,0xB4A3}, {0x82C6,0x574E}, {0x82D0,0x574F},
{0x82D1,0xB1F1}, {0x82D2,0xE7F2}, {0x82D3,0xCEEA}, {0x82D4,0xC2DD}, {0x82D5,0x5750},
{0x82D7,0xC9C4}, {0x82D9,0xE7FE}, {0x82DA,0x5751}, {0x82DB,0xB2D7}, {0x82DC,0xE7FC},
{0x82DE,0xE7FA}, {0x82DF,0xE7F1}, {0x82E0,0x5752}, {0x82E1,0xE7EF}, {0x82E2,0x5753},
{0x82E3,0xE7F0}, {0x82E4,0x5754}, {0x82E5,0xBCE3}, {0x82E6,0xB6EC}, {0x82E7,0xC3F7},
{0x82E8,0x5755}, {0x82EA,0x5756}, {0x82EB,0xC6D1}, {0x82ED,0x5757}, {0x82EF,0x5758},
{0x82F1,0xB1D1}, {0x82F3,0xE7F4}, {0x82F4,0xE7F3}, {0x82F6,0x5759}, {0x82F7,0x575A},
{0x82F9,0xE7F9}, {0x82FA,0xE7F5}, {0x82FB,0xE7F8}, {0x82FD,0x575B}, {0x82FE,0x575C},
// {0x8301,0xFBD7}, alternative
{0x8300,0x575D}, {0x8301,0x575E}, {0x8302,0xCCD0}, {0x8303,0xE7F7}, {0x8304,0xB2D8},
{0x8305,0xB3FD}, {0x8306,0xE7FB}, {0x8307,0x575F}, {0x8308,0x5760}, {0x8309,0xE7FD},
{0x830A,0x5761}, {0x830B,0x5762}, {0x830E,0xB7D4}, {0x8316,0xE8A3}, {0x8317,0xE8AC},
{0x8318,0xE8AD}, {0x831B,0x5764}, {0x831C,0xB0AB}, {0x831D,0x5765}, {0x831E,0x5766},
{0x831F,0x5767}, {0x8321,0x5768}, {0x8322,0x5769}, {0x8323,0xE8B4}, {0x8328,0xB0F1},
{0x832B,0xE8AB}, {0x832C,0x576A}, {0x832D,0x576B}, {0x832E,0x576C}, {0x832F,0xE8AA},
{0x8330,0x576D}, {0x8331,0xE8A5}, {0x8332,0xE8A4}, {0x8333,0x576E}, {0x8334,0xE8A2},
{0x8335,0xE8A1}, {0x8336,0xC3E3}, {0x8337,0x576F}, {0x8338,0xC2FB}, {0x8339,0xE8A7},
{0x833A,0x5770}, {0x833C,0x5771}, {0x833D,0x5772}, {0x8340,0xE8A6}, {0x8342,0x5773},
{0x8343,0x5774}, {0x8344,0x5775}, {0x8345,0xE8A9}, {0x8347,0x5776}, {0x8349,0xC1F0},
{0x834A,0xB7D5}, {0x834D,0x5777}, {0x834E,0x5778}, {0x834F,0xB1C1}, {0x8350,0xE8A8},
{0x8351,0x5779}, {0x8352,0xB9D3}, {0x8353,0x583E}, {0x8354,0x5763}, {0x8355,0x577A},
{0x8356,0x577B}, {0x8357,0x577C}, {0x8358,0xC1F1},
{0x8362,0x745f},
{0x8370,0x577D}, {0x8373,0xE8BA},
{0x8375,0xE8BB}, {0x8377,0xB2D9}, {0x8378,0x577E}, {0x837B,0xB2AE}, {0x837C,0xE8B8},
// {0x837F,0xFBD9}, alternative
{0x837D,0x5821}, {0x837F,0x5822}, {0x8380,0x5823}, {0x8382,0x5824}, {0x8384,0x5825},
{0x8385,0xE8AE}, {0x8386,0x5826}, {0x8387,0xE8B6}, {0x8389,0xE8BD}, {0x838A,0xE8B7},
{0x838D,0x5827}, {0x838E,0xE8B5}, {0x8392,0x5828}, {0x8393,0xE7F6}, {0x8394,0x5829},
{0x8395,0x582A}, {0x8396,0xE8B3}, {0x8398,0x582B}, {0x8399,0x582C}, {0x839A,0xE8AF},
{0x839B,0x582D}, {0x839C,0x582E}, {0x839D,0x582F}, {0x839E,0xB4D0}, {0x839F,0xE8B1},
{0x83A0,0xE8BC}, {0x83A2,0xE8B2}, {0x83A6,0x5830}, {0x83A7,0x5831}, {0x83A8,0xE8BE},
{0x83A9,0x5832}, {0x83AA,0xE8B0}, {0x83AB,0xC7FC}, {0x83AC,0x5833}, {0x83AD,0x584C},
{0x83B1,0xCDE9}, {0x83B5,0xE8B9}, {0x83BD,0xE8CF}, {0x83BE,0x5834}, {0x83BF,0x5835},
// {0x83C7,0xFBDA}, alternative
{0x83C0,0x5836}, {0x83C1,0xE8C7}, {0x83C5,0xBFFB}, {0x83C7,0x5837}, {0x83C9,0x5838},
{0x83CA,0xB5C6}, {0x83CC,0xB6DD}, {0x83CE,0xE8C2}, {0x83CF,0x5839}, {0x83D0,0x583A},
{0x83D1,0x583B}, {0x83D3,0xB2DB}, {0x83D4,0x583C}, {0x83D6,0xBED4}, {0x83D8,0xE8C5},
{0x83DC,0xBADA}, {0x83DD,0x583D}, {0x83DF,0xC5D1}, {0x83E0,0xE8CA}, {0x83E8,0x583F},
{0x83E9,0xCAEE}, {0x83EA,0x5840}, {0x83EB,0xE8C1}, {0x83EF,0xB2DA}, {0x83F0,0xB8D6},
// {0x83F6,0xFBDB}, alternative
{0x83F1,0xC9A9}, {0x83F2,0xE8CB}, {0x83F4,0xE8BF}, {0x83F6,0x5841}, {0x83F7,0xE8C8},
{0x83F8,0x5842}, {0x83F9,0x5843}, {0x83FB,0xE8D2}, {0x83FC,0x5844}, {0x83FD,0xE8C3},
{0x8401,0x5845}, {0x8403,0xE8C4}, {0x8404,0xC6BA}, {0x8406,0x5846}, {0x8407,0xE8C9},
{0x840A,0x5847}, {0x840B,0xE8C6}, {0x840C,0xCBA8}, {0x840D,0xE8CC}, {0x840E,0xB0E0},
{0x840F,0x5848}, {0x8411,0x5849}, {0x8413,0xE8C0}, {0x8415,0x584A}, {0x8419,0x584B},
{0x8420,0xE8CE}, {0x8422,0xE8CD}, {0x8429,0xC7EB}, {0x842A,0xE8D4}, {0x842C,0xE8DF},
{0x842F,0x584D}, {0x8431,0xB3FE}, {0x8435,0xE8E2}, {0x8438,0xE8D0}, {0x8439,0x584E},
{0x843C,0xE8D5}, {0x843D,0xCDEE}, {0x8445,0x584F}, {0x8446,0xE8DE}, {0x8447,0x5850},
// {0x8448,0xFBDC}, alternative
{0x8448,0x5851}, {0x8449,0xCDD5}, {0x844A,0x5852}, {0x844D,0x5853}, {0x844E,0xCEAA},
{0x844F,0x5854}, {0x8451,0x5855}, {0x8452,0x5856}, {0x8456,0x5857}, {0x8457,0xC3F8},
{0x8458,0x5858}, {0x8459,0x5859}, {0x845A,0x585A}, {0x845B,0xB3EB}, {0x845C,0x585B},
{0x8460,0x585C}, {0x8461,0xC9F2}, {0x8462,0xE8E4}, {0x8463,0xC6A1}, {0x8464,0x585D},
{0x8465,0x585E}, {0x8466,0xB0B1}, {0x8467,0x585F}, {0x8469,0xE8DD}, {0x846A,0x5860},
{0x846B,0xE8D9}, {0x846C,0xC1F2}, {0x846D,0xE8D3}, {0x846E,0xE8DB}, {0x846F,0xE8E0},
{0x8470,0x5861}, {0x8471,0xC7AC}, {0x8473,0x5862}, {0x8474,0x5863}, {0x8475,0xB0AA},
{0x8476,0x5864}, {0x8477,0xE8D8}, {0x8478,0x5865}, {0x8479,0xE8E1}, {0x847A,0xC9F8},
{0x847C,0x5866}, {0x847D,0x5867}, {0x8481,0x5868}, {0x8482,0xE8DC}, {0x8484,0xE8D7},
{0x8485,0x5869}, {0x848B,0xBED5}, {0x8490,0xBDAF}, {0x8492,0x586A}, {0x8493,0x586B},
{0x8494,0xBCAC}, {0x8495,0x586C}, {0x8499,0xCCD8}, {0x849C,0xC9C7}, {0x849E,0x586D},
{0x849F,0xE8E7}, {0x84A1,0xE8F0}, {0x84A6,0x586E}, {0x84A8,0x586F}, {0x84A9,0x5870},
{0x84AA,0x5871}, {0x84AD,0xE8DA}, {0x84AF,0x5872}, {0x84B1,0x5873}, {0x84B2,0xB3F7},
// {0x84B4,0xFBDD}, alternative
{0x84B4,0x5874}, {0x84B8,0xBEF8}, {0x84B9,0xE8E5}, {0x84BA,0x5875}, {0x84BB,0xE8EA},
{0x84BC,0xC1F3}, {0x84BD,0x5876}, {0x84BE,0x5877}, {0x84BF,0xE8E6}, {0x84C0,0x5878},
{0x84C1,0xE8ED}, {0x84C2,0x5879}, {0x84C4,0xC3DF}, {0x84C6,0xE8EE}, {0x84C7,0x587A},
{0x84C8,0x587B}, {0x84C9,0xCDD6}, {0x84CA,0xE8E3}, {0x84CB,0xB3B8}, {0x84CC,0x587C},
{0x84CD,0xE8E9}, {0x84CF,0x587D}, {0x84D0,0xE8EC}, {0x84D1,0xCCAC}, {0x84D3,0x587E},
// {0x84DC,0xF9A5}, alternative
{0x84D6,0xE8EF}, {0x84D9,0xE8E8}, {0x84DA,0xE8EB}, {0x84DC,0x5921}, {0x84E7,0x5922},
{0x84EA,0x5923}, {0x84EC,0xCBA9}, {0x84EE,0xCFA1}, {0x84EF,0x5924}, {0x84F0,0x5925},
{0x84F1,0x5926}, {0x84F2,0x5927}, {0x84F4,0xE8F3}, {0x84F7,0x5928}, {0x84FA,0x592A},
{0x84FB,0x592B}, {0x84FC,0xE8FA}, {0x84FD,0x592C}, {0x84FF,0xE8F2}, {0x8500,0xBCC3},
{0x8502,0x592D}, {0x8503,0x592E}, {0x8506,0xE8D1}, {0x8507,0x592F}, {0x850C,0x5930},
{0x850E,0x5931}, {0x8510,0x5932}, {0x8511,0xCACE}, {0x8513,0xCCA2}, {0x8514,0xE8F9},
{0x8515,0xE8F8}, {0x8517,0xE8F4}, {0x8518,0xE8F5}, {0x851A,0xB1B6}, {0x851C,0x5933},
{0x851E,0x5934}, {0x851F,0xE8F7}, {0x8521,0xE8F1}, {0x8522,0x5935}, {0x8523,0x5936},
{0x8524,0x5937}, {0x8525,0x5938}, {0x8526,0xC4D5}, {0x8527,0x5939}, {0x852A,0x593A},
{0x852B,0x593B}, {0x852C,0xE8F6}, {0x852D,0xB0FE}, {0x852F,0x593C}, {0x8532,0x5929},
{0x8533,0x593D}, {0x8534,0x593E}, {0x8535,0xC2A2}, {0x8536,0x593F}, {0x853D,0xCAC3},
{0x853F,0x5940}, {0x8540,0xE8FB}, {0x8541,0xE9A1}, {0x8543,0xC8D9}, {0x8546,0x5941},
{0x8548,0xE8FE}, {0x8549,0xBED6}, {0x854A,0xBCC9}, {0x854B,0xE9A3}, {0x854E,0xB6BE},
// {0x8553,0xFBDE}, alternative
{0x854F,0x5942}, {0x8550,0x5943}, {0x8551,0x5944}, {0x8552,0x5945}, {0x8553,0x5946},
// {0x8559,0xFBDF}, alternative
{0x8555,0xE9A4}, {0x8556,0x5947}, {0x8557,0xC9F9}, {0x8558,0xE8FD}, {0x8559,0x5948},
{0x855A,0xE8D6}, {0x855C,0x5949}, {0x855D,0x594A}, {0x855E,0x594B}, {0x855F,0x594C},
{0x8560,0x594D}, {0x8561,0x594E}, {0x8562,0x594F}, {0x8563,0xE8FC}, {0x8564,0x5950},
// {0x856B,0xFBE0}, alternative
{0x8568,0xCFCF}, {0x8569,0xC6A2}, {0x856A,0xC9F3}, {0x856B,0x5951}, {0x856D,0xE9AB},
{0x856F,0x5952}, {0x8577,0xE9B1}, {0x8579,0x5953}, {0x857A,0x5954}, {0x857B,0x5955},
{0x857D,0x5956}, {0x857E,0xE9B2}, {0x857F,0x5957}, {0x8580,0xE9A5}, {0x8581,0x5958},
{0x8584,0xC7F6}, {0x8585,0x5959}, {0x8586,0x595A}, {0x8587,0xE9AF}, {0x8588,0xE9A7},
{0x8589,0x595B}, {0x858A,0xE9A9}, {0x858B,0x595C}, {0x858C,0x595D}, {0x858F,0x595E},
{0x8590,0xE9B3}, {0x8591,0xE9A8}, {0x8593,0x595F}, {0x8594,0xE9AC}, {0x8597,0xB1F2},
{0x8598,0x5960}, {0x8599,0xC6E5}, {0x859B,0xE9AD}, {0x859C,0xE9B0}, {0x859D,0x5961},
{0x859F,0x5962}, {0x85A0,0x5963}, {0x85A2,0x5964}, {0x85A4,0xE9A6}, {0x85A5,0x5965},
{0x85A6,0xC1A6}, {0x85A7,0x5966}, {0x85A8,0xE9AA}, {0x85A9,0xBBA7}, {0x85AA,0xBFC5},
{0x85AB,0xB7B0}, {0x85AC,0xCCF4}, {0x85AD,0x5974}, {0x85AE,0xCCF9}, {0x85AF,0xBDF2},
{0x85B0,0x7461},
{0x85B4,0x5967}, {0x85B6,0x5968}, {0x85B7,0x5969}, {0x85B8,0x596A}, {0x85B9,0xE9B7},
{0x85BA,0xE9B5}, {0x85BC,0x596B}, {0x85BD,0x596C}, {0x85BE,0x596D}, {0x85BF,0x596E},
{0x85C1,0xCFCE}, {0x85C2,0x596F}, {0x85C7,0x5970}, {0x85C9,0xE9B4}, {0x85CA,0x5971},
{0x85CB,0x5972}, {0x85CD,0xCDF5}, {0x85CE,0x5973}, {0x85CF,0xE9B6}, {0x85D0,0xE9B8},
{0x85D5,0xE9B9}, {0x85D8,0x5975}, {0x85DA,0x5976}, {0x85DC,0xE9BC}, {0x85DD,0xE9BA},
{0x85DF,0x5977}, {0x85E0,0x5978}, {0x85E4,0xC6A3}, {0x85E5,0xE9BB}, {0x85E6,0x5979},
{0x85E8,0x597A}, {0x85E9,0xC8CD}, {0x85EA,0xE9AE}, {0x85ED,0x597B}, {0x85F3,0x597C},
{0x85F6,0x597D}, {0x85F7,0xBDF3}, {0x85F9,0xE9BD}, {0x85FA,0xE9C2}, {0x85FB,0xC1F4},
{0x85FC,0x597E}, {0x85FE,0xE9C1}, {0x85FF,0x5A21}, {0x8600,0x5A22}, {0x8602,0xE9A2},
{0x8604,0x5A23}, {0x8605,0x5A24}, {0x8606,0xE9C3}, {0x8607,0xC1C9}, {0x860A,0xE9BE},
{0x860B,0xE9C0}, {0x860D,0x5A25}, {0x860E,0x5A26}, {0x8610,0x5A27}, {0x8611,0x5A28},
{0x8612,0x5A29}, {0x8613,0xE9BF}, {0x8616,0xDDB1}, {0x8617,0xDDA2}, {0x8618,0x5A2A},
{0x8619,0x5A2B}, {0x861A,0xE9C5}, {0x861B,0x5A2C}, {0x861E,0x5A2D}, {0x8621,0x5A2E},
{0x8622,0xE9C4}, {0x8627,0x5A2F}, {0x8629,0x5A30}, {0x862D,0xCDF6}, {0x862F,0xE2BC},
{0x8630,0xE9C6}, {0x8636,0x5A31}, {0x8638,0x5A32}, {0x863A,0x5A33}, {0x863C,0x5A34},
{0x863D,0x5A35}, {0x863F,0xE9C7}, {0x8640,0x5A36}, {0x8641,0x3866}, {0x8642,0x5A37},
{0x8646,0x5A38}, {0x864D,0xE9C8}, {0x864E,0xB8D7}, {0x8650,0xB5D4}, {0x8652,0x5A39},
{0x8653,0x5A3A}, {0x8654,0xE9CA}, {0x8655,0xD1DD}, {0x8656,0x5A3B}, {0x8657,0x5A3C},
{0x8658,0x5A3D}, {0x8659,0x5A3E}, {0x865A,0xB5F5}, {0x865C,0xCEBA}, {0x865D,0x5A3F},
{0x865E,0xB6F3}, {0x865F,0xE9CB}, {0x8660,0x5A40}, {0x8661,0x5A41}, {0x8662,0x5A42},
{0x8663,0x5A43}, {0x8664,0x5A44}, {0x8667,0xE9CC}, {0x8669,0x5A45}, {0x866B,0xC3EE},
{0x866C,0x5A46}, {0x866F,0x5A47}, {0x8671,0xE9CD}, {0x8675,0x5A48}, {0x8676,0x5A49},
{0x8677,0x5A4A}, {0x8679,0xC6FA}, {0x867A,0x5A4B}, {0x867B,0xB0BA}, {0x8688,0x5A6D},
{0x868A,0xB2E3}, {0x868B,0xE9D2}, {0x868C,0xE9D3}, {0x868D,0x5A4C}, {0x8691,0x5A4D},
{0x8693,0xE9CE}, {0x8695,0xBBBD}, {0x8696,0x5A4E}, {0x8698,0x5A4F}, {0x869A,0x5A50},
{0x869C,0x5A51}, {0x86A1,0x5A52}, {0x86A3,0xE9CF}, {0x86A4,0xC7C2}, {0x86A6,0x5A53},
{0x86A7,0x5A54}, {0x86A8,0x5A55}, {0x86A9,0xE9D0}, {0x86AA,0xE9D1}, {0x86AB,0xE9DB},
{0x86AD,0x5A56}, {0x86AF,0xE9D5}, {0x86B0,0xE9D8}, {0x86B1,0x5A57}, {0x86B3,0x5A58},
{0x86B4,0x5A59}, {0x86B5,0x5A5A}, {0x86B6,0xE9D4}, {0x86B7,0x5A5B}, {0x86B8,0x5A5C},
{0x86B9,0x5A5D}, {0x86BF,0x5A5E}, {0x86C0,0x5A5F}, {0x86C1,0x5A60}, {0x86C3,0x5A61},
{0x86C4,0xE9D6}, {0x86C5,0x5A62}, {0x86C6,0xE9D7}, {0x86C7,0xBCD8}, {0x86C9,0xE9D9},
{0x86CB,0xC3C1}, {0x86CD,0xB7D6}, {0x86CE,0xB3C2}, {0x86D1,0x5A63}, {0x86D2,0x5A64},
{0x86D4,0xE9DC}, {0x86D5,0x5A65}, {0x86D7,0x5A66}, {0x86D9,0xB3BF}, {0x86DA,0x5A67},
{0x86DB,0xE9E1}, {0x86DC,0x5A68}, {0x86DE,0xE9DD}, {0x86DF,0xE9E0}, {0x86E0,0x5A69},
{0x86E3,0x5A6A}, {0x86E4,0xC8BA}, {0x86E5,0x5A6B}, {0x86E7,0x5A6C}, {0x86E9,0xE9DE},
{0x86EC,0xE9DF}, {0x86ED,0xC9C8}, {0x86EE,0xC8DA}, {0x86EF,0xE9E2}, {0x86F8,0xC2FD},
{0x86F9,0xE9EC}, {0x86FA,0x5A6E}, {0x86FB,0xE9E8}, {0x86FC,0x5A6F}, {0x86FD,0x5A70},
{0x86FE,0xB2EB}, {0x8700,0xE9E6}, {0x8702,0xCBAA}, {0x8703,0xE9E7}, {0x8704,0x5A71},
{0x8705,0x5A72}, {0x8706,0xE9E4}, {0x8707,0x5A73}, {0x8708,0xE9E5}, {0x8709,0xE9EA},
{0x870A,0xE9ED}, {0x870B,0x5A74}, {0x870D,0xE9EB}, {0x870E,0x5A75}, {0x870F,0x5A76},
{0x8710,0x5A77}, {0x8711,0xE9E9}, {0x8712,0xE9E3}, {0x8713,0x5A78}, {0x8714,0x5A79},
{0x8718,0xC3D8}, {0x8719,0x5A7A}, {0x871A,0xE9F4}, {0x871C,0xCCAA}, {0x871E,0x5A7B},
{0x871F,0x5A7C}, {0x8721,0x5A7D}, {0x8723,0x5A7E}, {0x8725,0xE9F2}, {0x8728,0x5B21},
{0x8729,0xE9F3}, {0x872E,0x5B22}, {0x872F,0x5B23}, {0x8731,0x5B24}, {0x8732,0x5B25},
{0x8734,0xE9EE}, {0x8737,0xE9F0}, {0x8739,0x5B26}, {0x873A,0x5B27}, {0x873B,0xE9F1},
{0x873C,0x5B28}, {0x873D,0x5B29}, {0x873E,0x5B2A}, {0x873F,0xE9EF}, {0x8740,0x5B2B},
{0x8743,0x5B2C}, {0x8745,0x5B2D}, {0x8749,0xC0E6}, {0x874B,0xCFB9}, {0x874C,0xE9F8},
{0x874D,0x5B2E}, {0x874E,0xE9F9}, {0x8753,0xEAA1}, {0x8755,0xBFAA}, {0x8757,0xE9FB},
{0x8758,0x5B2F}, {0x8759,0xE9FE}, {0x875D,0x5B30}, {0x875F,0xE9F6}, {0x8760,0xE9F5},
{0x8761,0x5B31}, {0x8763,0xEAA2}, {0x8764,0x5B32}, {0x8765,0x5B33}, {0x8766,0xB2DC},
{0x8768,0xE9FC}, {0x876A,0xEAA3}, {0x876E,0xE9FD}, {0x876F,0x5B34}, {0x8771,0x5B35},
{0x8772,0x5B36}, {0x8774,0xE9FA}, {0x8776,0xC4B3}, {0x8778,0xE9F7}, {0x877B,0x5B37},
{0x877F,0xC7E8}, {0x8782,0xEAA7}, {0x8783,0x5B38}, {0x8784,0x5B39}, {0x8785,0x5B3A},
{0x8786,0x5B3B}, {0x8787,0x5B3C}, {0x8788,0x5B3D}, {0x8789,0x5B3E}, {0x878B,0x5B3F},
{0x878C,0x5B40}, {0x878D,0xCDBB}, {0x8790,0x5B41}, {0x8793,0x5B42}, {0x8795,0x5B43},
{0x8797,0x5B44}, {0x8798,0x5B45}, {0x8799,0x5B46}, {0x879E,0x5B47}, {0x879F,0xEAA6},
{0x87A0,0x5B48}, {0x87A2,0xEAA5}, {0x87A3,0x5B49}, {0x87A7,0x5B4A}, {0x87AB,0xEAAE},
{0x87AC,0x5B4B}, {0x87AD,0x5B4C}, {0x87AE,0x5B4D}, {0x87AF,0xEAA8}, {0x87B1,0x5B4E},
{0x87B3,0xEAB0}, {0x87B5,0x5B4F}, {0x87BA,0xCDE6}, {0x87BB,0xEAB3}, {0x87BD,0xEAAA},
{0x87BE,0x5B50}, {0x87BF,0x5B51}, {0x87C0,0xEAAB}, {0x87C1,0x5B52}, {0x87C4,0xEAAF},
{0x87C6,0xEAB2}, {0x87C7,0xEAB1}, {0x87C8,0x5B53}, {0x87C9,0x5B54}, {0x87CA,0x5B55},
{0x87CB,0xEAA9}, {0x87CE,0x5B56}, {0x87D0,0xEAAC}, {0x87D2,0xEABD}, {0x87D5,0x5B57},
{0x87D6,0x5B58}, {0x87D9,0x5B59}, {0x87DA,0x5B5A}, {0x87DC,0x5B5B}, {0x87DF,0x5B5C},
{0x87E0,0xEAB6}, {0x87E2,0x5B5D}, {0x87E3,0x5B5E}, {0x87E4,0x5B5F}, {0x87EA,0x5B60},
{0x87EB,0x5B61}, {0x87ED,0x5B62}, {0x87EF,0xEAB4}, {0x87F1,0x5B63}, {0x87F2,0xEAB5},
{0x87F3,0x5B64}, {0x87F6,0xEABA}, {0x87F7,0xEABB}, {0x87F8,0x5B65}, {0x87F9,0xB3AA},
{0x87FA,0x5B66}, {0x87FB,0xB5C2}, {0x87FE,0xEAB9}, {0x87FF,0x5B67}, {0x8801,0x5B68},
{0x8803,0x5B69}, {0x8805,0xEAA4}, {0x8806,0x5B6A},
{0x8807,0x7464},
{0x8809,0x5B6B}, {0x880A,0x5B6C},
{0x880B,0x5B6D}, {0x880D,0xEAB8}, {0x880E,0xEABC}, {0x880F,0xEAB7}, {0x8810,0x5B6E},
{0x8811,0xEABE}, {0x8812,0x5B70}, {0x8813,0x5B71}, {0x8814,0x5B72}, {0x8815,0xEAC0},
{0x8816,0xEABF}, {0x8818,0x5B73}, {0x8819,0x5B6F}, {0x881A,0x5B74}, {0x881B,0x5B75},
{0x881C,0x5B76}, {0x881E,0x5B77}, {0x881F,0x5B78}, {0x8821,0xEAC2}, {0x8822,0xEAC1},
{0x8823,0xE9DA}, {0x8827,0xEAC6}, {0x8828,0x5B79}, {0x882D,0x5B7A}, {0x882E,0x5B7B},
{0x8830,0x5B7C}, {0x8831,0xEAC3}, {0x8832,0x5B7D}, {0x8835,0x5B7E}, {0x8836,0xEAC4},
{0x8839,0xEAC5}, {0x883A,0x5C21}, {0x883B,0xEAC7}, {0x883C,0x5C22}, {0x8840,0xB7EC},
{0x8841,0x5C23}, {0x8842,0xEAC9}, {0x8843,0x5C24}, {0x8844,0xEAC8}, {0x8845,0x5C25},
{0x8846,0xBDB0}, {0x8848,0x5C26}, {0x8849,0x5C27}, {0x884A,0x5C28}, {0x884B,0x5C29},
{0x884C,0xB9D4}, {0x884D,0xDEA7}, {0x884E,0x5C2A}, {0x8851,0x5C2B}, {0x8852,0xEACA},
{0x8853,0xBDD1}, {0x8855,0x5C2C}, {0x8856,0x5C2D}, {0x8857,0xB3B9}, {0x8858,0x5C2E},
{0x8859,0xEACB}, {0x885A,0x5C2F}, {0x885B,0xB1D2}, {0x885C,0x5C30}, {0x885D,0xBED7},
{0x885E,0xEACC}, {0x885F,0x5C31}, {0x8860,0x5C32}, {0x8861,0xB9D5}, {0x8862,0xEACD},
{0x8863,0xB0E1}, {0x8864,0x5C33}, {0x8868,0xC9BD}, {0x8869,0x5C34}, {0x886B,0xEACE},
{0x8870,0xBFEA}, {0x8871,0x5C35}, {0x8872,0xEAD5}, {0x8875,0xEAD2}, {0x8877,0xC3EF},
{0x8879,0x5C36}, {0x887B,0x5C37}, {0x887D,0xEAD3}, {0x887E,0xEAD0}, {0x887F,0xB6DE},
{0x8880,0x5C38}, {0x8881,0xEACF}, {0x8882,0xEAD6}, {0x8888,0xB7B6}, {0x888B,0xC2DE},
{0x888D,0xEADC}, {0x8892,0xEAD8}, {0x8896,0xC2B5}, {0x8897,0xEAD7}, {0x8898,0x5C39},
{0x8899,0xEADA}, {0x889A,0x5C3A}, {0x889B,0x5C3B}, {0x889C,0x5C3C}, {0x889E,0xEAD1},
{0x889F,0x5C3D}, {0x88A0,0x5C3E}, {0x88A2,0xEADB}, {0x88A4,0xEADD}, {0x88A8,0x5C3F},
{0x88AA,0x5C40}, {0x88AB,0xC8EF}, {0x88AE,0xEAD9}, {0x88B0,0xEADE}, {0x88B1,0xEAE0},
{0x88B4,0xB8D3}, {0x88B5,0xEAD4}, {0x88B7,0xB0C1}, {0x88BA,0x5C41}, {0x88BD,0x5C42},
{0x88BE,0x5C43}, {0x88BF,0xEADF}, {0x88C0,0x5C44}, {0x88C1,0xBADB}, {0x88C2,0xCEF6},
{0x88C3,0xEAE1}, {0x88C4,0xEAE2}, {0x88C5,0xC1F5}, {0x88CA,0x5C45}, {0x88CB,0x5C46},
{0x88CC,0x5C47}, {0x88CD,0x5C48}, {0x88CE,0x5C49}, {0x88CF,0xCEA2}, {0x88D1,0x5C4A},
{0x88D2,0x5C4B}, {0x88D3,0x5C4C}, {0x88D4,0xEAE3}, {0x88D5,0xCDB5}, {0x88D8,0xEAE4},
{0x88D9,0xEAE5}, {0x88DB,0x5C4D}, {0x88DC,0xCAE4}, {0x88DD,0xEAE6}, {0x88DE,0x5C4E},
{0x88DF,0xBAC0}, {0x88E1,0xCEA3}, {0x88E7,0x5C4F}, {0x88E8,0xEAEB}, {0x88EF,0x5C50},
{0x88F0,0x5C51}, {0x88F1,0x5C52}, {0x88F2,0xEAEC}, {0x88F3,0xBED8}, {0x88F4,0xEAEA},
// {0x88F5,0xFBE6}, alternative
{0x88F5,0x5C53}, {0x88F7,0x5C54}, {0x88F8,0xCDE7}, {0x88F9,0xEAE7}, {0x88FC,0xEAE9},
{0x88FD,0xC0BD}, {0x88FE,0xBFFE}, {0x8901,0x5C55}, {0x8902,0xEAE8}, {0x8904,0xEAED},
{0x8906,0x5C56}, {0x8907,0xCAA3}, {0x890A,0xEAEF}, {0x890C,0xEAEE}, {0x890D,0x5C57},
{0x890E,0x5C58}, {0x890F,0x5C59}, {0x8910,0xB3EC}, {0x8912,0xCBAB}, {0x8913,0xEAF0},
{0x8915,0x5C5A}, {0x8916,0x5C5B}, {0x8918,0x5C5C}, {0x8919,0x5C5D}, {0x891A,0x5C5E},
// {0x891C,0xF9A2}, alternative
{0x891C,0x5C5F}, {0x891D,0xEAFC}, {0x891E,0xEAF2}, {0x8920,0x5C60}, {0x8925,0xEAF3},
{0x8926,0x5C61}, {0x8927,0x5C62}, {0x8928,0x5C63}, {0x892A,0xEAF4}, {0x892B,0xEAF5},
{0x8930,0x5C64}, {0x8931,0x5C65}, {0x8932,0x5C66}, {0x8935,0x5C67}, {0x8936,0xEAF9},
{0x8938,0xEAFA}, {0x8939,0x5C68}, {0x893A,0x5C69}, {0x893B,0xEAF8}, {0x893E,0x5C6A},
{0x8940,0x5C6B}, {0x8941,0xEAF6}, {0x8942,0x5C6C}, {0x8943,0xEAF1}, {0x8944,0xEAF7},
{0x8945,0x5C6D}, {0x8946,0x5C6E}, {0x8949,0x5C6F}, {0x894C,0xEAFB}, {0x894D,0xF0B7},
{0x894F,0x5C70}, {0x8952,0x5C71}, {0x8956,0xB2A8}, {0x8957,0x5C72}, {0x895A,0x5C73},
{0x895B,0x5C74}, {0x895C,0x5C75}, {0x895E,0xEAFE}, {0x895F,0xB6DF}, {0x8960,0xEAFD},
{0x8961,0x5C76}, {0x8962,0x5C77}, {0x8963,0x5C78}, {0x8964,0xEBA2}, {0x8966,0xEBA1},
{0x896A,0xEBA4}, {0x896B,0x5C79}, {0x896D,0xEBA3}, {0x896E,0x5C7A}, {0x896F,0xEBA5},
{0x8970,0x5C7B}, {0x8972,0xBDB1}, {0x8973,0x5C7C}, {0x8974,0xEBA6}, {0x8975,0x5C7D},
{0x8977,0xEBA7}, {0x897A,0x5C7E}, {0x897B,0x5D21}, {0x897C,0x5D22}, {0x897D,0x5D23},
{0x897E,0xEBA8}, {0x897F,0xC0BE}, {0x8981,0xCDD7}, {0x8983,0xEBA9}, {0x8986,0xCAA4},
{0x8987,0xC7C6}, {0x8988,0xEBAA}, {0x8989,0x5D24}, {0x898A,0xEBAB}, {0x898B,0xB8AB},
{0x898D,0x5D25}, {0x898F,0xB5AC}, {0x8990,0x5D26}, {0x8993,0xEBAC}, {0x8994,0x5D27},
{0x8995,0x5D28}, {0x8996,0xBBEB}, {0x8997,0xC7C1}, {0x8998,0xEBAD}, {0x899A,0xB3D0},
{0x899B,0x5D29}, {0x899C,0x5D2A}, {0x899F,0x5D2B}, {0x89A0,0x5D2C}, {0x89A1,0xEBAE},
{0x89A5,0x5D2D}, {0x89A6,0xEBB0}, {0x89A7,0xCDF7}, {0x89A9,0xEBAF}, {0x89AA,0xBFC6},
{0x89AC,0xEBB1}, {0x89AF,0xEBB2}, {0x89B0,0x5D2E}, {0x89B2,0xEBB3}, {0x89B3,0xB4D1},
{0x89B4,0x5D2F}, {0x89B5,0x5D30}, {0x89B6,0x5D31}, {0x89B7,0x5D32}, {0x89BA,0xEBB4},
{0x89BC,0x5D33}, {0x89BD,0xEBB5}, {0x89BF,0xEBB6}, {0x89C0,0xEBB7}, {0x89D2,0xB3D1},
{0x89D4,0x5D34}, {0x89D5,0x5D35}, {0x89D6,0x5D36}, {0x89D7,0x5D37}, {0x89D8,0x5D38},
{0x89DA,0xEBB8}, {0x89DC,0xEBB9}, {0x89DD,0xEBBA}, {0x89E3,0xB2F2}, {0x89E5,0x5D39},
{0x89E6,0xBFA8}, {0x89E7,0xEBBB}, {0x89E9,0x5D3A}, {0x89EB,0x5D3B}, {0x89ED,0x5D3C},
{0x89F1,0x5D3D}, {0x89F3,0x5D3E}, {0x89F4,0xEBBC}, {0x89F6,0x5D3F}, {0x89F8,0xEBBD},
{0x89F9,0x5D40}, {0x89FD,0x5D41}, {0x89FF,0x5D42}, {0x8A00,0xB8C0}, {0x8A02,0xC4FB},
{0x8A03,0xEBBE}, {0x8A04,0x5D43}, {0x8A05,0x5D44}, {0x8A07,0x5D45}, {0x8A08,0xB7D7},
{0x8A0A,0xBFD6}, {0x8A0C,0xEBC1}, {0x8A0E,0xC6A4}, {0x8A0F,0x5D46}, {0x8A10,0xEBC0},
// {0x8A12,0xFBE7}, alternative
{0x8A11,0x5D47}, {0x8A12,0x5D48}, {0x8A13,0xB7B1}, {0x8A14,0x5D49}, {0x8A15,0x5D4A},
{0x8A16,0xEBBF}, {0x8A17,0xC2F7}, {0x8A18,0xB5AD}, {0x8A1B,0xEBC2}, {0x8A1D,0xEBC3},
{0x8A1E,0x5D4B}, {0x8A1F,0xBED9}, {0x8A20,0x5D4C}, {0x8A22,0x5D4D}, {0x8A23,0xB7ED},
{0x8A24,0x5D4E}, {0x8A25,0xEBC4}, {0x8A26,0x5D4F}, {0x8A2A,0xCBAC}, {0x8A2B,0x5D50},
{0x8A2C,0x5D51}, {0x8A2D,0xC0DF}, {0x8A2F,0x5D52}, {0x8A31,0xB5F6}, {0x8A33,0xCCF5},
// {0x8A37,0xFBE8}, alternative
{0x8A34,0xC1CA}, {0x8A35,0x5D53}, {0x8A36,0xEBC5}, {0x8A37,0x5D54}, {0x8A3A,0xBFC7},
{0x8A3B,0xC3F0}, {0x8A3C,0xBEDA}, {0x8A3D,0x5D55}, {0x8A3E,0x5D56}, {0x8A40,0x5D57},
{0x8A41,0xEBC6}, {0x8A43,0x5D58}, {0x8A45,0x5D59}, {0x8A46,0xEBC9}, {0x8A47,0x5D5A},
{0x8A48,0xEBCA}, {0x8A49,0x5D5B}, {0x8A4D,0x5D5C}, {0x8A4E,0x5D5D}, {0x8A50,0xBABE},
{0x8A51,0xC2C2}, {0x8A52,0xEBC8}, {0x8A53,0x5D5E}, {0x8A54,0xBEDB}, {0x8A55,0xC9BE},
{0x8A56,0x5D5F}, {0x8A57,0x5D60}, {0x8A58,0x5D61}, {0x8A5B,0xEBC7}, {0x8A5C,0x5D62},
{0x8A5D,0x5D63}, {0x8A5E,0xBBEC}, {0x8A60,0xB1D3}, {0x8A61,0x5D64}, {0x8A62,0xEBCE},
{0x8A63,0xB7D8}, {0x8A65,0x5D65}, {0x8A66,0xBBEE}, {0x8A67,0x5D66}, {0x8A69,0xBBED},
{0x8A6B,0xCFCD}, {0x8A6C,0xEBCD}, {0x8A6D,0xEBCC}, {0x8A6E,0xC1A7}, {0x8A70,0xB5CD},
{0x8A71,0xCFC3}, {0x8A72,0xB3BA}, {0x8A73,0xBEDC}, {0x8A75,0x5D67}, {0x8A76,0x5D68},
// {0x8A79,0xFBE9}, alternative
{0x8A77,0x5D69}, {0x8A79,0x5D6A}, {0x8A7A,0x5D6B}, {0x8A7B,0x5D6C}, {0x8A7C,0xEBCB},
{0x8A7E,0x5D6D}, {0x8A7F,0x5D6E}, {0x8A80,0x5D6F}, {0x8A82,0xEBD0}, {0x8A83,0x5D70},
{0x8A84,0xEBD1}, {0x8A85,0xEBCF}, {0x8A86,0x5D71}, {0x8A87,0xB8D8}, {0x8A89,0xCDC0},
{0x8A8B,0x5D72}, {0x8A8C,0xBBEF}, {0x8A8D,0xC7A7}, {0x8A8F,0x5D73}, {0x8A90,0x5D74},
{0x8A91,0xEBD4}, {0x8A92,0x5D75}, {0x8A93,0xC0C0}, {0x8A95,0xC3C2}, {0x8A96,0x5D76},
{0x8A97,0x5D77}, {0x8A98,0xCDB6}, {0x8A99,0x5D78}, {0x8A9A,0xEBD7}, {0x8A9E,0xB8EC},
{0x8A9F,0x5D79}, {0x8AA0,0xC0BF}, {0x8AA1,0xEBD3}, {0x8AA3,0xEBD8}, {0x8AA4,0xB8ED},
// {0x8AA7,0xFBEA}, alternative
{0x8AA5,0xEBD5}, {0x8AA6,0xEBD6}, {0x8AA7,0x5D7A}, {0x8AA8,0xEBD2}, {0x8AA9,0x5D7B},
{0x8AAC,0xC0E2}, {0x8AAD,0xC6C9}, {0x8AAE,0x5D7C}, {0x8AAF,0x5D7D}, {0x8AB0,0xC3AF},
{0x8AB2,0xB2DD}, {0x8AB3,0x5D7E}, {0x8AB6,0x5E21}, {0x8AB7,0x5E22}, {0x8AB9,0xC8F0},
// {0x8ABE,0xFBEB}, alternative
{0x8ABB,0x5E23}, {0x8ABC,0xB5C3}, {0x8ABE,0x5E24}, {0x8ABF,0xC4B4}, {0x8AC2,0xEBDB},
{0x8AC3,0x5E25}, {0x8AC4,0xEBD9}, {0x8AC6,0x5E26}, {0x8AC7,0xC3CC}, {0x8AC8,0x5E27},
{0x8AC9,0x5E28}, {0x8ACA,0x5E29}, {0x8ACB,0xC0C1}, {0x8ACC,0xB4D2}, {0x8ACD,0xEBDA},
{0x8ACF,0xBFDB}, {0x8AD1,0x5E2A}, {0x8AD2,0xCECA}, {0x8AD3,0x5E2B}, {0x8AD4,0x5E2C},
{0x8AD5,0x5E2D}, {0x8AD6,0xCFC0}, {0x8AD7,0x5E2E}, {0x8ADA,0xEBDC}, {0x8ADB,0xEBE7},
// {0x8ADF,0xFBEC}, alternative
{0x8ADC,0xC4B5}, {0x8ADD,0x5E2F}, {0x8ADE,0xEBE6}, {0x8ADF,0x5E30}, {0x8AE0,0xEBE3},
{0x8AE1,0xEBEB}, {0x8AE2,0xEBE4}, {0x8AE4,0xEBE0}, {0x8AE6,0xC4FC}, {0x8AE7,0xEBDF},
{0x8AEB,0xEBDD}, {0x8AEC,0x5E31}, {0x8AED,0xCDA1}, {0x8AEE,0xBBF0}, {0x8AF0,0x5E32},
// {0x8AF6,0xFBEE}, alternative
{0x8AF1,0xEBE1}, {0x8AF3,0xEBDE}, {0x8AF4,0x5E33}, {0x8AF5,0x5E34}, {0x8AF6,0x5E35},
{0x8AF7,0xEBE5}, {0x8AF8,0xBDF4}, {0x8AFA,0xB8C1}, {0x8AFC,0x5E36}, {0x8AFE,0xC2FA},
{0x8AFF,0x5E37}, {0x8B00,0xCBC5}, {0x8B01,0xB1DA}, {0x8B02,0xB0E2}, {0x8B04,0xC6A5},
{0x8B05,0x5E38}, {0x8B06,0x5E39}, {0x8B07,0xEBE9}, {0x8B0A,0x5E3F}, {0x8B0B,0x5E3A},
{0x8B0C,0xEBE8}, {0x8B0E,0xC6E6}, {0x8B10,0xEBED}, {0x8B11,0x5E3B}, {0x8B14,0xEBE2},
{0x8B16,0xEBEC}, {0x8B17,0xEBEE}, {0x8B19,0xB8AC}, {0x8B1A,0xEBEA}, {0x8B1B,0xB9D6},
{0x8B1C,0x5E3C}, {0x8B1D,0xBCD5}, {0x8B1E,0x5E3D}, {0x8B1F,0x5E3E}, {0x8B20,0xEBEF},
{0x8B21,0xCDD8}, {0x8B26,0xEBF2}, {0x8B28,0xEBF5}, {0x8B2B,0xEBF3}, {0x8B2C,0xC9B5},
{0x8B2D,0x5E40}, {0x8B30,0x5E41}, {0x8B33,0xEBF0}, {0x8B37,0x5E42}, {0x8B39,0xB6E0},
{0x8B3C,0x5E43}, {0x8B3E,0xEBF4}, {0x8B41,0xEBF6}, {0x8B42,0x5E44}, {0x8B43,0x5E45},
{0x8B44,0x5E46}, {0x8B45,0x5E47}, {0x8B46,0x5E48}, {0x8B48,0x5E49}, {0x8B49,0xEBFA},
{0x8B4C,0xEBF7}, {0x8B4D,0x5E4E}, {0x8B4E,0xEBF9}, {0x8B4F,0xEBF8}, {0x8B52,0x5E4A},
// {0x8B53,0xFBEF}, alternative
{0x8B53,0x5E4B}, {0x8B54,0x5E4C}, {0x8B56,0xEBFB}, {0x8B58,0xBCB1}, {0x8B59,0x5E4D},
{0x8B5A,0xEBFD}, {0x8B5B,0xEBFC}, {0x8B5C,0xC9E8}, {0x8B5E,0x5E4F}, {0x8B5F,0xECA1},
{0x8B63,0x5E50}, {0x8B66,0xB7D9}, {0x8B6B,0xEBFE}, {0x8B6C,0xECA2}, {0x8B6D,0x5E51},
{0x8B6F,0xECA3}, {0x8B70,0xB5C4}, {0x8B71,0xE6C1}, {0x8B72,0xBEF9}, {0x8B74,0xECA4},
{0x8B76,0x5E52}, {0x8B77,0xB8EE}, {0x8B78,0x5E53}, {0x8B79,0x5E54}, {0x8B7C,0x5E55},
{0x8B7D,0xECA5}, {0x8B7E,0x5E56},
{0x8B7F,0x7466},
{0x8B80,0xECA6}, {0x8B81,0x5E57}, {0x8B83,0xBBBE},
{0x8B84,0x5E58}, {0x8B85,0x5E59}, {0x8B8A,0xDACE}, {0x8B8B,0x5E5A}, {0x8B8C,0xECA7},
{0x8B8D,0x5E5B}, {0x8B8E,0xECA8}, {0x8B8F,0x5E5C}, {0x8B90,0xBDB2}, {0x8B92,0xECA9},
{0x8B93,0xECAA}, {0x8B94,0x5E5D}, {0x8B95,0x5E5E}, {0x8B96,0xECAB}, {0x8B99,0xECAC},
{0x8B9A,0xECAD}, {0x8B9C,0x5E5F}, {0x8B9E,0x5E60}, {0x8B9F,0x5E61}, {0x8C37,0xC3AB},
{0x8C38,0x5E62}, {0x8C39,0x5E63}, {0x8C3A,0xECAE}, {0x8C3D,0x5E64}, {0x8C3E,0x5E65},
{0x8C3F,0xECB0}, {0x8C41,0xECAF}, {0x8C45,0x5E66}, {0x8C46,0xC6A6}, {0x8C47,0x5E67},
{0x8C48,0xECB1}, {0x8C49,0x5E68}, {0x8C4A,0xCBAD}, {0x8C4B,0x5E69}, {0x8C4C,0xECB2},
{0x8C4E,0xECB3}, {0x8C4F,0x5E6A}, {0x8C50,0xECB4}, {0x8C51,0x5E6B}, {0x8C53,0x5E6C},
{0x8C54,0x5E6D}, {0x8C55,0xECB5}, {0x8C57,0x5E6E}, {0x8C58,0x5E6F}, {0x8C59,0x5E72},
{0x8C5A,0xC6DA}, {0x8C5B,0x5E70}, {0x8C5D,0x5E71}, {0x8C61,0xBEDD}, {0x8C62,0xECB6},
{0x8C63,0x5E73}, {0x8C64,0x5E74}, {0x8C66,0x5E75}, {0x8C68,0x5E76}, {0x8C69,0x5E77},
{0x8C6A,0xB9EB}, {0x8C6B,0xD0AE}, {0x8C6C,0xECB7}, {0x8C6D,0x5E78}, {0x8C73,0x5E79},
{0x8C75,0x5E7A}, {0x8C76,0x5E7B}, {0x8C78,0xECB8}, {0x8C79,0xC9BF}, {0x8C7A,0xECB9},
{0x8C7B,0x5E7C}, {0x8C7C,0xECC1}, {0x8C7E,0x5E7D}, {0x8C82,0xECBA}, {0x8C85,0xECBC},
{0x8C86,0x5E7E}, {0x8C87,0x5F21}, {0x8C89,0xECBB}, {0x8C8A,0xECBD}, {0x8C8B,0x5F22},
{0x8C8C,0xCBC6}, {0x8C8D,0xECBE}, {0x8C8E,0xECBF}, {0x8C90,0x5F23}, {0x8C92,0x5F24},
{0x8C93,0x5F25}, {0x8C94,0xECC0}, {0x8C98,0xECC2}, {0x8C99,0x5F26}, {0x8C9B,0x5F27},
{0x8C9C,0x5F28}, {0x8C9D,0xB3AD}, {0x8C9E,0xC4E7}, {0x8CA0,0xC9E9}, {0x8CA1,0xBAE2},
{0x8CA2,0xB9D7}, {0x8CA4,0x5F29}, {0x8CA7,0xC9CF}, {0x8CA8,0xB2DF}, {0x8CA9,0xC8CE},
{0x8CAA,0xECC5}, {0x8CAB,0xB4D3}, {0x8CAC,0xC0D5}, {0x8CAD,0xECC4}, {0x8CAE,0xECC9},
{0x8CAF,0xC3F9}, {0x8CB0,0xCCE3}, {0x8CB2,0xECC7}, {0x8CB3,0xECC8}, {0x8CB4,0xB5AE},
{0x8CB6,0xECCA}, {0x8CB7,0xC7E3}, {0x8CB8,0xC2DF}, {0x8CB9,0x5F2A}, {0x8CBA,0x5F2B},
{0x8CBB,0xC8F1}, {0x8CBC,0xC5BD}, {0x8CBD,0xECC6}, {0x8CBF,0xCBC7}, {0x8CC0,0xB2EC},
{0x8CC1,0xECCC}, {0x8CC2,0xCFA8}, {0x8CC3,0xC4C2}, {0x8CC4,0xCFC5}, {0x8CC5,0x5F2C},
{0x8CC6,0x5F2D}, {0x8CC7,0xBBF1}, {0x8CC8,0xECCB}, {0x8CC9,0x5F2E}, {0x8CCA,0xC2B1},
{0x8CCB,0x5F2F}, {0x8CCD,0xECDC}, {0x8CCE,0xC1A8}, {0x8CCF,0x5F30}, {0x8CD1,0xC6F8},
{0x8CD3,0xC9D0}, {0x8CD5,0x5F32}, {0x8CD6,0x5F31}, {0x8CD9,0x5F33}, {0x8CDA,0xECCF},
{0x8CDB,0xBBBF}, {0x8CDC,0xBBF2}, {0x8CDD,0x5F34}, {0x8CDE,0xBEDE}, {0x8CE0,0xC7E5},
{0x8CE1,0x5F35}, {0x8CE2,0xB8AD}, {0x8CE3,0xECCE}, {0x8CE4,0xECCD}, {0x8CE6,0xC9EA},
{0x8CE8,0x5F36}, {0x8CEA,0xBCC1}, {0x8CEC,0x5F37}, {0x8CED,0xC5D2}, {0x8CEF,0x5F38},
// {0x8CF0,0xFBF1}, alternative
{0x8CF0,0x5F39}, {0x8CF2,0x5F3A},
{0x8CF4,0x7467},
{0x8CF5,0x5F3B}, {0x8CF7,0x5F3C}, {0x8CF8,0x5F3D},
{0x8CFA,0xECD1}, {0x8CFB,0xECD2}, {0x8CFC,0xB9D8}, {0x8CFD,0xECD0}, {0x8CFE,0x5F3E},
{0x8CFF,0x5F3F}, {0x8D01,0x5F40}, {0x8D03,0x5F41}, {0x8D04,0xECD3}, {0x8D05,0xECD4},
{0x8D07,0xECD6}, {0x8D08,0xC2A3}, {0x8D09,0x5F42}, {0x8D0A,0xECD5}, {0x8D0B,0xB4E6},
// {0x8D12,0xFBF3}, alternative
{0x8D0D,0xECD8}, {0x8D0F,0xECD7}, {0x8D10,0xECD9}, {0x8D12,0x5F43}, {0x8D13,0xECDB},
{0x8D14,0xECDD}, {0x8D16,0xECDE}, {0x8D17,0x5F44}, {0x8D1B,0x5F45}, {0x8D64,0xC0D6},
{0x8D65,0x5F46}, {0x8D66,0xBCCF}, {0x8D67,0xECDF}, {0x8D69,0x5F47}, {0x8D6B,0xB3D2},
{0x8D6C,0x5F48}, {0x8D6D,0xECE0}, {0x8D6E,0x5F49}, {0x8D70,0xC1F6}, {0x8D71,0xECE1},
{0x8D73,0xECE2}, {0x8D74,0xC9EB},
{0x8D76,0x7468},
{0x8D77,0xB5AF}, {0x8D7F,0x5F4A}, {0x8D81,0xECE3},
{0x8D82,0x5F4B}, {0x8D84,0x5F4C}, {0x8D85,0xC4B6}, {0x8D88,0x5F4D}, {0x8D8A,0xB1DB},
{0x8D8D,0x5F4E}, {0x8D90,0x5F4F}, {0x8D91,0x5F50}, {0x8D95,0x5F51}, {0x8D99,0xECE4},
{0x8D9E,0x5F52}, {0x8D9F,0x5F53}, {0x8DA0,0x5F54}, {0x8DA3,0xBCF1}, {0x8DA6,0x5F55},
{0x8DA8,0xBFF6}, {0x8DAB,0x5F56}, {0x8DAC,0x5F57}, {0x8DAF,0x5F58}, {0x8DB2,0x5F59},
{0x8DB3,0xC2AD}, {0x8DB5,0x5F5A}, {0x8DB7,0x5F5B}, {0x8DB9,0x5F5C}, {0x8DBA,0xECE7},
{0x8DBB,0x5F5D}, {0x8DBC,0x5F6F}, {0x8DBE,0xECE6}, {0x8DC0,0x5F5E}, {0x8DC2,0xECE5},
{0x8DC5,0x5F5F}, {0x8DC6,0x5F60}, {0x8DC7,0x5F61}, {0x8DC8,0x5F62}, {0x8DCA,0x5F63},
{0x8DCB,0xECED}, {0x8DCC,0xECEB}, {0x8DCE,0x5F64}, {0x8DCF,0xECE8}, {0x8DD1,0x5F65},
{0x8DD4,0x5F66}, {0x8DD5,0x5F67}, {0x8DD6,0xECEA}, {0x8DD7,0x5F68}, {0x8DD9,0x5F69},
{0x8DDA,0xECE9}, {0x8DDB,0xECEC}, {0x8DDD,0xB5F7}, {0x8DDF,0xECF0}, {0x8DE1,0xC0D7},
{0x8DE3,0xECF1}, {0x8DE4,0x5F6A}, {0x8DE5,0x5F6B}, {0x8DE7,0x5F6C}, {0x8DE8,0xB8D9},
{0x8DEA,0xECEE}, {0x8DEB,0xECEF}, {0x8DEC,0x5F6D}, {0x8DEF,0xCFA9}, {0x8DF0,0x5F6E},
{0x8DF1,0x5F70}, {0x8DF2,0x5F71}, {0x8DF3,0xC4B7}, {0x8DF4,0x5F72}, {0x8DF5,0xC1A9},
{0x8DFC,0xECF2}, {0x8DFD,0x5F73}, {0x8DFF,0xECF5}, {0x8E01,0x5F74}, {0x8E04,0x5F75},
{0x8E05,0x5F76}, {0x8E06,0x5F77}, {0x8E08,0xECF3}, {0x8E09,0xECF4}, {0x8E0A,0xCDD9},
{0x8E0B,0x5F78}, {0x8E0F,0xC6A7}, {0x8E10,0xECF8}, {0x8E11,0x5F79}, {0x8E14,0x5F7A},
{0x8E16,0x5F7B}, {0x8E1D,0xECF6}, {0x8E1E,0xECF7}, {0x8E1F,0xECF9}, {0x8E20,0x5F7C},
{0x8E21,0x5F7D}, {0x8E22,0x5F7E}, {0x8E23,0x6021}, {0x8E26,0x6022}, {0x8E27,0x6023},
{0x8E2A,0xEDA9}, {0x8E30,0xECFC}, {0x8E31,0x6024}, {0x8E33,0x6025}, {0x8E34,0xECFD},
{0x8E35,0xECFB}, {0x8E36,0x6026}, {0x8E37,0x6027}, {0x8E38,0x6028}, {0x8E39,0x6029},
{0x8E3D,0x602A}, {0x8E40,0x602B}, {0x8E41,0x602C}, {0x8E42,0xECFA}, {0x8E44,0xC4FD},
{0x8E47,0xEDA1}, {0x8E48,0xEDA5}, {0x8E49,0xEDA2}, {0x8E4A,0xECFE}, {0x8E4B,0x602D},
{0x8E4C,0xEDA3}, {0x8E4D,0x602E}, {0x8E4E,0x602F}, {0x8E4F,0x6030}, {0x8E50,0xEDA4},
{0x8E54,0x6031}, {0x8E55,0xEDAB}, {0x8E59,0xEDA6}, {0x8E5B,0x6032}, {0x8E5C,0x6033},
{0x8E5D,0x6034}, {0x8E5E,0x6035}, {0x8E5F,0xC0D8}, {0x8E60,0xEDA8}, {0x8E61,0x6036},
{0x8E62,0x6037}, {0x8E63,0xEDAA}, {0x8E64,0xEDA7}, {0x8E69,0x6038}, {0x8E6C,0x6039},
{0x8E6D,0x603A}, {0x8E6F,0x603B}, {0x8E70,0x603C}, {0x8E71,0x603D}, {0x8E72,0xEDAD},
{0x8E74,0xBDB3}, {0x8E76,0xEDAC}, {0x8E79,0x603E}, {0x8E7A,0x603F}, {0x8E7B,0x6040},
{0x8E7C,0xEDAE}, {0x8E81,0xEDAF}, {0x8E82,0x6041}, {0x8E83,0x6042}, {0x8E84,0xEDB2},
{0x8E85,0xEDB1}, {0x8E87,0xEDB0}, {0x8E89,0x6043}, {0x8E8A,0xEDB4}, {0x8E8B,0xEDB3},
{0x8E8D,0xCCF6}, {0x8E90,0x6044}, {0x8E91,0xEDB6}, {0x8E92,0x6045}, {0x8E93,0xEDB5},
{0x8E94,0xEDB7}, {0x8E95,0x6046}, {0x8E99,0xEDB8}, {0x8E9A,0x6047}, {0x8E9B,0x6048},
{0x8E9D,0x6049}, {0x8E9E,0x604A}, {0x8EA1,0xEDBA}, {0x8EA2,0x604B}, {0x8EA7,0x604C},
{0x8EA9,0x604D}, {0x8EAA,0xEDB9}, {0x8EAB,0xBFC8}, {0x8EAC,0xEDBB}, {0x8EAD,0x604E},
{0x8EAE,0x604F}, {0x8EAF,0xB6ED}, {0x8EB0,0xEDBC}, {0x8EB1,0xEDBE}, {0x8EB3,0x6050},
{0x8EB5,0x6051}, {0x8EBA,0x6052}, {0x8EBB,0x6053}, {0x8EBE,0xEDBF}, {0x8EC0,0x6054},
{0x8EC1,0x6055}, {0x8EC3,0x6056}, {0x8EC4,0x6057}, {0x8EC5,0xEDC0}, {0x8EC6,0xEDBD},
{0x8EC7,0x6058}, {0x8EC8,0xEDC1}, {0x8ECA,0xBCD6}, {0x8ECB,0xEDC2}, {0x8ECC,0xB5B0},
// {0x8ECF,0xFBF6}, alternative
{0x8ECD,0xB7B3}, {0x8ECF,0x6059}, {0x8ED1,0x605A}, {0x8ED2,0xB8AE}, {0x8ED4,0x605B},
{0x8EDB,0xEDC3}, {0x8EDC,0x605C}, {0x8EDF,0xC6F0}, {0x8EE2,0xC5BE}, {0x8EE3,0xEDC4},
{0x8EE8,0x605D}, {0x8EEB,0xEDC7}, {0x8EED,0x6064}, {0x8EEE,0x605E}, {0x8EF0,0x605F},
{0x8EF1,0x6060}, {0x8EF7,0x6061}, {0x8EF8,0xBCB4}, {0x8EF9,0x6062}, {0x8EFA,0x6063},
{0x8EFB,0xEDC6}, {0x8EFC,0xEDC5}, {0x8EFD,0xB7DA}, {0x8EFE,0xEDC8}, {0x8F00,0x6065},
{0x8F02,0x6066}, {0x8F03,0xB3D3}, {0x8F05,0xEDCA}, {0x8F07,0x6067}, {0x8F08,0x6068},
{0x8F09,0xBADC}, {0x8F0A,0xEDC9}, {0x8F0C,0xEDD2}, {0x8F0F,0x6069}, {0x8F10,0x606A},
{0x8F12,0xEDCC}, {0x8F13,0xEDCE}, {0x8F14,0xCAE5}, {0x8F15,0xEDCB}, {0x8F16,0x606B},
{0x8F17,0x606C}, {0x8F18,0x606D}, {0x8F19,0xEDCD}, {0x8F1B,0xEDD1}, {0x8F1C,0xEDCF},
{0x8F1D,0xB5B1}, {0x8F1E,0x606E}, {0x8F1F,0xEDD0}, {0x8F20,0x606F}, {0x8F21,0x6070},
{0x8F23,0x6071}, {0x8F25,0x6072}, {0x8F26,0xEDD3}, {0x8F27,0x6073}, {0x8F28,0x6074},
{0x8F29,0xC7DA}, {0x8F2A,0xCED8}, {0x8F2C,0x6075}, {0x8F2D,0x6076}, {0x8F2E,0x6077},
{0x8F2F,0xBDB4}, {0x8F33,0xEDD4}, {0x8F34,0x6078}, {0x8F35,0x6079}, {0x8F36,0x607A},
{0x8F37,0x607B}, {0x8F38,0xCDA2}, {0x8F39,0xEDD6}, {0x8F3A,0x607C}, {0x8F3B,0xEDD5},
{0x8F3E,0xEDD9}, {0x8F3F,0xCDC1}, {0x8F40,0x607D}, {0x8F41,0x607E}, {0x8F42,0xEDD8},
{0x8F43,0x6121}, {0x8F44,0xB3ED}, {0x8F45,0xEDD7}, {0x8F46,0xEDDC}, {0x8F47,0x6122},
{0x8F49,0xEDDB}, {0x8F4C,0xEDDA}, {0x8F4D,0xC5B2}, {0x8F4E,0xEDDD}, {0x8F4F,0x6123},
{0x8F51,0x6124}, {0x8F52,0x6125}, {0x8F53,0x6126}, {0x8F54,0x6127}, {0x8F55,0x6128},
{0x8F57,0xEDDE}, {0x8F58,0x6129}, {0x8F5C,0xEDDF}, {0x8F5D,0x612A}, {0x8F5E,0x612B},
{0x8F5F,0xB9EC}, {0x8F61,0xB7A5}, {0x8F62,0xEDE0}, {0x8F63,0xEDE1}, {0x8F64,0xEDE2},
{0x8F65,0x612C}, {0x8F9B,0xBFC9}, {0x8F9C,0xEDE3}, {0x8F9D,0x612D}, {0x8F9E,0xBCAD},
{0x8F9F,0xEDE4}, {0x8FA0,0x612E}, {0x8FA1,0x612F}, {0x8FA3,0xEDE5}, {0x8FA4,0x6130},
{0x8FA5,0x6131}, {0x8FA6,0x6132}, {0x8FA7,0xD2A1}, {0x8FA8,0xD1FE}, {0x8FAD,0xEDE6},
{0x8FAE,0xE5F0}, {0x8FAF,0xEDE7}, {0x8FB0,0xC3A4}, {0x8FB1,0xBFAB}, {0x8FB2,0xC7C0},
{0x8FB5,0x6133}, {0x8FB6,0x6134}, {0x8FB7,0xEDE8}, {0x8FB8,0x6135}, {0x8FBA,0xCAD5},
{0x8FBB,0xC4D4}, {0x8FBC,0xB9FE}, {0x8FBE,0x6136}, {0x8FBF,0xC3A9}, {0x8FC0,0x6137},
{0x8FC1,0x6138}, {0x8FC2,0xB1AA}, {0x8FC4,0xCBF8}, {0x8FC5,0xBFD7}, {0x8FC6,0x6139},
{0x8FCA,0x613A}, {0x8FCB,0x613B}, {0x8FCD,0x613C}, {0x8FCE,0xB7DE}, {0x8FD0,0x613D},
{0x8FD1,0xB6E1}, {0x8FD2,0x613E}, {0x8FD3,0x613F}, {0x8FD4,0xCAD6}, {0x8FD5,0x6140},
{0x8FDA,0xEDE9}, {0x8FE0,0x6141}, {0x8FE2,0xEDEB}, {0x8FE3,0x6142}, {0x8FE4,0x6143},
{0x8FE5,0xEDEA}, {0x8FE6,0xB2E0}, {0x8FE8,0x6144}, {0x8FE9,0xC6F6}, {0x8FEA,0xEDEC},
{0x8FEB,0xC7F7}, {0x8FED,0xC5B3}, {0x8FEE,0x6145}, {0x8FEF,0xEDED}, {0x8FF0,0xBDD2},
{0x8FF1,0x6146}, {0x8FF4,0xEDEF}, {0x8FF5,0x6147}, {0x8FF6,0x6148}, {0x8FF7,0xCCC2},
{0x8FF8,0xEDFE}, {0x8FF9,0xEDF1}, {0x8FFA,0xEDF2}, {0x8FFB,0x6149}, {0x8FFD,0xC4C9},
{0x8FFE,0x614A}, {0x9000,0xC2E0}, {0x9001,0xC1F7}, {0x9002,0x614B}, {0x9003,0xC6A8},
{0x9004,0x614C}, {0x9005,0xEDF0}, {0x9006,0xB5D5}, {0x9008,0x614D}, {0x900B,0xEDF9},
{0x900C,0x614E}, {0x900D,0xEDF6}, {0x900E,0xEEA5}, {0x900F,0xC6A9}, {0x9010,0xC3E0},
{0x9011,0xEDF3}, {0x9013,0xC4FE}, {0x9014,0xC5D3}, {0x9015,0xEDF4}, {0x9016,0xEDF8},
{0x9017,0xBFE0}, {0x9018,0x614F}, {0x9019,0xC7E7}, {0x901A,0xC4CC}, {0x901B,0x6150},
{0x901D,0xC0C2}, {0x901E,0xEDF7}, {0x901F,0xC2AE}, {0x9020,0xC2A4}, {0x9021,0xEDF5},
{0x9022,0xB0A9}, {0x9023,0xCFA2}, {0x9027,0xEDFA}, {0x9028,0x6151}, {0x9029,0x6152},
{0x902A,0x6154}, {0x902C,0x6155}, {0x902D,0x6156}, {0x902E,0xC2E1}, {0x902F,0x6153},
{0x9031,0xBDB5}, {0x9032,0xBFCA}, {0x9033,0x6157}, {0x9034,0x6158}, {0x9035,0xEDFC},
{0x9036,0xEDFB}, {0x9037,0x6159}, {0x9038,0xB0EF}, {0x9039,0xEDFD}, {0x903C,0xC9AF},
{0x903E,0xEEA7}, {0x903F,0x615A}, {0x9041,0xC6DB}, {0x9042,0xBFEB}, {0x9043,0x615B},
{0x9044,0x615C}, {0x9045,0xC3D9}, {0x9047,0xB6F8}, {0x9049,0xEEA6}, {0x904A,0xCDB7},
{0x904B,0xB1BF}, {0x904C,0x615D}, {0x904D,0xCAD7}, {0x904E,0xB2E1}, {0x904F,0xEEA1},
{0x9050,0xEEA2}, {0x9051,0xEEA3}, {0x9052,0xEEA4}, {0x9053,0xC6BB}, {0x9054,0xC3A3},
{0x9055,0xB0E3}, {0x9056,0xEEA8}, {0x9058,0xEEA9}, {0x9059,0xF4A3}, {0x905B,0x615E},
{0x905C,0xC2BD}, {0x905D,0x615F}, {0x905E,0xEEAA}, {0x9060,0xB1F3}, {0x9061,0xC1CC},
// {0x9067,0xFBF9}, alternative
{0x9062,0x6160}, {0x9063,0xB8AF}, {0x9065,0xCDDA}, {0x9066,0x6161}, {0x9067,0x6162},
{0x9068,0xEEAB}, {0x9069,0xC5AC}, {0x906C,0x6163}, {0x906D,0xC1F8}, {0x906E,0xBCD7},
{0x906F,0xEEAC}, {0x9070,0x6164}, {0x9072,0xEEAF}, {0x9074,0x6165}, {0x9075,0xBDE5},
{0x9076,0xEEAD}, {0x9077,0xC1AB}, {0x9078,0xC1AA}, {0x9079,0x6166}, {0x907A,0xB0E4},
{0x907C,0xCECB}, {0x907D,0xEEB1}, {0x907F,0xC8F2}, {0x9080,0xEEB3}, {0x9081,0xEEB2},
{0x9082,0xEEB0}, {0x9083,0xE3E4}, {0x9084,0xB4D4}, {0x9085,0x6167}, {0x9087,0xEDEE},
{0x9088,0x6168}, {0x9089,0xEEB5}, {0x908A,0xEEB4}, {0x908B,0x6169}, {0x908C,0x616A},
{0x908E,0x616B}, {0x908F,0xEEB6}, {0x9090,0x616C}, {0x9091,0xCDB8}, {0x9095,0x616D},
{0x9097,0x616E}, {0x9098,0x616F}, {0x9099,0x6170}, {0x909B,0x6171}, {0x90A0,0x6172},
{0x90A1,0x6173}, {0x90A2,0x6174}, {0x90A3,0xC6E1}, {0x90A5,0x6175}, {0x90A6,0xCBAE},
{0x90A8,0xEEB7}, {0x90AA,0xBCD9}, {0x90AF,0xEEB8}, {0x90B0,0x6176}, {0x90B1,0xEEB9},
{0x90B2,0x6177}, {0x90B3,0x6178}, {0x90B4,0x6179}, {0x90B5,0xEEBA}, {0x90B6,0x617A},
{0x90B8,0xC5A1}, {0x90BD,0x617B}, {0x90BE,0x617D}, {0x90C1,0xB0EA}, {0x90C3,0x617E},
{0x90C4,0x6221}, {0x90C5,0x6222}, {0x90C7,0x6223}, {0x90C8,0x6224}, {0x90CA,0xB9D9},
{0x90CC,0x617C}, {0x90CE,0xCFBA}, {0x90D2,0x622D}, {0x90D5,0x6225}, {0x90D7,0x6226},
{0x90D8,0x6227}, {0x90D9,0x6228}, {0x90DB,0xEEBE}, {0x90DC,0x6229}, {0x90DD,0x622A},
{0x90DE,0x746c},
{0x90DF,0x622B}, {0x90E1,0xB7B4}, {0x90E2,0xEEBB}, {0x90E4,0xEEBC}, {0x90E5,0x622C},
{0x90E8,0xC9F4}, {0x90EB,0x622F}, {0x90ED,0xB3D4}, {0x90EF,0x6230}, {0x90F0,0x6231},
{0x90F4,0x6232}, {0x90F5,0xCDB9}, {0x90F6,0x622E}, {0x90F7,0xB6BF}, {0x90FD,0xC5D4},
{0x90FE,0x6233}, {0x90FF,0x6234}, {0x9100,0x6235}, {0x9102,0xEEBF}, {0x9104,0x6236},
{0x9105,0x6237}, {0x9106,0x6238}, {0x9108,0x6239}, {0x910D,0x623A}, {0x9110,0x623B},
{0x9112,0xEEC0}, {0x9114,0x623C},
{0x9115,0x746e},
{0x9116,0x623D}, {0x9117,0x623E}, {0x9118,0x623F},
{0x9119,0xEEC1}, {0x911A,0x6240}, {0x911C,0x6241}, {0x911E,0x6242}, {0x9120,0x6243},
// {0x9127,0xFBFD}, alternative
{0x9122,0x6245}, {0x9123,0x6246}, {0x9125,0x6244}, {0x9127,0x6247}, {0x9129,0x6248},
{0x912D,0xC5A2}, {0x912E,0x6249}, {0x912F,0x624A}, {0x9130,0xEEC3}, {0x9131,0x624B},
{0x9132,0xEEC2}, {0x9134,0x624C}, {0x9136,0x624D}, {0x9137,0x624E}, {0x9139,0x624F},
{0x913A,0x6250}, {0x913C,0x6251}, {0x913D,0x6252}, {0x9143,0x6253}, {0x9147,0x6254},
{0x9148,0x6255}, {0x9149,0xC6D3}, {0x914A,0xEEC4}, {0x914B,0xBDB6}, {0x914C,0xBCE0},
{0x914D,0xC7DB}, {0x914E,0xC3F1}, {0x914F,0x6256}, {0x9152,0xBCF2}, {0x9153,0x6257},
{0x9154,0xBFEC}, {0x9156,0xEEC5}, {0x9157,0x6258}, {0x9158,0xEEC6}, {0x9159,0x6259},
{0x915A,0x625A}, {0x915B,0x625B}, {0x9161,0x625C}, {0x9162,0xBFDD}, {0x9163,0xEEC7},
{0x9164,0x625D}, {0x9165,0xEEC8}, {0x9167,0x625E}, {0x9169,0xEEC9}, {0x916A,0xCDEF},
{0x916C,0xBDB7}, {0x916D,0x625F}, {0x9172,0xEECB}, {0x9173,0xEECA}, {0x9174,0x6260},
{0x9175,0xB9DA}, {0x9177,0xB9F3}, {0x9178,0xBBC0}, {0x9179,0x6261}, {0x917A,0x6262},
{0x917B,0x6263}, {0x9181,0x6264}, {0x9182,0xEECE}, {0x9183,0x6265}, {0x9185,0x6266},
{0x9186,0x6267}, {0x9187,0xBDE6}, {0x9189,0xEECD}, {0x918A,0x6268}, {0x918B,0xEECC},
{0x918D,0xC2E9}, {0x918E,0x6269}, {0x9190,0xB8EF}, {0x9191,0x626A}, {0x9192,0xC0C3},
{0x9193,0x626B}, {0x9194,0x626C}, {0x9195,0x626D}, {0x9197,0xC8B0}, {0x9198,0x626E},
{0x919C,0xBDB9}, {0x919E,0x626F}, {0x91A1,0x6270}, {0x91A2,0xEECF}, {0x91A4,0xBEDF},
{0x91A6,0x6271}, {0x91A8,0x6272}, {0x91AA,0xEED2}, {0x91AB,0xEED0}, {0x91AC,0x6273},
{0x91AD,0x6274}, {0x91AE,0x6275}, {0x91AF,0xEED1}, {0x91B0,0x6276}, {0x91B1,0x6277},
{0x91B2,0x6278}, {0x91B3,0x6279}, {0x91B4,0xEED4}, {0x91B5,0xEED3}, {0x91B6,0x627A},
{0x91B8,0xBEFA}, {0x91BA,0xEED5}, {0x91BB,0x627B}, {0x91BC,0x627C}, {0x91BD,0x627D},
{0x91BF,0x627E}, {0x91C0,0xEED6}, {0x91C1,0xEED7}, {0x91C2,0x6321}, {0x91C3,0x6322},
{0x91C5,0x6323}, {0x91C6,0xC8D0}, {0x91C7,0xBAD3}, {0x91C8,0xBCE1}, {0x91C9,0xEED8},
{0x91CB,0xEED9}, {0x91CC,0xCEA4}, {0x91CD,0xBDC5}, {0x91CE,0xCCEE}, {0x91CF,0xCECC},
{0x91D0,0xEEDA}, {0x91D1,0xB6E2}, {0x91D3,0x6324}, {0x91D4,0x6325}, {0x91D6,0xEEDB},
// {0x91D7,0xFCA1}, alternative
// {0x91DA,0xFBFE}, alternative
{0x91D7,0x6326}, {0x91D8,0xC5A3}, {0x91D9,0x6327}, {0x91DA,0x6328}, {0x91DB,0xEEDE},
// {0x91DE,0xFCA2}, alternative
{0x91DC,0xB3F8}, {0x91DD,0xBFCB}, {0x91DE,0x6329}, {0x91DF,0xEEDC}, {0x91E1,0xEEDD},
// {0x91E4,0xFCA5}, alternative
// {0x91E5,0xFCA6}, alternative
{0x91E3,0xC4E0}, {0x91E4,0x632A}, {0x91E5,0x632B}, {0x91E6,0xCBD5}, {0x91E7,0xB6FC},
// {0x91ED,0xFCA3}, alternative
// {0x91EE,0xFCA4}, alternative
{0x91E9,0x632C}, {0x91EA,0x632D}, {0x91EC,0x632E}, {0x91ED,0x632F}, {0x91EE,0x6330},
{0x91EF,0x6331}, {0x91F0,0x6332}, {0x91F1,0x6333}, {0x91F5,0xEEE0}, {0x91F6,0xEEE1},
{0x91F7,0x6334}, {0x91F9,0x6335}, {0x91FB,0x6336}, {0x91FC,0xEEDF}, {0x91FD,0x6337},
{0x91FF,0xEEE3}, {0x9200,0x6338}, {0x9201,0x6339}, {0x9204,0x633A}, {0x9205,0x633B},
// {0x9206,0xFCA7}, alternative
// {0x920A,0xFCA9}, alternative
{0x9206,0x633C}, {0x9207,0x633D}, {0x9209,0x633E}, {0x920A,0x633F}, {0x920C,0x6340},
// {0x9210,0xFCA8}, alternative
{0x920D,0xC6DF}, {0x920E,0xB3C3}, {0x9210,0x6341}, {0x9211,0xEEE7}, {0x9212,0x6342},
{0x9213,0x6343}, {0x9214,0xEEE4}, {0x9215,0xEEE6}, {0x9216,0x6344}, {0x9218,0x6345},
{0x921C,0x6346}, {0x921D,0x6347}, {0x921E,0xEEE2}, {0x9223,0x6348}, {0x9224,0x6349},
{0x9225,0x634A}, {0x9226,0x634B}, {0x9228,0x634C}, {0x9229,0xEFCF}, {0x922C,0xEEE5},
{0x922E,0x634D}, {0x922F,0x634E}, {0x9230,0x634F}, {0x9233,0x6350}, {0x9234,0xCEEB},
// {0x9239,0xFCB0}, alternative
{0x9235,0x6351}, {0x9236,0x6352}, {0x9237,0xB8DA}, {0x9238,0x6353}, {0x9239,0x6354},
// {0x923A,0xFCAA}, alternative
// {0x923C,0xFCAC}, alternative
// {0x9240,0xFCAB}, alternative
{0x923A,0x6355}, {0x923C,0x6356}, {0x923E,0x6357}, {0x923F,0xEEEF}, {0x9240,0x6358},
{0x9242,0x6359}, {0x9243,0x635A}, {0x9244,0xC5B4}, {0x9245,0xEEEA}, {0x9246,0x635B},
{0x9247,0x635C}, {0x9248,0xEEED}, {0x9249,0xEEEB}, {0x924A,0x635D}, {0x924B,0xEEF0},
// {0x924E,0xFCAD}, alternative
// {0x9251,0xFCAF}, alternative
{0x924D,0x635E}, {0x924E,0x635F}, {0x924F,0x6360}, {0x9250,0xEEF1}, {0x9251,0x6361},
// {0x9259,0xFCAE}, alternative
{0x9257,0xEEE9}, {0x9258,0x6362}, {0x9259,0x6363}, {0x925A,0xEEF6}, {0x925B,0xB1F4},
{0x925C,0x6364}, {0x925D,0x6365}, {0x925E,0xEEE8}, {0x9260,0x6366}, {0x9261,0x6367},
// {0x9267,0xFCB1}, alternative
{0x9262,0xC8AD}, {0x9264,0xEEEC}, {0x9265,0x6368}, {0x9266,0xBEE0}, {0x9267,0x6369},
{0x9268,0x636A}, {0x9269,0x636B}, {0x926E,0x636C}, {0x926F,0x636D}, {0x9270,0x636E},
// {0x9277,0xFCB3}, alternative
// {0x9278,0xFCB4}, alternative
{0x9271,0xB9DB}, {0x9275,0x636F}, {0x9276,0x6370}, {0x9277,0x6371}, {0x9278,0x6372},
{0x9279,0x6373}, {0x927B,0x6374}, {0x927C,0x6375}, {0x927D,0x6376}, {0x927E,0xCBC8},
// {0x9288,0xF9A4}, alternative
{0x927F,0x6377}, {0x9280,0xB6E4}, {0x9283,0xBDC6}, {0x9285,0xC6BC}, {0x9288,0x6378},
{0x9289,0x6379}, {0x928A,0x637A}, {0x928D,0x637B}, {0x928E,0x637C}, {0x9291,0xC1AD},
{0x9292,0x637D}, {0x9293,0xEEF4}, {0x9295,0xEEEE}, {0x9296,0xEEF3}, {0x9297,0x637E},
{0x9298,0xCCC3}, {0x9299,0x6421}, {0x929A,0xC4B8}, {0x929B,0xEEF5}, {0x929C,0xEEF2},
// {0x92A7,0xFCB2}, alternative
{0x929F,0x6422}, {0x92A0,0x6423}, {0x92A4,0x6424}, {0x92A5,0x6425}, {0x92A7,0x6426},
{0x92A8,0x6427}, {0x92AB,0x6428}, {0x92AD,0xC1AC}, {0x92AF,0x6429}, {0x92B2,0x642A},
{0x92B6,0x642B}, {0x92B7,0xEEF9}, {0x92B8,0x642C}, {0x92B9,0xEEF8}, {0x92BA,0x642D},
{0x92BB,0x642E}, {0x92BC,0x642F}, {0x92BD,0x6430}, {0x92BF,0x6431}, {0x92C0,0x6432},
{0x92C1,0x6433}, {0x92C2,0x6434}, {0x92C3,0x6435}, {0x92C5,0x6436}, {0x92C6,0x6437},
{0x92C7,0x6438}, {0x92C8,0x6439}, {0x92CB,0x643A}, {0x92CC,0x643B}, {0x92CD,0x643C},
// {0x92D0,0xFCB8}, alternative
// {0x92D3,0xFCBC}, alternative
{0x92CE,0x643D}, {0x92CF,0xEEF7}, {0x92D0,0x643E}, {0x92D2,0xCBAF}, {0x92D3,0x643F},
// {0x92D5,0xFCBA}, alternative
// {0x92D7,0xFCB6}, alternative
// {0x92D9,0xFCB7}, alternative
{0x92D5,0x6440}, {0x92D7,0x6441}, {0x92D8,0x6442}, {0x92D9,0x6443}, {0x92DC,0x6444},
// {0x92E0,0xFCBB}, alternative
{0x92DD,0x6445}, {0x92DF,0x6446}, {0x92E0,0x6447}, {0x92E1,0x6448}, {0x92E3,0x6449},
// {0x92E7,0xFCB5}, alternative
{0x92E4,0xBDFB}, {0x92E5,0x644A}, {0x92E7,0x644B}, {0x92E8,0x644C}, {0x92E9,0xEEFA},
{0x92EA,0xCADF}, {0x92EC,0x644D}, {0x92ED,0xB1D4}, {0x92EE,0x644E}, {0x92F0,0x644F},
// {0x92F9,0xF9AA}, alternative
{0x92F2,0xC9C6}, {0x92F3,0xC3F2}, {0x92F8,0xB5F8}, {0x92F9,0x6450}, {0x92FA,0xEEFC},
// {0x92FB,0xFCBF}, alternative
// {0x92FF,0xFCC2}, alternative
// {0x9302,0xFCC4}, alternative
{0x92FB,0x6451}, {0x92FC,0xB9DD}, {0x92FF,0x6452}, {0x9300,0x6453}, {0x9302,0x6454},
{0x9306,0xBBAC}, {0x9308,0x6455}, {0x930D,0x6456}, {0x930F,0xEEFB}, {0x9310,0xBFED},
{0x9311,0x6457}, {0x9314,0x6458}, {0x9315,0x6459}, {0x9318,0xBFEE}, {0x9319,0xEFA1},
// {0x931D,0xFCC3}, alternative
// {0x931E,0xFCC1}, alternative
{0x931A,0xEFA3}, {0x931C,0x645A}, {0x931D,0x645B}, {0x931E,0x645C}, {0x931F,0x645D},
// {0x9321,0xFCBE}, alternative
{0x9320,0xBEFB}, {0x9321,0x645E}, {0x9322,0xEFA2}, {0x9323,0xEFA4}, {0x9324,0x645F},
// {0x9325,0xFCBD}, alternative
{0x9325,0x6460}, {0x9326,0xB6D3}, {0x9327,0x6461}, {0x9328,0xC9C5}, {0x9329,0x6462},
{0x932A,0x6463}, {0x932B,0xBCE2}, {0x932C,0xCFA3}, {0x932E,0xEEFE}, {0x932F,0xBAF8},
{0x9332,0xCFBF}, {0x9333,0x6464}, {0x9334,0x6465}, {0x9335,0xEFA6}, {0x9336,0x6466},
{0x9337,0x6467}, {0x933A,0xEFA5}, {0x933B,0xEFA7}, {0x9344,0xEEFD}, {0x9347,0x6468},
// {0x9348,0xF9A3}, alternative
{0x9348,0x6469}, {0x9349,0x646A}, {0x934B,0xC6E9}, {0x934D,0xC5D5}, {0x9350,0x646B},
{0x9351,0x646C}, {0x9352,0x646D}, {0x9354,0xC4D7}, {0x9355,0x646E}, {0x9356,0xEFAC},
// {0x9357,0xFCC6}, alternative
{0x9357,0x646F}, {0x9358,0x6470}, {0x935A,0x6471}, {0x935B,0xC3C3}, {0x935C,0xEFA8},
{0x935E,0x6472}, {0x9360,0xEFA9}, {0x9364,0x6473}, {0x9365,0x6474}, {0x9367,0x6475},
{0x9369,0x6476}, {0x936A,0x6477}, {0x936C,0xB7AD}, {0x936D,0x6478}, {0x936E,0xEFAB},
// {0x9370,0xFCC5}, alternative
{0x936F,0x6479}, {0x9370,0x647A}, {0x9371,0x647B}, {0x9373,0x647C}, {0x9374,0x647D},
{0x9375,0xB8B0}, {0x9376,0x647E}, {0x937A,0x6521}, {0x937C,0xEFAA}, {0x937D,0x6522},
{0x937E,0xBEE1}, {0x937F,0x6523}, {0x9380,0x6524}, {0x9381,0x6525}, {0x9382,0x6526},
{0x9388,0x6527}, {0x938A,0x6528}, {0x938B,0x6529}, {0x938C,0xB3F9}, {0x938D,0x652A},
{0x938F,0x652B}, {0x9392,0x652C}, {0x9394,0xEFB0}, {0x9395,0x652D}, {0x9396,0xBABF},
{0x9397,0xC1F9}, {0x9398,0x652E}, {0x939A,0xC4CA}, {0x939B,0x652F}, {0x939E,0x6530},
// {0x93A4,0xFCC7}, alternative
{0x93A1,0x6531}, {0x93A3,0x6532}, {0x93A4,0x6533}, {0x93A6,0x6534}, {0x93A7,0xB3BB},
{0x93A8,0x6535}, {0x93A9,0x653B}, {0x93AB,0x6536}, {0x93AC,0xEFAE}, {0x93AD,0xEFAF},
{0x93AE,0xC4C3}, {0x93B0,0xEFAD}, {0x93B4,0x6537}, {0x93B5,0x6538}, {0x93B6,0x6539},
{0x93B9,0xEFB1}, {0x93BA,0x653A}, {0x93C1,0x653C}, {0x93C3,0xEFB7}, {0x93C4,0x653D},
// {0x93C6,0xFCC8}, alternative
{0x93C5,0x653E}, {0x93C6,0x653F}, {0x93C7,0x6540}, {0x93C8,0xEFBA}, {0x93C9,0x6541},
{0x93CA,0x6542}, {0x93CB,0x6543}, {0x93CC,0x6544}, {0x93CD,0x6545}, {0x93D0,0xEFB9},
{0x93D1,0xC5AD}, {0x93D3,0x6546}, {0x93D6,0xEFB2}, {0x93D7,0xEFB3}, {0x93D8,0xEFB6},
// {0x93DE,0xFCC9}, alternative
{0x93D9,0x6547}, {0x93DC,0x6548}, {0x93DD,0xEFB8}, {0x93DE,0x6549}, {0x93DF,0x654A},
{0x93E1,0xB6C0}, {0x93E2,0x654B}, {0x93E4,0xEFBB}, {0x93E5,0xEFB5}, {0x93E6,0x654C},
// {0x93F8,0xFCCA}, alternative
{0x93E7,0x654D}, {0x93E8,0xEFB4}, {0x93F7,0x654F}, {0x93F8,0x6550}, {0x93F9,0x654E},
{0x93FA,0x6551}, {0x93FB,0x6552}, {0x93FD,0x6553}, {0x9401,0x6554}, {0x9402,0x6555},
{0x9403,0xEFBF}, {0x9404,0x6556}, {0x9407,0xEFC0}, {0x9408,0x6557}, {0x9409,0x6558},
{0x940D,0x6559}, {0x940E,0x655A}, {0x940F,0x655B}, {0x9410,0xEFC1}, {0x9413,0xEFBE},
{0x9414,0xEFBD}, {0x9415,0x655C}, {0x9416,0x655D}, {0x9417,0x655E}, {0x9418,0xBEE2},
{0x9419,0xC6AA}, {0x941A,0xEFBC}, {0x941F,0x655F}, {0x9421,0xEFC5}, {0x942B,0xEFC3},
// {0x9431,0xFCCB}, alternative
{0x942E,0x6560}, {0x942F,0x6561}, {0x9431,0x6562}, {0x9432,0x6563}, {0x9433,0x6564},
{0x9434,0x6565}, {0x9435,0xEFC4}, {0x9436,0xEFC2}, {0x9438,0xC2F8}, {0x943A,0xEFC6},
{0x943B,0x6566}, {0x943D,0x6568}, {0x943F,0x6567}, {0x9441,0xEFC7}, {0x9443,0x6569},
// {0x9445,0xFCCC}, alternative
// {0x9448,0xFCCD}, alternative
{0x9444,0xEFC9}, {0x9445,0x656A}, {0x9448,0x656B}, {0x944A,0x656C}, {0x944C,0x656D},
{0x9451,0xB4D5}, {0x9452,0xEFC8}, {0x9453,0xCCFA}, {0x9455,0x656E}, {0x9459,0x656F},
{0x945A,0xEFD4}, {0x945B,0xEFCA}, {0x945C,0x6570}, {0x945E,0xEFCD}, {0x945F,0x6571},
{0x9460,0xEFCB}, {0x9461,0x6572}, {0x9462,0xEFCC}, {0x9463,0x6573}, {0x9468,0x6574},
{0x946A,0xEFCE}, {0x946B,0x6575}, {0x946D,0x6576}, {0x946E,0x6577}, {0x946F,0x6578},
{0x9470,0xEFD0}, {0x9471,0x6579}, {0x9472,0x657A}, {0x9475,0xEFD1}, {0x9477,0xEFD2},
{0x947C,0xEFD5}, {0x947D,0xEFD3}, {0x947E,0xEFD6}, {0x947F,0xEFD8}, {0x9481,0xEFD7},
{0x9483,0x657C}, {0x9484,0x657B}, {0x9577,0xC4B9}, {0x9578,0x657D}, {0x9579,0x657E},
{0x957E,0x6621}, {0x9580,0xCCE7}, {0x9582,0xEFD9}, {0x9583,0xC1AE}, {0x9584,0x6622},
{0x9587,0xEFDA}, {0x9588,0x6623}, {0x9589,0xCAC4}, {0x958A,0xEFDB}, {0x958B,0xB3AB},
{0x958C,0x6624}, {0x958D,0x6625}, {0x958E,0x6626}, {0x958F,0xB1BC}, {0x9591,0xB4D7},
{0x9592,0x7471},
{0x9593,0xB4D6}, {0x9594,0xEFDC}, {0x9596,0xEFDD}, {0x9598,0xEFDE}, {0x9599,0xEFDF},
{0x959D,0x6627}, {0x959E,0x6628}, {0x959F,0x6629}, {0x95A0,0xEFE0}, {0x95A1,0x662A},
{0x95A2,0xB4D8}, {0x95A3,0xB3D5}, {0x95A4,0xB9DE}, {0x95A5,0xC8B6}, {0x95A6,0x662B},
{0x95A7,0xEFE2}, {0x95A8,0xEFE1}, {0x95A9,0x662C}, {0x95AB,0x662D}, {0x95AC,0x662E},
{0x95AD,0xEFE3}, {0x95B2,0xB1DC}, {0x95B4,0x662F}, {0x95B6,0x6630}, {0x95B9,0xEFE6},
{0x95BA,0x6631}, {0x95BB,0xEFE5}, {0x95BC,0xEFE4}, {0x95BD,0x6632}, {0x95BE,0xEFE7},
{0x95BF,0x6633}, {0x95C3,0xEFEA}, {0x95C6,0x6634}, {0x95C7,0xB0C7}, {0x95C8,0x6635},
{0x95C9,0x6636}, {0x95CA,0xEFE8}, {0x95CB,0x6637}, {0x95CC,0xEFEC}, {0x95CD,0xEFEB},
{0x95D0,0x6638}, {0x95D1,0x6639}, {0x95D2,0x663A}, {0x95D3,0x663B}, {0x95D4,0xEFEE},
{0x95D5,0xEFED}, {0x95D6,0xEFEF}, {0x95D8,0xC6AE}, {0x95D9,0x663C}, {0x95DA,0x663D},
{0x95DC,0xEFF0}, {0x95DD,0x663E}, {0x95DE,0x663F}, {0x95DF,0x6640}, {0x95E0,0x6641},
{0x95E1,0xEFF1}, {0x95E2,0xEFF3}, {0x95E4,0x6642}, {0x95E5,0xEFF2}, {0x95E6,0x6643},
{0x961C,0xC9EC}, {0x961D,0x6644}, {0x961E,0x6645}, {0x9621,0xEFF4}, {0x9622,0x6646},
{0x9624,0x6647}, {0x9625,0x6648}, {0x9626,0x6649}, {0x9628,0xEFF5}, {0x962A,0xBAE5},
{0x962C,0x664A}, {0x962E,0xEFF6}, {0x962F,0xEFF7}, {0x9631,0x664B}, {0x9632,0xCBC9},
{0x9633,0x664C}, {0x9637,0x664D}, {0x9638,0x664E}, {0x9639,0x664F}, {0x963A,0x6650},
{0x963B,0xC1CB}, {0x963C,0x6651}, {0x963D,0x6652}, {0x963F,0xB0A4}, {0x9640,0xC2CB},
{0x9641,0x6653}, {0x9642,0xEFF8}, {0x9644,0xC9ED}, {0x964B,0xEFFB}, {0x964C,0xEFF9},
{0x964D,0xB9DF}, {0x964F,0xEFFA}, {0x9650,0xB8C2}, {0x9652,0x6654}, {0x9654,0x6655},
{0x9656,0x6656}, {0x9657,0x6657}, {0x9658,0x6658}, {0x965B,0xCAC5}, {0x965C,0xEFFD},
{0x965D,0xF0A1}, {0x965E,0xEFFE}, {0x965F,0xF0A2}, {0x9661,0x6659}, {0x9662,0xB1A1},
{0x9663,0xBFD8}, {0x9664,0xBDFC}, {0x9665,0xB4D9}, {0x9666,0xF0A3}, {0x966A,0xC7E6},
{0x966C,0xF0A5}, {0x966E,0x665A}, {0x9670,0xB1A2}, {0x9672,0xF0A4}, {0x9673,0xC4C4},
{0x9674,0x665B}, {0x9675,0xCECD}, {0x9676,0xC6AB}, {0x9677,0xEFFC}, {0x9678,0xCEA6},
{0x967A,0xB8B1}, {0x967B,0x665C}, {0x967C,0x665D}, {0x967D,0xCDDB}, {0x967E,0x665E},
{0x967F,0x665F}, {0x9681,0x6660}, {0x9682,0x6661}, {0x9683,0x6662}, {0x9684,0x6663},
{0x9685,0xB6F9}, {0x9686,0xCEB4}, {0x9688,0xB7A8}, {0x9689,0x6664}, {0x968A,0xC2E2},
{0x968B,0xE7A1}, {0x968D,0xF0A6}, {0x968E,0xB3AC}, {0x968F,0xBFEF}, {0x9691,0x6665},
{0x9694,0xB3D6}, {0x9695,0xF0A8}, {0x9696,0x6666}, {0x9697,0xF0A9}, {0x9698,0xF0A7},
// {0x969D,0xFCD1}, alternative
{0x9699,0xB7E4}, {0x969A,0x6667}, {0x969B,0xBADD}, {0x969C,0xBEE3}, {0x969D,0x6668},
{0x969F,0x6669}, {0x96A0,0xB1A3}, {0x96A3,0xCED9}, {0x96A4,0x666A}, {0x96A5,0x666B},
{0x96A6,0x666C}, {0x96A7,0xF0AB}, {0x96A8,0xEEAE}, {0x96A9,0x666D}, {0x96AA,0xF0AA},
// {0x96AF,0xFCD2}, alternative
{0x96AE,0x666E}, {0x96AF,0x666F}, {0x96B0,0xF0AE}, {0x96B1,0xF0AC}, {0x96B2,0xF0AD},
{0x96B3,0x6670}, {0x96B4,0xF0AF}, {0x96B6,0xF0B0}, {0x96B7,0xCEEC}, {0x96B8,0xF0B1},
{0x96B9,0xF0B2}, {0x96BA,0x6671}, {0x96BB,0xC0C9}, {0x96BC,0xC8BB}, {0x96C0,0xBFFD},
{0x96C1,0xB4E7}, {0x96C4,0xCDBA}, {0x96C5,0xB2ED}, {0x96C6,0xBDB8}, {0x96C7,0xB8DB},
{0x96C9,0xF0B5}, {0x96CA,0x6672}, {0x96CB,0xF0B4}, {0x96CC,0xBBF3}, {0x96CD,0xF0B6},
{0x96CE,0xF0B3}, {0x96D1,0xBBA8}, {0x96D2,0x6673}, {0x96D5,0xF0BA}, {0x96D6,0xEAAD},
{0x96D8,0x6675}, {0x96D9,0xD2D6}, {0x96DA,0x6676}, {0x96DB,0xBFF7}, {0x96DC,0xF0B8},
{0x96DD,0x6677}, {0x96DE,0x6678}, {0x96DF,0x6679}, {0x96E2,0xCEA5}, {0x96E3,0xC6F1},
{0x96E8,0xB1AB}, {0x96E9,0x667A}, {0x96EA,0xC0E3}, {0x96EB,0xBCB6}, {0x96EF,0x667B},
{0x96F0,0xCAB7}, {0x96F1,0x667C}, {0x96F2,0xB1C0}, {0x96F6,0xCEED}, {0x96F7,0xCDEB},
{0x96F9,0xF0BB}, {0x96FA,0x667D}, {0x96FB,0xC5C5}, {0x9700,0xBCFB}, {0x9702,0x667E},
{0x9703,0x6721}, {0x9704,0xF0BC}, {0x9705,0x6722}, {0x9706,0xF0BD}, {0x9707,0xBFCC},
{0x9708,0xF0BE}, {0x9709,0x6723}, {0x970A,0xCEEE}, {0x970D,0xF0B9}, {0x970E,0xF0C0},
{0x970F,0xF0C2}, {0x9711,0xF0C1}, {0x9713,0xF0BF}, {0x9716,0xF0C3}, {0x9719,0xF0C4},
{0x971A,0x6724}, {0x971B,0x6725}, {0x971C,0xC1FA}, {0x971D,0x6726}, {0x971E,0xB2E2},
{0x9721,0x6727}, {0x9722,0x6728}, {0x9723,0x6729}, {0x9724,0xF0C5}, {0x9727,0xCCB8},
{0x9728,0x672A}, {0x972A,0xF0C6}, {0x9730,0xF0C7}, {0x9731,0x672B}, {0x9732,0xCFAA},
// {0x9733,0xFCD3}, alternative
{0x9733,0x672C}, {0x9738,0xDBB1}, {0x9739,0xF0C8},
{0x973B,0x7474},
{0x973D,0xF0C9}, {0x973E,0xF0CA},
// {0x9743,0xFCD5}, alternative
{0x9741,0x672D}, {0x9742,0xF0CE}, {0x9743,0x672E}, {0x9744,0xF0CB}, {0x9746,0xF0CC},
{0x9748,0xF0CD}, {0x9749,0xF0CF}, {0x974A,0x672F},
{0x974D,0x7475},
// {0x974F,0xFCD7}, alternative
{0x974E,0x6730}, {0x974F,0x6731},
{0x9751,0x7476},
// {0x9755,0xFCD9}, alternative
{0x9752,0xC0C4}, {0x9755,0x6732}, {0x9756,0xCCF7}, {0x9757,0x6733}, {0x9758,0x6734},
{0x9759,0xC0C5}, {0x975A,0x6735}, {0x975B,0x6736}, {0x975C,0xF0D0}, {0x975E,0xC8F3},
{0x9760,0xF0D1}, {0x9761,0xF3D3}, {0x9762,0xCCCC}, {0x9763,0x6737}, {0x9764,0xF0D2},
{0x9766,0xF0D3}, {0x9767,0x6738}, {0x9768,0xF0D4}, {0x9769,0xB3D7}, {0x976A,0x6739},
{0x976B,0xF0D6}, {0x976D,0xBFD9}, {0x976E,0x673A}, {0x9771,0xF0D7}, {0x9773,0x673B},
{0x9774,0xB7A4}, {0x9776,0x673C}, {0x9777,0x673D}, {0x9778,0x673E}, {0x9779,0xF0D8},
{0x977A,0xF0DC}, {0x977B,0x673F}, {0x977C,0xF0DA}, {0x977D,0x6740}, {0x977F,0x6741},
{0x9780,0x6742}, {0x9781,0xF0DB}, {0x9784,0xB3F3}, {0x9785,0xF0D9}, {0x9786,0xF0DD},
{0x9789,0x6743}, {0x978B,0xF0DE}, {0x978D,0xB0C8}, {0x978F,0xF0DF}, {0x9790,0xF0E0},
{0x9795,0x6744}, {0x9796,0x6745}, {0x9797,0x6746}, {0x9798,0xBEE4}, {0x9799,0x6747},
{0x979A,0x6748}, {0x979C,0xF0E1}, {0x979E,0x6749}, {0x979F,0x674A}, {0x97A0,0xB5C7},
{0x97A2,0x674B}, {0x97A3,0xF0E4}, {0x97A6,0xF0E3}, {0x97A8,0xF0E2}, {0x97AB,0xEBF1},
{0x97AC,0x674C}, {0x97AD,0xCADC}, {0x97AE,0x674D}, {0x97B1,0x674E}, {0x97B2,0x674F},
{0x97B3,0xF0E5}, {0x97B4,0xF0E6}, {0x97B5,0x6750}, {0x97B6,0x6751}, {0x97B8,0x6752},
{0x97B9,0x6753}, {0x97BA,0x6754}, {0x97BC,0x6755}, {0x97BE,0x6756}, {0x97BF,0x6757},
{0x97C1,0x6758}, {0x97C3,0xF0E7}, {0x97C4,0x6759}, {0x97C5,0x675A}, {0x97C6,0xF0E8},
{0x97C7,0x675B}, {0x97C8,0xF0E9}, {0x97C9,0x675C}, {0x97CA,0x675D}, {0x97CB,0xF0EA},
{0x97CC,0x675E}, {0x97CD,0x675F}, {0x97CE,0x6760}, {0x97D0,0x6761}, {0x97D1,0x6762},
{0x97D3,0xB4DA}, {0x97D4,0x6763}, {0x97D7,0x6764}, {0x97D8,0x6765}, {0x97D9,0x6766},
{0x97DB,0x676A}, {0x97DC,0xF0EB}, {0x97DD,0x6767}, {0x97DE,0x6768}, {0x97E0,0x6769},
{0x97E1,0x676B}, {0x97E4,0x676C}, {0x97ED,0xF0EC}, {0x97EE,0xC7A3}, {0x97EF,0x676D},
{0x97F1,0x676E}, {0x97F2,0xF0EE}, {0x97F3,0xB2BB}, {0x97F4,0x676F}, {0x97F5,0xF0F1},
{0x97F6,0xF0F0}, {0x97F7,0x6770}, {0x97F8,0x6771}, {0x97FA,0x6772}, {0x97FB,0xB1A4},
{0x97FF,0xB6C1}, {0x9801,0xCAC7}, {0x9802,0xC4BA}, {0x9803,0xBAA2}, {0x9805,0xB9E0},
{0x9806,0xBDE7}, {0x9807,0x6773}, {0x9808,0xBFDC}, {0x980A,0x6774}, {0x980C,0xF0F3},
{0x980D,0x6776}, {0x980E,0x6777}, {0x980F,0xF0F2}, {0x9810,0xCDC2}, {0x9811,0xB4E8},
{0x9812,0xC8D2}, {0x9813,0xC6DC}, {0x9814,0x6778}, {0x9816,0x6779}, {0x9817,0xBFFC},
{0x9818,0xCECE}, {0x9819,0x6775}, {0x981A,0xB7DB}, {0x981C,0x677A}, {0x981E,0x677B},
{0x9820,0x677C}, {0x9821,0xF0F6}, {0x9823,0x677D}, {0x9824,0xF0F5}, {0x9825,0x6828},
{0x9826,0x677E}, {0x982B,0x6821}, {0x982C,0xCBCB}, {0x982D,0xC6AC}, {0x982E,0x6822},
{0x982F,0x6823}, {0x9830,0x6824}, {0x9832,0x6825}, {0x9833,0x6826}, {0x9834,0xB1D0},
{0x9835,0x6827}, {0x9837,0xF0F7}, {0x9838,0xF0F4}, {0x983B,0xC9D1}, {0x983C,0xCDEA},
{0x983D,0xF0F8}, {0x983E,0x6829}, {0x9844,0x682A}, {0x9846,0xF0F9}, {0x9847,0x682B},
{0x984A,0x682C}, {0x984B,0xF0FB}, {0x984C,0xC2EA}, {0x984D,0xB3DB}, {0x984E,0xB3DC},
{0x984F,0xF0FA}, {0x9851,0x682D}, {0x9852,0x682E}, {0x9853,0x682F}, {0x9854,0xB4E9},
// {0x9857,0xFCDA}, alternative
{0x9855,0xB8B2}, {0x9856,0x6830}, {0x9857,0x6831}, {0x9858,0xB4EA}, {0x9859,0x6832},
{0x985A,0x6833}, {0x985B,0xC5BF}, {0x985E,0xCEE0}, {0x9862,0x6834}, {0x9863,0x6835},
// {0x9865,0xFCDB}, alternative
{0x9865,0x6836}, {0x9866,0x6837}, {0x9867,0xB8DC}, {0x986A,0x6838}, {0x986B,0xF0FC},
{0x986C,0x6839}, {0x986F,0xF0FD}, {0x9870,0xF0FE}, {0x9871,0xF1A1}, {0x9873,0xF1A3},
{0x9874,0xF1A2}, {0x98A8,0xC9F7}, {0x98AA,0xF1A4}, {0x98AB,0x683A}, {0x98AD,0x683B},
{0x98AE,0x683C}, {0x98AF,0xF1A5}, {0x98B0,0x683D}, {0x98B1,0xF1A6}, {0x98B4,0x683E},
{0x98B6,0xF1A7}, {0x98B7,0x683F}, {0x98B8,0x6840}, {0x98BA,0x6841}, {0x98BB,0x6842},
{0x98BF,0x6843}, {0x98C2,0x6844}, {0x98C3,0xF1A9}, {0x98C4,0xF1A8}, {0x98C5,0x6845},
{0x98C6,0xF1AA}, {0x98C8,0x6846}, {0x98CC,0x6847}, {0x98DB,0xC8F4}, {0x98DC,0xE6CC},
{0x98DF,0xBFA9}, {0x98E1,0x6848}, {0x98E2,0xB5B2}, {0x98E3,0x6849}, {0x98E5,0x684A},
{0x98E6,0x684B}, {0x98E7,0x684C}, {0x98E9,0xF1AB}, {0x98EA,0x684D}, {0x98EB,0xF1AC},
{0x98ED,0xD2AC}, {0x98EE,0xDDBB}, {0x98EF,0xC8D3}, {0x98F2,0xB0FB}, {0x98F3,0x684E},
{0x98F4,0xB0BB}, {0x98F6,0x684F}, {0x98FC,0xBBF4}, {0x98FD,0xCBB0}, {0x98FE,0xBEFE},
{0x9902,0x6850}, {0x9903,0xF1AD}, {0x9905,0xCCDF}, {0x9907,0x6851}, {0x9908,0x6852},
{0x9909,0xF1AE}, {0x990A,0xCDDC}, {0x990C,0xB1C2}, {0x9910,0xBBC1}, {0x9911,0x6853},
{0x9912,0xF1AF}, {0x9913,0xB2EE}, {0x9914,0xF1B0}, {0x9915,0x6854}, {0x9916,0x6855},
{0x9917,0x6856}, {0x9918,0xF1B1}, {0x991A,0x6857}, {0x991B,0x6858}, {0x991C,0x6859},
{0x991D,0xF1B3}, {0x991E,0xF1B4}, {0x991F,0x685A}, {0x9920,0xF1B6}, {0x9921,0xF1B2},
// {0x9927,0xFCDE}, alternative
{0x9922,0x685B}, {0x9924,0xF1B5}, {0x9926,0x685C}, {0x9927,0x685D}, {0x9928,0xB4DB},
{0x992B,0x685E}, {0x992C,0xF1B7}, {0x992E,0xF1B8}, {0x9931,0x685F}, {0x9932,0x6860},
{0x9933,0x6861}, {0x9934,0x6862}, {0x9935,0x6863}, {0x9939,0x6864}, {0x993A,0x6865},
{0x993B,0x6866}, {0x993C,0x6867}, {0x993D,0xF1B9}, {0x993E,0xF1BA}, {0x9940,0x6868},
{0x9941,0x6869}, {0x9942,0xF1BB}, {0x9945,0xF1BD}, {0x9946,0x686A}, {0x9947,0x686B},
{0x9948,0x686C}, {0x9949,0xF1BC}, {0x994B,0xF1BF}, {0x994C,0xF1C2}, {0x994D,0x686D},
{0x994E,0x686E}, {0x9950,0xF1BE}, {0x9951,0xF1C0}, {0x9952,0xF1C1}, {0x9954,0x686F},
{0x9955,0xF1C3}, {0x9957,0xB6C2}, {0x9958,0x6870}, {0x9959,0x6871}, {0x995B,0x6872},
{0x995C,0x6873}, {0x995E,0x6874}, {0x995F,0x6875}, {0x9960,0x6876}, {0x9996,0xBCF3},
{0x9997,0xF1C4}, {0x9998,0xF1C5}, {0x9999,0xB9E1}, {0x999B,0x6877}, {0x999D,0x6878},
{0x999E,0x747a},
{0x999F,0x6879}, {0x99A5,0xF1C6}, {0x99A6,0x687A}, {0x99A8,0xB3BE}, {0x99AC,0xC7CF},
{0x99AD,0xF1C7}, {0x99AE,0xF1C8}, {0x99B0,0x687B}, {0x99B1,0x687C}, {0x99B2,0x687D},
{0x99B3,0xC3DA}, {0x99B4,0xC6EB}, {0x99B5,0x687E}, {0x99B9,0x6921}, {0x99BA,0x6922},
{0x99BC,0xF1C9}, {0x99BD,0x6923}, {0x99BF,0x6924}, {0x99C1,0xC7FD}, {0x99C3,0x6925},
{0x99C4,0xC2CC}, {0x99C5,0xB1D8}, {0x99C6,0xB6EE}, {0x99C8,0xB6EF}, {0x99C9,0x6926},
{0x99D0,0xC3F3}, {0x99D1,0xF1CE}, {0x99D2,0xB6F0}, {0x99D3,0x6927}, {0x99D4,0x6928},
{0x99D5,0xB2EF}, {0x99D8,0xF1CD}, {0x99D9,0x6929}, {0x99DA,0x692A}, {0x99DB,0xF1CB},
{0x99DC,0x692B}, {0x99DD,0xF1CC}, {0x99DE,0x692C}, {0x99DF,0xF1CA}, {0x99E2,0xF1D8},
{0x99E7,0x692D}, {0x99EA,0x692E}, {0x99EB,0x692F}, {0x99EC,0x6930}, {0x99ED,0xF1CF},
{0x99EE,0xF1D0}, {0x99F0,0x6931}, {0x99F1,0xF1D1}, {0x99F2,0xF1D2}, {0x99F4,0x6932},
{0x99F5,0x6933}, {0x99F8,0xF1D4}, {0x99F9,0x6934}, {0x99FB,0xF1D3}, {0x99FD,0x6935},
{0x99FE,0x6936}, {0x99FF,0xBDD9}, {0x9A01,0xF1D5}, {0x9A02,0x6937}, {0x9A03,0x6938},
{0x9A04,0x6939}, {0x9A05,0xF1D7}, {0x9A0B,0x693A}, {0x9A0C,0x693B}, {0x9A0E,0xB5B3},
{0x9A0F,0xF1D6}, {0x9A10,0x693C}, {0x9A11,0x693D}, {0x9A12,0xC1FB}, {0x9A13,0xB8B3},
{0x9A16,0x693E}, {0x9A19,0xF1D9}, {0x9A1E,0x693F}, {0x9A20,0x6940}, {0x9A22,0x6941},
{0x9A23,0x6942}, {0x9A24,0x6943}, {0x9A27,0x6944}, {0x9A28,0xC2CD}, {0x9A2B,0xF1DA},
{0x9A2D,0x6945}, {0x9A2E,0x6946}, {0x9A30,0xC6AD}, {0x9A33,0x6947}, {0x9A35,0x6948},
{0x9A36,0x6949}, {0x9A37,0xF1DB}, {0x9A38,0x694A}, {0x9A3E,0xF1E0}, {0x9A40,0xF1DE},
{0x9A41,0x694C}, {0x9A42,0xF1DD}, {0x9A43,0xF1DF}, {0x9A44,0x694D}, {0x9A45,0xF1DC},
{0x9A47,0x694B}, {0x9A4A,0x694E}, {0x9A4B,0x694F}, {0x9A4C,0x6950}, {0x9A4D,0xF1E2},
// {0x9A4E,0xFCE1}, alternative
{0x9A4E,0x6951}, {0x9A51,0x6952}, {0x9A54,0x6953}, {0x9A55,0xF1E1}, {0x9A56,0x6954},
{0x9A57,0xF1E4}, {0x9A5A,0xB6C3}, {0x9A5B,0xF1E3}, {0x9A5D,0x6955}, {0x9A5F,0xF1E5},
{0x9A62,0xF1E6}, {0x9A64,0xF1E8}, {0x9A65,0xF1E7}, {0x9A69,0xF1E9}, {0x9A6A,0xF1EB},
{0x9A6B,0xF1EA}, {0x9AA8,0xB9FC}, {0x9AAA,0x6956}, {0x9AAC,0x6957}, {0x9AAD,0xF1EC},
{0x9AAE,0x6958}, {0x9AAF,0x6959}, {0x9AB0,0xF1ED}, {0x9AB2,0x695A}, {0x9AB4,0x695B},
{0x9AB5,0x695C}, {0x9AB6,0x695D}, {0x9AB8,0xB3BC}, {0x9AB9,0x695E}, {0x9ABB,0x695F},
{0x9ABC,0xF1EE}, {0x9ABE,0x6960}, {0x9ABF,0x6961}, {0x9AC0,0xF1EF}, {0x9AC1,0x6962},
{0x9AC3,0x6963}, {0x9AC4,0xBFF1}, {0x9AC6,0x6964}, {0x9AC8,0x6965}, {0x9ACE,0x6966},
{0x9ACF,0xF1F0}, {0x9AD0,0x6967}, {0x9AD1,0xF1F1}, {0x9AD2,0x6968}, {0x9AD3,0xF1F2},
{0x9AD4,0xF1F3}, {0x9AD5,0x6969}, {0x9AD6,0x696A}, {0x9AD7,0x696B}, {0x9AD8,0xB9E2},
{0x9AD9,0x747b},
// {0x9ADC,0xFCE3}, alternative
{0x9ADB,0x696C}, {0x9ADC,0x696D}, {0x9ADE,0xF1F4}, {0x9ADF,0xF1F5}, {0x9AE0,0x696E},
{0x9AE2,0xF1F6}, {0x9AE3,0xF1F7}, {0x9AE4,0x696F}, {0x9AE5,0x6970}, {0x9AE6,0xF1F8},
{0x9AE7,0x6971}, {0x9AE9,0x6972}, {0x9AEA,0xC8B1}, {0x9AEB,0xF1FA}, {0x9AEC,0x6973},
{0x9AED,0xC9A6}, {0x9AEE,0xF1FB}, {0x9AEF,0xF1F9}, {0x9AF1,0xF1FD}, {0x9AF2,0x6974},
{0x9AF3,0x6975}, {0x9AF4,0xF1FC}, {0x9AF5,0x6976}, {0x9AF7,0xF1FE}, {0x9AF9,0x6977},
{0x9AFA,0x6978}, {0x9AFB,0xF2A1}, {0x9AFD,0x6979}, {0x9AFF,0x697A}, {0x9B00,0x697B},
{0x9B01,0x697C}, {0x9B02,0x697D}, {0x9B03,0x697E}, {0x9B04,0x6A21}, {0x9B05,0x6A22},
{0x9B06,0xF2A2}, {0x9B08,0x6A23}, {0x9B09,0x6A24}, {0x9B0B,0x6A25}, {0x9B0C,0x6A26},
{0x9B0D,0x6A27}, {0x9B0E,0x6A28}, {0x9B10,0x6A29}, {0x9B12,0x6A2A}, {0x9B16,0x6A2B},
{0x9B18,0xF2A3}, {0x9B19,0x6A2C}, {0x9B1A,0xF2A4}, {0x9B1B,0x6A2D}, {0x9B1C,0x6A2E},
{0x9B1F,0xF2A5}, {0x9B20,0x6A2F}, {0x9B22,0xF2A6}, {0x9B23,0xF2A7}, {0x9B25,0xF2A8},
{0x9B26,0x6A30}, {0x9B27,0xF2A9}, {0x9B28,0xF2AA}, {0x9B29,0xF2AB}, {0x9B2A,0xF2AC},
{0x9B2B,0x6A31}, {0x9B2D,0x6A32}, {0x9B2E,0xF2AD}, {0x9B2F,0xF2AE}, {0x9B31,0xDDB5},
{0x9B32,0xF2AF}, {0x9B33,0x6A33}, {0x9B34,0x6A34}, {0x9B35,0x6A35}, {0x9B37,0x6A36},
{0x9B39,0x6A37}, {0x9B3A,0x6A38}, {0x9B3B,0xE4F8}, {0x9B3C,0xB5B4}, {0x9B3D,0x6A39},
{0x9B41,0xB3A1}, {0x9B42,0xBAB2}, {0x9B43,0xF2B1}, {0x9B44,0xF2B0}, {0x9B45,0xCCA5},
{0x9B48,0x6A3A}, {0x9B4B,0x6A3B}, {0x9B4C,0x6A3C}, {0x9B4D,0xF2B3}, {0x9B4E,0xF2B4},
{0x9B4F,0xF2B2}, {0x9B51,0xF2B5}, {0x9B54,0xCBE2}, {0x9B55,0x6A3D}, {0x9B56,0x6A3E},
{0x9B57,0x6A3F}, {0x9B58,0xF2B6}, {0x9B5A,0xB5FB}, {0x9B5B,0x6A40}, {0x9B5E,0x6A41},
{0x9B61,0x6A42}, {0x9B63,0x6A43}, {0x9B65,0x6A44}, {0x9B66,0x6A45}, {0x9B68,0x6A46},
{0x9B6A,0x6A47}, {0x9B6B,0x6A48}, {0x9B6C,0x6A49}, {0x9B6D,0x6A4A}, {0x9B6E,0x6A4B},
{0x9B6F,0xCFA5},
{0x9B72,0x747c},
// {0x9B75,0xFCE4}, alternative
{0x9B73,0x6A4C}, {0x9B74,0xF2B7}, {0x9B75,0x6A4D}, {0x9B77,0x6A4E},
{0x9B78,0x6A4F}, {0x9B79,0x6A50}, {0x9B7F,0x6A51}, {0x9B80,0x6A52}, {0x9B83,0xF2B9},
{0x9B84,0x6A53}, {0x9B85,0x6A54}, {0x9B86,0x6A55}, {0x9B87,0x6A56}, {0x9B89,0x6A57},
// {0x9B8F,0xFCE6}, alternative
{0x9B8A,0x6A58}, {0x9B8B,0x6A59}, {0x9B8D,0x6A5A}, {0x9B8E,0xB0BE}, {0x9B8F,0x6A5B},
{0x9B90,0x6A5C}, {0x9B91,0xF2BA}, {0x9B92,0xCAAB}, {0x9B93,0xF2B8}, {0x9B94,0x6A5D},
{0x9B96,0xF2BB}, {0x9B97,0xF2BC}, {0x9B9A,0x6A5E}, {0x9B9D,0x6A5F}, {0x9B9E,0x6A60},
{0x9B9F,0xF2BD}, {0x9BA0,0xF2BE}, {0x9BA6,0x6A61}, {0x9BA7,0x6A62}, {0x9BA8,0xF2BF},
{0x9BA9,0x6A63}, {0x9BAA,0xCBEE}, {0x9BAB,0xBBAD}, {0x9BAC,0x6A64}, {0x9BAD,0xBAFA},
// {0x9BB1,0xFCE7}, alternative
{0x9BAE,0xC1AF}, {0x9BB0,0x6A65}, {0x9BB1,0x6A66}, {0x9BB2,0x6A67}, {0x9BB4,0xF2C0},
// {0x9BBB,0xFCE8}, alternative
{0x9BB7,0x6A68}, {0x9BB8,0x6A69}, {0x9BB9,0xF2C3}, {0x9BBB,0x6A6A}, {0x9BBC,0x6A6B},
{0x9BBE,0x6A6C}, {0x9BBF,0x6A6D}, {0x9BC0,0xF2C1}, {0x9BC1,0x6A6E}, {0x9BC6,0xF2C4},
{0x9BC7,0x6A6F}, {0x9BC8,0x6A70}, {0x9BC9,0xB8F1}, {0x9BCA,0xF2C2}, {0x9BCE,0x6A71},
{0x9BCF,0xF2C5}, {0x9BD0,0x6A72}, {0x9BD1,0xF2C6}, {0x9BD2,0xF2C7}, {0x9BD4,0xF2CB},
{0x9BD6,0xBBAA}, {0x9BD7,0x6A73}, {0x9BD8,0x6A74}, {0x9BDB,0xC2E4}, {0x9BDD,0x6A75},
{0x9BDF,0x6A76}, {0x9BE1,0xF2CC}, {0x9BE2,0xF2C9}, {0x9BE3,0xF2C8}, {0x9BE4,0xF2CA},
{0x9BE5,0x6A77}, {0x9BE7,0x6A78}, {0x9BE8,0xB7DF}, {0x9BEA,0x6A79}, {0x9BEB,0x6A7A},
{0x9BEF,0x6A7B}, {0x9BF0,0xF2D0}, {0x9BF1,0xF2CF}, {0x9BF2,0xF2CE}, {0x9BF3,0x6A7C},
{0x9BF5,0xB0B3}, {0x9BF7,0x6A7D}, {0x9BF8,0x6A7E}, {0x9BF9,0x6B21}, {0x9BFA,0x6B22},
// {0x9C00,0xFCE9}, alternative
{0x9BFD,0x6B23}, {0x9BFF,0x6B24}, {0x9C00,0x6B25}, {0x9C02,0x6B26}, {0x9C04,0xF2DA},
{0x9C06,0xF2D6}, {0x9C08,0xF2D7}, {0x9C09,0xF2D3}, {0x9C0A,0xF2D9}, {0x9C0B,0x6B27},
{0x9C0C,0xF2D5}, {0x9C0D,0xB3E2}, {0x9C0F,0x6B28}, {0x9C10,0xCFCC}, {0x9C11,0x6B29},
{0x9C12,0xF2D8}, {0x9C13,0xF2D4}, {0x9C14,0xF2D2}, {0x9C15,0xF2D1}, {0x9C16,0x6B2A},
{0x9C18,0x6B2B}, {0x9C19,0x6B2C}, {0x9C1A,0x6B2D}, {0x9C1B,0xF2DC}, {0x9C1C,0x6B2E},
{0x9C1E,0x6B2F}, {0x9C21,0xF2DF}, {0x9C22,0x6B30}, {0x9C23,0x6B31}, {0x9C24,0xF2DE},
{0x9C25,0xF2DD}, {0x9C26,0x6B32}, {0x9C27,0x6B33}, {0x9C28,0x6B34}, {0x9C29,0x6B35},
{0x9C2A,0x6B36}, {0x9C2D,0xC9C9}, {0x9C2E,0xF2DB}, {0x9C2F,0xB0F3}, {0x9C30,0xF2E0},
{0x9C31,0x6B37}, {0x9C32,0xF2E2}, {0x9C35,0x6B38}, {0x9C36,0x6B39}, {0x9C37,0x6B3A},
{0x9C39,0xB3EF}, {0x9C3A,0xF2CD}, {0x9C3B,0xB1B7}, {0x9C3D,0x6B3B}, {0x9C3E,0xF2E4},
{0x9C41,0x6B3C}, {0x9C43,0x6B3D}, {0x9C44,0x6B3E}, {0x9C45,0x6B3F}, {0x9C46,0xF2E3},
{0x9C47,0xF2E1}, {0x9C48,0xC3AD}, {0x9C49,0x6B40}, {0x9C4A,0x6B41}, {0x9C4E,0x6B42},
{0x9C4F,0x6B43}, {0x9C50,0x6B44}, {0x9C52,0xCBF0}, {0x9C53,0x6B45}, {0x9C54,0x6B46},
{0x9C56,0x6B47}, {0x9C57,0xCEDA}, {0x9C58,0x6B48}, {0x9C5A,0xF2E5}, {0x9C5B,0x6B49},
{0x9C5C,0x6B50}, {0x9C5D,0x6B4A}, {0x9C5E,0x6B4B}, {0x9C5F,0x6B4C}, {0x9C60,0xF2E6},
{0x9C63,0x6B4D}, {0x9C67,0xF2E7}, {0x9C68,0x6B52}, {0x9C69,0x6B4E}, {0x9C6A,0x6B4F},
{0x9C6B,0x6B51}, {0x9C6E,0x6B53}, {0x9C70,0x6B54}, {0x9C72,0x6B55}, {0x9C75,0x6B56},
{0x9C76,0xF2E8}, {0x9C77,0x6B57}, {0x9C78,0xF2E9}, {0x9C7B,0x6B58}, {0x9CE5,0xC4BB},
{0x9CE6,0x6B59}, {0x9CE7,0xF2EA}, {0x9CE9,0xC8B7}, {0x9CEB,0xF2EF}, {0x9CEC,0xF2EB},
{0x9CF0,0xF2EC}, {0x9CF2,0x6B5A}, {0x9CF3,0xCBB1}, {0x9CF4,0xCCC4}, {0x9CF6,0xC6D0},
{0x9CF7,0x6B5B}, {0x9CF9,0x6B5C}, {0x9D02,0x6B5E}, {0x9D03,0xF2F0}, {0x9D06,0xF2F1},
{0x9D07,0xC6BE}, {0x9D08,0xF2EE}, {0x9D09,0xF2ED}, {0x9D0B,0x6B5D}, {0x9D0E,0xB2AA},
{0x9D11,0x6B5F}, {0x9D12,0xF2F9}, {0x9D15,0xF2F8}, {0x9D17,0x6B60}, {0x9D18,0x6B61},
{0x9D1B,0xB1F5}, {0x9D1C,0x6B62}, {0x9D1D,0x6B63}, {0x9D1E,0x6B64}, {0x9D1F,0xF2F6},
{0x9D23,0xF2F5}, {0x9D26,0xF2F3}, {0x9D28,0xB3FB}, {0x9D2A,0xF2F2}, {0x9D2B,0xBCB2},
{0x9D2C,0xB2A9}, {0x9D2F,0x6B65}, {0x9D30,0x6B66}, {0x9D32,0x6B67}, {0x9D33,0x6B68},
{0x9D34,0x6B69}, {0x9D3A,0x6B6A}, {0x9D3B,0xB9E3}, {0x9D3C,0x6B6B}, {0x9D3D,0x6B6D},
{0x9D3E,0xF2FC}, {0x9D3F,0xF2FB}, {0x9D41,0xF2FA}, {0x9D42,0x6B6E}, {0x9D43,0x6B6F},
{0x9D44,0xF2F7}, {0x9D45,0x6B6C}, {0x9D46,0xF2FD}, {0x9D47,0x6B70}, {0x9D48,0xF2FE},
{0x9D4A,0x6B71}, {0x9D50,0xF3A5}, {0x9D51,0xF3A4}, {0x9D53,0x6B72}, {0x9D54,0x6B73},
{0x9D59,0xF3A6}, {0x9D5C,0xB1AD}, {0x9D5D,0xF3A1}, {0x9D5E,0xF3A2}, {0x9D5F,0x6B74},
{0x9D60,0xB9F4}, {0x9D61,0xCCB9}, {0x9D62,0x6B76}, {0x9D63,0x6B75}, {0x9D64,0xF3A3},
// {0x9D6B,0xFCEB}, alternative
{0x9D65,0x6B77}, {0x9D69,0x6B78}, {0x9D6A,0x6B79}, {0x9D6B,0x6B7A}, {0x9D6C,0xCBB2},
// {0x9D70,0xFCEA}, alternative
{0x9D6F,0xF3AB}, {0x9D70,0x6B7B}, {0x9D72,0xF3A7}, {0x9D76,0x6B7C}, {0x9D77,0x6B7D},
{0x9D7A,0xF3AC}, {0x9D7B,0x6B7E}, {0x9D7C,0x6C21}, {0x9D7E,0x6C22}, {0x9D83,0x6C23},
{0x9D84,0x6C24}, {0x9D86,0x6C25}, {0x9D87,0xF3A9}, {0x9D89,0xF3A8}, {0x9D8A,0x6C26},
{0x9D8D,0x6C27}, {0x9D8E,0x6C28}, {0x9D8F,0xB7DC}, {0x9D92,0x6C29}, {0x9D93,0x6C2A},
{0x9D95,0x6C2B}, {0x9D96,0x6C2C}, {0x9D97,0x6C2D}, {0x9D98,0x6C2E}, {0x9D9A,0xF3AD},
{0x9DA1,0x6C2F}, {0x9DA4,0xF3AE}, {0x9DA9,0xF3AF}, {0x9DAA,0x6C30}, {0x9DAB,0xF3AA},
{0x9DAC,0x6C31}, {0x9DAE,0x6C32}, {0x9DAF,0xF2F4}, {0x9DB1,0x6C33}, {0x9DB2,0xF3B0},
{0x9DB4,0xC4E1}, {0x9DB5,0x6C34}, {0x9DB8,0xF3B4}, {0x9DB9,0x6C35}, {0x9DBA,0xF3B5},
{0x9DBB,0xF3B3}, {0x9DBC,0x6C36}, {0x9DBF,0x6C37}, {0x9DC1,0xF3B2}, {0x9DC2,0xF3B8},
{0x9DC3,0x6C38}, {0x9DC4,0xF3B1}, {0x9DC6,0xF3B6}, {0x9DC7,0x6C39}, {0x9DC9,0x6C3A},
{0x9DCA,0x6C3B}, {0x9DCF,0xF3B7}, {0x9DD3,0xF3BA}, {0x9DD4,0x6C3C}, {0x9DD5,0x6C3D},
{0x9DD6,0x6C3E}, {0x9DD7,0x6C3F}, {0x9DD9,0xF3B9}, {0x9DDA,0x6C40}, {0x9DDE,0x6C41},
{0x9DDF,0x6C42}, {0x9DE0,0x6C43}, {0x9DE5,0x6C44}, {0x9DE6,0xF3BC}, {0x9DE7,0x6C45},
{0x9DE9,0x6C46}, {0x9DEB,0x6C47}, {0x9DED,0xF3BD}, {0x9DEE,0x6C48}, {0x9DEF,0xF3BE},
{0x9DF0,0x6C49}, {0x9DF2,0xCFC9}, {0x9DF3,0x6C4A}, {0x9DF4,0x6C4B}, {0x9DF8,0xF3BB},
{0x9DF9,0xC2EB}, {0x9DFA,0xBAED}, {0x9DFD,0xF3BF}, {0x9DFE,0x6C4C}, {0x9E02,0x6C4E},
{0x9E07,0x6C4F}, {0x9E0A,0x6C4D}, {0x9E0E,0x6C50}, {0x9E10,0x6C51}, {0x9E11,0x6C52},
// {0x9E19,0xFCED}, alternative
{0x9E12,0x6C53}, {0x9E15,0x6C54}, {0x9E16,0x6C55}, {0x9E19,0x6C56}, {0x9E1A,0xF3C0},
{0x9E1B,0xF3C1}, {0x9E1C,0x6C57}, {0x9E1D,0x6C58}, {0x9E1E,0xF3C2}, {0x9E75,0xF3C3},
{0x9E78,0xB8B4}, {0x9E79,0xF3C4}, {0x9E7A,0x6C59}, {0x9E7B,0x6C5A}, {0x9E7C,0x6C5B},
{0x9E7D,0xF3C5}, {0x9E7F,0xBCAF}, {0x9E80,0x6C5C}, {0x9E81,0xF3C6}, {0x9E82,0x6C5D},
{0x9E83,0x6C5E}, {0x9E84,0x6C5F}, {0x9E85,0x6C60}, {0x9E87,0x6C61}, {0x9E88,0xF3C7},
{0x9E8B,0xF3C8}, {0x9E8C,0xF3C9}, {0x9E8E,0x6C62}, {0x9E8F,0x6C63}, {0x9E91,0xF3CC},
{0x9E92,0xF3CA}, {0x9E93,0xCFBC}, {0x9E95,0xF3CB}, {0x9E96,0x6C64}, {0x9E97,0xCEEF},
{0x9E98,0x6C65}, {0x9E9B,0x6C66}, {0x9E9D,0xF3CD}, {0x9E9E,0x6C67}, {0x9E9F,0xCEDB},
{0x9EA4,0x6C68}, {0x9EA5,0xF3CE}, {0x9EA6,0xC7FE}, {0x9EA8,0x6C69}, {0x9EA9,0xF3CF},
{0x9EAA,0xF3D1}, {0x9EAC,0x6C6A}, {0x9EAD,0xF3D2}, {0x9EAE,0x6C6B}, {0x9EAF,0x6C6C},
{0x9EB0,0x6C6D}, {0x9EB3,0x6C6E}, {0x9EB4,0x6C6F}, {0x9EB5,0x6C70}, {0x9EB8,0xF3D0},
{0x9EB9,0xB9ED}, {0x9EBA,0xCCCD}, {0x9EBB,0xCBE3}, {0x9EBC,0xD6F7}, {0x9EBE,0xDDE0},
{0x9EBF,0xCBFB}, {0x9EC4,0xB2AB}, {0x9EC6,0x6C71}, {0x9EC8,0x6C72}, {0x9ECB,0x6C73},
{0x9ECC,0xF3D4}, {0x9ECD,0xB5D0}, {0x9ECE,0xF3D5}, {0x9ECF,0xF3D6}, {0x9ED0,0xF3D7},
{0x9ED1,0x747e},
{0x9ED2,0xB9F5}, {0x9ED4,0xF3D8}, {0x9ED5,0x6C74}, {0x9ED8,0xE0D4}, {0x9ED9,0xCCDB},
{0x9EDB,0xC2E3}, {0x9EDC,0xF3D9}, {0x9EDD,0xF3DB}, {0x9EDE,0xF3DA}, {0x9EDF,0x6C75},
{0x9EE0,0xF3DC}, {0x9EE4,0x6C76}, {0x9EE5,0xF3DD}, {0x9EE7,0x6C77}, {0x9EE8,0xF3DE},
{0x9EEC,0x6C78}, {0x9EED,0x6C79}, {0x9EEE,0x6C7A}, {0x9EEF,0xF3DF}, {0x9EF0,0x6C7B},
{0x9EF1,0x6C7C}, {0x9EF2,0x6C7D}, {0x9EF4,0xF3E0}, {0x9EF5,0x6C7E}, {0x9EF6,0xF3E1},
{0x9EF7,0xF3E2}, {0x9EF8,0x6D21}, {0x9EF9,0xF3E3}, {0x9EFB,0xF3E4}, {0x9EFC,0xF3E5},
{0x9EFD,0xF3E6}, {0x9EFF,0x6D22}, {0x9F02,0x6D23}, {0x9F03,0x6D24}, {0x9F07,0xF3E7},
{0x9F08,0xF3E8}, {0x9F09,0x6D25}, {0x9F0E,0xC5A4}, {0x9F0F,0x6D26}, {0x9F10,0x6D27},
{0x9F11,0x6D28}, {0x9F12,0x6D29}, {0x9F13,0xB8DD}, {0x9F14,0x6D2A}, {0x9F15,0xF3EA},
{0x9F16,0x6D2B}, {0x9F17,0x6D2C}, {0x9F19,0x6D2D}, {0x9F1A,0x6D2E}, {0x9F1B,0x6D2F},
{0x9F1F,0x6D30}, {0x9F20,0xC1CD}, {0x9F21,0xF3EB}, {0x9F22,0x6D31}, {0x9F26,0x6D32},
{0x9F2A,0x6D33}, {0x9F2B,0x6D34}, {0x9F2C,0xF3EC}, {0x9F2F,0x6D35}, {0x9F31,0x6D36},
{0x9F32,0x6D37}, {0x9F34,0x6D38}, {0x9F37,0x6D39}, {0x9F39,0x6D3A}, {0x9F3A,0x6D3B},
{0x9F3B,0xC9A1}, {0x9F3C,0x6D3C}, {0x9F3D,0x6D3D}, {0x9F3E,0xF3ED}, {0x9F3F,0x6D3E},
{0x9F41,0x6D3F}, {0x9F43,0x6D40}, {0x9F44,0x6D41}, {0x9F45,0x6D42}, {0x9F46,0x6D43},
{0x9F47,0x6D44}, {0x9F4A,0xF3EE}, {0x9F4B,0xE3B7}, {0x9F4E,0xECDA}, {0x9F4F,0xF0ED},
{0x9F52,0xF3EF}, {0x9F53,0x6D45}, {0x9F54,0xF3F0}, {0x9F55,0x6D46}, {0x9F56,0x6D47},
{0x9F57,0x6D48}, {0x9F58,0x6D49}, {0x9F5A,0x6D4A}, {0x9F5D,0x6D4B}, {0x9F5E,0x6D4C},
{0x9F5F,0xF3F2}, {0x9F60,0xF3F3}, {0x9F61,0xF3F4}, {0x9F62,0xCEF0}, {0x9F63,0xF3F1},
{0x9F66,0xF3F5}, {0x9F67,0xF3F6}, {0x9F68,0x6D4D}, {0x9F69,0x6D4E}, {0x9F6A,0xF3F8},
{0x9F6C,0xF3F7}, {0x9F6D,0x6D4F}, {0x9F6E,0x6D50}, {0x9F6F,0x6D51}, {0x9F70,0x6D52},
{0x9F71,0x6D53}, {0x9F72,0xF3FA}, {0x9F73,0x6D54}, {0x9F75,0x6D55}, {0x9F76,0xF3FB},
{0x9F77,0xF3F9}, {0x9F7A,0x6D56}, {0x9F7D,0x6D57}, {0x9F8D,0xCEB6}, {0x9F8F,0x6D58},
{0x9F90,0x6D59}, {0x9F91,0x6D5A}, {0x9F92,0x6D5B}, {0x9F94,0x6D5C}, {0x9F95,0xF3FC},
{0x9F96,0x6D5D}, {0x9F97,0x6D5E}, {0x9F9C,0xF3FD}, {0x9F9D,0xE3D4}, {0x9F9E,0x6D5F},
{0x9FA0,0xF3FE}, {0x9FA1,0x6D60}, {0x9FA2,0x6D61}, {0x9FA3,0x6D62}, {0x9FA5,0x6D63},
{0xF8F0,0x00A0}, {0xF8F1,0x00FD}, {0xF8F2,0x00FE}, {0xF8F3,0x00FF}, 
{0xF929,0x7445},
{0xF9DC,0x7472},
{0xFA0E,0x7434},
{0xFA0F,0x7437},
{0xFA10,0x7438},
{0xFA11,0x743d},
{0xFA12,0x7444},
{0xFA13,0x7447},
{0xFA14,0x7448},
{0xFA15,0x744e},
{0xFA16,0x744f},
{0xFA17,0x7453},
{0xFA18,0x7455},
{0xFA19,0x7456},
{0xFA1A,0x7457},
{0xFA1B,0x7458},
{0xFA1C,0x745a},
{0xFA1D,0x745b},
{0xFA1E,0x745e},
{0xFA1F,0x7460},
{0xFA20,0x7462},
{0xFA21,0x7463},
{0xFA22,0x7465},
{0xFA23,0x7469},
{0xFA24,0x746a},
{0xFA25,0x746b},
{0xFA26,0x746d},
{0xFA27,0x746f},
{0xFA28,0x7470},
{0xFA29,0x7473},
{0xFA2A,0x7477},
{0xFA2B,0x7478},
{0xFA2C,0x7479},
{0xFA2D,0x747d},
{0xFF01,0xA1AA},
{0xFF02,0x742a},
{0xFF03,0xA1F4}, {0xFF04,0xA1F0}, {0xFF05,0xA1F3}, {0xFF06,0xA1F5},
{0xFF07,0x7429},
{0xFF08,0xA1CA}, {0xFF09,0xA1CB}, {0xFF0A,0xA1F6}, {0xFF0B,0xA1DC}, {0xFF0C,0xA1A4},
{0xFF0D,0xA1DD},
{0xFF0E,0xA1A5}, {0xFF0F,0xA1BF}, {0xFF10,0xA3B0}, {0xFF11,0xA3B1}, {0xFF12,0xA3B2},
{0xFF13,0xA3B3}, {0xFF14,0xA3B4}, {0xFF15,0xA3B5}, {0xFF16,0xA3B6}, {0xFF17,0xA3B7},
{0xFF18,0xA3B8}, {0xFF19,0xA3B9}, {0xFF1A,0xA1A7}, {0xFF1B,0xA1A8}, {0xFF1C,0xA1E3},
{0xFF1D,0xA1E1}, {0xFF1E,0xA1E4}, {0xFF1F,0xA1A9}, {0xFF20,0xA1F7}, {0xFF21,0xA3C1},
{0xFF22,0xA3C2}, {0xFF23,0xA3C3}, {0xFF24,0xA3C4}, {0xFF25,0xA3C5}, {0xFF26,0xA3C6},
{0xFF27,0xA3C7}, {0xFF28,0xA3C8}, {0xFF29,0xA3C9}, {0xFF2A,0xA3CA}, {0xFF2B,0xA3CB},
{0xFF2C,0xA3CC}, {0xFF2D,0xA3CD}, {0xFF2E,0xA3CE}, {0xFF2F,0xA3CF}, {0xFF30,0xA3D0},
{0xFF31,0xA3D1}, {0xFF32,0xA3D2}, {0xFF33,0xA3D3}, {0xFF34,0xA3D4}, {0xFF35,0xA3D5},
{0xFF36,0xA3D6}, {0xFF37,0xA3D7}, {0xFF38,0xA3D8}, {0xFF39,0xA3D9}, {0xFF3A,0xA3DA},
{0xFF3B,0xA1CE},

# ifndef UNICODE_MAPPING
{0xFF3C, 0xA1C0},
# endif

               {0xFF3D,0xA1CF}, {0xFF3E,0xA1B0}, {0xFF3F,0xA1B2}, {0xFF40,0xA1AE},
{0xFF41,0xA3E1}, {0xFF42,0xA3E2}, {0xFF43,0xA3E3}, {0xFF44,0xA3E4}, {0xFF45,0xA3E5},
{0xFF46,0xA3E6}, {0xFF47,0xA3E7}, {0xFF48,0xA3E8}, {0xFF49,0xA3E9}, {0xFF4A,0xA3EA},
{0xFF4B,0xA3EB}, {0xFF4C,0xA3EC}, {0xFF4D,0xA3ED}, {0xFF4E,0xA3EE}, {0xFF4F,0xA3EF},
{0xFF50,0xA3F0}, {0xFF51,0xA3F1}, {0xFF52,0xA3F2}, {0xFF53,0xA3F3}, {0xFF54,0xA3F4},
{0xFF55,0xA3F5}, {0xFF56,0xA3F6}, {0xFF57,0xA3F7}, {0xFF58,0xA3F8}, {0xFF59,0xA3F9},
{0xFF5A,0xA3FA}, {0xFF5B,0xA1D0}, {0xFF5C,0xA1C3}, {0xFF5D,0xA1D1},
{0xFF5E,0xA1C1},
{0xFF61,0xA1},
{0xFF62,0xA2}, {0xFF63,0xA3}, {0xFF64,0xA4}, {0xFF65,0xA5}, {0xFF66,0xA6},
{0xFF67,0xA7}, {0xFF68,0xA8}, {0xFF69,0xA9}, {0xFF6A,0xAA}, {0xFF6B,0xAB},
{0xFF6C,0xAC}, {0xFF6D,0xAD}, {0xFF6E,0xAE}, {0xFF6F,0xAF}, {0xFF70,0xB0},
{0xFF71,0xB1}, {0xFF72,0xB2}, {0xFF73,0xB3}, {0xFF74,0xB4}, {0xFF75,0xB5},
{0xFF76,0xB6}, {0xFF77,0xB7}, {0xFF78,0xB8}, {0xFF79,0xB9}, {0xFF7A,0xBA},
{0xFF7B,0xBB}, {0xFF7C,0xBC}, {0xFF7D,0xBD}, {0xFF7E,0xBE}, {0xFF7F,0xBF},
{0xFF80,0xC0}, {0xFF81,0xC1}, {0xFF82,0xC2}, {0xFF83,0xC3}, {0xFF84,0xC4},
{0xFF85,0xC5}, {0xFF86,0xC6}, {0xFF87,0xC7}, {0xFF88,0xC8}, {0xFF89,0xC9},
{0xFF8A,0xCA}, {0xFF8B,0xCB}, {0xFF8C,0xCC}, {0xFF8D,0xCD}, {0xFF8E,0xCE},
{0xFF8F,0xCF}, {0xFF90,0xD0}, {0xFF91,0xD1}, {0xFF92,0xD2}, {0xFF93,0xD3},
{0xFF94,0xD4}, {0xFF95,0xD5}, {0xFF96,0xD6}, {0xFF97,0xD7}, {0xFF98,0xD8},
{0xFF99,0xD9}, {0xFF9A,0xDA}, {0xFF9B,0xDB}, {0xFF9C,0xDC}, {0xFF9D,0xDD},
{0xFF9E,0xDE}, {0xFF9F,0xDF},
{0xFFE0,0xA1F1},
{0xFFE1,0xA1F2},
{0xFFE2,0xa2cc}, 
{0xFFE3,0xA1B1},
{0xFFE4,0x2243},
{0xFFE5,0xA1EF}
# endif /* LYNX */
};

int
CharSetCvtUTF8toEUCJP::MapCount()
{
	return sizeof(UCS2toEUCJP) / sizeof(*UCS2toEUCJP);
}

CharSetCvt::MapEnt
CharSetCvtEUCJPtoUTF8::EUCJPtoUCS2[] = {
# ifndef OS_LYNX
{0x20,0x0020}, {0x21,0x0021}, {0x22,0x0022}, {0x23,0x0023}, {0x24,0x0024},
{0x25,0x0025}, {0x26,0x0026}, {0x27,0x0027}, {0x28,0x0028}, {0x29,0x0029},
{0x2A,0x002A}, {0x2B,0x002B}, {0x2C,0x002C}, {0x2D,0x002D}, {0x2E,0x002E},
{0x2F,0x002F}, {0x30,0x0030}, {0x31,0x0031}, {0x32,0x0032}, {0x33,0x0033},
{0x34,0x0034}, {0x35,0x0035}, {0x36,0x0036}, {0x37,0x0037}, {0x38,0x0038},
{0x39,0x0039}, {0x3A,0x003A}, {0x3B,0x003B}, {0x3C,0x003C}, {0x3D,0x003D},
{0x3E,0x003E}, {0x3F,0x003F}, {0x40,0x0040}, {0x41,0x0041}, {0x42,0x0042},
{0x43,0x0043}, {0x44,0x0044}, {0x45,0x0045}, {0x46,0x0046}, {0x47,0x0047},
{0x48,0x0048}, {0x49,0x0049}, {0x4A,0x004A}, {0x4B,0x004B}, {0x4C,0x004C},
{0x4D,0x004D}, {0x4E,0x004E}, {0x4F,0x004F}, {0x50,0x0050}, {0x51,0x0051},
{0x52,0x0052}, {0x53,0x0053}, {0x54,0x0054}, {0x55,0x0055}, {0x56,0x0056},
{0x57,0x0057}, {0x58,0x0058}, {0x59,0x0059}, {0x5A,0x005A}, {0x5B,0x005B},

# ifdef UNICODE_MAPPING
{0x5C,0x00A5},
#else
{0x5C,0x005C},
#endif
             {0x5D,0x005D}, {0x5E,0x005E}, {0x5F,0x005F}, {0x60,0x0060},
{0x61,0x0061}, {0x62,0x0062}, {0x63,0x0063}, {0x64,0x0064}, {0x65,0x0065},
{0x66,0x0066}, {0x67,0x0067}, {0x68,0x0068}, {0x69,0x0069}, {0x6A,0x006A},
{0x6B,0x006B}, {0x6C,0x006C}, {0x6D,0x006D}, {0x6E,0x006E}, {0x6F,0x006F},
{0x70,0x0070}, {0x71,0x0071}, {0x72,0x0072}, {0x73,0x0073}, {0x74,0x0074},
{0x75,0x0075}, {0x76,0x0076}, {0x77,0x0077}, {0x78,0x0078}, {0x79,0x0079},
{0x7A,0x007A}, {0x7B,0x007B}, {0x7C,0x007C}, {0x7D,0x007D}, {0x7E,0x007e},
{0xA0,0xF8F0},
{0xA1,0xFF61}, {0xA2,0xFF62}, {0xA3,0xFF63}, {0xA4,0xFF64}, {0xA5,0xFF65},
{0xA6,0xFF66}, {0xA7,0xFF67}, {0xA8,0xFF68}, {0xA9,0xFF69}, {0xAA,0xFF6A},
{0xAB,0xFF6B}, {0xAC,0xFF6C}, {0xAD,0xFF6D}, {0xAE,0xFF6E}, {0xAF,0xFF6F},
{0xB0,0xFF70}, {0xB1,0xFF71}, {0xB2,0xFF72}, {0xB3,0xFF73}, {0xB4,0xFF74},
{0xB5,0xFF75}, {0xB6,0xFF76}, {0xB7,0xFF77}, {0xB8,0xFF78}, {0xB9,0xFF79},
{0xBA,0xFF7A}, {0xBB,0xFF7B}, {0xBC,0xFF7C}, {0xBD,0xFF7D}, {0xBE,0xFF7E},
{0xBF,0xFF7F}, {0xC0,0xFF80}, {0xC1,0xFF81}, {0xC2,0xFF82}, {0xC3,0xFF83},
{0xC4,0xFF84}, {0xC5,0xFF85}, {0xC6,0xFF86}, {0xC7,0xFF87}, {0xC8,0xFF88},
{0xC9,0xFF89}, {0xCA,0xFF8A}, {0xCB,0xFF8B}, {0xCC,0xFF8C}, {0xCD,0xFF8D},
{0xCE,0xFF8E}, {0xCF,0xFF8F}, {0xD0,0xFF90}, {0xD1,0xFF91}, {0xD2,0xFF92},
{0xD3,0xFF93}, {0xD4,0xFF94}, {0xD5,0xFF95}, {0xD6,0xFF96}, {0xD7,0xFF97},
{0xD8,0xFF98}, {0xD9,0xFF99}, {0xDA,0xFF9A}, {0xDB,0xFF9B}, {0xDC,0xFF9C},
{0xDD,0xFF9D}, {0xDE,0xFF9E}, {0xDF,0xFF9F}, {0xFD,0xF8F1}, {0xFE,0xF8F2},
{0xFF,0xF8F3}, {0x222F,0x02D8}, {0x2230,0x02C7},
{0x2231,0x00B8}, {0x2232,0x02D9}, {0x2233,0x02DD}, {0x2234,0x00AF}, {0x2235,0x02DB},
{0x2236,0x02DA}, {0x2237,0x007E}, {0x2238,0x0384}, {0x2239,0x0385}, {0x2242,0x00A1},
{0x2243,0xffe4}, {0x2244,0x00BF}, {0x226B,0x00BA}, {0x226C,0x00AA}, {0x226D,0x00A9},
{0x226E,0x00AE}, {0x226F,0x2122}, {0x2270,0x00A4}, {0x2271,0x2116}, {0x2661,0x0386},
{0x2662,0x0388}, {0x2663,0x0389}, {0x2664,0x038A}, {0x2665,0x03AA}, {0x2667,0x038C},
{0x2669,0x038E}, {0x266A,0x03AB}, {0x266C,0x038F}, {0x2671,0x03AC}, {0x2672,0x03AD},
{0x2673,0x03AE}, {0x2674,0x03AF}, {0x2675,0x03CA}, {0x2676,0x0390}, {0x2677,0x03CC},
{0x2678,0x03C2}, {0x2679,0x03CD}, {0x267A,0x03CB}, {0x267B,0x03B0}, {0x267C,0x03CE},
{0x2742,0x0402}, {0x2743,0x0403}, {0x2744,0x0404}, {0x2745,0x0405}, {0x2746,0x0406},
{0x2747,0x0407}, {0x2748,0x0408}, {0x2749,0x0409}, {0x274A,0x040A}, {0x274B,0x040B},
{0x274C,0x040C}, {0x274D,0x040E}, {0x274E,0x040F}, {0x2772,0x0452}, {0x2773,0x0453},
{0x2774,0x0454}, {0x2775,0x0455}, {0x2776,0x0456}, {0x2777,0x0457}, {0x2778,0x0458},
{0x2779,0x0459}, {0x277A,0x045A}, {0x277B,0x045B}, {0x277C,0x045C}, {0x277D,0x045E},
{0x277E,0x045F}, {0x2921,0x00C6}, {0x2922,0x0110}, {0x2924,0x0126}, {0x2926,0x0132},
{0x2928,0x0141}, {0x2929,0x013F}, {0x292B,0x014A}, {0x292C,0x00D8}, {0x292D,0x0152},
{0x292F,0x0166}, {0x2930,0x00DE}, {0x2941,0x00E6}, {0x2942,0x0111}, {0x2943,0x00F0},
{0x2944,0x0127}, {0x2945,0x0131}, {0x2946,0x0133}, {0x2947,0x0138}, {0x2948,0x0142},
{0x2949,0x0140}, {0x294A,0x0149}, {0x294B,0x014B}, {0x294C,0x00F8}, {0x294D,0x0153},
{0x294E,0x00DF}, {0x294F,0x0167}, {0x2950,0x00FE}, {0x2A21,0x00C1}, {0x2A22,0x00C0},
{0x2A23,0x00C4}, {0x2A24,0x00C2}, {0x2A25,0x0102}, {0x2A26,0x01CD}, {0x2A27,0x0100},
{0x2A28,0x0104}, {0x2A29,0x00C5}, {0x2A2A,0x00C3}, {0x2A2B,0x0106}, {0x2A2C,0x0108},
{0x2A2D,0x010C}, {0x2A2E,0x00C7}, {0x2A2F,0x010A}, {0x2A30,0x010E}, {0x2A31,0x00C9},
{0x2A32,0x00C8}, {0x2A33,0x00CB}, {0x2A34,0x00CA}, {0x2A35,0x011A}, {0x2A36,0x0116},
{0x2A37,0x0112}, {0x2A38,0x0118}, {0x2A3A,0x011C}, {0x2A3B,0x011E}, {0x2A3C,0x0122},
{0x2A3D,0x0120}, {0x2A3E,0x0124}, {0x2A3F,0x00CD}, {0x2A40,0x00CC}, {0x2A41,0x00CF},
{0x2A42,0x00CE}, {0x2A43,0x01CF}, {0x2A44,0x0130}, {0x2A45,0x012A}, {0x2A46,0x012E},
{0x2A47,0x0128}, {0x2A48,0x0134}, {0x2A49,0x0136}, {0x2A4A,0x0139}, {0x2A4B,0x013D},
{0x2A4C,0x013B}, {0x2A4D,0x0143}, {0x2A4E,0x0147}, {0x2A4F,0x0145}, {0x2A50,0x00D1},
{0x2A51,0x00D3}, {0x2A52,0x00D2}, {0x2A53,0x00D6}, {0x2A54,0x00D4}, {0x2A55,0x01D1},
{0x2A56,0x0150}, {0x2A57,0x014C}, {0x2A58,0x00D5}, {0x2A59,0x0154}, {0x2A5A,0x0158},
{0x2A5B,0x0156}, {0x2A5C,0x015A}, {0x2A5D,0x015C}, {0x2A5E,0x0160}, {0x2A5F,0x015E},
{0x2A60,0x0164}, {0x2A61,0x0162}, {0x2A62,0x00DA}, {0x2A63,0x00D9}, {0x2A64,0x00DC},
{0x2A65,0x00DB}, {0x2A66,0x016C}, {0x2A67,0x01D3}, {0x2A68,0x0170}, {0x2A69,0x016A},
{0x2A6A,0x0172}, {0x2A6B,0x016E}, {0x2A6C,0x0168}, {0x2A6D,0x01D7}, {0x2A6E,0x01DB},
{0x2A6F,0x01D9}, {0x2A70,0x01D5}, {0x2A71,0x0174}, {0x2A72,0x00DD}, {0x2A73,0x0178},
{0x2A74,0x0176}, {0x2A75,0x0179}, {0x2A76,0x017D}, {0x2A77,0x017B}, {0x2B21,0x00E1},
{0x2B22,0x00E0}, {0x2B23,0x00E4}, {0x2B24,0x00E2}, {0x2B25,0x0103}, {0x2B26,0x01CE},
{0x2B27,0x0101}, {0x2B28,0x0105}, {0x2B29,0x00E5}, {0x2B2A,0x00E3}, {0x2B2B,0x0107},
{0x2B2C,0x0109}, {0x2B2D,0x010D}, {0x2B2E,0x00E7}, {0x2B2F,0x010B}, {0x2B30,0x010F},
{0x2B31,0x00E9}, {0x2B32,0x00E8}, {0x2B33,0x00EB}, {0x2B34,0x00EA}, {0x2B35,0x011B},
{0x2B36,0x0117}, {0x2B37,0x0113}, {0x2B38,0x0119}, {0x2B39,0x01F5}, {0x2B3A,0x011D},
{0x2B3B,0x011F}, {0x2B3D,0x0121}, {0x2B3E,0x0125}, {0x2B3F,0x00ED}, {0x2B40,0x00EC},
{0x2B41,0x00EF}, {0x2B42,0x00EE}, {0x2B43,0x01D0}, {0x2B45,0x012B}, {0x2B46,0x012F},
{0x2B47,0x0129}, {0x2B48,0x0135}, {0x2B49,0x0137}, {0x2B4A,0x013A}, {0x2B4B,0x013E},
{0x2B4C,0x013C}, {0x2B4D,0x0144}, {0x2B4E,0x0148}, {0x2B4F,0x0146}, {0x2B50,0x00F1},
{0x2B51,0x00F3}, {0x2B52,0x00F2}, {0x2B53,0x00F6}, {0x2B54,0x00F4}, {0x2B55,0x01D2},
{0x2B56,0x0151}, {0x2B57,0x014D}, {0x2B58,0x00F5}, {0x2B59,0x0155}, {0x2B5A,0x0159},
{0x2B5B,0x0157}, {0x2B5C,0x015B}, {0x2B5D,0x015D}, {0x2B5E,0x0161}, {0x2B5F,0x015F},
{0x2B60,0x0165}, {0x2B61,0x0163}, {0x2B62,0x00FA}, {0x2B63,0x00F9}, {0x2B64,0x00FC},
{0x2B65,0x00FB}, {0x2B66,0x016D}, {0x2B67,0x01D4}, {0x2B68,0x0171}, {0x2B69,0x016B},
{0x2B6A,0x0173}, {0x2B6B,0x016F}, {0x2B6C,0x0169}, {0x2B6D,0x01D8}, {0x2B6E,0x01DC},
{0x2B6F,0x01DA}, {0x2B70,0x01D6}, {0x2B71,0x0175}, {0x2B72,0x00FD}, {0x2B73,0x00FF},
{0x2B74,0x0177}, {0x2B75,0x017A}, {0x2B76,0x017E}, {0x2B77,0x017C}, {0x3021,0x4E02},
{0x3022,0x4E04}, {0x3023,0x4E05}, {0x3024,0x4E0C}, {0x3025,0x4E12}, {0x3026,0x4E1F},
{0x3027,0x4E23}, {0x3028,0x4E24}, {0x3029,0x4E28}, {0x302A,0x4E2B}, {0x302B,0x4E2E},
{0x302C,0x4E2F}, {0x302D,0x4E30}, {0x302E,0x4E35}, {0x302F,0x4E40}, {0x3030,0x4E41},
{0x3031,0x4E44}, {0x3032,0x4E47}, {0x3033,0x4E51}, {0x3034,0x4E5A}, {0x3035,0x4E5C},
{0x3036,0x4E63}, {0x3037,0x4E68}, {0x3038,0x4E69}, {0x3039,0x4E74}, {0x303A,0x4E75},
{0x303B,0x4E79}, {0x303C,0x4E7F}, {0x303D,0x4E8D}, {0x303E,0x4E96}, {0x303F,0x4E97},
{0x3040,0x4E9D}, {0x3041,0x4EAF}, {0x3042,0x4EB9}, {0x3043,0x4EC3}, {0x3044,0x4ED0},
{0x3045,0x4EDA}, {0x3046,0x4EDB}, {0x3047,0x4EE0}, {0x3048,0x4EE1}, {0x3049,0x4EE2},
{0x304A,0x4EE8}, {0x304B,0x4EEF}, {0x304C,0x4EF1}, {0x304D,0x4EF3}, {0x304E,0x4EF5},
{0x304F,0x4EFD}, {0x3050,0x4EFE}, {0x3051,0x4EFF}, {0x3052,0x4F00}, {0x3053,0x4F02},
{0x3054,0x4F03}, {0x3055,0x4F08}, {0x3056,0x4F0B}, {0x3057,0x4F0C}, {0x3058,0x4F12},
{0x3059,0x4F15}, {0x305A,0x4F16}, {0x305B,0x4F17}, {0x305C,0x4F19}, {0x305D,0x4F2E},
{0x305E,0x4F31}, {0x305F,0x4F60}, {0x3060,0x4F33}, {0x3061,0x4F35}, {0x3062,0x4F37},
{0x3063,0x4F39}, {0x3064,0x4F3B}, {0x3065,0x4F3E}, {0x3066,0x4F40}, {0x3067,0x4F42},
{0x3068,0x4F48}, {0x3069,0x4F49}, {0x306A,0x4F4B}, {0x306B,0x4F4C}, {0x306C,0x4F52},
{0x306D,0x4F54}, {0x306E,0x4F56}, {0x306F,0x4F58}, {0x3070,0x4F5F}, {0x3071,0x4F63},
{0x3072,0x4F6A}, {0x3073,0x4F6C}, {0x3074,0x4F6E}, {0x3075,0x4F71}, {0x3076,0x4F77},
{0x3077,0x4F78}, {0x3078,0x4F79}, {0x3079,0x4F7A}, {0x307A,0x4F7D}, {0x307B,0x4F7E},
{0x307C,0x4F81}, {0x307D,0x4F82}, {0x307E,0x4F84}, {0x3121,0x4F85}, {0x3122,0x4F89},
{0x3123,0x4F8A}, {0x3124,0x4F8C}, {0x3125,0x4F8E}, {0x3126,0x4F90}, {0x3127,0x4F92},
{0x3128,0x4F93}, {0x3129,0x4F94}, {0x312A,0x4F97}, {0x312B,0x4F99}, {0x312C,0x4F9A},
{0x312D,0x4F9E}, {0x312E,0x4F9F}, {0x312F,0x4FB2}, {0x3130,0x4FB7}, {0x3131,0x4FB9},
{0x3132,0x4FBB}, {0x3133,0x4FBC}, {0x3134,0x4FBD}, {0x3135,0x4FBE}, {0x3136,0x4FC0},
{0x3137,0x4FC1}, {0x3138,0x4FC5}, {0x3139,0x4FC6}, {0x313A,0x4FC8}, {0x313B,0x4FC9},
{0x313C,0x4FCB}, {0x313D,0x4FCC}, {0x313E,0x4FCD}, {0x313F,0x4FCF}, {0x3140,0x4FD2},
{0x3141,0x4FDC}, {0x3142,0x4FE0}, {0x3143,0x4FE2}, {0x3144,0x4FF0}, {0x3145,0x4FF2},
{0x3146,0x4FFC}, {0x3147,0x4FFD}, {0x3148,0x4FFF}, {0x3149,0x5000}, {0x314A,0x5001},
{0x314B,0x5004}, {0x314C,0x5007}, {0x314D,0x500A}, {0x314E,0x500C}, {0x314F,0x500E},
{0x3150,0x5010}, {0x3151,0x5013}, {0x3152,0x5017}, {0x3153,0x5018}, {0x3154,0x501B},
{0x3155,0x501C}, {0x3156,0x501D}, {0x3157,0x501E}, {0x3158,0x5022}, {0x3159,0x5027},
{0x315A,0x502E}, {0x315B,0x5030}, {0x315C,0x5032}, {0x315D,0x5033}, {0x315E,0x5035},
{0x315F,0x5040}, {0x3160,0x5041}, {0x3161,0x5042}, {0x3162,0x5045}, {0x3163,0x5046},
{0x3164,0x504A}, {0x3165,0x504C}, {0x3166,0x504E}, {0x3167,0x5051}, {0x3168,0x5052},
{0x3169,0x5053}, {0x316A,0x5057}, {0x316B,0x5059}, {0x316C,0x505F}, {0x316D,0x5060},
{0x316E,0x5062}, {0x316F,0x5063}, {0x3170,0x5066}, {0x3171,0x5067}, {0x3172,0x506A},
{0x3173,0x506D}, {0x3174,0x5070}, {0x3175,0x5071}, {0x3176,0x503B}, {0x3177,0x5081},
{0x3178,0x5083}, {0x3179,0x5084}, {0x317A,0x5086}, {0x317B,0x508A}, {0x317C,0x508E},
{0x317D,0x508F}, {0x317E,0x5090}, {0x3221,0x5092}, {0x3222,0x5093}, {0x3223,0x5094},
{0x3224,0x5096}, {0x3225,0x509B}, {0x3226,0x509C}, {0x3227,0x509E}, {0x3228,0x509F},
{0x3229,0x50A0}, {0x322A,0x50A1}, {0x322B,0x50A2}, {0x322C,0x50AA}, {0x322D,0x50AF},
{0x322E,0x50B0}, {0x322F,0x50B9}, {0x3230,0x50BA}, {0x3231,0x50BD}, {0x3232,0x50C0},
{0x3233,0x50C3}, {0x3234,0x50C4}, {0x3235,0x50C7}, {0x3236,0x50CC}, {0x3237,0x50CE},
{0x3238,0x50D0}, {0x3239,0x50D3}, {0x323A,0x50D4}, {0x323B,0x50D8}, {0x323C,0x50DC},
{0x323D,0x50DD}, {0x323E,0x50DF}, {0x323F,0x50E2}, {0x3240,0x50E4}, {0x3241,0x50E6},
{0x3242,0x50E8}, {0x3243,0x50E9}, {0x3244,0x50EF}, {0x3245,0x50F1}, {0x3246,0x50F6},
{0x3247,0x50FA}, {0x3248,0x50FE}, {0x3249,0x5103}, {0x324A,0x5106}, {0x324B,0x5107},
{0x324C,0x5108}, {0x324D,0x510B}, {0x324E,0x510C}, {0x324F,0x510D}, {0x3250,0x510E},
{0x3251,0x50F2}, {0x3252,0x5110}, {0x3253,0x5117}, {0x3254,0x5119}, {0x3255,0x511B},
{0x3256,0x511C}, {0x3257,0x511D}, {0x3258,0x511E}, {0x3259,0x5123}, {0x325A,0x5127},
{0x325B,0x5128}, {0x325C,0x512C}, {0x325D,0x512D}, {0x325E,0x512F}, {0x325F,0x5131},
{0x3260,0x5133}, {0x3261,0x5134}, {0x3262,0x5135}, {0x3263,0x5138}, {0x3264,0x5139},
{0x3265,0x5142}, {0x3266,0x514A}, {0x3267,0x514F}, {0x3268,0x5153}, {0x3269,0x5155},
{0x326A,0x5157}, {0x326B,0x5158}, {0x326C,0x515F}, {0x326D,0x5164}, {0x326E,0x5166},
{0x326F,0x517E}, {0x3270,0x5183}, {0x3271,0x5184}, {0x3272,0x518B}, {0x3273,0x518E},
{0x3274,0x5198}, {0x3275,0x519D}, {0x3276,0x51A1}, {0x3277,0x51A3}, {0x3278,0x51AD},
{0x3279,0x51B8}, {0x327A,0x51BA}, {0x327B,0x51BC}, {0x327C,0x51BE}, {0x327D,0x51BF},
{0x327E,0x51C2}, {0x3321,0x51C8}, {0x3322,0x51CF}, {0x3323,0x51D1}, {0x3324,0x51D2},
{0x3325,0x51D3}, {0x3326,0x51D5}, {0x3327,0x51D8}, {0x3328,0x51DE}, {0x3329,0x51E2},
{0x332A,0x51E5}, {0x332B,0x51EE}, {0x332C,0x51F2}, {0x332D,0x51F3}, {0x332E,0x51F4},
{0x332F,0x51F7}, {0x3330,0x5201}, {0x3331,0x5202}, {0x3332,0x5205}, {0x3333,0x5212},
{0x3334,0x5213}, {0x3335,0x5215}, {0x3336,0x5216}, {0x3337,0x5218}, {0x3338,0x5222},
{0x3339,0x5228}, {0x333A,0x5231}, {0x333B,0x5232}, {0x333C,0x5235}, {0x333D,0x523C},
{0x333E,0x5245}, {0x333F,0x5249}, {0x3340,0x5255}, {0x3341,0x5257}, {0x3342,0x5258},
{0x3343,0x525A}, {0x3344,0x525C}, {0x3345,0x525F}, {0x3346,0x5260}, {0x3347,0x5261},
{0x3348,0x5266}, {0x3349,0x526E}, {0x334A,0x5277}, {0x334B,0x5278}, {0x334C,0x5279},
{0x334D,0x5280}, {0x334E,0x5282}, {0x334F,0x5285}, {0x3350,0x528A}, {0x3351,0x528C},
{0x3352,0x5293}, {0x3353,0x5295}, {0x3354,0x5296}, {0x3355,0x5297}, {0x3356,0x5298},
{0x3357,0x529A}, {0x3358,0x529C}, {0x3359,0x52A4}, {0x335A,0x52A5}, {0x335B,0x52A6},
{0x335C,0x52A7}, {0x335D,0x52AF}, {0x335E,0x52B0}, {0x335F,0x52B6}, {0x3360,0x52B7},
{0x3361,0x52B8}, {0x3362,0x52BA}, {0x3363,0x52BB}, {0x3364,0x52BD}, {0x3365,0x52C0},
{0x3366,0x52C4}, {0x3367,0x52C6}, {0x3368,0x52C8}, {0x3369,0x52CC}, {0x336A,0x52CF},
{0x336B,0x52D1}, {0x336C,0x52D4}, {0x336D,0x52D6}, {0x336E,0x52DB}, {0x336F,0x52DC},
{0x3370,0x52E1}, {0x3371,0x52E5}, {0x3372,0x52E8}, {0x3373,0x52E9}, {0x3374,0x52EA},
{0x3375,0x52EC}, {0x3376,0x52F0}, {0x3377,0x52F1}, {0x3378,0x52F4}, {0x3379,0x52F6},
{0x337A,0x52F7}, {0x337B,0x5300}, {0x337C,0x5303}, {0x337D,0x530A}, {0x337E,0x530B},
{0x3421,0x530C}, {0x3422,0x5311}, {0x3423,0x5313}, {0x3424,0x5318}, {0x3425,0x531B},
{0x3426,0x531C}, {0x3427,0x531E}, {0x3428,0x531F}, {0x3429,0x5325}, {0x342A,0x5327},
{0x342B,0x5328}, {0x342C,0x5329}, {0x342D,0x532B}, {0x342E,0x532C}, {0x342F,0x532D},
{0x3430,0x5330}, {0x3431,0x5332}, {0x3432,0x5335}, {0x3433,0x533C}, {0x3434,0x533D},
{0x3435,0x533E}, {0x3436,0x5342}, {0x3437,0x534C}, {0x3438,0x534B}, {0x3439,0x5359},
{0x343A,0x535B}, {0x343B,0x5361}, {0x343C,0x5363}, {0x343D,0x5365}, {0x343E,0x536C},
{0x343F,0x536D}, {0x3440,0x5372}, {0x3441,0x5379}, {0x3442,0x537E}, {0x3443,0x5383},
{0x3444,0x5387}, {0x3445,0x5388}, {0x3446,0x538E}, {0x3447,0x5393}, {0x3448,0x5394},
{0x3449,0x5399}, {0x344A,0x539D}, {0x344B,0x53A1}, {0x344C,0x53A4}, {0x344D,0x53AA},
{0x344E,0x53AB}, {0x344F,0x53AF}, {0x3450,0x53B2}, {0x3451,0x53B4}, {0x3452,0x53B5},
{0x3453,0x53B7}, {0x3454,0x53B8}, {0x3455,0x53BA}, {0x3456,0x53BD}, {0x3457,0x53C0},
{0x3458,0x53C5}, {0x3459,0x53CF}, {0x345A,0x53D2}, {0x345B,0x53D3}, {0x345C,0x53D5},
{0x345D,0x53DA}, {0x345E,0x53DD}, {0x345F,0x53DE}, {0x3460,0x53E0}, {0x3461,0x53E6},
{0x3462,0x53E7}, {0x3463,0x53F5}, {0x3464,0x5402}, {0x3465,0x5413}, {0x3466,0x541A},
{0x3467,0x5421}, {0x3468,0x5427}, {0x3469,0x5428}, {0x346A,0x542A}, {0x346B,0x542F},
{0x346C,0x5431}, {0x346D,0x5434}, {0x346E,0x5435}, {0x346F,0x5443}, {0x3470,0x5444},
{0x3471,0x5447}, {0x3472,0x544D}, {0x3473,0x544F}, {0x3474,0x545E}, {0x3475,0x5462},
{0x3476,0x5464}, {0x3477,0x5466}, {0x3478,0x5467}, {0x3479,0x5469}, {0x347A,0x546B},
{0x347B,0x546D}, {0x347C,0x546E}, {0x347D,0x5474}, {0x347E,0x547F}, {0x3521,0x5481},
{0x3522,0x5483}, {0x3523,0x5485}, {0x3524,0x5488}, {0x3525,0x5489}, {0x3526,0x548D},
{0x3527,0x5491}, {0x3528,0x5495}, {0x3529,0x5496}, {0x352A,0x549C}, {0x352B,0x549F},
{0x352C,0x54A1}, {0x352D,0x54A6}, {0x352E,0x54A7}, {0x352F,0x54A9}, {0x3530,0x54AA},
{0x3531,0x54AD}, {0x3532,0x54AE}, {0x3533,0x54B1}, {0x3534,0x54B7}, {0x3535,0x54B9},
{0x3536,0x54BA}, {0x3537,0x54BB}, {0x3538,0x54BF}, {0x3539,0x54C6}, {0x353A,0x54CA},
{0x353B,0x54CD}, {0x353C,0x54CE}, {0x353D,0x54E0}, {0x353E,0x54EA}, {0x353F,0x54EC},
{0x3540,0x54EF}, {0x3541,0x54F6}, {0x3542,0x54FC}, {0x3543,0x54FE}, {0x3544,0x54FF},
{0x3545,0x5500}, {0x3546,0x5501}, {0x3547,0x5505}, {0x3548,0x5508}, {0x3549,0x5509},
{0x354A,0x550C}, {0x354B,0x550D}, {0x354C,0x550E}, {0x354D,0x5515}, {0x354E,0x552A},
{0x354F,0x552B}, {0x3550,0x5532}, {0x3551,0x5535}, {0x3552,0x5536}, {0x3553,0x553B},
{0x3554,0x553C}, {0x3555,0x553D}, {0x3556,0x5541}, {0x3557,0x5547}, {0x3558,0x5549},
{0x3559,0x554A}, {0x355A,0x554D}, {0x355B,0x5550}, {0x355C,0x5551}, {0x355D,0x5558},
{0x355E,0x555A}, {0x355F,0x555B}, {0x3560,0x555E}, {0x3561,0x5560}, {0x3562,0x5561},
{0x3563,0x5564}, {0x3564,0x5566}, {0x3565,0x557F}, {0x3566,0x5581}, {0x3567,0x5582},
{0x3568,0x5586}, {0x3569,0x5588}, {0x356A,0x558E}, {0x356B,0x558F}, {0x356C,0x5591},
{0x356D,0x5592}, {0x356E,0x5593}, {0x356F,0x5594}, {0x3570,0x5597}, {0x3571,0x55A3},
{0x3572,0x55A4}, {0x3573,0x55AD}, {0x3574,0x55B2}, {0x3575,0x55BF}, {0x3576,0x55C1},
{0x3577,0x55C3}, {0x3578,0x55C6}, {0x3579,0x55C9}, {0x357A,0x55CB}, {0x357B,0x55CC},
{0x357C,0x55CE}, {0x357D,0x55D1}, {0x357E,0x55D2}, {0x3621,0x55D3}, {0x3622,0x55D7},
{0x3623,0x55D8}, {0x3624,0x55DB}, {0x3625,0x55DE}, {0x3626,0x55E2}, {0x3627,0x55E9},
{0x3628,0x55F6}, {0x3629,0x55FF}, {0x362A,0x5605}, {0x362B,0x5608}, {0x362C,0x560A},
{0x362D,0x560D}, {0x362E,0x560E}, {0x362F,0x560F}, {0x3630,0x5610}, {0x3631,0x5611},
{0x3632,0x5612}, {0x3633,0x5619}, {0x3634,0x562C}, {0x3635,0x5630}, {0x3636,0x5633},
{0x3637,0x5635}, {0x3638,0x5637}, {0x3639,0x5639}, {0x363A,0x563B}, {0x363B,0x563C},
{0x363C,0x563D}, {0x363D,0x563F}, {0x363E,0x5640}, {0x363F,0x5641}, {0x3640,0x5643},
{0x3641,0x5644}, {0x3642,0x5646}, {0x3643,0x5649}, {0x3644,0x564B}, {0x3645,0x564D},
{0x3646,0x564F}, {0x3647,0x5654}, {0x3648,0x565E}, {0x3649,0x5660}, {0x364A,0x5661},
{0x364B,0x5662}, {0x364C,0x5663}, {0x364D,0x5666}, {0x364E,0x5669}, {0x364F,0x566D},
{0x3650,0x566F}, {0x3651,0x5671}, {0x3652,0x5672}, {0x3653,0x5675}, {0x3654,0x5684},
{0x3655,0x5685}, {0x3656,0x5688}, {0x3657,0x568B}, {0x3658,0x568C}, {0x3659,0x5695},
{0x365A,0x5699}, {0x365B,0x569A}, {0x365C,0x569D}, {0x365D,0x569E}, {0x365E,0x569F},
{0x365F,0x56A6}, {0x3660,0x56A7}, {0x3661,0x56A8}, {0x3662,0x56A9}, {0x3663,0x56AB},
{0x3664,0x56AC}, {0x3665,0x56AD}, {0x3666,0x56B1}, {0x3667,0x56B3}, {0x3668,0x56B7},
{0x3669,0x56BE}, {0x366A,0x56C5}, {0x366B,0x56C9}, {0x366C,0x56CA}, {0x366D,0x56CB},
{0x366E,0x56CF}, {0x366F,0x56D0}, {0x3670,0x56CC}, {0x3671,0x56CD}, {0x3672,0x56D9},
{0x3673,0x56DC}, {0x3674,0x56DD}, {0x3675,0x56DF}, {0x3676,0x56E1}, {0x3677,0x56E4},
{0x3678,0x56E5}, {0x3679,0x56E6}, {0x367A,0x56E7}, {0x367B,0x56E8}, {0x367C,0x56F1},
{0x367D,0x56EB}, {0x367E,0x56ED}, {0x3721,0x56F6}, {0x3722,0x56F7}, {0x3723,0x5701},
{0x3724,0x5702}, {0x3725,0x5707}, {0x3726,0x570A}, {0x3727,0x570C}, {0x3728,0x5711},
{0x3729,0x5715}, {0x372A,0x571A}, {0x372B,0x571B}, {0x372C,0x571D}, {0x372D,0x5720},
{0x372E,0x5722}, {0x372F,0x5723}, {0x3730,0x5724}, {0x3731,0x5725}, {0x3732,0x5729},
{0x3733,0x572A}, {0x3734,0x572C}, {0x3735,0x572E}, {0x3736,0x572F}, {0x3737,0x5733},
{0x3738,0x5734}, {0x3739,0x573D}, {0x373A,0x573E}, {0x373B,0x573F}, {0x373C,0x5745},
{0x373D,0x5746}, {0x373E,0x574C}, {0x373F,0x574D}, {0x3740,0x5752}, {0x3741,0x5762},
{0x3742,0x5765}, {0x3743,0x5767}, {0x3744,0x5768}, {0x3745,0x576B}, {0x3746,0x576D},
{0x3747,0x576E}, {0x3748,0x576F}, {0x3749,0x5770}, {0x374A,0x5771}, {0x374B,0x5773},
{0x374C,0x5774}, {0x374D,0x5775}, {0x374E,0x5777}, {0x374F,0x5779}, {0x3750,0x577A},
{0x3751,0x577B}, {0x3752,0x577C}, {0x3753,0x577E}, {0x3754,0x5781}, {0x3755,0x5783},
{0x3756,0x578C}, {0x3757,0x5794}, {0x3758,0x5797}, {0x3759,0x5799}, {0x375A,0x579A},
{0x375B,0x579C}, {0x375C,0x579D}, {0x375D,0x579E}, {0x375E,0x579F}, {0x375F,0x57A1},
{0x3760,0x5795}, {0x3761,0x57A7}, {0x3762,0x57A8}, {0x3763,0x57A9}, {0x3764,0x57AC},
{0x3765,0x57B8}, {0x3766,0x57BD}, {0x3767,0x57C7}, {0x3768,0x57C8}, {0x3769,0x57CC},
{0x376A,0x57CF}, {0x376B,0x57D5}, {0x376C,0x57DD}, {0x376D,0x57DE}, {0x376E,0x57E4},
{0x376F,0x57E6}, {0x3770,0x57E7}, {0x3771,0x57E9}, {0x3772,0x57ED}, {0x3773,0x57F0},
{0x3774,0x57F5}, {0x3775,0x57F6}, {0x3776,0x57F8}, {0x3777,0x57FD}, {0x3778,0x57FE},
{0x3779,0x57FF}, {0x377A,0x5803}, {0x377B,0x5804}, {0x377C,0x5808}, {0x377D,0x5809},
{0x377E,0x57E1}, {0x3821,0x580C}, {0x3822,0x580D}, {0x3823,0x581B}, {0x3824,0x581E},
{0x3825,0x581F}, {0x3826,0x5820}, {0x3827,0x5826}, {0x3828,0x5827}, {0x3829,0x582D},
{0x382A,0x5832}, {0x382B,0x5839}, {0x382C,0x583F}, {0x382D,0x5849}, {0x382E,0x584C},
{0x382F,0x584D}, {0x3830,0x584F}, {0x3831,0x5850}, {0x3832,0x5855}, {0x3833,0x585F},
{0x3834,0x5861}, {0x3835,0x5864}, {0x3836,0x5867}, {0x3837,0x5868}, {0x3838,0x5878},
{0x3839,0x587C}, {0x383A,0x587F}, {0x383B,0x5880}, {0x383C,0x5881}, {0x383D,0x5887},
{0x383E,0x5888}, {0x383F,0x5889}, {0x3840,0x588A}, {0x3841,0x588C}, {0x3842,0x588D},
{0x3843,0x588F}, {0x3844,0x5890}, {0x3845,0x5894}, {0x3846,0x5896}, {0x3847,0x589D},
{0x3848,0x58A0}, {0x3849,0x58A1}, {0x384A,0x58A2}, {0x384B,0x58A6}, {0x384C,0x58A9},
{0x384D,0x58B1}, {0x384E,0x58B2}, {0x384F,0x58C4}, {0x3850,0x58BC}, {0x3851,0x58C2},
{0x3852,0x58C8}, {0x3853,0x58CD}, {0x3854,0x58CE}, {0x3855,0x58D0}, {0x3856,0x58D2},
{0x3857,0x58D4}, {0x3858,0x58D6}, {0x3859,0x58DA}, {0x385A,0x58DD}, {0x385B,0x58E1},
{0x385C,0x58E2}, {0x385D,0x58E9}, {0x385E,0x58F3}, {0x385F,0x5905}, {0x3860,0x5906},
{0x3861,0x590B}, {0x3862,0x590C}, {0x3863,0x5912}, {0x3864,0x5913}, {0x3865,0x5914},
{0x3866,0x8641}, {0x3867,0x591D}, {0x3868,0x5921}, {0x3869,0x5923}, {0x386A,0x5924},
{0x386B,0x5928}, {0x386C,0x592F}, {0x386D,0x5930}, {0x386E,0x5933}, {0x386F,0x5935},
{0x3870,0x5936}, {0x3871,0x593F}, {0x3872,0x5943}, {0x3873,0x5946}, {0x3874,0x5952},
{0x3875,0x5953}, {0x3876,0x5959}, {0x3877,0x595B}, {0x3878,0x595D}, {0x3879,0x595E},
{0x387A,0x595F}, {0x387B,0x5961}, {0x387C,0x5963}, {0x387D,0x596B}, {0x387E,0x596D},
{0x3921,0x596F}, {0x3922,0x5972}, {0x3923,0x5975}, {0x3924,0x5976}, {0x3925,0x5979},
{0x3926,0x597B}, {0x3927,0x597C}, {0x3928,0x598B}, {0x3929,0x598C}, {0x392A,0x598E},
{0x392B,0x5992}, {0x392C,0x5995}, {0x392D,0x5997}, {0x392E,0x599F}, {0x392F,0x59A4},
{0x3930,0x59A7}, {0x3931,0x59AD}, {0x3932,0x59AE}, {0x3933,0x59AF}, {0x3934,0x59B0},
{0x3935,0x59B3}, {0x3936,0x59B7}, {0x3937,0x59BA}, {0x3938,0x59BC}, {0x3939,0x59C1},
{0x393A,0x59C3}, {0x393B,0x59C4}, {0x393C,0x59C8}, {0x393D,0x59CA}, {0x393E,0x59CD},
{0x393F,0x59D2}, {0x3940,0x59DD}, {0x3941,0x59DE}, {0x3942,0x59DF}, {0x3943,0x59E3},
{0x3944,0x59E4}, {0x3945,0x59E7}, {0x3946,0x59EE}, {0x3947,0x59EF}, {0x3948,0x59F1},
{0x3949,0x59F2}, {0x394A,0x59F4}, {0x394B,0x59F7}, {0x394C,0x5A00}, {0x394D,0x5A04},
{0x394E,0x5A0C}, {0x394F,0x5A0D}, {0x3950,0x5A0E}, {0x3951,0x5A12}, {0x3952,0x5A13},
{0x3953,0x5A1E}, {0x3954,0x5A23}, {0x3955,0x5A24}, {0x3956,0x5A27}, {0x3957,0x5A28},
{0x3958,0x5A2A}, {0x3959,0x5A2D}, {0x395A,0x5A30}, {0x395B,0x5A44}, {0x395C,0x5A45},
{0x395D,0x5A47}, {0x395E,0x5A48}, {0x395F,0x5A4C}, {0x3960,0x5A50}, {0x3961,0x5A55},
{0x3962,0x5A5E}, {0x3963,0x5A63}, {0x3964,0x5A65}, {0x3965,0x5A67}, {0x3966,0x5A6D},
{0x3967,0x5A77}, {0x3968,0x5A7A}, {0x3969,0x5A7B}, {0x396A,0x5A7E}, {0x396B,0x5A8B},
{0x396C,0x5A90}, {0x396D,0x5A93}, {0x396E,0x5A96}, {0x396F,0x5A99}, {0x3970,0x5A9C},
{0x3971,0x5A9E}, {0x3972,0x5A9F}, {0x3973,0x5AA0}, {0x3974,0x5AA2}, {0x3975,0x5AA7},
{0x3976,0x5AAC}, {0x3977,0x5AB1}, {0x3978,0x5AB2}, {0x3979,0x5AB3}, {0x397A,0x5AB5},
{0x397B,0x5AB8}, {0x397C,0x5ABA}, {0x397D,0x5ABB}, {0x397E,0x5ABF}, {0x3A21,0x5AC4},
{0x3A22,0x5AC6}, {0x3A23,0x5AC8}, {0x3A24,0x5ACF}, {0x3A25,0x5ADA}, {0x3A26,0x5ADC},
{0x3A27,0x5AE0}, {0x3A28,0x5AE5}, {0x3A29,0x5AEA}, {0x3A2A,0x5AEE}, {0x3A2B,0x5AF5},
{0x3A2C,0x5AF6}, {0x3A2D,0x5AFD}, {0x3A2E,0x5B00}, {0x3A2F,0x5B01}, {0x3A30,0x5B08},
{0x3A31,0x5B17}, {0x3A32,0x5B34}, {0x3A33,0x5B19}, {0x3A34,0x5B1B}, {0x3A35,0x5B1D},
{0x3A36,0x5B21}, {0x3A37,0x5B25}, {0x3A38,0x5B2D}, {0x3A39,0x5B38}, {0x3A3A,0x5B41},
{0x3A3B,0x5B4B}, {0x3A3C,0x5B4C}, {0x3A3D,0x5B52}, {0x3A3E,0x5B56}, {0x3A3F,0x5B5E},
{0x3A40,0x5B68}, {0x3A41,0x5B6E}, {0x3A42,0x5B6F}, {0x3A43,0x5B7C}, {0x3A44,0x5B7D},
{0x3A45,0x5B7E}, {0x3A46,0x5B7F}, {0x3A47,0x5B81}, {0x3A48,0x5B84}, {0x3A49,0x5B86},
{0x3A4A,0x5B8A}, {0x3A4B,0x5B8E}, {0x3A4C,0x5B90}, {0x3A4D,0x5B91}, {0x3A4E,0x5B93},
{0x3A4F,0x5B94}, {0x3A50,0x5B96}, {0x3A51,0x5BA8}, {0x3A52,0x5BA9}, {0x3A53,0x5BAC},
{0x3A54,0x5BAD}, {0x3A55,0x5BAF}, {0x3A56,0x5BB1}, {0x3A57,0x5BB2}, {0x3A58,0x5BB7},
{0x3A59,0x5BBA}, {0x3A5A,0x5BBC}, {0x3A5B,0x5BC0}, {0x3A5C,0x5BC1}, {0x3A5D,0x5BCD},
{0x3A5E,0x5BCF}, {0x3A5F,0x5BD6}, {0x3A60,0x5BD7}, {0x3A61,0x5BD8}, {0x3A62,0x5BD9},
{0x3A63,0x5BDA}, {0x3A64,0x5BE0}, {0x3A65,0x5BEF}, {0x3A66,0x5BF1}, {0x3A67,0x5BF4},
{0x3A68,0x5BFD}, {0x3A69,0x5C0C}, {0x3A6A,0x5C17}, {0x3A6B,0x5C1E}, {0x3A6C,0x5C1F},
{0x3A6D,0x5C23}, {0x3A6E,0x5C26}, {0x3A6F,0x5C29}, {0x3A70,0x5C2B}, {0x3A71,0x5C2C},
{0x3A72,0x5C2E}, {0x3A73,0x5C30}, {0x3A74,0x5C32}, {0x3A75,0x5C35}, {0x3A76,0x5C36},
{0x3A77,0x5C59}, {0x3A78,0x5C5A}, {0x3A79,0x5C5C}, {0x3A7A,0x5C62}, {0x3A7B,0x5C63},
{0x3A7C,0x5C67}, {0x3A7D,0x5C68}, {0x3A7E,0x5C69}, {0x3B21,0x5C6D}, {0x3B22,0x5C70},
{0x3B23,0x5C74}, {0x3B24,0x5C75}, {0x3B25,0x5C7A}, {0x3B26,0x5C7B}, {0x3B27,0x5C7C},
{0x3B28,0x5C7D}, {0x3B29,0x5C87}, {0x3B2A,0x5C88}, {0x3B2B,0x5C8A}, {0x3B2C,0x5C8F},
{0x3B2D,0x5C92}, {0x3B2E,0x5C9D}, {0x3B2F,0x5C9F}, {0x3B30,0x5CA0}, {0x3B31,0x5CA2},
{0x3B32,0x5CA3}, {0x3B33,0x5CA6}, {0x3B34,0x5CAA}, {0x3B35,0x5CB2}, {0x3B36,0x5CB4},
{0x3B37,0x5CB5}, {0x3B38,0x5CBA}, {0x3B39,0x5CC9}, {0x3B3A,0x5CCB}, {0x3B3B,0x5CD2},
{0x3B3C,0x5CDD}, {0x3B3D,0x5CD7}, {0x3B3E,0x5CEE}, {0x3B3F,0x5CF1}, {0x3B40,0x5CF2},
{0x3B41,0x5CF4}, {0x3B42,0x5D01}, {0x3B43,0x5D06}, {0x3B44,0x5D0D}, {0x3B45,0x5D12},
{0x3B46,0x5D2B}, {0x3B47,0x5D23}, {0x3B48,0x5D24}, {0x3B49,0x5D26}, {0x3B4A,0x5D27},
{0x3B4B,0x5D31}, {0x3B4C,0x5D34}, {0x3B4D,0x5D39}, {0x3B4E,0x5D3D}, {0x3B4F,0x5D3F},
{0x3B50,0x5D42}, {0x3B51,0x5D43}, {0x3B52,0x5D46}, {0x3B53,0x5D48}, {0x3B54,0x5D55},
{0x3B55,0x5D51}, {0x3B56,0x5D59}, {0x3B57,0x5D4A}, {0x3B58,0x5D5F}, {0x3B59,0x5D60},
{0x3B5A,0x5D61}, {0x3B5B,0x5D62}, {0x3B5C,0x5D64}, {0x3B5D,0x5D6A}, {0x3B5E,0x5D6D},
{0x3B5F,0x5D70}, {0x3B60,0x5D79}, {0x3B61,0x5D7A}, {0x3B62,0x5D7E}, {0x3B63,0x5D7F},
{0x3B64,0x5D81}, {0x3B65,0x5D83}, {0x3B66,0x5D88}, {0x3B67,0x5D8A}, {0x3B68,0x5D92},
{0x3B69,0x5D93}, {0x3B6A,0x5D94}, {0x3B6B,0x5D95}, {0x3B6C,0x5D99}, {0x3B6D,0x5D9B},
{0x3B6E,0x5D9F}, {0x3B6F,0x5DA0}, {0x3B70,0x5DA7}, {0x3B71,0x5DAB}, {0x3B72,0x5DB0},
{0x3B73,0x5DB4}, {0x3B74,0x5DB8}, {0x3B75,0x5DB9}, {0x3B76,0x5DC3}, {0x3B77,0x5DC7},
{0x3B78,0x5DCB}, {0x3B79,0x5DD0}, {0x3B7A,0x5DCE}, {0x3B7B,0x5DD8}, {0x3B7C,0x5DD9},
{0x3B7D,0x5DE0}, {0x3B7E,0x5DE4}, {0x3C21,0x5DE9}, {0x3C22,0x5DF8}, {0x3C23,0x5DF9},
{0x3C24,0x5E00}, {0x3C25,0x5E07}, {0x3C26,0x5E0D}, {0x3C27,0x5E12}, {0x3C28,0x5E14},
{0x3C29,0x5E15}, {0x3C2A,0x5E18}, {0x3C2B,0x5E1F}, {0x3C2C,0x5E20}, {0x3C2D,0x5E2E},
{0x3C2E,0x5E28}, {0x3C2F,0x5E32}, {0x3C30,0x5E35}, {0x3C31,0x5E3E}, {0x3C32,0x5E4B},
{0x3C33,0x5E50}, {0x3C34,0x5E49}, {0x3C35,0x5E51}, {0x3C36,0x5E56}, {0x3C37,0x5E58},
{0x3C38,0x5E5B}, {0x3C39,0x5E5C}, {0x3C3A,0x5E5E}, {0x3C3B,0x5E68}, {0x3C3C,0x5E6A},
{0x3C3D,0x5E6B}, {0x3C3E,0x5E6C}, {0x3C3F,0x5E6D}, {0x3C40,0x5E6E}, {0x3C41,0x5E70},
{0x3C42,0x5E80}, {0x3C43,0x5E8B}, {0x3C44,0x5E8E}, {0x3C45,0x5EA2}, {0x3C46,0x5EA4},
{0x3C47,0x5EA5}, {0x3C48,0x5EA8}, {0x3C49,0x5EAA}, {0x3C4A,0x5EAC}, {0x3C4B,0x5EB1},
{0x3C4C,0x5EB3}, {0x3C4D,0x5EBD}, {0x3C4E,0x5EBE}, {0x3C4F,0x5EBF}, {0x3C50,0x5EC6},
{0x3C51,0x5ECC}, {0x3C52,0x5ECB}, {0x3C53,0x5ECE}, {0x3C54,0x5ED1}, {0x3C55,0x5ED2},
{0x3C56,0x5ED4}, {0x3C57,0x5ED5}, {0x3C58,0x5EDC}, {0x3C59,0x5EDE}, {0x3C5A,0x5EE5},
{0x3C5B,0x5EEB}, {0x3C5C,0x5F02}, {0x3C5D,0x5F06}, {0x3C5E,0x5F07}, {0x3C5F,0x5F08},
{0x3C60,0x5F0E}, {0x3C61,0x5F19}, {0x3C62,0x5F1C}, {0x3C63,0x5F1D}, {0x3C64,0x5F21},
{0x3C65,0x5F22}, {0x3C66,0x5F23}, {0x3C67,0x5F24}, {0x3C68,0x5F28}, {0x3C69,0x5F2B},
{0x3C6A,0x5F2C}, {0x3C6B,0x5F2E}, {0x3C6C,0x5F30}, {0x3C6D,0x5F34}, {0x3C6E,0x5F36},
{0x3C6F,0x5F3B}, {0x3C70,0x5F3D}, {0x3C71,0x5F3F}, {0x3C72,0x5F40}, {0x3C73,0x5F44},
{0x3C74,0x5F45}, {0x3C75,0x5F47}, {0x3C76,0x5F4D}, {0x3C77,0x5F50}, {0x3C78,0x5F54},
{0x3C79,0x5F58}, {0x3C7A,0x5F5B}, {0x3C7B,0x5F60}, {0x3C7C,0x5F63}, {0x3C7D,0x5F64},
{0x3C7E,0x5F67}, {0x3D21,0x5F6F}, {0x3D22,0x5F72}, {0x3D23,0x5F74}, {0x3D24,0x5F75},
{0x3D25,0x5F78}, {0x3D26,0x5F7A}, {0x3D27,0x5F7D}, {0x3D28,0x5F7E}, {0x3D29,0x5F89},
{0x3D2A,0x5F8D}, {0x3D2B,0x5F8F}, {0x3D2C,0x5F96}, {0x3D2D,0x5F9C}, {0x3D2E,0x5F9D},
{0x3D2F,0x5FA2}, {0x3D30,0x5FA7}, {0x3D31,0x5FAB}, {0x3D32,0x5FA4}, {0x3D33,0x5FAC},
{0x3D34,0x5FAF}, {0x3D35,0x5FB0}, {0x3D36,0x5FB1}, {0x3D37,0x5FB8}, {0x3D38,0x5FC4},
{0x3D39,0x5FC7}, {0x3D3A,0x5FC8}, {0x3D3B,0x5FC9}, {0x3D3C,0x5FCB}, {0x3D3D,0x5FD0},
{0x3D3E,0x5FD1}, {0x3D3F,0x5FD2}, {0x3D40,0x5FD3}, {0x3D41,0x5FD4}, {0x3D42,0x5FDE},
{0x3D43,0x5FE1}, {0x3D44,0x5FE2}, {0x3D45,0x5FE8}, {0x3D46,0x5FE9}, {0x3D47,0x5FEA},
{0x3D48,0x5FEC}, {0x3D49,0x5FED}, {0x3D4A,0x5FEE}, {0x3D4B,0x5FEF}, {0x3D4C,0x5FF2},
{0x3D4D,0x5FF3}, {0x3D4E,0x5FF6}, {0x3D4F,0x5FFA}, {0x3D50,0x5FFC}, {0x3D51,0x6007},
{0x3D52,0x600A}, {0x3D53,0x600D}, {0x3D54,0x6013}, {0x3D55,0x6014}, {0x3D56,0x6017},
{0x3D57,0x6018}, {0x3D58,0x601A}, {0x3D59,0x601F}, {0x3D5A,0x6024}, {0x3D5B,0x602D},
{0x3D5C,0x6033}, {0x3D5D,0x6035}, {0x3D5E,0x6040}, {0x3D5F,0x6047}, {0x3D60,0x6048},
{0x3D61,0x6049}, {0x3D62,0x604C}, {0x3D63,0x6051}, {0x3D64,0x6054}, {0x3D65,0x6056},
{0x3D66,0x6057}, {0x3D67,0x605D}, {0x3D68,0x6061}, {0x3D69,0x6067}, {0x3D6A,0x6071},
{0x3D6B,0x607E}, {0x3D6C,0x607F}, {0x3D6D,0x6082}, {0x3D6E,0x6086}, {0x3D6F,0x6088},
{0x3D70,0x608A}, {0x3D71,0x608E}, {0x3D72,0x6091}, {0x3D73,0x6093}, {0x3D74,0x6095},
{0x3D75,0x6098}, {0x3D76,0x609D}, {0x3D77,0x609E}, {0x3D78,0x60A2}, {0x3D79,0x60A4},
{0x3D7A,0x60A5}, {0x3D7B,0x60A8}, {0x3D7C,0x60B0}, {0x3D7D,0x60B1}, {0x3D7E,0x60B7},
{0x3E21,0x60BB}, {0x3E22,0x60BE}, {0x3E23,0x60C2}, {0x3E24,0x60C4}, {0x3E25,0x60C8},
{0x3E26,0x60C9}, {0x3E27,0x60CA}, {0x3E28,0x60CB}, {0x3E29,0x60CE}, {0x3E2A,0x60CF},
{0x3E2B,0x60D4}, {0x3E2C,0x60D5}, {0x3E2D,0x60D9}, {0x3E2E,0x60DB}, {0x3E2F,0x60DD},
{0x3E30,0x60DE}, {0x3E31,0x60E2}, {0x3E32,0x60E5}, {0x3E33,0x60F2}, {0x3E34,0x60F5},
{0x3E35,0x60F8}, {0x3E36,0x60FC}, {0x3E37,0x60FD}, {0x3E38,0x6102}, {0x3E39,0x6107},
{0x3E3A,0x610A}, {0x3E3B,0x610C}, {0x3E3C,0x6110}, {0x3E3D,0x6111}, {0x3E3E,0x6112},
{0x3E3F,0x6113}, {0x3E40,0x6114}, {0x3E41,0x6116}, {0x3E42,0x6117}, {0x3E43,0x6119},
{0x3E44,0x611C}, {0x3E45,0x611E}, {0x3E46,0x6122}, {0x3E47,0x612A}, {0x3E48,0x612B},
{0x3E49,0x6130}, {0x3E4A,0x6131}, {0x3E4B,0x6135}, {0x3E4C,0x6136}, {0x3E4D,0x6137},
{0x3E4E,0x6139}, {0x3E4F,0x6141}, {0x3E50,0x6145}, {0x3E51,0x6146}, {0x3E52,0x6149},
{0x3E53,0x615E}, {0x3E54,0x6160}, {0x3E55,0x616C}, {0x3E56,0x6172}, {0x3E57,0x6178},
{0x3E58,0x617B}, {0x3E59,0x617C}, {0x3E5A,0x617F}, {0x3E5B,0x6180}, {0x3E5C,0x6181},
{0x3E5D,0x6183}, {0x3E5E,0x6184}, {0x3E5F,0x618B}, {0x3E60,0x618D}, {0x3E61,0x6192},
{0x3E62,0x6193}, {0x3E63,0x6197}, {0x3E64,0x6198}, {0x3E65,0x619C}, {0x3E66,0x619D},
{0x3E67,0x619F}, {0x3E68,0x61A0}, {0x3E69,0x61A5}, {0x3E6A,0x61A8}, {0x3E6B,0x61AA},
{0x3E6C,0x61AD}, {0x3E6D,0x61B8}, {0x3E6E,0x61B9}, {0x3E6F,0x61BC}, {0x3E70,0x61C0},
{0x3E71,0x61C1}, {0x3E72,0x61C2}, {0x3E73,0x61CE}, {0x3E74,0x61CF}, {0x3E75,0x61D5},
{0x3E76,0x61DC}, {0x3E77,0x61DD}, {0x3E78,0x61DE}, {0x3E79,0x61DF}, {0x3E7A,0x61E1},
{0x3E7B,0x61E2}, {0x3E7C,0x61E7}, {0x3E7D,0x61E9}, {0x3E7E,0x61E5}, {0x3F21,0x61EC},
{0x3F22,0x61ED}, {0x3F23,0x61EF}, {0x3F24,0x6201}, {0x3F25,0x6203}, {0x3F26,0x6204},
{0x3F27,0x6207}, {0x3F28,0x6213}, {0x3F29,0x6215}, {0x3F2A,0x621C}, {0x3F2B,0x6220},
{0x3F2C,0x6222}, {0x3F2D,0x6223}, {0x3F2E,0x6227}, {0x3F2F,0x6229}, {0x3F30,0x622B},
{0x3F31,0x6239}, {0x3F32,0x623D}, {0x3F33,0x6242}, {0x3F34,0x6243}, {0x3F35,0x6244},
{0x3F36,0x6246}, {0x3F37,0x624C}, {0x3F38,0x6250}, {0x3F39,0x6251}, {0x3F3A,0x6252},
{0x3F3B,0x6254}, {0x3F3C,0x6256}, {0x3F3D,0x625A}, {0x3F3E,0x625C}, {0x3F3F,0x6264},
{0x3F40,0x626D}, {0x3F41,0x626F}, {0x3F42,0x6273}, {0x3F43,0x627A}, {0x3F44,0x627D},
{0x3F45,0x628D}, {0x3F46,0x628E}, {0x3F47,0x628F}, {0x3F48,0x6290}, {0x3F49,0x62A6},
{0x3F4A,0x62A8}, {0x3F4B,0x62B3}, {0x3F4C,0x62B6}, {0x3F4D,0x62B7}, {0x3F4E,0x62BA},
{0x3F4F,0x62BE}, {0x3F50,0x62BF}, {0x3F51,0x62C4}, {0x3F52,0x62CE}, {0x3F53,0x62D5},
{0x3F54,0x62D6}, {0x3F55,0x62DA}, {0x3F56,0x62EA}, {0x3F57,0x62F2}, {0x3F58,0x62F4},
{0x3F59,0x62FC}, {0x3F5A,0x62FD}, {0x3F5B,0x6303}, {0x3F5C,0x6304}, {0x3F5D,0x630A},
{0x3F5E,0x630B}, {0x3F5F,0x630D}, {0x3F60,0x6310}, {0x3F61,0x6313}, {0x3F62,0x6316},
{0x3F63,0x6318}, {0x3F64,0x6329}, {0x3F65,0x632A}, {0x3F66,0x632D}, {0x3F67,0x6335},
{0x3F68,0x6336}, {0x3F69,0x6339}, {0x3F6A,0x633C}, {0x3F6B,0x6341}, {0x3F6C,0x6342},
{0x3F6D,0x6343}, {0x3F6E,0x6344}, {0x3F6F,0x6346}, {0x3F70,0x634A}, {0x3F71,0x634B},
{0x3F72,0x634E}, {0x3F73,0x6352}, {0x3F74,0x6353}, {0x3F75,0x6354}, {0x3F76,0x6358},
{0x3F77,0x635B}, {0x3F78,0x6365}, {0x3F79,0x6366}, {0x3F7A,0x636C}, {0x3F7B,0x636D},
{0x3F7C,0x6371}, {0x3F7D,0x6374}, {0x3F7E,0x6375}, {0x4021,0x6378}, {0x4022,0x637C},
{0x4023,0x637D}, {0x4024,0x637F}, {0x4025,0x6382}, {0x4026,0x6384}, {0x4027,0x6387},
{0x4028,0x638A}, {0x4029,0x6390}, {0x402A,0x6394}, {0x402B,0x6395}, {0x402C,0x6399},
{0x402D,0x639A}, {0x402E,0x639E}, {0x402F,0x63A4}, {0x4030,0x63A6}, {0x4031,0x63AD},
{0x4032,0x63AE}, {0x4033,0x63AF}, {0x4034,0x63BD}, {0x4035,0x63C1}, {0x4036,0x63C5},
{0x4037,0x63C8}, {0x4038,0x63CE}, {0x4039,0x63D1}, {0x403A,0x63D3}, {0x403B,0x63D4},
{0x403C,0x63D5}, {0x403D,0x63DC}, {0x403E,0x63E0}, {0x403F,0x63E5}, {0x4040,0x63EA},
{0x4041,0x63EC}, {0x4042,0x63F2}, {0x4043,0x63F3}, {0x4044,0x63F5}, {0x4045,0x63F8},
{0x4046,0x63F9}, {0x4047,0x6409}, {0x4048,0x640A}, {0x4049,0x6410}, {0x404A,0x6412},
{0x404B,0x6414}, {0x404C,0x6418}, {0x404D,0x641E}, {0x404E,0x6420}, {0x404F,0x6422},
{0x4050,0x6424}, {0x4051,0x6425}, {0x4052,0x6429}, {0x4053,0x642A}, {0x4054,0x642F},
{0x4055,0x6430}, {0x4056,0x6435}, {0x4057,0x643D}, {0x4058,0x643F}, {0x4059,0x644B},
{0x405A,0x644F}, {0x405B,0x6451}, {0x405C,0x6452}, {0x405D,0x6453}, {0x405E,0x6454},
{0x405F,0x645A}, {0x4060,0x645B}, {0x4061,0x645C}, {0x4062,0x645D}, {0x4063,0x645F},
{0x4064,0x6460}, {0x4065,0x6461}, {0x4066,0x6463}, {0x4067,0x646D}, {0x4068,0x6473},
{0x4069,0x6474}, {0x406A,0x647B}, {0x406B,0x647D}, {0x406C,0x6485}, {0x406D,0x6487},
{0x406E,0x648F}, {0x406F,0x6490}, {0x4070,0x6491}, {0x4071,0x6498}, {0x4072,0x6499},
{0x4073,0x649B}, {0x4074,0x649D}, {0x4075,0x649F}, {0x4076,0x64A1}, {0x4077,0x64A3},
{0x4078,0x64A6}, {0x4079,0x64A8}, {0x407A,0x64AC}, {0x407B,0x64B3}, {0x407C,0x64BD},
{0x407D,0x64BE}, {0x407E,0x64BF}, {0x4121,0x64C4}, {0x4122,0x64C9}, {0x4123,0x64CA},
{0x4124,0x64CB}, {0x4125,0x64CC}, {0x4126,0x64CE}, {0x4127,0x64D0}, {0x4128,0x64D1},
{0x4129,0x64D5}, {0x412A,0x64D7}, {0x412B,0x64E4}, {0x412C,0x64E5}, {0x412D,0x64E9},
{0x412E,0x64EA}, {0x412F,0x64ED}, {0x4130,0x64F0}, {0x4131,0x64F5}, {0x4132,0x64F7},
{0x4133,0x64FB}, {0x4134,0x64FF}, {0x4135,0x6501}, {0x4136,0x6504}, {0x4137,0x6508},
{0x4138,0x6509}, {0x4139,0x650A}, {0x413A,0x650F}, {0x413B,0x6513}, {0x413C,0x6514},
{0x413D,0x6516}, {0x413E,0x6519}, {0x413F,0x651B}, {0x4140,0x651E}, {0x4141,0x651F},
{0x4142,0x6522}, {0x4143,0x6526}, {0x4144,0x6529}, {0x4145,0x652E}, {0x4146,0x6531},
{0x4147,0x653A}, {0x4148,0x653C}, {0x4149,0x653D}, {0x414A,0x6543}, {0x414B,0x6547},
{0x414C,0x6549}, {0x414D,0x6550}, {0x414E,0x6552}, {0x414F,0x6554}, {0x4150,0x655F},
{0x4151,0x6560}, {0x4152,0x6567}, {0x4153,0x656B}, {0x4154,0x657A}, {0x4155,0x657D},
{0x4156,0x6581}, {0x4157,0x6585}, {0x4158,0x658A}, {0x4159,0x6592}, {0x415A,0x6595},
{0x415B,0x6598}, {0x415C,0x659D}, {0x415D,0x65A0}, {0x415E,0x65A3}, {0x415F,0x65A6},
{0x4160,0x65AE}, {0x4161,0x65B2}, {0x4162,0x65B3}, {0x4163,0x65B4}, {0x4164,0x65BF},
{0x4165,0x65C2}, {0x4166,0x65C8}, {0x4167,0x65C9}, {0x4168,0x65CE}, {0x4169,0x65D0},
{0x416A,0x65D4}, {0x416B,0x65D6}, {0x416C,0x65D8}, {0x416D,0x65DF}, {0x416E,0x65F0},
{0x416F,0x65F2}, {0x4170,0x65F4}, {0x4171,0x65F5}, {0x4172,0x65F9}, {0x4173,0x65FE},
{0x4174,0x65FF}, {0x4175,0x6600}, {0x4176,0x6604}, {0x4177,0x6608}, {0x4178,0x6609},
{0x4179,0x660D}, {0x417A,0x6611}, {0x417B,0x6612}, {0x417C,0x6615}, {0x417D,0x6616},
{0x417E,0x661D}, {0x4221,0x661E}, {0x4222,0x6621}, {0x4223,0x6622}, {0x4224,0x6623},
{0x4225,0x6624}, {0x4226,0x6626}, {0x4227,0x6629}, {0x4228,0x662A}, {0x4229,0x662B},
{0x422A,0x662C}, {0x422B,0x662E}, {0x422C,0x6630}, {0x422D,0x6631}, {0x422E,0x6633},
{0x422F,0x6639}, {0x4230,0x6637}, {0x4231,0x6640}, {0x4232,0x6645}, {0x4233,0x6646},
{0x4234,0x664A}, {0x4235,0x664C}, {0x4236,0x6651}, {0x4237,0x664E}, {0x4238,0x6657},
{0x4239,0x6658}, {0x423A,0x6659}, {0x423B,0x665B}, {0x423C,0x665C}, {0x423D,0x6660},
{0x423E,0x6661}, {0x423F,0x66FB}, {0x4240,0x666A}, {0x4241,0x666B}, {0x4242,0x666C},
{0x4243,0x667E}, {0x4244,0x6673}, {0x4245,0x6675}, {0x4246,0x667F}, {0x4247,0x6677},
{0x4248,0x6678}, {0x4249,0x6679}, {0x424A,0x667B}, {0x424B,0x6680}, {0x424C,0x667C},
{0x424D,0x668B}, {0x424E,0x668C}, {0x424F,0x668D}, {0x4250,0x6690}, {0x4251,0x6692},
{0x4252,0x6699}, {0x4253,0x669A}, {0x4254,0x669B}, {0x4255,0x669C}, {0x4256,0x669F},
{0x4257,0x66A0}, {0x4258,0x66A4}, {0x4259,0x66AD}, {0x425A,0x66B1}, {0x425B,0x66B2},
{0x425C,0x66B5}, {0x425D,0x66BB}, {0x425E,0x66BF}, {0x425F,0x66C0}, {0x4260,0x66C2},
{0x4261,0x66C3}, {0x4262,0x66C8}, {0x4263,0x66CC}, {0x4264,0x66CE}, {0x4265,0x66CF},
{0x4266,0x66D4}, {0x4267,0x66DB}, {0x4268,0x66DF}, {0x4269,0x66E8}, {0x426A,0x66EB},
{0x426B,0x66EC}, {0x426C,0x66EE}, {0x426D,0x66FA}, {0x426E,0x6705}, {0x426F,0x6707},
{0x4270,0x670E}, {0x4271,0x6713}, {0x4272,0x6719}, {0x4273,0x671C}, {0x4274,0x6720},
{0x4275,0x6722}, {0x4276,0x6733}, {0x4277,0x673E}, {0x4278,0x6745}, {0x4279,0x6747},
{0x427A,0x6748}, {0x427B,0x674C}, {0x427C,0x6754}, {0x427D,0x6755}, {0x427E,0x675D},
{0x4321,0x6766}, {0x4322,0x676C}, {0x4323,0x676E}, {0x4324,0x6774}, {0x4325,0x6776},
{0x4326,0x677B}, {0x4327,0x6781}, {0x4328,0x6784}, {0x4329,0x678E}, {0x432A,0x678F},
{0x432B,0x6791}, {0x432C,0x6793}, {0x432D,0x6796}, {0x432E,0x6798}, {0x432F,0x6799},
{0x4330,0x679B}, {0x4331,0x67B0}, {0x4332,0x67B1}, {0x4333,0x67B2}, {0x4334,0x67B5},
{0x4335,0x67BB}, {0x4336,0x67BC}, {0x4337,0x67BD}, {0x4338,0x67F9}, {0x4339,0x67C0},
{0x433A,0x67C2}, {0x433B,0x67C3}, {0x433C,0x67C5}, {0x433D,0x67C8}, {0x433E,0x67C9},
{0x433F,0x67D2}, {0x4340,0x67D7}, {0x4341,0x67D9}, {0x4342,0x67DC}, {0x4343,0x67E1},
{0x4344,0x67E6}, {0x4345,0x67F0}, {0x4346,0x67F2}, {0x4347,0x67F6}, {0x4348,0x67F7},
{0x4349,0x6852}, {0x434A,0x6814}, {0x434B,0x6819}, {0x434C,0x681D}, {0x434D,0x681F},
{0x434E,0x6828}, {0x434F,0x6827}, {0x4350,0x682C}, {0x4351,0x682D}, {0x4352,0x682F},
{0x4353,0x6830}, {0x4354,0x6831}, {0x4355,0x6833}, {0x4356,0x683B}, {0x4357,0x683F},
{0x4358,0x6844}, {0x4359,0x6845}, {0x435A,0x684A}, {0x435B,0x684C}, {0x435C,0x6855},
{0x435D,0x6857}, {0x435E,0x6858}, {0x435F,0x685B}, {0x4360,0x686B}, {0x4361,0x686E},
{0x4362,0x686F}, {0x4363,0x6870}, {0x4364,0x6871}, {0x4365,0x6872}, {0x4366,0x6875},
{0x4367,0x6879}, {0x4368,0x687A}, {0x4369,0x687B}, {0x436A,0x687C}, {0x436B,0x6882},
{0x436C,0x6884}, {0x436D,0x6886}, {0x436E,0x6888}, {0x436F,0x6896}, {0x4370,0x6898},
{0x4371,0x689A}, {0x4372,0x689C}, {0x4373,0x68A1}, {0x4374,0x68A3}, {0x4375,0x68A5},
{0x4376,0x68A9}, {0x4377,0x68AA}, {0x4378,0x68AE}, {0x4379,0x68B2}, {0x437A,0x68BB},
{0x437B,0x68C5}, {0x437C,0x68C8}, {0x437D,0x68CC}, {0x437E,0x68CF}, {0x4421,0x68D0},
{0x4422,0x68D1}, {0x4423,0x68D3}, {0x4424,0x68D6}, {0x4425,0x68D9}, {0x4426,0x68DC},
{0x4427,0x68DD}, {0x4428,0x68E5}, {0x4429,0x68E8}, {0x442A,0x68EA}, {0x442B,0x68EB},
{0x442C,0x68EC}, {0x442D,0x68ED}, {0x442E,0x68F0}, {0x442F,0x68F1}, {0x4430,0x68F5},
{0x4431,0x68F6}, {0x4432,0x68FB}, {0x4433,0x68FC}, {0x4434,0x68FD}, {0x4435,0x6906},
{0x4436,0x6909}, {0x4437,0x690A}, {0x4438,0x6910}, {0x4439,0x6911}, {0x443A,0x6913},
{0x443B,0x6916}, {0x443C,0x6917}, {0x443D,0x6931}, {0x443E,0x6933}, {0x443F,0x6935},
{0x4440,0x6938}, {0x4441,0x693B}, {0x4442,0x6942}, {0x4443,0x6945}, {0x4444,0x6949},
{0x4445,0x694E}, {0x4446,0x6957}, {0x4447,0x695B}, {0x4448,0x6963}, {0x4449,0x6964},
{0x444A,0x6965}, {0x444B,0x6966}, {0x444C,0x6968}, {0x444D,0x6969}, {0x444E,0x696C},
{0x444F,0x6970}, {0x4450,0x6971}, {0x4451,0x6972}, {0x4452,0x697A}, {0x4453,0x697B},
{0x4454,0x697F}, {0x4455,0x6980}, {0x4456,0x698D}, {0x4457,0x6992}, {0x4458,0x6996},
{0x4459,0x6998}, {0x445A,0x69A1}, {0x445B,0x69A5}, {0x445C,0x69A6}, {0x445D,0x69A8},
{0x445E,0x69AB}, {0x445F,0x69AD}, {0x4460,0x69AF}, {0x4461,0x69B7}, {0x4462,0x69B8},
{0x4463,0x69BA}, {0x4464,0x69BC}, {0x4465,0x69C5}, {0x4466,0x69C8}, {0x4467,0x69D1},
{0x4468,0x69D6}, {0x4469,0x69D7}, {0x446A,0x69E2}, {0x446B,0x69E5}, {0x446C,0x69EE},
{0x446D,0x69EF}, {0x446E,0x69F1}, {0x446F,0x69F3}, {0x4470,0x69F5}, {0x4471,0x69FE},
{0x4472,0x6A00}, {0x4473,0x6A01}, {0x4474,0x6A03}, {0x4475,0x6A0F}, {0x4476,0x6A11},
{0x4477,0x6A15}, {0x4478,0x6A1A}, {0x4479,0x6A1D}, {0x447A,0x6A20}, {0x447B,0x6A24},
{0x447C,0x6A28}, {0x447D,0x6A30}, {0x447E,0x6A32}, {0x4521,0x6A34}, {0x4522,0x6A37},
{0x4523,0x6A3B}, {0x4524,0x6A3E}, {0x4525,0x6A3F}, {0x4526,0x6A45}, {0x4527,0x6A46},
{0x4528,0x6A49}, {0x4529,0x6A4A}, {0x452A,0x6A4E}, {0x452B,0x6A50}, {0x452C,0x6A51},
{0x452D,0x6A52}, {0x452E,0x6A55}, {0x452F,0x6A56}, {0x4530,0x6A5B}, {0x4531,0x6A64},
{0x4532,0x6A67}, {0x4533,0x6A6A}, {0x4534,0x6A71}, {0x4535,0x6A73}, {0x4536,0x6A7E},
{0x4537,0x6A81}, {0x4538,0x6A83}, {0x4539,0x6A86}, {0x453A,0x6A87}, {0x453B,0x6A89},
{0x453C,0x6A8B}, {0x453D,0x6A91}, {0x453E,0x6A9B}, {0x453F,0x6A9D}, {0x4540,0x6A9E},
{0x4541,0x6A9F}, {0x4542,0x6AA5}, {0x4543,0x6AAB}, {0x4544,0x6AAF}, {0x4545,0x6AB0},
{0x4546,0x6AB1}, {0x4547,0x6AB4}, {0x4548,0x6ABD}, {0x4549,0x6ABE}, {0x454A,0x6ABF},
{0x454B,0x6AC6}, {0x454C,0x6AC9}, {0x454D,0x6AC8}, {0x454E,0x6ACC}, {0x454F,0x6AD0},
{0x4550,0x6AD4}, {0x4551,0x6AD5}, {0x4552,0x6AD6}, {0x4553,0x6ADC}, {0x4554,0x6ADD},
{0x4555,0x6AE4}, {0x4556,0x6AE7}, {0x4557,0x6AEC}, {0x4558,0x6AF0}, {0x4559,0x6AF1},
{0x455A,0x6AF2}, {0x455B,0x6AFC}, {0x455C,0x6AFD}, {0x455D,0x6B02}, {0x455E,0x6B03},
{0x455F,0x6B06}, {0x4560,0x6B07}, {0x4561,0x6B09}, {0x4562,0x6B0F}, {0x4563,0x6B10},
{0x4564,0x6B11}, {0x4565,0x6B17}, {0x4566,0x6B1B}, {0x4567,0x6B1E}, {0x4568,0x6B24},
{0x4569,0x6B28}, {0x456A,0x6B2B}, {0x456B,0x6B2C}, {0x456C,0x6B2F}, {0x456D,0x6B35},
{0x456E,0x6B36}, {0x456F,0x6B3B}, {0x4570,0x6B3F}, {0x4571,0x6B46}, {0x4572,0x6B4A},
{0x4573,0x6B4D}, {0x4574,0x6B52}, {0x4575,0x6B56}, {0x4576,0x6B58}, {0x4577,0x6B5D},
{0x4578,0x6B60}, {0x4579,0x6B67}, {0x457A,0x6B6B}, {0x457B,0x6B6E}, {0x457C,0x6B70},
{0x457D,0x6B75}, {0x457E,0x6B7D}, {0x4621,0x6B7E}, {0x4622,0x6B82}, {0x4623,0x6B85},
{0x4624,0x6B97}, {0x4625,0x6B9B}, {0x4626,0x6B9F}, {0x4627,0x6BA0}, {0x4628,0x6BA2},
{0x4629,0x6BA3}, {0x462A,0x6BA8}, {0x462B,0x6BA9}, {0x462C,0x6BAC}, {0x462D,0x6BAD},
{0x462E,0x6BAE}, {0x462F,0x6BB0}, {0x4630,0x6BB8}, {0x4631,0x6BB9}, {0x4632,0x6BBD},
{0x4633,0x6BBE}, {0x4634,0x6BC3}, {0x4635,0x6BC4}, {0x4636,0x6BC9}, {0x4637,0x6BCC},
{0x4638,0x6BD6}, {0x4639,0x6BDA}, {0x463A,0x6BE1}, {0x463B,0x6BE3}, {0x463C,0x6BE6},
{0x463D,0x6BE7}, {0x463E,0x6BEE}, {0x463F,0x6BF1}, {0x4640,0x6BF7}, {0x4641,0x6BF9},
{0x4642,0x6BFF}, {0x4643,0x6C02}, {0x4644,0x6C04}, {0x4645,0x6C05}, {0x4646,0x6C09},
{0x4647,0x6C0D}, {0x4648,0x6C0E}, {0x4649,0x6C10}, {0x464A,0x6C12}, {0x464B,0x6C19},
{0x464C,0x6C1F}, {0x464D,0x6C26}, {0x464E,0x6C27}, {0x464F,0x6C28}, {0x4650,0x6C2C},
{0x4651,0x6C2E}, {0x4652,0x6C33}, {0x4653,0x6C35}, {0x4654,0x6C36}, {0x4655,0x6C3A},
{0x4656,0x6C3B}, {0x4657,0x6C3F}, {0x4658,0x6C4A}, {0x4659,0x6C4B}, {0x465A,0x6C4D},
{0x465B,0x6C4F}, {0x465C,0x6C52}, {0x465D,0x6C54}, {0x465E,0x6C59}, {0x465F,0x6C5B},
{0x4660,0x6C5C}, {0x4661,0x6C6B}, {0x4662,0x6C6D}, {0x4663,0x6C6F}, {0x4664,0x6C74},
{0x4665,0x6C76}, {0x4666,0x6C78}, {0x4667,0x6C79}, {0x4668,0x6C7B}, {0x4669,0x6C85},
{0x466A,0x6C86}, {0x466B,0x6C87}, {0x466C,0x6C89}, {0x466D,0x6C94}, {0x466E,0x6C95},
{0x466F,0x6C97}, {0x4670,0x6C98}, {0x4671,0x6C9C}, {0x4672,0x6C9F}, {0x4673,0x6CB0},
{0x4674,0x6CB2}, {0x4675,0x6CB4}, {0x4676,0x6CC2}, {0x4677,0x6CC6}, {0x4678,0x6CCD},
{0x4679,0x6CCF}, {0x467A,0x6CD0}, {0x467B,0x6CD1}, {0x467C,0x6CD2}, {0x467D,0x6CD4},
{0x467E,0x6CD6}, {0x4721,0x6CDA}, {0x4722,0x6CDC}, {0x4723,0x6CE0}, {0x4724,0x6CE7},
{0x4725,0x6CE9}, {0x4726,0x6CEB}, {0x4727,0x6CEC}, {0x4728,0x6CEE}, {0x4729,0x6CF2},
{0x472A,0x6CF4}, {0x472B,0x6D04}, {0x472C,0x6D07}, {0x472D,0x6D0A}, {0x472E,0x6D0E},
{0x472F,0x6D0F}, {0x4730,0x6D11}, {0x4731,0x6D13}, {0x4732,0x6D1A}, {0x4733,0x6D26},
{0x4734,0x6D27}, {0x4735,0x6D28}, {0x4736,0x6C67}, {0x4737,0x6D2E}, {0x4738,0x6D2F},
{0x4739,0x6D31}, {0x473A,0x6D39}, {0x473B,0x6D3C}, {0x473C,0x6D3F}, {0x473D,0x6D57},
{0x473E,0x6D5E}, {0x473F,0x6D5F}, {0x4740,0x6D61}, {0x4741,0x6D65}, {0x4742,0x6D67},
{0x4743,0x6D6F}, {0x4744,0x6D70}, {0x4745,0x6D7C}, {0x4746,0x6D82}, {0x4747,0x6D87},
{0x4748,0x6D91}, {0x4749,0x6D92}, {0x474A,0x6D94}, {0x474B,0x6D96}, {0x474C,0x6D97},
{0x474D,0x6D98}, {0x474E,0x6DAA}, {0x474F,0x6DAC}, {0x4750,0x6DB4}, {0x4751,0x6DB7},
{0x4752,0x6DB9}, {0x4753,0x6DBD}, {0x4754,0x6DBF}, {0x4755,0x6DC4}, {0x4756,0x6DC8},
{0x4757,0x6DCA}, {0x4758,0x6DCE}, {0x4759,0x6DCF}, {0x475A,0x6DD6}, {0x475B,0x6DDB},
{0x475C,0x6DDD}, {0x475D,0x6DDF}, {0x475E,0x6DE0}, {0x475F,0x6DE2}, {0x4760,0x6DE5},
{0x4761,0x6DE9}, {0x4762,0x6DEF}, {0x4763,0x6DF0}, {0x4764,0x6DF4}, {0x4765,0x6DF6},
{0x4766,0x6DFC}, {0x4767,0x6E00}, {0x4768,0x6E04}, {0x4769,0x6E1E}, {0x476A,0x6E22},
{0x476B,0x6E27}, {0x476C,0x6E32}, {0x476D,0x6E36}, {0x476E,0x6E39}, {0x476F,0x6E3B},
{0x4770,0x6E3C}, {0x4771,0x6E44}, {0x4772,0x6E45}, {0x4773,0x6E48}, {0x4774,0x6E49},
{0x4775,0x6E4B}, {0x4776,0x6E4F}, {0x4777,0x6E51}, {0x4778,0x6E52}, {0x4779,0x6E53},
{0x477A,0x6E54}, {0x477B,0x6E57}, {0x477C,0x6E5C}, {0x477D,0x6E5D}, {0x477E,0x6E5E},
{0x4821,0x6E62}, {0x4822,0x6E63}, {0x4823,0x6E68}, {0x4824,0x6E73}, {0x4825,0x6E7B},
{0x4826,0x6E7D}, {0x4827,0x6E8D}, {0x4828,0x6E93}, {0x4829,0x6E99}, {0x482A,0x6EA0},
{0x482B,0x6EA7}, {0x482C,0x6EAD}, {0x482D,0x6EAE}, {0x482E,0x6EB1}, {0x482F,0x6EB3},
{0x4830,0x6EBB}, {0x4831,0x6EBF}, {0x4832,0x6EC0}, {0x4833,0x6EC1}, {0x4834,0x6EC3},
{0x4835,0x6EC7}, {0x4836,0x6EC8}, {0x4837,0x6ECA}, {0x4838,0x6ECD}, {0x4839,0x6ECE},
{0x483A,0x6ECF}, {0x483B,0x6EEB}, {0x483C,0x6EED}, {0x483D,0x6EEE}, {0x483E,0x6EF9},
{0x483F,0x6EFB}, {0x4840,0x6EFD}, {0x4841,0x6F04}, {0x4842,0x6F08}, {0x4843,0x6F0A},
{0x4844,0x6F0C}, {0x4845,0x6F0D}, {0x4846,0x6F16}, {0x4847,0x6F18}, {0x4848,0x6F1A},
{0x4849,0x6F1B}, {0x484A,0x6F26}, {0x484B,0x6F29}, {0x484C,0x6F2A}, {0x484D,0x6F2F},
{0x484E,0x6F30}, {0x484F,0x6F33}, {0x4850,0x6F36}, {0x4851,0x6F3B}, {0x4852,0x6F3C},
{0x4853,0x6F2D}, {0x4854,0x6F4F}, {0x4855,0x6F51}, {0x4856,0x6F52}, {0x4857,0x6F53},
{0x4858,0x6F57}, {0x4859,0x6F59}, {0x485A,0x6F5A}, {0x485B,0x6F5D}, {0x485C,0x6F5E},
{0x485D,0x6F61}, {0x485E,0x6F62}, {0x485F,0x6F68}, {0x4860,0x6F6C}, {0x4861,0x6F7D},
{0x4862,0x6F7E}, {0x4863,0x6F83}, {0x4864,0x6F87}, {0x4865,0x6F88}, {0x4866,0x6F8B},
{0x4867,0x6F8C}, {0x4868,0x6F8D}, {0x4869,0x6F90}, {0x486A,0x6F92}, {0x486B,0x6F93},
{0x486C,0x6F94}, {0x486D,0x6F96}, {0x486E,0x6F9A}, {0x486F,0x6F9F}, {0x4870,0x6FA0},
{0x4871,0x6FA5}, {0x4872,0x6FA6}, {0x4873,0x6FA7}, {0x4874,0x6FA8}, {0x4875,0x6FAE},
{0x4876,0x6FAF}, {0x4877,0x6FB0}, {0x4878,0x6FB5}, {0x4879,0x6FB6}, {0x487A,0x6FBC},
{0x487B,0x6FC5}, {0x487C,0x6FC7}, {0x487D,0x6FC8}, {0x487E,0x6FCA}, {0x4921,0x6FDA},
{0x4922,0x6FDE}, {0x4923,0x6FE8}, {0x4924,0x6FE9}, {0x4925,0x6FF0}, {0x4926,0x6FF5},
{0x4927,0x6FF9}, {0x4928,0x6FFC}, {0x4929,0x6FFD}, {0x492A,0x7000}, {0x492B,0x7005},
{0x492C,0x7006}, {0x492D,0x7007}, {0x492E,0x700D}, {0x492F,0x7017}, {0x4930,0x7020},
{0x4931,0x7023}, {0x4932,0x702F}, {0x4933,0x7034}, {0x4934,0x7037}, {0x4935,0x7039},
{0x4936,0x703C}, {0x4937,0x7043}, {0x4938,0x7044}, {0x4939,0x7048}, {0x493A,0x7049},
{0x493B,0x704A}, {0x493C,0x704B}, {0x493D,0x7054}, {0x493E,0x7055}, {0x493F,0x705D},
{0x4940,0x705E}, {0x4941,0x704E}, {0x4942,0x7064}, {0x4943,0x7065}, {0x4944,0x706C},
{0x4945,0x706E}, {0x4946,0x7075}, {0x4947,0x7076}, {0x4948,0x707E}, {0x4949,0x7081},
{0x494A,0x7085}, {0x494B,0x7086}, {0x494C,0x7094}, {0x494D,0x7095}, {0x494E,0x7096},
{0x494F,0x7097}, {0x4950,0x7098}, {0x4951,0x709B}, {0x4952,0x70A4}, {0x4953,0x70AB},
{0x4954,0x70B0}, {0x4955,0x70B1}, {0x4956,0x70B4}, {0x4957,0x70B7}, {0x4958,0x70CA},
{0x4959,0x70D1}, {0x495A,0x70D3}, {0x495B,0x70D4}, {0x495C,0x70D5}, {0x495D,0x70D6},
{0x495E,0x70D8}, {0x495F,0x70DC}, {0x4960,0x70E4}, {0x4961,0x70FA}, {0x4962,0x7103},
{0x4963,0x7104}, {0x4964,0x7105}, {0x4965,0x7106}, {0x4966,0x7107}, {0x4967,0x710B},
{0x4968,0x710C}, {0x4969,0x710F}, {0x496A,0x711E}, {0x496B,0x7120}, {0x496C,0x712B},
{0x496D,0x712D}, {0x496E,0x712F}, {0x496F,0x7130}, {0x4970,0x7131}, {0x4971,0x7138},
{0x4972,0x7141}, {0x4973,0x7145}, {0x4974,0x7146}, {0x4975,0x7147}, {0x4976,0x714A},
{0x4977,0x714B}, {0x4978,0x7150}, {0x4979,0x7152}, {0x497A,0x7157}, {0x497B,0x715A},
{0x497C,0x715C}, {0x497D,0x715E}, {0x497E,0x7160}, {0x4A21,0x7168}, {0x4A22,0x7179},
{0x4A23,0x7180}, {0x4A24,0x7185}, {0x4A25,0x7187}, {0x4A26,0x718C}, {0x4A27,0x7192},
{0x4A28,0x719A}, {0x4A29,0x719B}, {0x4A2A,0x71A0}, {0x4A2B,0x71A2}, {0x4A2C,0x71AF},
{0x4A2D,0x71B0}, {0x4A2E,0x71B2}, {0x4A2F,0x71B3}, {0x4A30,0x71BA}, {0x4A31,0x71BF},
{0x4A32,0x71C0}, {0x4A33,0x71C1}, {0x4A34,0x71C4}, {0x4A35,0x71CB}, {0x4A36,0x71CC},
{0x4A37,0x71D3}, {0x4A38,0x71D6}, {0x4A39,0x71D9}, {0x4A3A,0x71DA}, {0x4A3B,0x71DC},
{0x4A3C,0x71F8}, {0x4A3D,0x71FE}, {0x4A3E,0x7200}, {0x4A3F,0x7207}, {0x4A40,0x7208},
{0x4A41,0x7209}, {0x4A42,0x7213}, {0x4A43,0x7217}, {0x4A44,0x721A}, {0x4A45,0x721D},
{0x4A46,0x721F}, {0x4A47,0x7224}, {0x4A48,0x722B}, {0x4A49,0x722F}, {0x4A4A,0x7234},
{0x4A4B,0x7238}, {0x4A4C,0x7239}, {0x4A4D,0x7241}, {0x4A4E,0x7242}, {0x4A4F,0x7243},
{0x4A50,0x7245}, {0x4A51,0x724E}, {0x4A52,0x724F}, {0x4A53,0x7250}, {0x4A54,0x7253},
{0x4A55,0x7255}, {0x4A56,0x7256}, {0x4A57,0x725A}, {0x4A58,0x725C}, {0x4A59,0x725E},
{0x4A5A,0x7260}, {0x4A5B,0x7263}, {0x4A5C,0x7268}, {0x4A5D,0x726B}, {0x4A5E,0x726E},
{0x4A5F,0x726F}, {0x4A60,0x7271}, {0x4A61,0x7277}, {0x4A62,0x7278}, {0x4A63,0x727B},
{0x4A64,0x727C}, {0x4A65,0x727F}, {0x4A66,0x7284}, {0x4A67,0x7289}, {0x4A68,0x728D},
{0x4A69,0x728E}, {0x4A6A,0x7293}, {0x4A6B,0x729B}, {0x4A6C,0x72A8}, {0x4A6D,0x72AD},
{0x4A6E,0x72AE}, {0x4A6F,0x72B1}, {0x4A70,0x72B4}, {0x4A71,0x72BE}, {0x4A72,0x72C1},
{0x4A73,0x72C7}, {0x4A74,0x72C9}, {0x4A75,0x72CC}, {0x4A76,0x72D5}, {0x4A77,0x72D6},
{0x4A78,0x72D8}, {0x4A79,0x72DF}, {0x4A7A,0x72E5}, {0x4A7B,0x72F3}, {0x4A7C,0x72F4},
{0x4A7D,0x72FA}, {0x4A7E,0x72FB}, {0x4B21,0x72FE}, {0x4B22,0x7302}, {0x4B23,0x7304},
{0x4B24,0x7305}, {0x4B25,0x7307}, {0x4B26,0x730B}, {0x4B27,0x730D}, {0x4B28,0x7312},
{0x4B29,0x7313}, {0x4B2A,0x7318}, {0x4B2B,0x7319}, {0x4B2C,0x731E}, {0x4B2D,0x7322},
{0x4B2E,0x7324}, {0x4B2F,0x7327}, {0x4B30,0x7328}, {0x4B31,0x732C}, {0x4B32,0x7331},
{0x4B33,0x7332}, {0x4B34,0x7335}, {0x4B35,0x733A}, {0x4B36,0x733B}, {0x4B37,0x733D},
{0x4B38,0x7343}, {0x4B39,0x734D}, {0x4B3A,0x7350}, {0x4B3B,0x7352}, {0x4B3C,0x7356},
{0x4B3D,0x7358}, {0x4B3E,0x735D}, {0x4B3F,0x735E}, {0x4B40,0x735F}, {0x4B41,0x7360},
{0x4B42,0x7366}, {0x4B43,0x7367}, {0x4B44,0x7369}, {0x4B45,0x736B}, {0x4B46,0x736C},
{0x4B47,0x736E}, {0x4B48,0x736F}, {0x4B49,0x7371}, {0x4B4A,0x7377}, {0x4B4B,0x7379},
{0x4B4C,0x737C}, {0x4B4D,0x7380}, {0x4B4E,0x7381}, {0x4B4F,0x7383}, {0x4B50,0x7385},
{0x4B51,0x7386}, {0x4B52,0x738E}, {0x4B53,0x7390}, {0x4B54,0x7393}, {0x4B55,0x7395},
{0x4B56,0x7397}, {0x4B57,0x7398}, {0x4B58,0x739C}, {0x4B59,0x739E}, {0x4B5A,0x739F},
{0x4B5B,0x73A0}, {0x4B5C,0x73A2}, {0x4B5D,0x73A5}, {0x4B5E,0x73A6}, {0x4B5F,0x73AA},
{0x4B60,0x73AB}, {0x4B61,0x73AD}, {0x4B62,0x73B5}, {0x4B63,0x73B7}, {0x4B64,0x73B9},
{0x4B65,0x73BC}, {0x4B66,0x73BD}, {0x4B67,0x73BF}, {0x4B68,0x73C5}, {0x4B69,0x73C6},
{0x4B6A,0x73C9}, {0x4B6B,0x73CB}, {0x4B6C,0x73CC}, {0x4B6D,0x73CF}, {0x4B6E,0x73D2},
{0x4B6F,0x73D3}, {0x4B70,0x73D6}, {0x4B71,0x73D9}, {0x4B72,0x73DD}, {0x4B73,0x73E1},
{0x4B74,0x73E3}, {0x4B75,0x73E6}, {0x4B76,0x73E7}, {0x4B77,0x73E9}, {0x4B78,0x73F4},
{0x4B79,0x73F5}, {0x4B7A,0x73F7}, {0x4B7B,0x73F9}, {0x4B7C,0x73FA}, {0x4B7D,0x73FB},
{0x4B7E,0x73FD}, {0x4C21,0x73FF}, {0x4C22,0x7400}, {0x4C23,0x7401}, {0x4C24,0x7404},
{0x4C25,0x7407}, {0x4C26,0x740A}, {0x4C27,0x7411}, {0x4C28,0x741A}, {0x4C29,0x741B},
{0x4C2A,0x7424}, {0x4C2B,0x7426}, {0x4C2C,0x7428}, {0x4C2D,0x7429}, {0x4C2E,0x742A},
{0x4C2F,0x742B}, {0x4C30,0x742C}, {0x4C31,0x742D}, {0x4C32,0x742E}, {0x4C33,0x742F},
{0x4C34,0x7430}, {0x4C35,0x7431}, {0x4C36,0x7439}, {0x4C37,0x7440}, {0x4C38,0x7443},
{0x4C39,0x7444}, {0x4C3A,0x7446}, {0x4C3B,0x7447}, {0x4C3C,0x744B}, {0x4C3D,0x744D},
{0x4C3E,0x7451}, {0x4C3F,0x7452}, {0x4C40,0x7457}, {0x4C41,0x745D}, {0x4C42,0x7462},
{0x4C43,0x7466}, {0x4C44,0x7467}, {0x4C45,0x7468}, {0x4C46,0x746B}, {0x4C47,0x746D},
{0x4C48,0x746E}, {0x4C49,0x7471}, {0x4C4A,0x7472}, {0x4C4B,0x7480}, {0x4C4C,0x7481},
{0x4C4D,0x7485}, {0x4C4E,0x7486}, {0x4C4F,0x7487}, {0x4C50,0x7489}, {0x4C51,0x748F},
{0x4C52,0x7490}, {0x4C53,0x7491}, {0x4C54,0x7492}, {0x4C55,0x7498}, {0x4C56,0x7499},
{0x4C57,0x749A}, {0x4C58,0x749C}, {0x4C59,0x749F}, {0x4C5A,0x74A0}, {0x4C5B,0x74A1},
{0x4C5C,0x74A3}, {0x4C5D,0x74A6}, {0x4C5E,0x74A8}, {0x4C5F,0x74A9}, {0x4C60,0x74AA},
{0x4C61,0x74AB}, {0x4C62,0x74AE}, {0x4C63,0x74AF}, {0x4C64,0x74B1}, {0x4C65,0x74B2},
{0x4C66,0x74B5}, {0x4C67,0x74B9}, {0x4C68,0x74BB}, {0x4C69,0x74BF}, {0x4C6A,0x74C8},
{0x4C6B,0x74C9}, {0x4C6C,0x74CC}, {0x4C6D,0x74D0}, {0x4C6E,0x74D3}, {0x4C6F,0x74D8},
{0x4C70,0x74DA}, {0x4C71,0x74DB}, {0x4C72,0x74DE}, {0x4C73,0x74DF}, {0x4C74,0x74E4},
{0x4C75,0x74E8}, {0x4C76,0x74EA}, {0x4C77,0x74EB}, {0x4C78,0x74EF}, {0x4C79,0x74F4},
{0x4C7A,0x74FA}, {0x4C7B,0x74FB}, {0x4C7C,0x74FC}, {0x4C7D,0x74FF}, {0x4C7E,0x7506},
{0x4D21,0x7512}, {0x4D22,0x7516}, {0x4D23,0x7517}, {0x4D24,0x7520}, {0x4D25,0x7521},
{0x4D26,0x7524}, {0x4D27,0x7527}, {0x4D28,0x7529}, {0x4D29,0x752A}, {0x4D2A,0x752F},
{0x4D2B,0x7536}, {0x4D2C,0x7539}, {0x4D2D,0x753D}, {0x4D2E,0x753E}, {0x4D2F,0x753F},
{0x4D30,0x7540}, {0x4D31,0x7543}, {0x4D32,0x7547}, {0x4D33,0x7548}, {0x4D34,0x754E},
{0x4D35,0x7550}, {0x4D36,0x7552}, {0x4D37,0x7557}, {0x4D38,0x755E}, {0x4D39,0x755F},
{0x4D3A,0x7561}, {0x4D3B,0x756F}, {0x4D3C,0x7571}, {0x4D3D,0x7579}, {0x4D3E,0x757A},
{0x4D3F,0x757B}, {0x4D40,0x757C}, {0x4D41,0x757D}, {0x4D42,0x757E}, {0x4D43,0x7581},
{0x4D44,0x7585}, {0x4D45,0x7590}, {0x4D46,0x7592}, {0x4D47,0x7593}, {0x4D48,0x7595},
{0x4D49,0x7599}, {0x4D4A,0x759C}, {0x4D4B,0x75A2}, {0x4D4C,0x75A4}, {0x4D4D,0x75B4},
{0x4D4E,0x75BA}, {0x4D4F,0x75BF}, {0x4D50,0x75C0}, {0x4D51,0x75C1}, {0x4D52,0x75C4},
{0x4D53,0x75C6}, {0x4D54,0x75CC}, {0x4D55,0x75CE}, {0x4D56,0x75CF}, {0x4D57,0x75D7},
{0x4D58,0x75DC}, {0x4D59,0x75DF}, {0x4D5A,0x75E0}, {0x4D5B,0x75E1}, {0x4D5C,0x75E4},
{0x4D5D,0x75E7}, {0x4D5E,0x75EC}, {0x4D5F,0x75EE}, {0x4D60,0x75EF}, {0x4D61,0x75F1},
{0x4D62,0x75F9}, {0x4D63,0x7600}, {0x4D64,0x7602}, {0x4D65,0x7603}, {0x4D66,0x7604},
{0x4D67,0x7607}, {0x4D68,0x7608}, {0x4D69,0x760A}, {0x4D6A,0x760C}, {0x4D6B,0x760F},
{0x4D6C,0x7612}, {0x4D6D,0x7613}, {0x4D6E,0x7615}, {0x4D6F,0x7616}, {0x4D70,0x7619},
{0x4D71,0x761B}, {0x4D72,0x761C}, {0x4D73,0x761D}, {0x4D74,0x761E}, {0x4D75,0x7623},
{0x4D76,0x7625}, {0x4D77,0x7626}, {0x4D78,0x7629}, {0x4D79,0x762D}, {0x4D7A,0x7632},
{0x4D7B,0x7633}, {0x4D7C,0x7635}, {0x4D7D,0x7638}, {0x4D7E,0x7639}, {0x4E21,0x763A},
{0x4E22,0x763C}, {0x4E23,0x764A}, {0x4E24,0x7640}, {0x4E25,0x7641}, {0x4E26,0x7643},
{0x4E27,0x7644}, {0x4E28,0x7645}, {0x4E29,0x7649}, {0x4E2A,0x764B}, {0x4E2B,0x7655},
{0x4E2C,0x7659}, {0x4E2D,0x765F}, {0x4E2E,0x7664}, {0x4E2F,0x7665}, {0x4E30,0x766D},
{0x4E31,0x766E}, {0x4E32,0x766F}, {0x4E33,0x7671}, {0x4E34,0x7674}, {0x4E35,0x7681},
{0x4E36,0x7685}, {0x4E37,0x768C}, {0x4E38,0x768D}, {0x4E39,0x7695}, {0x4E3A,0x769B},
{0x4E3B,0x769C}, {0x4E3C,0x769D}, {0x4E3D,0x769F}, {0x4E3E,0x76A0}, {0x4E3F,0x76A2},
{0x4E40,0x76A3}, {0x4E41,0x76A4}, {0x4E42,0x76A5}, {0x4E43,0x76A6}, {0x4E44,0x76A7},
{0x4E45,0x76A8}, {0x4E46,0x76AA}, {0x4E47,0x76AD}, {0x4E48,0x76BD}, {0x4E49,0x76C1},
{0x4E4A,0x76C5}, {0x4E4B,0x76C9}, {0x4E4C,0x76CB}, {0x4E4D,0x76CC}, {0x4E4E,0x76CE},
{0x4E4F,0x76D4}, {0x4E50,0x76D9}, {0x4E51,0x76E0}, {0x4E52,0x76E6}, {0x4E53,0x76E8},
{0x4E54,0x76EC}, {0x4E55,0x76F0}, {0x4E56,0x76F1}, {0x4E57,0x76F6}, {0x4E58,0x76F9},
{0x4E59,0x76FC}, {0x4E5A,0x7700}, {0x4E5B,0x7706}, {0x4E5C,0x770A}, {0x4E5D,0x770E},
{0x4E5E,0x7712}, {0x4E5F,0x7714}, {0x4E60,0x7715}, {0x4E61,0x7717}, {0x4E62,0x7719},
{0x4E63,0x771A}, {0x4E64,0x771C}, {0x4E65,0x7722}, {0x4E66,0x7728}, {0x4E67,0x772D},
{0x4E68,0x772E}, {0x4E69,0x772F}, {0x4E6A,0x7734}, {0x4E6B,0x7735}, {0x4E6C,0x7736},
{0x4E6D,0x7739}, {0x4E6E,0x773D}, {0x4E6F,0x773E}, {0x4E70,0x7742}, {0x4E71,0x7745},
{0x4E72,0x7746}, {0x4E73,0x774A}, {0x4E74,0x774D}, {0x4E75,0x774E}, {0x4E76,0x774F},
{0x4E77,0x7752}, {0x4E78,0x7756}, {0x4E79,0x7757}, {0x4E7A,0x775C}, {0x4E7B,0x775E},
{0x4E7C,0x775F}, {0x4E7D,0x7760}, {0x4E7E,0x7762}, {0x4F21,0x7764}, {0x4F22,0x7767},
{0x4F23,0x776A}, {0x4F24,0x776C}, {0x4F25,0x7770}, {0x4F26,0x7772}, {0x4F27,0x7773},
{0x4F28,0x7774}, {0x4F29,0x777A}, {0x4F2A,0x777D}, {0x4F2B,0x7780}, {0x4F2C,0x7784},
{0x4F2D,0x778C}, {0x4F2E,0x778D}, {0x4F2F,0x7794}, {0x4F30,0x7795}, {0x4F31,0x7796},
{0x4F32,0x779A}, {0x4F33,0x779F}, {0x4F34,0x77A2}, {0x4F35,0x77A7}, {0x4F36,0x77AA},
{0x4F37,0x77AE}, {0x4F38,0x77AF}, {0x4F39,0x77B1}, {0x4F3A,0x77B5}, {0x4F3B,0x77BE},
{0x4F3C,0x77C3}, {0x4F3D,0x77C9}, {0x4F3E,0x77D1}, {0x4F3F,0x77D2}, {0x4F40,0x77D5},
{0x4F41,0x77D9}, {0x4F42,0x77DE}, {0x4F43,0x77DF}, {0x4F44,0x77E0}, {0x4F45,0x77E4},
{0x4F46,0x77E6}, {0x4F47,0x77EA}, {0x4F48,0x77EC}, {0x4F49,0x77F0}, {0x4F4A,0x77F1},
{0x4F4B,0x77F4}, {0x4F4C,0x77F8}, {0x4F4D,0x77FB}, {0x4F4E,0x7805}, {0x4F4F,0x7806},
{0x4F50,0x7809}, {0x4F51,0x780D}, {0x4F52,0x780E}, {0x4F53,0x7811}, {0x4F54,0x781D},
{0x4F55,0x7821}, {0x4F56,0x7822}, {0x4F57,0x7823}, {0x4F58,0x782D}, {0x4F59,0x782E},
{0x4F5A,0x7830}, {0x4F5B,0x7835}, {0x4F5C,0x7837}, {0x4F5D,0x7843}, {0x4F5E,0x7844},
{0x4F5F,0x7847}, {0x4F60,0x7848}, {0x4F61,0x784C}, {0x4F62,0x784E}, {0x4F63,0x7852},
{0x4F64,0x785C}, {0x4F65,0x785E}, {0x4F66,0x7860}, {0x4F67,0x7861}, {0x4F68,0x7863},
{0x4F69,0x7864}, {0x4F6A,0x7868}, {0x4F6B,0x786A}, {0x4F6C,0x786E}, {0x4F6D,0x787A},
{0x4F6E,0x787E}, {0x4F6F,0x788A}, {0x4F70,0x788F}, {0x4F71,0x7894}, {0x4F72,0x7898},
{0x4F73,0x78A1}, {0x4F74,0x789D}, {0x4F75,0x789E}, {0x4F76,0x789F}, {0x4F77,0x78A4},
{0x4F78,0x78A8}, {0x4F79,0x78AC}, {0x4F7A,0x78AD}, {0x4F7B,0x78B0}, {0x4F7C,0x78B1},
{0x4F7D,0x78B2}, {0x4F7E,0x78B3}, {0x5021,0x78BB}, {0x5022,0x78BD}, {0x5023,0x78BF},
{0x5024,0x78C7}, {0x5025,0x78C8}, {0x5026,0x78C9}, {0x5027,0x78CC}, {0x5028,0x78CE},
{0x5029,0x78D2}, {0x502A,0x78D3}, {0x502B,0x78D5}, {0x502C,0x78D6}, {0x502D,0x78E4},
{0x502E,0x78DB}, {0x502F,0x78DF}, {0x5030,0x78E0}, {0x5031,0x78E1}, {0x5032,0x78E6},
{0x5033,0x78EA}, {0x5034,0x78F2}, {0x5035,0x78F3}, {0x5036,0x7900}, {0x5037,0x78F6},
{0x5038,0x78F7}, {0x5039,0x78FA}, {0x503A,0x78FB}, {0x503B,0x78FF}, {0x503C,0x7906},
{0x503D,0x790C}, {0x503E,0x7910}, {0x503F,0x791A}, {0x5040,0x791C}, {0x5041,0x791E},
{0x5042,0x791F}, {0x5043,0x7920}, {0x5044,0x7925}, {0x5045,0x7927}, {0x5046,0x7929},
{0x5047,0x792D}, {0x5048,0x7931}, {0x5049,0x7934}, {0x504A,0x7935}, {0x504B,0x793B},
{0x504C,0x793D}, {0x504D,0x793F}, {0x504E,0x7944}, {0x504F,0x7945}, {0x5050,0x7946},
{0x5051,0x794A}, {0x5052,0x794B}, {0x5053,0x794F}, {0x5054,0x7951}, {0x5055,0x7954},
{0x5056,0x7958}, {0x5057,0x795B}, {0x5058,0x795C}, {0x5059,0x7967}, {0x505A,0x7969},
{0x505B,0x796B}, {0x505C,0x7972}, {0x505D,0x7979}, {0x505E,0x797B}, {0x505F,0x797C},
{0x5060,0x797E}, {0x5061,0x798B}, {0x5062,0x798C}, {0x5063,0x7991}, {0x5064,0x7993},
{0x5065,0x7994}, {0x5066,0x7995}, {0x5067,0x7996}, {0x5068,0x7998}, {0x5069,0x799B},
{0x506A,0x799C}, {0x506B,0x79A1}, {0x506C,0x79A8}, {0x506D,0x79A9}, {0x506E,0x79AB},
{0x506F,0x79AF}, {0x5070,0x79B1}, {0x5071,0x79B4}, {0x5072,0x79B8}, {0x5073,0x79BB},
{0x5074,0x79C2}, {0x5075,0x79C4}, {0x5076,0x79C7}, {0x5077,0x79C8}, {0x5078,0x79CA},
{0x5079,0x79CF}, {0x507A,0x79D4}, {0x507B,0x79D6}, {0x507C,0x79DA}, {0x507D,0x79DD},
{0x507E,0x79DE}, {0x5121,0x79E0}, {0x5122,0x79E2}, {0x5123,0x79E5}, {0x5124,0x79EA},
{0x5125,0x79EB}, {0x5126,0x79ED}, {0x5127,0x79F1}, {0x5128,0x79F8}, {0x5129,0x79FC},
{0x512A,0x7A02}, {0x512B,0x7A03}, {0x512C,0x7A07}, {0x512D,0x7A09}, {0x512E,0x7A0A},
{0x512F,0x7A0C}, {0x5130,0x7A11}, {0x5131,0x7A15}, {0x5132,0x7A1B}, {0x5133,0x7A1E},
{0x5134,0x7A21}, {0x5135,0x7A27}, {0x5136,0x7A2B}, {0x5137,0x7A2D}, {0x5138,0x7A2F},
{0x5139,0x7A30}, {0x513A,0x7A34}, {0x513B,0x7A35}, {0x513C,0x7A38}, {0x513D,0x7A39},
{0x513E,0x7A3A}, {0x513F,0x7A44}, {0x5140,0x7A45}, {0x5141,0x7A47}, {0x5142,0x7A48},
{0x5143,0x7A4C}, {0x5144,0x7A55}, {0x5145,0x7A56}, {0x5146,0x7A59}, {0x5147,0x7A5C},
{0x5148,0x7A5D}, {0x5149,0x7A5F}, {0x514A,0x7A60}, {0x514B,0x7A65}, {0x514C,0x7A67},
{0x514D,0x7A6A}, {0x514E,0x7A6D}, {0x514F,0x7A75}, {0x5150,0x7A78}, {0x5151,0x7A7E},
{0x5152,0x7A80}, {0x5153,0x7A82}, {0x5154,0x7A85}, {0x5155,0x7A86}, {0x5156,0x7A8A},
{0x5157,0x7A8B}, {0x5158,0x7A90}, {0x5159,0x7A91}, {0x515A,0x7A94}, {0x515B,0x7A9E},
{0x515C,0x7AA0}, {0x515D,0x7AA3}, {0x515E,0x7AAC}, {0x515F,0x7AB3}, {0x5160,0x7AB5},
{0x5161,0x7AB9}, {0x5162,0x7ABB}, {0x5163,0x7ABC}, {0x5164,0x7AC6}, {0x5165,0x7AC9},
{0x5166,0x7ACC}, {0x5167,0x7ACE}, {0x5168,0x7AD1}, {0x5169,0x7ADB}, {0x516A,0x7AE8},
{0x516B,0x7AE9}, {0x516C,0x7AEB}, {0x516D,0x7AEC}, {0x516E,0x7AF1}, {0x516F,0x7AF4},
{0x5170,0x7AFB}, {0x5171,0x7AFD}, {0x5172,0x7AFE}, {0x5173,0x7B07}, {0x5174,0x7B14},
{0x5175,0x7B1F}, {0x5176,0x7B23}, {0x5177,0x7B27}, {0x5178,0x7B29}, {0x5179,0x7B2A},
{0x517A,0x7B2B}, {0x517B,0x7B2D}, {0x517C,0x7B2E}, {0x517D,0x7B2F}, {0x517E,0x7B30},
{0x5221,0x7B31}, {0x5222,0x7B34}, {0x5223,0x7B3D}, {0x5224,0x7B3F}, {0x5225,0x7B40},
{0x5226,0x7B41}, {0x5227,0x7B47}, {0x5228,0x7B4E}, {0x5229,0x7B55}, {0x522A,0x7B60},
{0x522B,0x7B64}, {0x522C,0x7B66}, {0x522D,0x7B69}, {0x522E,0x7B6A}, {0x522F,0x7B6D},
{0x5230,0x7B6F}, {0x5231,0x7B72}, {0x5232,0x7B73}, {0x5233,0x7B77}, {0x5234,0x7B84},
{0x5235,0x7B89}, {0x5236,0x7B8E}, {0x5237,0x7B90}, {0x5238,0x7B91}, {0x5239,0x7B96},
{0x523A,0x7B9B}, {0x523B,0x7B9E}, {0x523C,0x7BA0}, {0x523D,0x7BA5}, {0x523E,0x7BAC},
{0x523F,0x7BAF}, {0x5240,0x7BB0}, {0x5241,0x7BB2}, {0x5242,0x7BB5}, {0x5243,0x7BB6},
{0x5244,0x7BBA}, {0x5245,0x7BBB}, {0x5246,0x7BBC}, {0x5247,0x7BBD}, {0x5248,0x7BC2},
{0x5249,0x7BC5}, {0x524A,0x7BC8}, {0x524B,0x7BCA}, {0x524C,0x7BD4}, {0x524D,0x7BD6},
{0x524E,0x7BD7}, {0x524F,0x7BD9}, {0x5250,0x7BDA}, {0x5251,0x7BDB}, {0x5252,0x7BE8},
{0x5253,0x7BEA}, {0x5254,0x7BF2}, {0x5255,0x7BF4}, {0x5256,0x7BF5}, {0x5257,0x7BF8},
{0x5258,0x7BF9}, {0x5259,0x7BFA}, {0x525A,0x7BFC}, {0x525B,0x7BFE}, {0x525C,0x7C01},
{0x525D,0x7C02}, {0x525E,0x7C03}, {0x525F,0x7C04}, {0x5260,0x7C06}, {0x5261,0x7C09},
{0x5262,0x7C0B}, {0x5263,0x7C0C}, {0x5264,0x7C0E}, {0x5265,0x7C0F}, {0x5266,0x7C19},
{0x5267,0x7C1B}, {0x5268,0x7C20}, {0x5269,0x7C25}, {0x526A,0x7C26}, {0x526B,0x7C28},
{0x526C,0x7C2C}, {0x526D,0x7C31}, {0x526E,0x7C33}, {0x526F,0x7C34}, {0x5270,0x7C36},
{0x5271,0x7C39}, {0x5272,0x7C3A}, {0x5273,0x7C46}, {0x5274,0x7C4A}, {0x5275,0x7C55},
{0x5276,0x7C51}, {0x5277,0x7C52}, {0x5278,0x7C53}, {0x5279,0x7C59}, {0x527A,0x7C5A},
{0x527B,0x7C5B}, {0x527C,0x7C5C}, {0x527D,0x7C5D}, {0x527E,0x7C5E}, {0x5321,0x7C61},
{0x5322,0x7C63}, {0x5323,0x7C67}, {0x5324,0x7C69}, {0x5325,0x7C6D}, {0x5326,0x7C6E},
{0x5327,0x7C70}, {0x5328,0x7C72}, {0x5329,0x7C79}, {0x532A,0x7C7C}, {0x532B,0x7C7D},
{0x532C,0x7C86}, {0x532D,0x7C87}, {0x532E,0x7C8F}, {0x532F,0x7C94}, {0x5330,0x7C9E},
{0x5331,0x7CA0}, {0x5332,0x7CA6}, {0x5333,0x7CB0}, {0x5334,0x7CB6}, {0x5335,0x7CB7},
{0x5336,0x7CBA}, {0x5337,0x7CBB}, {0x5338,0x7CBC}, {0x5339,0x7CBF}, {0x533A,0x7CC4},
{0x533B,0x7CC7}, {0x533C,0x7CC8}, {0x533D,0x7CC9}, {0x533E,0x7CCD}, {0x533F,0x7CCF},
{0x5340,0x7CD3}, {0x5341,0x7CD4}, {0x5342,0x7CD5}, {0x5343,0x7CD7}, {0x5344,0x7CD9},
{0x5345,0x7CDA}, {0x5346,0x7CDD}, {0x5347,0x7CE6}, {0x5348,0x7CE9}, {0x5349,0x7CEB},
{0x534A,0x7CF5}, {0x534B,0x7D03}, {0x534C,0x7D07}, {0x534D,0x7D08}, {0x534E,0x7D09},
{0x534F,0x7D0F}, {0x5350,0x7D11}, {0x5351,0x7D12}, {0x5352,0x7D13}, {0x5353,0x7D16},
{0x5354,0x7D1D}, {0x5355,0x7D1E}, {0x5356,0x7D23}, {0x5357,0x7D26}, {0x5358,0x7D2A},
{0x5359,0x7D2D}, {0x535A,0x7D31}, {0x535B,0x7D3C}, {0x535C,0x7D3D}, {0x535D,0x7D3E},
{0x535E,0x7D40}, {0x535F,0x7D41}, {0x5360,0x7D47}, {0x5361,0x7D48}, {0x5362,0x7D4D},
{0x5363,0x7D51}, {0x5364,0x7D53}, {0x5365,0x7D57}, {0x5366,0x7D59}, {0x5367,0x7D5A},
{0x5368,0x7D5C}, {0x5369,0x7D5D}, {0x536A,0x7D65}, {0x536B,0x7D67}, {0x536C,0x7D6A},
{0x536D,0x7D70}, {0x536E,0x7D78}, {0x536F,0x7D7A}, {0x5370,0x7D7B}, {0x5371,0x7D7F},
{0x5372,0x7D81}, {0x5373,0x7D82}, {0x5374,0x7D83}, {0x5375,0x7D85}, {0x5376,0x7D86},
{0x5377,0x7D88}, {0x5378,0x7D8B}, {0x5379,0x7D8C}, {0x537A,0x7D8D}, {0x537B,0x7D91},
{0x537C,0x7D96}, {0x537D,0x7D97}, {0x537E,0x7D9D}, {0x5421,0x7D9E}, {0x5422,0x7DA6},
{0x5423,0x7DA7}, {0x5424,0x7DAA}, {0x5425,0x7DB3}, {0x5426,0x7DB6}, {0x5427,0x7DB7},
{0x5428,0x7DB9}, {0x5429,0x7DC2}, {0x542A,0x7DC3}, {0x542B,0x7DC4}, {0x542C,0x7DC5},
{0x542D,0x7DC6}, {0x542E,0x7DCC}, {0x542F,0x7DCD}, {0x5430,0x7DCE}, {0x5431,0x7DD7},
{0x5432,0x7DD9}, {0x5433,0x7E00}, {0x5434,0x7DE2}, {0x5435,0x7DE5}, {0x5436,0x7DE6},
{0x5437,0x7DEA}, {0x5438,0x7DEB}, {0x5439,0x7DED}, {0x543A,0x7DF1}, {0x543B,0x7DF5},
{0x543C,0x7DF6}, {0x543D,0x7DF9}, {0x543E,0x7DFA}, {0x543F,0x7E08}, {0x5440,0x7E10},
{0x5441,0x7E11}, {0x5442,0x7E15}, {0x5443,0x7E17}, {0x5444,0x7E1C}, {0x5445,0x7E1D},
{0x5446,0x7E20}, {0x5447,0x7E27}, {0x5448,0x7E28}, {0x5449,0x7E2C}, {0x544A,0x7E2D},
{0x544B,0x7E2F}, {0x544C,0x7E33}, {0x544D,0x7E36}, {0x544E,0x7E3F}, {0x544F,0x7E44},
{0x5450,0x7E45}, {0x5451,0x7E47}, {0x5452,0x7E4E}, {0x5453,0x7E50}, {0x5454,0x7E52},
{0x5455,0x7E58}, {0x5456,0x7E5F}, {0x5457,0x7E61}, {0x5458,0x7E62}, {0x5459,0x7E65},
{0x545A,0x7E6B}, {0x545B,0x7E6E}, {0x545C,0x7E6F}, {0x545D,0x7E73}, {0x545E,0x7E78},
{0x545F,0x7E7E}, {0x5460,0x7E81}, {0x5461,0x7E86}, {0x5462,0x7E87}, {0x5463,0x7E8A},
{0x5464,0x7E8D}, {0x5465,0x7E91}, {0x5466,0x7E95}, {0x5467,0x7E98}, {0x5468,0x7E9A},
{0x5469,0x7E9D}, {0x546A,0x7E9E}, {0x546B,0x7F3C}, {0x546C,0x7F3B}, {0x546D,0x7F3D},
{0x546E,0x7F3E}, {0x546F,0x7F3F}, {0x5470,0x7F43}, {0x5471,0x7F44}, {0x5472,0x7F47},
{0x5473,0x7F4F}, {0x5474,0x7F52}, {0x5475,0x7F53}, {0x5476,0x7F5B}, {0x5477,0x7F5C},
{0x5478,0x7F5D}, {0x5479,0x7F61}, {0x547A,0x7F63}, {0x547B,0x7F64}, {0x547C,0x7F65},
{0x547D,0x7F66}, {0x547E,0x7F6D}, {0x5521,0x7F71}, {0x5522,0x7F7D}, {0x5523,0x7F7E},
{0x5524,0x7F7F}, {0x5525,0x7F80}, {0x5526,0x7F8B}, {0x5527,0x7F8D}, {0x5528,0x7F8F},
{0x5529,0x7F90}, {0x552A,0x7F91}, {0x552B,0x7F96}, {0x552C,0x7F97}, {0x552D,0x7F9C},
{0x552E,0x7FA1}, {0x552F,0x7FA2}, {0x5530,0x7FA6}, {0x5531,0x7FAA}, {0x5532,0x7FAD},
{0x5533,0x7FB4}, {0x5534,0x7FBC}, {0x5535,0x7FBF}, {0x5536,0x7FC0}, {0x5537,0x7FC3},
{0x5538,0x7FC8}, {0x5539,0x7FCE}, {0x553A,0x7FCF}, {0x553B,0x7FDB}, {0x553C,0x7FDF},
{0x553D,0x7FE3}, {0x553E,0x7FE5}, {0x553F,0x7FE8}, {0x5540,0x7FEC}, {0x5541,0x7FEE},
{0x5542,0x7FEF}, {0x5543,0x7FF2}, {0x5544,0x7FFA}, {0x5545,0x7FFD}, {0x5546,0x7FFE},
{0x5547,0x7FFF}, {0x5548,0x8007}, {0x5549,0x8008}, {0x554A,0x800A}, {0x554B,0x800D},
{0x554C,0x800E}, {0x554D,0x800F}, {0x554E,0x8011}, {0x554F,0x8013}, {0x5550,0x8014},
{0x5551,0x8016}, {0x5552,0x801D}, {0x5553,0x801E}, {0x5554,0x801F}, {0x5555,0x8020},
{0x5556,0x8024}, {0x5557,0x8026}, {0x5558,0x802C}, {0x5559,0x802E}, {0x555A,0x8030},
{0x555B,0x8034}, {0x555C,0x8035}, {0x555D,0x8037}, {0x555E,0x8039}, {0x555F,0x803A},
{0x5560,0x803C}, {0x5561,0x803E}, {0x5562,0x8040}, {0x5563,0x8044}, {0x5564,0x8060},
{0x5565,0x8064}, {0x5566,0x8066}, {0x5567,0x806D}, {0x5568,0x8071}, {0x5569,0x8075},
{0x556A,0x8081}, {0x556B,0x8088}, {0x556C,0x808E}, {0x556D,0x809C}, {0x556E,0x809E},
{0x556F,0x80A6}, {0x5570,0x80A7}, {0x5571,0x80AB}, {0x5572,0x80B8}, {0x5573,0x80B9},
{0x5574,0x80C8}, {0x5575,0x80CD}, {0x5576,0x80CF}, {0x5577,0x80D2}, {0x5578,0x80D4},
{0x5579,0x80D5}, {0x557A,0x80D7}, {0x557B,0x80D8}, {0x557C,0x80E0}, {0x557D,0x80ED},
{0x557E,0x80EE}, {0x5621,0x80F0}, {0x5622,0x80F2}, {0x5623,0x80F3}, {0x5624,0x80F6},
{0x5625,0x80F9}, {0x5626,0x80FA}, {0x5627,0x80FE}, {0x5628,0x8103}, {0x5629,0x810B},
{0x562A,0x8116}, {0x562B,0x8117}, {0x562C,0x8118}, {0x562D,0x811C}, {0x562E,0x811E},
{0x562F,0x8120}, {0x5630,0x8124}, {0x5631,0x8127}, {0x5632,0x812C}, {0x5633,0x8130},
{0x5634,0x8135}, {0x5635,0x813A}, {0x5636,0x813C}, {0x5637,0x8145}, {0x5638,0x8147},
{0x5639,0x814A}, {0x563A,0x814C}, {0x563B,0x8152}, {0x563C,0x8157}, {0x563D,0x8160},
{0x563E,0x8161}, {0x563F,0x8167}, {0x5640,0x8168}, {0x5641,0x8169}, {0x5642,0x816D},
{0x5643,0x816F}, {0x5644,0x8177}, {0x5645,0x8181}, {0x5646,0x8190}, {0x5647,0x8184},
{0x5648,0x8185}, {0x5649,0x8186}, {0x564A,0x818B}, {0x564B,0x818E}, {0x564C,0x8196},
{0x564D,0x8198}, {0x564E,0x819B}, {0x564F,0x819E}, {0x5650,0x81A2}, {0x5651,0x81AE},
{0x5652,0x81B2}, {0x5653,0x81B4}, {0x5654,0x81BB}, {0x5655,0x81CB}, {0x5656,0x81C3},
{0x5657,0x81C5}, {0x5658,0x81CA}, {0x5659,0x81CE}, {0x565A,0x81CF}, {0x565B,0x81D5},
{0x565C,0x81D7}, {0x565D,0x81DB}, {0x565E,0x81DD}, {0x565F,0x81DE}, {0x5660,0x81E1},
{0x5661,0x81E4}, {0x5662,0x81EB}, {0x5663,0x81EC}, {0x5664,0x81F0}, {0x5665,0x81F1},
{0x5666,0x81F2}, {0x5667,0x81F5}, {0x5668,0x81F6}, {0x5669,0x81F8}, {0x566A,0x81F9},
{0x566B,0x81FD}, {0x566C,0x81FF}, {0x566D,0x8200}, {0x566E,0x8203}, {0x566F,0x820F},
{0x5670,0x8213}, {0x5671,0x8214}, {0x5672,0x8219}, {0x5673,0x821A}, {0x5674,0x821D},
{0x5675,0x8221}, {0x5676,0x8222}, {0x5677,0x8228}, {0x5678,0x8232}, {0x5679,0x8234},
{0x567A,0x823A}, {0x567B,0x8243}, {0x567C,0x8244}, {0x567D,0x8245}, {0x567E,0x8246},
{0x5721,0x824B}, {0x5722,0x824E}, {0x5723,0x824F}, {0x5724,0x8251}, {0x5725,0x8256},
{0x5726,0x825C}, {0x5727,0x8260}, {0x5728,0x8263}, {0x5729,0x8267}, {0x572A,0x826D},
{0x572B,0x8274}, {0x572C,0x827B}, {0x572D,0x827D}, {0x572E,0x827F}, {0x572F,0x8280},
{0x5730,0x8281}, {0x5731,0x8283}, {0x5732,0x8284}, {0x5733,0x8287}, {0x5734,0x8289},
{0x5735,0x828A}, {0x5736,0x828E}, {0x5737,0x8291}, {0x5738,0x8294}, {0x5739,0x8296},
{0x573A,0x8298}, {0x573B,0x829A}, {0x573C,0x829B}, {0x573D,0x82A0}, {0x573E,0x82A1},
{0x573F,0x82A3}, {0x5740,0x82A4}, {0x5741,0x82A7}, {0x5742,0x82A8}, {0x5743,0x82A9},
{0x5744,0x82AA}, {0x5745,0x82AE}, {0x5746,0x82B0}, {0x5747,0x82B2}, {0x5748,0x82B4},
{0x5749,0x82B7}, {0x574A,0x82BA}, {0x574B,0x82BC}, {0x574C,0x82BE}, {0x574D,0x82BF},
{0x574E,0x82C6}, {0x574F,0x82D0}, {0x5750,0x82D5}, {0x5751,0x82DA}, {0x5752,0x82E0},
{0x5753,0x82E2}, {0x5754,0x82E4}, {0x5755,0x82E8}, {0x5756,0x82EA}, {0x5757,0x82ED},
{0x5758,0x82EF}, {0x5759,0x82F6}, {0x575A,0x82F7}, {0x575B,0x82FD}, {0x575C,0x82FE},
{0x575D,0x8300}, {0x575E,0x8301}, {0x575F,0x8307}, {0x5760,0x8308}, {0x5761,0x830A},
{0x5762,0x830B}, {0x5763,0x8354}, {0x5764,0x831B}, {0x5765,0x831D}, {0x5766,0x831E},
{0x5767,0x831F}, {0x5768,0x8321}, {0x5769,0x8322}, {0x576A,0x832C}, {0x576B,0x832D},
{0x576C,0x832E}, {0x576D,0x8330}, {0x576E,0x8333}, {0x576F,0x8337}, {0x5770,0x833A},
{0x5771,0x833C}, {0x5772,0x833D}, {0x5773,0x8342}, {0x5774,0x8343}, {0x5775,0x8344},
{0x5776,0x8347}, {0x5777,0x834D}, {0x5778,0x834E}, {0x5779,0x8351}, {0x577A,0x8355},
{0x577B,0x8356}, {0x577C,0x8357}, {0x577D,0x8370}, {0x577E,0x8378}, {0x5821,0x837D},
{0x5822,0x837F}, {0x5823,0x8380}, {0x5824,0x8382}, {0x5825,0x8384}, {0x5826,0x8386},
{0x5827,0x838D}, {0x5828,0x8392}, {0x5829,0x8394}, {0x582A,0x8395}, {0x582B,0x8398},
{0x582C,0x8399}, {0x582D,0x839B}, {0x582E,0x839C}, {0x582F,0x839D}, {0x5830,0x83A6},
{0x5831,0x83A7}, {0x5832,0x83A9}, {0x5833,0x83AC}, {0x5834,0x83BE}, {0x5835,0x83BF},
{0x5836,0x83C0}, {0x5837,0x83C7}, {0x5838,0x83C9}, {0x5839,0x83CF}, {0x583A,0x83D0},
{0x583B,0x83D1}, {0x583C,0x83D4}, {0x583D,0x83DD}, {0x583E,0x8353}, {0x583F,0x83E8},
{0x5840,0x83EA}, {0x5841,0x83F6}, {0x5842,0x83F8}, {0x5843,0x83F9}, {0x5844,0x83FC},
{0x5845,0x8401}, {0x5846,0x8406}, {0x5847,0x840A}, {0x5848,0x840F}, {0x5849,0x8411},
{0x584A,0x8415}, {0x584B,0x8419}, {0x584C,0x83AD}, {0x584D,0x842F}, {0x584E,0x8439},
{0x584F,0x8445}, {0x5850,0x8447}, {0x5851,0x8448}, {0x5852,0x844A}, {0x5853,0x844D},
{0x5854,0x844F}, {0x5855,0x8451}, {0x5856,0x8452}, {0x5857,0x8456}, {0x5858,0x8458},
{0x5859,0x8459}, {0x585A,0x845A}, {0x585B,0x845C}, {0x585C,0x8460}, {0x585D,0x8464},
{0x585E,0x8465}, {0x585F,0x8467}, {0x5860,0x846A}, {0x5861,0x8470}, {0x5862,0x8473},
{0x5863,0x8474}, {0x5864,0x8476}, {0x5865,0x8478}, {0x5866,0x847C}, {0x5867,0x847D},
{0x5868,0x8481}, {0x5869,0x8485}, {0x586A,0x8492}, {0x586B,0x8493}, {0x586C,0x8495},
{0x586D,0x849E}, {0x586E,0x84A6}, {0x586F,0x84A8}, {0x5870,0x84A9}, {0x5871,0x84AA},
{0x5872,0x84AF}, {0x5873,0x84B1}, {0x5874,0x84B4}, {0x5875,0x84BA}, {0x5876,0x84BD},
{0x5877,0x84BE}, {0x5878,0x84C0}, {0x5879,0x84C2}, {0x587A,0x84C7}, {0x587B,0x84C8},
{0x587C,0x84CC}, {0x587D,0x84CF}, {0x587E,0x84D3}, {0x5921,0x84DC}, {0x5922,0x84E7},
{0x5923,0x84EA}, {0x5924,0x84EF}, {0x5925,0x84F0}, {0x5926,0x84F1}, {0x5927,0x84F2},
{0x5928,0x84F7}, {0x5929,0x8532}, {0x592A,0x84FA}, {0x592B,0x84FB}, {0x592C,0x84FD},
{0x592D,0x8502}, {0x592E,0x8503}, {0x592F,0x8507}, {0x5930,0x850C}, {0x5931,0x850E},
{0x5932,0x8510}, {0x5933,0x851C}, {0x5934,0x851E}, {0x5935,0x8522}, {0x5936,0x8523},
{0x5937,0x8524}, {0x5938,0x8525}, {0x5939,0x8527}, {0x593A,0x852A}, {0x593B,0x852B},
{0x593C,0x852F}, {0x593D,0x8533}, {0x593E,0x8534}, {0x593F,0x8536}, {0x5940,0x853F},
{0x5941,0x8546}, {0x5942,0x854F}, {0x5943,0x8550}, {0x5944,0x8551}, {0x5945,0x8552},
{0x5946,0x8553}, {0x5947,0x8556}, {0x5948,0x8559}, {0x5949,0x855C}, {0x594A,0x855D},
{0x594B,0x855E}, {0x594C,0x855F}, {0x594D,0x8560}, {0x594E,0x8561}, {0x594F,0x8562},
{0x5950,0x8564}, {0x5951,0x856B}, {0x5952,0x856F}, {0x5953,0x8579}, {0x5954,0x857A},
{0x5955,0x857B}, {0x5956,0x857D}, {0x5957,0x857F}, {0x5958,0x8581}, {0x5959,0x8585},
{0x595A,0x8586}, {0x595B,0x8589}, {0x595C,0x858B}, {0x595D,0x858C}, {0x595E,0x858F},
{0x595F,0x8593}, {0x5960,0x8598}, {0x5961,0x859D}, {0x5962,0x859F}, {0x5963,0x85A0},
{0x5964,0x85A2}, {0x5965,0x85A5}, {0x5966,0x85A7}, {0x5967,0x85B4}, {0x5968,0x85B6},
{0x5969,0x85B7}, {0x596A,0x85B8}, {0x596B,0x85BC}, {0x596C,0x85BD}, {0x596D,0x85BE},
{0x596E,0x85BF}, {0x596F,0x85C2}, {0x5970,0x85C7}, {0x5971,0x85CA}, {0x5972,0x85CB},
{0x5973,0x85CE}, {0x5974,0x85AD}, {0x5975,0x85D8}, {0x5976,0x85DA}, {0x5977,0x85DF},
{0x5978,0x85E0}, {0x5979,0x85E6}, {0x597A,0x85E8}, {0x597B,0x85ED}, {0x597C,0x85F3},
{0x597D,0x85F6}, {0x597E,0x85FC}, {0x5A21,0x85FF}, {0x5A22,0x8600}, {0x5A23,0x8604},
{0x5A24,0x8605}, {0x5A25,0x860D}, {0x5A26,0x860E}, {0x5A27,0x8610}, {0x5A28,0x8611},
{0x5A29,0x8612}, {0x5A2A,0x8618}, {0x5A2B,0x8619}, {0x5A2C,0x861B}, {0x5A2D,0x861E},
{0x5A2E,0x8621}, {0x5A2F,0x8627}, {0x5A30,0x8629}, {0x5A31,0x8636}, {0x5A32,0x8638},
{0x5A33,0x863A}, {0x5A34,0x863C}, {0x5A35,0x863D}, {0x5A36,0x8640}, {0x5A37,0x8642},
{0x5A38,0x8646}, {0x5A39,0x8652}, {0x5A3A,0x8653}, {0x5A3B,0x8656}, {0x5A3C,0x8657},
{0x5A3D,0x8658}, {0x5A3E,0x8659}, {0x5A3F,0x865D}, {0x5A40,0x8660}, {0x5A41,0x8661},
{0x5A42,0x8662}, {0x5A43,0x8663}, {0x5A44,0x8664}, {0x5A45,0x8669}, {0x5A46,0x866C},
{0x5A47,0x866F}, {0x5A48,0x8675}, {0x5A49,0x8676}, {0x5A4A,0x8677}, {0x5A4B,0x867A},
{0x5A4C,0x868D}, {0x5A4D,0x8691}, {0x5A4E,0x8696}, {0x5A4F,0x8698}, {0x5A50,0x869A},
{0x5A51,0x869C}, {0x5A52,0x86A1}, {0x5A53,0x86A6}, {0x5A54,0x86A7}, {0x5A55,0x86A8},
{0x5A56,0x86AD}, {0x5A57,0x86B1}, {0x5A58,0x86B3}, {0x5A59,0x86B4}, {0x5A5A,0x86B5},
{0x5A5B,0x86B7}, {0x5A5C,0x86B8}, {0x5A5D,0x86B9}, {0x5A5E,0x86BF}, {0x5A5F,0x86C0},
{0x5A60,0x86C1}, {0x5A61,0x86C3}, {0x5A62,0x86C5}, {0x5A63,0x86D1}, {0x5A64,0x86D2},
{0x5A65,0x86D5}, {0x5A66,0x86D7}, {0x5A67,0x86DA}, {0x5A68,0x86DC}, {0x5A69,0x86E0},
{0x5A6A,0x86E3}, {0x5A6B,0x86E5}, {0x5A6C,0x86E7}, {0x5A6D,0x8688}, {0x5A6E,0x86FA},
{0x5A6F,0x86FC}, {0x5A70,0x86FD}, {0x5A71,0x8704}, {0x5A72,0x8705}, {0x5A73,0x8707},
{0x5A74,0x870B}, {0x5A75,0x870E}, {0x5A76,0x870F}, {0x5A77,0x8710}, {0x5A78,0x8713},
{0x5A79,0x8714}, {0x5A7A,0x8719}, {0x5A7B,0x871E}, {0x5A7C,0x871F}, {0x5A7D,0x8721},
{0x5A7E,0x8723}, {0x5B21,0x8728}, {0x5B22,0x872E}, {0x5B23,0x872F}, {0x5B24,0x8731},
{0x5B25,0x8732}, {0x5B26,0x8739}, {0x5B27,0x873A}, {0x5B28,0x873C}, {0x5B29,0x873D},
{0x5B2A,0x873E}, {0x5B2B,0x8740}, {0x5B2C,0x8743}, {0x5B2D,0x8745}, {0x5B2E,0x874D},
{0x5B2F,0x8758}, {0x5B30,0x875D}, {0x5B31,0x8761}, {0x5B32,0x8764}, {0x5B33,0x8765},
{0x5B34,0x876F}, {0x5B35,0x8771}, {0x5B36,0x8772}, {0x5B37,0x877B}, {0x5B38,0x8783},
{0x5B39,0x8784}, {0x5B3A,0x8785}, {0x5B3B,0x8786}, {0x5B3C,0x8787}, {0x5B3D,0x8788},
{0x5B3E,0x8789}, {0x5B3F,0x878B}, {0x5B40,0x878C}, {0x5B41,0x8790}, {0x5B42,0x8793},
{0x5B43,0x8795}, {0x5B44,0x8797}, {0x5B45,0x8798}, {0x5B46,0x8799}, {0x5B47,0x879E},
{0x5B48,0x87A0}, {0x5B49,0x87A3}, {0x5B4A,0x87A7}, {0x5B4B,0x87AC}, {0x5B4C,0x87AD},
{0x5B4D,0x87AE}, {0x5B4E,0x87B1}, {0x5B4F,0x87B5}, {0x5B50,0x87BE}, {0x5B51,0x87BF},
{0x5B52,0x87C1}, {0x5B53,0x87C8}, {0x5B54,0x87C9}, {0x5B55,0x87CA}, {0x5B56,0x87CE},
{0x5B57,0x87D5}, {0x5B58,0x87D6}, {0x5B59,0x87D9}, {0x5B5A,0x87DA}, {0x5B5B,0x87DC},
{0x5B5C,0x87DF}, {0x5B5D,0x87E2}, {0x5B5E,0x87E3}, {0x5B5F,0x87E4}, {0x5B60,0x87EA},
{0x5B61,0x87EB}, {0x5B62,0x87ED}, {0x5B63,0x87F1}, {0x5B64,0x87F3}, {0x5B65,0x87F8},
{0x5B66,0x87FA}, {0x5B67,0x87FF}, {0x5B68,0x8801}, {0x5B69,0x8803}, {0x5B6A,0x8806},
{0x5B6B,0x8809}, {0x5B6C,0x880A}, {0x5B6D,0x880B}, {0x5B6E,0x8810}, {0x5B6F,0x8819},
{0x5B70,0x8812}, {0x5B71,0x8813}, {0x5B72,0x8814}, {0x5B73,0x8818}, {0x5B74,0x881A},
{0x5B75,0x881B}, {0x5B76,0x881C}, {0x5B77,0x881E}, {0x5B78,0x881F}, {0x5B79,0x8828},
{0x5B7A,0x882D}, {0x5B7B,0x882E}, {0x5B7C,0x8830}, {0x5B7D,0x8832}, {0x5B7E,0x8835},
{0x5C21,0x883A}, {0x5C22,0x883C}, {0x5C23,0x8841}, {0x5C24,0x8843}, {0x5C25,0x8845},
{0x5C26,0x8848}, {0x5C27,0x8849}, {0x5C28,0x884A}, {0x5C29,0x884B}, {0x5C2A,0x884E},
{0x5C2B,0x8851}, {0x5C2C,0x8855}, {0x5C2D,0x8856}, {0x5C2E,0x8858}, {0x5C2F,0x885A},
{0x5C30,0x885C}, {0x5C31,0x885F}, {0x5C32,0x8860}, {0x5C33,0x8864}, {0x5C34,0x8869},
{0x5C35,0x8871}, {0x5C36,0x8879}, {0x5C37,0x887B}, {0x5C38,0x8880}, {0x5C39,0x8898},
{0x5C3A,0x889A}, {0x5C3B,0x889B}, {0x5C3C,0x889C}, {0x5C3D,0x889F}, {0x5C3E,0x88A0},
{0x5C3F,0x88A8}, {0x5C40,0x88AA}, {0x5C41,0x88BA}, {0x5C42,0x88BD}, {0x5C43,0x88BE},
{0x5C44,0x88C0}, {0x5C45,0x88CA}, {0x5C46,0x88CB}, {0x5C47,0x88CC}, {0x5C48,0x88CD},
{0x5C49,0x88CE}, {0x5C4A,0x88D1}, {0x5C4B,0x88D2}, {0x5C4C,0x88D3}, {0x5C4D,0x88DB},
{0x5C4E,0x88DE}, {0x5C4F,0x88E7}, {0x5C50,0x88EF}, {0x5C51,0x88F0}, {0x5C52,0x88F1},
{0x5C53,0x88F5}, {0x5C54,0x88F7}, {0x5C55,0x8901}, {0x5C56,0x8906}, {0x5C57,0x890D},
{0x5C58,0x890E}, {0x5C59,0x890F}, {0x5C5A,0x8915}, {0x5C5B,0x8916}, {0x5C5C,0x8918},
{0x5C5D,0x8919}, {0x5C5E,0x891A}, {0x5C5F,0x891C}, {0x5C60,0x8920}, {0x5C61,0x8926},
{0x5C62,0x8927}, {0x5C63,0x8928}, {0x5C64,0x8930}, {0x5C65,0x8931}, {0x5C66,0x8932},
{0x5C67,0x8935}, {0x5C68,0x8939}, {0x5C69,0x893A}, {0x5C6A,0x893E}, {0x5C6B,0x8940},
{0x5C6C,0x8942}, {0x5C6D,0x8945}, {0x5C6E,0x8946}, {0x5C6F,0x8949}, {0x5C70,0x894F},
{0x5C71,0x8952}, {0x5C72,0x8957}, {0x5C73,0x895A}, {0x5C74,0x895B}, {0x5C75,0x895C},
{0x5C76,0x8961}, {0x5C77,0x8962}, {0x5C78,0x8963}, {0x5C79,0x896B}, {0x5C7A,0x896E},
{0x5C7B,0x8970}, {0x5C7C,0x8973}, {0x5C7D,0x8975}, {0x5C7E,0x897A}, {0x5D21,0x897B},
{0x5D22,0x897C}, {0x5D23,0x897D}, {0x5D24,0x8989}, {0x5D25,0x898D}, {0x5D26,0x8990},
{0x5D27,0x8994}, {0x5D28,0x8995}, {0x5D29,0x899B}, {0x5D2A,0x899C}, {0x5D2B,0x899F},
{0x5D2C,0x89A0}, {0x5D2D,0x89A5}, {0x5D2E,0x89B0}, {0x5D2F,0x89B4}, {0x5D30,0x89B5},
{0x5D31,0x89B6}, {0x5D32,0x89B7}, {0x5D33,0x89BC}, {0x5D34,0x89D4}, {0x5D35,0x89D5},
{0x5D36,0x89D6}, {0x5D37,0x89D7}, {0x5D38,0x89D8}, {0x5D39,0x89E5}, {0x5D3A,0x89E9},
{0x5D3B,0x89EB}, {0x5D3C,0x89ED}, {0x5D3D,0x89F1}, {0x5D3E,0x89F3}, {0x5D3F,0x89F6},
{0x5D40,0x89F9}, {0x5D41,0x89FD}, {0x5D42,0x89FF}, {0x5D43,0x8A04}, {0x5D44,0x8A05},
{0x5D45,0x8A07}, {0x5D46,0x8A0F}, {0x5D47,0x8A11}, {0x5D48,0x8A12}, {0x5D49,0x8A14},
{0x5D4A,0x8A15}, {0x5D4B,0x8A1E}, {0x5D4C,0x8A20}, {0x5D4D,0x8A22}, {0x5D4E,0x8A24},
{0x5D4F,0x8A26}, {0x5D50,0x8A2B}, {0x5D51,0x8A2C}, {0x5D52,0x8A2F}, {0x5D53,0x8A35},
{0x5D54,0x8A37}, {0x5D55,0x8A3D}, {0x5D56,0x8A3E}, {0x5D57,0x8A40}, {0x5D58,0x8A43},
{0x5D59,0x8A45}, {0x5D5A,0x8A47}, {0x5D5B,0x8A49}, {0x5D5C,0x8A4D}, {0x5D5D,0x8A4E},
{0x5D5E,0x8A53}, {0x5D5F,0x8A56}, {0x5D60,0x8A57}, {0x5D61,0x8A58}, {0x5D62,0x8A5C},
{0x5D63,0x8A5D}, {0x5D64,0x8A61}, {0x5D65,0x8A65}, {0x5D66,0x8A67}, {0x5D67,0x8A75},
{0x5D68,0x8A76}, {0x5D69,0x8A77}, {0x5D6A,0x8A79}, {0x5D6B,0x8A7A}, {0x5D6C,0x8A7B},
{0x5D6D,0x8A7E}, {0x5D6E,0x8A7F}, {0x5D6F,0x8A80}, {0x5D70,0x8A83}, {0x5D71,0x8A86},
{0x5D72,0x8A8B}, {0x5D73,0x8A8F}, {0x5D74,0x8A90}, {0x5D75,0x8A92}, {0x5D76,0x8A96},
{0x5D77,0x8A97}, {0x5D78,0x8A99}, {0x5D79,0x8A9F}, {0x5D7A,0x8AA7}, {0x5D7B,0x8AA9},
{0x5D7C,0x8AAE}, {0x5D7D,0x8AAF}, {0x5D7E,0x8AB3}, {0x5E21,0x8AB6}, {0x5E22,0x8AB7},
{0x5E23,0x8ABB}, {0x5E24,0x8ABE}, {0x5E25,0x8AC3}, {0x5E26,0x8AC6}, {0x5E27,0x8AC8},
{0x5E28,0x8AC9}, {0x5E29,0x8ACA}, {0x5E2A,0x8AD1}, {0x5E2B,0x8AD3}, {0x5E2C,0x8AD4},
{0x5E2D,0x8AD5}, {0x5E2E,0x8AD7}, {0x5E2F,0x8ADD}, {0x5E30,0x8ADF}, {0x5E31,0x8AEC},
{0x5E32,0x8AF0}, {0x5E33,0x8AF4}, {0x5E34,0x8AF5}, {0x5E35,0x8AF6}, {0x5E36,0x8AFC},
{0x5E37,0x8AFF}, {0x5E38,0x8B05}, {0x5E39,0x8B06}, {0x5E3A,0x8B0B}, {0x5E3B,0x8B11},
{0x5E3C,0x8B1C}, {0x5E3D,0x8B1E}, {0x5E3E,0x8B1F}, {0x5E3F,0x8B0A}, {0x5E40,0x8B2D},
{0x5E41,0x8B30}, {0x5E42,0x8B37}, {0x5E43,0x8B3C}, {0x5E44,0x8B42}, {0x5E45,0x8B43},
{0x5E46,0x8B44}, {0x5E47,0x8B45}, {0x5E48,0x8B46}, {0x5E49,0x8B48}, {0x5E4A,0x8B52},
{0x5E4B,0x8B53}, {0x5E4C,0x8B54}, {0x5E4D,0x8B59}, {0x5E4E,0x8B4D}, {0x5E4F,0x8B5E},
{0x5E50,0x8B63}, {0x5E51,0x8B6D}, {0x5E52,0x8B76}, {0x5E53,0x8B78}, {0x5E54,0x8B79},
{0x5E55,0x8B7C}, {0x5E56,0x8B7E}, {0x5E57,0x8B81}, {0x5E58,0x8B84}, {0x5E59,0x8B85},
{0x5E5A,0x8B8B}, {0x5E5B,0x8B8D}, {0x5E5C,0x8B8F}, {0x5E5D,0x8B94}, {0x5E5E,0x8B95},
{0x5E5F,0x8B9C}, {0x5E60,0x8B9E}, {0x5E61,0x8B9F}, {0x5E62,0x8C38}, {0x5E63,0x8C39},
{0x5E64,0x8C3D}, {0x5E65,0x8C3E}, {0x5E66,0x8C45}, {0x5E67,0x8C47}, {0x5E68,0x8C49},
{0x5E69,0x8C4B}, {0x5E6A,0x8C4F}, {0x5E6B,0x8C51}, {0x5E6C,0x8C53}, {0x5E6D,0x8C54},
{0x5E6E,0x8C57}, {0x5E6F,0x8C58}, {0x5E70,0x8C5B}, {0x5E71,0x8C5D}, {0x5E72,0x8C59},
{0x5E73,0x8C63}, {0x5E74,0x8C64}, {0x5E75,0x8C66}, {0x5E76,0x8C68}, {0x5E77,0x8C69},
{0x5E78,0x8C6D}, {0x5E79,0x8C73}, {0x5E7A,0x8C75}, {0x5E7B,0x8C76}, {0x5E7C,0x8C7B},
{0x5E7D,0x8C7E}, {0x5E7E,0x8C86}, {0x5F21,0x8C87}, {0x5F22,0x8C8B}, {0x5F23,0x8C90},
{0x5F24,0x8C92}, {0x5F25,0x8C93}, {0x5F26,0x8C99}, {0x5F27,0x8C9B}, {0x5F28,0x8C9C},
{0x5F29,0x8CA4}, {0x5F2A,0x8CB9}, {0x5F2B,0x8CBA}, {0x5F2C,0x8CC5}, {0x5F2D,0x8CC6},
{0x5F2E,0x8CC9}, {0x5F2F,0x8CCB}, {0x5F30,0x8CCF}, {0x5F31,0x8CD6}, {0x5F32,0x8CD5},
{0x5F33,0x8CD9}, {0x5F34,0x8CDD}, {0x5F35,0x8CE1}, {0x5F36,0x8CE8}, {0x5F37,0x8CEC},
{0x5F38,0x8CEF}, {0x5F39,0x8CF0}, {0x5F3A,0x8CF2}, {0x5F3B,0x8CF5}, {0x5F3C,0x8CF7},
{0x5F3D,0x8CF8}, {0x5F3E,0x8CFE}, {0x5F3F,0x8CFF}, {0x5F40,0x8D01}, {0x5F41,0x8D03},
{0x5F42,0x8D09}, {0x5F43,0x8D12}, {0x5F44,0x8D17}, {0x5F45,0x8D1B}, {0x5F46,0x8D65},
{0x5F47,0x8D69}, {0x5F48,0x8D6C}, {0x5F49,0x8D6E}, {0x5F4A,0x8D7F}, {0x5F4B,0x8D82},
{0x5F4C,0x8D84}, {0x5F4D,0x8D88}, {0x5F4E,0x8D8D}, {0x5F4F,0x8D90}, {0x5F50,0x8D91},
{0x5F51,0x8D95}, {0x5F52,0x8D9E}, {0x5F53,0x8D9F}, {0x5F54,0x8DA0}, {0x5F55,0x8DA6},
{0x5F56,0x8DAB}, {0x5F57,0x8DAC}, {0x5F58,0x8DAF}, {0x5F59,0x8DB2}, {0x5F5A,0x8DB5},
{0x5F5B,0x8DB7}, {0x5F5C,0x8DB9}, {0x5F5D,0x8DBB}, {0x5F5E,0x8DC0}, {0x5F5F,0x8DC5},
{0x5F60,0x8DC6}, {0x5F61,0x8DC7}, {0x5F62,0x8DC8}, {0x5F63,0x8DCA}, {0x5F64,0x8DCE},
{0x5F65,0x8DD1}, {0x5F66,0x8DD4}, {0x5F67,0x8DD5}, {0x5F68,0x8DD7}, {0x5F69,0x8DD9},
{0x5F6A,0x8DE4}, {0x5F6B,0x8DE5}, {0x5F6C,0x8DE7}, {0x5F6D,0x8DEC}, {0x5F6E,0x8DF0},
{0x5F6F,0x8DBC}, {0x5F70,0x8DF1}, {0x5F71,0x8DF2}, {0x5F72,0x8DF4}, {0x5F73,0x8DFD},
{0x5F74,0x8E01}, {0x5F75,0x8E04}, {0x5F76,0x8E05}, {0x5F77,0x8E06}, {0x5F78,0x8E0B},
{0x5F79,0x8E11}, {0x5F7A,0x8E14}, {0x5F7B,0x8E16}, {0x5F7C,0x8E20}, {0x5F7D,0x8E21},
{0x5F7E,0x8E22}, {0x6021,0x8E23}, {0x6022,0x8E26}, {0x6023,0x8E27}, {0x6024,0x8E31},
{0x6025,0x8E33}, {0x6026,0x8E36}, {0x6027,0x8E37}, {0x6028,0x8E38}, {0x6029,0x8E39},
{0x602A,0x8E3D}, {0x602B,0x8E40}, {0x602C,0x8E41}, {0x602D,0x8E4B}, {0x602E,0x8E4D},
{0x602F,0x8E4E}, {0x6030,0x8E4F}, {0x6031,0x8E54}, {0x6032,0x8E5B}, {0x6033,0x8E5C},
{0x6034,0x8E5D}, {0x6035,0x8E5E}, {0x6036,0x8E61}, {0x6037,0x8E62}, {0x6038,0x8E69},
{0x6039,0x8E6C}, {0x603A,0x8E6D}, {0x603B,0x8E6F}, {0x603C,0x8E70}, {0x603D,0x8E71},
{0x603E,0x8E79}, {0x603F,0x8E7A}, {0x6040,0x8E7B}, {0x6041,0x8E82}, {0x6042,0x8E83},
{0x6043,0x8E89}, {0x6044,0x8E90}, {0x6045,0x8E92}, {0x6046,0x8E95}, {0x6047,0x8E9A},
{0x6048,0x8E9B}, {0x6049,0x8E9D}, {0x604A,0x8E9E}, {0x604B,0x8EA2}, {0x604C,0x8EA7},
{0x604D,0x8EA9}, {0x604E,0x8EAD}, {0x604F,0x8EAE}, {0x6050,0x8EB3}, {0x6051,0x8EB5},
{0x6052,0x8EBA}, {0x6053,0x8EBB}, {0x6054,0x8EC0}, {0x6055,0x8EC1}, {0x6056,0x8EC3},
{0x6057,0x8EC4}, {0x6058,0x8EC7}, {0x6059,0x8ECF}, {0x605A,0x8ED1}, {0x605B,0x8ED4},
{0x605C,0x8EDC}, {0x605D,0x8EE8}, {0x605E,0x8EEE}, {0x605F,0x8EF0}, {0x6060,0x8EF1},
{0x6061,0x8EF7}, {0x6062,0x8EF9}, {0x6063,0x8EFA}, {0x6064,0x8EED}, {0x6065,0x8F00},
{0x6066,0x8F02}, {0x6067,0x8F07}, {0x6068,0x8F08}, {0x6069,0x8F0F}, {0x606A,0x8F10},
{0x606B,0x8F16}, {0x606C,0x8F17}, {0x606D,0x8F18}, {0x606E,0x8F1E}, {0x606F,0x8F20},
{0x6070,0x8F21}, {0x6071,0x8F23}, {0x6072,0x8F25}, {0x6073,0x8F27}, {0x6074,0x8F28},
{0x6075,0x8F2C}, {0x6076,0x8F2D}, {0x6077,0x8F2E}, {0x6078,0x8F34}, {0x6079,0x8F35},
{0x607A,0x8F36}, {0x607B,0x8F37}, {0x607C,0x8F3A}, {0x607D,0x8F40}, {0x607E,0x8F41},
{0x6121,0x8F43}, {0x6122,0x8F47}, {0x6123,0x8F4F}, {0x6124,0x8F51}, {0x6125,0x8F52},
{0x6126,0x8F53}, {0x6127,0x8F54}, {0x6128,0x8F55}, {0x6129,0x8F58}, {0x612A,0x8F5D},
{0x612B,0x8F5E}, {0x612C,0x8F65}, {0x612D,0x8F9D}, {0x612E,0x8FA0}, {0x612F,0x8FA1},
{0x6130,0x8FA4}, {0x6131,0x8FA5}, {0x6132,0x8FA6}, {0x6133,0x8FB5}, {0x6134,0x8FB6},
{0x6135,0x8FB8}, {0x6136,0x8FBE}, {0x6137,0x8FC0}, {0x6138,0x8FC1}, {0x6139,0x8FC6},
{0x613A,0x8FCA}, {0x613B,0x8FCB}, {0x613C,0x8FCD}, {0x613D,0x8FD0}, {0x613E,0x8FD2},
{0x613F,0x8FD3}, {0x6140,0x8FD5}, {0x6141,0x8FE0}, {0x6142,0x8FE3}, {0x6143,0x8FE4},
{0x6144,0x8FE8}, {0x6145,0x8FEE}, {0x6146,0x8FF1}, {0x6147,0x8FF5}, {0x6148,0x8FF6},
{0x6149,0x8FFB}, {0x614A,0x8FFE}, {0x614B,0x9002}, {0x614C,0x9004}, {0x614D,0x9008},
{0x614E,0x900C}, {0x614F,0x9018}, {0x6150,0x901B}, {0x6151,0x9028}, {0x6152,0x9029},
{0x6153,0x902F}, {0x6154,0x902A}, {0x6155,0x902C}, {0x6156,0x902D}, {0x6157,0x9033},
{0x6158,0x9034}, {0x6159,0x9037}, {0x615A,0x903F}, {0x615B,0x9043}, {0x615C,0x9044},
{0x615D,0x904C}, {0x615E,0x905B}, {0x615F,0x905D}, {0x6160,0x9062}, {0x6161,0x9066},
{0x6162,0x9067}, {0x6163,0x906C}, {0x6164,0x9070}, {0x6165,0x9074}, {0x6166,0x9079},
{0x6167,0x9085}, {0x6168,0x9088}, {0x6169,0x908B}, {0x616A,0x908C}, {0x616B,0x908E},
{0x616C,0x9090}, {0x616D,0x9095}, {0x616E,0x9097}, {0x616F,0x9098}, {0x6170,0x9099},
{0x6171,0x909B}, {0x6172,0x90A0}, {0x6173,0x90A1}, {0x6174,0x90A2}, {0x6175,0x90A5},
{0x6176,0x90B0}, {0x6177,0x90B2}, {0x6178,0x90B3}, {0x6179,0x90B4}, {0x617A,0x90B6},
{0x617B,0x90BD}, {0x617C,0x90CC}, {0x617D,0x90BE}, {0x617E,0x90C3}, {0x6221,0x90C4},
{0x6222,0x90C5}, {0x6223,0x90C7}, {0x6224,0x90C8}, {0x6225,0x90D5}, {0x6226,0x90D7},
{0x6227,0x90D8}, {0x6228,0x90D9}, {0x6229,0x90DC}, {0x622A,0x90DD}, {0x622B,0x90DF},
{0x622C,0x90E5}, {0x622D,0x90D2}, {0x622E,0x90F6}, {0x622F,0x90EB}, {0x6230,0x90EF},
{0x6231,0x90F0}, {0x6232,0x90F4}, {0x6233,0x90FE}, {0x6234,0x90FF}, {0x6235,0x9100},
{0x6236,0x9104}, {0x6237,0x9105}, {0x6238,0x9106}, {0x6239,0x9108}, {0x623A,0x910D},
{0x623B,0x9110}, {0x623C,0x9114}, {0x623D,0x9116}, {0x623E,0x9117}, {0x623F,0x9118},
{0x6240,0x911A}, {0x6241,0x911C}, {0x6242,0x911E}, {0x6243,0x9120}, {0x6244,0x9125},
{0x6245,0x9122}, {0x6246,0x9123}, {0x6247,0x9127}, {0x6248,0x9129}, {0x6249,0x912E},
{0x624A,0x912F}, {0x624B,0x9131}, {0x624C,0x9134}, {0x624D,0x9136}, {0x624E,0x9137},
{0x624F,0x9139}, {0x6250,0x913A}, {0x6251,0x913C}, {0x6252,0x913D}, {0x6253,0x9143},
{0x6254,0x9147}, {0x6255,0x9148}, {0x6256,0x914F}, {0x6257,0x9153}, {0x6258,0x9157},
{0x6259,0x9159}, {0x625A,0x915A}, {0x625B,0x915B}, {0x625C,0x9161}, {0x625D,0x9164},
{0x625E,0x9167}, {0x625F,0x916D}, {0x6260,0x9174}, {0x6261,0x9179}, {0x6262,0x917A},
{0x6263,0x917B}, {0x6264,0x9181}, {0x6265,0x9183}, {0x6266,0x9185}, {0x6267,0x9186},
{0x6268,0x918A}, {0x6269,0x918E}, {0x626A,0x9191}, {0x626B,0x9193}, {0x626C,0x9194},
{0x626D,0x9195}, {0x626E,0x9198}, {0x626F,0x919E}, {0x6270,0x91A1}, {0x6271,0x91A6},
{0x6272,0x91A8}, {0x6273,0x91AC}, {0x6274,0x91AD}, {0x6275,0x91AE}, {0x6276,0x91B0},
{0x6277,0x91B1}, {0x6278,0x91B2}, {0x6279,0x91B3}, {0x627A,0x91B6}, {0x627B,0x91BB},
{0x627C,0x91BC}, {0x627D,0x91BD}, {0x627E,0x91BF}, {0x6321,0x91C2}, {0x6322,0x91C3},
{0x6323,0x91C5}, {0x6324,0x91D3}, {0x6325,0x91D4}, {0x6326,0x91D7}, {0x6327,0x91D9},
{0x6328,0x91DA}, {0x6329,0x91DE}, {0x632A,0x91E4}, {0x632B,0x91E5}, {0x632C,0x91E9},
{0x632D,0x91EA}, {0x632E,0x91EC}, {0x632F,0x91ED}, {0x6330,0x91EE}, {0x6331,0x91EF},
{0x6332,0x91F0}, {0x6333,0x91F1}, {0x6334,0x91F7}, {0x6335,0x91F9}, {0x6336,0x91FB},
{0x6337,0x91FD}, {0x6338,0x9200}, {0x6339,0x9201}, {0x633A,0x9204}, {0x633B,0x9205},
{0x633C,0x9206}, {0x633D,0x9207}, {0x633E,0x9209}, {0x633F,0x920A}, {0x6340,0x920C},
{0x6341,0x9210}, {0x6342,0x9212}, {0x6343,0x9213}, {0x6344,0x9216}, {0x6345,0x9218},
{0x6346,0x921C}, {0x6347,0x921D}, {0x6348,0x9223}, {0x6349,0x9224}, {0x634A,0x9225},
{0x634B,0x9226}, {0x634C,0x9228}, {0x634D,0x922E}, {0x634E,0x922F}, {0x634F,0x9230},
{0x6350,0x9233}, {0x6351,0x9235}, {0x6352,0x9236}, {0x6353,0x9238}, {0x6354,0x9239},
{0x6355,0x923A}, {0x6356,0x923C}, {0x6357,0x923E}, {0x6358,0x9240}, {0x6359,0x9242},
{0x635A,0x9243}, {0x635B,0x9246}, {0x635C,0x9247}, {0x635D,0x924A}, {0x635E,0x924D},
{0x635F,0x924E}, {0x6360,0x924F}, {0x6361,0x9251}, {0x6362,0x9258}, {0x6363,0x9259},
{0x6364,0x925C}, {0x6365,0x925D}, {0x6366,0x9260}, {0x6367,0x9261}, {0x6368,0x9265},
{0x6369,0x9267}, {0x636A,0x9268}, {0x636B,0x9269}, {0x636C,0x926E}, {0x636D,0x926F},
{0x636E,0x9270}, {0x636F,0x9275}, {0x6370,0x9276}, {0x6371,0x9277}, {0x6372,0x9278},
{0x6373,0x9279}, {0x6374,0x927B}, {0x6375,0x927C}, {0x6376,0x927D}, {0x6377,0x927F},
{0x6378,0x9288}, {0x6379,0x9289}, {0x637A,0x928A}, {0x637B,0x928D}, {0x637C,0x928E},
{0x637D,0x9292}, {0x637E,0x9297}, {0x6421,0x9299}, {0x6422,0x929F}, {0x6423,0x92A0},
{0x6424,0x92A4}, {0x6425,0x92A5}, {0x6426,0x92A7}, {0x6427,0x92A8}, {0x6428,0x92AB},
{0x6429,0x92AF}, {0x642A,0x92B2}, {0x642B,0x92B6}, {0x642C,0x92B8}, {0x642D,0x92BA},
{0x642E,0x92BB}, {0x642F,0x92BC}, {0x6430,0x92BD}, {0x6431,0x92BF}, {0x6432,0x92C0},
{0x6433,0x92C1}, {0x6434,0x92C2}, {0x6435,0x92C3}, {0x6436,0x92C5}, {0x6437,0x92C6},
{0x6438,0x92C7}, {0x6439,0x92C8}, {0x643A,0x92CB}, {0x643B,0x92CC}, {0x643C,0x92CD},
{0x643D,0x92CE}, {0x643E,0x92D0}, {0x643F,0x92D3}, {0x6440,0x92D5}, {0x6441,0x92D7},
{0x6442,0x92D8}, {0x6443,0x92D9}, {0x6444,0x92DC}, {0x6445,0x92DD}, {0x6446,0x92DF},
{0x6447,0x92E0}, {0x6448,0x92E1}, {0x6449,0x92E3}, {0x644A,0x92E5}, {0x644B,0x92E7},
{0x644C,0x92E8}, {0x644D,0x92EC}, {0x644E,0x92EE}, {0x644F,0x92F0}, {0x6450,0x92F9},
{0x6451,0x92FB}, {0x6452,0x92FF}, {0x6453,0x9300}, {0x6454,0x9302}, {0x6455,0x9308},
{0x6456,0x930D}, {0x6457,0x9311}, {0x6458,0x9314}, {0x6459,0x9315}, {0x645A,0x931C},
{0x645B,0x931D}, {0x645C,0x931E}, {0x645D,0x931F}, {0x645E,0x9321}, {0x645F,0x9324},
{0x6460,0x9325}, {0x6461,0x9327}, {0x6462,0x9329}, {0x6463,0x932A}, {0x6464,0x9333},
{0x6465,0x9334}, {0x6466,0x9336}, {0x6467,0x9337}, {0x6468,0x9347}, {0x6469,0x9348},
{0x646A,0x9349}, {0x646B,0x9350}, {0x646C,0x9351}, {0x646D,0x9352}, {0x646E,0x9355},
{0x646F,0x9357}, {0x6470,0x9358}, {0x6471,0x935A}, {0x6472,0x935E}, {0x6473,0x9364},
{0x6474,0x9365}, {0x6475,0x9367}, {0x6476,0x9369}, {0x6477,0x936A}, {0x6478,0x936D},
{0x6479,0x936F}, {0x647A,0x9370}, {0x647B,0x9371}, {0x647C,0x9373}, {0x647D,0x9374},
{0x647E,0x9376}, {0x6521,0x937A}, {0x6522,0x937D}, {0x6523,0x937F}, {0x6524,0x9380},
{0x6525,0x9381}, {0x6526,0x9382}, {0x6527,0x9388}, {0x6528,0x938A}, {0x6529,0x938B},
{0x652A,0x938D}, {0x652B,0x938F}, {0x652C,0x9392}, {0x652D,0x9395}, {0x652E,0x9398},
{0x652F,0x939B}, {0x6530,0x939E}, {0x6531,0x93A1}, {0x6532,0x93A3}, {0x6533,0x93A4},
{0x6534,0x93A6}, {0x6535,0x93A8}, {0x6536,0x93AB}, {0x6537,0x93B4}, {0x6538,0x93B5},
{0x6539,0x93B6}, {0x653A,0x93BA}, {0x653B,0x93A9}, {0x653C,0x93C1}, {0x653D,0x93C4},
{0x653E,0x93C5}, {0x653F,0x93C6}, {0x6540,0x93C7}, {0x6541,0x93C9}, {0x6542,0x93CA},
{0x6543,0x93CB}, {0x6544,0x93CC}, {0x6545,0x93CD}, {0x6546,0x93D3}, {0x6547,0x93D9},
{0x6548,0x93DC}, {0x6549,0x93DE}, {0x654A,0x93DF}, {0x654B,0x93E2}, {0x654C,0x93E6},
{0x654D,0x93E7}, {0x654E,0x93F9}, {0x654F,0x93F7}, {0x6550,0x93F8}, {0x6551,0x93FA},
{0x6552,0x93FB}, {0x6553,0x93FD}, {0x6554,0x9401}, {0x6555,0x9402}, {0x6556,0x9404},
{0x6557,0x9408}, {0x6558,0x9409}, {0x6559,0x940D}, {0x655A,0x940E}, {0x655B,0x940F},
{0x655C,0x9415}, {0x655D,0x9416}, {0x655E,0x9417}, {0x655F,0x941F}, {0x6560,0x942E},
{0x6561,0x942F}, {0x6562,0x9431}, {0x6563,0x9432}, {0x6564,0x9433}, {0x6565,0x9434},
{0x6566,0x943B}, {0x6567,0x943F}, {0x6568,0x943D}, {0x6569,0x9443}, {0x656A,0x9445},
{0x656B,0x9448}, {0x656C,0x944A}, {0x656D,0x944C}, {0x656E,0x9455}, {0x656F,0x9459},
{0x6570,0x945C}, {0x6571,0x945F}, {0x6572,0x9461}, {0x6573,0x9463}, {0x6574,0x9468},
{0x6575,0x946B}, {0x6576,0x946D}, {0x6577,0x946E}, {0x6578,0x946F}, {0x6579,0x9471},
{0x657A,0x9472}, {0x657B,0x9484}, {0x657C,0x9483}, {0x657D,0x9578}, {0x657E,0x9579},
{0x6621,0x957E}, {0x6622,0x9584}, {0x6623,0x9588}, {0x6624,0x958C}, {0x6625,0x958D},
{0x6626,0x958E}, {0x6627,0x959D}, {0x6628,0x959E}, {0x6629,0x959F}, {0x662A,0x95A1},
{0x662B,0x95A6}, {0x662C,0x95A9}, {0x662D,0x95AB}, {0x662E,0x95AC}, {0x662F,0x95B4},
{0x6630,0x95B6}, {0x6631,0x95BA}, {0x6632,0x95BD}, {0x6633,0x95BF}, {0x6634,0x95C6},
{0x6635,0x95C8}, {0x6636,0x95C9}, {0x6637,0x95CB}, {0x6638,0x95D0}, {0x6639,0x95D1},
{0x663A,0x95D2}, {0x663B,0x95D3}, {0x663C,0x95D9}, {0x663D,0x95DA}, {0x663E,0x95DD},
{0x663F,0x95DE}, {0x6640,0x95DF}, {0x6641,0x95E0}, {0x6642,0x95E4}, {0x6643,0x95E6},
{0x6644,0x961D}, {0x6645,0x961E}, {0x6646,0x9622}, {0x6647,0x9624}, {0x6648,0x9625},
{0x6649,0x9626}, {0x664A,0x962C}, {0x664B,0x9631}, {0x664C,0x9633}, {0x664D,0x9637},
{0x664E,0x9638}, {0x664F,0x9639}, {0x6650,0x963A}, {0x6651,0x963C}, {0x6652,0x963D},
{0x6653,0x9641}, {0x6654,0x9652}, {0x6655,0x9654}, {0x6656,0x9656}, {0x6657,0x9657},
{0x6658,0x9658}, {0x6659,0x9661}, {0x665A,0x966E}, {0x665B,0x9674}, {0x665C,0x967B},
{0x665D,0x967C}, {0x665E,0x967E}, {0x665F,0x967F}, {0x6660,0x9681}, {0x6661,0x9682},
{0x6662,0x9683}, {0x6663,0x9684}, {0x6664,0x9689}, {0x6665,0x9691}, {0x6666,0x9696},
{0x6667,0x969A}, {0x6668,0x969D}, {0x6669,0x969F}, {0x666A,0x96A4}, {0x666B,0x96A5},
{0x666C,0x96A6}, {0x666D,0x96A9}, {0x666E,0x96AE}, {0x666F,0x96AF}, {0x6670,0x96B3},
{0x6671,0x96BA}, {0x6672,0x96CA}, {0x6673,0x96D2}, {0x6674,0x5DB2}, {0x6675,0x96D8},
{0x6676,0x96DA}, {0x6677,0x96DD}, {0x6678,0x96DE}, {0x6679,0x96DF}, {0x667A,0x96E9},
{0x667B,0x96EF}, {0x667C,0x96F1}, {0x667D,0x96FA}, {0x667E,0x9702}, {0x6721,0x9703},
{0x6722,0x9705}, {0x6723,0x9709}, {0x6724,0x971A}, {0x6725,0x971B}, {0x6726,0x971D},
{0x6727,0x9721}, {0x6728,0x9722}, {0x6729,0x9723}, {0x672A,0x9728}, {0x672B,0x9731},
{0x672C,0x9733}, {0x672D,0x9741}, {0x672E,0x9743}, {0x672F,0x974A}, {0x6730,0x974E},
{0x6731,0x974F}, {0x6732,0x9755}, {0x6733,0x9757}, {0x6734,0x9758}, {0x6735,0x975A},
{0x6736,0x975B}, {0x6737,0x9763}, {0x6738,0x9767}, {0x6739,0x976A}, {0x673A,0x976E},
{0x673B,0x9773}, {0x673C,0x9776}, {0x673D,0x9777}, {0x673E,0x9778}, {0x673F,0x977B},
{0x6740,0x977D}, {0x6741,0x977F}, {0x6742,0x9780}, {0x6743,0x9789}, {0x6744,0x9795},
{0x6745,0x9796}, {0x6746,0x9797}, {0x6747,0x9799}, {0x6748,0x979A}, {0x6749,0x979E},
{0x674A,0x979F}, {0x674B,0x97A2}, {0x674C,0x97AC}, {0x674D,0x97AE}, {0x674E,0x97B1},
{0x674F,0x97B2}, {0x6750,0x97B5}, {0x6751,0x97B6}, {0x6752,0x97B8}, {0x6753,0x97B9},
{0x6754,0x97BA}, {0x6755,0x97BC}, {0x6756,0x97BE}, {0x6757,0x97BF}, {0x6758,0x97C1},
{0x6759,0x97C4}, {0x675A,0x97C5}, {0x675B,0x97C7}, {0x675C,0x97C9}, {0x675D,0x97CA},
{0x675E,0x97CC}, {0x675F,0x97CD}, {0x6760,0x97CE}, {0x6761,0x97D0}, {0x6762,0x97D1},
{0x6763,0x97D4}, {0x6764,0x97D7}, {0x6765,0x97D8}, {0x6766,0x97D9}, {0x6767,0x97DD},
{0x6768,0x97DE}, {0x6769,0x97E0}, {0x676A,0x97DB}, {0x676B,0x97E1}, {0x676C,0x97E4},
{0x676D,0x97EF}, {0x676E,0x97F1}, {0x676F,0x97F4}, {0x6770,0x97F7}, {0x6771,0x97F8},
{0x6772,0x97FA}, {0x6773,0x9807}, {0x6774,0x980A}, {0x6775,0x9819}, {0x6776,0x980D},
{0x6777,0x980E}, {0x6778,0x9814}, {0x6779,0x9816}, {0x677A,0x981C}, {0x677B,0x981E},
{0x677C,0x9820}, {0x677D,0x9823}, {0x677E,0x9826}, {0x6821,0x982B}, {0x6822,0x982E},
{0x6823,0x982F}, {0x6824,0x9830}, {0x6825,0x9832}, {0x6826,0x9833}, {0x6827,0x9835},
{0x6828,0x9825}, {0x6829,0x983E}, {0x682A,0x9844}, {0x682B,0x9847}, {0x682C,0x984A},
{0x682D,0x9851}, {0x682E,0x9852}, {0x682F,0x9853}, {0x6830,0x9856}, {0x6831,0x9857},
{0x6832,0x9859}, {0x6833,0x985A}, {0x6834,0x9862}, {0x6835,0x9863}, {0x6836,0x9865},
{0x6837,0x9866}, {0x6838,0x986A}, {0x6839,0x986C}, {0x683A,0x98AB}, {0x683B,0x98AD},
{0x683C,0x98AE}, {0x683D,0x98B0}, {0x683E,0x98B4}, {0x683F,0x98B7}, {0x6840,0x98B8},
{0x6841,0x98BA}, {0x6842,0x98BB}, {0x6843,0x98BF}, {0x6844,0x98C2}, {0x6845,0x98C5},
{0x6846,0x98C8}, {0x6847,0x98CC}, {0x6848,0x98E1}, {0x6849,0x98E3}, {0x684A,0x98E5},
{0x684B,0x98E6}, {0x684C,0x98E7}, {0x684D,0x98EA}, {0x684E,0x98F3}, {0x684F,0x98F6},
{0x6850,0x9902}, {0x6851,0x9907}, {0x6852,0x9908}, {0x6853,0x9911}, {0x6854,0x9915},
{0x6855,0x9916}, {0x6856,0x9917}, {0x6857,0x991A}, {0x6858,0x991B}, {0x6859,0x991C},
{0x685A,0x991F}, {0x685B,0x9922}, {0x685C,0x9926}, {0x685D,0x9927}, {0x685E,0x992B},
{0x685F,0x9931}, {0x6860,0x9932}, {0x6861,0x9933}, {0x6862,0x9934}, {0x6863,0x9935},
{0x6864,0x9939}, {0x6865,0x993A}, {0x6866,0x993B}, {0x6867,0x993C}, {0x6868,0x9940},
{0x6869,0x9941}, {0x686A,0x9946}, {0x686B,0x9947}, {0x686C,0x9948}, {0x686D,0x994D},
{0x686E,0x994E}, {0x686F,0x9954}, {0x6870,0x9958}, {0x6871,0x9959}, {0x6872,0x995B},
{0x6873,0x995C}, {0x6874,0x995E}, {0x6875,0x995F}, {0x6876,0x9960}, {0x6877,0x999B},
{0x6878,0x999D}, {0x6879,0x999F}, {0x687A,0x99A6}, {0x687B,0x99B0}, {0x687C,0x99B1},
{0x687D,0x99B2}, {0x687E,0x99B5}, {0x6921,0x99B9}, {0x6922,0x99BA}, {0x6923,0x99BD},
{0x6924,0x99BF}, {0x6925,0x99C3}, {0x6926,0x99C9}, {0x6927,0x99D3}, {0x6928,0x99D4},
{0x6929,0x99D9}, {0x692A,0x99DA}, {0x692B,0x99DC}, {0x692C,0x99DE}, {0x692D,0x99E7},
{0x692E,0x99EA}, {0x692F,0x99EB}, {0x6930,0x99EC}, {0x6931,0x99F0}, {0x6932,0x99F4},
{0x6933,0x99F5}, {0x6934,0x99F9}, {0x6935,0x99FD}, {0x6936,0x99FE}, {0x6937,0x9A02},
{0x6938,0x9A03}, {0x6939,0x9A04}, {0x693A,0x9A0B}, {0x693B,0x9A0C}, {0x693C,0x9A10},
{0x693D,0x9A11}, {0x693E,0x9A16}, {0x693F,0x9A1E}, {0x6940,0x9A20}, {0x6941,0x9A22},
{0x6942,0x9A23}, {0x6943,0x9A24}, {0x6944,0x9A27}, {0x6945,0x9A2D}, {0x6946,0x9A2E},
{0x6947,0x9A33}, {0x6948,0x9A35}, {0x6949,0x9A36}, {0x694A,0x9A38}, {0x694B,0x9A47},
{0x694C,0x9A41}, {0x694D,0x9A44}, {0x694E,0x9A4A}, {0x694F,0x9A4B}, {0x6950,0x9A4C},
{0x6951,0x9A4E}, {0x6952,0x9A51}, {0x6953,0x9A54}, {0x6954,0x9A56}, {0x6955,0x9A5D},
{0x6956,0x9AAA}, {0x6957,0x9AAC}, {0x6958,0x9AAE}, {0x6959,0x9AAF}, {0x695A,0x9AB2},
{0x695B,0x9AB4}, {0x695C,0x9AB5}, {0x695D,0x9AB6}, {0x695E,0x9AB9}, {0x695F,0x9ABB},
{0x6960,0x9ABE}, {0x6961,0x9ABF}, {0x6962,0x9AC1}, {0x6963,0x9AC3}, {0x6964,0x9AC6},
{0x6965,0x9AC8}, {0x6966,0x9ACE}, {0x6967,0x9AD0}, {0x6968,0x9AD2}, {0x6969,0x9AD5},
{0x696A,0x9AD6}, {0x696B,0x9AD7}, {0x696C,0x9ADB}, {0x696D,0x9ADC}, {0x696E,0x9AE0},
{0x696F,0x9AE4}, {0x6970,0x9AE5}, {0x6971,0x9AE7}, {0x6972,0x9AE9}, {0x6973,0x9AEC},
{0x6974,0x9AF2}, {0x6975,0x9AF3}, {0x6976,0x9AF5}, {0x6977,0x9AF9}, {0x6978,0x9AFA},
{0x6979,0x9AFD}, {0x697A,0x9AFF}, {0x697B,0x9B00}, {0x697C,0x9B01}, {0x697D,0x9B02},
{0x697E,0x9B03}, {0x6A21,0x9B04}, {0x6A22,0x9B05}, {0x6A23,0x9B08}, {0x6A24,0x9B09},
{0x6A25,0x9B0B}, {0x6A26,0x9B0C}, {0x6A27,0x9B0D}, {0x6A28,0x9B0E}, {0x6A29,0x9B10},
{0x6A2A,0x9B12}, {0x6A2B,0x9B16}, {0x6A2C,0x9B19}, {0x6A2D,0x9B1B}, {0x6A2E,0x9B1C},
{0x6A2F,0x9B20}, {0x6A30,0x9B26}, {0x6A31,0x9B2B}, {0x6A32,0x9B2D}, {0x6A33,0x9B33},
{0x6A34,0x9B34}, {0x6A35,0x9B35}, {0x6A36,0x9B37}, {0x6A37,0x9B39}, {0x6A38,0x9B3A},
{0x6A39,0x9B3D}, {0x6A3A,0x9B48}, {0x6A3B,0x9B4B}, {0x6A3C,0x9B4C}, {0x6A3D,0x9B55},
{0x6A3E,0x9B56}, {0x6A3F,0x9B57}, {0x6A40,0x9B5B}, {0x6A41,0x9B5E}, {0x6A42,0x9B61},
{0x6A43,0x9B63}, {0x6A44,0x9B65}, {0x6A45,0x9B66}, {0x6A46,0x9B68}, {0x6A47,0x9B6A},
{0x6A48,0x9B6B}, {0x6A49,0x9B6C}, {0x6A4A,0x9B6D}, {0x6A4B,0x9B6E}, {0x6A4C,0x9B73},
{0x6A4D,0x9B75}, {0x6A4E,0x9B77}, {0x6A4F,0x9B78}, {0x6A50,0x9B79}, {0x6A51,0x9B7F},
{0x6A52,0x9B80}, {0x6A53,0x9B84}, {0x6A54,0x9B85}, {0x6A55,0x9B86}, {0x6A56,0x9B87},
{0x6A57,0x9B89}, {0x6A58,0x9B8A}, {0x6A59,0x9B8B}, {0x6A5A,0x9B8D}, {0x6A5B,0x9B8F},
{0x6A5C,0x9B90}, {0x6A5D,0x9B94}, {0x6A5E,0x9B9A}, {0x6A5F,0x9B9D}, {0x6A60,0x9B9E},
{0x6A61,0x9BA6}, {0x6A62,0x9BA7}, {0x6A63,0x9BA9}, {0x6A64,0x9BAC}, {0x6A65,0x9BB0},
{0x6A66,0x9BB1}, {0x6A67,0x9BB2}, {0x6A68,0x9BB7}, {0x6A69,0x9BB8}, {0x6A6A,0x9BBB},
{0x6A6B,0x9BBC}, {0x6A6C,0x9BBE}, {0x6A6D,0x9BBF}, {0x6A6E,0x9BC1}, {0x6A6F,0x9BC7},
{0x6A70,0x9BC8}, {0x6A71,0x9BCE}, {0x6A72,0x9BD0}, {0x6A73,0x9BD7}, {0x6A74,0x9BD8},
{0x6A75,0x9BDD}, {0x6A76,0x9BDF}, {0x6A77,0x9BE5}, {0x6A78,0x9BE7}, {0x6A79,0x9BEA},
{0x6A7A,0x9BEB}, {0x6A7B,0x9BEF}, {0x6A7C,0x9BF3}, {0x6A7D,0x9BF7}, {0x6A7E,0x9BF8},
{0x6B21,0x9BF9}, {0x6B22,0x9BFA}, {0x6B23,0x9BFD}, {0x6B24,0x9BFF}, {0x6B25,0x9C00},
{0x6B26,0x9C02}, {0x6B27,0x9C0B}, {0x6B28,0x9C0F}, {0x6B29,0x9C11}, {0x6B2A,0x9C16},
{0x6B2B,0x9C18}, {0x6B2C,0x9C19}, {0x6B2D,0x9C1A}, {0x6B2E,0x9C1C}, {0x6B2F,0x9C1E},
{0x6B30,0x9C22}, {0x6B31,0x9C23}, {0x6B32,0x9C26}, {0x6B33,0x9C27}, {0x6B34,0x9C28},
{0x6B35,0x9C29}, {0x6B36,0x9C2A}, {0x6B37,0x9C31}, {0x6B38,0x9C35}, {0x6B39,0x9C36},
{0x6B3A,0x9C37}, {0x6B3B,0x9C3D}, {0x6B3C,0x9C41}, {0x6B3D,0x9C43}, {0x6B3E,0x9C44},
{0x6B3F,0x9C45}, {0x6B40,0x9C49}, {0x6B41,0x9C4A}, {0x6B42,0x9C4E}, {0x6B43,0x9C4F},
{0x6B44,0x9C50}, {0x6B45,0x9C53}, {0x6B46,0x9C54}, {0x6B47,0x9C56}, {0x6B48,0x9C58},
{0x6B49,0x9C5B}, {0x6B4A,0x9C5D}, {0x6B4B,0x9C5E}, {0x6B4C,0x9C5F}, {0x6B4D,0x9C63},
{0x6B4E,0x9C69}, {0x6B4F,0x9C6A}, {0x6B50,0x9C5C}, {0x6B51,0x9C6B}, {0x6B52,0x9C68},
{0x6B53,0x9C6E}, {0x6B54,0x9C70}, {0x6B55,0x9C72}, {0x6B56,0x9C75}, {0x6B57,0x9C77},
{0x6B58,0x9C7B}, {0x6B59,0x9CE6}, {0x6B5A,0x9CF2}, {0x6B5B,0x9CF7}, {0x6B5C,0x9CF9},
{0x6B5D,0x9D0B}, {0x6B5E,0x9D02}, {0x6B5F,0x9D11}, {0x6B60,0x9D17}, {0x6B61,0x9D18},
{0x6B62,0x9D1C}, {0x6B63,0x9D1D}, {0x6B64,0x9D1E}, {0x6B65,0x9D2F}, {0x6B66,0x9D30},
{0x6B67,0x9D32}, {0x6B68,0x9D33}, {0x6B69,0x9D34}, {0x6B6A,0x9D3A}, {0x6B6B,0x9D3C},
{0x6B6C,0x9D45}, {0x6B6D,0x9D3D}, {0x6B6E,0x9D42}, {0x6B6F,0x9D43}, {0x6B70,0x9D47},
{0x6B71,0x9D4A}, {0x6B72,0x9D53}, {0x6B73,0x9D54}, {0x6B74,0x9D5F}, {0x6B75,0x9D63},
{0x6B76,0x9D62}, {0x6B77,0x9D65}, {0x6B78,0x9D69}, {0x6B79,0x9D6A}, {0x6B7A,0x9D6B},
{0x6B7B,0x9D70}, {0x6B7C,0x9D76}, {0x6B7D,0x9D77}, {0x6B7E,0x9D7B}, {0x6C21,0x9D7C},
{0x6C22,0x9D7E}, {0x6C23,0x9D83}, {0x6C24,0x9D84}, {0x6C25,0x9D86}, {0x6C26,0x9D8A},
{0x6C27,0x9D8D}, {0x6C28,0x9D8E}, {0x6C29,0x9D92}, {0x6C2A,0x9D93}, {0x6C2B,0x9D95},
{0x6C2C,0x9D96}, {0x6C2D,0x9D97}, {0x6C2E,0x9D98}, {0x6C2F,0x9DA1}, {0x6C30,0x9DAA},
{0x6C31,0x9DAC}, {0x6C32,0x9DAE}, {0x6C33,0x9DB1}, {0x6C34,0x9DB5}, {0x6C35,0x9DB9},
{0x6C36,0x9DBC}, {0x6C37,0x9DBF}, {0x6C38,0x9DC3}, {0x6C39,0x9DC7}, {0x6C3A,0x9DC9},
{0x6C3B,0x9DCA}, {0x6C3C,0x9DD4}, {0x6C3D,0x9DD5}, {0x6C3E,0x9DD6}, {0x6C3F,0x9DD7},
{0x6C40,0x9DDA}, {0x6C41,0x9DDE}, {0x6C42,0x9DDF}, {0x6C43,0x9DE0}, {0x6C44,0x9DE5},
{0x6C45,0x9DE7}, {0x6C46,0x9DE9}, {0x6C47,0x9DEB}, {0x6C48,0x9DEE}, {0x6C49,0x9DF0},
{0x6C4A,0x9DF3}, {0x6C4B,0x9DF4}, {0x6C4C,0x9DFE}, {0x6C4D,0x9E0A}, {0x6C4E,0x9E02},
{0x6C4F,0x9E07}, {0x6C50,0x9E0E}, {0x6C51,0x9E10}, {0x6C52,0x9E11}, {0x6C53,0x9E12},
{0x6C54,0x9E15}, {0x6C55,0x9E16}, {0x6C56,0x9E19}, {0x6C57,0x9E1C}, {0x6C58,0x9E1D},
{0x6C59,0x9E7A}, {0x6C5A,0x9E7B}, {0x6C5B,0x9E7C}, {0x6C5C,0x9E80}, {0x6C5D,0x9E82},
{0x6C5E,0x9E83}, {0x6C5F,0x9E84}, {0x6C60,0x9E85}, {0x6C61,0x9E87}, {0x6C62,0x9E8E},
{0x6C63,0x9E8F}, {0x6C64,0x9E96}, {0x6C65,0x9E98}, {0x6C66,0x9E9B}, {0x6C67,0x9E9E},
{0x6C68,0x9EA4}, {0x6C69,0x9EA8}, {0x6C6A,0x9EAC}, {0x6C6B,0x9EAE}, {0x6C6C,0x9EAF},
{0x6C6D,0x9EB0}, {0x6C6E,0x9EB3}, {0x6C6F,0x9EB4}, {0x6C70,0x9EB5}, {0x6C71,0x9EC6},
{0x6C72,0x9EC8}, {0x6C73,0x9ECB}, {0x6C74,0x9ED5}, {0x6C75,0x9EDF}, {0x6C76,0x9EE4},
{0x6C77,0x9EE7}, {0x6C78,0x9EEC}, {0x6C79,0x9EED}, {0x6C7A,0x9EEE}, {0x6C7B,0x9EF0},
{0x6C7C,0x9EF1}, {0x6C7D,0x9EF2}, {0x6C7E,0x9EF5}, {0x6D21,0x9EF8}, {0x6D22,0x9EFF},
{0x6D23,0x9F02}, {0x6D24,0x9F03}, {0x6D25,0x9F09}, {0x6D26,0x9F0F}, {0x6D27,0x9F10},
{0x6D28,0x9F11}, {0x6D29,0x9F12}, {0x6D2A,0x9F14}, {0x6D2B,0x9F16}, {0x6D2C,0x9F17},
{0x6D2D,0x9F19}, {0x6D2E,0x9F1A}, {0x6D2F,0x9F1B}, {0x6D30,0x9F1F}, {0x6D31,0x9F22},
{0x6D32,0x9F26}, {0x6D33,0x9F2A}, {0x6D34,0x9F2B}, {0x6D35,0x9F2F}, {0x6D36,0x9F31},
{0x6D37,0x9F32}, {0x6D38,0x9F34}, {0x6D39,0x9F37}, {0x6D3A,0x9F39}, {0x6D3B,0x9F3A},
{0x6D3C,0x9F3C}, {0x6D3D,0x9F3D}, {0x6D3E,0x9F3F}, {0x6D3F,0x9F41}, {0x6D40,0x9F43},
{0x6D41,0x9F44}, {0x6D42,0x9F45}, {0x6D43,0x9F46}, {0x6D44,0x9F47}, {0x6D45,0x9F53},
{0x6D46,0x9F55}, {0x6D47,0x9F56}, {0x6D48,0x9F57}, {0x6D49,0x9F58}, {0x6D4A,0x9F5A},
{0x6D4B,0x9F5D}, {0x6D4C,0x9F5E}, {0x6D4D,0x9F68}, {0x6D4E,0x9F69}, {0x6D4F,0x9F6D},
{0x6D50,0x9F6E}, {0x6D51,0x9F6F}, {0x6D52,0x9F70}, {0x6D53,0x9F71}, {0x6D54,0x9F73},
{0x6D55,0x9F75}, {0x6D56,0x9F7A}, {0x6D57,0x9F7D}, {0x6D58,0x9F8F}, {0x6D59,0x9F90},
{0x6D5A,0x9F91}, {0x6D5B,0x9F92}, {0x6D5C,0x9F94}, {0x6D5D,0x9F96}, {0x6D5E,0x9F97},
{0x6D5F,0x9F9E}, {0x6D60,0x9FA1}, {0x6D61,0x9FA2}, {0x6D62,0x9FA3}, {0x6D63,0x9FA5},
{0x7373,0x2170},
{0x7374,0x2171},
{0x7375,0x2172},
{0x7376,0x2173},
{0x7377,0x2174},
{0x7378,0x2175},
{0x7379,0x2176},
{0x737A,0x2177},
{0x737B,0x2178},
{0x737C,0x2179},
{0x737D,0x2160},
{0x737E,0x2161},
{0x7421,0x2162},
{0x7422,0x2163},
{0x7423,0x2164},
{0x7424,0x2165},
{0x7425,0x2166},
{0x7426,0x2167},
{0x7427,0x2168},
{0x7428,0x2169},
{0x7429,0xFF07},
{0x742A,0xFF02},
{0x742B,0x3231},
{0x742C,0x2116},
{0x742D,0x2121},
{0x742E,0x70BB},
{0x742F,0x4EFC},
{0x7430,0x50F4},
{0x7431,0x51EC},
{0x7432,0x5307},
{0x7433,0x5324},
{0x7434,0xFA0E},
{0x7435,0x548A},
{0x7436,0x5759},
{0x7437,0xFA0F},
{0x7438,0xFA10},
{0x7439,0x589E},
{0x743A,0x5BEC},
{0x743B,0x5CF5},
{0x743C,0x5D53},
{0x743D,0xFA11},
{0x743E,0x5FB7},
{0x743F,0x6085},
{0x7440,0x6120},
{0x7441,0x654E},
{0x7442,0x663B},
{0x7443,0x6665},
{0x7444,0xFA12},
{0x7445,0xF929},
{0x7446,0x6801},
{0x7447,0xFA13},
{0x7448,0xFA14},
{0x7449,0x6A6B},
{0x744A,0x6AE2},
{0x744B,0x6DF8},
{0x744C,0x6DF2},
{0x744D,0x7028},
{0x744E,0xFA15},
{0x744F,0xFA16},
{0x7450,0x7501},
{0x7451,0x7682},
{0x7452,0x769E},
{0x7453,0xFA17},
{0x7454,0x7930},
{0x7455,0xFA18},
{0x7456,0xFA19},
{0x7457,0xFA1A},
{0x7458,0xFA1B},
{0x7459,0x7AE7},
{0x745A,0xFA1C},
{0x745B,0xFA1D},
{0x745C,0x7DA0},
{0x745D,0x7DD6},
{0x745E,0xFA1E},
{0x745F,0x8362},
{0x7460,0xFA1F},
{0x7461,0x85B0},
{0x7462,0xFA20},
{0x7463,0xFA21},
{0x7464,0x8807},
{0x7465,0xFA22},
{0x7466,0x8B7F},
{0x7467,0x8CF4},
{0x7468,0x8D76},
{0x7469,0xFA23},
{0x746A,0xFA24},
{0x746B,0xFA25},
{0x746C,0x90DE},
{0x746D,0xFA26},
{0x746E,0x9115},
{0x746F,0xFA27},
{0x7470,0xFA28},
{0x7471,0x9592},
{0x7472,0xF9DC},
{0x7473,0xFA29},
{0x7474,0x973B},
{0x7475,0x974D},
{0x7476,0x9751},
{0x7477,0xFA2A},
{0x7478,0xFA2B},
{0x7479,0xFA2C},
{0x747A,0x999E},
{0x747B,0x9AD9},
{0x747C,0x9B72},
{0x747D,0xFA2D},
{0x747E,0x9ED1},
{0xA1A1,0x3000}, {0xA1A2,0x3001}, {0xA1A3,0x3002}, {0xA1A4,0xFF0C}, {0xA1A5,0xFF0E},
{0xA1A6,0x30FB}, {0xA1A7,0xFF1A}, {0xA1A8,0xFF1B}, {0xA1A9,0xFF1F}, {0xA1AA,0xFF01},
{0xA1AB,0x309B}, {0xA1AC,0x309C}, {0xA1AD,0x00B4}, {0xA1AE,0xFF40}, {0xA1AF,0x00A8},
{0xA1B0,0xFF3E}, {0xA1B1,0xFFE3}, {0xA1B2,0xFF3F}, {0xA1B3,0x30FD}, {0xA1B4,0x30FE},
{0xA1B5,0x309D}, {0xA1B6,0x309E}, {0xA1B7,0x3003}, {0xA1B8,0x4EDD}, {0xA1B9,0x3005},
{0xA1BA,0x3006}, {0xA1BB,0x3007}, {0xA1BC,0x30FC}, {0xA1BD,0x2015}, {0xA1BE,0x2010},
{0xA1BF,0xFF0F},

# ifdef UNICODE_MAPPING
{0xA1C0,0x005C},
# else
{0xA1C0,0xFF3C},
# endif
{0xA1C1,0xFF5E},
{0xA1C2,0x2225},
{0xA1C3,0xFF5C},
{0xA1C4,0x2026}, {0xA1C5,0x2025}, {0xA1C6,0x2018}, {0xA1C7,0x2019}, {0xA1C8,0x201C},
{0xA1C9,0x201D}, {0xA1CA,0xFF08}, {0xA1CB,0xFF09}, {0xA1CC,0x3014}, {0xA1CD,0x3015},
{0xA1CE,0xFF3B}, {0xA1CF,0xFF3D}, {0xA1D0,0xFF5B}, {0xA1D1,0xFF5D}, {0xA1D2,0x3008},
{0xA1D3,0x3009}, {0xA1D4,0x300A}, {0xA1D5,0x300B}, {0xA1D6,0x300C}, {0xA1D7,0x300D},
{0xA1D8,0x300E}, {0xA1D9,0x300F}, {0xA1DA,0x3010}, {0xA1DB,0x3011}, {0xA1DC,0xFF0B},
{0xA1DD,0xFF0D},
{0xA1DE,0x00B1}, {0xA1DF,0x00D7}, {0xA1E0,0x00F7}, {0xA1E1,0xFF1D},
{0xA1E2,0x2260}, {0xA1E3,0xFF1C}, {0xA1E4,0xFF1E}, {0xA1E5,0x2266}, {0xA1E6,0x2267},
{0xA1E7,0x221E}, {0xA1E8,0x2234}, {0xA1E9,0x2642}, {0xA1EA,0x2640}, {0xA1EB,0x00B0},
{0xA1EC,0x2032}, {0xA1ED,0x2033}, {0xA1EE,0x2103}, {0xA1EF,0xFFE5}, {0xA1F0,0xFF04},
{0xA1F1,0xFFE0},
{0xA1F2,0xFFE1},
{0xA1F3,0xFF05}, {0xA1F4,0xFF03}, {0xA1F5,0xFF06},
{0xA1F6,0xFF0A}, {0xA1F7,0xFF20}, {0xA1F8,0x00A7}, {0xA1F9,0x2606}, {0xA1FA,0x2605},
{0xA1FB,0x25CB}, {0xA1FC,0x25CF}, {0xA1FD,0x25CE}, {0xA1FE,0x25C7}, {0xA2A1,0x25C6},
{0xA2A2,0x25A1}, {0xA2A3,0x25A0}, {0xA2A4,0x25B3}, {0xA2A5,0x25B2}, {0xA2A6,0x25BD},
{0xA2A7,0x25BC}, {0xA2A8,0x203B}, {0xA2A9,0x3012}, {0xA2AA,0x2192}, {0xA2AB,0x2190},
{0xA2AC,0x2191}, {0xA2AD,0x2193}, {0xA2AE,0x3013}, {0xA2BA,0x2208}, {0xA2BB,0x220B},
{0xA2BC,0x2286}, {0xA2BD,0x2287}, {0xA2BE,0x2282}, {0xA2BF,0x2283}, {0xA2C0,0x222A},
{0xA2C1,0x2229}, {0xA2CA,0x2227}, {0xA2CB,0x2228}, {0xA2CC,0xffe2}, {0xA2CD,0x21D2},
{0xA2CE,0x21D4}, {0xA2CF,0x2200}, {0xA2D0,0x2203}, {0xA2DC,0x2220}, {0xA2DD,0x22A5},
{0xA2DE,0x2312}, {0xA2DF,0x2202}, {0xA2E0,0x2207}, {0xA2E1,0x2261}, {0xA2E2,0x2252},
{0xA2E3,0x226A}, {0xA2E4,0x226B}, {0xA2E5,0x221A}, {0xA2E6,0x223D}, {0xA2E7,0x221D},
{0xA2E8,0x2235}, {0xA2E9,0x222B}, {0xA2EA,0x222C}, {0xA2F2,0x212B}, {0xA2F3,0x2030},
{0xA2F4,0x266F}, {0xA2F5,0x266D}, {0xA2F6,0x266A}, {0xA2F7,0x2020}, {0xA2F8,0x2021},
{0xA2F9,0x00B6}, {0xA2FE,0x25EF}, {0xA3B0,0xFF10}, {0xA3B1,0xFF11}, {0xA3B2,0xFF12},
{0xA3B3,0xFF13}, {0xA3B4,0xFF14}, {0xA3B5,0xFF15}, {0xA3B6,0xFF16}, {0xA3B7,0xFF17},
{0xA3B8,0xFF18}, {0xA3B9,0xFF19}, {0xA3C1,0xFF21}, {0xA3C2,0xFF22}, {0xA3C3,0xFF23},
{0xA3C4,0xFF24}, {0xA3C5,0xFF25}, {0xA3C6,0xFF26}, {0xA3C7,0xFF27}, {0xA3C8,0xFF28},
{0xA3C9,0xFF29}, {0xA3CA,0xFF2A}, {0xA3CB,0xFF2B}, {0xA3CC,0xFF2C}, {0xA3CD,0xFF2D},
{0xA3CE,0xFF2E}, {0xA3CF,0xFF2F}, {0xA3D0,0xFF30}, {0xA3D1,0xFF31}, {0xA3D2,0xFF32},
{0xA3D3,0xFF33}, {0xA3D4,0xFF34}, {0xA3D5,0xFF35}, {0xA3D6,0xFF36}, {0xA3D7,0xFF37},
{0xA3D8,0xFF38}, {0xA3D9,0xFF39}, {0xA3DA,0xFF3A}, {0xA3E1,0xFF41}, {0xA3E2,0xFF42},
{0xA3E3,0xFF43}, {0xA3E4,0xFF44}, {0xA3E5,0xFF45}, {0xA3E6,0xFF46}, {0xA3E7,0xFF47},
{0xA3E8,0xFF48}, {0xA3E9,0xFF49}, {0xA3EA,0xFF4A}, {0xA3EB,0xFF4B}, {0xA3EC,0xFF4C},
{0xA3ED,0xFF4D}, {0xA3EE,0xFF4E}, {0xA3EF,0xFF4F}, {0xA3F0,0xFF50}, {0xA3F1,0xFF51},
{0xA3F2,0xFF52}, {0xA3F3,0xFF53}, {0xA3F4,0xFF54}, {0xA3F5,0xFF55}, {0xA3F6,0xFF56},
{0xA3F7,0xFF57}, {0xA3F8,0xFF58}, {0xA3F9,0xFF59}, {0xA3FA,0xFF5A}, {0xA4A1,0x3041},
{0xA4A2,0x3042}, {0xA4A3,0x3043}, {0xA4A4,0x3044}, {0xA4A5,0x3045}, {0xA4A6,0x3046},
{0xA4A7,0x3047}, {0xA4A8,0x3048}, {0xA4A9,0x3049}, {0xA4AA,0x304A}, {0xA4AB,0x304B},
{0xA4AC,0x304C}, {0xA4AD,0x304D}, {0xA4AE,0x304E}, {0xA4AF,0x304F}, {0xA4B0,0x3050},
{0xA4B1,0x3051}, {0xA4B2,0x3052}, {0xA4B3,0x3053}, {0xA4B4,0x3054}, {0xA4B5,0x3055},
{0xA4B6,0x3056}, {0xA4B7,0x3057}, {0xA4B8,0x3058}, {0xA4B9,0x3059}, {0xA4BA,0x305A},
{0xA4BB,0x305B}, {0xA4BC,0x305C}, {0xA4BD,0x305D}, {0xA4BE,0x305E}, {0xA4BF,0x305F},
{0xA4C0,0x3060}, {0xA4C1,0x3061}, {0xA4C2,0x3062}, {0xA4C3,0x3063}, {0xA4C4,0x3064},
{0xA4C5,0x3065}, {0xA4C6,0x3066}, {0xA4C7,0x3067}, {0xA4C8,0x3068}, {0xA4C9,0x3069},
{0xA4CA,0x306A}, {0xA4CB,0x306B}, {0xA4CC,0x306C}, {0xA4CD,0x306D}, {0xA4CE,0x306E},
{0xA4CF,0x306F}, {0xA4D0,0x3070}, {0xA4D1,0x3071}, {0xA4D2,0x3072}, {0xA4D3,0x3073},
{0xA4D4,0x3074}, {0xA4D5,0x3075}, {0xA4D6,0x3076}, {0xA4D7,0x3077}, {0xA4D8,0x3078},
{0xA4D9,0x3079}, {0xA4DA,0x307A}, {0xA4DB,0x307B}, {0xA4DC,0x307C}, {0xA4DD,0x307D},
{0xA4DE,0x307E}, {0xA4DF,0x307F}, {0xA4E0,0x3080}, {0xA4E1,0x3081}, {0xA4E2,0x3082},
{0xA4E3,0x3083}, {0xA4E4,0x3084}, {0xA4E5,0x3085}, {0xA4E6,0x3086}, {0xA4E7,0x3087},
{0xA4E8,0x3088}, {0xA4E9,0x3089}, {0xA4EA,0x308A}, {0xA4EB,0x308B}, {0xA4EC,0x308C},
{0xA4ED,0x308D}, {0xA4EE,0x308E}, {0xA4EF,0x308F}, {0xA4F0,0x3090}, {0xA4F1,0x3091},
{0xA4F2,0x3092}, {0xA4F3,0x3093}, {0xA5A1,0x30A1}, {0xA5A2,0x30A2}, {0xA5A3,0x30A3},
{0xA5A4,0x30A4}, {0xA5A5,0x30A5}, {0xA5A6,0x30A6}, {0xA5A7,0x30A7}, {0xA5A8,0x30A8},
{0xA5A9,0x30A9}, {0xA5AA,0x30AA}, {0xA5AB,0x30AB}, {0xA5AC,0x30AC}, {0xA5AD,0x30AD},
{0xA5AE,0x30AE}, {0xA5AF,0x30AF}, {0xA5B0,0x30B0}, {0xA5B1,0x30B1}, {0xA5B2,0x30B2},
{0xA5B3,0x30B3}, {0xA5B4,0x30B4}, {0xA5B5,0x30B5}, {0xA5B6,0x30B6}, {0xA5B7,0x30B7},
{0xA5B8,0x30B8}, {0xA5B9,0x30B9}, {0xA5BA,0x30BA}, {0xA5BB,0x30BB}, {0xA5BC,0x30BC},
{0xA5BD,0x30BD}, {0xA5BE,0x30BE}, {0xA5BF,0x30BF}, {0xA5C0,0x30C0}, {0xA5C1,0x30C1},
{0xA5C2,0x30C2}, {0xA5C3,0x30C3}, {0xA5C4,0x30C4}, {0xA5C5,0x30C5}, {0xA5C6,0x30C6},
{0xA5C7,0x30C7}, {0xA5C8,0x30C8}, {0xA5C9,0x30C9}, {0xA5CA,0x30CA}, {0xA5CB,0x30CB},
{0xA5CC,0x30CC}, {0xA5CD,0x30CD}, {0xA5CE,0x30CE}, {0xA5CF,0x30CF}, {0xA5D0,0x30D0},
{0xA5D1,0x30D1}, {0xA5D2,0x30D2}, {0xA5D3,0x30D3}, {0xA5D4,0x30D4}, {0xA5D5,0x30D5},
{0xA5D6,0x30D6}, {0xA5D7,0x30D7}, {0xA5D8,0x30D8}, {0xA5D9,0x30D9}, {0xA5DA,0x30DA},
{0xA5DB,0x30DB}, {0xA5DC,0x30DC}, {0xA5DD,0x30DD}, {0xA5DE,0x30DE}, {0xA5DF,0x30DF},
{0xA5E0,0x30E0}, {0xA5E1,0x30E1}, {0xA5E2,0x30E2}, {0xA5E3,0x30E3}, {0xA5E4,0x30E4},
{0xA5E5,0x30E5}, {0xA5E6,0x30E6}, {0xA5E7,0x30E7}, {0xA5E8,0x30E8}, {0xA5E9,0x30E9},
{0xA5EA,0x30EA}, {0xA5EB,0x30EB}, {0xA5EC,0x30EC}, {0xA5ED,0x30ED}, {0xA5EE,0x30EE},
{0xA5EF,0x30EF}, {0xA5F0,0x30F0}, {0xA5F1,0x30F1}, {0xA5F2,0x30F2}, {0xA5F3,0x30F3},
{0xA5F4,0x30F4}, {0xA5F5,0x30F5}, {0xA5F6,0x30F6}, {0xA6A1,0x0391}, {0xA6A2,0x0392},
{0xA6A3,0x0393}, {0xA6A4,0x0394}, {0xA6A5,0x0395}, {0xA6A6,0x0396}, {0xA6A7,0x0397},
{0xA6A8,0x0398}, {0xA6A9,0x0399}, {0xA6AA,0x039A}, {0xA6AB,0x039B}, {0xA6AC,0x039C},
{0xA6AD,0x039D}, {0xA6AE,0x039E}, {0xA6AF,0x039F}, {0xA6B0,0x03A0}, {0xA6B1,0x03A1},
{0xA6B2,0x03A3}, {0xA6B3,0x03A4}, {0xA6B4,0x03A5}, {0xA6B5,0x03A6}, {0xA6B6,0x03A7},
{0xA6B7,0x03A8}, {0xA6B8,0x03A9}, {0xA6C1,0x03B1}, {0xA6C2,0x03B2}, {0xA6C3,0x03B3},
{0xA6C4,0x03B4}, {0xA6C5,0x03B5}, {0xA6C6,0x03B6}, {0xA6C7,0x03B7}, {0xA6C8,0x03B8},
{0xA6C9,0x03B9}, {0xA6CA,0x03BA}, {0xA6CB,0x03BB}, {0xA6CC,0x03BC}, {0xA6CD,0x03BD},
{0xA6CE,0x03BE}, {0xA6CF,0x03BF}, {0xA6D0,0x03C0}, {0xA6D1,0x03C1}, {0xA6D2,0x03C3},
{0xA6D3,0x03C4}, {0xA6D4,0x03C5}, {0xA6D5,0x03C6}, {0xA6D6,0x03C7}, {0xA6D7,0x03C8},
{0xA6D8,0x03C9}, {0xA7A1,0x0410}, {0xA7A2,0x0411}, {0xA7A3,0x0412}, {0xA7A4,0x0413},
{0xA7A5,0x0414}, {0xA7A6,0x0415}, {0xA7A7,0x0401}, {0xA7A8,0x0416}, {0xA7A9,0x0417},
{0xA7AA,0x0418}, {0xA7AB,0x0419}, {0xA7AC,0x041A}, {0xA7AD,0x041B}, {0xA7AE,0x041C},
{0xA7AF,0x041D}, {0xA7B0,0x041E}, {0xA7B1,0x041F}, {0xA7B2,0x0420}, {0xA7B3,0x0421},
{0xA7B4,0x0422}, {0xA7B5,0x0423}, {0xA7B6,0x0424}, {0xA7B7,0x0425}, {0xA7B8,0x0426},
{0xA7B9,0x0427}, {0xA7BA,0x0428}, {0xA7BB,0x0429}, {0xA7BC,0x042A}, {0xA7BD,0x042B},
{0xA7BE,0x042C}, {0xA7BF,0x042D}, {0xA7C0,0x042E}, {0xA7C1,0x042F}, {0xA7D1,0x0430},
{0xA7D2,0x0431}, {0xA7D3,0x0432}, {0xA7D4,0x0433}, {0xA7D5,0x0434}, {0xA7D6,0x0435},
{0xA7D7,0x0451}, {0xA7D8,0x0436}, {0xA7D9,0x0437}, {0xA7DA,0x0438}, {0xA7DB,0x0439},
{0xA7DC,0x043A}, {0xA7DD,0x043B}, {0xA7DE,0x043C}, {0xA7DF,0x043D}, {0xA7E0,0x043E},
{0xA7E1,0x043F}, {0xA7E2,0x0440}, {0xA7E3,0x0441}, {0xA7E4,0x0442}, {0xA7E5,0x0443},
{0xA7E6,0x0444}, {0xA7E7,0x0445}, {0xA7E8,0x0446}, {0xA7E9,0x0447}, {0xA7EA,0x0448},
{0xA7EB,0x0449}, {0xA7EC,0x044A}, {0xA7ED,0x044B}, {0xA7EE,0x044C}, {0xA7EF,0x044D},
{0xA7F0,0x044E}, {0xA7F1,0x044F}, {0xA8A1,0x2500}, {0xA8A2,0x2502}, {0xA8A3,0x250C},
{0xA8A4,0x2510}, {0xA8A5,0x2518}, {0xA8A6,0x2514}, {0xA8A7,0x251C}, {0xA8A8,0x252C},
{0xA8A9,0x2524}, {0xA8AA,0x2534}, {0xA8AB,0x253C}, {0xA8AC,0x2501}, {0xA8AD,0x2503},
{0xA8AE,0x250F}, {0xA8AF,0x2513}, {0xA8B0,0x251B}, {0xA8B1,0x2517}, {0xA8B2,0x2523},
{0xA8B3,0x2533}, {0xA8B4,0x252B}, {0xA8B5,0x253B}, {0xA8B6,0x254B}, {0xA8B7,0x2520},
{0xA8B8,0x252F}, {0xA8B9,0x2528}, {0xA8BA,0x2537}, {0xA8BB,0x253F}, {0xA8BC,0x251D},
{0xA8BD,0x2530}, {0xA8BE,0x2525}, {0xA8BF,0x2538}, {0xA8C0,0x2542},
{0xADA1, 0x2460},
{0xADA2, 0x2461},
{0xADA3, 0x2462},
{0xADA4, 0x2463},
{0xADA5, 0x2464},
{0xADA6, 0x2465},
{0xADA7, 0x2466},
{0xADA8, 0x2467},
{0xADA9, 0x2468},
{0xADAA, 0x2469},
{0xADAB, 0x246A},
{0xADAC, 0x246B},
{0xADAD, 0x246C},
{0xADAE, 0x246D},
{0xADAF, 0x246E},
{0xADB0, 0x246F},
{0xADB1, 0x2470},
{0xADB2, 0x2471},
{0xADB3, 0x2472},
{0xADB4, 0x2473},
{0xADB5, 0x2160},
{0xADB6, 0x2161},
{0xADB7, 0x2162},
{0xADB8, 0x2163},
{0xADB9, 0x2164},
{0xADBA, 0x2165},
{0xADBB, 0x2166},
{0xADBC, 0x2167},
{0xADBD, 0x2168},
{0xADBE, 0x2169},
{0xADC0, 0x3349},
{0xADC1, 0x3314},
{0xADC2, 0x3322},
{0xADC3, 0x334D},
{0xADC4, 0x3318},
{0xADC5, 0x3327},
{0xADC6, 0x3303},
{0xADC7, 0x3336},
{0xADC8, 0x3351},
{0xADC9, 0x3357},
{0xADCA, 0x330D},
{0xADCB, 0x3326},
{0xADCC, 0x3323},
{0xADCD, 0x332B},
{0xADCE, 0x334A},
{0xADCF, 0x333B},
{0xADD0, 0x339C},
{0xADD1, 0x339D},
{0xADD2, 0x339E},
{0xADD3, 0x338E},
{0xADD4, 0x338F},
{0xADD5, 0x33C4},
{0xADD6, 0x33A1},
{0xADDF, 0x337B},
{0xADE0, 0x301D},
{0xADE1, 0x301F},
{0xADE2, 0x2116},
{0xADE3, 0x33CD},
{0xADE4, 0x2121},
{0xADE5, 0x32A4},
{0xADE6, 0x32A5},
{0xADE7, 0x32A6},
{0xADE8, 0x32A7},
{0xADE9, 0x32A8},
{0xADEA, 0x3231},
{0xADEB, 0x3232},
{0xADEC, 0x3239},
{0xADED, 0x337E},
{0xADEE, 0x337D},
{0xADEF, 0x337C},
{0xADF0, 0x2252},
{0xADF1, 0x2261},
{0xADF2, 0x222B},
{0xADF3, 0x222E},
{0xADF4, 0x2211},
{0xADF5, 0x221A},
{0xADF6, 0x22A5},
{0xADF7, 0x2220},
{0xADF8, 0x221F},
{0xADF9, 0x22BF},
{0xADFA, 0x2235},
{0xADFB, 0x2229},
{0xADFC, 0x222A},
{0xB0A1,0x4E9C},
{0xB0A2,0x5516}, {0xB0A3,0x5A03}, {0xB0A4,0x963F}, {0xB0A5,0x54C0}, {0xB0A6,0x611B},
{0xB0A7,0x6328}, {0xB0A8,0x59F6}, {0xB0A9,0x9022}, {0xB0AA,0x8475}, {0xB0AB,0x831C},
{0xB0AC,0x7A50}, {0xB0AD,0x60AA}, {0xB0AE,0x63E1}, {0xB0AF,0x6E25}, {0xB0B0,0x65ED},
{0xB0B1,0x8466}, {0xB0B2,0x82A6}, {0xB0B3,0x9BF5}, {0xB0B4,0x6893}, {0xB0B5,0x5727},
{0xB0B6,0x65A1}, {0xB0B7,0x6271}, {0xB0B8,0x5B9B}, {0xB0B9,0x59D0}, {0xB0BA,0x867B},
{0xB0BB,0x98F4}, {0xB0BC,0x7D62}, {0xB0BD,0x7DBE}, {0xB0BE,0x9B8E}, {0xB0BF,0x6216},
{0xB0C0,0x7C9F}, {0xB0C1,0x88B7}, {0xB0C2,0x5B89}, {0xB0C3,0x5EB5}, {0xB0C4,0x6309},
{0xB0C5,0x6697}, {0xB0C6,0x6848}, {0xB0C7,0x95C7}, {0xB0C8,0x978D}, {0xB0C9,0x674F},
{0xB0CA,0x4EE5}, {0xB0CB,0x4F0A}, {0xB0CC,0x4F4D}, {0xB0CD,0x4F9D}, {0xB0CE,0x5049},
{0xB0CF,0x56F2}, {0xB0D0,0x5937}, {0xB0D1,0x59D4}, {0xB0D2,0x5A01}, {0xB0D3,0x5C09},
{0xB0D4,0x60DF}, {0xB0D5,0x610F}, {0xB0D6,0x6170}, {0xB0D7,0x6613}, {0xB0D8,0x6905},
{0xB0D9,0x70BA}, {0xB0DA,0x754F}, {0xB0DB,0x7570}, {0xB0DC,0x79FB}, {0xB0DD,0x7DAD},
{0xB0DE,0x7DEF}, {0xB0DF,0x80C3}, {0xB0E0,0x840E}, {0xB0E1,0x8863}, {0xB0E2,0x8B02},
{0xB0E3,0x9055}, {0xB0E4,0x907A}, {0xB0E5,0x533B}, {0xB0E6,0x4E95}, {0xB0E7,0x4EA5},
{0xB0E8,0x57DF}, {0xB0E9,0x80B2}, {0xB0EA,0x90C1}, {0xB0EB,0x78EF}, {0xB0EC,0x4E00},
{0xB0ED,0x58F1}, {0xB0EE,0x6EA2}, {0xB0EF,0x9038}, {0xB0F0,0x7A32}, {0xB0F1,0x8328},
{0xB0F2,0x828B}, {0xB0F3,0x9C2F}, {0xB0F4,0x5141}, {0xB0F5,0x5370}, {0xB0F6,0x54BD},
{0xB0F7,0x54E1}, {0xB0F8,0x56E0}, {0xB0F9,0x59FB}, {0xB0FA,0x5F15}, {0xB0FB,0x98F2},
{0xB0FC,0x6DEB}, {0xB0FD,0x80E4}, {0xB0FE,0x852D}, {0xB1A1,0x9662}, {0xB1A2,0x9670},
{0xB1A3,0x96A0}, {0xB1A4,0x97FB}, {0xB1A5,0x540B}, {0xB1A6,0x53F3}, {0xB1A7,0x5B87},
{0xB1A8,0x70CF}, {0xB1A9,0x7FBD}, {0xB1AA,0x8FC2}, {0xB1AB,0x96E8}, {0xB1AC,0x536F},
{0xB1AD,0x9D5C}, {0xB1AE,0x7ABA}, {0xB1AF,0x4E11}, {0xB1B0,0x7893}, {0xB1B1,0x81FC},
{0xB1B2,0x6E26}, {0xB1B3,0x5618}, {0xB1B4,0x5504}, {0xB1B5,0x6B1D}, {0xB1B6,0x851A},
{0xB1B7,0x9C3B}, {0xB1B8,0x59E5}, {0xB1B9,0x53A9}, {0xB1BA,0x6D66}, {0xB1BB,0x74DC},
{0xB1BC,0x958F}, {0xB1BD,0x5642}, {0xB1BE,0x4E91}, {0xB1BF,0x904B}, {0xB1C0,0x96F2},
{0xB1C1,0x834F}, {0xB1C2,0x990C}, {0xB1C3,0x53E1}, {0xB1C4,0x55B6}, {0xB1C5,0x5B30},
{0xB1C6,0x5F71}, {0xB1C7,0x6620}, {0xB1C8,0x66F3}, {0xB1C9,0x6804}, {0xB1CA,0x6C38},
{0xB1CB,0x6CF3}, {0xB1CC,0x6D29}, {0xB1CD,0x745B}, {0xB1CE,0x76C8}, {0xB1CF,0x7A4E},
{0xB1D0,0x9834}, {0xB1D1,0x82F1}, {0xB1D2,0x885B}, {0xB1D3,0x8A60}, {0xB1D4,0x92ED},
{0xB1D5,0x6DB2}, {0xB1D6,0x75AB}, {0xB1D7,0x76CA}, {0xB1D8,0x99C5}, {0xB1D9,0x60A6},
{0xB1DA,0x8B01}, {0xB1DB,0x8D8A}, {0xB1DC,0x95B2}, {0xB1DD,0x698E}, {0xB1DE,0x53AD},
{0xB1DF,0x5186}, {0xB1E0,0x5712}, {0xB1E1,0x5830}, {0xB1E2,0x5944}, {0xB1E3,0x5BB4},
{0xB1E4,0x5EF6}, {0xB1E5,0x6028}, {0xB1E6,0x63A9}, {0xB1E7,0x63F4}, {0xB1E8,0x6CBF},
{0xB1E9,0x6F14}, {0xB1EA,0x708E}, {0xB1EB,0x7114}, {0xB1EC,0x7159}, {0xB1ED,0x71D5},
{0xB1EE,0x733F}, {0xB1EF,0x7E01}, {0xB1F0,0x8276}, {0xB1F1,0x82D1}, {0xB1F2,0x8597},
{0xB1F3,0x9060}, {0xB1F4,0x925B}, {0xB1F5,0x9D1B}, {0xB1F6,0x5869}, {0xB1F7,0x65BC},
{0xB1F8,0x6C5A}, {0xB1F9,0x7525}, {0xB1FA,0x51F9}, {0xB1FB,0x592E}, {0xB1FC,0x5965},
{0xB1FD,0x5F80}, {0xB1FE,0x5FDC}, {0xB2A1,0x62BC}, {0xB2A2,0x65FA}, {0xB2A3,0x6A2A},
{0xB2A4,0x6B27}, {0xB2A5,0x6BB4}, {0xB2A6,0x738B}, {0xB2A7,0x7FC1}, {0xB2A8,0x8956},
{0xB2A9,0x9D2C}, {0xB2AA,0x9D0E}, {0xB2AB,0x9EC4}, {0xB2AC,0x5CA1}, {0xB2AD,0x6C96},
{0xB2AE,0x837B}, {0xB2AF,0x5104}, {0xB2B0,0x5C4B}, {0xB2B1,0x61B6}, {0xB2B2,0x81C6},
{0xB2B3,0x6876}, {0xB2B4,0x7261}, {0xB2B5,0x4E59}, {0xB2B6,0x4FFA}, {0xB2B7,0x5378},
{0xB2B8,0x6069}, {0xB2B9,0x6E29}, {0xB2BA,0x7A4F}, {0xB2BB,0x97F3}, {0xB2BC,0x4E0B},
{0xB2BD,0x5316}, {0xB2BE,0x4EEE}, {0xB2BF,0x4F55}, {0xB2C0,0x4F3D}, {0xB2C1,0x4FA1},
{0xB2C2,0x4F73}, {0xB2C3,0x52A0}, {0xB2C4,0x53EF}, {0xB2C5,0x5609}, {0xB2C6,0x590F},
{0xB2C7,0x5AC1}, {0xB2C8,0x5BB6}, {0xB2C9,0x5BE1}, {0xB2CA,0x79D1}, {0xB2CB,0x6687},
{0xB2CC,0x679C}, {0xB2CD,0x67B6}, {0xB2CE,0x6B4C}, {0xB2CF,0x6CB3}, {0xB2D0,0x706B},
{0xB2D1,0x73C2}, {0xB2D2,0x798D}, {0xB2D3,0x79BE}, {0xB2D4,0x7A3C}, {0xB2D5,0x7B87},
{0xB2D6,0x82B1}, {0xB2D7,0x82DB}, {0xB2D8,0x8304}, {0xB2D9,0x8377}, {0xB2DA,0x83EF},
{0xB2DB,0x83D3}, {0xB2DC,0x8766}, {0xB2DD,0x8AB2}, {0xB2DE,0x5629}, {0xB2DF,0x8CA8},
{0xB2E0,0x8FE6}, {0xB2E1,0x904E}, {0xB2E2,0x971E}, {0xB2E3,0x868A}, {0xB2E4,0x4FC4},
{0xB2E5,0x5CE8}, {0xB2E6,0x6211}, {0xB2E7,0x7259}, {0xB2E8,0x753B}, {0xB2E9,0x81E5},
{0xB2EA,0x82BD}, {0xB2EB,0x86FE}, {0xB2EC,0x8CC0}, {0xB2ED,0x96C5}, {0xB2EE,0x9913},
{0xB2EF,0x99D5}, {0xB2F0,0x4ECB}, {0xB2F1,0x4F1A}, {0xB2F2,0x89E3}, {0xB2F3,0x56DE},
{0xB2F4,0x584A}, {0xB2F5,0x58CA}, {0xB2F6,0x5EFB}, {0xB2F7,0x5FEB}, {0xB2F8,0x602A},
{0xB2F9,0x6094}, {0xB2FA,0x6062}, {0xB2FB,0x61D0}, {0xB2FC,0x6212}, {0xB2FD,0x62D0},
{0xB2FE,0x6539}, {0xB3A1,0x9B41}, {0xB3A2,0x6666}, {0xB3A3,0x68B0}, {0xB3A4,0x6D77},
{0xB3A5,0x7070}, {0xB3A6,0x754C}, {0xB3A7,0x7686}, {0xB3A8,0x7D75}, {0xB3A9,0x82A5},
{0xB3AA,0x87F9}, {0xB3AB,0x958B}, {0xB3AC,0x968E}, {0xB3AD,0x8C9D}, {0xB3AE,0x51F1},
{0xB3AF,0x52BE}, {0xB3B0,0x5916}, {0xB3B1,0x54B3}, {0xB3B2,0x5BB3}, {0xB3B3,0x5D16},
{0xB3B4,0x6168}, {0xB3B5,0x6982}, {0xB3B6,0x6DAF}, {0xB3B7,0x788D}, {0xB3B8,0x84CB},
{0xB3B9,0x8857}, {0xB3BA,0x8A72}, {0xB3BB,0x93A7}, {0xB3BC,0x9AB8}, {0xB3BD,0x6D6C},
{0xB3BE,0x99A8}, {0xB3BF,0x86D9}, {0xB3C0,0x57A3}, {0xB3C1,0x67FF}, {0xB3C2,0x86CE},
{0xB3C3,0x920E}, {0xB3C4,0x5283}, {0xB3C5,0x5687}, {0xB3C6,0x5404}, {0xB3C7,0x5ED3},
{0xB3C8,0x62E1}, {0xB3C9,0x64B9}, {0xB3CA,0x683C}, {0xB3CB,0x6838}, {0xB3CC,0x6BBB},
{0xB3CD,0x7372}, {0xB3CE,0x78BA}, {0xB3CF,0x7A6B}, {0xB3D0,0x899A}, {0xB3D1,0x89D2},
{0xB3D2,0x8D6B}, {0xB3D3,0x8F03}, {0xB3D4,0x90ED}, {0xB3D5,0x95A3}, {0xB3D6,0x9694},
{0xB3D7,0x9769}, {0xB3D8,0x5B66}, {0xB3D9,0x5CB3}, {0xB3DA,0x697D}, {0xB3DB,0x984D},
{0xB3DC,0x984E}, {0xB3DD,0x639B}, {0xB3DE,0x7B20}, {0xB3DF,0x6A2B}, {0xB3E0,0x6A7F},
{0xB3E1,0x68B6}, {0xB3E2,0x9C0D}, {0xB3E3,0x6F5F}, {0xB3E4,0x5272}, {0xB3E5,0x559D},
{0xB3E6,0x6070}, {0xB3E7,0x62EC}, {0xB3E8,0x6D3B}, {0xB3E9,0x6E07}, {0xB3EA,0x6ED1},
{0xB3EB,0x845B}, {0xB3EC,0x8910}, {0xB3ED,0x8F44}, {0xB3EE,0x4E14}, {0xB3EF,0x9C39},
{0xB3F0,0x53F6}, {0xB3F1,0x691B}, {0xB3F2,0x6A3A}, {0xB3F3,0x9784}, {0xB3F4,0x682A},
{0xB3F5,0x515C}, {0xB3F6,0x7AC3}, {0xB3F7,0x84B2}, {0xB3F8,0x91DC}, {0xB3F9,0x938C},
{0xB3FA,0x565B}, {0xB3FB,0x9D28}, {0xB3FC,0x6822}, {0xB3FD,0x8305}, {0xB3FE,0x8431},
{0xB4A1,0x7CA5}, {0xB4A2,0x5208}, {0xB4A3,0x82C5}, {0xB4A4,0x74E6}, {0xB4A5,0x4E7E},
{0xB4A6,0x4F83}, {0xB4A7,0x51A0}, {0xB4A8,0x5BD2}, {0xB4A9,0x520A}, {0xB4AA,0x52D8},
{0xB4AB,0x52E7}, {0xB4AC,0x5DFB}, {0xB4AD,0x559A}, {0xB4AE,0x582A}, {0xB4AF,0x59E6},
{0xB4B0,0x5B8C}, {0xB4B1,0x5B98}, {0xB4B2,0x5BDB}, {0xB4B3,0x5E72}, {0xB4B4,0x5E79},
{0xB4B5,0x60A3}, {0xB4B6,0x611F}, {0xB4B7,0x6163}, {0xB4B8,0x61BE}, {0xB4B9,0x63DB},
{0xB4BA,0x6562}, {0xB4BB,0x67D1}, {0xB4BC,0x6853}, {0xB4BD,0x68FA}, {0xB4BE,0x6B3E},
{0xB4BF,0x6B53}, {0xB4C0,0x6C57}, {0xB4C1,0x6F22}, {0xB4C2,0x6F97}, {0xB4C3,0x6F45},
{0xB4C4,0x74B0}, {0xB4C5,0x7518}, {0xB4C6,0x76E3}, {0xB4C7,0x770B}, {0xB4C8,0x7AFF},
{0xB4C9,0x7BA1}, {0xB4CA,0x7C21}, {0xB4CB,0x7DE9}, {0xB4CC,0x7F36}, {0xB4CD,0x7FF0},
{0xB4CE,0x809D}, {0xB4CF,0x8266}, {0xB4D0,0x839E}, {0xB4D1,0x89B3}, {0xB4D2,0x8ACC},
{0xB4D3,0x8CAB}, {0xB4D4,0x9084}, {0xB4D5,0x9451}, {0xB4D6,0x9593}, {0xB4D7,0x9591},
{0xB4D8,0x95A2}, {0xB4D9,0x9665}, {0xB4DA,0x97D3}, {0xB4DB,0x9928}, {0xB4DC,0x8218},
{0xB4DD,0x4E38}, {0xB4DE,0x542B}, {0xB4DF,0x5CB8}, {0xB4E0,0x5DCC}, {0xB4E1,0x73A9},
{0xB4E2,0x764C}, {0xB4E3,0x773C}, {0xB4E4,0x5CA9}, {0xB4E5,0x7FEB}, {0xB4E6,0x8D0B},
{0xB4E7,0x96C1}, {0xB4E8,0x9811}, {0xB4E9,0x9854}, {0xB4EA,0x9858}, {0xB4EB,0x4F01},
{0xB4EC,0x4F0E}, {0xB4ED,0x5371}, {0xB4EE,0x559C}, {0xB4EF,0x5668}, {0xB4F0,0x57FA},
{0xB4F1,0x5947}, {0xB4F2,0x5B09}, {0xB4F3,0x5BC4}, {0xB4F4,0x5C90}, {0xB4F5,0x5E0C},
{0xB4F6,0x5E7E}, {0xB4F7,0x5FCC}, {0xB4F8,0x63EE}, {0xB4F9,0x673A}, {0xB4FA,0x65D7},
{0xB4FB,0x65E2}, {0xB4FC,0x671F}, {0xB4FD,0x68CB}, {0xB4FE,0x68C4}, {0xB5A1,0x6A5F},
{0xB5A2,0x5E30}, {0xB5A3,0x6BC5}, {0xB5A4,0x6C17}, {0xB5A5,0x6C7D}, {0xB5A6,0x757F},
{0xB5A7,0x7948}, {0xB5A8,0x5B63}, {0xB5A9,0x7A00}, {0xB5AA,0x7D00}, {0xB5AB,0x5FBD},
{0xB5AC,0x898F}, {0xB5AD,0x8A18}, {0xB5AE,0x8CB4}, {0xB5AF,0x8D77}, {0xB5B0,0x8ECC},
{0xB5B1,0x8F1D}, {0xB5B2,0x98E2}, {0xB5B3,0x9A0E}, {0xB5B4,0x9B3C}, {0xB5B5,0x4E80},
{0xB5B6,0x507D}, {0xB5B7,0x5100}, {0xB5B8,0x5993}, {0xB5B9,0x5B9C}, {0xB5BA,0x622F},
{0xB5BB,0x6280}, {0xB5BC,0x64EC}, {0xB5BD,0x6B3A}, {0xB5BE,0x72A0}, {0xB5BF,0x7591},
{0xB5C0,0x7947}, {0xB5C1,0x7FA9}, {0xB5C2,0x87FB}, {0xB5C3,0x8ABC}, {0xB5C4,0x8B70},
{0xB5C5,0x63AC}, {0xB5C6,0x83CA}, {0xB5C7,0x97A0}, {0xB5C8,0x5409}, {0xB5C9,0x5403},
{0xB5CA,0x55AB}, {0xB5CB,0x6854}, {0xB5CC,0x6A58}, {0xB5CD,0x8A70}, {0xB5CE,0x7827},
{0xB5CF,0x6775}, {0xB5D0,0x9ECD}, {0xB5D1,0x5374}, {0xB5D2,0x5BA2}, {0xB5D3,0x811A},
{0xB5D4,0x8650}, {0xB5D5,0x9006}, {0xB5D6,0x4E18}, {0xB5D7,0x4E45}, {0xB5D8,0x4EC7},
{0xB5D9,0x4F11}, {0xB5DA,0x53CA}, {0xB5DB,0x5438}, {0xB5DC,0x5BAE}, {0xB5DD,0x5F13},
{0xB5DE,0x6025}, {0xB5DF,0x6551}, {0xB5E0,0x673D}, {0xB5E1,0x6C42}, {0xB5E2,0x6C72},
{0xB5E3,0x6CE3}, {0xB5E4,0x7078}, {0xB5E5,0x7403}, {0xB5E6,0x7A76}, {0xB5E7,0x7AAE},
{0xB5E8,0x7B08}, {0xB5E9,0x7D1A}, {0xB5EA,0x7CFE}, {0xB5EB,0x7D66}, {0xB5EC,0x65E7},
{0xB5ED,0x725B}, {0xB5EE,0x53BB}, {0xB5EF,0x5C45}, {0xB5F0,0x5DE8}, {0xB5F1,0x62D2},
{0xB5F2,0x62E0}, {0xB5F3,0x6319}, {0xB5F4,0x6E20}, {0xB5F5,0x865A}, {0xB5F6,0x8A31},
{0xB5F7,0x8DDD}, {0xB5F8,0x92F8}, {0xB5F9,0x6F01}, {0xB5FA,0x79A6}, {0xB5FB,0x9B5A},
{0xB5FC,0x4EA8}, {0xB5FD,0x4EAB}, {0xB5FE,0x4EAC}, {0xB6A1,0x4F9B}, {0xB6A2,0x4FA0},
{0xB6A3,0x50D1}, {0xB6A4,0x5147}, {0xB6A5,0x7AF6}, {0xB6A6,0x5171}, {0xB6A7,0x51F6},
{0xB6A8,0x5354}, {0xB6A9,0x5321}, {0xB6AA,0x537F}, {0xB6AB,0x53EB}, {0xB6AC,0x55AC},
{0xB6AD,0x5883}, {0xB6AE,0x5CE1}, {0xB6AF,0x5F37}, {0xB6B0,0x5F4A}, {0xB6B1,0x602F},
{0xB6B2,0x6050}, {0xB6B3,0x606D}, {0xB6B4,0x631F}, {0xB6B5,0x6559}, {0xB6B6,0x6A4B},
{0xB6B7,0x6CC1}, {0xB6B8,0x72C2}, {0xB6B9,0x72ED}, {0xB6BA,0x77EF}, {0xB6BB,0x80F8},
{0xB6BC,0x8105}, {0xB6BD,0x8208}, {0xB6BE,0x854E}, {0xB6BF,0x90F7}, {0xB6C0,0x93E1},
{0xB6C1,0x97FF}, {0xB6C2,0x9957}, {0xB6C3,0x9A5A}, {0xB6C4,0x4EF0}, {0xB6C5,0x51DD},
{0xB6C6,0x5C2D}, {0xB6C7,0x6681}, {0xB6C8,0x696D}, {0xB6C9,0x5C40}, {0xB6CA,0x66F2},
{0xB6CB,0x6975}, {0xB6CC,0x7389}, {0xB6CD,0x6850}, {0xB6CE,0x7C81}, {0xB6CF,0x50C5},
{0xB6D0,0x52E4}, {0xB6D1,0x5747}, {0xB6D2,0x5DFE}, {0xB6D3,0x9326}, {0xB6D4,0x65A4},
{0xB6D5,0x6B23}, {0xB6D6,0x6B3D}, {0xB6D7,0x7434}, {0xB6D8,0x7981}, {0xB6D9,0x79BD},
{0xB6DA,0x7B4B}, {0xB6DB,0x7DCA}, {0xB6DC,0x82B9}, {0xB6DD,0x83CC}, {0xB6DE,0x887F},
{0xB6DF,0x895F}, {0xB6E0,0x8B39}, {0xB6E1,0x8FD1}, {0xB6E2,0x91D1}, {0xB6E3,0x541F},
{0xB6E4,0x9280}, {0xB6E5,0x4E5D}, {0xB6E6,0x5036}, {0xB6E7,0x53E5}, {0xB6E8,0x533A},
{0xB6E9,0x72D7}, {0xB6EA,0x7396}, {0xB6EB,0x77E9}, {0xB6EC,0x82E6}, {0xB6ED,0x8EAF},
{0xB6EE,0x99C6}, {0xB6EF,0x99C8}, {0xB6F0,0x99D2}, {0xB6F1,0x5177}, {0xB6F2,0x611A},
{0xB6F3,0x865E}, {0xB6F4,0x55B0}, {0xB6F5,0x7A7A}, {0xB6F6,0x5076}, {0xB6F7,0x5BD3},
{0xB6F8,0x9047}, {0xB6F9,0x9685}, {0xB6FA,0x4E32}, {0xB6FB,0x6ADB}, {0xB6FC,0x91E7},
{0xB6FD,0x5C51}, {0xB6FE,0x5C48}, {0xB7A1,0x6398}, {0xB7A2,0x7A9F}, {0xB7A3,0x6C93},
{0xB7A4,0x9774}, {0xB7A5,0x8F61}, {0xB7A6,0x7AAA}, {0xB7A7,0x718A}, {0xB7A8,0x9688},
{0xB7A9,0x7C82}, {0xB7AA,0x6817}, {0xB7AB,0x7E70}, {0xB7AC,0x6851}, {0xB7AD,0x936C},
{0xB7AE,0x52F2}, {0xB7AF,0x541B}, {0xB7B0,0x85AB}, {0xB7B1,0x8A13}, {0xB7B2,0x7FA4},
{0xB7B3,0x8ECD}, {0xB7B4,0x90E1}, {0xB7B5,0x5366}, {0xB7B6,0x8888}, {0xB7B7,0x7941},
{0xB7B8,0x4FC2}, {0xB7B9,0x50BE}, {0xB7BA,0x5211}, {0xB7BB,0x5144}, {0xB7BC,0x5553},
{0xB7BD,0x572D}, {0xB7BE,0x73EA}, {0xB7BF,0x578B}, {0xB7C0,0x5951}, {0xB7C1,0x5F62},
{0xB7C2,0x5F84}, {0xB7C3,0x6075}, {0xB7C4,0x6176}, {0xB7C5,0x6167}, {0xB7C6,0x61A9},
{0xB7C7,0x63B2}, {0xB7C8,0x643A}, {0xB7C9,0x656C}, {0xB7CA,0x666F}, {0xB7CB,0x6842},
{0xB7CC,0x6E13}, {0xB7CD,0x7566}, {0xB7CE,0x7A3D}, {0xB7CF,0x7CFB}, {0xB7D0,0x7D4C},
{0xB7D1,0x7D99}, {0xB7D2,0x7E4B}, {0xB7D3,0x7F6B}, {0xB7D4,0x830E}, {0xB7D5,0x834A},
{0xB7D6,0x86CD}, {0xB7D7,0x8A08}, {0xB7D8,0x8A63}, {0xB7D9,0x8B66}, {0xB7DA,0x8EFD},
{0xB7DB,0x981A}, {0xB7DC,0x9D8F}, {0xB7DD,0x82B8}, {0xB7DE,0x8FCE}, {0xB7DF,0x9BE8},
{0xB7E0,0x5287}, {0xB7E1,0x621F}, {0xB7E2,0x6483}, {0xB7E3,0x6FC0}, {0xB7E4,0x9699},
{0xB7E5,0x6841}, {0xB7E6,0x5091}, {0xB7E7,0x6B20}, {0xB7E8,0x6C7A}, {0xB7E9,0x6F54},
{0xB7EA,0x7A74}, {0xB7EB,0x7D50}, {0xB7EC,0x8840}, {0xB7ED,0x8A23}, {0xB7EE,0x6708},
{0xB7EF,0x4EF6}, {0xB7F0,0x5039}, {0xB7F1,0x5026}, {0xB7F2,0x5065}, {0xB7F3,0x517C},
{0xB7F4,0x5238}, {0xB7F5,0x5263}, {0xB7F6,0x55A7}, {0xB7F7,0x570F}, {0xB7F8,0x5805},
{0xB7F9,0x5ACC}, {0xB7FA,0x5EFA}, {0xB7FB,0x61B2}, {0xB7FC,0x61F8}, {0xB7FD,0x62F3},
{0xB7FE,0x6372}, {0xB8A1,0x691C}, {0xB8A2,0x6A29}, {0xB8A3,0x727D}, {0xB8A4,0x72AC},
{0xB8A5,0x732E}, {0xB8A6,0x7814}, {0xB8A7,0x786F}, {0xB8A8,0x7D79}, {0xB8A9,0x770C},
{0xB8AA,0x80A9}, {0xB8AB,0x898B}, {0xB8AC,0x8B19}, {0xB8AD,0x8CE2}, {0xB8AE,0x8ED2},
{0xB8AF,0x9063}, {0xB8B0,0x9375}, {0xB8B1,0x967A}, {0xB8B2,0x9855}, {0xB8B3,0x9A13},
{0xB8B4,0x9E78}, {0xB8B5,0x5143}, {0xB8B6,0x539F}, {0xB8B7,0x53B3}, {0xB8B8,0x5E7B},
{0xB8B9,0x5F26}, {0xB8BA,0x6E1B}, {0xB8BB,0x6E90}, {0xB8BC,0x7384}, {0xB8BD,0x73FE},
{0xB8BE,0x7D43}, {0xB8BF,0x8237}, {0xB8C0,0x8A00}, {0xB8C1,0x8AFA}, {0xB8C2,0x9650},
{0xB8C3,0x4E4E}, {0xB8C4,0x500B}, {0xB8C5,0x53E4}, {0xB8C6,0x547C}, {0xB8C7,0x56FA},
{0xB8C8,0x59D1}, {0xB8C9,0x5B64}, {0xB8CA,0x5DF1}, {0xB8CB,0x5EAB}, {0xB8CC,0x5F27},
{0xB8CD,0x6238}, {0xB8CE,0x6545}, {0xB8CF,0x67AF}, {0xB8D0,0x6E56}, {0xB8D1,0x72D0},
{0xB8D2,0x7CCA}, {0xB8D3,0x88B4}, {0xB8D4,0x80A1}, {0xB8D5,0x80E1}, {0xB8D6,0x83F0},
{0xB8D7,0x864E}, {0xB8D8,0x8A87}, {0xB8D9,0x8DE8}, {0xB8DA,0x9237}, {0xB8DB,0x96C7},
{0xB8DC,0x9867}, {0xB8DD,0x9F13}, {0xB8DE,0x4E94}, {0xB8DF,0x4E92}, {0xB8E0,0x4F0D},
{0xB8E1,0x5348}, {0xB8E2,0x5449}, {0xB8E3,0x543E}, {0xB8E4,0x5A2F}, {0xB8E5,0x5F8C},
{0xB8E6,0x5FA1}, {0xB8E7,0x609F}, {0xB8E8,0x68A7}, {0xB8E9,0x6A8E}, {0xB8EA,0x745A},
{0xB8EB,0x7881}, {0xB8EC,0x8A9E}, {0xB8ED,0x8AA4}, {0xB8EE,0x8B77}, {0xB8EF,0x9190},
{0xB8F0,0x4E5E}, {0xB8F1,0x9BC9}, {0xB8F2,0x4EA4}, {0xB8F3,0x4F7C}, {0xB8F4,0x4FAF},
{0xB8F5,0x5019}, {0xB8F6,0x5016}, {0xB8F7,0x5149}, {0xB8F8,0x516C}, {0xB8F9,0x529F},
{0xB8FA,0x52B9}, {0xB8FB,0x52FE}, {0xB8FC,0x539A}, {0xB8FD,0x53E3}, {0xB8FE,0x5411},
{0xB9A1,0x540E}, {0xB9A2,0x5589}, {0xB9A3,0x5751}, {0xB9A4,0x57A2}, {0xB9A5,0x597D},
{0xB9A6,0x5B54}, {0xB9A7,0x5B5D}, {0xB9A8,0x5B8F}, {0xB9A9,0x5DE5}, {0xB9AA,0x5DE7},
{0xB9AB,0x5DF7}, {0xB9AC,0x5E78}, {0xB9AD,0x5E83}, {0xB9AE,0x5E9A}, {0xB9AF,0x5EB7},
{0xB9B0,0x5F18}, {0xB9B1,0x6052}, {0xB9B2,0x614C}, {0xB9B3,0x6297}, {0xB9B4,0x62D8},
{0xB9B5,0x63A7}, {0xB9B6,0x653B}, {0xB9B7,0x6602}, {0xB9B8,0x6643}, {0xB9B9,0x66F4},
{0xB9BA,0x676D}, {0xB9BB,0x6821}, {0xB9BC,0x6897}, {0xB9BD,0x69CB}, {0xB9BE,0x6C5F},
{0xB9BF,0x6D2A}, {0xB9C0,0x6D69}, {0xB9C1,0x6E2F}, {0xB9C2,0x6E9D}, {0xB9C3,0x7532},
{0xB9C4,0x7687}, {0xB9C5,0x786C}, {0xB9C6,0x7A3F}, {0xB9C7,0x7CE0}, {0xB9C8,0x7D05},
{0xB9C9,0x7D18}, {0xB9CA,0x7D5E}, {0xB9CB,0x7DB1}, {0xB9CC,0x8015}, {0xB9CD,0x8003},
{0xB9CE,0x80AF}, {0xB9CF,0x80B1}, {0xB9D0,0x8154}, {0xB9D1,0x818F}, {0xB9D2,0x822A},
{0xB9D3,0x8352}, {0xB9D4,0x884C}, {0xB9D5,0x8861}, {0xB9D6,0x8B1B}, {0xB9D7,0x8CA2},
{0xB9D8,0x8CFC}, {0xB9D9,0x90CA}, {0xB9DA,0x9175}, {0xB9DB,0x9271}, {0xB9DC,0x783F},
{0xB9DD,0x92FC}, {0xB9DE,0x95A4}, {0xB9DF,0x964D}, {0xB9E0,0x9805}, {0xB9E1,0x9999},
{0xB9E2,0x9AD8}, {0xB9E3,0x9D3B}, {0xB9E4,0x525B}, {0xB9E5,0x52AB}, {0xB9E6,0x53F7},
{0xB9E7,0x5408}, {0xB9E8,0x58D5}, {0xB9E9,0x62F7}, {0xB9EA,0x6FE0}, {0xB9EB,0x8C6A},
{0xB9EC,0x8F5F}, {0xB9ED,0x9EB9}, {0xB9EE,0x514B}, {0xB9EF,0x523B}, {0xB9F0,0x544A},
{0xB9F1,0x56FD}, {0xB9F2,0x7A40}, {0xB9F3,0x9177}, {0xB9F4,0x9D60}, {0xB9F5,0x9ED2},
{0xB9F6,0x7344}, {0xB9F7,0x6F09}, {0xB9F8,0x8170}, {0xB9F9,0x7511}, {0xB9FA,0x5FFD},
{0xB9FB,0x60DA}, {0xB9FC,0x9AA8}, {0xB9FD,0x72DB}, {0xB9FE,0x8FBC}, {0xBAA1,0x6B64},
{0xBAA2,0x9803}, {0xBAA3,0x4ECA}, {0xBAA4,0x56F0}, {0xBAA5,0x5764}, {0xBAA6,0x58BE},
{0xBAA7,0x5A5A}, {0xBAA8,0x6068}, {0xBAA9,0x61C7}, {0xBAAA,0x660F}, {0xBAAB,0x6606},
{0xBAAC,0x6839}, {0xBAAD,0x68B1}, {0xBAAE,0x6DF7}, {0xBAAF,0x75D5}, {0xBAB0,0x7D3A},
{0xBAB1,0x826E}, {0xBAB2,0x9B42}, {0xBAB3,0x4E9B}, {0xBAB4,0x4F50}, {0xBAB5,0x53C9},
{0xBAB6,0x5506}, {0xBAB7,0x5D6F}, {0xBAB8,0x5DE6}, {0xBAB9,0x5DEE}, {0xBABA,0x67FB},
{0xBABB,0x6C99}, {0xBABC,0x7473}, {0xBABD,0x7802}, {0xBABE,0x8A50}, {0xBABF,0x9396},
{0xBAC0,0x88DF}, {0xBAC1,0x5750}, {0xBAC2,0x5EA7}, {0xBAC3,0x632B}, {0xBAC4,0x50B5},
{0xBAC5,0x50AC}, {0xBAC6,0x518D}, {0xBAC7,0x6700}, {0xBAC8,0x54C9}, {0xBAC9,0x585E},
{0xBACA,0x59BB}, {0xBACB,0x5BB0}, {0xBACC,0x5F69}, {0xBACD,0x624D}, {0xBACE,0x63A1},
{0xBACF,0x683D}, {0xBAD0,0x6B73}, {0xBAD1,0x6E08}, {0xBAD2,0x707D}, {0xBAD3,0x91C7},
{0xBAD4,0x7280}, {0xBAD5,0x7815}, {0xBAD6,0x7826}, {0xBAD7,0x796D}, {0xBAD8,0x658E},
{0xBAD9,0x7D30}, {0xBADA,0x83DC}, {0xBADB,0x88C1}, {0xBADC,0x8F09}, {0xBADD,0x969B},
{0xBADE,0x5264}, {0xBADF,0x5728}, {0xBAE0,0x6750}, {0xBAE1,0x7F6A}, {0xBAE2,0x8CA1},
{0xBAE3,0x51B4}, {0xBAE4,0x5742}, {0xBAE5,0x962A}, {0xBAE6,0x583A}, {0xBAE7,0x698A},
{0xBAE8,0x80B4}, {0xBAE9,0x54B2}, {0xBAEA,0x5D0E}, {0xBAEB,0x57FC}, {0xBAEC,0x7895},
{0xBAED,0x9DFA}, {0xBAEE,0x4F5C}, {0xBAEF,0x524A}, {0xBAF0,0x548B}, {0xBAF1,0x643E},
{0xBAF2,0x6628}, {0xBAF3,0x6714}, {0xBAF4,0x67F5}, {0xBAF5,0x7A84}, {0xBAF6,0x7B56},
{0xBAF7,0x7D22}, {0xBAF8,0x932F}, {0xBAF9,0x685C}, {0xBAFA,0x9BAD}, {0xBAFB,0x7B39},
{0xBAFC,0x5319}, {0xBAFD,0x518A}, {0xBAFE,0x5237}, {0xBBA1,0x5BDF}, {0xBBA2,0x62F6},
{0xBBA3,0x64AE}, {0xBBA4,0x64E6}, {0xBBA5,0x672D}, {0xBBA6,0x6BBA}, {0xBBA7,0x85A9},
{0xBBA8,0x96D1}, {0xBBA9,0x7690}, {0xBBAA,0x9BD6}, {0xBBAB,0x634C}, {0xBBAC,0x9306},
{0xBBAD,0x9BAB}, {0xBBAE,0x76BF}, {0xBBAF,0x6652}, {0xBBB0,0x4E09}, {0xBBB1,0x5098},
{0xBBB2,0x53C2}, {0xBBB3,0x5C71}, {0xBBB4,0x60E8}, {0xBBB5,0x6492}, {0xBBB6,0x6563},
{0xBBB7,0x685F}, {0xBBB8,0x71E6}, {0xBBB9,0x73CA}, {0xBBBA,0x7523}, {0xBBBB,0x7B97},
{0xBBBC,0x7E82}, {0xBBBD,0x8695}, {0xBBBE,0x8B83}, {0xBBBF,0x8CDB}, {0xBBC0,0x9178},
{0xBBC1,0x9910}, {0xBBC2,0x65AC}, {0xBBC3,0x66AB}, {0xBBC4,0x6B8B}, {0xBBC5,0x4ED5},
{0xBBC6,0x4ED4}, {0xBBC7,0x4F3A}, {0xBBC8,0x4F7F}, {0xBBC9,0x523A}, {0xBBCA,0x53F8},
{0xBBCB,0x53F2}, {0xBBCC,0x55E3}, {0xBBCD,0x56DB}, {0xBBCE,0x58EB}, {0xBBCF,0x59CB},
{0xBBD0,0x59C9}, {0xBBD1,0x59FF}, {0xBBD2,0x5B50}, {0xBBD3,0x5C4D}, {0xBBD4,0x5E02},
{0xBBD5,0x5E2B}, {0xBBD6,0x5FD7}, {0xBBD7,0x601D}, {0xBBD8,0x6307}, {0xBBD9,0x652F},
{0xBBDA,0x5B5C}, {0xBBDB,0x65AF}, {0xBBDC,0x65BD}, {0xBBDD,0x65E8}, {0xBBDE,0x679D},
{0xBBDF,0x6B62}, {0xBBE0,0x6B7B}, {0xBBE1,0x6C0F}, {0xBBE2,0x7345}, {0xBBE3,0x7949},
{0xBBE4,0x79C1}, {0xBBE5,0x7CF8}, {0xBBE6,0x7D19}, {0xBBE7,0x7D2B}, {0xBBE8,0x80A2},
{0xBBE9,0x8102}, {0xBBEA,0x81F3}, {0xBBEB,0x8996}, {0xBBEC,0x8A5E}, {0xBBED,0x8A69},
{0xBBEE,0x8A66}, {0xBBEF,0x8A8C}, {0xBBF0,0x8AEE}, {0xBBF1,0x8CC7}, {0xBBF2,0x8CDC},
{0xBBF3,0x96CC}, {0xBBF4,0x98FC}, {0xBBF5,0x6B6F}, {0xBBF6,0x4E8B}, {0xBBF7,0x4F3C},
{0xBBF8,0x4F8D}, {0xBBF9,0x5150}, {0xBBFA,0x5B57}, {0xBBFB,0x5BFA}, {0xBBFC,0x6148},
{0xBBFD,0x6301}, {0xBBFE,0x6642}, {0xBCA1,0x6B21}, {0xBCA2,0x6ECB}, {0xBCA3,0x6CBB},
{0xBCA4,0x723E}, {0xBCA5,0x74BD}, {0xBCA6,0x75D4}, {0xBCA7,0x78C1}, {0xBCA8,0x793A},
{0xBCA9,0x800C}, {0xBCAA,0x8033}, {0xBCAB,0x81EA}, {0xBCAC,0x8494}, {0xBCAD,0x8F9E},
{0xBCAE,0x6C50}, {0xBCAF,0x9E7F}, {0xBCB0,0x5F0F}, {0xBCB1,0x8B58}, {0xBCB2,0x9D2B},
{0xBCB3,0x7AFA}, {0xBCB4,0x8EF8}, {0xBCB5,0x5B8D}, {0xBCB6,0x96EB}, {0xBCB7,0x4E03},
{0xBCB8,0x53F1}, {0xBCB9,0x57F7}, {0xBCBA,0x5931}, {0xBCBB,0x5AC9}, {0xBCBC,0x5BA4},
{0xBCBD,0x6089}, {0xBCBE,0x6E7F}, {0xBCBF,0x6F06}, {0xBCC0,0x75BE}, {0xBCC1,0x8CEA},
{0xBCC2,0x5B9F}, {0xBCC3,0x8500}, {0xBCC4,0x7BE0}, {0xBCC5,0x5072}, {0xBCC6,0x67F4},
{0xBCC7,0x829D}, {0xBCC8,0x5C61}, {0xBCC9,0x854A}, {0xBCCA,0x7E1E}, {0xBCCB,0x820E},
{0xBCCC,0x5199}, {0xBCCD,0x5C04}, {0xBCCE,0x6368}, {0xBCCF,0x8D66}, {0xBCD0,0x659C},
{0xBCD1,0x716E}, {0xBCD2,0x793E}, {0xBCD3,0x7D17}, {0xBCD4,0x8005}, {0xBCD5,0x8B1D},
{0xBCD6,0x8ECA}, {0xBCD7,0x906E}, {0xBCD8,0x86C7}, {0xBCD9,0x90AA}, {0xBCDA,0x501F},
{0xBCDB,0x52FA}, {0xBCDC,0x5C3A}, {0xBCDD,0x6753}, {0xBCDE,0x707C}, {0xBCDF,0x7235},
{0xBCE0,0x914C}, {0xBCE1,0x91C8}, {0xBCE2,0x932B}, {0xBCE3,0x82E5}, {0xBCE4,0x5BC2},
{0xBCE5,0x5F31}, {0xBCE6,0x60F9}, {0xBCE7,0x4E3B}, {0xBCE8,0x53D6}, {0xBCE9,0x5B88},
{0xBCEA,0x624B}, {0xBCEB,0x6731}, {0xBCEC,0x6B8A}, {0xBCED,0x72E9}, {0xBCEE,0x73E0},
{0xBCEF,0x7A2E}, {0xBCF0,0x816B}, {0xBCF1,0x8DA3}, {0xBCF2,0x9152}, {0xBCF3,0x9996},
{0xBCF4,0x5112}, {0xBCF5,0x53D7}, {0xBCF6,0x546A}, {0xBCF7,0x5BFF}, {0xBCF8,0x6388},
{0xBCF9,0x6A39}, {0xBCFA,0x7DAC}, {0xBCFB,0x9700}, {0xBCFC,0x56DA}, {0xBCFD,0x53CE},
{0xBCFE,0x5468}, {0xBDA1,0x5B97}, {0xBDA2,0x5C31}, {0xBDA3,0x5DDE}, {0xBDA4,0x4FEE},
{0xBDA5,0x6101}, {0xBDA6,0x62FE}, {0xBDA7,0x6D32}, {0xBDA8,0x79C0}, {0xBDA9,0x79CB},
{0xBDAA,0x7D42}, {0xBDAB,0x7E4D}, {0xBDAC,0x7FD2}, {0xBDAD,0x81ED}, {0xBDAE,0x821F},
{0xBDAF,0x8490}, {0xBDB0,0x8846}, {0xBDB1,0x8972}, {0xBDB2,0x8B90}, {0xBDB3,0x8E74},
{0xBDB4,0x8F2F}, {0xBDB5,0x9031}, {0xBDB6,0x914B}, {0xBDB7,0x916C}, {0xBDB8,0x96C6},
{0xBDB9,0x919C}, {0xBDBA,0x4EC0}, {0xBDBB,0x4F4F}, {0xBDBC,0x5145}, {0xBDBD,0x5341},
{0xBDBE,0x5F93}, {0xBDBF,0x620E}, {0xBDC0,0x67D4}, {0xBDC1,0x6C41}, {0xBDC2,0x6E0B},
{0xBDC3,0x7363}, {0xBDC4,0x7E26}, {0xBDC5,0x91CD}, {0xBDC6,0x9283}, {0xBDC7,0x53D4},
{0xBDC8,0x5919}, {0xBDC9,0x5BBF}, {0xBDCA,0x6DD1}, {0xBDCB,0x795D}, {0xBDCC,0x7E2E},
{0xBDCD,0x7C9B}, {0xBDCE,0x587E}, {0xBDCF,0x719F}, {0xBDD0,0x51FA}, {0xBDD1,0x8853},
{0xBDD2,0x8FF0}, {0xBDD3,0x4FCA}, {0xBDD4,0x5CFB}, {0xBDD5,0x6625}, {0xBDD6,0x77AC},
{0xBDD7,0x7AE3}, {0xBDD8,0x821C}, {0xBDD9,0x99FF}, {0xBDDA,0x51C6}, {0xBDDB,0x5FAA},
{0xBDDC,0x65EC}, {0xBDDD,0x696F}, {0xBDDE,0x6B89}, {0xBDDF,0x6DF3}, {0xBDE0,0x6E96},
{0xBDE1,0x6F64}, {0xBDE2,0x76FE}, {0xBDE3,0x7D14}, {0xBDE4,0x5DE1}, {0xBDE5,0x9075},
{0xBDE6,0x9187}, {0xBDE7,0x9806}, {0xBDE8,0x51E6}, {0xBDE9,0x521D}, {0xBDEA,0x6240},
{0xBDEB,0x6691}, {0xBDEC,0x66D9}, {0xBDED,0x6E1A}, {0xBDEE,0x5EB6}, {0xBDEF,0x7DD2},
{0xBDF0,0x7F72}, {0xBDF1,0x66F8}, {0xBDF2,0x85AF}, {0xBDF3,0x85F7}, {0xBDF4,0x8AF8},
{0xBDF5,0x52A9}, {0xBDF6,0x53D9}, {0xBDF7,0x5973}, {0xBDF8,0x5E8F}, {0xBDF9,0x5F90},
{0xBDFA,0x6055}, {0xBDFB,0x92E4}, {0xBDFC,0x9664}, {0xBDFD,0x50B7}, {0xBDFE,0x511F},
{0xBEA1,0x52DD}, {0xBEA2,0x5320}, {0xBEA3,0x5347}, {0xBEA4,0x53EC}, {0xBEA5,0x54E8},
{0xBEA6,0x5546}, {0xBEA7,0x5531}, {0xBEA8,0x5617}, {0xBEA9,0x5968}, {0xBEAA,0x59BE},
{0xBEAB,0x5A3C}, {0xBEAC,0x5BB5}, {0xBEAD,0x5C06}, {0xBEAE,0x5C0F}, {0xBEAF,0x5C11},
{0xBEB0,0x5C1A}, {0xBEB1,0x5E84}, {0xBEB2,0x5E8A}, {0xBEB3,0x5EE0}, {0xBEB4,0x5F70},
{0xBEB5,0x627F}, {0xBEB6,0x6284}, {0xBEB7,0x62DB}, {0xBEB8,0x638C}, {0xBEB9,0x6377},
{0xBEBA,0x6607}, {0xBEBB,0x660C}, {0xBEBC,0x662D}, {0xBEBD,0x6676}, {0xBEBE,0x677E},
{0xBEBF,0x68A2}, {0xBEC0,0x6A1F}, {0xBEC1,0x6A35}, {0xBEC2,0x6CBC}, {0xBEC3,0x6D88},
{0xBEC4,0x6E09}, {0xBEC5,0x6E58}, {0xBEC6,0x713C}, {0xBEC7,0x7126}, {0xBEC8,0x7167},
{0xBEC9,0x75C7}, {0xBECA,0x7701}, {0xBECB,0x785D}, {0xBECC,0x7901}, {0xBECD,0x7965},
{0xBECE,0x79F0}, {0xBECF,0x7AE0}, {0xBED0,0x7B11}, {0xBED1,0x7CA7}, {0xBED2,0x7D39},
{0xBED3,0x8096}, {0xBED4,0x83D6}, {0xBED5,0x848B}, {0xBED6,0x8549}, {0xBED7,0x885D},
{0xBED8,0x88F3}, {0xBED9,0x8A1F}, {0xBEDA,0x8A3C}, {0xBEDB,0x8A54}, {0xBEDC,0x8A73},
{0xBEDD,0x8C61}, {0xBEDE,0x8CDE}, {0xBEDF,0x91A4}, {0xBEE0,0x9266}, {0xBEE1,0x937E},
{0xBEE2,0x9418}, {0xBEE3,0x969C}, {0xBEE4,0x9798}, {0xBEE5,0x4E0A}, {0xBEE6,0x4E08},
{0xBEE7,0x4E1E}, {0xBEE8,0x4E57}, {0xBEE9,0x5197}, {0xBEEA,0x5270}, {0xBEEB,0x57CE},
{0xBEEC,0x5834}, {0xBEED,0x58CC}, {0xBEEE,0x5B22}, {0xBEEF,0x5E38}, {0xBEF0,0x60C5},
{0xBEF1,0x64FE}, {0xBEF2,0x6761}, {0xBEF3,0x6756}, {0xBEF4,0x6D44}, {0xBEF5,0x72B6},
{0xBEF6,0x7573}, {0xBEF7,0x7A63}, {0xBEF8,0x84B8}, {0xBEF9,0x8B72}, {0xBEFA,0x91B8},
{0xBEFB,0x9320}, {0xBEFC,0x5631}, {0xBEFD,0x57F4}, {0xBEFE,0x98FE}, {0xBFA1,0x62ED},
{0xBFA2,0x690D}, {0xBFA3,0x6B96}, {0xBFA4,0x71ED}, {0xBFA5,0x7E54}, {0xBFA6,0x8077},
{0xBFA7,0x8272}, {0xBFA8,0x89E6}, {0xBFA9,0x98DF}, {0xBFAA,0x8755}, {0xBFAB,0x8FB1},
{0xBFAC,0x5C3B}, {0xBFAD,0x4F38}, {0xBFAE,0x4FE1}, {0xBFAF,0x4FB5}, {0xBFB0,0x5507},
{0xBFB1,0x5A20}, {0xBFB2,0x5BDD}, {0xBFB3,0x5BE9}, {0xBFB4,0x5FC3}, {0xBFB5,0x614E},
{0xBFB6,0x632F}, {0xBFB7,0x65B0}, {0xBFB8,0x664B}, {0xBFB9,0x68EE}, {0xBFBA,0x699B},
{0xBFBB,0x6D78}, {0xBFBC,0x6DF1}, {0xBFBD,0x7533}, {0xBFBE,0x75B9}, {0xBFBF,0x771F},
{0xBFC0,0x795E}, {0xBFC1,0x79E6}, {0xBFC2,0x7D33}, {0xBFC3,0x81E3}, {0xBFC4,0x82AF},
{0xBFC5,0x85AA}, {0xBFC6,0x89AA}, {0xBFC7,0x8A3A}, {0xBFC8,0x8EAB}, {0xBFC9,0x8F9B},
{0xBFCA,0x9032}, {0xBFCB,0x91DD}, {0xBFCC,0x9707}, {0xBFCD,0x4EBA}, {0xBFCE,0x4EC1},
{0xBFCF,0x5203}, {0xBFD0,0x5875}, {0xBFD1,0x58EC}, {0xBFD2,0x5C0B}, {0xBFD3,0x751A},
{0xBFD4,0x5C3D}, {0xBFD5,0x814E}, {0xBFD6,0x8A0A}, {0xBFD7,0x8FC5}, {0xBFD8,0x9663},
{0xBFD9,0x976D}, {0xBFDA,0x7B25}, {0xBFDB,0x8ACF}, {0xBFDC,0x9808}, {0xBFDD,0x9162},
{0xBFDE,0x56F3}, {0xBFDF,0x53A8}, {0xBFE0,0x9017}, {0xBFE1,0x5439}, {0xBFE2,0x5782},
{0xBFE3,0x5E25}, {0xBFE4,0x63A8}, {0xBFE5,0x6C34}, {0xBFE6,0x708A}, {0xBFE7,0x7761},
{0xBFE8,0x7C8B}, {0xBFE9,0x7FE0}, {0xBFEA,0x8870}, {0xBFEB,0x9042}, {0xBFEC,0x9154},
{0xBFED,0x9310}, {0xBFEE,0x9318}, {0xBFEF,0x968F}, {0xBFF0,0x745E}, {0xBFF1,0x9AC4},
{0xBFF2,0x5D07}, {0xBFF3,0x5D69}, {0xBFF4,0x6570}, {0xBFF5,0x67A2}, {0xBFF6,0x8DA8},
{0xBFF7,0x96DB}, {0xBFF8,0x636E}, {0xBFF9,0x6749}, {0xBFFA,0x6919}, {0xBFFB,0x83C5},
{0xBFFC,0x9817}, {0xBFFD,0x96C0}, {0xBFFE,0x88FE}, {0xC0A1,0x6F84}, {0xC0A2,0x647A},
{0xC0A3,0x5BF8}, {0xC0A4,0x4E16}, {0xC0A5,0x702C}, {0xC0A6,0x755D}, {0xC0A7,0x662F},
{0xC0A8,0x51C4}, {0xC0A9,0x5236}, {0xC0AA,0x52E2}, {0xC0AB,0x59D3}, {0xC0AC,0x5F81},
{0xC0AD,0x6027}, {0xC0AE,0x6210}, {0xC0AF,0x653F}, {0xC0B0,0x6574}, {0xC0B1,0x661F},
{0xC0B2,0x6674}, {0xC0B3,0x68F2}, {0xC0B4,0x6816}, {0xC0B5,0x6B63}, {0xC0B6,0x6E05},
{0xC0B7,0x7272}, {0xC0B8,0x751F}, {0xC0B9,0x76DB}, {0xC0BA,0x7CBE}, {0xC0BB,0x8056},
{0xC0BC,0x58F0}, {0xC0BD,0x88FD}, {0xC0BE,0x897F}, {0xC0BF,0x8AA0}, {0xC0C0,0x8A93},
{0xC0C1,0x8ACB}, {0xC0C2,0x901D}, {0xC0C3,0x9192}, {0xC0C4,0x9752}, {0xC0C5,0x9759},
{0xC0C6,0x6589}, {0xC0C7,0x7A0E}, {0xC0C8,0x8106}, {0xC0C9,0x96BB}, {0xC0CA,0x5E2D},
{0xC0CB,0x60DC}, {0xC0CC,0x621A}, {0xC0CD,0x65A5}, {0xC0CE,0x6614}, {0xC0CF,0x6790},
{0xC0D0,0x77F3}, {0xC0D1,0x7A4D}, {0xC0D2,0x7C4D}, {0xC0D3,0x7E3E}, {0xC0D4,0x810A},
{0xC0D5,0x8CAC}, {0xC0D6,0x8D64}, {0xC0D7,0x8DE1}, {0xC0D8,0x8E5F}, {0xC0D9,0x78A9},
{0xC0DA,0x5207}, {0xC0DB,0x62D9}, {0xC0DC,0x63A5}, {0xC0DD,0x6442}, {0xC0DE,0x6298},
{0xC0DF,0x8A2D}, {0xC0E0,0x7A83}, {0xC0E1,0x7BC0}, {0xC0E2,0x8AAC}, {0xC0E3,0x96EA},
{0xC0E4,0x7D76}, {0xC0E5,0x820C}, {0xC0E6,0x8749}, {0xC0E7,0x4ED9}, {0xC0E8,0x5148},
{0xC0E9,0x5343}, {0xC0EA,0x5360}, {0xC0EB,0x5BA3}, {0xC0EC,0x5C02}, {0xC0ED,0x5C16},
{0xC0EE,0x5DDD}, {0xC0EF,0x6226}, {0xC0F0,0x6247}, {0xC0F1,0x64B0}, {0xC0F2,0x6813},
{0xC0F3,0x6834}, {0xC0F4,0x6CC9}, {0xC0F5,0x6D45}, {0xC0F6,0x6D17}, {0xC0F7,0x67D3},
{0xC0F8,0x6F5C}, {0xC0F9,0x714E}, {0xC0FA,0x717D}, {0xC0FB,0x65CB}, {0xC0FC,0x7A7F},
{0xC0FD,0x7BAD}, {0xC0FE,0x7DDA}, {0xC1A1,0x7E4A}, {0xC1A2,0x7FA8}, {0xC1A3,0x817A},
{0xC1A4,0x821B}, {0xC1A5,0x8239}, {0xC1A6,0x85A6}, {0xC1A7,0x8A6E}, {0xC1A8,0x8CCE},
{0xC1A9,0x8DF5}, {0xC1AA,0x9078}, {0xC1AB,0x9077}, {0xC1AC,0x92AD}, {0xC1AD,0x9291},
{0xC1AE,0x9583}, {0xC1AF,0x9BAE}, {0xC1B0,0x524D}, {0xC1B1,0x5584}, {0xC1B2,0x6F38},
{0xC1B3,0x7136}, {0xC1B4,0x5168}, {0xC1B5,0x7985}, {0xC1B6,0x7E55}, {0xC1B7,0x81B3},
{0xC1B8,0x7CCE}, {0xC1B9,0x564C}, {0xC1BA,0x5851}, {0xC1BB,0x5CA8}, {0xC1BC,0x63AA},
{0xC1BD,0x66FE}, {0xC1BE,0x66FD}, {0xC1BF,0x695A}, {0xC1C0,0x72D9}, {0xC1C1,0x758F},
{0xC1C2,0x758E}, {0xC1C3,0x790E}, {0xC1C4,0x7956}, {0xC1C5,0x79DF}, {0xC1C6,0x7C97},
{0xC1C7,0x7D20}, {0xC1C8,0x7D44}, {0xC1C9,0x8607}, {0xC1CA,0x8A34}, {0xC1CB,0x963B},
{0xC1CC,0x9061}, {0xC1CD,0x9F20}, {0xC1CE,0x50E7}, {0xC1CF,0x5275}, {0xC1D0,0x53CC},
{0xC1D1,0x53E2}, {0xC1D2,0x5009}, {0xC1D3,0x55AA}, {0xC1D4,0x58EE}, {0xC1D5,0x594F},
{0xC1D6,0x723D}, {0xC1D7,0x5B8B}, {0xC1D8,0x5C64}, {0xC1D9,0x531D}, {0xC1DA,0x60E3},
{0xC1DB,0x60F3}, {0xC1DC,0x635C}, {0xC1DD,0x6383}, {0xC1DE,0x633F}, {0xC1DF,0x63BB},
{0xC1E0,0x64CD}, {0xC1E1,0x65E9}, {0xC1E2,0x66F9}, {0xC1E3,0x5DE3}, {0xC1E4,0x69CD},
{0xC1E5,0x69FD}, {0xC1E6,0x6F15}, {0xC1E7,0x71E5}, {0xC1E8,0x4E89}, {0xC1E9,0x75E9},
{0xC1EA,0x76F8}, {0xC1EB,0x7A93}, {0xC1EC,0x7CDF}, {0xC1ED,0x7DCF}, {0xC1EE,0x7D9C},
{0xC1EF,0x8061}, {0xC1F0,0x8349}, {0xC1F1,0x8358}, {0xC1F2,0x846C}, {0xC1F3,0x84BC},
{0xC1F4,0x85FB}, {0xC1F5,0x88C5}, {0xC1F6,0x8D70}, {0xC1F7,0x9001}, {0xC1F8,0x906D},
{0xC1F9,0x9397}, {0xC1FA,0x971C}, {0xC1FB,0x9A12}, {0xC1FC,0x50CF}, {0xC1FD,0x5897},
{0xC1FE,0x618E}, {0xC2A1,0x81D3}, {0xC2A2,0x8535}, {0xC2A3,0x8D08}, {0xC2A4,0x9020},
{0xC2A5,0x4FC3}, {0xC2A6,0x5074}, {0xC2A7,0x5247}, {0xC2A8,0x5373}, {0xC2A9,0x606F},
{0xC2AA,0x6349}, {0xC2AB,0x675F}, {0xC2AC,0x6E2C}, {0xC2AD,0x8DB3}, {0xC2AE,0x901F},
{0xC2AF,0x4FD7}, {0xC2B0,0x5C5E}, {0xC2B1,0x8CCA}, {0xC2B2,0x65CF}, {0xC2B3,0x7D9A},
{0xC2B4,0x5352}, {0xC2B5,0x8896}, {0xC2B6,0x5176}, {0xC2B7,0x63C3}, {0xC2B8,0x5B58},
{0xC2B9,0x5B6B}, {0xC2BA,0x5C0A}, {0xC2BB,0x640D}, {0xC2BC,0x6751}, {0xC2BD,0x905C},
{0xC2BE,0x4ED6}, {0xC2BF,0x591A}, {0xC2C0,0x592A}, {0xC2C1,0x6C70}, {0xC2C2,0x8A51},
{0xC2C3,0x553E}, {0xC2C4,0x5815}, {0xC2C5,0x59A5}, {0xC2C6,0x60F0}, {0xC2C7,0x6253},
{0xC2C8,0x67C1}, {0xC2C9,0x8235}, {0xC2CA,0x6955}, {0xC2CB,0x9640}, {0xC2CC,0x99C4},
{0xC2CD,0x9A28}, {0xC2CE,0x4F53}, {0xC2CF,0x5806}, {0xC2D0,0x5BFE}, {0xC2D1,0x8010},
{0xC2D2,0x5CB1}, {0xC2D3,0x5E2F}, {0xC2D4,0x5F85}, {0xC2D5,0x6020}, {0xC2D6,0x614B},
{0xC2D7,0x6234}, {0xC2D8,0x66FF}, {0xC2D9,0x6CF0}, {0xC2DA,0x6EDE}, {0xC2DB,0x80CE},
{0xC2DC,0x817F}, {0xC2DD,0x82D4}, {0xC2DE,0x888B}, {0xC2DF,0x8CB8}, {0xC2E0,0x9000},
{0xC2E1,0x902E}, {0xC2E2,0x968A}, {0xC2E3,0x9EDB}, {0xC2E4,0x9BDB}, {0xC2E5,0x4EE3},
{0xC2E6,0x53F0}, {0xC2E7,0x5927}, {0xC2E8,0x7B2C}, {0xC2E9,0x918D}, {0xC2EA,0x984C},
{0xC2EB,0x9DF9}, {0xC2EC,0x6EDD}, {0xC2ED,0x7027}, {0xC2EE,0x5353}, {0xC2EF,0x5544},
{0xC2F0,0x5B85}, {0xC2F1,0x6258}, {0xC2F2,0x629E}, {0xC2F3,0x62D3}, {0xC2F4,0x6CA2},
{0xC2F5,0x6FEF}, {0xC2F6,0x7422}, {0xC2F7,0x8A17}, {0xC2F8,0x9438}, {0xC2F9,0x6FC1},
{0xC2FA,0x8AFE}, {0xC2FB,0x8338}, {0xC2FC,0x51E7}, {0xC2FD,0x86F8}, {0xC2FE,0x53EA},
{0xC3A1,0x53E9}, {0xC3A2,0x4F46}, {0xC3A3,0x9054}, {0xC3A4,0x8FB0}, {0xC3A5,0x596A},
{0xC3A6,0x8131}, {0xC3A7,0x5DFD}, {0xC3A8,0x7AEA}, {0xC3A9,0x8FBF}, {0xC3AA,0x68DA},
{0xC3AB,0x8C37}, {0xC3AC,0x72F8}, {0xC3AD,0x9C48}, {0xC3AE,0x6A3D}, {0xC3AF,0x8AB0},
{0xC3B0,0x4E39}, {0xC3B1,0x5358}, {0xC3B2,0x5606}, {0xC3B3,0x5766}, {0xC3B4,0x62C5},
{0xC3B5,0x63A2}, {0xC3B6,0x65E6}, {0xC3B7,0x6B4E}, {0xC3B8,0x6DE1}, {0xC3B9,0x6E5B},
{0xC3BA,0x70AD}, {0xC3BB,0x77ED}, {0xC3BC,0x7AEF}, {0xC3BD,0x7BAA}, {0xC3BE,0x7DBB},
{0xC3BF,0x803D}, {0xC3C0,0x80C6}, {0xC3C1,0x86CB}, {0xC3C2,0x8A95}, {0xC3C3,0x935B},
{0xC3C4,0x56E3}, {0xC3C5,0x58C7}, {0xC3C6,0x5F3E}, {0xC3C7,0x65AD}, {0xC3C8,0x6696},
{0xC3C9,0x6A80}, {0xC3CA,0x6BB5}, {0xC3CB,0x7537}, {0xC3CC,0x8AC7}, {0xC3CD,0x5024},
{0xC3CE,0x77E5}, {0xC3CF,0x5730}, {0xC3D0,0x5F1B}, {0xC3D1,0x6065}, {0xC3D2,0x667A},
{0xC3D3,0x6C60}, {0xC3D4,0x75F4}, {0xC3D5,0x7A1A}, {0xC3D6,0x7F6E}, {0xC3D7,0x81F4},
{0xC3D8,0x8718}, {0xC3D9,0x9045}, {0xC3DA,0x99B3}, {0xC3DB,0x7BC9}, {0xC3DC,0x755C},
{0xC3DD,0x7AF9}, {0xC3DE,0x7B51}, {0xC3DF,0x84C4}, {0xC3E0,0x9010}, {0xC3E1,0x79E9},
{0xC3E2,0x7A92}, {0xC3E3,0x8336}, {0xC3E4,0x5AE1}, {0xC3E5,0x7740}, {0xC3E6,0x4E2D},
{0xC3E7,0x4EF2}, {0xC3E8,0x5B99}, {0xC3E9,0x5FE0}, {0xC3EA,0x62BD}, {0xC3EB,0x663C},
{0xC3EC,0x67F1}, {0xC3ED,0x6CE8}, {0xC3EE,0x866B}, {0xC3EF,0x8877}, {0xC3F0,0x8A3B},
{0xC3F1,0x914E}, {0xC3F2,0x92F3}, {0xC3F3,0x99D0}, {0xC3F4,0x6A17}, {0xC3F5,0x7026},
{0xC3F6,0x732A}, {0xC3F7,0x82E7}, {0xC3F8,0x8457}, {0xC3F9,0x8CAF}, {0xC3FA,0x4E01},
{0xC3FB,0x5146}, {0xC3FC,0x51CB}, {0xC3FD,0x558B}, {0xC3FE,0x5BF5}, {0xC4A1,0x5E16},
{0xC4A2,0x5E33}, {0xC4A3,0x5E81}, {0xC4A4,0x5F14}, {0xC4A5,0x5F35}, {0xC4A6,0x5F6B},
{0xC4A7,0x5FB4}, {0xC4A8,0x61F2}, {0xC4A9,0x6311}, {0xC4AA,0x66A2}, {0xC4AB,0x671D},
{0xC4AC,0x6F6E}, {0xC4AD,0x7252}, {0xC4AE,0x753A}, {0xC4AF,0x773A}, {0xC4B0,0x8074},
{0xC4B1,0x8139}, {0xC4B2,0x8178}, {0xC4B3,0x8776}, {0xC4B4,0x8ABF}, {0xC4B5,0x8ADC},
{0xC4B6,0x8D85}, {0xC4B7,0x8DF3}, {0xC4B8,0x929A}, {0xC4B9,0x9577}, {0xC4BA,0x9802},
{0xC4BB,0x9CE5}, {0xC4BC,0x52C5}, {0xC4BD,0x6357}, {0xC4BE,0x76F4}, {0xC4BF,0x6715},
{0xC4C0,0x6C88}, {0xC4C1,0x73CD}, {0xC4C2,0x8CC3}, {0xC4C3,0x93AE}, {0xC4C4,0x9673},
{0xC4C5,0x6D25}, {0xC4C6,0x589C}, {0xC4C7,0x690E}, {0xC4C8,0x69CC}, {0xC4C9,0x8FFD},
{0xC4CA,0x939A}, {0xC4CB,0x75DB}, {0xC4CC,0x901A}, {0xC4CD,0x585A}, {0xC4CE,0x6802},
{0xC4CF,0x63B4}, {0xC4D0,0x69FB}, {0xC4D1,0x4F43}, {0xC4D2,0x6F2C}, {0xC4D3,0x67D8},
{0xC4D4,0x8FBB}, {0xC4D5,0x8526}, {0xC4D6,0x7DB4}, {0xC4D7,0x9354}, {0xC4D8,0x693F},
{0xC4D9,0x6F70}, {0xC4DA,0x576A}, {0xC4DB,0x58F7}, {0xC4DC,0x5B2C}, {0xC4DD,0x7D2C},
{0xC4DE,0x722A}, {0xC4DF,0x540A}, {0xC4E0,0x91E3}, {0xC4E1,0x9DB4}, {0xC4E2,0x4EAD},
{0xC4E3,0x4F4E}, {0xC4E4,0x505C}, {0xC4E5,0x5075}, {0xC4E6,0x5243}, {0xC4E7,0x8C9E},
{0xC4E8,0x5448}, {0xC4E9,0x5824}, {0xC4EA,0x5B9A}, {0xC4EB,0x5E1D}, {0xC4EC,0x5E95},
{0xC4ED,0x5EAD}, {0xC4EE,0x5EF7}, {0xC4EF,0x5F1F}, {0xC4F0,0x608C}, {0xC4F1,0x62B5},
{0xC4F2,0x633A}, {0xC4F3,0x63D0}, {0xC4F4,0x68AF}, {0xC4F5,0x6C40}, {0xC4F6,0x7887},
{0xC4F7,0x798E}, {0xC4F8,0x7A0B}, {0xC4F9,0x7DE0}, {0xC4FA,0x8247}, {0xC4FB,0x8A02},
{0xC4FC,0x8AE6}, {0xC4FD,0x8E44}, {0xC4FE,0x9013}, {0xC5A1,0x90B8}, {0xC5A2,0x912D},
{0xC5A3,0x91D8}, {0xC5A4,0x9F0E}, {0xC5A5,0x6CE5}, {0xC5A6,0x6458}, {0xC5A7,0x64E2},
{0xC5A8,0x6575}, {0xC5A9,0x6EF4}, {0xC5AA,0x7684}, {0xC5AB,0x7B1B}, {0xC5AC,0x9069},
{0xC5AD,0x93D1}, {0xC5AE,0x6EBA}, {0xC5AF,0x54F2}, {0xC5B0,0x5FB9}, {0xC5B1,0x64A4},
{0xC5B2,0x8F4D}, {0xC5B3,0x8FED}, {0xC5B4,0x9244}, {0xC5B5,0x5178}, {0xC5B6,0x586B},
{0xC5B7,0x5929}, {0xC5B8,0x5C55}, {0xC5B9,0x5E97}, {0xC5BA,0x6DFB}, {0xC5BB,0x7E8F},
{0xC5BC,0x751C}, {0xC5BD,0x8CBC}, {0xC5BE,0x8EE2}, {0xC5BF,0x985B}, {0xC5C0,0x70B9},
{0xC5C1,0x4F1D}, {0xC5C2,0x6BBF}, {0xC5C3,0x6FB1}, {0xC5C4,0x7530}, {0xC5C5,0x96FB},
{0xC5C6,0x514E}, {0xC5C7,0x5410}, {0xC5C8,0x5835}, {0xC5C9,0x5857}, {0xC5CA,0x59AC},
{0xC5CB,0x5C60}, {0xC5CC,0x5F92}, {0xC5CD,0x6597}, {0xC5CE,0x675C}, {0xC5CF,0x6E21},
{0xC5D0,0x767B}, {0xC5D1,0x83DF}, {0xC5D2,0x8CED}, {0xC5D3,0x9014}, {0xC5D4,0x90FD},
{0xC5D5,0x934D}, {0xC5D6,0x7825}, {0xC5D7,0x783A}, {0xC5D8,0x52AA}, {0xC5D9,0x5EA6},
{0xC5DA,0x571F}, {0xC5DB,0x5974}, {0xC5DC,0x6012}, {0xC5DD,0x5012}, {0xC5DE,0x515A},
{0xC5DF,0x51AC}, {0xC5E0,0x51CD}, {0xC5E1,0x5200}, {0xC5E2,0x5510}, {0xC5E3,0x5854},
{0xC5E4,0x5858}, {0xC5E5,0x5957}, {0xC5E6,0x5B95}, {0xC5E7,0x5CF6}, {0xC5E8,0x5D8B},
{0xC5E9,0x60BC}, {0xC5EA,0x6295}, {0xC5EB,0x642D}, {0xC5EC,0x6771}, {0xC5ED,0x6843},
{0xC5EE,0x68BC}, {0xC5EF,0x68DF}, {0xC5F0,0x76D7}, {0xC5F1,0x6DD8}, {0xC5F2,0x6E6F},
{0xC5F3,0x6D9B}, {0xC5F4,0x706F}, {0xC5F5,0x71C8}, {0xC5F6,0x5F53}, {0xC5F7,0x75D8},
{0xC5F8,0x7977}, {0xC5F9,0x7B49}, {0xC5FA,0x7B54}, {0xC5FB,0x7B52}, {0xC5FC,0x7CD6},
{0xC5FD,0x7D71}, {0xC5FE,0x5230}, {0xC6A1,0x8463}, {0xC6A2,0x8569}, {0xC6A3,0x85E4},
{0xC6A4,0x8A0E}, {0xC6A5,0x8B04}, {0xC6A6,0x8C46}, {0xC6A7,0x8E0F}, {0xC6A8,0x9003},
{0xC6A9,0x900F}, {0xC6AA,0x9419}, {0xC6AB,0x9676}, {0xC6AC,0x982D}, {0xC6AD,0x9A30},
{0xC6AE,0x95D8}, {0xC6AF,0x50CD}, {0xC6B0,0x52D5}, {0xC6B1,0x540C}, {0xC6B2,0x5802},
{0xC6B3,0x5C0E}, {0xC6B4,0x61A7}, {0xC6B5,0x649E}, {0xC6B6,0x6D1E}, {0xC6B7,0x77B3},
{0xC6B8,0x7AE5}, {0xC6B9,0x80F4}, {0xC6BA,0x8404}, {0xC6BB,0x9053}, {0xC6BC,0x9285},
{0xC6BD,0x5CE0}, {0xC6BE,0x9D07}, {0xC6BF,0x533F}, {0xC6C0,0x5F97}, {0xC6C1,0x5FB3},
{0xC6C2,0x6D9C}, {0xC6C3,0x7279}, {0xC6C4,0x7763}, {0xC6C5,0x79BF}, {0xC6C6,0x7BE4},
{0xC6C7,0x6BD2}, {0xC6C8,0x72EC}, {0xC6C9,0x8AAD}, {0xC6CA,0x6803}, {0xC6CB,0x6A61},
{0xC6CC,0x51F8}, {0xC6CD,0x7A81}, {0xC6CE,0x6934}, {0xC6CF,0x5C4A}, {0xC6D0,0x9CF6},
{0xC6D1,0x82EB}, {0xC6D2,0x5BC5}, {0xC6D3,0x9149}, {0xC6D4,0x701E}, {0xC6D5,0x5678},
{0xC6D6,0x5C6F}, {0xC6D7,0x60C7}, {0xC6D8,0x6566}, {0xC6D9,0x6C8C}, {0xC6DA,0x8C5A},
{0xC6DB,0x9041}, {0xC6DC,0x9813}, {0xC6DD,0x5451}, {0xC6DE,0x66C7}, {0xC6DF,0x920D},
{0xC6E0,0x5948}, {0xC6E1,0x90A3}, {0xC6E2,0x5185}, {0xC6E3,0x4E4D}, {0xC6E4,0x51EA},
{0xC6E5,0x8599}, {0xC6E6,0x8B0E}, {0xC6E7,0x7058}, {0xC6E8,0x637A}, {0xC6E9,0x934B},
{0xC6EA,0x6962}, {0xC6EB,0x99B4}, {0xC6EC,0x7E04}, {0xC6ED,0x7577}, {0xC6EE,0x5357},
{0xC6EF,0x6960}, {0xC6F0,0x8EDF}, {0xC6F1,0x96E3}, {0xC6F2,0x6C5D}, {0xC6F3,0x4E8C},
{0xC6F4,0x5C3C}, {0xC6F5,0x5F10}, {0xC6F6,0x8FE9}, {0xC6F7,0x5302}, {0xC6F8,0x8CD1},
{0xC6F9,0x8089}, {0xC6FA,0x8679}, {0xC6FB,0x5EFF}, {0xC6FC,0x65E5}, {0xC6FD,0x4E73},
{0xC6FE,0x5165}, {0xC7A1,0x5982}, {0xC7A2,0x5C3F}, {0xC7A3,0x97EE}, {0xC7A4,0x4EFB},
{0xC7A5,0x598A}, {0xC7A6,0x5FCD}, {0xC7A7,0x8A8D}, {0xC7A8,0x6FE1}, {0xC7A9,0x79B0},
{0xC7AA,0x7962}, {0xC7AB,0x5BE7}, {0xC7AC,0x8471}, {0xC7AD,0x732B}, {0xC7AE,0x71B1},
{0xC7AF,0x5E74}, {0xC7B0,0x5FF5}, {0xC7B1,0x637B}, {0xC7B2,0x649A}, {0xC7B3,0x71C3},
{0xC7B4,0x7C98}, {0xC7B5,0x4E43}, {0xC7B6,0x5EFC}, {0xC7B7,0x4E4B}, {0xC7B8,0x57DC},
{0xC7B9,0x56A2}, {0xC7BA,0x60A9}, {0xC7BB,0x6FC3}, {0xC7BC,0x7D0D}, {0xC7BD,0x80FD},
{0xC7BE,0x8133}, {0xC7BF,0x81BF}, {0xC7C0,0x8FB2}, {0xC7C1,0x8997}, {0xC7C2,0x86A4},
{0xC7C3,0x5DF4}, {0xC7C4,0x628A}, {0xC7C5,0x64AD}, {0xC7C6,0x8987}, {0xC7C7,0x6777},
{0xC7C8,0x6CE2}, {0xC7C9,0x6D3E}, {0xC7CA,0x7436}, {0xC7CB,0x7834}, {0xC7CC,0x5A46},
{0xC7CD,0x7F75}, {0xC7CE,0x82AD}, {0xC7CF,0x99AC}, {0xC7D0,0x4FF3}, {0xC7D1,0x5EC3},
{0xC7D2,0x62DD}, {0xC7D3,0x6392}, {0xC7D4,0x6557}, {0xC7D5,0x676F}, {0xC7D6,0x76C3},
{0xC7D7,0x724C}, {0xC7D8,0x80CC}, {0xC7D9,0x80BA}, {0xC7DA,0x8F29}, {0xC7DB,0x914D},
{0xC7DC,0x500D}, {0xC7DD,0x57F9}, {0xC7DE,0x5A92}, {0xC7DF,0x6885}, {0xC7E0,0x6973},
{0xC7E1,0x7164}, {0xC7E2,0x72FD}, {0xC7E3,0x8CB7}, {0xC7E4,0x58F2}, {0xC7E5,0x8CE0},
{0xC7E6,0x966A}, {0xC7E7,0x9019}, {0xC7E8,0x877F}, {0xC7E9,0x79E4}, {0xC7EA,0x77E7},
{0xC7EB,0x8429}, {0xC7EC,0x4F2F}, {0xC7ED,0x5265}, {0xC7EE,0x535A}, {0xC7EF,0x62CD},
{0xC7F0,0x67CF}, {0xC7F1,0x6CCA}, {0xC7F2,0x767D}, {0xC7F3,0x7B94}, {0xC7F4,0x7C95},
{0xC7F5,0x8236}, {0xC7F6,0x8584}, {0xC7F7,0x8FEB}, {0xC7F8,0x66DD}, {0xC7F9,0x6F20},
{0xC7FA,0x7206}, {0xC7FB,0x7E1B}, {0xC7FC,0x83AB}, {0xC7FD,0x99C1}, {0xC7FE,0x9EA6},
{0xC8A1,0x51FD}, {0xC8A2,0x7BB1}, {0xC8A3,0x7872}, {0xC8A4,0x7BB8}, {0xC8A5,0x8087},
{0xC8A6,0x7B48}, {0xC8A7,0x6AE8}, {0xC8A8,0x5E61}, {0xC8A9,0x808C}, {0xC8AA,0x7551},
{0xC8AB,0x7560}, {0xC8AC,0x516B}, {0xC8AD,0x9262}, {0xC8AE,0x6E8C}, {0xC8AF,0x767A},
{0xC8B0,0x9197}, {0xC8B1,0x9AEA}, {0xC8B2,0x4F10}, {0xC8B3,0x7F70}, {0xC8B4,0x629C},
{0xC8B5,0x7B4F}, {0xC8B6,0x95A5}, {0xC8B7,0x9CE9}, {0xC8B8,0x567A}, {0xC8B9,0x5859},
{0xC8BA,0x86E4}, {0xC8BB,0x96BC}, {0xC8BC,0x4F34}, {0xC8BD,0x5224}, {0xC8BE,0x534A},
{0xC8BF,0x53CD}, {0xC8C0,0x53DB}, {0xC8C1,0x5E06}, {0xC8C2,0x642C}, {0xC8C3,0x6591},
{0xC8C4,0x677F}, {0xC8C5,0x6C3E}, {0xC8C6,0x6C4E}, {0xC8C7,0x7248}, {0xC8C8,0x72AF},
{0xC8C9,0x73ED}, {0xC8CA,0x7554}, {0xC8CB,0x7E41}, {0xC8CC,0x822C}, {0xC8CD,0x85E9},
{0xC8CE,0x8CA9}, {0xC8CF,0x7BC4}, {0xC8D0,0x91C6}, {0xC8D1,0x7169}, {0xC8D2,0x9812},
{0xC8D3,0x98EF}, {0xC8D4,0x633D}, {0xC8D5,0x6669}, {0xC8D6,0x756A}, {0xC8D7,0x76E4},
{0xC8D8,0x78D0}, {0xC8D9,0x8543}, {0xC8DA,0x86EE}, {0xC8DB,0x532A}, {0xC8DC,0x5351},
{0xC8DD,0x5426}, {0xC8DE,0x5983}, {0xC8DF,0x5E87}, {0xC8E0,0x5F7C}, {0xC8E1,0x60B2},
{0xC8E2,0x6249}, {0xC8E3,0x6279}, {0xC8E4,0x62AB}, {0xC8E5,0x6590}, {0xC8E6,0x6BD4},
{0xC8E7,0x6CCC}, {0xC8E8,0x75B2}, {0xC8E9,0x76AE}, {0xC8EA,0x7891}, {0xC8EB,0x79D8},
{0xC8EC,0x7DCB}, {0xC8ED,0x7F77}, {0xC8EE,0x80A5}, {0xC8EF,0x88AB}, {0xC8F0,0x8AB9},
{0xC8F1,0x8CBB}, {0xC8F2,0x907F}, {0xC8F3,0x975E}, {0xC8F4,0x98DB}, {0xC8F5,0x6A0B},
{0xC8F6,0x7C38}, {0xC8F7,0x5099}, {0xC8F8,0x5C3E}, {0xC8F9,0x5FAE}, {0xC8FA,0x6787},
{0xC8FB,0x6BD8}, {0xC8FC,0x7435}, {0xC8FD,0x7709}, {0xC8FE,0x7F8E}, {0xC9A1,0x9F3B},
{0xC9A2,0x67CA}, {0xC9A3,0x7A17}, {0xC9A4,0x5339}, {0xC9A5,0x758B}, {0xC9A6,0x9AED},
{0xC9A7,0x5F66}, {0xC9A8,0x819D}, {0xC9A9,0x83F1}, {0xC9AA,0x8098}, {0xC9AB,0x5F3C},
{0xC9AC,0x5FC5}, {0xC9AD,0x7562}, {0xC9AE,0x7B46}, {0xC9AF,0x903C}, {0xC9B0,0x6867},
{0xC9B1,0x59EB}, {0xC9B2,0x5A9B}, {0xC9B3,0x7D10}, {0xC9B4,0x767E}, {0xC9B5,0x8B2C},
{0xC9B6,0x4FF5}, {0xC9B7,0x5F6A}, {0xC9B8,0x6A19}, {0xC9B9,0x6C37}, {0xC9BA,0x6F02},
{0xC9BB,0x74E2}, {0xC9BC,0x7968}, {0xC9BD,0x8868}, {0xC9BE,0x8A55}, {0xC9BF,0x8C79},
{0xC9C0,0x5EDF}, {0xC9C1,0x63CF}, {0xC9C2,0x75C5}, {0xC9C3,0x79D2}, {0xC9C4,0x82D7},
{0xC9C5,0x9328}, {0xC9C6,0x92F2}, {0xC9C7,0x849C}, {0xC9C8,0x86ED}, {0xC9C9,0x9C2D},
{0xC9CA,0x54C1}, {0xC9CB,0x5F6C}, {0xC9CC,0x658C}, {0xC9CD,0x6D5C}, {0xC9CE,0x7015},
{0xC9CF,0x8CA7}, {0xC9D0,0x8CD3}, {0xC9D1,0x983B}, {0xC9D2,0x654F}, {0xC9D3,0x74F6},
{0xC9D4,0x4E0D}, {0xC9D5,0x4ED8}, {0xC9D6,0x57E0}, {0xC9D7,0x592B}, {0xC9D8,0x5A66},
{0xC9D9,0x5BCC}, {0xC9DA,0x51A8}, {0xC9DB,0x5E03}, {0xC9DC,0x5E9C}, {0xC9DD,0x6016},
{0xC9DE,0x6276}, {0xC9DF,0x6577}, {0xC9E0,0x65A7}, {0xC9E1,0x666E}, {0xC9E2,0x6D6E},
{0xC9E3,0x7236}, {0xC9E4,0x7B26}, {0xC9E5,0x8150}, {0xC9E6,0x819A}, {0xC9E7,0x8299},
{0xC9E8,0x8B5C}, {0xC9E9,0x8CA0}, {0xC9EA,0x8CE6}, {0xC9EB,0x8D74}, {0xC9EC,0x961C},
{0xC9ED,0x9644}, {0xC9EE,0x4FAE}, {0xC9EF,0x64AB}, {0xC9F0,0x6B66}, {0xC9F1,0x821E},
{0xC9F2,0x8461}, {0xC9F3,0x856A}, {0xC9F4,0x90E8}, {0xC9F5,0x5C01}, {0xC9F6,0x6953},
{0xC9F7,0x98A8}, {0xC9F8,0x847A}, {0xC9F9,0x8557}, {0xC9FA,0x4F0F}, {0xC9FB,0x526F},
{0xC9FC,0x5FA9}, {0xC9FD,0x5E45}, {0xC9FE,0x670D}, {0xCAA1,0x798F}, {0xCAA2,0x8179},
{0xCAA3,0x8907}, {0xCAA4,0x8986}, {0xCAA5,0x6DF5}, {0xCAA6,0x5F17}, {0xCAA7,0x6255},
{0xCAA8,0x6CB8}, {0xCAA9,0x4ECF}, {0xCAAA,0x7269}, {0xCAAB,0x9B92}, {0xCAAC,0x5206},
{0xCAAD,0x543B}, {0xCAAE,0x5674}, {0xCAAF,0x58B3}, {0xCAB0,0x61A4}, {0xCAB1,0x626E},
{0xCAB2,0x711A}, {0xCAB3,0x596E}, {0xCAB4,0x7C89}, {0xCAB5,0x7CDE}, {0xCAB6,0x7D1B},
{0xCAB7,0x96F0}, {0xCAB8,0x6587}, {0xCAB9,0x805E}, {0xCABA,0x4E19}, {0xCABB,0x4F75},
{0xCABC,0x5175}, {0xCABD,0x5840}, {0xCABE,0x5E63}, {0xCABF,0x5E73}, {0xCAC0,0x5F0A},
{0xCAC1,0x67C4}, {0xCAC2,0x4E26}, {0xCAC3,0x853D}, {0xCAC4,0x9589}, {0xCAC5,0x965B},
{0xCAC6,0x7C73}, {0xCAC7,0x9801}, {0xCAC8,0x50FB}, {0xCAC9,0x58C1}, {0xCACA,0x7656},
{0xCACB,0x78A7}, {0xCACC,0x5225}, {0xCACD,0x77A5}, {0xCACE,0x8511}, {0xCACF,0x7B86},
{0xCAD0,0x504F}, {0xCAD1,0x5909}, {0xCAD2,0x7247}, {0xCAD3,0x7BC7}, {0xCAD4,0x7DE8},
{0xCAD5,0x8FBA}, {0xCAD6,0x8FD4}, {0xCAD7,0x904D}, {0xCAD8,0x4FBF}, {0xCAD9,0x52C9},
{0xCADA,0x5A29}, {0xCADB,0x5F01}, {0xCADC,0x97AD}, {0xCADD,0x4FDD}, {0xCADE,0x8217},
{0xCADF,0x92EA}, {0xCAE0,0x5703}, {0xCAE1,0x6355}, {0xCAE2,0x6B69}, {0xCAE3,0x752B},
{0xCAE4,0x88DC}, {0xCAE5,0x8F14}, {0xCAE6,0x7A42}, {0xCAE7,0x52DF}, {0xCAE8,0x5893},
{0xCAE9,0x6155}, {0xCAEA,0x620A}, {0xCAEB,0x66AE}, {0xCAEC,0x6BCD}, {0xCAED,0x7C3F},
{0xCAEE,0x83E9}, {0xCAEF,0x5023}, {0xCAF0,0x4FF8}, {0xCAF1,0x5305}, {0xCAF2,0x5446},
{0xCAF3,0x5831}, {0xCAF4,0x5949}, {0xCAF5,0x5B9D}, {0xCAF6,0x5CF0}, {0xCAF7,0x5CEF},
{0xCAF8,0x5D29}, {0xCAF9,0x5E96}, {0xCAFA,0x62B1}, {0xCAFB,0x6367}, {0xCAFC,0x653E},
{0xCAFD,0x65B9}, {0xCAFE,0x670B}, {0xCBA1,0x6CD5}, {0xCBA2,0x6CE1}, {0xCBA3,0x70F9},
{0xCBA4,0x7832}, {0xCBA5,0x7E2B}, {0xCBA6,0x80DE}, {0xCBA7,0x82B3}, {0xCBA8,0x840C},
{0xCBA9,0x84EC}, {0xCBAA,0x8702}, {0xCBAB,0x8912}, {0xCBAC,0x8A2A}, {0xCBAD,0x8C4A},
{0xCBAE,0x90A6}, {0xCBAF,0x92D2}, {0xCBB0,0x98FD}, {0xCBB1,0x9CF3}, {0xCBB2,0x9D6C},
{0xCBB3,0x4E4F}, {0xCBB4,0x4EA1}, {0xCBB5,0x508D}, {0xCBB6,0x5256}, {0xCBB7,0x574A},
{0xCBB8,0x59A8}, {0xCBB9,0x5E3D}, {0xCBBA,0x5FD8}, {0xCBBB,0x5FD9}, {0xCBBC,0x623F},
{0xCBBD,0x66B4}, {0xCBBE,0x671B}, {0xCBBF,0x67D0}, {0xCBC0,0x68D2}, {0xCBC1,0x5192},
{0xCBC2,0x7D21}, {0xCBC3,0x80AA}, {0xCBC4,0x81A8}, {0xCBC5,0x8B00}, {0xCBC6,0x8C8C},
{0xCBC7,0x8CBF}, {0xCBC8,0x927E}, {0xCBC9,0x9632}, {0xCBCA,0x5420}, {0xCBCB,0x982C},
{0xCBCC,0x5317}, {0xCBCD,0x50D5}, {0xCBCE,0x535C}, {0xCBCF,0x58A8}, {0xCBD0,0x64B2},
{0xCBD1,0x6734}, {0xCBD2,0x7267}, {0xCBD3,0x7766}, {0xCBD4,0x7A46}, {0xCBD5,0x91E6},
{0xCBD6,0x52C3}, {0xCBD7,0x6CA1}, {0xCBD8,0x6B86}, {0xCBD9,0x5800}, {0xCBDA,0x5E4C},
{0xCBDB,0x5954}, {0xCBDC,0x672C}, {0xCBDD,0x7FFB}, {0xCBDE,0x51E1}, {0xCBDF,0x76C6},
{0xCBE0,0x6469}, {0xCBE1,0x78E8}, {0xCBE2,0x9B54}, {0xCBE3,0x9EBB}, {0xCBE4,0x57CB},
{0xCBE5,0x59B9}, {0xCBE6,0x6627}, {0xCBE7,0x679A}, {0xCBE8,0x6BCE}, {0xCBE9,0x54E9},
{0xCBEA,0x69D9}, {0xCBEB,0x5E55}, {0xCBEC,0x819C}, {0xCBED,0x6795}, {0xCBEE,0x9BAA},
{0xCBEF,0x67FE}, {0xCBF0,0x9C52}, {0xCBF1,0x685D}, {0xCBF2,0x4EA6}, {0xCBF3,0x4FE3},
{0xCBF4,0x53C8}, {0xCBF5,0x62B9}, {0xCBF6,0x672B}, {0xCBF7,0x6CAB}, {0xCBF8,0x8FC4},
{0xCBF9,0x4FAD}, {0xCBFA,0x7E6D}, {0xCBFB,0x9EBF}, {0xCBFC,0x4E07}, {0xCBFD,0x6162},
{0xCBFE,0x6E80}, {0xCCA1,0x6F2B}, {0xCCA2,0x8513}, {0xCCA3,0x5473}, {0xCCA4,0x672A},
{0xCCA5,0x9B45}, {0xCCA6,0x5DF3}, {0xCCA7,0x7B95}, {0xCCA8,0x5CAC}, {0xCCA9,0x5BC6},
{0xCCAA,0x871C}, {0xCCAB,0x6E4A}, {0xCCAC,0x84D1}, {0xCCAD,0x7A14}, {0xCCAE,0x8108},
{0xCCAF,0x5999}, {0xCCB0,0x7C8D}, {0xCCB1,0x6C11}, {0xCCB2,0x7720}, {0xCCB3,0x52D9},
{0xCCB4,0x5922}, {0xCCB5,0x7121}, {0xCCB6,0x725F}, {0xCCB7,0x77DB}, {0xCCB8,0x9727},
{0xCCB9,0x9D61}, {0xCCBA,0x690B}, {0xCCBB,0x5A7F}, {0xCCBC,0x5A18}, {0xCCBD,0x51A5},
{0xCCBE,0x540D}, {0xCCBF,0x547D}, {0xCCC0,0x660E}, {0xCCC1,0x76DF}, {0xCCC2,0x8FF7},
{0xCCC3,0x9298}, {0xCCC4,0x9CF4}, {0xCCC5,0x59EA}, {0xCCC6,0x725D}, {0xCCC7,0x6EC5},
{0xCCC8,0x514D}, {0xCCC9,0x68C9}, {0xCCCA,0x7DBF}, {0xCCCB,0x7DEC}, {0xCCCC,0x9762},
{0xCCCD,0x9EBA}, {0xCCCE,0x6478}, {0xCCCF,0x6A21}, {0xCCD0,0x8302}, {0xCCD1,0x5984},
{0xCCD2,0x5B5F}, {0xCCD3,0x6BDB}, {0xCCD4,0x731B}, {0xCCD5,0x76F2}, {0xCCD6,0x7DB2},
{0xCCD7,0x8017}, {0xCCD8,0x8499}, {0xCCD9,0x5132}, {0xCCDA,0x6728}, {0xCCDB,0x9ED9},
{0xCCDC,0x76EE}, {0xCCDD,0x6762}, {0xCCDE,0x52FF}, {0xCCDF,0x9905}, {0xCCE0,0x5C24},
{0xCCE1,0x623B}, {0xCCE2,0x7C7E}, {0xCCE3,0x8CB0}, {0xCCE4,0x554F}, {0xCCE5,0x60B6},
{0xCCE6,0x7D0B}, {0xCCE7,0x9580}, {0xCCE8,0x5301}, {0xCCE9,0x4E5F}, {0xCCEA,0x51B6},
{0xCCEB,0x591C}, {0xCCEC,0x723A}, {0xCCED,0x8036}, {0xCCEE,0x91CE}, {0xCCEF,0x5F25},
{0xCCF0,0x77E2}, {0xCCF1,0x5384}, {0xCCF2,0x5F79}, {0xCCF3,0x7D04}, {0xCCF4,0x85AC},
{0xCCF5,0x8A33}, {0xCCF6,0x8E8D}, {0xCCF7,0x9756}, {0xCCF8,0x67F3}, {0xCCF9,0x85AE},
{0xCCFA,0x9453}, {0xCCFB,0x6109}, {0xCCFC,0x6108}, {0xCCFD,0x6CB9}, {0xCCFE,0x7652},
{0xCDA1,0x8AED}, {0xCDA2,0x8F38}, {0xCDA3,0x552F}, {0xCDA4,0x4F51}, {0xCDA5,0x512A},
{0xCDA6,0x52C7}, {0xCDA7,0x53CB}, {0xCDA8,0x5BA5}, {0xCDA9,0x5E7D}, {0xCDAA,0x60A0},
{0xCDAB,0x6182}, {0xCDAC,0x63D6}, {0xCDAD,0x6709}, {0xCDAE,0x67DA}, {0xCDAF,0x6E67},
{0xCDB0,0x6D8C}, {0xCDB1,0x7336}, {0xCDB2,0x7337}, {0xCDB3,0x7531}, {0xCDB4,0x7950},
{0xCDB5,0x88D5}, {0xCDB6,0x8A98}, {0xCDB7,0x904A}, {0xCDB8,0x9091}, {0xCDB9,0x90F5},
{0xCDBA,0x96C4}, {0xCDBB,0x878D}, {0xCDBC,0x5915}, {0xCDBD,0x4E88}, {0xCDBE,0x4F59},
{0xCDBF,0x4E0E}, {0xCDC0,0x8A89}, {0xCDC1,0x8F3F}, {0xCDC2,0x9810}, {0xCDC3,0x50AD},
{0xCDC4,0x5E7C}, {0xCDC5,0x5996}, {0xCDC6,0x5BB9}, {0xCDC7,0x5EB8}, {0xCDC8,0x63DA},
{0xCDC9,0x63FA}, {0xCDCA,0x64C1}, {0xCDCB,0x66DC}, {0xCDCC,0x694A}, {0xCDCD,0x69D8},
{0xCDCE,0x6D0B}, {0xCDCF,0x6EB6}, {0xCDD0,0x7194}, {0xCDD1,0x7528}, {0xCDD2,0x7AAF},
{0xCDD3,0x7F8A}, {0xCDD4,0x8000}, {0xCDD5,0x8449}, {0xCDD6,0x84C9}, {0xCDD7,0x8981},
{0xCDD8,0x8B21}, {0xCDD9,0x8E0A}, {0xCDDA,0x9065}, {0xCDDB,0x967D}, {0xCDDC,0x990A},
{0xCDDD,0x617E}, {0xCDDE,0x6291}, {0xCDDF,0x6B32}, {0xCDE0,0x6C83}, {0xCDE1,0x6D74},
{0xCDE2,0x7FCC}, {0xCDE3,0x7FFC}, {0xCDE4,0x6DC0}, {0xCDE5,0x7F85}, {0xCDE6,0x87BA},
{0xCDE7,0x88F8}, {0xCDE8,0x6765}, {0xCDE9,0x83B1}, {0xCDEA,0x983C}, {0xCDEB,0x96F7},
{0xCDEC,0x6D1B}, {0xCDED,0x7D61}, {0xCDEE,0x843D}, {0xCDEF,0x916A}, {0xCDF0,0x4E71},
{0xCDF1,0x5375}, {0xCDF2,0x5D50}, {0xCDF3,0x6B04}, {0xCDF4,0x6FEB}, {0xCDF5,0x85CD},
{0xCDF6,0x862D}, {0xCDF7,0x89A7}, {0xCDF8,0x5229}, {0xCDF9,0x540F}, {0xCDFA,0x5C65},
{0xCDFB,0x674E}, {0xCDFC,0x68A8}, {0xCDFD,0x7406}, {0xCDFE,0x7483}, {0xCEA1,0x75E2},
{0xCEA2,0x88CF}, {0xCEA3,0x88E1}, {0xCEA4,0x91CC}, {0xCEA5,0x96E2}, {0xCEA6,0x9678},
{0xCEA7,0x5F8B}, {0xCEA8,0x7387}, {0xCEA9,0x7ACB}, {0xCEAA,0x844E}, {0xCEAB,0x63A0},
{0xCEAC,0x7565}, {0xCEAD,0x5289}, {0xCEAE,0x6D41}, {0xCEAF,0x6E9C}, {0xCEB0,0x7409},
{0xCEB1,0x7559}, {0xCEB2,0x786B}, {0xCEB3,0x7C92}, {0xCEB4,0x9686}, {0xCEB5,0x7ADC},
{0xCEB6,0x9F8D}, {0xCEB7,0x4FB6}, {0xCEB8,0x616E}, {0xCEB9,0x65C5}, {0xCEBA,0x865C},
{0xCEBB,0x4E86}, {0xCEBC,0x4EAE}, {0xCEBD,0x50DA}, {0xCEBE,0x4E21}, {0xCEBF,0x51CC},
{0xCEC0,0x5BEE}, {0xCEC1,0x6599}, {0xCEC2,0x6881}, {0xCEC3,0x6DBC}, {0xCEC4,0x731F},
{0xCEC5,0x7642}, {0xCEC6,0x77AD}, {0xCEC7,0x7A1C}, {0xCEC8,0x7CE7}, {0xCEC9,0x826F},
{0xCECA,0x8AD2}, {0xCECB,0x907C}, {0xCECC,0x91CF}, {0xCECD,0x9675}, {0xCECE,0x9818},
{0xCECF,0x529B}, {0xCED0,0x7DD1}, {0xCED1,0x502B}, {0xCED2,0x5398}, {0xCED3,0x6797},
{0xCED4,0x6DCB}, {0xCED5,0x71D0}, {0xCED6,0x7433}, {0xCED7,0x81E8}, {0xCED8,0x8F2A},
{0xCED9,0x96A3}, {0xCEDA,0x9C57}, {0xCEDB,0x9E9F}, {0xCEDC,0x7460}, {0xCEDD,0x5841},
{0xCEDE,0x6D99}, {0xCEDF,0x7D2F}, {0xCEE0,0x985E}, {0xCEE1,0x4EE4}, {0xCEE2,0x4F36},
{0xCEE3,0x4F8B}, {0xCEE4,0x51B7}, {0xCEE5,0x52B1}, {0xCEE6,0x5DBA}, {0xCEE7,0x601C},
{0xCEE8,0x73B2}, {0xCEE9,0x793C}, {0xCEEA,0x82D3}, {0xCEEB,0x9234}, {0xCEEC,0x96B7},
{0xCEED,0x96F6}, {0xCEEE,0x970A}, {0xCEEF,0x9E97}, {0xCEF0,0x9F62}, {0xCEF1,0x66A6},
{0xCEF2,0x6B74}, {0xCEF3,0x5217}, {0xCEF4,0x52A3}, {0xCEF5,0x70C8}, {0xCEF6,0x88C2},
{0xCEF7,0x5EC9}, {0xCEF8,0x604B}, {0xCEF9,0x6190}, {0xCEFA,0x6F23}, {0xCEFB,0x7149},
{0xCEFC,0x7C3E}, {0xCEFD,0x7DF4}, {0xCEFE,0x806F}, {0xCFA1,0x84EE}, {0xCFA2,0x9023},
{0xCFA3,0x932C}, {0xCFA4,0x5442}, {0xCFA5,0x9B6F}, {0xCFA6,0x6AD3}, {0xCFA7,0x7089},
{0xCFA8,0x8CC2}, {0xCFA9,0x8DEF}, {0xCFAA,0x9732}, {0xCFAB,0x52B4}, {0xCFAC,0x5A41},
{0xCFAD,0x5ECA}, {0xCFAE,0x5F04}, {0xCFAF,0x6717}, {0xCFB0,0x697C}, {0xCFB1,0x6994},
{0xCFB2,0x6D6A}, {0xCFB3,0x6F0F}, {0xCFB4,0x7262}, {0xCFB5,0x72FC}, {0xCFB6,0x7BED},
{0xCFB7,0x8001}, {0xCFB8,0x807E}, {0xCFB9,0x874B}, {0xCFBA,0x90CE}, {0xCFBB,0x516D},
{0xCFBC,0x9E93}, {0xCFBD,0x7984}, {0xCFBE,0x808B}, {0xCFBF,0x9332}, {0xCFC0,0x8AD6},
{0xCFC1,0x502D}, {0xCFC2,0x548C}, {0xCFC3,0x8A71}, {0xCFC4,0x6B6A}, {0xCFC5,0x8CC4},
{0xCFC6,0x8107}, {0xCFC7,0x60D1}, {0xCFC8,0x67A0}, {0xCFC9,0x9DF2}, {0xCFCA,0x4E99},
{0xCFCB,0x4E98}, {0xCFCC,0x9C10}, {0xCFCD,0x8A6B}, {0xCFCE,0x85C1}, {0xCFCF,0x8568},
{0xCFD0,0x6900}, {0xCFD1,0x6E7E}, {0xCFD2,0x7897}, {0xCFD3,0x8155}, {0xD0A1,0x5F0C},
{0xD0A2,0x4E10}, {0xD0A3,0x4E15}, {0xD0A4,0x4E2A}, {0xD0A5,0x4E31}, {0xD0A6,0x4E36},
{0xD0A7,0x4E3C}, {0xD0A8,0x4E3F}, {0xD0A9,0x4E42}, {0xD0AA,0x4E56}, {0xD0AB,0x4E58},
{0xD0AC,0x4E82}, {0xD0AD,0x4E85}, {0xD0AE,0x8C6B}, {0xD0AF,0x4E8A}, {0xD0B0,0x8212},
{0xD0B1,0x5F0D}, {0xD0B2,0x4E8E}, {0xD0B3,0x4E9E}, {0xD0B4,0x4E9F}, {0xD0B5,0x4EA0},
{0xD0B6,0x4EA2}, {0xD0B7,0x4EB0}, {0xD0B8,0x4EB3}, {0xD0B9,0x4EB6}, {0xD0BA,0x4ECE},
{0xD0BB,0x4ECD}, {0xD0BC,0x4EC4}, {0xD0BD,0x4EC6}, {0xD0BE,0x4EC2}, {0xD0BF,0x4ED7},
{0xD0C0,0x4EDE}, {0xD0C1,0x4EED}, {0xD0C2,0x4EDF}, {0xD0C3,0x4EF7}, {0xD0C4,0x4F09},
{0xD0C5,0x4F5A}, {0xD0C6,0x4F30}, {0xD0C7,0x4F5B}, {0xD0C8,0x4F5D}, {0xD0C9,0x4F57},
{0xD0CA,0x4F47}, {0xD0CB,0x4F76}, {0xD0CC,0x4F88}, {0xD0CD,0x4F8F}, {0xD0CE,0x4F98},
{0xD0CF,0x4F7B}, {0xD0D0,0x4F69}, {0xD0D1,0x4F70}, {0xD0D2,0x4F91}, {0xD0D3,0x4F6F},
{0xD0D4,0x4F86}, {0xD0D5,0x4F96}, {0xD0D6,0x5118}, {0xD0D7,0x4FD4}, {0xD0D8,0x4FDF},
{0xD0D9,0x4FCE}, {0xD0DA,0x4FD8}, {0xD0DB,0x4FDB}, {0xD0DC,0x4FD1}, {0xD0DD,0x4FDA},
{0xD0DE,0x4FD0}, {0xD0DF,0x4FE4}, {0xD0E0,0x4FE5}, {0xD0E1,0x501A}, {0xD0E2,0x5028},
{0xD0E3,0x5014}, {0xD0E4,0x502A}, {0xD0E5,0x5025}, {0xD0E6,0x5005}, {0xD0E7,0x4F1C},
{0xD0E8,0x4FF6}, {0xD0E9,0x5021}, {0xD0EA,0x5029}, {0xD0EB,0x502C}, {0xD0EC,0x4FFE},
{0xD0ED,0x4FEF}, {0xD0EE,0x5011}, {0xD0EF,0x5006}, {0xD0F0,0x5043}, {0xD0F1,0x5047},
{0xD0F2,0x6703}, {0xD0F3,0x5055}, {0xD0F4,0x5050}, {0xD0F5,0x5048}, {0xD0F6,0x505A},
{0xD0F7,0x5056}, {0xD0F8,0x506C}, {0xD0F9,0x5078}, {0xD0FA,0x5080}, {0xD0FB,0x509A},
{0xD0FC,0x5085}, {0xD0FD,0x50B4}, {0xD0FE,0x50B2}, {0xD1A1,0x50C9}, {0xD1A2,0x50CA},
{0xD1A3,0x50B3}, {0xD1A4,0x50C2}, {0xD1A5,0x50D6}, {0xD1A6,0x50DE}, {0xD1A7,0x50E5},
{0xD1A8,0x50ED}, {0xD1A9,0x50E3}, {0xD1AA,0x50EE}, {0xD1AB,0x50F9}, {0xD1AC,0x50F5},
{0xD1AD,0x5109}, {0xD1AE,0x5101}, {0xD1AF,0x5102}, {0xD1B0,0x5116}, {0xD1B1,0x5115},
{0xD1B2,0x5114}, {0xD1B3,0x511A}, {0xD1B4,0x5121}, {0xD1B5,0x513A}, {0xD1B6,0x5137},
{0xD1B7,0x513C}, {0xD1B8,0x513B}, {0xD1B9,0x513F}, {0xD1BA,0x5140}, {0xD1BB,0x5152},
{0xD1BC,0x514C}, {0xD1BD,0x5154}, {0xD1BE,0x5162}, {0xD1BF,0x7AF8}, {0xD1C0,0x5169},
{0xD1C1,0x516A}, {0xD1C2,0x516E}, {0xD1C3,0x5180}, {0xD1C4,0x5182}, {0xD1C5,0x56D8},
{0xD1C6,0x518C}, {0xD1C7,0x5189}, {0xD1C8,0x518F}, {0xD1C9,0x5191}, {0xD1CA,0x5193},
{0xD1CB,0x5195}, {0xD1CC,0x5196}, {0xD1CD,0x51A4}, {0xD1CE,0x51A6}, {0xD1CF,0x51A2},
{0xD1D0,0x51A9}, {0xD1D1,0x51AA}, {0xD1D2,0x51AB}, {0xD1D3,0x51B3}, {0xD1D4,0x51B1},
{0xD1D5,0x51B2}, {0xD1D6,0x51B0}, {0xD1D7,0x51B5}, {0xD1D8,0x51BD}, {0xD1D9,0x51C5},
{0xD1DA,0x51C9}, {0xD1DB,0x51DB}, {0xD1DC,0x51E0}, {0xD1DD,0x8655}, {0xD1DE,0x51E9},
{0xD1DF,0x51ED}, {0xD1E0,0x51F0}, {0xD1E1,0x51F5}, {0xD1E2,0x51FE}, {0xD1E3,0x5204},
{0xD1E4,0x520B}, {0xD1E5,0x5214}, {0xD1E6,0x520E}, {0xD1E7,0x5227}, {0xD1E8,0x522A},
{0xD1E9,0x522E}, {0xD1EA,0x5233}, {0xD1EB,0x5239}, {0xD1EC,0x524F}, {0xD1ED,0x5244},
{0xD1EE,0x524B}, {0xD1EF,0x524C}, {0xD1F0,0x525E}, {0xD1F1,0x5254}, {0xD1F2,0x526A},
{0xD1F3,0x5274}, {0xD1F4,0x5269}, {0xD1F5,0x5273}, {0xD1F6,0x527F}, {0xD1F7,0x527D},
{0xD1F8,0x528D}, {0xD1F9,0x5294}, {0xD1FA,0x5292}, {0xD1FB,0x5271}, {0xD1FC,0x5288},
{0xD1FD,0x5291}, {0xD1FE,0x8FA8}, {0xD2A1,0x8FA7}, {0xD2A2,0x52AC}, {0xD2A3,0x52AD},
{0xD2A4,0x52BC}, {0xD2A5,0x52B5}, {0xD2A6,0x52C1}, {0xD2A7,0x52CD}, {0xD2A8,0x52D7},
{0xD2A9,0x52DE}, {0xD2AA,0x52E3}, {0xD2AB,0x52E6}, {0xD2AC,0x98ED}, {0xD2AD,0x52E0},
{0xD2AE,0x52F3}, {0xD2AF,0x52F5}, {0xD2B0,0x52F8}, {0xD2B1,0x52F9}, {0xD2B2,0x5306},
{0xD2B3,0x5308}, {0xD2B4,0x7538}, {0xD2B5,0x530D}, {0xD2B6,0x5310}, {0xD2B7,0x530F},
{0xD2B8,0x5315}, {0xD2B9,0x531A}, {0xD2BA,0x5323}, {0xD2BB,0x532F}, {0xD2BC,0x5331},
{0xD2BD,0x5333}, {0xD2BE,0x5338}, {0xD2BF,0x5340}, {0xD2C0,0x5346}, {0xD2C1,0x5345},
{0xD2C2,0x4E17}, {0xD2C3,0x5349}, {0xD2C4,0x534D}, {0xD2C5,0x51D6}, {0xD2C6,0x535E},
{0xD2C7,0x5369}, {0xD2C8,0x536E}, {0xD2C9,0x5918}, {0xD2CA,0x537B}, {0xD2CB,0x5377},
{0xD2CC,0x5382}, {0xD2CD,0x5396}, {0xD2CE,0x53A0}, {0xD2CF,0x53A6}, {0xD2D0,0x53A5},
{0xD2D1,0x53AE}, {0xD2D2,0x53B0}, {0xD2D3,0x53B6}, {0xD2D4,0x53C3}, {0xD2D5,0x7C12},
{0xD2D6,0x96D9}, {0xD2D7,0x53DF}, {0xD2D8,0x66FC}, {0xD2D9,0x71EE}, {0xD2DA,0x53EE},
{0xD2DB,0x53E8}, {0xD2DC,0x53ED}, {0xD2DD,0x53FA}, {0xD2DE,0x5401}, {0xD2DF,0x543D},
{0xD2E0,0x5440}, {0xD2E1,0x542C}, {0xD2E2,0x542D}, {0xD2E3,0x543C}, {0xD2E4,0x542E},
{0xD2E5,0x5436}, {0xD2E6,0x5429}, {0xD2E7,0x541D}, {0xD2E8,0x544E}, {0xD2E9,0x548F},
{0xD2EA,0x5475}, {0xD2EB,0x548E}, {0xD2EC,0x545F}, {0xD2ED,0x5471}, {0xD2EE,0x5477},
{0xD2EF,0x5470}, {0xD2F0,0x5492}, {0xD2F1,0x547B}, {0xD2F2,0x5480}, {0xD2F3,0x5476},
{0xD2F4,0x5484}, {0xD2F5,0x5490}, {0xD2F6,0x5486}, {0xD2F7,0x54C7}, {0xD2F8,0x54A2},
{0xD2F9,0x54B8}, {0xD2FA,0x54A5}, {0xD2FB,0x54AC}, {0xD2FC,0x54C4}, {0xD2FD,0x54C8},
{0xD2FE,0x54A8}, {0xD3A1,0x54AB}, {0xD3A2,0x54C2}, {0xD3A3,0x54A4}, {0xD3A4,0x54BE},
{0xD3A5,0x54BC}, {0xD3A6,0x54D8}, {0xD3A7,0x54E5}, {0xD3A8,0x54E6}, {0xD3A9,0x550F},
{0xD3AA,0x5514}, {0xD3AB,0x54FD}, {0xD3AC,0x54EE}, {0xD3AD,0x54ED}, {0xD3AE,0x54FA},
{0xD3AF,0x54E2}, {0xD3B0,0x5539}, {0xD3B1,0x5540}, {0xD3B2,0x5563}, {0xD3B3,0x554C},
{0xD3B4,0x552E}, {0xD3B5,0x555C}, {0xD3B6,0x5545}, {0xD3B7,0x5556}, {0xD3B8,0x5557},
{0xD3B9,0x5538}, {0xD3BA,0x5533}, {0xD3BB,0x555D}, {0xD3BC,0x5599}, {0xD3BD,0x5580},
{0xD3BE,0x54AF}, {0xD3BF,0x558A}, {0xD3C0,0x559F}, {0xD3C1,0x557B}, {0xD3C2,0x557E},
{0xD3C3,0x5598}, {0xD3C4,0x559E}, {0xD3C5,0x55AE}, {0xD3C6,0x557C}, {0xD3C7,0x5583},
{0xD3C8,0x55A9}, {0xD3C9,0x5587}, {0xD3CA,0x55A8}, {0xD3CB,0x55DA}, {0xD3CC,0x55C5},
{0xD3CD,0x55DF}, {0xD3CE,0x55C4}, {0xD3CF,0x55DC}, {0xD3D0,0x55E4}, {0xD3D1,0x55D4},
{0xD3D2,0x5614}, {0xD3D3,0x55F7}, {0xD3D4,0x5616}, {0xD3D5,0x55FE}, {0xD3D6,0x55FD},
{0xD3D7,0x561B}, {0xD3D8,0x55F9}, {0xD3D9,0x564E}, {0xD3DA,0x5650}, {0xD3DB,0x71DF},
{0xD3DC,0x5634}, {0xD3DD,0x5636}, {0xD3DE,0x5632}, {0xD3DF,0x5638}, {0xD3E0,0x566B},
{0xD3E1,0x5664}, {0xD3E2,0x562F}, {0xD3E3,0x566C}, {0xD3E4,0x566A}, {0xD3E5,0x5686},
{0xD3E6,0x5680}, {0xD3E7,0x568A}, {0xD3E8,0x56A0}, {0xD3E9,0x5694}, {0xD3EA,0x568F},
{0xD3EB,0x56A5}, {0xD3EC,0x56AE}, {0xD3ED,0x56B6}, {0xD3EE,0x56B4}, {0xD3EF,0x56C2},
{0xD3F0,0x56BC}, {0xD3F1,0x56C1}, {0xD3F2,0x56C3}, {0xD3F3,0x56C0}, {0xD3F4,0x56C8},
{0xD3F5,0x56CE}, {0xD3F6,0x56D1}, {0xD3F7,0x56D3}, {0xD3F8,0x56D7}, {0xD3F9,0x56EE},
{0xD3FA,0x56F9}, {0xD3FB,0x5700}, {0xD3FC,0x56FF}, {0xD3FD,0x5704}, {0xD3FE,0x5709},
{0xD4A1,0x5708}, {0xD4A2,0x570B}, {0xD4A3,0x570D}, {0xD4A4,0x5713}, {0xD4A5,0x5718},
{0xD4A6,0x5716}, {0xD4A7,0x55C7}, {0xD4A8,0x571C}, {0xD4A9,0x5726}, {0xD4AA,0x5737},
{0xD4AB,0x5738}, {0xD4AC,0x574E}, {0xD4AD,0x573B}, {0xD4AE,0x5740}, {0xD4AF,0x574F},
{0xD4B0,0x5769}, {0xD4B1,0x57C0}, {0xD4B2,0x5788}, {0xD4B3,0x5761}, {0xD4B4,0x577F},
{0xD4B5,0x5789}, {0xD4B6,0x5793}, {0xD4B7,0x57A0}, {0xD4B8,0x57B3}, {0xD4B9,0x57A4},
{0xD4BA,0x57AA}, {0xD4BB,0x57B0}, {0xD4BC,0x57C3}, {0xD4BD,0x57C6}, {0xD4BE,0x57D4},
{0xD4BF,0x57D2}, {0xD4C0,0x57D3}, {0xD4C1,0x580A}, {0xD4C2,0x57D6}, {0xD4C3,0x57E3},
{0xD4C4,0x580B}, {0xD4C5,0x5819}, {0xD4C6,0x581D}, {0xD4C7,0x5872}, {0xD4C8,0x5821},
{0xD4C9,0x5862}, {0xD4CA,0x584B}, {0xD4CB,0x5870}, {0xD4CC,0x6BC0}, {0xD4CD,0x5852},
{0xD4CE,0x583D}, {0xD4CF,0x5879}, {0xD4D0,0x5885}, {0xD4D1,0x58B9}, {0xD4D2,0x589F},
{0xD4D3,0x58AB}, {0xD4D4,0x58BA}, {0xD4D5,0x58DE}, {0xD4D6,0x58BB}, {0xD4D7,0x58B8},
{0xD4D8,0x58AE}, {0xD4D9,0x58C5}, {0xD4DA,0x58D3}, {0xD4DB,0x58D1}, {0xD4DC,0x58D7},
{0xD4DD,0x58D9}, {0xD4DE,0x58D8}, {0xD4DF,0x58E5}, {0xD4E0,0x58DC}, {0xD4E1,0x58E4},
{0xD4E2,0x58DF}, {0xD4E3,0x58EF}, {0xD4E4,0x58FA}, {0xD4E5,0x58F9}, {0xD4E6,0x58FB},
{0xD4E7,0x58FC}, {0xD4E8,0x58FD}, {0xD4E9,0x5902}, {0xD4EA,0x590A}, {0xD4EB,0x5910},
{0xD4EC,0x591B}, {0xD4ED,0x68A6}, {0xD4EE,0x5925}, {0xD4EF,0x592C}, {0xD4F0,0x592D},
{0xD4F1,0x5932}, {0xD4F2,0x5938}, {0xD4F3,0x593E}, {0xD4F4,0x7AD2}, {0xD4F5,0x5955},
{0xD4F6,0x5950}, {0xD4F7,0x594E}, {0xD4F8,0x595A}, {0xD4F9,0x5958}, {0xD4FA,0x5962},
{0xD4FB,0x5960}, {0xD4FC,0x5967}, {0xD4FD,0x596C}, {0xD4FE,0x5969}, {0xD5A1,0x5978},
{0xD5A2,0x5981}, {0xD5A3,0x599D}, {0xD5A4,0x4F5E}, {0xD5A5,0x4FAB}, {0xD5A6,0x59A3},
{0xD5A7,0x59B2}, {0xD5A8,0x59C6}, {0xD5A9,0x59E8}, {0xD5AA,0x59DC}, {0xD5AB,0x598D},
{0xD5AC,0x59D9}, {0xD5AD,0x59DA}, {0xD5AE,0x5A25}, {0xD5AF,0x5A1F}, {0xD5B0,0x5A11},
{0xD5B1,0x5A1C}, {0xD5B2,0x5A09}, {0xD5B3,0x5A1A}, {0xD5B4,0x5A40}, {0xD5B5,0x5A6C},
{0xD5B6,0x5A49}, {0xD5B7,0x5A35}, {0xD5B8,0x5A36}, {0xD5B9,0x5A62}, {0xD5BA,0x5A6A},
{0xD5BB,0x5A9A}, {0xD5BC,0x5ABC}, {0xD5BD,0x5ABE}, {0xD5BE,0x5ACB}, {0xD5BF,0x5AC2},
{0xD5C0,0x5ABD}, {0xD5C1,0x5AE3}, {0xD5C2,0x5AD7}, {0xD5C3,0x5AE6}, {0xD5C4,0x5AE9},
{0xD5C5,0x5AD6}, {0xD5C6,0x5AFA}, {0xD5C7,0x5AFB}, {0xD5C8,0x5B0C}, {0xD5C9,0x5B0B},
{0xD5CA,0x5B16}, {0xD5CB,0x5B32}, {0xD5CC,0x5AD0}, {0xD5CD,0x5B2A}, {0xD5CE,0x5B36},
{0xD5CF,0x5B3E}, {0xD5D0,0x5B43}, {0xD5D1,0x5B45}, {0xD5D2,0x5B40}, {0xD5D3,0x5B51},
{0xD5D4,0x5B55}, {0xD5D5,0x5B5A}, {0xD5D6,0x5B5B}, {0xD5D7,0x5B65}, {0xD5D8,0x5B69},
{0xD5D9,0x5B70}, {0xD5DA,0x5B73}, {0xD5DB,0x5B75}, {0xD5DC,0x5B78}, {0xD5DD,0x6588},
{0xD5DE,0x5B7A}, {0xD5DF,0x5B80}, {0xD5E0,0x5B83}, {0xD5E1,0x5BA6}, {0xD5E2,0x5BB8},
{0xD5E3,0x5BC3}, {0xD5E4,0x5BC7}, {0xD5E5,0x5BC9}, {0xD5E6,0x5BD4}, {0xD5E7,0x5BD0},
{0xD5E8,0x5BE4}, {0xD5E9,0x5BE6}, {0xD5EA,0x5BE2}, {0xD5EB,0x5BDE}, {0xD5EC,0x5BE5},
{0xD5ED,0x5BEB}, {0xD5EE,0x5BF0}, {0xD5EF,0x5BF6}, {0xD5F0,0x5BF3}, {0xD5F1,0x5C05},
{0xD5F2,0x5C07}, {0xD5F3,0x5C08}, {0xD5F4,0x5C0D}, {0xD5F5,0x5C13}, {0xD5F6,0x5C20},
{0xD5F7,0x5C22}, {0xD5F8,0x5C28}, {0xD5F9,0x5C38}, {0xD5FA,0x5C39}, {0xD5FB,0x5C41},
{0xD5FC,0x5C46}, {0xD5FD,0x5C4E}, {0xD5FE,0x5C53}, {0xD6A1,0x5C50}, {0xD6A2,0x5C4F},
{0xD6A3,0x5B71}, {0xD6A4,0x5C6C}, {0xD6A5,0x5C6E}, {0xD6A6,0x4E62}, {0xD6A7,0x5C76},
{0xD6A8,0x5C79}, {0xD6A9,0x5C8C}, {0xD6AA,0x5C91}, {0xD6AB,0x5C94}, {0xD6AC,0x599B},
{0xD6AD,0x5CAB}, {0xD6AE,0x5CBB}, {0xD6AF,0x5CB6}, {0xD6B0,0x5CBC}, {0xD6B1,0x5CB7},
{0xD6B2,0x5CC5}, {0xD6B3,0x5CBE}, {0xD6B4,0x5CC7}, {0xD6B5,0x5CD9}, {0xD6B6,0x5CE9},
{0xD6B7,0x5CFD}, {0xD6B8,0x5CFA}, {0xD6B9,0x5CED}, {0xD6BA,0x5D8C}, {0xD6BB,0x5CEA},
{0xD6BC,0x5D0B}, {0xD6BD,0x5D15}, {0xD6BE,0x5D17}, {0xD6BF,0x5D5C}, {0xD6C0,0x5D1F},
{0xD6C1,0x5D1B}, {0xD6C2,0x5D11}, {0xD6C3,0x5D14}, {0xD6C4,0x5D22}, {0xD6C5,0x5D1A},
{0xD6C6,0x5D19}, {0xD6C7,0x5D18}, {0xD6C8,0x5D4C}, {0xD6C9,0x5D52}, {0xD6CA,0x5D4E},
{0xD6CB,0x5D4B}, {0xD6CC,0x5D6C}, {0xD6CD,0x5D73}, {0xD6CE,0x5D76}, {0xD6CF,0x5D87},
{0xD6D0,0x5D84}, {0xD6D1,0x5D82}, {0xD6D2,0x5DA2}, {0xD6D3,0x5D9D}, {0xD6D4,0x5DAC},
{0xD6D5,0x5DAE}, {0xD6D6,0x5DBD}, {0xD6D7,0x5D90}, {0xD6D8,0x5DB7}, {0xD6D9,0x5DBC},
{0xD6DA,0x5DC9}, {0xD6DB,0x5DCD}, {0xD6DC,0x5DD3}, {0xD6DD,0x5DD2}, {0xD6DE,0x5DD6},
{0xD6DF,0x5DDB}, {0xD6E0,0x5DEB}, {0xD6E1,0x5DF2}, {0xD6E2,0x5DF5}, {0xD6E3,0x5E0B},
{0xD6E4,0x5E1A}, {0xD6E5,0x5E19}, {0xD6E6,0x5E11}, {0xD6E7,0x5E1B}, {0xD6E8,0x5E36},
{0xD6E9,0x5E37}, {0xD6EA,0x5E44}, {0xD6EB,0x5E43}, {0xD6EC,0x5E40}, {0xD6ED,0x5E4E},
{0xD6EE,0x5E57}, {0xD6EF,0x5E54}, {0xD6F0,0x5E5F}, {0xD6F1,0x5E62}, {0xD6F2,0x5E64},
{0xD6F3,0x5E47}, {0xD6F4,0x5E75}, {0xD6F5,0x5E76}, {0xD6F6,0x5E7A}, {0xD6F7,0x9EBC},
{0xD6F8,0x5E7F}, {0xD6F9,0x5EA0}, {0xD6FA,0x5EC1}, {0xD6FB,0x5EC2}, {0xD6FC,0x5EC8},
{0xD6FD,0x5ED0}, {0xD6FE,0x5ECF}, {0xD7A1,0x5ED6}, {0xD7A2,0x5EE3}, {0xD7A3,0x5EDD},
{0xD7A4,0x5EDA}, {0xD7A5,0x5EDB}, {0xD7A6,0x5EE2}, {0xD7A7,0x5EE1}, {0xD7A8,0x5EE8},
{0xD7A9,0x5EE9}, {0xD7AA,0x5EEC}, {0xD7AB,0x5EF1}, {0xD7AC,0x5EF3}, {0xD7AD,0x5EF0},
{0xD7AE,0x5EF4}, {0xD7AF,0x5EF8}, {0xD7B0,0x5EFE}, {0xD7B1,0x5F03}, {0xD7B2,0x5F09},
{0xD7B3,0x5F5D}, {0xD7B4,0x5F5C}, {0xD7B5,0x5F0B}, {0xD7B6,0x5F11}, {0xD7B7,0x5F16},
{0xD7B8,0x5F29}, {0xD7B9,0x5F2D}, {0xD7BA,0x5F38}, {0xD7BB,0x5F41}, {0xD7BC,0x5F48},
{0xD7BD,0x5F4C}, {0xD7BE,0x5F4E}, {0xD7BF,0x5F2F}, {0xD7C0,0x5F51}, {0xD7C1,0x5F56},
{0xD7C2,0x5F57}, {0xD7C3,0x5F59}, {0xD7C4,0x5F61}, {0xD7C5,0x5F6D}, {0xD7C6,0x5F73},
{0xD7C7,0x5F77}, {0xD7C8,0x5F83}, {0xD7C9,0x5F82}, {0xD7CA,0x5F7F}, {0xD7CB,0x5F8A},
{0xD7CC,0x5F88}, {0xD7CD,0x5F91}, {0xD7CE,0x5F87}, {0xD7CF,0x5F9E}, {0xD7D0,0x5F99},
{0xD7D1,0x5F98}, {0xD7D2,0x5FA0}, {0xD7D3,0x5FA8}, {0xD7D4,0x5FAD}, {0xD7D5,0x5FBC},
{0xD7D6,0x5FD6}, {0xD7D7,0x5FFB}, {0xD7D8,0x5FE4}, {0xD7D9,0x5FF8}, {0xD7DA,0x5FF1},
{0xD7DB,0x5FDD}, {0xD7DC,0x60B3}, {0xD7DD,0x5FFF}, {0xD7DE,0x6021}, {0xD7DF,0x6060},
{0xD7E0,0x6019}, {0xD7E1,0x6010}, {0xD7E2,0x6029}, {0xD7E3,0x600E}, {0xD7E4,0x6031},
{0xD7E5,0x601B}, {0xD7E6,0x6015}, {0xD7E7,0x602B}, {0xD7E8,0x6026}, {0xD7E9,0x600F},
{0xD7EA,0x603A}, {0xD7EB,0x605A}, {0xD7EC,0x6041}, {0xD7ED,0x606A}, {0xD7EE,0x6077},
{0xD7EF,0x605F}, {0xD7F0,0x604A}, {0xD7F1,0x6046}, {0xD7F2,0x604D}, {0xD7F3,0x6063},
{0xD7F4,0x6043}, {0xD7F5,0x6064}, {0xD7F6,0x6042}, {0xD7F7,0x606C}, {0xD7F8,0x606B},
{0xD7F9,0x6059}, {0xD7FA,0x6081}, {0xD7FB,0x608D}, {0xD7FC,0x60E7}, {0xD7FD,0x6083},
{0xD7FE,0x609A}, {0xD8A1,0x6084}, {0xD8A2,0x609B}, {0xD8A3,0x6096}, {0xD8A4,0x6097},
{0xD8A5,0x6092}, {0xD8A6,0x60A7}, {0xD8A7,0x608B}, {0xD8A8,0x60E1}, {0xD8A9,0x60B8},
{0xD8AA,0x60E0}, {0xD8AB,0x60D3}, {0xD8AC,0x60B4}, {0xD8AD,0x5FF0}, {0xD8AE,0x60BD},
{0xD8AF,0x60C6}, {0xD8B0,0x60B5}, {0xD8B1,0x60D8}, {0xD8B2,0x614D}, {0xD8B3,0x6115},
{0xD8B4,0x6106}, {0xD8B5,0x60F6}, {0xD8B6,0x60F7}, {0xD8B7,0x6100}, {0xD8B8,0x60F4},
{0xD8B9,0x60FA}, {0xD8BA,0x6103}, {0xD8BB,0x6121}, {0xD8BC,0x60FB}, {0xD8BD,0x60F1},
{0xD8BE,0x610D}, {0xD8BF,0x610E}, {0xD8C0,0x6147}, {0xD8C1,0x613E}, {0xD8C2,0x6128},
{0xD8C3,0x6127}, {0xD8C4,0x614A}, {0xD8C5,0x613F}, {0xD8C6,0x613C}, {0xD8C7,0x612C},
{0xD8C8,0x6134}, {0xD8C9,0x613D}, {0xD8CA,0x6142}, {0xD8CB,0x6144}, {0xD8CC,0x6173},
{0xD8CD,0x6177}, {0xD8CE,0x6158}, {0xD8CF,0x6159}, {0xD8D0,0x615A}, {0xD8D1,0x616B},
{0xD8D2,0x6174}, {0xD8D3,0x616F}, {0xD8D4,0x6165}, {0xD8D5,0x6171}, {0xD8D6,0x615F},
{0xD8D7,0x615D}, {0xD8D8,0x6153}, {0xD8D9,0x6175}, {0xD8DA,0x6199}, {0xD8DB,0x6196},
{0xD8DC,0x6187}, {0xD8DD,0x61AC}, {0xD8DE,0x6194}, {0xD8DF,0x619A}, {0xD8E0,0x618A},
{0xD8E1,0x6191}, {0xD8E2,0x61AB}, {0xD8E3,0x61AE}, {0xD8E4,0x61CC}, {0xD8E5,0x61CA},
{0xD8E6,0x61C9}, {0xD8E7,0x61F7}, {0xD8E8,0x61C8}, {0xD8E9,0x61C3}, {0xD8EA,0x61C6},
{0xD8EB,0x61BA}, {0xD8EC,0x61CB}, {0xD8ED,0x7F79}, {0xD8EE,0x61CD}, {0xD8EF,0x61E6},
{0xD8F0,0x61E3}, {0xD8F1,0x61F6}, {0xD8F2,0x61FA}, {0xD8F3,0x61F4}, {0xD8F4,0x61FF},
{0xD8F5,0x61FD}, {0xD8F6,0x61FC}, {0xD8F7,0x61FE}, {0xD8F8,0x6200}, {0xD8F9,0x6208},
{0xD8FA,0x6209}, {0xD8FB,0x620D}, {0xD8FC,0x620C}, {0xD8FD,0x6214}, {0xD8FE,0x621B},
{0xD9A1,0x621E}, {0xD9A2,0x6221}, {0xD9A3,0x622A}, {0xD9A4,0x622E}, {0xD9A5,0x6230},
{0xD9A6,0x6232}, {0xD9A7,0x6233}, {0xD9A8,0x6241}, {0xD9A9,0x624E}, {0xD9AA,0x625E},
{0xD9AB,0x6263}, {0xD9AC,0x625B}, {0xD9AD,0x6260}, {0xD9AE,0x6268}, {0xD9AF,0x627C},
{0xD9B0,0x6282}, {0xD9B1,0x6289}, {0xD9B2,0x627E}, {0xD9B3,0x6292}, {0xD9B4,0x6293},
{0xD9B5,0x6296}, {0xD9B6,0x62D4}, {0xD9B7,0x6283}, {0xD9B8,0x6294}, {0xD9B9,0x62D7},
{0xD9BA,0x62D1}, {0xD9BB,0x62BB}, {0xD9BC,0x62CF}, {0xD9BD,0x62FF}, {0xD9BE,0x62C6},
{0xD9BF,0x64D4}, {0xD9C0,0x62C8}, {0xD9C1,0x62DC}, {0xD9C2,0x62CC}, {0xD9C3,0x62CA},
{0xD9C4,0x62C2}, {0xD9C5,0x62C7}, {0xD9C6,0x629B}, {0xD9C7,0x62C9}, {0xD9C8,0x630C},
{0xD9C9,0x62EE}, {0xD9CA,0x62F1}, {0xD9CB,0x6327}, {0xD9CC,0x6302}, {0xD9CD,0x6308},
{0xD9CE,0x62EF}, {0xD9CF,0x62F5}, {0xD9D0,0x6350}, {0xD9D1,0x633E}, {0xD9D2,0x634D},
{0xD9D3,0x641C}, {0xD9D4,0x634F}, {0xD9D5,0x6396}, {0xD9D6,0x638E}, {0xD9D7,0x6380},
{0xD9D8,0x63AB}, {0xD9D9,0x6376}, {0xD9DA,0x63A3}, {0xD9DB,0x638F}, {0xD9DC,0x6389},
{0xD9DD,0x639F}, {0xD9DE,0x63B5}, {0xD9DF,0x636B}, {0xD9E0,0x6369}, {0xD9E1,0x63BE},
{0xD9E2,0x63E9}, {0xD9E3,0x63C0}, {0xD9E4,0x63C6}, {0xD9E5,0x63E3}, {0xD9E6,0x63C9},
{0xD9E7,0x63D2}, {0xD9E8,0x63F6}, {0xD9E9,0x63C4}, {0xD9EA,0x6416}, {0xD9EB,0x6434},
{0xD9EC,0x6406}, {0xD9ED,0x6413}, {0xD9EE,0x6426}, {0xD9EF,0x6436}, {0xD9F0,0x651D},
{0xD9F1,0x6417}, {0xD9F2,0x6428}, {0xD9F3,0x640F}, {0xD9F4,0x6467}, {0xD9F5,0x646F},
{0xD9F6,0x6476}, {0xD9F7,0x644E}, {0xD9F8,0x652A}, {0xD9F9,0x6495}, {0xD9FA,0x6493},
{0xD9FB,0x64A5}, {0xD9FC,0x64A9}, {0xD9FD,0x6488}, {0xD9FE,0x64BC}, {0xDAA1,0x64DA},
{0xDAA2,0x64D2}, {0xDAA3,0x64C5}, {0xDAA4,0x64C7}, {0xDAA5,0x64BB}, {0xDAA6,0x64D8},
{0xDAA7,0x64C2}, {0xDAA8,0x64F1}, {0xDAA9,0x64E7}, {0xDAAA,0x8209}, {0xDAAB,0x64E0},
{0xDAAC,0x64E1}, {0xDAAD,0x62AC}, {0xDAAE,0x64E3}, {0xDAAF,0x64EF}, {0xDAB0,0x652C},
{0xDAB1,0x64F6}, {0xDAB2,0x64F4}, {0xDAB3,0x64F2}, {0xDAB4,0x64FA}, {0xDAB5,0x6500},
{0xDAB6,0x64FD}, {0xDAB7,0x6518}, {0xDAB8,0x651C}, {0xDAB9,0x6505}, {0xDABA,0x6524},
{0xDABB,0x6523}, {0xDABC,0x652B}, {0xDABD,0x6534}, {0xDABE,0x6535}, {0xDABF,0x6537},
{0xDAC0,0x6536}, {0xDAC1,0x6538}, {0xDAC2,0x754B}, {0xDAC3,0x6548}, {0xDAC4,0x6556},
{0xDAC5,0x6555}, {0xDAC6,0x654D}, {0xDAC7,0x6558}, {0xDAC8,0x655E}, {0xDAC9,0x655D},
{0xDACA,0x6572}, {0xDACB,0x6578}, {0xDACC,0x6582}, {0xDACD,0x6583}, {0xDACE,0x8B8A},
{0xDACF,0x659B}, {0xDAD0,0x659F}, {0xDAD1,0x65AB}, {0xDAD2,0x65B7}, {0xDAD3,0x65C3},
{0xDAD4,0x65C6}, {0xDAD5,0x65C1}, {0xDAD6,0x65C4}, {0xDAD7,0x65CC}, {0xDAD8,0x65D2},
{0xDAD9,0x65DB}, {0xDADA,0x65D9}, {0xDADB,0x65E0}, {0xDADC,0x65E1}, {0xDADD,0x65F1},
{0xDADE,0x6772}, {0xDADF,0x660A}, {0xDAE0,0x6603}, {0xDAE1,0x65FB}, {0xDAE2,0x6773},
{0xDAE3,0x6635}, {0xDAE4,0x6636}, {0xDAE5,0x6634}, {0xDAE6,0x661C}, {0xDAE7,0x664F},
{0xDAE8,0x6644}, {0xDAE9,0x6649}, {0xDAEA,0x6641}, {0xDAEB,0x665E}, {0xDAEC,0x665D},
{0xDAED,0x6664}, {0xDAEE,0x6667}, {0xDAEF,0x6668}, {0xDAF0,0x665F}, {0xDAF1,0x6662},
{0xDAF2,0x6670}, {0xDAF3,0x6683}, {0xDAF4,0x6688}, {0xDAF5,0x668E}, {0xDAF6,0x6689},
{0xDAF7,0x6684}, {0xDAF8,0x6698}, {0xDAF9,0x669D}, {0xDAFA,0x66C1}, {0xDAFB,0x66B9},
{0xDAFC,0x66C9}, {0xDAFD,0x66BE}, {0xDAFE,0x66BC}, {0xDBA1,0x66C4}, {0xDBA2,0x66B8},
{0xDBA3,0x66D6}, {0xDBA4,0x66DA}, {0xDBA5,0x66E0}, {0xDBA6,0x663F}, {0xDBA7,0x66E6},
{0xDBA8,0x66E9}, {0xDBA9,0x66F0}, {0xDBAA,0x66F5}, {0xDBAB,0x66F7}, {0xDBAC,0x670F},
{0xDBAD,0x6716}, {0xDBAE,0x671E}, {0xDBAF,0x6726}, {0xDBB0,0x6727}, {0xDBB1,0x9738},
{0xDBB2,0x672E}, {0xDBB3,0x673F}, {0xDBB4,0x6736}, {0xDBB5,0x6741}, {0xDBB6,0x6738},
{0xDBB7,0x6737}, {0xDBB8,0x6746}, {0xDBB9,0x675E}, {0xDBBA,0x6760}, {0xDBBB,0x6759},
{0xDBBC,0x6763}, {0xDBBD,0x6764}, {0xDBBE,0x6789}, {0xDBBF,0x6770}, {0xDBC0,0x67A9},
{0xDBC1,0x677C}, {0xDBC2,0x676A}, {0xDBC3,0x678C}, {0xDBC4,0x678B}, {0xDBC5,0x67A6},
{0xDBC6,0x67A1}, {0xDBC7,0x6785}, {0xDBC8,0x67B7}, {0xDBC9,0x67EF}, {0xDBCA,0x67B4},
{0xDBCB,0x67EC}, {0xDBCC,0x67B3}, {0xDBCD,0x67E9}, {0xDBCE,0x67B8}, {0xDBCF,0x67E4},
{0xDBD0,0x67DE}, {0xDBD1,0x67DD}, {0xDBD2,0x67E2}, {0xDBD3,0x67EE}, {0xDBD4,0x67B9},
{0xDBD5,0x67CE}, {0xDBD6,0x67C6}, {0xDBD7,0x67E7}, {0xDBD8,0x6A9C}, {0xDBD9,0x681E},
{0xDBDA,0x6846}, {0xDBDB,0x6829}, {0xDBDC,0x6840}, {0xDBDD,0x684D}, {0xDBDE,0x6832},
{0xDBDF,0x684E}, {0xDBE0,0x68B3}, {0xDBE1,0x682B}, {0xDBE2,0x6859}, {0xDBE3,0x6863},
{0xDBE4,0x6877}, {0xDBE5,0x687F}, {0xDBE6,0x689F}, {0xDBE7,0x688F}, {0xDBE8,0x68AD},
{0xDBE9,0x6894}, {0xDBEA,0x689D}, {0xDBEB,0x689B}, {0xDBEC,0x6883}, {0xDBED,0x6AAE},
{0xDBEE,0x68B9}, {0xDBEF,0x6874}, {0xDBF0,0x68B5}, {0xDBF1,0x68A0}, {0xDBF2,0x68BA},
{0xDBF3,0x690F}, {0xDBF4,0x688D}, {0xDBF5,0x687E}, {0xDBF6,0x6901}, {0xDBF7,0x68CA},
{0xDBF8,0x6908}, {0xDBF9,0x68D8}, {0xDBFA,0x6922}, {0xDBFB,0x6926}, {0xDBFC,0x68E1},
{0xDBFD,0x690C}, {0xDBFE,0x68CD}, {0xDCA1,0x68D4}, {0xDCA2,0x68E7}, {0xDCA3,0x68D5},
{0xDCA4,0x6936}, {0xDCA5,0x6912}, {0xDCA6,0x6904}, {0xDCA7,0x68D7}, {0xDCA8,0x68E3},
{0xDCA9,0x6925}, {0xDCAA,0x68F9}, {0xDCAB,0x68E0}, {0xDCAC,0x68EF}, {0xDCAD,0x6928},
{0xDCAE,0x692A}, {0xDCAF,0x691A}, {0xDCB0,0x6923}, {0xDCB1,0x6921}, {0xDCB2,0x68C6},
{0xDCB3,0x6979}, {0xDCB4,0x6977}, {0xDCB5,0x695C}, {0xDCB6,0x6978}, {0xDCB7,0x696B},
{0xDCB8,0x6954}, {0xDCB9,0x697E}, {0xDCBA,0x696E}, {0xDCBB,0x6939}, {0xDCBC,0x6974},
{0xDCBD,0x693D}, {0xDCBE,0x6959}, {0xDCBF,0x6930}, {0xDCC0,0x6961}, {0xDCC1,0x695E},
{0xDCC2,0x695D}, {0xDCC3,0x6981}, {0xDCC4,0x696A}, {0xDCC5,0x69B2}, {0xDCC6,0x69AE},
{0xDCC7,0x69D0}, {0xDCC8,0x69BF}, {0xDCC9,0x69C1}, {0xDCCA,0x69D3}, {0xDCCB,0x69BE},
{0xDCCC,0x69CE}, {0xDCCD,0x5BE8}, {0xDCCE,0x69CA}, {0xDCCF,0x69DD}, {0xDCD0,0x69BB},
{0xDCD1,0x69C3}, {0xDCD2,0x69A7}, {0xDCD3,0x6A2E}, {0xDCD4,0x6991}, {0xDCD5,0x69A0},
{0xDCD6,0x699C}, {0xDCD7,0x6995}, {0xDCD8,0x69B4}, {0xDCD9,0x69DE}, {0xDCDA,0x69E8},
{0xDCDB,0x6A02}, {0xDCDC,0x6A1B}, {0xDCDD,0x69FF}, {0xDCDE,0x6B0A}, {0xDCDF,0x69F9},
{0xDCE0,0x69F2}, {0xDCE1,0x69E7}, {0xDCE2,0x6A05}, {0xDCE3,0x69B1}, {0xDCE4,0x6A1E},
{0xDCE5,0x69ED}, {0xDCE6,0x6A14}, {0xDCE7,0x69EB}, {0xDCE8,0x6A0A}, {0xDCE9,0x6A12},
{0xDCEA,0x6AC1}, {0xDCEB,0x6A23}, {0xDCEC,0x6A13}, {0xDCED,0x6A44}, {0xDCEE,0x6A0C},
{0xDCEF,0x6A72}, {0xDCF0,0x6A36}, {0xDCF1,0x6A78}, {0xDCF2,0x6A47}, {0xDCF3,0x6A62},
{0xDCF4,0x6A59}, {0xDCF5,0x6A66}, {0xDCF6,0x6A48}, {0xDCF7,0x6A38}, {0xDCF8,0x6A22},
{0xDCF9,0x6A90}, {0xDCFA,0x6A8D}, {0xDCFB,0x6AA0}, {0xDCFC,0x6A84}, {0xDCFD,0x6AA2},
{0xDCFE,0x6AA3}, {0xDDA1,0x6A97}, {0xDDA2,0x8617}, {0xDDA3,0x6ABB}, {0xDDA4,0x6AC3},
{0xDDA5,0x6AC2}, {0xDDA6,0x6AB8}, {0xDDA7,0x6AB3}, {0xDDA8,0x6AAC}, {0xDDA9,0x6ADE},
{0xDDAA,0x6AD1}, {0xDDAB,0x6ADF}, {0xDDAC,0x6AAA}, {0xDDAD,0x6ADA}, {0xDDAE,0x6AEA},
{0xDDAF,0x6AFB}, {0xDDB0,0x6B05}, {0xDDB1,0x8616}, {0xDDB2,0x6AFA}, {0xDDB3,0x6B12},
{0xDDB4,0x6B16}, {0xDDB5,0x9B31}, {0xDDB6,0x6B1F}, {0xDDB7,0x6B38}, {0xDDB8,0x6B37},
{0xDDB9,0x76DC}, {0xDDBA,0x6B39}, {0xDDBB,0x98EE}, {0xDDBC,0x6B47}, {0xDDBD,0x6B43},
{0xDDBE,0x6B49}, {0xDDBF,0x6B50}, {0xDDC0,0x6B59}, {0xDDC1,0x6B54}, {0xDDC2,0x6B5B},
{0xDDC3,0x6B5F}, {0xDDC4,0x6B61}, {0xDDC5,0x6B78}, {0xDDC6,0x6B79}, {0xDDC7,0x6B7F},
{0xDDC8,0x6B80}, {0xDDC9,0x6B84}, {0xDDCA,0x6B83}, {0xDDCB,0x6B8D}, {0xDDCC,0x6B98},
{0xDDCD,0x6B95}, {0xDDCE,0x6B9E}, {0xDDCF,0x6BA4}, {0xDDD0,0x6BAA}, {0xDDD1,0x6BAB},
{0xDDD2,0x6BAF}, {0xDDD3,0x6BB2}, {0xDDD4,0x6BB1}, {0xDDD5,0x6BB3}, {0xDDD6,0x6BB7},
{0xDDD7,0x6BBC}, {0xDDD8,0x6BC6}, {0xDDD9,0x6BCB}, {0xDDDA,0x6BD3}, {0xDDDB,0x6BDF},
{0xDDDC,0x6BEC}, {0xDDDD,0x6BEB}, {0xDDDE,0x6BF3}, {0xDDDF,0x6BEF}, {0xDDE0,0x9EBE},
{0xDDE1,0x6C08}, {0xDDE2,0x6C13}, {0xDDE3,0x6C14}, {0xDDE4,0x6C1B}, {0xDDE5,0x6C24},
{0xDDE6,0x6C23}, {0xDDE7,0x6C5E}, {0xDDE8,0x6C55}, {0xDDE9,0x6C62}, {0xDDEA,0x6C6A},
{0xDDEB,0x6C82}, {0xDDEC,0x6C8D}, {0xDDED,0x6C9A}, {0xDDEE,0x6C81}, {0xDDEF,0x6C9B},
{0xDDF0,0x6C7E}, {0xDDF1,0x6C68}, {0xDDF2,0x6C73}, {0xDDF3,0x6C92}, {0xDDF4,0x6C90},
{0xDDF5,0x6CC4}, {0xDDF6,0x6CF1}, {0xDDF7,0x6CD3}, {0xDDF8,0x6CBD}, {0xDDF9,0x6CD7},
{0xDDFA,0x6CC5}, {0xDDFB,0x6CDD}, {0xDDFC,0x6CAE}, {0xDDFD,0x6CB1}, {0xDDFE,0x6CBE},
{0xDEA1,0x6CBA}, {0xDEA2,0x6CDB}, {0xDEA3,0x6CEF}, {0xDEA4,0x6CD9}, {0xDEA5,0x6CEA},
{0xDEA6,0x6D1F}, {0xDEA7,0x884D}, {0xDEA8,0x6D36}, {0xDEA9,0x6D2B}, {0xDEAA,0x6D3D},
{0xDEAB,0x6D38}, {0xDEAC,0x6D19}, {0xDEAD,0x6D35}, {0xDEAE,0x6D33}, {0xDEAF,0x6D12},
{0xDEB0,0x6D0C}, {0xDEB1,0x6D63}, {0xDEB2,0x6D93}, {0xDEB3,0x6D64}, {0xDEB4,0x6D5A},
{0xDEB5,0x6D79}, {0xDEB6,0x6D59}, {0xDEB7,0x6D8E}, {0xDEB8,0x6D95}, {0xDEB9,0x6FE4},
{0xDEBA,0x6D85}, {0xDEBB,0x6DF9}, {0xDEBC,0x6E15}, {0xDEBD,0x6E0A}, {0xDEBE,0x6DB5},
{0xDEBF,0x6DC7}, {0xDEC0,0x6DE6}, {0xDEC1,0x6DB8}, {0xDEC2,0x6DC6}, {0xDEC3,0x6DEC},
{0xDEC4,0x6DDE}, {0xDEC5,0x6DCC}, {0xDEC6,0x6DE8}, {0xDEC7,0x6DD2}, {0xDEC8,0x6DC5},
{0xDEC9,0x6DFA}, {0xDECA,0x6DD9}, {0xDECB,0x6DE4}, {0xDECC,0x6DD5}, {0xDECD,0x6DEA},
{0xDECE,0x6DEE}, {0xDECF,0x6E2D}, {0xDED0,0x6E6E}, {0xDED1,0x6E2E}, {0xDED2,0x6E19},
{0xDED3,0x6E72}, {0xDED4,0x6E5F}, {0xDED5,0x6E3E}, {0xDED6,0x6E23}, {0xDED7,0x6E6B},
{0xDED8,0x6E2B}, {0xDED9,0x6E76}, {0xDEDA,0x6E4D}, {0xDEDB,0x6E1F}, {0xDEDC,0x6E43},
{0xDEDD,0x6E3A}, {0xDEDE,0x6E4E}, {0xDEDF,0x6E24}, {0xDEE0,0x6EFF}, {0xDEE1,0x6E1D},
{0xDEE2,0x6E38}, {0xDEE3,0x6E82}, {0xDEE4,0x6EAA}, {0xDEE5,0x6E98}, {0xDEE6,0x6EC9},
{0xDEE7,0x6EB7}, {0xDEE8,0x6ED3}, {0xDEE9,0x6EBD}, {0xDEEA,0x6EAF}, {0xDEEB,0x6EC4},
{0xDEEC,0x6EB2}, {0xDEED,0x6ED4}, {0xDEEE,0x6ED5}, {0xDEEF,0x6E8F}, {0xDEF0,0x6EA5},
{0xDEF1,0x6EC2}, {0xDEF2,0x6E9F}, {0xDEF3,0x6F41}, {0xDEF4,0x6F11}, {0xDEF5,0x704C},
{0xDEF6,0x6EEC}, {0xDEF7,0x6EF8}, {0xDEF8,0x6EFE}, {0xDEF9,0x6F3F}, {0xDEFA,0x6EF2},
{0xDEFB,0x6F31}, {0xDEFC,0x6EEF}, {0xDEFD,0x6F32}, {0xDEFE,0x6ECC}, {0xDFA1,0x6F3E},
{0xDFA2,0x6F13}, {0xDFA3,0x6EF7}, {0xDFA4,0x6F86}, {0xDFA5,0x6F7A}, {0xDFA6,0x6F78},
{0xDFA7,0x6F81}, {0xDFA8,0x6F80}, {0xDFA9,0x6F6F}, {0xDFAA,0x6F5B}, {0xDFAB,0x6FF3},
{0xDFAC,0x6F6D}, {0xDFAD,0x6F82}, {0xDFAE,0x6F7C}, {0xDFAF,0x6F58}, {0xDFB0,0x6F8E},
{0xDFB1,0x6F91}, {0xDFB2,0x6FC2}, {0xDFB3,0x6F66}, {0xDFB4,0x6FB3}, {0xDFB5,0x6FA3},
{0xDFB6,0x6FA1}, {0xDFB7,0x6FA4}, {0xDFB8,0x6FB9}, {0xDFB9,0x6FC6}, {0xDFBA,0x6FAA},
{0xDFBB,0x6FDF}, {0xDFBC,0x6FD5}, {0xDFBD,0x6FEC}, {0xDFBE,0x6FD4}, {0xDFBF,0x6FD8},
{0xDFC0,0x6FF1}, {0xDFC1,0x6FEE}, {0xDFC2,0x6FDB}, {0xDFC3,0x7009}, {0xDFC4,0x700B},
{0xDFC5,0x6FFA}, {0xDFC6,0x7011}, {0xDFC7,0x7001}, {0xDFC8,0x700F}, {0xDFC9,0x6FFE},
{0xDFCA,0x701B}, {0xDFCB,0x701A}, {0xDFCC,0x6F74}, {0xDFCD,0x701D}, {0xDFCE,0x7018},
{0xDFCF,0x701F}, {0xDFD0,0x7030}, {0xDFD1,0x703E}, {0xDFD2,0x7032}, {0xDFD3,0x7051},
{0xDFD4,0x7063}, {0xDFD5,0x7099}, {0xDFD6,0x7092}, {0xDFD7,0x70AF}, {0xDFD8,0x70F1},
{0xDFD9,0x70AC}, {0xDFDA,0x70B8}, {0xDFDB,0x70B3}, {0xDFDC,0x70AE}, {0xDFDD,0x70DF},
{0xDFDE,0x70CB}, {0xDFDF,0x70DD}, {0xDFE0,0x70D9}, {0xDFE1,0x7109}, {0xDFE2,0x70FD},
{0xDFE3,0x711C}, {0xDFE4,0x7119}, {0xDFE5,0x7165}, {0xDFE6,0x7155}, {0xDFE7,0x7188},
{0xDFE8,0x7166}, {0xDFE9,0x7162}, {0xDFEA,0x714C}, {0xDFEB,0x7156}, {0xDFEC,0x716C},
{0xDFED,0x718F}, {0xDFEE,0x71FB}, {0xDFEF,0x7184}, {0xDFF0,0x7195}, {0xDFF1,0x71A8},
{0xDFF2,0x71AC}, {0xDFF3,0x71D7}, {0xDFF4,0x71B9}, {0xDFF5,0x71BE}, {0xDFF6,0x71D2},
{0xDFF7,0x71C9}, {0xDFF8,0x71D4}, {0xDFF9,0x71CE}, {0xDFFA,0x71E0}, {0xDFFB,0x71EC},
{0xDFFC,0x71E7}, {0xDFFD,0x71F5}, {0xDFFE,0x71FC}, {0xE0A1,0x71F9}, {0xE0A2,0x71FF},
{0xE0A3,0x720D}, {0xE0A4,0x7210}, {0xE0A5,0x721B}, {0xE0A6,0x7228}, {0xE0A7,0x722D},
{0xE0A8,0x722C}, {0xE0A9,0x7230}, {0xE0AA,0x7232}, {0xE0AB,0x723B}, {0xE0AC,0x723C},
{0xE0AD,0x723F}, {0xE0AE,0x7240}, {0xE0AF,0x7246}, {0xE0B0,0x724B}, {0xE0B1,0x7258},
{0xE0B2,0x7274}, {0xE0B3,0x727E}, {0xE0B4,0x7282}, {0xE0B5,0x7281}, {0xE0B6,0x7287},
{0xE0B7,0x7292}, {0xE0B8,0x7296}, {0xE0B9,0x72A2}, {0xE0BA,0x72A7}, {0xE0BB,0x72B9},
{0xE0BC,0x72B2}, {0xE0BD,0x72C3}, {0xE0BE,0x72C6}, {0xE0BF,0x72C4}, {0xE0C0,0x72CE},
{0xE0C1,0x72D2}, {0xE0C2,0x72E2}, {0xE0C3,0x72E0}, {0xE0C4,0x72E1}, {0xE0C5,0x72F9},
{0xE0C6,0x72F7}, {0xE0C7,0x500F}, {0xE0C8,0x7317}, {0xE0C9,0x730A}, {0xE0CA,0x731C},
{0xE0CB,0x7316}, {0xE0CC,0x731D}, {0xE0CD,0x7334}, {0xE0CE,0x732F}, {0xE0CF,0x7329},
{0xE0D0,0x7325}, {0xE0D1,0x733E}, {0xE0D2,0x734E}, {0xE0D3,0x734F}, {0xE0D4,0x9ED8},
{0xE0D5,0x7357}, {0xE0D6,0x736A}, {0xE0D7,0x7368}, {0xE0D8,0x7370}, {0xE0D9,0x7378},
{0xE0DA,0x7375}, {0xE0DB,0x737B}, {0xE0DC,0x737A}, {0xE0DD,0x73C8}, {0xE0DE,0x73B3},
{0xE0DF,0x73CE}, {0xE0E0,0x73BB}, {0xE0E1,0x73C0}, {0xE0E2,0x73E5}, {0xE0E3,0x73EE},
{0xE0E4,0x73DE}, {0xE0E5,0x74A2}, {0xE0E6,0x7405}, {0xE0E7,0x746F}, {0xE0E8,0x7425},
{0xE0E9,0x73F8}, {0xE0EA,0x7432}, {0xE0EB,0x743A}, {0xE0EC,0x7455}, {0xE0ED,0x743F},
{0xE0EE,0x745F}, {0xE0EF,0x7459}, {0xE0F0,0x7441}, {0xE0F1,0x745C}, {0xE0F2,0x7469},
{0xE0F3,0x7470}, {0xE0F4,0x7463}, {0xE0F5,0x746A}, {0xE0F6,0x7476}, {0xE0F7,0x747E},
{0xE0F8,0x748B}, {0xE0F9,0x749E}, {0xE0FA,0x74A7}, {0xE0FB,0x74CA}, {0xE0FC,0x74CF},
{0xE0FD,0x74D4}, {0xE0FE,0x73F1}, {0xE1A1,0x74E0}, {0xE1A2,0x74E3}, {0xE1A3,0x74E7},
{0xE1A4,0x74E9}, {0xE1A5,0x74EE}, {0xE1A6,0x74F2}, {0xE1A7,0x74F0}, {0xE1A8,0x74F1},
{0xE1A9,0x74F8}, {0xE1AA,0x74F7}, {0xE1AB,0x7504}, {0xE1AC,0x7503}, {0xE1AD,0x7505},
{0xE1AE,0x750C}, {0xE1AF,0x750E}, {0xE1B0,0x750D}, {0xE1B1,0x7515}, {0xE1B2,0x7513},
{0xE1B3,0x751E}, {0xE1B4,0x7526}, {0xE1B5,0x752C}, {0xE1B6,0x753C}, {0xE1B7,0x7544},
{0xE1B8,0x754D}, {0xE1B9,0x754A}, {0xE1BA,0x7549}, {0xE1BB,0x755B}, {0xE1BC,0x7546},
{0xE1BD,0x755A}, {0xE1BE,0x7569}, {0xE1BF,0x7564}, {0xE1C0,0x7567}, {0xE1C1,0x756B},
{0xE1C2,0x756D}, {0xE1C3,0x7578}, {0xE1C4,0x7576}, {0xE1C5,0x7586}, {0xE1C6,0x7587},
{0xE1C7,0x7574}, {0xE1C8,0x758A}, {0xE1C9,0x7589}, {0xE1CA,0x7582}, {0xE1CB,0x7594},
{0xE1CC,0x759A}, {0xE1CD,0x759D}, {0xE1CE,0x75A5}, {0xE1CF,0x75A3}, {0xE1D0,0x75C2},
{0xE1D1,0x75B3}, {0xE1D2,0x75C3}, {0xE1D3,0x75B5}, {0xE1D4,0x75BD}, {0xE1D5,0x75B8},
{0xE1D6,0x75BC}, {0xE1D7,0x75B1}, {0xE1D8,0x75CD}, {0xE1D9,0x75CA}, {0xE1DA,0x75D2},
{0xE1DB,0x75D9}, {0xE1DC,0x75E3}, {0xE1DD,0x75DE}, {0xE1DE,0x75FE}, {0xE1DF,0x75FF},
{0xE1E0,0x75FC}, {0xE1E1,0x7601}, {0xE1E2,0x75F0}, {0xE1E3,0x75FA}, {0xE1E4,0x75F2},
{0xE1E5,0x75F3}, {0xE1E6,0x760B}, {0xE1E7,0x760D}, {0xE1E8,0x7609}, {0xE1E9,0x761F},
{0xE1EA,0x7627}, {0xE1EB,0x7620}, {0xE1EC,0x7621}, {0xE1ED,0x7622}, {0xE1EE,0x7624},
{0xE1EF,0x7634}, {0xE1F0,0x7630}, {0xE1F1,0x763B}, {0xE1F2,0x7647}, {0xE1F3,0x7648},
{0xE1F4,0x7646}, {0xE1F5,0x765C}, {0xE1F6,0x7658}, {0xE1F7,0x7661}, {0xE1F8,0x7662},
{0xE1F9,0x7668}, {0xE1FA,0x7669}, {0xE1FB,0x766A}, {0xE1FC,0x7667}, {0xE1FD,0x766C},
{0xE1FE,0x7670}, {0xE2A1,0x7672}, {0xE2A2,0x7676}, {0xE2A3,0x7678}, {0xE2A4,0x767C},
{0xE2A5,0x7680}, {0xE2A6,0x7683}, {0xE2A7,0x7688}, {0xE2A8,0x768B}, {0xE2A9,0x768E},
{0xE2AA,0x7696}, {0xE2AB,0x7693}, {0xE2AC,0x7699}, {0xE2AD,0x769A}, {0xE2AE,0x76B0},
{0xE2AF,0x76B4}, {0xE2B0,0x76B8}, {0xE2B1,0x76B9}, {0xE2B2,0x76BA}, {0xE2B3,0x76C2},
{0xE2B4,0x76CD}, {0xE2B5,0x76D6}, {0xE2B6,0x76D2}, {0xE2B7,0x76DE}, {0xE2B8,0x76E1},
{0xE2B9,0x76E5}, {0xE2BA,0x76E7}, {0xE2BB,0x76EA}, {0xE2BC,0x862F}, {0xE2BD,0x76FB},
{0xE2BE,0x7708}, {0xE2BF,0x7707}, {0xE2C0,0x7704}, {0xE2C1,0x7729}, {0xE2C2,0x7724},
{0xE2C3,0x771E}, {0xE2C4,0x7725}, {0xE2C5,0x7726}, {0xE2C6,0x771B}, {0xE2C7,0x7737},
{0xE2C8,0x7738}, {0xE2C9,0x7747}, {0xE2CA,0x775A}, {0xE2CB,0x7768}, {0xE2CC,0x776B},
{0xE2CD,0x775B}, {0xE2CE,0x7765}, {0xE2CF,0x777F}, {0xE2D0,0x777E}, {0xE2D1,0x7779},
{0xE2D2,0x778E}, {0xE2D3,0x778B}, {0xE2D4,0x7791}, {0xE2D5,0x77A0}, {0xE2D6,0x779E},
{0xE2D7,0x77B0}, {0xE2D8,0x77B6}, {0xE2D9,0x77B9}, {0xE2DA,0x77BF}, {0xE2DB,0x77BC},
{0xE2DC,0x77BD}, {0xE2DD,0x77BB}, {0xE2DE,0x77C7}, {0xE2DF,0x77CD}, {0xE2E0,0x77D7},
{0xE2E1,0x77DA}, {0xE2E2,0x77DC}, {0xE2E3,0x77E3}, {0xE2E4,0x77EE}, {0xE2E5,0x77FC},
{0xE2E6,0x780C}, {0xE2E7,0x7812}, {0xE2E8,0x7926}, {0xE2E9,0x7820}, {0xE2EA,0x792A},
{0xE2EB,0x7845}, {0xE2EC,0x788E}, {0xE2ED,0x7874}, {0xE2EE,0x7886}, {0xE2EF,0x787C},
{0xE2F0,0x789A}, {0xE2F1,0x788C}, {0xE2F2,0x78A3}, {0xE2F3,0x78B5}, {0xE2F4,0x78AA},
{0xE2F5,0x78AF}, {0xE2F6,0x78D1}, {0xE2F7,0x78C6}, {0xE2F8,0x78CB}, {0xE2F9,0x78D4},
{0xE2FA,0x78BE}, {0xE2FB,0x78BC}, {0xE2FC,0x78C5}, {0xE2FD,0x78CA}, {0xE2FE,0x78EC},
{0xE3A1,0x78E7}, {0xE3A2,0x78DA}, {0xE3A3,0x78FD}, {0xE3A4,0x78F4}, {0xE3A5,0x7907},
{0xE3A6,0x7912}, {0xE3A7,0x7911}, {0xE3A8,0x7919}, {0xE3A9,0x792C}, {0xE3AA,0x792B},
{0xE3AB,0x7940}, {0xE3AC,0x7960}, {0xE3AD,0x7957}, {0xE3AE,0x795F}, {0xE3AF,0x795A},
{0xE3B0,0x7955}, {0xE3B1,0x7953}, {0xE3B2,0x797A}, {0xE3B3,0x797F}, {0xE3B4,0x798A},
{0xE3B5,0x799D}, {0xE3B6,0x79A7}, {0xE3B7,0x9F4B}, {0xE3B8,0x79AA}, {0xE3B9,0x79AE},
{0xE3BA,0x79B3}, {0xE3BB,0x79B9}, {0xE3BC,0x79BA}, {0xE3BD,0x79C9}, {0xE3BE,0x79D5},
{0xE3BF,0x79E7}, {0xE3C0,0x79EC}, {0xE3C1,0x79E1}, {0xE3C2,0x79E3}, {0xE3C3,0x7A08},
{0xE3C4,0x7A0D}, {0xE3C5,0x7A18}, {0xE3C6,0x7A19}, {0xE3C7,0x7A20}, {0xE3C8,0x7A1F},
{0xE3C9,0x7980}, {0xE3CA,0x7A31}, {0xE3CB,0x7A3B}, {0xE3CC,0x7A3E}, {0xE3CD,0x7A37},
{0xE3CE,0x7A43}, {0xE3CF,0x7A57}, {0xE3D0,0x7A49}, {0xE3D1,0x7A61}, {0xE3D2,0x7A62},
{0xE3D3,0x7A69}, {0xE3D4,0x9F9D}, {0xE3D5,0x7A70}, {0xE3D6,0x7A79}, {0xE3D7,0x7A7D},
{0xE3D8,0x7A88}, {0xE3D9,0x7A97}, {0xE3DA,0x7A95}, {0xE3DB,0x7A98}, {0xE3DC,0x7A96},
{0xE3DD,0x7AA9}, {0xE3DE,0x7AC8}, {0xE3DF,0x7AB0}, {0xE3E0,0x7AB6}, {0xE3E1,0x7AC5},
{0xE3E2,0x7AC4}, {0xE3E3,0x7ABF}, {0xE3E4,0x9083}, {0xE3E5,0x7AC7}, {0xE3E6,0x7ACA},
{0xE3E7,0x7ACD}, {0xE3E8,0x7ACF}, {0xE3E9,0x7AD5}, {0xE3EA,0x7AD3}, {0xE3EB,0x7AD9},
{0xE3EC,0x7ADA}, {0xE3ED,0x7ADD}, {0xE3EE,0x7AE1}, {0xE3EF,0x7AE2}, {0xE3F0,0x7AE6},
{0xE3F1,0x7AED}, {0xE3F2,0x7AF0}, {0xE3F3,0x7B02}, {0xE3F4,0x7B0F}, {0xE3F5,0x7B0A},
{0xE3F6,0x7B06}, {0xE3F7,0x7B33}, {0xE3F8,0x7B18}, {0xE3F9,0x7B19}, {0xE3FA,0x7B1E},
{0xE3FB,0x7B35}, {0xE3FC,0x7B28}, {0xE3FD,0x7B36}, {0xE3FE,0x7B50}, {0xE4A1,0x7B7A},
{0xE4A2,0x7B04}, {0xE4A3,0x7B4D}, {0xE4A4,0x7B0B}, {0xE4A5,0x7B4C}, {0xE4A6,0x7B45},
{0xE4A7,0x7B75}, {0xE4A8,0x7B65}, {0xE4A9,0x7B74}, {0xE4AA,0x7B67}, {0xE4AB,0x7B70},
{0xE4AC,0x7B71}, {0xE4AD,0x7B6C}, {0xE4AE,0x7B6E}, {0xE4AF,0x7B9D}, {0xE4B0,0x7B98},
{0xE4B1,0x7B9F}, {0xE4B2,0x7B8D}, {0xE4B3,0x7B9C}, {0xE4B4,0x7B9A}, {0xE4B5,0x7B8B},
{0xE4B6,0x7B92}, {0xE4B7,0x7B8F}, {0xE4B8,0x7B5D}, {0xE4B9,0x7B99}, {0xE4BA,0x7BCB},
{0xE4BB,0x7BC1}, {0xE4BC,0x7BCC}, {0xE4BD,0x7BCF}, {0xE4BE,0x7BB4}, {0xE4BF,0x7BC6},
{0xE4C0,0x7BDD}, {0xE4C1,0x7BE9}, {0xE4C2,0x7C11}, {0xE4C3,0x7C14}, {0xE4C4,0x7BE6},
{0xE4C5,0x7BE5}, {0xE4C6,0x7C60}, {0xE4C7,0x7C00}, {0xE4C8,0x7C07}, {0xE4C9,0x7C13},
{0xE4CA,0x7BF3}, {0xE4CB,0x7BF7}, {0xE4CC,0x7C17}, {0xE4CD,0x7C0D}, {0xE4CE,0x7BF6},
{0xE4CF,0x7C23}, {0xE4D0,0x7C27}, {0xE4D1,0x7C2A}, {0xE4D2,0x7C1F}, {0xE4D3,0x7C37},
{0xE4D4,0x7C2B}, {0xE4D5,0x7C3D}, {0xE4D6,0x7C4C}, {0xE4D7,0x7C43}, {0xE4D8,0x7C54},
{0xE4D9,0x7C4F}, {0xE4DA,0x7C40}, {0xE4DB,0x7C50}, {0xE4DC,0x7C58}, {0xE4DD,0x7C5F},
{0xE4DE,0x7C64}, {0xE4DF,0x7C56}, {0xE4E0,0x7C65}, {0xE4E1,0x7C6C}, {0xE4E2,0x7C75},
{0xE4E3,0x7C83}, {0xE4E4,0x7C90}, {0xE4E5,0x7CA4}, {0xE4E6,0x7CAD}, {0xE4E7,0x7CA2},
{0xE4E8,0x7CAB}, {0xE4E9,0x7CA1}, {0xE4EA,0x7CA8}, {0xE4EB,0x7CB3}, {0xE4EC,0x7CB2},
{0xE4ED,0x7CB1}, {0xE4EE,0x7CAE}, {0xE4EF,0x7CB9}, {0xE4F0,0x7CBD}, {0xE4F1,0x7CC0},
{0xE4F2,0x7CC5}, {0xE4F3,0x7CC2}, {0xE4F4,0x7CD8}, {0xE4F5,0x7CD2}, {0xE4F6,0x7CDC},
{0xE4F7,0x7CE2}, {0xE4F8,0x9B3B}, {0xE4F9,0x7CEF}, {0xE4FA,0x7CF2}, {0xE4FB,0x7CF4},
{0xE4FC,0x7CF6}, {0xE4FD,0x7CFA}, {0xE4FE,0x7D06}, {0xE5A1,0x7D02}, {0xE5A2,0x7D1C},
{0xE5A3,0x7D15}, {0xE5A4,0x7D0A}, {0xE5A5,0x7D45}, {0xE5A6,0x7D4B}, {0xE5A7,0x7D2E},
{0xE5A8,0x7D32}, {0xE5A9,0x7D3F}, {0xE5AA,0x7D35}, {0xE5AB,0x7D46}, {0xE5AC,0x7D73},
{0xE5AD,0x7D56}, {0xE5AE,0x7D4E}, {0xE5AF,0x7D72}, {0xE5B0,0x7D68}, {0xE5B1,0x7D6E},
{0xE5B2,0x7D4F}, {0xE5B3,0x7D63}, {0xE5B4,0x7D93}, {0xE5B5,0x7D89}, {0xE5B6,0x7D5B},
{0xE5B7,0x7D8F}, {0xE5B8,0x7D7D}, {0xE5B9,0x7D9B}, {0xE5BA,0x7DBA}, {0xE5BB,0x7DAE},
{0xE5BC,0x7DA3}, {0xE5BD,0x7DB5}, {0xE5BE,0x7DC7}, {0xE5BF,0x7DBD}, {0xE5C0,0x7DAB},
{0xE5C1,0x7E3D}, {0xE5C2,0x7DA2}, {0xE5C3,0x7DAF}, {0xE5C4,0x7DDC}, {0xE5C5,0x7DB8},
{0xE5C6,0x7D9F}, {0xE5C7,0x7DB0}, {0xE5C8,0x7DD8}, {0xE5C9,0x7DDD}, {0xE5CA,0x7DE4},
{0xE5CB,0x7DDE}, {0xE5CC,0x7DFB}, {0xE5CD,0x7DF2}, {0xE5CE,0x7DE1}, {0xE5CF,0x7E05},
{0xE5D0,0x7E0A}, {0xE5D1,0x7E23}, {0xE5D2,0x7E21}, {0xE5D3,0x7E12}, {0xE5D4,0x7E31},
{0xE5D5,0x7E1F}, {0xE5D6,0x7E09}, {0xE5D7,0x7E0B}, {0xE5D8,0x7E22}, {0xE5D9,0x7E46},
{0xE5DA,0x7E66}, {0xE5DB,0x7E3B}, {0xE5DC,0x7E35}, {0xE5DD,0x7E39}, {0xE5DE,0x7E43},
{0xE5DF,0x7E37}, {0xE5E0,0x7E32}, {0xE5E1,0x7E3A}, {0xE5E2,0x7E67}, {0xE5E3,0x7E5D},
{0xE5E4,0x7E56}, {0xE5E5,0x7E5E}, {0xE5E6,0x7E59}, {0xE5E7,0x7E5A}, {0xE5E8,0x7E79},
{0xE5E9,0x7E6A}, {0xE5EA,0x7E69}, {0xE5EB,0x7E7C}, {0xE5EC,0x7E7B}, {0xE5ED,0x7E83},
{0xE5EE,0x7DD5}, {0xE5EF,0x7E7D}, {0xE5F0,0x8FAE}, {0xE5F1,0x7E7F}, {0xE5F2,0x7E88},
{0xE5F3,0x7E89}, {0xE5F4,0x7E8C}, {0xE5F5,0x7E92}, {0xE5F6,0x7E90}, {0xE5F7,0x7E93},
{0xE5F8,0x7E94}, {0xE5F9,0x7E96}, {0xE5FA,0x7E8E}, {0xE5FB,0x7E9B}, {0xE5FC,0x7E9C},
{0xE5FD,0x7F38}, {0xE5FE,0x7F3A}, {0xE6A1,0x7F45}, {0xE6A2,0x7F4C}, {0xE6A3,0x7F4D},
{0xE6A4,0x7F4E}, {0xE6A5,0x7F50}, {0xE6A6,0x7F51}, {0xE6A7,0x7F55}, {0xE6A8,0x7F54},
{0xE6A9,0x7F58}, {0xE6AA,0x7F5F}, {0xE6AB,0x7F60}, {0xE6AC,0x7F68}, {0xE6AD,0x7F69},
{0xE6AE,0x7F67}, {0xE6AF,0x7F78}, {0xE6B0,0x7F82}, {0xE6B1,0x7F86}, {0xE6B2,0x7F83},
{0xE6B3,0x7F88}, {0xE6B4,0x7F87}, {0xE6B5,0x7F8C}, {0xE6B6,0x7F94}, {0xE6B7,0x7F9E},
{0xE6B8,0x7F9D}, {0xE6B9,0x7F9A}, {0xE6BA,0x7FA3}, {0xE6BB,0x7FAF}, {0xE6BC,0x7FB2},
{0xE6BD,0x7FB9}, {0xE6BE,0x7FAE}, {0xE6BF,0x7FB6}, {0xE6C0,0x7FB8}, {0xE6C1,0x8B71},
{0xE6C2,0x7FC5}, {0xE6C3,0x7FC6}, {0xE6C4,0x7FCA}, {0xE6C5,0x7FD5}, {0xE6C6,0x7FD4},
{0xE6C7,0x7FE1}, {0xE6C8,0x7FE6}, {0xE6C9,0x7FE9}, {0xE6CA,0x7FF3}, {0xE6CB,0x7FF9},
{0xE6CC,0x98DC}, {0xE6CD,0x8006}, {0xE6CE,0x8004}, {0xE6CF,0x800B}, {0xE6D0,0x8012},
{0xE6D1,0x8018}, {0xE6D2,0x8019}, {0xE6D3,0x801C}, {0xE6D4,0x8021}, {0xE6D5,0x8028},
{0xE6D6,0x803F}, {0xE6D7,0x803B}, {0xE6D8,0x804A}, {0xE6D9,0x8046}, {0xE6DA,0x8052},
{0xE6DB,0x8058}, {0xE6DC,0x805A}, {0xE6DD,0x805F}, {0xE6DE,0x8062}, {0xE6DF,0x8068},
{0xE6E0,0x8073}, {0xE6E1,0x8072}, {0xE6E2,0x8070}, {0xE6E3,0x8076}, {0xE6E4,0x8079},
{0xE6E5,0x807D}, {0xE6E6,0x807F}, {0xE6E7,0x8084}, {0xE6E8,0x8086}, {0xE6E9,0x8085},
{0xE6EA,0x809B}, {0xE6EB,0x8093}, {0xE6EC,0x809A}, {0xE6ED,0x80AD}, {0xE6EE,0x5190},
{0xE6EF,0x80AC}, {0xE6F0,0x80DB}, {0xE6F1,0x80E5}, {0xE6F2,0x80D9}, {0xE6F3,0x80DD},
{0xE6F4,0x80C4}, {0xE6F5,0x80DA}, {0xE6F6,0x80D6}, {0xE6F7,0x8109}, {0xE6F8,0x80EF},
{0xE6F9,0x80F1}, {0xE6FA,0x811B}, {0xE6FB,0x8129}, {0xE6FC,0x8123}, {0xE6FD,0x812F},
{0xE6FE,0x814B}, {0xE7A1,0x968B}, {0xE7A2,0x8146}, {0xE7A3,0x813E}, {0xE7A4,0x8153},
{0xE7A5,0x8151}, {0xE7A6,0x80FC}, {0xE7A7,0x8171}, {0xE7A8,0x816E}, {0xE7A9,0x8165},
{0xE7AA,0x8166}, {0xE7AB,0x8174}, {0xE7AC,0x8183}, {0xE7AD,0x8188}, {0xE7AE,0x818A},
{0xE7AF,0x8180}, {0xE7B0,0x8182}, {0xE7B1,0x81A0}, {0xE7B2,0x8195}, {0xE7B3,0x81A4},
{0xE7B4,0x81A3}, {0xE7B5,0x815F}, {0xE7B6,0x8193}, {0xE7B7,0x81A9}, {0xE7B8,0x81B0},
{0xE7B9,0x81B5}, {0xE7BA,0x81BE}, {0xE7BB,0x81B8}, {0xE7BC,0x81BD}, {0xE7BD,0x81C0},
{0xE7BE,0x81C2}, {0xE7BF,0x81BA}, {0xE7C0,0x81C9}, {0xE7C1,0x81CD}, {0xE7C2,0x81D1},
{0xE7C3,0x81D9}, {0xE7C4,0x81D8}, {0xE7C5,0x81C8}, {0xE7C6,0x81DA}, {0xE7C7,0x81DF},
{0xE7C8,0x81E0}, {0xE7C9,0x81E7}, {0xE7CA,0x81FA}, {0xE7CB,0x81FB}, {0xE7CC,0x81FE},
{0xE7CD,0x8201}, {0xE7CE,0x8202}, {0xE7CF,0x8205}, {0xE7D0,0x8207}, {0xE7D1,0x820A},
{0xE7D2,0x820D}, {0xE7D3,0x8210}, {0xE7D4,0x8216}, {0xE7D5,0x8229}, {0xE7D6,0x822B},
{0xE7D7,0x8238}, {0xE7D8,0x8233}, {0xE7D9,0x8240}, {0xE7DA,0x8259}, {0xE7DB,0x8258},
{0xE7DC,0x825D}, {0xE7DD,0x825A}, {0xE7DE,0x825F}, {0xE7DF,0x8264}, {0xE7E0,0x8262},
{0xE7E1,0x8268}, {0xE7E2,0x826A}, {0xE7E3,0x826B}, {0xE7E4,0x822E}, {0xE7E5,0x8271},
{0xE7E6,0x8277}, {0xE7E7,0x8278}, {0xE7E8,0x827E}, {0xE7E9,0x828D}, {0xE7EA,0x8292},
{0xE7EB,0x82AB}, {0xE7EC,0x829F}, {0xE7ED,0x82BB}, {0xE7EE,0x82AC}, {0xE7EF,0x82E1},
{0xE7F0,0x82E3}, {0xE7F1,0x82DF}, {0xE7F2,0x82D2}, {0xE7F3,0x82F4}, {0xE7F4,0x82F3},
{0xE7F5,0x82FA}, {0xE7F6,0x8393}, {0xE7F7,0x8303}, {0xE7F8,0x82FB}, {0xE7F9,0x82F9},
{0xE7FA,0x82DE}, {0xE7FB,0x8306}, {0xE7FC,0x82DC}, {0xE7FD,0x8309}, {0xE7FE,0x82D9},
{0xE8A1,0x8335}, {0xE8A2,0x8334}, {0xE8A3,0x8316}, {0xE8A4,0x8332}, {0xE8A5,0x8331},
{0xE8A6,0x8340}, {0xE8A7,0x8339}, {0xE8A8,0x8350}, {0xE8A9,0x8345}, {0xE8AA,0x832F},
{0xE8AB,0x832B}, {0xE8AC,0x8317}, {0xE8AD,0x8318}, {0xE8AE,0x8385}, {0xE8AF,0x839A},
{0xE8B0,0x83AA}, {0xE8B1,0x839F}, {0xE8B2,0x83A2}, {0xE8B3,0x8396}, {0xE8B4,0x8323},
{0xE8B5,0x838E}, {0xE8B6,0x8387}, {0xE8B7,0x838A}, {0xE8B8,0x837C}, {0xE8B9,0x83B5},
{0xE8BA,0x8373}, {0xE8BB,0x8375}, {0xE8BC,0x83A0}, {0xE8BD,0x8389}, {0xE8BE,0x83A8},
{0xE8BF,0x83F4}, {0xE8C0,0x8413}, {0xE8C1,0x83EB}, {0xE8C2,0x83CE}, {0xE8C3,0x83FD},
{0xE8C4,0x8403}, {0xE8C5,0x83D8}, {0xE8C6,0x840B}, {0xE8C7,0x83C1}, {0xE8C8,0x83F7},
{0xE8C9,0x8407}, {0xE8CA,0x83E0}, {0xE8CB,0x83F2}, {0xE8CC,0x840D}, {0xE8CD,0x8422},
{0xE8CE,0x8420}, {0xE8CF,0x83BD}, {0xE8D0,0x8438}, {0xE8D1,0x8506}, {0xE8D2,0x83FB},
{0xE8D3,0x846D}, {0xE8D4,0x842A}, {0xE8D5,0x843C}, {0xE8D6,0x855A}, {0xE8D7,0x8484},
{0xE8D8,0x8477}, {0xE8D9,0x846B}, {0xE8DA,0x84AD}, {0xE8DB,0x846E}, {0xE8DC,0x8482},
{0xE8DD,0x8469}, {0xE8DE,0x8446}, {0xE8DF,0x842C}, {0xE8E0,0x846F}, {0xE8E1,0x8479},
{0xE8E2,0x8435}, {0xE8E3,0x84CA}, {0xE8E4,0x8462}, {0xE8E5,0x84B9}, {0xE8E6,0x84BF},
{0xE8E7,0x849F}, {0xE8E8,0x84D9}, {0xE8E9,0x84CD}, {0xE8EA,0x84BB}, {0xE8EB,0x84DA},
{0xE8EC,0x84D0}, {0xE8ED,0x84C1}, {0xE8EE,0x84C6}, {0xE8EF,0x84D6}, {0xE8F0,0x84A1},
{0xE8F1,0x8521}, {0xE8F2,0x84FF}, {0xE8F3,0x84F4}, {0xE8F4,0x8517}, {0xE8F5,0x8518},
{0xE8F6,0x852C}, {0xE8F7,0x851F}, {0xE8F8,0x8515}, {0xE8F9,0x8514}, {0xE8FA,0x84FC},
{0xE8FB,0x8540}, {0xE8FC,0x8563}, {0xE8FD,0x8558}, {0xE8FE,0x8548}, {0xE9A1,0x8541},
{0xE9A2,0x8602}, {0xE9A3,0x854B}, {0xE9A4,0x8555}, {0xE9A5,0x8580}, {0xE9A6,0x85A4},
{0xE9A7,0x8588}, {0xE9A8,0x8591}, {0xE9A9,0x858A}, {0xE9AA,0x85A8}, {0xE9AB,0x856D},
{0xE9AC,0x8594}, {0xE9AD,0x859B}, {0xE9AE,0x85EA}, {0xE9AF,0x8587}, {0xE9B0,0x859C},
{0xE9B1,0x8577}, {0xE9B2,0x857E}, {0xE9B3,0x8590}, {0xE9B4,0x85C9}, {0xE9B5,0x85BA},
{0xE9B6,0x85CF}, {0xE9B7,0x85B9}, {0xE9B8,0x85D0}, {0xE9B9,0x85D5}, {0xE9BA,0x85DD},
{0xE9BB,0x85E5}, {0xE9BC,0x85DC}, {0xE9BD,0x85F9}, {0xE9BE,0x860A}, {0xE9BF,0x8613},
{0xE9C0,0x860B}, {0xE9C1,0x85FE}, {0xE9C2,0x85FA}, {0xE9C3,0x8606}, {0xE9C4,0x8622},
{0xE9C5,0x861A}, {0xE9C6,0x8630}, {0xE9C7,0x863F}, {0xE9C8,0x864D}, {0xE9C9,0x4E55},
{0xE9CA,0x8654}, {0xE9CB,0x865F}, {0xE9CC,0x8667}, {0xE9CD,0x8671}, {0xE9CE,0x8693},
{0xE9CF,0x86A3}, {0xE9D0,0x86A9}, {0xE9D1,0x86AA}, {0xE9D2,0x868B}, {0xE9D3,0x868C},
{0xE9D4,0x86B6}, {0xE9D5,0x86AF}, {0xE9D6,0x86C4}, {0xE9D7,0x86C6}, {0xE9D8,0x86B0},
{0xE9D9,0x86C9}, {0xE9DA,0x8823}, {0xE9DB,0x86AB}, {0xE9DC,0x86D4}, {0xE9DD,0x86DE},
{0xE9DE,0x86E9}, {0xE9DF,0x86EC}, {0xE9E0,0x86DF}, {0xE9E1,0x86DB}, {0xE9E2,0x86EF},
{0xE9E3,0x8712}, {0xE9E4,0x8706}, {0xE9E5,0x8708}, {0xE9E6,0x8700}, {0xE9E7,0x8703},
{0xE9E8,0x86FB}, {0xE9E9,0x8711}, {0xE9EA,0x8709}, {0xE9EB,0x870D}, {0xE9EC,0x86F9},
{0xE9ED,0x870A}, {0xE9EE,0x8734}, {0xE9EF,0x873F}, {0xE9F0,0x8737}, {0xE9F1,0x873B},
{0xE9F2,0x8725}, {0xE9F3,0x8729}, {0xE9F4,0x871A}, {0xE9F5,0x8760}, {0xE9F6,0x875F},
{0xE9F7,0x8778}, {0xE9F8,0x874C}, {0xE9F9,0x874E}, {0xE9FA,0x8774}, {0xE9FB,0x8757},
{0xE9FC,0x8768}, {0xE9FD,0x876E}, {0xE9FE,0x8759}, {0xEAA1,0x8753}, {0xEAA2,0x8763},
{0xEAA3,0x876A}, {0xEAA4,0x8805}, {0xEAA5,0x87A2}, {0xEAA6,0x879F}, {0xEAA7,0x8782},
{0xEAA8,0x87AF}, {0xEAA9,0x87CB}, {0xEAAA,0x87BD}, {0xEAAB,0x87C0}, {0xEAAC,0x87D0},
{0xEAAD,0x96D6}, {0xEAAE,0x87AB}, {0xEAAF,0x87C4}, {0xEAB0,0x87B3}, {0xEAB1,0x87C7},
{0xEAB2,0x87C6}, {0xEAB3,0x87BB}, {0xEAB4,0x87EF}, {0xEAB5,0x87F2}, {0xEAB6,0x87E0},
{0xEAB7,0x880F}, {0xEAB8,0x880D}, {0xEAB9,0x87FE}, {0xEABA,0x87F6}, {0xEABB,0x87F7},
{0xEABC,0x880E}, {0xEABD,0x87D2}, {0xEABE,0x8811}, {0xEABF,0x8816}, {0xEAC0,0x8815},
{0xEAC1,0x8822}, {0xEAC2,0x8821}, {0xEAC3,0x8831}, {0xEAC4,0x8836}, {0xEAC5,0x8839},
{0xEAC6,0x8827}, {0xEAC7,0x883B}, {0xEAC8,0x8844}, {0xEAC9,0x8842}, {0xEACA,0x8852},
{0xEACB,0x8859}, {0xEACC,0x885E}, {0xEACD,0x8862}, {0xEACE,0x886B}, {0xEACF,0x8881},
{0xEAD0,0x887E}, {0xEAD1,0x889E}, {0xEAD2,0x8875}, {0xEAD3,0x887D}, {0xEAD4,0x88B5},
{0xEAD5,0x8872}, {0xEAD6,0x8882}, {0xEAD7,0x8897}, {0xEAD8,0x8892}, {0xEAD9,0x88AE},
{0xEADA,0x8899}, {0xEADB,0x88A2}, {0xEADC,0x888D}, {0xEADD,0x88A4}, {0xEADE,0x88B0},
{0xEADF,0x88BF}, {0xEAE0,0x88B1}, {0xEAE1,0x88C3}, {0xEAE2,0x88C4}, {0xEAE3,0x88D4},
{0xEAE4,0x88D8}, {0xEAE5,0x88D9}, {0xEAE6,0x88DD}, {0xEAE7,0x88F9}, {0xEAE8,0x8902},
{0xEAE9,0x88FC}, {0xEAEA,0x88F4}, {0xEAEB,0x88E8}, {0xEAEC,0x88F2}, {0xEAED,0x8904},
{0xEAEE,0x890C}, {0xEAEF,0x890A}, {0xEAF0,0x8913}, {0xEAF1,0x8943}, {0xEAF2,0x891E},
{0xEAF3,0x8925}, {0xEAF4,0x892A}, {0xEAF5,0x892B}, {0xEAF6,0x8941}, {0xEAF7,0x8944},
{0xEAF8,0x893B}, {0xEAF9,0x8936}, {0xEAFA,0x8938}, {0xEAFB,0x894C}, {0xEAFC,0x891D},
{0xEAFD,0x8960}, {0xEAFE,0x895E}, {0xEBA1,0x8966}, {0xEBA2,0x8964}, {0xEBA3,0x896D},
{0xEBA4,0x896A}, {0xEBA5,0x896F}, {0xEBA6,0x8974}, {0xEBA7,0x8977}, {0xEBA8,0x897E},
{0xEBA9,0x8983}, {0xEBAA,0x8988}, {0xEBAB,0x898A}, {0xEBAC,0x8993}, {0xEBAD,0x8998},
{0xEBAE,0x89A1}, {0xEBAF,0x89A9}, {0xEBB0,0x89A6}, {0xEBB1,0x89AC}, {0xEBB2,0x89AF},
{0xEBB3,0x89B2}, {0xEBB4,0x89BA}, {0xEBB5,0x89BD}, {0xEBB6,0x89BF}, {0xEBB7,0x89C0},
{0xEBB8,0x89DA}, {0xEBB9,0x89DC}, {0xEBBA,0x89DD}, {0xEBBB,0x89E7}, {0xEBBC,0x89F4},
{0xEBBD,0x89F8}, {0xEBBE,0x8A03}, {0xEBBF,0x8A16}, {0xEBC0,0x8A10}, {0xEBC1,0x8A0C},
{0xEBC2,0x8A1B}, {0xEBC3,0x8A1D}, {0xEBC4,0x8A25}, {0xEBC5,0x8A36}, {0xEBC6,0x8A41},
{0xEBC7,0x8A5B}, {0xEBC8,0x8A52}, {0xEBC9,0x8A46}, {0xEBCA,0x8A48}, {0xEBCB,0x8A7C},
{0xEBCC,0x8A6D}, {0xEBCD,0x8A6C}, {0xEBCE,0x8A62}, {0xEBCF,0x8A85}, {0xEBD0,0x8A82},
{0xEBD1,0x8A84}, {0xEBD2,0x8AA8}, {0xEBD3,0x8AA1}, {0xEBD4,0x8A91}, {0xEBD5,0x8AA5},
{0xEBD6,0x8AA6}, {0xEBD7,0x8A9A}, {0xEBD8,0x8AA3}, {0xEBD9,0x8AC4}, {0xEBDA,0x8ACD},
{0xEBDB,0x8AC2}, {0xEBDC,0x8ADA}, {0xEBDD,0x8AEB}, {0xEBDE,0x8AF3}, {0xEBDF,0x8AE7},
{0xEBE0,0x8AE4}, {0xEBE1,0x8AF1}, {0xEBE2,0x8B14}, {0xEBE3,0x8AE0}, {0xEBE4,0x8AE2},
{0xEBE5,0x8AF7}, {0xEBE6,0x8ADE}, {0xEBE7,0x8ADB}, {0xEBE8,0x8B0C}, {0xEBE9,0x8B07},
{0xEBEA,0x8B1A}, {0xEBEB,0x8AE1}, {0xEBEC,0x8B16}, {0xEBED,0x8B10}, {0xEBEE,0x8B17},
{0xEBEF,0x8B20}, {0xEBF0,0x8B33}, {0xEBF1,0x97AB}, {0xEBF2,0x8B26}, {0xEBF3,0x8B2B},
{0xEBF4,0x8B3E}, {0xEBF5,0x8B28}, {0xEBF6,0x8B41}, {0xEBF7,0x8B4C}, {0xEBF8,0x8B4F},
{0xEBF9,0x8B4E}, {0xEBFA,0x8B49}, {0xEBFB,0x8B56}, {0xEBFC,0x8B5B}, {0xEBFD,0x8B5A},
{0xEBFE,0x8B6B}, {0xECA1,0x8B5F}, {0xECA2,0x8B6C}, {0xECA3,0x8B6F}, {0xECA4,0x8B74},
{0xECA5,0x8B7D}, {0xECA6,0x8B80}, {0xECA7,0x8B8C}, {0xECA8,0x8B8E}, {0xECA9,0x8B92},
{0xECAA,0x8B93}, {0xECAB,0x8B96}, {0xECAC,0x8B99}, {0xECAD,0x8B9A}, {0xECAE,0x8C3A},
{0xECAF,0x8C41}, {0xECB0,0x8C3F}, {0xECB1,0x8C48}, {0xECB2,0x8C4C}, {0xECB3,0x8C4E},
{0xECB4,0x8C50}, {0xECB5,0x8C55}, {0xECB6,0x8C62}, {0xECB7,0x8C6C}, {0xECB8,0x8C78},
{0xECB9,0x8C7A}, {0xECBA,0x8C82}, {0xECBB,0x8C89}, {0xECBC,0x8C85}, {0xECBD,0x8C8A},
{0xECBE,0x8C8D}, {0xECBF,0x8C8E}, {0xECC0,0x8C94}, {0xECC1,0x8C7C}, {0xECC2,0x8C98},
{0xECC3,0x621D}, {0xECC4,0x8CAD}, {0xECC5,0x8CAA}, {0xECC6,0x8CBD}, {0xECC7,0x8CB2},
{0xECC8,0x8CB3}, {0xECC9,0x8CAE}, {0xECCA,0x8CB6}, {0xECCB,0x8CC8}, {0xECCC,0x8CC1},
{0xECCD,0x8CE4}, {0xECCE,0x8CE3}, {0xECCF,0x8CDA}, {0xECD0,0x8CFD}, {0xECD1,0x8CFA},
{0xECD2,0x8CFB}, {0xECD3,0x8D04}, {0xECD4,0x8D05}, {0xECD5,0x8D0A}, {0xECD6,0x8D07},
{0xECD7,0x8D0F}, {0xECD8,0x8D0D}, {0xECD9,0x8D10}, {0xECDA,0x9F4E}, {0xECDB,0x8D13},
{0xECDC,0x8CCD}, {0xECDD,0x8D14}, {0xECDE,0x8D16}, {0xECDF,0x8D67}, {0xECE0,0x8D6D},
{0xECE1,0x8D71}, {0xECE2,0x8D73}, {0xECE3,0x8D81}, {0xECE4,0x8D99}, {0xECE5,0x8DC2},
{0xECE6,0x8DBE}, {0xECE7,0x8DBA}, {0xECE8,0x8DCF}, {0xECE9,0x8DDA}, {0xECEA,0x8DD6},
{0xECEB,0x8DCC}, {0xECEC,0x8DDB}, {0xECED,0x8DCB}, {0xECEE,0x8DEA}, {0xECEF,0x8DEB},
{0xECF0,0x8DDF}, {0xECF1,0x8DE3}, {0xECF2,0x8DFC}, {0xECF3,0x8E08}, {0xECF4,0x8E09},
{0xECF5,0x8DFF}, {0xECF6,0x8E1D}, {0xECF7,0x8E1E}, {0xECF8,0x8E10}, {0xECF9,0x8E1F},
{0xECFA,0x8E42}, {0xECFB,0x8E35}, {0xECFC,0x8E30}, {0xECFD,0x8E34}, {0xECFE,0x8E4A},
{0xEDA1,0x8E47}, {0xEDA2,0x8E49}, {0xEDA3,0x8E4C}, {0xEDA4,0x8E50}, {0xEDA5,0x8E48},
{0xEDA6,0x8E59}, {0xEDA7,0x8E64}, {0xEDA8,0x8E60}, {0xEDA9,0x8E2A}, {0xEDAA,0x8E63},
{0xEDAB,0x8E55}, {0xEDAC,0x8E76}, {0xEDAD,0x8E72}, {0xEDAE,0x8E7C}, {0xEDAF,0x8E81},
{0xEDB0,0x8E87}, {0xEDB1,0x8E85}, {0xEDB2,0x8E84}, {0xEDB3,0x8E8B}, {0xEDB4,0x8E8A},
{0xEDB5,0x8E93}, {0xEDB6,0x8E91}, {0xEDB7,0x8E94}, {0xEDB8,0x8E99}, {0xEDB9,0x8EAA},
{0xEDBA,0x8EA1}, {0xEDBB,0x8EAC}, {0xEDBC,0x8EB0}, {0xEDBD,0x8EC6}, {0xEDBE,0x8EB1},
{0xEDBF,0x8EBE}, {0xEDC0,0x8EC5}, {0xEDC1,0x8EC8}, {0xEDC2,0x8ECB}, {0xEDC3,0x8EDB},
{0xEDC4,0x8EE3}, {0xEDC5,0x8EFC}, {0xEDC6,0x8EFB}, {0xEDC7,0x8EEB}, {0xEDC8,0x8EFE},
{0xEDC9,0x8F0A}, {0xEDCA,0x8F05}, {0xEDCB,0x8F15}, {0xEDCC,0x8F12}, {0xEDCD,0x8F19},
{0xEDCE,0x8F13}, {0xEDCF,0x8F1C}, {0xEDD0,0x8F1F}, {0xEDD1,0x8F1B}, {0xEDD2,0x8F0C},
{0xEDD3,0x8F26}, {0xEDD4,0x8F33}, {0xEDD5,0x8F3B}, {0xEDD6,0x8F39}, {0xEDD7,0x8F45},
{0xEDD8,0x8F42}, {0xEDD9,0x8F3E}, {0xEDDA,0x8F4C}, {0xEDDB,0x8F49}, {0xEDDC,0x8F46},
{0xEDDD,0x8F4E}, {0xEDDE,0x8F57}, {0xEDDF,0x8F5C}, {0xEDE0,0x8F62}, {0xEDE1,0x8F63},
{0xEDE2,0x8F64}, {0xEDE3,0x8F9C}, {0xEDE4,0x8F9F}, {0xEDE5,0x8FA3}, {0xEDE6,0x8FAD},
{0xEDE7,0x8FAF}, {0xEDE8,0x8FB7}, {0xEDE9,0x8FDA}, {0xEDEA,0x8FE5}, {0xEDEB,0x8FE2},
{0xEDEC,0x8FEA}, {0xEDED,0x8FEF}, {0xEDEE,0x9087}, {0xEDEF,0x8FF4}, {0xEDF0,0x9005},
{0xEDF1,0x8FF9}, {0xEDF2,0x8FFA}, {0xEDF3,0x9011}, {0xEDF4,0x9015}, {0xEDF5,0x9021},
{0xEDF6,0x900D}, {0xEDF7,0x901E}, {0xEDF8,0x9016}, {0xEDF9,0x900B}, {0xEDFA,0x9027},
{0xEDFB,0x9036}, {0xEDFC,0x9035}, {0xEDFD,0x9039}, {0xEDFE,0x8FF8}, {0xEEA1,0x904F},
{0xEEA2,0x9050}, {0xEEA3,0x9051}, {0xEEA4,0x9052}, {0xEEA5,0x900E}, {0xEEA6,0x9049},
{0xEEA7,0x903E}, {0xEEA8,0x9056}, {0xEEA9,0x9058}, {0xEEAA,0x905E}, {0xEEAB,0x9068},
{0xEEAC,0x906F}, {0xEEAD,0x9076}, {0xEEAE,0x96A8}, {0xEEAF,0x9072}, {0xEEB0,0x9082},
{0xEEB1,0x907D}, {0xEEB2,0x9081}, {0xEEB3,0x9080}, {0xEEB4,0x908A}, {0xEEB5,0x9089},
{0xEEB6,0x908F}, {0xEEB7,0x90A8}, {0xEEB8,0x90AF}, {0xEEB9,0x90B1}, {0xEEBA,0x90B5},
{0xEEBB,0x90E2}, {0xEEBC,0x90E4}, {0xEEBD,0x6248}, {0xEEBE,0x90DB}, {0xEEBF,0x9102},
{0xEEC0,0x9112}, {0xEEC1,0x9119}, {0xEEC2,0x9132}, {0xEEC3,0x9130}, {0xEEC4,0x914A},
{0xEEC5,0x9156}, {0xEEC6,0x9158}, {0xEEC7,0x9163}, {0xEEC8,0x9165}, {0xEEC9,0x9169},
{0xEECA,0x9173}, {0xEECB,0x9172}, {0xEECC,0x918B}, {0xEECD,0x9189}, {0xEECE,0x9182},
{0xEECF,0x91A2}, {0xEED0,0x91AB}, {0xEED1,0x91AF}, {0xEED2,0x91AA}, {0xEED3,0x91B5},
{0xEED4,0x91B4}, {0xEED5,0x91BA}, {0xEED6,0x91C0}, {0xEED7,0x91C1}, {0xEED8,0x91C9},
{0xEED9,0x91CB}, {0xEEDA,0x91D0}, {0xEEDB,0x91D6}, {0xEEDC,0x91DF}, {0xEEDD,0x91E1},
{0xEEDE,0x91DB}, {0xEEDF,0x91FC}, {0xEEE0,0x91F5}, {0xEEE1,0x91F6}, {0xEEE2,0x921E},
{0xEEE3,0x91FF}, {0xEEE4,0x9214}, {0xEEE5,0x922C}, {0xEEE6,0x9215}, {0xEEE7,0x9211},
{0xEEE8,0x925E}, {0xEEE9,0x9257}, {0xEEEA,0x9245}, {0xEEEB,0x9249}, {0xEEEC,0x9264},
{0xEEED,0x9248}, {0xEEEE,0x9295}, {0xEEEF,0x923F}, {0xEEF0,0x924B}, {0xEEF1,0x9250},
{0xEEF2,0x929C}, {0xEEF3,0x9296}, {0xEEF4,0x9293}, {0xEEF5,0x929B}, {0xEEF6,0x925A},
{0xEEF7,0x92CF}, {0xEEF8,0x92B9}, {0xEEF9,0x92B7}, {0xEEFA,0x92E9}, {0xEEFB,0x930F},
{0xEEFC,0x92FA}, {0xEEFD,0x9344}, {0xEEFE,0x932E}, {0xEFA1,0x9319}, {0xEFA2,0x9322},
{0xEFA3,0x931A}, {0xEFA4,0x9323}, {0xEFA5,0x933A}, {0xEFA6,0x9335}, {0xEFA7,0x933B},
{0xEFA8,0x935C}, {0xEFA9,0x9360}, {0xEFAA,0x937C}, {0xEFAB,0x936E}, {0xEFAC,0x9356},
{0xEFAD,0x93B0}, {0xEFAE,0x93AC}, {0xEFAF,0x93AD}, {0xEFB0,0x9394}, {0xEFB1,0x93B9},
{0xEFB2,0x93D6}, {0xEFB3,0x93D7}, {0xEFB4,0x93E8}, {0xEFB5,0x93E5}, {0xEFB6,0x93D8},
{0xEFB7,0x93C3}, {0xEFB8,0x93DD}, {0xEFB9,0x93D0}, {0xEFBA,0x93C8}, {0xEFBB,0x93E4},
{0xEFBC,0x941A}, {0xEFBD,0x9414}, {0xEFBE,0x9413}, {0xEFBF,0x9403}, {0xEFC0,0x9407},
{0xEFC1,0x9410}, {0xEFC2,0x9436}, {0xEFC3,0x942B}, {0xEFC4,0x9435}, {0xEFC5,0x9421},
{0xEFC6,0x943A}, {0xEFC7,0x9441}, {0xEFC8,0x9452}, {0xEFC9,0x9444}, {0xEFCA,0x945B},
{0xEFCB,0x9460}, {0xEFCC,0x9462}, {0xEFCD,0x945E}, {0xEFCE,0x946A}, {0xEFCF,0x9229},
{0xEFD0,0x9470}, {0xEFD1,0x9475}, {0xEFD2,0x9477}, {0xEFD3,0x947D}, {0xEFD4,0x945A},
{0xEFD5,0x947C}, {0xEFD6,0x947E}, {0xEFD7,0x9481}, {0xEFD8,0x947F}, {0xEFD9,0x9582},
{0xEFDA,0x9587}, {0xEFDB,0x958A}, {0xEFDC,0x9594}, {0xEFDD,0x9596}, {0xEFDE,0x9598},
{0xEFDF,0x9599}, {0xEFE0,0x95A0}, {0xEFE1,0x95A8}, {0xEFE2,0x95A7}, {0xEFE3,0x95AD},
{0xEFE4,0x95BC}, {0xEFE5,0x95BB}, {0xEFE6,0x95B9}, {0xEFE7,0x95BE}, {0xEFE8,0x95CA},
{0xEFE9,0x6FF6}, {0xEFEA,0x95C3}, {0xEFEB,0x95CD}, {0xEFEC,0x95CC}, {0xEFED,0x95D5},
{0xEFEE,0x95D4}, {0xEFEF,0x95D6}, {0xEFF0,0x95DC}, {0xEFF1,0x95E1}, {0xEFF2,0x95E5},
{0xEFF3,0x95E2}, {0xEFF4,0x9621}, {0xEFF5,0x9628}, {0xEFF6,0x962E}, {0xEFF7,0x962F},
{0xEFF8,0x9642}, {0xEFF9,0x964C}, {0xEFFA,0x964F}, {0xEFFB,0x964B}, {0xEFFC,0x9677},
{0xEFFD,0x965C}, {0xEFFE,0x965E}, {0xF0A1,0x965D}, {0xF0A2,0x965F}, {0xF0A3,0x9666},
{0xF0A4,0x9672}, {0xF0A5,0x966C}, {0xF0A6,0x968D}, {0xF0A7,0x9698}, {0xF0A8,0x9695},
{0xF0A9,0x9697}, {0xF0AA,0x96AA}, {0xF0AB,0x96A7}, {0xF0AC,0x96B1}, {0xF0AD,0x96B2},
{0xF0AE,0x96B0}, {0xF0AF,0x96B4}, {0xF0B0,0x96B6}, {0xF0B1,0x96B8}, {0xF0B2,0x96B9},
{0xF0B3,0x96CE}, {0xF0B4,0x96CB}, {0xF0B5,0x96C9}, {0xF0B6,0x96CD}, {0xF0B7,0x894D},
{0xF0B8,0x96DC}, {0xF0B9,0x970D}, {0xF0BA,0x96D5}, {0xF0BB,0x96F9}, {0xF0BC,0x9704},
{0xF0BD,0x9706}, {0xF0BE,0x9708}, {0xF0BF,0x9713}, {0xF0C0,0x970E}, {0xF0C1,0x9711},
{0xF0C2,0x970F}, {0xF0C3,0x9716}, {0xF0C4,0x9719}, {0xF0C5,0x9724}, {0xF0C6,0x972A},
{0xF0C7,0x9730}, {0xF0C8,0x9739}, {0xF0C9,0x973D}, {0xF0CA,0x973E}, {0xF0CB,0x9744},
{0xF0CC,0x9746}, {0xF0CD,0x9748}, {0xF0CE,0x9742}, {0xF0CF,0x9749}, {0xF0D0,0x975C},
{0xF0D1,0x9760}, {0xF0D2,0x9764}, {0xF0D3,0x9766}, {0xF0D4,0x9768}, {0xF0D5,0x52D2},
{0xF0D6,0x976B}, {0xF0D7,0x9771}, {0xF0D8,0x9779}, {0xF0D9,0x9785}, {0xF0DA,0x977C},
{0xF0DB,0x9781}, {0xF0DC,0x977A}, {0xF0DD,0x9786}, {0xF0DE,0x978B}, {0xF0DF,0x978F},
{0xF0E0,0x9790}, {0xF0E1,0x979C}, {0xF0E2,0x97A8}, {0xF0E3,0x97A6}, {0xF0E4,0x97A3},
{0xF0E5,0x97B3}, {0xF0E6,0x97B4}, {0xF0E7,0x97C3}, {0xF0E8,0x97C6}, {0xF0E9,0x97C8},
{0xF0EA,0x97CB}, {0xF0EB,0x97DC}, {0xF0EC,0x97ED}, {0xF0ED,0x9F4F}, {0xF0EE,0x97F2},
{0xF0EF,0x7ADF}, {0xF0F0,0x97F6}, {0xF0F1,0x97F5}, {0xF0F2,0x980F}, {0xF0F3,0x980C},
{0xF0F4,0x9838}, {0xF0F5,0x9824}, {0xF0F6,0x9821}, {0xF0F7,0x9837}, {0xF0F8,0x983D},
{0xF0F9,0x9846}, {0xF0FA,0x984F}, {0xF0FB,0x984B}, {0xF0FC,0x986B}, {0xF0FD,0x986F},
{0xF0FE,0x9870}, {0xF1A1,0x9871}, {0xF1A2,0x9874}, {0xF1A3,0x9873}, {0xF1A4,0x98AA},
{0xF1A5,0x98AF}, {0xF1A6,0x98B1}, {0xF1A7,0x98B6}, {0xF1A8,0x98C4}, {0xF1A9,0x98C3},
{0xF1AA,0x98C6}, {0xF1AB,0x98E9}, {0xF1AC,0x98EB}, {0xF1AD,0x9903}, {0xF1AE,0x9909},
{0xF1AF,0x9912}, {0xF1B0,0x9914}, {0xF1B1,0x9918}, {0xF1B2,0x9921}, {0xF1B3,0x991D},
{0xF1B4,0x991E}, {0xF1B5,0x9924}, {0xF1B6,0x9920}, {0xF1B7,0x992C}, {0xF1B8,0x992E},
{0xF1B9,0x993D}, {0xF1BA,0x993E}, {0xF1BB,0x9942}, {0xF1BC,0x9949}, {0xF1BD,0x9945},
{0xF1BE,0x9950}, {0xF1BF,0x994B}, {0xF1C0,0x9951}, {0xF1C1,0x9952}, {0xF1C2,0x994C},
{0xF1C3,0x9955}, {0xF1C4,0x9997}, {0xF1C5,0x9998}, {0xF1C6,0x99A5}, {0xF1C7,0x99AD},
{0xF1C8,0x99AE}, {0xF1C9,0x99BC}, {0xF1CA,0x99DF}, {0xF1CB,0x99DB}, {0xF1CC,0x99DD},
{0xF1CD,0x99D8}, {0xF1CE,0x99D1}, {0xF1CF,0x99ED}, {0xF1D0,0x99EE}, {0xF1D1,0x99F1},
{0xF1D2,0x99F2}, {0xF1D3,0x99FB}, {0xF1D4,0x99F8}, {0xF1D5,0x9A01}, {0xF1D6,0x9A0F},
{0xF1D7,0x9A05}, {0xF1D8,0x99E2}, {0xF1D9,0x9A19}, {0xF1DA,0x9A2B}, {0xF1DB,0x9A37},
{0xF1DC,0x9A45}, {0xF1DD,0x9A42}, {0xF1DE,0x9A40}, {0xF1DF,0x9A43}, {0xF1E0,0x9A3E},
{0xF1E1,0x9A55}, {0xF1E2,0x9A4D}, {0xF1E3,0x9A5B}, {0xF1E4,0x9A57}, {0xF1E5,0x9A5F},
{0xF1E6,0x9A62}, {0xF1E7,0x9A65}, {0xF1E8,0x9A64}, {0xF1E9,0x9A69}, {0xF1EA,0x9A6B},
{0xF1EB,0x9A6A}, {0xF1EC,0x9AAD}, {0xF1ED,0x9AB0}, {0xF1EE,0x9ABC}, {0xF1EF,0x9AC0},
{0xF1F0,0x9ACF}, {0xF1F1,0x9AD1}, {0xF1F2,0x9AD3}, {0xF1F3,0x9AD4}, {0xF1F4,0x9ADE},
{0xF1F5,0x9ADF}, {0xF1F6,0x9AE2}, {0xF1F7,0x9AE3}, {0xF1F8,0x9AE6}, {0xF1F9,0x9AEF},
{0xF1FA,0x9AEB}, {0xF1FB,0x9AEE}, {0xF1FC,0x9AF4}, {0xF1FD,0x9AF1}, {0xF1FE,0x9AF7},
{0xF2A1,0x9AFB}, {0xF2A2,0x9B06}, {0xF2A3,0x9B18}, {0xF2A4,0x9B1A}, {0xF2A5,0x9B1F},
{0xF2A6,0x9B22}, {0xF2A7,0x9B23}, {0xF2A8,0x9B25}, {0xF2A9,0x9B27}, {0xF2AA,0x9B28},
{0xF2AB,0x9B29}, {0xF2AC,0x9B2A}, {0xF2AD,0x9B2E}, {0xF2AE,0x9B2F}, {0xF2AF,0x9B32},
{0xF2B0,0x9B44}, {0xF2B1,0x9B43}, {0xF2B2,0x9B4F}, {0xF2B3,0x9B4D}, {0xF2B4,0x9B4E},
{0xF2B5,0x9B51}, {0xF2B6,0x9B58}, {0xF2B7,0x9B74}, {0xF2B8,0x9B93}, {0xF2B9,0x9B83},
{0xF2BA,0x9B91}, {0xF2BB,0x9B96}, {0xF2BC,0x9B97}, {0xF2BD,0x9B9F}, {0xF2BE,0x9BA0},
{0xF2BF,0x9BA8}, {0xF2C0,0x9BB4}, {0xF2C1,0x9BC0}, {0xF2C2,0x9BCA}, {0xF2C3,0x9BB9},
{0xF2C4,0x9BC6}, {0xF2C5,0x9BCF}, {0xF2C6,0x9BD1}, {0xF2C7,0x9BD2}, {0xF2C8,0x9BE3},
{0xF2C9,0x9BE2}, {0xF2CA,0x9BE4}, {0xF2CB,0x9BD4}, {0xF2CC,0x9BE1}, {0xF2CD,0x9C3A},
{0xF2CE,0x9BF2}, {0xF2CF,0x9BF1}, {0xF2D0,0x9BF0}, {0xF2D1,0x9C15}, {0xF2D2,0x9C14},
{0xF2D3,0x9C09}, {0xF2D4,0x9C13}, {0xF2D5,0x9C0C}, {0xF2D6,0x9C06}, {0xF2D7,0x9C08},
{0xF2D8,0x9C12}, {0xF2D9,0x9C0A}, {0xF2DA,0x9C04}, {0xF2DB,0x9C2E}, {0xF2DC,0x9C1B},
{0xF2DD,0x9C25}, {0xF2DE,0x9C24}, {0xF2DF,0x9C21}, {0xF2E0,0x9C30}, {0xF2E1,0x9C47},
{0xF2E2,0x9C32}, {0xF2E3,0x9C46}, {0xF2E4,0x9C3E}, {0xF2E5,0x9C5A}, {0xF2E6,0x9C60},
{0xF2E7,0x9C67}, {0xF2E8,0x9C76}, {0xF2E9,0x9C78}, {0xF2EA,0x9CE7}, {0xF2EB,0x9CEC},
{0xF2EC,0x9CF0}, {0xF2ED,0x9D09}, {0xF2EE,0x9D08}, {0xF2EF,0x9CEB}, {0xF2F0,0x9D03},
{0xF2F1,0x9D06}, {0xF2F2,0x9D2A}, {0xF2F3,0x9D26}, {0xF2F4,0x9DAF}, {0xF2F5,0x9D23},
{0xF2F6,0x9D1F}, {0xF2F7,0x9D44}, {0xF2F8,0x9D15}, {0xF2F9,0x9D12}, {0xF2FA,0x9D41},
{0xF2FB,0x9D3F}, {0xF2FC,0x9D3E}, {0xF2FD,0x9D46}, {0xF2FE,0x9D48}, {0xF3A1,0x9D5D},
{0xF3A2,0x9D5E}, {0xF3A3,0x9D64}, {0xF3A4,0x9D51}, {0xF3A5,0x9D50}, {0xF3A6,0x9D59},
{0xF3A7,0x9D72}, {0xF3A8,0x9D89}, {0xF3A9,0x9D87}, {0xF3AA,0x9DAB}, {0xF3AB,0x9D6F},
{0xF3AC,0x9D7A}, {0xF3AD,0x9D9A}, {0xF3AE,0x9DA4}, {0xF3AF,0x9DA9}, {0xF3B0,0x9DB2},
{0xF3B1,0x9DC4}, {0xF3B2,0x9DC1}, {0xF3B3,0x9DBB}, {0xF3B4,0x9DB8}, {0xF3B5,0x9DBA},
{0xF3B6,0x9DC6}, {0xF3B7,0x9DCF}, {0xF3B8,0x9DC2}, {0xF3B9,0x9DD9}, {0xF3BA,0x9DD3},
{0xF3BB,0x9DF8}, {0xF3BC,0x9DE6}, {0xF3BD,0x9DED}, {0xF3BE,0x9DEF}, {0xF3BF,0x9DFD},
{0xF3C0,0x9E1A}, {0xF3C1,0x9E1B}, {0xF3C2,0x9E1E}, {0xF3C3,0x9E75}, {0xF3C4,0x9E79},
{0xF3C5,0x9E7D}, {0xF3C6,0x9E81}, {0xF3C7,0x9E88}, {0xF3C8,0x9E8B}, {0xF3C9,0x9E8C},
{0xF3CA,0x9E92}, {0xF3CB,0x9E95}, {0xF3CC,0x9E91}, {0xF3CD,0x9E9D}, {0xF3CE,0x9EA5},
{0xF3CF,0x9EA9}, {0xF3D0,0x9EB8}, {0xF3D1,0x9EAA}, {0xF3D2,0x9EAD}, {0xF3D3,0x9761},
{0xF3D4,0x9ECC}, {0xF3D5,0x9ECE}, {0xF3D6,0x9ECF}, {0xF3D7,0x9ED0}, {0xF3D8,0x9ED4},
{0xF3D9,0x9EDC}, {0xF3DA,0x9EDE}, {0xF3DB,0x9EDD}, {0xF3DC,0x9EE0}, {0xF3DD,0x9EE5},
{0xF3DE,0x9EE8}, {0xF3DF,0x9EEF}, {0xF3E0,0x9EF4}, {0xF3E1,0x9EF6}, {0xF3E2,0x9EF7},
{0xF3E3,0x9EF9}, {0xF3E4,0x9EFB}, {0xF3E5,0x9EFC}, {0xF3E6,0x9EFD}, {0xF3E7,0x9F07},
{0xF3E8,0x9F08}, {0xF3E9,0x76B7}, {0xF3EA,0x9F15}, {0xF3EB,0x9F21}, {0xF3EC,0x9F2C},
{0xF3ED,0x9F3E}, {0xF3EE,0x9F4A}, {0xF3EF,0x9F52}, {0xF3F0,0x9F54}, {0xF3F1,0x9F63},
{0xF3F2,0x9F5F}, {0xF3F3,0x9F60}, {0xF3F4,0x9F61}, {0xF3F5,0x9F66}, {0xF3F6,0x9F67},
{0xF3F7,0x9F6C}, {0xF3F8,0x9F6A}, {0xF3F9,0x9F77}, {0xF3FA,0x9F72}, {0xF3FB,0x9F76},
{0xF3FC,0x9F95}, {0xF3FD,0x9F9C}, {0xF3FE,0x9FA0}, {0xF4A1,0x582F}, {0xF4A2,0x69C7},
{0xF4A3,0x9059}, {0xF4A4,0x7464}, {0xF4A5,0x51DC}, {0xF4A6,0x7199},
{0xF9A1, 0x7E8A},
{0xF9A2, 0x891C},
{0xF9A3, 0x9348},
{0xF9A4, 0x9288},
{0xF9A5, 0x84DC},
{0xF9A6, 0x4FC9},
{0xF9A7, 0x70BB},
{0xF9A8, 0x6631},
{0xF9A9, 0x68C8},
{0xF9AA, 0x92F9},
{0xF9AB, 0x66FB},
{0xF9AC, 0x5F45},
{0xF9AD, 0x4E28},
{0xF9AE, 0x4EE1},
{0xF9AF, 0x4EFC},
{0xF9B0, 0x4F00},
{0xF9B1, 0x4F03},
{0xF9B2, 0x4F39},
{0xF9B3, 0x4F56},
{0xF9B4, 0x4F92},
{0xF9B5, 0x4F8A},
{0xF9B6, 0x4F9A},
{0xF9B7, 0x4F94},
{0xF9B8, 0x4FCD},
{0xF9B9, 0x5040},
{0xF9BA, 0x5022},
{0xF9BB, 0x4FFF},
{0xF9BC, 0x501E},
{0xF9BD, 0x5046},
{0xF9BE, 0x5070},
{0xF9BF, 0x5042},
{0xF9C0, 0x5094},
{0xF9C1, 0x50F4},
{0xF9C2, 0x50D8},
{0xF9C3, 0x514A},
{0xF9C4, 0x5164},
{0xF9C5, 0x519D},
{0xF9C6, 0x51BE},
{0xF9C7, 0x51EC},
{0xF9C8, 0x5215},
{0xF9C9, 0x529C},
{0xF9CA, 0x52A6},
{0xF9CB, 0x52C0},
{0xF9CC, 0x52DB},
{0xF9CD, 0x5300},
{0xF9CE, 0x5307},
{0xF9CF, 0x5324},
{0xF9D0, 0x5372},
{0xF9D1, 0x5393},
{0xF9D2, 0x53B2},
{0xF9D3, 0x53DD},
{0xF9D4, 0xFA0E},
{0xF9D5, 0x549C},
{0xF9D6, 0x548A},
{0xF9D7, 0x54A9},
{0xF9D8, 0x54FF},
{0xF9D9, 0x5586},
{0xF9DA, 0x5759},
{0xF9DB, 0x5765},
{0xF9DC, 0x57AC},
{0xF9DD, 0x57C8},
{0xF9DE, 0x57C7},
{0xF9DF, 0xFA0F},
{0xF9E0, 0xFA10},
{0xF9E1, 0x589E},
{0xF9E2, 0x58B2},
{0xF9E3, 0x590B},
{0xF9E4, 0x5953},
{0xF9E5, 0x595B},
{0xF9E6, 0x595D},
{0xF9E7, 0x5963},
{0xF9E8, 0x59A4},
{0xF9E9, 0x59BA},
{0xF9EA, 0x5B56},
{0xF9EB, 0x5BC0},
{0xF9EC, 0x752F},
{0xF9ED, 0x5BD8},
{0xF9EE, 0x5BEC},
{0xF9EF, 0x5C1E},
{0xF9F0, 0x5CA6},
{0xF9F1, 0x5CBA},
{0xF9F2, 0x5CF5},
{0xF9F3, 0x5D27},
{0xF9F4, 0x5D53},
{0xF9F5, 0xFA11},
{0xF9F6, 0x5D42},
{0xF9F7, 0x5D6D},
{0xF9F8, 0x5DB8},
{0xF9F9, 0x5DB9},
{0xF9FA, 0x5DD0},
{0xF9FB, 0x5F21},
{0xF9FC, 0x5F34},
{0xF9FD, 0x5F67},
{0xF9FE, 0x5FB7},
{0xFAA1, 0x5FDE},
{0xFAA2, 0x605D},
{0xFAA3, 0x6085},
{0xFAA4, 0x608A},
{0xFAA5, 0x60DE},
{0xFAA6, 0x60D5},
{0xFAA7, 0x6120},
{0xFAA8, 0x60F2},
{0xFAA9, 0x6111},
{0xFAAA, 0x6137},
{0xFAAB, 0x6130},
{0xFAAC, 0x6198},
{0xFAAD, 0x6213},
{0xFAAE, 0x62A6},
{0xFAAF, 0x63F5},
{0xFAB0, 0x6460},
{0xFAB1, 0x649D},
{0xFAB2, 0x64CE},
{0xFAB3, 0x654E},
{0xFAB4, 0x6600},
{0xFAB5, 0x6615},
{0xFAB6, 0x663B},
{0xFAB7, 0x6609},
{0xFAB8, 0x662E},
{0xFAB9, 0x661E},
{0xFABA, 0x6624},
{0xFABB, 0x6665},
{0xFABC, 0x6657},
{0xFABD, 0x6659},
{0xFABE, 0xFA12},
{0xFABF, 0x6673},
{0xFAC0, 0x6699},
{0xFAC1, 0x66A0},
{0xFAC2, 0x66B2},
{0xFAC3, 0x66BF},
{0xFAC4, 0x66FA},
{0xFAC5, 0x670E},
{0xFAC6, 0xF929},
{0xFAC7, 0x6766},
{0xFAC8, 0x67BB},
{0xFAC9, 0x6852},
{0xFACA, 0x67C0},
{0xFACB, 0x6801},
{0xFACC, 0x6844},
{0xFACD, 0x68CF},
{0xFACE, 0xFA13},
{0xFACF, 0x6968},
{0xFAD0, 0xFA14},
{0xFAD1, 0x6998},
{0xFAD2, 0x69E2},
{0xFAD3, 0x6A30},
{0xFAD4, 0x6A6B},
{0xFAD5, 0x6A46},
{0xFAD6, 0x6A73},
{0xFAD7, 0x6A7E},
{0xFAD8, 0x6AE2},
{0xFAD9, 0x6AE4},
{0xFADA, 0x6BD6},
{0xFADB, 0x6C3F},
{0xFADC, 0x6C5C},
{0xFADD, 0x6C86},
{0xFADE, 0x6C6F},
{0xFADF, 0x6CDA},
{0xFAE0, 0x6D04},
{0xFAE1, 0x6D87},
{0xFAE2, 0x6D6F},
{0xFAE3, 0x6D96},
{0xFAE4, 0x6DAC},
{0xFAE5, 0x6DCF},
{0xFAE6, 0x6DF8},
{0xFAE7, 0x6DF2},
{0xFAE8, 0x6DFC},
{0xFAE9, 0x6E39},
{0xFAEA, 0x6E5C},
{0xFAEB, 0x6E27},
{0xFAEC, 0x6E3C},
{0xFAED, 0x6EBF},
{0xFAEE, 0x6F88},
{0xFAEF, 0x6FB5},
{0xFAF0, 0x6FF5},
{0xFAF1, 0x7005},
{0xFAF2, 0x7007},
{0xFAF3, 0x7028},
{0xFAF4, 0x7085},
{0xFAF5, 0x70AB},
{0xFAF6, 0x710F},
{0xFAF7, 0x7104},
{0xFAF8, 0x715C},
{0xFAF9, 0x7146},
{0xFAFA, 0x7147},
{0xFAFB, 0xFA15},
{0xFAFC, 0x71C1},
{0xFAFD, 0x71FE},
{0xFAFE, 0x72B1},
{0xFBA1, 0x72BE},
{0xFBA2, 0x7324},
{0xFBA3, 0xFA16},
{0xFBA4, 0x7377},
{0xFBA5, 0x73BD},
{0xFBA6, 0x73C9},
{0xFBA7, 0x73D6},
{0xFBA8, 0x73E3},
{0xFBA9, 0x73D2},
{0xFBAA, 0x7407},
{0xFBAB, 0x73F5},
{0xFBAC, 0x7426},
{0xFBAD, 0x742A},
{0xFBAE, 0x7429},
{0xFBAF, 0x742E},
{0xFBB0, 0x7462},
{0xFBB1, 0x7489},
{0xFBB2, 0x749F},
{0xFBB3, 0x7501},
{0xFBB4, 0x756F},
{0xFBB5, 0x7682},
{0xFBB6, 0x769C},
{0xFBB7, 0x769E},
{0xFBB8, 0x769B},
{0xFBB9, 0x76A6},
{0xFBBA, 0xFA17},
{0xFBBB, 0x7746},
{0xFBBC, 0x52AF},
{0xFBBD, 0x7821},
{0xFBBE, 0x784E},
{0xFBBF, 0x7864},
{0xFBC0, 0x787A},
{0xFBC1, 0x7930},
{0xFBC2, 0xFA18},
{0xFBC3, 0xFA19},
{0xFBC4, 0xFA1A},
{0xFBC5, 0x7994},
{0xFBC6, 0xFA1B},
{0xFBC7, 0x799B},
{0xFBC8, 0x7AD1},
{0xFBC9, 0x7AE7},
{0xFBCA, 0xFA1C},
{0xFBCB, 0x7AEB},
{0xFBCC, 0x7B9E},
{0xFBCD, 0xFA1D},
{0xFBCE, 0x7D48},
{0xFBCF, 0x7D5C},
{0xFBD0, 0x7DB7},
{0xFBD1, 0x7DA0},
{0xFBD2, 0x7DD6},
{0xFBD3, 0x7E52},
{0xFBD4, 0x7F47},
{0xFBD5, 0x7FA1},
{0xFBD6, 0xFA1E},
{0xFBD7, 0x8301},
{0xFBD8, 0x8362},
{0xFBD9, 0x837F},
{0xFBDA, 0x83C7},
{0xFBDB, 0x83F6},
{0xFBDC, 0x8448},
{0xFBDD, 0x84B4},
{0xFBDE, 0x8553},
{0xFBDF, 0x8559},
{0xFBE0, 0x856B},
{0xFBE1, 0xFA1F},
{0xFBE2, 0x85B0},
{0xFBE3, 0xFA20},
{0xFBE4, 0xFA21},
{0xFBE5, 0x8807},
{0xFBE6, 0x88F5},
{0xFBE7, 0x8A12},
{0xFBE8, 0x8A37},
{0xFBE9, 0x8A79},
{0xFBEA, 0x8AA7},
{0xFBEB, 0x8ABE},
{0xFBEC, 0x8ADF},
{0xFBED, 0xFA22},
{0xFBEE, 0x8AF6},
{0xFBEF, 0x8B53},
{0xFBF0, 0x8B7F},
{0xFBF1, 0x8CF0},
{0xFBF2, 0x8CF4},
{0xFBF3, 0x8D12},
{0xFBF4, 0x8D76},
{0xFBF5, 0xFA23},
{0xFBF6, 0x8ECF},
{0xFBF7, 0xFA24},
{0xFBF8, 0xFA25},
{0xFBF9, 0x9067},
{0xFBFA, 0x90DE},
{0xFBFB, 0xFA26},
{0xFBFC, 0x9115},
{0xFBFD, 0x9127},
{0xFBFE, 0x91DA},
{0xFCA1, 0x91D7},
{0xFCA2, 0x91DE},
{0xFCA3, 0x91ED},
{0xFCA4, 0x91EE},
{0xFCA5, 0x91E4},
{0xFCA6, 0x91E5},
{0xFCA7, 0x9206},
{0xFCA8, 0x9210},
{0xFCA9, 0x920A},
{0xFCAA, 0x923A},
{0xFCAB, 0x9240},
{0xFCAC, 0x923C},
{0xFCAD, 0x924E},
{0xFCAE, 0x9259},
{0xFCAF, 0x9251},
{0xFCB0, 0x9239},
{0xFCB1, 0x9267},
{0xFCB2, 0x92A7},
{0xFCB3, 0x9277},
{0xFCB4, 0x9278},
{0xFCB5, 0x92E7},
{0xFCB6, 0x92D7},
{0xFCB7, 0x92D9},
{0xFCB8, 0x92D0},
{0xFCB9, 0xFA27},
{0xFCBA, 0x92D5},
{0xFCBB, 0x92E0},
{0xFCBC, 0x92D3},
{0xFCBD, 0x9325},
{0xFCBE, 0x9321},
{0xFCBF, 0x92FB},
{0xFCC0, 0xFA28},
{0xFCC1, 0x931E},
{0xFCC2, 0x92FF},
{0xFCC3, 0x931D},
{0xFCC4, 0x9302},
{0xFCC5, 0x9370},
{0xFCC6, 0x9357},
{0xFCC7, 0x93A4},
{0xFCC8, 0x93C6},
{0xFCC9, 0x93DE},
{0xFCCA, 0x93F8},
{0xFCCB, 0x9431},
{0xFCCC, 0x9445},
{0xFCCD, 0x9448},
{0xFCCE, 0x9592},
{0xFCCF, 0xF9DC},
{0xFCD0, 0xFA29},
{0xFCD1, 0x969D},
{0xFCD2, 0x96AF},
{0xFCD3, 0x9733},
{0xFCD4, 0x973B},
{0xFCD5, 0x9743},
{0xFCD6, 0x974D},
{0xFCD7, 0x974F},
{0xFCD8, 0x9751},
{0xFCD9, 0x9755},
{0xFCDA, 0x9857},
{0xFCDB, 0x9865},
{0xFCDC, 0xFA2A},
{0xFCDD, 0xFA2B},
{0xFCDE, 0x9927},
{0xFCDF, 0xFA2C},
{0xFCE0, 0x999E},
{0xFCE1, 0x9A4E},
{0xFCE2, 0x9AD9},
{0xFCE3, 0x9ADC},
{0xFCE4, 0x9B75},
{0xFCE5, 0x9B72},
{0xFCE6, 0x9B8F},
{0xFCE7, 0x9BB1},
{0xFCE8, 0x9BBB},
{0xFCE9, 0x9C00},
{0xFCEA, 0x9D70},
{0xFCEB, 0x9D6B},
{0xFCEC, 0xFA2D},
{0xFCED, 0x9E19},
{0xFCEE, 0x9ED1},
{0xFCF1, 0x2170},
{0xFCF2, 0x2171},
{0xFCF3, 0x2172},
{0xFCF4, 0x2173},
{0xFCF5, 0x2174},
{0xFCF6, 0x2175},
{0xFCF7, 0x2176},
{0xFCF8, 0x2177},
{0xFCF9, 0x2178},
{0xFCFA, 0x2179},
{0xFCFB, 0xFFE2},
{0xFCFC, 0xFFE4},
{0xFCFD, 0xFF07},
{0xFCFE, 0xFF02}
# endif /* lynx */
};

int
CharSetCvtEUCJPtoUTF8::MapCount()
{
	return sizeof(EUCJPtoUCS2) / sizeof(*EUCJPtoUCS2);
}
