using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;

namespace Perforce.P4
{
	public partial class P4ClientError
	{
		public static int MsgSupp_NoTransVar = ErrorOf(ErrorSubsystem.ES_SUPP, 1, ErrorSeverity.E_WARN, ErrorGeneric.EV_ILLEGAL, 2); //"No Translation for parameter '%arg%' value '%value%'!"
		public static int MsgSupp_InvalidDate = ErrorOf(ErrorSubsystem.ES_SUPP, 2, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid date '%date%'."
		public static int MsgSupp_InvalidCharset = ErrorOf(ErrorSubsystem.ES_SUPP, 244, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid charset '%charset%'."
		public static int MsgSupp_TooMany = ErrorOf(ErrorSubsystem.ES_SUPP, 3, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Too many options on command!"
		public static int MsgSupp_Invalid = ErrorOf(ErrorSubsystem.ES_SUPP, 4, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid option: -%option%."
		public static int MsgSupp_NeedsArg = ErrorOf(ErrorSubsystem.ES_SUPP, 5, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Option: -%option% needs argument."
		public static int MsgSupp_NeedsNonNegArg = ErrorOf(ErrorSubsystem.ES_SUPP, 33, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Option: -%option% needs a non-negative integer argument."
		public static int MsgSupp_Needs2Arg = ErrorOf(ErrorSubsystem.ES_SUPP, 23, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Option: -%option% needs a flag and an argument."
		public static int MsgSupp_ExtraArg = ErrorOf(ErrorSubsystem.ES_SUPP, 6, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Unexpected arguments."
		public static int MsgSupp_WrongArg = ErrorOf(ErrorSubsystem.ES_SUPP, 7, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Missing/wrong number of arguments."
		public static int MsgSupp_Usage = ErrorOf(ErrorSubsystem.ES_SUPP, 8, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Usage: %text%"
		public static int MsgSupp_OptionData = ErrorOf(ErrorSubsystem.ES_SUPP, 31, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //
		public static int MsgSupp_NoParm = ErrorOf(ErrorSubsystem.ES_SUPP, 9, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Required parameter '%arg%' not set!"
		public static int MsgSupp_NoUnixReg = ErrorOf(ErrorSubsystem.ES_SUPP, 10, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 0); //"Can't set registry on UNIX."
		public static int MsgSupp_NoSuchVariable = ErrorOf(ErrorSubsystem.ES_SUPP, 34, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 1); //"Unrecognized variable name %varName%. Comment lines should contain '#' in column 1."
		public static int MsgSupp_HidesVar = ErrorOf(ErrorSubsystem.ES_SUPP, 11, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 1); //"Warning: environment variable hides registry definition of %name%."
		public static int MsgSupp_NoP4Config = ErrorOf(ErrorSubsystem.ES_SUPP, 12, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 0); //"Can't save in config if %'P4CONFIG'% not set."
		public static int MsgSupp_VariableData = ErrorOf(ErrorSubsystem.ES_SUPP, 32, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //
		public static int MsgSupp_PartialChar = ErrorOf(ErrorSubsystem.ES_SUPP, 13, ErrorSeverity.E_INFO, ErrorGeneric.EV_ILLEGAL, 0); //"Partial character in translation"
		public static int MsgSupp_NoTrans = ErrorOf(ErrorSubsystem.ES_SUPP, 14, ErrorSeverity.E_WARN, ErrorGeneric.EV_ILLEGAL, 2); //"Translation of file content failed near line %arg%[ file %name%]"
		public static int MsgSupp_ConvertFailed = ErrorOf(ErrorSubsystem.ES_SUPP, 36, ErrorSeverity.E_WARN, ErrorGeneric.EV_ILLEGAL, 3); //"Translation of %path% from %charset1% to %charset2% failed -- correct before proceeding."
		public static int MsgSupp_BadMangleParams = ErrorOf(ErrorSubsystem.ES_SUPP, 22, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Bad parameters passed to mangler!"
		public static int MsgSupp_BadOS = ErrorOf(ErrorSubsystem.ES_SUPP, 15, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Don't know how to translate paths for OS '%arg%'!"
		public static int MsgSupp_Deflate = ErrorOf(ErrorSubsystem.ES_SUPP, 16, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Deflate failed!"
		public static int MsgSupp_DeflateEnd = ErrorOf(ErrorSubsystem.ES_SUPP, 17, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"DeflateEnd failed!"
		public static int MsgSupp_DeflateInit = ErrorOf(ErrorSubsystem.ES_SUPP, 18, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"DeflateInit failed!"
		public static int MsgSupp_Inflate = ErrorOf(ErrorSubsystem.ES_SUPP, 19, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Inflate failed!"
		public static int MsgSupp_InflateInit = ErrorOf(ErrorSubsystem.ES_SUPP, 20, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"InflateInit failed!"
		public static int MsgSupp_MagicHeader = ErrorOf(ErrorSubsystem.ES_SUPP, 21, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Gzip magic header wrong!"
		public static int MsgSupp_RegexError = ErrorOf(ErrorSubsystem.ES_SUPP, 30, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Regular expression error: %text%"
		public static int MsgSupp_UnknownTunable = ErrorOf(ErrorSubsystem.ES_SUPP, 319, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Unknown configurable: %conf%"
		public static int MsgSupp_TunableValueTooLow = ErrorOf(ErrorSubsystem.ES_SUPP, 320, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Configurable '%config%' cannot be set to a value less than '%minVal%'."
		public static int MsgSupp_TunableValueTooHigh = ErrorOf(ErrorSubsystem.ES_SUPP, 321, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Configurable '%config%' cannot be set to a value greater than '%maxVal%'."
		public static int MsgSupp_OptionChange = ErrorOf(ErrorSubsystem.ES_SUPP, 37, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--change (-c)'%: specifies the changelist to use for the command."
		public static int MsgSupp_OptionPort = ErrorOf(ErrorSubsystem.ES_SUPP, 38, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--port (-p)'%: specifies the network address of the server."
		public static int MsgSupp_OptionUser = ErrorOf(ErrorSubsystem.ES_SUPP, 39, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--user (-u)'%: specifies the user name."
		public static int MsgSupp_OptionClient = ErrorOf(ErrorSubsystem.ES_SUPP, 40, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--client (-c)'%: specifies the client workspace name."
		public static int MsgSupp_OptionPreview = ErrorOf(ErrorSubsystem.ES_SUPP, 41, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--preview (-n)'%: specifies that the command should display a preview of the results, but not execute them."
		public static int MsgSupp_OptionDelete = ErrorOf(ErrorSubsystem.ES_SUPP, 42, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--delete (-d)'%: specifies that the object should be deleted."
		public static int MsgSupp_OptionForce = ErrorOf(ErrorSubsystem.ES_SUPP, 43, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--force (-f)'%: overrides the normal safety checks."
		public static int MsgSupp_OptionInput = ErrorOf(ErrorSubsystem.ES_SUPP, 44, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--input (-i)'%: specifies that the data should be read from standard input."
		public static int MsgSupp_OptionOutput = ErrorOf(ErrorSubsystem.ES_SUPP, 45, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--output (-o)'%: specifies that the data should be written to standard output."
		public static int MsgSupp_OptionMax = ErrorOf(ErrorSubsystem.ES_SUPP, 46, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--max (-m)'%: specifies the maximum number of objects."
		public static int MsgSupp_OptionQuiet = ErrorOf(ErrorSubsystem.ES_SUPP, 47, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--quiet (-q)'%: suppresses normal information output."
		public static int MsgSupp_OptionShort = ErrorOf(ErrorSubsystem.ES_SUPP, 48, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--short (-s)'%: displays a brief version of the results."
		public static int MsgSupp_OptionLong = ErrorOf(ErrorSubsystem.ES_SUPP, 49, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--long (-l)'%: displays a complete version of the results."
		public static int MsgSupp_OptionAll = ErrorOf(ErrorSubsystem.ES_SUPP, 50, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--all (-a)'%: specifies that the command should include all objects."
		public static int MsgSupp_OptionFiletype = ErrorOf(ErrorSubsystem.ES_SUPP, 51, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--filetype (-t)'%: specifies the filetype to be used."
		public static int MsgSupp_OptionStream = ErrorOf(ErrorSubsystem.ES_SUPP, 52, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--stream (-S)'%: specifies the stream to be used."
		public static int MsgSupp_OptionParent = ErrorOf(ErrorSubsystem.ES_SUPP, 53, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--parent (-P)'%: specifies the stream to be used as the parent."
		public static int MsgSupp_OptionClientName = ErrorOf(ErrorSubsystem.ES_SUPP, 54, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--client (-C)'%: specifies the client workspace name."
		public static int MsgSupp_OptionHost = ErrorOf(ErrorSubsystem.ES_SUPP, 55, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--host (-H)'%: specifies the host name, overriding the value from the network configuration."
		public static int MsgSupp_OptionPassword = ErrorOf(ErrorSubsystem.ES_SUPP, 56, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--password (-P)'%: specifies the password to be used."
		public static int MsgSupp_OptionCharset = ErrorOf(ErrorSubsystem.ES_SUPP, 57, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--charset (-C)'%: specifies the client's character set."
		public static int MsgSupp_OptionCmdCharset = ErrorOf(ErrorSubsystem.ES_SUPP, 58, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--cmd-charset (-Q)'%: specifies the client's command character set."
		public static int MsgSupp_OptionVariable = ErrorOf(ErrorSubsystem.ES_SUPP, 59, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--variable (-v)'%: specifies the value of a configurable variable."
		public static int MsgSupp_OptionHelp = ErrorOf(ErrorSubsystem.ES_SUPP, 60, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--help (-h)'%: provides help."
		public static int MsgSupp_OptionVersion = ErrorOf(ErrorSubsystem.ES_SUPP, 61, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--version (-V)'%: displays version information."
		public static int MsgSupp_OptionBatchsize = ErrorOf(ErrorSubsystem.ES_SUPP, 62, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--batchsize (-b)'%: specifies the number of objects in a single batch."
		public static int MsgSupp_OptionMessageType = ErrorOf(ErrorSubsystem.ES_SUPP, 63, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--message-type (-s)'%: includes message type information in the output."
		public static int MsgSupp_OptionXargs = ErrorOf(ErrorSubsystem.ES_SUPP, 64, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--xargs (-x)'%: reads input arguments from the specified file."
		public static int MsgSupp_OptionExclusive = ErrorOf(ErrorSubsystem.ES_SUPP, 65, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--exclusive (-x)'%: indicates that the command should process files of type +l."
		public static int MsgSupp_OptionProgress = ErrorOf(ErrorSubsystem.ES_SUPP, 66, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--progress (-I)'%: indicates that the command should display progress information."
		public static int MsgSupp_OptionDowngrade = ErrorOf(ErrorSubsystem.ES_SUPP, 67, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--downgrade (-d)'%: indicates that the operation should be downgraded."
		public static int MsgSupp_OptionDirectory = ErrorOf(ErrorSubsystem.ES_SUPP, 68, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--directory (-d)'%: specifies the directory to be used as the current directory."
		public static int MsgSupp_OptionRetries = ErrorOf(ErrorSubsystem.ES_SUPP, 69, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--retries (-r)'%: specifies the number of times the command may be retried."
		public static int MsgSupp_OptionNoIgnore = ErrorOf(ErrorSubsystem.ES_SUPP, 70, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no-ignore (-I)'%: specifies that the command should ignore the %'P4IGNORE'% settings."
		public static int MsgSupp_OptionCentralUsers = ErrorOf(ErrorSubsystem.ES_SUPP, 71, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--central-only (-c)'%: include user information from the central server only."
		public static int MsgSupp_OptionReplicaUsers = ErrorOf(ErrorSubsystem.ES_SUPP, 72, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--replica-only (-r)'%: include user information from the replica server only."
		public static int MsgSupp_OptionFullBranch = ErrorOf(ErrorSubsystem.ES_SUPP, 73, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--full-branch (-F)'%: include the full generated branch spec in the output."
		public static int MsgSupp_OptionSpecFixStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 74, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--status (-s)'%: include the fix status for each job in the spec."
		public static int MsgSupp_OptionChangeType = ErrorOf(ErrorSubsystem.ES_SUPP, 75, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--type (-t)'%: specify the type of this change (public or restricted)."
		public static int MsgSupp_OptionChangeUpdate = ErrorOf(ErrorSubsystem.ES_SUPP, 76, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--update (-u)'%: allows the owner of a submitted change to update it."
		public static int MsgSupp_OptionOriginal = ErrorOf(ErrorSubsystem.ES_SUPP, 77, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--original (-O)'%: specifies the original change number of a renumbered change."
		public static int MsgSupp_OptionChangeUser = ErrorOf(ErrorSubsystem.ES_SUPP, 78, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--new-user (-U)'%: specifies the new user of an empty pending change."
		public static int MsgSupp_OptionTemplate = ErrorOf(ErrorSubsystem.ES_SUPP, 79, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--template (-t)'%: specifies the template for a client or label."
		public static int MsgSupp_OptionSwitch = ErrorOf(ErrorSubsystem.ES_SUPP, 80, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--switch (-s)'%: specifies to switch this client to a different stream."
		public static int MsgSupp_OptionTemporary = ErrorOf(ErrorSubsystem.ES_SUPP, 81, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--temporary (-x)'%: specifies to create a temporary client."
		public static int MsgSupp_OptionOwner = ErrorOf(ErrorSubsystem.ES_SUPP, 82, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--owner (-a)'%: enables an owner of the group to update it."
		public static int MsgSupp_OptionAdministrator = ErrorOf(ErrorSubsystem.ES_SUPP, 83, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--administrator (-A)'%: enables an administrator to create a new group."
		public static int MsgSupp_OptionGlobal = ErrorOf(ErrorSubsystem.ES_SUPP, 84, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--global (-g)'%: enables modifying a global label from an Edge Server."
		public static int MsgSupp_OptionStreamType = ErrorOf(ErrorSubsystem.ES_SUPP, 85, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--type (-t)'%: specifies the type of stream"
		public static int MsgSupp_OptionVirtualStream = ErrorOf(ErrorSubsystem.ES_SUPP, 86, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--virtual (-v)'%: specifies this is a virtual stream."
		public static int MsgSupp_OptionBrief = ErrorOf(ErrorSubsystem.ES_SUPP, 87, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--brief (-L)'%: displays truncated changelist description."
		public static int MsgSupp_OptionInherited = ErrorOf(ErrorSubsystem.ES_SUPP, 88, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--inherited (-i)'%: includes changes integrated into the files."
		public static int MsgSupp_OptionShowTime = ErrorOf(ErrorSubsystem.ES_SUPP, 89, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--show-time (-t)'%: includes the time in the output."
		public static int MsgSupp_OptionChangeStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 90, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--status (-s)'%: specifies the change status."
		public static int MsgSupp_OptionLimitClient = ErrorOf(ErrorSubsystem.ES_SUPP, 91, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--client (-C)'%: limit the results to this client workspace."
		public static int MsgSupp_OptionLabelName = ErrorOf(ErrorSubsystem.ES_SUPP, 92, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--label (-l)'%: specifies the name of the label."
		public static int MsgSupp_OptionRunOnMaster = ErrorOf(ErrorSubsystem.ES_SUPP, 93, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--global (-M)'%: create this list on the master server."
		public static int MsgSupp_OptionArchive = ErrorOf(ErrorSubsystem.ES_SUPP, 94, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--archive (-A)'%: enables access to the archive depot"
		public static int MsgSupp_OptionBlocksize = ErrorOf(ErrorSubsystem.ES_SUPP, 95, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--blocksize (-b)'%: specifies the blocksize to be used for calculations."
		public static int MsgSupp_OptionHuman1024 = ErrorOf(ErrorSubsystem.ES_SUPP, 96, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--human (-h)'%: displays output using human-friendly abbreviations."
		public static int MsgSupp_OptionHuman1000 = ErrorOf(ErrorSubsystem.ES_SUPP, 97, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--human-1000 (-H)'%: displays human-friendly output using units of 1000."
		public static int MsgSupp_OptionSummary = ErrorOf(ErrorSubsystem.ES_SUPP, 98, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--summary (-s)'%: displays summary information."
		public static int MsgSupp_OptionShelved = ErrorOf(ErrorSubsystem.ES_SUPP, 99, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--shelved (-S)'%: specifies to access shelved files."
		public static int MsgSupp_OptionUnload = ErrorOf(ErrorSubsystem.ES_SUPP, 100, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--unload (-U)'%: enables access to unloaded objects."
		public static int MsgSupp_OptionUnloadLimit = ErrorOf(ErrorSubsystem.ES_SUPP, 264, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--unload-limit (-u)'%: threshold number of days after which an unused client will be unloaded."
		public static int MsgSupp_OptionOmitLazy = ErrorOf(ErrorSubsystem.ES_SUPP, 101, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--omit-lazy (-z)'%: omits lazy copies from the results."
		public static int MsgSupp_OptionLeaveKeywords = ErrorOf(ErrorSubsystem.ES_SUPP, 102, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--leave-keywords (-k)'%: specifies that RCS keywords are not to be expanded in the output."
		public static int MsgSupp_OptionOutputFile = ErrorOf(ErrorSubsystem.ES_SUPP, 103, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--file (-o)'%: specifies the name of the output file."
		public static int MsgSupp_OptionExists = ErrorOf(ErrorSubsystem.ES_SUPP, 104, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--exists (-e)'%: includes only files which are not deleted."
		public static int MsgSupp_OptionContent = ErrorOf(ErrorSubsystem.ES_SUPP, 105, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--content (-h)'%: display file content history instead of file name history."
		public static int MsgSupp_OptionOmitPromoted = ErrorOf(ErrorSubsystem.ES_SUPP, 106, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--omit-promoted (-p)'%: disables following content of promoted task streams."
		public static int MsgSupp_OptionOmitMoved = ErrorOf(ErrorSubsystem.ES_SUPP, 107, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--omit-moved (-1)'%: disables following renames resulting from '%'p4 move'%'."
		public static int MsgSupp_OptionKeepClient = ErrorOf(ErrorSubsystem.ES_SUPP, 108, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--keep-client (-k)'%: leaves the client's copy of the files untouched."
		public static int MsgSupp_OptionFileCharset = ErrorOf(ErrorSubsystem.ES_SUPP, 109, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--file-charset (-Q)'%: specifies a character set override for this file."
		public static int MsgSupp_OptionVirtual = ErrorOf(ErrorSubsystem.ES_SUPP, 110, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--virtual (-v)'%: performs the action on the server without updating client data."
		public static int MsgSupp_OptionGenerate = ErrorOf(ErrorSubsystem.ES_SUPP, 111, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--generate (-g)'%: generate a new unique value."
		public static int MsgSupp_OptionConfigure = ErrorOf(ErrorSubsystem.ES_SUPP, 276, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--configure (-c)'%: configure edge or commit server."
		public static int MsgSupp_OptionUsage = ErrorOf(ErrorSubsystem.ES_SUPP, 112, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--usage (-u)'%: display the current usage levels."
		public static int MsgSupp_OptionTags = ErrorOf(ErrorSubsystem.ES_SUPP, 113, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--tags (-T)'%: specify which tags to include in the results."
		public static int MsgSupp_OptionFilter = ErrorOf(ErrorSubsystem.ES_SUPP, 114, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--filter (-F)'%: specify filters which limit the results."
		public static int MsgSupp_OptionJob = ErrorOf(ErrorSubsystem.ES_SUPP, 115, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--job (-j)'%: specifies the job name."
		public static int MsgSupp_OptionExpression = ErrorOf(ErrorSubsystem.ES_SUPP, 116, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--expression (-e)'%: specifies the expression to filter the results."
		public static int MsgSupp_OptionNoCaseExpr = ErrorOf(ErrorSubsystem.ES_SUPP, 117, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no-case-expression (-E)'%: specifies the case-insensitive expression to filter the results."
		public static int MsgSupp_OptionIncrement = ErrorOf(ErrorSubsystem.ES_SUPP, 118, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--increment (-i)'%: specifies that the value is to be incremented by 1."
		public static int MsgSupp_OptionDiffFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 119, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--diff-flags (-d)'%: specifies flags for diff behavior."
		public static int MsgSupp_OptionFixStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 120, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--fix-status (-s)'%: specifies the status for this fix."
		public static int MsgSupp_OptionShelf = ErrorOf(ErrorSubsystem.ES_SUPP, 121, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--shelf (-s)'%: specifies the shelved changelist number to use."
		public static int MsgSupp_OptionReplace = ErrorOf(ErrorSubsystem.ES_SUPP, 122, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--replace (-r)'%: specifies to replace all shelved files in the changelist."
		public static int MsgSupp_OptionShelveOpts = ErrorOf(ErrorSubsystem.ES_SUPP, 123, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--shelve-options (-a)'%: specifies options for handling unchanged files."
		public static int MsgSupp_OptionBranch = ErrorOf(ErrorSubsystem.ES_SUPP, 124, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--branch (-b)'%: specifies the branch name to use."
		public static int MsgSupp_OptionSubmitShelf = ErrorOf(ErrorSubsystem.ES_SUPP, 125, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--shelf (-e)'%: specifies the shelved changelist to submit."
		public static int MsgSupp_OptionSubmitOpts = ErrorOf(ErrorSubsystem.ES_SUPP, 126, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--submit-options (-f)'%: specifies options for handling unchanged files."
		public static int MsgSupp_OptionReopen = ErrorOf(ErrorSubsystem.ES_SUPP, 127, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--reopen (-r)'%: specifies that the files should be reopened after submit."
		public static int MsgSupp_OptionDescription = ErrorOf(ErrorSubsystem.ES_SUPP, 128, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--description (-d)'%: specifies the description of the change."
		public static int MsgSupp_OptionTamper = ErrorOf(ErrorSubsystem.ES_SUPP, 129, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--tamper-check (-t)'%: specifies that file digests should be used to detect tampering."
		public static int MsgSupp_OptionCompress = ErrorOf(ErrorSubsystem.ES_SUPP, 130, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--compress (-z)'%: specifies that the output should be compressed."
		public static int MsgSupp_OptionDate = ErrorOf(ErrorSubsystem.ES_SUPP, 131, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--date (-d)'%: specifies to unload all objects older than that date."
		public static int MsgSupp_OptionStreamName = ErrorOf(ErrorSubsystem.ES_SUPP, 132, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--stream (-s)'%: specifies the stream name."
		public static int MsgSupp_OptionReverse = ErrorOf(ErrorSubsystem.ES_SUPP, 133, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--reverse (-r)'%: specifies to reverse the direction of the branch view."
		public static int MsgSupp_OptionWipe = ErrorOf(ErrorSubsystem.ES_SUPP, 134, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--erase (-w)'%: removes the object from the client machine."
		public static int MsgSupp_OptionUnchanged = ErrorOf(ErrorSubsystem.ES_SUPP, 135, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--unchanged (-a)'%: specifies that only unchanged files are affected."
		public static int MsgSupp_OptionDepot = ErrorOf(ErrorSubsystem.ES_SUPP, 136, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--depot (-D)'%: specifies the depot name."
		public static int MsgSupp_OptionDepot2 = ErrorOf(ErrorSubsystem.ES_SUPP, 324, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--depot (-d)'%: specifies the depot name."
		public static int MsgSupp_OptionKeepHead = ErrorOf(ErrorSubsystem.ES_SUPP, 137, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--keep-head (-h)'%: specifies the head revision is not to be processed."
		public static int MsgSupp_OptionPurge = ErrorOf(ErrorSubsystem.ES_SUPP, 138, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--purge (-p)'%: specifies that the revisions are to be purged."
		public static int MsgSupp_OptionForceText = ErrorOf(ErrorSubsystem.ES_SUPP, 139, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--force-text (-t)'%: specifies that text revisions are to be processed."
		public static int MsgSupp_OptionBinaryAsText = ErrorOf(ErrorSubsystem.ES_SUPP, 140, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--binary-as-text (-t)'%: specifies that binary files are to be processed."
		public static int MsgSupp_OptionBypassFlow = ErrorOf(ErrorSubsystem.ES_SUPP, 141, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--bypass-flow (-F)'%: forces the command to process against a stream's expected flow."
		public static int MsgSupp_OptionShowChange = ErrorOf(ErrorSubsystem.ES_SUPP, 142, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--show-change (-c)'%: show changelist numbers rather than revision numbers."
		public static int MsgSupp_OptionFollowBranch = ErrorOf(ErrorSubsystem.ES_SUPP, 143, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--follow-branch (-i)'%: include the revisions of the source file up to the branch point."
		public static int MsgSupp_OptionFollowInteg = ErrorOf(ErrorSubsystem.ES_SUPP, 144, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--follow-integ (-I)'%: include all integrations into the file."
		public static int MsgSupp_OptionSourceFile = ErrorOf(ErrorSubsystem.ES_SUPP, 145, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--source-file (-s)'%: treat fromFile as the source and both sides of the branch view as the target."
		public static int MsgSupp_OptionOutputFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 146, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--output-flags (-O)'%: specifies codes controlling the command output."
		public static int MsgSupp_OptionResolveFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 148, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--resolve-flags (-A)'%: controls which types of resolves are performed."
		public static int MsgSupp_OptionAcceptFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 149, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--accept-flags (-a)'%: specifies the level of automatic resolves accepted."
		public static int MsgSupp_OptionIntegFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 150, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--integ-flags (-R)'%: specifies how integrate should schedule resolves."
		public static int MsgSupp_OptionDeleteFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 151, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--delete-flags (-D)'%: specifies how integration should handle deleted files."
		public static int MsgSupp_OptionRestrictFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 152, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--restrict-flags (-R)'%: limits the output to specific files."
		public static int MsgSupp_OptionSortFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 153, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--sort-flags (-S)'%: changes the order of output."
		public static int MsgSupp_OptionForceFlag = ErrorOf(ErrorSubsystem.ES_SUPP, 175, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--force-flag (-F)'%: optional force behavior when deleting clients."
		public static int MsgSupp_OptionUseList = ErrorOf(ErrorSubsystem.ES_SUPP, 154, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--use-list (-L)'%: collects multiple file arguments into an in-memory list."
		public static int MsgSupp_OptionPublish = ErrorOf(ErrorSubsystem.ES_SUPP, 155, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--publish (-p)'%: populates the client workspace but does not update the server."
		public static int MsgSupp_OptionSafe = ErrorOf(ErrorSubsystem.ES_SUPP, 156, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--safe (-s)'%: performs a safety check before sending the file."
		public static int MsgSupp_OptionIsGroup = ErrorOf(ErrorSubsystem.ES_SUPP, 157, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--group (-g)'%: indicates that the argument is a group name."
		public static int MsgSupp_OptionIsUser = ErrorOf(ErrorSubsystem.ES_SUPP, 158, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--user (-u)'%: indicates that the argument is a user name."
		public static int MsgSupp_OptionIsOwner = ErrorOf(ErrorSubsystem.ES_SUPP, 159, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--owner (-o)'%: indicates that the argument is an owner."
		public static int MsgSupp_OptionVerbose = ErrorOf(ErrorSubsystem.ES_SUPP, 160, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--verbose (-v)'%: includes additional information in the output."
		public static int MsgSupp_OptionLineNumber = ErrorOf(ErrorSubsystem.ES_SUPP, 161, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--line-number (-n)'%: print line number with output lines."
		public static int MsgSupp_OptionInvertMatch = ErrorOf(ErrorSubsystem.ES_SUPP, 162, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--invert-match (-v)'%: select non-matching lines."
		public static int MsgSupp_OptionFilesWithMatches = ErrorOf(ErrorSubsystem.ES_SUPP, 163, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--files-with-matches (-l)'%: only print files containing matches."
		public static int MsgSupp_OptionFilesWithoutMatch = ErrorOf(ErrorSubsystem.ES_SUPP, 164, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--files-without-match (-L)'%: only print files containing no match."
		public static int MsgSupp_OptionNoMessages = ErrorOf(ErrorSubsystem.ES_SUPP, 165, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no-messages (-s)'%: specifies no line-too-long messages."
		public static int MsgSupp_OptionFixedStrings = ErrorOf(ErrorSubsystem.ES_SUPP, 166, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--fixed-strings (-F)'%: specifies a fixed string."
		public static int MsgSupp_OptionBasicRegexp = ErrorOf(ErrorSubsystem.ES_SUPP, 167, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--basic-regexp (-G)'%: specifies a basic regular expression."
		public static int MsgSupp_OptionExtendedRegexp = ErrorOf(ErrorSubsystem.ES_SUPP, 168, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--extended-regexp (-E)'%: specifies an extended regular expression."
		public static int MsgSupp_OptionPerlRegexp = ErrorOf(ErrorSubsystem.ES_SUPP, 169, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--perl-regexp (-P)'%: specifies a Perl regular expression"
		public static int MsgSupp_OptionRegexp = ErrorOf(ErrorSubsystem.ES_SUPP, 170, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--regexp (-e)'%: specifies the regular expression"
		public static int MsgSupp_OptionAfterContext = ErrorOf(ErrorSubsystem.ES_SUPP, 171, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--after-context (-A)'%: specifies the number of lines after the match."
		public static int MsgSupp_OptionBeforeContext = ErrorOf(ErrorSubsystem.ES_SUPP, 172, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--before-context (-B)'%: specifies the number of lines before the match."
		public static int MsgSupp_OptionContext = ErrorOf(ErrorSubsystem.ES_SUPP, 173, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--context (-C)'%: specifies the number of lines of context."
		public static int MsgSupp_OptionIgnoreCase = ErrorOf(ErrorSubsystem.ES_SUPP, 174, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--ignore-case (-i)'%: causes the pattern-matching to be case-insensitive."
		public static int MsgSupp_OptionJournalPrefix = ErrorOf(ErrorSubsystem.ES_SUPP, 176, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--journal-prefix (-J)'%: specifies the journal file name prefix."
		public static int MsgSupp_OptionRepeat = ErrorOf(ErrorSubsystem.ES_SUPP, 177, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--repeat (-i)'%: specifies the repeat interval in seconds."
		public static int MsgSupp_OptionBackoff = ErrorOf(ErrorSubsystem.ES_SUPP, 178, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--backoff (-b)'%: specifies the error backoff period in seconds."
		public static int MsgSupp_OptionArchiveData = ErrorOf(ErrorSubsystem.ES_SUPP, 179, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--archive-data (-u)'%: specifies to retrieve file content."
		public static int MsgSupp_OptionStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 180, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--status (-l)'%: specifies that status information should be displayed"
		public static int MsgSupp_OptionJournalPosition = ErrorOf(ErrorSubsystem.ES_SUPP, 181, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--journal-position (-j)'%: specifies to display journal position status."
		public static int MsgSupp_OptionPullServerid = ErrorOf(ErrorSubsystem.ES_SUPP, 182, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--serverid (-P)'%: specifies to use filtering specifications of this server."
		public static int MsgSupp_OptionExcludeTables = ErrorOf(ErrorSubsystem.ES_SUPP, 183, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--exclude-tables (-T)'%: specifies tables to exclude."
		public static int MsgSupp_OptionFile = ErrorOf(ErrorSubsystem.ES_SUPP, 184, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--file (-f)'%: specifies the file."
		public static int MsgSupp_OptionRevision = ErrorOf(ErrorSubsystem.ES_SUPP, 185, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--revision (-r)'%: specifies the revision."
		public static int MsgSupp_OptionNoRejournal = ErrorOf(ErrorSubsystem.ES_SUPP, 186, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no-rejournal'%: specifies that the pull command should not re-journal records which are replicated from the target server."
		public static int MsgSupp_OptionAppend = ErrorOf(ErrorSubsystem.ES_SUPP, 187, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--append (-a)'%: specifies that information is to be appended."
		public static int MsgSupp_OptionSequence = ErrorOf(ErrorSubsystem.ES_SUPP, 188, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--sequence (-c)'%: specifies the sequence value."
		public static int MsgSupp_OptionCounter = ErrorOf(ErrorSubsystem.ES_SUPP, 189, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--counter (-t)'%: specifies the counter name."
		public static int MsgSupp_OptionHostName = ErrorOf(ErrorSubsystem.ES_SUPP, 190, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--host (-h)'%: specifies the host name to use."
		public static int MsgSupp_OptionPrint = ErrorOf(ErrorSubsystem.ES_SUPP, 191, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--print (-p)'%: specifies that the result is to be displayed."
		public static int MsgSupp_OptionStartPosition = ErrorOf(ErrorSubsystem.ES_SUPP, 192, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--start (-s)'%: specifies the starting position."
		public static int MsgSupp_OptionEncoded = ErrorOf(ErrorSubsystem.ES_SUPP, 193, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--encoded (-e)'%: specifies that the value is to be encoded."
		public static int MsgSupp_OptionLogName = ErrorOf(ErrorSubsystem.ES_SUPP, 194, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--log (-l)'%: specifies the name of the log."
		public static int MsgSupp_OptionLoginStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 195, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--status (-s)'%: displays the current status."
		public static int MsgSupp_OptionCompressCkp = ErrorOf(ErrorSubsystem.ES_SUPP, 196, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--compress-ckp (-Z)'%: compress the checkpoint, but not the journal."
		public static int MsgSupp_OptionSpecType = ErrorOf(ErrorSubsystem.ES_SUPP, 197, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--spec (-s)'%: specifies the type of spec to be processed."
		public static int MsgSupp_OptionMaxAccess = ErrorOf(ErrorSubsystem.ES_SUPP, 198, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--max-access (-m)'%: displays a single word summary of the maximum access level."
		public static int MsgSupp_OptionGroupName = ErrorOf(ErrorSubsystem.ES_SUPP, 199, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--group (-g)'%: specifies the group name."
		public static int MsgSupp_OptionShowFiles = ErrorOf(ErrorSubsystem.ES_SUPP, 200, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--show-files (-f)'%: specifies to display the individual files."
		public static int MsgSupp_OptionName = ErrorOf(ErrorSubsystem.ES_SUPP, 201, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--name (-n)'%: specifies the object name."
		public static int MsgSupp_OptionValue = ErrorOf(ErrorSubsystem.ES_SUPP, 202, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--value (-v)'%: specifies the object value."
		public static int MsgSupp_OptionPropagating = ErrorOf(ErrorSubsystem.ES_SUPP, 203, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--propagating (-p)'%: specifies the attribute is propagating."
		public static int MsgSupp_OptionOpenAdd = ErrorOf(ErrorSubsystem.ES_SUPP, 204, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--add (-a)'%: specifies files should be opened for add."
		public static int MsgSupp_OptionOpenEdit = ErrorOf(ErrorSubsystem.ES_SUPP, 205, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--edit (-e)'%: specifies files should be opened for edit."
		public static int MsgSupp_OptionOpenDelete = ErrorOf(ErrorSubsystem.ES_SUPP, 206, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--delete (-d)'%: specifies files should be opened for delete."
		public static int MsgSupp_OptionUseModTime = ErrorOf(ErrorSubsystem.ES_SUPP, 207, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--modtime (-m)'%: specifies the file modification time should be checked."
		public static int MsgSupp_OptionLocal = ErrorOf(ErrorSubsystem.ES_SUPP, 208, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--local (-l)'%: specifies local syntax for filenames."
		public static int MsgSupp_OptionOutputBase = ErrorOf(ErrorSubsystem.ES_SUPP, 209, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--output-base (-o)'%: specifies to display the revision used as the base."
		public static int MsgSupp_OptionSystem = ErrorOf(ErrorSubsystem.ES_SUPP, 210, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--system (-s)'%: specifies the value should apply to all users on the system."
		public static int MsgSupp_OptionService = ErrorOf(ErrorSubsystem.ES_SUPP, 211, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--service (-S)'%: specifies the value applies to the named service."
		public static int MsgSupp_OptionHistogram = ErrorOf(ErrorSubsystem.ES_SUPP, 212, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--histogram (-h)'%: specifies to display a histogram."
		public static int MsgSupp_OptionTableNotUnlocked = ErrorOf(ErrorSubsystem.ES_SUPP, 213, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--table-not-unlocked (-U)'%: runs only the table-not-unlocked check."
		public static int MsgSupp_OptionTableName = ErrorOf(ErrorSubsystem.ES_SUPP, 214, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--table (-t)'%: specifies the table."
		public static int MsgSupp_OptionAllClients = ErrorOf(ErrorSubsystem.ES_SUPP, 215, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--all-clients (-C)'%: specifies to process all client workspaces."
		public static int MsgSupp_OptionCheckSize = ErrorOf(ErrorSubsystem.ES_SUPP, 216, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--size (-s)'%: specifies that file size should be checked."
		public static int MsgSupp_OptionTransfer = ErrorOf(ErrorSubsystem.ES_SUPP, 217, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--transfer (-t)'%: specifies damaged or missing files should be retransferred."
		public static int MsgSupp_OptionUpdate = ErrorOf(ErrorSubsystem.ES_SUPP, 218, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--update (-u)'%: specifies to process only files that have no saved digest."
		public static int MsgSupp_OptionVerify = ErrorOf(ErrorSubsystem.ES_SUPP, 219, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--verify (-v)'%: specifies to recompute digests for all files."
		public static int MsgSupp_OptionNoArchive = ErrorOf(ErrorSubsystem.ES_SUPP, 220, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no-archive (-X)'%: specifies to skip files with the +X filetype."
		public static int MsgSupp_OptionServerid = ErrorOf(ErrorSubsystem.ES_SUPP, 221, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--serverid (-s)'%: specifies the serverid."
		public static int MsgSupp_OptionUnified = ErrorOf(ErrorSubsystem.ES_SUPP, 222, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--unified (-u)'%: specifies to display the diff in unified format."
		public static int MsgSupp_OptionPreviewNC = ErrorOf(ErrorSubsystem.ES_SUPP, 223, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--preview-noncontent (-N)'%: previews the operation, including non-content."
		public static int MsgSupp_OptionEstimates = ErrorOf(ErrorSubsystem.ES_SUPP, 224, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--estimates (-N)'%: specifies to display estimates about the work required."
		public static int MsgSupp_OptionLocked = ErrorOf(ErrorSubsystem.ES_SUPP, 225, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--locked (-L)'%: specifies that locked objects are to be included."
		public static int MsgSupp_OptionUnloadAll = ErrorOf(ErrorSubsystem.ES_SUPP, 226, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--unload-all (-a)'%: specifies that multiple objects are to be unloaded."
		public static int MsgSupp_OptionKeepHave = ErrorOf(ErrorSubsystem.ES_SUPP, 227, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--keep-have (-h)'%: specifies to leave target files at the currently synced revision."
		public static int MsgSupp_OptionYes = ErrorOf(ErrorSubsystem.ES_SUPP, 228, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--yes (-y)'%: causes prompts to be automatically accepted."
		public static int MsgSupp_OptionNo = ErrorOf(ErrorSubsystem.ES_SUPP, 229, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no (-n)'%: causes prompts to be automatically refused."
		public static int MsgSupp_OptionInputValue = ErrorOf(ErrorSubsystem.ES_SUPP, 230, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--value (-i)'%: specifies the value."
		public static int MsgSupp_OptionReplacement = ErrorOf(ErrorSubsystem.ES_SUPP, 231, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--replacement (-r)'%: specifies that a replacement is affected."
		public static int MsgSupp_OptionFrom = ErrorOf(ErrorSubsystem.ES_SUPP, 232, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--from'%: specifies the old value."
		public static int MsgSupp_OptionTo = ErrorOf(ErrorSubsystem.ES_SUPP, 233, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--to'%: specifies the new value."
		public static int MsgSupp_OptionRebuild = ErrorOf(ErrorSubsystem.ES_SUPP, 234, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--rebuild (-R)'%: rebuild the database."
		public static int MsgSupp_OptionEqual = ErrorOf(ErrorSubsystem.ES_SUPP, 235, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--equal (-e)'%: specifies the exact changelist."
		public static int MsgSupp_OptionAttrPattern = ErrorOf(ErrorSubsystem.ES_SUPP, 236, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--attribute-pattern (-A)'%: displays only attributes that match the pattern."
		public static int MsgSupp_OptionDiffListFlag = ErrorOf(ErrorSubsystem.ES_SUPP, 237, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--diff-list-flag (-s)'%: lists files that satisfy the flag value."
		public static int MsgSupp_OptionArguments = ErrorOf(ErrorSubsystem.ES_SUPP, 238, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--arguments (-a)'%: displays the arguments."
		public static int MsgSupp_OptionEnvironment = ErrorOf(ErrorSubsystem.ES_SUPP, 239, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--environment (-e)'%: displays the environment."
		public static int MsgSupp_OptionTaskStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 240, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--status (-s)'%: displays only commands that match the status."
		public static int MsgSupp_OptionAllUsers = ErrorOf(ErrorSubsystem.ES_SUPP, 241, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--all-users (-A)'%: specifies the command applies to all users."
		public static int MsgSupp_OptionParallel = ErrorOf(ErrorSubsystem.ES_SUPP, 242, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //
		public static int MsgSupp_OptionParallelSubmit = ErrorOf(ErrorSubsystem.ES_SUPP, 35, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //
		public static int MsgSupp_OptionPromote = ErrorOf(ErrorSubsystem.ES_SUPP, 243, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--promote (-p)'%: specifies to promote the shelf to the Commit Server."
		public static int MsgSupp_OptionInputFile = ErrorOf(ErrorSubsystem.ES_SUPP, 245, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--input-file'%: specifies the name of the input file."
		public static int MsgSupp_OptionPidFile = ErrorOf(ErrorSubsystem.ES_SUPP, 246, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--pid-file'%: specifies the name of the PID file."
		public static int MsgSupp_OptionLocalJournal = ErrorOf(ErrorSubsystem.ES_SUPP, 247, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--local-journal'%: specifies that the pull command should read journal records from a local journal file rather than from the target server."
		public static int MsgSupp_OptionTest = ErrorOf(ErrorSubsystem.ES_SUPP, 248, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--test (-t)'%: specifies a user to test against the LDAP configuration."
		public static int MsgSupp_OptionActive = ErrorOf(ErrorSubsystem.ES_SUPP, 249, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--active (-A)'%: only list the active LDAP configurations."
		public static int MsgSupp_OptionNoRetransfer = ErrorOf(ErrorSubsystem.ES_SUPP, 250, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--noretransfer'%: override submit.noretransfer configurable behavior."
		public static int MsgSupp_OptionForceNoRetransfer = ErrorOf(ErrorSubsystem.ES_SUPP, 251, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--forcenoretransfer'%: skip file transfer if archive files are found (undoc and not recommended)."
		public static int MsgSupp_OptionDurableOnly = ErrorOf(ErrorSubsystem.ES_SUPP, 252, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--durable-only'%: deliver only durable journal records."
		public static int MsgSupp_OptionNonAcknowledging = ErrorOf(ErrorSubsystem.ES_SUPP, 253, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--non-acknowledging'%: this request does not acknowledge previous journal records."
		public static int MsgSupp_OptionReplicationStatus = ErrorOf(ErrorSubsystem.ES_SUPP, 254, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--replication-status (-J)'%: show the replication status of the server and of its replicas."
		public static int MsgSupp_OptionGroupMode = ErrorOf(ErrorSubsystem.ES_SUPP, 255, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--groups (-g)'%: updates Perforce group users with LDAP group members."
		public static int MsgSupp_OptionUserMode = ErrorOf(ErrorSubsystem.ES_SUPP, 285, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--users (-u)'%: updates Perforce users from LDAP user."
		public static int MsgSupp_OptionUserModeCreate = ErrorOf(ErrorSubsystem.ES_SUPP, 286, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--create (-c)'%: creates new users found in LDAP."
		public static int MsgSupp_OptionUserModeCreateStrict = ErrorOf(ErrorSubsystem.ES_SUPP, 322, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--create-strict (-C)'%: creates new users found in LDAP, only if they would have access."
		public static int MsgSupp_OptionUserModeUpdate = ErrorOf(ErrorSubsystem.ES_SUPP, 287, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--update (-U)'%: updates existing users found in LDAP."
		public static int MsgSupp_OptionUserModeDelete = ErrorOf(ErrorSubsystem.ES_SUPP, 288, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--delete (-d)'%: deletes users not found in LDAP."
		public static int MsgSupp_OptionBypassExlusiveLock = ErrorOf(ErrorSubsystem.ES_SUPP, 256, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--bypass-exclusive-lock'%: allow command on (+l) filetype even if already exclusively opened."
		public static int MsgSupp_OptionRetainLbrRevisions = ErrorOf(ErrorSubsystem.ES_SUPP, 261, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--retain-lbr-revisions'%: don't rename library archive files with the renamed changelist number."
		public static int MsgSupp_OptionCreate = ErrorOf(ErrorSubsystem.ES_SUPP, 257, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--create (-c)'%: Create a new stream and populate it with files from the current stream. (dvcs only)"
		public static int MsgSupp_OptionList = ErrorOf(ErrorSubsystem.ES_SUPP, 258, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--list (-l)'%: list all the streams available to your client."
		public static int MsgSupp_OptionMainline = ErrorOf(ErrorSubsystem.ES_SUPP, 259, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--mainline (-m)'%: Create this stream as an empty mainline (no parent)."
		public static int MsgSupp_OptionMoveChanges = ErrorOf(ErrorSubsystem.ES_SUPP, 260, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--movechanges (-r)'%: Move open files to the stream you are switching to, instead of shelving and reverting them."
		public static int MsgSupp_OptionJavaProtocol = ErrorOf(ErrorSubsystem.ES_SUPP, 262, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--java'%: enable Java support via the rsh protocol."
		public static int MsgSupp_OptionPullBatch = ErrorOf(ErrorSubsystem.ES_SUPP, 263, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--batch'%: pull N archives in a single request to master."
		public static int MsgSupp_OptionDepotType = ErrorOf(ErrorSubsystem.ES_SUPP, 265, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--depot-type (-t)'%: specifies the type of depot"
		public static int MsgSupp_OptionClientType = ErrorOf(ErrorSubsystem.ES_SUPP, 280, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--client-type'%: specifies the type of client."
		public static int MsgSupp_OptionGlobalLock = ErrorOf(ErrorSubsystem.ES_SUPP, 266, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--global (-g)'%: reports or changes global locks from Edge Server"
		public static int MsgSupp_OptionEnableDVCSTriggers = ErrorOf(ErrorSubsystem.ES_SUPP, 267, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--enable-dvcs-triggers'%: fires any push-* triggers for changelists imported by this unzip command."
		public static int MsgSupp_OptionUsers = ErrorOf(ErrorSubsystem.ES_SUPP, 269, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--users (-u)'%: show the user who modifed the line."
		public static int MsgSupp_OptionConvertAdminComments = ErrorOf(ErrorSubsystem.ES_SUPP, 270, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--convert-p4admin-comments'%: When used with -o option converts P4Admin style comments into new ## native spec comments."
		public static int MsgSupp_OptionRemoteSpec = ErrorOf(ErrorSubsystem.ES_SUPP, 271, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--remote'%: Specifies the remote spec to be used."
		public static int MsgSupp_OptionP4UserUser = ErrorOf(ErrorSubsystem.ES_SUPP, 272, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--me'%: Shorthand for -u $P4USER"
		public static int MsgSupp_OptionAliases = ErrorOf(ErrorSubsystem.ES_SUPP, 273, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--aliases'%: specifies alias-handling behavior."
		public static int MsgSupp_OptionField = ErrorOf(ErrorSubsystem.ES_SUPP, 274, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--field'%: Modify spec fields from the command line."
		public static int MsgSupp_OptionTab = ErrorOf(ErrorSubsystem.ES_SUPP, 275, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //
		public static int MsgSupp_OptionForceDelete = ErrorOf(ErrorSubsystem.ES_SUPP, 277, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--force-delete'%: delete entity from protects and groups."
		public static int MsgSupp_OptionStorageType = ErrorOf(ErrorSubsystem.ES_SUPP, 278, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--type'% (-T): specifies the type of client (writeable/readonly/graph)."
		public static int MsgSupp_OptionAtomicPush = ErrorOf(ErrorSubsystem.ES_SUPP, 279, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--atomic'%: specifies that all references must pass their checks in order for any reference updates to occur."
		public static int MsgSupp_OptionColor = ErrorOf(ErrorSubsystem.ES_SUPP, 281, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--color'%: Force color output on the command line."
		public static int MsgSupp_OptionChangeFiles = ErrorOf(ErrorSubsystem.ES_SUPP, 282, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--show-files'%: specifies to display the individual files."
		public static int MsgSupp_OptionDiscardArchives = ErrorOf(ErrorSubsystem.ES_SUPP, 283, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //
		public static int MsgSupp_OptionLicenseInfo = ErrorOf(ErrorSubsystem.ES_SUPP, 284, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--license-info'%: report license status information."
		public static int MsgSupp_OptionRename = ErrorOf(ErrorSubsystem.ES_SUPP, 290, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--rename (-r)'%: rename existing files without changing content."
		public static int MsgSupp_TooManyLockTrys = ErrorOf(ErrorSubsystem.ES_SUPP, 268, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Too many trys to get lock %file%."
		public static int MsgSupp_OptionRemoteUser = ErrorOf(ErrorSubsystem.ES_SUPP, 289, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //
		public static int MsgSupp_OptionIgnoreCMap = ErrorOf(ErrorSubsystem.ES_SUPP, 291, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--ignore-changeview'%: Ignore the limits imposed by the changview."
		public static int MsgSupp_OptionMirror = ErrorOf(ErrorSubsystem.ES_SUPP, 292, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--mirror'%: specifies that this update is for a mirrored repo."
		public static int MsgSupp_OptionDaemonSafe = ErrorOf(ErrorSubsystem.ES_SUPP, 293, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--daemonsafe'%: Start server as daemon with stdio closed."
		public static int MsgSupp_OptionTrigger = ErrorOf(ErrorSubsystem.ES_SUPP, 294, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--trigger'%: Pull archive content using an external trigger."
		public static int MsgSupp_OptionIgnoreHave = ErrorOf(ErrorSubsystem.ES_SUPP, 295, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--ignore-have'%: specifies that the publish option (-p) ignore any have records."
		public static int MsgSupp_OptionGraphOnly = ErrorOf(ErrorSubsystem.ES_SUPP, 296, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--graph-only'%: skip any non-graph results."
		public static int MsgSupp_OptionMinSize = ErrorOf(ErrorSubsystem.ES_SUPP, 297, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--min-size'%: Pull archive trigger min file size."
		public static int MsgSupp_OptionMaxSize = ErrorOf(ErrorSubsystem.ES_SUPP, 298, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--max-size'%: Pull archive trigger max file size."
		public static int MsgSupp_OptionNameOnly = ErrorOf(ErrorSubsystem.ES_SUPP, 299, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--name-only'%: List only filenames."
		public static int MsgSupp_OptionNoFastForward = ErrorOf(ErrorSubsystem.ES_SUPP, 300, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--no-ff'%: Create a merge commit even when the merge resolves as a fast-forward."
		public static int MsgSupp_OptionFastForwardOnly = ErrorOf(ErrorSubsystem.ES_SUPP, 301, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--ff-only'%: Refuse to merge unless the current HEAD is already up-to-date or merge can be resolved as a fast-forward."
		public static int MsgSupp_OptionMustExist = ErrorOf(ErrorSubsystem.ES_SUPP, 302, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--exists'%: Only output spec if it exists."
		public static int MsgSupp_OptionRepoName = ErrorOf(ErrorSubsystem.ES_SUPP, 303, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--repo'%: specifies the repo for a non-interactive merge."
		public static int MsgSupp_OptionTargetBranch = ErrorOf(ErrorSubsystem.ES_SUPP, 304, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--target'%: specifies the target branch for a non-interactive merge."
		public static int MsgSupp_OptionByUser = ErrorOf(ErrorSubsystem.ES_SUPP, 305, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--user (-u)'%: limit output to repos readable by specified user or group."
		public static int MsgSupp_OptionByOwner = ErrorOf(ErrorSubsystem.ES_SUPP, 306, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--owner (-O)'%: limit output to repos owned by specified user or group."
		public static int MsgSupp_OptionSquash = ErrorOf(ErrorSubsystem.ES_SUPP, 307, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--squash'%: Create a single commit on top of the specified branch, with content from the merge."
		public static int MsgSupp_OptionAllowEmpty = ErrorOf(ErrorSubsystem.ES_SUPP, 308, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--allow-empty'%: allows submitting empty repo commit."
		public static int MsgSupp_OptionAdded = ErrorOf(ErrorSubsystem.ES_SUPP, 309, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--added (-a)'%: display content of added files."
		public static int MsgSupp_OptionCreateIndex = ErrorOf(ErrorSubsystem.ES_SUPP, 310, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--create-index'%: create repo index for direct file history access."
		public static int MsgSupp_OptionDropIndex = ErrorOf(ErrorSubsystem.ES_SUPP, 311, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--drop-index'%: drop repo index."
		public static int MsgSupp_OptionRepoName2 = ErrorOf(ErrorSubsystem.ES_SUPP, 323, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--repo (-n)'%: specifies the repo."
		public static int MsgSupp_OptionRetry = ErrorOf(ErrorSubsystem.ES_SUPP, 318, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--retry (-R)'%: retry transfer of files that failed to transfer."
		public static int MsgSupp_OptionReference = ErrorOf(ErrorSubsystem.ES_SUPP, 325, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--reference (-r)'%: specifies the reference."
		public static int MsgSupp_OptionPerm = ErrorOf(ErrorSubsystem.ES_SUPP, 326, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--permission (-p)'%: specifies the permission."
		public static int MsgSupp_JsmnBadType = ErrorOf(ErrorSubsystem.ES_SUPP, 312, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 3); //"JSON error: token not expected type. Token number %index% Expected type %expected% Observed type %observed%."
		public static int MsgSupp_JsmnBadParent = ErrorOf(ErrorSubsystem.ES_SUPP, 313, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 3); //"JSON error: token does not have the expected parent. Token number %index% Expected parent index %expected% Observed parent index %observed%."
		public static int MsgSupp_JsmnBadMem = ErrorOf(ErrorSubsystem.ES_SUPP, 314, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 1); //"JSON error: parse failed, input has too many tokens. Limit is %limit%."
		public static int MsgSupp_JsmnBadSyn = ErrorOf(ErrorSubsystem.ES_SUPP, 315, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"JSON error: parse failed, bad syntax."
		public static int MsgSupp_JsmnTooFew = ErrorOf(ErrorSubsystem.ES_SUPP, 316, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 0); //"JSON error: parse failed, missing tokens."
		public static int MsgSupp_JsmnKeyNotFound = ErrorOf(ErrorSubsystem.ES_SUPP, 317, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CONFIG, 2); //"JSON error: not found key name \"
		public static int MsgSupp_ZCLoadLibFailed = ErrorOf(ErrorSubsystem.ES_SUPP, 24, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 0); //"Perforce failed to load zeroconf dynamic libraries."
		public static int MsgSupp_ZCInvalidName = ErrorOf(ErrorSubsystem.ES_SUPP, 25, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid name '%name%'."
		public static int MsgSupp_ZCRequireName = ErrorOf(ErrorSubsystem.ES_SUPP, 26, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Perforce requires IDname '-In' to register with zeroconf."
		public static int MsgSupp_ZCNameConflict = ErrorOf(ErrorSubsystem.ES_SUPP, 27, ErrorSeverity.E_FATAL, ErrorGeneric.EV_ADMIN, 3); //"*** WARNING duplicate of '%name%' at '%host%:%port%' ***"
		public static int MsgSupp_ZCRegistryFailed = ErrorOf(ErrorSubsystem.ES_SUPP, 28, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 1); //"Perforce could not register with zeroconf: error is %err%"
		public static int MsgSupp_ZCBrowseFailed = ErrorOf(ErrorSubsystem.ES_SUPP, 29, ErrorSeverity.E_WARN, ErrorGeneric.EV_ADMIN, 2); //"Perforce could not browse zeroconf/%implementation%: error is %err%"
		public static int MsgSupp_OptionShowFlags = ErrorOf(ErrorSubsystem.ES_SUPP, 147, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"%'--show-flags (-s)'%: lists the files that satisfy the condition."
	}
}
