using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;

namespace Perforce.P4
{
	public partial class P4ClientError
	{
		public static int MsgGraph_CommitDataShort = ErrorOf(ErrorSubsystem.ES_OS, 1, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"commit %sha%\ntree %tree%\n%description%\n"
		public static int MsgGraph_UseGraph = ErrorOf(ErrorSubsystem.ES_OS, 61, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: see %'p4 help graph'%"
		public static int MsgGraph_UseCatFile = ErrorOf(ErrorSubsystem.ES_OS, 2, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'cat-file [ commit | -n repo blob | -t ] object-sha'%"
		public static int MsgGraph_UseChanges = ErrorOf(ErrorSubsystem.ES_OS, 226, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'changes [-m max] -n repo commit...'%"
		public static int MsgGraph_UseLsTree = ErrorOf(ErrorSubsystem.ES_OS, 3, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'ls-tree [ -r [--name-only] ]  treeish-sha'%\n%'       ls-tree [ -r [--name-only] ] -n //repo/name [commit|reference]'%"
		public static int MsgGraph_UseDescribe = ErrorOf(ErrorSubsystem.ES_OS, 230, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'describe -n repo [-s] commit'%"
		public static int MsgGraph_UseDiff = ErrorOf(ErrorSubsystem.ES_OS, 259, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'diff [ -d<flags> -sr ] [files...]'%"
		public static int MsgGraph_UseDiffTree = ErrorOf(ErrorSubsystem.ES_OS, 4, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'diff-tree -n repo tree-1-sha tree-2-sha'%"
		public static int MsgGraph_UseDiff2 = ErrorOf(ErrorSubsystem.ES_OS, 223, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'diff2 [ -d<flags> -Od -q -u ] file file2'%"
		public static int MsgGraph_UseDirs = ErrorOf(ErrorSubsystem.ES_OS, 228, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'dirs filespec'%"
		public static int MsgGraph_UseFilelog = ErrorOf(ErrorSubsystem.ES_OS, 235, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'filelog [ -d -m max --first-parent ] -n repo filespec'%"
		public static int MsgGraph_FollowDeletedWildcard = ErrorOf(ErrorSubsystem.ES_OS, 317, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Wildcard in path not allowed with -d."
		public static int MsgGraph_UseFiles = ErrorOf(ErrorSubsystem.ES_OS, 224, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'files [-m max] filespec'%"
		public static int MsgGraph_UseFstat = ErrorOf(ErrorSubsystem.ES_OS, 262, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'fstat [ -m max ] file...'%"
		public static int MsgGraph_UseLock = ErrorOf(ErrorSubsystem.ES_OS, 246, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'lock [-c change] file...'%"
		public static int MsgGraph_UseLog = ErrorOf(ErrorSubsystem.ES_OS, 6, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'log -n repo [ -u user -A date -B date -p -N N -X N ] [ -a | -m N ] [ commit... ]'%"
		public static int MsgGraph_UseShowRef = ErrorOf(ErrorSubsystem.ES_OS, 58, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'show-ref [ -a -n repo -u user -t type -m N -e|-E filter]'%"
		public static int MsgGraph_UseMerge = ErrorOf(ErrorSubsystem.ES_OS, 7, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'merge [ -n ] [ --ff-only ] [ --no-ff | --squash ] other-branch'%"
		public static int MsgGraph_UseMerge2 = ErrorOf(ErrorSubsystem.ES_OS, 330, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'merge [ -n ] [ --ff-only ] [ --no-ff | --squash ] --repo repo --target target-branch other-branch'%"
		public static int MsgGraph_UseRebase = ErrorOf(ErrorSubsystem.ES_OS, 327, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'graph rebase [ -r ref -f ] --repo repo --target target source'%"
		public static int MsgGraph_UseCherryPick = ErrorOf(ErrorSubsystem.ES_OS, 328, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'graph cherry-pick [ -r ref -f ] --repo repo --target target source'%"
		public static int MsgGraph_UseOpen = ErrorOf(ErrorSubsystem.ES_OS, 221, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'add/edit/delete [-c changelist#] [-n] [-t type] files...'%"
		public static int MsgGraph_UseTag = ErrorOf(ErrorSubsystem.ES_OS, 211, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'tag -n repo [ -d tag | -l [ -m max ] | -c comment | -o ] tag [ sha ]'%"
		public static int MsgGraph_UseTags = ErrorOf(ErrorSubsystem.ES_OS, 335, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'graph tags [-o] [-m max]'%"
		public static int MsgGraph_UseReconcile = ErrorOf(ErrorSubsystem.ES_OS, 261, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'reconcile [ -a -e -d -n -c change ]'%"
		public static int MsgGraph_UseReopen = ErrorOf(ErrorSubsystem.ES_OS, 257, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'reopen [-c changelist#] files...'%"
		public static int MsgGraph_UseResolve = ErrorOf(ErrorSubsystem.ES_OS, 220, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'resolve'%"
		public static int MsgGraph_UseResolved = ErrorOf(ErrorSubsystem.ES_OS, 244, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'resolved'%"
		public static int MsgGraph_UseRevert = ErrorOf(ErrorSubsystem.ES_OS, 222, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'revert [ -n -w -a -c changelist# ] files...'%"
		public static int MsgGraph_UseSwitch = ErrorOf(ErrorSubsystem.ES_OS, 216, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'switch [-l | [-a|-c|-d|-n repo] branch]'%"
		public static int MsgGraph_UseUnlock = ErrorOf(ErrorSubsystem.ES_OS, 247, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'unlock [-c change] file...'%"
		public static int MsgGraph_UseReceivePack = ErrorOf(ErrorSubsystem.ES_OS, 59, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'receive-pack -n repo [-u user -v] -i files... [ -r refs... | -F refs... | -p packed-refs ]'%"
		public static int MsgGraph_UsePackObjects = ErrorOf(ErrorSubsystem.ES_OS, 60, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'pack-objects -n repo [-u user] -o git-pack-dir [ -a | commit... ]'%"
		public static int MsgGraph_UseGraphSync = ErrorOf(ErrorSubsystem.ES_OS, 62, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'sync [-f -n -q -k] [ commit... ]'%"
		public static int MsgGraph_UseGraphProtects = ErrorOf(ErrorSubsystem.ES_OS, 66, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'protects -n repo -u user [ -r reference ] [ file... ]'%"
		public static int MsgGraph_UseGraphList = ErrorOf(ErrorSubsystem.ES_OS, 69, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'list-repos [ -n repo -u user -m max ]'%"
		public static int MsgGraph_UseGraphCollect = ErrorOf(ErrorSubsystem.ES_OS, 77, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'collect [ -n -A -t days ]'%"
		public static int MsgGraph_UseGraphForkRepo = ErrorOf(ErrorSubsystem.ES_OS, 80, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'fork-repo [ -u user ] -n repo -t new-repo'%"
		public static int MsgGraph_UseGraphDeleteRepo = ErrorOf(ErrorSubsystem.ES_OS, 81, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'delete-repo [ -u user] -n repo'%"
		public static int MsgGraph_UseGraphLFSPush = ErrorOf(ErrorSubsystem.ES_OS, 89, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'lfs-push [ -u user ] -n repo -i /path/to/lfs/file -r sha-256-hash'%"
		public static int MsgGraph_UseGraphLFSFetch = ErrorOf(ErrorSubsystem.ES_OS, 90, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'lfs-fetch [ -u user ] -n repo -o /path/to/lfs/file -r sha-256-hash'%"
		public static int MsgGraph_UseGraphLFSStat = ErrorOf(ErrorSubsystem.ES_OS, 144, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'lfs-stat [ -u user ] -n repo oid...'%"
		public static int MsgGraph_UseGraphSubmodule = ErrorOf(ErrorSubsystem.ES_OS, 252, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'submodule -n repo [-p path -t submodule -d -l]'%"
		public static int MsgGraph_UseGraphVerify = ErrorOf(ErrorSubsystem.ES_OS, 132, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'verify [-q] -n repo'%"
		public static int MsgGraph_UseGraphPackInfo = ErrorOf(ErrorSubsystem.ES_OS, 284, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'pack-info -n repo'%"
		public static int MsgGraph_UsePermissionG = ErrorOf(ErrorSubsystem.ES_OS, 110, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'grant-permission [ -r ref ] -p perm -g group|-u user -d graphdepot|-n //repo/name'%"
		public static int MsgGraph_UsePermissionR = ErrorOf(ErrorSubsystem.ES_OS, 111, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'revoke-permission [ -r ref ] -p perm -g group|-u user -d graphdepot|-n //repo/name'%"
		public static int MsgGraph_UsePermissionS = ErrorOf(ErrorSubsystem.ES_OS, 112, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'show-permission [ -r ref ] [ -u user ] [ -g group ] [ -p perm ] -d graphdepot|-n //repo/name'%"
		public static int MsgGraph_UsePermissions = ErrorOf(ErrorSubsystem.ES_OS, 334, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'show-permissions [ -d graphdepot | -n //repo/name ] [ -u user ]'%"
		public static int MsgGraph_UsePermissionC = ErrorOf(ErrorSubsystem.ES_OS, 113, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'check-permission -n //repo/name [ -r ref ] -u user -p perm'%"
		public static int MsgGraph_UsePermNoRef = ErrorOf(ErrorSubsystem.ES_OS, 279, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Usage: -r (ref) not required for permission '%perm%'"
		public static int MsgGraph_UsePermNeedRef = ErrorOf(ErrorSubsystem.ES_OS, 290, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Usage: -r (ref) required for permission '%perm%'"
		public static int MsgGraph_UsePermBadRestrict = ErrorOf(ErrorSubsystem.ES_OS, 307, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Usage: -n (repo) required for permission '%perm%'"
		public static int MsgGraph_UseRefHist = ErrorOf(ErrorSubsystem.ES_OS, 115, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'ref-hist [ -n repo -r ref -u user -t reftype -a action -s start -e end -m max]'%"
		public static int MsgGraph_UsePubKey = ErrorOf(ErrorSubsystem.ES_OS, 127, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'pubkey -d | -i [-f] [-u user] [-s scope]'%"
		public static int MsgGraph_UsePubKeyS = ErrorOf(ErrorSubsystem.ES_OS, 128, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'pubkeys [-u user] [-s scope]'%"
		public static int MsgGraph_ReferenceData = ErrorOf(ErrorSubsystem.ES_OS, 8, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%depot% %sha% %owner% %type% %name%"
		public static int MsgGraph_ReferenceHistory = ErrorOf(ErrorSubsystem.ES_OS, 116, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 7); //"%repo% %sha% %type% %name% %action% %user% %date%"
		public static int MsgGraph_ReferenceDataShort = ErrorOf(ErrorSubsystem.ES_OS, 9, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% %sha% %name%"
		public static int MsgGraph_ReferenceDataMatch = ErrorOf(ErrorSubsystem.ES_OS, 302, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% %sha% %name% *"
		public static int MsgGraph_ReferenceDataEmpty = ErrorOf(ErrorSubsystem.ES_OS, 442, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% (no branches)"
		public static int MsgGraph_RepositoryData = ErrorOf(ErrorSubsystem.ES_OS, 70, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%repo%"
		public static int MsgGraph_FileLogData = ErrorOf(ErrorSubsystem.ES_OS, 10, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%depotFile%%depotRev% (%action%) %commit%"
		public static int MsgGraph_SubmoduleData = ErrorOf(ErrorSubsystem.ES_OS, 253, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%repo% %path% %subrepo%"
		public static int MsgGraph_WrongClientType = ErrorOf(ErrorSubsystem.ES_OS, 11, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"A client of this type may not have a view that includes %depotFile%"
		public static int MsgGraph_NotSupported = ErrorOf(ErrorSubsystem.ES_OS, 241, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"This operation is not supported."
		public static int MsgGraph_CmdNotSupported = ErrorOf(ErrorSubsystem.ES_OS, 249, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"'p4 %cmd%' is not supported when using a graph type client."
		public static int MsgGraph_CurrentBranchShort = ErrorOf(ErrorSubsystem.ES_OS, 12, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depot% %branchName%"
		public static int MsgGraph_DetachedHead = ErrorOf(ErrorSubsystem.ES_OS, 227, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%repoName% DETACHED HEAD"
		public static int MsgGraph_ReferenceHeadShort = ErrorOf(ErrorSubsystem.ES_OS, 13, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% %client% %sha%"
		public static int MsgGraph_ReferenceHaveShort = ErrorOf(ErrorSubsystem.ES_OS, 14, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% %client% %sha%"
		public static int MsgGraph_RepoDefaultBranch = ErrorOf(ErrorSubsystem.ES_OS, 117, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%repo% %branch% HEAD"
		public static int MsgGraph_NoSuchObject = ErrorOf(ErrorSubsystem.ES_OS, 15, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"No such object %sha%"
		public static int MsgGraph_NoSuchCommit = ErrorOf(ErrorSubsystem.ES_OS, 147, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"No commit named %sha%"
		public static int MsgGraph_NoSuchDepot = ErrorOf(ErrorSubsystem.ES_OS, 88, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"There is no graph depot named %depot%."
		public static int MsgGraph_UseRevList = ErrorOf(ErrorSubsystem.ES_OS, 16, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'rev-list -n repo [ -m N ] [ commit... ]'%"
		public static int MsgGraph_UseGraphDescribe = ErrorOf(ErrorSubsystem.ES_OS, 17, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'describe -n repo commit...'%"
		public static int MsgGraph_PackRefSyntax = ErrorOf(ErrorSubsystem.ES_OS, 18, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 1); //"Unrecognized syntax in packed-refs file: %line%"
		public static int MsgGraph_PackHeader = ErrorOf(ErrorSubsystem.ES_OS, 19, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failed to read pack header from %packfile%"
		public static int MsgGraph_PackMagic = ErrorOf(ErrorSubsystem.ES_OS, 20, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unrecognized packfile header in %packfile%"
		public static int MsgGraph_PackIndexCount = ErrorOf(ErrorSubsystem.ES_OS, 21, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 3); //"Pack file %packfile% has %packcount% objects, but index has %indexcount% objects."
		public static int MsgGraph_PackTypeByte = ErrorOf(ErrorSubsystem.ES_OS, 22, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failed to read object type byte from %packfile%"
		public static int MsgGraph_PackSizeByte = ErrorOf(ErrorSubsystem.ES_OS, 23, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"Failed to read object size byte from %packfile%. Error was on byte %bytenumber%."
		public static int MsgGraph_PackIdxFanoutRead = ErrorOf(ErrorSubsystem.ES_OS, 24, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failed to read fanout table from %indexfile%"
		public static int MsgGraph_PackIdxEndOfFile = ErrorOf(ErrorSubsystem.ES_OS, 25, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Premature EOF during SHA read from %indexfile%"
		public static int MsgGraph_PackIdxPartial = ErrorOf(ErrorSubsystem.ES_OS, 26, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unexpected partial SHA read from %indexfile%"
		public static int MsgGraph_PackOffsetEndOfFile = ErrorOf(ErrorSubsystem.ES_OS, 27, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Premature EOF during offset read from %indexfile%"
		public static int MsgGraph_PackOffsetPartial = ErrorOf(ErrorSubsystem.ES_OS, 28, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unexpected partial offset read from %indexfile%"
		public static int MsgGraph_PackIdxLargeEndOfFile = ErrorOf(ErrorSubsystem.ES_OS, 29, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Premature EOF during large offset read from %indexfile%"
		public static int MsgGraph_PackLargeOffsetPartial = ErrorOf(ErrorSubsystem.ES_OS, 30, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Unexpected partial large offset read from %indexfile%"
		public static int MsgGraph_DeltaVarint = ErrorOf(ErrorSubsystem.ES_OS, 31, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Failed to read varintZ byte"
		public static int MsgGraph_DeltaOffset = ErrorOf(ErrorSubsystem.ES_OS, 32, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failed to read delta source offset at %offset%"
		public static int MsgGraph_DeltaOffsetMore = ErrorOf(ErrorSubsystem.ES_OS, 33, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failed to read delta source offset continuation byte %bytenumber%"
		public static int MsgGraph_DeltaOffsetBits = ErrorOf(ErrorSubsystem.ES_OS, 34, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Delta offset bits %bits% are out of bounds."
		public static int MsgGraph_DeltaCopyOffset = ErrorOf(ErrorSubsystem.ES_OS, 35, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Failure reading offset bytes for delta copy instruction."
		public static int MsgGraph_DeltaLengthBits = ErrorOf(ErrorSubsystem.ES_OS, 36, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Delta length bits %bits% are out of bounds."
		public static int MsgGraph_DeltaCopyLength = ErrorOf(ErrorSubsystem.ES_OS, 37, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"Failure reading length bytes for delta copy instruction."
		public static int MsgGraph_DeltaRefBaseMissing = ErrorOf(ErrorSubsystem.ES_OS, 38, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failed to find source by reference sha %sha%"
		public static int MsgGraph_DeltaLengthMismatch = ErrorOf(ErrorSubsystem.ES_OS, 39, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"Delta instructions anticipated a result length of %expected%, but the actual result was length %actual%."
		public static int MsgGraph_DeltaInsertData = ErrorOf(ErrorSubsystem.ES_OS, 40, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Failure reading insert instruction bytes at byte %bytenumber%."
		public static int MsgGraph_CommitMissing = ErrorOf(ErrorSubsystem.ES_OS, 41, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit record not found in db for sha %sha%."
		public static int MsgGraph_CommitNotUnique = ErrorOf(ErrorSubsystem.ES_OS, 42, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Commit sha prefix %sha% is not unique. Please specify a longer prefix."
		public static int MsgGraph_TagMissing = ErrorOf(ErrorSubsystem.ES_OS, 78, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Tag record not found in db for sha %sha%."
		public static int MsgGraph_TagNotUnique = ErrorOf(ErrorSubsystem.ES_OS, 79, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Tag sha prefix %sha% is not unique. Please specify a longer prefix."
		public static int MsgGraph_NoEmailStart = ErrorOf(ErrorSubsystem.ES_OS, 43, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit object syntax error: email start not found in %line%."
		public static int MsgGraph_NoEmailEnd = ErrorOf(ErrorSubsystem.ES_OS, 44, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit object syntax error: email end not found in %line%."
		public static int MsgGraph_NoCommitDate = ErrorOf(ErrorSubsystem.ES_OS, 45, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Commit object syntax error: date not found in %line%."
		public static int MsgGraph_TreeModeEndOfFile = ErrorOf(ErrorSubsystem.ES_OS, 46, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"Tree parse error on %sha%: eof during mode parse at offset %offset%."
		public static int MsgGraph_TreeNameEndOfFile = ErrorOf(ErrorSubsystem.ES_OS, 47, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"Tree parse error on %sha%: eof during name parse at offset %offset%."
		public static int MsgGraph_TreeShaEndOfFile = ErrorOf(ErrorSubsystem.ES_OS, 48, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"Tree parse error on %sha%: eof during sha parse at offset %offset%."
		public static int MsgGraph_LbrShaSyntax = ErrorOf(ErrorSubsystem.ES_OS, 49, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"%sha% is not a valid blob sha."
		public static int MsgGraph_LbrWrongType = ErrorOf(ErrorSubsystem.ES_OS, 50, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"This librarian type only supports read-only access."
		public static int MsgGraph_InvalidBlobHeader = ErrorOf(ErrorSubsystem.ES_OS, 51, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Invalid object header for %sha%."
		public static int MsgGraph_LbrBadAccess = ErrorOf(ErrorSubsystem.ES_OS, 52, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"LbrGraphLoose: invalid operation %operation%."
		public static int MsgGraph_LbrPackBadAccess = ErrorOf(ErrorSubsystem.ES_OS, 53, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"LbrGraphPack: invalid operation %operation%."
		public static int MsgGraph_LooseWriterBadAccess = ErrorOf(ErrorSubsystem.ES_OS, 54, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"LbrGraphLooseWriter: invalid operation %operation%."
		public static int MsgGraph_LbrWriteOnly = ErrorOf(ErrorSubsystem.ES_OS, 55, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 0); //"This librarian type only supports write access."
		public static int MsgGraph_TreeMissing = ErrorOf(ErrorSubsystem.ES_OS, 56, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Tree record not found in db for sha %sha%."
		public static int MsgGraph_TreeNotUnique = ErrorOf(ErrorSubsystem.ES_OS, 57, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Tree sha prefix %sha% is not unique. Please specify a longer prefix."
		public static int MsgGraph_RcvRefSyntax = ErrorOf(ErrorSubsystem.ES_OS, 63, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //
		public static int MsgGraph_RcvFileName = ErrorOf(ErrorSubsystem.ES_OS, 64, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"File %filename% must be either a packfile or a loose object."
		public static int MsgGraph_NotFastForward = ErrorOf(ErrorSubsystem.ES_OS, 65, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 3); //"Reference %branchName% may not be set to %newSha% because that is not a fast-forward update from %currentSha%."
		public static int MsgGraph_NotFastForward2 = ErrorOf(ErrorSubsystem.ES_OS, 340, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 3); //"Reference %branchName% cannot be used as this would not be a fast-forward update from %oldSha% to %targetSha%."
		public static int MsgGraph_NotAGraphDepot = ErrorOf(ErrorSubsystem.ES_OS, 67, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%depotName% is not a graph depot."
		public static int MsgGraph_UnknownRepo = ErrorOf(ErrorSubsystem.ES_OS, 68, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%file% is not a repository in a graph depot."
		public static int MsgGraph_IllegalRefChar = ErrorOf(ErrorSubsystem.ES_OS, 71, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid character '%char%' in reference."
		public static int MsgGraph_IllegalRefSubstr = ErrorOf(ErrorSubsystem.ES_OS, 72, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid substring '%sequence%' in reference."
		public static int MsgGraph_UnqualifiedRef = ErrorOf(ErrorSubsystem.ES_OS, 73, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Unqualified reference name is not allowed here."
		public static int MsgGraph_InvalidParentChar = ErrorOf(ErrorSubsystem.ES_OS, 74, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Invalid character '%char%' in parent traversal."
		public static int MsgGraph_NoSuchParent = ErrorOf(ErrorSubsystem.ES_OS, 75, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Commit %sha% does not contain a reference to parent number %parent%."
		public static int MsgGraph_RefTargetMissing = ErrorOf(ErrorSubsystem.ES_OS, 76, ErrorSeverity.E_WARN, ErrorGeneric.EV_USAGE, 2); //"Reference %ref% specifies a non-existent commit %commit%."
		public static int MsgGraph_InvalidReference = ErrorOf(ErrorSubsystem.ES_OS, 82, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Reference %ref% could not be interpreted in repository %repository%"
		public static int MsgGraph_InvalidRepoRef = ErrorOf(ErrorSubsystem.ES_OS, 282, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Reference is not valid for repo %repo%!"
		public static int MsgGraph_InvalidRepo = ErrorOf(ErrorSubsystem.ES_OS, 83, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Repository %repository% does not appear to be valid."
		public static int MsgGraph_PackObjectCount = ErrorOf(ErrorSubsystem.ES_OS, 84, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 2); //"Pack construction wrote %actual% objects rather than the anticipated %expected% objects."
		public static int MsgGraph_PackObjectMissing = ErrorOf(ErrorSubsystem.ES_OS, 85, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Pack construction failure: object %sha% missing from database."
		public static int MsgGraph_PackFileMissing = ErrorOf(ErrorSubsystem.ES_OS, 303, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Pack file missing."
		public static int MsgGraph_PackObjectLength = ErrorOf(ErrorSubsystem.ES_OS, 86, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 3); //"Pack verification failure: Expected object of type %objectType% and length %objectLength% but uncompressed an object of length %actualLength%."
		public static int MsgGraph_InvalidRepoName = ErrorOf(ErrorSubsystem.ES_OS, 87, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Repository name [%repoName% is invalid|is missing]. Please specify a name in the format //depot-name/path/to/repo."
		public static int MsgGraph_InvalidDepotName = ErrorOf(ErrorSubsystem.ES_OS, 255, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Graph Depot name %depotName% is invalid. The name may not include the string %'.git'%."
		public static int MsgGraph_NotASha256 = ErrorOf(ErrorSubsystem.ES_OS, 92, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%sha% is not a valid SHA-256 value."
		public static int MsgGraph_LFSShaMismatch = ErrorOf(ErrorSubsystem.ES_OS, 93, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"LFS file push failure: content sha was %actual% instead of the expected sha %expected%."
		public static int MsgGraph_LFSAlreadyPresent = ErrorOf(ErrorSubsystem.ES_OS, 143, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"LFS blob %sha% already exists."
		public static int MsgGraph_AtomicPushFailed = ErrorOf(ErrorSubsystem.ES_OS, 94, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Reference %ref% could not be updated, and the command specified --atomic. No reference updates were performed."
		public static int MsgGraph_TriggerErrorMessage = ErrorOf(ErrorSubsystem.ES_OS, 95, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"%msg%"
		public static int MsgGraph_UseRepo = ErrorOf(ErrorSubsystem.ES_OS, 96, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'repo [ -i -o -d -f ] [ repo ]'%"
		public static int MsgGraph_UseRepoo = ErrorOf(ErrorSubsystem.ES_OS, 97, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'repo -o repo'%"
		public static int MsgGraph_UseRepod = ErrorOf(ErrorSubsystem.ES_OS, 98, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'repo -d [ -f ] repo'%"
		public static int MsgGraph_UseRepoi = ErrorOf(ErrorSubsystem.ES_OS, 99, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'repo -i'%"
		public static int MsgGraph_UseRepoc = ErrorOf(ErrorSubsystem.ES_OS, 298, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'repo [ --create-index | --drop-index ] [ repo ]'%"
		public static int MsgGraph_UseRepos = ErrorOf(ErrorSubsystem.ES_OS, 100, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //
		public static int MsgGraph_ReposData = ErrorOf(ErrorSubsystem.ES_OS, 101, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%repo% %owner% %forked% %created% %description%"
		public static int MsgGraph_RepoSave = ErrorOf(ErrorSubsystem.ES_OS, 102, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Repo %repoName% saved."
		public static int MsgGraph_RepoNoChange = ErrorOf(ErrorSubsystem.ES_OS, 103, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Repo %repoName% not changed."
		public static int MsgGraph_RepoDelete = ErrorOf(ErrorSubsystem.ES_OS, 104, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Repo %repoName% deleted."
		public static int MsgGraph_NoSuchRepo = ErrorOf(ErrorSubsystem.ES_OS, 105, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 1); //"Repo '%repo%' doesn't exist."
		public static int MsgGraph_BadRepoName = ErrorOf(ErrorSubsystem.ES_OS, 106, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Repo name '%repo%' invalid. Specify name as //depot/repo/name."
		public static int MsgGraph_NotInGraphDepot = ErrorOf(ErrorSubsystem.ES_OS, 107, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Repo name '%repo%' must be located in a valid graph depot."
		public static int MsgGraph_CantAutocreateRepo = ErrorOf(ErrorSubsystem.ES_OS, 108, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Repo '%repo%' does not exist in this server, and server policy prevents automatic creation of new repos. Please contact the server administrator to create the repo, then retry the operation."
		public static int MsgGraph_OutOfRepoLicenses = ErrorOf(ErrorSubsystem.ES_OS, 273, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ADMIN, 1); //"Repo '%repo%' does not exist in this server, and server has hit maximum limit for new repos."
		public static int MsgGraph_MustForceFork = ErrorOf(ErrorSubsystem.ES_OS, 109, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Repo %repo% was forked from %forkedRepo%. To create a fork of a fork, specify -f."
		public static int MsgGraph_ShowPermission = ErrorOf(ErrorSubsystem.ES_OS, 114, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"%repo% %branch% %type% %user% %perm%"
		public static int MsgGraph_DepotHasRepos = ErrorOf(ErrorSubsystem.ES_OS, 118, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NOTYET, 2); //"Depot %depot% isn't empty of repos. One or more repos are still present in the depot directory. Display the existing repos with %'p4 repos -e'% %depotPrefix%. Delete those repos using %'p4 repo -d'%, then retry the depot deletion."
		public static int MsgGraph_EmptyRepo = ErrorOf(ErrorSubsystem.ES_OS, 119, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 1); //"%repo% is empty."
		public static int MsgGraph_AmbiguousRefUpdate = ErrorOf(ErrorSubsystem.ES_OS, 129, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 3); //"Reference %ref% may not be set to both %sha% and %otherSha%."
		public static int MsgGraph_CantCreateRepo = ErrorOf(ErrorSubsystem.ES_OS, 121, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"User %user% does not have administrative privileges to create repo %repo%."
		public static int MsgGraph_CantWriteAllRepo = ErrorOf(ErrorSubsystem.ES_OS, 163, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"User %user% does not have write-all permission to initially import repo %repo%."
		public static int MsgGraph_CantDeleteRepo = ErrorOf(ErrorSubsystem.ES_OS, 124, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"User %user% does not have administrative privileges to delete repo %repo%."
		public static int MsgGraph_CantPruneRepo = ErrorOf(ErrorSubsystem.ES_OS, 154, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"User %user% does not have administrative privileges to delete out of date packfiles from repo %repo%."
		public static int MsgGraph_CantChangeView = ErrorOf(ErrorSubsystem.ES_OS, 158, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client %client% has already been used to sync files. Run %'p4 sync //...#none'%, then retry this command."
		public static int MsgGraph_RepoAccessDenied = ErrorOf(ErrorSubsystem.ES_OS, 122, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%repo% - access denied."
		public static int MsgGraph_NoPermissionOnRef = ErrorOf(ErrorSubsystem.ES_OS, 123, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 3); //"User %user% does not have %permission% privilege for reference %ref%."
		public static int MsgGraph_NoMatchPermissions = ErrorOf(ErrorSubsystem.ES_OS, 125, ErrorSeverity.E_WARN, ErrorGeneric.EV_EMPTY, 0); //"No matching permissions."
		public static int MsgGraph_NoLFSPushPerm = ErrorOf(ErrorSubsystem.ES_OS, 145, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"User %user% does not have permission to push LFS files to repo %repo%."
		public static int MsgGraph_NoLFSFetchPerm = ErrorOf(ErrorSubsystem.ES_OS, 146, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"User %user% does not have permission to fetch LFS files from repo %repo%."
		public static int MsgGraph_PubKeyData = ErrorOf(ErrorSubsystem.ES_OS, 126, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%key%"
		public static int MsgGraph_BadPublicKey = ErrorOf(ErrorSubsystem.ES_OS, 130, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"pubkey failed - error with public key!"
		public static int MsgGraph_PubKeyTooLong = ErrorOf(ErrorSubsystem.ES_OS, 135, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"pubkey failed - too long!"
		public static int MsgGraph_PubKeyDuplicate = ErrorOf(ErrorSubsystem.ES_OS, 136, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"pubkey failed - duplicate key exists!"
		public static int MsgGraph_PubKeyUpdateAction = ErrorOf(ErrorSubsystem.ES_OS, 131, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Public Key for %user% with %scope% scope updated."
		public static int MsgGraph_PubKeyDeleteAction = ErrorOf(ErrorSubsystem.ES_OS, 281, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Public Key for %user% with %scope% scope deleted."
		public static int MsgGraph_PubKeyNotExist = ErrorOf(ErrorSubsystem.ES_OS, 150, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Public Key for %user% with %scope% scope does not exist."
		public static int MsgGraph_PubKeyNeedsForce = ErrorOf(ErrorSubsystem.ES_OS, 157, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Public Key for '%user%/%scope%' already exists, use '-f' to replace."
		public static int MsgGraph_BlobVerified = ErrorOf(ErrorSubsystem.ES_OS, 133, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%sha% %file%"
		public static int MsgGraph_BlobDamaged = ErrorOf(ErrorSubsystem.ES_OS, 134, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 3); //"%file% is damaged: expected %expectedSha% actual %actualSha%"
		public static int MsgGraph_LFSBlobVerified = ErrorOf(ErrorSubsystem.ES_OS, 156, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"LFS File %LFSFile%"
		public static int MsgGraph_LFSBlobDamaged = ErrorOf(ErrorSubsystem.ES_OS, 91, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"LFS file %LFSFile% is damaged: actual %actualSha%"
		public static int MsgGraph_ArchiveImported = ErrorOf(ErrorSubsystem.ES_OS, 137, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Pack %file% imported."
		public static int MsgGraph_ReferenceAdded = ErrorOf(ErrorSubsystem.ES_OS, 138, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Reference %ref% added with value %sha%."
		public static int MsgGraph_ReferenceUpdated = ErrorOf(ErrorSubsystem.ES_OS, 139, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Reference %ref% updated to value %sha%."
		public static int MsgGraph_ReferenceDeleted = ErrorOf(ErrorSubsystem.ES_OS, 140, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Reference %ref% deleted."
		public static int MsgGraph_ReferenceForced = ErrorOf(ErrorSubsystem.ES_OS, 141, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Reference %ref% force pushed to new value %sha%."
		public static int MsgGraph_ObjectStatistics = ErrorOf(ErrorSubsystem.ES_OS, 142, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Objects added: %commits%/%total% (commits/total)."
		public static int MsgGraph_ForkTargetNotEmpty = ErrorOf(ErrorSubsystem.ES_OS, 148, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Cannot fork into repo %targetRepo% because it is not empty."
		public static int MsgGraph_ForkTargetIsSource = ErrorOf(ErrorSubsystem.ES_OS, 149, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Cannot fork %targetRepo% to itself."
		public static int MsgGraph_DanglingObject = ErrorOf(ErrorSubsystem.ES_OS, 151, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 3); //"Object %parentSha% refers to nonexistent child object %childNumber% %childSha%"
		public static int MsgGraph_BlobMissing = ErrorOf(ErrorSubsystem.ES_OS, 152, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Blob data not found in archives for sha %sha%."
		public static int MsgGraph_LFSBlobMissing = ErrorOf(ErrorSubsystem.ES_OS, 155, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"LFS Blob file not found in archives for sha-256 %sha%."
		public static int MsgGraph_NoRepoSelected = ErrorOf(ErrorSubsystem.ES_OS, 153, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client %client% has no repos mapped. This command requires at least one repo to be mapped in the client's view."
		public static int MsgGraph_RefAlreadyExists = ErrorOf(ErrorSubsystem.ES_OS, 159, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Reference %refName% already exists."
		public static int MsgGraph_RefDoesntExist = ErrorOf(ErrorSubsystem.ES_OS, 160, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Reference %refName% does not exist[ in repo %repo%]."
		public static int MsgGraph_RefValidation = ErrorOf(ErrorSubsystem.ES_OS, 161, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Reference update failed to validate. Reference %refName% may not be given the value %newSha% because the reference was expected to refer to %checkSha% but it actually refers to %headSha%."
		public static int MsgGraph_SpecifyForce = ErrorOf(ErrorSubsystem.ES_OS, 162, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"To change the value of the %fieldName% field, you must specify the -f flag."
		public static int MsgGraph_OpenSuccess = ErrorOf(ErrorSubsystem.ES_OS, 200, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - opened for %action%"
		public static int MsgGraph_NoMultiRepoSubmit = ErrorOf(ErrorSubsystem.ES_OS, 201, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Client %client% must specify precisely one repo in its View."
		public static int MsgGraph_NoReposForSubmit = ErrorOf(ErrorSubsystem.ES_OS, 299, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"None of repos involved by this change are mapped by this client."
		public static int MsgGraph_SingleRepoOnly = ErrorOf(ErrorSubsystem.ES_OS, 203, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"This command requires that exactly 1 repo be mapped by this client."
		public static int MsgGraph_DiffData = ErrorOf(ErrorSubsystem.ES_OS, 204, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //
		public static int MsgGraph_NotAtHead = ErrorOf(ErrorSubsystem.ES_OS, 205, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 5); //"%command% failed: In %repo%, the head of %branch% is currently %headRef%, but your client is currently at %haveRef%. Sync to the head and try again."
		public static int MsgGraph_RepoNotHad = ErrorOf(ErrorSubsystem.ES_OS, 263, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Submit failed: Your client includes %repo%, but you are not currently synced to that repo. You must sync to the head before submitting."
		public static int MsgGraph_SyncAdd = ErrorOf(ErrorSubsystem.ES_OS, 206, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - added as %localPath%"
		public static int MsgGraph_SyncDelete = ErrorOf(ErrorSubsystem.ES_OS, 207, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - deleted as %localPath%"
		public static int MsgGraph_SyncUpdate = ErrorOf(ErrorSubsystem.ES_OS, 208, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - updating %localPath%"
		public static int MsgGraph_SyncIntegUpdate = ErrorOf(ErrorSubsystem.ES_OS, 209, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - is opened and not being changed"
		public static int MsgGraph_SyncIntegDelete = ErrorOf(ErrorSubsystem.ES_OS, 258, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - is opened for delete -- not changed"
		public static int MsgGraph_SyncUptodate = ErrorOf(ErrorSubsystem.ES_OS, 210, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - is up-to-date"
		public static int MsgGraph_SyncRefresh = ErrorOf(ErrorSubsystem.ES_OS, 276, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - refreshing %localPath%"
		public static int MsgGraph_RefAlreadySet = ErrorOf(ErrorSubsystem.ES_OS, 212, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Reference %ref% already has a value; specify -f to force the new value."
		public static int MsgGraph_NoSuchTag = ErrorOf(ErrorSubsystem.ES_OS, 213, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"No such tag %tagName%"
		public static int MsgGraph_TagSaved = ErrorOf(ErrorSubsystem.ES_OS, 214, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Tag %tagName% saved."
		public static int MsgGraph_TagDeleted = ErrorOf(ErrorSubsystem.ES_OS, 215, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Tag %tagName% deleted."
		public static int MsgGraph_NotSyncd = ErrorOf(ErrorSubsystem.ES_OS, 217, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Client %client% cannot create a new branch in repo %repo% because it is not currently syncd."
		public static int MsgGraph_BranchCreated = ErrorOf(ErrorSubsystem.ES_OS, 218, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Branch %branchName% created in repo %repo%."
		public static int MsgGraph_BranchDeleted = ErrorOf(ErrorSubsystem.ES_OS, 219, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Branch %branchName% deleted in repo %repo%."
		public static int MsgGraph_BranchAlreadyExists = ErrorOf(ErrorSubsystem.ES_OS, 283, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Branch %branchName% already exists in repo %repo%."
		public static int MsgGraph_DefaultBranchReset = ErrorOf(ErrorSubsystem.ES_OS, 301, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"DefaultBranch set to %branchName%."
		public static int MsgGraph_FilesData = ErrorOf(ErrorSubsystem.ES_OS, 225, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile%"
		public static int MsgGraph_ResolvedData = ErrorOf(ErrorSubsystem.ES_OS, 245, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%clientFile% %how% %depotFile% %shaBuf%"
		public static int MsgGraph_DescribeFile = ErrorOf(ErrorSubsystem.ES_OS, 231, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% (%action%)"
		public static int MsgGraph_DirsData = ErrorOf(ErrorSubsystem.ES_OS, 229, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotDir%"
		public static int MsgGraph_SyncNotSameBranch = ErrorOf(ErrorSubsystem.ES_OS, 232, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Cannot sync to %target% because this client currently has files opened on branch %branch%."
		public static int MsgGraph_SyncNotFastForward = ErrorOf(ErrorSubsystem.ES_OS, 233, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Cannot sync to %target% because it would not be a forward merge from the files opened at %haveCommit%."
		public static int MsgGraph_SyncUnknownBranch = ErrorOf(ErrorSubsystem.ES_OS, 234, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 0); //"Client has opened files, but is on an unknown branch."
		public static int MsgGraph_CommitSummary = ErrorOf(ErrorSubsystem.ES_OS, 236, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"Commit: %sha%\nAuthor: %authorName%\nDate: %authorDate%\nDescription: %description%\n"
		public static int MsgGraph_NoMergeOpenFiles = ErrorOf(ErrorSubsystem.ES_OS, 237, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Merge not allowed: workspace has opened files."
		public static int MsgGraph_FastForwardMerge = ErrorOf(ErrorSubsystem.ES_OS, 238, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Fast-forward merge of branch %branchName% to commit %sha%."
		public static int MsgGraph_MergePreview = ErrorOf(ErrorSubsystem.ES_OS, 291, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%action% of branch %branchName% would succeed."
		public static int MsgGraph_BranchNotFound = ErrorOf(ErrorSubsystem.ES_OS, 240, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Branch %branchName% not found."
		public static int MsgGraph_ManyReposUseAll = ErrorOf(ErrorSubsystem.ES_OS, 308, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Multiple repos mapped by client; use -n to specify a single repo or -a for all."
		public static int MsgGraph_MergeComplete = ErrorOf(ErrorSubsystem.ES_OS, 242, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Merge completed as %sha%."
		public static int MsgGraph_CherryPickComplete = ErrorOf(ErrorSubsystem.ES_OS, 326, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Cherry-pick completed as %sha%."
		public static int MsgGraph_NoChangeFixes = ErrorOf(ErrorSubsystem.ES_OS, 243, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Change %change% has fixes attached, and therefore may not be submitted."
		public static int MsgGraph_UnsupportedFileType = ErrorOf(ErrorSubsystem.ES_OS, 248, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"File type %fileType% is not currently supported."
		public static int MsgGraph_ChangeViewBranch = ErrorOf(ErrorSubsystem.ES_OS, 250, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't sync to a different branch when limited by changeview"
		public static int MsgGraph_ChangeViewFuture = ErrorOf(ErrorSubsystem.ES_OS, 251, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Can't sync to a future sha when limited by changeview"
		public static int MsgGraph_SubmoduleOpen = ErrorOf(ErrorSubsystem.ES_OS, 254, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"In repo %repo%, file %depotFile% is part of a submodule and therefore must be modified in the submodule, not in this repo."
		public static int MsgGraph_UnknownRefType = ErrorOf(ErrorSubsystem.ES_OS, 256, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Reference type %refType% unrecognized."
		public static int MsgGraph_CommitFileLog = ErrorOf(ErrorSubsystem.ES_OS, 260, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 5); //"commit %sha%\n[Merge: %merge%\n]Author: %author%\nDate: %date%\n%description%\n"
		public static int MsgGraph_CantUpgradePackDir = ErrorOf(ErrorSubsystem.ES_OS, 264, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"Failed to rename archive for repo %repo%."
		public static int MsgGraph_NoMatchingRepos = ErrorOf(ErrorSubsystem.ES_OS, 265, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"%spec% - No matching repos."
		public static int MsgGraph_InvalidRevSpec = ErrorOf(ErrorSubsystem.ES_OS, 266, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Unexpected argument syntax[ - %revSpec%]"
		public static int MsgGraph_CorruptedTree = ErrorOf(ErrorSubsystem.ES_OS, 267, ErrorSeverity.E_FATAL, ErrorGeneric.EV_FAULT, 1); //"Tree node %sha% has no children, it might be corrupted or unreachable."
		public static int MsgGraph_NoAdvancedMappings = ErrorOf(ErrorSubsystem.ES_OS, 268, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Cannot use '+' or '&' mappings in the same view as graph depot paths."
		public static int MsgGraph_CantAddToRepo = ErrorOf(ErrorSubsystem.ES_OS, 269, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"p4 add of '%filepath%' failed - verify that this is the correct path and the repository for this file exists."
		public static int MsgGraph_CantUpdateMirror = ErrorOf(ErrorSubsystem.ES_OS, 277, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 3); //"p4 %action% of '%filepath%' failed - repo '%repo%' is mirrored and cannot be updated."
		public static int MsgGraph_CantSubmitMirror = ErrorOf(ErrorSubsystem.ES_OS, 278, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Submit failed: repo '%repo%' is mirrored and cannot be updated."
		public static int MsgGraph_CantSubmitEmpty = ErrorOf(ErrorSubsystem.ES_OS, 292, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"Submit failed: no modified repo files - submit empty commit requires '--allow-empty'."
		public static int MsgGraph_AutoLabelsOnly = ErrorOf(ErrorSubsystem.ES_OS, 270, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Graph depot paths are only permitted in automatic labels."
		public static int MsgGraph_LabelViewMustLimit = ErrorOf(ErrorSubsystem.ES_OS, 271, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Graph depot paths must be explicitly limited in label views."
		public static int MsgGraph_LabelViewMustNotLimit = ErrorOf(ErrorSubsystem.ES_OS, 272, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Only graph depot paths may be explicitly limited in label views."
		public static int MsgGraph_RepoNotMirrored = ErrorOf(ErrorSubsystem.ES_OS, 274, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Repo '%repo%' not configured for mirror operation."
		public static int MsgGraph_RepoIsMirrored = ErrorOf(ErrorSubsystem.ES_OS, 275, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Repo '%repo%' is configured only for mirror operations."
		public static int MsgGraph_GraphNotCompat = ErrorOf(ErrorSubsystem.ES_OS, 280, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"This version of the API is not compatible with GraphDepot."
		public static int MsgGraph_InvalidDefaultBranch = ErrorOf(ErrorSubsystem.ES_OS, 285, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 1); //"DefaultBranch '%defaultbranch%' must begin with \"
		public static int MsgGraph_LsTree = ErrorOf(ErrorSubsystem.ES_OS, 286, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%mode% %type% %sha%\t%path%"
		public static int MsgGraph_LsTreeNameOnly = ErrorOf(ErrorSubsystem.ES_OS, 287, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"%path%"
		public static int MsgGraph_MergeConflict = ErrorOf(ErrorSubsystem.ES_OS, 288, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Merge failed, conflict detected for '%depotFile%'"
		public static int MsgGraph_MergeNotText = ErrorOf(ErrorSubsystem.ES_OS, 289, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Merge failed, non-textual file '%depotFile%'"
		public static int MsgGraph_MergeSkippedResolve = ErrorOf(ErrorSubsystem.ES_OS, 300, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Merge failed, some file(s) were skipped in interactive resolve."
		public static int MsgGraph_LFSDisabled = ErrorOf(ErrorSubsystem.ES_OS, 293, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 1); //"Import of LFS objects is disabled for '%repo%'."
		public static int MsgGraph_UseUpdateRef = ErrorOf(ErrorSubsystem.ES_OS, 294, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Usage: %'update-ref -n repo [-u user -v] [-r refs... | -F refs...]'%"
		public static int MsgGraph_RepoIndexAlready = ErrorOf(ErrorSubsystem.ES_OS, 295, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"'%repo%' - index already exists."
		public static int MsgGraph_RepoIndexNone = ErrorOf(ErrorSubsystem.ES_OS, 296, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"'%repo%' - index does not exist."
		public static int MsgGraph_RepoIndexSuccess = ErrorOf(ErrorSubsystem.ES_OS, 297, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"'%repo%' - index created, %commits% commit(s), %files% file(s)."
		public static int MsgGraph_NoRepoEdgeSubmit = ErrorOf(ErrorSubsystem.ES_OS, 304, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"Cannot submit using a graph client on edge replica."
		public static int MsgGraph_MirrorMissingFile = ErrorOf(ErrorSubsystem.ES_OS, 305, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 1); //"Mirrored repo '%repo%' is missing some LFS files. Mirroring does not support LFS files.\n'%file%' missing LFS object."
		public static int MsgGraph_NoWriteForRef = ErrorOf(ErrorSubsystem.ES_OS, 306, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"%file% - no write permission on %ref% reference."
		public static int MsgGraph_RepoSwitchChanged = ErrorOf(ErrorSubsystem.ES_OS, 309, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% changed branch from %orig% to %name%"
		public static int MsgGraph_RepoAlreadyOnBranch = ErrorOf(ErrorSubsystem.ES_OS, 310, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depot% is already on branch %name%"
		public static int MsgGraph_RepoSwitchMissing = ErrorOf(ErrorSubsystem.ES_OS, 311, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% has no branch %name%, will remain on branch %orig%"
		public static int MsgGraph_BlobNotFoundRepo = ErrorOf(ErrorSubsystem.ES_OS, 312, ErrorSeverity.E_FAILED, ErrorGeneric.EV_FAULT, 2); //"Commit '%sha%' not found in %repo%."
		public static int MsgGraph_FilelogMessage = ErrorOf(ErrorSubsystem.ES_OS, 313, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 5); //"blob %blobsha% commit %commit% %action% on %date% by %user% %description%"
		public static int MsgGraph_MergeOfMessage = ErrorOf(ErrorSubsystem.ES_OS, 314, ErrorSeverity.E_INFO, ErrorGeneric.EV_UNKNOWN, 1); //"merge of %parents%"
		public static int MsgGraph_DescribeDiff = ErrorOf(ErrorSubsystem.ES_OS, 315, ErrorSeverity.E_INFO, ErrorGeneric.EV_UNKNOWN, 2); //
		public static int MsgGraph_HeadChanged = ErrorOf(ErrorSubsystem.ES_OS, 316, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 3); //"The head reference for %repo% has changed during the submit. Expect %expected% Observed %observed%. Resync and retry."
		public static int MsgGraph_SubmitCompleteWithRepo = ErrorOf(ErrorSubsystem.ES_OS, 318, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%change% renamed %commitSha% and submitted on %repo%."
		public static int MsgGraph_LbrPackCacheRequiresServerLocks = ErrorOf(ErrorSubsystem.ES_OS, 319, ErrorSeverity.E_FAILED, ErrorGeneric.EV_NONE, 0); //"Internal error: LbrPackCache passed NULL serverLocks"
		public static int MsgGraph_Rebased = ErrorOf(ErrorSubsystem.ES_OS, 320, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 4); //"Rebased %baseSha% to %srcSha% onto %dstSha% to create %newSha%"
		public static int MsgGraph_CherryPicked = ErrorOf(ErrorSubsystem.ES_OS, 321, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"Cherry picked %srcSha% onto %dstSha% to create %newSha%"
		public static int MsgGraph_RefUpdated = ErrorOf(ErrorSubsystem.ES_OS, 322, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"Reference %branch% updated to %newSha%"
		public static int MsgGraph_BadMergeMode = ErrorOf(ErrorSubsystem.ES_OS, 323, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 0); //"Can't merge and cherry-pick at the same time!"
		public static int MsgGraph_BadSource = ErrorOf(ErrorSubsystem.ES_OS, 324, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 2); //"Source '%commitish%' not found in %repo%."
		public static int MsgGraph_BadTarget = ErrorOf(ErrorSubsystem.ES_OS, 325, ErrorSeverity.E_FAILED, ErrorGeneric.EV_UNKNOWN, 2); //"Target '%commitish%' not found in %repo%."
		public static int MsgGraph_BadAtRev = ErrorOf(ErrorSubsystem.ES_OS, 329, ErrorSeverity.E_FAILED, ErrorGeneric.EV_ILLEGAL, 1); //"Invalid changelist/client/label/date/ref/sha '@%arg%'."
		public static int MsgGraph_NoMergeRequired = ErrorOf(ErrorSubsystem.ES_OS, 331, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"Nothing to merge"
		public static int MsgGraph_EditedWasDelete = ErrorOf(ErrorSubsystem.ES_OS, 332, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - edit of deleted file; must %'revert'%"
		public static int MsgGraph_AlreadyDeleted = ErrorOf(ErrorSubsystem.ES_OS, 333, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%depotFile% - open for delete of already deleted file; automatically removed"
		public static int MsgGraph_FileSpecific = ErrorOf(ErrorSubsystem.ES_OS, 336, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 0); //"File specific revisions:"
		public static int MsgGraph_FileSpecificData = ErrorOf(ErrorSubsystem.ES_OS, 337, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 3); //"%depot% %file% %sha%"
		public static int MsgGraph_OpenMustResolve = ErrorOf(ErrorSubsystem.ES_OS, 338, ErrorSeverity.E_INFO, ErrorGeneric.EV_USAGE, 2); //"%depotFile% - must %'sync'%/%'resolve'% %sha% before submitting"
		public static int MsgGraph_SyncResolve = ErrorOf(ErrorSubsystem.ES_OS, 339, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%depotFile% - must %'resolve'% %sha% before submitting"
		public static int MsgGraph_NoPermOnRefRepo = ErrorOf(ErrorSubsystem.ES_OS, 341, ErrorSeverity.E_WARN, ErrorGeneric.EV_NONE, 4); //"User %user% does not have %permission% privilege for reference %ref% on repo %repo%."
		public static int MsgGraph_AmbiguousRepoName = ErrorOf(ErrorSubsystem.ES_OS, 120, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Repo name '%repo%' may not be used. It would be an ambiguous name, because a repo named %otherRepo% already exists."
		public static int MsgGraph_SubmitComplete = ErrorOf(ErrorSubsystem.ES_OS, 202, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 2); //"%change% renamed %commitSha% and submitted."
	}
}
