using System;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Text;

namespace Perforce.P4
{
	public partial class P4ClientError
	{
		public static int MsgClient_Connect = ErrorOf(ErrorSubsystem.ES_CLIENT, 1, ErrorSeverity.E_FAILED, ErrorGeneric.EV_COMM, 0); //"Connect to server failed; check $P4PORT."
		public static int MsgClient_Fatal = ErrorOf(ErrorSubsystem.ES_CLIENT, 2, ErrorSeverity.E_FATAL, ErrorGeneric.EV_CLIENT, 0); //"Fatal client error; disconnecting!"
		public static int MsgClient_BadFlag = ErrorOf(ErrorSubsystem.ES_CLIENT, 3, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Unknown flag.  Try ? for help."
		public static int MsgClient_ClobberFile = ErrorOf(ErrorSubsystem.ES_CLIENT, 4, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Can't clobber writable file %file%"
		public static int MsgClient_MkDir = ErrorOf(ErrorSubsystem.ES_CLIENT, 5, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"can't create directory for %file%"
		public static int MsgClient_Eof = ErrorOf(ErrorSubsystem.ES_CLIENT, 6, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"EOF reading terminal."
		public static int MsgClient_FileOpenError = ErrorOf(ErrorSubsystem.ES_CLIENT, 40, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Error opening file."
		public static int MsgClient_CantEdit = ErrorOf(ErrorSubsystem.ES_CLIENT, 7, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"%type% - can't edit this type of file!"
		public static int MsgClient_NoMerger = ErrorOf(ErrorSubsystem.ES_CLIENT, 8, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"No merge program specified with $P4MERGE or $MERGE."
		public static int MsgClient_CheckFileBadPath = ErrorOf(ErrorSubsystem.ES_CLIENT, 9, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 2); //"%file% - symlink at '%dir%', file can't be added."
		public static int MsgClient_ToolServer2 = ErrorOf(ErrorSubsystem.ES_CLIENT, 10, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Could not start another ToolServer.  Tool is running under ToolServer."
		public static int MsgClient_ToolServer = ErrorOf(ErrorSubsystem.ES_CLIENT, 11, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Could not start ToolServer."
		public static int MsgClient_ToolCmdCreate = ErrorOf(ErrorSubsystem.ES_CLIENT, 12, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Could not create command to send to ToolServer."
		public static int MsgClient_ToolCmdSend = ErrorOf(ErrorSubsystem.ES_CLIENT, 13, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Could not send command to ToolServer."
		public static int MsgClient_Memory = ErrorOf(ErrorSubsystem.ES_CLIENT, 14, ErrorSeverity.E_FATAL, ErrorGeneric.EV_CLIENT, 0); //"Out of memory!"
		public static int MsgClient_CantFindApp = ErrorOf(ErrorSubsystem.ES_CLIENT, 15, ErrorSeverity.E_FATAL, ErrorGeneric.EV_CLIENT, 0); //"Could not find application!"
		public static int MsgClient_BadSignature = ErrorOf(ErrorSubsystem.ES_CLIENT, 16, ErrorSeverity.E_FATAL, ErrorGeneric.EV_CLIENT, 0); //"EDITOR_SIGNATURE must be 4 characters exactly!"
		public static int MsgClient_BadMarshalInput = ErrorOf(ErrorSubsystem.ES_CLIENT, 29, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Invalid marshalled data supplied as input."
		public static int MsgClient_ResolveManually = ErrorOf(ErrorSubsystem.ES_CLIENT, 18, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 0); //"Must resolve manually."
		public static int MsgClient_NonTextFileMerge = ErrorOf(ErrorSubsystem.ES_CLIENT, 19, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 0); //"Non-text file merge."
		public static int MsgClient_MergeMsg2 = ErrorOf(ErrorSubsystem.ES_CLIENT, 28, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 4); //"Non-text diff: %yours% yours + %theirs% theirs + %both% both + %conflicting% conflicting"
		public static int MsgClient_MergeMsg3 = ErrorOf(ErrorSubsystem.ES_CLIENT, 20, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 4); //"Diff chunks: %yours% yours + %theirs% theirs + %both% both + %conflicting% conflicting"
		public static int MsgClient_MergeMsg32 = ErrorOf(ErrorSubsystem.ES_CLIENT, 21, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 1); //"Diff chunks: %chunks% between yours and theirs (no common base)"
		public static int MsgClient_MergePrompt = ErrorOf(ErrorSubsystem.ES_CLIENT, 22, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 1); //"Accept(a) Edit(e) Diff(d) Merge (m) Skip(s) Help(?) [%mergeDefault%]: "
		public static int MsgClient_MergePrompt2 = ErrorOf(ErrorSubsystem.ES_CLIENT, 26, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 1); //"Accept (at/ay) Skip (s) Help (?) [%mergeDefault%]: "
		public static int MsgClient_MergePrompt2Edit = ErrorOf(ErrorSubsystem.ES_CLIENT, 27, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 1); //"Accept (at/ay) Edit (et/ey) Skip (s) Help (?) [%mergeDefault%]: "
		public static int MsgClient_ConfirmMarkers = ErrorOf(ErrorSubsystem.ES_CLIENT, 23, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 0); //"There are still change markers: confirm accept (y/n)? "
		public static int MsgClient_ConfirmEdit = ErrorOf(ErrorSubsystem.ES_CLIENT, 24, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 0); //"Use 'ae' to indicate original edits: confirm accept merge (y/n)? "
		public static int MsgClient_Confirm = ErrorOf(ErrorSubsystem.ES_CLIENT, 25, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 0); //"This overrides your changes: confirm accept (y/n)? "
		public static int MsgClient_CheckFileAssume = ErrorOf(ErrorSubsystem.ES_CLIENT, 30, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 3); //"%file% - %type%, assuming %type2%."
		public static int MsgClient_CheckFileAssumeWild = ErrorOf(ErrorSubsystem.ES_CLIENT, 41, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 4); //"%file% - %type%, assuming %type2% (%modified%)."
		public static int MsgClient_CheckFileSubst = ErrorOf(ErrorSubsystem.ES_CLIENT, 31, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 3); //"%file% - using %type% instead of %type2%"
		public static int MsgClient_CheckFileCant = ErrorOf(ErrorSubsystem.ES_CLIENT, 32, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 2); //"%file% - %type% file can't be added."
		public static int MsgClient_FileExists = ErrorOf(ErrorSubsystem.ES_CLIENT, 34, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"%file% - can't overwrite existing file."
		public static int MsgClient_NoSuchFile = ErrorOf(ErrorSubsystem.ES_CLIENT, 35, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"%file% - file does not exist."
		public static int MsgClient_LoginPrintTicket = ErrorOf(ErrorSubsystem.ES_CLIENT, 36, ErrorSeverity.E_INFO, ErrorGeneric.EV_NONE, 1); //"%ticket%"
		public static int MsgClient_DigestMisMatch = ErrorOf(ErrorSubsystem.ES_CLIENT, 37, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 3); //"%clientFile% corrupted during transfer (or bad on the server) %clientDigest% vs %serverDigest%"
		public static int MsgClient_NotUnderPath = ErrorOf(ErrorSubsystem.ES_CLIENT, 38, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 2); //"File %clientFile% is not inside permitted filesystem path %clientPath%"
		public static int MsgClient_LineTooLong = ErrorOf(ErrorSubsystem.ES_CLIENT, 39, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Command line too long. Maximum length is %maxLineLen%. This length can be increased by setting filesys.bufsize in P4CONFIG or using -v."
		public static int MsgClient_UnknownCharset = ErrorOf(ErrorSubsystem.ES_CLIENT, 42, ErrorSeverity.E_FATAL, ErrorGeneric.EV_CLIENT, 1); //"Unknown P4CHARSET %charset%."
		public static int MsgClient_FileKept = ErrorOf(ErrorSubsystem.ES_CLIENT, 43, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Edited File %file% kept due to errors."
		public static int MsgClient_LockCheckFail = ErrorOf(ErrorSubsystem.ES_CLIENT, 44, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"File locking check failed, Perforce server can not run."
		public static int MsgClient_ChdirFail = ErrorOf(ErrorSubsystem.ES_CLIENT, 45, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Failed to change to direcitory '%dir%'."
		public static int MsgClient_InitRootExists = ErrorOf(ErrorSubsystem.ES_CLIENT, 46, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Nothing to do - existing dvcs tree at %dir%"
		public static int MsgClient_NoDvcsServer = ErrorOf(ErrorSubsystem.ES_CLIENT, 47, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"No server root found"
		public static int MsgClient_InitServerFail = ErrorOf(ErrorSubsystem.ES_CLIENT, 48, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"\np4d server failed to initialize.  A 2015.1 or later p4d server\nmust be in your path and runable."
		public static int MsgClient_CloneCantFetch = ErrorOf(ErrorSubsystem.ES_CLIENT, 49, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Remote server '%port%' not configured to clone (server.allowfetch)."
		public static int MsgClient_NotValidStreamName = ErrorOf(ErrorSubsystem.ES_CLIENT, 50, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"'%path%' is not a valid mainline stream name."
		public static int MsgClient_CloneStart = ErrorOf(ErrorSubsystem.ES_CLIENT, 51, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 1); //"Cloning from '%port%'..."
		public static int MsgClient_CloneNeedLogin1 = ErrorOf(ErrorSubsystem.ES_CLIENT, 52, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 2); //"'%user%' is not currently logged in to '%port%'"
		public static int MsgClient_CloneNeedLogin2 = ErrorOf(ErrorSubsystem.ES_CLIENT, 53, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 2); //"run 'p4 -u %user% -p %port% login' to authenticate"
		public static int MsgClient_CloneTooWide = ErrorOf(ErrorSubsystem.ES_CLIENT, 54, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Remote map entry '%path%' cannot be allocated a stream name:\nClone requires at least //<depotname>/<streamname>/ on the left hand side of the map\n"
		public static int MsgClient_CloneRemoteInvalid = ErrorOf(ErrorSubsystem.ES_CLIENT, 55, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Remote clone spec invalid!"
		public static int MsgClient_CloneTooManyDepots = ErrorOf(ErrorSubsystem.ES_CLIENT, 56, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Remote spec references multiple depots on the left hand side of map : %depots%"
		public static int MsgClient_CloneNoRemote = ErrorOf(ErrorSubsystem.ES_CLIENT, 57, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 2); //"Remote server '%port%' does not have a remote spec '%remote%'"
		public static int MsgClient_ClonePathNoMap = ErrorOf(ErrorSubsystem.ES_CLIENT, 58, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Filepath '%path%' cannot be mapped"
		public static int MsgClient_ClonePathTooWide = ErrorOf(ErrorSubsystem.ES_CLIENT, 59, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Filepath '%path%' is too wide open"
		public static int MsgClient_ClonePathHasWild = ErrorOf(ErrorSubsystem.ES_CLIENT, 60, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Filepath '%path%' contains embedded wildcard"
		public static int MsgClient_ClonePathHasIllegal = ErrorOf(ErrorSubsystem.ES_CLIENT, 61, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Filepath '%path%' contains illegal characters [@%#*]"
		public static int MsgClient_RemoteAlreadySet = ErrorOf(ErrorSubsystem.ES_CLIENT, 62, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 1); //"Remote '%remote%' is already cached"
		public static int MsgClient_NoRemoteToSet = ErrorOf(ErrorSubsystem.ES_CLIENT, 63, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"No remote in cache"
		public static int MsgClient_InitCaseFlagUnset = ErrorOf(ErrorSubsystem.ES_CLIENT, 64, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"CaseFlag must be set to -C0 or -C1"
		public static int MsgClient_InitUnicodeUnset = ErrorOf(ErrorSubsystem.ES_CLIENT, 65, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"Unicode must be set to 0 or 1"
		public static int MsgClient_CloneFetchCounts = ErrorOf(ErrorSubsystem.ES_CLIENT, 66, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 2); //"%changes% change(s) containing a total of %revs% file revision(s) were successfully fetched."
		public static int MsgClient_LocalRemoteMismatch = ErrorOf(ErrorSubsystem.ES_CLIENT, 67, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"ServerHelperApi already refers to a local Perforce Server."
		public static int MsgClient_RemoteLocalMismatch = ErrorOf(ErrorSubsystem.ES_CLIENT, 68, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 0); //"ServerHelperApi already refers to a remote Perforce Server."
		public static int MsgClient_AliasTooManyEquals = ErrorOf(ErrorSubsystem.ES_CLIENT, 69, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: extra equals sign in '%alias%'"
		public static int MsgClient_AliasMissingEquals = ErrorOf(ErrorSubsystem.ES_CLIENT, 70, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: missing equals sign in '%alias%'"
		public static int MsgClient_AliasTooComplex = ErrorOf(ErrorSubsystem.ES_CLIENT, 71, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias definition '%alias%' exceeds the complexity limit of %limit%."
		public static int MsgClient_AliasMissingCommand = ErrorOf(ErrorSubsystem.ES_CLIENT, 72, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias definition '%alias%' does not contain the command to run."
		public static int MsgClient_AliasArgSyntax = ErrorOf(ErrorSubsystem.ES_CLIENT, 73, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Alias syntax error: '%arg%' not understood in '%alias%'."
		public static int MsgClient_AliasIOSyntax = ErrorOf(ErrorSubsystem.ES_CLIENT, 74, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 2); //"Alias syntax error: unexpected character '%redirChar%' found in alias '%alias%'."
		public static int MsgClient_AliasInputMultiple = ErrorOf(ErrorSubsystem.ES_CLIENT, 75, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: multiple input redirections were found in alias '%alias%'."
		public static int MsgClient_AliasOutputMultiple = ErrorOf(ErrorSubsystem.ES_CLIENT, 76, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: multiple output redirections were found in alias '%alias%'."
		public static int MsgClient_AliasRedirection = ErrorOf(ErrorSubsystem.ES_CLIENT, 77, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: unrecognized redirection syntax in alias '%alias%'."
		public static int MsgClient_NoAliasesFound = ErrorOf(ErrorSubsystem.ES_CLIENT, 78, ErrorSeverity.E_INFO, ErrorGeneric.EV_CLIENT, 0); //"You have no aliases defined."
		public static int MsgClient_AliasNoTransform = ErrorOf(ErrorSubsystem.ES_CLIENT, 79, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: no transformation found in '%alias%'."
		public static int MsgClient_AliasEmptyTransform = ErrorOf(ErrorSubsystem.ES_CLIENT, 80, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Alias syntax error: empty transformation not allowed."
		public static int MsgClient_AliasPartial = ErrorOf(ErrorSubsystem.ES_CLIENT, 81, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Alias syntax error: alias definition incomplete."
		public static int MsgClient_AliasSubstArgs = ErrorOf(ErrorSubsystem.ES_CLIENT, 82, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Alias syntax error: p4subst should have exactly two arguments."
		public static int MsgClient_AliasSubstInput = ErrorOf(ErrorSubsystem.ES_CLIENT, 83, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Alias syntax error: p4subst input should be redirected."
		public static int MsgClient_AliasSubstOutput = ErrorOf(ErrorSubsystem.ES_CLIENT, 84, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 0); //"Alias syntax error: p4subst output should be redirected"
		public static int MsgClient_AliasSyntaxError = ErrorOf(ErrorSubsystem.ES_CLIENT, 85, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: '%alias%' not understood."
		public static int MsgClient_CommandNotAliased = ErrorOf(ErrorSubsystem.ES_CLIENT, 86, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"There is no alias which applies to '%cmd%'."
		public static int MsgClient_AliasEmptyPattern = ErrorOf(ErrorSubsystem.ES_CLIENT, 87, ErrorSeverity.E_FAILED, ErrorGeneric.EV_USAGE, 1); //"Alias syntax error: no pattern found in '%alias%'"
		public static int MsgClient_NoModifiedFile = ErrorOf(ErrorSubsystem.ES_CLIENT, 88, ErrorSeverity.E_FAILED, ErrorGeneric.EV_CLIENT, 2); //"Can't %action% modified file %file%"
		public static int MsgClient_ZCResolve = ErrorOf(ErrorSubsystem.ES_CLIENT, 33, ErrorSeverity.E_FAILED, ErrorGeneric.EV_COMM, 2); //"Zeroconf resolved '%name%' to '%port%'."
	}
}
