/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */
swarm.mentions = {
    additionalClass: '',
    mode: '',
    mentionsArray: [],
    enableGroups: true,

    /**
     * Initialise mentions by setting up a user picker on an element
     * @param additionalClass optional additional class to add to the element
     * @param id optional id for the element. Defaults to the 'old' pages element selector if not provided.
     * This makes it possible for react code to call legacy mentions by providing an id to select when that
     * component is mounted
     * @param options additional options that can be passed to alter default functionality such as not
     * to set focus when invoked this code from react code etc.
     */
    init: function(additionalClass, id, options) {
        this.mode = swarm.comments.mentionsMode;
        this.mentionsArray = swarm.comments.mentionsArray;
        this.additionalClass = additionalClass || 'no-class';
        var comp = null;
        if (id) {
            comp = $('#' + id);
        }
        if (this.mode === 'global') {
            this.getAllUsersAndGroups(comp, options);
        } else if (this.mode === 'projects') {
            if (this.mentionsArray.length === 0) {
                this.getAllUsersAndGroups(comp, options);
            } else {
                this.addUsersAndGroups(comp);
            }
        }
    },
    addUsersAndGroups: function (target){
        $(target||'.comment-form textarea').userMultiPicker({
            inputName:      'Users',
            groupInputName: 'Groups',
            selectedGroups: [],
            excludeProjects: true,
            enableGroups: this.enableGroups,
            triggerChar: '@',
            groupTriggerChar: '@@',
            triggerModifiers: '[!*]',
            minLength: 1,
            onCaret: true,
            clearInput: false,
            disabled: true,
            items: 5,
            source: this.mentionsArray,
            additionalClass : this.additionalClass,
            consumeEnterKeyPress: false,
            setFocus: !!target,
            onSelect: function() {
                var currentText = this.typeahead.$element.val();
                var activeItem = this.typeahead.$menu.find('.active').data('value');
                if (activeItem) {
                    var pattern = new RegExp("(" + this.options.triggerChar + "+[^\\s]{" + this.options.minLength + ",})$");
                    var cursorIndex = this.typeahead.$element.get(0).selectionStart;
                    var firstPart = currentText.substring(0, cursorIndex);
                    var newValue;
                    if (activeItem.type === 'group') {
                        newValue = firstPart.replace(pattern, this.options.triggerChar + this.options.triggerChar + activeItem.id);
                    } else {
                        newValue = firstPart.replace(pattern, this.options.triggerChar + activeItem.id);
                    }
                    var cursorPosition = newValue.length;
                    newValue += currentText.substring(cursorIndex);

                    this.typeahead.$element.val(newValue);
                    this.typeahead.$element.setCursorPosition(cursorPosition);
                }
            }
        });
    },
    getAllUsersAndGroups: function(target, options) {
        var setFocus = (options && Object.hasOwn(options, 'setFocus')) ? options.setFocus : true;
        $(target||'.comment-form textarea').userMultiPicker({
            inputName:      'Users',
            groupInputName: 'Groups',
            selectedGroups: [],
            excludeProjects: true,
            enableGroups: this.enableGroups,
            triggerChar: '@',
            groupTriggerChar: '@@',
            triggerModifiers: '[!*]',
            minLength: 1,
            onCaret: true,
            clearInput: false,
            ignoreBlacklist: false,
            items: 5,
            additionalClass : this.additionalClass,
            consumeEnterKeyPress: false,
            setFocus: setFocus && !!target,
            onSelect: function() {
                var currentText = this.typeahead.$element.val();
                var activeItem = this.typeahead.$menu.find('.active').data('value');
                if (activeItem) {
                    var pattern = new RegExp("(" + this.options.triggerChar + "+[^\\s]{" + this.options.minLength + ",})$");
                    var cursorIndex = this.typeahead.$element.get(0).selectionStart;
                    var firstPart = currentText.substring(0, cursorIndex);
                    var newValue;
                    if (activeItem.type === 'group') {
                        newValue = firstPart.replace(pattern, this.options.triggerChar + this.options.triggerChar + activeItem.id);
                    } else {
                        newValue = firstPart.replace(pattern, this.options.triggerChar + activeItem.id);
                    }
                    var cursorPosition = newValue.length;
                    newValue += currentText.substring(cursorIndex);

                    this.typeahead.$element.val(newValue).trigger('click');
                    this.typeahead.$element.setCursorPosition(cursorPosition);
                }
            }
        });
    }
};

