<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace Reviews\Filter;

use Application\InputFilter\DirectInput;
use Application\InputFilter\InputFilter;
use Application\Validator\BetweenInt;
use Interop\Container\ContainerInterface;
use Laminas\Filter\StringTrim;
use Laminas\Validator\Date;

/**
 * Defines filters for archive inactive operation.
 * @package Reviews\Filter
 */
class ArchiveInactive extends InputFilter implements IArchiveInactive
{

    public function __construct(ContainerInterface $services, array $options = null)
    {
        $this->addNotUpdatedSinceFilter();
        $this->addMaxFilter();
        $this->addDescriptionFilter();
    }

    /**
     * Add a filter for notUpdatedSince field
     */
    private function addNotUpdatedSinceFilter()
    {
        $input = new DirectInput(self::NOTUPDATEDSINCE);
        $input->setRequired(true);
        $input->getValidatorChain()->attach(new Date());
        $this->add($input);
    }

    /**
     * Add a filter for max field
     */
    private function addMaxFilter()
    {
            $input = new DirectInput(self::MAX);
            $input->setRequired(false);
            $input->getValidatorChain()->attach(new BetweenInt(['min' => 1, 'max' => PHP_INT_MAX]));
            $this->add($input);
    }

    /**
     * Add a filter for description field
     */
    private function addDescriptionFilter()
    {
        $input = new DirectInput(self::DESCRIPTION);
        $input->setRequired(false);
        $input->getFilterChain()->attach(new StringTrim());
        $this->add($input);
    }
}
