<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace Application\Router;

class Regex extends \Laminas\Router\Http\Regex
{
    /**
     * Extend parent to preserve slashes '/'.
     *
     * @see    Route::assemble()
     * @param  array $params
     * @param  array $options
     * @return mixed
     */
    public function assemble(array $params = [], array $options = [])
    {
        return str_ireplace('%2f', '/', parent::assemble($params, $options));
    }
}
