<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace AiAnalysis\Model;

use Application\Checker;

/**
 * Interface IAiReviewSummary. Define values and responsibilities for a Comments
 * @package AiAnalysis\Model
 */
interface IAiReviewSummary
{
    const TOPIC_REVIEW    = 'review';
    const TOPIC           = 'topic';
    const ID              = 'id';
    const COMMENT         = 'comment';
    const USER            = 'user';
    const USERS           = 'users';
    const TIME            = 'time';
    const EDITED          = 'edited';
    const CONTENT         = 'content';
    const CONTEXT         = 'context';
    const FLAGS           = 'flags';
    const UPDATED         = 'updated';
    const BASE_URL        = 'baseURL';
    const REVIEW_ID       = 'reviewId';
    const TO_VERSION      = 'toVersion';
    const FROM_VERSION    = 'fromVersion';
    const FILE_ID         = 'fileId';
    const HTTPS           = "https";
    const ERROR           = 'error';
    const DIGEST          = 'digest';
    const DIFF_START      = 'diffStart';
    const DIFF_END        = 'diffEnd';
    const LEFT_LINE       = 'leftLine';
    const FLAG_CLOSED     = 'closed';
    const TEXT            = 'text';
    const REVIEW          = 'review';
    const CALL_AI_SERVICE = 'callAiService';
    const UPDATE_RECORD   = 'updateRecord';
    const RECORD_MATCH_AT = 'recordMatchAt';
    const IS_VISIBLE      = 'isVisible';

    const FETCH_BY_TOPIC                              = self::TOPIC;
    const FETCH_BY_USER                               = self::USER;
    const FETCH_BY_CONTEXT                            = self::CONTEXT;
    const AI_ANALYSIS                                 = 'aiAnalysis';
    const AI_ANALYSIS_CHAR_LIMIT                      = 'aiAnalysisCharLimit';
    const AI_ANALYSIS_CHECKER                         = [Checker::NAME => self::AI_ANALYSIS];
    const AI_ANALYSIS_CHAR_LIMIT_CHECKER              = [Checker::NAME => self::AI_ANALYSIS_CHAR_LIMIT];
    const AI_SERVICE_NAME                             = 'aiServiceName';
    const AI_PACKAGE_TYPE                             = 'aiPackageType';
    const AI_MODEL                                    = 'aiModel';
    const AI_ANALYSIS_DATA_RETENTION_LIFETIME         = 'aiAnalysisDataRetentionLifetime';
    const AI_ANALYSIS_DATA_RETENTION_LIFETIME_CHECKER = [Checker::NAME => self::AI_ANALYSIS_DATA_RETENTION_LIFETIME];
}
