/**
 *
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;

import java.util.List;

/**
 * Options class for IOptionsServer's setKey method.
 */
public class KeyOptions extends Options {

	/**
	 * Options: -u, -d, -i, -m
	 */
	public static final String OPTIONS_SPECS = "b:u b:d b:i b:m";

	protected boolean undocKey = false;

	/**
	 * If true, delete the counter. Corresponds to the -d flag.
	 */
	protected boolean delete = false;

	/**
	 * If true, increment the key and return the new value. This option is used
	 * instead of a value argument and can only be used with numeric key values.
	 * Corresponds to the -i flag.
	 */
	protected boolean incrementKey = false;

	/**
	 * Perform multiple key value operations in one command.
	 */
	protected boolean isMultiplePair = false;

	/**
	 * Default constructor.
	 */
	public KeyOptions() {
		super();
	}

	/**
	 * Strings-based constructor; see 'p4 help [command]' for possible options.
	 * <p>
	 *
	 * <b>WARNING: you should not pass more than one option or argument in each
	 * string parameter. Each option or argument should be passed-in as its own
	 * separate string parameter, without any spaces between the option and the
	 * option value (if any).</b>
	 * <p>
	 *
	 * <b>NOTE: setting options this way always bypasses the internal options
	 * values, and getter methods against the individual values corresponding to
	 * the strings passed in to this constructor will not normally reflect the
	 * string's setting. Do not use this constructor unless you know what you're
	 * doing and / or you do not also use the field getters and setters.</b>
	 *
	 * @param options options
	 * @see com.perforce.p4java.option.Options#Options(java.lang.String...)
	 */
	public KeyOptions(String... options) {
		super(options);
	}

	/**
	 * Explicit value constructor.
	 *
	 * @param delete           delete
	 * @param incrementCounter incrementCounter
	 */
	public KeyOptions(boolean delete, boolean incrementCounter) {
		super();
		this.delete = delete;
		this.incrementKey = incrementCounter;
	}

	/**
	 * @see com.perforce.p4java.option.Options#processOptions(com.perforce.p4java.server.IServer)
	 */
	public List<String> processOptions(IServer server) throws OptionsException {
		this.optionList = this.processFields(OPTIONS_SPECS, this.isUndocKey(), this.isDelete(), this.isIncrementKey(), this.isMultiplePair());

		return this.optionList;
	}

	public boolean isUndocKey() {
		return undocKey;
	}

	public KeyOptions setUndocKey(boolean undocKey) {
		this.undocKey = undocKey;
		return this;
	}

	public boolean isDelete() {
		return delete;
	}

	public KeyOptions setDelete(boolean delete) {
		this.delete = delete;
		return this;
	}

	public boolean isIncrementKey() {
		return incrementKey;
	}

	public KeyOptions setIncrementKey(boolean incrementKey) {
		this.incrementKey = incrementKey;
		return this;
	}

	public boolean isMultiplePair() {
		return isMultiplePair;
	}

	public KeyOptions setMultiplePair(boolean isMultiplePair) {
		this.isMultiplePair = isMultiplePair;
		return this;
	}
}
