package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.ServerInfo;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.delegator.IInfoDelegator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.perforce.p4java.common.base.P4JavaExceptions.throwRequestExceptionIfConditionFails;
import static com.perforce.p4java.common.base.P4ResultMapUtils.parseCode0ErrorString;
import static com.perforce.p4java.server.CmdSpec.INFO;
import static java.util.Objects.nonNull;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * Implementation for 'p4 info' commands.
 */
public class InfoDelegator extends BaseDelegator implements IInfoDelegator {

    /**
     * Instantiates a new info delegator.
     *
     * @param server
     *            the server
     */
    public InfoDelegator(final IOptionsServer server) {
        super(server);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.perforce.p4java.server.delegator.IInfoDelegator#getServerInfo()
     */
    @Override
    public IServerInfo getServerInfo()
            throws ConnectionException, RequestException, AccessException {
        ServerInfo serverInfo = new ServerInfo();
        List<Map<String, Object>> resultMaps = execMapCmdList(INFO, new String[0], null);

        if (nonNull(resultMaps)) {
            List<Map<String, Object>> validMaps = new ArrayList<>();
            for (int i = 0; i < resultMaps.size(); i++) {
                Map<String, Object> map = resultMaps.get(i);
                String errStr = ResultMapParser.getErrorStr(map);
                throwRequestExceptionIfConditionFails(isBlank(errStr), parseCode0ErrorString(map),
                        errStr);
                validMaps.add(map);
            }
            serverInfo = new ServerInfo(validMaps);
        }
        return serverInfo;
    }
}
