package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.admin.IDiskSpace;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.admin.DiskSpace;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IDiskspaceDelegator;

import java.util.List;
import java.util.Map;

import static com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder.buildNonNullObjectListFromCommandResultMaps;
import static com.perforce.p4java.server.CmdSpec.DISKSPACE;
import static java.util.Objects.nonNull;

/**
 * Implementation to handle the Diskspace command.
 */
public class DiskspaceDelegator extends BaseDelegator implements IDiskspaceDelegator {
    /**
     * Instantiate a new DiskspaceDelegator, providing the server object that will be used to
     * execute Perforce Helix attribute commands.
     *
     * @param server a concrete implementation of a Perforce Helix Server
     */
    public DiskspaceDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IDiskSpace> getDiskSpace(final List<String> filesystems) throws P4JavaException {
        String[] cmdArgs = null;
        if (nonNull(filesystems)) {
            cmdArgs = filesystems.toArray(new String[filesystems.size()]);
        }

        List<Map<String, Object>> resultMaps = execMapCmdList(
                DISKSPACE,
                cmdArgs,
                null);

        return buildNonNullObjectListFromCommandResultMaps(
                resultMaps,
				map -> new DiskSpace(map));
    }
}
