/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import java.util.Properties;

public interface IServerAddress {
    public boolean isSecure();

    public String getUri();

    public Protocol getProtocol();

    public String getHost();

    public int getPort();

    public String getQuery();

    public Properties getProperties();

    public String getRsh();

    public static enum Protocol {
        P4JAVA("p4java"),
        P4JAVASSL("p4javassl"),
        P4JRPC("p4jrpc"),
        P4JRPCSSL("p4jrpcssl"),
        P4JRPCNTS("p4jrpcnts"),
        P4JRPCNTSSSL("p4jrpcntsssl"),
        P4JRSH("p4jrsh"),
        P4JRSHNTS("p4jrshnts");

        private String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public static Protocol fromString(String protocol) {
            if (protocol != null) {
                for (Protocol p : Protocol.values()) {
                    if (!protocol.equalsIgnoreCase(p.protocol)) continue;
                    return p;
                }
            }
            return null;
        }

        public String toString() {
            return this.protocol;
        }

        public boolean isSecure() {
            return this.protocol != null && this.protocol.toLowerCase().endsWith("ssl");
        }

        public boolean isRsh() {
            return this.protocol != null && this.protocol.toLowerCase().startsWith("p4jrsh");
        }
    }
}

