/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option.server;

import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.List;

public class GraphCommitLogOptions
extends Options {
    public static final String GRAPH_COMMITLOG_COMMAND_PART = "log";
    public static final String OPTIONS_SPECS = "s:n s:u i:m:gtz s:A s:B i:N:gtz i:X:gtz";
    private String repo;
    private String user;
    private int maxResults;
    private String startDate;
    private String endDate;
    private int minNumberOfParents;
    private int maxNumberOfParents;
    private String[] commitValue;

    public GraphCommitLogOptions() {
    }

    public GraphCommitLogOptions(String repo, int maxResults, String startDate, String endDate, int minNumberOfParents, int maxNumberOfParents, String ... commitValue) {
        this.repo = repo;
        this.maxResults = maxResults;
        this.startDate = startDate;
        this.endDate = endDate;
        this.minNumberOfParents = minNumberOfParents;
        this.maxNumberOfParents = maxNumberOfParents;
        this.commitValue = commitValue;
    }

    @Override
    public List<String> processOptions(IServer server) throws OptionsException {
        this.optionList = this.processFields(OPTIONS_SPECS, this.repo, this.user, this.maxResults, this.startDate, this.endDate, this.minNumberOfParents, this.maxNumberOfParents);
        if (this.commitValue != null && this.commitValue.length > 0) {
            for (String commitValueItem : this.commitValue) {
                this.optionList.add(commitValueItem);
            }
        }
        this.optionList.add(0, GRAPH_COMMITLOG_COMMAND_PART);
        return this.optionList;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public String getRepo() {
        return this.repo;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setCommitValue(String ... commitValue) {
        this.commitValue = commitValue;
    }

    public String[] getCommitValue() {
        return this.commitValue;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setMinParents(int minimumNumberOfParents) {
        this.minNumberOfParents = minimumNumberOfParents;
    }

    public int getMinParents() {
        return this.minNumberOfParents;
    }

    public void setMaxParents(int maximumNumberOfParents) {
        this.maxNumberOfParents = maximumNumberOfParents;
    }

    public int getMaxParents() {
        return this.maxNumberOfParents;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        this.user = this.user;
        return this.user;
    }
}

