/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IReviewChangelist;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.ReviewChangelist;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetReviewChangelistsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IReviewDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReviewDelegator
extends BaseDelegator
implements IReviewDelegator {
    public ReviewDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IReviewChangelist> getReviewChangelists(GetReviewChangelistsOptions opts) throws P4JavaException {
        ArrayList<IReviewChangelist> reviewList = new ArrayList<IReviewChangelist>();
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.REVIEW, Parameters.processParameters(opts, this.server), null);
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                ResultMapParser.handleErrorStr(map);
                try {
                    ReviewChangelist reviewChangelist = new ReviewChangelist(P4ResultMapUtils.parseInt(map, "change"), P4ResultMapUtils.parseString(map, "user"), P4ResultMapUtils.parseString(map, "email"), P4ResultMapUtils.parseString(map, "name"));
                    reviewList.add(reviewChangelist);
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in getReviews: %s", thr.getLocalizedMessage());
                    Log.exception(thr);
                }
            }
        }
        return reviewList;
    }
}

