/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IOpenedDelegator;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OpenedDelegator
extends BaseDelegator
implements IOpenedDelegator {
    public OpenedDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, boolean allClients, String clientName, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        try {
            OpenedFilesOptions openedFilesOptions = new OpenedFilesOptions(allClients, clientName, maxFiles, null, changeListId);
            return this.getOpenedFiles(fileSpecs, openedFilesOptions);
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.openedFiles: %s", exc);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IFileSpec> getOpenedFiles(List<IFileSpec> fileSpecs, OpenedFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.OPENED, Parameters.processParameters(opts, fileSpecs, this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(map -> ResultListBuilder.handleFileReturn(map, this.server)));
    }
}

