/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.graph.IGraphRef;
import com.perforce.p4java.impl.generic.graph.GraphRef;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GraphShowRefOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IGraphShowRefDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GraphShowRefDelegator
extends BaseDelegator
implements IGraphShowRefDelegator {
    public GraphShowRefDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IGraphRef> getGraphShowRefs(GraphShowRefOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(opts, this.server), null);
        if (!Objects.nonNull(resultMaps)) {
            return null;
        }
        String repo = null;
        String type = null;
        String sha = null;
        String name = null;
        ArrayList<IGraphRef> graphRefList = new ArrayList<IGraphRef>();
        for (Map<String, Object> map : resultMaps) {
            ResultMapParser.handleErrorStr(map);
            try {
                if (map.containsKey("repoName")) {
                    repo = P4ResultMapUtils.parseString(map, "repoName");
                }
                if (map.containsKey("type")) {
                    type = P4ResultMapUtils.parseString(map, "type");
                }
                if (map.containsKey("sha")) {
                    sha = P4ResultMapUtils.parseString(map, "sha");
                }
                if (map.containsKey("name")) {
                    name = P4ResultMapUtils.parseString(map, "name");
                }
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
            graphRefList.add(new GraphRef(repo, type, sha, name));
        }
        return graphRefList;
    }
}

