/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.FileDiffUtils;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.file.DiffType;
import com.perforce.p4java.core.file.FileDiff;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetFileDiffsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IDiff2Delegator;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class Diff2Delegator
extends BaseDelegator
implements IDiff2Delegator {
    public Diff2Delegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DIFF2, Parameters.processParameters((Options)opts, file1, file2, branchSpecName, (IServer)this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromNonMessageCommandResultMaps(resultMaps, map -> new FileDiff((Map<String, Object>)map));
    }

    @Override
    public List<IFileDiff> getFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        try {
            GetFileDiffsOptions opts = new GetFileDiffsOptions().setQuiet(quiet).setIncludeNonTextDiffs(includeNonTextDiffs).setGnuDiffs(gnuDiffs);
            FileDiffUtils.setFileDiffsOptionsByDiffType(diffType, opts);
            return this.getFileDiffs(file1, file2, branchSpecName, opts);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public InputStream getFileDiffsStream(IFileSpec file1, IFileSpec file2, String branchSpecName, GetFileDiffsOptions opts) throws P4JavaException {
        return this.execStreamCmd(CmdSpec.DIFF2, Parameters.processParameters((Options)opts, file1, file2, branchSpecName, (IServer)this.server));
    }

    @Override
    public InputStream getServerFileDiffs(IFileSpec file1, IFileSpec file2, String branchSpecName, DiffType diffType, boolean quiet, boolean includeNonTextDiffs, boolean gnuDiffs) throws ConnectionException, RequestException, AccessException {
        try {
            GetFileDiffsOptions opts = new GetFileDiffsOptions().setQuiet(quiet).setIncludeNonTextDiffs(includeNonTextDiffs).setGnuDiffs(gnuDiffs);
            FileDiffUtils.setFileDiffsOptionsByDiffType(diffType, opts);
            return this.getFileDiffsStream(file1, file2, branchSpecName, opts);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

