/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IServerResource;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class ServerResource
implements IServerResource {
    private Map<String, Object> rawFields = new HashMap<String, Object>();
    protected boolean refreshable = false;
    protected boolean updateable = false;
    protected IServer server = null;
    private final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss";

    protected ServerResource() {
    }

    protected ServerResource(IServer server) {
        this.server = server;
    }

    protected ServerResource(boolean refreshable, boolean updateable) {
        this(refreshable, updateable, null);
    }

    protected ServerResource(boolean refreshable, boolean updateable, IServer server) {
        this(server);
        this.refreshable = refreshable;
        this.updateable = updateable;
    }

    @Override
    public boolean canRefresh() {
        return this.refreshable && this.server != null;
    }

    @Override
    public boolean canUpdate() {
        return this.updateable && this.server != null;
    }

    @Override
    public void complete() throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called default IServerResourceImpl.complete");
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called default IServerResourceImpl.refresh");
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called default IServerResourceImpl.update");
    }

    @Override
    public void update(boolean force) throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called IServerResourceImpl.update(force)");
    }

    @Override
    public void update(Options opts) throws ConnectionException, RequestException, AccessException {
        throw new UnimplementedError("called IServerResourceImpl.update(opts)");
    }

    public void setRefreshable(boolean refreshable) {
        this.refreshable = refreshable;
    }

    @Override
    public void setServer(IServer server) {
        this.server = server;
    }

    @Override
    public Object getRawField(String field) {
        return this.rawFields.get(field);
    }

    @Override
    public void setRawField(String field, Object value) {
        this.rawFields.put(field, value);
    }

    @Override
    public boolean hasRawField(String field) {
        return this.rawFields.containsKey(field);
    }

    @Override
    public Map<String, Object> getRawFields() {
        return this.rawFields;
    }

    @Override
    public void setRawFields(Map<String, Object> map) {
        this.rawFields.putAll(map);
    }

    @Override
    public void clearRawFields() {
        this.rawFields = new HashMap<String, Object>();
    }

    protected Date parseDate(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            long d = Long.parseLong(value);
            return new Date(d * 1000L);
        }
        catch (NumberFormatException d) {
            try {
                return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(value);
            }
            catch (ParseException e) {
                Log.warn("Unexpected date format: " + e.getMessage(), new Object[0]);
                Log.exception(e);
                return null;
            }
        }
    }

    protected String toDateString(Date date) {
        if (date == null) {
            return "0";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

