/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.admin;

import com.perforce.p4java.admin.ITriggerEntry;
import com.perforce.p4java.impl.generic.core.MapEntry;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TriggerEntry
extends MapEntry
implements ITriggerEntry {
    private static final String TRIGGER_ENTRY_TOKEN_REGEX_PATTERN = "[^\\s\"']+|\"([^\"]*)\"|'([^']*)'";
    private String name = null;
    private ITriggerEntry.TriggerType triggerType = null;
    private String path = null;
    private String command = null;

    public TriggerEntry() {
    }

    public TriggerEntry(int order, String name, ITriggerEntry.TriggerType triggerType, String path, String command) {
        super(order, null);
        this.name = name;
        this.triggerType = triggerType;
        this.path = TriggerEntry.quoteWhitespaceString(path);
        this.command = TriggerEntry.quoteWhitespaceString(command);
    }

    public TriggerEntry(String triggerEntry, int order) {
        List<String> parts;
        if (triggerEntry != null && (parts = this.parseTriggerEntry(triggerEntry)) != null && parts.size() == 4) {
            this.order = order;
            this.name = parts.get(0);
            this.triggerType = ITriggerEntry.TriggerType.fromString(parts.get(1));
            this.path = TriggerEntry.quoteWhitespaceString(parts.get(2));
            this.command = TriggerEntry.quoteWhitespaceString(parts.get(3));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ITriggerEntry.TriggerType getTriggerType() {
        return this.triggerType;
    }

    @Override
    public void setTriggerType(ITriggerEntry.TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = TriggerEntry.quoteWhitespaceString(path);
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(String command) {
        this.command = TriggerEntry.quoteWhitespaceString(command);
    }

    private List<String> parseTriggerEntry(String triggerEntry) {
        LinkedList<String> list = new LinkedList<String>();
        if (triggerEntry != null) {
            Pattern pattern = Pattern.compile(TRIGGER_ENTRY_TOKEN_REGEX_PATTERN);
            Matcher regexMatcher = pattern.matcher(triggerEntry);
            while (regexMatcher.find()) {
                if (regexMatcher.groupCount() <= 0) continue;
                if (regexMatcher.group(1) != null) {
                    list.add(regexMatcher.group(1));
                    continue;
                }
                if (regexMatcher.group(2) != null) {
                    list.add(regexMatcher.group(2));
                    continue;
                }
                list.add(regexMatcher.group());
            }
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.triggerType != null) {
            sb.append(" ").append(this.triggerType.toString());
        }
        if (this.path != null) {
            sb.append(" ").append(this.path);
        }
        if (this.command != null) {
            sb.append(" ").append(this.command);
        }
        return sb.toString();
    }
}

