/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.client;

import com.perforce.p4java.client.IProgressReport;
import com.perforce.p4java.server.callback.progress.ProgressUnit;

public abstract class BaseProgressReport
implements IProgressReport {
    protected boolean descriptionChanged = false;
    protected boolean unitsChanged = false;
    protected boolean totalChanged = false;
    protected boolean positionChanged = false;
    protected boolean isNewProgress = true;
    protected String description = "";
    protected ProgressUnit units = ProgressUnit.UNSPECIFIED;
    protected long total = 0L;
    protected long position = 0L;
    protected boolean needFinal = false;
    protected long lastUpdateTime = System.currentTimeMillis();

    @Override
    public void description(String description) {
        this.description = description;
        this.descriptionChanged = true;
    }

    @Override
    public void units(ProgressUnit units) {
        this.units = units;
        this.unitsChanged = true;
    }

    @Override
    public void total(long total) {
        this.total = total;
        this.totalChanged = true;
    }

    @Override
    public void position(long position) {
        this.position(position, 0);
    }

    @Override
    public void position(long position, int flag) {
        if (this.position != position) {
            this.position = position;
            this.positionChanged = true;
        }
        this.considerReport(flag);
    }

    @Override
    public void increment() {
        this.increment(1L, 0);
    }

    @Override
    public void increment(long amount) {
        this.increment(amount, 0);
    }

    @Override
    public void increment(long amount, int flag) {
        if (amount != 0L) {
            this.position += amount;
            this.positionChanged = true;
        }
        this.considerReport(flag);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ProgressUnit getUnits() {
        return this.units;
    }

    protected void considerReport(int flag) {
        this.doReport(flag);
    }

    protected void clearChangeFlags() {
        this.descriptionChanged = false;
        this.unitsChanged = false;
        this.totalChanged = false;
        this.positionChanged = false;
        this.isNewProgress = false;
    }

    protected abstract void doReport(int var1);

    protected void finalize() throws Throwable {
        try {
            if (this.needFinal) {
                this.doReport(2);
            }
        }
        finally {
            super.finalize();
        }
    }
}

