/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.Log;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Metadata {
    public static final String P4JAVA_PROPS_KEY_PREFIX = "com.perforce.p4java.";
    public static final int DEFAULT_MINIMUM_SUPPORTED_SERVER_VERSION = 20052;
    public static final String DEFAULT_VERSION_STRING = "Internal 2010.1 Perforce Development";
    public static final String DEFAULT_DATE_STRING = "unknown";
    private static String p4jVersionString = null;
    private static String p4jDateString = null;
    private static Manifest manifest = null;

    public static String getP4JVersionString() {
        if (p4jVersionString != null) {
            return p4jVersionString;
        }
        p4jVersionString = DEFAULT_VERSION_STRING;
        try {
            Attributes attr;
            String version;
            if (manifest == null) {
                manifest = Metadata.getManifest();
            }
            if ((version = (attr = manifest.getMainAttributes()).getValue(Attributes.Name.IMPLEMENTATION_VERSION)) != null) {
                p4jVersionString = version;
            }
        }
        catch (Exception exc) {
            Log.warn("unable to get manifest version attribute: " + exc.getLocalizedMessage(), new Object[0]);
        }
        return p4jVersionString;
    }

    public static String getP4JDateString() {
        if (p4jDateString != null) {
            return p4jVersionString;
        }
        p4jDateString = DEFAULT_DATE_STRING;
        try {
            Attributes attr;
            String date;
            if (manifest == null) {
                manifest = Metadata.getManifest();
            }
            if ((date = (attr = manifest.getMainAttributes()).getValue("Build-Date")) != null) {
                p4jDateString = date;
            }
        }
        catch (Exception exc) {
            Log.warn("unable to get manifest date attribute: " + exc.getLocalizedMessage(), new Object[0]);
        }
        return p4jDateString;
    }

    public static void main(String[] args) {
        try {
            String type;
            Manifest manifest = Metadata.getManifest();
            Attributes attr = manifest.getMainAttributes();
            System.out.println(attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE));
            StringBuilder version = new StringBuilder(attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
            String changelist = attr.getValue("Build-Changelist");
            if (changelist != null) {
                version.append('/').append(changelist);
            }
            if ((type = attr.getValue("Build-Type")) != null) {
                version.append('/').append(type);
            }
            System.out.println(version);
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest() throws Exception {
        String className = Metadata.class.getSimpleName() + ".class";
        URL classURL = Metadata.class.getResource(className);
        if (classURL == null) {
            throw new Exception("Error retrieving class as resource: " + className);
        }
        String classPath = classURL.toString();
        if (!classPath.startsWith("jar")) {
            throw new Exception("Not running from jar file: " + classPath);
        }
        int separator = classPath.lastIndexOf(33);
        if (separator != -1 && separator + 1 >= classPath.length()) {
            throw new Exception("Invalid jar file class path: " + classPath);
        }
        String manifestPath = classPath.substring(0, separator + 1) + "/META-INF/MANIFEST.MF";
        try (InputStream inStream = null;){
            inStream = new URL(manifestPath).openStream();
            Manifest manifest = new Manifest(inStream);
            return manifest;
        }
    }
}

