/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.server.callback.ILogCallback;
import java.util.Objects;

public class Log {
    private static ILogCallback logCallback = null;

    public static ILogCallback getLogCallback() {
        return logCallback;
    }

    public static ILogCallback setLogCallback(ILogCallback logCallback) {
        ILogCallback oldCallback = Log.logCallback;
        Log.logCallback = logCallback;
        return oldCallback;
    }

    public static void error(String errorString, Object ... args) {
        if (Objects.nonNull(logCallback)) {
            String errorMessage = errorString;
            if (Objects.nonNull(args)) {
                errorMessage = StringHelper.format(errorString, args);
            }
            logCallback.internalError(errorMessage);
        }
    }

    public static void warn(String warnString, Object ... args) {
        if (Objects.nonNull(logCallback)) {
            String warningMessage = warnString;
            if (Objects.nonNull(args)) {
                warningMessage = StringHelper.format(warnString, args);
            }
            logCallback.internalWarn(warningMessage);
        }
    }

    public static void info(String infoString, Object ... args) {
        if (Objects.nonNull(logCallback)) {
            String infoMessage = infoString;
            if (Objects.nonNull(args)) {
                infoMessage = StringHelper.format(infoString, args);
            }
            logCallback.internalInfo(infoMessage);
        }
    }

    public static void stats(String statsString, Object ... args) {
        if (Objects.nonNull(logCallback)) {
            String statsMessage = statsString;
            if (Objects.nonNull(args)) {
                statsMessage = StringHelper.format(statsString, args);
            }
            logCallback.internalStats(statsMessage);
        }
    }

    public static void exception(Throwable thr) {
        if (Objects.nonNull(logCallback) && Objects.nonNull(thr)) {
            logCallback.internalException(thr);
        }
    }

    public static void trace(ILogCallback.LogTraceLevel traceLevel, String traceMessage) {
        if (Objects.nonNull(logCallback) && Objects.nonNull((Object)traceLevel) && Objects.nonNull(traceMessage) && Log.isTracingAtLevel(traceLevel)) {
            logCallback.internalTrace(traceLevel, traceMessage);
        }
    }

    public static boolean isTracingAtLevel(ILogCallback.LogTraceLevel traceLevel) {
        return Objects.nonNull(logCallback) && Objects.nonNull((Object)logCallback.getTraceLevel()) && traceLevel.compareTo(logCallback.getTraceLevel()) <= 0;
    }
}

