/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java.synchronize;

import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.synchronize.Messages;
import com.perforce.team.core.p4java.synchronize.PerforceSyncFile;
import com.perforce.team.core.p4java.synchronize.PerforceSyncInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;

public final class PerforceSubscriber
extends Subscriber {
    private static PerforceSubscriber subscriber;
    private Map<IResource, InternalSyncInfo> infos;
    private IResourceVisitor nullVisitor = new IResourceVisitor(){

        public boolean visit(IResource resource) throws CoreException {
            return true;
        }
    };
    private IResourceVariantComparator comparator = new IResourceVariantComparator(){

        public boolean compare(IResource local, IResourceVariant remote) {
            InternalSyncInfo holder = (InternalSyncInfo)PerforceSubscriber.this.infos.get(local);
            if (holder != null) {
                PerforceSyncFile file = holder.remote;
                if (file == null) {
                    file = holder.base;
                }
                if (file != null && file.getFile() != null) {
                    return !file.getFile().isOpened();
                }
            }
            return false;
        }

        public boolean compare(IResourceVariant base, IResourceVariant remote) {
            if (base == remote) {
                return true;
            }
            if (base == null || remote == null) {
                return false;
            }
            return base.getContentIdentifier().equals(remote.getContentIdentifier());
        }

        public boolean isThreeWay() {
            return true;
        }
    };
    private IP4Listener listener = new IP4Listener(){

        @Override
        public void resoureChanged(P4Event event) {
            ResourceVisitor visitor = new ResourceVisitor();
            try {
                if (P4Event.EventType.REFRESHED == event.getType()) {
                    IP4Resource[] iP4ResourceArray = event.getResources();
                    int n = iP4ResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Resource resource = iP4ResourceArray[n2];
                        if (resource instanceof IP4File) {
                            PerforceSubscriber.this.updateFile((IP4File)resource, visitor);
                        } else if (resource instanceof IP4PendingChangelist) {
                            IP4File[] iP4FileArray = ((IP4PendingChangelist)resource).getPendingFiles();
                            int n3 = iP4FileArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IP4File file = iP4FileArray[n4];
                                PerforceSubscriber.this.updateFile(file, visitor);
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                visitor.add(event.getLocalResources());
                if (visitor.size() > 0) {
                    PerforceSubscriber.this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)PerforceSubscriber.this, (IResource[])visitor.toArray()));
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        @Override
        public String getName() {
            return ((Object)((Object)PerforceSubscriber.this)).getClass().getSimpleName();
        }
    };

    public static synchronized PerforceSubscriber getSubscriber() {
        if (subscriber == null) {
            subscriber = new PerforceSubscriber();
        }
        return subscriber;
    }

    private PerforceSubscriber() {
        this.infos = Collections.synchronizedMap(new HashMap());
        P4Workspace.getWorkspace().addListener(this.listener);
    }

    public String getName() {
        return Messages.PerforceSynchronizations;
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    public SyncInfo getSyncInfo(IResource resource) throws TeamException {
        PerforceSyncInfo info = null;
        try {
            InternalSyncInfo element;
            if (resource.getType() == 1 && (element = this.infos.get(resource)) != null) {
                info = new PerforceSyncInfo(resource, (IResourceVariant)element.base, (IResourceVariant)element.remote, this.getResourceComparator(), element.p4File);
                info.init();
            }
        }
        catch (Exception e) {
            PerforceProviderPlugin.logError(e);
        }
        catch (Error e) {
            PerforceProviderPlugin.logError(e);
        }
        return info;
    }

    public boolean isSupervised(IResource resource) throws TeamException {
        return PerforceTeamProvider.getPerforceProvider(resource) != null;
    }

    public IResource[] members(IResource resource) throws TeamException {
        IResource[] members = null;
        if (resource.getType() == 1) {
            members = new IResource[]{};
        } else if (resource instanceof IContainer) {
            ArrayList<IResource> memberList = new ArrayList<IResource>();
            try {
                memberList.addAll(Arrays.asList(((IContainer)resource).members(4)));
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError(e);
            }
            members = memberList.toArray(new IResource[0]);
        }
        return members;
    }

    private boolean isOutOfSync(IP4File file) {
        if (file.getRemotePath() != null) {
            if (file.isOpened()) {
                return file.openedByOwner();
            }
            if (!file.isSynced()) {
                return file.getHaveRevision() != 0 || !file.isHeadActionDelete();
            }
        }
        return false;
    }

    private void updateFile(IP4File file, IResourceVisitor visitor) throws CoreException {
        IFile[] files = file.getLocalFiles();
        String name = file.getName();
        if (this.isOutOfSync(file)) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IPath location;
                IFile localFile = iFileArray[n2];
                visitor.visit((IResource)localFile);
                String fileName = localFile.getName();
                if (localFile.isLinked() && (location = localFile.getLocation()) != null && location.lastSegment() != null) {
                    fileName = location.lastSegment();
                }
                if (fileName.equals(name)) {
                    InternalSyncInfo holder = this.infos.get(localFile);
                    if (holder == null) {
                        holder = new InternalSyncInfo();
                        this.infos.put((IResource)localFile, holder);
                    }
                    holder.remote = null;
                    holder.base = null;
                    holder.p4File = file;
                    if (!file.openedForAdd()) {
                        if (!file.isHeadActionDelete()) {
                            holder.remote = new PerforceSyncFile(file, PerforceSyncFile.VariantType.REMOTE);
                        }
                        if (file.getHaveRevision() > 0) {
                            holder.base = new PerforceSyncFile(file, PerforceSyncFile.VariantType.BASE);
                        }
                    }
                }
                ++n2;
            }
        } else {
            IFile[] iFileArray = files;
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                IFile localFile = iFileArray[n3];
                visitor.visit((IResource)localFile);
                if (localFile.getName().equals(name)) {
                    this.infos.remove(localFile);
                }
                ++n3;
            }
        }
    }

    private void addLinkedFolders(IResource[] resources, Collection<IResource> withLinked) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isLinked()) {
                withLinked.add(resource);
            }
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    this.addLinkedFolders(container.members(4), withLinked);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private void refreshResources(IProgressMonitor monitor, int work, IResource[] resources) {
        SubProgressMonitor refreshMonitor = new SubProgressMonitor(monitor, work);
        refreshMonitor.beginTask("", resources.length);
        try {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                String path;
                IResource resource = iResourceArray[n2];
                IPath location = resource.getLocation();
                if (location != null && (path = location.makeAbsolute().toOSString()) != null) {
                    refreshMonitor.setTaskName(MessageFormat.format(Messages.Refreshing, path));
                }
                try {
                    resource.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                refreshMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            refreshMonitor.done();
        }
    }

    private void loadResources(IProgressMonitor monitor, int work, IResource[] resources, List<IP4Resource> p4Resources) {
        SubProgressMonitor loadMonitor = new SubProgressMonitor(monitor, work);
        loadMonitor.beginTask("", resources.length);
        try {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource file;
                String path;
                IResource resource = iResourceArray[n2];
                IPath location = resource.getLocation();
                if (location != null && (path = location.makeAbsolute().toOSString()) != null) {
                    loadMonitor.setTaskName(MessageFormat.format(Messages.Loading, path));
                }
                if ((file = P4Workspace.getWorkspace().getResource(resource)) != null) {
                    p4Resources.add(file);
                }
                loadMonitor.worked(1);
                ++n2;
            }
        }
        finally {
            loadMonitor.done();
        }
    }

    private void statResources(IProgressMonitor monitor, int work, List<IP4Resource> p4Resources, List<IResource> newFiles) throws CoreException {
        SubProgressMonitor statMonitor = new SubProgressMonitor(monitor, work);
        statMonitor.beginTask("", p4Resources.size());
        try {
            IP4File[] localFiles;
            P4Collection collection = new P4Collection(p4Resources.toArray(new IP4Resource[p4Resources.size()]));
            collection.resolve(new ResolveFilesAutoOptions().setShowActionsOnly(true).setShowBase(true));
            IP4File[] iP4FileArray = localFiles = collection.getAllLocalFiles((IProgressMonitor)statMonitor);
            int n = localFiles.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File resource = iP4FileArray[n2];
                IP4File file = resource;
                if (file.getRemotePath() != null) {
                    IFile[] files;
                    IFile[] iFileArray = files = file.getLocalFiles();
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IFile localFile = iFileArray[n4];
                        newFiles.add((IResource)localFile);
                        ++n4;
                    }
                    this.updateFile(file, this.nullVisitor);
                }
                ++n2;
            }
        }
        finally {
            statMonitor.done();
        }
    }

    public void refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        HashSet<IResource> original = new HashSet<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            original.add(resource);
            ++n2;
        }
        HashSet<IResource> withLinked = new HashSet<IResource>();
        this.addLinkedFolders(resources, withLinked);
        if (withLinked.size() > 0) {
            original.addAll(withLinked);
        }
        IResource[] combined = original.toArray(new IResource[0]);
        List<IFile> allFiles = P4CoreUtils.getAllFiles(combined);
        for (IFile file : allFiles) {
            this.infos.remove(file);
        }
        ArrayList<IResource> newFiles = new ArrayList<IResource>();
        try {
            try {
                monitor.beginTask(Messages.Synchronizing, 80);
                this.refreshResources(monitor, 10, combined);
                ArrayList<IP4Resource> p4Files = new ArrayList<IP4Resource>();
                this.loadResources(monitor, 20, combined, p4Files);
                this.statResources(monitor, 50, p4Files, newFiles);
                monitor.done();
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError(e);
                if (!newFiles.isEmpty()) {
                    this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])newFiles.toArray(new IResource[0])));
                }
            }
            catch (Error e) {
                PerforceProviderPlugin.logError(e);
                if (!newFiles.isEmpty()) {
                    this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])newFiles.toArray(new IResource[0])));
                }
            }
        }
        finally {
            if (!newFiles.isEmpty()) {
                this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])newFiles.toArray(new IResource[0])));
            }
        }
    }

    public void remove(IResource resource) {
        this.infos.remove(resource);
    }

    public void fireTeamResourceChange(ISubscriberChangeEvent[] deltas) {
        super.fireTeamResourceChange(deltas);
    }

    public IResource[] roots() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && PerforceTeamProvider.getPerforceProvider((IResource)project) != null) {
                projects.add(project);
            }
            ++n2;
        }
        return projects.toArray(new IResource[projects.size()]);
    }

    private static class InternalSyncInfo {
        PerforceSyncFile base;
        PerforceSyncFile remote;
        IP4File p4File;

        private InternalSyncInfo() {
        }
    }

    private static class ResourceVisitor
    implements IResourceVisitor {
        Set<IResource> visited = new HashSet<IResource>();

        private ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            this.visited.add(resource);
            return true;
        }

        public void add(IResource[] resources) throws CoreException {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                this.visit(resource);
                ++n2;
            }
        }

        public int size() {
            return this.visited.size();
        }

        public IResource[] toArray() {
            return this.visited.toArray(new IResource[this.visited.size()]);
        }
    }
}

