/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java.builder;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.client.Client;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.builder.Messages;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class ClientBuilder {
    private ConnectionParameters params;
    private String location = null;
    private String stream;

    public ClientBuilder(ConnectionParameters params, String location, String stream) {
        this.params = params;
        this.location = location;
        this.stream = stream;
    }

    public ClientBuilder(ConnectionParameters params, String location) {
        this(params, location, null);
    }

    public boolean build(IErrorHandler handler) {
        boolean created = false;
        boolean retry = true;
        P4Connection connection = new P4Connection(this.params);
        while (retry) {
            retry = false;
            try {
                created = this.build(connection);
            }
            catch (P4JavaException e) {
                retry = handler.shouldRetry(connection, e);
            }
        }
        return created;
    }

    public boolean build() throws P4JavaException {
        return this.build((IP4Connection)null);
    }

    public IClient getClientTemplate(IErrorHandler handler) {
        IClient template = null;
        boolean retry = true;
        P4Connection connection = new P4Connection(this.params);
        while (retry) {
            retry = false;
            try {
                template = this.getClientTemplate(connection.getServer());
            }
            catch (P4JavaException e) {
                retry = handler.shouldRetry(connection, e);
            }
        }
        return template;
    }

    public IClient getClientTemplate() throws P4JavaException {
        P4Connection connection = new P4Connection(this.params);
        return this.getClientTemplate(connection.getServer());
    }

    private IClient getClientTemplate(IServer server) throws P4JavaException {
        IClient template = null;
        try {
            template = server.getClientTemplate(this.params.getClient());
        }
        catch (P4JavaError e) {
            PerforceProviderPlugin.logError(e);
        }
        return template;
    }

    public boolean build(IP4Connection connection) throws P4JavaException {
        IServer server;
        if (connection == null) {
            connection = new P4Connection(this.params);
        }
        if ((server = connection.getServer()) == null) {
            throw new P4JavaException(Messages.ClientBuilder_RetrieveServerError);
        }
        IClient template = this.getClientTemplate(server);
        if (template == null) {
            return false;
        }
        Client spec = new Client(server);
        StringBuilder root = new StringBuilder();
        root.append(this.location);
        if (root.length() == 0 || root.charAt(root.length() - 1) != File.separatorChar) {
            root.append(File.separatorChar);
        }
        try {
            File path = new File(root.toString());
            if (!path.exists() && !path.mkdirs()) {
                String msg = MessageFormat.format(Messages.ClientBuilder_CreateFolderError, path.getAbsolutePath());
                throw new Exception(msg);
            }
        }
        catch (Exception e) {
            throw new P4JavaException((Throwable)e);
        }
        if (!StringUtils.isEmpty((CharSequence)this.stream)) {
            spec.setStream(this.stream);
        }
        spec.setRoot(root.toString());
        spec.setOwnerName(this.params.getUser());
        spec.setName(this.params.getClient());
        spec.setClientView(template.getClientView());
        spec.setHostName(template.getHostName());
        spec.setDescription(template.getDescription());
        spec.setSubmitOptions(template.getSubmitOptions());
        spec.setOptions(template.getOptions());
        spec.setLineEnd(template.getLineEnd());
        try {
            server.createClient((IClient)spec);
        }
        catch (P4JavaError e) {
            PerforceProviderPlugin.logError(e);
        }
        return true;
    }
}

