/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.core.p4java.P4Changelist;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Job;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4SubmittedFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class P4SubmittedChangelist
extends P4Changelist
implements IP4SubmittedChangelist {
    private boolean hasReview;

    public P4SubmittedChangelist(IP4Connection connection, IChangelist list) {
        super(connection, list);
        this.readOnly = false;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IP4SubmittedChangelist && super.equals(obj);
    }

    @Override
    public IP4Resource[] getFiles() {
        ArrayList<IP4Resource> files = new ArrayList<IP4Resource>();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4SubmittedFile) {
                files.add(resource);
            }
            ++n2;
        }
        return files.toArray(new IP4Resource[files.size()]);
    }

    @Override
    public String getActionPath() {
        StringBuilder path = null;
        if (this.cachedFiles.isEmpty()) {
            this.refresh();
        }
        String[] paths = null;
        if (this.cachedFiles != null) {
            for (IP4Resource resource : this.cachedFiles) {
                if (!(resource instanceof IP4SubmittedFile)) continue;
                String[] segments = resource.getRemotePath().split("/");
                if (paths != null) {
                    int common = 0;
                    int length = Math.min(paths.length, segments.length);
                    int i = 0;
                    while (i < length) {
                        if (!segments[i].equals(paths[i])) break;
                        ++common;
                        ++i;
                    }
                    String[] newPaths = new String[common];
                    System.arraycopy(segments, 0, newPaths, 0, common);
                    paths = newPaths;
                    continue;
                }
                paths = new String[segments.length - 1];
                System.arraycopy(segments, 0, paths, 0, segments.length - 1);
            }
        }
        if (paths != null) {
            path = new StringBuilder("//");
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                void segment = stringArray[n2];
                if (segment.length() > 0) {
                    path.append((String)segment);
                    path.append('/');
                }
                ++n2;
            }
            path.append("...");
        }
        if (path == null) {
            path = new StringBuilder("//...");
        }
        return path.toString();
    }

    @Override
    public void refresh() {
        if (this.changelist != null) {
            try {
                HashSet<P4Resource> resources = new HashSet<P4Resource>();
                List jobs = this.changelist.getJobs();
                for (IJob job : jobs) {
                    P4Job p4Job = new P4Job(job, this.getConnection(), this);
                    resources.add(p4Job);
                }
                this.changelist.refresh();
                List files = this.changelist.getFiles(false);
                for (IFileSpec file : files) {
                    if (file == null || FileSpecOpStatus.VALID != file.getOpStatus()) continue;
                    P4SubmittedFile submittedFile = new P4SubmittedFile(new P4File(file, this){

                        @Override
                        public void refresh() {
                        }

                        @Override
                        public void setFileSpec(IFileSpec spec) {
                        }
                    }, this);
                    resources.add(submittedFile);
                }
                this.cachedFiles = resources;
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        this.needsRefresh = false;
    }

    public String toString() {
        return ("P4SubmittedChangelist:[" + this.getDescription() + "]").replaceAll("[\n|\r]", "");
    }

    @Override
    public boolean hasReview() {
        return this.hasReview;
    }

    @Override
    public void setHasReview(boolean hasReview) {
        this.hasReview = hasReview;
    }
}

