/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.p4java.option.client.RevertFilesOptions;
import com.perforce.p4java.option.client.SyncOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.IStreamingCallback;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceConnectionFactory;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4ClientOperation;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4ProgressListener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ServerOperation;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4ProgressListener;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4SandBoxUtils;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class P4Collection
extends P4Resource
implements IP4Container {
    public static final String EDIT_DEFAULT_DESCRIPTION = Messages.P4Collection_0;
    public static final String ADD_DEFAULT_DESCRIPTION = Messages.P4Collection_1;
    public static final String DELETE_DEFAULT_DESCRIPTION = Messages.P4Collection_2;
    private IP4Resource.Type type = IP4Resource.Type.REMOTE;
    private Set<IP4Resource> resources = new HashSet<IP4Resource>();

    public static P4Collection createCollection(IP4Connection connection, List<IFileSpec> specs) {
        P4Collection collection = null;
        collection = connection != null && specs != null ? P4Collection.getValidCollection(connection, specs, IP4Resource.Type.REMOTE) : new P4Collection();
        return collection;
    }

    public P4Collection() {
    }

    private void runOperation(IP4Connection connection, IP4ClientOperation operation) {
        if (connection != null && operation != null) {
            boolean retry = true;
            IClient client = connection.getClient();
            while (retry && client != null) {
                retry = false;
                try {
                    operation.run(client);
                }
                catch (P4JavaException e) {
                    retry = this.handleError(connection, e);
                    if (retry) {
                        client = connection.getClient();
                    }
                    PerforceProviderPlugin.logError(e);
                }
                catch (P4JavaError e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
        }
    }

    private void runOperation(IP4Connection connection, IP4ServerOperation operation) {
        if (connection != null && operation != null) {
            boolean retry = true;
            IServer server = connection.getServer();
            while (retry && server != null) {
                retry = false;
                try {
                    operation.run(server);
                }
                catch (P4JavaException e) {
                    retry = this.handleError(connection, e);
                    if (retry) {
                        server = connection.getServer();
                    }
                    PerforceProviderPlugin.logError(e);
                }
                catch (P4JavaError e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
        }
    }

    public P4Collection(IP4Resource[] resources) {
        if (resources != null) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                this.add(resource);
                ++n2;
            }
        }
    }

    public P4Collection(Collection<IP4Resource> resources) {
        if (resources != null) {
            for (IP4Resource resource : resources) {
                this.add(resource);
            }
        }
    }

    public P4Collection(P4Collection collection) {
        if (collection != null) {
            this.addAll(collection);
        }
    }

    public void addAll(P4Collection collection) {
        if (collection != null) {
            this.resources.addAll(collection.resources);
        }
    }

    public <T> T[] toArray(T[] array) {
        return this.resources.toArray(array);
    }

    @Override
    public int size() {
        return this.resources.size();
    }

    public void reopen(final IP4PendingChangelist changelist) {
        IClient client;
        if (changelist != null && (client = changelist.getClient()) != null && changelist.getId() > -1) {
            ArrayList<String> paths = new ArrayList<String>();
            IP4Resource[] iP4ResourceArray = this.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                String path = resource.getActionPath(this.type);
                if (path != null) {
                    paths.add(path);
                }
                ++n2;
            }
            if (paths.size() > 0) {
                final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(paths.toArray(new String[0]));
                P4ClientOperation operation = new P4ClientOperation(){

                    @Override
                    public void run(IClient client) throws P4JavaException, P4JavaError {
                        List reopened = client.reopenFiles(specList, changelist.getId(), null);
                        P4Collection reopenedResources = P4Collection.this.getValidOpenCollection(changelist.getConnection(), reopened);
                        if (reopenedResources.members().length > 0) {
                            changelist.getConnection().updateRevertedFiles(reopenedResources);
                            P4Collection.this.updateChangelist(changelist, reopenedResources);
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REVERTED, reopenedResources));
                            reopenedResources.refresh();
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, reopenedResources));
                        }
                        P4Collection.this.handleErrors(reopened.toArray(new IFileSpec[0]));
                    }
                };
                this.runOperation(changelist.getConnection(), operation);
            }
        }
    }

    public void lock() {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.isEmpty()) continue;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List locked = client.lockFiles(specList, -1);
                    P4Collection lockedResources = P4Collection.getValidCollection(connection, locked, P4Collection.this.getType());
                    if (!lockedResources.isEmpty()) {
                        lockedResources.refresh();
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.LOCKED, lockedResources));
                    }
                    P4Collection.this.handleErrors(locked.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
    }

    public void unlock() {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.isEmpty()) continue;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List unlocked = client.unlockFiles(specList, -1, false);
                    P4Collection unlockedResources = P4Collection.getValidCollection(connection, unlocked, P4Collection.this.getType());
                    if (!unlockedResources.isEmpty()) {
                        unlockedResources.refresh();
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.UNLOCKED, unlockedResources));
                    }
                    P4Collection.this.handleErrors(unlocked.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
    }

    public void fix(IP4Changelist changelist) {
        if (changelist != null) {
            IP4Resource[] fixed;
            ArrayList<IP4Job> jobs = new ArrayList<IP4Job>();
            IP4Resource[] iP4ResourceArray = this.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4Job) {
                    jobs.add((IP4Job)resource);
                }
                ++n2;
            }
            if (jobs.size() > 0 && (fixed = changelist.fix(jobs.toArray(new IP4Job[0]))).length > 0) {
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.FIXED, new P4Collection(fixed)));
            }
        }
    }

    public void unfix(IP4Changelist changelist) {
        if (changelist != null) {
            IP4Resource[] unfixed;
            ArrayList<IP4Job> jobs = new ArrayList<IP4Job>();
            IP4Resource[] iP4ResourceArray = this.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4Job) {
                    jobs.add((IP4Job)resource);
                }
                ++n2;
            }
            if (jobs.size() > 0 && (unfixed = changelist.unfix(jobs.toArray(new IP4Job[0]))).length > 0) {
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.UNFIXED, new P4Collection(unfixed)));
            }
        }
    }

    private boolean handleError(IP4Connection connection, P4JavaException exception) {
        IErrorHandler handler;
        boolean retry = false;
        if (connection != null && exception != null && (handler = connection.getErrorHandler()) != null) {
            retry = handler.shouldRetry(connection, exception);
        }
        return retry;
    }

    public IP4Resource[] resolve(final ResolveFilesAutoOptions options) {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        final ArrayList resolvedFiles = new ArrayList();
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            IClient client = connection.getClient();
            if (client == null) continue;
            List<String> clientResources = entry.getValue();
            final List<IFileSpec> resolveSpecs = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List resolved = client.resolveFilesAuto(resolveSpecs, options);
                    P4Collection resolvedResources = null;
                    if (options.isShowActionsOnly()) {
                        resolvedResources = P4Collection.getValidCollection(connection, resolved, P4Collection.this.getType(), true);
                    } else {
                        resolved = client.resolvedFiles(resolveSpecs, false);
                        resolvedResources = P4Collection.getValidCollection(connection, resolved, P4Collection.this.getType(), true);
                        if (!resolvedResources.isEmpty()) {
                            resolvedResources.refresh();
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.RESOLVED, resolvedResources));
                        }
                    }
                    P4Collection.this.handleErrors(resolveSpecs.toArray(new IFileSpec[0]));
                    resolvedFiles.addAll(Arrays.asList(resolvedResources.members()));
                }
            };
            this.runOperation(connection, operation);
        }
        return resolvedFiles.toArray(new IP4Resource[0]);
    }

    public IP4Resource[] resolveChangelist(final ResolveFilesAutoOptions options, final IP4Connection connection) {
        final ArrayList resolvedFiles = new ArrayList();
        IClient client = connection.getClient();
        if (client != null) {
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List resolved = client.resolveFilesAuto(null, options);
                    P4Collection resolvedResources = null;
                    if (options.isShowActionsOnly()) {
                        resolvedResources = P4Collection.getValidCollection(connection, resolved, P4Collection.this.getType(), true);
                    } else {
                        resolved = client.resolvedFiles(null, false);
                        resolvedResources = P4Collection.getValidCollection(connection, resolved, P4Collection.this.getType(), true);
                        if (!resolvedResources.isEmpty()) {
                            resolvedResources.refresh();
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.RESOLVED, resolvedResources));
                        }
                    }
                    P4Collection.this.handleErrors(resolved.toArray(new IFileSpec[0]));
                    resolvedFiles.addAll(Arrays.asList(resolvedResources.members()));
                }
            };
            this.runOperation(connection, operation);
        }
        return resolvedFiles.toArray(new IP4Resource[0]);
    }

    public IP4Resource[] resolve(final InputStream stream, final boolean useTextualMerge, final int startFromRev, final int endFromRev) {
        final ArrayList resolvedSpecs = new ArrayList();
        final P4Collection resolvedResources = new P4Collection();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                final IP4File file = (IP4File)resource;
                P4ClientOperation operation = new P4ClientOperation(){

                    @Override
                    public void run(IClient client) throws P4JavaException, P4JavaError {
                        FileSpec resolveSpec;
                        IFileSpec resolvedSpec;
                        String path = file.getActionPath(P4Collection.this.getType());
                        if (client != null && path != null && (resolvedSpec = client.resolveFile((IFileSpec)(resolveSpec = new FileSpec(path)), stream, useTextualMerge, startFromRev, endFromRev)) != null) {
                            resolvedSpecs.add(resolvedSpec);
                            if (FileSpecOpStatus.VALID == resolvedSpec.getOpStatus()) {
                                resolvedResources.add(file);
                            }
                        }
                    }
                };
                this.runOperation(file.getConnection(), operation);
            }
            ++n2;
        }
        if (!resolvedResources.isEmpty()) {
            resolvedResources.refresh();
            resolvedResources.refreshLocalResources(2);
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.RESOLVED, resolvedResources));
        }
        this.handleErrors(resolvedSpecs.toArray(new IFileSpec[0]));
        return resolvedResources.members();
    }

    public void add(IP4Resource file) {
        if (file != null && !file.isReadOnly()) {
            this.resources.add(file);
        }
    }

    public void add(P4Collection collection) {
        if (collection != null) {
            IP4Resource[] iP4ResourceArray = collection.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                this.add(resource);
                ++n2;
            }
        }
    }

    public boolean contains(IP4Resource file) {
        if (file != null && this.resources != null) {
            return this.resources.contains(file);
        }
        return false;
    }

    protected Map<IClient, List<IP4Resource>> generateClientMap(List<IP4Resource> items) {
        HashMap<IClient, List<IP4Resource>> mappedClients = new HashMap<IClient, List<IP4Resource>>();
        for (IP4Resource resource : items) {
            IClient client = resource.getClient();
            if (client == null) continue;
            List<IP4Resource> clientResources = null;
            if (mappedClients.containsKey(client)) {
                clientResources = (List)mappedClients.get(client);
            } else {
                clientResources = new ArrayList();
                mappedClients.put(client, clientResources);
            }
            clientResources.add(resource);
        }
        return mappedClients;
    }

    public static P4Collection getValidCollection(IP4Connection connection, List<? extends IFileSpec> specs, IP4Resource.Type type, boolean updateIntegSpec) {
        P4Collection collection = new P4Collection();
        collection.setType(type);
        ArrayList<IP4Resource> resources = new ArrayList<IP4Resource>();
        if (specs != null) {
            HashSet<String> paths = new HashSet<String>();
            for (IFileSpec iFileSpec : specs) {
                if (FileSpecOpStatus.VALID != iFileSpec.getOpStatus()) continue;
                String path = iFileSpec.getDepotPathString();
                if (path == null) {
                    path = P4Resource.normalizeLocalPath(iFileSpec);
                }
                if (path == null) continue;
                IP4Resource resource = connection.getResource(path);
                if (resource == null && connection.updateResourceThenCheckNotify(resource = new P4File(iFileSpec, connection))) {
                    resources.add(resource);
                }
                if (updateIntegSpec && resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    ArrayList<IFileSpec> list = new ArrayList<IFileSpec>();
                    if (paths.contains(path) && file.getIntegrationSpecs() != null) {
                        list.addAll(Arrays.asList(file.getIntegrationSpecs()));
                    }
                    list.add(iFileSpec);
                    file.setIntegrationSpecs(list.toArray(new IFileSpec[0]));
                    paths.add(path);
                }
                collection.add(resource);
            }
        }
        if (resources.size() > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ADDED, resources.toArray(new IP4Resource[0])));
        }
        return collection;
    }

    public static P4Collection getValidCollection(IP4Connection connection, List<? extends IFileSpec> specs, IP4Resource.Type type) {
        return P4Collection.getValidCollection(connection, specs, type, false);
    }

    private P4Collection getValidOpenCollection(IP4Connection connection, List<? extends IFileSpec> specs) {
        P4Collection collection = new P4Collection();
        ArrayList<IP4Resource> resources = new ArrayList<IP4Resource>();
        if (specs != null) {
            for (IFileSpec iFileSpec : specs) {
                if (iFileSpec.getChangelistId() <= -1 || FileSpecOpStatus.VALID != iFileSpec.getOpStatus()) continue;
                String path = iFileSpec.getDepotPathString();
                if (path == null) {
                    path = P4Resource.normalizeLocalPath(iFileSpec);
                }
                if (path == null) continue;
                IP4Resource resource = connection.getResource(path);
                if (resource == null && connection.updateResourceThenCheckNotify(resource = new P4File(iFileSpec, connection))) {
                    resources.add(resource);
                }
                collection.add(resource);
            }
        }
        if (resources.size() > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ADDED, resources.toArray(new IP4Resource[0])));
        }
        return collection;
    }

    private P4Collection getValidSyncedCollection(IP4Connection connection, List<? extends IFileSpec> specs) {
        P4Collection collection = new P4Collection();
        ArrayList<IP4Resource> resources = new ArrayList<IP4Resource>();
        if (specs != null) {
            for (IFileSpec iFileSpec : specs) {
                String path;
                int index;
                String message;
                if (FileSpecOpStatus.VALID == iFileSpec.getOpStatus()) {
                    String path2 = iFileSpec.getDepotPathString();
                    if (path2 == null) {
                        path2 = P4Resource.normalizeLocalPath(iFileSpec);
                    }
                    if (path2 == null) continue;
                    IP4Resource resource = connection.getResource(path2);
                    if (resource == null && connection.updateResourceThenCheckNotify(resource = new P4File(iFileSpec, connection))) {
                        resources.add(resource);
                    }
                    collection.add(resource);
                    continue;
                }
                if (FileSpecOpStatus.INFO != iFileSpec.getOpStatus() || (message = iFileSpec.getStatusMessage()) == null || (index = message.indexOf(" - must resolve")) <= -1 || (path = message.substring(0, index)).length() <= 0) continue;
                IP4Resource resource = connection.getResource(path);
                if (resource == null && connection.updateResourceThenCheckNotify(resource = new P4File(iFileSpec, connection))) {
                    resources.add(resource);
                }
                collection.add(resource);
            }
        }
        if (resources.size() > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ADDED, resources.toArray(new IP4Resource[0])));
        }
        return collection;
    }

    protected Map<IClient, List<String>> generateClientSpecMapping(Set<IP4Resource> items) {
        return this.generateClientSpecMapping(items, true);
    }

    protected Map<IClient, List<String>> generateClientSpecMapping(Set<IP4Resource> items, boolean formatted) {
        HashMap<IClient, List<String>> mappedClients = new HashMap<IClient, List<String>>();
        for (IP4Resource resource : items) {
            IClient client = resource.getClient();
            if (client == null) continue;
            List<String> clientResources = null;
            if (mappedClients.containsKey(client)) {
                clientResources = (List)mappedClients.get(client);
            } else {
                clientResources = new ArrayList();
                mappedClients.put(client, clientResources);
            }
            String actionPath = resource.getActionPath(this.type);
            if (actionPath == null) continue;
            if (formatted) {
                actionPath = PerforceConnectionFactory.formatFilename(actionPath);
            }
            clientResources.add(actionPath);
        }
        return mappedClients;
    }

    protected Map<IP4Connection, List<String>> generateConnectionSpecMapping(Collection<IP4Resource> items) {
        return this.generateConnectionSpecMapping(items, true);
    }

    protected Map<IP4Connection, List<String>> generateConnectionSpecMapping(Collection<IP4Resource> items, boolean formatted) {
        HashMap<IP4Connection, List<String>> mappedClients = new HashMap<IP4Connection, List<String>>();
        for (IP4Resource resource : items) {
            IP4Connection connection = resource.getConnection();
            if (connection == null) continue;
            List<String> clientResources = null;
            if (mappedClients.containsKey(connection)) {
                clientResources = (List)mappedClients.get(connection);
            } else {
                clientResources = new ArrayList();
                mappedClients.put(connection, clientResources);
            }
            String actionPath = resource.getActionPath(this.type);
            if (actionPath == null || "".equals(actionPath)) continue;
            if (formatted) {
                actionPath = PerforceConnectionFactory.formatFilename(actionPath);
            }
            clientResources.add(actionPath);
        }
        return mappedClients;
    }

    public Map<IP4Connection, List<IP4Resource>> toResourceMap() {
        HashMap<IP4Connection, List<IP4Resource>> mappedClients = new HashMap<IP4Connection, List<IP4Resource>>();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            IP4Connection connection = resource.getConnection();
            if (connection != null) {
                List<IP4Resource> resources = null;
                if (mappedClients.containsKey(connection)) {
                    resources = (List)mappedClients.get(connection);
                } else {
                    resources = new ArrayList();
                    mappedClients.put(connection, resources);
                }
                resources.add(resource);
            }
            ++n2;
        }
        return mappedClients;
    }

    public Map<IP4Connection, List<IP4File>> toFileMap() {
        HashMap<IP4Connection, List<IP4File>> mappedClients = new HashMap<IP4Connection, List<IP4File>>();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Connection connection;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File && (connection = resource.getConnection()) != null) {
                List<IP4File> resources = null;
                if (mappedClients.containsKey(connection)) {
                    resources = (List)mappedClients.get(connection);
                } else {
                    resources = new ArrayList();
                    mappedClients.put(connection, resources);
                }
                resources.add((IP4File)resource);
            }
            ++n2;
        }
        return mappedClients;
    }

    @Override
    public IP4Resource[] members() {
        return this.resources.toArray(new IP4Resource[0]);
    }

    private void loadChildResource(IP4Container container, Set<IP4Resource> resources) {
        IP4Resource[] members;
        IP4Resource[] iP4ResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource member = iP4ResourceArray[n2];
            if (member instanceof IP4Container) {
                this.loadChildResource((IP4Container)member, resources);
            }
            resources.add(member);
            ++n2;
        }
    }

    public IP4Resource[] allMembers() {
        HashSet<IP4Resource> all = new HashSet<IP4Resource>();
        for (IP4Resource resource : this.resources) {
            if (resource instanceof IP4Container) {
                this.loadChildResource((IP4Container)resource, all);
            }
            all.add(resource);
        }
        return all.toArray(new IP4Resource[0]);
    }

    @Override
    public String getActionPath() {
        return null;
    }

    @Override
    public String getActionPath(IP4Resource.Type type) {
        return null;
    }

    @Override
    public IClient getClient() {
        return null;
    }

    @Override
    public IP4Connection getConnection() {
        return null;
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public IP4Container getParent() {
        return null;
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    private void updateChangelist(IP4PendingChangelist list, P4Collection editedFiles) {
        if (list != null) {
            IP4Resource[] iP4ResourceArray = editedFiles.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    list.addFile((IP4File)resource);
                }
                ++n2;
            }
        }
    }

    private int createChangelist(IP4Connection connection, String description) {
        int id = -1;
        IP4PendingChangelist newList = connection.createChangelist(description, null);
        if (newList != null) {
            id = newList.getId();
        }
        return id;
    }

    public void addToChangelistModel(IP4PendingChangelist list) {
        if (list != null) {
            IP4Resource[] iP4ResourceArray = this.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    list.addFile((IP4File)resource);
                }
                ++n2;
            }
        }
    }

    @Override
    public void add(int changelist) {
        this.addToChangelist(changelist);
    }

    public P4Collection addToChangelist(int changelist) {
        return this.addToChangelist(changelist, false);
    }

    public P4Collection addToChangelist(int changelist, boolean setActive) {
        return this.addToChangelist(changelist, null, setActive);
    }

    public P4Collection addToChangelist(int changelist, String description, boolean setActive) {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources, false);
        final P4Collection allResources = new P4Collection();
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.isEmpty()) continue;
            if (changelist == -2) {
                if (description == null) {
                    description = ADD_DEFAULT_DESCRIPTION;
                }
                changelist = this.createChangelist(connection, description);
            }
            if (changelist < 0) continue;
            if (setActive) {
                connection.setActivePendingChangelist(changelist);
            }
            final int listId = changelist;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List added = client.addFiles(specList, false, listId, null, true);
                    P4Collection addedResources = P4Collection.getValidCollection(connection, added, P4Collection.this.getType());
                    if (!addedResources.isEmpty()) {
                        addedResources.refresh();
                        P4Collection.this.updateChangelist(connection.getPendingChangelist(listId), addedResources);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, addedResources));
                        allResources.addAll(addedResources);
                    }
                    P4Collection.this.handleErrors(added.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
        return allResources;
    }

    @Override
    public void delete(int changelist) {
        this.delete(changelist, false);
    }

    public void delete(int changelist, boolean setActive) {
        this.delete(changelist, null, setActive);
    }

    public void delete(int changelist, String description, boolean setActive) {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.size() <= 0) continue;
            if (changelist == -2) {
                if (description == null) {
                    description = DELETE_DEFAULT_DESCRIPTION;
                }
                changelist = this.createChangelist(connection, description);
            }
            if (changelist < 0) continue;
            if (setActive) {
                connection.setActivePendingChangelist(changelist);
            }
            final int listId = changelist;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List deleted = client.deleteFiles(specList, listId, false);
                    P4Collection deletedResources = P4Collection.getValidCollection(connection, deleted, P4Collection.this.getType());
                    if (!deletedResources.isEmpty()) {
                        deletedResources.refresh();
                        P4Collection.this.updateChangelist(connection.getPendingChangelist(listId), deletedResources);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, deletedResources));
                    }
                    P4Collection.this.handleErrors(deleted.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
    }

    @Override
    public void edit(int changelist) {
        this.edit(changelist, false);
    }

    public void edit(int changelist, boolean setActive) {
        this.edit(changelist, null, setActive);
    }

    public void revertThenEdit(int changelist, String description, boolean setActive) {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.size() <= 0) continue;
            if (changelist == -2) {
                if (description == null) {
                    description = EDIT_DEFAULT_DESCRIPTION;
                }
                changelist = this.createChangelist(connection, description);
            }
            if (changelist < 0) continue;
            if (setActive) {
                connection.setActivePendingChangelist(changelist);
            }
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            final int listId = changelist;
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List edited = client.revertFiles(specList, new RevertFilesOptions().setNoClientRefresh(true));
                    edited = client.editFiles(specList, false, false, listId, null);
                    P4Collection editedCollection = P4Collection.getValidCollection(connection, edited, P4Collection.this.getType());
                    if (!editedCollection.isEmpty()) {
                        editedCollection.refresh();
                        P4Collection.this.updateChangelist(connection.getPendingChangelist(listId), editedCollection);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, editedCollection));
                    }
                    P4Collection.this.handleErrors(edited.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
    }

    public void edit(int changelist, String description, boolean setActive) {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.size() <= 0) continue;
            if (changelist == -2) {
                if (description == null) {
                    description = EDIT_DEFAULT_DESCRIPTION;
                }
                changelist = this.createChangelist(connection, description);
            }
            if (changelist < 0) continue;
            if (setActive) {
                connection.setActivePendingChangelist(changelist);
            }
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            final int listId = changelist;
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List edited = client.editFiles(specList, false, false, listId, null);
                    P4Collection editedCollection = P4Collection.getValidCollection(connection, edited, P4Collection.this.getType());
                    if (!editedCollection.isEmpty()) {
                        editedCollection.refresh();
                        P4Collection.this.updateChangelist(connection.getPendingChangelist(listId), editedCollection);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, editedCollection));
                    }
                    P4Collection.this.handleErrors(edited.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
    }

    public P4Collection previewUnchangedRevert() {
        return this.revert(true, true);
    }

    public P4Collection revert(boolean preview, boolean unchangedOnly) {
        return this.revert(preview, unchangedOnly, false);
    }

    public P4Collection revert(final boolean preview, final boolean unchangedOnly, final boolean wipeAddFiles) {
        IClient client;
        IP4Connection connection;
        final P4Collection collection = new P4Collection();
        for (IP4Resource resource : this.resources) {
            if (!(resource instanceof IP4PendingChangelist)) continue;
            final IP4PendingChangelist list = (IP4PendingChangelist)resource;
            connection = list.getConnection();
            client = list.getClient();
            if (connection == null || client == null) continue;
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(final IClient client) throws P4JavaException, P4JavaError {
                    final ArrayList<FileSpec> specs = new ArrayList<FileSpec>();
                    String name = client.getName();
                    if (name != null) {
                        name = "//" + name + "/...";
                        specs.add(new FileSpec(name));
                    }
                    final ArrayList reverted = new ArrayList();
                    try {
                        Tracing.printExecTime2(Policy.DEBUG_TIME, "revert", "list-" + list.getId(), new Tracing.IRunnable(){

                            @Override
                            public void run() throws Throwable {
                                List rlist = client.revertFiles(specs, preview, list.getId(), unchangedOnly, false);
                                reverted.addAll(rlist);
                            }
                        });
                    }
                    catch (P4JavaException e) {
                        throw e;
                    }
                    catch (P4JavaError e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    P4Collection revertedCollection = P4Collection.getValidCollection(connection, reverted, P4Collection.this.getType());
                    if (!preview && !revertedCollection.isEmpty()) {
                        revertedCollection.refresh();
                        connection.updateRevertedFiles(revertedCollection);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REVERTED, revertedCollection));
                    }
                    collection.add(revertedCollection);
                    P4Collection.this.handleErrors(reverted.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            List<String> clientResources;
            connection = entry.getKey();
            client = connection.getClient();
            if (client == null || (clientResources = entry.getValue()).size() <= 0) continue;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            final ArrayList reverted = new ArrayList();
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    RevertFilesOptions revertOpts = new RevertFilesOptions();
                    revertOpts.setNoUpdate(preview);
                    revertOpts.setNoClientRefresh(false);
                    revertOpts.setRevertOnlyUnchanged(unchangedOnly);
                    revertOpts.setWipeAddFiles(wipeAddFiles);
                    List rlist = client.revertFiles(specList, revertOpts);
                    reverted.addAll(rlist);
                    P4Collection revertedCollection = P4Collection.getValidCollection(connection, reverted, P4Collection.this.getType());
                    if (!preview && !revertedCollection.isEmpty()) {
                        revertedCollection.refresh();
                        connection.updateRevertedFiles(revertedCollection);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REVERTED, revertedCollection));
                    }
                    collection.add(revertedCollection);
                    P4Collection.this.handleErrors(reverted.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
        return collection;
    }

    public P4Collection previewRevert() {
        return this.revert(true, false);
    }

    @Override
    public void revert() {
        this.revert(false, false);
    }

    @Override
    public void revert(boolean wipeAddFiles) {
        this.revert(false, false, wipeAddFiles);
    }

    @Override
    public void sync(IProgressMonitor monitor, IP4ProgressListener callback) {
        this.sync(false, false, null, monitor, callback);
    }

    public List<IFileSpec> previewSync(IProgressMonitor monitor) {
        return this.sync(false, true, null, monitor, null);
    }

    public void forceSync(IProgressMonitor monitor) {
        this.sync(true, false, null, monitor, null);
    }

    public void sync(String revision, IProgressMonitor monitor) {
        this.sync(false, false, revision, monitor, null);
    }

    public IP4Resource[] getUnresolved() {
        return this.resolve(new ResolveFilesAutoOptions().setShowActionsOnly(true).setShowBase(true));
    }

    public List<IFileSpec> sync(final boolean force, final boolean preview, String revision, final IProgressMonitor monitor, final IP4ProgressListener callback) {
        monitor.beginTask("sync", 200);
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null) continue;
            if (revision != null) {
                ArrayList<String> revisioned = new ArrayList<String>();
                if (!clientResources.isEmpty()) {
                    for (String path : clientResources) {
                        revisioned.add(String.valueOf(path) + revision);
                    }
                } else {
                    revisioned.add(revision);
                }
                clientResources = revisioned;
            }
            if (clientResources.isEmpty()) continue;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    ArrayList<String> oplist = new ArrayList<String>();
                    if (force) {
                        oplist.add("-f");
                    }
                    if (preview) {
                        oplist.add("-n");
                    }
                    SyncOptions opt = new SyncOptions(oplist.toArray(new String[0]));
                    int key = P4CoreUtils.getRandomInt();
                    List<IFileSpec> syncSpecs = null;
                    if (callback != null) {
                        callback.setConnection(connection);
                        client.sync(specList, opt, (IStreamingCallback)callback, key);
                        syncSpecs = callback.getFileSpecs();
                    } else {
                        P4ProgressListener cb = P4CoreUtils.createStreamCallback(connection, CmdSpec.SYNC, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        client.sync(specList, opt, (IStreamingCallback)cb, key);
                        syncSpecs = cb.getFileSpecs();
                    }
                    specs.addAll(syncSpecs);
                    P4Collection syncedResources = P4Collection.this.getValidSyncedCollection(connection, syncSpecs);
                    monitor.setTaskName(Messages.P4Collection_RefreshResourceAfterSync);
                    monitor.worked(100);
                    if (!preview && !syncedResources.isEmpty()) {
                        syncedResources.refresh();
                        syncedResources.refreshLocalResources(2);
                    }
                    P4Collection.this.handleErrors(syncSpecs.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
        return specs;
    }

    public void changeType(final String newType) {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            List<String> clientResources = entry.getValue();
            IClient client = connection.getClient();
            if (client == null || clientResources.isEmpty()) continue;
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List changed = client.reopenFiles(specList, -1, newType);
                    P4Collection changedCollection = P4Collection.getValidCollection(connection, changed, P4Collection.this.getType());
                    if (!changedCollection.isEmpty()) {
                        changedCollection.refresh();
                    }
                }
            };
            this.runOperation(connection, operation);
        }
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    @Override
    public void refresh() {
        this.refresh(1);
    }

    public void resetStateValidation() {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager == null) {
            return;
        }
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                IFile[] files;
                IFile[] iFileArray = files = ((IP4File)resource).getLocalFiles();
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFileBuffer buffer;
                    IFile file = iFileArray[n4];
                    IPath location = file.getLocation();
                    if (location != null && (buffer = manager.getFileBuffer(location, LocationKind.NORMALIZE)) != null) {
                        buffer.resetStateValidation();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void refreshLocalResources(int depth) {
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            IContainer[] iContainerArray;
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4Folder) {
                IContainer[] containers;
                iContainerArray = containers = ((IP4Folder)resource).getLocalContainers();
                n4 = containers.length;
                n3 = 0;
                while (n3 < n4) {
                    IContainer container = iContainerArray[n3];
                    if (container != null) {
                        try {
                            container.refreshLocal(depth, null);
                        }
                        catch (CoreException e) {
                            PerforceProviderPlugin.logError(e);
                        }
                    }
                    ++n3;
                }
            } else if (resource instanceof IP4File) {
                IFile[] files = ((IP4File)resource).getLocalFiles();
                iContainerArray = files;
                n4 = files.length;
                n3 = 0;
                while (n3 < n4) {
                    IContainer file = iContainerArray[n3];
                    try {
                        file.refreshLocal(depth, null);
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError(e);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public void tag(String label) {
        this.tag(label, null, false, false);
    }

    public void tag(String label, String revision) {
        this.tag(label, revision, false, false);
    }

    public void tag(final String label, String revision, final boolean delete, final boolean preview) {
        if (label == null) {
            return;
        }
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            IP4Connection connection = entry.getKey();
            IServer server = connection.getServer();
            if (server == null) continue;
            List<String> clientResources = entry.getValue();
            if (revision != null) {
                ArrayList<String> revisioned = new ArrayList<String>();
                for (String path : clientResources) {
                    revisioned.add(String.valueOf(path) + revision);
                }
                clientResources = revisioned;
            }
            final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[0]));
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    List specs = server.tagFiles(specList, label, preview, delete);
                    P4Collection.this.handleErrors(specs.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
    }

    @Override
    public void markForRefresh() {
    }

    @Override
    public boolean needsRefresh() {
        return false;
    }

    @Override
    public void refresh(int depth) {
        if (this.resources.size() > 0) {
            final HashSet<IP4Resource> files = new HashSet<IP4Resource>();
            for (IP4Resource resource : this.resources) {
                IP4Connection connection;
                if (resource instanceof IP4File) {
                    files.add(resource);
                    continue;
                }
                if (!(resource instanceof IP4Container) || (connection = resource.getConnection()) == resource) continue;
                IP4File[] found = connection.findFiles(resource.getActionPath(this.type));
                files.addAll(Arrays.asList(found));
            }
            final P4Collection refreshCollection = new P4Collection(files);
            Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
            for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
                List<String> clientResources;
                final IP4Connection connection = entry.getKey();
                IServer server = connection.getServer();
                if (server == null || (clientResources = entry.getValue()).isEmpty()) continue;
                final List<IFileSpec> specList = P4FileSpecBuilder.makeFileSpecList(clientResources.toArray(new String[clientResources.size()]));
                P4ClientOperation operation = new P4ClientOperation(){

                    @Override
                    public void run(IClient client) throws P4JavaException, P4JavaError {
                        IServer server = client.getServer();
                        if (server != null) {
                            List specs = client.getServer().getExtendedFiles(specList, 0, -1, -1, null, null);
                            ArrayList<IP4File> validFiles = new ArrayList<IP4File>();
                            ArrayList<IExtendedFileSpec> validSpecs = new ArrayList<IExtendedFileSpec>();
                            for (IExtendedFileSpec spec : specs) {
                                IP4File file;
                                if (FileSpecOpStatus.VALID != spec.getOpStatus() || (file = connection.getFile((IFileSpec)spec)) == null) continue;
                                files.remove(file);
                                validFiles.add(file);
                                validSpecs.add(spec);
                            }
                            if (!validFiles.isEmpty()) {
                                P4Collection.this.batchMoveFilesToSubmittedChangelist(validFiles, validSpecs, refreshCollection);
                            }
                            P4Collection.this.handleErrors(specs.toArray(new IFileSpec[specs.size()]));
                        }
                    }
                };
                this.runOperation(connection, operation);
            }
            this.batchRemoveFilesFromChangelist(files);
            if (!refreshCollection.isEmpty()) {
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, refreshCollection));
            }
        }
    }

    protected void batchMoveFilesToSubmittedChangelist(List<IP4File> files, List<IExtendedFileSpec> specs, P4Collection refreshCollection) {
        IP4Connection connection;
        ArrayList<IP4File> flist;
        HashMap removeMap = new HashMap();
        HashMap addMap = new HashMap();
        int i = 0;
        while (i < files.size()) {
            IP4File file = files.get(i);
            IExtendedFileSpec spec = specs.get(i);
            int previousChangelist = file.getChangelistId();
            file.setFileSpec((IFileSpec)spec, refreshCollection, false);
            int newChangelist = file.getChangelistId();
            IP4Connection connection2 = file.getConnection();
            if (connection2 != null) {
                Map<Integer, ArrayList<IP4File>> submap;
                if (previousChangelist > -1 && previousChangelist != newChangelist) {
                    submap = (HashMap<Integer, ArrayList<IP4File>>)removeMap.get(connection2);
                    if (submap == null) {
                        submap = new HashMap<Integer, ArrayList<IP4File>>();
                        removeMap.put(connection2, submap);
                    }
                    if ((flist = (List)submap.get(previousChangelist)) == null) {
                        flist = new ArrayList<IP4File>();
                        submap.put(previousChangelist, flist);
                    }
                    flist.add(file);
                }
                if (newChangelist > -1 && newChangelist != previousChangelist) {
                    submap = (Map)addMap.get(connection2);
                    if (submap == null) {
                        submap = new HashMap();
                        addMap.put(connection2, submap);
                    }
                    if ((flist = (List)submap.get(newChangelist)) == null) {
                        flist = new ArrayList();
                        submap.put(newChangelist, flist);
                    }
                    flist.add(file);
                }
            }
            ++i;
        }
        for (Map.Entry outerEntry : removeMap.entrySet()) {
            connection = (IP4Connection)outerEntry.getKey();
            Map submap = (Map)outerEntry.getValue();
            for (Map.Entry entry : submap.entrySet()) {
                int change = (Integer)entry.getKey();
                flist = (ArrayList<IP4File>)entry.getValue();
                IP4PendingChangelist iP4PendingChangelist = connection.getPendingChangelist(change, false, true);
                if (iP4PendingChangelist == null) continue;
                for (IP4Resource iP4Resource : flist) {
                    iP4PendingChangelist.removeFile((IP4File)iP4Resource);
                }
                if (refreshCollection != null) {
                    refreshCollection.add(iP4PendingChangelist);
                    continue;
                }
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, iP4PendingChangelist));
            }
        }
        for (Map.Entry outerEntry : addMap.entrySet()) {
            connection = (IP4Connection)outerEntry.getKey();
            Map submap = (Map)outerEntry.getValue();
            for (Map.Entry entry : submap.entrySet()) {
                int change = (Integer)entry.getKey();
                flist = (List)entry.getValue();
                for (IP4Resource iP4Resource : flist) {
                    IP4PendingChangelist newList = connection.getPendingChangelist(change, ((IP4File)iP4Resource).isOpened(), true);
                    if (newList == null) continue;
                    newList.addFile((IP4File)iP4Resource);
                }
            }
        }
    }

    private void batchRemoveFilesFromChangelist(Set<IP4Resource> files) {
        HashMap removeMap = new HashMap();
        for (IP4Resource iP4Resource : files) {
            ArrayList<IP4File> flist;
            IP4File file = (IP4File)iP4Resource;
            int previousChangelist = file.getChangelistId();
            file.setFileSpec(null, null, false);
            IP4Connection connection = file.getConnection();
            if (connection == null || previousChangelist <= -1) continue;
            HashMap<Integer, ArrayList<IP4File>> submap = (HashMap<Integer, ArrayList<IP4File>>)removeMap.get(connection);
            if (submap == null) {
                submap = new HashMap<Integer, ArrayList<IP4File>>();
                removeMap.put(connection, submap);
            }
            if ((flist = (ArrayList<IP4File>)submap.get(previousChangelist)) == null) {
                flist = new ArrayList<IP4File>();
                submap.put(previousChangelist, flist);
            }
            flist.add(file);
        }
        for (Map.Entry entry : removeMap.entrySet()) {
            IP4Connection connection = (IP4Connection)entry.getKey();
            Map submap = (Map)entry.getValue();
            for (Map.Entry entry2 : submap.entrySet()) {
                int change = (Integer)entry2.getKey();
                List flist = (List)entry2.getValue();
                IP4PendingChangelist oldList = connection.getPendingChangelist(change, false, true);
                if (oldList == null) continue;
                for (IP4Resource file : flist) {
                    oldList.removeFile((IP4File)file);
                }
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, oldList));
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.resources.size() > 0) {
            for (IP4Resource resource : this.resources) {
                IFile[] files;
                if (!(resource instanceof IP4File)) continue;
                IFile[] iFileArray = files = ((IP4File)resource).getLocalFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile file = iFileArray[n2];
                    ResourceAttributes attrs = file.getResourceAttributes();
                    if (attrs != null) {
                        attrs.setReadOnly(readOnly);
                        try {
                            file.setResourceAttributes(attrs);
                        }
                        catch (CoreException e) {
                            PerforceProviderPlugin.logError(e);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public IP4File[] getAllLocalFiles(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IP4File> locals = new ArrayList<IP4File>();
        ArrayList<IP4File> containerFiles = new ArrayList<IP4File>();
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        for (IP4Resource resource : this.resources) {
            String path = resource.getActionPath(this.getType());
            if (path != null) {
                monitor.setTaskName(MessageFormat.format(Messages.P4Collection_7, path));
            }
            if (resource instanceof IP4Container) {
                List<IP4File> filesFromContainer = Arrays.asList(((IP4Container)resource).getAllLocalFiles());
                containerFiles.addAll(filesFromContainer);
                locals.addAll(filesFromContainer);
            } else if (resource instanceof IP4File) {
                files.add((IP4File)resource);
                locals.add((IP4File)resource);
            }
            monitor.worked(1);
        }
        if (!files.isEmpty()) {
            P4Collection filesCollections = new P4Collection(files.toArray(new IP4File[0]));
            filesCollections.setType(this.getType());
            filesCollections.refresh();
        }
        P4Collection filesFound = new P4Collection(containerFiles.toArray(new IP4File[0]));
        filesFound.setType(this.getType());
        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, filesFound));
        return locals.toArray(new IP4File[0]);
    }

    @Override
    public IP4File[] getAllLocalFiles() {
        return this.getAllLocalFiles(null);
    }

    public IP4Resource.Type getType() {
        return this.type;
    }

    public void setType(IP4Resource.Type type) {
        this.type = type;
    }

    public List<IFileSpec> pull() {
        Map<IP4Connection, List<String>> items = this.generateConnectionSpecMapping(this.resources);
        final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
        for (Map.Entry<IP4Connection, List<String>> entry : items.entrySet()) {
            final IP4Connection connection = entry.getKey();
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List<IFileSpec> pullSpecs = P4SandBoxUtils.pull(connection);
                    specs.addAll(pullSpecs);
                    P4Collection pulledResources = P4Collection.this.getValidSyncedCollection(connection, pullSpecs);
                    pulledResources.refresh();
                    P4Collection.this.handleErrors(pullSpecs.toArray(new IFileSpec[0]));
                }
            };
            this.runOperation(connection, operation);
        }
        return specs;
    }
}

