/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.P4Connection;

public class P4BrowsableConnection
extends P4Connection {
    private boolean clientExists = false;

    public P4BrowsableConnection(ConnectionParameters params) {
        super(params);
    }

    @Override
    public boolean refreshClient() {
        IServer server = this.getServer();
        boolean retry = true;
        if (retry && server != null) {
            retry = false;
            try {
                String clientName = this.getParameters().getClient();
                IClient latest = null;
                if (clientName != null) {
                    latest = server.getClientTemplate(clientName, true);
                    this.clientExists = latest != null ? latest.getUpdated() != null && latest.getAccessed() != null : false;
                    server.setCurrentClient(latest);
                } else {
                    this.clientExists = false;
                }
                this.client = latest;
            }
            catch (P4JavaException e) {
                this.handleError(e);
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
            return this.client != null;
        }
        return false;
    }

    @Override
    public void connect() {
        this.refresh();
        IServer server = this.getServer();
        if (server != null) {
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    this.refreshClient();
                    this.serverInfo = server.getServerInfo();
                    if (this.getVersion() != null && !this.isSupported()) {
                        throw this.createUnsupportedException();
                    }
                    if (this.serverInfo != null) {
                        this.connected = true;
                        this.offline = false;
                        continue;
                    }
                    this.connected = false;
                }
                catch (P4JavaException e) {
                    retry = this.handleError(e);
                    if (retry) {
                        server = this.getServer();
                    } else {
                        this.connected = false;
                    }
                    PerforceProviderPlugin.logError(e);
                }
                catch (P4JavaError e) {
                    this.connected = false;
                    PerforceProviderPlugin.logError(e);
                }
            }
        } else {
            this.connected = false;
        }
    }

    public boolean clientExists() {
        return this.clientExists;
    }

    @Override
    public boolean equals(Object otherConnection) {
        return otherConnection instanceof P4BrowsableConnection && this.getParameters().equals(((P4BrowsableConnection)otherConnection).getParameters());
    }

    @Override
    public int hashCode() {
        return this.getParameters().hashCode();
    }
}

