/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.map;

import com.perforce.team.core.map.MapFlag;
import com.perforce.team.core.map.MapHalf;
import com.perforce.team.core.map.MapParams;
import com.perforce.team.core.map.MapTableT;
import com.perforce.team.core.map.MapWhole;

public class MapItem {
    MapWhole[] halves = new MapWhole[2];
    MapItem chain;
    MapFlag mapFlag;
    int slot;

    public static MapItem tree(MapItem[] start, int startIndex, int endIndex, MapTableT dir, MapItem parent, int depth) {
        int ri;
        if (start == null || start.length == 0 || startIndex == endIndex) {
            return null;
        }
        int li = startIndex;
        if (start[startIndex] == start[endIndex - 1] || start[startIndex].isParent(start[endIndex - 1], dir)) {
            ri = endIndex;
        } else {
            ri = startIndex + (endIndex - startIndex) / 2;
            while (li < ri && !start[li].isParent(start[ri], dir)) {
                ++li;
            }
            while (ri < start.length && start[li].isParent(start[ri], dir)) {
                ++ri;
            }
        }
        MapWhole t = start[li].whole(dir.ordinal());
        int depthBelow = 0;
        t.overlap = 0;
        t.maxSlot = start[li].slot;
        t.left = MapItem.tree(start, startIndex, li, dir, start[li], depthBelow);
        t.center = MapItem.tree(start, li + 1, ri, dir, start[li], depthBelow);
        t.right = MapItem.tree(start, ri, endIndex, dir, start[li], depthBelow);
        if (parent != null) {
            if (parent.whole((int)dir.ordinal()).maxSlot < t.maxSlot) {
                parent.whole((int)dir.ordinal()).maxSlot = t.maxSlot;
            }
            t.overlap = t.half.getCommonLen(parent.ths(dir));
        }
        return start[li];
    }

    MapItem(MapItem c, String l, String r, MapFlag f, int s) {
        this.halves[MapTableT.LHS.ordinal()] = new MapWhole();
        this.halves[MapTableT.RHS.ordinal()] = new MapWhole();
        this.halves[MapTableT.LHS.ordinal()].half = new MapHalf(l);
        this.halves[MapTableT.RHS.ordinal()].half = new MapHalf(r);
        this.mapFlag = f;
        this.chain = c;
        this.slot = s;
    }

    MapHalf lhs() {
        return this.half(MapTableT.LHS.ordinal());
    }

    MapHalf rhs() {
        return this.half(MapTableT.RHS.ordinal());
    }

    MapHalf ths(MapTableT dir) {
        return this.half(dir.ordinal());
    }

    MapHalf ohs(MapTableT dir) {
        return this.half(1 - dir.ordinal());
    }

    MapItem next() {
        return this.chain;
    }

    MapFlag flag() {
        return this.mapFlag;
    }

    int slot() {
        return this.slot;
    }

    MapWhole whole(int dir) {
        return this.halves[dir];
    }

    MapHalf half(int dir) {
        return this.halves[dir].half;
    }

    boolean isParent(MapItem other, MapTableT dir) {
        return this.ths(dir).getFixedLen() == this.ths(dir).getCommonLen(other.ths(dir));
    }

    public MapItem reverse() {
        MapItem m = this;
        MapItem entry = null;
        int top = m != null ? m.slot : 0;
        while (m != null) {
            MapItem n = m.chain;
            m.chain = entry;
            m.slot = top - m.slot;
            entry = m;
            m = n;
        }
        return entry;
    }

    public MapItem match(MapTableT dir, String from) {
        int coff = 0;
        int best = -1;
        MapItem map = null;
        MapItem tree = this;
        MapParams params = new MapParams();
        while (tree != null) {
            MapWhole t = tree.whole(dir.ordinal());
            if (best > t.maxSlot) break;
            if (coff > t.overlap) {
                coff = t.overlap;
            }
            int r = 0;
            if (coff < t.half.getFixedLen()) {
                r = t.half.match1(from, coff);
            }
            if (r == 0 && best < tree.slot && t.half.match2(from, params) != 0) {
                map = tree;
                best = map.slot;
            }
            tree = r < 0 ? t.left : (r > 0 ? t.right : t.center);
        }
        if (map == null || map.mapFlag == MapFlag.MfUnmap) {
            return null;
        }
        return map;
    }
}

