/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.map;

import com.perforce.team.core.map.MapChar;
import com.perforce.team.core.map.MapCharClass;
import com.perforce.team.core.map.MapParam;
import com.perforce.team.core.map.MapParams;

public class MapHalf {
    public static final int PARAM_VECTOR_LENGTH = 30;
    public static final int PARAM_MAX_BACKTRACK = 10;
    public static final int PARAM_MAX_WILDS = 10;
    public static final int[][] CmpGrid;
    String string;
    MapChar[] mapChar;
    int mapTail;
    int mapEnd;
    int fixedLen;
    boolean isWild;
    int nWilds = 0;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[6];
        nArray[1] = -1;
        nArray[2] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, -2, -2, 1, 1, 1};
        nArrayArray[2] = new int[]{1, -2, 2, 1, 1, 1};
        int[] nArray2 = new int[6];
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArrayArray[3] = nArray2;
        int[] nArray3 = new int[6];
        nArray3[1] = -1;
        nArray3[2] = -1;
        nArrayArray[4] = nArray3;
        int[] nArray4 = new int[6];
        nArray4[1] = -1;
        nArray4[2] = -1;
        nArrayArray[5] = nArray4;
        CmpGrid = nArrayArray;
    }

    public MapHalf(String p) {
        int l = p.length() + 1;
        this.string = p;
        this.mapChar = new MapChar[l];
        MapChar.ParseSession session = new MapChar.ParseSession();
        int mc = 0;
        StringBuilder buffer = new StringBuilder(p);
        while ((this.mapChar[mc] = new MapChar()).set(buffer, session)) {
            ++mc;
        }
        this.mapEnd = mc;
        while (mc > 0 && (this.mapChar[mc - 1].cc == MapCharClass.cCHAR || this.mapChar[mc - 1].cc == MapCharClass.cSLASH)) {
            --mc;
        }
        this.mapTail = mc;
        mc = 0;
        while (this.mapChar[mc].cc == MapCharClass.cCHAR || this.mapChar[mc].cc == MapCharClass.cSLASH) {
            ++mc;
        }
        this.isWild = this.mapChar[mc].cc != MapCharClass.cEOS;
        this.fixedLen = mc;
        this.nWilds = 0;
        mc = 0;
        while (this.mapChar[mc].cc != MapCharClass.cEOS) {
            if (this.mapChar[mc].isWild()) {
                ++this.nWilds;
            }
            ++mc;
        }
    }

    public String toString() {
        return this.string;
    }

    boolean hasSubDirs(int match) {
        MapChar mc = this.mapChar[match];
        while (mc.cc != MapCharClass.cEOS && mc.cc != MapCharClass.cSLASH && mc.cc != MapCharClass.cDOTS) {
            mc = this.mapChar[++match];
        }
        return mc.cc != MapCharClass.cEOS;
    }

    public boolean hasEndSlashEllipses() {
        MapChar mc = this.mapChar[this.mapEnd - 1];
        if (!this.isWild) {
            return false;
        }
        if (mc == this.mapChar[0]) {
            return false;
        }
        mc = this.mapChar[this.mapEnd - 2];
        if (mc.cc != MapCharClass.cSLASH && mc.c != '\\') {
            return false;
        }
        return mc.cc == MapCharClass.cDOTS;
    }

    public int compare(MapHalf item) {
        int mc1 = 0;
        int mc2 = 0;
        int l = this.fixedLen < item.fixedLen ? this.fixedLen : item.fixedLen;
        while (l-- != 0 && this.mapChar[mc1].equals(item.mapChar[mc2])) {
            ++mc1;
            ++mc2;
        }
        while (true) {
            switch (CmpGrid[this.mapChar[mc1].cc.ordinal()][item.mapChar[mc2].cc.ordinal()]) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
                case 0: {
                    return 0;
                }
                case -2: {
                    int d = this.mapChar[mc1].compareTo(item.mapChar[mc2]);
                    if (d == 0) break;
                    return d;
                }
            }
            ++mc1;
            ++mc2;
        }
    }

    public int getFixedLen() {
        return this.fixedLen;
    }

    public int getCommonLen(MapHalf prev) {
        int matchLen = 0;
        MapChar mc1 = this.mapChar[matchLen];
        MapChar mc2 = prev.mapChar[matchLen];
        while (matchLen < this.fixedLen && mc1.compareTo(mc2) == 0) {
            mc1 = this.mapChar[++matchLen];
            mc2 = prev.mapChar[matchLen];
        }
        return matchLen;
    }

    public int match1(String from, int coff) {
        int r = 0;
        while (coff < this.fixedLen && coff < from.length()) {
            r = this.mapChar[coff].c - from.charAt(coff);
            if (r != 0) {
                return -r;
            }
            ++coff;
        }
        if (from.length() < this.fixedLen) {
            r = -1;
        }
        return r;
    }

    public int match2(String from, MapParams params) {
        if (from.length() < this.fixedLen) {
            return 0;
        }
        int mc = this.fixedLen;
        if (this.isWild) {
            int i = from.length() - 1;
            int index = this.mapEnd - 1;
            while (index > this.mapTail) {
                if (this.mapChar[index].c - from.charAt(i) != 0) {
                    return 0;
                }
                --i;
                --index;
            }
        }
        int input = this.fixedLen;
        Backup[] backup = new Backup[20];
        int i = 0;
        while (i < backup.length) {
            backup[i] = new Backup();
            ++i;
        }
        int bIndex = 0;
        block7: while (true) {
            switch (this.mapChar[mc].cc) {
                case cPERC: 
                case cSTAR: 
                case cDOTS: {
                    backup[bIndex].param = params.vector[this.mapChar[mc].paramNumber];
                    backup[bIndex].param.start = input;
                    if (this.mapChar[mc].cc != MapCharClass.cDOTS) {
                        while (input < from.length() && from.charAt(input) != '/') {
                            ++input;
                        }
                    } else {
                        input = from.length();
                    }
                    backup[bIndex].param.end = input;
                    backup[bIndex].mc = ++mc;
                    ++bIndex;
                    continue block7;
                }
                case cCHAR: 
                case cSLASH: {
                    Retry retried;
                    do {
                        if (input >= from.length() || this.mapChar[mc].c != from.charAt(input)) {
                            ++mc;
                            retried = new Retry(input, bIndex);
                            mc = this.retry(bIndex, backup, from, retried);
                            if (mc == -1) {
                                return 0;
                            }
                            input = retried.inputIndex;
                            bIndex = retried.backupIndex;
                            continue block7;
                        }
                        ++input;
                    } while (this.mapChar[++mc].cc == MapCharClass.cCHAR || this.mapChar[mc].cc == MapCharClass.cSLASH);
                    continue block7;
                }
                case cEOS: {
                    Retry retried;
                    if (input > from.length()) {
                        retried = new Retry(input, bIndex);
                        mc = this.retry(bIndex, backup, from, retried);
                        if (mc == -1) {
                            return 0;
                        }
                        input = retried.inputIndex;
                        bIndex = retried.backupIndex;
                        continue block7;
                    }
                    return 1;
                }
            }
        }
    }

    private int retry(int bIndex, Backup[] backup, String from, Retry retry) {
        int mc = -1;
        while (true) {
            if (bIndex <= 0) {
                mc = -1;
                break;
            }
            mc = backup[bIndex - 1].mc;
            retry.inputIndex = --backup[bIndex - 1].param.end;
            if (retry.inputIndex >= backup[bIndex - 1].param.start) break;
            --bIndex;
        }
        retry.backupIndex = bIndex;
        return mc;
    }

    public void expand(String from, StringBuilder output, MapParams params) {
        MapChar[] mapCharArray = this.mapChar;
        int n = this.mapChar.length;
        int n2 = 0;
        while (n2 < n) {
            MapChar mc = mapCharArray[n2];
            if (mc.cc == MapCharClass.cEOS) break;
            if (mc.isWild()) {
                int slot = mc.paramNumber;
                int start = params.vector[slot].start;
                int end = params.vector[slot].end;
                output.append(from.substring(start, end));
            } else {
                output.append(mc.c);
            }
            ++n2;
        }
    }

    private static class Backup {
        int mc;
        MapParam param;

        private Backup() {
        }
    }

    private static class Retry {
        int inputIndex;
        int backupIndex;

        public Retry(int index, int lastBackup) {
            this.inputIndex = index;
            this.backupIndex = lastBackup;
        }
    }
}

