/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4SecureStore;
import com.perforce.team.core.PerforceProviderPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.team.core.RepositoryProvider;

public class PerforceTeamProvider
extends RepositoryProvider {
    public static final String ID = "com.perforce.team.core.PerforceTeamProvider";
    private static FileModificationValidator modValidator = null;
    private static IMoveDeleteHook moveDeleteHook = null;
    private static final QualifiedName PERFORCE_PORT = new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "port");
    private static final QualifiedName PERFORCE_CLIENT = new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "client");
    private static final QualifiedName PERFORCE_USER = new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "user");
    private static final QualifiedName PERFORCE_PASSWORD = new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "password");
    private static final QualifiedName PERFORCE_CHARSET = new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "charset");
    private static final QualifiedName PERFORCE_CONNECTION = new QualifiedName("com.perforce.team.core.PerforceTeamProvider", "connection");
    private boolean oldFormat = false;
    private static final IResourceRuleFactory PERFORCE_RULE_FACTORY = new ResourceRuleFactory(){};

    public IResourceRuleFactory getRuleFactory() {
        return PERFORCE_RULE_FACTORY;
    }

    public void configureProject() throws CoreException {
        ConnectionParameters params = PerforceProviderPlugin.getCurrParams();
        this.setProjectProperties(params);
    }

    public void setProjectProperties(final ConnectionParameters params) {
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                ConnectionParameters oldParams = PerforceTeamProvider.this.getProjectProperties(true);
                if (PerforceTeamProvider.this.oldFormat || !oldParams.equals(params)) {
                    IProject project = PerforceTeamProvider.this.getProject();
                    project.setPersistentProperty(PERFORCE_CONNECTION, params.toString());
                    if (params.savePassword()) {
                        P4SecureStore.INSTANCE.put(params.getStorageKey(), params.getPasswordNoNull(), true);
                    }
                    PerforceTeamProvider.this.oldFormat = false;
                    if (!(oldParams.getPortNoNull().equals(params.getPortNoNull()) && oldParams.getClientNoNull().equals(params.getClientNoNull()) && oldParams.getUserNoNull().equals(params.getUserNoNull()) && oldParams.getCharsetNoNull().equals(params.getCharsetNoNull()))) {
                        PerforceProviderPlugin.broadcastProjectSettingsChanges(project, params);
                    }
                }
            }

            public void handleException(Throwable e) {
            }
        };
        SafeRunner.run((ISafeRunnable)code);
    }

    public ConnectionParameters getProjectProperties(boolean original) throws CoreException {
        ConnectionParameters params;
        IProject project = this.getProject();
        String conStr = project.getPersistentProperty(PERFORCE_CONNECTION);
        if (conStr != null) {
            params = new ConnectionParameters(conStr);
        } else {
            this.oldFormat = true;
            params = new ConnectionParameters();
            params.setPort(project.getPersistentProperty(PERFORCE_PORT));
            params.setClient(project.getPersistentProperty(PERFORCE_CLIENT));
            params.setUser(project.getPersistentProperty(PERFORCE_USER));
        }
        return params;
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        project.setPersistentProperty(PERFORCE_CONNECTION, null);
        project.setPersistentProperty(PERFORCE_PORT, null);
        project.setPersistentProperty(PERFORCE_CLIENT, null);
        project.setPersistentProperty(PERFORCE_USER, null);
        project.setPersistentProperty(PERFORCE_PASSWORD, null);
        project.setPersistentProperty(PERFORCE_CHARSET, null);
        PerforceProviderPlugin.broadcastProjectSettingsChanges(project, new ConnectionParameters());
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public String getID() {
        return ID;
    }

    public static void registerFileModicationsValidator(FileModificationValidator validator) {
        modValidator = validator;
    }

    public FileModificationValidator getFileModificationValidator2() {
        return modValidator;
    }

    public static void registerMoveDeleteHook(IMoveDeleteHook hook) {
        moveDeleteHook = hook;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return moveDeleteHook;
    }

    public static PerforceTeamProvider getPerforceProvider(IResource resource) {
        IProject project;
        PerforceTeamProvider provider = null;
        if (resource != null && (project = resource.getProject()) != null && (provider = (PerforceTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)ID)) != null) {
            try {
                ConnectionParameters params = provider.getProjectProperties(true);
                if (params.getPort() == null) {
                    provider = null;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return provider;
    }
}

