/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core;

import com.perforce.team.core.ICredentialsStore;
import java.io.IOException;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class P4SecureStore
implements ICredentialsStore {
    private static final String ID_PLUGIN = "com.perforce.team.core";
    private final String url;
    public static final ICredentialsStore INSTANCE = new P4SecureStore("default");

    private P4SecureStore(String url) {
        this.url = url;
    }

    @Override
    public void clear() {
        this.getSecurePreferences().removeNode();
    }

    @Override
    public void flush() throws IOException {
        this.getSecurePreferences().flush();
    }

    @Override
    public String get(String key, String def) throws StorageException {
        return this.getSecurePreferences().get(key, def);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) throws StorageException {
        return this.getSecurePreferences().getByteArray(key, def);
    }

    private ISecurePreferences getSecurePreferences() {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault().node(ID_PLUGIN);
        securePreferences = securePreferences.node(EncodingUtils.encodeSlashes((String)this.getUrl()));
        return securePreferences;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String[] keys() {
        return this.getSecurePreferences().keys();
    }

    @Override
    public void put(String key, String value, boolean encrypt) throws StorageException {
        this.getSecurePreferences().put(key, value, encrypt);
    }

    @Override
    public void putByteArray(String key, byte[] value, boolean encrypt) throws StorageException {
        this.getSecurePreferences().putByteArray(key, value, encrypt);
    }

    @Override
    public void remove(String key) {
        this.getSecurePreferences().remove(key);
    }

    @Override
    public void copyTo(ICredentialsStore target) throws StorageException {
        ISecurePreferences preferences = this.getSecurePreferences();
        String[] stringArray = preferences.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            target.put(key, preferences.get(key, null), preferences.isEncrypted(key));
            ++n2;
        }
    }
}

