/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.model;

import com.perforce.p4java.CharsetDefs;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.ui.patch.model.FileStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WorkspaceStream
extends FileStream {
    private IFile file;
    private OutputStream stream;

    public void setFile(IFile file) {
        this.file = file;
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws IOException {
        if (this.file == null) {
            throw new IOException("Missing workspace file");
        }
        File workspaceFile = this.file.getLocation().toFile();
        this.validateFile(workspaceFile, monitor);
        if (!monitor.isCanceled()) {
            this.stream = new FileOutputStream(workspaceFile);
        }
    }

    @Override
    public OutputStream getStream() throws IOException {
        return this.stream;
    }

    @Override
    public void finish(IProgressMonitor monitor) throws IOException {
        if (this.file != null) {
            try {
                this.file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    public Charset getCharset() {
        Charset charset = null;
        try {
            String name = this.file.getCharset(true);
            if (name != null) {
                charset = P4CoreUtils.charsetForName((String)name);
            }
        }
        catch (CoreException e) {
            charset = null;
        }
        catch (IllegalCharsetNameException e) {
            charset = null;
        }
        catch (UnsupportedCharsetException e) {
            charset = null;
        }
        catch (IllegalArgumentException e) {
            charset = null;
        }
        if (charset == null) {
            charset = CharsetDefs.LOCAL;
        }
        return charset;
    }
}

