/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.model;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.patch.model.ErrorCollector;
import com.perforce.team.ui.patch.model.IErrorCollector;
import com.perforce.team.ui.patch.model.IPatchStream;
import com.perforce.team.ui.patch.model.Messages;
import com.perforce.team.ui.patch.model.PatchDiffRunner;
import com.perforce.team.ui.patch.model.PatchException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.compare.patch.WorkspacePatcherUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class P4Patch {
    public static final String SERVER_DATE_FORMAT = "yyyy-MM-dd kk:mm:ss.SSS Z";
    public static final String PATCH_DATE_FORMAT = "yyyy/MM/dd kk:mm:ss";
    public static final String NULL_DATE = "1970/01/01 00:00:00";
    public static final String NULL_PATH = "/dev/null";
    public static final String FILE_MINUS = "---";
    public static final String FILE_PLUS = "+++";
    public static final String LINE_RANGE = "@@";
    private boolean async = true;
    private IPatchStream stream;
    private Object[] resources;
    private DateFormat serverFormat;
    private DateFormat patchFormat;

    public P4Patch(IPatchStream stream, Object[] resources) {
        Assert.isNotNull((Object)stream, (String)"Patch stream cannot be null");
        Assert.isNotNull((Object)resources, (String)"Resources cannot be null");
        this.stream = stream;
        this.resources = resources;
        this.serverFormat = new SimpleDateFormat(SERVER_DATE_FORMAT);
        this.serverFormat.setLenient(true);
        this.patchFormat = new SimpleDateFormat(PATCH_DATE_FORMAT);
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    private void addResource(IResource resource, IP4File p4File, Map<IProject, List<IP4File>> projects) {
        if (resource != null) {
            IProject project = resource.getProject();
            List<IP4File> resources = projects.get(project);
            if (resources == null) {
                resources = new ArrayList<IP4File>();
                projects.put(project, resources);
            }
            resources.add(p4File);
        }
    }

    private String getRelativePath(String diffPath, IP4Connection connection) {
        IFile workspaceFile;
        String relative = null;
        IP4File file = connection.getFile(diffPath);
        if (file != null && (workspaceFile = file.getLocalFileForLocation()) != null) {
            relative = this.getRelative(workspaceFile);
        }
        return relative;
    }

    private String getRelative(IFile file) {
        String relative = null;
        IPath relativePath = file.getProjectRelativePath();
        if (relativePath != null) {
            relative = relativePath.toPortableString();
        }
        return relative;
    }

    private String getModDate(IFile file) {
        return this.patchFormat.format(new Date(file.getModificationStamp()));
    }

    private void printIndex(String relativePath, PrintWriter writer) {
        writer.println("Index: " + relativePath);
        writer.println("===================================================================");
    }

    private void printDetails(IP4Connection connection, PrintWriter writer) {
        ConnectionParameters params = connection.getParameters();
        writer.print("# P4 Server: ");
        writer.print(params.getPort());
        writer.print(" User: ");
        writer.print(params.getUser());
        writer.print(" Client: ");
        writer.print(params.getClient());
        String charset = params.getCharsetNoNone();
        if (charset != null) {
            writer.print(" Charset: ");
            writer.print(charset);
        }
        writer.println();
    }

    private boolean isFileEntry(String line) {
        return this.isFileStart(line) || line.startsWith(FILE_PLUS);
    }

    private boolean isFileStart(String line) {
        return line.startsWith(FILE_MINUS);
    }

    private int getLineCount(IFile file) throws CoreException, IOException {
        int lines = 0;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(file.getContents(), P4CoreUtils.charsetForName((String)file.getCharset())));
            String line = reader.readLine();
            while (line != null) {
                ++lines;
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lines;
    }

    private void printRevision(IP4File file, PrintWriter writer) {
        String path = file.getActionPath(IP4Resource.Type.REMOTE);
        if (path != null) {
            FileAction action;
            writer.print("# " + path);
            int have = file.getHaveRevision();
            if (have > 0) {
                writer.print("#" + have);
            }
            if ((action = file.getAction()) != null) {
                writer.print(' ');
                writer.print('<');
                writer.print(action.toString().toLowerCase(Locale.US));
                writer.print('>');
            }
            writer.println();
        }
    }

    private void printAdd(IP4File file, PrintWriter writer) throws CoreException, IOException {
        IFile local = file.getLocalFileForLocation();
        if (local != null) {
            String relative = this.getRelative(local);
            this.printIndex(relative, writer);
            this.printRevision(file, writer);
            writer.println("--- /dev/null\t1970/01/01 00:00:00");
            writer.println("+++ " + relative + "\t" + NULL_DATE);
            String line = null;
            BufferedReader reader = null;
            int lines = this.getLineCount(local);
            String end = lines > 1 ? "," + lines : "";
            writer.println("@@ -0,0 +1" + end + " " + LINE_RANGE);
            try {
                reader = new BufferedReader(new InputStreamReader(local.getContents(), P4CoreUtils.charsetForName((String)local.getCharset())));
                int i = 0;
                while (i < lines - 1) {
                    line = reader.readLine();
                    if (line == null) {
                        throw new IOException("Error reading added file");
                    }
                    writer.print('+');
                    writer.println(line);
                    ++i;
                }
                int read = reader.read();
                boolean trailingNewline = false;
                if (read != -1) {
                    writer.print('+');
                }
                while (read != -1) {
                    if (read == 10) {
                        trailingNewline = true;
                    }
                    writer.print((char)read);
                    read = reader.read();
                }
                if (!trailingNewline) {
                    writer.println();
                    writer.println("\\ No newline at end of file");
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private void printEdit(InputStream diff, PrintWriter writer, IP4Connection connection, IP4File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(diff, CharsetDefs.UTF8));
        try {
            String line = reader.readLine();
            while (line != null) {
                String path;
                String relative;
                int firstTab;
                if (this.isFileEntry(line) && (firstTab = line.indexOf(9)) > 4 && (relative = this.getRelativePath(path = line.substring(4, firstTab), connection)) != null) {
                    line = line.replace(path, relative);
                    firstTab = line.indexOf(9);
                    if (this.isFileStart(line = this.replaceDate(line, firstTab + 1))) {
                        this.printIndex(relative, writer);
                        this.printRevision(file, writer);
                    }
                }
                writer.println(line);
                line = reader.readLine();
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String convertDate(String date) {
        String converted = null;
        try {
            Date serverDate = this.serverFormat.parse(date);
            converted = this.patchFormat.format(serverDate);
        }
        catch (ParseException e) {
            converted = null;
        }
        return converted;
    }

    private String replaceDate(String line, int dateIndex) {
        String date = line.substring(dateIndex);
        String converted = this.convertDate(date);
        if (converted != null) {
            return line.replace(date, converted);
        }
        return line;
    }

    private void printDelete(IP4File file, PrintWriter writer) throws CoreException, IOException {
        IFile local = file.getLocalFileForLocation();
        if (local != null) {
            String relative = this.getRelative(local);
            this.printIndex(relative, writer);
            this.printRevision(file, writer);
            writer.println("--- " + relative + "\t" + this.getModDate(local));
            writer.println("+++ /dev/null\t1970/01/01 00:00:00");
            int lines = 0;
            BufferedReader reader = new BufferedReader(new InputStreamReader(file.getHaveContents(), ConnectionParameters.getJavaCharset((IP4Resource)file)));
            try {
                String line = reader.readLine();
                while (line != null) {
                    ++lines;
                    line = reader.readLine();
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            String end = lines > 1 ? "," + lines : "";
            writer.println("@@ -1" + end + " +0,0" + " " + LINE_RANGE);
            reader = new BufferedReader(new InputStreamReader(file.getHaveContents(), ConnectionParameters.getJavaCharset((IP4Resource)file)));
            try {
                String line = reader.readLine();
                while (line != null) {
                    writer.print('-');
                    writer.println(line);
                    line = reader.readLine();
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void logCommand(String path) {
        P4Workspace.getWorkspace().getCallback().issuingServerCommand(-1, "diff -du -t " + path);
    }

    private void collectorErrorOutput(InputStream stream, IErrorCollector collector) {
        StringBuilder errorBuffer;
        block13: {
            errorBuffer = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, CharsetDefs.DEFAULT));
            try {
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        errorBuffer.append(line).append('\n');
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (errorBuffer.length() > 0) {
            collector.collect(new PatchException(errorBuffer.toString()));
        }
    }

    /*
     * Loose catch block
     */
    private void generateDiffs(List<IP4File> resources, PrintWriter writer, IProgressMonitor monitor, IErrorCollector errorCollector) {
        block19: {
            IP4Connection connection;
            if (!resources.isEmpty() && !(connection = resources.get(0).getConnection()).isOffline()) {
                monitor.subTask(Messages.P4Patch_AddingPerforceMetadata);
                this.printDetails(connection, writer);
                PatchDiffRunner runner = null;
                try {
                    try {
                        ArrayList<IP4File> edits = new ArrayList<IP4File>();
                        for (IP4File file : resources) {
                            if (file.openedForAdd()) {
                                monitor.subTask(file.getActionPath(IP4Resource.Type.REMOTE));
                                this.printAdd(file, writer);
                                monitor.worked(1);
                                continue;
                            }
                            if (file.openedForDelete()) {
                                monitor.subTask(file.getActionPath(IP4Resource.Type.REMOTE));
                                this.printDelete(file, writer);
                                monitor.worked(1);
                                continue;
                            }
                            if (!file.openedForEdit()) continue;
                            edits.add(file);
                        }
                        runner = new PatchDiffRunner(connection);
                        for (IP4File file : edits) {
                            String actionPath = file.getActionPath(IP4Resource.Type.REMOTE);
                            if (actionPath != null) {
                                monitor.subTask(actionPath);
                                this.logCommand(actionPath);
                                Process process = runner.run(actionPath);
                                this.printEdit(process.getInputStream(), writer, connection, file);
                                this.collectorErrorOutput(process.getErrorStream(), errorCollector);
                                process.waitFor();
                            }
                            monitor.worked(1);
                        }
                    }
                    catch (IOException e) {
                        errorCollector.collect(e);
                        PerforceProviderPlugin.logError((Throwable)e);
                        if (runner != null) {
                            runner.dispose();
                        }
                    }
                    catch (CoreException e) {
                        errorCollector.collect(e);
                        PerforceProviderPlugin.logError((Throwable)e);
                        if (runner != null) {
                            runner.dispose();
                        }
                    }
                    catch (InterruptedException e) {
                        errorCollector.collect(e);
                        PerforceProviderPlugin.logError((Throwable)e);
                        if (runner != null) {
                            runner.dispose();
                        }
                        break block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
                finally {
                    if (runner != null) {
                        runner.dispose();
                    }
                }
            }
        }
    }

    private Map<IProject, List<IP4File>> generateProjectGroups(IP4File[] files) {
        HashMap<IProject, List<IP4File>> projects = new HashMap<IProject, List<IP4File>>();
        IP4File[] iP4FileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IP4File resource = iP4FileArray[n2];
            IFile file = resource.getLocalFileForLocation();
            this.addResource((IResource)file, resource, projects);
            ++n2;
        }
        return projects;
    }

    private IP4File[] getAllFiles() {
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        IP4File file = null;
        Object[] objectArray = this.resources;
        int n = this.resources.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            IP4File[] iP4FileArray;
            Object resource = objectArray[n2];
            if (resource instanceof IResource) {
                resource = P4ConnectionManager.getManager().getResource((IResource)resource);
            }
            if (resource instanceof IP4Folder) {
                IP4Folder folder = (IP4Folder)resource;
                iP4FileArray = folder.getAllLocalFiles();
                n4 = iP4FileArray.length;
                n3 = 0;
                while (n3 < n4) {
                    IP4File localFile = iP4FileArray[n3];
                    files.add(localFile);
                    ++n3;
                }
            } else if (resource instanceof IP4PendingChangelist) {
                IP4PendingChangelist list = (IP4PendingChangelist)resource;
                iP4FileArray = list.getFiles();
                n4 = iP4FileArray.length;
                n3 = 0;
                while (n3 < n4) {
                    IP4File member = iP4FileArray[n3];
                    file = (IP4File)P4CoreUtils.convert((Object)member, IP4File.class);
                    if (file != null) {
                        files.add(file);
                    }
                    ++n3;
                }
            } else {
                file = (IP4File)P4CoreUtils.convert((Object)resource, IP4File.class);
                if (file != null) {
                    files.add(file);
                }
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    protected WorkspaceModifyOperation createOperation(final IErrorCollector collector) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                monitor.beginTask("", 2);
                SubProgressMonitor refreshMonitor = new SubProgressMonitor(monitor, 1);
                refreshMonitor.beginTask("", 1);
                refreshMonitor.subTask(Messages.P4Patch_RefreshingFiles);
                IP4File[] files = P4Patch.this.getAllFiles();
                if (refreshMonitor.isCanceled()) {
                    return;
                }
                refreshMonitor.done();
                Map groups = P4Patch.this.generateProjectGroups(files);
                SubProgressMonitor patchMonitor = new SubProgressMonitor(monitor, 1);
                patchMonitor.beginTask("", files.length);
                PrintWriter writer = null;
                try {
                    P4Patch.this.stream.initialize((IProgressMonitor)patchMonitor);
                    if (patchMonitor.isCanceled()) {
                        return;
                    }
                    try {
                        writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(P4Patch.this.stream.getStream(), P4Patch.this.stream.getCharset())), true);
                        writer.println(WorkspacePatcherUI.getWorkspacePatchHeader());
                        writer.println("### Generated using the 'p4 diff -du' command");
                        for (Map.Entry entry : groups.entrySet()) {
                            IProject project = (IProject)entry.getKey();
                            monitor.subTask(project.getName());
                            writer.println(WorkspacePatcherUI.getWorkspacePatchProjectHeader((IProject)project));
                            P4Patch.this.generateDiffs((List)entry.getValue(), writer, (IProgressMonitor)patchMonitor, collector);
                        }
                    }
                    catch (IOException e) {
                        collector.collect(e);
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                    try {
                        P4Patch.this.stream.finish((IProgressMonitor)patchMonitor);
                    }
                    catch (IOException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                    patchMonitor.done();
                    monitor.done();
                }
            }
        };
        return operation;
    }

    public void generate(IErrorCollector collector) {
        final IErrorCollector errorCollector = ErrorCollector.collectorFor(collector);
        final WorkspaceModifyOperation operation = this.createOperation(errorCollector);
        P4Runnable runnable = new P4Runnable(){

            public String getTitle() {
                return Messages.P4Patch_GeneratingPatch;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    try {
                        operation.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                        errorCollector.done();
                    }
                    catch (InterruptedException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                        errorCollector.done();
                    }
                }
                finally {
                    errorCollector.done();
                }
            }
        };
        if (this.async) {
            P4Runner.schedule((IP4Runnable)runnable);
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

