/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.model;

import com.perforce.p4java.CharsetDefs;
import com.perforce.team.ui.patch.model.FileStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileSystemStream
extends FileStream {
    private String path;
    private FileOutputStream stream;

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void initialize(IProgressMonitor monitor) throws IOException {
        if (this.path == null) {
            throw new IOException("Path not set");
        }
        File file = new File(this.path);
        this.validateFile(file, monitor);
        if (!monitor.isCanceled()) {
            this.stream = new FileOutputStream(file);
        }
    }

    @Override
    public OutputStream getStream() throws IOException {
        return this.stream;
    }

    @Override
    public void finish(IProgressMonitor monitor) throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    public Charset getCharset() {
        return CharsetDefs.LOCAL;
    }
}

