/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.patch.model;

import com.perforce.p4java.CharsetDefs;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.patch.model.IPatchStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClipboardStream
implements IPatchStream {
    private ByteArrayOutputStream stream = null;

    @Override
    public void initialize(IProgressMonitor monitor) {
        this.stream = new ByteArrayOutputStream();
    }

    @Override
    public OutputStream getStream() {
        return this.stream;
    }

    @Override
    public void finish(IProgressMonitor monitor) {
        if (this.stream != null) {
            try {
                final String clipboardContents = this.stream.toString(CharsetDefs.DEFAULT_NAME);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        P4UIUtils.copyToClipboard((String)clipboardContents);
                    }
                };
                if (PerforceUIPlugin.isUIThread()) {
                    runnable.run();
                } else {
                    PerforceUIPlugin.asyncExec((Runnable)runnable);
                }
            }
            catch (UnsupportedEncodingException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            this.stream = null;
        }
    }

    @Override
    public Charset getCharset() {
        return CharsetDefs.LOCAL;
    }
}

