/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.search.results.tree;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.search.results.P4SearchResult;
import com.perforce.team.ui.search.results.RevisionMatch;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class SearchTreeContentProvider
extends PerforceContentProvider {
    protected P4SearchResult results = null;
    protected Folder.Type type = Folder.Type.FLAT;

    public SearchTreeContentProvider(StructuredViewer viewer) {
        super(viewer);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.results = (P4SearchResult)((Object)newInput);
    }

    public Object[] getElements(Object inputElement) {
        if (this.results.getMatchCount() > 0) {
            switch (this.type) {
                default: {
                    return this.results.getFiles();
                }
                case TREE: {
                    return this.results.getFolders();
                }
                case COMPRESSED: 
            }
            return this.results.getCompressed();
        }
        return EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IP4File) {
            return this.results.getRevisions((IP4File)parentElement);
        }
        if (parentElement instanceof RevisionMatch) {
            return this.results.getMatches(parentElement);
        }
        return super.getChildren(parentElement);
    }

    public void setDisplayType(Folder.Type type) {
        if (type != null) {
            this.type = type;
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }
}

