/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.c.timelapse;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.c.timelapse.CUtils;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.NodeModel;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;

public class CNodeModel
extends NodeModel
implements IFilterNodeModel {
    private Map<String, String> methodList = new TreeMap<String, String>();

    public static String getCHandle(Object element) {
        return element instanceof ICElement ? CNodeModel.generateCHandle((ICElement)element) : null;
    }

    private static String generateCHandle(ICElement element) {
        String handle = element.getHandleIdentifier();
        if (handle != null) {
            int sourceElementDelimiter = handle.indexOf(91);
            while (sourceElementDelimiter != -1) {
                if (sourceElementDelimiter - 1 > 0 && handle.charAt(sourceElementDelimiter - 1) == '\\') {
                    sourceElementDelimiter = handle.indexOf(91, sourceElementDelimiter + 1);
                    continue;
                }
                handle = handle.substring(sourceElementDelimiter);
                break;
            }
        }
        return handle;
    }

    public CNodeModel(IP4Revision[] revisions, IRevisionInputCache inputCache) {
        super(revisions, inputCache);
    }

    public Collection<String> getFilterLabels() {
        return this.methodList.keySet();
    }

    public String getFilterKey(String filterLabel) {
        return this.methodList.get(filterLabel);
    }

    public void findNodes(Object nodeInput, IP4Revision revision) {
        this.walkTree((ICElement)nodeInput, revision);
    }

    private String getMethodDisplay(IFunctionDeclaration method) {
        try {
            return method.getSignature();
        }
        catch (CModelException e) {
            e.printStackTrace();
            return method.getElementName();
        }
    }

    public String getHandle(Object element) {
        return CNodeModel.getCHandle(element);
    }

    private void walkTree(ICElement node, IP4Revision revision) {
        try {
            IParent parent;
            ISourceReference reference;
            String content;
            String key = null;
            if (node instanceof IFunctionDeclaration) {
                IFunctionDeclaration method = (IFunctionDeclaration)node;
                key = CNodeModel.generateCHandle(node);
                String display = this.getMethodDisplay(method);
                this.methodList.put(display, key);
            }
            if (node instanceof ISourceReference && (content = (reference = (ISourceReference)node).getSource()) != null) {
                ASTAccessVisibility visibility;
                if (node instanceof IMember && (visibility = ((IMember)node).getVisibility()) != null) {
                    content = String.valueOf(visibility.toString()) + content;
                }
                int hash = this.computeHash(content, P4CoreUtils.charsetForName((String)PerforceCharsets.getJavaCharsetName((String)revision.getCharset())));
                String key2 = null;
                if (key == null) {
                    key = CNodeModel.generateCHandle(node);
                } else {
                    key2 = CNodeModel.generateCHandle(node);
                }
                this.addRecord(hash, key, key2, node, revision);
            }
            if (node instanceof IParent && (parent = (IParent)node).hasChildren()) {
                ICElement[] iCElementArray = parent.getChildren();
                int n = iCElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement child = iCElementArray[n2];
                    this.walkTree(child, revision);
                    ++n2;
                }
            }
        }
        catch (CModelException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }

    public ICElement getCElement(IP4Revision revision, String id) {
        return (ICElement)this.getElement(revision, id);
    }

    public Object parseInput(IEditorInput input, IP4Revision revision) {
        if (CUtils.getProvider().getDocument((Object)input) == null) {
            try {
                CUtils.getProvider().connect((Object)input);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return CUtils.getWorkingCopy(input);
    }
}

