/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.timelapse.ITickFormatter;
import com.perforce.team.ui.timelapse.ITickPositionHandler;
import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class NodeTickFormatter
implements ITickFormatter,
ITickPositionHandler {
    public static final RGB TICK_BG = new RGB(0, 128, 0);
    private INodeModel model;
    private INodeModel.ChangeType[] types;
    private INodeModel.ChangeType[] filteredTypes;
    private boolean enabled = false;
    private boolean filter = false;
    private Color color = null;
    private String currentId = null;

    public NodeTickFormatter(INodeModel model, Color color) {
        this.model = model;
        this.color = color;
    }

    public NodeTickFormatter(INodeModel model) {
        this(model, null);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getId() {
        return this.currentId;
    }

    public void setFilter(String id) {
        this.currentId = id;
        if (id != null) {
            this.enabled = true;
            this.types = this.model.getRecords(id);
            this.filteredTypes = this.filter(this.types);
        } else {
            this.enabled = false;
            this.types = null;
            this.filteredTypes = null;
        }
    }

    public Color format(IP4Revision revision, int tickNumber, PaintEvent event) {
        if (this.filteredTypes != null && this.color != null) {
            switch (this.filteredTypes[tickNumber]) {
                case ADD: 
                case DELETE: 
                case EDIT: {
                    return this.color;
                }
            }
            return event.display.getSystemColor(16);
        }
        return event.display.getSystemColor(16);
    }

    public int getNext(int position) {
        int next = -1;
        if (this.filteredTypes != null) {
            int i = position + 1;
            while (i < this.filteredTypes.length) {
                if (this.filteredTypes[i] != INodeModel.ChangeType.UNCHANGED) {
                    next = i;
                    break;
                }
                ++i;
            }
        }
        return next;
    }

    public int getPrevious(int position) {
        int previous = -1;
        if (this.filteredTypes != null) {
            int i = position - 1;
            while (i >= 0) {
                if (this.filteredTypes[i] != INodeModel.ChangeType.UNCHANGED) {
                    previous = i;
                    break;
                }
                --i;
            }
        }
        return previous;
    }

    public boolean hasNextPosition(int position) {
        return this.getNext(position) != -1;
    }

    public boolean hasPreviousPosition(int position) {
        return this.getPrevious(position) != -1;
    }

    public boolean contains(int position) {
        boolean contains = false;
        if (this.filteredTypes != null && position >= 0 && position < this.filteredTypes.length) {
            contains = this.filteredTypes[position] != INodeModel.ChangeType.UNCHANGED;
        }
        return contains;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled && this.filteredTypes != null;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public int getTickCount() {
        int count = -1;
        if (this.filteredTypes != null) {
            count = 0;
            INodeModel.ChangeType[] changeTypeArray = this.filteredTypes;
            int n = this.filteredTypes.length;
            int n2 = 0;
            while (n2 < n) {
                INodeModel.ChangeType type = changeTypeArray[n2];
                if (type != INodeModel.ChangeType.UNCHANGED) {
                    ++count;
                }
                ++n2;
            }
        }
        return count;
    }

    public void filter() {
        this.filteredTypes = this.filter(this.types);
    }

    private INodeModel.ChangeType[] filter(INodeModel.ChangeType[] types) {
        INodeModel.ChangeType[] newFiltered = null;
        if (this.filter) {
            if (types != null) {
                ArrayList<INodeModel.ChangeType> filtered = new ArrayList<INodeModel.ChangeType>();
                int i = 0;
                while (i < types.length) {
                    if (types[i] != INodeModel.ChangeType.UNCHANGED) {
                        filtered.add(types[i]);
                    }
                    ++i;
                }
                newFiltered = filtered.toArray(new INodeModel.ChangeType[filtered.size()]);
            }
        } else {
            newFiltered = types;
        }
        return newFiltered;
    }

    public IP4Revision[] filter(IP4Revision[] revisions) {
        if (this.filter && this.types != null && this.types.length == revisions.length) {
            ArrayList<IP4Revision> filtered = new ArrayList<IP4Revision>();
            ArrayList<INodeModel.ChangeType> filteredTypes = new ArrayList<INodeModel.ChangeType>();
            int i = 0;
            while (i < this.types.length) {
                if (this.types[i] != INodeModel.ChangeType.UNCHANGED) {
                    filtered.add(revisions[i]);
                    filteredTypes.add(this.types[i]);
                }
                ++i;
            }
            this.filteredTypes = filteredTypes.toArray(new INodeModel.ChangeType[filteredTypes.size()]);
            revisions = filtered.toArray(new IP4Revision[filtered.size()]);
        }
        return revisions;
    }

    public int getNewPosition() {
        int nonDelete = -1;
        if (this.filter && this.filteredTypes != null) {
            INodeModel.ChangeType curr = null;
            int position = this.filteredTypes.length - 1;
            while (position >= 0) {
                curr = this.filteredTypes[position];
                if (curr != INodeModel.ChangeType.DELETE && curr != INodeModel.ChangeType.UNCHANGED) {
                    nonDelete = position;
                    break;
                }
                --position;
            }
        }
        return nonDelete;
    }
}

