/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text;

import com.perforce.team.core.PerforceProviderPlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.osgi.framework.Bundle;

public class TextUtils {
    private static Method modelLineToWidgetLine;
    private static Method getHiddenTopLinePixels;
    private static Method getVisibleModelLines;
    private static Method isShowingEntireContents;

    static {
        Class jfaceTextUtil = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jface.text");
        if (bundle != null) {
            try {
                jfaceTextUtil = bundle.loadClass("org.eclipse.jface.text.JFaceTextUtil");
            }
            catch (Throwable throwable) {
                try {
                    jfaceTextUtil = bundle.loadClass("org.eclipse.jface.internal.text.JFaceTextUtil");
                }
                catch (Throwable throwable2) {}
            }
        }
        if (jfaceTextUtil != null) {
            try {
                modelLineToWidgetLine = jfaceTextUtil.getMethod("modelLineToWidgetLine", ITextViewer.class, Integer.TYPE);
            }
            catch (SecurityException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            try {
                getHiddenTopLinePixels = jfaceTextUtil.getMethod("getHiddenTopLinePixels", StyledText.class);
            }
            catch (SecurityException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            try {
                getVisibleModelLines = jfaceTextUtil.getMethod("getVisibleModelLines", ITextViewer.class);
            }
            catch (SecurityException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            try {
                isShowingEntireContents = jfaceTextUtil.getMethod("isShowingEntireContents", StyledText.class);
            }
            catch (SecurityException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    public static EditorsPlugin getEditorsPlugin() {
        return EditorsPlugin.getDefault();
    }

    public static int modelLineToWidgetLine(ITextViewer viewer, int modelLine) {
        int line = -1;
        if (modelLineToWidgetLine != null) {
            try {
                line = (Integer)modelLineToWidgetLine.invoke(null, viewer, modelLine);
            }
            catch (IllegalArgumentException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return line;
    }

    public static int getHiddenTopLinePixels(StyledText textWidget) {
        int line = -1;
        if (getHiddenTopLinePixels != null) {
            try {
                line = (Integer)getHiddenTopLinePixels.invoke(null, textWidget);
            }
            catch (IllegalArgumentException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return line;
    }

    public static ILineRange getVisibleModelLines(ITextViewer viewer) {
        ILineRange lineRange = null;
        if (getVisibleModelLines != null && viewer != null && viewer.getDocument() != null) {
            try {
                lineRange = (ILineRange)getVisibleModelLines.invoke(null, viewer);
            }
            catch (IllegalArgumentException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return lineRange;
    }

    public static boolean isShowingEntireContents(StyledText widget) {
        boolean showing = false;
        if (isShowingEntireContents != null) {
            try {
                showing = (Boolean)isShowingEntireContents.invoke(null, widget);
            }
            catch (IllegalArgumentException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return showing;
    }

    public static RGB getEditorRgb(String key) {
        return PreferenceConverter.getColor((IPreferenceStore)TextUtils.getEditorStore(), (String)key);
    }

    public static IPreferenceStore getEditorStore() {
        return TextUtils.getEditorsPlugin().getPreferenceStore();
    }

    public static Color getEditorColor(String key) {
        RGB rgb = TextUtils.getEditorRgb(key);
        return TextUtils.getSharedTextColors().getColor(rgb);
    }

    public static ISharedTextColors getSharedTextColors() {
        return TextUtils.getEditorsPlugin().getSharedTextColors();
    }
}

