/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn.job;

import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.mylyn.P4MylynUiUtils;
import com.perforce.team.ui.mylyn.job.IJobProxy;
import com.perforce.team.ui.mylyn.job.JobFieldEntry;
import com.perforce.team.ui.mylyn.job.Messages;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;

public class BulkJobUpdater {
    public static final String TIME_FORMAT = "hh:mm aaa";
    private IJobProxy[] updateJobs = null;
    private IJobSpec spec = null;
    private JobFieldEntry.FieldChange[] filters = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm aaa");

    public BulkJobUpdater(IJobProxy[] jobs, IJobSpec spec, JobFieldEntry.FieldChange[] filters) {
        this.updateJobs = jobs;
        this.spec = spec;
        this.filters = filters;
    }

    private Map<String, Object> fillMap(IP4Job job) {
        HashMap<String, Object> jobFields = new HashMap<String, Object>();
        String name = null;
        Object value = null;
        for (IJobSpec.IJobSpecField field : this.spec.getFields()) {
            name = field.getName();
            value = job.getField(name);
            if (value == null) {
                value = "";
            }
            jobFields.put(name, value);
        }
        return jobFields;
    }

    public String run(IProgressMonitor monitor, JobCallback callback) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        int total = this.updateJobs.length;
        monitor.beginTask("", total);
        int passCount = 0;
        int jobCount = 0;
        String base = Messages.BulkJobUpdater_UpdateJobWithLink;
        ArrayList<IP4Job> eventJobs = new ArrayList<IP4Job>();
        ArrayList<IJobProxy> eventTasks = new ArrayList<IJobProxy>();
        StringBuilder errors = new StringBuilder();
        try {
            IJobProxy[] iJobProxyArray = this.updateJobs;
            int n = this.updateJobs.length;
            int n2 = 0;
            while (n2 < n) {
                IJobProxy job = iJobProxyArray[n2];
                if (monitor.isCanceled()) break;
                monitor.setTaskName(MessageFormat.format(base, job.getId(), ++jobCount, total));
                IP4Job realJob = job.getConnection().getJob(job.getId());
                Map<String, Object> jobFields = this.fillMap(realJob);
                JobFieldEntry.FieldChange[] fieldChangeArray = this.filters;
                int n3 = this.filters.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object current;
                    JobFieldEntry.FieldChange filter = fieldChangeArray[n4];
                    String value = filter.value;
                    if (filter.type == JobFieldEntry.FieldChange.Type.APPEND) {
                        current = jobFields.get(filter.name);
                        if (current != null) {
                            value = String.valueOf(current.toString()) + value;
                        }
                    } else if (filter.type == JobFieldEntry.FieldChange.Type.PREPEND && (current = jobFields.get(filter.name)) != null) {
                        value = String.valueOf(value) + current.toString();
                    }
                    jobFields.put(filter.name, value);
                    ++n4;
                }
                try {
                    realJob.update((IJob)this.createJob(jobFields));
                    if (job.getConnection() != null) {
                        IP4Job updated = job.getConnection().getJob(job.getId());
                        if (updated != null) {
                            eventJobs.add(updated);
                            eventTasks.add(job);
                            if (callback != null) {
                                callback.updated(realJob, updated);
                            }
                        }
                        ++passCount;
                    }
                }
                catch (P4JavaException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    errors.append('\n');
                    errors.append(job.getId());
                    errors.append(':');
                    errors.append('\n');
                    errors.append(e.getLocalizedMessage());
                }
                monitor.worked(1);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            String viewErrors = "";
            if (errors.length() > 0) {
                viewErrors = Messages.BulkJobUpdater_ViewErrorsLink;
            }
            this.sendEvents(eventJobs, eventTasks);
            monitor.done();
            monitor.setTaskName(MessageFormat.format(Messages.BulkJobUpdater_UpdateFinished, passCount, this.updateJobs.length, this.updateJobs.length > 1 ? Messages.BulkJobUpdater_Jobs : Messages.BulkJobUpdater_Job, this.formatTime(), viewErrors));
            throw throwable;
        }
        String viewErrors = "";
        if (errors.length() > 0) {
            viewErrors = Messages.BulkJobUpdater_ViewErrorsLink;
        }
        this.sendEvents(eventJobs, eventTasks);
        monitor.done();
        monitor.setTaskName(MessageFormat.format(Messages.BulkJobUpdater_UpdateFinished, passCount, this.updateJobs.length, this.updateJobs.length > 1 ? Messages.BulkJobUpdater_Jobs : Messages.BulkJobUpdater_Job, this.formatTime(), viewErrors));
        return errors.toString().trim();
    }

    private void sendEvents(List<IP4Job> jobs, List<IJobProxy> proxies) {
        if (jobs.size() > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, jobs.toArray(new IP4Resource[jobs.size()])));
        }
        if (proxies.size() > 0) {
            HashSet<ITask> tasks = new HashSet<ITask>();
            for (IJobProxy proxy : proxies) {
                ITask task = (ITask)P4CoreUtils.convert((Object)proxy, ITask.class);
                if (task == null) continue;
                tasks.add(task);
            }
            if (tasks.size() > 0) {
                TasksUiInternal.synchronizeTasks((AbstractRepositoryConnector)P4MylynUiUtils.getPerforceConnector(), tasks, (boolean)false, null);
            }
        }
    }

    private String formatTime() {
        return this.dateFormat.format(new Date());
    }

    private Job createJob(Map<String, Object> fields) {
        return new Job(null, fields);
    }

    public static interface JobCallback {
        public void updated(IP4Job var1, IP4Job var2);
    }
}

