/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mylyn;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.mylyn.P4JobConnector;
import com.perforce.team.core.mylyn.P4MylynUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.mylyn.P4JobConnectorUi;
import com.perforce.team.ui.mylyn.PerforceUiMylynPlugin;
import java.util.ArrayList;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;

public final class P4MylynUiUtils {
    public static final String JOB_SEGMENT = "/job/";

    public static TaskRepository createTaskRepository(IP4Connection connection) {
        TaskRepository repository = null;
        if (connection != null) {
            repository = new TaskRepository("perforce", connection.getParameters().getPort());
            P4MylynUiUtils.setTaskSettings(connection, repository);
        }
        return repository;
    }

    public static void setTaskSettings(IP4Connection connection, TaskRepository repository) {
        if (repository != null && connection != null) {
            repository.setProperty("category", "org.eclipse.mylyn.category.tasks");
            ConnectionParameters params = connection.getParameters();
            if (params.getClient() != null) {
                repository.setProperty("P4_CLIENT", params.getClient());
            }
            if (params.getPort() != null) {
                repository.setProperty("P4_PORT", params.getPort());
            }
            if (params.getUser() != null) {
                repository.setProperty("P4_USER", params.getUser());
                repository.setCredentials(AuthenticationType.REPOSITORY, new AuthenticationCredentials(params.getUser(), ""), false);
            }
            if (params.getCharset() != null) {
                repository.setProperty("P4_CHARSET", params.getCharset());
                String javaCharset = PerforceCharsets.getJavaCharsetName((String)params.getCharset());
                if (javaCharset != null) {
                    repository.setCharacterEncoding(javaCharset);
                }
            }
        }
    }

    public static TaskRepository getRepository(IP4Connection connection) {
        TaskRepository repository = null;
        if (connection != null) {
            repository = P4MylynUiUtils.getRepository(connection.getParameters());
        }
        return repository;
    }

    public static TaskRepository getRepository(ConnectionParameters params) {
        return P4MylynUiUtils.getRepository(params, true);
    }

    public static TaskRepository getRepository(ConnectionParameters params, boolean checkPerforce) {
        TaskRepository repository = null;
        if (params != null) {
            String kind = P4MylynUiUtils.getConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_KIND.", params);
            String url = P4MylynUiUtils.getConnectionSetting("com.perforce.team.ui.mylyn.preferences.CONNECTION_LINK_URL.", params);
            if (kind != null && kind.length() > 0 && url != null && url.length() > 0) {
                repository = TasksUi.getRepositoryManager().getRepository(kind, url);
            }
            if (repository == null && checkPerforce) {
                repository = P4MylynUiUtils.findRepository(params, "perforce");
            }
        }
        return repository;
    }

    public static TaskRepository findRepository(IP4Connection connection, String connectorKind) {
        TaskRepository repository = null;
        if (connection != null) {
            repository = P4MylynUiUtils.findRepository(connection.getParameters(), connectorKind);
        }
        return repository;
    }

    public static TaskRepository findRepository(ConnectionParameters params, String connectorKind) {
        TaskRepository repository = null;
        if (params != null && connectorKind != null) {
            for (TaskRepository taskRepo : TasksUi.getRepositoryManager().getRepositories(connectorKind)) {
                IP4Connection taskConnection = P4MylynUtils.getConnection((TaskRepository)taskRepo);
                if (taskConnection == null || !params.equals((Object)taskConnection.getParameters())) continue;
                repository = taskRepo;
                break;
            }
        }
        return repository;
    }

    public static TaskRepository getRepository(TaskEditor editor) {
        TaskEditorInput input;
        TaskRepository repository = null;
        if (editor != null && (input = editor.getTaskEditorInput()) != null && (repository = TasksUiUtil.getOutgoingNewTaskRepository((ITask)input.getTask())) == null) {
            repository = input.getTaskRepository();
        }
        return repository;
    }

    public static IP4Connection getConnection(ITask task) {
        IP4Connection connection = null;
        if (task != null) {
            connection = P4MylynUiUtils.getConnection(task.getConnectorKind(), task.getRepositoryUrl());
        }
        return connection;
    }

    public static IP4Connection getConnection(TaskRepository repository) {
        IP4Connection connection = null;
        if (repository != null) {
            connection = P4MylynUiUtils.getConnection(repository.getConnectorKind(), repository.getRepositoryUrl());
        }
        return connection;
    }

    public static TaskRepository getRepository(ITask task) {
        TaskRepository repository = null;
        if (task != null) {
            repository = P4MylynUiUtils.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        }
        return repository;
    }

    public static TaskRepository getRepository(String repositoryKind, String repositoryUrl) {
        TaskRepository repo = null;
        if (repositoryKind != null && repositoryUrl != null) {
            repo = TasksUi.getRepositoryManager().getRepository(repositoryKind, repositoryUrl);
        }
        return repo;
    }

    public static IP4Connection getLinkedConnection(TaskRepository repository) {
        IP4Connection connection = null;
        if (repository != null) {
            TaskRepository linked = null;
            IP4Connection[] iP4ConnectionArray = P4ConnectionManager.getManager().getConnections();
            int n = iP4ConnectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Connection candidate = iP4ConnectionArray[n2];
                linked = P4MylynUiUtils.getRepository(candidate);
                if (repository.equals((Object)linked)) {
                    connection = candidate;
                    break;
                }
                ++n2;
            }
        }
        return connection;
    }

    public static IP4Connection getConnection(String repositoryKind, String repositoryUrl) {
        TaskRepository repository;
        IP4Connection connection = null;
        if (repositoryKind != null && repositoryUrl != null && (repository = TasksUi.getRepositoryManager().getRepository(repositoryKind, repositoryUrl)) != null && (connection = P4MylynUiUtils.getLinkedConnection(repository)) == null) {
            connection = P4MylynUtils.getConnection((TaskRepository)repository);
        }
        return connection;
    }

    public static ITask getTask(String repoUrl, String id) {
        return P4MylynUiUtils.getTaskList().getTaskByKey(repoUrl, id);
    }

    public static TaskList getTaskList() {
        return TasksUiPlugin.getTaskList();
    }

    public static boolean setConnectionSetting(String baseKey, String value, ConnectionParameters params) {
        boolean set = false;
        if (baseKey != null && value != null && params != null) {
            String port;
            if (!baseKey.endsWith(".")) {
                baseKey = String.valueOf(baseKey) + ".";
            }
            if ((port = params.getPort()) != null) {
                PerforceUiMylynPlugin.getDefault().getPreferenceStore().setValue(String.valueOf(baseKey) + port, value);
                set = true;
            }
        }
        return set;
    }

    public static boolean setConnectionSetting(String baseKey, String value, IP4Connection connection) {
        boolean set = false;
        if (connection != null) {
            set = P4MylynUiUtils.setConnectionSetting(baseKey, value, connection.getParameters());
        }
        return set;
    }

    public static String getConnectionSetting(String baseKey, ConnectionParameters params) {
        String value = null;
        if (baseKey != null && params != null) {
            String port;
            if (!baseKey.endsWith(".")) {
                baseKey = String.valueOf(baseKey) + ".";
            }
            if ((port = params.getPort()) != null) {
                value = PerforceUiMylynPlugin.getDefault().getPreferenceStore().getString(String.valueOf(baseKey) + port);
            }
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static String getConnectionSetting(String baseKey, IP4Connection connection) {
        String value = null;
        if (connection != null) {
            value = P4MylynUiUtils.getConnectionSetting(baseKey, connection.getParameters());
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static TaskRepository[] getNonPerforceRepositories() {
        ArrayList<TaskRepository> repos = new ArrayList<TaskRepository>();
        for (TaskRepository repo : TasksUi.getRepositoryManager().getAllRepositories()) {
            if ("perforce".equals(repo.getConnectorKind())) continue;
            repos.add(repo);
        }
        return repos.toArray(new TaskRepository[repos.size()]);
    }

    public static P4JobConnector getPerforceConnector() {
        return (P4JobConnector)TasksUi.getRepositoryConnector((String)"perforce");
    }

    public static P4JobConnectorUi getPerforceConnectorUi() {
        return (P4JobConnectorUi)TasksUi.getRepositoryConnectorUi((String)"perforce");
    }

    public static IP4File getJobSpecFile(ITask task) {
        IP4File file = null;
        IP4Connection connection = P4MylynUiUtils.getConnection(task);
        if (connection != null && !connection.isOffline()) {
            String jobPath;
            IP4File jobFile;
            P4Depot spec;
            if (connection.needsRefresh()) {
                connection.refresh();
            }
            if ((spec = connection.getSpecDepot()) != null && (jobFile = connection.getFile(jobPath = P4MylynUiUtils.getJobSpecPath(spec, task))) != null && jobFile.isRemote()) {
                file = jobFile;
            }
        }
        return file;
    }

    public static String getJobSpecPath(P4Depot specDepot, ITask task) {
        String jobSpecPath = null;
        String remote = specDepot.getRemotePath();
        if (remote != null) {
            String id;
            StringBuilder specPath = new StringBuilder(remote);
            specPath.append(JOB_SEGMENT);
            if (task != null && (id = task.getTaskKey()) != null) {
                specPath.append(id);
                String suffix = specDepot.getSuffix();
                if (suffix != null) {
                    specPath.append(suffix);
                }
                jobSpecPath = specPath.toString();
            }
        }
        return jobSpecPath;
    }
}

