/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor.input;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.editor.Messages;
import com.perforce.team.ui.folder.diff.editor.input.DiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IDiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import java.text.MessageFormat;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class FolderDiffInput
extends PlatformObject
implements IFolderDiffInput,
IPersistableElement {
    protected IP4Connection connection;
    private Set<ComparePair> paths = new TreeSet<ComparePair>();
    private String lastLeftFilter = "";
    private String lastRightFilter = "";
    private Set<String> depotPaths = new TreeSet<String>();
    private IDiffConfiguration leftConfig;
    private IDiffConfiguration rightConfig;
    private IDiffConfiguration headerConfig;

    public FolderDiffInput(IP4Connection connection) {
        this(connection, null, null, new DiffConfiguration(Messages.FolderDiffInput_HeaderTitle, PerforceUIPlugin.getDescriptor((String)"perforce/depot_folder.png")));
    }

    public FolderDiffInput(IP4Connection connection, IDiffConfiguration left, IDiffConfiguration right, IDiffConfiguration header) {
        this.connection = connection;
        if (left == null) {
            left = new DiffConfiguration();
        }
        if (right == null) {
            right = new DiffConfiguration();
        }
        if (header == null) {
            header = new DiffConfiguration();
        }
        this.leftConfig = left;
        this.rightConfig = right;
        this.headerConfig = header;
    }

    public void addPaths(String left, String right) {
        if (left != null && right != null) {
            this.paths.add(new ComparePair(left, right));
            if (this.paths.size() == 1) {
                if (this.getLeftConfiguration().getLabel(this.getLeftConfiguration()).length() == 0) {
                    this.getLeftConfiguration().setLabel(left);
                }
                if (this.getRightConfiguration().getLabel(this.getRightConfiguration()).length() == 0) {
                    this.getRightConfiguration().setLabel(right);
                }
            }
        }
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return PerforceUiFolderPlugin.getDescriptor("icons/folder_diff.png");
    }

    public String getName() {
        return Messages.FolderDiffInput_Name;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return MessageFormat.format(Messages.FolderDiffInput_Tooltip, this.leftConfig.getLabel(this.leftConfig), this.lastLeftFilter, this.rightConfig.getLabel(this.rightConfig), this.lastRightFilter);
    }

    public Object getAdapter(Class adapter) {
        if (IP4Connection.class == adapter || IP4Resource.class == adapter) {
            return this.connection;
        }
        return super.getAdapter(adapter);
    }

    protected void addPaths(String leftFilter, String rightFilter, FileDiffContainer container) {
        for (ComparePair pair : this.paths) {
            container.addMapping(pair.left, pair.right);
            container.add(this.connection.getDiffs(String.valueOf(pair.left) + leftFilter, String.valueOf(pair.right) + rightFilter), this.connection);
        }
    }

    @Override
    public FileDiffContainer generateDiffs(String leftFilter, String rightFilter, IProgressMonitor monitor) {
        FileDiffContainer container = new FileDiffContainer();
        if (leftFilter == null) {
            leftFilter = "";
        }
        if (rightFilter == null) {
            rightFilter = "";
        }
        this.lastLeftFilter = leftFilter;
        this.lastRightFilter = rightFilter;
        for (String depot : this.depotPaths) {
            container.addMapping(depot, depot);
        }
        this.addPaths(leftFilter, rightFilter, container);
        container.finish();
        return container;
    }

    @Override
    public IDiffConfiguration getLeftConfiguration() {
        return this.leftConfig;
    }

    @Override
    public IDiffConfiguration getRightConfiguration() {
        return this.rightConfig;
    }

    @Override
    public IDiffConfiguration getHeaderConfiguration() {
        return this.headerConfig;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FolderDiffInput) {
            FolderDiffInput other = (FolderDiffInput)obj;
            return this.lastLeftFilter.equals(other.lastLeftFilter) && this.lastRightFilter.equals(other.lastRightFilter) && this.paths.equals(other.paths);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 0;
        if (this.lastLeftFilter != null) {
            hash += this.lastLeftFilter.hashCode();
        }
        if (this.lastRightFilter != null) {
            hash += this.lastRightFilter.hashCode() * 31;
        }
        if (this.paths != null) {
            hash += this.paths.hashCode() * 11;
        }
        if (hash > 0) {
            return hash;
        }
        return super.hashCode();
    }

    protected void savePaths(IMemento memento) {
        for (ComparePair pair : this.paths) {
            IMemento pairMemento = memento.createChild("pair");
            pairMemento.putString("left", pair.left);
            pairMemento.putString("right", pair.right);
        }
    }

    public void saveState(IMemento memento) {
        memento.putString("connection", this.connection.getParameters().toString());
        this.savePaths(memento);
        IMemento optionsMemento = memento.createChild("leftOptions");
        this.leftConfig.getOptions().saveState(optionsMemento);
        optionsMemento = memento.createChild("rightOptions");
        this.rightConfig.getOptions().saveState(optionsMemento);
    }

    public String getFactoryId() {
        return "com.perforce.team.ui.folder.diff.editor.FolderDiffInputFactory";
    }

    @Override
    public void refreshInput(IProgressMonitor monitor) {
        IP4Resource[] iP4ResourceArray = this.connection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource depot = iP4ResourceArray[n2];
            this.depotPaths.add(depot.getActionPath(IP4Resource.Type.REMOTE));
            ++n2;
        }
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }

    private static class ComparePair
    implements Comparable<ComparePair> {
        String left;
        String right;

        public ComparePair(String left, String right) {
            Assert.isNotNull((Object)left, (String)"Left cannot be null");
            Assert.isNotNull((Object)right, (String)"Right cannot be null");
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ComparePair) {
                ComparePair pair2 = (ComparePair)other;
                return this.left.equals(pair2.left) && this.right.equals(pair2.right);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.left) + " " + this.right;
        }

        @Override
        public int compareTo(ComparePair o) {
            return this.toString().compareToIgnoreCase(o.toString());
        }
    }
}

