/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor.input;

import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.core.BranchSpecSummary;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Branch;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.folder.PerforceUiFolderPlugin;
import com.perforce.team.ui.folder.diff.editor.Messages;
import com.perforce.team.ui.folder.diff.editor.input.DiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IDiffConfiguration;
import com.perforce.team.ui.folder.diff.editor.input.IFolderDiffInput;
import com.perforce.team.ui.folder.diff.model.FileDiffContainer;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class BranchDiffInput
extends PlatformObject
implements IFolderDiffInput,
IPersistableElement {
    private String branch;
    private IP4Branch fetchedBranch;
    private IP4Connection connection;
    private IDiffConfiguration leftConfig;
    private IDiffConfiguration rightConfig;
    private IDiffConfiguration headerConfig;

    public BranchDiffInput(String branch, IP4Connection connection, IDiffConfiguration header, IDiffConfiguration left, IDiffConfiguration right) {
        Assert.isNotNull((Object)branch, (String)"Branch cannot be null");
        Assert.isNotNull((Object)branch, (String)"Connection cannot be null");
        this.branch = branch;
        this.connection = connection;
        this.headerConfig = header;
        this.leftConfig = left;
        this.rightConfig = right;
        if (this.headerConfig == null) {
            this.headerConfig = new DiffConfiguration(MessageFormat.format(Messages.BranchDiffInput_Comparing, this.branch), PerforceUIPlugin.getDescriptor((String)"normal/branch.png"));
        }
        if (this.leftConfig == null) {
            this.leftConfig = new DiffConfiguration(Messages.BranchDiffInput_Source);
        }
        if (this.rightConfig == null) {
            this.rightConfig = new DiffConfiguration(Messages.BranchDiffInput_Target);
        }
    }

    public BranchDiffInput(String branch, IP4Connection connection) {
        this(branch, connection, null, null, null);
    }

    @Override
    public FileDiffContainer generateDiffs(String leftFilter, String rightFilter, IProgressMonitor monitor) {
        FileDiffContainer container = new FileDiffContainer();
        if (leftFilter != null && rightFilter != null) {
            leftFilter = "//..." + leftFilter;
            rightFilter = "//..." + rightFilter;
        } else if (leftFilter != null) {
            leftFilter = "//..." + leftFilter;
            rightFilter = "//...";
        } else if (rightFilter != null) {
            leftFilter = "//...";
            rightFilter = "//..." + rightFilter;
        }
        IP4Branch p4Branch = this.fetchBranch();
        ViewMap view = p4Branch.getView();
        if (view != null) {
            for (IBranchMapping mapping : view) {
                if (IMapEntry.EntryType.INCLUDE != mapping.getType()) continue;
                container.addMapping(mapping.getLeft(), mapping.getRight());
            }
        }
        container.add(p4Branch.getDiffs(leftFilter, rightFilter), this.connection);
        container.finish();
        return container;
    }

    private IP4Branch createBranch() {
        BranchSpecSummary summary = new BranchSpecSummary();
        summary.setName(this.getName());
        return new P4Branch(this.connection, (IBranchSpecSummary)summary, false);
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return PerforceUiFolderPlugin.getDescriptor("icons/folder_diff.png");
    }

    public String getName() {
        return this.branch;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return MessageFormat.format(Messages.BranchDiffInput_Comparing, this.branch);
    }

    public Object getAdapter(Class adapter) {
        if (IP4Connection.class == adapter || IP4Resource.class == adapter) {
            return this.connection;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IDiffConfiguration getLeftConfiguration() {
        return this.leftConfig;
    }

    @Override
    public IDiffConfiguration getRightConfiguration() {
        return this.rightConfig;
    }

    @Override
    public IDiffConfiguration getHeaderConfiguration() {
        return this.headerConfig;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BranchDiffInput) {
            return this.branch.equals(((BranchDiffInput)obj).branch) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.branch != null) {
            return this.branch.hashCode();
        }
        return super.hashCode();
    }

    public void saveState(IMemento memento) {
        memento.putString("connection", this.connection.getParameters().toString());
        memento.putString("branchName", this.branch);
        IMemento optionsMemento = memento.createChild("leftOptions");
        this.leftConfig.getOptions().saveState(optionsMemento);
        optionsMemento = memento.createChild("rightOptions");
        this.rightConfig.getOptions().saveState(optionsMemento);
    }

    public String getFactoryId() {
        return "com.perforce.team.ui.folder.diff.editor.BranchDiffInputFactory";
    }

    private IP4Branch fetchBranch() {
        if (this.fetchedBranch == null) {
            IP4Branch branch = this.createBranch();
            branch.markForRefresh();
            branch.refresh();
            this.fetchedBranch = branch;
        }
        return this.fetchedBranch;
    }

    @Override
    public void refreshInput(IProgressMonitor monitor) {
        monitor.subTask(String.valueOf(Messages.BranchDiffInput_Refreshing) + this.branch);
        IP4Branch branch = this.fetchBranch();
        ViewMap view = branch.getView();
        if (view != null) {
            ArrayList<String> sources = new ArrayList<String>();
            ArrayList<String> targets = new ArrayList<String>();
            for (IBranchMapping mapping : view) {
                if (IMapEntry.EntryType.EXCLUDE == mapping.getType()) continue;
                sources.add(mapping.getLeft());
                targets.add(mapping.getRight());
            }
            this.leftConfig.setLabel(P4CoreUtils.getCommonPath(sources));
            this.rightConfig.setLabel(P4CoreUtils.getCommonPath(targets));
        }
    }

    @Override
    public IP4Connection getConnection() {
        return this.connection;
    }
}

