/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.folder.diff.editor;

import com.perforce.team.core.folder.IP4DiffFile;
import com.perforce.team.ui.folder.diff.model.GroupedDiffContainer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CompressFilter
extends ViewerFilter {
    private ViewerFilter[] fileFilters = new ViewerFilter[0];

    public void setFileFilters(ViewerFilter[] filters) {
        this.fileFilters = filters != null ? filters : new ViewerFilter[0];
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof GroupedDiffContainer.GroupFolder && this.fileFilters.length > 0) {
            return this.hasUnfilteredChidlren(viewer, (GroupedDiffContainer.GroupFolder)((Object)element));
        }
        return true;
    }

    private boolean fileDisplayed(Viewer viewer, Object file, Object parent) {
        ViewerFilter[] viewerFilterArray = this.fileFilters;
        int n = this.fileFilters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!filter.select(viewer, parent, file)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean hasUnfilteredChidlren(Viewer viewer, GroupedDiffContainer.GroupFolder element) {
        if (element.containsFolders() || element.containsFiles()) {
            Object[] objectArray = element.getChildren((Object)element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof IP4DiffFile && this.fileDisplayed(viewer, child, (Object)element)) {
                    return true;
                }
                if (child instanceof GroupedDiffContainer.GroupFolder && this.hasUnfilteredChidlren(viewer, (GroupedDiffContainer.GroupFolder)((Object)child))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

