/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.mapping.branch;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.ui.editor.BaseCompletionProposal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class BranchCompletionProposal
extends BaseCompletionProposal {
    private IP4Branch branch;
    private Runnable applyCallback;
    private SimpleDateFormat pattern;

    public BranchCompletionProposal(IP4Branch branch, int replacementOffset, int replacementLength, int cursorPosition, Image image, Runnable callback) {
        this(branch, replacementOffset, replacementLength, cursorPosition, image);
        this.applyCallback = callback;
        this.pattern = new SimpleDateFormat("MM/dd/yyyy");
    }

    public BranchCompletionProposal(IP4Branch branch, int replacementOffset, int replacementLength, int cursorPosition, Image image) {
        super(branch.getName(), replacementOffset, replacementLength, cursorPosition, image, branch.getName());
        this.branch = branch;
    }

    public void apply(IDocument document) {
        super.apply(document);
        if (this.applyCallback != null) {
            this.applyCallback.run();
        }
    }

    public StyledString getStyledDisplayString() {
        Date access;
        StyledString display = new StyledString(this.branch.getName());
        String owner = this.branch.getOwner();
        if (owner != null) {
            display.append(": ", StyledString.QUALIFIER_STYLER);
            display.append(owner, StyledString.QUALIFIER_STYLER);
        }
        if ((access = this.branch.getAccessTime()) != null) {
            display.append(' ');
            display.append(this.pattern.format(access), StyledString.QUALIFIER_STYLER);
        }
        return display;
    }
}

