/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.branch;

import com.perforce.team.core.mergequest.P4BranchGraphCorePlugin;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.branch.BranchNameArea;
import com.perforce.team.ui.mergequest.wizards.branch.BranchWizardPage;
import com.perforce.team.ui.mergequest.wizards.branch.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class EditBranchWizard
extends Wizard
implements INewWizard {
    private IBranchGraph graph;
    private BranchDescriptor createdBranch = new BranchDescriptor();
    private Branch initialBranch = null;
    private BranchWizardPage branchPage;

    public EditBranchWizard(IBranchGraph graph, Branch branch) {
        this.graph = graph;
        this.initialBranch = branch;
    }

    public void addPages() {
        BranchDescriptor initial = new BranchDescriptor();
        initial.setName(this.initialBranch.getName());
        initial.setType(P4BranchGraphCorePlugin.getDefault().getBranchRegistry().getType(this.initialBranch.getType()));
        this.branchPage = new BranchWizardPage("branchPage", this.graph, initial){

            @Override
            protected BranchNameArea createNameArea(Composite parent, SharedResources resources, IBranchGraph graph, IErrorProvider provider) {
                BranchNameArea area = super.createNameArea(parent, resources, graph, provider);
                area.setSyncTypes(false);
                area.setEditable(true);
                area.selectAll();
                return area;
            }
        };
        this.addPage((IWizardPage)this.branchPage);
        this.branchPage.setTitle(Messages.EditBranchWizard_EditBranchTitle);
        this.branchPage.setMessage(Messages.EditBranchWizard_EditBranchDescription);
        this.branchPage.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/wizard/branchWizard.png"));
    }

    public boolean performFinish() {
        this.createdBranch = this.branchPage.getCreatedBranch();
        return true;
    }

    public BranchDescriptor getDescriptor() {
        return this.createdBranch;
    }

    public IAction[] getPostFinishActions() {
        return new IAction[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

