/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.views.tasks;

import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.processor.InterchangesProcessor;
import com.perforce.team.core.p4java.IP4ConnectionProvider;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.editor.BranchGraphToolkit;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.views.tasks.IIntegrateTaskContainer;
import com.perforce.team.ui.mergequest.views.tasks.Messages;
import com.perforce.team.ui.mergequest.views.tasks.TaskContainer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class IntegrateTaskViewer
implements PropertyChangeListener {
    public static final String MODE_SETTING = "MODE_SETTING";
    private IManagedForm form;
    private Composite parent;
    private TaskContainer sourceContainer;
    private TaskContainer targetContainer;
    private SharedResources resources;
    private ImageDescriptor flatImageDescriptor;
    private ImageDescriptor groupImageDescriptor;
    private ImageDescriptor dateImageDescriptor;
    private ImageDescriptor taskImageDescriptor;
    private Action refreshAction;
    private IP4ConnectionProvider provider;
    private InterchangesProcessor processor;
    private Mapping mapping;
    private IIntegrateTaskContainer.Mode mode;
    private WorkbenchLabelProvider labelProvider;

    public static String formatDate(Date date) {
        return DateFormat.getTimeInstance(0).format(date);
    }

    public IntegrateTaskViewer(IP4ConnectionProvider provider, InterchangesProcessor processor) {
        this.provider = provider;
        this.processor = processor;
        this.mode = this.getDefaultMode();
    }

    private IIntegrateTaskContainer.Mode getDefaultMode() {
        IIntegrateTaskContainer.Mode mode = null;
        String value = P4BranchGraphPlugin.getDefault().getPreferenceStore().getString(MODE_SETTING);
        try {
            mode = IIntegrateTaskContainer.Mode.valueOf(value);
        }
        catch (Exception exception) {
            mode = IIntegrateTaskContainer.Mode.FLAT;
        }
        return mode;
    }

    public void createControl(Composite parent) {
        this.labelProvider = new WorkbenchLabelProvider();
        final BranchGraphToolkit toolkit = new BranchGraphToolkit(P4UIUtils.getDisplay());
        this.form = new ManagedForm((FormToolkit)toolkit, toolkit.createScrolledForm(parent));
        ScrolledForm formControl = this.form.getForm();
        formControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        this.updateTitle();
        formControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parent = parent = formControl.getBody();
        this.resources = new SharedResources();
        this.parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IntegrateTaskViewer.this.resources.dispose();
            }
        });
        this.flatImageDescriptor = PerforceUIPlugin.getDescriptor((String)"normal/flat_layout.png");
        this.groupImageDescriptor = P4BranchGraphPlugin.getImageDescriptor("icons/user_group.png");
        this.dateImageDescriptor = PerforceUIPlugin.getDescriptor((String)"normal/dates.png");
        this.taskImageDescriptor = PerforceUIPlugin.getDescriptor((String)"perforce/job.png");
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (IntegrateTaskViewer.this.labelProvider != null) {
                    IntegrateTaskViewer.this.labelProvider.dispose();
                }
            }
        });
        GridLayout daLayout = new GridLayout(2, true);
        parent.setLayout((Layout)daLayout);
        Text description = new Text(parent, 72);
        description.setText(Messages.IntegrateTaskViewer_Description);
        toolkit.adapt((Control)description, false, false);
        description.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(2, 1).create());
        this.targetContainer = new TaskContainer(this.provider);
        this.targetContainer.createControl(toolkit, parent);
        this.sourceContainer = new TaskContainer(this.provider, true);
        this.sourceContainer.createControl(toolkit, parent);
        toolkit.decorateFormHeading(this.form.getForm().getForm());
        this.createViewerToolbar(this.form.getForm().getForm().getToolBarManager());
    }

    private void createViewerToolbar(IToolBarManager manager) {
        this.refreshAction = new Action(Messages.IntegrateTaskViewer_RefreshTasks, PerforceUIPlugin.getDescriptor((String)"normal/refresh.png")){

            public void run() {
                IntegrateTaskViewer.this.refresh(true);
            }
        };
        manager.add((IAction)this.refreshAction);
        ContributionItem item = new ContributionItem(){

            public void fill(final ToolBar parent, int index) {
                final ToolItem item = new ToolItem(parent, 4);
                IntegrateTaskViewer.this.changeMode(item, IntegrateTaskViewer.this.mode);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IntegrateTaskViewer.this.createListModeMenu(parent, item);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }
        };
        manager.add((IContributionItem)item);
        manager.update(true);
    }

    private void changeMode(ToolItem item, IIntegrateTaskContainer.Mode mode) {
        this.mode = mode;
        P4BranchGraphPlugin.getDefault().getPreferenceStore().setValue(MODE_SETTING, this.mode.toString());
        switch (this.mode) {
            case FLAT: {
                item.setImage(this.resources.getImage(this.flatImageDescriptor));
                item.setToolTipText(Messages.IntegrateTaskViewer_FlatMode);
                break;
            }
            case USER: {
                item.setImage(this.resources.getImage(this.groupImageDescriptor));
                item.setToolTipText(Messages.IntegrateTaskViewer_UserMode);
                break;
            }
            case DATE: {
                item.setImage(this.resources.getImage(this.dateImageDescriptor));
                item.setToolTipText(Messages.IntegrateTaskViewer_DateMode);
                break;
            }
            case TASK: {
                item.setImage(this.resources.getImage(this.taskImageDescriptor));
                item.setToolTipText(Messages.IntegrateTaskViewer_TaskMode);
                break;
            }
        }
        this.sourceContainer.setMode(this.mode);
        this.targetContainer.setMode(this.mode);
    }

    private void createListModeMenu(ToolBar toolbar, final ToolItem item) {
        Menu menu = new Menu((Control)toolbar);
        MenuItem listItem = new MenuItem(menu, 32);
        listItem.setText(Messages.IntegrateTaskViewer_ListMode);
        listItem.setImage(this.resources.getImage(this.flatImageDescriptor));
        listItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateTaskViewer.this.changeMode(item, IIntegrateTaskContainer.Mode.FLAT);
            }
        });
        MenuItem userItem = new MenuItem(menu, 32);
        userItem.setText(Messages.IntegrateTaskViewer_UserMode);
        userItem.setImage(this.resources.getImage(this.groupImageDescriptor));
        userItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateTaskViewer.this.changeMode(item, IIntegrateTaskContainer.Mode.USER);
            }
        });
        MenuItem dateItem = new MenuItem(menu, 32);
        dateItem.setText(Messages.IntegrateTaskViewer_DateMode);
        dateItem.setImage(this.resources.getImage(this.dateImageDescriptor));
        dateItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateTaskViewer.this.changeMode(item, IIntegrateTaskContainer.Mode.DATE);
            }
        });
        MenuItem taskItem = new MenuItem(menu, 32);
        taskItem.setText(Messages.IntegrateTaskViewer_TaskMode);
        taskItem.setImage(this.resources.getImage(this.taskImageDescriptor));
        taskItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IntegrateTaskViewer.this.changeMode(item, IIntegrateTaskContainer.Mode.TASK);
            }
        });
        switch (this.mode) {
            case USER: {
                userItem.setSelection(true);
                break;
            }
            case DATE: {
                dateItem.setSelection(true);
                break;
            }
            case TASK: {
                taskItem.setSelection(true);
                break;
            }
            default: {
                listItem.setSelection(true);
            }
        }
        Rectangle bounds = item.getBounds();
        Point location = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    public TreeViewer getSourceViewer() {
        return this.sourceContainer.getViewer();
    }

    public TreeViewer getTargetViewer() {
        return this.targetContainer.getViewer();
    }

    private boolean forceMappingRefresh(Mapping mapping) {
        if (this.processor == null) {
            return false;
        }
        return mapping.hasSourceChanges() && this.processor.getSourceInterchanges(mapping) == null || mapping.hasTargetChanges() && this.processor.getTargetInterchanges(mapping) == null;
    }

    private void loadMapping(final Mapping mapping, boolean force) {
        if (!force) {
            force = this.forceMappingRefresh(mapping);
        }
        if (force) {
            this.sourceContainer.showLoading();
            this.targetContainer.showLoading();
            Mapping[] mappings = new Mapping[]{mapping};
            if (this.processor != null) {
                this.processor.refresh(mappings);
                this.processor.refreshInterchanges(mappings, new Runnable(){

                    @Override
                    public void run() {
                        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (mapping.equals((Object)IntegrateTaskViewer.this.mapping) && P4UIUtils.okToUse((Widget)IntegrateTaskViewer.this.parent) && IntegrateTaskViewer.this.processor != null) {
                                    IntegrateTaskViewer.this.updateDate(IntegrateTaskViewer.this.processor.getLastRefreshDate(mapping));
                                    IntegrateTaskViewer.this.showMappings(IntegrateTaskViewer.this.processor.getSourceInterchanges(mapping), IntegrateTaskViewer.this.processor.getTargetInterchanges(mapping));
                                }
                            }
                        });
                    }
                });
            }
        } else if (this.processor != null) {
            this.updateDate(this.processor.getLastRefreshDate(mapping));
            this.showMappings(this.processor.getSourceInterchanges(mapping), this.processor.getTargetInterchanges(mapping));
        }
    }

    private void updateDate(Date date) {
        String dateText = "";
        if (date != null) {
            dateText = IntegrateTaskViewer.formatDate(date);
        }
        this.refreshAction.setToolTipText(MessageFormat.format(Messages.IntegrateTaskViewer_RefreshTasksTooltip, dateText));
    }

    private void showMappings(IP4SubmittedChangelist[] sourceLists, IP4SubmittedChangelist[] targetLists) {
        this.sourceContainer.setInput(this.mapping, sourceLists);
        this.targetContainer.setInput(this.mapping, targetLists);
        this.form.reflow(true);
    }

    private void refresh(boolean force) {
        Mapping.Direction direction = this.mapping.getDirection();
        ((GridLayout)this.parent.getLayout()).numColumns = direction == Mapping.Direction.BOTH ? 2 : 1;
        this.sourceContainer.show(direction == Mapping.Direction.BOTH || direction == Mapping.Direction.SOURCE);
        this.targetContainer.show(direction == Mapping.Direction.BOTH || direction == Mapping.Direction.TARGET);
        this.form.getForm().setImage(this.labelProvider.getImage((Object)this.mapping));
        this.updateTitle();
        this.loadMapping(this.mapping, force);
    }

    private void updateTitle() {
        if (this.mapping != null) {
            this.form.getForm().setText(this.mapping.getName());
        } else {
            this.form.getForm().setText(Messages.IntegrateTaskViewer_NoMappingSelected);
        }
    }

    public void setInput(Mapping mapping) {
        if (this.mapping != null && this.mapping.equals((Object)mapping)) {
            return;
        }
        this.sourceContainer.setInput(mapping, null);
        this.targetContainer.setInput(mapping, null);
        if (this.mapping != null) {
            this.mapping.removePropertyListener((PropertyChangeListener)this);
        }
        if (mapping != null) {
            this.mapping = mapping;
            this.mapping.addPropertyListener((PropertyChangeListener)this);
            this.refresh(false);
        } else {
            this.mapping = null;
            ((GridLayout)this.parent.getLayout()).numColumns = 2;
            this.sourceContainer.show(true);
            this.form.getForm().setImage(null);
            this.updateTitle();
        }
        this.form.reflow(true);
    }

    private boolean refreshTasks(String changedProperty) {
        if (changedProperty == null) {
            return false;
        }
        return "sourceChangeType".equals(changedProperty) || "targetChangeType".equals(changedProperty) || "connected".equals(changedProperty) || "name".equals(changedProperty);
    }

    private boolean forceRefresh(String changedProperty) {
        if (changedProperty == null) {
            return false;
        }
        return "latestSourceChange".equals(changedProperty) || "latestTargetChange".equals(changedProperty) || "direction".equals(changedProperty) || "sourcePath".equals(changedProperty) || "targetPath".equals(changedProperty) || this.mapping instanceof BranchSpecMapping && "name".equals(changedProperty);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean refresh;
        final boolean force = this.forceRefresh(evt.getPropertyName());
        boolean bl = refresh = force || this.refreshTasks(evt.getPropertyName());
        if (refresh) {
            PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    IntegrateTaskViewer.this.refresh(force);
                }
            });
        }
    }

    public void dispose() {
        if (this.mapping != null) {
            this.mapping.removePropertyListener((PropertyChangeListener)this);
        }
    }
}

