/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.views.tasks;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.changelists.ChangelistDecorator;
import com.perforce.team.ui.changelists.ChangelistLabelProvider;
import com.perforce.team.ui.changelists.StyledChangelistLabelProvider;
import com.perforce.team.ui.mergequest.views.tasks.IIntegrateTaskContainer;
import com.perforce.team.ui.mergequest.views.tasks.ITaskGroup;
import com.perforce.team.ui.mergequest.views.tasks.JobTaskGroup;
import com.perforce.team.ui.mergequest.views.tasks.Messages;
import com.perforce.team.ui.mergequest.views.tasks.UserTaskGroup;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class IntegrateTaskLabelProvider {
    private IIntegrateTaskContainer container;
    private Font bold;
    private ILabelProvider viewerLabelProvider = new ChangelistLabelProvider(true);
    private DelegatingStyledCellLabelProvider.IStyledLabelProvider styleProvider = new StyledChangelistLabelProvider(this.viewerLabelProvider){
        StyledString.Styler boldStyler;
        {
            this.boldStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = IntegrateTaskLabelProvider.this.bold;
                }
            };
        }

        private void addCount(StyledString styled, IWorkbenchAdapter adapter) {
            int count = adapter.getChildren((Object)adapter).length;
            String counter = MessageFormat.format(Messages.IntegrateTaskLabelProvider_Count, count);
            styled.append(counter, StyledString.COUNTER_STYLER);
        }

        public StyledString getStyledText(Object element) {
            StyledString styled = new StyledString();
            if (element instanceof UserTaskGroup && ((UserTaskGroup)element).isCurrentUser()) {
                styled.append(IntegrateTaskLabelProvider.this.viewerLabelProvider.getText(element), this.boldStyler);
            } else if (element instanceof JobTaskGroup && ((JobTaskGroup)element).getJob() == null) {
                styled.append(IntegrateTaskLabelProvider.this.viewerLabelProvider.getText(element), this.boldStyler);
            } else {
                styled.append(super.getStyledText(element));
            }
            if (element instanceof ITaskGroup) {
                this.addCount(styled, (ITaskGroup)element);
            }
            return styled;
        }

        protected void addQualifier(IP4Changelist list, StyledString styled) {
            String client;
            if (list instanceof IP4SubmittedChangelist && (client = list.getClientName()) != null && IIntegrateTaskContainer.Mode.USER == IntegrateTaskLabelProvider.this.container.getMode()) {
                styled.append(MessageFormat.format(Messages.IntegrateTaskLabelProvider_ChangelistClient, client), StyledString.QUALIFIER_STYLER);
                return;
            }
            super.addQualifier(list, styled);
        }

        public void dispose() {
            super.dispose();
            IntegrateTaskLabelProvider.this.bold.dispose();
        }
    };
    private ILabelDecorator decorator = new ChangelistDecorator(true){

        public String decorateText(String text, Object element) {
            if (element instanceof JobTaskGroup) {
                StringBuilder decorated = new StringBuilder(text);
                IP4Job job = ((JobTaskGroup)element).getJob();
                if (job != null) {
                    decorated.append(" : ");
                    decorated.append(job.getShortDescription());
                }
                return decorated.toString();
            }
            return super.decorateText(text, element);
        }

        public String getName() {
            return IntegrateTaskLabelProvider.class.getSimpleName();
        }
    };

    public IntegrateTaskLabelProvider(IIntegrateTaskContainer container) {
        this.container = container;
        DecoratingStyledCellLabelProvider labelProvider = new DecoratingStyledCellLabelProvider(this.styleProvider, this.decorator, null);
        container.getViewer().setLabelProvider((IBaseLabelProvider)labelProvider);
        Control control = container.getViewer().getControl();
        this.bold = P4UIUtils.generateBoldFont((Device)control.getDisplay(), (Font)control.getFont());
    }

    public ILabelProvider getLabelProvider() {
        return this.viewerLabelProvider;
    }
}

