/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.policies;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.mergequest.commands.MappingCreateCommand;
import com.perforce.team.ui.mergequest.commands.MappingReconnectCommand;
import com.perforce.team.ui.mergequest.figures.BranchFigure;
import com.perforce.team.ui.mergequest.figures.MappingConnectionAnchor;
import com.perforce.team.ui.mergequest.figures.theme.ThemeHelper;
import com.perforce.team.ui.mergequest.figures.theme.ThemeListenerAdapter;
import com.perforce.team.ui.mergequest.parts.BranchEditPart;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;

public class BranchConnectPolicy
extends GraphicalNodeEditPolicy {
    private ThemeHelper themeHelper = new ThemeHelper();
    private Color defaultLineColor;

    public BranchConnectPolicy() {
        this.themeHelper.setForegroundKey("com.perforce.team.ui.mergequest.foreground.mapping.disabled");
        this.themeHelper.setListener(new ThemeListenerAdapter(){

            @Override
            public void setForegroundColor(Color color) {
                BranchConnectPolicy.this.defaultLineColor = color;
            }
        });
    }

    public void deactivate() {
        this.themeHelper.deactivate();
        super.deactivate();
    }

    public void activate() {
        this.themeHelper.activate();
        super.activate();
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Branch target = (Branch)this.getHost().getModel();
        MappingCreateCommand command = (MappingCreateCommand)request.getStartCommand();
        command.setTarget(target);
        MappingConnectionAnchor anchor = (MappingConnectionAnchor)((BranchEditPart)this.getHost()).getTargetConnectionAnchor((Request)request);
        command.setTargetTerminal(anchor.getIndex());
        return command;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        MappingCreateCommand command = null;
        Branch source = (Branch)this.getHost().getModel();
        if (source != null) {
            Object type;
            IP4Connection connection = null;
            IBranchGraph graph = source.getGraph();
            if (graph != null && (connection = graph.getConnection()) != null && (type = request.getNewObjectType()) != null) {
                command = new MappingCreateCommand(graph, type);
                command.setSource(source);
                request.setStartCommand((Command)command);
            }
            MappingConnectionAnchor anchor = (MappingConnectionAnchor)((BranchEditPart)this.getHost()).getTargetConnectionAnchor((Request)request);
            command.setSourceTerminal(anchor.getIndex());
        }
        return command;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Mapping mapping = (Mapping)request.getConnectionEditPart().getModel();
        Branch newSource = (Branch)this.getHost().getModel();
        if (newSource.equals((Object)mapping.getTarget())) {
            return null;
        }
        MappingConnectionAnchor anchor = (MappingConnectionAnchor)((BranchEditPart)this.getHost()).getSourceConnectionAnchor((Request)request);
        MappingReconnectCommand command = new MappingReconnectCommand(mapping);
        command.setNewTerminal(anchor.getIndex());
        command.setNewSource(newSource);
        return command;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Mapping mapping = (Mapping)request.getConnectionEditPart().getModel();
        Branch newTarget = (Branch)this.getHost().getModel();
        if (newTarget.equals((Object)mapping.getSource())) {
            return null;
        }
        MappingConnectionAnchor anchor = (MappingConnectionAnchor)((BranchEditPart)this.getHost()).getTargetConnectionAnchor((Request)request);
        MappingReconnectCommand command = new MappingReconnectCommand(mapping);
        command.setNewTarget(newTarget);
        command.setNewTerminal(anchor.getIndex());
        return command;
    }

    protected IFigure getRequestFigure(Request request, boolean source) {
        IFigure figure = null;
        if (request instanceof CreateConnectionRequest) {
            EditPart part = null;
            part = source ? ((CreateConnectionRequest)request).getSourceEditPart() : ((CreateConnectionRequest)request).getTargetEditPart();
            if (part instanceof GraphicalEditPart) {
                figure = ((GraphicalEditPart)part).getFigure();
            }
        }
        return figure;
    }

    protected void showAnchors(IFigure figure, boolean show) {
        if (figure instanceof BranchFigure) {
            ((BranchFigure)figure).showAnchors(show);
        }
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        this.showAnchors(this.getRequestFigure(request, true), false);
    }

    public void eraseTargetFeedback(Request request) {
        super.eraseTargetFeedback(request);
        this.showAnchors(this.getRequestFigure(request, false), false);
    }

    public void showSourceFeedback(Request request) {
        super.showSourceFeedback(request);
        this.showAnchors(this.getRequestFigure(request, true), true);
    }

    public void showTargetFeedback(Request request) {
        super.showTargetFeedback(request);
        this.showAnchors(this.getRequestFigure(request, false), true);
    }

    protected Connection createDummyConnection(Request req) {
        PolylineConnection connection = new PolylineConnection();
        connection.setLineWidth(2);
        connection.setForegroundColor(this.defaultLineColor);
        return connection;
    }

    private IFigure getFigure(EditPart part) {
        return part instanceof GraphicalEditPart ? ((GraphicalEditPart)part).getFigure() : null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        ConnectionAnchor anchor = super.getTargetConnectionAnchor(request);
        if (anchor != null && anchor.getOwner().equals(this.getFigure(request.getSourceEditPart()))) {
            anchor = null;
        }
        return anchor;
    }
}

